// <auto-generated>

using Microsoft.EntityFrameworkCore;
using Microsoft.EntityFrameworkCore.ChangeTracking;
using Microsoft.EntityFrameworkCore.Design;
using Microsoft.EntityFrameworkCore.Infrastructure;
using Microsoft.EntityFrameworkCore.Metadata;
using Microsoft.EntityFrameworkCore.Metadata.Builders;
using Microsoft.EntityFrameworkCore.Query;
using Microsoft.EntityFrameworkCore.Query.Internal;
using Microsoft.EntityFrameworkCore.Storage;
using Npgsql;
using NpgsqlTypes;
using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.ComponentModel;
using System.Data;
using System.Data.SqlTypes;
using System.Linq;
using System.Linq.Expressions;
using System.Reflection;
using System.Threading;
using System.Threading.Tasks;

namespace Efrpg.PostgreSQL
{
    #region Database context interface

    public interface IMyDbContext : IDisposable
    {
        DbSet<dbo_TestPostGisTbl> dbo_TestPostGisTbls { get; set; } // TestPostGisTbl
        DbSet<GeographyColumn> GeographyColumns { get; set; } // geography_columns
        DbSet<GeometryColumn> GeometryColumns { get; set; } // geometry_columns
        DbSet<SpatialRefSy> SpatialRefSies { get; set; } // spatial_ref_sys

        int SaveChanges();
        int SaveChanges(bool acceptAllChangesOnSuccess);
        Task<int> SaveChangesAsync(CancellationToken cancellationToken = default(CancellationToken));
        Task<int> SaveChangesAsync(bool acceptAllChangesOnSuccess, CancellationToken cancellationToken = default(CancellationToken));
        DatabaseFacade Database { get; }
        DbSet<TEntity> Set<TEntity>() where TEntity : class;
        string ToString();

        EntityEntry Add(object entity);
        EntityEntry<TEntity> Add<TEntity>(TEntity entity) where TEntity : class;
        Task AddRangeAsync(params object[] entities);
        Task AddRangeAsync(IEnumerable<object> entities, CancellationToken cancellationToken = default);
        ValueTask<EntityEntry<TEntity>> AddAsync<TEntity>(TEntity entity, CancellationToken cancellationToken = default) where TEntity : class;
        ValueTask<EntityEntry> AddAsync(object entity, CancellationToken cancellationToken = default);
        void AddRange(IEnumerable<object> entities);
        void AddRange(params object[] entities);

        EntityEntry Attach(object entity);
        EntityEntry<TEntity> Attach<TEntity>(TEntity entity) where TEntity : class;
        void AttachRange(IEnumerable<object> entities);
        void AttachRange(params object[] entities);

        EntityEntry Entry(object entity);
        EntityEntry<TEntity> Entry<TEntity>(TEntity entity) where TEntity : class;

        TEntity Find<TEntity>(params object[] keyValues) where TEntity : class;
        ValueTask<TEntity> FindAsync<TEntity>(object[] keyValues, CancellationToken cancellationToken) where TEntity : class;
        ValueTask<TEntity> FindAsync<TEntity>(params object[] keyValues) where TEntity : class;
        ValueTask<object> FindAsync(Type entityType, object[] keyValues, CancellationToken cancellationToken);
        ValueTask<object> FindAsync(Type entityType, params object[] keyValues);
        object Find(Type entityType, params object[] keyValues);

        EntityEntry Remove(object entity);
        EntityEntry<TEntity> Remove<TEntity>(TEntity entity) where TEntity : class;
        void RemoveRange(IEnumerable<object> entities);
        void RemoveRange(params object[] entities);

        EntityEntry Update(object entity);
        EntityEntry<TEntity> Update<TEntity>(TEntity entity) where TEntity : class;
        void UpdateRange(IEnumerable<object> entities);
        void UpdateRange(params object[] entities);

        IQueryable<TResult> FromExpression<TResult> (Expression<Func<IQueryable<TResult>>> expression);

        // Scalar Valued Functions
        string PostgisSrs(string authName, string authSrid); // public.postgis_srs
        string PostgisSrsAll(); // public.postgis_srs_all
        string PostgisSrsSearch(string bounds, string authname); // public.postgis_srs_search
        string StHexagongrid(double? size, string bounds); // public.st_hexagongrid
        string StLargestemptycircle(string geom, double? tolerance, string boundary); // public.st_largestemptycircle
        string StMaximuminscribedcircle(string p1); // public.st_maximuminscribedcircle
        string StMinimumboundingradius(string p1); // public.st_minimumboundingradius
        string StSquaregrid(double? size, string bounds); // public.st_squaregrid
    }

    #endregion

    #region Database context

    public class MyDbContext : DbContext, IMyDbContext
    {
        public MyDbContext()
        {
        }

        public MyDbContext(DbContextOptions<MyDbContext> options)
            : base(options)
        {
        }

        public DbSet<dbo_TestPostGisTbl> dbo_TestPostGisTbls { get; set; } // TestPostGisTbl
        public DbSet<GeographyColumn> GeographyColumns { get; set; } // geography_columns
        public DbSet<GeometryColumn> GeometryColumns { get; set; } // geometry_columns
        public DbSet<SpatialRefSy> SpatialRefSies { get; set; } // spatial_ref_sys

        protected override void OnConfiguring(DbContextOptionsBuilder optionsBuilder)
        {
            if (!optionsBuilder.IsConfigured)
            {
                optionsBuilder.UseNpgsql(@"Server=127.0.0.1;Port=5433;Database=postgis_test;User Id=testuser;Password=testtesttest;");
                optionsBuilder.UseLazyLoadingProxies();
            }
        }

        public bool IsSqlParameterNull(NpgsqlParameter param)
        {
            var sqlValue = param.NpgsqlValue;
            var nullableValue = sqlValue as INullable;
            if (nullableValue != null)
                return nullableValue.IsNull;
            return (sqlValue == null || sqlValue == DBNull.Value);
        }

        protected override void OnModelCreating(ModelBuilder modelBuilder)
        {
            base.OnModelCreating(modelBuilder);

            modelBuilder.ApplyConfiguration(new dbo_TestPostGisTblConfiguration());
            modelBuilder.ApplyConfiguration(new GeographyColumnConfiguration());
            modelBuilder.ApplyConfiguration(new GeometryColumnConfiguration());
            modelBuilder.ApplyConfiguration(new SpatialRefSyConfiguration());
        }


        // Scalar Valued Functions

        [DbFunction("postgis_srs", "public")]
        public string PostgisSrs(string authName, string authSrid)
        {
            throw new Exception("Don't call this directly. Use LINQ to call the scalar valued function as part of your query");
        }

        [DbFunction("postgis_srs_all", "public")]
        public string PostgisSrsAll()
        {
            throw new Exception("Don't call this directly. Use LINQ to call the scalar valued function as part of your query");
        }

        [DbFunction("postgis_srs_search", "public")]
        public string PostgisSrsSearch(string bounds, string authname)
        {
            throw new Exception("Don't call this directly. Use LINQ to call the scalar valued function as part of your query");
        }

        [DbFunction("st_hexagongrid", "public")]
        public string StHexagongrid(double? size, string bounds)
        {
            throw new Exception("Don't call this directly. Use LINQ to call the scalar valued function as part of your query");
        }

        [DbFunction("st_largestemptycircle", "public")]
        public string StLargestemptycircle(string geom, double? tolerance, string boundary)
        {
            throw new Exception("Don't call this directly. Use LINQ to call the scalar valued function as part of your query");
        }

        [DbFunction("st_maximuminscribedcircle", "public")]
        public string StMaximuminscribedcircle(string p1)
        {
            throw new Exception("Don't call this directly. Use LINQ to call the scalar valued function as part of your query");
        }

        [DbFunction("st_minimumboundingradius", "public")]
        public string StMinimumboundingradius(string p1)
        {
            throw new Exception("Don't call this directly. Use LINQ to call the scalar valued function as part of your query");
        }

        [DbFunction("st_squaregrid", "public")]
        public string StSquaregrid(double? size, string bounds)
        {
            throw new Exception("Don't call this directly. Use LINQ to call the scalar valued function as part of your query");
        }
    }

    #endregion

    #region Database context factory

    public class MyDbContextFactory : IDesignTimeDbContextFactory<MyDbContext>
    {
        public MyDbContext CreateDbContext(string[] args)
        {
            return new MyDbContext();
        }
    }

    #endregion

    #region Fake Database context

    public class FakeMyDbContext : IMyDbContext
    {
        public DbSet<dbo_TestPostGisTbl> dbo_TestPostGisTbls { get; set; } // TestPostGisTbl
        public DbSet<GeographyColumn> GeographyColumns { get; set; } // geography_columns
        public DbSet<GeometryColumn> GeometryColumns { get; set; } // geometry_columns
        public DbSet<SpatialRefSy> SpatialRefSies { get; set; } // spatial_ref_sys

        public FakeMyDbContext()
        {
            _database = new FakeDatabaseFacade(new MyDbContext());

            dbo_TestPostGisTbls = new FakeDbSet<dbo_TestPostGisTbl>("Id");
            GeographyColumns = new FakeDbSet<GeographyColumn>();
            GeometryColumns = new FakeDbSet<GeometryColumn>();
            SpatialRefSies = new FakeDbSet<SpatialRefSy>("Srid");

        }

        public int SaveChangesCount { get; private set; }
        public virtual int SaveChanges()
        {
            ++SaveChangesCount;
            return 1;
        }

        public virtual int SaveChanges(bool acceptAllChangesOnSuccess)
        {
            return SaveChanges();
        }

        public virtual Task<int> SaveChangesAsync(CancellationToken cancellationToken)
        {
            ++SaveChangesCount;
            return Task<int>.Factory.StartNew(() => 1, cancellationToken);
        }
        public virtual Task<int> SaveChangesAsync(bool acceptAllChangesOnSuccess, CancellationToken cancellationToken)
        {
            ++SaveChangesCount;
            return Task<int>.Factory.StartNew(x => 1, acceptAllChangesOnSuccess, cancellationToken);
        }

        protected virtual void Dispose(bool disposing)
        {
        }

        public void Dispose()
        {
            Dispose(true);
        }

        private DatabaseFacade _database;
        public DatabaseFacade Database { get { return _database; } }

        public DbSet<TEntity> Set<TEntity>() where TEntity : class
        {
            throw new NotImplementedException();
        }

        public override string ToString()
        {
            throw new NotImplementedException();
        }

        public virtual EntityEntry Add(object entity)
        {
            throw new NotImplementedException();
        }

        public virtual EntityEntry<TEntity> Add<TEntity>(TEntity entity) where TEntity : class
        {
            throw new NotImplementedException();
        }

        public virtual Task AddRangeAsync(params object[] entities)
        {
            throw new NotImplementedException();
        }

        public virtual async Task AddRangeAsync(IEnumerable<object> entities, CancellationToken cancellationToken = default)
        {
            await Task.CompletedTask;
            throw new NotImplementedException();
        }

        public virtual async ValueTask<EntityEntry<TEntity>> AddAsync<TEntity>(TEntity entity, CancellationToken cancellationToken = default) where TEntity : class
        {
            await Task.CompletedTask;
            throw new NotImplementedException();
        }

        public virtual async ValueTask<EntityEntry> AddAsync(object entity, CancellationToken cancellationToken = default)
        {
            await Task.CompletedTask;
            throw new NotImplementedException();
        }

        public virtual void AddRange(IEnumerable<object> entities)
        {
            throw new NotImplementedException();
        }

        public virtual void AddRange(params object[] entities)
        {
            throw new NotImplementedException();
        }

        public virtual EntityEntry Attach(object entity)
        {
            throw new NotImplementedException();
        }

        public virtual EntityEntry<TEntity> Attach<TEntity>(TEntity entity) where TEntity : class
        {
            throw new NotImplementedException();
        }

        public virtual void AttachRange(IEnumerable<object> entities)
        {
            throw new NotImplementedException();
        }

        public virtual void AttachRange(params object[] entities)
        {
            throw new NotImplementedException();
        }

        public virtual EntityEntry Entry(object entity)
        {
            throw new NotImplementedException();
        }

        public virtual EntityEntry<TEntity> Entry<TEntity>(TEntity entity) where TEntity : class
        {
            throw new NotImplementedException();
        }

        public virtual TEntity Find<TEntity>(params object[] keyValues) where TEntity : class
        {
            throw new NotImplementedException();
        }

        public virtual ValueTask<TEntity> FindAsync<TEntity>(object[] keyValues, CancellationToken cancellationToken) where TEntity : class
        {
            throw new NotImplementedException();
        }

        public virtual ValueTask<TEntity> FindAsync<TEntity>(params object[] keyValues) where TEntity : class
        {
            throw new NotImplementedException();
        }

        public virtual ValueTask<object> FindAsync(Type entityType, object[] keyValues, CancellationToken cancellationToken)
        {
            throw new NotImplementedException();
        }

        public virtual ValueTask<object> FindAsync(Type entityType, params object[] keyValues)
        {
            throw new NotImplementedException();
        }

        public virtual object Find(Type entityType, params object[] keyValues)
        {
            throw new NotImplementedException();
        }

        public virtual EntityEntry Remove(object entity)
        {
            throw new NotImplementedException();
        }

        public virtual EntityEntry<TEntity> Remove<TEntity>(TEntity entity) where TEntity : class
        {
            throw new NotImplementedException();
        }

        public virtual void RemoveRange(IEnumerable<object> entities)
        {
            throw new NotImplementedException();
        }

        public virtual void RemoveRange(params object[] entities)
        {
            throw new NotImplementedException();
        }

        public virtual EntityEntry Update(object entity)
        {
            throw new NotImplementedException();
        }

        public virtual EntityEntry<TEntity> Update<TEntity>(TEntity entity) where TEntity : class
        {
            throw new NotImplementedException();
        }

        public virtual void UpdateRange(IEnumerable<object> entities)
        {
            throw new NotImplementedException();
        }

        public virtual void UpdateRange(params object[] entities)
        {
            throw new NotImplementedException();
        }

        public virtual IQueryable<TResult> FromExpression<TResult> (Expression<Func<IQueryable<TResult>>> expression)
        {
            throw new NotImplementedException();
        }


        // Scalar Valued Functions

        // public.postgis_srs
        public string PostgisSrs(string authName, string authSrid)
        {
            return default(string);
        }

        // public.postgis_srs_all
        public string PostgisSrsAll()
        {
            return default(string);
        }

        // public.postgis_srs_search
        public string PostgisSrsSearch(string bounds, string authname)
        {
            return default(string);
        }

        // public.st_hexagongrid
        public string StHexagongrid(double? size, string bounds)
        {
            return default(string);
        }

        // public.st_largestemptycircle
        public string StLargestemptycircle(string geom, double? tolerance, string boundary)
        {
            return default(string);
        }

        // public.st_maximuminscribedcircle
        public string StMaximuminscribedcircle(string p1)
        {
            return default(string);
        }

        // public.st_minimumboundingradius
        public string StMinimumboundingradius(string p1)
        {
            return default(string);
        }

        // public.st_squaregrid
        public string StSquaregrid(double? size, string bounds)
        {
            return default(string);
        }
    }

    #endregion

    #region Fake DbSet

    // ************************************************************************
    // Fake DbSet
    // Implementing Find:
    //      The Find method is difficult to implement in a generic fashion. If
    //      you need to test code that makes use of the Find method it is
    //      easiest to create a test DbSet for each of the entity types that
    //      need to support find. You can then write logic to find that
    //      particular type of entity, as shown below:
    //      public class FakeBlogDbSet : FakeDbSet<Blog>
    //      {
    //          public override Blog Find(params object[] keyValues)
    //          {
    //              var id = (int) keyValues.Single();
    //              return this.SingleOrDefault(b => b.BlogId == id);
    //          }
    //      }
    //      Read more about it here: https://msdn.microsoft.com/en-us/data/dn314431.aspx
    public class FakeDbSet<TEntity> :
        DbSet<TEntity>,
        IQueryable<TEntity>,
        IAsyncEnumerable<TEntity>,
        IListSource,
        IResettableService
        where TEntity : class
    {
        private readonly PropertyInfo[] _primaryKeys;
        private ObservableCollection<TEntity> _data;
        private IQueryable _query;
        public override IEntityType EntityType { get; }

        public FakeDbSet()
        {
            _primaryKeys = null;
            _data        = new ObservableCollection<TEntity>();
            _query       = _data.AsQueryable();
        }

        public FakeDbSet(params string[] primaryKeys)
        {
            _primaryKeys = typeof(TEntity).GetProperties().Where(x => primaryKeys.Contains(x.Name)).ToArray();
            _data        = new ObservableCollection<TEntity>();
            _query       = _data.AsQueryable();
        }

        public override TEntity Find(params object[] keyValues)
        {
            if (_primaryKeys == null)
                throw new ArgumentException("No primary keys defined");
            if (keyValues.Length != _primaryKeys.Length)
                throw new ArgumentException("Incorrect number of keys passed to Find method");

            var keyQuery = this.AsQueryable();
            keyQuery = keyValues
                .Select((t, i) => i)
                .Aggregate(keyQuery,
                    (current, x) =>
                        current.Where(entity => _primaryKeys[x].GetValue(entity, null).Equals(keyValues[x])));

            return keyQuery.SingleOrDefault();
        }

        public override ValueTask<TEntity> FindAsync(object[] keyValues, CancellationToken cancellationToken)
        {
            return new ValueTask<TEntity>(Task<TEntity>.Factory.StartNew(() => Find(keyValues), cancellationToken));
        }

        public override ValueTask<TEntity> FindAsync(params object[] keyValues)
        {
            return new ValueTask<TEntity>(Task<TEntity>.Factory.StartNew(() => Find(keyValues)));
        }

        public override EntityEntry<TEntity> Add(TEntity entity)
        {
            _data.Add(entity);
            return null;
        }

        public override ValueTask<EntityEntry<TEntity>> AddAsync(TEntity entity, CancellationToken cancellationToken = default)
        {
            return new ValueTask<EntityEntry<TEntity>>(Task<EntityEntry<TEntity>>.Factory.StartNew(() => Add(entity), cancellationToken));
        }

        public override void AddRange(params TEntity[] entities)
        {
            if (entities == null) throw new ArgumentNullException("entities");
            foreach (var entity in entities)
                _data.Add(entity);
        }

        public override void AddRange(IEnumerable<TEntity> entities)
        {
            if (entities == null) throw new ArgumentNullException("entities");
            foreach (var entity in entities)
                _data.Add(entity);
        }

        public override Task AddRangeAsync(params TEntity[] entities)
        {
            if (entities == null) throw new ArgumentNullException("entities");
            return Task.Factory.StartNew(() => AddRange(entities));
        }

        public override Task AddRangeAsync(IEnumerable<TEntity> entities, CancellationToken cancellationToken = default)
        {
            if (entities == null) throw new ArgumentNullException("entities");
            return Task.Factory.StartNew(() => AddRange(entities), cancellationToken);
        }

        public override EntityEntry<TEntity> Attach(TEntity entity)
        {
            if (entity == null) throw new ArgumentNullException("entity");
            return Add(entity);
        }

        public override void AttachRange(params TEntity[] entities)
        {
            if (entities == null) throw new ArgumentNullException("entities");
            AddRange(entities);
        }

        public override void AttachRange(IEnumerable<TEntity> entities)
        {
            if (entities == null) throw new ArgumentNullException("entities");
            AddRange(entities);
        }

        public override EntityEntry<TEntity> Remove(TEntity entity)
        {
            _data.Remove(entity);
            return null;
        }

        public override void RemoveRange(params TEntity[] entities)
        {
            if (entities == null) throw new ArgumentNullException("entities");
            foreach (var entity in entities.ToList())
                _data.Remove(entity);
        }

        public override void RemoveRange(IEnumerable<TEntity> entities)
        {
            RemoveRange(entities.ToArray());
        }

        public override EntityEntry<TEntity> Update(TEntity entity)
        {
            _data.Remove(entity);
            _data.Add(entity);
            return null;
        }

        public override void UpdateRange(params TEntity[] entities)
        {
            if (entities == null) throw new ArgumentNullException("entities");
            RemoveRange(entities);
            AddRange(entities);
        }

        public override void UpdateRange(IEnumerable<TEntity> entities)
        {
            if (entities == null) throw new ArgumentNullException("entities");
            var array = entities.ToArray();        RemoveRange(array);
            AddRange(array);
        }

        bool IListSource.ContainsListCollection => true;

        public IList GetList()
        {
            return _data;
        }

        IList IListSource.GetList()
        {
            return _data;
        }

        Type IQueryable.ElementType
        {
            get { return _query.ElementType; }
        }

        Expression IQueryable.Expression
        {
            get { return _query.Expression; }
        }

        IQueryProvider IQueryable.Provider
        {
            get { return new FakeDbAsyncQueryProvider<TEntity>(_data); }
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return _data.GetEnumerator();
        }

        IEnumerator<TEntity> IEnumerable<TEntity>.GetEnumerator()
        {
            return _data.GetEnumerator();
        }

        public override IAsyncEnumerator<TEntity> GetAsyncEnumerator(CancellationToken cancellationToken = default)
        {
            return new FakeDbAsyncEnumerator<TEntity>(this.AsEnumerable().GetEnumerator());
        }

        public void ResetState()
        {
            _data  = new ObservableCollection<TEntity>();
            _query = _data.AsQueryable();
        }

        public Task ResetStateAsync(CancellationToken cancellationToken = new CancellationToken())
        {
            return Task.Factory.StartNew(() => ResetState());
        }
    }

    public class FakeDbAsyncQueryProvider<TEntity> : FakeQueryProvider<TEntity>, IAsyncEnumerable<TEntity>, IAsyncQueryProvider
    {
        public FakeDbAsyncQueryProvider(Expression expression) : base(expression)
        {
        }

        public FakeDbAsyncQueryProvider(IEnumerable<TEntity> enumerable) : base(enumerable)
        {
        }

        public TResult ExecuteAsync<TResult>(Expression expression, CancellationToken cancellationToken)
        {
            var expectedResultType = typeof(TResult).GetGenericArguments()[0];
            var executionResult = typeof(IQueryProvider)
                .GetMethods()
                .First(method => method.Name == nameof(IQueryProvider.Execute) && method.IsGenericMethod)
                .MakeGenericMethod(expectedResultType)
                .Invoke(this, new object[] { expression });

            return (TResult) typeof(Task).GetMethod(nameof(Task.FromResult))
                ?.MakeGenericMethod(expectedResultType)
                .Invoke(null, new[] { executionResult });
        }

        public IAsyncEnumerator<TEntity> GetAsyncEnumerator(CancellationToken cancellationToken = default)
        {
            return new FakeDbAsyncEnumerator<TEntity>(this.AsEnumerable().GetEnumerator());
        }
    }

    public class FakeDbAsyncEnumerable<T> : EnumerableQuery<T>, IAsyncEnumerable<T>, IQueryable<T>
    {
        public FakeDbAsyncEnumerable(IEnumerable<T> enumerable)
            : base(enumerable)
        {
        }

        public FakeDbAsyncEnumerable(Expression expression)
            : base(expression)
        {
        }

        public IAsyncEnumerator<T> GetAsyncEnumerator(CancellationToken cancellationToken = new CancellationToken())
        {
            return new FakeDbAsyncEnumerator<T>(this.AsEnumerable().GetEnumerator());
        }

        IAsyncEnumerator<T> IAsyncEnumerable<T>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAsyncEnumerator(cancellationToken);
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return this.AsEnumerable().GetEnumerator();
        }
    }

    public class FakeDbAsyncEnumerator<T> : IAsyncEnumerator<T>
    {
        private readonly IEnumerator<T> _inner;

        public FakeDbAsyncEnumerator(IEnumerator<T> inner)
        {
            _inner = inner;
        }

        public T Current
        {
            get { return _inner.Current; }
        }

        public ValueTask<bool> MoveNextAsync()
        {
            return new ValueTask<bool>(_inner.MoveNext());
        }

        public ValueTask DisposeAsync()
        {
            _inner.Dispose();
            return new ValueTask(Task.CompletedTask);
        }
    }

    public abstract class FakeQueryProvider<T> : IOrderedQueryable<T>, IQueryProvider
    {
        private IEnumerable<T> _enumerable;

        protected FakeQueryProvider(Expression expression)
        {
            Expression = expression;
        }

        protected FakeQueryProvider(IEnumerable<T> enumerable)
        {
            _enumerable = enumerable;
            Expression = enumerable.AsQueryable().Expression;
        }

        public IQueryable CreateQuery(Expression expression)
        {
            if (expression is MethodCallExpression m)
            {
                var resultType = m.Method.ReturnType; // it should be IQueryable<T>
                var tElement = resultType.GetGenericArguments().First();
                return (IQueryable) CreateInstance(tElement, expression);
            }

            return CreateQuery<T>(expression);
        }

        public IQueryable<TEntity> CreateQuery<TEntity>(Expression expression)
        {
            return (IQueryable<TEntity>) CreateInstance(typeof(TEntity), expression);
        }

        private object CreateInstance(Type tElement, Expression expression)
        {
            var queryType = GetType().GetGenericTypeDefinition().MakeGenericType(tElement);
            return Activator.CreateInstance(queryType, expression);
        }

        public object Execute(Expression expression)
        {
            return CompileExpressionItem<object>(expression);
        }

        public TResult Execute<TResult>(Expression expression)
        {
            return CompileExpressionItem<TResult>(expression);
        }

        IEnumerator<T> IEnumerable<T>.GetEnumerator()
        {
            if (_enumerable == null) _enumerable = CompileExpressionItem<IEnumerable<T>>(Expression);
            return _enumerable.GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            if (_enumerable == null) _enumerable = CompileExpressionItem<IEnumerable<T>>(Expression);
            return _enumerable.GetEnumerator();
        }

        public Type ElementType => typeof(T);

        public Expression Expression { get; }

        public IQueryProvider Provider => this;

        private static TResult CompileExpressionItem<TResult>(Expression expression)
        {
            var visitor = new FakeExpressionVisitor();
            var body = visitor.Visit(expression);
            var f = Expression.Lambda<Func<TResult>>(body ?? throw new InvalidOperationException(string.Format("{0} is null", nameof(body))), (IEnumerable<ParameterExpression>) null);
            return f.Compile()();
        }
    }

    public class FakeExpressionVisitor : ExpressionVisitor
    {
    }

    public class FakeDatabaseFacade : DatabaseFacade
    {
        public FakeDatabaseFacade(DbContext context) : base(context)
        {
        }

        public override bool EnsureCreated()
        {
            return true;
        }

        public override Task<bool> EnsureCreatedAsync(CancellationToken cancellationToken = new CancellationToken())
        {
            return Task.FromResult(EnsureCreated());
        }

        public override bool EnsureDeleted()
        {
            return true;
        }

        public override Task<bool> EnsureDeletedAsync(CancellationToken cancellationToken = new CancellationToken())
        {
            return Task.FromResult(EnsureDeleted());
        }

        public override bool CanConnect()
        {
            return true;
        }

        public override Task<bool> CanConnectAsync(CancellationToken cancellationToken = new CancellationToken())
        {
            return Task.FromResult(CanConnect());
        }

        public override IDbContextTransaction BeginTransaction()
        {
            return new FakeDbContextTransaction();
        }

        public override Task<IDbContextTransaction> BeginTransactionAsync(CancellationToken cancellationToken = new CancellationToken())
        {
            return Task.FromResult(BeginTransaction());
        }

        public override void CommitTransaction()
        {
        }

        public override Task CommitTransactionAsync(CancellationToken cancellationToken = new CancellationToken())
        {
            return Task.CompletedTask;
        }

        public override void RollbackTransaction()
        {
        }

        public override Task RollbackTransactionAsync(CancellationToken cancellationToken = new CancellationToken())
        {
            return Task.CompletedTask;
        }

        public override IExecutionStrategy CreateExecutionStrategy()
        {
            return null;
        }

        public override string ToString()
        {
            return string.Empty;
        }
    }

    public class FakeDbContextTransaction : IDbContextTransaction
    {
        public Guid TransactionId => Guid.NewGuid();
        public void Commit() { }
        public void Rollback() { }
        public Task CommitAsync(CancellationToken cancellationToken = new CancellationToken()) => Task.CompletedTask;
        public Task RollbackAsync(CancellationToken cancellationToken = new CancellationToken()) => Task.CompletedTask;
        public void Dispose() { }
        public ValueTask DisposeAsync() => default;
    }

    #endregion

    #region POCO classes

    // TestPostGisTbl
    public class dbo_TestPostGisTbl
    {
        public int Id { get; set; } // Id (Primary key)
        public decimal TblMinValue { get; set; } // TblMinValue
        public decimal TblMaxValue { get; set; } // TblMaxValue
        public string AtdLocation { get; set; } // ATDLocation
    }

    // geography_columns
    public class GeographyColumn
    {
        public string FTableCatalog { get; set; } // f_table_catalog
        public string FTableSchema { get; set; } // f_table_schema
        public string FTableName { get; set; } // f_table_name
        public string FGeographyColumn { get; set; } // f_geography_column
        public int? CoordDimension { get; set; } // coord_dimension
        public int? Srid { get; set; } // srid
        public string Type { get; set; } // type
    }

    // geometry_columns
    public class GeometryColumn
    {
        public string FTableCatalog { get; set; } // f_table_catalog (length: 256)
        public string FTableSchema { get; set; } // f_table_schema
        public string FTableName { get; set; } // f_table_name
        public string FGeometryColumn { get; set; } // f_geometry_column
        public int? CoordDimension { get; set; } // coord_dimension
        public int? Srid { get; set; } // srid
        public string Type { get; set; } // type (length: 30)
    }

    // spatial_ref_sys
    public class SpatialRefSy
    {
        public int Srid { get; set; } // srid (Primary key)
        public string AuthName { get; set; } // auth_name (length: 256)
        public int? AuthSrid { get; set; } // auth_srid
        public string Srtext { get; set; } // srtext (length: 2048)
        public string Proj4Text { get; set; } // proj4text (length: 2048)
    }


    #endregion

    #region POCO Configuration

    // TestPostGisTbl
    public class dbo_TestPostGisTblConfiguration : IEntityTypeConfiguration<dbo_TestPostGisTbl>
    {
        public void Configure(EntityTypeBuilder<dbo_TestPostGisTbl> builder)
        {
            builder.ToTable("TestPostGisTbl", "dbo");
            builder.HasKey(x => x.Id).HasName("TestPostGisTbl_pk");

            builder.Property(x => x.Id).HasColumnName(@"Id").HasColumnType("integer").IsRequired().ValueGeneratedOnAdd().UseIdentityColumn();
            builder.Property(x => x.TblMinValue).HasColumnName(@"TblMinValue").HasColumnType("numeric(22,0)").HasPrecision(22,0).IsRequired();
            builder.Property(x => x.TblMaxValue).HasColumnName(@"TblMaxValue").HasColumnType("numeric(22,0)").HasPrecision(22,0).IsRequired();
            builder.Property(x => x.AtdLocation).HasColumnName(@"ATDLocation").IsRequired(); // .HasColumnType("user-defined") was excluded
        }
    }

    // geography_columns
    public class GeographyColumnConfiguration : IEntityTypeConfiguration<GeographyColumn>
    {
        public void Configure(EntityTypeBuilder<GeographyColumn> builder)
        {
            builder.ToView("geography_columns", "public");
            builder.HasNoKey();

            builder.Property(x => x.FTableCatalog).HasColumnName(@"f_table_catalog").HasColumnType("name").IsRequired(false);
            builder.Property(x => x.FTableSchema).HasColumnName(@"f_table_schema").HasColumnType("name").IsRequired(false);
            builder.Property(x => x.FTableName).HasColumnName(@"f_table_name").HasColumnType("name").IsRequired(false);
            builder.Property(x => x.FGeographyColumn).HasColumnName(@"f_geography_column").HasColumnType("name").IsRequired(false);
            builder.Property(x => x.CoordDimension).HasColumnName(@"coord_dimension").HasColumnType("integer").IsRequired(false);
            builder.Property(x => x.Srid).HasColumnName(@"srid").HasColumnType("integer").IsRequired(false);
            builder.Property(x => x.Type).HasColumnName(@"type").HasColumnType("text").IsRequired(false).IsUnicode(false);
        }
    }

    // geometry_columns
    public class GeometryColumnConfiguration : IEntityTypeConfiguration<GeometryColumn>
    {
        public void Configure(EntityTypeBuilder<GeometryColumn> builder)
        {
            builder.ToView("geometry_columns", "public");
            builder.HasNoKey();

            builder.Property(x => x.FTableCatalog).HasColumnName(@"f_table_catalog").HasColumnType("character varying(256)").IsRequired(false).HasMaxLength(256);
            builder.Property(x => x.FTableSchema).HasColumnName(@"f_table_schema").HasColumnType("name").IsRequired(false);
            builder.Property(x => x.FTableName).HasColumnName(@"f_table_name").HasColumnType("name").IsRequired(false);
            builder.Property(x => x.FGeometryColumn).HasColumnName(@"f_geometry_column").HasColumnType("name").IsRequired(false);
            builder.Property(x => x.CoordDimension).HasColumnName(@"coord_dimension").HasColumnType("integer").IsRequired(false);
            builder.Property(x => x.Srid).HasColumnName(@"srid").HasColumnType("integer").IsRequired(false);
            builder.Property(x => x.Type).HasColumnName(@"type").HasColumnType("character varying(30)").IsRequired(false).HasMaxLength(30);
        }
    }

    // spatial_ref_sys
    public class SpatialRefSyConfiguration : IEntityTypeConfiguration<SpatialRefSy>
    {
        public void Configure(EntityTypeBuilder<SpatialRefSy> builder)
        {
            builder.ToTable("spatial_ref_sys", "public");
            builder.HasKey(x => x.Srid).HasName("spatial_ref_sys_pkey");

            builder.Property(x => x.Srid).HasColumnName(@"srid").HasColumnType("integer").IsRequired().ValueGeneratedNever();
            builder.Property(x => x.AuthName).HasColumnName(@"auth_name").HasColumnType("character varying(256)").IsRequired(false).HasMaxLength(256);
            builder.Property(x => x.AuthSrid).HasColumnName(@"auth_srid").HasColumnType("integer").IsRequired(false);
            builder.Property(x => x.Srtext).HasColumnName(@"srtext").HasColumnType("character varying(2048)").IsRequired(false).HasMaxLength(2048);
            builder.Property(x => x.Proj4Text).HasColumnName(@"proj4text").HasColumnType("character varying(2048)").IsRequired(false).HasMaxLength(2048);
        }
    }


    #endregion

}
// </auto-generated>
