// <auto-generated>

using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.ComponentModel.DataAnnotations.Schema;
using System.Data;
using System.Data.Common;
using System.Data.Entity;
using System.Data.Entity.Core.Objects;
using System.Data.Entity.Infrastructure;
using System.Data.Entity.Infrastructure.Annotations;
using System.Data.Entity.Infrastructure.Interception;
using System.Data.Entity.ModelConfiguration;
using System.Data.Entity.Spatial;
using System.Data.Entity.Validation;
using System.Data.SqlClient;
using System.Data.SqlTypes;
using System.Linq;
using System.Linq.Expressions;
using System.Reflection;
using System.Threading;
using System.Threading.Tasks;

namespace Efrpg.SqlCE
{
    #region Database context interface

    public interface IMyDbContext : IDisposable
    {
        DbSet<Category> Categories { get; set; } // Categories
        DbSet<Customer> Customers { get; set; } // Customers
        DbSet<Employee> Employees { get; set; } // Employees
        DbSet<Order> Orders { get; set; } // Orders
        DbSet<OrderDetail> OrderDetails { get; set; } // Order Details
        DbSet<Product> Products { get; set; } // Products
        DbSet<Shipper> Shippers { get; set; } // Shippers
        DbSet<Supplier> Suppliers { get; set; } // Suppliers

        int SaveChanges();
        Task<int> SaveChangesAsync();
        Task<int> SaveChangesAsync(CancellationToken cancellationToken);
        DbChangeTracker ChangeTracker { get; }
        DbContextConfiguration Configuration { get; }
        Database Database { get; }
        DbEntityEntry<TEntity> Entry<TEntity>(TEntity entity) where TEntity : class;
        DbEntityEntry Entry(object entity);
        IEnumerable<DbEntityValidationResult> GetValidationErrors();
        DbSet Set(Type entityType);
        DbSet<TEntity> Set<TEntity>() where TEntity : class;
        string ToString();
    }

    #endregion

    #region Database context

    public class MyDbContext : DbContext, IMyDbContext
    {
        public DbSet<Category> Categories { get; set; } // Categories
        public DbSet<Customer> Customers { get; set; } // Customers
        public DbSet<Employee> Employees { get; set; } // Employees
        public DbSet<Order> Orders { get; set; } // Orders
        public DbSet<OrderDetail> OrderDetails { get; set; } // Order Details
        public DbSet<Product> Products { get; set; } // Products
        public DbSet<Shipper> Shippers { get; set; } // Shippers
        public DbSet<Supplier> Suppliers { get; set; } // Suppliers

        static MyDbContext()
        {
            System.Data.Entity.Database.SetInitializer<MyDbContext>(null);
        }

        /// <inheritdoc />
        public MyDbContext()
            : base("Name=MyDbContext")
        {
        }

        /// <inheritdoc />
        public MyDbContext(string connectionString)
            : base(connectionString)
        {
        }

        /// <inheritdoc />
        public MyDbContext(string connectionString, DbCompiledModel model)
            : base(connectionString, model)
        {
        }

        /// <inheritdoc />
        public MyDbContext(DbConnection existingConnection, bool contextOwnsConnection)
            : base(existingConnection, contextOwnsConnection)
        {
        }

        /// <inheritdoc />
        public MyDbContext(DbConnection existingConnection, DbCompiledModel model, bool contextOwnsConnection)
            : base(existingConnection, model, contextOwnsConnection)
        {
        }

        /// <inheritdoc />
        public MyDbContext(ObjectContext objectContext, bool dbContextOwnsObjectContext)
            : base(objectContext, dbContextOwnsObjectContext)
        {
        }

        protected override void Dispose(bool disposing)
        {
            base.Dispose(disposing);
        }

        public bool IsSqlParameterNull(SqlParameter param)
        {
            var sqlValue = param.SqlValue;
            var nullableValue = sqlValue as INullable;
            if (nullableValue != null)
                return nullableValue.IsNull;
            return (sqlValue == null || sqlValue == DBNull.Value);
        }

        protected override void OnModelCreating(DbModelBuilder modelBuilder)
        {
            base.OnModelCreating(modelBuilder);

            modelBuilder.Configurations.Add(new CategoryConfiguration());
            modelBuilder.Configurations.Add(new CustomerConfiguration());
            modelBuilder.Configurations.Add(new EmployeeConfiguration());
            modelBuilder.Configurations.Add(new OrderConfiguration());
            modelBuilder.Configurations.Add(new OrderDetailConfiguration());
            modelBuilder.Configurations.Add(new ProductConfiguration());
            modelBuilder.Configurations.Add(new ShipperConfiguration());
            modelBuilder.Configurations.Add(new SupplierConfiguration());
        }

        public static DbModelBuilder CreateModel(DbModelBuilder modelBuilder, string schema)
        {
            modelBuilder.Configurations.Add(new CategoryConfiguration(schema));
            modelBuilder.Configurations.Add(new CustomerConfiguration(schema));
            modelBuilder.Configurations.Add(new EmployeeConfiguration(schema));
            modelBuilder.Configurations.Add(new OrderConfiguration(schema));
            modelBuilder.Configurations.Add(new OrderDetailConfiguration(schema));
            modelBuilder.Configurations.Add(new ProductConfiguration(schema));
            modelBuilder.Configurations.Add(new ShipperConfiguration(schema));
            modelBuilder.Configurations.Add(new SupplierConfiguration(schema));

            return modelBuilder;
        }
    }

    #endregion

    #region Database context factory

    public class MyDbContextFactory : IDbContextFactory<MyDbContext>
    {
        public MyDbContext Create()
        {
            return new MyDbContext();
        }
    }

    #endregion

    #region Fake Database context

    public class FakeMyDbContext : IMyDbContext
    {
        public DbSet<Category> Categories { get; set; } // Categories
        public DbSet<Customer> Customers { get; set; } // Customers
        public DbSet<Employee> Employees { get; set; } // Employees
        public DbSet<Order> Orders { get; set; } // Orders
        public DbSet<OrderDetail> OrderDetails { get; set; } // Order Details
        public DbSet<Product> Products { get; set; } // Products
        public DbSet<Shipper> Shippers { get; set; } // Shippers
        public DbSet<Supplier> Suppliers { get; set; } // Suppliers

        public FakeMyDbContext()
        {
            _changeTracker = null;
            _configuration = null;
            _database = null;

            Categories = new FakeDbSet<Category>("CategoryId");
            Customers = new FakeDbSet<Customer>("CustomerId");
            Employees = new FakeDbSet<Employee>("EmployeeId");
            Orders = new FakeDbSet<Order>("OrderId");
            OrderDetails = new FakeDbSet<OrderDetail>("OrderId", "ProductId");
            Products = new FakeDbSet<Product>("ProductId");
            Shippers = new FakeDbSet<Shipper>("ShipperId");
            Suppliers = new FakeDbSet<Supplier>("SupplierId");

        }

        public int SaveChangesCount { get; private set; }
        public int SaveChanges()
        {
            ++SaveChangesCount;
            return 1;
        }

        public Task<int> SaveChangesAsync()
        {
            ++SaveChangesCount;
            return Task<int>.Factory.StartNew(() => 1);
        }

        public Task<int> SaveChangesAsync(CancellationToken cancellationToken)
        {
            ++SaveChangesCount;
            return Task<int>.Factory.StartNew(() => 1, cancellationToken);
        }

        protected virtual void Dispose(bool disposing)
        {
        }

        public void Dispose()
        {
            Dispose(true);
        }

        private DbChangeTracker _changeTracker;

        public DbChangeTracker ChangeTracker { get { return _changeTracker; } }

        private DbContextConfiguration _configuration;

        public DbContextConfiguration Configuration { get { return _configuration; } }

        private Database _database;

        public Database Database { get { return _database; } }

        public DbEntityEntry<TEntity> Entry<TEntity>(TEntity entity) where TEntity : class
        {
            throw new NotImplementedException();
        }

        public DbEntityEntry Entry(object entity)
        {
            throw new NotImplementedException();
        }

        public IEnumerable<DbEntityValidationResult> GetValidationErrors()
        {
            throw new NotImplementedException();
        }

        public DbSet Set(Type entityType)
        {
            throw new NotImplementedException();
        }

        public DbSet<TEntity> Set<TEntity>() where TEntity : class
        {
            throw new NotImplementedException();
        }

        public override string ToString()
        {
            throw new NotImplementedException();
        }
    }

    #endregion

    #region Fake DbSet

    // ************************************************************************
    // Fake DbSet
    // Implementing Find:
    //      The Find method is difficult to implement in a generic fashion. If
    //      you need to test code that makes use of the Find method it is
    //      easiest to create a test DbSet for each of the entity types that
    //      need to support find. You can then write logic to find that
    //      particular type of entity, as shown below:
    //      public class FakeBlogDbSet : FakeDbSet<Blog>
    //      {
    //          public override Blog Find(params object[] keyValues)
    //          {
    //              var id = (int) keyValues.Single();
    //              return this.SingleOrDefault(b => b.BlogId == id);
    //          }
    //      }
    //      Read more about it here: https://msdn.microsoft.com/en-us/data/dn314431.aspx
    public class FakeDbSet<TEntity> : DbSet<TEntity>, IQueryable, IEnumerable<TEntity>, IDbAsyncEnumerable<TEntity> where TEntity : class
    {
        private readonly PropertyInfo[] _primaryKeys;
        private readonly ObservableCollection<TEntity> _data;
        private readonly IQueryable _query;

        public FakeDbSet()
        {
            _data = new ObservableCollection<TEntity>();
            _query = _data.AsQueryable();
        }

        public FakeDbSet(params string[] primaryKeys)
        {
            _primaryKeys = typeof(TEntity).GetProperties().Where(x => primaryKeys.Contains(x.Name)).ToArray();
            _data = new ObservableCollection<TEntity>();
            _query = _data.AsQueryable();
        }

        public override TEntity Find(params object[] keyValues)
        {
            if (_primaryKeys == null)
                throw new ArgumentException("No primary keys defined");
            if (keyValues.Length != _primaryKeys.Length)
                throw new ArgumentException("Incorrect number of keys passed to Find method");

            var keyQuery = this.AsQueryable();
            keyQuery = keyValues
                .Select((t, i) => i)
                .Aggregate(keyQuery,
                    (current, x) =>
                        current.Where(entity => _primaryKeys[x].GetValue(entity, null).Equals(keyValues[x])));

            return keyQuery.SingleOrDefault();
        }

        public override Task<TEntity> FindAsync(CancellationToken cancellationToken, params object[] keyValues)
        {
            return Task<TEntity>.Factory.StartNew(() => Find(keyValues), cancellationToken);
        }

        public override Task<TEntity> FindAsync(params object[] keyValues)
        {
            return Task<TEntity>.Factory.StartNew(() => Find(keyValues));
        }

        public override IEnumerable<TEntity> AddRange(IEnumerable<TEntity> entities)
        {
            if (entities == null) throw new ArgumentNullException("entities");
            var items = entities.ToList();
            foreach (var entity in items)
            {
                _data.Add(entity);
            }
            return items;
        }

        public override TEntity Add(TEntity item)
        {
            if (item == null) throw new ArgumentNullException("item");
            _data.Add(item);
            return item;
        }

        public override IEnumerable<TEntity> RemoveRange(IEnumerable<TEntity> entities)
        {
            if (entities == null) throw new ArgumentNullException("entities");
            var items = entities.ToList();
            foreach (var entity in items)
            {
                _data.Remove(entity);
            }
            return items;
        }

        public override TEntity Remove(TEntity item)
        {
            if (item == null) throw new ArgumentNullException("item");
            _data.Remove(item);
            return item;
        }

        public override TEntity Attach(TEntity item)
        {
            if (item == null) throw new ArgumentNullException("item");
            _data.Add(item);
            return item;
        }

        public override TEntity Create()
        {
            return Activator.CreateInstance<TEntity>();
        }

        public override TDerivedEntity Create<TDerivedEntity>()
        {
            return Activator.CreateInstance<TDerivedEntity>();
        }

        public override ObservableCollection<TEntity> Local
        {
            get { return _data; }
        }

        Type IQueryable.ElementType
        {
            get { return _query.ElementType; }
        }

        Expression IQueryable.Expression
        {
            get { return _query.Expression; }
        }

        IQueryProvider IQueryable.Provider
        {
            get { return new FakeDbAsyncQueryProvider<TEntity>(_query.Provider); }
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return _data.GetEnumerator();
        }

        IEnumerator<TEntity> IEnumerable<TEntity>.GetEnumerator()
        {
            return _data.GetEnumerator();
        }

        IDbAsyncEnumerator<TEntity> IDbAsyncEnumerable<TEntity>.GetAsyncEnumerator()
        {
            return new FakeDbAsyncEnumerator<TEntity>(_data.GetEnumerator());
        }
    }

    public class FakeDbAsyncQueryProvider<TEntity> : IDbAsyncQueryProvider
    {
        private readonly IQueryProvider _inner;

        public FakeDbAsyncQueryProvider(IQueryProvider inner)
        {
            _inner = inner;
        }

        public IQueryable CreateQuery(Expression expression)
        {
            var m = expression as MethodCallExpression;
            if (m != null)
            {
                var resultType = m.Method.ReturnType; // it should be IQueryable<T>
                var tElement = resultType.GetGenericArguments()[0];
                var queryType = typeof(FakeDbAsyncEnumerable<>).MakeGenericType(tElement);
                return (IQueryable) Activator.CreateInstance(queryType, expression);
            }
            return new FakeDbAsyncEnumerable<TEntity>(expression);
        }

        public IQueryable<TElement> CreateQuery<TElement>(Expression expression)
        {
            var queryType = typeof(FakeDbAsyncEnumerable<>).MakeGenericType(typeof(TElement));
            return (IQueryable<TElement>) Activator.CreateInstance(queryType, expression);
        }

        public object Execute(Expression expression)
        {
            return _inner.Execute(expression);
        }

        public TResult Execute<TResult>(Expression expression)
        {
            return _inner.Execute<TResult>(expression);
        }

        public Task<object> ExecuteAsync(Expression expression, CancellationToken cancellationToken)
        {
            return Task.FromResult(Execute(expression));
        }

        public Task<TResult> ExecuteAsync<TResult>(Expression expression, CancellationToken cancellationToken)
        {
            return Task.FromResult(Execute<TResult>(expression));
        }
    }

    public class FakeDbAsyncEnumerable<T> : EnumerableQuery<T>, IDbAsyncEnumerable<T>, IQueryable<T>
    {
        public FakeDbAsyncEnumerable(IEnumerable<T> enumerable)
            : base(enumerable)
        { }

        public FakeDbAsyncEnumerable(Expression expression)
            : base(expression)
        { }

        public IDbAsyncEnumerator<T> GetAsyncEnumerator()
        {
            return new FakeDbAsyncEnumerator<T>(this.AsEnumerable().GetEnumerator());
        }

        IDbAsyncEnumerator IDbAsyncEnumerable.GetAsyncEnumerator()
        {
            return GetAsyncEnumerator();
        }

        IQueryProvider IQueryable.Provider
        {
            get { return new FakeDbAsyncQueryProvider<T>(this); }
        }

    }

    public class FakeDbAsyncEnumerator<T> : IDbAsyncEnumerator<T>
    {
        private readonly IEnumerator<T> _inner;

        public FakeDbAsyncEnumerator(IEnumerator<T> inner)
        {
            _inner = inner;
        }

        public void Dispose()
        {
            _inner.Dispose();
        }

        public Task<bool> MoveNextAsync(CancellationToken cancellationToken)
        {
            return Task.FromResult(_inner.MoveNext());
        }

        public T Current
        {
            get { return _inner.Current; }
        }

        object IDbAsyncEnumerator.Current
        {
            get { return Current; }
        }
    }

    #endregion

    #region POCO classes

    // Categories
    public class Category
    {
        public int CategoryId { get; set; } // Category ID (Primary key)
        public string CategoryName { get; set; } // Category Name (length: 15)
        public string Description { get; set; } // Description (length: 536870911)
        public byte[] Picture { get; set; } // Picture (length: 1073741823)

        // Reverse navigation

        /// <summary>
        /// Child Products where [Products].[Category ID] point to this entity (Products_FK01)
        /// </summary>
        public virtual ICollection<Product> Products { get; set; } // Products.Products_FK01

        public Category()
        {
            Products = new List<Product>();
        }
    }

    // Customers
    public class Customer
    {
        public string CustomerId { get; set; } // Customer ID (Primary key) (length: 5)
        public string CompanyName { get; set; } // Company Name (length: 40)
        public string ContactName { get; set; } // Contact Name (length: 30)
        public string ContactTitle { get; set; } // Contact Title (length: 30)
        public string Address { get; set; } // Address (length: 60)
        public string City { get; set; } // City (length: 15)
        public string Region { get; set; } // Region (length: 15)
        public string PostalCode { get; set; } // Postal Code (length: 10)
        public string Country { get; set; } // Country (length: 15)
        public string Phone { get; set; } // Phone (length: 24)
        public string Fax { get; set; } // Fax (length: 24)

        // Reverse navigation

        /// <summary>
        /// Child Orders where [Orders].[Customer ID] point to this entity (Orders_FK00)
        /// </summary>
        public virtual ICollection<Order> Orders { get; set; } // Orders.Orders_FK00

        public Customer()
        {
            Orders = new List<Order>();
        }
    }

    // Employees
    public class Employee
    {
        public int EmployeeId { get; set; } // Employee ID (Primary key)
        public string LastName { get; set; } // Last Name (length: 20)
        public string FirstName { get; set; } // First Name (length: 10)
        public string Title { get; set; } // Title (length: 30)
        public DateTime? BirthDate { get; set; } // Birth Date
        public DateTime? HireDate { get; set; } // Hire Date
        public string Address { get; set; } // Address (length: 60)
        public string City { get; set; } // City (length: 15)
        public string Region { get; set; } // Region (length: 15)
        public string PostalCode { get; set; } // Postal Code (length: 10)
        public string Country { get; set; } // Country (length: 15)
        public string HomePhone { get; set; } // Home Phone (length: 24)
        public string Extension { get; set; } // Extension (length: 4)
        public byte[] Photo { get; set; } // Photo (length: 1073741823)
        public string Notes { get; set; } // Notes (length: 536870911)
        public int? ReportsTo { get; set; } // Reports To

        // Reverse navigation

        /// <summary>
        /// Child Orders where [Orders].[Employee ID] point to this entity (Orders_FK02)
        /// </summary>
        public virtual ICollection<Order> Orders { get; set; } // Orders.Orders_FK02

        public Employee()
        {
            Orders = new List<Order>();
        }
    }

    // Orders
    public class Order
    {
        public int OrderId { get; set; } // Order ID (Primary key)
        public string CustomerId { get; set; } // Customer ID (length: 5)
        public int? EmployeeId { get; set; } // Employee ID
        public string ShipName { get; set; } // Ship Name (length: 40)
        public string ShipAddress { get; set; } // Ship Address (length: 60)
        public string ShipCity { get; set; } // Ship City (length: 15)
        public string ShipRegion { get; set; } // Ship Region (length: 15)
        public string ShipPostalCode { get; set; } // Ship Postal Code (length: 10)
        public string ShipCountry { get; set; } // Ship Country (length: 15)
        public int? ShipVia { get; set; } // Ship Via
        public DateTime? OrderDate { get; set; } // Order Date
        public DateTime? RequiredDate { get; set; } // Required Date
        public DateTime? ShippedDate { get; set; } // Shipped Date
        public decimal? Freight { get; set; } // Freight

        // Reverse navigation

        /// <summary>
        /// Child OrderDetails where [Order Details].[Order ID] point to this entity (Order Details_FK01)
        /// </summary>
        public virtual ICollection<OrderDetail> OrderDetails { get; set; } // Order Details.Order Details_FK01

        // Foreign keys

        /// <summary>
        /// Parent Customer pointed by [Orders].([CustomerId]) (Orders_FK00)
        /// </summary>
        public virtual Customer Customer { get; set; } // Orders_FK00

        /// <summary>
        /// Parent Employee pointed by [Orders].([EmployeeId]) (Orders_FK02)
        /// </summary>
        public virtual Employee Employee { get; set; } // Orders_FK02

        /// <summary>
        /// Parent Shipper pointed by [Orders].([ShipVia]) (Orders_FK01)
        /// </summary>
        public virtual Shipper Shipper { get; set; } // Orders_FK01

        public Order()
        {
            OrderDetails = new List<OrderDetail>();
        }
    }

    // Order Details
    public class OrderDetail
    {
        public int OrderId { get; set; } // Order ID (Primary key)
        public int ProductId { get; set; } // Product ID (Primary key)
        public decimal UnitPrice { get; set; } // Unit Price
        public short Quantity { get; set; } // Quantity
        public float Discount { get; set; } // Discount

        // Foreign keys

        /// <summary>
        /// Parent Order pointed by [Order Details].([OrderId]) (Order Details_FK01)
        /// </summary>
        public virtual Order Order { get; set; } // Order Details_FK01

        /// <summary>
        /// Parent Product pointed by [Order Details].([ProductId]) (Order Details_FK00)
        /// </summary>
        public virtual Product Product { get; set; } // Order Details_FK00
    }

    // Products
    public class Product
    {
        public int ProductId { get; set; } // Product ID (Primary key)
        public int? SupplierId { get; set; } // Supplier ID
        public int? CategoryId { get; set; } // Category ID
        public string ProductName { get; set; } // Product Name (length: 40)
        public string EnglishName { get; set; } // English Name (length: 40)
        public string QuantityPerUnit { get; set; } // Quantity Per Unit (length: 20)
        public decimal? UnitPrice { get; set; } // Unit Price
        public short? UnitsInStock { get; set; } // Units In Stock
        public short? UnitsOnOrder { get; set; } // Units On Order
        public short? ReorderLevel { get; set; } // Reorder Level
        public bool Discontinued { get; set; } // Discontinued

        // Reverse navigation

        /// <summary>
        /// Child OrderDetails where [Order Details].[Product ID] point to this entity (Order Details_FK00)
        /// </summary>
        public virtual ICollection<OrderDetail> OrderDetails { get; set; } // Order Details.Order Details_FK00

        // Foreign keys

        /// <summary>
        /// Parent Category pointed by [Products].([CategoryId]) (Products_FK01)
        /// </summary>
        public virtual Category Category { get; set; } // Products_FK01

        /// <summary>
        /// Parent Supplier pointed by [Products].([SupplierId]) (Products_FK00)
        /// </summary>
        public virtual Supplier Supplier { get; set; } // Products_FK00

        public Product()
        {
            OrderDetails = new List<OrderDetail>();
        }
    }

    // Shippers
    public class Shipper
    {
        public int ShipperId { get; set; } // Shipper ID (Primary key)
        public string CompanyName { get; set; } // Company Name (length: 40)

        // Reverse navigation

        /// <summary>
        /// Child Orders where [Orders].[Ship Via] point to this entity (Orders_FK01)
        /// </summary>
        public virtual ICollection<Order> Orders { get; set; } // Orders.Orders_FK01

        public Shipper()
        {
            Orders = new List<Order>();
        }
    }

    // Suppliers
    public class Supplier
    {
        public int SupplierId { get; set; } // Supplier ID (Primary key)
        public string CompanyName { get; set; } // Company Name (length: 40)
        public string ContactName { get; set; } // Contact Name (length: 30)
        public string ContactTitle { get; set; } // Contact Title (length: 30)
        public string Address { get; set; } // Address (length: 60)
        public string City { get; set; } // City (length: 15)
        public string Region { get; set; } // Region (length: 15)
        public string PostalCode { get; set; } // Postal Code (length: 10)
        public string Country { get; set; } // Country (length: 15)
        public string Phone { get; set; } // Phone (length: 24)
        public string Fax { get; set; } // Fax (length: 24)

        // Reverse navigation

        /// <summary>
        /// Child Products where [Products].[Supplier ID] point to this entity (Products_FK00)
        /// </summary>
        public virtual ICollection<Product> Products { get; set; } // Products.Products_FK00

        public Supplier()
        {
            Products = new List<Product>();
        }
    }


    #endregion

    #region POCO Configuration

    // Categories
    public class CategoryConfiguration : EntityTypeConfiguration<Category>
    {
        public CategoryConfiguration()
            : this("")
        {
        }

        public CategoryConfiguration(string schema)
        {
            ToTable("Categories");
            HasKey(x => x.CategoryId);

            Property(x => x.CategoryId).HasColumnName(@"Category ID").HasColumnType("int").IsRequired().HasDatabaseGeneratedOption(DatabaseGeneratedOption.Identity);
            Property(x => x.CategoryName).HasColumnName(@"Category Name").HasColumnType("nvarchar").IsRequired().HasMaxLength(15);
            Property(x => x.Description).HasColumnName(@"Description").HasColumnType("ntext").IsOptional().IsMaxLength();
            Property(x => x.Picture).HasColumnName(@"Picture").HasColumnType("image").IsOptional().HasMaxLength(null);
        }
    }

    // Customers
    public class CustomerConfiguration : EntityTypeConfiguration<Customer>
    {
        public CustomerConfiguration()
            : this("")
        {
        }

        public CustomerConfiguration(string schema)
        {
            ToTable("Customers");
            HasKey(x => x.CustomerId);

            Property(x => x.CustomerId).HasColumnName(@"Customer ID").HasColumnType("nvarchar").IsRequired().HasMaxLength(5).HasDatabaseGeneratedOption(DatabaseGeneratedOption.None);
            Property(x => x.CompanyName).HasColumnName(@"Company Name").HasColumnType("nvarchar").IsRequired().HasMaxLength(40);
            Property(x => x.ContactName).HasColumnName(@"Contact Name").HasColumnType("nvarchar").IsOptional().HasMaxLength(30);
            Property(x => x.ContactTitle).HasColumnName(@"Contact Title").HasColumnType("nvarchar").IsOptional().HasMaxLength(30);
            Property(x => x.Address).HasColumnName(@"Address").HasColumnType("nvarchar").IsOptional().HasMaxLength(60);
            Property(x => x.City).HasColumnName(@"City").HasColumnType("nvarchar").IsOptional().HasMaxLength(15);
            Property(x => x.Region).HasColumnName(@"Region").HasColumnType("nvarchar").IsOptional().HasMaxLength(15);
            Property(x => x.PostalCode).HasColumnName(@"Postal Code").HasColumnType("nvarchar").IsOptional().HasMaxLength(10);
            Property(x => x.Country).HasColumnName(@"Country").HasColumnType("nvarchar").IsOptional().HasMaxLength(15);
            Property(x => x.Phone).HasColumnName(@"Phone").HasColumnType("nvarchar").IsOptional().HasMaxLength(24);
            Property(x => x.Fax).HasColumnName(@"Fax").HasColumnType("nvarchar").IsOptional().HasMaxLength(24);
        }
    }

    // Employees
    public class EmployeeConfiguration : EntityTypeConfiguration<Employee>
    {
        public EmployeeConfiguration()
            : this("")
        {
        }

        public EmployeeConfiguration(string schema)
        {
            ToTable("Employees");
            HasKey(x => x.EmployeeId);

            Property(x => x.EmployeeId).HasColumnName(@"Employee ID").HasColumnType("int").IsRequired().HasDatabaseGeneratedOption(DatabaseGeneratedOption.Identity);
            Property(x => x.LastName).HasColumnName(@"Last Name").HasColumnType("nvarchar").IsRequired().HasMaxLength(20);
            Property(x => x.FirstName).HasColumnName(@"First Name").HasColumnType("nvarchar").IsRequired().HasMaxLength(10);
            Property(x => x.Title).HasColumnName(@"Title").HasColumnType("nvarchar").IsOptional().HasMaxLength(30);
            Property(x => x.BirthDate).HasColumnName(@"Birth Date").HasColumnType("datetime").IsOptional();
            Property(x => x.HireDate).HasColumnName(@"Hire Date").HasColumnType("datetime").IsOptional();
            Property(x => x.Address).HasColumnName(@"Address").HasColumnType("nvarchar").IsOptional().HasMaxLength(60);
            Property(x => x.City).HasColumnName(@"City").HasColumnType("nvarchar").IsOptional().HasMaxLength(15);
            Property(x => x.Region).HasColumnName(@"Region").HasColumnType("nvarchar").IsOptional().HasMaxLength(15);
            Property(x => x.PostalCode).HasColumnName(@"Postal Code").HasColumnType("nvarchar").IsOptional().HasMaxLength(10);
            Property(x => x.Country).HasColumnName(@"Country").HasColumnType("nvarchar").IsOptional().HasMaxLength(15);
            Property(x => x.HomePhone).HasColumnName(@"Home Phone").HasColumnType("nvarchar").IsOptional().HasMaxLength(24);
            Property(x => x.Extension).HasColumnName(@"Extension").HasColumnType("nvarchar").IsOptional().HasMaxLength(4);
            Property(x => x.Photo).HasColumnName(@"Photo").HasColumnType("image").IsOptional().HasMaxLength(null);
            Property(x => x.Notes).HasColumnName(@"Notes").HasColumnType("ntext").IsOptional().IsMaxLength();
            Property(x => x.ReportsTo).HasColumnName(@"Reports To").HasColumnType("int").IsOptional();
        }
    }

    // Orders
    public class OrderConfiguration : EntityTypeConfiguration<Order>
    {
        public OrderConfiguration()
            : this("")
        {
        }

        public OrderConfiguration(string schema)
        {
            ToTable("Orders");
            HasKey(x => x.OrderId);

            Property(x => x.OrderId).HasColumnName(@"Order ID").HasColumnType("int").IsRequired().HasDatabaseGeneratedOption(DatabaseGeneratedOption.None);
            Property(x => x.CustomerId).HasColumnName(@"Customer ID").HasColumnType("nvarchar").IsRequired().HasMaxLength(5);
            Property(x => x.EmployeeId).HasColumnName(@"Employee ID").HasColumnType("int").IsOptional();
            Property(x => x.ShipName).HasColumnName(@"Ship Name").HasColumnType("nvarchar").IsOptional().HasMaxLength(40);
            Property(x => x.ShipAddress).HasColumnName(@"Ship Address").HasColumnType("nvarchar").IsOptional().HasMaxLength(60);
            Property(x => x.ShipCity).HasColumnName(@"Ship City").HasColumnType("nvarchar").IsOptional().HasMaxLength(15);
            Property(x => x.ShipRegion).HasColumnName(@"Ship Region").HasColumnType("nvarchar").IsOptional().HasMaxLength(15);
            Property(x => x.ShipPostalCode).HasColumnName(@"Ship Postal Code").HasColumnType("nvarchar").IsOptional().HasMaxLength(10);
            Property(x => x.ShipCountry).HasColumnName(@"Ship Country").HasColumnType("nvarchar").IsOptional().HasMaxLength(15);
            Property(x => x.ShipVia).HasColumnName(@"Ship Via").HasColumnType("int").IsOptional();
            Property(x => x.OrderDate).HasColumnName(@"Order Date").HasColumnType("datetime").IsOptional();
            Property(x => x.RequiredDate).HasColumnName(@"Required Date").HasColumnType("datetime").IsOptional();
            Property(x => x.ShippedDate).HasColumnName(@"Shipped Date").HasColumnType("datetime").IsOptional();
            Property(x => x.Freight).HasColumnName(@"Freight").HasColumnType("money").IsOptional();

            // Foreign keys
            HasOptional(a => a.Employee).WithMany(b => b.Orders).HasForeignKey(c => c.EmployeeId).WillCascadeOnDelete(false); // Orders_FK02
            HasOptional(a => a.Shipper).WithMany(b => b.Orders).HasForeignKey(c => c.ShipVia).WillCascadeOnDelete(false); // Orders_FK01
            HasRequired(a => a.Customer).WithMany(b => b.Orders).HasForeignKey(c => c.CustomerId).WillCascadeOnDelete(false); // Orders_FK00
        }
    }

    // Order Details
    public class OrderDetailConfiguration : EntityTypeConfiguration<OrderDetail>
    {
        public OrderDetailConfiguration()
            : this("")
        {
        }

        public OrderDetailConfiguration(string schema)
        {
            ToTable("Order Details");
            HasKey(x => new { x.OrderId, x.ProductId });

            Property(x => x.OrderId).HasColumnName(@"Order ID").HasColumnType("int").IsRequired().HasDatabaseGeneratedOption(DatabaseGeneratedOption.None);
            Property(x => x.ProductId).HasColumnName(@"Product ID").HasColumnType("int").IsRequired().HasDatabaseGeneratedOption(DatabaseGeneratedOption.None);
            Property(x => x.UnitPrice).HasColumnName(@"Unit Price").HasColumnType("money").IsRequired();
            Property(x => x.Quantity).HasColumnName(@"Quantity").HasColumnType("smallint").IsRequired();
            Property(x => x.Discount).HasColumnName(@"Discount").HasColumnType("real").IsRequired();

            // Foreign keys
            HasRequired(a => a.Order).WithMany(b => b.OrderDetails).HasForeignKey(c => c.OrderId); // Order Details_FK01
            HasRequired(a => a.Product).WithMany(b => b.OrderDetails).HasForeignKey(c => c.ProductId).WillCascadeOnDelete(false); // Order Details_FK00
        }
    }

    // Products
    public class ProductConfiguration : EntityTypeConfiguration<Product>
    {
        public ProductConfiguration()
            : this("")
        {
        }

        public ProductConfiguration(string schema)
        {
            ToTable("Products");
            HasKey(x => x.ProductId);

            Property(x => x.ProductId).HasColumnName(@"Product ID").HasColumnType("int").IsRequired().HasDatabaseGeneratedOption(DatabaseGeneratedOption.Identity);
            Property(x => x.SupplierId).HasColumnName(@"Supplier ID").HasColumnType("int").IsOptional();
            Property(x => x.CategoryId).HasColumnName(@"Category ID").HasColumnType("int").IsOptional();
            Property(x => x.ProductName).HasColumnName(@"Product Name").HasColumnType("nvarchar").IsRequired().HasMaxLength(40);
            Property(x => x.EnglishName).HasColumnName(@"English Name").HasColumnType("nvarchar").IsOptional().HasMaxLength(40);
            Property(x => x.QuantityPerUnit).HasColumnName(@"Quantity Per Unit").HasColumnType("nvarchar").IsOptional().HasMaxLength(20);
            Property(x => x.UnitPrice).HasColumnName(@"Unit Price").HasColumnType("money").IsOptional();
            Property(x => x.UnitsInStock).HasColumnName(@"Units In Stock").HasColumnType("smallint").IsOptional();
            Property(x => x.UnitsOnOrder).HasColumnName(@"Units On Order").HasColumnType("smallint").IsOptional();
            Property(x => x.ReorderLevel).HasColumnName(@"Reorder Level").HasColumnType("smallint").IsOptional();
            Property(x => x.Discontinued).HasColumnName(@"Discontinued").HasColumnType("bit").IsRequired();

            // Foreign keys
            HasOptional(a => a.Category).WithMany(b => b.Products).HasForeignKey(c => c.CategoryId).WillCascadeOnDelete(false); // Products_FK01
            HasOptional(a => a.Supplier).WithMany(b => b.Products).HasForeignKey(c => c.SupplierId).WillCascadeOnDelete(false); // Products_FK00
        }
    }

    // Shippers
    public class ShipperConfiguration : EntityTypeConfiguration<Shipper>
    {
        public ShipperConfiguration()
            : this("")
        {
        }

        public ShipperConfiguration(string schema)
        {
            ToTable("Shippers");
            HasKey(x => x.ShipperId);

            Property(x => x.ShipperId).HasColumnName(@"Shipper ID").HasColumnType("int").IsRequired().HasDatabaseGeneratedOption(DatabaseGeneratedOption.Identity);
            Property(x => x.CompanyName).HasColumnName(@"Company Name").HasColumnType("nvarchar").IsRequired().HasMaxLength(40);
        }
    }

    // Suppliers
    public class SupplierConfiguration : EntityTypeConfiguration<Supplier>
    {
        public SupplierConfiguration()
            : this("")
        {
        }

        public SupplierConfiguration(string schema)
        {
            ToTable("Suppliers");
            HasKey(x => x.SupplierId);

            Property(x => x.SupplierId).HasColumnName(@"Supplier ID").HasColumnType("int").IsRequired().HasDatabaseGeneratedOption(DatabaseGeneratedOption.Identity);
            Property(x => x.CompanyName).HasColumnName(@"Company Name").HasColumnType("nvarchar").IsRequired().HasMaxLength(40);
            Property(x => x.ContactName).HasColumnName(@"Contact Name").HasColumnType("nvarchar").IsOptional().HasMaxLength(30);
            Property(x => x.ContactTitle).HasColumnName(@"Contact Title").HasColumnType("nvarchar").IsOptional().HasMaxLength(30);
            Property(x => x.Address).HasColumnName(@"Address").HasColumnType("nvarchar").IsOptional().HasMaxLength(60);
            Property(x => x.City).HasColumnName(@"City").HasColumnType("nvarchar").IsOptional().HasMaxLength(15);
            Property(x => x.Region).HasColumnName(@"Region").HasColumnType("nvarchar").IsOptional().HasMaxLength(15);
            Property(x => x.PostalCode).HasColumnName(@"Postal Code").HasColumnType("nvarchar").IsOptional().HasMaxLength(10);
            Property(x => x.Country).HasColumnName(@"Country").HasColumnType("nvarchar").IsOptional().HasMaxLength(15);
            Property(x => x.Phone).HasColumnName(@"Phone").HasColumnType("nvarchar").IsOptional().HasMaxLength(24);
            Property(x => x.Fax).HasColumnName(@"Fax").HasColumnType("nvarchar").IsOptional().HasMaxLength(24);
        }
    }


    #endregion

}
// </auto-generated>
