// <auto-generated>

using Microsoft.EntityFrameworkCore;
using Microsoft.EntityFrameworkCore.ChangeTracking;
using Microsoft.EntityFrameworkCore.Design;
using Microsoft.EntityFrameworkCore.Infrastructure;
using Microsoft.EntityFrameworkCore.Metadata;
using Microsoft.EntityFrameworkCore.Metadata.Builders;
using Microsoft.EntityFrameworkCore.Query;
using Microsoft.EntityFrameworkCore.Query.Internal;
using Microsoft.EntityFrameworkCore.Storage;
using Npgsql;
using NpgsqlTypes;
using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.ComponentModel;
using System.Data;
using System.Data.SqlTypes;
using System.Linq;
using System.Linq.Expressions;
using System.Reflection;
using System.Threading;
using System.Threading.Tasks;

namespace Efrpg.PostgreSQL
{
    #region Database context interface

    public interface IMyDbContext : IDisposable
    {
        DbSet<Category> Categories { get; set; } // categories
        DbSet<Customer> Customers { get; set; } // customers
        DbSet<CustomerCustomerDemo> CustomerCustomerDemoes { get; set; } // customer_customer_demo
        DbSet<CustomerDemographic> CustomerDemographics { get; set; } // customer_demographics
        DbSet<Employee> Employees { get; set; } // employees
        DbSet<EmployeeTerritory> EmployeeTerritories { get; set; } // employee_territories
        DbSet<Order> Orders { get; set; } // orders
        DbSet<OrderDetail> OrderDetails { get; set; } // order_details
        DbSet<Product> Products { get; set; } // products
        DbSet<Region> Regions { get; set; } // region
        DbSet<Shipper> Shippers { get; set; } // shippers
        DbSet<Supplier> Suppliers { get; set; } // suppliers
        DbSet<Territory> Territories { get; set; } // territories
        DbSet<UsState> UsStates { get; set; } // us_states

        int SaveChanges();
        int SaveChanges(bool acceptAllChangesOnSuccess);
        Task<int> SaveChangesAsync(CancellationToken cancellationToken = default(CancellationToken));
        Task<int> SaveChangesAsync(bool acceptAllChangesOnSuccess, CancellationToken cancellationToken = default(CancellationToken));
        DatabaseFacade Database { get; }
        DbSet<TEntity> Set<TEntity>() where TEntity : class;
        string ToString();

        EntityEntry Add(object entity);
        EntityEntry<TEntity> Add<TEntity>(TEntity entity) where TEntity : class;
        Task AddRangeAsync(params object[] entities);
        Task AddRangeAsync(IEnumerable<object> entities, CancellationToken cancellationToken = default);
        ValueTask<EntityEntry<TEntity>> AddAsync<TEntity>(TEntity entity, CancellationToken cancellationToken = default) where TEntity : class;
        ValueTask<EntityEntry> AddAsync(object entity, CancellationToken cancellationToken = default);
        void AddRange(IEnumerable<object> entities);
        void AddRange(params object[] entities);

        EntityEntry Attach(object entity);
        EntityEntry<TEntity> Attach<TEntity>(TEntity entity) where TEntity : class;
        void AttachRange(IEnumerable<object> entities);
        void AttachRange(params object[] entities);

        EntityEntry Entry(object entity);
        EntityEntry<TEntity> Entry<TEntity>(TEntity entity) where TEntity : class;

        TEntity Find<TEntity>(params object[] keyValues) where TEntity : class;
        ValueTask<TEntity> FindAsync<TEntity>(object[] keyValues, CancellationToken cancellationToken) where TEntity : class;
        ValueTask<TEntity> FindAsync<TEntity>(params object[] keyValues) where TEntity : class;
        ValueTask<object> FindAsync(Type entityType, object[] keyValues, CancellationToken cancellationToken);
        ValueTask<object> FindAsync(Type entityType, params object[] keyValues);
        object Find(Type entityType, params object[] keyValues);

        EntityEntry Remove(object entity);
        EntityEntry<TEntity> Remove<TEntity>(TEntity entity) where TEntity : class;
        void RemoveRange(IEnumerable<object> entities);
        void RemoveRange(params object[] entities);

        EntityEntry Update(object entity);
        EntityEntry<TEntity> Update<TEntity>(TEntity entity) where TEntity : class;
        void UpdateRange(IEnumerable<object> entities);
        void UpdateRange(params object[] entities);

        IQueryable<TResult> FromExpression<TResult> (Expression<Func<IQueryable<TResult>>> expression);
    }

    #endregion

    #region Database context

    public class MyDbContext : DbContext, IMyDbContext
    {
        public MyDbContext()
        {
        }

        public MyDbContext(DbContextOptions<MyDbContext> options)
            : base(options)
        {
        }

        public DbSet<Category> Categories { get; set; } // categories
        public DbSet<Customer> Customers { get; set; } // customers
        public DbSet<CustomerCustomerDemo> CustomerCustomerDemoes { get; set; } // customer_customer_demo
        public DbSet<CustomerDemographic> CustomerDemographics { get; set; } // customer_demographics
        public DbSet<Employee> Employees { get; set; } // employees
        public DbSet<EmployeeTerritory> EmployeeTerritories { get; set; } // employee_territories
        public DbSet<Order> Orders { get; set; } // orders
        public DbSet<OrderDetail> OrderDetails { get; set; } // order_details
        public DbSet<Product> Products { get; set; } // products
        public DbSet<Region> Regions { get; set; } // region
        public DbSet<Shipper> Shippers { get; set; } // shippers
        public DbSet<Supplier> Suppliers { get; set; } // suppliers
        public DbSet<Territory> Territories { get; set; } // territories
        public DbSet<UsState> UsStates { get; set; } // us_states

        protected override void OnConfiguring(DbContextOptionsBuilder optionsBuilder)
        {
            if (!optionsBuilder.IsConfigured)
            {
                optionsBuilder.UseNpgsql(@"Server=127.0.0.1;Port=5433;Database=Northwind;User Id=testuser;Password=testtesttest;");
                optionsBuilder.UseLazyLoadingProxies();
            }
        }

        public bool IsSqlParameterNull(NpgsqlParameter param)
        {
            var sqlValue = param.NpgsqlValue;
            var nullableValue = sqlValue as INullable;
            if (nullableValue != null)
                return nullableValue.IsNull;
            return (sqlValue == null || sqlValue == DBNull.Value);
        }

        protected override void OnModelCreating(ModelBuilder modelBuilder)
        {
            base.OnModelCreating(modelBuilder);

            modelBuilder.ApplyConfiguration(new CategoryConfiguration());
            modelBuilder.ApplyConfiguration(new CustomerConfiguration());
            modelBuilder.ApplyConfiguration(new CustomerCustomerDemoConfiguration());
            modelBuilder.ApplyConfiguration(new CustomerDemographicConfiguration());
            modelBuilder.ApplyConfiguration(new EmployeeConfiguration());
            modelBuilder.ApplyConfiguration(new EmployeeTerritoryConfiguration());
            modelBuilder.ApplyConfiguration(new OrderConfiguration());
            modelBuilder.ApplyConfiguration(new OrderDetailConfiguration());
            modelBuilder.ApplyConfiguration(new ProductConfiguration());
            modelBuilder.ApplyConfiguration(new RegionConfiguration());
            modelBuilder.ApplyConfiguration(new ShipperConfiguration());
            modelBuilder.ApplyConfiguration(new SupplierConfiguration());
            modelBuilder.ApplyConfiguration(new TerritoryConfiguration());
            modelBuilder.ApplyConfiguration(new UsStateConfiguration());
        }

    }

    #endregion

    #region Database context factory

    public class MyDbContextFactory : IDesignTimeDbContextFactory<MyDbContext>
    {
        public MyDbContext CreateDbContext(string[] args)
        {
            return new MyDbContext();
        }
    }

    #endregion

    #region Fake Database context

    public class FakeMyDbContext : IMyDbContext
    {
        public DbSet<Category> Categories { get; set; } // categories
        public DbSet<Customer> Customers { get; set; } // customers
        public DbSet<CustomerCustomerDemo> CustomerCustomerDemoes { get; set; } // customer_customer_demo
        public DbSet<CustomerDemographic> CustomerDemographics { get; set; } // customer_demographics
        public DbSet<Employee> Employees { get; set; } // employees
        public DbSet<EmployeeTerritory> EmployeeTerritories { get; set; } // employee_territories
        public DbSet<Order> Orders { get; set; } // orders
        public DbSet<OrderDetail> OrderDetails { get; set; } // order_details
        public DbSet<Product> Products { get; set; } // products
        public DbSet<Region> Regions { get; set; } // region
        public DbSet<Shipper> Shippers { get; set; } // shippers
        public DbSet<Supplier> Suppliers { get; set; } // suppliers
        public DbSet<Territory> Territories { get; set; } // territories
        public DbSet<UsState> UsStates { get; set; } // us_states

        public FakeMyDbContext()
        {
            _database = new FakeDatabaseFacade(new MyDbContext());

            Categories = new FakeDbSet<Category>("CategoryId");
            Customers = new FakeDbSet<Customer>("CustomerId");
            CustomerCustomerDemoes = new FakeDbSet<CustomerCustomerDemo>("CustomerId", "CustomerTypeId");
            CustomerDemographics = new FakeDbSet<CustomerDemographic>("CustomerTypeId");
            Employees = new FakeDbSet<Employee>("EmployeeId");
            EmployeeTerritories = new FakeDbSet<EmployeeTerritory>("EmployeeId", "TerritoryId");
            Orders = new FakeDbSet<Order>("OrderId");
            OrderDetails = new FakeDbSet<OrderDetail>("OrderId", "ProductId");
            Products = new FakeDbSet<Product>("ProductId");
            Regions = new FakeDbSet<Region>("RegionId");
            Shippers = new FakeDbSet<Shipper>("ShipperId");
            Suppliers = new FakeDbSet<Supplier>("SupplierId");
            Territories = new FakeDbSet<Territory>("TerritoryId");
            UsStates = new FakeDbSet<UsState>("StateId");

        }

        public int SaveChangesCount { get; private set; }
        public virtual int SaveChanges()
        {
            ++SaveChangesCount;
            return 1;
        }

        public virtual int SaveChanges(bool acceptAllChangesOnSuccess)
        {
            return SaveChanges();
        }

        public virtual Task<int> SaveChangesAsync(CancellationToken cancellationToken)
        {
            ++SaveChangesCount;
            return Task<int>.Factory.StartNew(() => 1, cancellationToken);
        }
        public virtual Task<int> SaveChangesAsync(bool acceptAllChangesOnSuccess, CancellationToken cancellationToken)
        {
            ++SaveChangesCount;
            return Task<int>.Factory.StartNew(x => 1, acceptAllChangesOnSuccess, cancellationToken);
        }

        protected virtual void Dispose(bool disposing)
        {
        }

        public void Dispose()
        {
            Dispose(true);
        }

        private DatabaseFacade _database;
        public DatabaseFacade Database { get { return _database; } }

        public DbSet<TEntity> Set<TEntity>() where TEntity : class
        {
            throw new NotImplementedException();
        }

        public override string ToString()
        {
            throw new NotImplementedException();
        }

        public virtual EntityEntry Add(object entity)
        {
            throw new NotImplementedException();
        }

        public virtual EntityEntry<TEntity> Add<TEntity>(TEntity entity) where TEntity : class
        {
            throw new NotImplementedException();
        }

        public virtual Task AddRangeAsync(params object[] entities)
        {
            throw new NotImplementedException();
        }

        public virtual async Task AddRangeAsync(IEnumerable<object> entities, CancellationToken cancellationToken = default)
        {
            await Task.CompletedTask;
            throw new NotImplementedException();
        }

        public virtual async ValueTask<EntityEntry<TEntity>> AddAsync<TEntity>(TEntity entity, CancellationToken cancellationToken = default) where TEntity : class
        {
            await Task.CompletedTask;
            throw new NotImplementedException();
        }

        public virtual async ValueTask<EntityEntry> AddAsync(object entity, CancellationToken cancellationToken = default)
        {
            await Task.CompletedTask;
            throw new NotImplementedException();
        }

        public virtual void AddRange(IEnumerable<object> entities)
        {
            throw new NotImplementedException();
        }

        public virtual void AddRange(params object[] entities)
        {
            throw new NotImplementedException();
        }

        public virtual EntityEntry Attach(object entity)
        {
            throw new NotImplementedException();
        }

        public virtual EntityEntry<TEntity> Attach<TEntity>(TEntity entity) where TEntity : class
        {
            throw new NotImplementedException();
        }

        public virtual void AttachRange(IEnumerable<object> entities)
        {
            throw new NotImplementedException();
        }

        public virtual void AttachRange(params object[] entities)
        {
            throw new NotImplementedException();
        }

        public virtual EntityEntry Entry(object entity)
        {
            throw new NotImplementedException();
        }

        public virtual EntityEntry<TEntity> Entry<TEntity>(TEntity entity) where TEntity : class
        {
            throw new NotImplementedException();
        }

        public virtual TEntity Find<TEntity>(params object[] keyValues) where TEntity : class
        {
            throw new NotImplementedException();
        }

        public virtual ValueTask<TEntity> FindAsync<TEntity>(object[] keyValues, CancellationToken cancellationToken) where TEntity : class
        {
            throw new NotImplementedException();
        }

        public virtual ValueTask<TEntity> FindAsync<TEntity>(params object[] keyValues) where TEntity : class
        {
            throw new NotImplementedException();
        }

        public virtual ValueTask<object> FindAsync(Type entityType, object[] keyValues, CancellationToken cancellationToken)
        {
            throw new NotImplementedException();
        }

        public virtual ValueTask<object> FindAsync(Type entityType, params object[] keyValues)
        {
            throw new NotImplementedException();
        }

        public virtual object Find(Type entityType, params object[] keyValues)
        {
            throw new NotImplementedException();
        }

        public virtual EntityEntry Remove(object entity)
        {
            throw new NotImplementedException();
        }

        public virtual EntityEntry<TEntity> Remove<TEntity>(TEntity entity) where TEntity : class
        {
            throw new NotImplementedException();
        }

        public virtual void RemoveRange(IEnumerable<object> entities)
        {
            throw new NotImplementedException();
        }

        public virtual void RemoveRange(params object[] entities)
        {
            throw new NotImplementedException();
        }

        public virtual EntityEntry Update(object entity)
        {
            throw new NotImplementedException();
        }

        public virtual EntityEntry<TEntity> Update<TEntity>(TEntity entity) where TEntity : class
        {
            throw new NotImplementedException();
        }

        public virtual void UpdateRange(IEnumerable<object> entities)
        {
            throw new NotImplementedException();
        }

        public virtual void UpdateRange(params object[] entities)
        {
            throw new NotImplementedException();
        }

        public virtual IQueryable<TResult> FromExpression<TResult> (Expression<Func<IQueryable<TResult>>> expression)
        {
            throw new NotImplementedException();
        }

    }

    #endregion

    #region Fake DbSet

    // ************************************************************************
    // Fake DbSet
    // Implementing Find:
    //      The Find method is difficult to implement in a generic fashion. If
    //      you need to test code that makes use of the Find method it is
    //      easiest to create a test DbSet for each of the entity types that
    //      need to support find. You can then write logic to find that
    //      particular type of entity, as shown below:
    //      public class FakeBlogDbSet : FakeDbSet<Blog>
    //      {
    //          public override Blog Find(params object[] keyValues)
    //          {
    //              var id = (int) keyValues.Single();
    //              return this.SingleOrDefault(b => b.BlogId == id);
    //          }
    //      }
    //      Read more about it here: https://msdn.microsoft.com/en-us/data/dn314431.aspx
    public class FakeDbSet<TEntity> :
        DbSet<TEntity>,
        IQueryable<TEntity>,
        IAsyncEnumerable<TEntity>,
        IListSource,
        IResettableService
        where TEntity : class
    {
        private readonly PropertyInfo[] _primaryKeys;
        private ObservableCollection<TEntity> _data;
        private IQueryable _query;
        public override IEntityType EntityType { get; }

        public FakeDbSet()
        {
            _primaryKeys = null;
            _data        = new ObservableCollection<TEntity>();
            _query       = _data.AsQueryable();
        }

        public FakeDbSet(params string[] primaryKeys)
        {
            _primaryKeys = typeof(TEntity).GetProperties().Where(x => primaryKeys.Contains(x.Name)).ToArray();
            _data        = new ObservableCollection<TEntity>();
            _query       = _data.AsQueryable();
        }

        public override TEntity Find(params object[] keyValues)
        {
            if (_primaryKeys == null)
                throw new ArgumentException("No primary keys defined");
            if (keyValues.Length != _primaryKeys.Length)
                throw new ArgumentException("Incorrect number of keys passed to Find method");

            var keyQuery = this.AsQueryable();
            keyQuery = keyValues
                .Select((t, i) => i)
                .Aggregate(keyQuery,
                    (current, x) =>
                        current.Where(entity => _primaryKeys[x].GetValue(entity, null).Equals(keyValues[x])));

            return keyQuery.SingleOrDefault();
        }

        public override ValueTask<TEntity> FindAsync(object[] keyValues, CancellationToken cancellationToken)
        {
            return new ValueTask<TEntity>(Task<TEntity>.Factory.StartNew(() => Find(keyValues), cancellationToken));
        }

        public override ValueTask<TEntity> FindAsync(params object[] keyValues)
        {
            return new ValueTask<TEntity>(Task<TEntity>.Factory.StartNew(() => Find(keyValues)));
        }

        public override EntityEntry<TEntity> Add(TEntity entity)
        {
            _data.Add(entity);
            return null;
        }

        public override ValueTask<EntityEntry<TEntity>> AddAsync(TEntity entity, CancellationToken cancellationToken = default)
        {
            return new ValueTask<EntityEntry<TEntity>>(Task<EntityEntry<TEntity>>.Factory.StartNew(() => Add(entity), cancellationToken));
        }

        public override void AddRange(params TEntity[] entities)
        {
            if (entities == null) throw new ArgumentNullException("entities");
            foreach (var entity in entities)
                _data.Add(entity);
        }

        public override void AddRange(IEnumerable<TEntity> entities)
        {
            if (entities == null) throw new ArgumentNullException("entities");
            foreach (var entity in entities)
                _data.Add(entity);
        }

        public override Task AddRangeAsync(params TEntity[] entities)
        {
            if (entities == null) throw new ArgumentNullException("entities");
            return Task.Factory.StartNew(() => AddRange(entities));
        }

        public override Task AddRangeAsync(IEnumerable<TEntity> entities, CancellationToken cancellationToken = default)
        {
            if (entities == null) throw new ArgumentNullException("entities");
            return Task.Factory.StartNew(() => AddRange(entities), cancellationToken);
        }

        public override EntityEntry<TEntity> Attach(TEntity entity)
        {
            if (entity == null) throw new ArgumentNullException("entity");
            return Add(entity);
        }

        public override void AttachRange(params TEntity[] entities)
        {
            if (entities == null) throw new ArgumentNullException("entities");
            AddRange(entities);
        }

        public override void AttachRange(IEnumerable<TEntity> entities)
        {
            if (entities == null) throw new ArgumentNullException("entities");
            AddRange(entities);
        }

        public override EntityEntry<TEntity> Remove(TEntity entity)
        {
            _data.Remove(entity);
            return null;
        }

        public override void RemoveRange(params TEntity[] entities)
        {
            if (entities == null) throw new ArgumentNullException("entities");
            foreach (var entity in entities.ToList())
                _data.Remove(entity);
        }

        public override void RemoveRange(IEnumerable<TEntity> entities)
        {
            RemoveRange(entities.ToArray());
        }

        public override EntityEntry<TEntity> Update(TEntity entity)
        {
            _data.Remove(entity);
            _data.Add(entity);
            return null;
        }

        public override void UpdateRange(params TEntity[] entities)
        {
            if (entities == null) throw new ArgumentNullException("entities");
            RemoveRange(entities);
            AddRange(entities);
        }

        public override void UpdateRange(IEnumerable<TEntity> entities)
        {
            if (entities == null) throw new ArgumentNullException("entities");
            var array = entities.ToArray();        RemoveRange(array);
            AddRange(array);
        }

        bool IListSource.ContainsListCollection => true;

        public IList GetList()
        {
            return _data;
        }

        IList IListSource.GetList()
        {
            return _data;
        }

        Type IQueryable.ElementType
        {
            get { return _query.ElementType; }
        }

        Expression IQueryable.Expression
        {
            get { return _query.Expression; }
        }

        IQueryProvider IQueryable.Provider
        {
            get { return new FakeDbAsyncQueryProvider<TEntity>(_data); }
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return _data.GetEnumerator();
        }

        IEnumerator<TEntity> IEnumerable<TEntity>.GetEnumerator()
        {
            return _data.GetEnumerator();
        }

        public override IAsyncEnumerator<TEntity> GetAsyncEnumerator(CancellationToken cancellationToken = default)
        {
            return new FakeDbAsyncEnumerator<TEntity>(this.AsEnumerable().GetEnumerator());
        }

        public void ResetState()
        {
            _data  = new ObservableCollection<TEntity>();
            _query = _data.AsQueryable();
        }

        public Task ResetStateAsync(CancellationToken cancellationToken = new CancellationToken())
        {
            return Task.Factory.StartNew(() => ResetState());
        }
    }

    public class FakeDbAsyncQueryProvider<TEntity> : FakeQueryProvider<TEntity>, IAsyncEnumerable<TEntity>, IAsyncQueryProvider
    {
        public FakeDbAsyncQueryProvider(Expression expression) : base(expression)
        {
        }

        public FakeDbAsyncQueryProvider(IEnumerable<TEntity> enumerable) : base(enumerable)
        {
        }

        public TResult ExecuteAsync<TResult>(Expression expression, CancellationToken cancellationToken)
        {
            var expectedResultType = typeof(TResult).GetGenericArguments()[0];
            var executionResult = typeof(IQueryProvider)
                .GetMethods()
                .First(method => method.Name == nameof(IQueryProvider.Execute) && method.IsGenericMethod)
                .MakeGenericMethod(expectedResultType)
                .Invoke(this, new object[] { expression });

            return (TResult) typeof(Task).GetMethod(nameof(Task.FromResult))
                ?.MakeGenericMethod(expectedResultType)
                .Invoke(null, new[] { executionResult });
        }

        public IAsyncEnumerator<TEntity> GetAsyncEnumerator(CancellationToken cancellationToken = default)
        {
            return new FakeDbAsyncEnumerator<TEntity>(this.AsEnumerable().GetEnumerator());
        }
    }

    public class FakeDbAsyncEnumerable<T> : EnumerableQuery<T>, IAsyncEnumerable<T>, IQueryable<T>
    {
        public FakeDbAsyncEnumerable(IEnumerable<T> enumerable)
            : base(enumerable)
        {
        }

        public FakeDbAsyncEnumerable(Expression expression)
            : base(expression)
        {
        }

        public IAsyncEnumerator<T> GetAsyncEnumerator(CancellationToken cancellationToken = new CancellationToken())
        {
            return new FakeDbAsyncEnumerator<T>(this.AsEnumerable().GetEnumerator());
        }

        IAsyncEnumerator<T> IAsyncEnumerable<T>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAsyncEnumerator(cancellationToken);
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return this.AsEnumerable().GetEnumerator();
        }
    }

    public class FakeDbAsyncEnumerator<T> : IAsyncEnumerator<T>
    {
        private readonly IEnumerator<T> _inner;

        public FakeDbAsyncEnumerator(IEnumerator<T> inner)
        {
            _inner = inner;
        }

        public T Current
        {
            get { return _inner.Current; }
        }

        public ValueTask<bool> MoveNextAsync()
        {
            return new ValueTask<bool>(_inner.MoveNext());
        }

        public ValueTask DisposeAsync()
        {
            _inner.Dispose();
            return new ValueTask(Task.CompletedTask);
        }
    }

    public abstract class FakeQueryProvider<T> : IOrderedQueryable<T>, IQueryProvider
    {
        private IEnumerable<T> _enumerable;

        protected FakeQueryProvider(Expression expression)
        {
            Expression = expression;
        }

        protected FakeQueryProvider(IEnumerable<T> enumerable)
        {
            _enumerable = enumerable;
            Expression = enumerable.AsQueryable().Expression;
        }

        public IQueryable CreateQuery(Expression expression)
        {
            if (expression is MethodCallExpression m)
            {
                var resultType = m.Method.ReturnType; // it should be IQueryable<T>
                var tElement = resultType.GetGenericArguments().First();
                return (IQueryable) CreateInstance(tElement, expression);
            }

            return CreateQuery<T>(expression);
        }

        public IQueryable<TEntity> CreateQuery<TEntity>(Expression expression)
        {
            return (IQueryable<TEntity>) CreateInstance(typeof(TEntity), expression);
        }

        private object CreateInstance(Type tElement, Expression expression)
        {
            var queryType = GetType().GetGenericTypeDefinition().MakeGenericType(tElement);
            return Activator.CreateInstance(queryType, expression);
        }

        public object Execute(Expression expression)
        {
            return CompileExpressionItem<object>(expression);
        }

        public TResult Execute<TResult>(Expression expression)
        {
            return CompileExpressionItem<TResult>(expression);
        }

        IEnumerator<T> IEnumerable<T>.GetEnumerator()
        {
            if (_enumerable == null) _enumerable = CompileExpressionItem<IEnumerable<T>>(Expression);
            return _enumerable.GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            if (_enumerable == null) _enumerable = CompileExpressionItem<IEnumerable<T>>(Expression);
            return _enumerable.GetEnumerator();
        }

        public Type ElementType => typeof(T);

        public Expression Expression { get; }

        public IQueryProvider Provider => this;

        private static TResult CompileExpressionItem<TResult>(Expression expression)
        {
            var visitor = new FakeExpressionVisitor();
            var body = visitor.Visit(expression);
            var f = Expression.Lambda<Func<TResult>>(body ?? throw new InvalidOperationException(string.Format("{0} is null", nameof(body))), (IEnumerable<ParameterExpression>) null);
            return f.Compile()();
        }
    }

    public class FakeExpressionVisitor : ExpressionVisitor
    {
    }

    public class FakeDatabaseFacade : DatabaseFacade
    {
        public FakeDatabaseFacade(DbContext context) : base(context)
        {
        }

        public override bool EnsureCreated()
        {
            return true;
        }

        public override Task<bool> EnsureCreatedAsync(CancellationToken cancellationToken = new CancellationToken())
        {
            return Task.FromResult(EnsureCreated());
        }

        public override bool EnsureDeleted()
        {
            return true;
        }

        public override Task<bool> EnsureDeletedAsync(CancellationToken cancellationToken = new CancellationToken())
        {
            return Task.FromResult(EnsureDeleted());
        }

        public override bool CanConnect()
        {
            return true;
        }

        public override Task<bool> CanConnectAsync(CancellationToken cancellationToken = new CancellationToken())
        {
            return Task.FromResult(CanConnect());
        }

        public override IDbContextTransaction BeginTransaction()
        {
            return new FakeDbContextTransaction();
        }

        public override Task<IDbContextTransaction> BeginTransactionAsync(CancellationToken cancellationToken = new CancellationToken())
        {
            return Task.FromResult(BeginTransaction());
        }

        public override void CommitTransaction()
        {
        }

        public override Task CommitTransactionAsync(CancellationToken cancellationToken = new CancellationToken())
        {
            return Task.CompletedTask;
        }

        public override void RollbackTransaction()
        {
        }

        public override Task RollbackTransactionAsync(CancellationToken cancellationToken = new CancellationToken())
        {
            return Task.CompletedTask;
        }

        public override IExecutionStrategy CreateExecutionStrategy()
        {
            return null;
        }

        public override string ToString()
        {
            return string.Empty;
        }
    }

    public class FakeDbContextTransaction : IDbContextTransaction
    {
        public Guid TransactionId => Guid.NewGuid();
        public void Commit() { }
        public void Rollback() { }
        public Task CommitAsync(CancellationToken cancellationToken = new CancellationToken()) => Task.CompletedTask;
        public Task RollbackAsync(CancellationToken cancellationToken = new CancellationToken()) => Task.CompletedTask;
        public void Dispose() { }
        public ValueTask DisposeAsync() => default;
    }

    #endregion

    #region POCO classes

    // categories
    public class Category
    {
        public short CategoryId { get; set; } // category_id (Primary key)
        public string CategoryName { get; set; } // category_name (length: 15)
        public string Description { get; set; } // description
        public byte[] Picture { get; set; } // picture

        // Reverse navigation

        /// <summary>
        /// Child Products where [products].[category_id] point to this entity (fk_products_categories)
        /// </summary>
        public virtual ICollection<Product> Products { get; set; } // products.fk_products_categories

        public Category()
        {
            Products = new List<Product>();
        }
    }

    // customers
    public class Customer
    {
        public string CustomerId { get; set; } // customer_id (Primary key) (length: 5)
        public string CompanyName { get; set; } // company_name (length: 40)
        public string ContactName { get; set; } // contact_name (length: 30)
        public string ContactTitle { get; set; } // contact_title (length: 30)
        public string Address { get; set; } // address (length: 60)
        public string City { get; set; } // city (length: 15)
        public string Region { get; set; } // region (length: 15)
        public string PostalCode { get; set; } // postal_code (length: 10)
        public string Country { get; set; } // country (length: 15)
        public string Phone { get; set; } // phone (length: 24)
        public string Fax { get; set; } // fax (length: 24)

        // Reverse navigation

        /// <summary>
        /// Child CustomerCustomerDemoes where [customer_customer_demo].[customer_id] point to this entity (fk_customer_customer_demo_customers)
        /// </summary>
        public virtual ICollection<CustomerCustomerDemo> CustomerCustomerDemoes { get; set; } // customer_customer_demo.fk_customer_customer_demo_customers

        /// <summary>
        /// Child Orders where [orders].[customer_id] point to this entity (fk_orders_customers)
        /// </summary>
        public virtual ICollection<Order> Orders { get; set; } // orders.fk_orders_customers

        public Customer()
        {
            Orders = new List<Order>();
            CustomerCustomerDemoes = new List<CustomerCustomerDemo>();
        }
    }

    // customer_customer_demo
    public class CustomerCustomerDemo
    {
        public string CustomerId { get; set; } // customer_id (Primary key) (length: 5)
        public string CustomerTypeId { get; set; } // customer_type_id (Primary key) (length: 5)

        // Foreign keys

        /// <summary>
        /// Parent Customer pointed by [customer_customer_demo].([CustomerId]) (fk_customer_customer_demo_customers)
        /// </summary>
        public virtual Customer Customer { get; set; } // fk_customer_customer_demo_customers

        /// <summary>
        /// Parent CustomerDemographic pointed by [customer_customer_demo].([CustomerTypeId]) (fk_customer_customer_demo_customer_demographics)
        /// </summary>
        public virtual CustomerDemographic CustomerDemographic { get; set; } // fk_customer_customer_demo_customer_demographics
    }

    // customer_demographics
    public class CustomerDemographic
    {
        public string CustomerTypeId { get; set; } // customer_type_id (Primary key) (length: 5)
        public string CustomerDesc { get; set; } // customer_desc

        // Reverse navigation

        /// <summary>
        /// Child CustomerCustomerDemoes where [customer_customer_demo].[customer_type_id] point to this entity (fk_customer_customer_demo_customer_demographics)
        /// </summary>
        public virtual ICollection<CustomerCustomerDemo> CustomerCustomerDemoes { get; set; } // customer_customer_demo.fk_customer_customer_demo_customer_demographics

        public CustomerDemographic()
        {
            CustomerCustomerDemoes = new List<CustomerCustomerDemo>();
        }
    }

    // employees
    public class Employee
    {
        public short EmployeeId { get; set; } // employee_id (Primary key)
        public string LastName { get; set; } // last_name (length: 20)
        public string FirstName { get; set; } // first_name (length: 10)
        public string Title { get; set; } // title (length: 30)
        public string TitleOfCourtesy { get; set; } // title_of_courtesy (length: 25)
        public DateTime? BirthDate { get; set; } // birth_date
        public DateTime? HireDate { get; set; } // hire_date
        public string Address { get; set; } // address (length: 60)
        public string City { get; set; } // city (length: 15)
        public string Region { get; set; } // region (length: 15)
        public string PostalCode { get; set; } // postal_code (length: 10)
        public string Country { get; set; } // country (length: 15)
        public string HomePhone { get; set; } // home_phone (length: 24)
        public string Extension { get; set; } // extension (length: 4)
        public byte[] Photo { get; set; } // photo
        public string Notes { get; set; } // notes
        public short? ReportsTo { get; set; } // reports_to
        public string PhotoPath { get; set; } // photo_path (length: 255)

        // Reverse navigation

        /// <summary>
        /// Child Employees where [employees].[reports_to] point to this entity (fk_employees_employees)
        /// </summary>
        public virtual ICollection<Employee> Employees { get; set; } // employees.fk_employees_employees

        /// <summary>
        /// Child EmployeeTerritories where [employee_territories].[employee_id] point to this entity (fk_employee_territories_employees)
        /// </summary>
        public virtual ICollection<EmployeeTerritory> EmployeeTerritories { get; set; } // employee_territories.fk_employee_territories_employees

        /// <summary>
        /// Child Orders where [orders].[employee_id] point to this entity (fk_orders_employees)
        /// </summary>
        public virtual ICollection<Order> Orders { get; set; } // orders.fk_orders_employees

        // Foreign keys

        /// <summary>
        /// Parent Employee pointed by [employees].([ReportsTo]) (fk_employees_employees)
        /// </summary>
        public virtual Employee Employee_ReportsTo { get; set; } // fk_employees_employees

        public Employee()
        {
            Orders = new List<Order>();
            EmployeeTerritories = new List<EmployeeTerritory>();
            Employees = new List<Employee>();
        }
    }

    // employee_territories
    public class EmployeeTerritory
    {
        public short EmployeeId { get; set; } // employee_id (Primary key)
        public string TerritoryId { get; set; } // territory_id (Primary key) (length: 20)

        // Foreign keys

        /// <summary>
        /// Parent Employee pointed by [employee_territories].([EmployeeId]) (fk_employee_territories_employees)
        /// </summary>
        public virtual Employee Employee { get; set; } // fk_employee_territories_employees

        /// <summary>
        /// Parent Territory pointed by [employee_territories].([TerritoryId]) (fk_employee_territories_territories)
        /// </summary>
        public virtual Territory Territory { get; set; } // fk_employee_territories_territories
    }

    // orders
    public class Order
    {
        public short OrderId { get; set; } // order_id (Primary key)
        public string CustomerId { get; set; } // customer_id (length: 5)
        public short? EmployeeId { get; set; } // employee_id
        public DateTime? OrderDate { get; set; } // order_date
        public DateTime? RequiredDate { get; set; } // required_date
        public DateTime? ShippedDate { get; set; } // shipped_date
        public short? ShipVia { get; set; } // ship_via
        public float? Freight { get; set; } // freight
        public string ShipName { get; set; } // ship_name (length: 40)
        public string ShipAddress { get; set; } // ship_address (length: 60)
        public string ShipCity { get; set; } // ship_city (length: 15)
        public string ShipRegion { get; set; } // ship_region (length: 15)
        public string ShipPostalCode { get; set; } // ship_postal_code (length: 10)
        public string ShipCountry { get; set; } // ship_country (length: 15)

        // Reverse navigation

        /// <summary>
        /// Child OrderDetails where [order_details].[order_id] point to this entity (fk_order_details_orders)
        /// </summary>
        public virtual ICollection<OrderDetail> OrderDetails { get; set; } // order_details.fk_order_details_orders

        // Foreign keys

        /// <summary>
        /// Parent Customer pointed by [orders].([CustomerId]) (fk_orders_customers)
        /// </summary>
        public virtual Customer Customer { get; set; } // fk_orders_customers

        /// <summary>
        /// Parent Employee pointed by [orders].([EmployeeId]) (fk_orders_employees)
        /// </summary>
        public virtual Employee Employee { get; set; } // fk_orders_employees

        /// <summary>
        /// Parent Shipper pointed by [orders].([ShipVia]) (fk_orders_shippers)
        /// </summary>
        public virtual Shipper Shipper { get; set; } // fk_orders_shippers

        public Order()
        {
            OrderDetails = new List<OrderDetail>();
        }
    }

    // order_details
    public class OrderDetail
    {
        public short OrderId { get; set; } // order_id (Primary key)
        public short ProductId { get; set; } // product_id (Primary key)
        public float UnitPrice { get; set; } // unit_price
        public short Quantity { get; set; } // quantity
        public float Discount { get; set; } // discount

        // Foreign keys

        /// <summary>
        /// Parent Order pointed by [order_details].([OrderId]) (fk_order_details_orders)
        /// </summary>
        public virtual Order Order { get; set; } // fk_order_details_orders

        /// <summary>
        /// Parent Product pointed by [order_details].([ProductId]) (fk_order_details_products)
        /// </summary>
        public virtual Product Product { get; set; } // fk_order_details_products
    }

    // products
    public class Product
    {
        public short ProductId { get; set; } // product_id (Primary key)
        public string ProductName { get; set; } // product_name (length: 40)
        public short? SupplierId { get; set; } // supplier_id
        public short? CategoryId { get; set; } // category_id
        public string QuantityPerUnit { get; set; } // quantity_per_unit (length: 20)
        public float? UnitPrice { get; set; } // unit_price
        public short? UnitsInStock { get; set; } // units_in_stock
        public short? UnitsOnOrder { get; set; } // units_on_order
        public short? ReorderLevel { get; set; } // reorder_level
        public int Discontinued { get; set; } // discontinued

        // Reverse navigation

        /// <summary>
        /// Child OrderDetails where [order_details].[product_id] point to this entity (fk_order_details_products)
        /// </summary>
        public virtual ICollection<OrderDetail> OrderDetails { get; set; } // order_details.fk_order_details_products

        // Foreign keys

        /// <summary>
        /// Parent Category pointed by [products].([CategoryId]) (fk_products_categories)
        /// </summary>
        public virtual Category Category { get; set; } // fk_products_categories

        /// <summary>
        /// Parent Supplier pointed by [products].([SupplierId]) (fk_products_suppliers)
        /// </summary>
        public virtual Supplier Supplier { get; set; } // fk_products_suppliers

        public Product()
        {
            OrderDetails = new List<OrderDetail>();
        }
    }

    // region
    public class Region
    {
        public short RegionId { get; set; } // region_id (Primary key)
        public string RegionDescription { get; set; } // region_description (length: 60)

        // Reverse navigation

        /// <summary>
        /// Child Territories where [territories].[region_id] point to this entity (fk_territories_region)
        /// </summary>
        public virtual ICollection<Territory> Territories { get; set; } // territories.fk_territories_region

        public Region()
        {
            Territories = new List<Territory>();
        }
    }

    // shippers
    public class Shipper
    {
        public short ShipperId { get; set; } // shipper_id (Primary key)
        public string CompanyName { get; set; } // company_name (length: 40)
        public string Phone { get; set; } // phone (length: 24)

        // Reverse navigation

        /// <summary>
        /// Child Orders where [orders].[ship_via] point to this entity (fk_orders_shippers)
        /// </summary>
        public virtual ICollection<Order> Orders { get; set; } // orders.fk_orders_shippers

        public Shipper()
        {
            Orders = new List<Order>();
        }
    }

    // suppliers
    public class Supplier
    {
        public short SupplierId { get; set; } // supplier_id (Primary key)
        public string CompanyName { get; set; } // company_name (length: 40)
        public string ContactName { get; set; } // contact_name (length: 30)
        public string ContactTitle { get; set; } // contact_title (length: 30)
        public string Address { get; set; } // address (length: 60)
        public string City { get; set; } // city (length: 15)
        public string Region { get; set; } // region (length: 15)
        public string PostalCode { get; set; } // postal_code (length: 10)
        public string Country { get; set; } // country (length: 15)
        public string Phone { get; set; } // phone (length: 24)
        public string Fax { get; set; } // fax (length: 24)
        public string Homepage { get; set; } // homepage

        // Reverse navigation

        /// <summary>
        /// Child Products where [products].[supplier_id] point to this entity (fk_products_suppliers)
        /// </summary>
        public virtual ICollection<Product> Products { get; set; } // products.fk_products_suppliers

        public Supplier()
        {
            Products = new List<Product>();
        }
    }

    // territories
    public class Territory
    {
        public string TerritoryId { get; set; } // territory_id (Primary key) (length: 20)
        public string TerritoryDescription { get; set; } // territory_description (length: 60)
        public short RegionId { get; set; } // region_id

        // Reverse navigation

        /// <summary>
        /// Child EmployeeTerritories where [employee_territories].[territory_id] point to this entity (fk_employee_territories_territories)
        /// </summary>
        public virtual ICollection<EmployeeTerritory> EmployeeTerritories { get; set; } // employee_territories.fk_employee_territories_territories

        // Foreign keys

        /// <summary>
        /// Parent Region pointed by [territories].([RegionId]) (fk_territories_region)
        /// </summary>
        public virtual Region Region { get; set; } // fk_territories_region

        public Territory()
        {
            EmployeeTerritories = new List<EmployeeTerritory>();
        }
    }

    // us_states
    public class UsState
    {
        public short StateId { get; set; } // state_id (Primary key)
        public string StateName { get; set; } // state_name (length: 100)
        public string StateAbbr { get; set; } // state_abbr (length: 2)
        public string StateRegion { get; set; } // state_region (length: 50)
    }


    #endregion

    #region POCO Configuration

    // categories
    public class CategoryConfiguration : IEntityTypeConfiguration<Category>
    {
        public void Configure(EntityTypeBuilder<Category> builder)
        {
            builder.ToTable("categories", "public");
            builder.HasKey(x => x.CategoryId).HasName("pk_categories");

            builder.Property(x => x.CategoryId).HasColumnName(@"category_id").HasColumnType("smallint").IsRequired().ValueGeneratedNever();
            builder.Property(x => x.CategoryName).HasColumnName(@"category_name").HasColumnType("character varying(15)").IsRequired().HasMaxLength(15);
            builder.Property(x => x.Description).HasColumnName(@"description").HasColumnType("text").IsRequired(false).IsUnicode(false);
            builder.Property(x => x.Picture).HasColumnName(@"picture").HasColumnType("bytea").IsRequired(false);
        }
    }

    // customers
    public class CustomerConfiguration : IEntityTypeConfiguration<Customer>
    {
        public void Configure(EntityTypeBuilder<Customer> builder)
        {
            builder.ToTable("customers", "public");
            builder.HasKey(x => x.CustomerId).HasName("pk_customers");

            builder.Property(x => x.CustomerId).HasColumnName(@"customer_id").HasColumnType("character varying(5)").IsRequired().HasMaxLength(5).ValueGeneratedNever();
            builder.Property(x => x.CompanyName).HasColumnName(@"company_name").HasColumnType("character varying(40)").IsRequired().HasMaxLength(40);
            builder.Property(x => x.ContactName).HasColumnName(@"contact_name").HasColumnType("character varying(30)").IsRequired(false).HasMaxLength(30);
            builder.Property(x => x.ContactTitle).HasColumnName(@"contact_title").HasColumnType("character varying(30)").IsRequired(false).HasMaxLength(30);
            builder.Property(x => x.Address).HasColumnName(@"address").HasColumnType("character varying(60)").IsRequired(false).HasMaxLength(60);
            builder.Property(x => x.City).HasColumnName(@"city").HasColumnType("character varying(15)").IsRequired(false).HasMaxLength(15);
            builder.Property(x => x.Region).HasColumnName(@"region").HasColumnType("character varying(15)").IsRequired(false).HasMaxLength(15);
            builder.Property(x => x.PostalCode).HasColumnName(@"postal_code").HasColumnType("character varying(10)").IsRequired(false).HasMaxLength(10);
            builder.Property(x => x.Country).HasColumnName(@"country").HasColumnType("character varying(15)").IsRequired(false).HasMaxLength(15);
            builder.Property(x => x.Phone).HasColumnName(@"phone").HasColumnType("character varying(24)").IsRequired(false).HasMaxLength(24);
            builder.Property(x => x.Fax).HasColumnName(@"fax").HasColumnType("character varying(24)").IsRequired(false).HasMaxLength(24);
        }
    }

    // customer_customer_demo
    public class CustomerCustomerDemoConfiguration : IEntityTypeConfiguration<CustomerCustomerDemo>
    {
        public void Configure(EntityTypeBuilder<CustomerCustomerDemo> builder)
        {
            builder.ToTable("customer_customer_demo", "public");
            builder.HasKey(x => new { x.CustomerId, x.CustomerTypeId }).HasName("pk_customer_customer_demo");

            builder.Property(x => x.CustomerId).HasColumnName(@"customer_id").HasColumnType("character varying(5)").IsRequired().HasMaxLength(5).ValueGeneratedNever();
            builder.Property(x => x.CustomerTypeId).HasColumnName(@"customer_type_id").HasColumnType("character varying(5)").IsRequired().HasMaxLength(5).ValueGeneratedNever();

            // Foreign keys
            builder.HasOne(a => a.Customer).WithMany(b => b.CustomerCustomerDemoes).HasForeignKey(c => c.CustomerId).OnDelete(DeleteBehavior.ClientSetNull).HasConstraintName("fk_customer_customer_demo_customers");
            builder.HasOne(a => a.CustomerDemographic).WithMany(b => b.CustomerCustomerDemoes).HasForeignKey(c => c.CustomerTypeId).OnDelete(DeleteBehavior.ClientSetNull).HasConstraintName("fk_customer_customer_demo_customer_demographics");
        }
    }

    // customer_demographics
    public class CustomerDemographicConfiguration : IEntityTypeConfiguration<CustomerDemographic>
    {
        public void Configure(EntityTypeBuilder<CustomerDemographic> builder)
        {
            builder.ToTable("customer_demographics", "public");
            builder.HasKey(x => x.CustomerTypeId).HasName("pk_customer_demographics");

            builder.Property(x => x.CustomerTypeId).HasColumnName(@"customer_type_id").HasColumnType("character varying(5)").IsRequired().HasMaxLength(5).ValueGeneratedNever();
            builder.Property(x => x.CustomerDesc).HasColumnName(@"customer_desc").HasColumnType("text").IsRequired(false).IsUnicode(false);
        }
    }

    // employees
    public class EmployeeConfiguration : IEntityTypeConfiguration<Employee>
    {
        public void Configure(EntityTypeBuilder<Employee> builder)
        {
            builder.ToTable("employees", "public");
            builder.HasKey(x => x.EmployeeId).HasName("pk_employees");

            builder.Property(x => x.EmployeeId).HasColumnName(@"employee_id").HasColumnType("smallint").IsRequired().ValueGeneratedNever();
            builder.Property(x => x.LastName).HasColumnName(@"last_name").HasColumnType("character varying(20)").IsRequired().HasMaxLength(20);
            builder.Property(x => x.FirstName).HasColumnName(@"first_name").HasColumnType("character varying(10)").IsRequired().HasMaxLength(10);
            builder.Property(x => x.Title).HasColumnName(@"title").HasColumnType("character varying(30)").IsRequired(false).HasMaxLength(30);
            builder.Property(x => x.TitleOfCourtesy).HasColumnName(@"title_of_courtesy").HasColumnType("character varying(25)").IsRequired(false).HasMaxLength(25);
            builder.Property(x => x.BirthDate).HasColumnName(@"birth_date").HasColumnType("date").IsRequired(false);
            builder.Property(x => x.HireDate).HasColumnName(@"hire_date").HasColumnType("date").IsRequired(false);
            builder.Property(x => x.Address).HasColumnName(@"address").HasColumnType("character varying(60)").IsRequired(false).HasMaxLength(60);
            builder.Property(x => x.City).HasColumnName(@"city").HasColumnType("character varying(15)").IsRequired(false).HasMaxLength(15);
            builder.Property(x => x.Region).HasColumnName(@"region").HasColumnType("character varying(15)").IsRequired(false).HasMaxLength(15);
            builder.Property(x => x.PostalCode).HasColumnName(@"postal_code").HasColumnType("character varying(10)").IsRequired(false).HasMaxLength(10);
            builder.Property(x => x.Country).HasColumnName(@"country").HasColumnType("character varying(15)").IsRequired(false).HasMaxLength(15);
            builder.Property(x => x.HomePhone).HasColumnName(@"home_phone").HasColumnType("character varying(24)").IsRequired(false).HasMaxLength(24);
            builder.Property(x => x.Extension).HasColumnName(@"extension").HasColumnType("character varying(4)").IsRequired(false).HasMaxLength(4);
            builder.Property(x => x.Photo).HasColumnName(@"photo").HasColumnType("bytea").IsRequired(false);
            builder.Property(x => x.Notes).HasColumnName(@"notes").HasColumnType("text").IsRequired(false).IsUnicode(false);
            builder.Property(x => x.ReportsTo).HasColumnName(@"reports_to").HasColumnType("smallint").IsRequired(false);
            builder.Property(x => x.PhotoPath).HasColumnName(@"photo_path").HasColumnType("character varying(255)").IsRequired(false).HasMaxLength(255);

            // Foreign keys
            builder.HasOne(a => a.Employee_ReportsTo).WithMany(b => b.Employees).HasForeignKey(c => c.ReportsTo).OnDelete(DeleteBehavior.ClientSetNull).HasConstraintName("fk_employees_employees");
        }
    }

    // employee_territories
    public class EmployeeTerritoryConfiguration : IEntityTypeConfiguration<EmployeeTerritory>
    {
        public void Configure(EntityTypeBuilder<EmployeeTerritory> builder)
        {
            builder.ToTable("employee_territories", "public");
            builder.HasKey(x => new { x.EmployeeId, x.TerritoryId }).HasName("pk_employee_territories");

            builder.Property(x => x.EmployeeId).HasColumnName(@"employee_id").HasColumnType("smallint").IsRequired().ValueGeneratedNever();
            builder.Property(x => x.TerritoryId).HasColumnName(@"territory_id").HasColumnType("character varying(20)").IsRequired().HasMaxLength(20).ValueGeneratedNever();

            // Foreign keys
            builder.HasOne(a => a.Employee).WithMany(b => b.EmployeeTerritories).HasForeignKey(c => c.EmployeeId).OnDelete(DeleteBehavior.ClientSetNull).HasConstraintName("fk_employee_territories_employees");
            builder.HasOne(a => a.Territory).WithMany(b => b.EmployeeTerritories).HasForeignKey(c => c.TerritoryId).OnDelete(DeleteBehavior.ClientSetNull).HasConstraintName("fk_employee_territories_territories");
        }
    }

    // orders
    public class OrderConfiguration : IEntityTypeConfiguration<Order>
    {
        public void Configure(EntityTypeBuilder<Order> builder)
        {
            builder.ToTable("orders", "public");
            builder.HasKey(x => x.OrderId).HasName("pk_orders");

            builder.Property(x => x.OrderId).HasColumnName(@"order_id").HasColumnType("smallint").IsRequired().ValueGeneratedNever();
            builder.Property(x => x.CustomerId).HasColumnName(@"customer_id").HasColumnType("character varying(5)").IsRequired(false).HasMaxLength(5);
            builder.Property(x => x.EmployeeId).HasColumnName(@"employee_id").HasColumnType("smallint").IsRequired(false);
            builder.Property(x => x.OrderDate).HasColumnName(@"order_date").HasColumnType("date").IsRequired(false);
            builder.Property(x => x.RequiredDate).HasColumnName(@"required_date").HasColumnType("date").IsRequired(false);
            builder.Property(x => x.ShippedDate).HasColumnName(@"shipped_date").HasColumnType("date").IsRequired(false);
            builder.Property(x => x.ShipVia).HasColumnName(@"ship_via").HasColumnType("smallint").IsRequired(false);
            builder.Property(x => x.Freight).HasColumnName(@"freight").HasColumnType("real").IsRequired(false);
            builder.Property(x => x.ShipName).HasColumnName(@"ship_name").HasColumnType("character varying(40)").IsRequired(false).HasMaxLength(40);
            builder.Property(x => x.ShipAddress).HasColumnName(@"ship_address").HasColumnType("character varying(60)").IsRequired(false).HasMaxLength(60);
            builder.Property(x => x.ShipCity).HasColumnName(@"ship_city").HasColumnType("character varying(15)").IsRequired(false).HasMaxLength(15);
            builder.Property(x => x.ShipRegion).HasColumnName(@"ship_region").HasColumnType("character varying(15)").IsRequired(false).HasMaxLength(15);
            builder.Property(x => x.ShipPostalCode).HasColumnName(@"ship_postal_code").HasColumnType("character varying(10)").IsRequired(false).HasMaxLength(10);
            builder.Property(x => x.ShipCountry).HasColumnName(@"ship_country").HasColumnType("character varying(15)").IsRequired(false).HasMaxLength(15);

            // Foreign keys
            builder.HasOne(a => a.Customer).WithMany(b => b.Orders).HasForeignKey(c => c.CustomerId).OnDelete(DeleteBehavior.ClientSetNull).HasConstraintName("fk_orders_customers");
            builder.HasOne(a => a.Employee).WithMany(b => b.Orders).HasForeignKey(c => c.EmployeeId).OnDelete(DeleteBehavior.ClientSetNull).HasConstraintName("fk_orders_employees");
            builder.HasOne(a => a.Shipper).WithMany(b => b.Orders).HasForeignKey(c => c.ShipVia).OnDelete(DeleteBehavior.ClientSetNull).HasConstraintName("fk_orders_shippers");
        }
    }

    // order_details
    public class OrderDetailConfiguration : IEntityTypeConfiguration<OrderDetail>
    {
        public void Configure(EntityTypeBuilder<OrderDetail> builder)
        {
            builder.ToTable("order_details", "public");
            builder.HasKey(x => new { x.OrderId, x.ProductId }).HasName("pk_order_details");

            builder.Property(x => x.OrderId).HasColumnName(@"order_id").HasColumnType("smallint").IsRequired().ValueGeneratedNever();
            builder.Property(x => x.ProductId).HasColumnName(@"product_id").HasColumnType("smallint").IsRequired().ValueGeneratedNever();
            builder.Property(x => x.UnitPrice).HasColumnName(@"unit_price").HasColumnType("real").IsRequired();
            builder.Property(x => x.Quantity).HasColumnName(@"quantity").HasColumnType("smallint").IsRequired();
            builder.Property(x => x.Discount).HasColumnName(@"discount").HasColumnType("real").IsRequired();

            // Foreign keys
            builder.HasOne(a => a.Order).WithMany(b => b.OrderDetails).HasForeignKey(c => c.OrderId).OnDelete(DeleteBehavior.ClientSetNull).HasConstraintName("fk_order_details_orders");
            builder.HasOne(a => a.Product).WithMany(b => b.OrderDetails).HasForeignKey(c => c.ProductId).OnDelete(DeleteBehavior.ClientSetNull).HasConstraintName("fk_order_details_products");
        }
    }

    // products
    public class ProductConfiguration : IEntityTypeConfiguration<Product>
    {
        public void Configure(EntityTypeBuilder<Product> builder)
        {
            builder.ToTable("products", "public");
            builder.HasKey(x => x.ProductId).HasName("pk_products");

            builder.Property(x => x.ProductId).HasColumnName(@"product_id").HasColumnType("smallint").IsRequired().ValueGeneratedNever();
            builder.Property(x => x.ProductName).HasColumnName(@"product_name").HasColumnType("character varying(40)").IsRequired().HasMaxLength(40);
            builder.Property(x => x.SupplierId).HasColumnName(@"supplier_id").HasColumnType("smallint").IsRequired(false);
            builder.Property(x => x.CategoryId).HasColumnName(@"category_id").HasColumnType("smallint").IsRequired(false);
            builder.Property(x => x.QuantityPerUnit).HasColumnName(@"quantity_per_unit").HasColumnType("character varying(20)").IsRequired(false).HasMaxLength(20);
            builder.Property(x => x.UnitPrice).HasColumnName(@"unit_price").HasColumnType("real").IsRequired(false);
            builder.Property(x => x.UnitsInStock).HasColumnName(@"units_in_stock").HasColumnType("smallint").IsRequired(false);
            builder.Property(x => x.UnitsOnOrder).HasColumnName(@"units_on_order").HasColumnType("smallint").IsRequired(false);
            builder.Property(x => x.ReorderLevel).HasColumnName(@"reorder_level").HasColumnType("smallint").IsRequired(false);
            builder.Property(x => x.Discontinued).HasColumnName(@"discontinued").HasColumnType("integer").IsRequired();

            // Foreign keys
            builder.HasOne(a => a.Category).WithMany(b => b.Products).HasForeignKey(c => c.CategoryId).OnDelete(DeleteBehavior.ClientSetNull).HasConstraintName("fk_products_categories");
            builder.HasOne(a => a.Supplier).WithMany(b => b.Products).HasForeignKey(c => c.SupplierId).OnDelete(DeleteBehavior.ClientSetNull).HasConstraintName("fk_products_suppliers");
        }
    }

    // region
    public class RegionConfiguration : IEntityTypeConfiguration<Region>
    {
        public void Configure(EntityTypeBuilder<Region> builder)
        {
            builder.ToTable("region", "public");
            builder.HasKey(x => x.RegionId).HasName("pk_region");

            builder.Property(x => x.RegionId).HasColumnName(@"region_id").HasColumnType("smallint").IsRequired().ValueGeneratedNever();
            builder.Property(x => x.RegionDescription).HasColumnName(@"region_description").HasColumnType("character varying(60)").IsRequired().HasMaxLength(60);
        }
    }

    // shippers
    public class ShipperConfiguration : IEntityTypeConfiguration<Shipper>
    {
        public void Configure(EntityTypeBuilder<Shipper> builder)
        {
            builder.ToTable("shippers", "public");
            builder.HasKey(x => x.ShipperId).HasName("pk_shippers");

            builder.Property(x => x.ShipperId).HasColumnName(@"shipper_id").HasColumnType("smallint").IsRequired().ValueGeneratedNever();
            builder.Property(x => x.CompanyName).HasColumnName(@"company_name").HasColumnType("character varying(40)").IsRequired().HasMaxLength(40);
            builder.Property(x => x.Phone).HasColumnName(@"phone").HasColumnType("character varying(24)").IsRequired(false).HasMaxLength(24);
        }
    }

    // suppliers
    public class SupplierConfiguration : IEntityTypeConfiguration<Supplier>
    {
        public void Configure(EntityTypeBuilder<Supplier> builder)
        {
            builder.ToTable("suppliers", "public");
            builder.HasKey(x => x.SupplierId).HasName("pk_suppliers");

            builder.Property(x => x.SupplierId).HasColumnName(@"supplier_id").HasColumnType("smallint").IsRequired().ValueGeneratedNever();
            builder.Property(x => x.CompanyName).HasColumnName(@"company_name").HasColumnType("character varying(40)").IsRequired().HasMaxLength(40);
            builder.Property(x => x.ContactName).HasColumnName(@"contact_name").HasColumnType("character varying(30)").IsRequired(false).HasMaxLength(30);
            builder.Property(x => x.ContactTitle).HasColumnName(@"contact_title").HasColumnType("character varying(30)").IsRequired(false).HasMaxLength(30);
            builder.Property(x => x.Address).HasColumnName(@"address").HasColumnType("character varying(60)").IsRequired(false).HasMaxLength(60);
            builder.Property(x => x.City).HasColumnName(@"city").HasColumnType("character varying(15)").IsRequired(false).HasMaxLength(15);
            builder.Property(x => x.Region).HasColumnName(@"region").HasColumnType("character varying(15)").IsRequired(false).HasMaxLength(15);
            builder.Property(x => x.PostalCode).HasColumnName(@"postal_code").HasColumnType("character varying(10)").IsRequired(false).HasMaxLength(10);
            builder.Property(x => x.Country).HasColumnName(@"country").HasColumnType("character varying(15)").IsRequired(false).HasMaxLength(15);
            builder.Property(x => x.Phone).HasColumnName(@"phone").HasColumnType("character varying(24)").IsRequired(false).HasMaxLength(24);
            builder.Property(x => x.Fax).HasColumnName(@"fax").HasColumnType("character varying(24)").IsRequired(false).HasMaxLength(24);
            builder.Property(x => x.Homepage).HasColumnName(@"homepage").HasColumnType("text").IsRequired(false).IsUnicode(false);
        }
    }

    // territories
    public class TerritoryConfiguration : IEntityTypeConfiguration<Territory>
    {
        public void Configure(EntityTypeBuilder<Territory> builder)
        {
            builder.ToTable("territories", "public");
            builder.HasKey(x => x.TerritoryId).HasName("pk_territories");

            builder.Property(x => x.TerritoryId).HasColumnName(@"territory_id").HasColumnType("character varying(20)").IsRequired().HasMaxLength(20).ValueGeneratedNever();
            builder.Property(x => x.TerritoryDescription).HasColumnName(@"territory_description").HasColumnType("character varying(60)").IsRequired().HasMaxLength(60);
            builder.Property(x => x.RegionId).HasColumnName(@"region_id").HasColumnType("smallint").IsRequired();

            // Foreign keys
            builder.HasOne(a => a.Region).WithMany(b => b.Territories).HasForeignKey(c => c.RegionId).OnDelete(DeleteBehavior.ClientSetNull).HasConstraintName("fk_territories_region");
        }
    }

    // us_states
    public class UsStateConfiguration : IEntityTypeConfiguration<UsState>
    {
        public void Configure(EntityTypeBuilder<UsState> builder)
        {
            builder.ToTable("us_states", "public");
            builder.HasKey(x => x.StateId).HasName("pk_usstates");

            builder.Property(x => x.StateId).HasColumnName(@"state_id").HasColumnType("smallint").IsRequired().ValueGeneratedNever();
            builder.Property(x => x.StateName).HasColumnName(@"state_name").HasColumnType("character varying(100)").IsRequired(false).HasMaxLength(100);
            builder.Property(x => x.StateAbbr).HasColumnName(@"state_abbr").HasColumnType("character varying(2)").IsRequired(false).HasMaxLength(2);
            builder.Property(x => x.StateRegion).HasColumnName(@"state_region").HasColumnType("character varying(50)").IsRequired(false).HasMaxLength(50);
        }
    }


    #endregion

}
// </auto-generated>
