// <auto-generated>

using Microsoft.Data.SqlClient;
using Microsoft.EntityFrameworkCore;
using Microsoft.EntityFrameworkCore.ChangeTracking;
using Microsoft.EntityFrameworkCore.Design;
using Microsoft.EntityFrameworkCore.Infrastructure;
using Microsoft.EntityFrameworkCore.Metadata.Builders;
using Microsoft.EntityFrameworkCore.Query;
using Microsoft.EntityFrameworkCore.Query.Internal;
using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.ComponentModel;
using System.Data;
using System.Data.SqlTypes;
using System.Linq;
using System.Linq.Expressions;
using System.Reflection;
using System.Threading;
using System.Threading.Tasks;

namespace Efrpg.PostgreSQL
{
    #region Database context interface

    public interface IMyDbContext : IDisposable
    {
        DbSet<AlphabeticalListOfProduct> AlphabeticalListOfProducts { get; set; } // Alphabetical list of products
        DbSet<Category> Categories { get; set; } // categories
        DbSet<CategorySalesFor1997> CategorySalesFor1997 { get; set; } // Category Sales for 1997
        DbSet<CurrentProductList> CurrentProductLists { get; set; } // Current Product List
        DbSet<Customer> Customers { get; set; } // customers
        DbSet<CustomerAndSuppliersByCity> CustomerAndSuppliersByCities { get; set; } // Customer and Suppliers by City
        DbSet<Customercustomerdemo> Customercustomerdemoes { get; set; } // customercustomerdemo
        DbSet<Customerdemographic> Customerdemographics { get; set; } // customerdemographics
        DbSet<Employee> Employees { get; set; } // employees
        DbSet<Employeeterritory> Employeeterritories { get; set; } // employeeterritories
        DbSet<Invoice> Invoices { get; set; } // Invoices
        DbSet<Order> Orders { get; set; } // orders
        DbSet<OrderDetail> OrderDetails { get; set; } // order_details
        DbSet<OrderDetailsExtended> OrderDetailsExtendeds { get; set; } // Order Details Extended
        DbSet<OrdersQry> OrdersQries { get; set; } // Orders Qry
        DbSet<OrderSubtotal> OrderSubtotals { get; set; } // Order Subtotals
        DbSet<Product> Products { get; set; } // products
        DbSet<ProductsAboveAveragePrice> ProductsAboveAveragePrices { get; set; } // Products Above Average Price
        DbSet<ProductSalesFor1997> ProductSalesFor1997 { get; set; } // Product Sales for 1997
        DbSet<ProductsByCategory> ProductsByCategories { get; set; } // Products by Category
        DbSet<QuarterlyOrder> QuarterlyOrders { get; set; } // Quarterly Orders
        DbSet<Region> Regions { get; set; } // region
        DbSet<SalesByCategory> SalesByCategories { get; set; } // Sales by Category
        DbSet<SalesTotalsByAmount> SalesTotalsByAmounts { get; set; } // Sales Totals by Amount
        DbSet<Shipper> Shippers { get; set; } // shippers
        DbSet<ShippersTmp> ShippersTmps { get; set; } // shippers_tmp
        DbSet<SummaryOfSalesByQuarter> SummaryOfSalesByQuarters { get; set; } // Summary of Sales by Quarter
        DbSet<SummaryOfSalesByYear> SummaryOfSalesByYears { get; set; } // Summary of Sales by Year
        DbSet<Supplier> Suppliers { get; set; } // suppliers
        DbSet<Territory> Territories { get; set; } // territories
        DbSet<Usstate> Usstates { get; set; } // usstates

        int SaveChanges();
        int SaveChanges(bool acceptAllChangesOnSuccess);
        Task<int> SaveChangesAsync(CancellationToken cancellationToken = default(CancellationToken));
        Task<int> SaveChangesAsync(bool acceptAllChangesOnSuccess, CancellationToken cancellationToken = default(CancellationToken));
        DatabaseFacade Database { get; }
        DbSet<TEntity> Set<TEntity>() where TEntity : class;
        string ToString();

        // Stored Procedures
        int CustOrdersOrders(string p1);
        // CustOrdersOrdersAsync() cannot be created due to having out parameters, or is relying on the procedure result (int)

        int EmployeeSalesByCountry(DateTime? p1, DateTime? p2);
        // EmployeeSalesByCountryAsync() cannot be created due to having out parameters, or is relying on the procedure result (int)

        int SalesByCategory(string cn, string ordYear);
        // SalesByCategoryAsync() cannot be created due to having out parameters, or is relying on the procedure result (int)

        int SalesByYear(DateTime? p1, DateTime? p2);
        // SalesByYearAsync() cannot be created due to having out parameters, or is relying on the procedure result (int)

        int TenMostExpensiveProducts();
        // TenMostExpensiveProductsAsync() cannot be created due to having out parameters, or is relying on the procedure result (int)


        // Scalar Valued Functions
        string CustOrderHist(string customerId); // public.CustOrderHist
        string CustOrdersDetail(int? p1); // public.CustOrdersDetail
    }

    #endregion

    #region Database context

    public class MyDbContext : DbContext, IMyDbContext
    {
        public MyDbContext()
        {
        }

        public MyDbContext(DbContextOptions<MyDbContext> options)
            : base(options)
        {
        }

        public DbSet<AlphabeticalListOfProduct> AlphabeticalListOfProducts { get; set; } // Alphabetical list of products
        public DbSet<Category> Categories { get; set; } // categories
        public DbSet<CategorySalesFor1997> CategorySalesFor1997 { get; set; } // Category Sales for 1997
        public DbSet<CurrentProductList> CurrentProductLists { get; set; } // Current Product List
        public DbSet<Customer> Customers { get; set; } // customers
        public DbSet<CustomerAndSuppliersByCity> CustomerAndSuppliersByCities { get; set; } // Customer and Suppliers by City
        public DbSet<Customercustomerdemo> Customercustomerdemoes { get; set; } // customercustomerdemo
        public DbSet<Customerdemographic> Customerdemographics { get; set; } // customerdemographics
        public DbSet<Employee> Employees { get; set; } // employees
        public DbSet<Employeeterritory> Employeeterritories { get; set; } // employeeterritories
        public DbSet<Invoice> Invoices { get; set; } // Invoices
        public DbSet<Order> Orders { get; set; } // orders
        public DbSet<OrderDetail> OrderDetails { get; set; } // order_details
        public DbSet<OrderDetailsExtended> OrderDetailsExtendeds { get; set; } // Order Details Extended
        public DbSet<OrdersQry> OrdersQries { get; set; } // Orders Qry
        public DbSet<OrderSubtotal> OrderSubtotals { get; set; } // Order Subtotals
        public DbSet<Product> Products { get; set; } // products
        public DbSet<ProductsAboveAveragePrice> ProductsAboveAveragePrices { get; set; } // Products Above Average Price
        public DbSet<ProductSalesFor1997> ProductSalesFor1997 { get; set; } // Product Sales for 1997
        public DbSet<ProductsByCategory> ProductsByCategories { get; set; } // Products by Category
        public DbSet<QuarterlyOrder> QuarterlyOrders { get; set; } // Quarterly Orders
        public DbSet<Region> Regions { get; set; } // region
        public DbSet<SalesByCategory> SalesByCategories { get; set; } // Sales by Category
        public DbSet<SalesTotalsByAmount> SalesTotalsByAmounts { get; set; } // Sales Totals by Amount
        public DbSet<Shipper> Shippers { get; set; } // shippers
        public DbSet<ShippersTmp> ShippersTmps { get; set; } // shippers_tmp
        public DbSet<SummaryOfSalesByQuarter> SummaryOfSalesByQuarters { get; set; } // Summary of Sales by Quarter
        public DbSet<SummaryOfSalesByYear> SummaryOfSalesByYears { get; set; } // Summary of Sales by Year
        public DbSet<Supplier> Suppliers { get; set; } // suppliers
        public DbSet<Territory> Territories { get; set; } // territories
        public DbSet<Usstate> Usstates { get; set; } // usstates

        protected override void OnConfiguring(DbContextOptionsBuilder optionsBuilder)
        {
            if (!optionsBuilder.IsConfigured)
            {
                optionsBuilder.UseSqlServer(@"Server=127.0.0.1;Port=5433;Database=Northwind;User Id=testuser;Password=testtesttest;");
            }
        }

        public bool IsSqlParameterNull(SqlParameter param)
        {
            var sqlValue = param.SqlValue;
            var nullableValue = sqlValue as INullable;
            if (nullableValue != null)
                return nullableValue.IsNull;
            return (sqlValue == null || sqlValue == DBNull.Value);
        }

        protected override void OnModelCreating(ModelBuilder modelBuilder)
        {
            base.OnModelCreating(modelBuilder);

            modelBuilder.ApplyConfiguration(new AlphabeticalListOfProductConfiguration());
            modelBuilder.ApplyConfiguration(new CategoryConfiguration());
            modelBuilder.ApplyConfiguration(new CategorySalesFor1997Configuration());
            modelBuilder.ApplyConfiguration(new CurrentProductListConfiguration());
            modelBuilder.ApplyConfiguration(new CustomerConfiguration());
            modelBuilder.ApplyConfiguration(new CustomerAndSuppliersByCityConfiguration());
            modelBuilder.ApplyConfiguration(new CustomercustomerdemoConfiguration());
            modelBuilder.ApplyConfiguration(new CustomerdemographicConfiguration());
            modelBuilder.ApplyConfiguration(new EmployeeConfiguration());
            modelBuilder.ApplyConfiguration(new EmployeeterritoryConfiguration());
            modelBuilder.ApplyConfiguration(new InvoiceConfiguration());
            modelBuilder.ApplyConfiguration(new OrderConfiguration());
            modelBuilder.ApplyConfiguration(new OrderDetailConfiguration());
            modelBuilder.ApplyConfiguration(new OrderDetailsExtendedConfiguration());
            modelBuilder.ApplyConfiguration(new OrdersQryConfiguration());
            modelBuilder.ApplyConfiguration(new OrderSubtotalConfiguration());
            modelBuilder.ApplyConfiguration(new ProductConfiguration());
            modelBuilder.ApplyConfiguration(new ProductsAboveAveragePriceConfiguration());
            modelBuilder.ApplyConfiguration(new ProductSalesFor1997Configuration());
            modelBuilder.ApplyConfiguration(new ProductsByCategoryConfiguration());
            modelBuilder.ApplyConfiguration(new QuarterlyOrderConfiguration());
            modelBuilder.ApplyConfiguration(new RegionConfiguration());
            modelBuilder.ApplyConfiguration(new SalesByCategoryConfiguration());
            modelBuilder.ApplyConfiguration(new SalesTotalsByAmountConfiguration());
            modelBuilder.ApplyConfiguration(new ShipperConfiguration());
            modelBuilder.ApplyConfiguration(new ShippersTmpConfiguration());
            modelBuilder.ApplyConfiguration(new SummaryOfSalesByQuarterConfiguration());
            modelBuilder.ApplyConfiguration(new SummaryOfSalesByYearConfiguration());
            modelBuilder.ApplyConfiguration(new SupplierConfiguration());
            modelBuilder.ApplyConfiguration(new TerritoryConfiguration());
            modelBuilder.ApplyConfiguration(new UsstateConfiguration());

        }


        // Stored Procedures
        public int CustOrdersOrders(string p1)
        {
            var p1Param = new SqlParameter { ParameterName = "p1", SqlDbType = SqlDbType.character, Direction = ParameterDirection.Input, Value = p1 };
            if (p1Param.Value == null)
                p1Param.Value = DBNull.Value;

            var procResultParam = new SqlParameter { ParameterName = "@procResult", SqlDbType = SqlDbType.Int, Direction = ParameterDirection.Output };

            Database.ExecuteSqlRaw("EXEC @procResult = [public].[CustOrdersOrders] p1", p1Param, procResultParam);

            return (int)procResultParam.Value;
        }

        // CustOrdersOrdersAsync() cannot be created due to having out parameters, or is relying on the procedure result (int)

        public int EmployeeSalesByCountry(DateTime? p1, DateTime? p2)
        {
            var p1Param = new SqlParameter { ParameterName = "p1", SqlDbType = SqlDbType.date, Direction = ParameterDirection.Input, Value = p1.GetValueOrDefault() };
            if (!p1.HasValue)
                p1Param.Value = DBNull.Value;

            var p2Param = new SqlParameter { ParameterName = "p2", SqlDbType = SqlDbType.date, Direction = ParameterDirection.Input, Value = p2.GetValueOrDefault() };
            if (!p2.HasValue)
                p2Param.Value = DBNull.Value;

            var procResultParam = new SqlParameter { ParameterName = "@procResult", SqlDbType = SqlDbType.Int, Direction = ParameterDirection.Output };

            Database.ExecuteSqlRaw("EXEC @procResult = [public].[Employee Sales by Country] p1, p2", p1Param, p2Param, procResultParam);

            return (int)procResultParam.Value;
        }

        // EmployeeSalesByCountryAsync() cannot be created due to having out parameters, or is relying on the procedure result (int)

        public int SalesByCategory(string cn, string ordYear)
        {
            var cnParam = new SqlParameter { ParameterName = "cn", SqlDbType = SqlDbType.character, Direction = ParameterDirection.Input, Value = cn };
            if (cnParam.Value == null)
                cnParam.Value = DBNull.Value;

            var ordYearParam = new SqlParameter { ParameterName = "OrdYear", SqlDbType = SqlDbType.character, Direction = ParameterDirection.Input, Value = ordYear };
            if (ordYearParam.Value == null)
                ordYearParam.Value = DBNull.Value;

            var procResultParam = new SqlParameter { ParameterName = "@procResult", SqlDbType = SqlDbType.Int, Direction = ParameterDirection.Output };

            Database.ExecuteSqlRaw("EXEC @procResult = [public].[SalesByCategory] cn, OrdYear", cnParam, ordYearParam, procResultParam);

            return (int)procResultParam.Value;
        }

        // SalesByCategoryAsync() cannot be created due to having out parameters, or is relying on the procedure result (int)

        public int SalesByYear(DateTime? p1, DateTime? p2)
        {
            var p1Param = new SqlParameter { ParameterName = "p1", SqlDbType = SqlDbType.date, Direction = ParameterDirection.Input, Value = p1.GetValueOrDefault() };
            if (!p1.HasValue)
                p1Param.Value = DBNull.Value;

            var p2Param = new SqlParameter { ParameterName = "p2", SqlDbType = SqlDbType.date, Direction = ParameterDirection.Input, Value = p2.GetValueOrDefault() };
            if (!p2.HasValue)
                p2Param.Value = DBNull.Value;

            var procResultParam = new SqlParameter { ParameterName = "@procResult", SqlDbType = SqlDbType.Int, Direction = ParameterDirection.Output };

            Database.ExecuteSqlRaw("EXEC @procResult = [public].[Sales by Year] p1, p2", p1Param, p2Param, procResultParam);

            return (int)procResultParam.Value;
        }

        // SalesByYearAsync() cannot be created due to having out parameters, or is relying on the procedure result (int)

        public int TenMostExpensiveProducts()
        {
            var procResultParam = new SqlParameter { ParameterName = "@procResult", SqlDbType = SqlDbType.Int, Direction = ParameterDirection.Output };

            Database.ExecuteSqlRaw("EXEC @procResult = [public].[Ten Most Expensive Products] ", procResultParam);

            return (int)procResultParam.Value;
        }

        // TenMostExpensiveProductsAsync() cannot be created due to having out parameters, or is relying on the procedure result (int)


        // Scalar Valued Functions

        [DbFunction("CustOrderHist", "public")]
        public string CustOrderHist(string customerId)
        {
            throw new Exception("Don't call this directly. Use LINQ to call the scalar valued function as part of your query");
        }

        [DbFunction("CustOrdersDetail", "public")]
        public string CustOrdersDetail(int? p1)
        {
            throw new Exception("Don't call this directly. Use LINQ to call the scalar valued function as part of your query");
        }
    }

    #endregion

    #region Database context factory

    public class MyDbContextFactory : IDesignTimeDbContextFactory<MyDbContext>
    {
        public MyDbContext CreateDbContext(string[] args)
        {
            return new MyDbContext();
        }
    }

    #endregion

    #region Fake Database context

    public class FakeMyDbContext : IMyDbContext
    {
        public DbSet<AlphabeticalListOfProduct> AlphabeticalListOfProducts { get; set; } // Alphabetical list of products
        public DbSet<Category> Categories { get; set; } // categories
        public DbSet<CategorySalesFor1997> CategorySalesFor1997 { get; set; } // Category Sales for 1997
        public DbSet<CurrentProductList> CurrentProductLists { get; set; } // Current Product List
        public DbSet<Customer> Customers { get; set; } // customers
        public DbSet<CustomerAndSuppliersByCity> CustomerAndSuppliersByCities { get; set; } // Customer and Suppliers by City
        public DbSet<Customercustomerdemo> Customercustomerdemoes { get; set; } // customercustomerdemo
        public DbSet<Customerdemographic> Customerdemographics { get; set; } // customerdemographics
        public DbSet<Employee> Employees { get; set; } // employees
        public DbSet<Employeeterritory> Employeeterritories { get; set; } // employeeterritories
        public DbSet<Invoice> Invoices { get; set; } // Invoices
        public DbSet<Order> Orders { get; set; } // orders
        public DbSet<OrderDetail> OrderDetails { get; set; } // order_details
        public DbSet<OrderDetailsExtended> OrderDetailsExtendeds { get; set; } // Order Details Extended
        public DbSet<OrdersQry> OrdersQries { get; set; } // Orders Qry
        public DbSet<OrderSubtotal> OrderSubtotals { get; set; } // Order Subtotals
        public DbSet<Product> Products { get; set; } // products
        public DbSet<ProductsAboveAveragePrice> ProductsAboveAveragePrices { get; set; } // Products Above Average Price
        public DbSet<ProductSalesFor1997> ProductSalesFor1997 { get; set; } // Product Sales for 1997
        public DbSet<ProductsByCategory> ProductsByCategories { get; set; } // Products by Category
        public DbSet<QuarterlyOrder> QuarterlyOrders { get; set; } // Quarterly Orders
        public DbSet<Region> Regions { get; set; } // region
        public DbSet<SalesByCategory> SalesByCategories { get; set; } // Sales by Category
        public DbSet<SalesTotalsByAmount> SalesTotalsByAmounts { get; set; } // Sales Totals by Amount
        public DbSet<Shipper> Shippers { get; set; } // shippers
        public DbSet<ShippersTmp> ShippersTmps { get; set; } // shippers_tmp
        public DbSet<SummaryOfSalesByQuarter> SummaryOfSalesByQuarters { get; set; } // Summary of Sales by Quarter
        public DbSet<SummaryOfSalesByYear> SummaryOfSalesByYears { get; set; } // Summary of Sales by Year
        public DbSet<Supplier> Suppliers { get; set; } // suppliers
        public DbSet<Territory> Territories { get; set; } // territories
        public DbSet<Usstate> Usstates { get; set; } // usstates

        public FakeMyDbContext()
        {
            _database = null;

            AlphabeticalListOfProducts = new FakeDbSet<AlphabeticalListOfProduct>();
            Categories = new FakeDbSet<Category>("CategoryId");
            CategorySalesFor1997 = new FakeDbSet<CategorySalesFor1997>();
            CurrentProductLists = new FakeDbSet<CurrentProductList>();
            Customers = new FakeDbSet<Customer>("CustomerId");
            CustomerAndSuppliersByCities = new FakeDbSet<CustomerAndSuppliersByCity>();
            Customercustomerdemoes = new FakeDbSet<Customercustomerdemo>("CustomerId", "CustomerTypeId");
            Customerdemographics = new FakeDbSet<Customerdemographic>("CustomerTypeId");
            Employees = new FakeDbSet<Employee>("EmployeeId");
            Employeeterritories = new FakeDbSet<Employeeterritory>("EmployeeId", "TerritoryId");
            Invoices = new FakeDbSet<Invoice>();
            Orders = new FakeDbSet<Order>("OrderId");
            OrderDetails = new FakeDbSet<OrderDetail>("OrderId", "ProductId");
            OrderDetailsExtendeds = new FakeDbSet<OrderDetailsExtended>();
            OrdersQries = new FakeDbSet<OrdersQry>();
            OrderSubtotals = new FakeDbSet<OrderSubtotal>();
            Products = new FakeDbSet<Product>("ProductId");
            ProductsAboveAveragePrices = new FakeDbSet<ProductsAboveAveragePrice>();
            ProductSalesFor1997 = new FakeDbSet<ProductSalesFor1997>();
            ProductsByCategories = new FakeDbSet<ProductsByCategory>();
            QuarterlyOrders = new FakeDbSet<QuarterlyOrder>();
            Regions = new FakeDbSet<Region>("RegionId");
            SalesByCategories = new FakeDbSet<SalesByCategory>();
            SalesTotalsByAmounts = new FakeDbSet<SalesTotalsByAmount>();
            Shippers = new FakeDbSet<Shipper>("ShipperId");
            ShippersTmps = new FakeDbSet<ShippersTmp>("ShipperId");
            SummaryOfSalesByQuarters = new FakeDbSet<SummaryOfSalesByQuarter>();
            SummaryOfSalesByYears = new FakeDbSet<SummaryOfSalesByYear>();
            Suppliers = new FakeDbSet<Supplier>("SupplierId");
            Territories = new FakeDbSet<Territory>("TerritoryId");
            Usstates = new FakeDbSet<Usstate>("StateId");

        }

        public int SaveChangesCount { get; private set; }
        public virtual int SaveChanges()
        {
            ++SaveChangesCount;
            return 1;
        }

        public virtual int SaveChanges(bool acceptAllChangesOnSuccess)
        {
            return SaveChanges();
        }

        public virtual Task<int> SaveChangesAsync(CancellationToken cancellationToken)
        {
            ++SaveChangesCount;
            return Task<int>.Factory.StartNew(() => 1, cancellationToken);
        }
        public virtual Task<int> SaveChangesAsync(bool acceptAllChangesOnSuccess, CancellationToken cancellationToken)
        {
            ++SaveChangesCount;
            return Task<int>.Factory.StartNew(x => 1, acceptAllChangesOnSuccess, cancellationToken);
        }

        protected virtual void Dispose(bool disposing)
        {
        }

        public void Dispose()
        {
            Dispose(true);
        }

        private DatabaseFacade _database;
        public DatabaseFacade Database { get { return _database; } }

        public DbSet<TEntity> Set<TEntity>() where TEntity : class
        {
            throw new NotImplementedException();
        }

        public override string ToString()
        {
            throw new NotImplementedException();
        }

        // Stored Procedures

        public int CustOrdersOrders(string p1)
        {
            return 0;
        }

        // CustOrdersOrdersAsync() cannot be created due to having out parameters, or is relying on the procedure result (int)

        public int EmployeeSalesByCountry(DateTime? p1, DateTime? p2)
        {
            return 0;
        }

        // EmployeeSalesByCountryAsync() cannot be created due to having out parameters, or is relying on the procedure result (int)

        public int SalesByCategory(string cn, string ordYear)
        {
            return 0;
        }

        // SalesByCategoryAsync() cannot be created due to having out parameters, or is relying on the procedure result (int)

        public int SalesByYear(DateTime? p1, DateTime? p2)
        {
            return 0;
        }

        // SalesByYearAsync() cannot be created due to having out parameters, or is relying on the procedure result (int)

        public int TenMostExpensiveProducts()
        {
            return 0;
        }

        // TenMostExpensiveProductsAsync() cannot be created due to having out parameters, or is relying on the procedure result (int)

        // Scalar Valued Functions

        // public.CustOrderHist
        public string CustOrderHist(string customerId)
        {
            return default(string);
        }

        // public.CustOrdersDetail
        public string CustOrdersDetail(int? p1)
        {
            return default(string);
        }
    }

    #endregion

    #region Fake DbSet

    // ************************************************************************
    // Fake DbSet
    // Implementing Find:
    //      The Find method is difficult to implement in a generic fashion. If
    //      you need to test code that makes use of the Find method it is
    //      easiest to create a test DbSet for each of the entity types that
    //      need to support find. You can then write logic to find that
    //      particular type of entity, as shown below:
    //      public class FakeBlogDbSet : FakeDbSet<Blog>
    //      {
    //          public override Blog Find(params object[] keyValues)
    //          {
    //              var id = (int) keyValues.Single();
    //              return this.SingleOrDefault(b => b.BlogId == id);
    //          }
    //      }
    //      Read more about it here: https://msdn.microsoft.com/en-us/data/dn314431.aspx
    public class FakeDbSet<TEntity> : DbSet<TEntity>, IQueryable<TEntity>, IAsyncEnumerable<TEntity>, IListSource where TEntity : class
    {
        private readonly PropertyInfo[] _primaryKeys;
        private readonly ObservableCollection<TEntity> _data;
        private readonly IQueryable _query;

        public FakeDbSet()
        {
            _primaryKeys = null;
            _data        = new ObservableCollection<TEntity>();
            _query       = _data.AsQueryable();
        }

        public FakeDbSet(params string[] primaryKeys)
        {
            _primaryKeys = typeof(TEntity).GetProperties().Where(x => primaryKeys.Contains(x.Name)).ToArray();
            _data        = new ObservableCollection<TEntity>();
            _query       = _data.AsQueryable();
        }

        public override TEntity Find(params object[] keyValues)
        {
            if (_primaryKeys == null)
                throw new ArgumentException("No primary keys defined");
            if (keyValues.Length != _primaryKeys.Length)
                throw new ArgumentException("Incorrect number of keys passed to Find method");

            var keyQuery = this.AsQueryable();
            keyQuery = keyValues
                .Select((t, i) => i)
                .Aggregate(keyQuery,
                    (current, x) =>
                        current.Where(entity => _primaryKeys[x].GetValue(entity, null).Equals(keyValues[x])));

            return keyQuery.SingleOrDefault();
        }

        public override ValueTask<TEntity> FindAsync(object[] keyValues, CancellationToken cancellationToken)
        {
            return new ValueTask<TEntity>(Task<TEntity>.Factory.StartNew(() => Find(keyValues), cancellationToken));
        }

        public override ValueTask<TEntity> FindAsync(params object[] keyValues)
        {
            return new ValueTask<TEntity>(Task<TEntity>.Factory.StartNew(() => Find(keyValues)));
        }

        IAsyncEnumerator<TEntity> IAsyncEnumerable<TEntity>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAsyncEnumerator(cancellationToken);
        }

        public override EntityEntry<TEntity> Add(TEntity entity)
        {
            _data.Add(entity);
            return null;
        }

        public override void AddRange(params TEntity[] entities)
        {
            if (entities == null) throw new ArgumentNullException("entities");
            foreach (var entity in entities.ToList())
                _data.Add(entity);
        }

        public override void AddRange(IEnumerable<TEntity> entities)
        {
            AddRange(entities.ToArray());
        }

        public override Task AddRangeAsync(params TEntity[] entities)
        {
            if (entities == null) throw new ArgumentNullException("entities");
            return Task.Factory.StartNew(() => AddRange(entities), cancellationToken);
        }

        public override void AttachRange(params TEntity[] entities)
        {
            if (entities == null) throw new ArgumentNullException("entities");
            AddRange(entities);
        }

        public override void RemoveRange(params TEntity[] entities)
        {
            if (entities == null) throw new ArgumentNullException("entities");
            foreach (var entity in entities.ToList())
                _data.Remove(entity);
        }

        public override void RemoveRange(IEnumerable<TEntity> entities)
        {
            RemoveRange(entities.ToArray());
        }

        public override void UpdateRange(params TEntity[] entities)
        {
            if (entities == null) throw new ArgumentNullException("entities");
            RemoveRange(entities);
            AddRange(entities);
        }

        public IList GetList()
        {
            return _data;
        }

        IList IListSource.GetList()
        {
            return _data;
        }

        Type IQueryable.ElementType
        {
            get { return _query.ElementType; }
        }

        Expression IQueryable.Expression
        {
            get { return _query.Expression; }
        }

        IQueryProvider IQueryable.Provider
        {
            get { return new FakeDbAsyncQueryProvider<TEntity>(_query.Provider); }
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return _data.GetEnumerator();
        }

        IEnumerator<TEntity> IEnumerable<TEntity>.GetEnumerator()
        {
            return _data.GetEnumerator();
        }

        IAsyncEnumerator<TEntity> GetAsyncEnumerator(CancellationToken cancellationToken = default(CancellationToken))
        {
            return new FakeDbAsyncEnumerator<TEntity>(this.AsEnumerable().GetEnumerator());
        }

    }

    public class FakeDbAsyncQueryProvider<TEntity> : IAsyncQueryProvider
    {
        private readonly IQueryProvider _inner;

        public FakeDbAsyncQueryProvider(IQueryProvider inner)
        {
            _inner = inner;
        }

        public IQueryable CreateQuery(Expression expression)
        {
            var m = expression as MethodCallExpression;
            if (m != null)
            {
                var resultType = m.Method.ReturnType; // it should be IQueryable<T>
                var tElement = resultType.GetGenericArguments()[0];
                var queryType = typeof(FakeDbAsyncEnumerable<>).MakeGenericType(tElement);
                return (IQueryable) Activator.CreateInstance(queryType, expression);
            }
            return new FakeDbAsyncEnumerable<TEntity>(expression);
        }

        public IQueryable<TElement> CreateQuery<TElement>(Expression expression)
        {
            var queryType = typeof(FakeDbAsyncEnumerable<>).MakeGenericType(typeof(TElement));
            return (IQueryable<TElement>) Activator.CreateInstance(queryType, expression);
        }

        public object Execute(Expression expression)
        {
            return _inner.Execute(expression);
        }

        public TResult Execute<TResult>(Expression expression)
        {
            return _inner.Execute<TResult>(expression);
        }

        public TResult ExecuteAsync<TResult>(Expression expression, CancellationToken cancellationToken = new CancellationToken())
        {
            var expectedResultType = typeof(TResult).GetGenericArguments()[0];
            var executionResult = typeof(IQueryProvider)
                .GetMethod(
                    name: nameof(IQueryProvider.Execute),
                    genericParameterCount: 1,
                    types: new[] { typeof(Expression) })
                .MakeGenericMethod(expectedResultType)
                .Invoke(this, new[] { expression });

            return (TResult) typeof(Task).GetMethod(nameof(Task.FromResult))
                ?.MakeGenericMethod(expectedResultType)
                .Invoke(null, new[] { executionResult });
        }
    }

    public class FakeDbAsyncEnumerable<T> : EnumerableQuery<T>, IAsyncEnumerable<T>, IQueryable<T>
    {
        public FakeDbAsyncEnumerable(IEnumerable<T> enumerable)
            : base(enumerable)
        {
        }

        public FakeDbAsyncEnumerable(Expression expression)
            : base(expression)
        {
        }

        public IAsyncEnumerator<T> GetAsyncEnumerator(CancellationToken cancellationToken = new CancellationToken())
        {
            return new FakeDbAsyncEnumerator<T>(this.AsEnumerable().GetEnumerator());
        }

        IAsyncEnumerator<T> IAsyncEnumerable<T>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAsyncEnumerator(cancellationToken);
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return this.AsEnumerable().GetEnumerator();
        }
    }

    public class FakeDbAsyncEnumerator<T> : IAsyncEnumerator<T>
    {
        private readonly IEnumerator<T> _inner;

        public FakeDbAsyncEnumerator(IEnumerator<T> inner)
        {
            _inner = inner;
        }

        public T Current
        {
            get { return _inner.Current; }
        }
        public ValueTask<bool> MoveNextAsync()
        {
            return new ValueTask<bool>(_inner.MoveNext());
        }

        public ValueTask DisposeAsync()
        {
            _inner.Dispose();
            return new ValueTask(Task.CompletedTask);
        }
    }

    #endregion

    #region POCO classes

    // Alphabetical list of products
    public class AlphabeticalListOfProduct
    {
        public short? ProductId { get; set; } // ProductID
        public string ProductName { get; set; } // ProductName (length: 40)
        public short? SupplierId { get; set; } // SupplierID
        public short? CategoryId { get; set; } // CategoryID
        public string QuantityPerUnit { get; set; } // QuantityPerUnit (length: 20)
        public float? UnitPrice { get; set; } // UnitPrice
        public short? UnitsInStock { get; set; } // UnitsInStock
        public short? UnitsOnOrder { get; set; } // UnitsOnOrder
        public short? ReorderLevel { get; set; } // ReorderLevel
        public int? Discontinued { get; set; } // Discontinued
        public string CategoryName { get; set; } // CategoryName (length: 15)
    }

    // categories
    public class Category
    {
        public short CategoryId { get; set; } // CategoryID (Primary key)
        public string CategoryName { get; set; } // CategoryName (length: 15)
        public string Description { get; set; } // Description
        public byte[] Picture { get; set; } // Picture

        // Reverse navigation

        /// <summary>
        /// Child Products where [products].[CategoryID] point to this entity (FK_Products_Categories)
        /// </summary>
        public virtual ICollection<Product> Products { get; set; } // products.FK_Products_Categories

        public Category()
        {
            Products = new List<Product>();
        }
    }

    // Category Sales for 1997
    public class CategorySalesFor1997
    {
        public string CategoryName { get; set; } // CategoryName (length: 15)
        public double? Categorysales { get; set; } // categorysales
    }

    // Current Product List
    public class CurrentProductList
    {
        public short? ProductId { get; set; } // ProductID
        public string ProductName { get; set; } // ProductName (length: 40)
    }

    // customers
    public class Customer
    {
        public string CustomerId { get; set; } // CustomerID (Primary key)
        public string CompanyName { get; set; } // CompanyName (length: 40)
        public string ContactName { get; set; } // ContactName (length: 30)
        public string ContactTitle { get; set; } // ContactTitle (length: 30)
        public string Address { get; set; } // Address (length: 60)
        public string City { get; set; } // City (length: 15)
        public string Region { get; set; } // Region (length: 15)
        public string PostalCode { get; set; } // PostalCode (length: 10)
        public string Country { get; set; } // Country (length: 15)
        public string Phone { get; set; } // Phone (length: 24)
        public string Fax { get; set; } // Fax (length: 24)

        // Reverse navigation

        /// <summary>
        /// Child Customercustomerdemoes where [customercustomerdemo].[CustomerID] point to this entity (FK_CustomerCustomerDemo_Customers)
        /// </summary>
        public virtual ICollection<Customercustomerdemo> Customercustomerdemoes { get; set; } // customercustomerdemo.FK_CustomerCustomerDemo_Customers

        /// <summary>
        /// Child Orders where [orders].[CustomerID] point to this entity (FK_Orders_Customers)
        /// </summary>
        public virtual ICollection<Order> Orders { get; set; } // orders.FK_Orders_Customers

        public Customer()
        {
            Customercustomerdemoes = new List<Customercustomerdemo>();
            Orders = new List<Order>();
        }
    }

    // Customer and Suppliers by City
    public class CustomerAndSuppliersByCity
    {
        public string City { get; set; } // City (length: 15)
        public string CompanyName { get; set; } // CompanyName (length: 40)
        public string ContactName { get; set; } // ContactName (length: 30)
        public string Relationship { get; set; } // relationship
    }

    // customercustomerdemo
    public class Customercustomerdemo
    {
        public string CustomerId { get; set; } // CustomerID (Primary key)
        public string CustomerTypeId { get; set; } // CustomerTypeID (Primary key)

        // Foreign keys

        /// <summary>
        /// Parent Customer pointed by [customercustomerdemo].([CustomerId]) (FK_CustomerCustomerDemo_Customers)
        /// </summary>
        public virtual Customer Customer { get; set; } // FK_CustomerCustomerDemo_Customers

        /// <summary>
        /// Parent Customerdemographic pointed by [customercustomerdemo].([CustomerTypeId]) (FK_CustomerCustomerDemo)
        /// </summary>
        public virtual Customerdemographic Customerdemographic { get; set; } // FK_CustomerCustomerDemo
    }

    // customerdemographics
    public class Customerdemographic
    {
        public string CustomerTypeId { get; set; } // CustomerTypeID (Primary key)
        public string CustomerDesc { get; set; } // CustomerDesc

        // Reverse navigation

        /// <summary>
        /// Child Customercustomerdemoes where [customercustomerdemo].[CustomerTypeID] point to this entity (FK_CustomerCustomerDemo)
        /// </summary>
        public virtual ICollection<Customercustomerdemo> Customercustomerdemoes { get; set; } // customercustomerdemo.FK_CustomerCustomerDemo

        public Customerdemographic()
        {
            Customercustomerdemoes = new List<Customercustomerdemo>();
        }
    }

    // employees
    public class Employee
    {
        public short EmployeeId { get; set; } // EmployeeID (Primary key)
        public string LastName { get; set; } // LastName (length: 20)
        public string FirstName { get; set; } // FirstName (length: 10)
        public string Title { get; set; } // Title (length: 30)
        public string TitleOfCourtesy { get; set; } // TitleOfCourtesy (length: 25)
        public DateTime? BirthDate { get; set; } // BirthDate
        public DateTime? HireDate { get; set; } // HireDate
        public string Address { get; set; } // Address (length: 60)
        public string City { get; set; } // City (length: 15)
        public string Region { get; set; } // Region (length: 15)
        public string PostalCode { get; set; } // PostalCode (length: 10)
        public string Country { get; set; } // Country (length: 15)
        public string HomePhone { get; set; } // HomePhone (length: 24)
        public string Extension { get; set; } // Extension (length: 4)
        public byte[] Photo { get; set; } // Photo
        public string Notes { get; set; } // Notes
        public short? ReportsTo { get; set; } // ReportsTo
        public string PhotoPath { get; set; } // PhotoPath (length: 255)

        // Reverse navigation

        /// <summary>
        /// Child Employees where [employees].[ReportsTo] point to this entity (FK_Employees_Employees)
        /// </summary>
        public virtual ICollection<Employee> Employees { get; set; } // employees.FK_Employees_Employees

        /// <summary>
        /// Child Employeeterritories where [employeeterritories].[EmployeeID] point to this entity (FK_EmployeeTerritories_Employees)
        /// </summary>
        public virtual ICollection<Employeeterritory> Employeeterritories { get; set; } // employeeterritories.FK_EmployeeTerritories_Employees

        /// <summary>
        /// Child Orders where [orders].[EmployeeID] point to this entity (FK_Orders_Employees)
        /// </summary>
        public virtual ICollection<Order> Orders { get; set; } // orders.FK_Orders_Employees

        // Foreign keys

        /// <summary>
        /// Parent Employee pointed by [employees].([ReportsTo]) (FK_Employees_Employees)
        /// </summary>
        public virtual Employee Employee_ReportsTo { get; set; } // FK_Employees_Employees

        public Employee()
        {
            Employees = new List<Employee>();
            Employeeterritories = new List<Employeeterritory>();
            Orders = new List<Order>();
        }
    }

    // employeeterritories
    public class Employeeterritory
    {
        public short EmployeeId { get; set; } // EmployeeID (Primary key)
        public string TerritoryId { get; set; } // TerritoryID (Primary key) (length: 20)

        // Foreign keys

        /// <summary>
        /// Parent Employee pointed by [employeeterritories].([EmployeeId]) (FK_EmployeeTerritories_Employees)
        /// </summary>
        public virtual Employee Employee { get; set; } // FK_EmployeeTerritories_Employees

        /// <summary>
        /// Parent Territory pointed by [employeeterritories].([TerritoryId]) (FK_EmployeeTerritories_Territories)
        /// </summary>
        public virtual Territory Territory { get; set; } // FK_EmployeeTerritories_Territories
    }

    // Invoices
    public class Invoice
    {
        public string ShipName { get; set; } // ShipName (length: 40)
        public string ShipAddress { get; set; } // ShipAddress (length: 60)
        public string ShipCity { get; set; } // ShipCity (length: 15)
        public string ShipRegion { get; set; } // ShipRegion (length: 15)
        public string ShipPostalCode { get; set; } // ShipPostalCode (length: 10)
        public string ShipCountry { get; set; } // ShipCountry (length: 15)
        public string CustomerId { get; set; } // CustomerID
        public string Customername { get; set; } // customername (length: 40)
        public string Address { get; set; } // Address (length: 60)
        public string City { get; set; } // City (length: 15)
        public string Region { get; set; } // Region (length: 15)
        public string PostalCode { get; set; } // PostalCode (length: 10)
        public string Country { get; set; } // Country (length: 15)
        public string Salesperson { get; set; } // salesperson
        public short? OrderId { get; set; } // OrderID
        public DateTime? OrderDate { get; set; } // OrderDate
        public DateTime? RequiredDate { get; set; } // RequiredDate
        public DateTime? ShippedDate { get; set; } // ShippedDate
        public string Shippername { get; set; } // shippername (length: 40)
        public short? ProductId { get; set; } // ProductID
        public string ProductName { get; set; } // ProductName (length: 40)
        public float? UnitPrice { get; set; } // UnitPrice
        public short? Quantity { get; set; } // Quantity
        public float? Discount { get; set; } // Discount
        public double? Extendedprice { get; set; } // extendedprice
        public float? Freight { get; set; } // Freight
    }

    // orders
    public class Order
    {
        public short OrderId { get; set; } // OrderID (Primary key)
        public string CustomerId { get; set; } // CustomerID
        public short? EmployeeId { get; set; } // EmployeeID
        public DateTime? OrderDate { get; set; } // OrderDate
        public DateTime? RequiredDate { get; set; } // RequiredDate
        public DateTime? ShippedDate { get; set; } // ShippedDate
        public short? ShipVia { get; set; } // ShipVia
        public float? Freight { get; set; } // Freight
        public string ShipName { get; set; } // ShipName (length: 40)
        public string ShipAddress { get; set; } // ShipAddress (length: 60)
        public string ShipCity { get; set; } // ShipCity (length: 15)
        public string ShipRegion { get; set; } // ShipRegion (length: 15)
        public string ShipPostalCode { get; set; } // ShipPostalCode (length: 10)
        public string ShipCountry { get; set; } // ShipCountry (length: 15)

        // Reverse navigation

        /// <summary>
        /// Child OrderDetails where [order_details].[OrderID] point to this entity (FK_Order_Details_Orders)
        /// </summary>
        public virtual ICollection<OrderDetail> OrderDetails { get; set; } // order_details.FK_Order_Details_Orders

        // Foreign keys

        /// <summary>
        /// Parent Customer pointed by [orders].([CustomerId]) (FK_Orders_Customers)
        /// </summary>
        public virtual Customer Customer { get; set; } // FK_Orders_Customers

        /// <summary>
        /// Parent Employee pointed by [orders].([EmployeeId]) (FK_Orders_Employees)
        /// </summary>
        public virtual Employee Employee { get; set; } // FK_Orders_Employees

        /// <summary>
        /// Parent Shipper pointed by [orders].([ShipVia]) (FK_Orders_Shippers)
        /// </summary>
        public virtual Shipper Shipper { get; set; } // FK_Orders_Shippers

        public Order()
        {
            OrderDetails = new List<OrderDetail>();
        }
    }

    // order_details
    public class OrderDetail
    {
        public short OrderId { get; set; } // OrderID (Primary key)
        public short ProductId { get; set; } // ProductID (Primary key)
        public float UnitPrice { get; set; } // UnitPrice
        public short Quantity { get; set; } // Quantity
        public float Discount { get; set; } // Discount

        // Foreign keys

        /// <summary>
        /// Parent Order pointed by [order_details].([OrderId]) (FK_Order_Details_Orders)
        /// </summary>
        public virtual Order Order { get; set; } // FK_Order_Details_Orders

        /// <summary>
        /// Parent Product pointed by [order_details].([ProductId]) (FK_Order_Details_Products)
        /// </summary>
        public virtual Product Product { get; set; } // FK_Order_Details_Products
    }

    // Order Details Extended
    public class OrderDetailsExtended
    {
        public short? OrderId { get; set; } // OrderID
        public short? ProductId { get; set; } // ProductID
        public string ProductName { get; set; } // ProductName (length: 40)
        public float? UnitPrice { get; set; } // UnitPrice
        public short? Quantity { get; set; } // Quantity
        public float? Discount { get; set; } // Discount
        public double? Extendedprice { get; set; } // extendedprice
    }

    // Orders Qry
    public class OrdersQry
    {
        public short? OrderId { get; set; } // OrderID
        public string CustomerId { get; set; } // CustomerID
        public short? EmployeeId { get; set; } // EmployeeID
        public DateTime? OrderDate { get; set; } // OrderDate
        public DateTime? RequiredDate { get; set; } // RequiredDate
        public DateTime? ShippedDate { get; set; } // ShippedDate
        public short? ShipVia { get; set; } // ShipVia
        public float? Freight { get; set; } // Freight
        public string ShipName { get; set; } // ShipName (length: 40)
        public string ShipAddress { get; set; } // ShipAddress (length: 60)
        public string ShipCity { get; set; } // ShipCity (length: 15)
        public string ShipRegion { get; set; } // ShipRegion (length: 15)
        public string ShipPostalCode { get; set; } // ShipPostalCode (length: 10)
        public string ShipCountry { get; set; } // ShipCountry (length: 15)
        public string CompanyName { get; set; } // CompanyName (length: 40)
        public string Address { get; set; } // Address (length: 60)
        public string City { get; set; } // City (length: 15)
        public string Region { get; set; } // Region (length: 15)
        public string PostalCode { get; set; } // PostalCode (length: 10)
        public string Country { get; set; } // Country (length: 15)
    }

    // Order Subtotals
    public class OrderSubtotal
    {
        public short? OrderId { get; set; } // OrderID
        public double? Subtotal { get; set; } // subtotal
    }

    // products
    public class Product
    {
        public short ProductId { get; set; } // ProductID (Primary key)
        public string ProductName { get; set; } // ProductName (length: 40)
        public short? SupplierId { get; set; } // SupplierID
        public short? CategoryId { get; set; } // CategoryID
        public string QuantityPerUnit { get; set; } // QuantityPerUnit (length: 20)
        public float? UnitPrice { get; set; } // UnitPrice
        public short? UnitsInStock { get; set; } // UnitsInStock
        public short? UnitsOnOrder { get; set; } // UnitsOnOrder
        public short? ReorderLevel { get; set; } // ReorderLevel
        public int Discontinued { get; set; } // Discontinued

        // Reverse navigation

        /// <summary>
        /// Child OrderDetails where [order_details].[ProductID] point to this entity (FK_Order_Details_Products)
        /// </summary>
        public virtual ICollection<OrderDetail> OrderDetails { get; set; } // order_details.FK_Order_Details_Products

        // Foreign keys

        /// <summary>
        /// Parent Category pointed by [products].([CategoryId]) (FK_Products_Categories)
        /// </summary>
        public virtual Category Category { get; set; } // FK_Products_Categories

        /// <summary>
        /// Parent Supplier pointed by [products].([SupplierId]) (FK_Products_Suppliers)
        /// </summary>
        public virtual Supplier Supplier { get; set; } // FK_Products_Suppliers

        public Product()
        {
            OrderDetails = new List<OrderDetail>();
        }
    }

    // Products Above Average Price
    public class ProductsAboveAveragePrice
    {
        public string ProductName { get; set; } // ProductName (length: 40)
        public float? UnitPrice { get; set; } // UnitPrice
    }

    // Product Sales for 1997
    public class ProductSalesFor1997
    {
        public string CategoryName { get; set; } // CategoryName (length: 15)
        public string ProductName { get; set; } // ProductName (length: 40)
        public double? ProductSales { get; set; } // ProductSales
    }

    // Products by Category
    public class ProductsByCategory
    {
        public string CategoryName { get; set; } // CategoryName (length: 15)
        public string ProductName { get; set; } // ProductName (length: 40)
        public string QuantityPerUnit { get; set; } // QuantityPerUnit (length: 20)
        public short? UnitsInStock { get; set; } // UnitsInStock
        public int? Discontinued { get; set; } // Discontinued
    }

    // Quarterly Orders
    public class QuarterlyOrder
    {
        public string CustomerId { get; set; } // CustomerID
        public string CompanyName { get; set; } // CompanyName (length: 40)
        public string City { get; set; } // City (length: 15)
        public string Country { get; set; } // Country (length: 15)
    }

    // region
    public class Region
    {
        public short RegionId { get; set; } // RegionID (Primary key)
        public string RegionDescription { get; set; } // RegionDescription

        // Reverse navigation

        /// <summary>
        /// Child Territories where [territories].[RegionID] point to this entity (FK_Territories_Region)
        /// </summary>
        public virtual ICollection<Territory> Territories { get; set; } // territories.FK_Territories_Region

        public Region()
        {
            Territories = new List<Territory>();
        }
    }

    // Sales by Category
    public class SalesByCategory
    {
        public short? CategoryId { get; set; } // CategoryID
        public string CategoryName { get; set; } // CategoryName (length: 15)
        public string ProductName { get; set; } // ProductName (length: 40)
        public double? Productsales { get; set; } // productsales
    }

    // Sales Totals by Amount
    public class SalesTotalsByAmount
    {
        public double? Saleamount { get; set; } // saleamount
        public short? OrderId { get; set; } // OrderID
        public string CompanyName { get; set; } // CompanyName (length: 40)
        public DateTime? ShippedDate { get; set; } // ShippedDate
    }

    // shippers
    public class Shipper
    {
        public short ShipperId { get; set; } // ShipperID (Primary key)
        public string CompanyName { get; set; } // CompanyName (length: 40)
        public string Phone { get; set; } // Phone (length: 24)

        // Reverse navigation

        /// <summary>
        /// Child Orders where [orders].[ShipVia] point to this entity (FK_Orders_Shippers)
        /// </summary>
        public virtual ICollection<Order> Orders { get; set; } // orders.FK_Orders_Shippers

        public Shipper()
        {
            Orders = new List<Order>();
        }
    }

    // shippers_tmp
    public class ShippersTmp
    {
        public short ShipperId { get; set; } // ShipperID (Primary key)
        public string CompanyName { get; set; } // CompanyName (length: 40)
        public string Phone { get; set; } // Phone (length: 24)
    }

    // Summary of Sales by Quarter
    public class SummaryOfSalesByQuarter
    {
        public DateTime? ShippedDate { get; set; } // ShippedDate
        public short? OrderId { get; set; } // OrderID
        public double? Subtotal { get; set; } // subtotal
    }

    // Summary of Sales by Year
    public class SummaryOfSalesByYear
    {
        public DateTime? ShippedDate { get; set; } // ShippedDate
        public short? OrderId { get; set; } // OrderID
        public double? Subtotal { get; set; } // subtotal
    }

    // suppliers
    public class Supplier
    {
        public short SupplierId { get; set; } // SupplierID (Primary key)
        public string CompanyName { get; set; } // CompanyName (length: 40)
        public string ContactName { get; set; } // ContactName (length: 30)
        public string ContactTitle { get; set; } // ContactTitle (length: 30)
        public string Address { get; set; } // Address (length: 60)
        public string City { get; set; } // City (length: 15)
        public string Region { get; set; } // Region (length: 15)
        public string PostalCode { get; set; } // PostalCode (length: 10)
        public string Country { get; set; } // Country (length: 15)
        public string Phone { get; set; } // Phone (length: 24)
        public string Fax { get; set; } // Fax (length: 24)
        public string HomePage { get; set; } // HomePage

        // Reverse navigation

        /// <summary>
        /// Child Products where [products].[SupplierID] point to this entity (FK_Products_Suppliers)
        /// </summary>
        public virtual ICollection<Product> Products { get; set; } // products.FK_Products_Suppliers

        public Supplier()
        {
            Products = new List<Product>();
        }
    }

    // territories
    public class Territory
    {
        public string TerritoryId { get; set; } // TerritoryID (Primary key) (length: 20)
        public string TerritoryDescription { get; set; } // TerritoryDescription
        public short RegionId { get; set; } // RegionID

        // Reverse navigation

        /// <summary>
        /// Child Employeeterritories where [employeeterritories].[TerritoryID] point to this entity (FK_EmployeeTerritories_Territories)
        /// </summary>
        public virtual ICollection<Employeeterritory> Employeeterritories { get; set; } // employeeterritories.FK_EmployeeTerritories_Territories

        // Foreign keys

        /// <summary>
        /// Parent Region pointed by [territories].([RegionId]) (FK_Territories_Region)
        /// </summary>
        public virtual Region Region { get; set; } // FK_Territories_Region

        public Territory()
        {
            Employeeterritories = new List<Employeeterritory>();
        }
    }

    // usstates
    public class Usstate
    {
        public short StateId { get; set; } // StateID (Primary key)
        public string StateName { get; set; } // StateName (length: 100)
        public string StateAbbr { get; set; } // StateAbbr (length: 2)
        public string StateRegion { get; set; } // StateRegion (length: 50)
    }


    #endregion

    #region POCO Configuration

    // Alphabetical list of products
    public class AlphabeticalListOfProductConfiguration : IEntityTypeConfiguration<AlphabeticalListOfProduct>
    {
        public void Configure(EntityTypeBuilder<AlphabeticalListOfProduct> builder)
        {
            builder.ToView("Alphabetical list of products", "public");
            builder.HasNoKey();

            builder.Property(x => x.ProductId).HasColumnName(@"ProductID").HasColumnType("smallint").IsRequired(false);
            builder.Property(x => x.ProductName).HasColumnName(@"ProductName").HasColumnType("character varying(40)").IsRequired(false).HasMaxLength(40);
            builder.Property(x => x.SupplierId).HasColumnName(@"SupplierID").HasColumnType("smallint").IsRequired(false);
            builder.Property(x => x.CategoryId).HasColumnName(@"CategoryID").HasColumnType("smallint").IsRequired(false);
            builder.Property(x => x.QuantityPerUnit).HasColumnName(@"QuantityPerUnit").HasColumnType("character varying(20)").IsRequired(false).HasMaxLength(20);
            builder.Property(x => x.UnitPrice).HasColumnName(@"UnitPrice").HasColumnType("real").IsRequired(false);
            builder.Property(x => x.UnitsInStock).HasColumnName(@"UnitsInStock").HasColumnType("smallint").IsRequired(false);
            builder.Property(x => x.UnitsOnOrder).HasColumnName(@"UnitsOnOrder").HasColumnType("smallint").IsRequired(false);
            builder.Property(x => x.ReorderLevel).HasColumnName(@"ReorderLevel").HasColumnType("smallint").IsRequired(false);
            builder.Property(x => x.Discontinued).HasColumnName(@"Discontinued").HasColumnType("integer").IsRequired(false);
            builder.Property(x => x.CategoryName).HasColumnName(@"CategoryName").HasColumnType("character varying(15)").IsRequired(false).HasMaxLength(15);
        }
    }

    // categories
    public class CategoryConfiguration : IEntityTypeConfiguration<Category>
    {
        public void Configure(EntityTypeBuilder<Category> builder)
        {
            builder.ToTable("categories", "public");
            builder.HasKey(x => x.CategoryId).HasName("pk_categories");

            builder.Property(x => x.CategoryId).HasColumnName(@"CategoryID").HasColumnType("smallint").IsRequired().ValueGeneratedNever();
            builder.Property(x => x.CategoryName).HasColumnName(@"CategoryName").HasColumnType("character varying(15)").IsRequired().HasMaxLength(15);
            builder.Property(x => x.Description).HasColumnName(@"Description").HasColumnType("text").IsRequired(false).IsUnicode(false);
            builder.Property(x => x.Picture).HasColumnName(@"Picture").HasColumnType("bytea").IsRequired(false);

            builder.HasIndex(x => x.CategoryName).HasName("CategoryName");
        }
    }

    // Category Sales for 1997
    public class CategorySalesFor1997Configuration : IEntityTypeConfiguration<CategorySalesFor1997>
    {
        public void Configure(EntityTypeBuilder<CategorySalesFor1997> builder)
        {
            builder.ToView("Category Sales for 1997", "public");
            builder.HasNoKey();

            builder.Property(x => x.CategoryName).HasColumnName(@"CategoryName").HasColumnType("character varying(15)").IsRequired(false).HasMaxLength(15);
            builder.Property(x => x.Categorysales).HasColumnName(@"categorysales").HasColumnType("double precision").IsRequired(false);
        }
    }

    // Current Product List
    public class CurrentProductListConfiguration : IEntityTypeConfiguration<CurrentProductList>
    {
        public void Configure(EntityTypeBuilder<CurrentProductList> builder)
        {
            builder.ToView("Current Product List", "public");
            builder.HasNoKey();

            builder.Property(x => x.ProductId).HasColumnName(@"ProductID").HasColumnType("smallint").IsRequired(false);
            builder.Property(x => x.ProductName).HasColumnName(@"ProductName").HasColumnType("character varying(40)").IsRequired(false).HasMaxLength(40);
        }
    }

    // customers
    public class CustomerConfiguration : IEntityTypeConfiguration<Customer>
    {
        public void Configure(EntityTypeBuilder<Customer> builder)
        {
            builder.ToTable("customers", "public");
            builder.HasKey(x => x.CustomerId).HasName("pk_customers");

            builder.Property(x => x.CustomerId).HasColumnName(@"CustomerID").HasColumnType("character").IsRequired().ValueGeneratedNever();
            builder.Property(x => x.CompanyName).HasColumnName(@"CompanyName").HasColumnType("character varying(40)").IsRequired().HasMaxLength(40);
            builder.Property(x => x.ContactName).HasColumnName(@"ContactName").HasColumnType("character varying(30)").IsRequired(false).HasMaxLength(30);
            builder.Property(x => x.ContactTitle).HasColumnName(@"ContactTitle").HasColumnType("character varying(30)").IsRequired(false).HasMaxLength(30);
            builder.Property(x => x.Address).HasColumnName(@"Address").HasColumnType("character varying(60)").IsRequired(false).HasMaxLength(60);
            builder.Property(x => x.City).HasColumnName(@"City").HasColumnType("character varying(15)").IsRequired(false).HasMaxLength(15);
            builder.Property(x => x.Region).HasColumnName(@"Region").HasColumnType("character varying(15)").IsRequired(false).HasMaxLength(15);
            builder.Property(x => x.PostalCode).HasColumnName(@"PostalCode").HasColumnType("character varying(10)").IsRequired(false).HasMaxLength(10);
            builder.Property(x => x.Country).HasColumnName(@"Country").HasColumnType("character varying(15)").IsRequired(false).HasMaxLength(15);
            builder.Property(x => x.Phone).HasColumnName(@"Phone").HasColumnType("character varying(24)").IsRequired(false).HasMaxLength(24);
            builder.Property(x => x.Fax).HasColumnName(@"Fax").HasColumnType("character varying(24)").IsRequired(false).HasMaxLength(24);

            builder.HasIndex(x => x.City).HasName("City");
            builder.HasIndex(x => x.CompanyName).HasName("CompanyName");
            builder.HasIndex(x => x.PostalCode).HasName("PostalCode");
            builder.HasIndex(x => x.Region).HasName("Region");
        }
    }

    // Customer and Suppliers by City
    public class CustomerAndSuppliersByCityConfiguration : IEntityTypeConfiguration<CustomerAndSuppliersByCity>
    {
        public void Configure(EntityTypeBuilder<CustomerAndSuppliersByCity> builder)
        {
            builder.ToView("Customer and Suppliers by City", "public");
            builder.HasNoKey();

            builder.Property(x => x.City).HasColumnName(@"City").HasColumnType("character varying(15)").IsRequired(false).HasMaxLength(15);
            builder.Property(x => x.CompanyName).HasColumnName(@"CompanyName").HasColumnType("character varying(40)").IsRequired(false).HasMaxLength(40);
            builder.Property(x => x.ContactName).HasColumnName(@"ContactName").HasColumnType("character varying(30)").IsRequired(false).HasMaxLength(30);
            builder.Property(x => x.Relationship).HasColumnName(@"relationship").HasColumnType("text").IsRequired(false).IsUnicode(false);
        }
    }

    // customercustomerdemo
    public class CustomercustomerdemoConfiguration : IEntityTypeConfiguration<Customercustomerdemo>
    {
        public void Configure(EntityTypeBuilder<Customercustomerdemo> builder)
        {
            builder.ToTable("customercustomerdemo", "public");
            builder.HasKey(x => new { x.CustomerId, x.CustomerTypeId }).HasName("pk_customercustomerdemo");

            builder.Property(x => x.CustomerId).HasColumnName(@"CustomerID").HasColumnType("character").IsRequired().ValueGeneratedNever();
            builder.Property(x => x.CustomerTypeId).HasColumnName(@"CustomerTypeID").HasColumnType("character").IsRequired().ValueGeneratedNever();

            // Foreign keys
            builder.HasOne(a => a.Customer).WithMany(b => b.Customercustomerdemoes).HasForeignKey(c => c.CustomerId).OnDelete(DeleteBehavior.ClientSetNull).HasConstraintName("FK_CustomerCustomerDemo_Customers");
            builder.HasOne(a => a.Customerdemographic).WithMany(b => b.Customercustomerdemoes).HasForeignKey(c => c.CustomerTypeId).OnDelete(DeleteBehavior.ClientSetNull).HasConstraintName("FK_CustomerCustomerDemo");
        }
    }

    // customerdemographics
    public class CustomerdemographicConfiguration : IEntityTypeConfiguration<Customerdemographic>
    {
        public void Configure(EntityTypeBuilder<Customerdemographic> builder)
        {
            builder.ToTable("customerdemographics", "public");
            builder.HasKey(x => x.CustomerTypeId).HasName("pk_customerdemographics");

            builder.Property(x => x.CustomerTypeId).HasColumnName(@"CustomerTypeID").HasColumnType("character").IsRequired().ValueGeneratedNever();
            builder.Property(x => x.CustomerDesc).HasColumnName(@"CustomerDesc").HasColumnType("text").IsRequired(false).IsUnicode(false);
        }
    }

    // employees
    public class EmployeeConfiguration : IEntityTypeConfiguration<Employee>
    {
        public void Configure(EntityTypeBuilder<Employee> builder)
        {
            builder.ToTable("employees", "public");
            builder.HasKey(x => x.EmployeeId).HasName("pk_employees");

            builder.Property(x => x.EmployeeId).HasColumnName(@"EmployeeID").HasColumnType("smallint").IsRequired().ValueGeneratedNever();
            builder.Property(x => x.LastName).HasColumnName(@"LastName").HasColumnType("character varying(20)").IsRequired().HasMaxLength(20);
            builder.Property(x => x.FirstName).HasColumnName(@"FirstName").HasColumnType("character varying(10)").IsRequired().HasMaxLength(10);
            builder.Property(x => x.Title).HasColumnName(@"Title").HasColumnType("character varying(30)").IsRequired(false).HasMaxLength(30);
            builder.Property(x => x.TitleOfCourtesy).HasColumnName(@"TitleOfCourtesy").HasColumnType("character varying(25)").IsRequired(false).HasMaxLength(25);
            builder.Property(x => x.BirthDate).HasColumnName(@"BirthDate").HasColumnType("date").IsRequired(false);
            builder.Property(x => x.HireDate).HasColumnName(@"HireDate").HasColumnType("date").IsRequired(false);
            builder.Property(x => x.Address).HasColumnName(@"Address").HasColumnType("character varying(60)").IsRequired(false).HasMaxLength(60);
            builder.Property(x => x.City).HasColumnName(@"City").HasColumnType("character varying(15)").IsRequired(false).HasMaxLength(15);
            builder.Property(x => x.Region).HasColumnName(@"Region").HasColumnType("character varying(15)").IsRequired(false).HasMaxLength(15);
            builder.Property(x => x.PostalCode).HasColumnName(@"PostalCode").HasColumnType("character varying(10)").IsRequired(false).HasMaxLength(10);
            builder.Property(x => x.Country).HasColumnName(@"Country").HasColumnType("character varying(15)").IsRequired(false).HasMaxLength(15);
            builder.Property(x => x.HomePhone).HasColumnName(@"HomePhone").HasColumnType("character varying(24)").IsRequired(false).HasMaxLength(24);
            builder.Property(x => x.Extension).HasColumnName(@"Extension").HasColumnType("character varying(4)").IsRequired(false).HasMaxLength(4);
            builder.Property(x => x.Photo).HasColumnName(@"Photo").HasColumnType("bytea").IsRequired(false);
            builder.Property(x => x.Notes).HasColumnName(@"Notes").HasColumnType("text").IsRequired(false).IsUnicode(false);
            builder.Property(x => x.ReportsTo).HasColumnName(@"ReportsTo").HasColumnType("smallint").IsRequired(false);
            builder.Property(x => x.PhotoPath).HasColumnName(@"PhotoPath").HasColumnType("character varying(255)").IsRequired(false).HasMaxLength(255);

            // Foreign keys
            builder.HasOne(a => a.Employee_ReportsTo).WithMany(b => b.Employees).HasForeignKey(c => c.ReportsTo).OnDelete(DeleteBehavior.ClientSetNull).HasConstraintName("FK_Employees_Employees");

            builder.HasIndex(x => x.LastName).HasName("LastName");
            builder.HasIndex(x => x.PostalCode).HasName("PostCode");
        }
    }

    // employeeterritories
    public class EmployeeterritoryConfiguration : IEntityTypeConfiguration<Employeeterritory>
    {
        public void Configure(EntityTypeBuilder<Employeeterritory> builder)
        {
            builder.ToTable("employeeterritories", "public");
            builder.HasKey(x => new { x.EmployeeId, x.TerritoryId }).HasName("pk_employeeterritories");

            builder.Property(x => x.EmployeeId).HasColumnName(@"EmployeeID").HasColumnType("smallint").IsRequired().ValueGeneratedNever();
            builder.Property(x => x.TerritoryId).HasColumnName(@"TerritoryID").HasColumnType("character varying(20)").IsRequired().HasMaxLength(20).ValueGeneratedNever();

            // Foreign keys
            builder.HasOne(a => a.Employee).WithMany(b => b.Employeeterritories).HasForeignKey(c => c.EmployeeId).OnDelete(DeleteBehavior.ClientSetNull).HasConstraintName("FK_EmployeeTerritories_Employees");
            builder.HasOne(a => a.Territory).WithMany(b => b.Employeeterritories).HasForeignKey(c => c.TerritoryId).OnDelete(DeleteBehavior.ClientSetNull).HasConstraintName("FK_EmployeeTerritories_Territories");
        }
    }

    // Invoices
    public class InvoiceConfiguration : IEntityTypeConfiguration<Invoice>
    {
        public void Configure(EntityTypeBuilder<Invoice> builder)
        {
            builder.ToView("Invoices", "public");
            builder.HasNoKey();

            builder.Property(x => x.ShipName).HasColumnName(@"ShipName").HasColumnType("character varying(40)").IsRequired(false).HasMaxLength(40);
            builder.Property(x => x.ShipAddress).HasColumnName(@"ShipAddress").HasColumnType("character varying(60)").IsRequired(false).HasMaxLength(60);
            builder.Property(x => x.ShipCity).HasColumnName(@"ShipCity").HasColumnType("character varying(15)").IsRequired(false).HasMaxLength(15);
            builder.Property(x => x.ShipRegion).HasColumnName(@"ShipRegion").HasColumnType("character varying(15)").IsRequired(false).HasMaxLength(15);
            builder.Property(x => x.ShipPostalCode).HasColumnName(@"ShipPostalCode").HasColumnType("character varying(10)").IsRequired(false).HasMaxLength(10);
            builder.Property(x => x.ShipCountry).HasColumnName(@"ShipCountry").HasColumnType("character varying(15)").IsRequired(false).HasMaxLength(15);
            builder.Property(x => x.CustomerId).HasColumnName(@"CustomerID").HasColumnType("character").IsRequired(false);
            builder.Property(x => x.Customername).HasColumnName(@"customername").HasColumnType("character varying(40)").IsRequired(false).HasMaxLength(40);
            builder.Property(x => x.Address).HasColumnName(@"Address").HasColumnType("character varying(60)").IsRequired(false).HasMaxLength(60);
            builder.Property(x => x.City).HasColumnName(@"City").HasColumnType("character varying(15)").IsRequired(false).HasMaxLength(15);
            builder.Property(x => x.Region).HasColumnName(@"Region").HasColumnType("character varying(15)").IsRequired(false).HasMaxLength(15);
            builder.Property(x => x.PostalCode).HasColumnName(@"PostalCode").HasColumnType("character varying(10)").IsRequired(false).HasMaxLength(10);
            builder.Property(x => x.Country).HasColumnName(@"Country").HasColumnType("character varying(15)").IsRequired(false).HasMaxLength(15);
            builder.Property(x => x.Salesperson).HasColumnName(@"salesperson").HasColumnType("text").IsRequired(false).IsUnicode(false);
            builder.Property(x => x.OrderId).HasColumnName(@"OrderID").HasColumnType("smallint").IsRequired(false);
            builder.Property(x => x.OrderDate).HasColumnName(@"OrderDate").HasColumnType("date").IsRequired(false);
            builder.Property(x => x.RequiredDate).HasColumnName(@"RequiredDate").HasColumnType("date").IsRequired(false);
            builder.Property(x => x.ShippedDate).HasColumnName(@"ShippedDate").HasColumnType("date").IsRequired(false);
            builder.Property(x => x.Shippername).HasColumnName(@"shippername").HasColumnType("character varying(40)").IsRequired(false).HasMaxLength(40);
            builder.Property(x => x.ProductId).HasColumnName(@"ProductID").HasColumnType("smallint").IsRequired(false);
            builder.Property(x => x.ProductName).HasColumnName(@"ProductName").HasColumnType("character varying(40)").IsRequired(false).HasMaxLength(40);
            builder.Property(x => x.UnitPrice).HasColumnName(@"UnitPrice").HasColumnType("real").IsRequired(false);
            builder.Property(x => x.Quantity).HasColumnName(@"Quantity").HasColumnType("smallint").IsRequired(false);
            builder.Property(x => x.Discount).HasColumnName(@"Discount").HasColumnType("real").IsRequired(false);
            builder.Property(x => x.Extendedprice).HasColumnName(@"extendedprice").HasColumnType("double precision").IsRequired(false);
            builder.Property(x => x.Freight).HasColumnName(@"Freight").HasColumnType("real").IsRequired(false);
        }
    }

    // orders
    public class OrderConfiguration : IEntityTypeConfiguration<Order>
    {
        public void Configure(EntityTypeBuilder<Order> builder)
        {
            builder.ToTable("orders", "public");
            builder.HasKey(x => x.OrderId).HasName("pk_orders");

            builder.Property(x => x.OrderId).HasColumnName(@"OrderID").HasColumnType("smallint").IsRequired().ValueGeneratedNever();
            builder.Property(x => x.CustomerId).HasColumnName(@"CustomerID").HasColumnType("character").IsRequired(false);
            builder.Property(x => x.EmployeeId).HasColumnName(@"EmployeeID").HasColumnType("smallint").IsRequired(false);
            builder.Property(x => x.OrderDate).HasColumnName(@"OrderDate").HasColumnType("date").IsRequired(false);
            builder.Property(x => x.RequiredDate).HasColumnName(@"RequiredDate").HasColumnType("date").IsRequired(false);
            builder.Property(x => x.ShippedDate).HasColumnName(@"ShippedDate").HasColumnType("date").IsRequired(false);
            builder.Property(x => x.ShipVia).HasColumnName(@"ShipVia").HasColumnType("smallint").IsRequired(false);
            builder.Property(x => x.Freight).HasColumnName(@"Freight").HasColumnType("real").IsRequired(false);
            builder.Property(x => x.ShipName).HasColumnName(@"ShipName").HasColumnType("character varying(40)").IsRequired(false).HasMaxLength(40);
            builder.Property(x => x.ShipAddress).HasColumnName(@"ShipAddress").HasColumnType("character varying(60)").IsRequired(false).HasMaxLength(60);
            builder.Property(x => x.ShipCity).HasColumnName(@"ShipCity").HasColumnType("character varying(15)").IsRequired(false).HasMaxLength(15);
            builder.Property(x => x.ShipRegion).HasColumnName(@"ShipRegion").HasColumnType("character varying(15)").IsRequired(false).HasMaxLength(15);
            builder.Property(x => x.ShipPostalCode).HasColumnName(@"ShipPostalCode").HasColumnType("character varying(10)").IsRequired(false).HasMaxLength(10);
            builder.Property(x => x.ShipCountry).HasColumnName(@"ShipCountry").HasColumnType("character varying(15)").IsRequired(false).HasMaxLength(15);

            // Foreign keys
            builder.HasOne(a => a.Customer).WithMany(b => b.Orders).HasForeignKey(c => c.CustomerId).OnDelete(DeleteBehavior.ClientSetNull).HasConstraintName("FK_Orders_Customers");
            builder.HasOne(a => a.Employee).WithMany(b => b.Orders).HasForeignKey(c => c.EmployeeId).OnDelete(DeleteBehavior.ClientSetNull).HasConstraintName("FK_Orders_Employees");
            builder.HasOne(a => a.Shipper).WithMany(b => b.Orders).HasForeignKey(c => c.ShipVia).OnDelete(DeleteBehavior.ClientSetNull).HasConstraintName("FK_Orders_Shippers");

            builder.HasIndex(x => x.CustomerId).HasName("CustomerID");
            builder.HasIndex(x => x.CustomerId).HasName("CustomersOrders");
            builder.HasIndex(x => x.EmployeeId).HasName("EmployeeID");
            builder.HasIndex(x => x.EmployeeId).HasName("EmployeesOrders");
            builder.HasIndex(x => x.OrderDate).HasName("OrderDate");
            builder.HasIndex(x => x.ShippedDate).HasName("ShippedDate");
            builder.HasIndex(x => x.ShipVia).HasName("ShippersOrders");
            builder.HasIndex(x => x.ShipPostalCode).HasName("ShipPostalCode");
        }
    }

    // order_details
    public class OrderDetailConfiguration : IEntityTypeConfiguration<OrderDetail>
    {
        public void Configure(EntityTypeBuilder<OrderDetail> builder)
        {
            builder.ToTable("order_details", "public");
            builder.HasKey(x => new { x.OrderId, x.ProductId }).HasName("pk_order_details");

            builder.Property(x => x.OrderId).HasColumnName(@"OrderID").HasColumnType("smallint").IsRequired().ValueGeneratedNever();
            builder.Property(x => x.ProductId).HasColumnName(@"ProductID").HasColumnType("smallint").IsRequired().ValueGeneratedNever();
            builder.Property(x => x.UnitPrice).HasColumnName(@"UnitPrice").HasColumnType("real").IsRequired();
            builder.Property(x => x.Quantity).HasColumnName(@"Quantity").HasColumnType("smallint").IsRequired();
            builder.Property(x => x.Discount).HasColumnName(@"Discount").HasColumnType("real").IsRequired();

            // Foreign keys
            builder.HasOne(a => a.Order).WithMany(b => b.OrderDetails).HasForeignKey(c => c.OrderId).OnDelete(DeleteBehavior.ClientSetNull).HasConstraintName("FK_Order_Details_Orders");
            builder.HasOne(a => a.Product).WithMany(b => b.OrderDetails).HasForeignKey(c => c.ProductId).OnDelete(DeleteBehavior.ClientSetNull).HasConstraintName("FK_Order_Details_Products");

            builder.HasIndex(x => x.OrderId).HasName("OrderID");
            builder.HasIndex(x => x.OrderId).HasName("OrdersOrder_Details");
            builder.HasIndex(x => x.ProductId).HasName("ProductID");
            builder.HasIndex(x => x.ProductId).HasName("ProductsOrder_Details");
        }
    }

    // Order Details Extended
    public class OrderDetailsExtendedConfiguration : IEntityTypeConfiguration<OrderDetailsExtended>
    {
        public void Configure(EntityTypeBuilder<OrderDetailsExtended> builder)
        {
            builder.ToView("Order Details Extended", "public");
            builder.HasNoKey();

            builder.Property(x => x.OrderId).HasColumnName(@"OrderID").HasColumnType("smallint").IsRequired(false);
            builder.Property(x => x.ProductId).HasColumnName(@"ProductID").HasColumnType("smallint").IsRequired(false);
            builder.Property(x => x.ProductName).HasColumnName(@"ProductName").HasColumnType("character varying(40)").IsRequired(false).HasMaxLength(40);
            builder.Property(x => x.UnitPrice).HasColumnName(@"UnitPrice").HasColumnType("real").IsRequired(false);
            builder.Property(x => x.Quantity).HasColumnName(@"Quantity").HasColumnType("smallint").IsRequired(false);
            builder.Property(x => x.Discount).HasColumnName(@"Discount").HasColumnType("real").IsRequired(false);
            builder.Property(x => x.Extendedprice).HasColumnName(@"extendedprice").HasColumnType("double precision").IsRequired(false);
        }
    }

    // Orders Qry
    public class OrdersQryConfiguration : IEntityTypeConfiguration<OrdersQry>
    {
        public void Configure(EntityTypeBuilder<OrdersQry> builder)
        {
            builder.ToView("Orders Qry", "public");
            builder.HasNoKey();

            builder.Property(x => x.OrderId).HasColumnName(@"OrderID").HasColumnType("smallint").IsRequired(false);
            builder.Property(x => x.CustomerId).HasColumnName(@"CustomerID").HasColumnType("character").IsRequired(false);
            builder.Property(x => x.EmployeeId).HasColumnName(@"EmployeeID").HasColumnType("smallint").IsRequired(false);
            builder.Property(x => x.OrderDate).HasColumnName(@"OrderDate").HasColumnType("date").IsRequired(false);
            builder.Property(x => x.RequiredDate).HasColumnName(@"RequiredDate").HasColumnType("date").IsRequired(false);
            builder.Property(x => x.ShippedDate).HasColumnName(@"ShippedDate").HasColumnType("date").IsRequired(false);
            builder.Property(x => x.ShipVia).HasColumnName(@"ShipVia").HasColumnType("smallint").IsRequired(false);
            builder.Property(x => x.Freight).HasColumnName(@"Freight").HasColumnType("real").IsRequired(false);
            builder.Property(x => x.ShipName).HasColumnName(@"ShipName").HasColumnType("character varying(40)").IsRequired(false).HasMaxLength(40);
            builder.Property(x => x.ShipAddress).HasColumnName(@"ShipAddress").HasColumnType("character varying(60)").IsRequired(false).HasMaxLength(60);
            builder.Property(x => x.ShipCity).HasColumnName(@"ShipCity").HasColumnType("character varying(15)").IsRequired(false).HasMaxLength(15);
            builder.Property(x => x.ShipRegion).HasColumnName(@"ShipRegion").HasColumnType("character varying(15)").IsRequired(false).HasMaxLength(15);
            builder.Property(x => x.ShipPostalCode).HasColumnName(@"ShipPostalCode").HasColumnType("character varying(10)").IsRequired(false).HasMaxLength(10);
            builder.Property(x => x.ShipCountry).HasColumnName(@"ShipCountry").HasColumnType("character varying(15)").IsRequired(false).HasMaxLength(15);
            builder.Property(x => x.CompanyName).HasColumnName(@"CompanyName").HasColumnType("character varying(40)").IsRequired(false).HasMaxLength(40);
            builder.Property(x => x.Address).HasColumnName(@"Address").HasColumnType("character varying(60)").IsRequired(false).HasMaxLength(60);
            builder.Property(x => x.City).HasColumnName(@"City").HasColumnType("character varying(15)").IsRequired(false).HasMaxLength(15);
            builder.Property(x => x.Region).HasColumnName(@"Region").HasColumnType("character varying(15)").IsRequired(false).HasMaxLength(15);
            builder.Property(x => x.PostalCode).HasColumnName(@"PostalCode").HasColumnType("character varying(10)").IsRequired(false).HasMaxLength(10);
            builder.Property(x => x.Country).HasColumnName(@"Country").HasColumnType("character varying(15)").IsRequired(false).HasMaxLength(15);
        }
    }

    // Order Subtotals
    public class OrderSubtotalConfiguration : IEntityTypeConfiguration<OrderSubtotal>
    {
        public void Configure(EntityTypeBuilder<OrderSubtotal> builder)
        {
            builder.ToView("Order Subtotals", "public");
            builder.HasNoKey();

            builder.Property(x => x.OrderId).HasColumnName(@"OrderID").HasColumnType("smallint").IsRequired(false);
            builder.Property(x => x.Subtotal).HasColumnName(@"subtotal").HasColumnType("double precision").IsRequired(false);
        }
    }

    // products
    public class ProductConfiguration : IEntityTypeConfiguration<Product>
    {
        public void Configure(EntityTypeBuilder<Product> builder)
        {
            builder.ToTable("products", "public");
            builder.HasKey(x => x.ProductId).HasName("pk_products");

            builder.Property(x => x.ProductId).HasColumnName(@"ProductID").HasColumnType("smallint").IsRequired().ValueGeneratedNever();
            builder.Property(x => x.ProductName).HasColumnName(@"ProductName").HasColumnType("character varying(40)").IsRequired().HasMaxLength(40);
            builder.Property(x => x.SupplierId).HasColumnName(@"SupplierID").HasColumnType("smallint").IsRequired(false);
            builder.Property(x => x.CategoryId).HasColumnName(@"CategoryID").HasColumnType("smallint").IsRequired(false);
            builder.Property(x => x.QuantityPerUnit).HasColumnName(@"QuantityPerUnit").HasColumnType("character varying(20)").IsRequired(false).HasMaxLength(20);
            builder.Property(x => x.UnitPrice).HasColumnName(@"UnitPrice").HasColumnType("real").IsRequired(false);
            builder.Property(x => x.UnitsInStock).HasColumnName(@"UnitsInStock").HasColumnType("smallint").IsRequired(false);
            builder.Property(x => x.UnitsOnOrder).HasColumnName(@"UnitsOnOrder").HasColumnType("smallint").IsRequired(false);
            builder.Property(x => x.ReorderLevel).HasColumnName(@"ReorderLevel").HasColumnType("smallint").IsRequired(false);
            builder.Property(x => x.Discontinued).HasColumnName(@"Discontinued").HasColumnType("integer").IsRequired();

            // Foreign keys
            builder.HasOne(a => a.Category).WithMany(b => b.Products).HasForeignKey(c => c.CategoryId).OnDelete(DeleteBehavior.ClientSetNull).HasConstraintName("FK_Products_Categories");
            builder.HasOne(a => a.Supplier).WithMany(b => b.Products).HasForeignKey(c => c.SupplierId).OnDelete(DeleteBehavior.ClientSetNull).HasConstraintName("FK_Products_Suppliers");

            builder.HasIndex(x => x.CategoryId).HasName("CategoriesProducts");
            builder.HasIndex(x => x.CategoryId).HasName("CategoryID");
            builder.HasIndex(x => x.ProductName).HasName("ProductName");
            builder.HasIndex(x => x.SupplierId).HasName("SupplierID");
            builder.HasIndex(x => x.SupplierId).HasName("SuppliersProducts");
        }
    }

    // Products Above Average Price
    public class ProductsAboveAveragePriceConfiguration : IEntityTypeConfiguration<ProductsAboveAveragePrice>
    {
        public void Configure(EntityTypeBuilder<ProductsAboveAveragePrice> builder)
        {
            builder.ToView("Products Above Average Price", "public");
            builder.HasNoKey();

            builder.Property(x => x.ProductName).HasColumnName(@"ProductName").HasColumnType("character varying(40)").IsRequired(false).HasMaxLength(40);
            builder.Property(x => x.UnitPrice).HasColumnName(@"UnitPrice").HasColumnType("real").IsRequired(false);
        }
    }

    // Product Sales for 1997
    public class ProductSalesFor1997Configuration : IEntityTypeConfiguration<ProductSalesFor1997>
    {
        public void Configure(EntityTypeBuilder<ProductSalesFor1997> builder)
        {
            builder.ToView("Product Sales for 1997", "public");
            builder.HasNoKey();

            builder.Property(x => x.CategoryName).HasColumnName(@"CategoryName").HasColumnType("character varying(15)").IsRequired(false).HasMaxLength(15);
            builder.Property(x => x.ProductName).HasColumnName(@"ProductName").HasColumnType("character varying(40)").IsRequired(false).HasMaxLength(40);
            builder.Property(x => x.ProductSales).HasColumnName(@"ProductSales").HasColumnType("double precision").IsRequired(false);
        }
    }

    // Products by Category
    public class ProductsByCategoryConfiguration : IEntityTypeConfiguration<ProductsByCategory>
    {
        public void Configure(EntityTypeBuilder<ProductsByCategory> builder)
        {
            builder.ToView("Products by Category", "public");
            builder.HasNoKey();

            builder.Property(x => x.CategoryName).HasColumnName(@"CategoryName").HasColumnType("character varying(15)").IsRequired(false).HasMaxLength(15);
            builder.Property(x => x.ProductName).HasColumnName(@"ProductName").HasColumnType("character varying(40)").IsRequired(false).HasMaxLength(40);
            builder.Property(x => x.QuantityPerUnit).HasColumnName(@"QuantityPerUnit").HasColumnType("character varying(20)").IsRequired(false).HasMaxLength(20);
            builder.Property(x => x.UnitsInStock).HasColumnName(@"UnitsInStock").HasColumnType("smallint").IsRequired(false);
            builder.Property(x => x.Discontinued).HasColumnName(@"Discontinued").HasColumnType("integer").IsRequired(false);
        }
    }

    // Quarterly Orders
    public class QuarterlyOrderConfiguration : IEntityTypeConfiguration<QuarterlyOrder>
    {
        public void Configure(EntityTypeBuilder<QuarterlyOrder> builder)
        {
            builder.ToView("Quarterly Orders", "public");
            builder.HasNoKey();

            builder.Property(x => x.CustomerId).HasColumnName(@"CustomerID").HasColumnType("character").IsRequired(false);
            builder.Property(x => x.CompanyName).HasColumnName(@"CompanyName").HasColumnType("character varying(40)").IsRequired(false).HasMaxLength(40);
            builder.Property(x => x.City).HasColumnName(@"City").HasColumnType("character varying(15)").IsRequired(false).HasMaxLength(15);
            builder.Property(x => x.Country).HasColumnName(@"Country").HasColumnType("character varying(15)").IsRequired(false).HasMaxLength(15);
        }
    }

    // region
    public class RegionConfiguration : IEntityTypeConfiguration<Region>
    {
        public void Configure(EntityTypeBuilder<Region> builder)
        {
            builder.ToTable("region", "public");
            builder.HasKey(x => x.RegionId).HasName("pk_region");

            builder.Property(x => x.RegionId).HasColumnName(@"RegionID").HasColumnType("smallint").IsRequired().ValueGeneratedNever();
            builder.Property(x => x.RegionDescription).HasColumnName(@"RegionDescription").HasColumnType("character").IsRequired();
        }
    }

    // Sales by Category
    public class SalesByCategoryConfiguration : IEntityTypeConfiguration<SalesByCategory>
    {
        public void Configure(EntityTypeBuilder<SalesByCategory> builder)
        {
            builder.ToView("Sales by Category", "public");
            builder.HasNoKey();

            builder.Property(x => x.CategoryId).HasColumnName(@"CategoryID").HasColumnType("smallint").IsRequired(false);
            builder.Property(x => x.CategoryName).HasColumnName(@"CategoryName").HasColumnType("character varying(15)").IsRequired(false).HasMaxLength(15);
            builder.Property(x => x.ProductName).HasColumnName(@"ProductName").HasColumnType("character varying(40)").IsRequired(false).HasMaxLength(40);
            builder.Property(x => x.Productsales).HasColumnName(@"productsales").HasColumnType("double precision").IsRequired(false);
        }
    }

    // Sales Totals by Amount
    public class SalesTotalsByAmountConfiguration : IEntityTypeConfiguration<SalesTotalsByAmount>
    {
        public void Configure(EntityTypeBuilder<SalesTotalsByAmount> builder)
        {
            builder.ToView("Sales Totals by Amount", "public");
            builder.HasNoKey();

            builder.Property(x => x.Saleamount).HasColumnName(@"saleamount").HasColumnType("double precision").IsRequired(false);
            builder.Property(x => x.OrderId).HasColumnName(@"OrderID").HasColumnType("smallint").IsRequired(false);
            builder.Property(x => x.CompanyName).HasColumnName(@"CompanyName").HasColumnType("character varying(40)").IsRequired(false).HasMaxLength(40);
            builder.Property(x => x.ShippedDate).HasColumnName(@"ShippedDate").HasColumnType("date").IsRequired(false);
        }
    }

    // shippers
    public class ShipperConfiguration : IEntityTypeConfiguration<Shipper>
    {
        public void Configure(EntityTypeBuilder<Shipper> builder)
        {
            builder.ToTable("shippers", "public");
            builder.HasKey(x => x.ShipperId).HasName("pk_shippers");

            builder.Property(x => x.ShipperId).HasColumnName(@"ShipperID").HasColumnType("smallint").IsRequired().ValueGeneratedNever();
            builder.Property(x => x.CompanyName).HasColumnName(@"CompanyName").HasColumnType("character varying(40)").IsRequired().HasMaxLength(40);
            builder.Property(x => x.Phone).HasColumnName(@"Phone").HasColumnType("character varying(24)").IsRequired(false).HasMaxLength(24);
        }
    }

    // shippers_tmp
    public class ShippersTmpConfiguration : IEntityTypeConfiguration<ShippersTmp>
    {
        public void Configure(EntityTypeBuilder<ShippersTmp> builder)
        {
            builder.ToTable("shippers_tmp", "public");
            builder.HasKey(x => x.ShipperId).HasName("pk_shippers_tmp");

            builder.Property(x => x.ShipperId).HasColumnName(@"ShipperID").HasColumnType("smallint").IsRequired().ValueGeneratedNever();
            builder.Property(x => x.CompanyName).HasColumnName(@"CompanyName").HasColumnType("character varying(40)").IsRequired().HasMaxLength(40);
            builder.Property(x => x.Phone).HasColumnName(@"Phone").HasColumnType("character varying(24)").IsRequired(false).HasMaxLength(24);
        }
    }

    // Summary of Sales by Quarter
    public class SummaryOfSalesByQuarterConfiguration : IEntityTypeConfiguration<SummaryOfSalesByQuarter>
    {
        public void Configure(EntityTypeBuilder<SummaryOfSalesByQuarter> builder)
        {
            builder.ToView("Summary of Sales by Quarter", "public");
            builder.HasNoKey();

            builder.Property(x => x.ShippedDate).HasColumnName(@"ShippedDate").HasColumnType("date").IsRequired(false);
            builder.Property(x => x.OrderId).HasColumnName(@"OrderID").HasColumnType("smallint").IsRequired(false);
            builder.Property(x => x.Subtotal).HasColumnName(@"subtotal").HasColumnType("double precision").IsRequired(false);
        }
    }

    // Summary of Sales by Year
    public class SummaryOfSalesByYearConfiguration : IEntityTypeConfiguration<SummaryOfSalesByYear>
    {
        public void Configure(EntityTypeBuilder<SummaryOfSalesByYear> builder)
        {
            builder.ToView("Summary of Sales by Year", "public");
            builder.HasNoKey();

            builder.Property(x => x.ShippedDate).HasColumnName(@"ShippedDate").HasColumnType("date").IsRequired(false);
            builder.Property(x => x.OrderId).HasColumnName(@"OrderID").HasColumnType("smallint").IsRequired(false);
            builder.Property(x => x.Subtotal).HasColumnName(@"subtotal").HasColumnType("double precision").IsRequired(false);
        }
    }

    // suppliers
    public class SupplierConfiguration : IEntityTypeConfiguration<Supplier>
    {
        public void Configure(EntityTypeBuilder<Supplier> builder)
        {
            builder.ToTable("suppliers", "public");
            builder.HasKey(x => x.SupplierId).HasName("pk_suppliers");

            builder.Property(x => x.SupplierId).HasColumnName(@"SupplierID").HasColumnType("smallint").IsRequired().ValueGeneratedNever();
            builder.Property(x => x.CompanyName).HasColumnName(@"CompanyName").HasColumnType("character varying(40)").IsRequired().HasMaxLength(40);
            builder.Property(x => x.ContactName).HasColumnName(@"ContactName").HasColumnType("character varying(30)").IsRequired(false).HasMaxLength(30);
            builder.Property(x => x.ContactTitle).HasColumnName(@"ContactTitle").HasColumnType("character varying(30)").IsRequired(false).HasMaxLength(30);
            builder.Property(x => x.Address).HasColumnName(@"Address").HasColumnType("character varying(60)").IsRequired(false).HasMaxLength(60);
            builder.Property(x => x.City).HasColumnName(@"City").HasColumnType("character varying(15)").IsRequired(false).HasMaxLength(15);
            builder.Property(x => x.Region).HasColumnName(@"Region").HasColumnType("character varying(15)").IsRequired(false).HasMaxLength(15);
            builder.Property(x => x.PostalCode).HasColumnName(@"PostalCode").HasColumnType("character varying(10)").IsRequired(false).HasMaxLength(10);
            builder.Property(x => x.Country).HasColumnName(@"Country").HasColumnType("character varying(15)").IsRequired(false).HasMaxLength(15);
            builder.Property(x => x.Phone).HasColumnName(@"Phone").HasColumnType("character varying(24)").IsRequired(false).HasMaxLength(24);
            builder.Property(x => x.Fax).HasColumnName(@"Fax").HasColumnType("character varying(24)").IsRequired(false).HasMaxLength(24);
            builder.Property(x => x.HomePage).HasColumnName(@"HomePage").HasColumnType("text").IsRequired(false).IsUnicode(false);

            builder.HasIndex(x => x.CompanyName).HasName("IX_CompanyName");
            builder.HasIndex(x => x.PostalCode).HasName("IX_PostalCode");
        }
    }

    // territories
    public class TerritoryConfiguration : IEntityTypeConfiguration<Territory>
    {
        public void Configure(EntityTypeBuilder<Territory> builder)
        {
            builder.ToTable("territories", "public");
            builder.HasKey(x => x.TerritoryId).HasName("pk_territories");

            builder.Property(x => x.TerritoryId).HasColumnName(@"TerritoryID").HasColumnType("character varying(20)").IsRequired().HasMaxLength(20).ValueGeneratedNever();
            builder.Property(x => x.TerritoryDescription).HasColumnName(@"TerritoryDescription").HasColumnType("character").IsRequired();
            builder.Property(x => x.RegionId).HasColumnName(@"RegionID").HasColumnType("smallint").IsRequired();

            // Foreign keys
            builder.HasOne(a => a.Region).WithMany(b => b.Territories).HasForeignKey(c => c.RegionId).OnDelete(DeleteBehavior.ClientSetNull).HasConstraintName("FK_Territories_Region");
        }
    }

    // usstates
    public class UsstateConfiguration : IEntityTypeConfiguration<Usstate>
    {
        public void Configure(EntityTypeBuilder<Usstate> builder)
        {
            builder.ToTable("usstates", "public");
            builder.HasKey(x => x.StateId);

            builder.Property(x => x.StateId).HasColumnName(@"StateID").HasColumnType("smallint").IsRequired().ValueGeneratedNever();
            builder.Property(x => x.StateName).HasColumnName(@"StateName").HasColumnType("character varying(100)").IsRequired(false).HasMaxLength(100);
            builder.Property(x => x.StateAbbr).HasColumnName(@"StateAbbr").HasColumnType("character varying(2)").IsRequired(false).HasMaxLength(2);
            builder.Property(x => x.StateRegion).HasColumnName(@"StateRegion").HasColumnType("character varying(50)").IsRequired(false).HasMaxLength(50);
        }
    }


    #endregion

}
// </auto-generated>
