// <auto-generated>

using Microsoft.Data.Sqlite;
using Microsoft.EntityFrameworkCore;
using Microsoft.EntityFrameworkCore.ChangeTracking;
using Microsoft.EntityFrameworkCore.Design;
using Microsoft.EntityFrameworkCore.Infrastructure;
using Microsoft.EntityFrameworkCore.Metadata;
using Microsoft.EntityFrameworkCore.Metadata.Builders;
using Microsoft.EntityFrameworkCore.Query;
using Microsoft.EntityFrameworkCore.Query.Internal;
using Microsoft.EntityFrameworkCore.Storage;
using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.ComponentModel;
using System.Data;
using System.Data.SqlTypes;
using System.Linq;
using System.Linq.Expressions;
using System.Reflection;
using System.Threading;
using System.Threading.Tasks;

namespace Efrpg.SQLite
{
    #region Database context interface

    public interface IMyDbContext : IDisposable
    {
        DbSet<Efrpg> Efrpgs { get; set; } // Efrpg
        DbSet<EfrpgItem> EfrpgItems { get; set; } // EfrpgItems
        DbSet<ThisIsAView> ThisIsAViews { get; set; } // ThisIsAView

        int SaveChanges();
        int SaveChanges(bool acceptAllChangesOnSuccess);
        Task<int> SaveChangesAsync(CancellationToken cancellationToken = default(CancellationToken));
        Task<int> SaveChangesAsync(bool acceptAllChangesOnSuccess, CancellationToken cancellationToken = default(CancellationToken));
        DatabaseFacade Database { get; }
        DbSet<TEntity> Set<TEntity>() where TEntity : class;
        string ToString();

        EntityEntry Add(object entity);
        EntityEntry<TEntity> Add<TEntity>(TEntity entity) where TEntity : class;
        Task AddRangeAsync(params object[] entities);
        Task AddRangeAsync(IEnumerable<object> entities, CancellationToken cancellationToken = default);
        ValueTask<EntityEntry<TEntity>> AddAsync<TEntity>(TEntity entity, CancellationToken cancellationToken = default) where TEntity : class;
        ValueTask<EntityEntry> AddAsync(object entity, CancellationToken cancellationToken = default);
        void AddRange(IEnumerable<object> entities);
        void AddRange(params object[] entities);

        EntityEntry Attach(object entity);
        EntityEntry<TEntity> Attach<TEntity>(TEntity entity) where TEntity : class;
        void AttachRange(IEnumerable<object> entities);
        void AttachRange(params object[] entities);

        EntityEntry Entry(object entity);
        EntityEntry<TEntity> Entry<TEntity>(TEntity entity) where TEntity : class;

        TEntity Find<TEntity>(params object[] keyValues) where TEntity : class;
        ValueTask<TEntity> FindAsync<TEntity>(object[] keyValues, CancellationToken cancellationToken) where TEntity : class;
        ValueTask<TEntity> FindAsync<TEntity>(params object[] keyValues) where TEntity : class;
        ValueTask<object> FindAsync(Type entityType, object[] keyValues, CancellationToken cancellationToken);
        ValueTask<object> FindAsync(Type entityType, params object[] keyValues);
        object Find(Type entityType, params object[] keyValues);

        EntityEntry Remove(object entity);
        EntityEntry<TEntity> Remove<TEntity>(TEntity entity) where TEntity : class;
        void RemoveRange(IEnumerable<object> entities);
        void RemoveRange(params object[] entities);

        EntityEntry Update(object entity);
        EntityEntry<TEntity> Update<TEntity>(TEntity entity) where TEntity : class;
        void UpdateRange(IEnumerable<object> entities);
        void UpdateRange(params object[] entities);

        IQueryable<TResult> FromExpression<TResult> (Expression<Func<IQueryable<TResult>>> expression);
    }

    #endregion

    #region Database context

    public class MyDbContext : DbContext, IMyDbContext
    {
        public MyDbContext()
        {
        }

        public MyDbContext(DbContextOptions<MyDbContext> options)
            : base(options)
        {
        }

        public DbSet<Efrpg> Efrpgs { get; set; } // Efrpg
        public DbSet<EfrpgItem> EfrpgItems { get; set; } // EfrpgItems
        public DbSet<ThisIsAView> ThisIsAViews { get; set; } // ThisIsAView

        protected override void OnConfiguring(DbContextOptionsBuilder optionsBuilder)
        {
            if (!optionsBuilder.IsConfigured)
            {
                optionsBuilder.UseSqlite(@"Data Source=C:\Users\simon\AppData\Local\Temp\Efrpg.db");
                optionsBuilder.UseLazyLoadingProxies();
            }
        }

        public bool IsSqlParameterNull(SqliteParameter param)
        {
            var sqlValue = param.Value;
            var nullableValue = sqlValue as INullable;
            if (nullableValue != null)
                return nullableValue.IsNull;
            return (sqlValue == null || sqlValue == DBNull.Value);
        }

        protected override void OnModelCreating(ModelBuilder modelBuilder)
        {
            base.OnModelCreating(modelBuilder);

            modelBuilder.ApplyConfiguration(new EfrpgConfiguration());
            modelBuilder.ApplyConfiguration(new EfrpgItemConfiguration());
            modelBuilder.ApplyConfiguration(new ThisIsAViewConfiguration());

            modelBuilder.Entity<Efrpg>().ToTable(tb => tb.HasTrigger("efrpg_trigger"));
        }

    }

    #endregion

    #region Database context factory

    public class MyDbContextFactory : IDesignTimeDbContextFactory<MyDbContext>
    {
        public MyDbContext CreateDbContext(string[] args)
        {
            return new MyDbContext();
        }
    }

    #endregion

    #region Fake Database context

    public class FakeMyDbContext : IMyDbContext
    {
        public DbSet<Efrpg> Efrpgs { get; set; } // Efrpg
        public DbSet<EfrpgItem> EfrpgItems { get; set; } // EfrpgItems
        public DbSet<ThisIsAView> ThisIsAViews { get; set; } // ThisIsAView

        public FakeMyDbContext()
        {
            _database = new FakeDatabaseFacade(new MyDbContext());

            Efrpgs = new FakeDbSet<Efrpg>("Id");
            EfrpgItems = new FakeDbSet<EfrpgItem>("Id");
            ThisIsAViews = new FakeDbSet<ThisIsAView>();

        }

        public int SaveChangesCount { get; private set; }
        public virtual int SaveChanges()
        {
            ++SaveChangesCount;
            return 1;
        }

        public virtual int SaveChanges(bool acceptAllChangesOnSuccess)
        {
            return SaveChanges();
        }

        public virtual Task<int> SaveChangesAsync(CancellationToken cancellationToken)
        {
            ++SaveChangesCount;
            return Task<int>.Factory.StartNew(() => 1, cancellationToken);
        }
        public virtual Task<int> SaveChangesAsync(bool acceptAllChangesOnSuccess, CancellationToken cancellationToken)
        {
            ++SaveChangesCount;
            return Task<int>.Factory.StartNew(x => 1, acceptAllChangesOnSuccess, cancellationToken);
        }

        protected virtual void Dispose(bool disposing)
        {
        }

        public void Dispose()
        {
            Dispose(true);
        }

        private DatabaseFacade _database;
        public DatabaseFacade Database { get { return _database; } }

        public DbSet<TEntity> Set<TEntity>() where TEntity : class
        {
            throw new NotImplementedException();
        }

        public override string ToString()
        {
            throw new NotImplementedException();
        }

        public virtual EntityEntry Add(object entity)
        {
            throw new NotImplementedException();
        }

        public virtual EntityEntry<TEntity> Add<TEntity>(TEntity entity) where TEntity : class
        {
            throw new NotImplementedException();
        }

        public virtual Task AddRangeAsync(params object[] entities)
        {
            throw new NotImplementedException();
        }

        public virtual async Task AddRangeAsync(IEnumerable<object> entities, CancellationToken cancellationToken = default)
        {
            await Task.CompletedTask;
            throw new NotImplementedException();
        }

        public virtual async ValueTask<EntityEntry<TEntity>> AddAsync<TEntity>(TEntity entity, CancellationToken cancellationToken = default) where TEntity : class
        {
            await Task.CompletedTask;
            throw new NotImplementedException();
        }

        public virtual async ValueTask<EntityEntry> AddAsync(object entity, CancellationToken cancellationToken = default)
        {
            await Task.CompletedTask;
            throw new NotImplementedException();
        }

        public virtual void AddRange(IEnumerable<object> entities)
        {
            throw new NotImplementedException();
        }

        public virtual void AddRange(params object[] entities)
        {
            throw new NotImplementedException();
        }

        public virtual EntityEntry Attach(object entity)
        {
            throw new NotImplementedException();
        }

        public virtual EntityEntry<TEntity> Attach<TEntity>(TEntity entity) where TEntity : class
        {
            throw new NotImplementedException();
        }

        public virtual void AttachRange(IEnumerable<object> entities)
        {
            throw new NotImplementedException();
        }

        public virtual void AttachRange(params object[] entities)
        {
            throw new NotImplementedException();
        }

        public virtual EntityEntry Entry(object entity)
        {
            throw new NotImplementedException();
        }

        public virtual EntityEntry<TEntity> Entry<TEntity>(TEntity entity) where TEntity : class
        {
            throw new NotImplementedException();
        }

        public virtual TEntity Find<TEntity>(params object[] keyValues) where TEntity : class
        {
            throw new NotImplementedException();
        }

        public virtual ValueTask<TEntity> FindAsync<TEntity>(object[] keyValues, CancellationToken cancellationToken) where TEntity : class
        {
            throw new NotImplementedException();
        }

        public virtual ValueTask<TEntity> FindAsync<TEntity>(params object[] keyValues) where TEntity : class
        {
            throw new NotImplementedException();
        }

        public virtual ValueTask<object> FindAsync(Type entityType, object[] keyValues, CancellationToken cancellationToken)
        {
            throw new NotImplementedException();
        }

        public virtual ValueTask<object> FindAsync(Type entityType, params object[] keyValues)
        {
            throw new NotImplementedException();
        }

        public virtual object Find(Type entityType, params object[] keyValues)
        {
            throw new NotImplementedException();
        }

        public virtual EntityEntry Remove(object entity)
        {
            throw new NotImplementedException();
        }

        public virtual EntityEntry<TEntity> Remove<TEntity>(TEntity entity) where TEntity : class
        {
            throw new NotImplementedException();
        }

        public virtual void RemoveRange(IEnumerable<object> entities)
        {
            throw new NotImplementedException();
        }

        public virtual void RemoveRange(params object[] entities)
        {
            throw new NotImplementedException();
        }

        public virtual EntityEntry Update(object entity)
        {
            throw new NotImplementedException();
        }

        public virtual EntityEntry<TEntity> Update<TEntity>(TEntity entity) where TEntity : class
        {
            throw new NotImplementedException();
        }

        public virtual void UpdateRange(IEnumerable<object> entities)
        {
            throw new NotImplementedException();
        }

        public virtual void UpdateRange(params object[] entities)
        {
            throw new NotImplementedException();
        }

        public virtual IQueryable<TResult> FromExpression<TResult> (Expression<Func<IQueryable<TResult>>> expression)
        {
            throw new NotImplementedException();
        }

    }

    #endregion

    #region Fake DbSet

    // ************************************************************************
    // Fake DbSet
    // Implementing Find:
    //      The Find method is difficult to implement in a generic fashion. If
    //      you need to test code that makes use of the Find method it is
    //      easiest to create a test DbSet for each of the entity types that
    //      need to support find. You can then write logic to find that
    //      particular type of entity, as shown below:
    //      public class FakeBlogDbSet : FakeDbSet<Blog>
    //      {
    //          public override Blog Find(params object[] keyValues)
    //          {
    //              var id = (int) keyValues.Single();
    //              return this.SingleOrDefault(b => b.BlogId == id);
    //          }
    //      }
    //      Read more about it here: https://msdn.microsoft.com/en-us/data/dn314431.aspx
    public class FakeDbSet<TEntity> :
        DbSet<TEntity>,
        IQueryable<TEntity>,
        IAsyncEnumerable<TEntity>,
        IListSource,
        IResettableService
        where TEntity : class
    {
        private readonly PropertyInfo[] _primaryKeys;
        private ObservableCollection<TEntity> _data;
        private IQueryable _query;
        public override IEntityType EntityType { get; }

        public FakeDbSet()
        {
            _primaryKeys = null;
            _data        = new ObservableCollection<TEntity>();
            _query       = _data.AsQueryable();
        }

        public FakeDbSet(params string[] primaryKeys)
        {
            _primaryKeys = typeof(TEntity).GetProperties().Where(x => primaryKeys.Contains(x.Name)).ToArray();
            _data        = new ObservableCollection<TEntity>();
            _query       = _data.AsQueryable();
        }

        public override TEntity Find(params object[] keyValues)
        {
            if (_primaryKeys == null)
                throw new ArgumentException("No primary keys defined");
            if (keyValues.Length != _primaryKeys.Length)
                throw new ArgumentException("Incorrect number of keys passed to Find method");

            var keyQuery = this.AsQueryable();
            keyQuery = keyValues
                .Select((t, i) => i)
                .Aggregate(keyQuery,
                    (current, x) =>
                        current.Where(entity => _primaryKeys[x].GetValue(entity, null).Equals(keyValues[x])));

            return keyQuery.SingleOrDefault();
        }

        public override ValueTask<TEntity> FindAsync(object[] keyValues, CancellationToken cancellationToken)
        {
            return new ValueTask<TEntity>(Task<TEntity>.Factory.StartNew(() => Find(keyValues), cancellationToken));
        }

        public override ValueTask<TEntity> FindAsync(params object[] keyValues)
        {
            return new ValueTask<TEntity>(Task<TEntity>.Factory.StartNew(() => Find(keyValues)));
        }

        public override EntityEntry<TEntity> Add(TEntity entity)
        {
            _data.Add(entity);
            return null;
        }

        public override ValueTask<EntityEntry<TEntity>> AddAsync(TEntity entity, CancellationToken cancellationToken = default)
        {
            return new ValueTask<EntityEntry<TEntity>>(Task<EntityEntry<TEntity>>.Factory.StartNew(() => Add(entity), cancellationToken));
        }

        public override void AddRange(params TEntity[] entities)
        {
            if (entities == null) throw new ArgumentNullException("entities");
            foreach (var entity in entities)
                _data.Add(entity);
        }

        public override void AddRange(IEnumerable<TEntity> entities)
        {
            if (entities == null) throw new ArgumentNullException("entities");
            foreach (var entity in entities)
                _data.Add(entity);
        }

        public override Task AddRangeAsync(params TEntity[] entities)
        {
            if (entities == null) throw new ArgumentNullException("entities");
            return Task.Factory.StartNew(() => AddRange(entities));
        }

        public override Task AddRangeAsync(IEnumerable<TEntity> entities, CancellationToken cancellationToken = default)
        {
            if (entities == null) throw new ArgumentNullException("entities");
            return Task.Factory.StartNew(() => AddRange(entities), cancellationToken);
        }

        public override EntityEntry<TEntity> Attach(TEntity entity)
        {
            if (entity == null) throw new ArgumentNullException("entity");
            return Add(entity);
        }

        public override void AttachRange(params TEntity[] entities)
        {
            if (entities == null) throw new ArgumentNullException("entities");
            AddRange(entities);
        }

        public override void AttachRange(IEnumerable<TEntity> entities)
        {
            if (entities == null) throw new ArgumentNullException("entities");
            AddRange(entities);
        }

        public override EntityEntry<TEntity> Remove(TEntity entity)
        {
            _data.Remove(entity);
            return null;
        }

        public override void RemoveRange(params TEntity[] entities)
        {
            if (entities == null) throw new ArgumentNullException("entities");
            foreach (var entity in entities.ToList())
                _data.Remove(entity);
        }

        public override void RemoveRange(IEnumerable<TEntity> entities)
        {
            RemoveRange(entities.ToArray());
        }

        public override EntityEntry<TEntity> Update(TEntity entity)
        {
            _data.Remove(entity);
            _data.Add(entity);
            return null;
        }

        public override void UpdateRange(params TEntity[] entities)
        {
            if (entities == null) throw new ArgumentNullException("entities");
            RemoveRange(entities);
            AddRange(entities);
        }

        public override void UpdateRange(IEnumerable<TEntity> entities)
        {
            if (entities == null) throw new ArgumentNullException("entities");
            var array = entities.ToArray();        RemoveRange(array);
            AddRange(array);
        }

        bool IListSource.ContainsListCollection => true;

        public IList GetList()
        {
            return _data;
        }

        IList IListSource.GetList()
        {
            return _data;
        }

        Type IQueryable.ElementType
        {
            get { return _query.ElementType; }
        }

        Expression IQueryable.Expression
        {
            get { return _query.Expression; }
        }

        IQueryProvider IQueryable.Provider
        {
            get { return new FakeDbAsyncQueryProvider<TEntity>(_data); }
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return _data.GetEnumerator();
        }

        IEnumerator<TEntity> IEnumerable<TEntity>.GetEnumerator()
        {
            return _data.GetEnumerator();
        }

        public override IAsyncEnumerator<TEntity> GetAsyncEnumerator(CancellationToken cancellationToken = default)
        {
            return new FakeDbAsyncEnumerator<TEntity>(this.AsEnumerable().GetEnumerator());
        }

        public void ResetState()
        {
            _data  = new ObservableCollection<TEntity>();
            _query = _data.AsQueryable();
        }

        public Task ResetStateAsync(CancellationToken cancellationToken = new CancellationToken())
        {
            return Task.Factory.StartNew(() => ResetState());
        }
    }

    public class FakeDbAsyncQueryProvider<TEntity> : FakeQueryProvider<TEntity>, IAsyncEnumerable<TEntity>, IAsyncQueryProvider
    {
        public FakeDbAsyncQueryProvider(Expression expression) : base(expression)
        {
        }

        public FakeDbAsyncQueryProvider(IEnumerable<TEntity> enumerable) : base(enumerable)
        {
        }

        public TResult ExecuteAsync<TResult>(Expression expression, CancellationToken cancellationToken)
        {
            var expectedResultType = typeof(TResult).GetGenericArguments()[0];
            var executionResult = typeof(IQueryProvider)
                .GetMethods()
                .First(method => method.Name == nameof(IQueryProvider.Execute) && method.IsGenericMethod)
                .MakeGenericMethod(expectedResultType)
                .Invoke(this, new object[] { expression });

            return (TResult) typeof(Task).GetMethod(nameof(Task.FromResult))
                ?.MakeGenericMethod(expectedResultType)
                .Invoke(null, new[] { executionResult });
        }

        public IAsyncEnumerator<TEntity> GetAsyncEnumerator(CancellationToken cancellationToken = default)
        {
            return new FakeDbAsyncEnumerator<TEntity>(this.AsEnumerable().GetEnumerator());
        }
    }

    public class FakeDbAsyncEnumerable<T> : EnumerableQuery<T>, IAsyncEnumerable<T>, IQueryable<T>
    {
        public FakeDbAsyncEnumerable(IEnumerable<T> enumerable)
            : base(enumerable)
        {
        }

        public FakeDbAsyncEnumerable(Expression expression)
            : base(expression)
        {
        }

        public IAsyncEnumerator<T> GetAsyncEnumerator(CancellationToken cancellationToken = new CancellationToken())
        {
            return new FakeDbAsyncEnumerator<T>(this.AsEnumerable().GetEnumerator());
        }

        IAsyncEnumerator<T> IAsyncEnumerable<T>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAsyncEnumerator(cancellationToken);
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return this.AsEnumerable().GetEnumerator();
        }
    }

    public class FakeDbAsyncEnumerator<T> : IAsyncEnumerator<T>
    {
        private readonly IEnumerator<T> _inner;

        public FakeDbAsyncEnumerator(IEnumerator<T> inner)
        {
            _inner = inner;
        }

        public T Current
        {
            get { return _inner.Current; }
        }

        public ValueTask<bool> MoveNextAsync()
        {
            return new ValueTask<bool>(_inner.MoveNext());
        }

        public ValueTask DisposeAsync()
        {
            _inner.Dispose();
            return new ValueTask(Task.CompletedTask);
        }
    }

    public abstract class FakeQueryProvider<T> : IOrderedQueryable<T>, IQueryProvider
    {
        private IEnumerable<T> _enumerable;

        protected FakeQueryProvider(Expression expression)
        {
            Expression = expression;
        }

        protected FakeQueryProvider(IEnumerable<T> enumerable)
        {
            _enumerable = enumerable;
            Expression = enumerable.AsQueryable().Expression;
        }

        public IQueryable CreateQuery(Expression expression)
        {
            if (expression is MethodCallExpression m)
            {
                var resultType = m.Method.ReturnType; // it should be IQueryable<T>
                var tElement = resultType.GetGenericArguments().First();
                return (IQueryable) CreateInstance(tElement, expression);
            }

            return CreateQuery<T>(expression);
        }

        public IQueryable<TEntity> CreateQuery<TEntity>(Expression expression)
        {
            return (IQueryable<TEntity>) CreateInstance(typeof(TEntity), expression);
        }

        private object CreateInstance(Type tElement, Expression expression)
        {
            var queryType = GetType().GetGenericTypeDefinition().MakeGenericType(tElement);
            return Activator.CreateInstance(queryType, expression);
        }

        public object Execute(Expression expression)
        {
            return CompileExpressionItem<object>(expression);
        }

        public TResult Execute<TResult>(Expression expression)
        {
            return CompileExpressionItem<TResult>(expression);
        }

        IEnumerator<T> IEnumerable<T>.GetEnumerator()
        {
            if (_enumerable == null) _enumerable = CompileExpressionItem<IEnumerable<T>>(Expression);
            return _enumerable.GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            if (_enumerable == null) _enumerable = CompileExpressionItem<IEnumerable<T>>(Expression);
            return _enumerable.GetEnumerator();
        }

        public Type ElementType => typeof(T);

        public Expression Expression { get; }

        public IQueryProvider Provider => this;

        private static TResult CompileExpressionItem<TResult>(Expression expression)
        {
            var visitor = new FakeExpressionVisitor();
            var body = visitor.Visit(expression);
            var f = Expression.Lambda<Func<TResult>>(body ?? throw new InvalidOperationException(string.Format("{0} is null", nameof(body))), (IEnumerable<ParameterExpression>) null);
            return f.Compile()();
        }
    }

    public class FakeExpressionVisitor : ExpressionVisitor
    {
    }

    public class FakeDatabaseFacade : DatabaseFacade
    {
        public FakeDatabaseFacade(DbContext context) : base(context)
        {
        }

        public override bool EnsureCreated()
        {
            return true;
        }

        public override Task<bool> EnsureCreatedAsync(CancellationToken cancellationToken = new CancellationToken())
        {
            return Task.FromResult(EnsureCreated());
        }

        public override bool EnsureDeleted()
        {
            return true;
        }

        public override Task<bool> EnsureDeletedAsync(CancellationToken cancellationToken = new CancellationToken())
        {
            return Task.FromResult(EnsureDeleted());
        }

        public override bool CanConnect()
        {
            return true;
        }

        public override Task<bool> CanConnectAsync(CancellationToken cancellationToken = new CancellationToken())
        {
            return Task.FromResult(CanConnect());
        }

        public override IDbContextTransaction BeginTransaction()
        {
            return new FakeDbContextTransaction();
        }

        public override Task<IDbContextTransaction> BeginTransactionAsync(CancellationToken cancellationToken = new CancellationToken())
        {
            return Task.FromResult(BeginTransaction());
        }

        public override void CommitTransaction()
        {
        }

        public override Task CommitTransactionAsync(CancellationToken cancellationToken = new CancellationToken())
        {
            return Task.CompletedTask;
        }

        public override void RollbackTransaction()
        {
        }

        public override Task RollbackTransactionAsync(CancellationToken cancellationToken = new CancellationToken())
        {
            return Task.CompletedTask;
        }

        public override IExecutionStrategy CreateExecutionStrategy()
        {
            return null;
        }

        public override string ToString()
        {
            return string.Empty;
        }
    }

    public class FakeDbContextTransaction : IDbContextTransaction
    {
        public Guid TransactionId => Guid.NewGuid();
        public void Commit() { }
        public void Rollback() { }
        public Task CommitAsync(CancellationToken cancellationToken = new CancellationToken()) => Task.CompletedTask;
        public Task RollbackAsync(CancellationToken cancellationToken = new CancellationToken()) => Task.CompletedTask;
        public void Dispose() { }
        public ValueTask DisposeAsync() => default;
    }

    #endregion

    #region POCO classes

    // Efrpg
    public class Efrpg
    {
        public long Id { get; set; } // Id (Primary key)
        public string Text1 { get; set; } // text1
        public string Text2 { get; set; } // text2 (length: 22)
        public string Text3 { get; set; } // text3 (length: 33)
        public string Text4 { get; set; } // text4 (length: 44)
        public string Text5 { get; set; } // text5 (length: 55)
        public string Text6 { get; set; } // text6 (length: 66)
        public string Text7 { get; set; } // text7 (length: 77)
        public string Text8 { get; set; } // text8 (length: 88)
        public string Text9 { get; set; } // text9
        public long? Int1 { get; set; } // int1
        public long? Int2 { get; set; } // int2
        public int? Int3 { get; set; } // int3
        public long? Int4 { get; set; } // int4
        public long? Int5 { get; set; } // int5
        public long? Int6 { get; set; } // int6
        public long? Int7 { get; set; } // int7
        public long? Int8 { get; set; } // INT8
        public byte[] Blob1 { get; set; } // blob1
        public byte[] Blob2 { get; set; } // blob2 (length: 22)
        public double? Real1 { get; set; } // real1
        public double? Real2 { get; set; } // real2
        public double? Real3 { get; set; } // real3
        public double? Real4 { get; set; } // real4
        public decimal? Num1 { get; set; } // num1
        public double? Num2 { get; set; } // num2 (length: 10)
        public double? Num22 { get; set; } // num22 (length: 10)
        public double? Num222 { get; set; } // num222 (length: 10)
        public bool? Num3 { get; set; } // num3
        public DateTime? Date1 { get; set; } // date1
        public DateTime? Date2 { get; set; } // date2

        // Reverse navigation

        /// <summary>
        /// Child EfrpgItems where [EfrpgItems].[EfrpgId] point to this entity (FK_EfrpgItems_EfrpgId_Id)
        /// </summary>
        public virtual ICollection<EfrpgItem> EfrpgItems_EfrpgId { get; set; } // EfrpgItems.FK_EfrpgItems_EfrpgId_Id

        /// <summary>
        /// Child EfrpgItems where [EfrpgItems].[ParentEfrpgId] point to this entity (FK_EfrpgItems_ParentEfrpgId_Id)
        /// </summary>
        public virtual ICollection<EfrpgItem> EfrpgItems_ParentEfrpgId { get; set; } // EfrpgItems.FK_EfrpgItems_ParentEfrpgId_Id

        public Efrpg()
        {
            Text8 = "Hello";
            Int1 = 123;
            EfrpgItems_ParentEfrpgId = new List<EfrpgItem>();
            EfrpgItems_EfrpgId = new List<EfrpgItem>();
        }
    }

    // EfrpgItems
    public class EfrpgItem
    {
        public long Id { get; set; } // Id (Primary key)
        public long EfrpgId { get; set; } // EfrpgId
        public long? ParentEfrpgId { get; set; } // ParentEfrpgId
        public long Test { get; set; } // Test
        public DateTime? CreatedAt { get; set; } // CreatedAt

        // Foreign keys

        /// <summary>
        /// Parent Efrpg pointed by [EfrpgItems].([EfrpgId]) (FK_EfrpgItems_EfrpgId_Id)
        /// </summary>
        public virtual Efrpg Efrpg_EfrpgId { get; set; } // FK_EfrpgItems_EfrpgId_Id

        /// <summary>
        /// Parent Efrpg pointed by [EfrpgItems].([ParentEfrpgId]) (FK_EfrpgItems_ParentEfrpgId_Id)
        /// </summary>
        public virtual Efrpg ParentEfrpg { get; set; } // FK_EfrpgItems_ParentEfrpgId_Id
    }

    // ThisIsAView
    public class ThisIsAView
    {
        public long? Id { get; set; } // Id
        public string Text1 { get; set; } // text1
        public long? Int1 { get; set; } // int1
        public byte[] Blob1 { get; set; } // blob1
        public double? Real1 { get; set; } // real1
        public decimal? Num1 { get; set; } // num1
    }


    #endregion

    #region POCO Configuration

    // Efrpg
    public class EfrpgConfiguration : IEntityTypeConfiguration<Efrpg>
    {
        public void Configure(EntityTypeBuilder<Efrpg> builder)
        {
            builder.ToTable("Efrpg", "main");
            builder.HasKey(x => x.Id);

            builder.Property(x => x.Id).HasColumnName(@"Id").HasColumnType("integer").IsRequired().ValueGeneratedOnAdd();
            builder.Property(x => x.Text1).HasColumnName(@"text1").HasColumnType("text").IsRequired(false).IsUnicode(false);
            builder.Property(x => x.Text2).HasColumnName(@"text2").HasColumnType("character(22)").IsRequired(false).HasMaxLength(22);
            builder.Property(x => x.Text3).HasColumnName(@"text3").HasColumnType("varchar(33)").IsRequired(false).IsUnicode(false).HasMaxLength(33);
            builder.Property(x => x.Text4).HasColumnName(@"text4").HasColumnType("varying character(44)").IsRequired(false).HasMaxLength(44);
            builder.Property(x => x.Text5).HasColumnName(@"text5").HasColumnType("nchar(55)").IsRequired(false).IsFixedLength().HasMaxLength(55);
            builder.Property(x => x.Text6).HasColumnName(@"text6").HasColumnType("native character(66)").IsRequired(false).HasMaxLength(66);
            builder.Property(x => x.Text7).HasColumnName(@"text7").HasColumnType("nvarchar(77)").IsRequired(false).HasMaxLength(77);
            builder.Property(x => x.Text8).HasColumnName(@"text8").HasColumnType("text(88)").IsRequired(false).IsUnicode(false).HasMaxLength(88);
            builder.Property(x => x.Text9).HasColumnName(@"text9").HasColumnType("clob").IsRequired(false);
            builder.Property(x => x.Int1).HasColumnName(@"int1").HasColumnType("integer").IsRequired(false);
            builder.Property(x => x.Int2).HasColumnName(@"int2").HasColumnType("int").IsRequired(false);
            builder.Property(x => x.Int3).HasColumnName(@"int3").HasColumnType("smallint").IsRequired(false);
            builder.Property(x => x.Int4).HasColumnName(@"int4").HasColumnType("mediumint").IsRequired(false);
            builder.Property(x => x.Int5).HasColumnName(@"int5").HasColumnType("bigint").IsRequired(false);
            builder.Property(x => x.Int6).HasColumnName(@"int6").HasColumnType("unsigned big int").IsRequired(false);
            builder.Property(x => x.Int7).HasColumnName(@"int7").HasColumnType("int2").IsRequired(false);
            builder.Property(x => x.Int8).HasColumnName(@"INT8").HasColumnType("int8").IsRequired(false);
            builder.Property(x => x.Blob1).HasColumnName(@"blob1").HasColumnType("blob").IsRequired(false);
            builder.Property(x => x.Blob2).HasColumnName(@"blob2").HasColumnType("blob(22)").IsRequired(false).HasMaxLength(22);
            builder.Property(x => x.Real1).HasColumnName(@"real1").HasColumnType("real").IsRequired(false);
            builder.Property(x => x.Real2).HasColumnName(@"real2").HasColumnType("double").IsRequired(false);
            builder.Property(x => x.Real3).HasColumnName(@"real3").HasColumnType("double precision").IsRequired(false);
            builder.Property(x => x.Real4).HasColumnName(@"real4").HasColumnType("float").IsRequired(false);
            builder.Property(x => x.Num1).HasColumnName(@"num1").HasColumnType("numeric").IsRequired(false);
            builder.Property(x => x.Num2).HasColumnName(@"num2").HasColumnType("decimal(10,5)").IsRequired(false).HasMaxLength(10);
            builder.Property(x => x.Num22).HasColumnName(@"num22").HasColumnType("decimal(10,5)").IsRequired(false).HasMaxLength(10);
            builder.Property(x => x.Num222).HasColumnName(@"num222").HasColumnType("decimal(10,5)").IsRequired(false).HasMaxLength(10);
            builder.Property(x => x.Num3).HasColumnName(@"num3").HasColumnType("boolean").IsRequired(false);
            builder.Property(x => x.Date1).HasColumnName(@"date1").HasColumnType("date").IsRequired(false);
            builder.Property(x => x.Date2).HasColumnName(@"date2").HasColumnType("datetime").IsRequired(false);

            builder.HasIndex(x => new { x.Int1, x.Int2 }).HasDatabaseName("IX_Efrpg_Composite");
        }
    }

    // EfrpgItems
    public class EfrpgItemConfiguration : IEntityTypeConfiguration<EfrpgItem>
    {
        public void Configure(EntityTypeBuilder<EfrpgItem> builder)
        {
            builder.ToTable("EfrpgItems", "main");
            builder.HasKey(x => x.Id);

            builder.Property(x => x.Id).HasColumnName(@"Id").HasColumnType("integer").IsRequired().ValueGeneratedOnAdd();
            builder.Property(x => x.EfrpgId).HasColumnName(@"EfrpgId").HasColumnType("integer").IsRequired();
            builder.Property(x => x.ParentEfrpgId).HasColumnName(@"ParentEfrpgId").HasColumnType("integer").IsRequired(false);
            builder.Property(x => x.Test).HasColumnName(@"Test").HasColumnType("int").IsRequired();
            builder.Property(x => x.CreatedAt).HasColumnName(@"CreatedAt").HasColumnType("datetime").IsRequired(false);

            // Foreign keys
            builder.HasOne(a => a.Efrpg_EfrpgId).WithMany(b => b.EfrpgItems_EfrpgId).HasForeignKey(c => c.EfrpgId).HasConstraintName("FK_EfrpgItems_EfrpgId_Id");
            builder.HasOne(a => a.ParentEfrpg).WithMany(b => b.EfrpgItems_ParentEfrpgId).HasForeignKey(c => c.ParentEfrpgId).HasConstraintName("FK_EfrpgItems_ParentEfrpgId_Id");
        }
    }

    // ThisIsAView
    public class ThisIsAViewConfiguration : IEntityTypeConfiguration<ThisIsAView>
    {
        public void Configure(EntityTypeBuilder<ThisIsAView> builder)
        {
            builder.ToView("ThisIsAView", "main");
            builder.HasNoKey();

            builder.Property(x => x.Id).HasColumnName(@"Id").HasColumnType("integer").IsRequired(false);
            builder.Property(x => x.Text1).HasColumnName(@"text1").HasColumnType("text").IsRequired(false).IsUnicode(false);
            builder.Property(x => x.Int1).HasColumnName(@"int1").HasColumnType("integer").IsRequired(false);
            builder.Property(x => x.Blob1).HasColumnName(@"blob1").HasColumnType("blob").IsRequired(false);
            builder.Property(x => x.Real1).HasColumnName(@"real1").HasColumnType("real").IsRequired(false);
            builder.Property(x => x.Num1).HasColumnName(@"num1").HasColumnType("numeric").IsRequired(false);
        }
    }


    #endregion

}
// </auto-generated>
