
########## fonts start ##########

# Code generated by font_to_py.py (https://github.com/peterhinch/micropython-font-to-py).
# Font: Alibaba-PuHuiTi-Heavy.ttf Char set:  ehlo你好
# Cmd: python3 font_to_py.py -x Alibaba-PuHuiTi-Heavy.ttf 16 font_16.py -c "hello 你好"


def height():
    return 16

def baseline():
    return 14

def max_width():
    return 17

def hmap():
    return True

def reverse():
    return False

def monospaced():
    return False

def min_ch():
    return 32

def max_ch():
    return 22909

_font =\
b'\x08\x00\x00\x00\x00\x7c\x7e\x0e\x0e\x1e\x3c\x38\x00\x38\x38\x38'\
b'\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00'\
b'\x00\x00\x00\x00\x08\x00\x00\x00\x00\x7c\x7e\x0e\x0e\x1e\x3c\x38'\
b'\x00\x38\x38\x38\x00\x00\x0b\x00\x00\x00\x00\x00\x00\x00\x00\x00'\
b'\x00\x00\x1f\x00\x3f\x80\x71\xc0\x7f\xc0\x7f\xc0\x7f\xc0\x70\x40'\
b'\x3f\xc0\x1f\x80\x00\x00\x00\x00\x0b\x00\x00\x00\x00\x00\x70\x00'\
b'\x70\x00\x70\x00\x77\x80\x7f\xc0\x7b\xc0\x71\xc0\x71\xc0\x71\xc0'\
b'\x71\xc0\x71\xc0\x71\xc0\x00\x00\x00\x00\x06\x00\x00\x00\x70\x70'\
b'\x70\x70\x70\x70\x70\x70\x70\x70\x78\x38\x00\x00\x0b\x00\x00\x00'\
b'\x00\x00\x00\x00\x00\x00\x00\x00\x1f\x00\x3f\x80\x71\xc0\x71\xc0'\
b'\x71\xc0\x71\xc0\x71\xc0\x3f\x80\x1f\x00\x00\x00\x00\x00\x11\x00'\
b'\x00\x00\x00\x1d\xc0\x00\x3d\xff\x00\x3b\xff\x00\x3b\x87\x00\x7f'\
b'\x7e\x00\xfb\x72\x00\xf8\x72\x00\x7b\xfe\x00\x3b\xf6\x00\x3b\x77'\
b'\x00\x3f\x77\x00\x3f\x77\x00\x3e\xf3\x00\x3a\xf2\x00\x38\xf0\x00'\
b'\x11\x00\x18\x00\x00\x18\x7f\x00\x7f\x7f\x00\x7f\x7f\x00\x7f\x0e'\
b'\x00\x33\x1c\x00\x37\x1c\x00\x37\xff\x00\x76\xff\x00\x76\xff\x00'\
b'\x7e\x1c\x00\x1e\x1c\x00\x1f\x1c\x00\x3f\x7c\x00\xf3\x7c\x00\x60'\
b'\x38\x00'

_sparse =\
b'\x20\x00\x12\x00\x3f\x00\x24\x00\x65\x00\x36\x00\x68\x00\x58\x00'\
b'\x6c\x00\x7a\x00\x6f\x00\x8c\x00\x60\x4f\xae\x00\x7d\x59\xe0\x00'\

_mvfont = memoryview(_font)
_mvsp = memoryview(_sparse)
ifb = lambda l : l[0] | (l[1] << 8)

def bs(lst, val):
    while True:
        m = (len(lst) & ~ 7) >> 1
        v = ifb(lst[m:])
        if v == val:
            return ifb(lst[m + 2:])
        if not m:
            return 0
        lst = lst[m:] if v < val else lst[:m]

def get_ch(ch):
    doff = bs(_mvsp, ch)
    width = ifb(_mvfont[doff : ])

    next_offs = doff + 2 + ((width - 1)//8 + 1) * 16
    return _mvfont[doff + 2:next_offs], 16, width
 
########## fonts end ##########


import lvgl as lv
import lvgl_helper as lv_h
import lcd
import time
from machine import Timer
from machine import I2C

config_touchscreen_support = True
board_m1n = False
   
if not board_m1n:
	lcd.init()
else:
	lcd.init(type=2, freq=20000000)
if config_touchscreen_support:
	import touchscreen as ts
	i2c = I2C(I2C.I2C0, freq=400000, scl=30, sda=31)
	ts.init(i2c)

try:
	if lv_init_end:
		pass
except Exception:
	lv.init()
	lv_init_end = True

disp_buf1 = lv.disp_buf_t()
buf1_1 = bytearray(320*10)
lv.disp_buf_init(disp_buf1,buf1_1, None, len(buf1_1)//4)
disp_drv = lv.disp_drv_t()
lv.disp_drv_init(disp_drv)
disp_drv.buffer = disp_buf1
disp_drv.flush_cb = lv_h.flush
if board_m1n:
    disp_drv.hor_res = 240
    disp_drv.ver_res = 240
else:
    disp_drv.hor_res = 320
    disp_drv.ver_res = 240
lv.disp_drv_register(disp_drv)

if config_touchscreen_support:
	indev_drv = lv.indev_drv_t()
	lv.indev_drv_init(indev_drv)
	indev_drv.type = lv.INDEV_TYPE.POINTER
	indev_drv.read_cb = lv_h.read
	lv.indev_drv_register(indev_drv)

# lv.log_register_print_cb(lv_h.log)
lv.log_register_print_cb(lambda level,path,line,msg: print('%s(%d): %s' % (path, line, msg)))


font_bitmap = None

def my_get_glyph_dsc_cb(font, dsc_out, unicode_letter, unicode_letter_next):
	global font_bitmap
	# get bitmap
	ret = get_ch(unicode_letter)
	# convert bitmap to what lvgl supported
	dsc_out.adv_w = 16 #max_width()
	dsc_out.box_h = (ret[1]+7) & 0xF8
	dsc_out.box_w = (ret[2]+7) & 0xF8
	dsc_out.ofs_x = 0
	dsc_out.ofs_y = 0
	dsc_out.bpp   = 1
	font_bitmap = bytes(ret[0])
	if dsc_out.box_h != ret[1]: # fill
		if reverse():
			fill = 0xFF
		else:
			fill = 0x00
		font_bitmap += bytes([fill]*(dsc_out.box_w//8 * (dsc_out.box_h-ret[1]) ))
	return True

def my_get_glyph_bitmap_cb( font, unicode_letter):
	global font_bitmap
	return font_bitmap


# new font
my_font = lv.font_t()
my_font.get_glyph_dsc = my_get_glyph_dsc_cb
my_font.get_glyph_bitmap = my_get_glyph_bitmap_cb
my_font.line_height = height()
my_font.base_line = 0 #baseline()

# new style
my_style = lv.style_t()
lv.style_copy(my_style, lv.style_plain)
color_red = lv.color16_t()
color_red.full = lcd.RED
my_style.body.main_color = color_red
my_style.body.grad_color = color_red
my_style.body.radius = 10
color = lv.color16_t()
color.full = lcd.WHITE
my_style.text.font = my_font # use new font
my_style.text.color = color

# root
scr = lv.obj(lv.scr_act())
scr.set_style(my_style)
# scr.set_pos(20, 20)
scr.align(None, lv.ALIGN.CENTER, 0, -30) 
scr.set_size(120,100)

# label
label = lv.label(scr)
label.set_long_mode(label.LONG.SROLL)
label.set_width(100)
label.align(None, lv.ALIGN.CENTER, 0, 0)
label.set_text("你好 hello")
# label.set_text("\u4f60\u597d hello")
# label.set_text(b"\xE4\xBD\xA0\xE5\xA5\xBDhello")

def on_timer(timer):
	lv.tick_inc(5)
	
timer = Timer(Timer.TIMER0, Timer.CHANNEL0, mode=Timer.MODE_PERIODIC, period=5, unit=Timer.UNIT_MS, callback=on_timer, arg=None)

while True:
	tim = time.ticks_ms()
	lv.task_handler()
	while time.ticks_ms()-tim < 5:
		pass



