﻿unit FMX.MaterialIconsFont;

{
  Material Design Icons 3.0.1
  https://material.io/icons/

  Based on FMX.FontAwesome by ZuBy, 2017
  https://github.com/rzaripov1990/FMX.FontAwesome
}

interface

uses
  FMX.Types, FMX.FontGlyphs, System.SysUtils
{$IFDEF ANDROID}
    , FMX.FontGlyphs.Android
{$ENDIF};

const
  {$IF  defined(MSWINDOWS) or defined(MACOS)}
  MaterialIconsFontName  = 'Material Icons';
  {$ELSEIF defined(ANDROID)}
  MaterialIconsFontName  = 'MaterialIcons-Regular';
  {$ENDIF}

const
  mi_3d_rotation = WideChar($e84d);
  mi_ac_unit = WideChar($eb3b);
  mi_access_alarm = WideChar($e190);
  mi_access_alarms = WideChar($e191);
  mi_access_time = WideChar($e192);
  mi_accessibility = WideChar($e84e);
  mi_accessible = WideChar($e914);
  mi_account_balance = WideChar($e84f);
  mi_account_balance_wallet = WideChar($e850);
  mi_account_box = WideChar($e851);
  mi_account_circle = WideChar($e853);
  mi_adb = WideChar($e60e);
  mi_add = WideChar($e145);
  mi_add_a_photo = WideChar($e439);
  mi_add_alarm = WideChar($e193);
  mi_add_alert = WideChar($e003);
  mi_add_box = WideChar($e146);
  mi_add_circle = WideChar($e147);
  mi_add_circle_outline = WideChar($e148);
  mi_add_location = WideChar($e567);
  mi_add_shopping_cart = WideChar($e854);
  mi_add_to_photos = WideChar($e39d);
  mi_add_to_queue = WideChar($e05c);
  mi_adjust = WideChar($e39e);
  mi_airline_seat_flat = WideChar($e630);
  mi_airline_seat_flat_angled = WideChar($e631);
  mi_airline_seat_individual_suite = WideChar($e632);
  mi_airline_seat_legroom_extra = WideChar($e633);
  mi_airline_seat_legroom_normal = WideChar($e634);
  mi_airline_seat_legroom_reduced = WideChar($e635);
  mi_airline_seat_recline_extra = WideChar($e636);
  mi_airline_seat_recline_normal = WideChar($e637);
  mi_airplanemode_active = WideChar($e195);
  mi_airplanemode_inactive = WideChar($e194);
  mi_airplay = WideChar($e055);
  mi_airport_shuttle = WideChar($eb3c);
  mi_alarm = WideChar($e855);
  mi_alarm_add = WideChar($e856);
  mi_alarm_off = WideChar($e857);
  mi_alarm_on = WideChar($e858);
  mi_album = WideChar($e019);
  mi_all_inclusive = WideChar($eb3d);
  mi_all_out = WideChar($e90b);
  mi_android = WideChar($e859);
  mi_announcement = WideChar($e85a);
  mi_apps = WideChar($e5c3);
  mi_archive = WideChar($e149);
  mi_arrow_back = WideChar($e5c4);
  mi_arrow_downward = WideChar($e5db);
  mi_arrow_drop_down = WideChar($e5c5);
  mi_arrow_drop_down_circle = WideChar($e5c6);
  mi_arrow_drop_up = WideChar($e5c7);
  mi_arrow_forward = WideChar($e5c8);
  mi_arrow_upward = WideChar($e5d8);
  mi_art_track = WideChar($e060);
  mi_aspect_ratio = WideChar($e85b);
  mi_assessment = WideChar($e85c);
  mi_assignment = WideChar($e85d);
  mi_assignment_ind = WideChar($e85e);
  mi_assignment_late = WideChar($e85f);
  mi_assignment_return = WideChar($e860);
  mi_assignment_returned = WideChar($e861);
  mi_assignment_turned_in = WideChar($e862);
  mi_assistant = WideChar($e39f);
  mi_assistant_photo = WideChar($e3a0);
  mi_attach_file = WideChar($e226);
  mi_attach_money = WideChar($e227);
  mi_attachment = WideChar($e2bc);
  mi_audiotrack = WideChar($e3a1);
  mi_autorenew = WideChar($e863);
  mi_av_timer = WideChar($e01b);
  mi_backspace = WideChar($e14a);
  mi_backup = WideChar($e864);
  mi_battery_alert = WideChar($e19c);
  mi_battery_charging_full = WideChar($e1a3);
  mi_battery_full = WideChar($e1a4);
  mi_battery_std = WideChar($e1a5);
  mi_battery_unknown = WideChar($e1a6);
  mi_beach_access = WideChar($eb3e);
  mi_beenhere = WideChar($e52d);
  mi_block = WideChar($e14b);
  mi_bluetooth = WideChar($e1a7);
  mi_bluetooth_audio = WideChar($e60f);
  mi_bluetooth_connected = WideChar($e1a8);
  mi_bluetooth_disabled = WideChar($e1a9);
  mi_bluetooth_searching = WideChar($e1aa);
  mi_blur_circular = WideChar($e3a2);
  mi_blur_linear = WideChar($e3a3);
  mi_blur_off = WideChar($e3a4);
  mi_blur_on = WideChar($e3a5);
  mi_book = WideChar($e865);
  mi_bookmark = WideChar($e866);
  mi_bookmark_border = WideChar($e867);
  mi_border_all = WideChar($e228);
  mi_border_bottom = WideChar($e229);
  mi_border_clear = WideChar($e22a);
  mi_border_color = WideChar($e22b);
  mi_border_horizontal = WideChar($e22c);
  mi_border_inner = WideChar($e22d);
  mi_border_left = WideChar($e22e);
  mi_border_outer = WideChar($e22f);
  mi_border_right = WideChar($e230);
  mi_border_style = WideChar($e231);
  mi_border_top = WideChar($e232);
  mi_border_vertical = WideChar($e233);
  mi_branding_watermark = WideChar($e06b);
  mi_brightness_1 = WideChar($e3a6);
  mi_brightness_2 = WideChar($e3a7);
  mi_brightness_3 = WideChar($e3a8);
  mi_brightness_4 = WideChar($e3a9);
  mi_brightness_5 = WideChar($e3aa);
  mi_brightness_6 = WideChar($e3ab);
  mi_brightness_7 = WideChar($e3ac);
  mi_brightness_auto = WideChar($e1ab);
  mi_brightness_high = WideChar($e1ac);
  mi_brightness_low = WideChar($e1ad);
  mi_brightness_medium = WideChar($e1ae);
  mi_broken_image = WideChar($e3ad);
  mi_brush = WideChar($e3ae);
  mi_bubble_chart = WideChar($e6dd);
  mi_bug_report = WideChar($e868);
  mi_build = WideChar($e869);
  mi_burst_mode = WideChar($e43c);
  mi_business = WideChar($e0af);
  mi_business_center = WideChar($eb3f);
  mi_cached = WideChar($e86a);
  mi_cake = WideChar($e7e9);
  mi_call = WideChar($e0b0);
  mi_call_end = WideChar($e0b1);
  mi_call_made = WideChar($e0b2);
  mi_call_merge = WideChar($e0b3);
  mi_call_missed = WideChar($e0b4);
  mi_call_missed_outgoing = WideChar($e0e4);
  mi_call_received = WideChar($e0b5);
  mi_call_split = WideChar($e0b6);
  mi_call_to_action = WideChar($e06c);
  mi_camera = WideChar($e3af);
  mi_camera_alt = WideChar($e3b0);
  mi_camera_enhance = WideChar($e8fc);
  mi_camera_front = WideChar($e3b1);
  mi_camera_rear = WideChar($e3b2);
  mi_camera_roll = WideChar($e3b3);
  mi_cancel = WideChar($e5c9);
  mi_card_giftcard = WideChar($e8f6);
  mi_card_membership = WideChar($e8f7);
  mi_card_travel = WideChar($e8f8);
  mi_casino = WideChar($eb40);
  mi_cast = WideChar($e307);
  mi_cast_connected = WideChar($e308);
  mi_center_focus_strong = WideChar($e3b4);
  mi_center_focus_weak = WideChar($e3b5);
  mi_change_history = WideChar($e86b);
  mi_chat = WideChar($e0b7);
  mi_chat_bubble = WideChar($e0ca);
  mi_chat_bubble_outline = WideChar($e0cb);
  mi_check = WideChar($e5ca);
  mi_check_box = WideChar($e834);
  mi_check_box_outline_blank = WideChar($e835);
  mi_check_circle = WideChar($e86c);
  mi_chevron_left = WideChar($e5cb);
  mi_chevron_right = WideChar($e5cc);
  mi_child_care = WideChar($eb41);
  mi_child_friendly = WideChar($eb42);
  mi_chrome_reader_mode = WideChar($e86d);
  mi_class = WideChar($e86e);
  mi_clear = WideChar($e14c);
  mi_clear_all = WideChar($e0b8);
  mi_close = WideChar($e5cd);
  mi_closed_caption = WideChar($e01c);
  mi_cloud = WideChar($e2bd);
  mi_cloud_circle = WideChar($e2be);
  mi_cloud_done = WideChar($e2bf);
  mi_cloud_download = WideChar($e2c0);
  mi_cloud_off = WideChar($e2c1);
  mi_cloud_queue = WideChar($e2c2);
  mi_cloud_upload = WideChar($e2c3);
  mi_code = WideChar($e86f);
  mi_collections = WideChar($e3b6);
  mi_collections_bookmark = WideChar($e431);
  mi_color_lens = WideChar($e3b7);
  mi_colorize = WideChar($e3b8);
  mi_comment = WideChar($e0b9);
  mi_compare = WideChar($e3b9);
  mi_compare_arrows = WideChar($e915);
  mi_computer = WideChar($e30a);
  mi_confirmation_number = WideChar($e638);
  mi_contact_mail = WideChar($e0d0);
  mi_contact_phone = WideChar($e0cf);
  mi_contacts = WideChar($e0ba);
  mi_content_copy = WideChar($e14d);
  mi_content_cut = WideChar($e14e);
  mi_content_paste = WideChar($e14f);
  mi_control_point = WideChar($e3ba);
  mi_control_point_duplicate = WideChar($e3bb);
  mi_copyright = WideChar($e90c);
  mi_create = WideChar($e150);
  mi_create_new_folder = WideChar($e2cc);
  mi_credit_card = WideChar($e870);
  mi_crop = WideChar($e3be);
  mi_crop_16_9 = WideChar($e3bc);
  mi_crop_3_2 = WideChar($e3bd);
  mi_crop_5_4 = WideChar($e3bf);
  mi_crop_7_5 = WideChar($e3c0);
  mi_crop_din = WideChar($e3c1);
  mi_crop_free = WideChar($e3c2);
  mi_crop_landscape = WideChar($e3c3);
  mi_crop_original = WideChar($e3c4);
  mi_crop_portrait = WideChar($e3c5);
  mi_crop_rotate = WideChar($e437);
  mi_crop_square = WideChar($e3c6);
  mi_dashboard = WideChar($e871);
  mi_data_usage = WideChar($e1af);
  mi_date_range = WideChar($e916);
  mi_dehaze = WideChar($e3c7);
  mi_delete = WideChar($e872);
  mi_delete_forever = WideChar($e92b);
  mi_delete_sweep = WideChar($e16c);
  mi_description = WideChar($e873);
  mi_desktop_mac = WideChar($e30b);
  mi_desktop_windows = WideChar($e30c);
  mi_details = WideChar($e3c8);
  mi_developer_board = WideChar($e30d);
  mi_developer_mode = WideChar($e1b0);
  mi_device_hub = WideChar($e335);
  mi_devices = WideChar($e1b1);
  mi_devices_other = WideChar($e337);
  mi_dialer_sip = WideChar($e0bb);
  mi_dialpad = WideChar($e0bc);
  mi_directions = WideChar($e52e);
  mi_directions_bike = WideChar($e52f);
  mi_directions_boat = WideChar($e532);
  mi_directions_bus = WideChar($e530);
  mi_directions_car = WideChar($e531);
  mi_directions_railway = WideChar($e534);
  mi_directions_run = WideChar($e566);
  mi_directions_subway = WideChar($e533);
  mi_directions_transit = WideChar($e535);
  mi_directions_walk = WideChar($e536);
  mi_disc_full = WideChar($e610);
  mi_dns = WideChar($e875);
  mi_do_not_disturb = WideChar($e612);
  mi_do_not_disturb_alt = WideChar($e611);
  mi_do_not_disturb_off = WideChar($e643);
  mi_do_not_disturb_on = WideChar($e644);
  mi_dock = WideChar($e30e);
  mi_domain = WideChar($e7ee);
  mi_done = WideChar($e876);
  mi_done_all = WideChar($e877);
  mi_donut_large = WideChar($e917);
  mi_donut_small = WideChar($e918);
  mi_drafts = WideChar($e151);
  mi_drag_handle = WideChar($e25d);
  mi_drive_eta = WideChar($e613);
  mi_dvr = WideChar($e1b2);
  mi_edit = WideChar($e3c9);
  mi_edit_location = WideChar($e568);
  mi_eject = WideChar($e8fb);
  mi_email = WideChar($e0be);
  mi_enhanced_encryption = WideChar($e63f);
  mi_equalizer = WideChar($e01d);
  mi_error = WideChar($e000);
  mi_error_outline = WideChar($e001);
  mi_euro_symbol = WideChar($e926);
  mi_ev_station = WideChar($e56d);
  mi_event = WideChar($e878);
  mi_event_available = WideChar($e614);
  mi_event_busy = WideChar($e615);
  mi_event_note = WideChar($e616);
  mi_event_seat = WideChar($e903);
  mi_exit_to_app = WideChar($e879);
  mi_expand_less = WideChar($e5ce);
  mi_expand_more = WideChar($e5cf);
  mi_explicit = WideChar($e01e);
  mi_explore = WideChar($e87a);
  mi_exposure = WideChar($e3ca);
  mi_exposure_neg_1 = WideChar($e3cb);
  mi_exposure_neg_2 = WideChar($e3cc);
  mi_exposure_plus_1 = WideChar($e3cd);
  mi_exposure_plus_2 = WideChar($e3ce);
  mi_exposure_zero = WideChar($e3cf);
  mi_extension = WideChar($e87b);
  mi_face = WideChar($e87c);
  mi_fast_forward = WideChar($e01f);
  mi_fast_rewind = WideChar($e020);
  mi_favorite = WideChar($e87d);
  mi_favorite_border = WideChar($e87e);
  mi_featured_play_list = WideChar($e06d);
  mi_featured_video = WideChar($e06e);
  mi_feedback = WideChar($e87f);
  mi_fiber_dvr = WideChar($e05d);
  mi_fiber_manual_record = WideChar($e061);
  mi_fiber_new = WideChar($e05e);
  mi_fiber_pin = WideChar($e06a);
  mi_fiber_smart_record = WideChar($e062);
  mi_file_download = WideChar($e2c4);
  mi_file_upload = WideChar($e2c6);
  mi_filter = WideChar($e3d3);
  mi_filter_1 = WideChar($e3d0);
  mi_filter_2 = WideChar($e3d1);
  mi_filter_3 = WideChar($e3d2);
  mi_filter_4 = WideChar($e3d4);
  mi_filter_5 = WideChar($e3d5);
  mi_filter_6 = WideChar($e3d6);
  mi_filter_7 = WideChar($e3d7);
  mi_filter_8 = WideChar($e3d8);
  mi_filter_9 = WideChar($e3d9);
  mi_filter_9_plus = WideChar($e3da);
  mi_filter_b_and_w = WideChar($e3db);
  mi_filter_center_focus = WideChar($e3dc);
  mi_filter_drama = WideChar($e3dd);
  mi_filter_frames = WideChar($e3de);
  mi_filter_hdr = WideChar($e3df);
  mi_filter_list = WideChar($e152);
  mi_filter_none = WideChar($e3e0);
  mi_filter_tilt_shift = WideChar($e3e2);
  mi_filter_vintage = WideChar($e3e3);
  mi_find_in_page = WideChar($e880);
  mi_find_replace = WideChar($e881);
  mi_fingerprint = WideChar($e90d);
  mi_first_page = WideChar($e5dc);
  mi_fitness_center = WideChar($eb43);
  mi_flag = WideChar($e153);
  mi_flare = WideChar($e3e4);
  mi_flash_auto = WideChar($e3e5);
  mi_flash_off = WideChar($e3e6);
  mi_flash_on = WideChar($e3e7);
  mi_flight = WideChar($e539);
  mi_flight_land = WideChar($e904);
  mi_flight_takeoff = WideChar($e905);
  mi_flip = WideChar($e3e8);
  mi_flip_to_back = WideChar($e882);
  mi_flip_to_front = WideChar($e883);
  mi_folder = WideChar($e2c7);
  mi_folder_open = WideChar($e2c8);
  mi_folder_shared = WideChar($e2c9);
  mi_folder_special = WideChar($e617);
  mi_font_download = WideChar($e167);
  mi_format_align_center = WideChar($e234);
  mi_format_align_justify = WideChar($e235);
  mi_format_align_left = WideChar($e236);
  mi_format_align_right = WideChar($e237);
  mi_format_bold = WideChar($e238);
  mi_format_clear = WideChar($e239);
  mi_format_color_fill = WideChar($e23a);
  mi_format_color_reset = WideChar($e23b);
  mi_format_color_text = WideChar($e23c);
  mi_format_indent_decrease = WideChar($e23d);
  mi_format_indent_increase = WideChar($e23e);
  mi_format_italic = WideChar($e23f);
  mi_format_line_spacing = WideChar($e240);
  mi_format_list_bulleted = WideChar($e241);
  mi_format_list_numbered = WideChar($e242);
  mi_format_paint = WideChar($e243);
  mi_format_quote = WideChar($e244);
  mi_format_shapes = WideChar($e25e);
  mi_format_size = WideChar($e245);
  mi_format_strikethrough = WideChar($e246);
  mi_format_textdirection_l_to_r = WideChar($e247);
  mi_format_textdirection_r_to_l = WideChar($e248);
  mi_format_underlined = WideChar($e249);
  mi_forum = WideChar($e0bf);
  mi_forward = WideChar($e154);
  mi_forward_10 = WideChar($e056);
  mi_forward_30 = WideChar($e057);
  mi_forward_5 = WideChar($e058);
  mi_free_breakfast = WideChar($eb44);
  mi_fullscreen = WideChar($e5d0);
  mi_fullscreen_exit = WideChar($e5d1);
  mi_functions = WideChar($e24a);
  mi_g_translate = WideChar($e927);
  mi_gamepad = WideChar($e30f);
  mi_games = WideChar($e021);
  mi_gavel = WideChar($e90e);
  mi_gesture = WideChar($e155);
  mi_get_app = WideChar($e884);
  mi_gif = WideChar($e908);
  mi_golf_course = WideChar($eb45);
  mi_gps_fixed = WideChar($e1b3);
  mi_gps_not_fixed = WideChar($e1b4);
  mi_gps_off = WideChar($e1b5);
  mi_grade = WideChar($e885);
  mi_gradient = WideChar($e3e9);
  mi_grain = WideChar($e3ea);
  mi_graphic_eq = WideChar($e1b8);
  mi_grid_off = WideChar($e3eb);
  mi_grid_on = WideChar($e3ec);
  mi_group = WideChar($e7ef);
  mi_group_add = WideChar($e7f0);
  mi_group_work = WideChar($e886);
  mi_hd = WideChar($e052);
  mi_hdr_off = WideChar($e3ed);
  mi_hdr_on = WideChar($e3ee);
  mi_hdr_strong = WideChar($e3f1);
  mi_hdr_weak = WideChar($e3f2);
  mi_headset = WideChar($e310);
  mi_headset_mic = WideChar($e311);
  mi_healing = WideChar($e3f3);
  mi_hearing = WideChar($e023);
  mi_help = WideChar($e887);
  mi_help_outline = WideChar($e8fd);
  mi_high_quality = WideChar($e024);
  mi_highlight = WideChar($e25f);
  mi_highlight_off = WideChar($e888);
  mi_history = WideChar($e889);
  mi_home = WideChar($e88a);
  mi_hot_tub = WideChar($eb46);
  mi_hotel = WideChar($e53a);
  mi_hourglass_empty = WideChar($e88b);
  mi_hourglass_full = WideChar($e88c);
  mi_http = WideChar($e902);
  mi_https = WideChar($e88d);
  mi_image = WideChar($e3f4);
  mi_image_aspect_ratio = WideChar($e3f5);
  mi_import_contacts = WideChar($e0e0);
  mi_import_export = WideChar($e0c3);
  mi_important_devices = WideChar($e912);
  mi_inbox = WideChar($e156);
  mi_indeterminate_check_box = WideChar($e909);
  mi_info = WideChar($e88e);
  mi_info_outline = WideChar($e88f);
  mi_input = WideChar($e890);
  mi_insert_chart = WideChar($e24b);
  mi_insert_comment = WideChar($e24c);
  mi_insert_drive_file = WideChar($e24d);
  mi_insert_emoticon = WideChar($e24e);
  mi_insert_invitation = WideChar($e24f);
  mi_insert_link = WideChar($e250);
  mi_insert_photo = WideChar($e251);
  mi_invert_colors = WideChar($e891);
  mi_invert_colors_off = WideChar($e0c4);
  mi_iso = WideChar($e3f6);
  mi_keyboard = WideChar($e312);
  mi_keyboard_arrow_down = WideChar($e313);
  mi_keyboard_arrow_left = WideChar($e314);
  mi_keyboard_arrow_right = WideChar($e315);
  mi_keyboard_arrow_up = WideChar($e316);
  mi_keyboard_backspace = WideChar($e317);
  mi_keyboard_capslock = WideChar($e318);
  mi_keyboard_hide = WideChar($e31a);
  mi_keyboard_return = WideChar($e31b);
  mi_keyboard_tab = WideChar($e31c);
  mi_keyboard_voice = WideChar($e31d);
  mi_kitchen = WideChar($eb47);
  mi_label = WideChar($e892);
  mi_label_outline = WideChar($e893);
  mi_landscape = WideChar($e3f7);
  mi_language = WideChar($e894);
  mi_laptop = WideChar($e31e);
  mi_laptop_chromebook = WideChar($e31f);
  mi_laptop_mac = WideChar($e320);
  mi_laptop_windows = WideChar($e321);
  mi_last_page = WideChar($e5dd);
  mi_launch = WideChar($e895);
  mi_layers = WideChar($e53b);
  mi_layers_clear = WideChar($e53c);
  mi_leak_add = WideChar($e3f8);
  mi_leak_remove = WideChar($e3f9);
  mi_lens = WideChar($e3fa);
  mi_library_add = WideChar($e02e);
  mi_library_books = WideChar($e02f);
  mi_library_music = WideChar($e030);
  mi_lightbulb_outline = WideChar($e90f);
  mi_line_style = WideChar($e919);
  mi_line_weight = WideChar($e91a);
  mi_linear_scale = WideChar($e260);
  mi_link = WideChar($e157);
  mi_linked_camera = WideChar($e438);
  mi_list = WideChar($e896);
  mi_live_help = WideChar($e0c6);
  mi_live_tv = WideChar($e639);
  mi_local_activity = WideChar($e53f);
  mi_local_airport = WideChar($e53d);
  mi_local_atm = WideChar($e53e);
  mi_local_bar = WideChar($e540);
  mi_local_cafe = WideChar($e541);
  mi_local_car_wash = WideChar($e542);
  mi_local_convenience_store = WideChar($e543);
  mi_local_dining = WideChar($e556);
  mi_local_drink = WideChar($e544);
  mi_local_florist = WideChar($e545);
  mi_local_gas_station = WideChar($e546);
  mi_local_grocery_store = WideChar($e547);
  mi_local_hospital = WideChar($e548);
  mi_local_hotel = WideChar($e549);
  mi_local_laundry_service = WideChar($e54a);
  mi_local_library = WideChar($e54b);
  mi_local_mall = WideChar($e54c);
  mi_local_movies = WideChar($e54d);
  mi_local_offer = WideChar($e54e);
  mi_local_parking = WideChar($e54f);
  mi_local_pharmacy = WideChar($e550);
  mi_local_phone = WideChar($e551);
  mi_local_pizza = WideChar($e552);
  mi_local_play = WideChar($e553);
  mi_local_post_office = WideChar($e554);
  mi_local_printshop = WideChar($e555);
  mi_local_see = WideChar($e557);
  mi_local_shipping = WideChar($e558);
  mi_local_taxi = WideChar($e559);
  mi_location_city = WideChar($e7f1);
  mi_location_disabled = WideChar($e1b6);
  mi_location_off = WideChar($e0c7);
  mi_location_on = WideChar($e0c8);
  mi_location_searching = WideChar($e1b7);
  mi_lock = WideChar($e897);
  mi_lock_open = WideChar($e898);
  mi_lock_outline = WideChar($e899);
  mi_looks = WideChar($e3fc);
  mi_looks_3 = WideChar($e3fb);
  mi_looks_4 = WideChar($e3fd);
  mi_looks_5 = WideChar($e3fe);
  mi_looks_6 = WideChar($e3ff);
  mi_looks_one = WideChar($e400);
  mi_looks_two = WideChar($e401);
  mi_loop = WideChar($e028);
  mi_loupe = WideChar($e402);
  mi_low_priority = WideChar($e16d);
  mi_loyalty = WideChar($e89a);
  mi_mail = WideChar($e158);
  mi_mail_outline = WideChar($e0e1);
  mi_map = WideChar($e55b);
  mi_markunread = WideChar($e159);
  mi_markunread_mailbox = WideChar($e89b);
  mi_memory = WideChar($e322);
  mi_menu = WideChar($e5d2);
  mi_merge_type = WideChar($e252);
  mi_message = WideChar($e0c9);
  mi_mic = WideChar($e029);
  mi_mic_none = WideChar($e02a);
  mi_mic_off = WideChar($e02b);
  mi_mms = WideChar($e618);
  mi_mode_comment = WideChar($e253);
  mi_mode_edit = WideChar($e254);
  mi_monetization_on = WideChar($e263);
  mi_money_off = WideChar($e25c);
  mi_monochrome_photos = WideChar($e403);
  mi_mood = WideChar($e7f2);
  mi_mood_bad = WideChar($e7f3);
  mi_more = WideChar($e619);
  mi_more_horiz = WideChar($e5d3);
  mi_more_vert = WideChar($e5d4);
  mi_motorcycle = WideChar($e91b);
  mi_mouse = WideChar($e323);
  mi_move_to_inbox = WideChar($e168);
  mi_movie = WideChar($e02c);
  mi_movie_creation = WideChar($e404);
  mi_movie_filter = WideChar($e43a);
  mi_multiline_chart = WideChar($e6df);
  mi_music_note = WideChar($e405);
  mi_music_video = WideChar($e063);
  mi_my_location = WideChar($e55c);
  mi_nature = WideChar($e406);
  mi_nature_people = WideChar($e407);
  mi_navigate_before = WideChar($e408);
  mi_navigate_next = WideChar($e409);
  mi_navigation = WideChar($e55d);
  mi_near_me = WideChar($e569);
  mi_network_cell = WideChar($e1b9);
  mi_network_check = WideChar($e640);
  mi_network_locked = WideChar($e61a);
  mi_network_wifi = WideChar($e1ba);
  mi_new_releases = WideChar($e031);
  mi_next_week = WideChar($e16a);
  mi_nfc = WideChar($e1bb);
  mi_no_encryption = WideChar($e641);
  mi_no_sim = WideChar($e0cc);
  mi_not_interested = WideChar($e033);
  mi_note = WideChar($e06f);
  mi_note_add = WideChar($e89c);
  mi_notifications = WideChar($e7f4);
  mi_notifications_active = WideChar($e7f7);
  mi_notifications_none = WideChar($e7f5);
  mi_notifications_off = WideChar($e7f6);
  mi_notifications_paused = WideChar($e7f8);
  mi_offline_pin = WideChar($e90a);
  mi_ondemand_video = WideChar($e63a);
  mi_opacity = WideChar($e91c);
  mi_open_in_browser = WideChar($e89d);
  mi_open_in_new = WideChar($e89e);
  mi_open_with = WideChar($e89f);
  mi_pages = WideChar($e7f9);
  mi_pageview = WideChar($e8a0);
  mi_palette = WideChar($e40a);
  mi_pan_tool = WideChar($e925);
  mi_panorama = WideChar($e40b);
  mi_panorama_fish_eye = WideChar($e40c);
  mi_panorama_horizontal = WideChar($e40d);
  mi_panorama_vertical = WideChar($e40e);
  mi_panorama_wide_angle = WideChar($e40f);
  mi_party_mode = WideChar($e7fa);
  mi_pause = WideChar($e034);
  mi_pause_circle_filled = WideChar($e035);
  mi_pause_circle_outline = WideChar($e036);
  mi_payment = WideChar($e8a1);
  mi_people = WideChar($e7fb);
  mi_people_outline = WideChar($e7fc);
  mi_perm_camera_mic = WideChar($e8a2);
  mi_perm_contact_calendar = WideChar($e8a3);
  mi_perm_data_setting = WideChar($e8a4);
  mi_perm_device_information = WideChar($e8a5);
  mi_perm_identity = WideChar($e8a6);
  mi_perm_media = WideChar($e8a7);
  mi_perm_phone_msg = WideChar($e8a8);
  mi_perm_scan_wifi = WideChar($e8a9);
  mi_person = WideChar($e7fd);
  mi_person_add = WideChar($e7fe);
  mi_person_outline = WideChar($e7ff);
  mi_person_pin = WideChar($e55a);
  mi_person_pin_circle = WideChar($e56a);
  mi_personal_video = WideChar($e63b);
  mi_pets = WideChar($e91d);
  mi_phone = WideChar($e0cd);
  mi_phone_android = WideChar($e324);
  mi_phone_bluetooth_speaker = WideChar($e61b);
  mi_phone_forwarded = WideChar($e61c);
  mi_phone_in_talk = WideChar($e61d);
  mi_phone_iphone = WideChar($e325);
  mi_phone_locked = WideChar($e61e);
  mi_phone_missed = WideChar($e61f);
  mi_phone_paused = WideChar($e620);
  mi_phonelink = WideChar($e326);
  mi_phonelink_erase = WideChar($e0db);
  mi_phonelink_lock = WideChar($e0dc);
  mi_phonelink_off = WideChar($e327);
  mi_phonelink_ring = WideChar($e0dd);
  mi_phonelink_setup = WideChar($e0de);
  mi_photo = WideChar($e410);
  mi_photo_album = WideChar($e411);
  mi_photo_camera = WideChar($e412);
  mi_photo_filter = WideChar($e43b);
  mi_photo_library = WideChar($e413);
  mi_photo_size_select_actual = WideChar($e432);
  mi_photo_size_select_large = WideChar($e433);
  mi_photo_size_select_small = WideChar($e434);
  mi_picture_as_pdf = WideChar($e415);
  mi_picture_in_picture = WideChar($e8aa);
  mi_picture_in_picture_alt = WideChar($e911);
  mi_pie_chart = WideChar($e6c4);
  mi_pie_chart_outlined = WideChar($e6c5);
  mi_pin_drop = WideChar($e55e);
  mi_place = WideChar($e55f);
  mi_play_arrow = WideChar($e037);
  mi_play_circle_filled = WideChar($e038);
  mi_play_circle_outline = WideChar($e039);
  mi_play_for_work = WideChar($e906);
  mi_playlist_add = WideChar($e03b);
  mi_playlist_add_check = WideChar($e065);
  mi_playlist_play = WideChar($e05f);
  mi_plus_one = WideChar($e800);
  mi_poll = WideChar($e801);
  mi_polymer = WideChar($e8ab);
  mi_pool = WideChar($eb48);
  mi_portable_wifi_off = WideChar($e0ce);
  mi_portrait = WideChar($e416);
  mi_power = WideChar($e63c);
  mi_power_input = WideChar($e336);
  mi_power_settings_new = WideChar($e8ac);
  mi_pregnant_woman = WideChar($e91e);
  mi_present_to_all = WideChar($e0df);
  mi_print = WideChar($e8ad);
  mi_priority_high = WideChar($e645);
  mi_public = WideChar($e80b);
  mi_publish = WideChar($e255);
  mi_query_builder = WideChar($e8ae);
  mi_question_answer = WideChar($e8af);
  mi_queue = WideChar($e03c);
  mi_queue_music = WideChar($e03d);
  mi_queue_play_next = WideChar($e066);
  mi_radio = WideChar($e03e);
  mi_radio_button_checked = WideChar($e837);
  mi_radio_button_unchecked = WideChar($e836);
  mi_rate_review = WideChar($e560);
  mi_receipt = WideChar($e8b0);
  mi_recent_actors = WideChar($e03f);
  mi_record_voice_over = WideChar($e91f);
  mi_redeem = WideChar($e8b1);
  mi_redo = WideChar($e15a);
  mi_refresh = WideChar($e5d5);
  mi_remove = WideChar($e15b);
  mi_remove_circle = WideChar($e15c);
  mi_remove_circle_outline = WideChar($e15d);
  mi_remove_from_queue = WideChar($e067);
  mi_remove_red_eye = WideChar($e417);
  mi_remove_shopping_cart = WideChar($e928);
  mi_reorder = WideChar($e8fe);
  mi_repeat = WideChar($e040);
  mi_repeat_one = WideChar($e041);
  mi_replay = WideChar($e042);
  mi_replay_10 = WideChar($e059);
  mi_replay_30 = WideChar($e05a);
  mi_replay_5 = WideChar($e05b);
  mi_reply = WideChar($e15e);
  mi_reply_all = WideChar($e15f);
  mi_report = WideChar($e160);
  mi_report_problem = WideChar($e8b2);
  mi_restaurant = WideChar($e56c);
  mi_restaurant_menu = WideChar($e561);
  mi_restore = WideChar($e8b3);
  mi_restore_page = WideChar($e929);
  mi_ring_volume = WideChar($e0d1);
  mi_room = WideChar($e8b4);
  mi_room_service = WideChar($eb49);
  mi_rotate_90_degrees_ccw = WideChar($e418);
  mi_rotate_left = WideChar($e419);
  mi_rotate_right = WideChar($e41a);
  mi_rounded_corner = WideChar($e920);
  mi_router = WideChar($e328);
  mi_rowing = WideChar($e921);
  mi_rss_feed = WideChar($e0e5);
  mi_rv_hookup = WideChar($e642);
  mi_satellite = WideChar($e562);
  mi_save = WideChar($e161);
  mi_scanner = WideChar($e329);
  mi_schedule = WideChar($e8b5);
  mi_school = WideChar($e80c);
  mi_screen_lock_landscape = WideChar($e1be);
  mi_screen_lock_portrait = WideChar($e1bf);
  mi_screen_lock_rotation = WideChar($e1c0);
  mi_screen_rotation = WideChar($e1c1);
  mi_screen_share = WideChar($e0e2);
  mi_sd_card = WideChar($e623);
  mi_sd_storage = WideChar($e1c2);
  mi_search = WideChar($e8b6);
  mi_security = WideChar($e32a);
  mi_select_all = WideChar($e162);
  mi_send = WideChar($e163);
  mi_sentiment_dissatisfied = WideChar($e811);
  mi_sentiment_neutral = WideChar($e812);
  mi_sentiment_satisfied = WideChar($e813);
  mi_sentiment_very_dissatisfied = WideChar($e814);
  mi_sentiment_very_satisfied = WideChar($e815);
  mi_settings = WideChar($e8b8);
  mi_settings_applications = WideChar($e8b9);
  mi_settings_backup_restore = WideChar($e8ba);
  mi_settings_bluetooth = WideChar($e8bb);
  mi_settings_brightness = WideChar($e8bd);
  mi_settings_cell = WideChar($e8bc);
  mi_settings_ethernet = WideChar($e8be);
  mi_settings_input_antenna = WideChar($e8bf);
  mi_settings_input_component = WideChar($e8c0);
  mi_settings_input_composite = WideChar($e8c1);
  mi_settings_input_hdmi = WideChar($e8c2);
  mi_settings_input_svideo = WideChar($e8c3);
  mi_settings_overscan = WideChar($e8c4);
  mi_settings_phone = WideChar($e8c5);
  mi_settings_power = WideChar($e8c6);
  mi_settings_remote = WideChar($e8c7);
  mi_settings_system_daydream = WideChar($e1c3);
  mi_settings_voice = WideChar($e8c8);
  mi_share = WideChar($e80d);
  mi_shop = WideChar($e8c9);
  mi_shop_two = WideChar($e8ca);
  mi_shopping_basket = WideChar($e8cb);
  mi_shopping_cart = WideChar($e8cc);
  mi_short_text = WideChar($e261);
  mi_show_chart = WideChar($e6e1);
  mi_shuffle = WideChar($e043);
  mi_signal_cellular_4_bar = WideChar($e1c8);
  mi_signal_cellular_connected_no_internet_4_bar = WideChar($e1cd);
  mi_signal_cellular_no_sim = WideChar($e1ce);
  mi_signal_cellular_null = WideChar($e1cf);
  mi_signal_cellular_off = WideChar($e1d0);
  mi_signal_wifi_4_bar = WideChar($e1d8);
  mi_signal_wifi_4_bar_lock = WideChar($e1d9);
  mi_signal_wifi_off = WideChar($e1da);
  mi_sim_card = WideChar($e32b);
  mi_sim_card_alert = WideChar($e624);
  mi_skip_next = WideChar($e044);
  mi_skip_previous = WideChar($e045);
  mi_slideshow = WideChar($e41b);
  mi_slow_motion_video = WideChar($e068);
  mi_smartphone = WideChar($e32c);
  mi_smoke_free = WideChar($eb4a);
  mi_smoking_rooms = WideChar($eb4b);
  mi_sms = WideChar($e625);
  mi_sms_failed = WideChar($e626);
  mi_snooze = WideChar($e046);
  mi_sort = WideChar($e164);
  mi_sort_by_alpha = WideChar($e053);
  mi_spa = WideChar($eb4c);
  mi_space_bar = WideChar($e256);
  mi_speaker = WideChar($e32d);
  mi_speaker_group = WideChar($e32e);
  mi_speaker_notes = WideChar($e8cd);
  mi_speaker_notes_off = WideChar($e92a);
  mi_speaker_phone = WideChar($e0d2);
  mi_spellcheck = WideChar($e8ce);
  mi_star = WideChar($e838);
  mi_star_border = WideChar($e83a);
  mi_star_half = WideChar($e839);
  mi_stars = WideChar($e8d0);
  mi_stay_current_landscape = WideChar($e0d3);
  mi_stay_current_portrait = WideChar($e0d4);
  mi_stay_primary_landscape = WideChar($e0d5);
  mi_stay_primary_portrait = WideChar($e0d6);
  mi_stop = WideChar($e047);
  mi_stop_screen_share = WideChar($e0e3);
  mi_storage = WideChar($e1db);
  mi_store = WideChar($e8d1);
  mi_store_mall_directory = WideChar($e563);
  mi_straighten = WideChar($e41c);
  mi_streetview = WideChar($e56e);
  mi_strikethrough_s = WideChar($e257);
  mi_style = WideChar($e41d);
  mi_subdirectory_arrow_left = WideChar($e5d9);
  mi_subdirectory_arrow_right = WideChar($e5da);
  mi_subject = WideChar($e8d2);
  mi_subscriptions = WideChar($e064);
  mi_subtitles = WideChar($e048);
  mi_subway = WideChar($e56f);
  mi_supervisor_account = WideChar($e8d3);
  mi_surround_sound = WideChar($e049);
  mi_swap_calls = WideChar($e0d7);
  mi_swap_horiz = WideChar($e8d4);
  mi_swap_vert = WideChar($e8d5);
  mi_swap_vertical_circle = WideChar($e8d6);
  mi_switch_camera = WideChar($e41e);
  mi_switch_video = WideChar($e41f);
  mi_sync = WideChar($e627);
  mi_sync_disabled = WideChar($e628);
  mi_sync_problem = WideChar($e629);
  mi_system_update = WideChar($e62a);
  mi_system_update_alt = WideChar($e8d7);
  mi_tab = WideChar($e8d8);
  mi_tab_unselected = WideChar($e8d9);
  mi_tablet = WideChar($e32f);
  mi_tablet_android = WideChar($e330);
  mi_tablet_mac = WideChar($e331);
  mi_tag_faces = WideChar($e420);
  mi_tap_and_play = WideChar($e62b);
  mi_terrain = WideChar($e564);
  mi_text_fields = WideChar($e262);
  mi_text_format = WideChar($e165);
  mi_textsms = WideChar($e0d8);
  mi_texture = WideChar($e421);
  mi_theaters = WideChar($e8da);
  mi_thumb_down = WideChar($e8db);
  mi_thumb_up = WideChar($e8dc);
  mi_thumbs_up_down = WideChar($e8dd);
  mi_time_to_leave = WideChar($e62c);
  mi_timelapse = WideChar($e422);
  mi_timeline = WideChar($e922);
  mi_timer = WideChar($e425);
  mi_timer_10 = WideChar($e423);
  mi_timer_3 = WideChar($e424);
  mi_timer_off = WideChar($e426);
  mi_title = WideChar($e264);
  mi_toc = WideChar($e8de);
  mi_today = WideChar($e8df);
  mi_toll = WideChar($e8e0);
  mi_tonality = WideChar($e427);
  mi_touch_app = WideChar($e913);
  mi_toys = WideChar($e332);
  mi_track_changes = WideChar($e8e1);
  mi_traffic = WideChar($e565);
  mi_train = WideChar($e570);
  mi_tram = WideChar($e571);
  mi_transfer_within_a_station = WideChar($e572);
  mi_transform = WideChar($e428);
  mi_translate = WideChar($e8e2);
  mi_trending_down = WideChar($e8e3);
  mi_trending_flat = WideChar($e8e4);
  mi_trending_up = WideChar($e8e5);
  mi_tune = WideChar($e429);
  mi_turned_in = WideChar($e8e6);
  mi_turned_in_not = WideChar($e8e7);
  mi_tv = WideChar($e333);
  mi_unarchive = WideChar($e169);
  mi_undo = WideChar($e166);
  mi_unfold_less = WideChar($e5d6);
  mi_unfold_more = WideChar($e5d7);
  mi_update = WideChar($e923);
  mi_usb = WideChar($e1e0);
  mi_verified_user = WideChar($e8e8);
  mi_vertical_align_bottom = WideChar($e258);
  mi_vertical_align_center = WideChar($e259);
  mi_vertical_align_top = WideChar($e25a);
  mi_vibration = WideChar($e62d);
  mi_video_call = WideChar($e070);
  mi_video_label = WideChar($e071);
  mi_video_library = WideChar($e04a);
  mi_videocam = WideChar($e04b);
  mi_videocam_off = WideChar($e04c);
  mi_videogame_asset = WideChar($e338);
  mi_view_agenda = WideChar($e8e9);
  mi_view_array = WideChar($e8ea);
  mi_view_carousel = WideChar($e8eb);
  mi_view_column = WideChar($e8ec);
  mi_view_comfy = WideChar($e42a);
  mi_view_compact = WideChar($e42b);
  mi_view_day = WideChar($e8ed);
  mi_view_headline = WideChar($e8ee);
  mi_view_list = WideChar($e8ef);
  mi_view_module = WideChar($e8f0);
  mi_view_quilt = WideChar($e8f1);
  mi_view_stream = WideChar($e8f2);
  mi_view_week = WideChar($e8f3);
  mi_vignette = WideChar($e435);
  mi_visibility = WideChar($e8f4);
  mi_visibility_off = WideChar($e8f5);
  mi_voice_chat = WideChar($e62e);
  mi_voicemail = WideChar($e0d9);
  mi_volume_down = WideChar($e04d);
  mi_volume_mute = WideChar($e04e);
  mi_volume_off = WideChar($e04f);
  mi_volume_up = WideChar($e050);
  mi_vpn_key = WideChar($e0da);
  mi_vpn_lock = WideChar($e62f);
  mi_wallpaper = WideChar($e1bc);
  mi_warning = WideChar($e002);
  mi_watch = WideChar($e334);
  mi_watch_later = WideChar($e924);
  mi_wb_auto = WideChar($e42c);
  mi_wb_cloudy = WideChar($e42d);
  mi_wb_incandescent = WideChar($e42e);
  mi_wb_iridescent = WideChar($e436);
  mi_wb_sunny = WideChar($e430);
  mi_wc = WideChar($e63d);
  mi_web = WideChar($e051);
  mi_web_asset = WideChar($e069);
  mi_weekend = WideChar($e16b);
  mi_whatshot = WideChar($e80e);
  mi_widgets = WideChar($e1bd);
  mi_wifi = WideChar($e63e);
  mi_wifi_lock = WideChar($e1e1);
  mi_wifi_tethering = WideChar($e1e2);
  mi_work = WideChar($e8f9);
  mi_wrap_text = WideChar($e25b);
  mi_youtube_searched_for = WideChar($e8fa);
  mi_zoom_in = WideChar($e8ff);
  mi_zoom_out = WideChar($e900);
  mi_zoom_out_map = WideChar($e56b);

procedure MaterialIconsFontAssign(aControl: TFmxObject);

implementation

uses
  FMX.Graphics;

procedure MaterialIconsFontAssign(aControl: TFmxObject);
var
  aTextSettings: ITextSettings;
begin
  if Supports(aControl, ITextSettings, aTextSettings) then
  begin
    aTextSettings.StyledSettings := [];
    aTextSettings.TextSettings.Font.Family := MaterialIconsFontName;
  end;
end;

end.
