<div align="center">
	<br>
	<br>
	<div>
		<img src="media/logo.png" alt="Awesome Whisper">
		<br>
	</div>
	<br>
	<p>
		<a href="https://openai.com/research/whisper">Whisper</a> is an open-source AI-powered speech recognition system developed by <a href="https://openai.com">OpenAI</a>
	</p>
	<br>
	<a href="https://awesome.re">
		<img src="https://awesome.re/badge-flat2.svg" alt="Awesome">
	</a>
	<br>
	<br>
	<br>
	<br>
	<br>
</div>

## Contents

- [Official](#official)
- [Model variants](#model-variants)
- [Apps](#apps)
- [Web apps](#web-apps)
- [CLI tools](#cli-tools)
- [Playgrounds](#playgrounds)
- [Packages](#packages)
- [Articles](#articles)
- [Videos](#videos)
- [Community](#community)
- [Third-party APIs](#third-party-apis)
- [Related lists](#related-lists)

## Official

- [Introduction](https://openai.com/research/whisper)
- [Source code](https://github.com/openai/whisper)
- [White paper](https://cdn.openai.com/papers/whisper.pdf)

## Model variants

- [Whisper.cpp](https://github.com/ggerganov/whisper.cpp) - Port of Whisper in C++.
	- [Bindings for many languages](https://github.com/ggerganov/whisper.cpp#bindings)
- [WhisperX](https://github.com/m-bain/whisperX) - Adds fast automatic speaker recognition with word-level timestamps and speaker diarization.
- [faster-whisper](https://github.com/guillaumekln/faster-whisper) - Faster reimplementation of Whisper using CTranslate2.
- [Whisper JAX](https://github.com/sanchit-gandhi/whisper-jax) - JAX implementation of Whisper for up to 70x speed-up on TPU.
- [whisper-timestamped](https://github.com/linto-ai/whisper-timestamped) - Adds word-level timestamps and confidence scores.
- [whisper-openvino](https://github.com/zhuzilin/whisper-openvino) - Whisper running on OpenVINO.
- [whisper.tflite](https://github.com/usefulsensors/openai-whisper) - Whisper running on TensorFlow Lite.
- [Whisper variants](https://huggingface.co/models?other=whisper) - Various Whisper variants on Hugging Faces.
- [Whisper-AT](https://github.com/YuanGongND/whisper-at) - Whisper that can recognize non-speech audio events in addition to speech.

## Apps

- [Aiko](https://sindresorhus.com/aiko) - Audio transcription iOS and macOS app.
- [MacWhisper](https://goodsnooze.gumroad.com/l/macwhisper) - Audio transcription macOS app. (Freemium)
- [Whisper Memos](https://apps.apple.com/app/id6443658039) - Audio transcription iOS app. (Freemium)
- [FourYou](https://apps.apple.com/app/id1671616134) - Audio journal iOS app.
- [Jojo Transcribe](https://apps.apple.com/app/id1659864300) - Audio transcription macOS app.
- [Buzz](https://github.com/chidiwilliams/Buzz) - Audio transcription and translation macOS app.
- [WhisperScript](https://store.getwavery.com/l/whisperscript) - Audio transcription macOS app. (Freemium · Electron)
- [Audio Podium](https://apps.apple.com/app/id6449008295) - Audio/video management macOS app.
- [superwhisper](https://superwhisper.com) - Global audio transcription macOS menu bar app.
- [Speech Note](https://github.com/mkiol/dsnote) - Audio transcription Linux app.
- [FridayGPT](https://www.fridaygpt.app) - Dictation macOS app powered by OpenAI API.
- [EasyWhisper](https://easywhisper.io) - Windows and macOS app for audio transcription and speaker diarization. (Freemium)

## Web apps

<!-- ### Hosted and self-hosted -->

### Hosted

- [bigWav](https://bigwav.app) - Audio transcription and annotation tool.
- [Free Podcast Transcription](https://freepodcasttranscription.com) - Runs locally in your browser.
- [Gladia](https://www.gladia.io) - Transcription with real-time processing.

### Self-hosted

- [Subs AI](https://github.com/abdeladim-s/subsai) - Subtitle generation.
- [WaaS](https://github.com/schibsted/WAAS) - GUI and API for Whisper.
- [writeout.ai](https://github.com/beyondcode/writeout.ai) - Laravel app to transcribe and translate audio files.
- [Meeper](https://github.com/pas1ko/meeper) - Transcriptions, summary and more for meetings and any browser tab. (Chrome app)

## CLI tools

- [yt-whisper](https://github.com/m1guelpf/yt-whisper) - YouTube subtitle generation.
- [phonix](https://github.com/platisd/phonix) - Generate captions for videos.
- [whisper-standalone-win](https://github.com/Purfview/whisper-standalone-win) - Standalone Windows executable for Whisper and Faster Whisper.
- [whisper-ctranslate2](https://github.com/Softcatala/whisper-ctranslate2) - Whisper command-line tool based on CTranslate2, compatible with the original.
- [insanely-fast-whisper-cli](https://github.com/ochen1/insanely-fast-whisper-cli) - Achieve transcription speeds near 30x real-time with several optimizations.
- [whisper-diarization](https://github.com/MahmoudAshraf97/whisper-diarization) - Automatic speech recognition with speaker diarization.

## Playgrounds

- [Hugging Faces](https://huggingface.co/spaces/openai/whisper) - Whisper demo running on Hugging Faces. ([Source](https://huggingface.co/spaces/openai/whisper/tree/main))
- [Monster API](https://whisperui.monsterapi.ai) - Whisper demo running on Monster API. ([Source](https://github.com/saharmor/whisper-playground))
- [Web Whisper](https://whisper.r3d.red) - Whisper demo by Pluja. ([Source](https://codeberg.org/pluja/web-whisper))
- [YouTube Video Transcription](https://github.com/ArthurFDLR/whisper-youtube) - Running on Colab.

## Packages

### JavaScript

- [use-whisper](https://github.com/chengsokdara/use-whisper) - React hook.

## Articles

- [Whispers of A.I.'s Modular Future](https://www.newyorker.com/tech/annals-of-technology/whispers-of-ais-modular-future) - The future of machine learning lies in adaptable and accessible open-source speech-transcription programs.
- [How to Run Whisper Speech Recognition Model](https://www.assemblyai.com/blog/how-to-run-openais-whisper-speech-recognition-model/) - Explains how to install and run the model, as well as providing a performance analysis comparing Whisper to other models.
- [Create your own speech to text app using Flask](https://blog.paperspace.com/whisper-openai-flask-application-deployment/) - The tutorial demonstrates Whisper's speech-to-text model, with a demo on running it in a Gradient Notebook and a guide for setting up a Flask app with Gradient Deployments.
- [Convert Podcasts to Text](https://betterprogramming.pub/openais-whisper-tutorial-42140dd696ee) - Tutorial on the Whisper API with Python for speech-to-text transcription, showcasing GPU's faster transcription and advanced technology.

## Videos

- [Open AI's Whisper is Amazing!](https://www.youtube.com/watch?v=OCBZtgQGt1I) - Introduction to Whisper.
- [How to do Free Speech-to-Text Transcription Better Than Google Premium API](https://www.youtube.com/watch?v=msj3wuYf3d8) - Tutorial.
- [Multilingual AI Speech Recognition Live App](https://www.youtube.com/watch?v=ywIyc8l1K1Q) - Tutorial.

## Community

- [Discussions](https://github.com/openai/whisper/discussions)
- [Discord](https://discord.com/invite/openai)

## Third-party APIs

*APIs that use Whisper.*

- [Whisper+](https://www.oneai.com/speech-to-text) - Extension of the Whisper model which adds powerful features such as speaker identification custom vocabulary, summarization, and chapter generation.
- [Replicate](https://replicate.com/openai/whisper) - Use Whisper running on Replicate.

## Related lists

- [awesome-chatgpt](https://github.com/sindresorhus/awesome-chatgpt) - ChatGPT resources.
