import os
import requests
import json
from dotenv import load_dotenv

# Load environment variables from the .env file
load_dotenv()

def get_shodan_exploit_count(query, facet=None):
    """
    This method behaves identically to the "/search" method with the difference that it doesn't return any results.

    :param query: The search query.
    :type query: str
    :param facet: Optional facet parameter.
    :type facet: str
    :return: Dictionary with exploit count information or an error message.
    :rtype: dict or str
    """
    api_key = os.getenv("SHODAN_API_KEY")
    if not api_key:
        return "Please set the 'SHODAN_API_KEY' environment variable with your Shodan API key."

    if not query:
        return "Please specify your query with '-Query [string]'."

    api_endpoint = f"https://exploits.shodan.io/api/count?key={api_key}&query={query}"
    
    if facet:
        api_endpoint += f"&facets={facet}"

    try:
        response = requests.get(api_endpoint)
        response.raise_for_status()  # Raise an exception for non-200 status codes
        return json.loads(response.text)
    except requests.exceptions.RequestException as e:
        return f"Error: {e}"

if __name__ == "__main__":
    # Replace '[string]' with your query and, if needed, specify the '-Facet [string]'
    query_to_search = "[string]"
    facet_to_include = "[string]"  # Optional
    result = get_shodan_exploit_count(query_to_search, facet_to_include)
    if isinstance(result, dict):
        print(json.dumps(result, indent=4))
    else:
        print(result)
