# Contributing #

When contributing to this repository, keep in mind that you can discuss the
change you wish to make via issue, email, or any other method with the owners of
this repository before making a change.

## Issues ##

One of the most straightforward ways to contribute to the development is to
create an issues. If you experience strange behavior on part of the module, or
if you would like to request a feature, please file an issue and we'll look into
it.

## Pull request process ##

To craft an ideal pull request that can be accepted quickly, please follow these
guidelines:

1. Make sure your code compiles correctly
2. Make sure that unit tests pass
3. Write tests for the new behavior
4. Make sure the code is documented and styled according to the [ns-3
   guidelines](https://www.nsnam.org/developers/contributing-code/coding-style
   "ns-3 documentation and style guidelines")
5. Write an example illustrating how to use the new feature
6. Update the documentation in the `doc/lorawan.rst` file
7. For big changes, update the repository README
