# Inators UI

Inators UI is a UI library based on Shadcn UI, designed to simplify the development of stylish and responsive user interfaces in Next.js 14 projects.

## Installation

Install and configure Shadcn UI.

### Create Project

Start by creating a new Next.js project using create-next-app:

```bash
npx create-next-app@latest my-app
```

### Run the CLI

Run the Shadcn UI init command to set up your project:

```bash
npx shadcn-ui@latest init
```

## Inators UI Usage

Install and configure Shadcn UI components.

### Install Components

Start by installing a new component by using commands from the components page dropdown-menu:

```bash
npx shadcn-ui@latest add button dropdown-menu
```

### Copy code from components page

Create a new file using your code editor, e.g., `ButtonOptions.tsx`, in your components folder and copy code from components page.

### Import created component to use it

Add the component to use `ButtonOptions.tsx`:

#### Example Code

```jsx
import ButtonOptions from "@/components/ButtonOptions";
// Your component usage code here
```
