#include "PygmentLexersDlg.h"
#include "ui_PygmentLexersDlg.h"
#include <QStringList>
#include <Qt>

namespace RstPad {

    PygmentLexersDlg::PygmentLexersDlg(QWidget *parent) :
        QDialog(parent),
        ui(new Ui::PygmentLexersDlg)
    {
        ui->setupUi(this);

        setWindowFlags((windowFlags() & ~Qt::WindowContextHelpButtonHint) | Qt::MSWindowsFixedSizeDialogHint);
        setFixedSize(size());

        completer = new QCompleter(pygmentsLexers(), ui->Search);
        completer->setFilterMode(Qt::MatchContains);

        ui->Search->setCompleter(completer);
        ui->Search->setFocus();
    }

    PygmentLexersDlg::~PygmentLexersDlg()
    {
        delete ui;
    }

    QString PygmentLexersDlg::lexer()
    {
        return ui->Search->text();
    }

    QStringList PygmentLexersDlg::pygmentsLexers()
    {
        QStringList lexers;

        // http://pygments.org/docs/lexers/
        lexers.append("as3");
        lexers.append("actionscript3");
        lexers.append("as");
        lexers.append("actionscript");
        lexers.append("mxml");
        lexers.append("bc");
        lexers.append("gap");
        lexers.append("mathematica");
        lexers.append("mma");
        lexers.append("nb");
        lexers.append("mupad");
        lexers.append("at");
        lexers.append("ambienttalk");
        lexers.append("ambienttalk/2");
        lexers.append("apl");
        lexers.append("adl");
        lexers.append("cadl");
        lexers.append("odin");
        lexers.append("c-objdump");
        lexers.append("ca65");
        lexers.append("cpp-objdump");
        lexers.append("c++-objdumb");
        lexers.append("cxx-objdump");
        lexers.append("d-objdump");
        lexers.append("gas");
        lexers.append("asm");
        lexers.append("llvm");
        lexers.append("nasm");
        lexers.append("objdump-nasm");
        lexers.append("objdump");
        lexers.append("autoit");
        lexers.append("ahk");
        lexers.append("autohotkey");
        lexers.append("blitzbasic");
        lexers.append("b3d");
        lexers.append("bplus");
        lexers.append("blitzmax");
        lexers.append("bmax");
        lexers.append("cbmbas");
        lexers.append("monkey");
        lexers.append("qbasic");
        lexers.append("basic");
        lexers.append("abap");
        lexers.append("cobolfree");
        lexers.append("cobol");
        lexers.append("gooddata-cl");
        lexers.append("maql");
        lexers.append("openedge");
        lexers.append("abl");
        lexers.append("progress");
        lexers.append("c");
        lexers.append("cpp");
        lexers.append("c++");
        lexers.append("arduino");
        lexers.append("clay");
        lexers.append("cuda");
        lexers.append("cu");
        lexers.append("ec");
        lexers.append("mql");
        lexers.append("mq4");
        lexers.append("mq5");
        lexers.append("mql4");
        lexers.append("mql5");
        lexers.append("nesc");
        lexers.append("pike");
        lexers.append("swig");
        lexers.append("vala");
        lexers.append("vapi");
        lexers.append("chapel");
        lexers.append("chpl");
        lexers.append("apacheconf");
        lexers.append("aconf");
        lexers.append("apache");
        lexers.append("cfengine3");
        lexers.append("cf3");
        lexers.append("docker");
        lexers.append("dockerfile");
        lexers.append("ini");
        lexers.append("cfg");
        lexers.append("dosini");
        lexers.append("kconfig");
        lexers.append("menuconfig");
        lexers.append("linux-config");
        lexers.append("kernel-config");
        lexers.append("lighty");
        lexers.append("lighttpd");
        lexers.append("nginx");
        lexers.append("pacmanconf");
        lexers.append("pkgconfig");
        lexers.append("properties");
        lexers.append("jproperties");
        lexers.append("registry");
        lexers.append("squidconf");
        lexers.append("squid.conf");
        lexers.append("squid");
        lexers.append("termcap");
        lexers.append("terminfo");
        lexers.append("terraform");
        lexers.append("tf");
        lexers.append("pypylog");
        lexers.append("pypy");
        lexers.append("vctreestatus");
        lexers.append("csound-document");
        lexers.append("csound-csd");
        lexers.append("csound");
        lexers.append("csound-orc");
        lexers.append("csound-score");
        lexers.append("csound-sco");
        lexers.append("css");
        lexers.append("less");
        lexers.append("sass");
        lexers.append("scss");
        lexers.append("croc");
        lexers.append("d");
        lexers.append("minid");
        lexers.append("smali");
        lexers.append("jsonld");
        lexers.append("json-ld");
        lexers.append("json");
        lexers.append("yaml");
        lexers.append("dpatch");
        lexers.append("diff");
        lexers.append("udiff");
        lexers.append("boo");
        lexers.append("aspx-cs");
        lexers.append("csharp");
        lexers.append("c#");
        lexers.append("fsharp");
        lexers.append("nemerle");
        lexers.append("aspx-vb");
        lexers.append("vb.net");
        lexers.append("vbnet");
        lexers.append("alloy");
        lexers.append("bro");
        lexers.append("crmsh");
        lexers.append("pcmk");
        lexers.append("mscgen");
        lexers.append("msc");
        lexers.append("pan");
        lexers.append("protobuf");
        lexers.append("proto");
        lexers.append("puppet");
        lexers.append("rsl");
        lexers.append("thrift");
        lexers.append("vgl");
        lexers.append("dylan-console");
        lexers.append("dylan-repl");
        lexers.append("dylan");
        lexers.append("dylan-lid");
        lexers.append("lid");
        lexers.append("ecl");
        lexers.append("eiffel");
        lexers.append("elm");
        lexers.append("iex");
        lexers.append("elixir");
        lexers.append("ex");
        lexers.append("exs");
        lexers.append("erlang");
        lexers.append("erl");
        lexers.append("befunge");
        lexers.append("boogie");
        lexers.append("brainfuck");
        lexers.append("bf");
        lexers.append("camkes");
        lexers.append("idl4");
        lexers.append("redcode");
        lexers.append("ezhil");
        lexers.append("factor");
        lexers.append("fan");
        lexers.append("felix");
        lexers.append("flx");
        lexers.append("fortranfixed");
        lexers.append("fortran");
        lexers.append("foxpro");
        lexers.append("vfp");
        lexers.append("clipper");
        lexers.append("xbase");
        lexers.append("go");
        lexers.append("abnf");
        lexers.append("bnf");
        lexers.append("cypher");
        lexers.append("asy");
        lexers.append("asymptote");
        lexers.append("glsl");
        lexers.append("gnuplot");
        lexers.append("postscript");
        lexers.append("postscr");
        lexers.append("pov");
        lexers.append("agda");
        lexers.append("cryptol");
        lexers.append("cry");
        lexers.append("haskell");
        lexers.append("hs");
        lexers.append("idris");
        lexers.append("idr");
        lexers.append("koka");
        lexers.append("lagda");
        lexers.append("literate-agda");
        lexers.append("lcry");
        lexers.append("literate-cryptol");
        lexers.append("lcryptol");
        lexers.append("lhs");
        lexers.append("literate-haskell");
        lexers.append("lhaskell");
        lexers.append("lidr");
        lexers.append("literate-idris");
        lexers.append("lidris");
        lexers.append("hx");
        lexers.append("haxe");
        lexers.append("hxsl");
        lexers.append("haxeml");
        lexers.append("hxml");
        lexers.append("systemverilog");
        lexers.append("sv");
        lexers.append("verilog");
        lexers.append("v");
        lexers.append("vhdl");
        lexers.append("hexdump");
        lexers.append("dtd");
        lexers.append("haml");
        lexers.append("html");
        lexers.append("jade");
        lexers.append("scaml");
        lexers.append("xml");
        lexers.append("xslt");
        lexers.append("idl");
        lexers.append("igor");
        lexers.append("igorpro");
        lexers.append("limbo");
        lexers.append("control");
        lexers.append("debcontrol");
        lexers.append("nsis");
        lexers.append("nsi");
        lexers.append("nsh");
        lexers.append("spec");
        lexers.append("sourceslist");
        lexers.append("sources.list");
        lexers.append("debsources");
        lexers.append("inform6");
        lexers.append("i6");
        lexers.append("i6t");
        lexers.append("inform7");
        lexers.append("i7");
        lexers.append("tads3");
        lexers.append("io");
        lexers.append("j");
        lexers.append("coffee-script");
        lexers.append("coffeescript");
        lexers.append("coffee");
        lexers.append("dart");
        lexers.append("earl-grey");
        lexers.append("earlgrey");
        lexers.append("eg");
        lexers.append("js");
        lexers.append("javascript");
        lexers.append("kal");
        lexers.append("lasso");
        lexers.append("lassoscript");
        lexers.append("live-script");
        lexers.append("livescript");
        lexers.append("mask");
        lexers.append("objective-j");
        lexers.append("objectivej");
        lexers.append("obj-j");
        lexers.append("objj");
        lexers.append("ts");
        lexers.append("typescript");
        lexers.append("jlcon");
        lexers.append("julia");
        lexers.append("jl");
        lexers.append("aspectj");
        lexers.append("ceylon");
        lexers.append("clojure");
        lexers.append("clj");
        lexers.append("clojurescript");
        lexers.append("cljs");
        lexers.append("golo");
        lexers.append("gosu");
        lexers.append("gst");
        lexers.append("groovy");
        lexers.append("ioke");
        lexers.append("ik");
        lexers.append("jasmin");
        lexers.append("jasminxt");
        lexers.append("java");
        lexers.append("kotlin");
        lexers.append("pig");
        lexers.append("scala");
        lexers.append("xtend");
        lexers.append("cpsa");
        lexers.append("common-lisp");
        lexers.append("cl");
        lexers.append("lisp");
        lexers.append("emacs");
        lexers.append("elisp");
        lexers.append("emacs-lisp");
        lexers.append("hylang");
        lexers.append("newlisp");
        lexers.append("racket");
        lexers.append("rkt");
        lexers.append("scheme");
        lexers.append("scm");
        lexers.append("shen");
        lexers.append("basemake");
        lexers.append("cmake");
        lexers.append("make");
        lexers.append("makefile");
        lexers.append("mf");
        lexers.append("bsdmake");
        lexers.append("bbcode");
        lexers.append("groff");
        lexers.append("nroff");
        lexers.append("man");
        lexers.append("trac-wiki");
        lexers.append("moin");
        lexers.append("css+mozpreproc");
        lexers.append("mozhashpreproc");
        lexers.append("javascript+mozpreproc");
        lexers.append("mozpercentpreproc");
        lexers.append("xul+mozpreproc");
        lexers.append("rst");
        lexers.append("rest");
        lexers.append("restructuredtext");
        lexers.append("tex");
        lexers.append("latex");
        lexers.append("matlab");
        lexers.append("matlabsession");
        lexers.append("octave");
        lexers.append("scilab");
        lexers.append("ocaml");
        lexers.append("opa");
        lexers.append("sml");
        lexers.append("bugs");
        lexers.append("winbugs");
        lexers.append("openbugs");
        lexers.append("jags");
        lexers.append("modelica");
        lexers.append("stan");
        lexers.append("modula2");
        lexers.append("m2");
        lexers.append("nimrod");
        lexers.append("nim");
        lexers.append("nit");
        lexers.append("nixos");
        lexers.append("nix");
        lexers.append("componentpascal");
        lexers.append("cp");
        lexers.append("logos");
        lexers.append("objective-c");
        lexers.append("objectivec");
        lexers.append("obj-c");
        lexers.append("objc");
        lexers.append("objective-c++");
        lexers.append("objectivec++");
        lexers.append("obj-c++");
        lexers.append("objc++");
        lexers.append("swift");
        lexers.append("ooc");
        lexers.append("parasail");
        lexers.append("antlr-as");
        lexers.append("antlr-actionscript");
        lexers.append("antlr-csharp");
        lexers.append("antlr-c#");
        lexers.append("antlr-cpp");
        lexers.append("antlr-java");
        lexers.append("antlr");
        lexers.append("antlr-objc");
        lexers.append("antlr-perl");
        lexers.append("antlr-python");
        lexers.append("antlr-ruby");
        lexers.append("antlr-rb");
        lexers.append("ebnf");
        lexers.append("ragel-c");
        lexers.append("ragel-cpp");
        lexers.append("ragel-d");
        lexers.append("ragel-em");
        lexers.append("ragel-java");
        lexers.append("ragel");
        lexers.append("ragel-objc");
        lexers.append("ragel-ruby");
        lexers.append("ragel-rb");
        lexers.append("treetop");
        lexers.append("ada");
        lexers.append("ada95");
        lexers.append("ada2005");
        lexers.append("delphi");
        lexers.append("pas");
        lexers.append("pascal");
        lexers.append("objectpascal");
        lexers.append("pawn");
        lexers.append("sp");
        lexers.append("perl6");
        lexers.append("pl6");
        lexers.append("perl");
        lexers.append("pl");
        lexers.append("php");
        lexers.append("php3");
        lexers.append("php4");
        lexers.append("php5");
        lexers.append("zephir");
        lexers.append("praat");
        lexers.append("logtalk");
        lexers.append("prolog");
        lexers.append("cython");
        lexers.append("pyx");
        lexers.append("pyrex");
        lexers.append("dg");
        lexers.append("numpy");
        lexers.append("python3");
        lexers.append("py3");
        lexers.append("py3tb");
        lexers.append("pycon");
        lexers.append("python");
        lexers.append("py");
        lexers.append("sage");
        lexers.append("pytb");
        lexers.append("qvto");
        lexers.append("qvt");
        lexers.append("rconsole");
        lexers.append("rout");
        lexers.append("rd");
        lexers.append("splus");
        lexers.append("s");
        lexers.append("r");
        lexers.append("sparql");
        lexers.append("turtle");
        lexers.append("rebol");
        lexers.append("red");
        lexers.append("red/system");
        lexers.append("resource");
        lexers.append("resourcebundle");
        lexers.append("roboconf-graph");
        lexers.append("roboconf-instances");
        lexers.append("robotframework");
        lexers.append("fancy");
        lexers.append("fy");
        lexers.append("rbcon");
        lexers.append("irb");
        lexers.append("rb");
        lexers.append("ruby");
        lexers.append("duby");
        lexers.append("rust");
        lexers.append("applescript");
        lexers.append("chai");
        lexers.append("chaiscript");
        lexers.append("easytrieve");
        lexers.append("hybris");
        lexers.append("hy");
        lexers.append("jcl");
        lexers.append("lsl");
        lexers.append("lua");
        lexers.append("moocode");
        lexers.append("moo");
        lexers.append("moon");
        lexers.append("moonscript");
        lexers.append("rexx");
        lexers.append("arexx");
        lexers.append("bash");
        lexers.append("sh");
        lexers.append("ksh");
        lexers.append("shell");
        lexers.append("console");
        lexers.append("shell-session");
        lexers.append("bat");
        lexers.append("batch");
        lexers.append("dosbatch");
        lexers.append("winbatch");
        lexers.append("fish");
        lexers.append("fishshell");
        lexers.append("doscon");
        lexers.append("powershell");
        lexers.append("posh");
        lexers.append("ps1");
        lexers.append("psm1");
        lexers.append("ps1con");
        lexers.append("tcsh");
        lexers.append("csh");
        lexers.append("tcshcon");
        lexers.append("newspeak");
        lexers.append("smalltalk");
        lexers.append("squeak");
        lexers.append("st");
        lexers.append("snobol");
        lexers.append("raw");
        lexers.append("text");
        lexers.append("mysql");
        lexers.append("plpgsql");
        lexers.append("psql");
        lexers.append("postgresql-console");
        lexers.append("postgres-console");
        lexers.append("postgresql");
        lexers.append("postgres");
        lexers.append("rql");
        lexers.append("sql");
        lexers.append("sqlite3");
        lexers.append("sc");
        lexers.append("supercollider");
        lexers.append("tcl");
        lexers.append("html+cheetah");
        lexers.append("html+spitfire");
        lexers.append("htmlcheetah");
        lexers.append("js+cheetah");
        lexers.append("javascript+cheetah");
        lexers.append("js+spitfire");
        lexers.append("javascript+spitfire");
        lexers.append("cheetah");
        lexers.append("spitfire");
        lexers.append("xml+cheetah");
        lexers.append("xml+spitfire");
        lexers.append("cfc");
        lexers.append("cfm");
        lexers.append("cfs");
        lexers.append("css+django");
        lexers.append("css+jinja");
        lexers.append("css+erb");
        lexers.append("css+ruby");
        lexers.append("css+genshitext");
        lexers.append("css+genshi");
        lexers.append("css+php");
        lexers.append("css+smarty");
        lexers.append("django");
        lexers.append("jinja");
        lexers.append("erb");
        lexers.append("html+evoque");
        lexers.append("evoque");
        lexers.append("xml+evoque");
        lexers.append("genshi");
        lexers.append("kid");
        lexers.append("xml+genshi");
        lexers.append("xml+kid");
        lexers.append("genshitext");
        lexers.append("html+handlebars");
        lexers.append("handlebars");
        lexers.append("html+django");
        lexers.append("html+jinja");
        lexers.append("htmldjango");
        lexers.append("html+genshi");
        lexers.append("html+kid");
        lexers.append("html+php");
        lexers.append("html+smarty");
        lexers.append("js+django");
        lexers.append("javascript+django");
        lexers.append("js+jinja");
        lexers.append("javascript+jinja");
        lexers.append("js+erb");
        lexers.append("javascript+erb");
        lexers.append("js+ruby");
        lexers.append("javascript+ruby");
        lexers.append("js+genshitext");
        lexers.append("js+genshi");
        lexers.append("javascript+genshitext");
        lexers.append("javascript+genshi");
        lexers.append("js+php");
        lexers.append("javascript+php");
        lexers.append("js+smarty");
        lexers.append("javascript+smarty");
        lexers.append("jsp");
        lexers.append("css+lasso");
        lexers.append("html+lasso");
        lexers.append("js+lasso");
        lexers.append("javascript+lasso");
        lexers.append("xml+lasso");
        lexers.append("liquid");
        lexers.append("css+mako");
        lexers.append("html+mako");
        lexers.append("js+mako");
        lexers.append("javascript+mako");
        lexers.append("mako");
        lexers.append("xml+mako");
        lexers.append("mason");
        lexers.append("css+myghty");
        lexers.append("html+myghty");
        lexers.append("js+myghty");
        lexers.append("javascript+myghty");
        lexers.append("myghty");
        lexers.append("xml+myghty");
        lexers.append("rhtml");
        lexers.append("html+erb");
        lexers.append("html+ruby");
        lexers.append("smarty");
        lexers.append("ssp");
        lexers.append("tea");
        lexers.append("html+twig");
        lexers.append("twig");
        lexers.append("html+velocity");
        lexers.append("velocity");
        lexers.append("xml+velocity");
        lexers.append("xml+django");
        lexers.append("xml+jinja");
        lexers.append("xml+erb");
        lexers.append("xml+ruby");
        lexers.append("xml+php");
        lexers.append("xml+smarty");
        lexers.append("yaml+jinja");
        lexers.append("salt");
        lexers.append("sls");
        lexers.append("cucumber");
        lexers.append("gherkin");
        lexers.append("tap");
        lexers.append("awk");
        lexers.append("gawk");
        lexers.append("mawk");
        lexers.append("nawk");
        lexers.append("vim");
        lexers.append("pot");
        lexers.append("po");
        lexers.append("http");
        lexers.append("irc");
        lexers.append("todotxt");
        lexers.append("coq");
        lexers.append("isabelle");
        lexers.append("lean");
        lexers.append("rts");
        lexers.append("trafficscript");
        lexers.append("urbiscript");
        lexers.append("cirru");
        lexers.append("duel");
        lexers.append("jbst");
        lexers.append("jsonml+bst");
        lexers.append("qml");
        lexers.append("qbs");
        lexers.append("slim");
        lexers.append("xquery");
        lexers.append("xqy");
        lexers.append("xq");
        lexers.append("xql");
        lexers.append("xqm");
        lexers.append("x10");
        lexers.append("xten");

        return lexers;
    }

}
