<h1 align="center">కంప్యూటర్ సైన్స్</h1>
<h4 align="center">
    <p>
        <a href="https://github.com/shhossain/computer_science/blob/main/README.md">English</a> |
        <a href="https://github.com/shhossain/computer_science/blob/main/README_it.md">Italiano</a> |
        <a href="https://github.com/shhossain/computer_science/blob/main/README_es.md">Español</a> |
        <a href="https://github.com/shhossain/computer_science/blob/main/README_fr.md">Français</a> |
        <a href="https://github.com/shhossain/computer_science/blob/main/README_bn.md">বাংলা</a> |
         <b>తెలుగు</b>|
        <a href="https://github.com/shhossain/computer_science/blob/main/README_guj.md">ગુજરાતી</a> |
        <a href="https://github.com/shhossain/computer_science/blob/main/README_pt.md">Portuguese</a> |
        <a href="https://github.com/shhossain/computer_science/blob/main/README_ro.md">Română</a>
    </p>
</h4>

## సహకార మార్గదర్శకాలు

మీరు ఈ ప్రాజెక్ట్‌కు సహకరించడానికి ఆసక్తి కలిగి ఉంటే, దయచేసి సమీక్షించడానికి కొంత సమయం కేటాయించండి [CONTRIBUTING.md](https://github.com/shhossain/computer_science/blob/main/CONTRIBUTING.md) ఎలా ప్రారంభించాలో వివరణాత్మక సూచనల కోసం. మీ సహకారాలు చాలా ప్రశంసించబడ్డాయి!

## విషయ సూచిక

- [పరిచయం](#పరిచయం)
- [ఎలక్ట్రానిక్ కంప్యూటర్](#ఎలక్ట్రానిక్-కంప్యూటర్)
- [బూలియన్ లాజిక్](#బూలియన్-లాజిక్)
- [సంఖ్య వ్యవస్థలు](#సంఖ్య-వ్యవస్థలు)
- [సెంట్రల్ ప్రాసెసింగ్ యూనిట్(CPU)](#central-processing-unit-cpu)
- [రిజిస్టర్లు, కాష్ మరియు RAM](#రిజిస్టర్లు-కాష్-మరియు-రామ్)
- [సూచనలు మరియు ప్రోగ్రామ్](#సూచనలు మరియు ప్రోగ్రామ్)
- [ప్రోగ్రామింగ్ లాంగ్వేజెస్](#ప్రోగ్రామింగ్-లాంగ్వేజెస్)
- [డేటా రకాలు](#డేటా-రకాలు)
- [ప్రకటనలు మరియు విధులు](#స్టేట్‌మెంట్‌లు మరియు విధులు)
- [డేటా నిర్మాణాలు](#డేటా-నిర్మాణాలు)
- [అల్గోరిథంలు](#algorithms)
- [అలన్ ట్యూరింగ్](#అలన్-ట్యూరింగ్)
- [సాఫ్ట్‌వేర్ ఇంజనీరింగ్](#సాఫ్ట్‌వేర్-ఇంజనీరింగ్)
- [ఇంటిగ్రేటెడ్ సర్క్యూట్‌లు](#ఇంటిగ్రేటెడ్-సర్క్యూట్స్)
- [ఆబ్జెక్ట్ ఓరియెంటెడ్ ప్రోగ్రామింగ్](#ఆబ్జెక్ట్-ఓరియెంటెడ్-ప్రోగ్రామింగ్)
- [ఫంక్షనల్ ప్రోగ్రామింగ్](#ఫంక్షనల్-ప్రోగ్రామింగ్)
- [ఆపరేటింగ్ సిస్టమ్స్](#ఆపరేటింగ్-సిస్టమ్స్)
- [మెమరీ మరియు స్టోరేజ్](#మెమరీ-అండ్-స్టోరేజ్)
- [ఫైల్ సిస్టమ్](#ఫైల్-సిస్టమ్)
- [క్లౌడ్ కంప్యూటింగ్](#క్లౌడ్-కంప్యూటింగ్)
- [మెషిన్ లెర్నింగ్](#మెషిన్-లెర్నింగ్)
- [వెబ్ టెక్నాలజీ](#వెబ్-టెక్నాలజీ)
- [నెట్‌వర్కింగ్](#నెట్‌వర్కింగ్)
- [ఇంటర్నెట్](#ఇంటర్నెట్)
- [DBMS(డేటాబేస్ మేనేజ్‌మెంట్ సిస్టమ్)](#dbms)
- [క్రిప్టోగ్రఫీ](#క్రిప్టోగ్రఫీ)
- [గణన సిద్ధాంతం](#థియరీ-ఆఫ్-కంప్యూటేషన్)

## పరిచయం

కంప్యూటర్ సైన్స్ అనేది కంప్యూటర్లు మరియు కంప్యూటింగ్ మరియు వాటి సైద్ధాంతిక మరియు ఆచరణాత్మక అనువర్తనాల అధ్యయనం. కంప్యూటర్ సైన్స్ అనేక సమస్యలకు గణితం, ఇంజనీరింగ్ మరియు లాజిక్ సూత్రాలను వర్తిస్తుంది. వీటిలో అల్గోరిథం ఫార్ములేషన్, సాఫ్ట్‌వేర్/హార్డ్‌వేర్ డెవలప్‌మెంట్ మరియు ఆర్టిఫిషియల్ ఇంటెలిజెన్స్ ఉన్నాయి.


## [ఎలక్ట్రానిక్ కంప్యూటర్](ఎలక్ట్రానిక్%20Computer/readme.md)
గణించే పరికరం, ముఖ్యంగా హై-స్పీడ్ మ్యాథమెటికల్ లేదా లాజికల్ ఆపరేషన్‌లు చేసే లేదా సమీకరించడం, నిల్వ చేయడం, సహసంబంధాలు లేదా సమాచారాన్ని ప్రాసెస్ చేసే ప్రోగ్రామబుల్ ఎలక్ట్రానిక్ మెషీన్.

## [బూలియన్ లాజిక్](Boolean%20Logic/readme.md)
బూలియన్ తర్కం అనేది సత్యం మరియు అసత్యం యొక్క విలువలతో వ్యవహరించే గణిత శాస్త్ర విభాగం. ఇది తర్కం యొక్క వ్యవస్థ, ఇది వరుసగా తప్పుడు మరియు సత్యాన్ని సూచించడానికి 0 మరియు 1 అనే రెండు విలువలను మాత్రమే ఉపయోగిస్తుంది. దీనిని 1854లో మొదటిసారిగా వివరించిన జార్జ్ బూల్ పేరు మీదుగా దీనిని బూలియన్ ఆల్జీబ్రా అని కూడా పిలుస్తారు.

### సాధారణ బూలియన్ ఆపరేటర్లు
| ఆపరేటర్ | పేరు | వివరణ |
| :------: | :--: | :---------------------------------------: |
| ! | కాదు | ఆపరాండ్ విలువను తిరస్కరిస్తుంది. |
| && | మరియు | రెండు ఒపెరాండ్‌లు నిజమైతే **నిజం**ని చూపుతుంది. |
| \|\| | లేదా | ఒకటి లేదా అన్ని ఒపెరాండ్‌లు నిజమైతే **నిజం**ని చూపుతుంది. |

### బూలియన్ ఆపరేటర్లను తెలుసుకోవడం ఆనందంగా ఉంది
| ఆపరేటర్ | పేరు | వివరణ |
| :------: | :--: | :---------------------------------------: |
| () | కుండలీకరణాలు | కీలకపదాలను సమూహపరచడానికి మరియు నిబంధనలను శోధించే క్రమాన్ని నియంత్రించడానికి మిమ్మల్ని అనుమతిస్తుంది. |
| "" | కొటేషన్ గుర్తులు | ఖచ్చితమైన పదబంధంతో ఫలితాలను అందిస్తుంది. |
| * | నక్షత్రం గుర్తు | కీవర్డ్ వైవిధ్యాన్ని కలిగి ఉన్న ఫలితాలను అందిస్తుంది. |
| ⊕ | XOR | ఆపరాండ్‌లు భిన్నంగా ఉంటే **నిజం**ని చూపుతుంది |
| ⊽ | NOR | అన్ని ఒపెరాండ్‌లు తప్పు అయితే **నిజం**ని చూపుతుంది. |
| ⊼ | NAND | దాని రెండు ఇన్‌పుట్‌లలోని రెండు విలువలు నిజం అయితే మాత్రమే **తప్పు**ని చూపుతుంది.


## [సంఖ్య వ్యవస్థలు](సంఖ్య%20System/readme.md#number-systems)
సంఖ్యా వ్యవస్థలు సంఖ్యలను వ్యక్తీకరించడానికి గణిత వ్యవస్థలు. సంఖ్యా వ్యవస్థ సంఖ్యలను సూచించడానికి ఉపయోగించే చిహ్నాల సమితిని మరియు ఆ చిహ్నాలను మార్చడానికి నియమాల సమితిని కలిగి ఉంటుంది. సంఖ్యా వ్యవస్థలో ఉపయోగించే చిహ్నాలను సంఖ్యలు అంటారు.

### [సంఖ్య వ్యవస్థల రకాలు](సంఖ్య%20System/readme.md#types-of-number-systems)
- [స్థాన సంఖ్యా వ్యవస్థ](Number%20System/readme.md#positional-numeral-system)
- [సైన్-వాల్యూ నోటేషన్ సిస్టమ్](సంఖ్య%20System/readme.md#sign-value-notation-system)

### [కామన్ పొజిషనల్ నంబర్ సిస్టమ్స్](Number%20System/readme.md#common-positional-number-systems)
- [బైనరీ](Number%20System/readme.md#binary)
- [అక్టల్](సంఖ్య%20System/readme.md#octal)
- [దశాంశం](సంఖ్య%20System/readme.md#decimal)
- [హెక్సాడెసిమల్](సంఖ్య%20System/readme.md#హెక్సాడెసిమల్)

### బైనరీ ప్రాముఖ్యత
బైనరీ అనేది గాట్‌ఫ్రైడ్ లీబ్నిజ్ చేత కనుగొనబడిన బేస్-2 సంఖ్య వ్యవస్థ, ఇది కేవలం రెండు సంఖ్యలు లేదా అంకెలతో రూపొందించబడింది: 0 (సున్నా) మరియు 1 (ఒకటి). ఈ నంబరింగ్ సిస్టమ్ అన్ని బైనరీ కోడ్‌లకు ఆధారం, ఇది ప్రతిరోజూ ఉపయోగించే కంప్యూటర్ ప్రాసెసర్ సూచనల వంటి డిజిటల్ డేటాను వ్రాయడానికి ఉపయోగించబడుతుంది. బైనరీలోని 0లు మరియు 1లు వరుసగా ఆఫ్ లేదా ఆన్‌ని సూచిస్తాయి. ట్రాన్సిస్టర్‌లో, "0" అనేది విద్యుత్ ప్రవాహాన్ని సూచిస్తుంది మరియు "1" విద్యుత్ ప్రవాహానికి అనుమతించబడుతుందని సూచిస్తుంది. ఈ విధంగా, కంప్యూటింగ్ పరికరం లోపల సంఖ్యలు భౌతికంగా సూచించబడతాయి, గణనలను అనుమతిస్తాయి.

 
బైనరీ ఇప్పటికీ కంప్యూటర్‌లకు ప్రాథమిక భాషగా ఉంది మరియు కింది కారణాల వల్ల ఎలక్ట్రానిక్స్ మరియు కంప్యూటర్ హార్డ్‌వేర్‌తో ఉపయోగించబడుతుంది:

- ఇది సరళమైన మరియు సొగసైన డిజైన్.
- బైనరీ యొక్క 0 మరియు 1 పద్ధతి ఎలక్ట్రికల్ సిగ్నల్ ఆఫ్ (తప్పు) లేదా ఆన్ (నిజమైన) స్థితిని త్వరగా గుర్తించగలదు.
- ఎలక్ట్రికల్ సిగ్నల్‌లో రెండు రాష్ట్రాలు మాత్రమే దూరంగా ఉంచడం వల్ల అది విద్యుత్ జోక్యానికి తక్కువ అవకాశం ఉంటుంది.
- అయస్కాంత మాధ్యమం యొక్క సానుకూల మరియు ప్రతికూల ధ్రువాలు త్వరగా బైనరీకి అనువదించబడతాయి.
- లాజిక్ సర్క్యూట్‌లను నియంత్రించడానికి బైనరీ అత్యంత ప్రభావవంతమైన మార్గం.



## [సెంట్రల్ ప్రాసెసింగ్ యూనిట్ (CPU)](CPU/readme.md#central-processing-unitcpu)
సెంట్రల్ ప్రాసెసింగ్ యూనిట్ (CPU) అనేది ఏదైనా కంప్యూటర్‌లో అత్యంత ముఖ్యమైన భాగం. CPU కంప్యూటర్‌లోని ఇతర భాగాలను నియంత్రించడానికి సంకేతాలను పంపుతుంది, మెదడు శరీరాన్ని ఎలా నియంత్రిస్తుంది. CPU అనేది ఎలక్ట్రానిక్ మెషీన్, ఇది చేయవలసిన కంప్యూటర్ పనుల జాబితాలో పని చేస్తుంది, దీనిని సూచనలు అని పిలుస్తారు. ఇది సూచనల జాబితాను చదువుతుంది మరియు ప్రతి ఒక్కటి క్రమంలో అమలు చేస్తుంది (అమలు చేస్తుంది). CPU అమలు చేయగల సూచనల జాబితా కంప్యూటర్ ప్రోగ్రామ్. CPU "కోర్లు" అని పిలువబడే విభాగాలపై ఒకేసారి ఒకటి కంటే ఎక్కువ సూచనలను ప్రాసెస్ చేయగలదు. నాలుగు కోర్లతో కూడిన CPU ఒకేసారి నాలుగు ప్రోగ్రామ్‌లను ప్రాసెస్ చేయవచ్చు. CPU మూడు ప్రధాన భాగాలతో తయారు చేయబడింది. వారు:
1. [మెమరీ లేదా స్టోరేజ్ యూనిట్](CPU/readme.md#memory-or-storage-unit)
2. [కంట్రోల్ యూనిట్](CPU/readme.md#control-unit)
3. [అరిథ్మెటిక్ అండ్ లాజిక్ యూనిట్ (ALU)](CPU/readme.md#arithmetic-and-logic-unit-alu)


## [రిజిస్టర్లు, కాష్ మరియు RAM](/రిజిస్టర్లు%20కాష్%20మరియు%20RAM)

### [రిజిస్టర్](/రిజిస్టర్లు%20కాష్%20మరియు%20RAM/readme.md#register)
రిజిస్టర్‌లు అనేది CPUలో ఉండే చిన్న మొత్తంలో హై-స్పీడ్ మెమరీ. రిజిస్టర్లు అనేది "ఫ్లిప్-ఫ్లాప్స్" (1 బిట్ మెమరీని నిల్వ చేయడానికి ఉపయోగించే సర్క్యూట్) యొక్క సమాహారం. ప్రాసెసింగ్ సమయంలో అవసరమైన చిన్న మొత్తంలో డేటాను నిల్వ చేయడానికి వాటిని ప్రాసెసర్ ఉపయోగిస్తుంది. ఒక CPU "కోర్లు" అని పిలువబడే అనేక రిజిస్టర్‌లను కలిగి ఉండవచ్చు. రిజిస్టర్ అంకగణితం మరియు తర్కం కార్యకలాపాలలో కూడా సహాయపడుతుంది.

అంకగణిత కార్యకలాపాలు రిజిస్టర్లలో నిల్వ చేయబడిన సంఖ్యా డేటాపై CPUచే నిర్వహించబడే గణిత గణనలు. ఈ ఆపరేషన్లలో కూడిక, తీసివేత, గుణకారం మరియు భాగహారం ఉంటాయి. లాజిక్ కార్యకలాపాలు రిజిస్టర్లలో నిల్వ చేయబడిన బైనరీ డేటాపై CPUచే నిర్వహించబడే బూలియన్ లెక్కలు. ఈ ఆపరేషన్‌లలో పోలికలు (ఉదా. రెండు విలువలు సమానంగా ఉంటే పరీక్షించడం) మరియు లాజికల్ ఆపరేషన్‌లు (ఉదా. AND, OR, NOT) ఉంటాయి.

ఈ కార్యకలాపాలను నిర్వహించడానికి రిజిస్టర్‌లు చాలా అవసరం ఎందుకంటే అవి చిన్న మొత్తంలో డేటాను త్వరగా యాక్సెస్ చేయడానికి మరియు మార్చడానికి CPUని అనుమతిస్తాయి. తరచుగా యాక్సెస్ చేయబడిన డేటాను రిజిస్టర్లలో నిల్వ చేయడం ద్వారా, మెమరీ నుండి డేటాను తిరిగి పొందే నెమ్మదిగా ప్రక్రియను CPU నివారించవచ్చు.

పెద్ద మొత్తంలో డేటా కాష్‌లో నిల్వ చేయబడుతుంది ("నగదు" అని ఉచ్ఛరిస్తారు), రిజిస్టర్‌ల వలె అదే ఇంటిగ్రేటెడ్ సర్క్యూట్‌లో ఉన్న చాలా వేగవంతమైన మెమరీ. ప్రోగ్రామ్ నడుస్తున్నప్పుడు తరచుగా యాక్సెస్ చేయబడిన డేటా కోసం కాష్ ఉపయోగించబడుతుంది. RAMలో ఎక్కువ మొత్తంలో డేటా నిల్వ చేయబడవచ్చు. RAM అంటే రాండమ్-యాక్సెస్ మెమరీ, ఇది ప్రాసెసర్‌కు అవసరమైనంత వరకు డిస్క్ నిల్వ నుండి తరలించబడిన డేటా మరియు సూచనలను కలిగి ఉండే ఒక రకమైన మెమరీ.

### [కాష్](/రిజిస్టర్లు%20కాష్%20మరియు%20RAM/readme.md#cache)
కాష్ మెమరీ అనేది చిప్-ఆధారిత కంప్యూటర్ భాగం, ఇది కంప్యూటర్ మెమరీ నుండి డేటాను తిరిగి పొందడం మరింత సమర్థవంతంగా చేస్తుంది. ఇది తాత్కాలిక నిల్వ ప్రాంతంగా పనిచేస్తుంది కాబట్టి కంప్యూటర్ ప్రాసెసర్ సులభంగా డేటాను తిరిగి పొందగలదు. ఈ తాత్కాలిక నిల్వ ప్రాంతం, కాష్ అని పిలుస్తారు, ఇది కంప్యూటర్ యొక్క ప్రధాన మెమరీ మూలం కంటే ప్రాసెసర్‌కు మరింత సులభంగా అందుబాటులో ఉంటుంది, సాధారణంగా కొన్ని రకాల DRAM.

కాష్ మెమరీని కొన్నిసార్లు CPU (సెంట్రల్ ప్రాసెసింగ్ యూనిట్) మెమరీ అని పిలుస్తారు, ఎందుకంటే ఇది సాధారణంగా CPU చిప్‌లో నేరుగా విలీనం చేయబడుతుంది లేదా CPUతో ప్రత్యేక బస్సు ఇంటర్‌కనెక్ట్‌ను కలిగి ఉన్న ప్రత్యేక చిప్‌లో ఉంచబడుతుంది. అందువల్ల, ఇది ప్రాసెసర్‌కు మరింత అందుబాటులో ఉంటుంది మరియు ప్రాసెసర్‌కు భౌతికంగా దగ్గరగా ఉన్నందున సామర్థ్యాన్ని పెంచగలదు.

ప్రాసెసర్‌కు దగ్గరగా ఉండాలంటే, ప్రధాన మెమరీ కంటే కాష్ మెమరీ చాలా తక్కువగా ఉండాలి. పర్యవసానంగా, ఇది తక్కువ నిల్వ స్థలాన్ని కలిగి ఉంటుంది. ఇది ప్రధాన మెమరీ కంటే ఖరీదైనది, ఎందుకంటే ఇది అధిక పనితీరును అందించే క్లిష్టమైన చిప్.

ఇది పరిమాణం మరియు ధరలో ఏమి త్యాగం చేస్తుంది, అది వేగంతో భర్తీ చేస్తుంది. కాష్ మెమరీ RAM కంటే 10 నుండి 100 రెట్లు వేగంగా పనిచేస్తుంది, CPU అభ్యర్థనకు ప్రతిస్పందించడానికి కొన్ని నానోసెకన్లు మాత్రమే అవసరం.

కాష్ మెమరీ కోసం ఉపయోగించే అసలు హార్డ్‌వేర్ పేరు హై-స్పీడ్ స్టాటిక్ రాండమ్ యాక్సెస్ మెమరీ (SRAM). కంప్యూటర్ యొక్క ప్రధాన మెమరీలో ఉపయోగించే హార్డ్‌వేర్ పేరు డైనమిక్ రాండమ్-యాక్సెస్ మెమరీ (DRAM).

కాష్ మెమరీ విస్తృత పదం కాష్‌తో గందరగోళం చెందకూడదు. కాష్‌లు అనేది హార్డ్‌వేర్ మరియు సాఫ్ట్‌వేర్ రెండింటిలోనూ ఉండే తాత్కాలిక డేటా స్టోర్‌లు. కాష్ మెమరీ అనేది నిర్దిష్ట హార్డ్‌వేర్ కాంపోనెంట్‌ను సూచిస్తుంది, ఇది నెట్‌వర్క్‌లోని వివిధ స్థాయిలలో కాష్‌లను సృష్టించడానికి కంప్యూటర్‌లను అనుమతిస్తుంది. కాష్ అనేది ఒక హార్డ్‌వేర్ లేదా సాఫ్ట్‌వేర్, ఇది ఏదైనా, సాధారణంగా డేటాను, తాత్కాలికంగా కంప్యూటింగ్ వాతావరణంలో నిల్వ చేయడానికి ఉపయోగించబడుతుంది.

### [RAM](/రిజిస్టర్లు%20Cache%20మరియు%20RAM/readme.md#ram)
RAM (రాండమ్ యాక్సెస్ మెమరీ) అనేది కంప్యూటర్ మెమరీ యొక్క ఒక రూపం, దీనిని ఏ క్రమంలోనైనా చదవవచ్చు మరియు మార్చవచ్చు, సాధారణంగా పని చేసే డేటా మరియు మెషిన్ కోడ్‌ను నిల్వ చేయడానికి ఉపయోగిస్తారు. యాదృచ్ఛిక యాక్సెస్ మెమరీ పరికరం డేటా అంశాలను అనుమతిస్తుంది
ఇతర డైరెక్ట్-యాక్సెస్ డేటా స్టోరేజ్ మీడియాతో (హార్డ్ డిస్క్‌లు, CD-RWS వంటివి, మెమొరీ లోపల డేటా యొక్క భౌతిక స్థానంతో సంబంధం లేకుండా దాదాపు అదే సమయంలో చదవడం లేదా వ్రాయడం,
DVD-RWలు మరియు పాత మాగ్నెటిక్ టేప్‌లు మరియు డ్రమ్ మెమరీ), మీడియా భ్రమణ వేగం మరియు చేయి కదలిక వంటి యాంత్రిక పరిమితుల కారణంగా రికార్డింగ్ మాధ్యమంలో వాటి భౌతిక స్థానాలపై ఆధారపడి డేటా అంశాలను చదవడానికి మరియు వ్రాయడానికి అవసరమైన సమయం గణనీయంగా మారుతుంది.

## [సూచనలు మరియు ప్రోగ్రామ్](జోడించబడలేదు)
కంప్యూటర్ సైన్స్‌లో, ఇన్‌స్ట్రక్షన్ అనేది ప్రాసెసర్ ఇన్‌స్ట్రక్షన్ సెట్ ద్వారా నిర్వచించబడిన ప్రాసెసర్ యొక్క ఒకే ఆపరేషన్. కంప్యూటర్ ప్రోగ్రామ్ అంటే కంప్యూటర్‌కు ఏమి చేయాలో చెప్పే సూచనల జాబితా. కంప్యూటర్ చేసే ప్రతిదీ కంప్యూటర్ ప్రోగ్రామ్‌ను ఉపయోగించడం ద్వారా సాధించబడుతుంది. కంప్యూటర్ మెమరీలో నిల్వ చేయబడిన ప్రోగ్రామ్‌లు ("అంతర్గత ప్రోగ్రామింగ్") మధ్య విరామాలతో కూడా కంప్యూటర్‌ను ఒకదాని తర్వాత మరొకటి చేయడానికి అనుమతిస్తాయి.

## [ప్రోగ్రామింగ్ లాంగ్వేజెస్](/Programming_Languages/readme.md)
ప్రోగ్రామింగ్ లాంగ్వేజ్ అనేది స్ట్రింగ్‌లను లేదా విజువల్ ప్రోగ్రామింగ్ లాంగ్వేజ్‌ల విషయంలో గ్రాఫికల్ ప్రోగ్రామ్ ఎలిమెంట్‌లను వివిధ రకాల మెషిన్ కోడ్ అవుట్‌పుట్‌గా మార్చే ఏదైనా నియమాల సమితి. ప్రోగ్రామింగ్ లాంగ్వేజ్‌లు కంప్యూటర్ ప్రోగ్రామింగ్‌లో అల్గారిథమ్‌లను అమలు చేయడానికి ఉపయోగించే ఒక రకమైన కంప్యూటర్ భాష.

ప్రోగ్రామింగ్ భాషలు తరచుగా రెండు విస్తృత వర్గాలుగా విభజించబడ్డాయి:
1. ఉన్నత-స్థాయి భాష ఆంగ్ల భాషకు సమానమైన వాక్యనిర్మాణాన్ని ఉపయోగిస్తుంది. కంపైలర్ లేదా ఇంటర్‌ప్రెటర్‌ని ఉపయోగించి సోర్స్ కోడ్ మెషీన్-అర్థం చేసుకోగలిగే మెషిన్ కోడ్‌గా మార్చబడుతుంది. జావా మరియు పైథాన్ ఉన్నత-స్థాయి ప్రోగ్రామింగ్ భాషలకు కొన్ని ఉదాహరణలు. ఇవి సాధారణంగా తక్కువ-స్థాయి కంటే నెమ్మదిగా ఉంటాయి, కానీ ఇది సులభంగా ఉంటుంది.
2. తక్కువ-స్థాయి ప్రోగ్రామింగ్ భాషలు హార్డ్‌వేర్‌తో మరింత సన్నిహితంగా పనిచేస్తాయి మరియు దానిపై మరింత నియంత్రణను కలిగి ఉంటాయి. వారు నేరుగా హార్డ్‌వేర్‌తో సంకర్షణ చెందుతారు. తక్కువ-స్థాయి భాషలకు రెండు సాధారణ ఉదాహరణలు యంత్ర భాష మరియు అసెంబ్లీ భాష. ఇవి సాధారణంగా హై-లెవల్ కంటే వేగంగా ఉంటాయి, అయితే ఇది చాలా కష్టమైన మరియు చదవగలిగే లోపానికి సంబంధించిన ఖర్చుతో వస్తుంది.

### [ప్రోగ్రామింగ్ నమూనాలు](/Programming_Languages/readme.md#Programming+Paradigms)
అనేక విభిన్న *ప్రోగ్రామింగ్ నమూనాలు* కూడా ఉన్నాయి. ప్రోగ్రామింగ్ నమూనాలు ఇచ్చిన ప్రోగ్రామ్ లేదా ప్రోగ్రామింగ్ లాంగ్వేజ్‌ని నిర్వహించగల విభిన్న మార్గాలు లేదా శైలులు. ప్రతి నమూనా సాధారణ ప్రోగ్రామింగ్ సమస్యలను ఎలా పరిష్కరించాలి అనే దాని గురించి నిర్దిష్ట నిర్మాణాలు, లక్షణాలు మరియు అభిప్రాయాలను కలిగి ఉంటుంది.

ప్రోగ్రామింగ్ నమూనాలు *కాదు* భాషలు లేదా సాధనాలు. మీరు ఒక నమూనాతో దేనినీ "నిర్మించలేరు". అవి చాలా మంది వ్యక్తులు అంగీకరించిన, అనుసరించిన మరియు విస్తరించిన ఆదర్శాలు మరియు మార్గదర్శకాల సమితి లాంటివి. ప్రోగ్రామింగ్ భాషలు ఎల్లప్పుడూ ఒక నిర్దిష్ట నమూనాతో ముడిపడి ఉండవు. ఒక నిర్దిష్ట నమూనాను దృష్టిలో ఉంచుకుని నిర్మించబడిన * భాషలు ఉన్నాయి మరియు ఇతరులకన్నా ఎక్కువగా ఆ రకమైన ప్రోగ్రామింగ్‌ను సులభతరం చేసే లక్షణాలను కలిగి ఉన్నాయి (హాస్కెల్ మరియు ఫంక్షనల్ ప్రోగ్రామింగ్ మంచి ఉదాహరణ). కానీ "మల్టీ-పారాడిగ్మ్" భాషలు కూడా ఉన్నాయి, వీటిలో మీరు మీ కోడ్‌ని నిర్దిష్ట నమూనా లేదా ఇతర వాటికి సరిపోయేలా మార్చుకోవచ్చు (జావాస్క్రిప్ట్ మరియు పైథాన్ మంచి ఉదాహరణలు).


## [డేటా రకాలు](డేటా%20రకాలు/readme.md#data-types)
డేటా రకం, ప్రోగ్రామింగ్‌లో, ఒక వేరియబుల్ ఏ రకమైన విలువను కలిగి ఉందో మరియు ఏ రకమైన గణిత, రిలేషనల్ లేదా లాజికల్ ఆపరేషన్‌లను దోషం లేకుండా దానికి వర్తింపజేయగలదో పేర్కొనే వర్గీకరణ.

### [ప్రిమిటివ్ డేటా రకాలు](డేటా%20రకాలు/readme.md#primitive-data-types)
ప్రోగ్రామింగ్ లాంగ్వేజ్‌లో ప్రిమిటివ్ డేటా రకాలు అత్యంత ప్రాథమిక డేటా రకాలు. అవి మరింత సంక్లిష్టమైన డేటా రకాల బిల్డింగ్ బ్లాక్‌లు. ప్రిమిటివ్ డేటా రకాలు ప్రోగ్రామింగ్ లాంగ్వేజ్ ద్వారా ముందే నిర్వచించబడ్డాయి మరియు రిజర్వు చేయబడిన కీవర్డ్ ద్వారా పేరు పెట్టబడతాయి.

### [సాధారణ ఆదిమ డేటా రకాలు](డేటా%20రకాలు/readme.md#common-primitive-data-types)
- [పూర్ణాంకం](డేటా%20రకాలు/readme.md#integer)
- [ఫ్లోట్](డేటా%20రకాలు/readme.md#float)
- [బూలియన్](డేటా%20రకాలు/readme.md#boolean)
- [అక్షరం](డేటా%20రకాలు/readme.md#character)
- [స్ట్రింగ్](డేటా%20రకాలు/readme.md#string)

### [నాన్-ప్రిమిటివ్ డేటా రకాలు](డేటా%20రకాలు/readme.md#non-primitive-data-types)
నాన్-ప్రిమిటివ్ డేటా రకాలను రిఫరెన్స్ డేటా రకాలు అని కూడా అంటారు. అవి ప్రోగ్రామర్ చేత సృష్టించబడతాయి మరియు ప్రోగ్రామింగ్ భాష ద్వారా నిర్వచించబడవు. నాన్-ప్రిమిటివ్ డేటా రకాలను కాంపోజిట్ డేటా రకాలు అని కూడా అంటారు ఎందుకంటే అవి ఇతర రకాలతో కూడి ఉంటాయి.

### [సాధారణ నాన్-ప్రిమిటివ్ డేటా రకాలు](డేటా%20రకాలు/readme.md#common-non-primitive-data-types)
- [శ్రేణి](డేటా%20రకాలు/readme.md#array)
- [నిర్మాణం](డేటా%20రకాలు/readme.md#struct)
- [యూనియన్](డేటా%20రకాలు/readme.md#union)
- [పాయింటర్](డేటా%20రకాలు/readme.md#pointer)
- [ఫంక్షన్](డేటా%20రకాలు/readme.md#ఫంక్షన్)
- [తరగతి](డేటా%20రకాలు/readme.md#class)

## [ప్రకటనలు మరియు విధులు](ప్రకటనలు%20మరియు%20Functions/readme.md)
కంప్యూటర్ ప్రోగ్రామింగ్‌లో, స్టేట్‌మెంట్ అనేది తప్పనిసరి ప్రోగ్రామింగ్ లాంగ్వేజ్ యొక్క వాక్యనిర్మాణ యూనిట్, ఇది చేయవలసిన కొన్ని చర్యలను వ్యక్తపరుస్తుంది. అటువంటి భాషలో వ్రాసిన ప్రోగ్రామ్ ఒకటి లేదా అంతకంటే ఎక్కువ స్టేట్‌మెంట్‌ల క్రమం ద్వారా ఏర్పడుతుంది. ఒక ప్రకటనలో అంతర్గత భాగాలు ఉండవచ్చు (ఉదా., వ్యక్తీకరణలు).
కోడ్ యొక్క లాజిక్‌ను రూపొందించడానికి అవసరమైన ఏదైనా ప్రోగ్రామింగ్ భాషలో రెండు ప్రధాన రకాల స్టేట్‌మెంట్‌లు ఉన్నాయి.

1. [షరతులతో కూడిన ప్రకటనలు](స్టేట్‌మెంట్‌లు%20మరియు%20ఫంక్షన్‌లు/readme.md#షరతులతో కూడిన ప్రకటనలు)

ప్రధానంగా రెండు రకాల షరతులతో కూడిన ప్రకటనలు ఉన్నాయి:
- ఉంటే
- లేకపోతే
- స్విచ్ కేసు


2. [లూప్స్](స్టేట్‌మెంట్‌లు%20మరియు%20ఫంక్షన్‌లు/readme.md#loops)

ప్రధానంగా మూడు రకాల షరతులతో కూడిన ప్రకటనలు ఉన్నాయి:
- లూప్ కోసం
- అయితే లూప్
- డూ - అయితే లూప్ (అయితే లూప్ యొక్క వైవిధ్యం)
- do - లూప్ వరకు

----------

ఫంక్షన్ అనేది ఒక నిర్దిష్ట పనిని చేసే స్టేట్‌మెంట్‌ల బ్లాక్. విధులు డేటాను అంగీకరిస్తాయి, ప్రాసెస్ చేస్తాయి మరియు ఫలితాన్ని అందిస్తాయి లేదా అమలు చేస్తాయి. విధులు ప్రాథమికంగా పునర్వినియోగ భావనకు మద్దతు ఇవ్వడానికి వ్రాయబడ్డాయి. ఒక ఫంక్షన్ వ్రాసిన తర్వాత, అదే కోడ్‌ను పునరావృతం చేయకుండా సులభంగా కాల్ చేయవచ్చు.

వివిధ ఫంక్షనల్ భాషలు ఫంక్షన్‌లను వ్రాయడానికి వేర్వేరు సింటాక్స్‌లను ఉపయోగిస్తాయి.

ఫంక్షన్ల గురించి మరింత చదవండి [ఇక్కడ](ప్రకటనలు%20మరియు%20Functions/readme.md#functions)


## [డేటా స్ట్రక్చర్స్](డేటా%20 స్ట్రక్చర్స్/రీడ్‌మే.ఎమ్‌డి)
కంప్యూటర్ సైన్స్‌లో, డేటా స్ట్రక్చర్ అనేది డేటా ఆర్గనైజేషన్, మేనేజ్‌మెంట్ మరియు స్టోరేజ్ ఫార్మాట్, ఇది సమర్థవంతమైన యాక్సెస్ మరియు సవరణను అనుమతిస్తుంది. మరింత ఖచ్చితంగా, డేటా నిర్మాణం అనేది డేటా విలువలు, వాటి మధ్య సంబంధాలు మరియు డేటాకు వర్తించే విధులు లేదా కార్యకలాపాల సమాహారం.

### డేటా స్ట్రక్చర్ల రకాలు
- [అరే](డేటా%20స్ట్రక్చర్స్/రీడ్‌మె.ఎమ్‌డి#అరే)
- [లింక్డ్ లిస్ట్](డేటా%20 స్ట్రక్చర్స్/రీడ్‌మే.ఎమ్‌డి#లింక్డ్‌లిస్ట్)
- [స్టాక్](Data%20Structures/readme.md#stack)
- [క్యూ](Data%20Structures/readme.md#queue)
- [హాష్ టేబుల్](డేటా%20స్ట్రక్చర్స్/రీడ్‌మే.ఎమ్‌డి#హాష్‌టేబుల్)
- [హీప్](డేటా%20 స్ట్రక్చర్స్/రీడ్‌మే.ఎమ్‌డి#హీప్)
- [చెట్టు](డేటా%20 స్ట్రక్చర్స్/రీడ్‌మే.ఎమ్‌డి#ట్రీ)
- [గ్రాఫ్](డేటా%20నిర్మాణాలు/readme.md#graph)

## [అల్గోరిథంలు](Algorithms/readme.md)
అల్గారిథమ్‌లు గణనను పూర్తి చేయడానికి అవసరమైన దశల సెట్‌లు. అవి మా పరికరాలు చేసే పనులలో ప్రధానమైనవి మరియు ఇది కొత్త భావన కాదు. గణితం అభివృద్ధి చెందినప్పటి నుండి, పనులను మరింత సమర్ధవంతంగా పూర్తి చేయడంలో మాకు సహాయం చేయడానికి అల్గారిథమ్‌లు అవసరమవుతాయి, అయితే ఈ రోజు మనం సార్టింగ్ మరియు గ్రాఫ్ సెర్చ్ వంటి కొన్ని ఆధునిక కంప్యూటింగ్ సమస్యలను పరిశీలించి, వాటిని మరింతగా ఎలా తయారు చేశామో చూపించబోతున్నాం. సమర్థవంతమైనది కాబట్టి మీరు వింటర్‌ఫెల్ లేదా రెస్టారెంట్ లేదా మరేదైనా చౌకైన విమాన ఛార్జీలు లేదా మ్యాప్ దిశలను మరింత సులభంగా కనుగొనవచ్చు.

### [సమయ సంక్లిష్టత](అల్గోరిథంలు/సమయం%20సంక్లిష్టత/readme.md)
అల్గారిథమ్ యొక్క సమయ సంక్లిష్టత కొంత ఇన్‌పుట్ కోసం అల్గారిథమ్ ఎంత సమయాన్ని ఉపయోగిస్తుందో అంచనా వేస్తుంది. పరామితి ఇన్‌పుట్ పరిమాణంగా ఉండే ఫంక్షన్‌గా సామర్థ్యాన్ని సూచించడం ఆలోచన. సమయ సంక్లిష్టతను లెక్కించడం ద్వారా, అల్గోరిథం అమలు చేయకుండానే తగినంత వేగంగా ఉందో లేదో మేము గుర్తించగలము.

### [స్పేస్ కాంప్లెక్సిటీ](అల్గోరిథమ్స్/స్పేస్%20కాంప్లెక్సిటీ/రీడ్‌మే.ఎమ్‌డి)
స్పేస్ కాంప్లెక్సిటీ అనేది ఒక అల్గారిథమ్/ప్రోగ్రామ్ ఉపయోగించే మొత్తం మెమరీ స్పేస్‌ను సూచిస్తుంది, అమలు కోసం ఇన్‌పుట్ విలువల స్థలంతో సహా. స్పేస్ సంక్లిష్టతను గుర్తించడానికి అల్గారిథమ్/ప్రోగ్రామ్‌లో వేరియబుల్స్ ఆక్రమించిన స్థలాన్ని లెక్కించండి.


### [సార్టింగ్](Algorithms/Sorting/readme.md)
సార్టింగ్ అనేది ఒక నిర్దిష్ట క్రమంలో వస్తువుల జాబితాను అమర్చే ప్రక్రియ. ఉదాహరణకు, మీరు పేర్ల జాబితాను కలిగి ఉంటే, మీరు వాటిని అక్షర క్రమంలో క్రమబద్ధీకరించాలనుకోవచ్చు. ప్రత్యామ్నాయంగా, మీరు సంఖ్యల జాబితాను కలిగి ఉంటే, మీరు వాటిని చిన్న నుండి పెద్ద వరకు క్రమంలో ఉంచాలనుకోవచ్చు. క్రమబద్ధీకరించడం అనేది ఒక సాధారణ పని, మరియు ఇది మనం అనేక రకాలుగా చేయగలిగినది.

### [శోధన](Algorithms/Searching/readme.md)
శోధించడం అనేది కంటైనర్‌లో నిర్దిష్ట లక్ష్య మూలకాన్ని కనుగొనడానికి ఒక అల్గారిథమ్. శోధన అల్గారిథమ్‌లు మూలకం కోసం తనిఖీ చేయడానికి లేదా అది నిల్వ చేయబడిన ఏదైనా డేటా నిర్మాణం నుండి మూలకాన్ని తిరిగి పొందడానికి రూపొందించబడ్డాయి.

### [స్ట్రింగ్ ఆధారిత అల్గారిథమ్‌లు](అల్గోరిథంలు/స్ట్రింగ్%20బేస్డ్%20అల్గోరిథంలు/readme.md)
స్ట్రింగ్‌లు ప్రోగ్రామింగ్‌లో ఎక్కువగా ఉపయోగించే మరియు అత్యంత ముఖ్యమైన డేటా స్ట్రక్చర్‌లలో ఒకటి, ఈ రిపోజిటరీలో ఎక్కువగా ఉపయోగించిన కొన్ని అల్గారిథమ్‌లు ఉన్నాయి, ఇవి మా కోడ్‌ను వేగంగా శోధించడంలో సహాయపడతాయి.

### [గ్రాఫ్ శోధన](Algorithms/Graph/readme.md)
గ్రాఫ్ శోధన అనేది నిర్దిష్ట నోడ్‌ను కనుగొనడానికి గ్రాఫ్ ద్వారా శోధించే ప్రక్రియ. గ్రాఫ్ అనేది నిర్దేశించని గ్రాఫ్ కోసం ఈ శీర్షాల యొక్క క్రమం చేయని జతల సెట్‌తో పాటు లేదా నిర్దేశించబడిన గ్రాఫ్ కోసం ఆర్డర్ చేయబడిన జతల సెట్‌తో పాటు పరిమిత (మరియు బహుశా మార్చదగిన) శీర్షాలు లేదా నోడ్‌లు లేదా పాయింట్లను కలిగి ఉండే డేటా నిర్మాణం. ఈ జతలను ఎడ్జ్‌లు, ఆర్క్‌లు లేదా అన్‌డైరెక్ట్ చేసిన గ్రాఫ్‌కు లైన్‌లుగా పిలుస్తారు మరియు డైరెక్ట్ చేసిన గ్రాఫ్‌కు బాణాలు, దర్శకత్వం వహించిన అంచులు, డైరెక్ట్ ఆర్క్‌లు లేదా డైరెక్ట్ లైన్‌లు అని పిలుస్తారు. శీర్షాలు గ్రాఫ్ నిర్మాణంలో భాగం కావచ్చు లేదా పూర్ణాంక సూచికలు లేదా సూచనల ద్వారా సూచించబడే బాహ్య ఎంటిటీలు కావచ్చు. అనేక వాస్తవ-ప్రపంచ అనువర్తనాలకు గ్రాఫ్‌లు అత్యంత ఉపయోగకరమైన డేటా నిర్మాణాలలో ఒకటి. వస్తువుల మధ్య జత వైపు సంబంధాలను మోడల్ చేయడానికి గ్రాఫ్‌లు ఉపయోగించబడతాయి. ఉదాహరణకు, ఎయిర్‌లైన్ రూట్ నెట్‌వర్క్ అనేది గ్రాఫ్, దీనిలో నగరాలు శీర్షాలుగా ఉంటాయి మరియు విమాన మార్గాలు అంచులుగా ఉంటాయి. నెట్‌వర్క్‌లను సూచించడానికి గ్రాఫ్‌లు కూడా ఉపయోగించబడతాయి. ఇంటర్నెట్‌ను గ్రాఫ్‌గా రూపొందించవచ్చు, దీనిలో కంప్యూటర్‌లు శీర్షాలుగా ఉంటాయి మరియు కంప్యూటర్‌ల మధ్య లింక్‌లు అంచులుగా ఉంటాయి. లింక్డ్‌ఇన్ మరియు ఫేస్‌బుక్ వంటి సోషల్ నెట్‌వర్క్‌లలో కూడా గ్రాఫ్‌లు ఉపయోగించబడతాయి. అనేక వాస్తవ-ప్రపంచ అనువర్తనాలను సూచించడానికి గ్రాఫ్‌లు ఉపయోగించబడతాయి: కంప్యూటర్ నెట్‌వర్క్‌లు, సర్క్యూట్ డిజైన్ మరియు ఏరోనాటికల్ షెడ్యూలింగ్ కొన్ని మాత్రమే.

### [డైనమిక్ ప్రోగ్రామింగ్](అల్గోరిథమ్స్/డైనమిక్%20ప్రోగ్రామింగ్/README.md)
డైనమిక్ ప్రోగ్రామింగ్ అనేది గణిత ఆప్టిమైజేషన్ పద్ధతి మరియు కంప్యూటర్ ప్రోగ్రామింగ్ పద్ధతి. రిచర్డ్ బెల్మాన్ 1950లలో ఈ పద్ధతిని అభివృద్ధి చేసాడు మరియు ఏరోస్పేస్ ఇంజనీరింగ్ నుండి ఎకనామిక్స్ వరకు అనేక రంగాలలో అప్లికేషన్లను కనుగొన్నాడు. రెండు సందర్భాలలో, ఇది సంక్లిష్టమైన సమస్యను పునరావృత పద్ధతిలో సరళమైన ఉప-సమస్యలుగా విభజించడం ద్వారా సరళీకృతం చేయడాన్ని సూచిస్తుంది. కొన్ని నిర్ణయ సమస్యలను ఈ విధంగా వేరుగా తీసుకోలేనప్పటికీ, అనేక పాయింట్ల వ్యవధిలో ఉండే నిర్ణయాలు తరచుగా పునరావృతంగా విడిపోతాయి. అదేవిధంగా, కంప్యూటర్ సైన్స్‌లో, ఒక సమస్యను ఉప-సమస్యలుగా విభజించి, ఆపై పునరావృతమయ్యే ఉప-సమస్యలకు సరైన పరిష్కారాలను కనుగొనడం ద్వారా సమస్యను ఉత్తమంగా పరిష్కరించగలిగితే, అది సరైన సబ్‌స్ట్రక్చర్‌ను కలిగి ఉంటుంది. ఈ లక్షణాలతో సమస్యలను పరిష్కరించడానికి డైనమిక్ ప్రోగ్రామింగ్ ఒక మార్గం. సంక్లిష్టమైన సమస్యను సరళమైన ఉప-సమస్యలుగా విభజించే ప్రక్రియను "విభజించు మరియు జయించు" అంటారు.



### [గ్రీడీ అల్గారిథమ్‌లు](అల్గోరిథమ్స్/గ్రీడీ%20అల్గోరిథమ్/రీడ్‌మే.ఎమ్‌డి)
అత్యాశ అల్గారిథమ్‌లు అనేది కొన్ని ఆప్టిమైజేషన్ సమస్యలకు సరైన పరిష్కారాన్ని కనుగొనడానికి ఉపయోగించే అల్గారిథమ్‌ల యొక్క సాధారణ, సహజమైన తరగతి. వారిని అత్యాశ అని పిలుస్తారు, ఎందుకంటే, ప్రతి దశలో, వారు ఆ సమయంలో ఉత్తమంగా కనిపించే ఎంపికను చేస్తారు. దీనర్థం అత్యాశతో కూడిన అల్గారిథమ్‌లు ప్రపంచవ్యాప్తంగా సరైన పరిష్కారాన్ని తిరిగి ఇవ్వడానికి హామీ ఇవ్వవు, బదులుగా గ్లోబల్ ఆప్టిమమ్‌ను కనుగొనాలనే ఆశతో స్థానికంగా సరైన ఎంపికలను చేస్తాయి. ఆప్టిమైజేషన్ సమస్యల కోసం అత్యాశ అల్గారిథమ్‌లు ఉపయోగించబడతాయి. సమస్య కింది లక్షణాన్ని కలిగి ఉంటే గ్రీడీని ఉపయోగించి ఆప్టిమైజేషన్ సమస్యను పరిష్కరించవచ్చు: ప్రతి దశలో, మేము ప్రస్తుతానికి ఉత్తమంగా కనిపించే ఎంపికను చేయవచ్చు మరియు పూర్తి సమస్యకు సరైన పరిష్కారాన్ని పొందుతాము.


### [బ్యాక్‌ట్రాకింగ్](అల్గోరిథంలు/బ్యాక్‌ట్రాకింగ్/README.md)
బ్యాక్‌ట్రాకింగ్ అనేది సమస్య యొక్క పరిమితులను ఏ సమయంలోనైనా సంతృప్తి పరచడంలో విఫలమయ్యే పరిష్కారాలను తొలగించడం ద్వారా, ఒక సమయంలో ఒక్కొక్క ముక్కగా పరిష్కారాన్ని నిర్మించడానికి ప్రయత్నించడం ద్వారా పునరావృతమయ్యే సమస్యలను పరిష్కరించడానికి అల్గారిథమిక్ టెక్నిక్. శోధన చెట్టు యొక్క ఏ స్థాయికి చేరుకునే వరకు సమయం గడిచిపోయింది).


### [బ్రాంచ్ మరియు బౌండ్](అల్గోరిథంలు/బ్రాంచ్%20మరియు%20బౌండ్/README.md)
బ్రాంచ్ మరియు బౌండ్ అనేది కాంబినేటోరియల్ ఆప్టిమైజేషన్ సమస్యలను పరిష్కరించడానికి ఒక సాధారణ సాంకేతికత. ఇది ఒక క్రమబద్ధమైన గణన సాంకేతికత, ఇది సమస్య యొక్క నిర్మాణాన్ని ఉపయోగించడం ద్వారా అభ్యర్థి పరిష్కారాల సంఖ్యను తగ్గించి, బహుశా సరైనది కానటువంటి అభ్యర్థి పరిష్కారాలను తొలగిస్తుంది.

### [వివిధ శోధన మరియు క్రమబద్ధీకరణ అల్గారిథమ్‌ల సమయ సంక్లిష్టత మరియు స్పేస్ సంక్లిష్టత](జోడించబడలేదు)
**సమయ సంక్లిష్టత**: ఇది మొత్తం సమయం కంటే నిర్దిష్ట ఇన్‌స్ట్రక్షన్ సెట్‌ని ఎన్నిసార్లు అమలు చేయాలనే అంచనాగా నిర్వచించబడింది. సమయం ఆధారపడిన దృగ్విషయం కాబట్టి, ప్రాసెసర్ వేగం, ఉపయోగించిన కంపైలర్ మొదలైన కొన్ని బాహ్య కారకాలపై సమయ సంక్లిష్టత మారవచ్చు.

**స్పేస్ కాంప్లెక్సిటీ**: ఇది ప్రోగ్రామ్ దాని అమలు కోసం వినియోగించే మొత్తం మెమరీ స్పేస్.

రెండూ ఇన్‌పుట్ పరిమాణం(n) ఫంక్షన్‌గా లెక్కించబడతాయి. అల్గోరిథం యొక్క సమయ సంక్లిష్టత పెద్ద O సంజ్ఞామానంలో వ్యక్తీకరించబడింది.

అల్గోరిథం యొక్క సామర్థ్యం ఈ రెండు పారామితులపై ఆధారపడి ఉంటుంది.

సమయ సంక్లిష్టత రకాలు:

- *ఉత్తమ సమయ సంక్లిష్టత*: అల్గోరిథం తక్కువ సమయం లేదా కనిష్ట సమయాన్ని తీసుకునే ఇన్‌పుట్. ఉత్తమ సందర్భంలో, మేము అల్గోరిథం యొక్క తక్కువ పరిమిత సమయ సంక్లిష్టతను గణిస్తాము. ఉదాహరణకు: లీనియర్ సెర్చ్‌లో పెద్ద డేటా శ్రేణి యొక్క మొదటి స్థానంలో శోధించాల్సిన డేటా ఉన్నట్లయితే, ఉత్తమ సందర్భం ఏర్పడుతుంది.
- *సగటు సమయ సంక్లిష్టత*: మేము అన్ని యాదృచ్ఛిక ఇన్‌పుట్‌లను తీసుకుంటాము మరియు అన్ని ఇన్‌పుట్‌ల కోసం గణన సమయాన్ని గణిస్తాము. ఆపై, మేము దానిని మొత్తం ఇన్‌పుట్‌ల సంఖ్యతో విభజిస్తాము.
- *చెత్త సమయ సంక్లిష్టత*: అల్గోరిథం ఎక్కువ సమయం లేదా గరిష్ట సమయం తీసుకునే ఇన్‌పుట్‌ను నిర్వచించండి. చెత్త సందర్భంలో, మేము అల్గోరిథం యొక్క ఎగువ సరిహద్దును గణిస్తాము. ఉదాహరణ: లీనియర్ సెర్చ్ అల్గారిథమ్‌లో శోధించాల్సిన డేటా పెద్ద డేటా శ్రేణి యొక్క చివరి ప్రదేశంలో ఉంటే, అప్పుడు చెత్త పరిస్థితి ఏర్పడుతుంది.

కొన్ని సాధారణ సమయ సంక్లిష్టతలు:

- **O(1)**: ఇది స్థిరమైన సమయాన్ని సూచిస్తుంది. O(1) సాధారణంగా ఇన్‌పుట్ పరిమాణంతో సంబంధం లేకుండా ఒక అల్గోరిథం స్థిరమైన సమయాన్ని కలిగి ఉంటుంది. హాష్ మ్యాప్‌లు స్థిరమైన సమయానికి సరైన ఉదాహరణలు.

- **O(log n)**: ఇది సంవర్గమాన సమయాన్ని సూచిస్తుంది. O(log n) అంటే ఆపరేషన్‌ల కోసం ప్రతి సందర్భంలో తగ్గడం. బైనరీ సెర్చ్ ట్రీస్ (BSTలు)లో మూలకాల కోసం శోధించడం లాగరిథమిక్ సమయానికి మంచి ఉదాహరణ.

- **O(n)**: ఇది సరళ సమయాన్ని సూచిస్తుంది. O(n) అంటే పనితీరు ఇన్‌పుట్ పరిమాణానికి నేరుగా అనులోమానుపాతంలో ఉంటుంది. సరళంగా చెప్పాలంటే, ఇన్‌పుట్‌ల సంఖ్య మరియు ఆ ఇన్‌పుట్‌లను అమలు చేయడానికి పట్టే సమయం అనుపాతంలో ఉంటుంది. శ్రేణులలోని లీనియర్ శోధన అనేది లీనియర్ టైమ్ కాంప్లెక్సిటీకి గొప్ప ఉదాహరణ.

- **O(n*n)**: ఇది చతుర్భుజ సమయాన్ని సూచిస్తుంది. O(n^2) అంటే పనితీరు తీసుకున్న ఇన్‌పుట్ వర్గానికి నేరుగా అనులోమానుపాతంలో ఉంటుంది. సరళంగా చెప్పాలంటే, అమలు చేయడానికి పట్టే సమయం ఇన్‌పుట్ పరిమాణం కంటే దాదాపు చదరపు రెట్లు పడుతుంది. సమూహ లూప్‌లు క్వాడ్రాటిక్ టైమ్ కాంప్లెక్సిటీకి సరైన ఉదాహరణలు.

- **O(n log n)**: ఇది బహుపది సమయ సంక్లిష్టతను సూచిస్తుంది. O(n log n) అంటే పనితీరు O(log n) కంటే n రెట్లు ఎక్కువ అని అర్థం, (ఇది చెత్త-కేస్ సంక్లిష్టత). ఒక మంచి ఉదాహరణ విభజించబడింది మరియు విలీన క్రమబద్ధీకరణ వంటి అల్గారిథమ్‌లను జయించవచ్చు. ఈ అల్గోరిథం మొదట సెట్‌ను విభజిస్తుంది, ఇది O(log n) సమయాన్ని తీసుకుంటుంది, ఆపై O(n) సమయం తీసుకుంటుంది, ఇది O(n) సమయం తీసుకుంటుంది- కాబట్టి, Merge sort O(n log n) సమయాన్ని తీసుకుంటుంది.

| అల్గోరిథం | | సమయ సంక్లిష్టత| | అంతరిక్ష సంక్లిష్టత |
| :---: | :---: | :---: | :---: | :---: |
| | ఉత్తమ | సగటు | చెత్త | చెత్త |
| ఎంపిక క్రమబద్ధీకరణ | Ω(n^2) | θ(n^2) | O(n^2) | O(1) |
| బబుల్ క్రమబద్ధీకరణ | Ω(n) | θ(n^2) | O(n^2) | O(1) |
| చొప్పించడం క్రమబద్ధీకరించు | Ω(n) | θ(n^2) | O(n^2) | O(1) |
| కుప్ప క్రమబద్ధీకరించు | Ω(n లాగ్(n)) | θ(n లాగ్(n)) | O(n log(n)) | O(1) |
| త్వరిత క్రమబద్ధీకరణ | Ω(n లాగ్(n)) | θ(n లాగ్(n)) | O(n^2) | O(n) |
| క్రమబద్ధీకరించు | Ω(n లాగ్(n)) | θ(n లాగ్(n)) | O(n log(n)) | O(n) |
| బకెట్ క్రమబద్ధీకరణ | Ω(n +k) | θ(n +k) | O(n^2) | O(n) |
| రాడిక్స్ క్రమబద్ధీకరణ | Ω(nk) | θ(nk) | O(nk) | O(n + k)|
| క్రమబద్ధీకరించు | Ω(n +k) | θ(n +k) | O(n + k) | O(k)|
| షెల్ క్రమబద్ధీకరించు | Ω(n లాగ్(n)) | θ(n లాగ్(n)) | O(n^2) | O(1) |
| టిమ్ క్రమబద్ధీకరించు | Ω(n) | θ(n లాగ్(n)) | O(n log(n)) | O(n) |
| చెట్టు క్రమబద్ధీకరణ | Ω(n లాగ్(n)) | θ(n లాగ్(n)) | O(n^2) | O(n) |
| క్యూబ్ క్రమబద్ధీకరణ | Ω(n) | θ(n లాగ్(n)) | O(n log(n)) | O(n) |

| అల్గోరిథం | | సమయ సంక్లిష్టత| |
| :---: | :---: | :---: | :---: |
| | ఉత్తమ | సగటు | చెత్త |
| సరళ శోధన | O(1) | O(N)| O(N)| O(1) |
| బైనరీ శోధన | O(1) | O(logN) | O(logN) |

## [అలన్ ట్యూరింగ్](జోడించబడలేదు)
అలాన్ ట్యూరింగ్ (జననం జూన్ 23, 1912, లండన్, ఇంజి.- జూన్ 7, 1954న మరణించారు, విల్మ్స్లో, చెషైర్) ఒక ఆంగ్ల గణిత శాస్త్రజ్ఞుడు మరియు తర్కవేత్త. అతను కేంబ్రిడ్జ్ విశ్వవిద్యాలయం మరియు ప్రిన్స్‌టన్ ఇన్‌స్టిట్యూట్ ఫర్ అడ్వాన్స్‌డ్ స్టడీలో చదువుకున్నాడు. తన సెమినల్ 1936 పేపర్ "ఆన్ కంప్యూటబుల్ నంబర్స్"లో, అతను గణితంలో సత్యాన్ని నిర్ణయించే సార్వత్రిక అల్గారిథమిక్ పద్ధతి ఉనికిలో లేదని మరియు గణితం ఎల్లప్పుడూ నిర్ణయించలేని (తెలియని వాటికి విరుద్ధంగా) ప్రతిపాదనలను కలిగి ఉంటుందని నిరూపించాడు. ఆ పేపర్ ట్యూరింగ్ యంత్రాన్ని కూడా పరిచయం చేసింది. కంప్యూటర్లు చివరికి మానవుడి నుండి వేరు చేయలేని విధంగా ఆలోచించగలవని అతను నమ్మాడు మరియు ఈ సామర్థ్యాన్ని అంచనా వేయడానికి ఒక సాధారణ పరీక్షను (ట్యూరింగ్ పరీక్ష చూడండి) ప్రతిపాదించాడు. ఈ అంశంపై అతని పత్రాలు కృత్రిమ మేధస్సులో పరిశోధనకు పునాదిగా విస్తృతంగా గుర్తించబడ్డాయి. అతను రెండవ ప్రపంచ యుద్ధం సమయంలో క్రిప్టోగ్రఫీలో విలువైన పని చేసాడు, రేడియో కమ్యూనికేషన్ల కోసం జర్మనీ ఉపయోగించే ఎనిగ్మా కోడ్‌ను విచ్ఛిన్నం చేయడంలో ముఖ్యమైన పాత్ర పోషించాడు. యుద్ధం తరువాత, అతను మాంచెస్టర్ విశ్వవిద్యాలయంలో బోధించాడు మరియు ఇప్పుడు కృత్రిమ మేధస్సు అని పిలవబడే పనిని ప్రారంభించాడు. ఈ సంచలనాత్మక పని మధ్య, ట్యూరింగ్ తన బెడ్‌లో సైనైడ్‌తో విషం తాగి చనిపోయాడు. అతని మరణం స్వలింగ సంపర్క చర్య (అప్పుడు నేరం) మరియు 12 నెలల హార్మోన్ థెరపీకి శిక్ష విధించిన తర్వాత అతనిని అరెస్టు చేసింది.


2009లో బహిరంగ ప్రచారాన్ని అనుసరించి, బ్రిటీష్ ప్రధాన మంత్రి గోర్డాన్ బ్రౌన్ ట్యూరింగ్‌తో వ్యవహరించిన భయంకరమైన విధానానికి బ్రిటిష్ ప్రభుత్వం తరపున అధికారిక బహిరంగ క్షమాపణ చెప్పారు. క్వీన్ ఎలిజబెత్ II 2013లో మరణానంతర క్షమాపణను మంజూరు చేసింది. "అలన్ ట్యూరింగ్ లా" అనే పదాన్ని ఇప్పుడు యునైటెడ్ కింగ్‌డమ్‌లోని 2017 చట్టాన్ని సూచించడానికి అనధికారికంగా ఉపయోగించబడుతోంది, ఇది స్వలింగ సంపర్క చర్యలను నిషేధించే చారిత్రక చట్టం ప్రకారం హెచ్చరించిన లేదా దోషులుగా నిర్ధారించబడిన పురుషులను ముందస్తుగా క్షమించింది.

ట్యూరింగ్‌కు అతని విగ్రహాలు మరియు కంప్యూటర్ సైన్స్ ఆవిష్కరణలకు వార్షిక అవార్డుతో సహా అతని పేరు మీద అనేక వస్తువులతో విస్తృతమైన వారసత్వం ఉంది. అతను తన పుట్టినరోజు సందర్భంగా జూన్ 23, 2021న విడుదల చేసిన ప్రస్తుత బ్యాంక్ ఆఫ్ ఇంగ్లండ్ £50 నోట్‌లో కనిపించాడు. 2019 BBC సిరీస్, ప్రేక్షకులచే ఓటు వేయబడినట్లుగా, అతన్ని 20వ శతాబ్దపు గొప్ప వ్యక్తిగా పేర్కొంది.

## [సాఫ్ట్‌వేర్ ఇంజనీరింగ్](సాఫ్ట్‌వేర్%20Engineering/readme.md)
సాఫ్ట్‌వేర్ ఇంజనీరింగ్ అనేది సాఫ్ట్‌వేర్ అప్లికేషన్‌ల రూపకల్పన, అభివృద్ధి, పరీక్ష మరియు నిర్వహణతో వ్యవహరించే కంప్యూటర్ సైన్స్ యొక్క శాఖ. సాఫ్ట్‌వేర్ ఇంజనీర్లు తుది వినియోగదారుల కోసం సాఫ్ట్‌వేర్ పరిష్కారాలను రూపొందించడానికి ఇంజనీరింగ్ సూత్రాలు మరియు ప్రోగ్రామింగ్ భాషల పరిజ్ఞానాన్ని వర్తింపజేస్తారు.

సాఫ్ట్‌వేర్ ఇంజనీరింగ్ యొక్క వివిధ నిర్వచనాలను చూద్దాం:

- IEEE, దాని ప్రామాణిక 610.12-1990లో, సాఫ్ట్‌వేర్ ఇంజినీరింగ్‌ను క్రమబద్ధమైన, క్రమశిక్షణతో కూడిన అప్లికేషన్‌గా నిర్వచించింది, ఇది సాఫ్ట్‌వేర్ అభివృద్ధి, ఆపరేషన్ మరియు నిర్వహణ కోసం గణించదగిన విధానం.
- ఫ్రిట్జ్ బాయర్ దీనిని 'స్థాపన మరియు ప్రామాణిక ఇంజనీరింగ్ సూత్రాలను ఉపయోగించినట్లు నిర్వచించారు. ఇది విశ్వసనీయమైన మరియు నిజమైన మెషీన్‌లపై సమర్థవంతంగా పనిచేసే ఆర్థిక సాఫ్ట్‌వేర్‌ను పొందడంలో మీకు సహాయపడుతుంది.
- కంప్యూటర్ ప్రోగ్రామ్‌ల సృజనాత్మక రూపకల్పన మరియు నిర్మాణానికి శాస్త్రీయ పరిజ్ఞానం యొక్క ఆచరణాత్మక అనువర్తనంతో కూడిన సాఫ్ట్‌వేర్ ఇంజనీరింగ్‌ని బోహ్మ్ నిర్వచించాడు. ఇది వాటిని అభివృద్ధి చేయడానికి, నిర్వహించడానికి మరియు నిర్వహించడానికి అవసరమైన అనుబంధ డాక్యుమెంటేషన్‌ను కూడా కలిగి ఉంటుంది.'

### సాఫ్ట్‌వేర్ ఇంజనీర్ పనులు మరియు బాధ్యతలు
కంప్యూటర్ గేమ్‌ల నుండి నెట్‌వర్క్ కంట్రోల్ సిస్టమ్‌ల వరకు అన్నింటినీ అభివృద్ధి చేయడానికి సరైన ప్రోగ్రామింగ్ లాంగ్వేజ్‌లు, ప్లాట్‌ఫారమ్‌లు మరియు ఆర్కిటెక్చర్‌లను ఎలా ఉపయోగించాలో విజయవంతమైన ఇంజనీర్‌లకు తెలుసు. వారి సిస్టమ్‌లను నిర్మించడంతో పాటు, సాఫ్ట్‌వేర్ ఇంజనీర్లు ఇతర ఇంజనీర్లు రూపొందించిన సాఫ్ట్‌వేర్‌ను పరీక్షించడం, మెరుగుపరచడం మరియు నిర్వహించడం కూడా చేస్తారు.

ఈ పాత్రలో, మీ రోజువారీ పనులు క్రింది వాటిని కలిగి ఉండవచ్చు:

- సాఫ్ట్‌వేర్ సిస్టమ్‌ల రూపకల్పన మరియు నిర్వహణ
- కొత్త సాఫ్ట్‌వేర్ ప్రోగ్రామ్‌లను మూల్యాంకనం చేయడం మరియు పరీక్షించడం
- వేగం మరియు స్కేలబిలిటీ కోసం ఆప్టిమైజింగ్ సాఫ్ట్‌వేర్
- కోడ్ రాయడం మరియు పరీక్షించడం
- క్లయింట్లు, ఇంజనీర్లు, భద్రతా నిపుణులు మరియు ఇతర వాటాదారులతో సంప్రదింపులు
- వాటాదారులు మరియు అంతర్గత కస్టమర్‌లకు కొత్త ఫీచర్‌లను అందించడం

### సాఫ్ట్‌వేర్ ఇంజనీరింగ్ దశలు
సాఫ్ట్‌వేర్ ఇంజనీరింగ్ ప్రక్రియలో అవసరాల సేకరణ, రూపకల్పన, అమలు, పరీక్ష మరియు నిర్వహణ వంటి అనేక దశలు ఉంటాయి. సాఫ్ట్‌వేర్ అభివృద్ధికి క్రమశిక్షణా విధానాన్ని అనుసరించడం ద్వారా, సాఫ్ట్‌వేర్ ఇంజనీర్లు దాని వినియోగదారుల అవసరాలను తీర్చే అధిక-నాణ్యత సాఫ్ట్‌వేర్‌ను సృష్టించగలరు.

- సాఫ్ట్‌వేర్ ఇంజనీరింగ్‌లో మొదటి దశ అవసరాల సేకరణ. ఈ దశలో, సాఫ్ట్‌వేర్ ఇంజనీర్ క్లయింట్‌తో కలిసి సాఫ్ట్‌వేర్ యొక్క ఫంక్షనల్ మరియు నాన్-ఫంక్షనల్ అవసరాలను గుర్తించడానికి పని చేస్తాడు. ఫంక్షనల్ అవసరాలు సాఫ్ట్‌వేర్ ఏమి చేయాలో వివరిస్తాయి, అయితే ఫంక్షనల్ కాని అవసరాలు దానిని ఎంత బాగా చేయాలో వివరిస్తాయి. అవసరాల సేకరణ అనేది ఒక క్లిష్టమైన దశ, ఎందుకంటే ఇది మొత్తం సాఫ్ట్‌వేర్ అభివృద్ధి ప్రక్రియకు పునాది వేస్తుంది.

- అవసరాలు సేకరించిన తర్వాత, తదుపరి దశ డిజైన్. ఈ దశలో, సాఫ్ట్‌వేర్ ఇంజనీర్ సాఫ్ట్‌వేర్ ఆర్కిటెక్చర్ మరియు కార్యాచరణ కోసం వివరణాత్మక ప్రణాళికను రూపొందిస్తాడు. ఈ ప్లాన్‌లో సాఫ్ట్‌వేర్ నిర్మాణం, ప్రవర్తన మరియు ఇతర సిస్టమ్‌లతో పరస్పర చర్యలను పేర్కొనే సాఫ్ట్‌వేర్ డిజైన్ పత్రం ఉంటుంది. సాఫ్ట్‌వేర్ డిజైన్ డాక్యుమెంట్ అమలు దశకు బ్లూప్రింట్‌గా ఉపయోగపడుతుంది కాబట్టి ఇది చాలా అవసరం.

- అమలు దశ అంటే సాఫ్ట్‌వేర్ ఇంజనీర్ సాఫ్ట్‌వేర్ కోసం అసలు కోడ్‌ను సృష్టించడం. ఇక్కడే డిజైన్ డాక్యుమెంట్ వర్కింగ్ సాఫ్ట్‌వేర్‌గా మార్చబడుతుంది. అమలు దశలో కోడ్ రాయడం, కంపైల్ చేయడం మరియు డిజైన్ డాక్యుమెంట్‌లో పేర్కొన్న అవసరాలకు అనుగుణంగా ఉండేలా పరీక్షించడం వంటివి ఉంటాయి.

- సాఫ్ట్‌వేర్ ఇంజినీరింగ్‌లో పరీక్ష అనేది కీలక దశ. ఈ దశలో, సాఫ్ట్‌వేర్ ఇంజనీర్ సాఫ్ట్‌వేర్ సరిగ్గా పనిచేస్తుందని, నమ్మదగినదని మరియు ఉపయోగించడానికి సులభమైనదని నిర్ధారించడానికి తనిఖీ చేస్తాడు. ఇందులో యూనిట్ టెస్టింగ్, ఇంటిగ్రేషన్ టెస్టింగ్ మరియు సిస్టమ్ టెస్టింగ్ వంటి అనేక రకాల టెస్టింగ్ ఉంటుంది. టెస్టింగ్ సాఫ్ట్‌వేర్ ఆశించిన విధంగా అవసరాలు మరియు విధులను తీరుస్తుందని నిర్ధారిస్తుంది.

- సాఫ్ట్‌వేర్ ఇంజనీరింగ్ చివరి దశ నిర్వహణ. ఈ దశలో, సాఫ్ట్‌వేర్ ఇంజనీర్ లోపాలను సరిచేయడానికి, కొత్త ఫీచర్‌లను జోడించడానికి లేదా దాని పనితీరును మెరుగుపరచడానికి సాఫ్ట్‌వేర్‌లో మార్పులు చేస్తాడు. నిర్వహణ అనేది సాఫ్ట్‌వేర్ జీవితకాలమంతా కొనసాగే కొనసాగుతున్న ప్రక్రియ.

### సాఫ్ట్‌వేర్ ఇంజనీరింగ్ ఎందుకు ప్రసిద్ధి చెందింది?

- కంప్యూటర్ సైన్స్: ఎలక్ట్రికల్ ఇంజనీరింగ్ ప్రధానంగా భౌతిక శాస్త్రంపై ఆధారపడి ఉంటుంది కాబట్టి సాఫ్ట్‌వేర్‌కు శాస్త్రీయ పునాదిని ఇస్తుంది.
- మేనేజ్‌మెంట్ సైన్స్: సాఫ్ట్‌వేర్ ఇంజనీరింగ్ శ్రమతో కూడుకున్నది మరియు సాంకేతిక మరియు నిర్వాహక నియంత్రణను కోరుతుంది. అందువల్ల, ఇది నిర్వహణ శాస్త్రంలో విస్తృతంగా ఉపయోగించబడుతుంది.
- ఎకనామిక్స్: ఈ రంగంలో, సాఫ్ట్‌వేర్ ఇంజనీరింగ్ వనరులను అంచనా వేయడానికి మరియు ఖర్చులను నియంత్రించడంలో మీకు సహాయపడుతుంది. ఒక కంప్యూటింగ్ సిస్టమ్ అభివృద్ధి చేయబడాలి మరియు ఇచ్చిన బడ్జెట్‌లో డేటాను క్రమం తప్పకుండా నిర్వహించాలి.
- సిస్టమ్ ఇంజనీరింగ్: చాలా సాఫ్ట్‌వేర్ చాలా పెద్ద సిస్టమ్‌లో భాగం. ఉదాహరణకు, ఇండస్ట్రీ మానిటరింగ్ సిస్టమ్‌లోని సాఫ్ట్‌వేర్ లేదా విమానంలోని ఫ్లైట్ సాఫ్ట్‌వేర్. ఈ రకమైన వ్యవస్థ యొక్క అధ్యయనానికి సాఫ్ట్‌వేర్ ఇంజనీరింగ్ పద్ధతులను వర్తింపజేయాలి.

## [ఇంటిగ్రేటెడ్ సర్క్యూట్‌లు](ఇంటిగ్రేటెడ్%20సర్క్యూట్‌లు/readme.md)
ఇంటిగ్రేటెడ్ సర్క్యూట్ లేదా మోనోలిథిక్ ఇంటిగ్రేటెడ్ సర్క్యూట్ (దీనిని IC, చిప్ లేదా మైక్రోచిప్ అని కూడా పిలుస్తారు) అనేది సెమీకండక్టర్ పదార్థం యొక్క ఒక చిన్న ఫ్లాట్ పీస్ (లేదా "చిప్"), సాధారణంగా సిలికాన్‌పై ఎలక్ట్రానిక్ సర్క్యూట్‌ల సమితి. చాలా చిన్న MOSFETలు (మెటల్-ఆక్సైడ్-సెమీకండక్టర్ ఫీల్డ్-ఎఫెక్ట్ ట్రాన్సిస్టర్‌లు) చిన్న చిప్‌లో కలిసిపోతాయి. ఇది వివిక్త ఎలక్ట్రానిక్ భాగాలతో నిర్మించిన వాటి కంటే చిన్న, వేగవంతమైన మరియు తక్కువ ఖర్చుతో కూడిన సర్క్యూట్‌లకు దారి తీస్తుంది. IC యొక్క సామూహిక ఉత్పత్తి సామర్థ్యం, ​​విశ్వసనీయత మరియు ఇంటిగ్రేటెడ్ సర్క్యూట్ డిజైన్‌కు బిల్డింగ్-బ్లాక్ విధానం వివిక్త ట్రాన్సిస్టర్‌ల స్థానంలో ప్రామాణిక ICలను వేగంగా స్వీకరించేలా నిర్ధారిస్తుంది. ICలు ఇప్పుడు వాస్తవంగా అన్ని ఎలక్ట్రానిక్ పరికరాలలో ఉపయోగించబడుతున్నాయి మరియు ఎలక్ట్రానిక్స్ ప్రపంచాన్ని విప్లవాత్మకంగా మార్చాయి. కంప్యూటర్లు, మొబైల్ ఫోన్‌లు మరియు ఇతర గృహోపకరణాలు ఇప్పుడు ఆధునిక సమాజాల నిర్మాణంలో విడదీయరాని భాగాలుగా మారాయి, ఆధునిక కంప్యూటర్ ప్రాసెసర్‌లు మరియు మైక్రోకంట్రోలర్‌లు వంటి ICల యొక్క చిన్న పరిమాణం మరియు తక్కువ ధరతో సాధ్యమయ్యాయి.

మెటల్-ఆక్సైడ్-సిలికాన్ (MOS) సెమీకండక్టర్ డివైస్ ఫ్యాబ్రికేషన్‌లో సాంకేతిక పురోగతి ద్వారా చాలా-పెద్ద-స్థాయి ఏకీకరణ ఆచరణాత్మకమైనది. 1960వ దశకంలో వాటి మూలం నుండి, చిప్‌ల పరిమాణం, వేగం మరియు సామర్థ్యం అపారంగా పురోగమించాయి, అదే పరిమాణంలోని చిప్‌లపై మరింత ఎక్కువ MOS ట్రాన్సిస్టర్‌లకు సరిపోయే సాంకేతిక పురోగతులతో నడిచింది - ఒక ఆధునిక చిప్‌లో అనేక బిలియన్ల MOS ట్రాన్సిస్టర్‌లు ఉండవచ్చు. మానవ వేలుగోళ్ల పరిమాణంలో ఉన్న ప్రాంతం. ఈ పురోగతులు, స్థూలంగా మూర్ చట్టాన్ని అనుసరించి, నేటి కంప్యూటర్ చిప్‌లు 1970ల ప్రారంభంలో కంప్యూటర్ చిప్‌ల కంటే మిలియన్ల రెట్లు మరియు వేగాన్ని వేల రెట్లు కలిగి ఉన్నాయి.

ICలు వివిక్త సర్క్యూట్‌ల కంటే రెండు ప్రధాన ప్రయోజనాలను కలిగి ఉన్నాయి: ఖర్చు మరియు పనితీరు. చిప్‌లు, వాటి భాగాలన్నింటితో పాటు, ఒక సమయంలో ఒక ట్రాన్సిస్టర్‌ను నిర్మించకుండా ఫోటోలిథోగ్రఫీ ద్వారా యూనిట్‌గా ముద్రించబడినందున ఖర్చు తక్కువగా ఉంటుంది. ఇంకా, ప్యాక్ చేయబడిన ICలు డిస్క్రీట్ సర్క్యూట్‌ల కంటే చాలా తక్కువ మెటీరియల్‌ని ఉపయోగిస్తాయి. పనితీరు ఎక్కువగా ఉంటుంది ఎందుకంటే IC యొక్క భాగాలు త్వరగా మారతాయి మరియు వాటి చిన్న పరిమాణం మరియు సామీప్యత కారణంగా తులనాత్మకంగా తక్కువ శక్తిని వినియోగిస్తాయి. ICల యొక్క ప్రధాన ప్రతికూలత ఏమిటంటే వాటిని రూపొందించడానికి మరియు అవసరమైన ఫోటోమాస్క్‌లను రూపొందించడానికి అధిక ధర. ఈ అధిక ప్రారంభ ధర అంటే అధిక ఉత్పత్తి వాల్యూమ్‌లను ఊహించినప్పుడు మాత్రమే ICలు వాణిజ్యపరంగా లాభదాయకంగా ఉంటాయి.

### రకాలు
ఆధునిక ఎలక్ట్రానిక్ కాంపోనెంట్ డిస్ట్రిబ్యూటర్లు తరచుగా ఇంటిగ్రేటెడ్ సర్క్యూట్‌లను ఉప-వర్గీకరించారు:

- డిజిటల్ ICలు లాజిక్ ICలు (మైక్రోప్రాసెసర్‌లు మరియు మైక్రోకంట్రోలర్‌లు వంటివి), మెమరీ చిప్‌లు (MOS మెమరీ మరియు ఫ్లోటింగ్-గేట్ మెమరీ వంటివి), ఇంటర్‌ఫేస్ ICలు (లెవల్ షిఫ్టర్‌లు, సీరియలైజర్/డీరియలైజర్ మొదలైనవి), పవర్ మేనేజ్‌మెంట్ ICలు మరియు ప్రోగ్రామబుల్‌గా వర్గీకరించబడ్డాయి. పరికరాలు.
- అనలాగ్ ICలు లీనియర్ ఇంటిగ్రేటెడ్ సర్క్యూట్‌లు మరియు RF సర్క్యూట్‌లు (రేడియో ఫ్రీక్వెన్సీ సర్క్యూట్‌లు)గా వర్గీకరించబడ్డాయి.
- మిక్స్‌డ్-సిగ్నల్ ఇంటిగ్రేటెడ్ సర్క్యూట్‌లు డేటా అక్విజిషన్ ICలు (A/D కన్వర్టర్‌లు, D/A కన్వర్టర్‌లు మరియు డిజిటల్ పొటెన్షియోమీటర్‌లు), క్లాక్/టైమింగ్ ICలు, స్విచ్డ్ కెపాసిటర్ (SC) సర్క్యూట్‌లు మరియు RF CMOS సర్క్యూట్‌లుగా వర్గీకరించబడ్డాయి.
- త్రీ-డైమెన్షనల్ ఇంటిగ్రేటెడ్ సర్క్యూట్‌లు (3D ICలు) సిలికాన్ ద్వారా (TSV) ICలు మరియు Cu-Cu కనెక్షన్ ICలు ద్వారా వర్గీకరించబడ్డాయి.


## [ఆబ్జెక్ట్ ఓరియెంటెడ్ ప్రోగ్రామింగ్](Object%20Oriented%20Programming/readme.md)
ఆబ్జెక్ట్ ఓరియెంటెడ్ ప్రోగ్రామింగ్ అనేది వస్తువులు మరియు డేటా యొక్క భావనలపై ఆధారపడిన ప్రాథమిక ప్రోగ్రామింగ్ నమూనా.

కోడ్ యొక్క మెరుగైన రీడబిలిటీ మరియు పునర్వినియోగం కోసం ప్రతి ప్రోగ్రామర్ కట్టుబడి ఉండాల్సిన ప్రామాణిక కోడ్ ఇది.

### * ఆబ్జెక్ట్ ఓరియెంటెడ్ ప్రోగ్రామింగ్‌లో నాలుగు ప్రాథమిక అంశాలు ఉన్నాయి:
- సంగ్రహణ
- ఎన్కప్సులేషన్
- వారసత్వం
- పాలిమార్ఫిజం

OOP యొక్క ఈ భావనల గురించి మరింత చదవండి [ఇక్కడ](Object%20Oriented%20Programming/readme.md)

## [ఫంక్షనల్ ప్రోగ్రామింగ్](ఫంక్షనల్%20Programming/readme.md)

కంప్యూటర్ సైన్స్‌లో, ఫంక్షనల్ ప్రోగ్రామింగ్ అనేది ప్రోగ్రామింగ్ నమూనా, ఇక్కడ ప్రోగ్రామ్‌లను వర్తింపజేయడం మరియు కంపోజ్ చేయడం ద్వారా ప్రోగ్రామ్‌లు నిర్మించబడతాయి. ఇది డిక్లరేటివ్ ప్రోగ్రామింగ్ నమూనా, దీనిలో ఫంక్షన్ నిర్వచనాలు ప్రోగ్రామ్ యొక్క నడుస్తున్న స్థితిని నవీకరించే అత్యవసర ప్రకటనల క్రమం కాకుండా, ఇతర విలువలకు విలువలను మ్యాప్ చేసే వ్యక్తీకరణల వృక్షాలు.

ఫంక్షనల్ ప్రోగ్రామింగ్‌లో, ఫంక్షన్‌లు ఫస్ట్-క్లాస్ సిటిజన్‌లుగా పరిగణించబడతాయి, అంటే అవి పేర్లకు (స్థానిక ఐడెంటిఫైయర్‌లతో సహా) కట్టుబడి ఉంటాయి, ఆర్గ్యుమెంట్‌లుగా ఆమోదించబడతాయి మరియు ఏదైనా ఇతర డేటా రకం వలె ఇతర ఫంక్షన్‌ల నుండి తిరిగి ఇవ్వబడతాయి. ఇది ప్రోగ్రామ్‌లను డిక్లరేటివ్ మరియు కంపోజబుల్ శైలిలో వ్రాయడానికి అనుమతిస్తుంది, ఇక్కడ చిన్న విధులు మాడ్యులర్ పద్ధతిలో మిళితం చేయబడతాయి.

ఫంక్షనల్ ప్రోగ్రామింగ్ కొన్నిసార్లు పూర్తిగా ఫంక్షనల్ ప్రోగ్రామింగ్‌కు పర్యాయపదంగా పరిగణించబడుతుంది, ఇది ఫంక్షనల్ ప్రోగ్రామింగ్ యొక్క ఉపసమితి, ఇది అన్ని ఫంక్షన్‌లను నిర్ణయాత్మక గణిత విధులు లేదా స్వచ్ఛమైన విధులుగా పరిగణిస్తుంది. కొన్ని ఇచ్చిన ఆర్గ్యుమెంట్‌లతో స్వచ్ఛమైన ఫంక్షన్‌ని పిలిచినప్పుడు, అది ఎల్లప్పుడూ అదే ఫలితాన్ని అందిస్తుంది మరియు ఏదైనా మార్చగల స్థితి లేదా ఇతర దుష్ప్రభావాల ద్వారా ప్రభావితం చేయబడదు. ఇది ఇంపెరేటివ్ ప్రోగ్రామింగ్‌లో సాధారణమైన అపవిత్ర విధానాలకు విరుద్ధంగా ఉంటుంది, ఇది దుష్ప్రభావాలు (ప్రోగ్రామ్ యొక్క స్థితిని సవరించడం లేదా వినియోగదారు నుండి ఇన్‌పుట్ తీసుకోవడం వంటివి) కలిగి ఉంటుంది. పూర్తిగా ఫంక్షనల్ ప్రోగ్రామింగ్ యొక్క ప్రతిపాదకులు దుష్ప్రభావాలను పరిమితం చేయడం ద్వారా, ప్రోగ్రామ్‌లు తక్కువ బగ్‌లను కలిగి ఉంటాయని, డీబగ్ చేయడం మరియు పరీక్షించడం సులభం మరియు అధికారిక ధృవీకరణ విధానాలకు మరింత అనుకూలంగా ఉంటాయి.

ఫంక్షనల్ ప్రోగ్రామింగ్ దాని మూలాలను అకాడెమియాలో కలిగి ఉంది, ఇది లాంబ్డా కాలిక్యులస్ నుండి ఉద్భవించింది, ఇది కేవలం ఫంక్షన్‌ల ఆధారంగా గణన యొక్క అధికారిక వ్యవస్థ. ఫంక్షనల్ ప్రోగ్రామింగ్ చారిత్రాత్మకంగా అత్యవసరమైన ప్రోగ్రామింగ్ కంటే తక్కువ జనాదరణ పొందింది, అయితే అనేక ఫంక్షనల్ భాషలు నేడు పరిశ్రమ మరియు విద్యలో ఉపయోగించబడుతున్నాయి.

ఫంక్షనల్ ప్రోగ్రామింగ్ భాషలకు కొన్ని ఉదాహరణలు:
- <a href="https://lisp-lang.org/"> కామన్ లిస్ప్ </a>
- <a href="https://www.scheme.org/"> పథకం </a>
- <a href="https://racket-lang.org/"> రాకెట్ </a>
- <a href="https://www.erlang.org/"> ఎర్లాంగ్ </a>
- <a href="https://www.haskell.org/"> హాస్కెల్ </a>
- <a href="https://fsharp.org/"> F# </a>
- <a href="https://cs.lmu.edu/~ray/notes/introml/"> ML </a>

ఫంక్షనల్ ప్రోగ్రామింగ్ చారిత్రాత్మకంగా *లాంబ్డా కాలిక్యులస్* నుండి తీసుకోబడింది. లాంబ్డా కాలిక్యులస్ అనేది ఫంక్షన్లతో గణనలను అధ్యయనం చేయడానికి అలోంజో చర్చిచే అభివృద్ధి చేయబడిన ఫ్రేమ్‌వర్క్. దీనిని తరచుగా "ప్రపంచంలోని అతి చిన్న ప్రోగ్రామింగ్ భాష" అని పిలుస్తారు. ఇది ఏది గణించదగినది మరియు ఏది కాదు అనేదానికి నిర్వచనాన్ని అందిస్తుంది. ఇది ట్యూరింగ్ మెషీన్‌కు దాని గణన సామర్థ్యంతో సమానం మరియు లాంబ్డా కాలిక్యులస్ ద్వారా గణించదగిన ఏదైనా ట్యూరింగ్ మెషీన్ ద్వారా గణించదగినది ఏదైనా గణించదగినది. ఇది విధులు మరియు వాటి మూల్యాంకనాలను వివరించడానికి సైద్ధాంతిక ఫ్రేమ్‌వర్క్‌ను అందిస్తుంది.

ఫంక్షనల్ ప్రోగ్రామింగ్ యొక్క కొన్ని ముఖ్యమైన అంశాలు:
- స్వచ్ఛమైన విధులు
- పునరావృతం
- సూచన పారదర్శకత
- ఫస్ట్ క్లాస్ మరియు హయ్యర్ ఆర్డర్ ఫంక్షన్‌లుగా విధులు
- వేరియబుల్ మార్పులేనివి.

**ప్యూర్ ఫంక్షన్‌లు**: ఈ ఫంక్షన్‌లు రెండు ప్రధాన లక్షణాలను కలిగి ఉంటాయి. మొదటిది, మరేదైనా సంబంధం లేకుండా ఒకే వాదనల కోసం అవి ఎల్లప్పుడూ ఒకే అవుట్‌పుట్‌ను ఉత్పత్తి చేస్తాయి. రెండవది, వాటికి ఎటువంటి దుష్ప్రభావాలు లేవు. అనగా వారు ఎటువంటి వాదనలు లేదా స్థానిక/గ్లోబల్ వేరియబుల్‌ను సవరించరు
లేదా ఇన్‌పుట్/అవుట్‌పుట్ స్ట్రీమ్‌లు. తరువాతి ఆస్తిని *మార్పులేని* అంటారు. స్వచ్ఛమైన ఫంక్షన్ యొక్క ఏకైక ఫలితం అది తిరిగి ఇచ్చే విలువ. అవి నిర్ణయాత్మకమైనవి. ఫంక్షనల్ ప్రోగ్రామింగ్‌ని ఉపయోగించి చేసిన ప్రోగ్రామ్‌లు డీబగ్ చేయడం సులభం ఎందుకంటే వాటికి ఎటువంటి దుష్ప్రభావాలు లేవు లేదా దాచిన I/O. ప్యూర్ ఫంక్షన్‌లు సమాంతర/ఏకకాలిక అప్లికేషన్‌లను వ్రాయడాన్ని సులభతరం చేస్తాయి. ఈ శైలిలో కోడ్ వ్రాయబడినప్పుడు, స్మార్ట్ కంపైలర్ అనేక పనులను చేయగలదు- ఇది సూచనలను సమాంతరంగా చేయగలదు, అవసరమైనంత వరకు ఫలితాలను మూల్యాంకనం చేయడానికి వేచి ఉండండి మరియు ఇన్‌పుట్ మారనంత కాలం ఫలితాలు మారవు కాబట్టి ఫలితాలను గుర్తుంచుకోండి. పైథాన్‌లోని ప్యూర్ ఫంక్షన్‌కి ఇక్కడ ఒక సాధారణ ఉదాహరణ:

```కొండచిలువ
def sum(x ,y): # sum అనేది x మరియు y లను ఆర్గ్యుమెంట్‌లుగా తీసుకునే ఫంక్షన్
    తిరిగి x + y # విలువను మార్చకుండా x + yని తిరిగి ఇస్తుంది
 ```

** పునరావృతం**: స్వచ్ఛమైన ఫంక్షనల్ ప్రోగ్రామింగ్ భాషలలో "ఫర్" లేదా "వైల్" లూప్‌లు లేవు. పునరావృతం ద్వారా పునరావృతం చేయబడుతుంది. ఒక బేస్ కేస్ చేరే వరకు పునరావృత విధులు పదే పదే తమను తాము పిలుస్తాయి. పునరావృతం యొక్క సాధారణ ఉదాహరణ ఇక్కడ ఉంది
C లో ఫంక్షన్:

```సి
int fib(n) {
  ఉంటే (n <= 1)
    తిరిగి 1;
   లేకపోతే
     తిరిగి (fib(n-1) + fib(n-2));
}
 ```

 **రిఫరెన్షియల్ పారదర్శకత**: ఫంక్షనల్ ప్రోగ్రామ్‌లలో, ఒకసారి నిర్వచించిన వేరియబుల్స్ ప్రోగ్రామ్ అంతటా వాటి విలువను మార్చవు.
ఫంక్షనల్ ప్రోగ్రామ్‌లు అసైన్‌మెంట్ స్టేట్‌మెంట్‌లను కలిగి ఉండవు. మనం కొంత విలువను నిల్వ చేయవలసి వస్తే, బదులుగా కొత్త వేరియబుల్‌ని నిర్వచించాము. ఇది దుష్ప్రభావాల యొక్క ఏదైనా అవకాశాన్ని తొలగిస్తుంది ఎందుకంటే ఏదైనా వేరియబుల్ అమలు సమయంలో దాని వాస్తవ విలువతో భర్తీ చేయబడుతుంది. ఏదైనా వేరియబుల్ యొక్క స్థితి ఏ క్షణంలోనైనా స్థిరంగా ఉంటుంది. ఉదాహరణ:
 
```బాష్
x = x + 1 # ఇది వేరియబుల్ xకి కేటాయించిన విలువను మార్చింది
         # కాబట్టి, వ్యక్తీకరణ రెఫరెన్షియల్‌గా పారదర్శకంగా ఉండదు
```

**ఫంక్షన్‌లు ఫస్ట్-క్లాస్ మరియు హైయర్ ఆర్డర్**: ఫస్ట్ క్లాస్ ఫంక్షన్‌లు ఫస్ట్-క్లాస్ వేరియబుల్స్‌గా పరిగణించబడతాయి. ఫస్ట్ క్లాస్ వేరియబుల్స్‌ని ఫంక్షన్‌లకు పారామీటర్‌లుగా పాస్ చేయవచ్చు, ఫంక్షన్‌ల నుండి రిటర్న్ చేయవచ్చు లేదా డేటా స్ట్రక్చర్‌లలో స్టోర్ చేయవచ్చు.
         
ఫంక్షన్ అప్లికేషన్‌ల కలయికను **ఫన్‌కాల్** అనే LISP ఫారమ్‌ని ఉపయోగించి నిర్వచించవచ్చు, ఇది ఒక ఫంక్షన్ మరియు ఆర్గ్యుమెంట్‌ల శ్రేణిని ఆర్గ్యుమెంట్‌లుగా తీసుకుంటుంది మరియు ఆ ఆర్గ్యుమెంట్‌లకు ఆ ఫంక్షన్‌ని వర్తింపజేస్తుంది:

```లిస్ప్
(డిఫన్ ఫిల్టర్ (లిస్ట్ ఆఫ్ ఎలిమెంట్స్ టెస్ట్)
    (కాండ్ ((మూలకాల యొక్క శూన్య జాబితా) నిల్)
          ((ఫన్‌కాల్ టెస్ట్ (కార్ లిస్ట్ ఆఫ్ ఎలిమెంట్స్))
            (కాన్స్ (కార్ లిస్ట్ ఆఫ్ ఎలిమెంట్స్)
                (ఫిల్టర్ (సిడిఆర్ లిస్ట్ ఆఫ్ ఎలిమెంట్స్)
                      పరీక్ష)))
           (t (ఫిల్టర్ (cdr లిస్ట్ ఆఫ్ ఎలిమెంట్స్)
                       పరీక్ష))))
   ```
  **ఫిల్టర్** ఫంక్షన్ జాబితా యొక్క మొదటి మూలకానికి పరీక్షను వర్తింపజేస్తుంది. పరీక్ష శూన్యం కానిదిగా తిరిగి వచ్చినట్లయితే, అది జాబితా యొక్క cdrకి వర్తింపజేయబడిన ఫిల్టర్ యొక్క ఫలితంపై మూలకాన్ని కలిగి ఉంటుంది; లేకుంటే, అది కేవలం ఫిల్టర్ చేయబడిన cdrని తిరిగి ఇస్తుంది. ఈ ఫంక్షన్ వివిధ రకాల ఫిల్టరింగ్ పనులను నిర్వహించడానికి పారామీటర్‌లుగా ఆమోదించబడిన విభిన్న అంచనాలతో ఉపయోగించవచ్చు:

```లిస్ప్
    > (ఫిల్టర్ '(1 3 -9 5 -2 -7 6) #'plusp) ; అన్ని ప్రతికూల సంఖ్యలను ఫిల్టర్ చేయండి
```
    అవుట్‌పుట్: (1 3 5 6)

```లిస్ప్
   > (ఫిల్టర్ '(1 2 3 4 5 6 7 8 9) #'evenp) ; అన్ని బేసి సంఖ్యలను ఫిల్టర్ చేయండి
```
   అవుట్‌పుట్: (2 4 6 8)

   మరియు అందువలన న.

   **వేరియబుల్స్ మార్పులేనివి**: ఫంక్షనల్ ప్రోగ్రామింగ్‌లో, బీమ్ ప్రారంభించిన తర్వాత మనం వేరియబుల్‌ని సవరించలేము.
మేము కొత్త వేరియబుల్‌లను సృష్టించగలము- కానీ ఇప్పటికే ఉన్న వేరియబుల్‌ను మేము సవరించలేము మరియు ఇది ప్రోగ్రామ్ యొక్క రన్‌టైమ్ అంతటా స్థితిని నిర్వహించడానికి నిజంగా సహాయపడుతుంది. ఒకసారి మనం ఒక వేరియబుల్‌ని సృష్టించి దాని విలువను సెట్ చేసిన తర్వాత, ఆ వేరియబుల్ విలువ ఎప్పటికీ మారదని తెలుసుకోవడం ద్వారా మనకు పూర్తి విశ్వాసం ఉంటుంది.

## [ఆపరేటింగ్ సిస్టమ్స్](ఆపరేటింగ్%20Systems/readme.md)
ఆపరేటింగ్ సిస్టమ్ (లేదా సంక్షిప్తంగా OS) కంప్యూటర్ వినియోగదారు మరియు కంప్యూటర్ హార్డ్‌వేర్ మధ్య మధ్యవర్తిగా పనిచేస్తుంది. ఆపరేటింగ్ సిస్టమ్ యొక్క ఉద్దేశ్యం వినియోగదారుడు ప్రోగ్రామ్‌లను సౌకర్యవంతంగా మరియు సమర్ధవంతంగా అమలు చేయగల వాతావరణాన్ని అందించడం.
ఆపరేటింగ్ సిస్టమ్ అనేది కంప్యూటర్ హార్డ్‌వేర్‌ను నిర్వహించే సాఫ్ట్‌వేర్. కంప్యూటర్ సిస్టమ్ యొక్క సరైన ఆపరేషన్‌ను నిర్ధారించడానికి మరియు సిస్టమ్ యొక్క సరైన ఆపరేషన్‌లో జోక్యం చేసుకోకుండా వినియోగదారు ప్రోగ్రామ్‌లను నిరోధించడానికి హార్డ్‌వేర్ తగిన యంత్రాంగాలను అందించాలి.
మరింత సాధారణ నిర్వచనం ఏమిటంటే, ఆపరేటింగ్ సిస్టమ్ అనేది కంప్యూటర్‌లో అన్ని సమయాల్లో నడుస్తున్న ఒక ప్రోగ్రామ్ (సాధారణంగా కెర్నల్ అని పిలుస్తారు), మిగతావన్నీ అప్లికేషన్ ప్రోగ్రామ్‌లు.

ఆపరేటింగ్ సిస్టమ్‌లను రెండు దృక్కోణాల నుండి చూడవచ్చు: వనరుల నిర్వాహకులు మరియు
విస్తరించిన యంత్రాలు. రిసోర్స్-మేనేజర్ వీక్షణలో, ఆపరేటింగ్ సిస్టమ్ యొక్క పని
వ్యవస్థలోని వివిధ భాగాలను సమర్థవంతంగా నిర్వహించండి. విస్తరించిన యంత్ర వీక్షణలో,
సిస్టమ్ యొక్క పని వినియోగదారులకు మరింత సంగ్రహణలను అందించడం.
అసలు యంత్రం కంటే ఉపయోగించడానికి అనుకూలమైనది. వీటిలో ప్రక్రియలు, చిరునామా ఖాళీలు,
మరియు ఫైళ్లు.
ఆపరేటింగ్ సిస్టమ్‌లు ఆపరేటర్‌ను భర్తీ చేసినప్పటి నుండి ఆధునిక మల్టీప్రోగ్రామింగ్ సిస్టమ్‌ల వరకు సుదీర్ఘ చరిత్రను కలిగి ఉన్నాయి.
హైలైట్‌లలో ప్రారంభ బ్యాచ్ సిస్టమ్‌లు, మల్టీప్రోగ్రామింగ్ సిస్టమ్‌లు మరియు పర్సనల్ కంప్యూటర్ సిస్టమ్‌లు ఉన్నాయి.
ఆపరేటింగ్ సిస్టమ్‌లు హార్డ్‌వేర్‌తో సన్నిహితంగా సంకర్షణ చెందుతాయి కాబట్టి, కొంత జ్ఞానం
వాటిని అర్థం చేసుకోవడానికి కంప్యూటర్ హార్డ్‌వేర్ ఉపయోగపడుతుంది. కంప్యూటర్లు నిర్మించబడ్డాయి
ప్రాసెసర్లు, జ్ఞాపకాలు మరియు I/O పరికరాలు. ఈ భాగాలు బస్సుల ద్వారా అనుసంధానించబడి ఉన్నాయి.
అన్ని ఆపరేటింగ్ సిస్టమ్‌లు నిర్మించబడిన ప్రాథమిక అంశాలు ప్రక్రియలు,
మెమరీ నిర్వహణ, I/O నిర్వహణ, ఫైల్ సిస్టమ్ మరియు భద్రత. ఏదైనా ఆపరేటింగ్ సిస్టమ్ యొక్క గుండె అది నిర్వహించగల సిస్టమ్ కాల్‌ల సమితి.
ఆపరేటింగ్ సిస్టమ్ ఏమి చేస్తుందో ఇవి తెలియజేస్తాయి.

### రిసోర్స్ మేనేజర్‌గా ఆపరేటింగ్ సిస్టమ్
ఆపరేటింగ్ సిస్టమ్ సంక్లిష్ట వ్యవస్థ యొక్క అన్ని భాగాలను నిర్వహిస్తుంది. ఆధునిక కంప్యూటర్‌లు ప్రాసెసర్‌లు, జ్ఞాపకాలు, టైమర్‌లు, డిస్క్‌లు, ఎలుకలు,
నెట్‌వర్క్ ఇంటర్‌ఫేస్‌లు, ప్రింటర్లు మరియు అనేక రకాల ఇతర పరికరాలు.
దిగువ వీక్షణలో, ఆపరేటింగ్ సిస్టమ్ యొక్క పని క్రమబద్ధమైన మరియు నియంత్రిత కేటాయింపును అందించడం.
ప్రాసెసర్‌లు, జ్ఞాపకాలు మరియు I/O పరికరాలు కోరుకునే వివిధ ప్రోగ్రామ్‌లలో ఉన్నాయి.
ఆధునిక ఆపరేటింగ్ సిస్టమ్‌లు బహుళ ప్రోగ్రామ్‌లను మెమరీలో మరియు అమలు చేయడానికి అనుమతిస్తాయి
ఏకకాలంలో. కొన్నింటిలో మూడు ప్రోగ్రామ్‌లు నడుస్తున్నట్లయితే ఏమి జరుగుతుందో ఊహించండి
కంప్యూటర్‌లన్నీ ఒకే ప్రింటర్‌లో తమ అవుట్‌పుట్‌ను ఏకకాలంలో ప్రింట్ చేయడానికి ప్రయత్నించాయి.
ఫలితం పూర్తిగా గందరగోళంగా ఉంటుంది. ఆపరేటింగ్ సిస్టమ్ సంభావ్య గందరగోళానికి క్రమాన్ని తీసుకురాగలదు
డిస్క్‌లో ప్రింటర్‌కు ఉద్దేశించిన మొత్తం అవుట్‌పుట్‌ను బఫర్ చేయడం ద్వారా.
ఒక ప్రోగ్రామ్ పూర్తయినప్పుడు, ఆపరేటింగ్ సిస్టమ్ చేయగలదు
ఆపై ప్రింటర్ కోసం నిల్వ చేయబడిన డిస్క్ ఫైల్ నుండి దాని అవుట్‌పుట్‌ను కాపీ చేయండి,
అదే సమయంలో, ఇతర ప్రోగ్రామ్ మరింత అవుట్‌పుట్‌ను ఉత్పత్తి చేయడాన్ని కొనసాగించవచ్చు,
అవుట్‌పుట్ ప్రింటర్‌కి వెళ్లడం లేదని (ఇంకా) పట్టించుకోలేదు.
కంప్యూటర్ (లేదా నెట్‌వర్క్) ఒకటి కంటే ఎక్కువ మంది వినియోగదారులను కలిగి ఉన్నప్పుడు, నిర్వహించాల్సిన అవసరం ఉంది
మరియు మెమొరీ, I/O పరికరాలు మరియు ఇతర వనరులను మరింత ఎక్కువగా రక్షించండి
వినియోగదారులు ఒకరితో ఒకరు జోక్యం చేసుకోవచ్చు. అదనంగా, వినియోగదారులు తరచుగా అవసరం
హార్డ్‌వేర్ మాత్రమే కాకుండా సమాచారాన్ని కూడా భాగస్వామ్యం చేయండి (ఫైళ్లు, డేటాబేస్‌లు మొదలైనవి). సంక్షిప్తంగా,
ఆపరేటింగ్ సిస్టమ్ యొక్క ఈ అభిప్రాయం దాని ప్రాథమిక పనిని ట్రాక్ చేయడం
ఏ ప్రోగ్రామ్‌లు ఏ వనరును ఉపయోగిస్తున్నాయి, వనరుల అభ్యర్థనలను మంజూరు చేయడానికి, ఖాతాకు
ఉపయోగం కోసం మరియు విభిన్న ప్రోగ్రామ్‌లు మరియు వినియోగదారుల నుండి విరుద్ధమైన అభ్యర్థనలను మధ్యవర్తిత్వం చేయడానికి.

### ఆపరేటింగ్ సిస్టమ్ విస్తరించిన యంత్రంగా
మెషీన్-లాంగ్వేజ్ స్థాయిలో చాలా కంప్యూటర్ల నిర్మాణం ప్రాచీనమైనది మరియు ఇబ్బందికరమైనది
ప్రోగ్రామ్, ముఖ్యంగా ఇన్‌పుట్/అవుట్‌పుట్ కోసం. ఈ పాయింట్ మరింత కాంక్రీటుగా చేయడానికి, పరిగణించండి
చాలా కంప్యూటర్లలో ఉపయోగించే ఆధునిక SATA (సీరియల్ ATA) హార్డ్ డిస్క్‌లు. డిస్క్‌ని ఉపయోగించడానికి ప్రోగ్రామర్ ఏమి తెలుసుకోవాలి.
అప్పటి నుండి, ఇంటర్‌ఫేస్ అనేకసార్లు సవరించబడింది మరియు దాని కంటే చాలా క్లిష్టంగా ఉంది
2007. ఏ సేన్ ప్రోగ్రామర్ ఈ డిస్క్‌తో హార్డ్‌వేర్ స్థాయిలో వ్యవహరించాలని కోరుకోడు.
బదులుగా, డిస్క్ డ్రైవర్ అని పిలువబడే సాఫ్ట్‌వేర్ ముక్క హార్డ్‌వేర్‌తో వ్యవహరిస్తుంది మరియు డిస్క్ బ్లాక్‌లను చదవడానికి మరియు వ్రాయడానికి ఇంటర్‌ఫేస్‌ను అందిస్తుంది,
వివరాలలోకి రాకుండా.
I/O పరికరాలను నియంత్రించడానికి ఆపరేటింగ్ సిస్టమ్‌లు అనేక డ్రైవర్‌లను కలిగి ఉంటాయి.
కానీ చాలా అప్లికేషన్‌లకు ఈ స్థాయి కూడా చాలా తక్కువగా ఉంది. ఈ కారణంగా, అన్ని
ఆపరేటింగ్ సిస్టమ్‌లు డిస్క్‌లను ఉపయోగించడం కోసం మరొక నైరూప్య పొరను అందిస్తాయి: ఫైల్స్.
ఈ సంగ్రహాన్ని ఉపయోగించి, ప్రోగ్రామ్‌లు హార్డ్‌వేర్ ఎలా పనిచేస్తుందనే గజిబిజి వివరాలతో వ్యవహరించకుండా ఫైల్‌లను సృష్టించవచ్చు, వ్రాయవచ్చు మరియు చదవవచ్చు.
ఈ సంక్లిష్టతను నిర్వహించడానికి ఈ సంగ్రహణ కీలకం. మంచి సంగ్రహణలు
దాదాపు అసాధ్యమైన పనిని రెండు నిర్వహించదగినవిగా మార్చండి. మొదటిది నిర్వచించడం మరియు
సంగ్రహణలను అమలు చేయడం. రెండవది పరిష్కరించడానికి ఈ సంగ్రహాలను ఉపయోగించడం
చేతిలో సమస్య.

### ఆపరేటింగ్ సిస్టమ్స్ చరిత్ర
- **మొదటి తరం (1945-55)**: రెండవ ప్రపంచ యుద్ధ కాలం వరకు బాబేజ్ యొక్క వినాశకరమైన ప్రయత్నాల తర్వాత డిజిటల్ కంప్యూటర్‌ల నిర్మాణంలో స్వల్ప పురోగతి సాధించబడింది. అయోవా స్టేట్ యూనివర్శిటీలో, ప్రొఫెసర్ జాన్ అటానాసోఫ్ మరియు అతని గ్రాడ్యుయేట్ విద్యార్థి క్లిఫోర్డ్ బెర్రీ ఈ రోజు మొదటి కార్యాచరణ డిజిటల్ కంప్యూటర్‌గా గుర్తింపు పొందారు. బెర్లిన్‌లోని కొన్రాడ్ జుసే అదే సమయంలో ఎలక్ట్రోమెకానికల్ రిలేలను ఉపయోగించి Z3 కంప్యూటర్‌ను నిర్మించారు. మార్క్ Iను హార్వర్డ్‌లోని హోవార్డ్ ఐకెన్, ఇంగ్లాండ్‌లోని బ్లెచ్లీ పార్క్‌లోని శాస్త్రవేత్తల బృందం కొలోసస్ మరియు 1944లో పెన్సిల్వేనియా విశ్వవిద్యాలయంలో విలియం మౌచ్లీ మరియు అతని డాక్టరల్ విద్యార్థి J. ప్రెస్పెర్ ఎకెర్ట్ చేత ENIAC సృష్టించారు.

- **రెండవ తరం (1955-65)**: 1950ల మధ్యలో ట్రాన్సిస్టర్ యొక్క ఆవిష్కరణ పరిస్థితిని సమూలంగా మార్చింది. కంప్యూటర్లు తగినంతగా ఆధారపడదగినవిగా మారాయి, అవి కొంత అర్ధవంతమైన పనిని నిర్వహించడానికి చాలా కాలం పాటు పనిచేస్తాయనే ఊహతో వాటిని తయారు చేసి చెల్లించే వినియోగదారులకు విక్రయించవచ్చు. మెయిన్‌ఫ్రేమ్‌లు, ఈ మెషీన్‌లు ఇప్పుడు తెలిసినట్లుగా, భారీ, ప్రత్యేకించి ఎయిర్ కండిషన్డ్ కంప్యూటర్ రూమ్‌లలో బంధించబడ్డాయి, వాటిని నిర్వహించడానికి అర్హత కలిగిన ఆపరేటర్‌ల బృందాలు ఉన్నాయి. భారీ వ్యాపారాలు, ముఖ్యమైన ప్రభుత్వ సంస్థలు లేదా సంస్థలు మాత్రమే అనేక మిలియన్ డాలర్ల ధరను కొనుగోలు చేయగలవు.

- **మూడో తరం (1965-80)**: వ్యక్తిగత ట్రాన్సిస్టర్‌ల నుండి నిర్మించబడిన రెండవ తరం కంప్యూటర్‌లతో పోల్చితే, IBM 360 అనేది (చిన్న-స్థాయి) ICలను (ఇంటిగ్రేటెడ్ సర్క్యూట్‌లు) ఉపయోగించుకున్న మొదటి పెద్ద కంప్యూటర్ లైన్. ఫలితంగా, ఇది గణనీయమైన ధర/పనితీరు ప్రయోజనాన్ని అందించింది. ఇది తక్షణ హిట్ అయ్యింది మరియు ఇతర పెద్ద తయారీదారులందరూ ఇంటర్‌ఆపరబుల్ కంప్యూటర్‌ల కుటుంబం అనే భావనను త్వరగా స్వీకరించారు. OS/360 ఆపరేటింగ్ సిస్టమ్‌తో సహా అన్ని సాఫ్ట్‌వేర్‌లు అసలు డిజైన్‌లోని అన్ని మోడళ్లకు అనుకూలంగా ఉండాలి. ఇది భారీ గణన మరియు వాతావరణ సూచన కోసం తరచుగా 7094లను భర్తీ చేసే భారీ సిస్టమ్‌లపై అమలు చేయవలసి ఉంటుంది మరియు కార్డులను టేప్‌కు బదిలీ చేయడానికి 1401లను తరచుగా భర్తీ చేసే చిన్న వ్యవస్థలు. కొన్ని పెరిఫెరల్స్‌తో కూడిన రెండు సిస్టమ్‌లు మరియు అనేక పెరిఫెరల్స్‌తో కూడిన సిస్టమ్‌లు దానితో బాగా పనిచేయడానికి అవసరం. ఇది వృత్తిపరమైన మరియు అకడమిక్ సెట్టింగులలో పనిచేయాలి. అన్నింటికంటే మించి, ఈ అనేక అప్లికేషన్‌లలో ప్రతిదానికి ఇది ప్రభావవంతంగా ఉండాలి.

- **నాల్గవ తరం (1980-ప్రస్తుతం)**: వ్యక్తిగత కంప్యూటర్ యుగం LSI (లార్జ్ స్కేల్ ఇంటిగ్రేషన్) సర్క్యూట్‌లు, చదరపు సెంటీమీటర్ సిలికాన్‌పై వేల ట్రాన్సిస్టర్‌లతో ప్రాసెసర్‌ల సృష్టితో ప్రారంభమైంది. వాస్తవానికి మైక్రోకంప్యూటర్‌లుగా పిలవబడే వ్యక్తిగత కంప్యూటర్‌లు, PDP-11 తరగతికి చెందిన మినీకంప్యూటర్‌ల నుండి నిర్మాణంలో గణనీయంగా మారనప్పటికీ, అవి ధరలో గణనీయంగా తేడాను కలిగి ఉన్నాయి.

- **ఐదవ తరం (1990-ప్రస్తుతం)**: 1940ల కామిక్ స్ట్రిప్‌లోని డిటెక్టివ్ డిక్ ట్రేసీ తన "రెండు-మార్గం రేడియో చేతి గడియారం"తో సంభాషించడం ప్రారంభించినప్పటి నుండి ప్రజలు పోర్టబుల్ కమ్యూనికేషన్ గాడ్జెట్ కోసం ఆరాటపడ్డారు. 1946 లో, ఒక నిజమైన మొబైల్ ఫోన్ ప్రారంభమైంది మరియు దాని బరువు 40 కిలోగ్రాములు. మొదటి నిజమైన పోర్టబుల్ ఫోన్ 1970 లలో ప్రారంభమైంది మరియు ఒక కిలోగ్రాము వద్ద చాలా తేలికగా ఉంది. ఇది "ఇటుక" అని సరదాగా సూచించబడింది. కాసేపటికే, అందరూ ఒక్కటి కోసం తహతహలాడారు.

### OS యొక్క విధులు
- **సౌలభ్యం**: OS కంప్యూటర్‌ను ఉపయోగించడానికి మరింత సౌకర్యవంతంగా చేస్తుంది.
- ** సమర్థత**: కంప్యూటర్ సిస్టమ్ వనరులను సమర్ధవంతంగా ఉపయోగించుకోవడానికి OS అనుమతిస్తుంది.
- **ఎబిలిటీ టు ఎవాల్వ్**: సర్వీస్‌లో జోక్యం చేసుకోకుండా అదే సమయంలో కొత్త సిస్టమ్ ఫంక్షన్‌లను ప్రభావవంతంగా అభివృద్ధి చేయడం, పరీక్షించడం మరియు పరిచయం చేయడం వంటి వాటిని అనుమతించే విధంగా OS నిర్మించబడాలి.
- **త్రూపుట్**: గరిష్ట నిర్గమాంశ (యూనిట్ సమయానికి టాస్క్‌ల సంఖ్య) ఇవ్వగలిగేలా ఒక OS నిర్మించబడాలి.

### OS యొక్క ప్రధాన కార్యాచరణలు
- **రిసోర్స్ మేనేజ్‌మెంట్**: OSలో సమాంతర యాక్సెస్ జరిగినప్పుడు, బహుళ వినియోగదారులు సిస్టమ్‌ను యాక్సెస్ చేస్తున్నప్పుడు, OS రిసోర్స్ మేనేజర్‌గా పని చేస్తుంది. వినియోగదారుకు హార్డ్‌వేర్ అందించడం దీని బాధ్యత. ఇది సిస్టమ్‌లో లోడ్‌ను తగ్గిస్తుంది.
- **ప్రాసెస్ మేనేజ్‌మెంట్**: ఇది ప్రక్రియ యొక్క షెడ్యూల్ మరియు ముగింపు వంటి వివిధ పనులను కలిగి ఉంటుంది. OS ఒకేసారి వివిధ పనులను నిర్వహిస్తుంది. ఇక్కడ CPU షెడ్యూలింగ్ జరుగుతుంది అంటే షెడ్యూలింగ్ కోసం ఉపయోగించే అనేక అల్గారిథమ్‌ల ద్వారా అన్ని పనులు జరుగుతాయి.
- **స్టోరేజ్ మేనేజ్‌మెంట్**: నిల్వ నిర్వహణ కోసం ఉపయోగించే ఫైల్ సిస్టమ్ మెకానిజం. NIFS, CFS, CIFS, NFS మొదలైనవి కొన్ని ఫైల్ సిస్టమ్‌లు. మొత్తం డేటా హార్డ్ డిస్క్‌ల యొక్క వివిధ ట్రాక్‌లలో నిల్వ చేయబడుతుంది, ఇవన్నీ స్టోరేజ్ మేనేజర్ ద్వారా నిర్వహించబడతాయి. అందులో హార్డ్ డిస్క్ ఉంది.
- **మెమరీ మేనేజ్‌మెంట్**: ప్రాథమిక మెమరీ నిర్వహణను సూచిస్తుంది. ఆపరేటింగ్ సిస్టమ్ ఎంత మెమరీని ఎవరు ఉపయోగించారు అనే విషయాలను ట్రాక్ చేయాలి. ఏ ప్రక్రియకు మెమరీ స్థలం అవసరం మరియు ఎంత అవసరమో నిర్ణయించుకోవాలి. OS కూడా మెమరీ స్థలాన్ని కేటాయించాలి మరియు డీలాకేట్ చేయాలి.
- **భద్రత/గోప్యతా నిర్వహణ**: పాస్‌వర్డ్‌లను ఉపయోగించి ఆపరేటింగ్ సిస్టమ్ ద్వారా గోప్యత కూడా అందించబడుతుంది, తద్వారా అనధికార అప్లికేషన్‌లు ప్రోగ్రామ్‌లు లేదా డేటాను యాక్సెస్ చేయలేవు. ఉదాహరణకు, డేటాకు అనధికార ప్రాప్యతను నిరోధించడానికి Windows **_Kerberos_** ప్రమాణీకరణను ఉపయోగిస్తుంది.

### ఆపరేటింగ్ సిస్టమ్స్ రకాలు
- **మెయిన్‌ఫ్రేమ్ OS**:
అధిక ముగింపులో మెయిన్‌ఫ్రేమ్‌ల కోసం ఆపరేటింగ్ సిస్టమ్‌లు ఉన్నాయి, ఆ గది పరిమాణం
కంప్యూటర్లు ఇప్పటికీ ప్రధాన కార్పొరేట్ డేటా సెంటర్లలో కనుగొనబడ్డాయి. ఈ కంప్యూటర్లు భిన్నంగా ఉంటాయి
వ్యక్తిగత కంప్యూటర్లు వాటి I/O సామర్థ్యం పరంగా. 1000 డిస్క్‌లతో కూడిన మెయిన్‌ఫ్రేమ్
మరియు మిలియన్ల గిగాబైట్ల డేటా అసాధారణమైనది కాదు; వీటితో కూడిన వ్యక్తిగత కంప్యూటర్
స్పెసిఫికేషన్లు దాని స్నేహితుల అసూయగా ఉంటాయి. మెయిన్‌ఫ్రేమ్‌లు కూడా కొన్ని తయారు చేస్తున్నాయి-
హై-ఎండ్ వెబ్ సర్వర్లు, పెద్ద-స్థాయి ఎలక్ట్రానిక్ కోసం సర్వర్‌లుగా తిరిగి వచ్చే విషయం
వాణిజ్య సైట్‌లు మరియు వ్యాపారం నుండి వ్యాపార లావాదేవీల కోసం సర్వర్లు.
మెయిన్‌ఫ్రేమ్‌ల కోసం ఆపరేటింగ్ సిస్టమ్‌లు ప్రాసెసింగ్ వైపు ఎక్కువగా దృష్టి సారిస్తాయి
ఒకేసారి అనేక ఉద్యోగాలు, వీటిలో చాలా వరకు I/O యొక్క అద్భుతమైన మొత్తాలు అవసరం. వారు సాధారణంగా
మూడు రకాల సేవలను అందిస్తాయి: బ్యాచ్, లావాదేవీ ప్రాసెసింగ్ మరియు టైమ్‌షేరింగ్

- **సర్వర్ OS**:
ఒక స్థాయి డౌన్ సర్వర్ ఆపరేటింగ్ సిస్టమ్స్. అవి సర్వర్‌లపై నడుస్తాయి, ఇది
చాలా పెద్ద వ్యక్తిగత కంప్యూటర్‌లు, వర్క్‌స్టేషన్‌లు లేదా మెయిన్‌ఫ్రేమ్‌లు కూడా. వాళ్ళు
నెట్‌వర్క్‌లో ఒకేసారి బహుళ వినియోగదారులకు సేవలందించండి మరియు హార్డ్‌వేర్‌ను భాగస్వామ్యం చేయడానికి వినియోగదారులను అనుమతించండి
మరియు సాఫ్ట్‌వేర్ వనరులు. సర్వర్లు ప్రింట్ సేవ, ఫైల్ సేవ లేదా వెబ్ సేవను అందించగలవు.
ఇంటర్నెట్ ప్రొవైడర్లు తమ కస్టమర్లకు మద్దతు ఇవ్వడానికి అనేక సర్వర్ మెషీన్లను అమలు చేస్తారు
, మరియు వెబ్‌సైట్‌లు వెబ్ పేజీలను నిల్వ చేయడానికి మరియు ఇన్‌కమింగ్ అభ్యర్థనలను నిర్వహించడానికి సర్వర్‌లను ఉపయోగిస్తాయి.
సాధారణ సర్వర్ ఆపరేటింగ్ సిస్టమ్‌లు సోలారిస్, ఫ్రీబిఎస్‌డి, లైనక్స్ మరియు విండోస్ సర్వర్
201x.

- **మల్టీప్రాసెసర్ OS**:
మేజర్-లీగ్ కంప్యూటింగ్ పవర్‌ని పొందడానికి పెరుగుతున్న సాధారణ మార్గం బహుళ CPUలను ఒకే సిస్టమ్‌లోకి కనెక్ట్ చేయడం.
అవి ఎలా కనెక్ట్ చేయబడ్డాయి మరియు భాగస్వామ్యం చేయబడిన వాటిపై ఆధారపడి, ఈ వ్యవస్థలను సమాంతర కంప్యూటర్లు, బహుళ-కంప్యూటర్లు లేదా మల్టీప్రాసెసర్‌లు అంటారు.
వారికి ప్రత్యేక ఆపరేటింగ్ సిస్టమ్‌లు అవసరం, కానీ తరచుగా ఇవి సర్వర్ ఆపరేటింగ్ సిస్టమ్‌లలో వైవిధ్యాలు,
కమ్యూనికేషన్, కనెక్టివిటీ మరియు స్థిరత్వం కోసం ప్రత్యేక లక్షణాలతో.

- **పర్సనల్ కంప్యూటర్ OS**:
తదుపరి వర్గం వ్యక్తిగత కంప్యూటర్ ఆపరేటింగ్ సిస్టమ్. అన్నీ ఆధునికమైనవి
మల్టీప్రోగ్రామింగ్‌కు మద్దతు ఇస్తుంది, తరచుగా డజన్ల కొద్దీ ప్రోగ్రామ్‌లు బూట్ సమయంలో ప్రారంభించబడతాయి.
వారి పని ఒకే వినియోగదారుకు మంచి మద్దతును అందించడం. వారు విస్తృతంగా ఉపయోగిస్తారు
వర్డ్ ప్రాసెసింగ్, స్ప్రెడ్‌షీట్‌లు, గేమ్‌లు మరియు ఇంటర్నెట్ యాక్సెస్. సాధారణ ఉదాహరణలు
Linux, FreeBSD, Windows 7, Windows 8, మరియు Apple యొక్క OS X. వ్యక్తిగత కంప్యూటర్
ఆపరేటింగ్ సిస్టమ్స్ చాలా విస్తృతంగా ప్రసిద్ధి చెందాయి, బహుశా తక్కువ పరిచయం అవసరం.
చాలా మందికి ఇతర రకాలు ఉన్నాయని కూడా తెలియదు.

- **ఎంబెడెడ్ OS**:
ఎంబెడెడ్ సిస్టమ్‌లు సాధారణంగా కంప్యూటర్‌లుగా పరిగణించబడని మరియు వినియోగదారు-ఇన్‌స్టాల్ చేసిన సాఫ్ట్‌వేర్‌ను ఆమోదించని పరికరాలను నియంత్రించే కంప్యూటర్‌లపై అమలవుతాయి.
సాధారణ ఉదాహరణలు మైక్రోవేవ్ ఓవెన్లు, టీవీ సెట్లు, కార్లు, DVD రికార్డర్లు, సంప్రదాయమైనవి
ఫోన్‌లు మరియు MP3 ప్లేయర్‌లు. ఎంబెడెడ్ సిస్టమ్‌లను హ్యాండ్‌హెల్డ్‌ల నుండి వేరుచేసే ప్రధాన ప్రాపర్టీ ఏమిటంటే, ఎటువంటి అవిశ్వసనీయ సాఫ్ట్‌వేర్ వాటిపై ఎప్పటికీ అమలు చేయబడదని నిశ్చయత.
మీరు మీ మైక్రోవేవ్ ఓవెన్-అన్ని సాఫ్ట్‌వేర్‌లకు కొత్త అప్లికేషన్‌లను డౌన్‌లోడ్ చేయలేరు
ROMలో ఉంది. అప్లికేషన్ల మధ్య రక్షణ అవసరం లేదని దీని అర్థం,
సరళీకృత డిజైన్. పొందుపరిచిన Linux, QNX మరియు వంటి సిస్టమ్‌లు
VxWorks ఈ డొమైన్‌లో ప్రసిద్ధి చెందింది.

- **స్మార్ట్ కార్డ్ OS**:
అతి చిన్న ఆపరేటింగ్ సిస్టమ్‌లు క్రెడిట్-కార్డ్-పరిమాణ స్మార్ట్ కార్డ్‌పై నడుస్తాయి
CPU చిప్‌లతో పరికరాలు. వారు చాలా తీవ్రమైన ప్రాసెసింగ్ పవర్ మరియు మెమరీ పరిమితులను కలిగి ఉన్నారు.
కొన్ని రీడర్‌లోని పరిచయాల ద్వారా ఆధారితమైనవి
చొప్పించబడింది, కానీ కాంటాక్ట్‌లెస్ స్మార్ట్ కార్డ్‌లు ప్రేరేపకంగా శక్తిని కలిగి ఉంటాయి, చాలా పరిమితం చేస్తాయి
వారు ఏమి చేయగలరు. కొందరు ఎలక్ట్రానిక్ చెల్లింపుల వంటి ఒకే ఫంక్షన్‌ను మాత్రమే నిర్వహించగలరు, అయితే ఇతరులు బహుళ ఫంక్షన్‌లను నిర్వహించగలరు.
తరచుగా ఇవి యాజమాన్య వ్యవస్థలు.
కొన్ని స్మార్ట్ కార్డ్‌లు జావా ఓరియెంటెడ్‌గా ఉంటాయి. అంటే స్మార్ట్‌లో ఉన్న ROM
కార్డ్ జావా వర్చువల్ మెషిన్ (JVM) కోసం ఇంటర్‌ప్రెటర్‌ను కలిగి ఉంది. జావా ఆప్లెట్స్ (చిన్న
ప్రోగ్రామ్‌లు) కార్డ్‌కి డౌన్‌లోడ్ చేయబడతాయి మరియు JVM ఇంటర్‌ప్రెటర్ ద్వారా వివరించబడతాయి.
ఈ కార్డ్‌లలో కొన్ని ఒకే సమయంలో బహుళ జావా ఆప్లెట్‌లను హ్యాండిల్ చేయగలవు
మల్టీప్రోగ్రామింగ్ మరియు వాటిని షెడ్యూల్ చేయవలసిన అవసరం. రెండు లేదా అంతకంటే ఎక్కువ ఆప్లెట్‌లు ఏకకాలంలో ఉన్నప్పుడు వనరుల నిర్వహణ మరియు రక్షణ కూడా సమస్యగా మారుతుంది.
ఈ సమస్యలు తప్పనిసరిగా కార్డ్‌లో ఉన్న (సాధారణంగా అత్యంత ప్రాచీనమైన) ఆపరేటింగ్ సిస్టమ్ ద్వారా నిర్వహించబడాలి.

## [మెమరీ మరియు స్టోరేజ్](మెమొరీ%20మరియు%20స్టోరేజ్/readme.md)

### జ్ఞాపకశక్తి
_memory_ అనే పదం మీ కంప్యూటర్‌లోని స్వల్పకాలిక డేటా యాక్సెస్‌ను అనుమతించే భాగాన్ని సూచిస్తుంది. మీరు ఈ భాగాన్ని DRAM లేదా డైనమిక్ రాండమ్-యాక్సెస్ మెమరీగా గుర్తించవచ్చు. మీ కంప్యూటర్ దాని స్వల్పకాలిక మెమరీలో నిల్వ చేయబడిన డేటాను యాక్సెస్ చేయడం ద్వారా అనేక కార్యకలాపాలను నిర్వహిస్తుంది. అటువంటి కార్యకలాపాలకు కొన్ని ఉదాహరణలు పత్రాన్ని సవరించడం, అప్లికేషన్‌లను లోడ్ చేయడం మరియు ఇంటర్నెట్‌ను బ్రౌజ్ చేయడం వంటివి. మీ సిస్టమ్ యొక్క వేగం మరియు పనితీరు మీ కంప్యూటర్‌లో ఇన్‌స్టాల్ చేయబడిన మెమరీ పరిమాణంపై ఆధారపడి ఉంటుంది.

మీకు డెస్క్ మరియు ఫైలింగ్ క్యాబినెట్ ఉంటే, డెస్క్ మీ కంప్యూటర్ మెమరీని సూచిస్తుంది. మీరు వెంటనే ఉపయోగించాల్సిన అంశాలు సులభంగా యాక్సెస్ చేయడానికి మీ డెస్క్‌పై ఉంచబడతాయి. అయినప్పటికీ, దాని పరిమాణ పరిమితుల కారణంగా డెస్క్‌పై ఎక్కువ నిల్వ చేయబడదు.

### నిల్వ
మెమరీ అనేది స్వల్పకాలిక డేటా యొక్క స్థానాన్ని సూచిస్తుంది, అయితే _storage_ అనేది మీ కంప్యూటర్‌లోని భాగం, ఇది డేటాను దీర్ఘకాలికంగా నిల్వ చేయడానికి మరియు యాక్సెస్ చేయడానికి మిమ్మల్ని అనుమతిస్తుంది. సాధారణంగా, నిల్వ అనేది సాలిడ్-స్టేట్ డ్రైవ్ లేదా హార్డ్ డ్రైవ్ రూపంలో వస్తుంది. నిల్వ మీ అప్లికేషన్‌లు, ఆపరేటింగ్ సిస్టమ్ మరియు ఫైల్‌లను నిరవధికంగా ఉంచుతుంది. కంప్యూటర్లు స్టోరేజ్ సిస్టమ్ నుండి సమాచారాన్ని చదవాలి మరియు వ్రాయాలి, కాబట్టి మీరు సేవ్ చేసిన వాటిని మీ సిస్టమ్ ఎంత వేగంగా బూట్ చేయవచ్చో, లోడ్ చేయగలదో మరియు యాక్సెస్ చేయగలదో స్టోరేజ్ వేగం నిర్ణయిస్తుంది.

డెస్క్ కంప్యూటర్ మెమరీని సూచిస్తుంది, ఫైలింగ్ క్యాబినెట్ మీ కంప్యూటర్ నిల్వను సూచిస్తుంది. ఇది సేవ్ చేయవలసిన మరియు నిల్వ చేయవలసిన ఐటెమ్‌లను కలిగి ఉంటుంది కానీ తక్షణ ప్రాప్యత కోసం అవసరం లేదు. ఫైలింగ్ క్యాబినెట్ పరిమాణం అంటే అది చాలా విషయాలను కలిగి ఉంటుంది.

**మెమొరీ మరియు స్టోరేజ్ మధ్య ఒక ముఖ్యమైన వ్యత్యాసం** కంప్యూటర్ ఆఫ్ చేయబడినప్పుడు మెమరీ క్లియర్ అవుతుంది. మరోవైపు, మీరు మీ కంప్యూటర్‌ను ఎంత తరచుగా ఆపివేసినప్పటికీ నిల్వ చెక్కుచెదరకుండా ఉంటుంది. అందువల్ల, డెస్క్ మరియు ఫైలింగ్ క్యాబినెట్ సారూప్యతలో, మీరు కార్యాలయం నుండి బయలుదేరినప్పుడు మీ డెస్క్‌పై మిగిలి ఉన్న ఏవైనా ఫైల్‌లు విసిరివేయబడతాయి. మీ ఫైలింగ్ క్యాబినెట్‌లోని ప్రతిదీ అలాగే ఉంటుంది.

### వర్చువల్ మెమరీ
కంప్యూటర్ సిస్టమ్స్ యొక్క గుండె వద్ద మెమరీ ఉంది, ప్రోగ్రామ్‌లు రన్ అయ్యే స్థలం మరియు డేటా నిల్వ చేయబడుతుంది. కానీ మీరు అమలు చేస్తున్న ప్రోగ్రామ్‌లు మరియు మీరు పని చేస్తున్న డేటా మీ కంప్యూటర్ మెమరీ యొక్క భౌతిక సామర్థ్యాన్ని మించిపోయినప్పుడు ఏమి జరుగుతుంది? ఇక్కడే వర్చువల్ మెమరీ మీ కంప్యూటర్ మెమరీకి స్మార్ట్ ఎక్స్‌టెన్షన్‌గా పనిచేస్తుంది మరియు దాని సామర్థ్యాలను మెరుగుపరుస్తుంది.

**వర్చువల్ మెమరీ యొక్క నిర్వచనం మరియు ప్రయోజనం:**

వర్చువల్ మెమరీ అనేది ఫిజికల్ మెమరీ (RAM) పరిమితులను అధిగమించడానికి ఆపరేటింగ్ సిస్టమ్‌లచే ఉపయోగించబడే మెమరీ మేనేజ్‌మెంట్ టెక్నిక్. ఇది కంప్యూటర్‌లో భౌతికంగా ఇన్‌స్టాల్ చేయబడిన దాని కంటే ఎక్కువ మెమరీని కలిగి ఉన్న సాఫ్ట్‌వేర్ అప్లికేషన్‌లకు ఒక భ్రమను సృష్టిస్తుంది. సారాంశంలో, ఇది కంప్యూటర్ యొక్క భౌతిక RAM యొక్క పరిమితులకు మించి మెమరీ స్థలాన్ని ఉపయోగించుకునేలా ప్రోగ్రామ్‌లను అనుమతిస్తుంది.

వర్చువల్ మెమొరీ యొక్క ప్రాథమిక ఉద్దేశ్యం సమర్థవంతమైన మల్టీ టాస్కింగ్ మరియు పెద్ద ప్రోగ్రామ్‌ల అమలును ప్రారంభించడం, ఇవన్నీ సిస్టమ్ యొక్క ప్రతిస్పందనను కొనసాగించడం. ఇది భౌతిక RAM మరియు హార్డ్ డ్రైవ్ లేదా SSD వంటి సెకండరీ స్టోరేజ్ పరికరాల మధ్య అతుకులు లేని పరస్పర చర్యను సృష్టించడం ద్వారా దీనిని సాధిస్తుంది.

**వర్చువల్ మెమరీ భౌతిక మెమరీని ఎలా విస్తరింపజేస్తుంది:**

వర్చువల్ మెమరీని మీ కంప్యూటర్ యొక్క RAM మరియు దాని ద్వితీయ నిల్వ (డిస్క్ డ్రైవ్‌లు) కలిపే వంతెనగా భావించండి. మీరు ప్రోగ్రామ్‌ను అమలు చేసినప్పుడు, దానిలోని భాగాలు వేగవంతమైన భౌతిక మెమరీ (RAM)లోకి లోడ్ చేయబడతాయి. అయితే, ప్రోగ్రామ్‌లోని అన్ని భాగాలు వెంటనే ఉపయోగించబడవు.

వర్చువల్ మెమరీ ఈ పరిస్థితిని యాక్టివ్‌గా ఉపయోగించని ప్రోగ్రామ్‌లోని విభాగాలను RAM నుండి సెకండరీ స్టోరేజ్‌కి తరలించడం ద్వారా ఉపయోగించుకుంటుంది, చురుకుగా ఉపయోగంలో ఉన్న భాగాలకు RAMలో ఎక్కువ స్థలాన్ని సృష్టిస్తుంది. ఈ ప్రక్రియ వినియోగదారుకు మరియు నడుస్తున్న ప్రోగ్రామ్‌లకు పారదర్శకంగా ఉంటుంది. తరలించబడిన భాగాలు మళ్లీ అవసరమైనప్పుడు, అవి తిరిగి RAMలోకి మార్చబడతాయి, అయితే ఇతర తక్కువ క్రియాశీల భాగాలు ద్వితీయ నిల్వకు తరలించబడతాయి.

భౌతిక మెమరీలో మరియు వెలుపల డేటా యొక్క ఈ డైనమిక్ స్వాపింగ్ ఆపరేటింగ్ సిస్టమ్ ద్వారా నిర్వహించబడుతుంది. ఇది ప్రోగ్రామ్‌లు అందుబాటులో ఉన్న RAM కంటే పెద్దగా ఉన్నప్పటికీ అమలు చేయడానికి అనుమతిస్తుంది, ఎందుకంటే ఆపరేటింగ్ సిస్టమ్ సరైన పనితీరు కోసం RAMలో ఏ డేటా ఉండాలో తెలివిగా నిర్ణయిస్తుంది.

సారాంశంలో, వర్చువల్ మెమరీ అనేది ర్యామ్ మరియు సెకండరీ స్టోరేజ్ మధ్య ప్రోగ్రామ్‌లు మరియు డేటా యొక్క భాగాలను తాత్కాలికంగా బదిలీ చేయడం ద్వారా అందుబాటులో ఉన్న భౌతిక మెమరీని విస్తరించే వర్చువలైజేషన్ లేయర్‌గా పనిచేస్తుంది. ఈ ప్రక్రియ కంప్యూటర్ పెద్ద టాస్క్‌లను మరియు అనేక ప్రోగ్రామ్‌లను ఏకకాలంలో నిర్వహించగలదని నిర్ధారిస్తుంది, అదే సమయంలో సమర్ధవంతమైన పనితీరు మరియు ప్రతిస్పందనను కొనసాగిస్తుంది.

## [ఫైల్ సిస్టమ్](File%20System/readme.md)
కంప్యూటింగ్‌లో, ఫైల్ సిస్టమ్ లేదా ఫైల్‌సిస్టమ్ (తరచుగా fs అని సంక్షిప్తీకరించబడుతుంది) అనేది డేటా ఎలా నిల్వ చేయబడి మరియు తిరిగి పొందబడుతుందో నియంత్రించడానికి ఆపరేటింగ్ సిస్టమ్ ఉపయోగించే ఒక పద్ధతి మరియు డేటా నిర్మాణం. ఫైల్ సిస్టమ్ లేకుండా, స్టోరేజ్ మీడియంలో ఉంచిన డేటా ఒక పెద్ద డేటాగా ఉంటుంది, ఒక డేటా ఎక్కడ ఆగిపోయింది మరియు తదుపరిది ఎక్కడ ప్రారంభమైంది లేదా దాన్ని తిరిగి పొందే సమయం వచ్చినప్పుడు ఏదైనా డేటా ఎక్కడ ఉందో చెప్పడానికి మార్గం లేదు. డేటాను ముక్కలుగా విభజించి, ప్రతి భాగానికి పేరు పెట్టడం ద్వారా, డేటా సులభంగా వేరు చేయబడి, గుర్తించబడుతుంది. పేపర్ ఆధారిత డేటా మేనేజ్‌మెంట్ సిస్టమ్‌కు ఎలా పేరు పెట్టారు అనే దాని నుండి దాని పేరును తీసుకొని, ప్రతి డేటా సమూహాన్ని "ఫైల్" అంటారు. డేటా సమూహాలు మరియు వాటి పేర్లను నిర్వహించడానికి ఉపయోగించే నిర్మాణం మరియు లాజిక్ నియమాలను "ఫైల్ సిస్టమ్" అంటారు.

అనేక రకాల ఫైల్ సిస్టమ్‌లు ఉన్నాయి, ప్రతి ఒక్కటి ప్రత్యేకమైన నిర్మాణం మరియు తర్కం, వేగం యొక్క లక్షణాలు, సౌలభ్యం, భద్రత, పరిమాణం మరియు మరిన్ని. కొన్ని ఫైల్ సిస్టమ్‌లు నిర్దిష్ట అప్లికేషన్‌ల కోసం ఉపయోగించేందుకు రూపొందించబడ్డాయి. ఉదాహరణకు, ISO 9660 ఫైల్ సిస్టమ్ ప్రత్యేకంగా ఆప్టికల్ డిస్క్‌ల కోసం రూపొందించబడింది.

వివిధ మాధ్యమాలను ఉపయోగించి అనేక రకాల నిల్వ పరికరాలలో ఫైల్ సిస్టమ్‌లను ఉపయోగించవచ్చు. 2019 నాటికి, హార్డ్ డిస్క్ డ్రైవ్‌లు కీలకమైన స్టోరేజ్ డివైజ్‌లుగా ఉన్నాయి మరియు భవిష్యత్తులో కూడా అలాగే ఉంటాయని అంచనా వేయబడింది. SSDలు, మాగ్నెటిక్ టేపులు మరియు ఆప్టికల్ డిస్క్‌లు ఉపయోగించబడే ఇతర రకాల మీడియా. tmpfs వంటి కొన్ని సందర్భాల్లో, కంప్యూటర్ యొక్క ప్రధాన మెమరీ (రాండమ్-యాక్సెస్ మెమరీ, RAM) స్వల్పకాలిక ఉపయోగం కోసం తాత్కాలిక ఫైల్ సిస్టమ్‌ను సృష్టిస్తుంది.

కొన్ని ఫైల్ సిస్టమ్‌లు స్థానిక డేటా నిల్వ పరికరాలలో ఉపయోగించబడతాయి; ఇతరులు నెట్‌వర్క్ ప్రోటోకాల్ ద్వారా ఫైల్ యాక్సెస్‌ను అందిస్తారు (ఉదాహరణకు, NFS, SMB లేదా 9P క్లయింట్లు). కొన్ని ఫైల్ సిస్టమ్‌లు "వర్చువల్", అంటే సరఫరా చేయబడిన "ఫైల్స్" (వర్చువల్ ఫైల్స్ అని పిలుస్తారు) అభ్యర్థనపై (procfs మరియు sysfs వంటివి) గణించబడతాయి లేదా బ్యాకింగ్ స్టోర్‌గా ఉపయోగించే వేరే ఫైల్ సిస్టమ్‌లోకి మ్యాపింగ్ మాత్రమే. ఫైల్ సిస్టమ్ ఫైల్‌ల కంటెంట్ మరియు ఆ ఫైల్‌ల గురించి మెటాడేటా రెండింటికి యాక్సెస్‌ను నిర్వహిస్తుంది. నిల్వ స్థలాన్ని ఏర్పాటు చేయడానికి ఇది బాధ్యత వహిస్తుంది; భౌతిక నిల్వ మాధ్యమానికి సంబంధించి విశ్వసనీయత, సామర్థ్యం మరియు ట్యూనింగ్ ముఖ్యమైన డిజైన్ పరిగణనలు.

### ఫైల్ సిస్టమ్స్ ఎలా పని చేస్తాయి
ఫైల్ సిస్టమ్ డేటాను నిల్వ చేస్తుంది మరియు నిర్వహిస్తుంది మరియు నిల్వ పరికరంలో ఉన్న మొత్తం డేటా కోసం ఒక రకమైన సూచికగా పరిగణించబడుతుంది. ఈ పరికరాలు హార్డ్ డ్రైవ్‌లు, ఆప్టికల్ డ్రైవ్‌లు మరియు ఫ్లాష్ డ్రైవ్‌లను కలిగి ఉంటాయి.

ఫైల్ సిస్టమ్‌లు ఫైల్‌లకు పేరు పెట్టడం కోసం సంప్రదాయాలను పేర్కొంటాయి, పేరులోని గరిష్ట సంఖ్యలో అక్షరాలు, ఏ అక్షరాలను ఉపయోగించవచ్చు మరియు కొన్ని సిస్టమ్‌లలో, ఫైల్ పేరు ప్రత్యయం ఎంత వరకు ఉంటుంది. అనేక ఫైల్ సిస్టమ్‌లలో, ఫైల్ పేర్లు కేస్-సెన్సిటివ్ కాదు.

ఫైల్‌తో పాటు, ఫైల్ సిస్టమ్‌లు మెటాడేటాలోని డైరెక్టరీలో ఫైల్ పరిమాణం మరియు దాని లక్షణాలు, స్థానం మరియు సోపానక్రమం వంటి సమాచారాన్ని కలిగి ఉంటాయి. మెటాడేటా డ్రైవ్‌లో అందుబాటులో ఉన్న ఉచిత స్టోరేజ్ బ్లాక్‌లను మరియు ఎంత స్థలం అందుబాటులో ఉందో కూడా గుర్తించగలదు.

డైరెక్టరీల నిర్మాణం ద్వారా ఫైల్‌కు మార్గాన్ని పేర్కొనడానికి ఫైల్ సిస్టమ్ ఫార్మాట్‌ను కూడా కలిగి ఉంటుంది. ఒక ఫైల్ డైరెక్టరీలో -- లేదా Windows OSలోని ఫోల్డర్‌లో -- లేదా ట్రీ స్ట్రక్చర్‌లో కావలసిన ప్రదేశంలో సబ్‌డైరెక్టరీలో ఉంచబడుతుంది. PC మరియు మొబైల్ OSలు ఫైల్ సిస్టమ్‌లను కలిగి ఉంటాయి, వీటిలో ఫైల్‌లు క్రమానుగత చెట్టు నిర్మాణంలో ఉంచబడతాయి.

నిల్వ మాధ్యమంలో ఫైల్‌లు మరియు డైరెక్టరీలను సృష్టించే ముందు, విభజనలను ఉంచాలి. విభజన అనేది హార్డ్ డిస్క్ యొక్క ప్రాంతం లేదా OS విడిగా నిర్వహించే ఇతర నిల్వ. ఒక ఫైల్ సిస్టమ్ ప్రాథమిక విభజనలో ఉంటుంది మరియు కొన్ని OSలు ఒక డిస్క్‌లో బహుళ విభజనలను అనుమతిస్తాయి. ఈ పరిస్థితిలో, ఒక ఫైల్ సిస్టమ్ పాడైతే, వేరే విభజనలోని డేటా సురక్షితంగా ఉంటుంది.

### ఫైల్ సిస్టమ్స్ రకాలు
అనేక రకాల ఫైల్ సిస్టమ్‌లు ఉన్నాయి, అన్నీ వేర్వేరు తార్కిక నిర్మాణాలు మరియు వేగం మరియు పరిమాణం వంటి లక్షణాలతో ఉంటాయి. ఫైల్ సిస్టమ్ రకం OS మరియు ఆ OS అవసరాలను బట్టి మారవచ్చు. Microsoft Windows, Mac OS X మరియు Linux మూడు అత్యంత సాధారణ PC ఆపరేటింగ్ సిస్టమ్‌లు. మొబైల్ OSలలో Apple iOS మరియు Google Android ఉన్నాయి.

ప్రధాన ఫైల్ సిస్టమ్‌లు క్రింది వాటిని కలిగి ఉంటాయి:

- ఫైల్ కేటాయింపు పట్టిక (FAT)కి Microsoft Windows OS మద్దతు ఇస్తుంది. FAT సాధారణ మరియు నమ్మదగినదిగా పరిగణించబడుతుంది మరియు లెగసీ ఫైల్ సిస్టమ్‌ల తర్వాత రూపొందించబడింది. FAT 1977లో ఫ్లాపీ డిస్క్‌ల కోసం రూపొందించబడింది కానీ తర్వాత హార్డ్ డిస్క్‌ల కోసం రూపొందించబడింది. చాలా ప్రస్తుత OSలతో సమర్థవంతంగా మరియు అనుకూలంగా ఉన్నప్పటికీ, FAT మరింత ఆధునిక ఫైల్ సిస్టమ్‌ల పనితీరు మరియు స్కేలబిలిటీతో సరిపోలలేదు.

- గ్లోబల్ ఫైల్ సిస్టమ్ (GFS) అనేది Linux OS కోసం ఒక ఫైల్ సిస్టమ్, మరియు ఇది షేర్డ్ డిస్క్ ఫైల్ సిస్టమ్. GFS భాగస్వామ్య బ్లాక్ నిల్వకు ప్రత్యక్ష ప్రాప్యతను అందిస్తుంది మరియు స్థానిక ఫైల్ సిస్టమ్‌గా ఉపయోగించవచ్చు.

- GFS2 అనేది నవీకరించబడిన మెటాడేటా సిస్టమ్ వంటి ఒరిజినల్ GFSలో చేర్చబడని లక్షణాలతో కూడిన నవీకరించబడిన సంస్కరణ. GNU జనరల్ పబ్లిక్ లైసెన్స్ నిబంధనల ప్రకారం, GFS మరియు GFS2 ఫైల్ సిస్టమ్‌లు రెండూ ఉచిత సాఫ్ట్‌వేర్‌గా అందుబాటులో ఉన్నాయి.

- Mac ఆపరేటింగ్ సిస్టమ్‌లతో ఉపయోగం కోసం క్రమానుగత ఫైల్ సిస్టమ్ (HFS) అభివృద్ధి చేయబడింది. HFSని Mac OS స్టాండర్డ్ అని కూడా పిలుస్తారు, Mac OS ఎక్స్‌టెండెడ్ ద్వారా విజయం సాధించింది. వాస్తవానికి 1985లో ఫ్లాపీ మరియు హార్డ్ డిస్క్‌ల కోసం ప్రవేశపెట్టబడింది, HFS అసలు Macintosh ఫైల్ సిస్టమ్‌ను భర్తీ చేసింది. దీనిని CD-ROMలలో కూడా ఉపయోగించవచ్చు.

- NT ఫైల్ సిస్టమ్ -- న్యూ టెక్నాలజీ ఫైల్ సిస్టమ్ (NTFS) అని కూడా పిలుస్తారు -- Windows NT 3.1 OS నుండి Windows ఉత్పత్తుల కోసం డిఫాల్ట్ ఫైల్ సిస్టమ్. మునుపటి FAT ఫైల్ సిస్టమ్ నుండి మెరుగుదలలు మెరుగైన మెటాడేటా మద్దతు, పనితీరు మరియు డిస్క్ స్థలాన్ని ఉపయోగించడం. NTFSకి ఉచిత, ఓపెన్ సోర్స్ NTFS డ్రైవర్ ద్వారా Linux OSలో కూడా మద్దతు ఉంది. Mac OSలు NTFS కోసం చదవడానికి మాత్రమే మద్దతుని కలిగి ఉన్నాయి.

- యూనివర్సల్ డిస్క్ ఫార్మాట్ (UDF) అనేది ఆప్టికల్ మీడియా మరియు DVDల కోసం వెండర్-న్యూట్రల్ ఫైల్ సిస్టమ్. UDF ISO 9660 ఫైల్ సిస్టమ్‌ను భర్తీ చేస్తుంది మరియు DVD ఫోరమ్ ద్వారా ఎంపిక చేయబడిన DVD వీడియో మరియు ఆడియో కోసం అధికారిక ఫైల్ సిస్టమ్.

## [క్లౌడ్ కంప్యూటింగ్](Cloud%20Computing/Readme.md)
క్లౌడ్ కంప్యూటింగ్ అంటే ఇంటర్నెట్ ద్వారా సమాచారం మరియు అప్లికేషన్‌లను యాక్సెస్ చేయగల సామర్థ్యం. క్లౌడ్ కంప్యూటింగ్ ఇంటర్నెట్ కనెక్షన్‌తో ఏ ప్రదేశం నుండి అయినా అప్లికేషన్‌లు మరియు డేటాను యాక్సెస్ చేయడానికి వినియోగదారులను అనుమతిస్తుంది.

క్లౌడ్ కంప్యూటింగ్ అనేది ఒక రకమైన ఇంటర్నెట్ ఆధారిత కంప్యూటింగ్, ఇది కంప్యూటర్‌లు మరియు డిమాండ్‌పై ఇతర పరికరాలకు షేర్డ్ కంప్యూటర్ ప్రాసెసింగ్ వనరులు మరియు డేటాను అందిస్తుంది.

కాన్ఫిగర్ చేయదగిన కంప్యూటింగ్ వనరుల (ఉదా., నెట్‌వర్క్‌లు, సర్వర్లు, నిల్వ, అప్లికేషన్‌లు మరియు సేవలు) భాగస్వామ్య పూల్‌కు సర్వత్రా, అనుకూలమైన, ఆన్-డిమాండ్ నెట్‌వర్క్ యాక్సెస్‌ను ప్రారంభించడం కోసం ఇది ఒక నమూనా, వీటిని వేగంగా అందించవచ్చు మరియు తక్కువ నిర్వహణ ప్రయత్నం లేదా సేవతో విడుదల చేయవచ్చు. ప్రొవైడర్ పరస్పర చర్య.

## క్లౌడ్ కంప్యూటింగ్ యొక్క అగ్ర ప్రయోజనాలు
 
క్లౌడ్ కంప్యూటింగ్ అనేది IT వనరుల గురించి వ్యాపారాలు ఎలా ఆలోచిస్తాయి అనే దాని నుండి పెద్ద మార్పు. సంస్థలు క్లౌడ్ కంప్యూటింగ్ సేవల వైపు మొగ్గు చూపడానికి ఇక్కడ ఏడు సాధారణ కారణాలు ఉన్నాయి:


ఖరీదు
క్లౌడ్ కంప్యూటింగ్ హార్డ్‌వేర్ మరియు సాఫ్ట్‌వేర్‌లను కొనుగోలు చేయడం మరియు ఆన్-సైట్ డేటా సెంటర్‌లను సెటప్ చేయడం మరియు రన్ చేయడం వంటి మూలధన వ్యయాన్ని తొలగిస్తుంది-సర్వర్‌ల రాక్‌లు, పవర్ మరియు శీతలీకరణ కోసం రౌండ్-ది-క్లాక్ విద్యుత్ మరియు ఇన్‌ఫ్రాస్ట్రక్చర్ నిర్వహణ కోసం IT నిపుణులు. ఇది వేగంగా జతచేస్తుంది.


వేగం
చాలా క్లౌడ్ కంప్యూటింగ్ సేవలు స్వీయ-సేవ మరియు డిమాండ్‌పై అందించబడతాయి, కాబట్టి పెద్ద మొత్తంలో కంప్యూటింగ్ వనరులను కూడా నిమిషాల్లో అందించవచ్చు, సాధారణంగా కేవలం కొన్ని మౌస్ క్లిక్‌లతో, వ్యాపారాలకు చాలా సౌలభ్యాన్ని ఇస్తుంది మరియు సామర్థ్య ప్రణాళికపై ఒత్తిడిని తగ్గిస్తుంది.


ప్రపంచ స్థాయి
క్లౌడ్ కంప్యూటింగ్ సేవల ప్రయోజనాలు సాగే సామర్థ్యాన్ని కలిగి ఉంటాయి. క్లౌడ్ స్పీచ్‌లో, అంటే సరైన మొత్తంలో IT వనరులను అందించడం-ఉదాహరణకు, ఎక్కువ లేదా తక్కువ కంప్యూటింగ్ శక్తి, నిల్వ మరియు బ్యాండ్‌విడ్త్-అవసరమైనప్పుడు మరియు సరైన భౌగోళిక స్థానం నుండి.


ఉత్పాదకత
ఆన్-సైట్ డేటా సెంటర్‌లకు సాధారణంగా చాలా "ర్యాకింగ్ మరియు స్టాకింగ్" అవసరం-హార్డ్‌వేర్ సెటప్, సాఫ్ట్‌వేర్ ప్యాచింగ్ మరియు ఇతర సమయం తీసుకునే IT నిర్వహణ పనులు. క్లౌడ్ కంప్యూటింగ్ ఈ అనేక పనుల అవసరాన్ని తొలగిస్తుంది, కాబట్టి IT బృందాలు మరింత ముఖ్యమైన వ్యాపార లక్ష్యాలను సాధించడంలో సమయాన్ని వెచ్చించవచ్చు.


ప్రదర్శన
అతిపెద్ద క్లౌడ్ కంప్యూటింగ్ సేవలు ప్రపంచవ్యాప్త సురక్షిత డేటా సెంటర్‌ల నెట్‌వర్క్‌లో నడుస్తాయి, ఇవి తాజా తరం వేగవంతమైన మరియు సమర్థవంతమైన కంప్యూటింగ్ హార్డ్‌వేర్‌కు క్రమం తప్పకుండా అప్‌గ్రేడ్ చేయబడతాయి. ఇది ఒకే కార్పొరేట్ డేటా సెంటర్‌లో అనేక ప్రయోజనాలను అందిస్తుంది, అప్లికేషన్‌ల కోసం తగ్గిన నెట్‌వర్క్ జాప్యం మరియు గ్రేటర్ ఎకానమీ ఆఫ్ స్కేల్‌తో సహా.


విశ్వసనీయత
క్లౌడ్ కంప్యూటింగ్ డేటా బ్యాకప్, విపత్తు పునరుద్ధరణ మరియు వ్యాపార కొనసాగింపును సులభతరం చేస్తుంది మరియు తక్కువ ఖర్చుతో కూడుకున్నది ఎందుకంటే క్లౌడ్ ప్రొవైడర్ నెట్‌వర్క్‌లోని బహుళ పునరావృత సైట్‌లలో డేటా ప్రతిబింబించబడుతుంది.


భద్రత
చాలా మంది క్లౌడ్ ప్రొవైడర్‌లు మీ డేటా, యాప్‌లు మరియు ఇన్‌ఫ్రాస్ట్రక్చర్‌ను సంభావ్య బెదిరింపుల నుండి రక్షించడంలో సహాయపడటానికి, మీ భద్రతా భంగిమను మొత్తంగా పటిష్టపరిచే విస్తృతమైన విధానాలు, సాంకేతికతలు మరియు నియంత్రణలను అందిస్తారు.

### క్లౌడ్ కంప్యూటింగ్ సేవల రకాలు
- [ఇన్‌ఫ్రాస్ట్రక్చర్ యాజ్ ఎ సర్వీస్ (IaaS)](Cloud%20Computing/Readme.md#infrastructure-as-a-service-iaas)
- [ప్లాట్‌ఫారమ్‌గా సేవ (PaaS)](Cloud%20Computing/Readme.md#platform-as-a-service-paas)
- [సాఫ్ట్‌వేర్ యాజ్ ఎ సర్వీస్ (SaaS)](Cloud%20Computing/Readme.md#software-as-a-service-saas)


## [యంత్ర అభ్యాస]()
మెషిన్ లెర్నింగ్ అంటే కంప్యూటర్ నేర్చుకోవడానికి నేర్పించే అభ్యాసం. ఇన్‌కమింగ్ డేటాపై తీర్పులు ఇవ్వడానికి కాన్సెప్ట్ నమూనా గుర్తింపును, అలాగే ఇతర రకాల ప్రిడిక్టివ్ అల్గారిథమ్‌లను ఉపయోగిస్తుంది. ఈ ఫీల్డ్ కృత్రిమ మేధస్సు మరియు గణన గణాంకాలకు దగ్గరి సంబంధం కలిగి ఉంది.

### మెషిన్ లెర్నింగ్‌లో మూడు ఉపవర్గాలు ఉన్నాయి:

### పర్యవేక్షించబడే యంత్ర అభ్యాసం
దీనిలో, మెషీన్ లెర్నింగ్ మోడల్‌లు లేబుల్ చేయబడిన డేటా సెట్‌లతో శిక్షణ పొందుతాయి, ఇవి మోడల్‌లు కాలక్రమేణా మరింత ఖచ్చితంగా తెలుసుకోవడానికి మరియు పెరగడానికి అనుమతిస్తాయి. ఉదాహరణకు, ఒక అల్గారిథమ్ కుక్కల చిత్రాలు మరియు ఇతర వస్తువులతో శిక్షణ పొందుతుంది, అన్నీ మనుషులచే లేబుల్ చేయబడతాయి మరియు యంత్రం కుక్కల చిత్రాలను స్వయంగా గుర్తించే మార్గాలను నేర్చుకుంటుంది. పర్యవేక్షించబడే యంత్ర అభ్యాసం అనేది నేడు ఉపయోగించే అత్యంత సాధారణ రకం.

పర్యవేక్షించబడిన అభ్యాసం యొక్క ప్రాక్టికల్ అప్లికేషన్లు -
1. **బయోఇన్ఫర్మేటిక్స్:** బయోఇన్ఫర్మేటిక్స్ అనేది వ్యక్తులు వేలిముద్రలు, కంటి ఆకృతి, ఇయర్‌లోబ్‌లు మొదలైన జీవశాస్త్ర పరిజ్ఞానాన్ని ఎలా నిలుపుకుంటారో అధ్యయనం చేస్తుంది. మొబైల్ ఫోన్‌లు ఇప్పుడు మన బయోలాజికల్ డేటాను గ్రహించి, సిస్టమ్ భద్రతను పెంచడానికి మమ్మల్ని ధృవీకరించడానికి తగినంత తెలివైనవి.
2. **స్పీచ్ రికగ్నిషన్:** ఇది ప్రోగ్రామ్ రకం, ఇక్కడ మీరు ప్రోగ్రామ్‌కి మీ వాయిస్‌ని తెలియజేయవచ్చు మరియు ఇది మిమ్మల్ని గుర్తిస్తుంది. అత్యంత ప్రసిద్ధ వాస్తవ-ప్రపంచ గాడ్జెట్‌లు Google అసిస్టెంట్ లేదా సిరి వంటి డిజిటల్ అసిస్టెంట్‌లు, ఇవి మీ వాయిస్‌తో మాత్రమే పదానికి ప్రతిస్పందిస్తాయి.
3. **స్పామ్ గుర్తింపు:** ఈ సాధనం కల్పిత లేదా యంత్ర ఆధారిత కమ్యూనికేషన్‌లను పంపకుండా నిరోధించడానికి ఉపయోగించబడుతుంది. Gmail అనేక తప్పుడు నిబంధనలను నేర్చుకునే అల్గారిథమ్‌ని కలిగి ఉంది. Oneplus Messages యాప్ ఏ నిబంధనలను నిషేధించాలో పేర్కొనమని వినియోగదారుని అడుగుతుంది మరియు యాప్ నుండి అటువంటి టెక్స్ట్‌లను కీవర్డ్ నిరోధిస్తుంది.
4. ** దృష్టి కోసం వస్తువు గుర్తింపు:** మీరు ఏదైనా నిర్వచించవలసి వచ్చినప్పుడు ఈ రకమైన సాఫ్ట్‌వేర్ ఉపయోగించబడుతుంది. మీరు అల్గారిథమ్‌కు శిక్షణ ఇవ్వడానికి ఉపయోగించే పెద్ద డేటాసెట్‌ను కలిగి ఉన్నారు మరియు ఇది దీన్ని ఉపయోగించి కొత్త వస్తువును గుర్తించగలదు.

### పర్యవేక్షించబడని యంత్ర అభ్యాసం
పర్యవేక్షించబడని మెషీన్ లెర్నింగ్‌లో, ప్రోగ్రామ్ లేబుల్ చేయని డేటాలో నమూనాల కోసం చూస్తుంది. పర్యవేక్షించబడని యంత్ర అభ్యాసం వ్యక్తులు స్పష్టంగా వెతకని నమూనాలు లేదా ట్రెండ్‌లను కనుగొనవచ్చు. ఉదాహరణకు, పర్యవేక్షించబడని మెషీన్ లెర్నింగ్ ప్రోగ్రామ్ ఆన్‌లైన్ విక్రయాల డేటాను పరిశీలించి, కొనుగోళ్లు చేసే వివిధ రకాల క్లయింట్‌లను గుర్తించగలదు.

పర్యవేక్షించబడని అభ్యాసం యొక్క ప్రాక్టికల్ అప్లికేషన్లు
1. **క్లస్టరింగ్:** క్లస్టరింగ్ అనేది డేటాను ప్రత్యేక సమూహాలుగా వర్గీకరించే ప్రక్రియ. క్లస్టర్‌ల గురించిన అన్ని వివరాలు మనకు తెలియనప్పుడు, వాటిని క్లస్టర్ చేయడానికి మేము పర్యవేక్షించబడని అభ్యాసాన్ని ఉపయోగించుకోవచ్చు. ముందుగా లేబుల్ చేయబడిన తరగతులు లేదా తరగతి లక్షణాలను కలిగి లేని డేటాను విశ్లేషించడానికి మరియు నిర్వహించడానికి పర్యవేక్షించబడని అభ్యాసం ఉపయోగించబడుతుంది. క్లస్టరింగ్ సంస్థలు తమ డేటాను మరింత సమర్థవంతంగా నిర్వహించడానికి సహాయపడుతుంది.
మీకు యూట్యూబ్ ఛానెల్ ఉందనుకోండి. మీ సబ్‌స్క్రైబర్‌ల గురించి మీకు చాలా సమాచారం ఉండవచ్చు. మీరు ఇలాంటి సబ్‌స్క్రైబర్‌లను కనుగొనాలనుకుంటే, మీరు క్లస్టరింగ్ టెక్నిక్‌ని ఉపయోగించాల్సి ఉంటుంది.
2. **విజువలైజేషన్:** రేఖాచిత్రాలు, ఫోటోలు, గ్రాఫ్‌లు, చార్ట్‌లు మరియు ఇతర సమాచారాన్ని ప్రదర్శించే ప్రక్రియను విజువలైజేషన్ అంటారు. ఈ వ్యూహాన్ని అమలు చేయడానికి పర్యవేక్షించబడని యంత్ర అభ్యాసాన్ని ఉపయోగించవచ్చు.
టోర్నమెంట్‌లో మీ జట్టు ప్రదర్శనకు సంబంధించిన సమాచారంతో మీరు క్రికెట్ కోచ్ అని అనుకుందాం. మీరు మ్యాచ్ గణాంకాలన్నింటినీ త్వరగా గుర్తించాలనుకోవచ్చు. మీరు లేబుల్ చేయని మరియు సంక్లిష్టమైన డేటాను విజువలైజేషన్ అల్గారిథమ్‌కి పంపవచ్చు.
3. **అనామలీ డిటెక్షన్:** అసాధారణమైన విషయాలు, సంఘటనలు లేదా సాధారణ డేటా నుండి పెద్దగా వైదొలగడం ద్వారా అనుమానాలను రేకెత్తించే పరిశీలనలను కనుగొనడాన్ని అనోమలీ డిటెక్షన్ అంటారు. ఈ పరిస్థితిలో, సిస్టమ్ పెద్ద సంఖ్యలో సాధారణ కేసులతో ప్రోగ్రామ్ చేయబడింది. ఫలితంగా, ఇది ఊహించని సంఘటనను గుర్తించినప్పుడు, అది అసాధారణమైనదా కాదా అని నిర్ధారించగలదు.
క్రెడిట్ కార్డ్ మోసాన్ని గుర్తించడం దీనికి మంచి ఉదాహరణ. ఈ సమస్య ఇప్పుడు పర్యవేక్షించబడని మెషిన్ లెర్నింగ్ అనోమలీ డిటెక్షన్ విధానాలను ఉపయోగించి పరిష్కరించబడుతోంది. మోసాన్ని నివారించడానికి, సిస్టమ్ ఊహించని క్రెడిట్ కార్డ్ లావాదేవీలను గుర్తిస్తుంది.

### సెమీ-పర్యవేక్షించిన మెషిన్ లెర్నింగ్
పర్యవేక్షించబడే అభ్యాసం యొక్క ప్రతికూలత ఏమిటంటే, దీనికి ML నిపుణులు లేదా డేటా శాస్త్రవేత్తలచే చేతితో లేబులింగ్ అవసరం మరియు ప్రాసెస్ చేయడానికి అధిక ధర అవసరం. పర్యవేక్షించబడని అభ్యాసం దాని అనువర్తనాల కోసం పరిమిత స్పెక్ట్రమ్‌ను కూడా కలిగి ఉంది. పర్యవేక్షించబడే అభ్యాసం మరియు పర్యవేక్షించబడని అభ్యాస అల్గారిథమ్‌ల యొక్క ఈ లోపాలను అధిగమించడానికి, సెమీ-పర్యవేక్షించిన అభ్యాసం అనే భావన ప్రవేశపెట్టబడింది. సాధారణంగా, ఈ కలయిక చాలా తక్కువ మొత్తంలో లేబుల్ చేయబడిన డేటాను మరియు పెద్ద మొత్తంలో లేబుల్ చేయని డేటాను కలిగి ఉంటుంది. ఇందులో ఉన్న ప్రాథమిక విధానం ఏమిటంటే, ముందుగా, ప్రోగ్రామర్ పర్యవేక్షించబడని లెర్నింగ్ అల్గారిథమ్‌ని ఉపయోగించి సారూప్య డేటాను క్లస్టర్ చేస్తాడు మరియు లేబుల్ చేయని మిగిలిన డేటాను లేబుల్ చేయడానికి ఇప్పటికే లేబుల్ చేయబడిన డేటాను ఉపయోగిస్తాడు.

సెమీ-పర్వైజ్డ్ లెర్నింగ్ యొక్క ప్రాక్టికల్ అప్లికేషన్లు –
1. **స్పీచ్ అనాలిసిస్:** ఆడియో ఫైల్‌లను లేబుల్ చేయడం చాలా ఇంటెన్సివ్ టాస్క్ కాబట్టి, ఈ సమస్యను పరిష్కరించడానికి సెమీ-పర్యవేజ్డ్ లెర్నింగ్ అనేది చాలా సహజమైన విధానం.
2. **ఇంటర్నెట్ కంటెంట్:** వర్గీకరణ: ప్రతి వెబ్‌పేజీని లేబుల్ చేయడం అనేది అసాధ్యమైన మరియు అసాధ్యమైన ప్రక్రియ మరియు అందువలన సెమీ-పర్యవేక్షించబడిన అభ్యాస అల్గారిథమ్‌లను ఉపయోగిస్తుంది. Google శోధన అల్గారిథమ్ కూడా ఇచ్చిన ప్రశ్న కోసం వెబ్‌పేజీ యొక్క ఔచిత్యాన్ని ర్యాంక్ చేయడానికి సెమీ-పర్వైజ్డ్ లెర్నింగ్ యొక్క వేరియంట్‌ను ఉపయోగిస్తుంది.
3. **ప్రోటీన్ సీక్వెన్స్ వర్గీకరణ:** DNA తంతువులు సాధారణంగా చాలా పెద్దవి కాబట్టి, సెమీ-పర్యవేక్షించిన అభ్యాసం ఈ రంగంలో ఆసన్నమైంది.

### ఉపబల యంత్ర అభ్యాసం
ఇది రివార్డ్ సిస్టమ్‌ను ఏర్పాటు చేయడం ద్వారా ఉత్తమ చర్య తీసుకోవడానికి ట్రయల్ మరియు ఎర్రర్ ద్వారా యంత్రాలకు శిక్షణ ఇస్తుంది. రీన్‌ఫోర్స్‌మెంట్ లెర్నింగ్ అనేది మెషీన్ సరైన నిర్ణయాలు తీసుకున్నప్పుడు చెప్పడం ద్వారా గేమ్‌లు ఆడేందుకు లేదా స్వయంప్రతిపత్త వాహనాలను నడపడానికి మోడల్‌లకు శిక్షణ ఇస్తుంది, ఇది ఏ చర్యలు తీసుకోవాలో కాలక్రమేణా తెలుసుకోవడానికి సహాయపడుతుంది.

రీన్‌ఫోర్స్‌మెంట్ లెర్నింగ్ యొక్క ప్రాక్టికల్ అప్లికేషన్‌లు -
1. **ఉత్పత్తి వ్యవస్థలు**
   ఉదా Google Cloud AutoML, Facebook హారిజన్, సిఫార్సు, ప్రకటన, శోధన
2. **అటానమస్ డ్రైవింగ్**
3. **వ్యాపార నిర్వహణ**
   ఉదా వాహన రూటింగ్ సమస్యను పరిష్కరించడం, ఇ-కామర్స్‌లో మోసపూరిత ప్రవర్తన, కస్టమర్ పరస్పర చర్యల నుండి ఏకకాల ఉపబల అభ్యాసం
4. **సిఫార్సు వ్యవస్థలు**
   ఉదా శోధన, సిఫార్సు మరియు ఆన్‌లైన్ ప్రకటనల కోసం
   
### మెషిన్ లెర్నింగ్ అనేక ఇతర ఆర్టిఫిషియల్ ఇంటెలిజెన్స్ సబ్‌ఫీల్డ్‌లతో కూడా అనుబంధించబడింది:

### సహజ భాషా ప్రాసెసింగ్

నేచురల్ లాంగ్వేజ్ ప్రాసెసింగ్ అనేది మెషీన్ లెర్నింగ్ యొక్క ఒక రంగం, దీనిలో కంప్యూటర్‌లను ప్రోగ్రామ్ చేయడానికి సాధారణంగా ఉపయోగించే డేటా మరియు నంబర్‌లకు బదులుగా మానవులు మాట్లాడే మరియు వ్రాసిన సహజ భాషను అర్థం చేసుకోవడానికి యంత్రాలు నేర్చుకుంటాయి. ఇది యంత్రాలు భాషను గుర్తించడానికి, అర్థం చేసుకోవడానికి మరియు దానికి ప్రతిస్పందించడానికి, అలాగే కొత్త వచనాన్ని సృష్టించడానికి మరియు భాషల మధ్య అనువదించడానికి అనుమతిస్తుంది. సహజ భాషా ప్రాసెసింగ్ చాట్‌బాట్‌ల వంటి సుపరిచితమైన సాంకేతికతను మరియు సిరి లేదా అలెక్సా వంటి డిజిటల్ సహాయకులను అనుమతిస్తుంది.

NLP యొక్క ప్రాక్టికల్ అప్లికేషన్లు:
1. **ప్రశ్న సమాధానం:** మానవులు అడిగే ప్రశ్నలకు సహజమైన భాషలో స్వయంచాలకంగా సమాధానమిచ్చే వ్యవస్థలను నిర్మించడంపై ప్రశ్న సమాధానాలు దృష్టి సారిస్తాయి.
2. **స్పామ్ డిటెక్షన్:** యూజర్ ఇన్‌బాక్స్‌కు వచ్చే అవాంఛిత ఇ-మెయిల్‌లను గుర్తించడానికి స్పామ్ డిటెక్షన్ ఉపయోగించబడుతుంది.
3. **సెంటిమెంట్ విశ్లేషణ:** సెంటిమెంట్ విశ్లేషణను ఒపీనియన్ మైనింగ్ అని కూడా అంటారు. పంపినవారి వైఖరి, ప్రవర్తన మరియు భావోద్వేగ స్థితిని విశ్లేషించడానికి ఇది వెబ్‌లో ఉపయోగించబడుతుంది. ఈ అప్లికేషన్ NLP (నేచురల్ లాంగ్వేజ్ ప్రాసెసింగ్) మరియు గణాంకాల కలయిక ద్వారా టెక్స్ట్‌కు (పాజిటివ్, నెగటివ్, లేదా నేచురల్) విలువలను కేటాయించడం ద్వారా మరియు సందర్భం (సంతోషం, విచారం, కోపం మొదలైనవి) యొక్క మానసిక స్థితిని గుర్తించడం ద్వారా అమలు చేయబడుతుంది.
4. **యంత్ర అనువాదం:** ఒక సహజ భాష నుండి మరొక సహజ భాషకు వచనం లేదా ప్రసంగాన్ని అనువదించడానికి యంత్ర అనువాదం ఉపయోగించబడుతుంది. ఉదా Google అనువాదం
5. **స్పెల్లింగ్ దిద్దుబాటు:** మైక్రోసాఫ్ట్ కార్పొరేషన్ స్పెల్లింగ్ దిద్దుబాటు కోసం MS-word మరియు PowerPoint వంటి వర్డ్ ప్రాసెసర్ సాఫ్ట్‌వేర్‌ను అందిస్తుంది.

### నరాల నెట్వర్క్

న్యూరల్ నెట్‌వర్క్‌లు సాధారణంగా ఉపయోగించే, నిర్దిష్ట తరగతి యంత్ర అభ్యాస అల్గారిథమ్‌లు. కృత్రిమ న్యూరల్ నెట్‌వర్క్‌లు మానవ మెదడుపై రూపొందించబడ్డాయి, దీనిలో వేల లేదా మిలియన్ల ప్రాసెసింగ్ నోడ్‌లు పరస్పరం అనుసంధానించబడి లేయర్‌లుగా నిర్వహించబడతాయి.

ఒక కృత్రిమ న్యూరల్ నెట్‌వర్క్‌లో, కణాలు లేదా నోడ్‌లు అనుసంధానించబడి ఉంటాయి, ప్రతి సెల్ ప్రాసెసింగ్ ఇన్‌పుట్‌లతో మరియు ఇతర న్యూరాన్‌లకు పంపబడే అవుట్‌పుట్‌ను ఉత్పత్తి చేస్తుంది. లేబుల్ చేయబడిన డేటా నోడ్‌లు లేదా సెల్‌ల ద్వారా కదులుతుంది, ప్రతి సెల్ వేరే ఫంక్షన్‌ను నిర్వహిస్తుంది. చిత్రంలో పిల్లి ఉందా లేదా అని గుర్తించడానికి శిక్షణ పొందిన న్యూరల్ నెట్‌వర్క్‌లో, వివిధ నోడ్‌లు సమాచారాన్ని అంచనా వేస్తాయి మరియు చిత్రంలో పిల్లి ఉందా లేదా అని సూచించే అవుట్‌పుట్‌కు చేరుకుంటుంది.

న్యూరల్ నెట్‌వర్క్‌ల ప్రాక్టికల్ అప్లికేషన్‌లు:
1. **స్టాక్ మార్కెట్ అంచనా:** నిజ-సమయంలో విజయవంతమైన స్టాక్ ప్రిడిక్షన్ చేయడానికి, మల్టీలేయర్ పెర్‌సెప్ట్రాన్ MLP (క్లాస్ ఆఫ్ ఫీడ్‌ఫార్వర్డ్ ఆర్టిఫిషియల్ ఇంటెలిజెన్స్ అల్గారిథమ్) ఉపయోగించబడుతుంది. MLP నోడ్‌ల యొక్క బహుళ లేయర్‌లను కలిగి ఉంటుంది మరియు ఈ పొరల్లో ప్రతి ఒక్కటి తదుపరి నోడ్‌లకు పూర్తిగా అనుసంధానించబడి ఉంటుంది. MLP మోడల్‌ను రూపొందించడానికి స్టాక్ యొక్క గత ప్రదర్శనలు, వార్షిక రాబడి మరియు లాభాపేక్ష లేని నిష్పత్తులు పరిగణించబడతాయి.
2. **సోషల్ మీడియా:** మల్టీ-లేయర్డ్ పర్సెప్‌ట్రాన్‌లు సోషల్ మీడియా ట్రెండ్‌లను అంచనా వేస్తాయి. ఇది మీన్ అబ్సొల్యూట్ ఎర్రర్ (MAE), రూట్ మీన్ స్క్వేర్డ్ ఎర్రర్ (RMSE) మరియు మీన్ స్క్వేర్డ్ ఎర్రర్ (MSE) వంటి విభిన్న శిక్షణా పద్ధతులను ఉపయోగిస్తుంది. MLP వినియోగదారుకు ఇష్టమైన ఇన్‌స్టాగ్రామ్ పేజీలు, బుక్‌మార్క్ ఎంపికలు మొదలైన అనేక అంశాలను పరిగణనలోకి తీసుకుంటుంది. సోషల్ మీడియా నెట్‌వర్క్‌ల ద్వారా వ్యక్తుల ప్రవర్తనలను విశ్లేషించిన తర్వాత, డేటాను వ్యక్తుల ఖర్చు అలవాట్లకు లింక్ చేయవచ్చు. MLP ANN సోషల్ మీడియా అప్లికేషన్‌ల నుండి డేటాను తీయడానికి ఉపయోగించబడుతుంది.
3. **ఏరోస్పేస్:** ఏరోస్పేస్ ఇంజనీరింగ్ అనేది స్పేస్‌క్రాఫ్ట్ మరియు ఎయిర్‌క్రాఫ్ట్‌ల అభివృద్ధిని కవర్ చేసే విస్తారమైన పదం. తప్పు నిర్ధారణ, అధిక-పనితీరు గల ఆటో-పైలటింగ్, ఎయిర్‌క్రాఫ్ట్ కంట్రోల్ సిస్టమ్‌లను సురక్షితం చేయడం మరియు మోడలింగ్ కీ డైనమిక్ సిమ్యులేషన్‌లు న్యూరల్ నెట్‌వర్క్‌లు స్వాధీనం చేసుకున్న కొన్ని కీలక రంగాలు. సమయం ఆలస్యం నాన్-లీనియర్ టైమ్ డైనమిక్ సిస్టమ్‌లను మోడలింగ్ చేయడానికి న్యూరల్ నెట్‌వర్క్‌లను ఉపయోగించవచ్చు.

### లోతైన అభ్యాసం

డీప్ లెర్నింగ్ నెట్‌వర్క్‌లు అనేక లేయర్‌లతో కూడిన న్యూరల్ నెట్‌వర్క్‌లు. లేయర్డ్ నెట్‌వర్క్ విస్తృతమైన డేటాను ప్రాసెస్ చేయగలదు మరియు నెట్‌వర్క్‌లోని ప్రతి లింక్ యొక్క "బరువు"ని నిర్ణయించగలదు - ఉదాహరణకు, ఇమేజ్ రికగ్నిషన్ సిస్టమ్‌లో, న్యూరల్ నెట్‌వర్క్‌లోని కొన్ని లేయర్‌లు కళ్ళు, ముక్కు వంటి ముఖం యొక్క వ్యక్తిగత లక్షణాలను గుర్తించవచ్చు. లేదా నోరు, మరొక పొర ఆ లక్షణాలు ముఖాన్ని సూచించే విధంగా కనిపిస్తాయో లేదో చెప్పగలదు.

డీప్ లెర్నింగ్ యొక్క ప్రాక్టికల్ అప్లికేషన్స్:
1. **ఆటోమేటిక్ టెక్స్ట్ జనరేషన్ -** టెక్స్ట్ యొక్క కార్పస్ నేర్చుకుంటారు మరియు ఈ మోడల్ నుండి, కొత్త టెక్స్ట్ రూపొందించబడింది, పదం-పదం లేదా అక్షరం-వారీగా. అప్పుడు ఈ మోడల్ స్పెల్లింగ్, విరామచిహ్నాలు మరియు వాక్యాలను ఏర్పరచడం ఎలాగో నేర్చుకోగలదు, లేదా అది శైలిని కూడా సంగ్రహించవచ్చు.
2. **ఆరోగ్య సంరక్షణ –** వివిధ వ్యాధులను గుర్తించడంలో మరియు వాటికి చికిత్స చేయడంలో సహాయపడుతుంది.
3. **ఆటోమేటిక్ మెషిన్ ట్రాన్స్‌లేషన్ –** ఒక భాషలోని కొన్ని పదాలు, వాక్యాలు లేదా పదబంధాలు మరొక భాషలోకి రూపాంతరం చెందుతాయి (డీప్ లెర్నింగ్ అనేది టెక్స్ట్ మరియు ఇమేజ్‌ల రంగాలలో అత్యుత్తమ ఫలితాలను సాధించడం).
4. **ఇమేజ్ రికగ్నిషన్ -** ఇమేజ్‌లలో వ్యక్తులను మరియు వస్తువులను గుర్తిస్తుంది మరియు గుర్తిస్తుంది అలాగే కంటెంట్ మరియు సందర్భాన్ని అర్థం చేసుకుంటుంది. ఈ ప్రాంతం ఇప్పటికే గేమింగ్, రిటైల్, టూరిజం మొదలైన వాటిలో ఉపయోగించబడుతోంది.
5. **భూకంపాలను అంచనా వేయడం –** భూకంపాలను అంచనా వేయడంలో ఉపయోగించే విస్కోలాస్టిక్ గణనలను నిర్వహించడానికి కంప్యూటర్‌కు బోధిస్తుంది.

## [వెబ్ టెక్నాలజీ](Web%20Technology/WebTechnology.md#web-tecnology)
వెబ్ టెక్నాలజీ అనేది ఇంటర్నెట్‌లో వివిధ రకాల పరికరాల మధ్య కమ్యూనికేషన్ ప్రక్రియలో ఉపయోగించే వివిధ సాధనాలు మరియు సాంకేతికతలను సూచిస్తుంది. వెబ్ పేజీలను యాక్సెస్ చేయడానికి వెబ్ బ్రౌజర్ ఉపయోగించబడుతుంది. వెబ్ బ్రౌజర్‌లను ఇంటర్నెట్‌లో టెక్స్ట్, డేటా, చిత్రాలు, యానిమేషన్ మరియు వీడియోను ప్రదర్శించే ప్రోగ్రామ్‌లుగా నిర్వచించవచ్చు. వెబ్ బ్రౌజర్‌లు అందించిన సాఫ్ట్‌వేర్ ఇంటర్‌ఫేస్‌లను ఉపయోగించి వరల్డ్ వైడ్ వెబ్‌లోని హైపర్‌లింక్డ్ వనరులను యాక్సెస్ చేయవచ్చు.
### వెబ్ టెక్నాలజీని క్రింది విభాగాలుగా వర్గీకరించవచ్చు:
- వరల్డ్ వైడ్ వెబ్ (WWW)
వరల్డ్ వైడ్ వెబ్ అనేక విభిన్న సాంకేతికతలపై ఆధారపడి ఉంది: వెబ్ బ్రౌజర్‌లు, హైపర్‌టెక్స్ట్ మార్కప్ లాంగ్వేజ్ (HTML), మరియు హైపర్‌టెక్స్ట్ ట్రాన్స్‌ఫర్ ప్రోటోకాల్ (HTTP).
- వెబ్ బ్రౌజర్
వెబ్ బ్రౌజర్ www (వరల్డ్ వైడ్ వెబ్) అన్వేషించడానికి ఒక అప్లికేషన్ సాఫ్ట్‌వేర్. ఇది సర్వర్ మరియు క్లయింట్ మధ్య ఇంటర్‌ఫేస్‌ను అందిస్తుంది మరియు వెబ్ పత్రాలు మరియు సేవల కోసం సర్వర్‌కు అభ్యర్థనలను అందిస్తుంది.
- వెబ్ సర్వర్
వెబ్ సర్వర్ అనేది వినియోగదారుల యొక్క నెట్‌వర్క్ అభ్యర్థనలను ప్రాసెస్ చేసే మరియు వెబ్ పేజీలను సృష్టించే ఫైల్‌లతో వారికి అందించే ప్రోగ్రామ్. ఈ మార్పిడి హైపర్‌టెక్స్ట్ ట్రాన్స్‌ఫర్ ప్రోటోకాల్ (HTTP)ని ఉపయోగించి జరుగుతుంది.
- వెబ్ పేజీలు
వెబ్‌పేజీ అనేది వరల్డ్ వైడ్ వెబ్‌కి లింక్ చేయబడిన డిజిటల్ డాక్యుమెంట్ మరియు వెబ్ బ్రౌజర్‌ని కలిగి ఉన్న ఇంటర్నెట్‌కి కనెక్ట్ చేయబడిన ఎవరైనా వీక్షించవచ్చు.
- వెబ్ అభివృద్ధి
వెబ్ అభివృద్ధి అనేది వెబ్‌సైట్‌లను నిర్మించడం, సృష్టించడం మరియు నిర్వహించడం సూచిస్తుంది. ఇది వెబ్ డిజైన్, వెబ్ పబ్లిషింగ్, వెబ్ ప్రోగ్రామింగ్ మరియు డేటాబేస్ మేనేజ్‌మెంట్ వంటి అంశాలను కలిగి ఉంటుంది. ఇది ఇంటర్నెట్‌లో పని చేసే అప్లికేషన్ యొక్క సృష్టి, అంటే వెబ్‌సైట్‌లు.
### వెబ్ అభివృద్ధిని రెండు రకాలుగా వర్గీకరించవచ్చు:
### ఫ్రంటెండ్ డెవలప్‌మెంట్
వినియోగదారు నేరుగా పరస్పర చర్య చేసే వెబ్‌సైట్ భాగాన్ని ఫ్రంట్ ఎండ్ అంటారు. ఇది అప్లికేషన్ యొక్క 'క్లయింట్ వైపు' అని కూడా సూచించబడుతుంది.
### బ్యాకెండ్ డెవలప్‌మెంట్
బ్యాకెండ్ అనేది వెబ్‌సైట్ యొక్క సర్వర్ వైపు. ఇది వెబ్‌సైట్‌లో భాగం, వినియోగదారులు చూడలేరు మరియు పరస్పర చర్య చేయలేరు. ఇది వినియోగదారులతో ప్రత్యక్ష సంబంధంలోకి రాని సాఫ్ట్‌వేర్ భాగం. ఇది డేటాను నిల్వ చేయడానికి మరియు అమర్చడానికి ఉపయోగించబడుతుంది.

# [నెట్‌వర్కింగ్](నెట్‌వర్కింగ్/readme.md#networking)
కంప్యూటర్ నెట్‌వర్క్ అనేది నెట్‌వర్క్ నోడ్‌లలో ఉన్న లేదా అందించబడిన వనరులను పంచుకునే కంప్యూటర్‌ల సమితి. కంప్యూటర్లు ఒకదానితో ఒకటి కమ్యూనికేట్ చేయడానికి డిజిటల్ ఇంటర్‌కనెక్షన్‌లపై సాధారణ కమ్యూనికేషన్ ప్రోటోకాల్‌లను ఉపయోగిస్తాయి. ఈ ఇంటర్‌కనెక్షన్‌లు భౌతికంగా వైర్డు, ఆప్టికల్ మరియు వైర్‌లెస్ రేడియో-ఫ్రీక్వెన్సీ పద్ధతులపై ఆధారపడిన టెలికమ్యూనికేషన్ నెట్‌వర్క్ సాంకేతికతలతో రూపొందించబడ్డాయి, వీటిని వివిధ రకాల నెట్‌వర్క్ టోపోలాజీలలో అమర్చవచ్చు.

కంప్యూటర్ నెట్‌వర్క్ యొక్క నోడ్‌లు వ్యక్తిగత కంప్యూటర్‌లు, సర్వర్లు, నెట్‌వర్కింగ్ హార్డ్‌వేర్ లేదా ఇతర ప్రత్యేక లేదా సాధారణ-ప్రయోజన హోస్ట్‌లను కలిగి ఉంటాయి. అవి నెట్‌వర్క్ చిరునామాల ద్వారా గుర్తించబడతాయి మరియు హోస్ట్ పేర్లను కలిగి ఉండవచ్చు. హోస్ట్ పేర్లు నోడ్‌లకు గుర్తుండిపోయే లేబుల్‌లుగా ఉపయోగపడతాయి, ప్రారంభ అసైన్‌మెంట్ తర్వాత చాలా అరుదుగా మార్చబడతాయి. ఇంటర్నెట్ ప్రోటోకాల్ వంటి కమ్యూనికేషన్ ప్రోటోకాల్‌ల ద్వారా నోడ్‌లను గుర్తించడం మరియు గుర్తించడం కోసం నెట్‌వర్క్ చిరునామాలు ఉపయోగపడతాయి.

సిగ్నల్స్, బ్యాండ్‌విడ్త్, నెట్‌వర్క్ ట్రాఫిక్‌ను నిర్వహించడానికి కమ్యూనికేషన్ ప్రోటోకాల్‌లు, నెట్‌వర్క్ పరిమాణం, టోపోలాజీ, ట్రాఫిక్ కంట్రోల్ మెకానిజం మరియు సంస్థాగత ఉద్దేశం వంటి వాటిని తీసుకువెళ్లడానికి ఉపయోగించే ప్రసార మాధ్యమంతో సహా కంప్యూటర్ నెట్‌వర్క్‌లను అనేక ప్రమాణాల ద్వారా వర్గీకరించవచ్చు.

## నెట్‌వర్కింగ్ రకాలు
కంప్యూటర్ నెట్‌వర్కింగ్‌లో రెండు ప్రాథమిక రకాలు ఉన్నాయి:
- వైర్డ్ నెట్‌వర్కింగ్: వైర్డ్ నెట్‌వర్కింగ్‌కు నోడ్‌ల మధ్య రవాణా కోసం భౌతిక మాధ్యమాన్ని ఉపయోగించడం అవసరం. రాగి-ఆధారిత ఈథర్నెట్ కేబులింగ్, తక్కువ ధర మరియు మన్నిక కారణంగా ప్రజాదరణ పొందింది, సాధారణంగా వ్యాపారాలు మరియు గృహాలలో డిజిటల్ కమ్యూనికేషన్‌ల కోసం ఉపయోగించబడుతుంది. ప్రత్యామ్నాయంగా, ఆప్టికల్ ఫైబర్ ఎక్కువ దూరాలకు మరియు వేగవంతమైన వేగంతో డేటాను రవాణా చేయడానికి ఉపయోగించబడుతుంది, అయితే ఇది అధిక ఖర్చులు మరియు మరింత పెళుసుగా ఉండే భాగాలతో సహా అనేక లావాదేవీలను కలిగి ఉంది.
- వైర్‌లెస్ నెట్‌వర్కింగ్: వైర్‌లెస్ నెట్‌వర్కింగ్ రేడియో తరంగాలను గాలిలో డేటాను రవాణా చేయడానికి ఉపయోగిస్తుంది, పరికరాలను ఎలాంటి కేబులింగ్ లేకుండా నెట్‌వర్క్‌కి కనెక్ట్ చేయడానికి వీలు కల్పిస్తుంది. వైర్‌లెస్ LANలు వైర్‌లెస్ నెట్‌వర్కింగ్ యొక్క అత్యంత ప్రసిద్ధ మరియు విస్తృతంగా అమలు చేయబడిన రూపం. ప్రత్యామ్నాయాలలో మైక్రోవేవ్, శాటిలైట్, సెల్యులార్ మరియు బ్లూటూత్ ఉన్నాయి.
## OSI మోడల్
OSI అంటే **ఓపెన్ సిస్టమ్స్ ఇంటర్‌కనెక్షన్**. ఇది ISO – ‘**ఇంటర్నేషనల్ ఆర్గనైజేషన్ ఫర్ స్టాండర్డైజేషన్**’ సంవత్సరంలో 1984లో అభివృద్ధి చేయబడింది. ఇది 7-లేయర్ ఆర్కిటెక్చర్, ప్రతి లేయర్ నిర్దిష్ట కార్యాచరణను కలిగి ఉంటుంది. ప్రపంచవ్యాప్తంగా ఒక వ్యక్తి నుండి మరొకరికి డేటాను ప్రసారం చేయడానికి ఈ ఏడు పొరలన్నీ కలిసి పనిచేస్తాయి.

### **1\. భౌతిక పొర (లేయర్ 1):**

OSI రిఫరెన్స్ మోడల్ యొక్క అత్యల్ప పొర భౌతిక పొర. పరికరాల మధ్య వాస్తవ భౌతిక కనెక్షన్‌కు ఇది బాధ్యత వహిస్తుంది. భౌతిక పొర ** బిట్‌ల రూపంలో సమాచారాన్ని కలిగి ఉంటుంది.** ఇది ఒక నోడ్ నుండి మరొక నోడ్‌కు వ్యక్తిగత బిట్‌లను ప్రసారం చేయడానికి బాధ్యత వహిస్తుంది. డేటాను స్వీకరించేటప్పుడు, ఈ లేయర్ అందుకున్న సిగ్నల్‌ను పొందుతుంది మరియు దానిని 0సె మరియు 1లకి మారుస్తుంది మరియు వాటిని డేటా లింక్ లేయర్‌కి పంపుతుంది, ఇది ఫ్రేమ్‌ను తిరిగి కలిపి ఉంచుతుంది.

![](నెట్‌వర్కింగ్/OSI%20Model/img/computer-network-osi-model-layers-bits.png)

భౌతిక పొర యొక్క విధులు క్రింది విధంగా ఉన్నాయి:

1. **బిట్ సింక్రొనైజేషన్:** ఫిజికల్ లేయర్ గడియారాన్ని అందించడం ద్వారా బిట్‌ల సమకాలీకరణను అందిస్తుంది. ఈ గడియారం పంపినవారు మరియు రిసీవర్ రెండింటినీ నియంత్రిస్తుంది, తద్వారా బిట్ స్థాయిలో సమకాలీకరణను అందిస్తుంది.
2. **బిట్ రేట్ నియంత్రణ:** ఫిజికల్ లేయర్ ట్రాన్స్‌మిషన్ రేట్‌ను కూడా నిర్వచిస్తుంది, అనగా సెకనుకు పంపిన బిట్‌ల సంఖ్య.
3. **ఫిజికల్ టోపోలాజీలు:** ఫిజికల్ లేయర్ నెట్‌వర్క్‌లో వివిధ పరికరాలు/నోడ్‌లు ఎలా అమర్చబడిందో పేర్కొంటుంది, అనగా బస్, స్టార్ లేదా మెష్ టోపోలాజీ.
4. **ట్రాన్స్‌మిషన్ మోడ్:** కనెక్ట్ చేయబడిన రెండు పరికరాల మధ్య డేటా ఎలా ప్రవహిస్తుందో కూడా ఫిజికల్ లేయర్ నిర్వచిస్తుంది. సాధ్యమయ్యే వివిధ ప్రసార మోడ్‌లు సింప్లెక్స్, హాఫ్-డ్యూప్లెక్స్ మరియు ఫుల్-డి

### **2\. డేటా లింక్ లేయర్ (DLL) (లేయర్ 2):**

సందేశం యొక్క నోడ్-టు-నోడ్ డెలివరీకి డేటా లింక్ లేయర్ బాధ్యత వహిస్తుంది. ఫిజికల్ లేయర్‌పై ఒక నోడ్ నుండి మరొక నోడ్‌కి డేటా బదిలీ లోపం లేకుండా ఉండేలా చూసుకోవడం ఈ లేయర్ యొక్క ప్రధాన విధి. నెట్‌వర్క్‌లో ప్యాకెట్ వచ్చినప్పుడు, దాని MAC చిరునామాను ఉపయోగించి దానిని హోస్ట్‌కు ప్రసారం చేయడం DLL యొక్క బాధ్యత.
డేటా లింక్ లేయర్ రెండు సబ్‌లేయర్‌లుగా విభజించబడింది:

1. లాజికల్ లింక్ కంట్రోల్ (LLC)
2. మీడియా యాక్సెస్ కంట్రోల్ (MAC)

NIC(నెట్‌వర్క్ ఇంటర్‌ఫేస్ కార్డ్) యొక్క ఫ్రేమ్ పరిమాణంపై ఆధారపడి నెట్‌వర్క్ లేయర్ నుండి అందుకున్న ప్యాకెట్ మరింత ఫ్రేమ్‌లుగా విభజించబడింది. DLL హెడర్‌లో పంపినవారు మరియు స్వీకర్త యొక్క MAC చిరునామాను కూడా కలుపుతుంది.

"ఆ IP చిరునామా ఎవరి వద్ద ఉంది?" అని అడిగే వైర్‌పై ARP (అడ్రస్ రిజల్యూషన్ ప్రోటోకాల్) అభ్యర్థనను ఉంచడం ద్వారా స్వీకర్త యొక్క MAC చిరునామా పొందబడుతుంది. మరియు గమ్యస్థాన హోస్ట్ దాని MAC చిరునామాతో ప్రత్యుత్తరం ఇస్తుంది.

![](నెట్‌వర్కింగ్/OSI%20Model/img/computer-network-osi-model-layers-framing.png)

డేటా లింక్ లేయర్ యొక్క విధులు:

1. **ఫ్రేమింగ్:** ఫ్రేమింగ్ అనేది డేటా లింక్ లేయర్ యొక్క ఫంక్షన్. ఇది రిసీవర్‌కు అర్థవంతమైన బిట్‌ల సెట్‌ను పంపడానికి పంపినవారికి ఒక మార్గాన్ని అందిస్తుంది. ఫ్రేమ్ యొక్క ప్రారంభం మరియు ముగింపుకు ప్రత్యేక బిట్ నమూనాలను జోడించడం ద్వారా దీనిని సాధించవచ్చు.
2. **ఫిజికల్ అడ్రసింగ్:** ఫ్రేమ్‌లను సృష్టించిన తర్వాత, డేటా లింక్ లేయర్ ప్రతి ఫ్రేమ్ యొక్క హెడర్‌లో పంపినవారు మరియు/లేదా రిసీవర్ యొక్క భౌతిక చిరునామాలను (MAC చిరునామాలు) జోడిస్తుంది.
3. **ఎర్రర్ కంట్రోల్:** డేటా లింక్ లేయర్ ఎర్రర్ కంట్రోల్ మెకానిజంను అందిస్తుంది, దీనిలో దెబ్బతిన్న లేదా కోల్పోయిన ఫ్రేమ్‌లను గుర్తించి తిరిగి ప్రసారం చేస్తుంది.
4. **ఫ్లో కంట్రోల్:** డేటా రేటు రెండు వైపులా స్థిరంగా ఉండాలి లేదా డేటా పాడైపోవచ్చు; అందువల్ల, ప్రవాహ నియంత్రణ రసీదుని స్వీకరించడానికి ముందు పంపగల డేటా మొత్తాన్ని సమన్వయపరుస్తుంది.
5. **యాక్సెస్ నియంత్రణ:** ఒకే కమ్యూనికేషన్ ఛానెల్‌ని బహుళ పరికరాల ద్వారా భాగస్వామ్యం చేసినప్పుడు, డేటా లింక్ లేయర్ యొక్క MAC ఉప-లేయర్ నిర్దిష్ట సమయంలో ఛానెల్‌పై ఏ పరికరం నియంత్రణను కలిగి ఉందో గుర్తించడంలో సహాయపడుతుంది.

### **3\. నెట్‌వర్క్ లేయర్ (లేయర్ 3):**

నెట్‌వర్క్ లేయర్ వివిధ నెట్‌వర్క్‌లలో ఉన్న ఒక హోస్ట్ నుండి మరొకదానికి డేటాను ప్రసారం చేయడానికి పనిచేస్తుంది. ఇది ప్యాకెట్ రూటింగ్‌ను కూడా చూసుకుంటుంది, అనగా, అందుబాటులో ఉన్న మార్గాల సంఖ్య నుండి ప్యాకెట్‌ను ప్రసారం చేయడానికి అతి తక్కువ మార్గం ఎంపిక. పంపినవారు & రిసీవర్ యొక్క IP చిరునామాలు నెట్‌వర్క్ లేయర్ ద్వారా హెడర్‌లో ఉంచబడతాయి.

నెట్‌వర్క్ లేయర్ యొక్క విధులు:

1. **రూటింగ్:** నెట్‌వర్క్ లేయర్ ప్రోటోకాల్‌లు సోర్స్ నుండి గమ్యస్థానానికి ఏ మార్గాన్ని అనుకూలంగా ఉందో నిర్ణయిస్తాయి. నెట్‌వర్క్ లేయర్ యొక్క ఈ ఫంక్షన్‌ను రౌటింగ్ అంటారు.
2. **లాజికల్ అడ్రసింగ్:** ఇంటర్నెట్‌వర్క్‌లోని ప్రతి పరికరాన్ని ప్రత్యేకంగా గుర్తించడానికి, నెట్‌వర్క్ లేయర్ అడ్రసింగ్ స్కీమ్‌ను నిర్వచిస్తుంది. పంపినవారు & రిసీవర్ యొక్క IP చిరునామాలు నెట్‌వర్క్ లేయర్ ద్వారా హెడర్‌లో ఉంచబడతాయి. అటువంటి చిరునామా ప్రతి పరికరాన్ని ప్రత్యేకంగా మరియు విశ్వవ్యాప్తంగా వేరు చేస్తుంది.


# [ఇంటర్నెట్](ఇంటర్నెట్/readme.md#internet)
ఇంటర్నెట్ అనేది ప్రపంచవ్యాప్తంగా బిలియన్ల కొద్దీ వినియోగదారులకు సేవలందించేందుకు ప్రామాణిక ఇంటర్నెట్ ప్రోటోకాల్ సూట్ ([TCP/IP](Networking/readme.md#tcptransmission-control-protocol)ని ఉపయోగించే ఇంటర్‌కనెక్టడ్ కంప్యూటర్ నెట్‌వర్క్‌ల యొక్క గ్లోబల్ సిస్టమ్. ఇది ఎలక్ట్రానిక్, వైర్‌లెస్ మరియు ఆప్టికల్ నెట్‌వర్కింగ్ టెక్నాలజీల విస్తృత శ్రేణితో అనుసంధానించబడిన స్థానిక నుండి ప్రపంచ పరిధికి సంబంధించిన మిలియన్ల కొద్దీ ప్రైవేట్, పబ్లిక్, అకడమిక్, బిజినెస్ మరియు ప్రభుత్వ నెట్‌వర్క్‌లను కలిగి ఉన్న నెట్‌వర్క్‌ల నెట్‌వర్క్. ఇంటర్‌లింక్ చేయబడిన హైపర్‌టెక్స్ట్ డాక్యుమెంట్‌లు మరియు వరల్డ్ వైడ్ వెబ్ ([WWW](Internet/readme.md#world-wide-web-www)) మరియు మద్దతిచ్చే మౌలిక సదుపాయాల వంటి విస్తృతమైన సమాచార వనరులు మరియు సేవలను ఇంటర్నెట్ అందిస్తుంది. ఇమెయిల్.

## [వరల్డ్ వైడ్ వెబ్ (WWW)](Internet/readme.md#world-wide-web-www)
వరల్డ్ వైడ్ వెబ్ (WWW) అనేది ఒక సమాచార స్థలం, దీనిలో పత్రాలు మరియు ఇతర వెబ్ వనరులు యూనిఫాం రిసోర్స్ లొకేటర్స్ (URLలు) ద్వారా గుర్తించబడతాయి, హైపర్‌టెక్స్ట్ లింక్‌ల ద్వారా ఇంటర్‌లింక్ చేయబడతాయి మరియు ఇంటర్నెట్ ద్వారా యాక్సెస్ చేయబడతాయి. ఆంగ్ల శాస్త్రవేత్త టిమ్ బెర్నర్స్-లీ 1989లో వరల్డ్ వైడ్ వెబ్‌ను కనుగొన్నారు. అతను 1990లో స్విట్జర్లాండ్‌లోని CERNలో ఉద్యోగం చేస్తున్నప్పుడు మొదటి వెబ్ బ్రౌజర్‌ను రాశాడు. బ్రౌజర్ 1991లో CERN వెలుపల విడుదల చేయబడింది, మొదట జనవరి 1991 నుండి ఇతర పరిశోధనా సంస్థలకు మరియు ఆగస్టు 1991లో ఇంటర్నెట్‌లో సాధారణ ప్రజలకు అందించబడింది.

## [ఇంటర్నెట్ ప్రోటోకాల్ (IP)](Internet/readme.md#internet-protocol-ip)
ఇంటర్నెట్ ప్రోటోకాల్ (IP) అనేది డేటా ప్యాకెట్‌లను రూటింగ్ చేయడానికి మరియు అడ్రస్ చేయడానికి ప్రోటోకాల్ లేదా నియమాల సమితి, తద్వారా అవి నెట్‌వర్క్‌లలో ప్రయాణించి సరైన గమ్యాన్ని చేరుకోగలవు. ఇంటర్నెట్‌లో ప్రయాణించే డేటా ప్యాకెట్లు అని పిలువబడే చిన్న ముక్కలుగా విభజించబడింది.


## [DBMS]()

డేటాబేస్ అంటే ఏమిటి?
-------------------

డేటాబేస్ అనేది వాస్తవ ప్రపంచంలోని కొన్ని అంశాలను సూచించే సంబంధిత డేటా యొక్క సమాహారం. ఒక డేటాబేస్ సిస్టమ్ ఒక నిర్దిష్ట పని కోసం డేటాతో నిర్మించబడటానికి మరియు జనాభాతో రూపొందించబడింది.

DBMS అంటే ఏమిటి?
-------------

**డేటాబేస్ మేనేజ్‌మెంట్ సిస్టమ్ (DBMS)** అనేది తగిన భద్రతా చర్యలను పరిగణనలోకి తీసుకుంటూ వినియోగదారుల డేటాను నిల్వ చేయడానికి మరియు తిరిగి పొందడానికి సాఫ్ట్‌వేర్. ఇది డేటాబేస్‌ను మార్చే ప్రోగ్రామ్‌ల సమూహాన్ని కలిగి ఉంటుంది. DBMS అప్లికేషన్ నుండి డేటా కోసం అభ్యర్థనను అంగీకరిస్తుంది మరియు నిర్దిష్ట డేటాను అందించమని ఆపరేటింగ్ సిస్టమ్‌కు నిర్దేశిస్తుంది. పెద్ద సిస్టమ్‌లలో, DBMS వినియోగదారులు మరియు ఇతర మూడవ పక్ష సాఫ్ట్‌వేర్ డేటాను నిల్వ చేయడం మరియు తిరిగి పొందడంలో సహాయపడుతుంది.

DBMS వినియోగదారులు వారి అవసరాలకు అనుగుణంగా వారి డేటాబేస్‌లను సృష్టించడానికి అనుమతిస్తుంది. "DBMS" అనే పదం డేటాబేస్ మరియు ఇతర అప్లికేషన్ ప్రోగ్రామ్‌ల వినియోగాన్ని కలిగి ఉంటుంది. ఇది డేటా మరియు సాఫ్ట్‌వేర్ అప్లికేషన్ మధ్య ఇంటర్‌ఫేస్‌ను అందిస్తుంది.

DBMS యొక్క ఉదాహరణ
-------------------

విశ్వవిద్యాలయ డేటాబేస్ యొక్క సాధారణ ఉదాహరణను చూద్దాం. ఈ డేటాబేస్ విశ్వవిద్యాలయ వాతావరణంలో విద్యార్థులు, కోర్సులు మరియు గ్రేడ్‌లకు సంబంధించిన సమాచారాన్ని నిర్వహిస్తుంది. డేటాబేస్ ఐదు ఫైల్‌లుగా నిర్వహించబడింది:

* STUDENT ఫైల్ ప్రతి విద్యార్థి డేటాను నిల్వ చేస్తుంది
* COURSE ఫైల్ స్టోర్‌లు ప్రతి కోర్సులో డేటాను కలిగి ఉంటాయి.
* సెక్షన్ నిర్దిష్ట కోర్సులోని విభాగాల గురించి సమాచారాన్ని నిల్వ చేస్తుంది.
* GRADE ఫైల్ వివిధ విభాగాలలో విద్యార్థులు పొందే గ్రేడ్‌లను నిల్వ చేస్తుంది
* TUTOR ఫైల్‌లో ప్రతి ప్రొఫెసర్ గురించిన సమాచారం ఉంటుంది.

DBMSని నిర్వచించడానికి:

* ప్రతి రికార్డ్‌లో నిల్వ చేయబడే వివిధ రకాల డేటా ఎలిమెంట్‌లను నిర్వచించడం ద్వారా మేము ప్రతి ఫైల్ యొక్క రికార్డ్‌ల నిర్మాణాన్ని పేర్కొనాలి.
* మేము డేటా అంశం విలువలను సూచించడానికి కోడింగ్ స్కీమ్‌ను కూడా ఉపయోగించవచ్చు.
* ప్రాథమికంగా, మీ డేటాబేస్ వివిధ పట్టికలలో నిర్వచించబడిన విదేశీ కీతో ఐదు పట్టికలను కలిగి ఉంటుంది.

DBMS చరిత్ర
-------------

చరిత్ర నుండి ముఖ్యమైన మైలురాళ్లు ఇక్కడ ఉన్నాయి:

* 1960 – చార్లెస్ బాచ్‌మన్ మొదటి DBMS వ్యవస్థను రూపొందించారు
* 1970 – కాడ్ IBM'S ఇన్ఫర్మేషన్ మేనేజ్‌మెంట్ సిస్టమ్ (IMS)ని ప్రవేశపెట్టాడు
* 1976- పీటర్ చెన్ ఎంటిటీ-రిలేషన్‌షిప్ మోడల్‌ను రూపొందించారు మరియు నిర్వచించారు, దీనిని ER మోడల్ అని కూడా పిలుస్తారు.
* 1980 – రిలేషనల్ మోడల్ విస్తృతంగా ఆమోదించబడిన డేటాబేస్ భాగం
* 1985- ఆబ్జెక్ట్-ఓరియెంటెడ్ DBMS అభివృద్ధి చేయబడింది.
* 1990లు- రిలేషనల్ DBMSలో ఆబ్జెక్ట్ ఓరియంటేషన్‌ను చేర్చడం.
* 1991- మైక్రోసాఫ్ట్ MS యాక్సెస్‌ను రవాణా చేస్తుంది, ఇది అన్ని ఇతర వ్యక్తిగత DBMS ఉత్పత్తులను స్థానభ్రంశం చేసే వ్యక్తిగత DBMS.
* 1995: మొదటి ఇంటర్నెట్ డేటాబేస్ అప్లికేషన్స్
* 1997: డేటాబేస్ ప్రాసెసింగ్‌కు XML వర్తింపజేయబడింది. చాలా మంది విక్రేతలు XMLని DBMS ఉత్పత్తుల్లోకి చేర్చడం ప్రారంభించారు.

DBMS యొక్క లక్షణాలు
-------------------------

డేటాబేస్ మేనేజ్‌మెంట్ సిస్టమ్ యొక్క లక్షణాలు మరియు లక్షణాలు ఇక్కడ ఉన్నాయి:

* భద్రతను అందిస్తుంది మరియు రిడెండెన్సీని తొలగిస్తుంది
* డేటాబేస్ సిస్టమ్ స్వభావాన్ని స్వయంగా వివరించడం
* ప్రోగ్రామ్‌లు మరియు డేటా సంగ్రహణ మధ్య ఇన్సులేషన్
* డేటా యొక్క బహుళ వీక్షణల మద్దతు
* డేటా భాగస్వామ్యం మరియు బహుళ-వినియోగదారు లావాదేవీల ప్రాసెసింగ్
* డేటాబేస్ మేనేజ్‌మెంట్ సాఫ్ట్‌వేర్ పట్టికలను రూపొందించడానికి ఎంటిటీలు మరియు వాటి మధ్య సంబంధాలను అనుమతిస్తుంది.
* ఇది ACID కాన్సెప్ట్‌ను అనుసరిస్తుంది (అటామిసిటీ, కన్సిస్టెన్సీ, ఐసోలేషన్ మరియు డ్యూరబిలిటీ).
* DBMS బహుళ-వినియోగదారు వాతావరణానికి మద్దతు ఇస్తుంది, ఇది వినియోగదారులు డేటాను సమాంతరంగా యాక్సెస్ చేయడానికి మరియు మార్చడానికి అనుమతిస్తుంది.

ప్రసిద్ధ DBMS సాఫ్ట్‌వేర్
-------------------

ఇక్కడ కొన్ని ప్రసిద్ధ DBMS సిస్టమ్‌ల జాబితా ఉంది:

* MySQL
* మైక్రోసాఫ్ట్ యాక్సెస్
* ఒరాకిల్
* PostgreSQL
* dBASE
* ఫాక్స్‌ప్రో
* SQLite
* IBM DB2
* లిబ్రే ఆఫీస్ బేస్
* మరియాడిబి
* Microsoft SQL సర్వర్ మొదలైనవి.

## [క్రిప్టోగ్రఫీ](క్రిప్టోగ్రఫీ/readme.md#cryptography)
క్రిప్టోగ్రఫీ అనేది డేటా మరియు కమ్యూనికేషన్‌ను భద్రపరచడానికి ఒక సాంకేతికత. ఇది కోడ్‌లను ఉపయోగించడం ద్వారా సమాచారాన్ని మరియు కమ్యూనికేషన్‌లను రక్షించే పద్ధతి, తద్వారా సమాచారాన్ని ఉద్దేశించిన వారు మాత్రమే చదవగలరు మరియు ప్రాసెస్ చేయగలరు. క్రిప్టోగ్రఫీ రవాణాలో, విశ్రాంతి సమయంలో మరియు ఉపయోగంలో ఉన్న డేటాను రక్షించడానికి ఉపయోగించబడుతుంది. ఉపసర్గ _crypt_ అంటే "దాచిన" లేదా "రహస్యం", మరియు ప్రత్యయం _graphy_ అంటే "వ్రాయడం".

### క్రిప్టోగ్రఫీ రకాలు
గూఢ లిపి శాస్త్రంలో రెండు రకాలు ఉన్నాయి:
1. [సిమెట్రిక్ క్రిప్టోగ్రఫీ](క్రిప్టోగ్రఫీ/readme.md#symmetric-cryptography)
2. [అసిమెట్రిక్ క్రిప్టోగ్రఫీ](క్రిప్టోగ్రఫీ/readme.md#asymmetric-cryptography)

### [క్రిప్టో కరెన్సీ](క్రిప్టోగ్రఫీ/CryptoCurrency/readme.md#crypto-currency)
క్రిప్టోకరెన్సీ అనేది డిజిటల్ కరెన్సీ, దీనిలో కరెన్సీ యూనిట్ల ఉత్పత్తిని నియంత్రించడానికి మరియు నిధుల బదిలీని ధృవీకరించడానికి ఎన్‌క్రిప్షన్ పద్ధతులు ఉపయోగించబడతాయి, ఇది సెంట్రల్ బ్యాంక్ నుండి స్వతంత్రంగా పనిచేస్తుంది. క్రిప్టోకరెన్సీలు కేంద్రీకృత డిజిటల్ కరెన్సీ మరియు సెంట్రల్ బ్యాంకింగ్ వ్యవస్థలకు విరుద్ధంగా వికేంద్రీకృత నియంత్రణను ఉపయోగిస్తాయి. ప్రతి క్రిప్టోకరెన్సీ యొక్క వికేంద్రీకృత నియంత్రణ పంపిణీ చేయబడిన లెడ్జర్ టెక్నాలజీ ద్వారా పనిచేస్తుంది, సాధారణంగా బ్లాక్‌చెయిన్, ఇది పబ్లిక్ ఫైనాన్షియల్ లావాదేవీల డేటాబేస్‌గా పనిచేస్తుంది. క్రిప్టోకరెన్సీ యొక్క నిర్వచించే లక్షణం, మరియు నిస్సందేహంగా దాని అత్యంత మనోహరమైన ఆకర్షణ, దాని సేంద్రీయ స్వభావం; ఇది ఏ కేంద్ర అధికారంచే జారీ చేయబడదు, ఇది ప్రభుత్వ జోక్యం లేదా అవకతవకలకు సిద్ధాంతపరంగా రోగనిరోధక శక్తిని అందిస్తుంది.

## క్రిప్టో కరెన్సీ రకాలు క్రింది విధంగా ఉన్నాయి:
1. [పని యొక్క రుజువు](క్రిప్టోగ్రఫీ/క్రిప్టోకరెన్సీ/ప్రూఫ్ఆఫ్‌వర్క్/రీడ్‌మే.ఎమ్‌డి#పని యొక్క ప్రూఫ్)
2. [ప్రూఫ్ ఆఫ్ స్టేక్](క్రిప్టోగ్రఫీ/క్రిప్టోకరెన్సీ/ప్రూఫ్ఆఫ్‌స్టేక్/రీడ్‌మే.ఎమ్‌డి#ప్రూఫ్-ఆఫ్-స్టేక్)



### _అత్యంత జనాదరణ పొందిన క్రిప్టో కరెన్సీలు క్రింది విధంగా ఉన్నాయి:_
1. [బిట్‌కాయిన్](క్రిప్టోగ్రఫీ/క్రిప్టోకరెన్సీ/ప్రూఫ్ఆఫ్‌వర్క్/బిట్‌కాయిన్/readme.md#bitcoin)
2. [Ethereum](క్రిప్టోగ్రఫీ/CryptoCurrency/ProofOfStake/Ethereum/readme.md#ethereum)
3. [Litecoin](క్రిప్టోగ్రఫీ/క్రిప్టోకరెన్సీ/ProofOfWork/Litecoin/readme.md#litecoin)
4. [కార్డానో](క్రిప్టోగ్రఫీ/క్రిప్టోకరెన్సీ/ప్రూఫ్ఆఫ్‌స్టేక్/కార్డానో/readme.md#cardano)
5. [Dogecoin](క్రిప్టోగ్రఫీ/క్రిప్టోకరెన్సీ/ProofOfWork/Dogecoin/readme.md#dogecoin)

## గణన సిద్ధాంతం
సైద్ధాంతిక కంప్యూటర్ సైన్స్ మరియు గణిత శాస్త్రంలో, గణన సిద్ధాంతం అనేది ఒక అల్గారిథమ్‌ని ఉపయోగించి గణన నమూనాలో ఏ సమస్యలను పరిష్కరించవచ్చు, వాటిని ఎంత సమర్థవంతంగా పరిష్కరించవచ్చు లేదా ఏ స్థాయిలో (ఉదా., ఖచ్చితమైన పరిష్కారాలు మరియు ఖచ్చితమైన పరిష్కారాలు) అనే వాటితో వ్యవహరించే శాఖ. ) ఫీల్డ్ మూడు ప్రధాన శాఖలుగా విభజించబడింది: ఆటోమేటా సిద్ధాంతం మరియు అధికారిక భాషలు, కంప్యూటబిలిటీ సిద్ధాంతం మరియు గణన సంక్లిష్టత సిద్ధాంతం, ఇవి ప్రశ్నతో అనుసంధానించబడ్డాయి: "కంప్యూటర్‌ల ప్రాథమిక సామర్థ్యాలు మరియు పరిమితులు ఏమిటి?".

### ఆటోమేటా సిద్ధాంతం
ఆటోమేటా సిద్ధాంతం అనేది నైరూప్య యంత్రాలు మరియు ఆటోమాటా, అలాగే వాటిని ఉపయోగించి పరిష్కరించగల గణన సమస్యలను అధ్యయనం చేస్తుంది. ఇది సైద్ధాంతిక కంప్యూటర్ సైన్స్‌లో ఒక సిద్ధాంతం. ఆటోమాటా అనే పదం గ్రీకు పదం αὐτόματος నుండి వచ్చింది, దీని అర్థం "స్వీయ-నటన, స్వీయ-సంకల్పం, స్వీయ-కదిలే". ఆటోమేటన్ (బహువచనంలో ఆటోమాటా) అనేది ఒక వియుక్త స్వీయ-చోదక కంప్యూటింగ్ పరికరం, ఇది స్వయంచాలకంగా ముందుగా నిర్ణయించిన కార్యకలాపాల క్రమాన్ని అనుసరిస్తుంది. పరిమిత సంఖ్యలో రాష్ట్రాలతో కూడిన ఆటోమేటన్‌ని ఫినైట్ ఆటోమేటన్ (FA) లేదా ఫినైట్-స్టేట్ మెషిన్ (FSM) అంటారు. కుడివైపున ఉన్న బొమ్మ పరిమిత-స్థితి యంత్రాన్ని వివరిస్తుంది, ఇది ఆటోమేటన్ యొక్క ప్రసిద్ధ రకం. ఈ ఆటోమేటన్ స్టేట్‌లను (ఫిగర్‌లో సర్కిల్‌ల ద్వారా సూచించబడుతుంది) మరియు పరివర్తనాలు (బాణాల ద్వారా సూచించబడుతుంది) కలిగి ఉంటుంది. ఆటోమేటన్ ఇన్‌పుట్ యొక్క చిహ్నాన్ని చూసినప్పుడు, దాని పరివర్తన ఫంక్షన్ ప్రకారం, ఇది మరొక స్థితికి పరివర్తన (లేదా జంప్) చేస్తుంది, ఇది మునుపటి స్థితి మరియు ప్రస్తుత ఇన్‌పుట్ చిహ్నాన్ని దాని వాదనలుగా తీసుకుంటుంది.

### అధికారిక భాషలు
తర్కం, గణితం, కంప్యూటర్ సైన్స్ మరియు భాషాశాస్త్రంలో, ఒక అధికారిక భాషలో అక్షరాలు వర్ణమాల నుండి తీసుకోబడిన పదాలను కలిగి ఉంటాయి మరియు నిర్దిష్ట నియమాల ప్రకారం బాగా రూపొందించబడ్డాయి.

అధికారిక భాష యొక్క వర్ణమాల చిహ్నాలు, అక్షరాలు లేదా టోకెన్‌లను కలిగి ఉంటుంది, ఇవి భాష యొక్క తీగలను కలిగి ఉంటాయి.[1] ఈ వర్ణమాల యొక్క చిహ్నాల నుండి సంగ్రహించబడిన ప్రతి స్ట్రింగ్‌ను ఒక పదం అని పిలుస్తారు మరియు నిర్దిష్ట అధికారిక భాషకు చెందిన పదాలను కొన్నిసార్లు బాగా రూపొందించిన పదాలు లేదా బాగా రూపొందించిన సూత్రాలు అని పిలుస్తారు. ఒక అధికారిక భాష తరచుగా అధికారిక వ్యాకరణాన్ని ఉపయోగించి నిర్వచించబడుతుంది, సాధారణ వ్యాకరణం లేదా సందర్భం-రహిత వ్యాకరణం, దాని నిర్మాణ నియమాలను కలిగి ఉంటుంది.

కంప్యూటర్ సైన్స్‌లో, లాంఛనప్రాయ భాషలను ప్రోగ్రామింగ్ భాషల వ్యాకరణాన్ని మరియు సహజ భాషల ఉపసమితుల యొక్క అధికారిక సంస్కరణలను నిర్వచించడానికి ప్రాతిపదికగా ఉపయోగిస్తారు, దీనిలో భాష యొక్క పదాలు నిర్దిష్ట అర్థాలు లేదా సెమాంటిక్స్‌తో అనుబంధించబడిన భావనలను సూచిస్తాయి. గణన సంక్లిష్టత సిద్ధాంతంలో, నిర్ణయ సమస్యలు సాధారణంగా అధికారిక భాషలుగా నిర్వచించబడతాయి మరియు సంక్లిష్టత తరగతులు పరిమిత గణన శక్తితో యంత్రాల ద్వారా అన్వయించబడే అధికారిక భాషల సెట్లుగా నిర్వచించబడతాయి. తర్కం మరియు గణిత శాస్త్రపు పునాదులలో, అక్షసంబంధ వ్యవస్థల వాక్యనిర్మాణాన్ని సూచించడానికి అధికారిక భాషలు ఉపయోగించబడతాయి మరియు గణిత ఫార్మలిజం అనేది అన్ని గణితాలను ఈ విధంగా అధికారిక భాషల వాక్యనిర్మాణ తారుమారుకి తగ్గించగల తత్వశాస్త్రం.

### కంప్యూటబిలిటీ థియరీ
కంప్యూటబిలిటీ థియరీ, రికర్షన్ థియరీ అని కూడా పిలుస్తారు, ఇది గణిత తర్కం, కంప్యూటర్ సైన్స్ మరియు కంప్యూటేషన్ సిద్ధాంతం యొక్క శాఖ, ఇది 1930లలో కంప్యూటబుల్ ఫంక్షన్‌లు మరియు ట్యూరింగ్ డిగ్రీల అధ్యయనంతో ఉద్భవించింది. సాధారణీకరించిన కంప్యూటబిలిటీ మరియు డెఫినిబిలిటీ అధ్యయనాన్ని చేర్చడానికి ఈ క్షేత్రం విస్తరించింది. ఈ ప్రాంతాల్లో, ప్రూఫ్ థియరీ మరియు ఎఫెక్టివ్ డిస్క్రిప్టివ్ సెట్ థియరీతో కంప్యూటబిలిటీ థియరీ అతివ్యాప్తి చెందుతుంది.

### గణన సంక్లిష్టత సిద్ధాంతం
సైద్ధాంతిక కంప్యూటర్ సైన్స్ మరియు గణితంలో, గణన సంక్లిష్టత సిద్ధాంతం వాటి వనరుల వినియోగం ప్రకారం గణన సమస్యలను వర్గీకరించడం మరియు ఈ తరగతులను ఒకదానికొకటి సంబంధం కలిగి ఉండటంపై దృష్టి పెడుతుంది. గణన సమస్య అనేది కంప్యూటర్ ద్వారా పరిష్కరించబడే పని. అల్గోరిథం వంటి గణిత దశల యాంత్రిక అనువర్తనం ద్వారా గణన సమస్య పరిష్కరించబడుతుంది.

ఏదైనా అల్గోరిథం ఉపయోగించిన దాని పరిష్కారానికి ముఖ్యమైన వనరులు అవసరమైతే సమస్య అంతర్లీనంగా కష్టంగా పరిగణించబడుతుంది. సిద్ధాంతం ఈ సమస్యలను అధ్యయనం చేయడానికి గణన యొక్క గణిత నమూనాలను పరిచయం చేయడం ద్వారా మరియు వాటి గణన సంక్లిష్టతను లెక్కించడం ద్వారా ఈ అంతర్ దృష్టిని అధికారికం చేస్తుంది, అనగా, వాటిని పరిష్కరించడానికి అవసరమైన వనరుల సంఖ్య, సమయం మరియు నిల్వ వంటివి. కమ్యూనికేషన్ మొత్తం (కమ్యూనికేషన్ సంక్లిష్టతలో ఉపయోగించబడుతుంది), సర్క్యూట్‌లోని గేట్ల సంఖ్య (సర్క్యూట్ సంక్లిష్టతలో ఉపయోగించబడుతుంది) మరియు ప్రాసెసర్‌ల సంఖ్య (సమాంతర కంప్యూటింగ్‌లో ఉపయోగించబడుతుంది) వంటి సంక్లిష్టత యొక్క ఇతర కొలతలు కూడా ఉపయోగించబడతాయి. గణన సంక్లిష్టత సిద్ధాంతం యొక్క పాత్రలలో ఒకటి కంప్యూటర్లు ఏమి చేయగలవు మరియు చేయలేవు అనే వాటిపై ఆచరణాత్మక పరిమితులను నిర్ణయించడం. P వర్సెస్ NP సమస్య, ఏడు మిలీనియం ప్రైజ్ ప్రాబ్లమ్స్‌లో ఒకటి, గణన సంక్లిష్టత రంగానికి అంకితం చేయబడింది.[1]

సైద్ధాంతిక కంప్యూటర్ సైన్స్‌లో దగ్గరి సంబంధిత రంగాలు అల్గారిథమ్‌ల విశ్లేషణ మరియు గణన సిద్ధాంతం. అల్గారిథమ్‌ల విశ్లేషణ మరియు గణన సంక్లిష్టత సిద్ధాంతం మధ్య ఉన్న ముఖ్యమైన వ్యత్యాసం ఏమిటంటే, ఒక సమస్యను పరిష్కరించడానికి ఒక నిర్దిష్ట అల్గారిథమ్‌కు అవసరమైన వనరుల సంఖ్యను విశ్లేషించడానికి మొదటిది అంకితం చేయబడింది, అయితే రెండోది ఉపయోగించగల అన్ని అల్గారిథమ్‌ల గురించి మరింత సాధారణ ప్రశ్న అడుగుతుంది. అదే సమస్యను పరిష్కరించడానికి. మరింత ఖచ్చితంగా, గణన సంక్లిష్టత సిద్ధాంతం సముచితంగా పరిమితం చేయబడిన వనరులతో పరిష్కరించగల లేదా పరిష్కరించలేని సమస్యలను వర్గీకరించడానికి ప్రయత్నిస్తుంది. ప్రతిగా, అందుబాటులో ఉన్న వనరులపై పరిమితులను విధించడం అనేది గణన సంక్లిష్టతను కంప్యూటబిలిటీ సిద్ధాంతం నుండి వేరు చేస్తుంది: తరువాతి సిద్ధాంతం ఏ విధమైన సమస్యలను సూత్రప్రాయంగా, అల్గారిథమిక్‌గా పరిష్కరించగలదని అడుగుతుంది.
