<h1 align="center">கணினி அறிவியல்</h1>
<h4 align="center">
    <p>
        <a href="https://github.com/shhossain/computer_science/blob/main/README.md">English</a> |
        <a href="https://github.com/shhossain/computer_science/blob/main/README_it.md">Italiano</a> |
        <a href="https://github.com/shhossain/computer_science/blob/main/README_es.md">Español</a> |
        <a href="https://github.com/shhossain/computer_science/blob/main/README_fr.md">Français</a> |
        <a href="https://github.com/shhossain/computer_science/blob/main/README_bn.md">বাংলা</a> |
        <b>தமிழ்</b> |
        <a href="https://github.com/shhossain/computer_science/blob/main/README_guj.md">ગુજરાતી</a> |
        <a href="https://github.com/shhossain/computer_science/blob/main/README_pt.md">Portuguese</a> |
        <a href="https://github.com/shhossain/computer_science/blob/main/README_ro.md">Română</a>
    </p>
</h4>

## உள்ளடக்க அட்டவணை

- [அறிமுகம்](#அறிமுகம்)
- [மின்னணு கணினி](#மின்னணு-கணினி)
- [பூலியன் மாநிலம்](#பூலியன்-மாநிலம்)
- [எண் அமைப்புகள்](#எண்-அமைப்புகள்)
- [மத்திய செயலக அலுவலகம்(CPU)](#மத்திய-செயலக-அலுவலகம்(CPU))
- [அடைவுகள், காசே, மற்றும் உண்மை அணுவகம்(RAM)](#அடைவுகள்-காசே-மற்றும்-உண்மை-அணுவகம்(RAM))
- [உட்பொருள்கள் மற்றும் திட்டம்](#உட்பொருள்கள்-மற்றும்-திட்டம்)
- [நிரலாக்க மொழிகள்](#நிரலாக்க-மொழிகள்)
- [தரவு வகைகள்](#தரவு-வகைகள்)
- [அறிமுகங்கள் மற்றும் செயல்கள்](#அறிமுகங்கள்-மற்றும்-செயல்கள்)
- [தரவு கட்டமைப்புகள்](#தரவு-கட்டமைப்புகள்)
- [அல்கொரிதம்](#அல்கொரிதம்)
- [அலன் ட்யூரிங்](#அலன்-ட்யூரிங்)
- [மென்பொருள் பொறியியல்](#மென்பொருள்-பொறியியல்)
- [ஒரேதர மொதிகள்](#ஒரேதர-மொதிகள்)
- [பொருள் செயல்முறை நிரூபிகம்](#பொருள்-செயல்முறை-நிரூபிகம்)
- [செயல்பாட்டு நிரலாக்கம்](#செயல்பாட்டு-நிரலாக்கம்)
- [இயக்க முறைமைகள்](#இயக்க-முறைமைகள்)
- [நினைவு மற்றும் சேமிப்பு](#நினைவு-மற்றும்-சேமிப்பு)
- [கோப்பு முறைமை](#கோப்பு-முறைமை)
- [மேகக் கணக்கீடு](#மேகக்-கணக்கீடு)
- [இயந்திர கற்றல்](#இயந்திர-கற்றல்)
- [வலை தொழில்நுட்ப வல்லுநர்](#வலை-தொழில்நுட்ப-வல்லுநர்)
- [நெட்வொர்க்](#நெட்வொர்க்)
- [இணையம்](#இணையம்)
- [டிபிஎம்எஸ்](#டிபிஎம்எஸ்)
- [கிரிப்டோ நாணயம்](#கிரிப்டோ-நாணயம்)
- [கணக்கீட்டு கோட்பாடு](#கணக்கீட்டு-கோட்பாடு)

## அறிமுகம்

கணினி அறிவியல் கணினிகள் மற்றும் கணினி நிலை பயன்பாட்டுகளின் ஆய்வக் கலையும் அதன் தொடக்க மற்றும் வழியியல் பயன்பாட்டுகளும் ஆகிய கிளளவுகளின் ஆய்விக்குப் பயன்படுகின்றது. கணினி அறிவியல் கணிதத்தின், பொறியியலின் மற்றும் அநியாயத்தின் அசைகளை அனைத்து சிக்கல்களுக்கும் பின்பற்றுகின்றது. இவற்றில் அல்கொரிதம் உருவாக்கல், மென்/ஹார்ட்வேர் வளர்ச்சி, மற்றும் செயல்முறை நிரம்பியல் உள்ளன.



## [ மின்னணு கணினி ](Electronic%20Computer/readme.md)
ஒரு சாதனம் அல்லது ஒரு வகையான பிரோக்ராம் செய்யக்கூடிய மின்னணு இயந்திரம், உயர் வேக கணித அல்லது அநியாய செயல்களை செய்யும் அல்லது விபிரேஷிக்குக் கொண்டு, சேமிப்பு செய்யும், இணைத்துப் பரிமாற்றும் அல்லது விவரங்களை மற்றும் திட்டமைகளை போதுமாகச் செய்யும் ஒரு சாதனம்.

## [ பூலியன் மாநிலம் ](Boolean%20Logic/readme.md)
பூலியன் மாநிலம் ஒரு மெய்ய மற்றும் பொய் மதிப்புகள் குறிப்பது கணிதத்தின் ஒரு பிரியாணி ஆகும். இது மட்டும் பொய் மற்றும் உண்மையை போலிக் காட்சிப்படுத்த வேண்டிய இரு மதிப்புகள், 0 மற்றும் 1, அளிக்குகின்றன. இது கூட பூலியன் பெருமான் என்பதும், 1854-ல் அதேச்சொன்ன ஜோர்ஜ் பூல்-ஐ அனுப்பி விளக்கும் ஒரு மானிடக் கணிதத்தின் ஒரு அமைப்பாகும்.

### பொது பூலியன் செய்பாடுகள்
| ஆபரேட்டர் | பெயர் |               விளக்கம்               |
| :------: | :--: | :-------------------------------------: |
|    !     | NOT  |    செயல்பாட்டின் மதிப்பை எதிர்மறையாக காட்டுகிறது.    |
|    &&    | AND  | இரண்டு செயல்பாடுகளும் உண்மையாக இருந்தால் **உண்மை** என்று காட்டும். |
|   \|\|   |  OR  | ஒன்று அல்லது அனைத்து செயல்பாடுகளும் உண்மையாக இருந்தால் **உண்மை** என்று காட்டும். |

### உதவும் பூலியன் செய்பாடுகள்
| ஆபரேட்டர் | பெயர் |               விளக்கம்               |
| :------: | :--: | :-------------------------------------: |
|    ()    | Parentheses     |   முக்கிய வார்த்தைகளை தொகுக்கவும், சொற்கள் தேடப்படும் வரிசையை கட்டுப்படுத்தவும் உங்களை அனுமதிக்கிறது.    |
|    “”    | Quotation marks | சரியான சொற்றொடருடன் முடிவுகளை வழங்குகிறது. |
|   *      |  Asterisk       | முக்கிய சொல் மாறுபாட்டைக் கொண்ட முடிவுகளை வழங்குகிறது. |
|   ⊕     |  XOR            | செயல்பாடுகள் வேறுபட்டால் **உண்மையாக** திரும்பும் |
|   ⊽      |  NOR            | அனைத்து செயல்பாடுகளும் தவறாக இருந்தால் **உண்மை** என்று காட்டும். |
|   ⊼      |  NAND           | அதன் இரண்டு உள்ளீடுகளின் இரண்டு மதிப்புகளும் உண்மையாக இருந்தால் மட்டுமே **false** திரும்பும்.

## [ எண் அமைப்புகள் ](Number%20System/readme.md#number-systems)
எண் அமைப்புகள் எண்களை வெளியிட பயன்படுத்தும் கணித அமைப்புகள் ஆகும். ஒரு எண் அமைப்பு எண்களை குறிப்பிட பயன்படுத்தும் சின்னங்களின் அமைப்பு மற்றும் அவ்வதற்கான விதிகளின் ஒன்றியம் அடங்குகின்றது. ஒரு எண் அமைப்பில் பயன்படுத்துவதற்கு பயன்படுத்தப்படும் சின்னங்கள் "எண்கள்" எனப்படுகின்றன.

### [எண் அமைப்புகளின் வகைகள்](Number%20System/readme.md#types-of-number-systems)
- [இடை இலக்கு எண் அமைப்பு](Number%20System/readme.md#positional-numeral-system)
- [குறிப்பு-மதிப்பு அமைப்பு](Number%20System/readme.md#sign-value-notation-system)

### [பொது இடை எண் அமைப்புகள்](Number%20System/readme.md#common-positional-number-systems)
- [இருபிரியம்](Number%20System/readme.md#binary)
- [நான்குபிரியம்](Number%20System/readme.md#octal)
- [பதினைபிரியம்](Number%20System/readme.md#decimal)
- [ஹெக்சாடெசிமல்](Number%20System/readme.md#hexadecimal)

### பைனரியன் முக்கியத்துவம்
பைனரியன் என்பது ஒரு எண் அமைப்பு ஆகும், அது காட்சிப்படும் எண்கள் அல்லது இலக்குகள் மட்டும் உள்ளன: 0 (பூஜ்யம்) மற்றும் 1 (ஒன்று). இந்த எண் அமைப்பு அனைத்து பைனரி குறியீட்டிற்கு அடுத்து அடுத்த அடைகளை அடக்குகின்றது, இது கணினி செயல்பாட்டு விநாடிகள் ஆகும் அதனால் பயன்படுகின்ற அனைத்து பைனரி குறியீட்டை எழுத பயன்படுத்தும். பைனரி செயலியில் 0 மற்றும் 1 பைனரி இலக்குகளை குறிப்பிடுகின்றன, இரகசியம் இல்லாமல் எலக்ட்ரிசிட்டியில் ஒழியுதல் (OFF) அல்லது இயக்குதல் (ON) ஐ குறிப்பிடுகின்றது. ஒரு ட்ரான்ஸிஸ்டரில், "0" மின்னாடி மின் பரவாக்குக்காது, மற்றும் "1" மின்னாடி மின் பரவாக்குகின்றது. இந்த வழியாக, எண்கள் கணினி சாதனத்தையில் உண்மையில் பிரதிநிலை பெற்று, கணக்குகளை அனுமதிக்கும்.

பைனரி இன்னும் கணினிகளுக்கு முக்கிய மொழி ஆகும், மிகவும் கணினி மூலம் மற்றும் பின்னர் கணினி உபகரணங்களுடன் பயன்படுகின்ற கணினி வளர்ச்சிக்கு கண்டுபிடிக்கப்படும் காரணங்கள்:

- அது ஒரு எளிது மற்றும் அழகான வடிவம் ஆகும்.
- பைனரி இலக்கு 0 மற்றும் 1 முறை மின்னாடி சிக்னல் முடக்கம் (பொருளை) விரைவாகக் கண்டன.
- ஒரு மின்னாடி சிக்னலில் இரு நிலைகள் அதிக வாரியம் உள்ளன, அதனால் மின்னாடி அனுபவப்படுவது குறிப்புக்களின் செயல்முறைகளுக்கு குறைந்த     வகைகளை அடுத்து அடுத்து அடைகளுக்காக உத்தமமாக்குகின்றது.
- அதிகமான காம்பிக் பரம்பலங்களின் அனைத்து மாறியங்களை பைனரிக்கு அனுமதிக்கும்.
- பைனரி வினாக்குகளை நியாயாதிபதி சூத்திரங்களை கட்டமைப்பதற்கு அதிகமான வழிகளில் உள்ளது.



## [மத்திய செயலக அலுவலகம்](CPU/readme.md#central-processing-unitcpu)
மத்திய செயலக அலுவலகம் (Central Processing Unit - CPU) அநேகம் எழுத்துப்பதிவின் முக்கிய பகுதி ஆகும். CPU மற்ற கணினி பகுதிகளை கட்டுப்படுத்த உள்ளது, போல் உணவுக்கு ஒரு உடல் அதிகரிக்கும் புதியவர்கள் பணிகளை நியமிக்குகின்றன. CPU ஒரு கணினி வினாக்குகள் என்று அழைக்கப்படுகின்ற கணினியில் உழைக்கும் ஒரு பட்டியல், அது "கட்டுப்படுத்துகின்ற நிரல்கள்" எனப்படுகின்றது. அந்த நிரல்களின் பட்டியலை அவன் படிக்கும், மற்றும் ஒரு படிச்செய்யும் (நிறையெழுதும்) முதல் ஒரு படியாக உழைக்கும். CPU ஒரு கணினி நிரல்களை ஒரு முறையில் செயல்படுத்தல் முடியும். CPU ஒரு கணினி நிரல்கள் செயலாக்க முடியும் என்ற ஒரு படிச்செய்தி கணினி தொழில்நுட்பம் ஆகும். CPU ஒரு கணினி நிரல்களை ஒரு கோடை அல்லது அதிக இடங்களில் ஒருவர் "கோர்கள்" எனப்படுத்தலாம். நான்கு கோர்களைக் கொண்ட CPU நான்கு நிரல்களை ஒருபோது செயலாக்கலாம். CPU தன்னை உடம்பில் அமைக்கப்பட்டுள்ளது. அதில் இருக்கும் முக்கிய அமைப்புகள் அவை:
1. [நினைவு அல்லது சேமிப்பு அலுவலகம்](CPU/readme.md#memory-or-storage-unit)
2. [கட்டுப்படுத்தும் அலுவலகம்](CPU/readme.md#control-unit)
3. [கணக்கு மற்றும் நியாய அலுவலகம் (ALU)](CPU/readme.md#arithmetic-and-logic-unit-alu)


## [அடைவுகள், காசே, மற்றும் உண்மை அணுவகம்(RAM)](/Registers%20Cache%20and%20RAM)

### [அடைவுகள்](/Registers%20Cache%20and%20RAM/readme.md#register)
பதிவுகள் பதிவக்கம் கணினி உள்ளிடப்பட்ட அதிசேர்ந்த அளவுக்கு உள்ள உச்ச வேக நினைவுகள் ஆகும். பதிவுகள் "ஃப்ளிப்-ஃளாப்ஸ்" (1 பிட் நினைவுகளை சேமிக்க பயன்படுத்தும் ஒரு மேல் சோதிகம்) கூட்டம் ஆகும். இவை செயலாக்கல் போது தேவைப்படும் அல்லது குறிப்பிடப்படும் சிறிய தரவை சேமிக்க பயன்படுத்தப்படுகின்றன. ஒரு CPU முக்கிய பதிவுகள் அநேகம் உள்ளன அவை "கோர்கள்" எனப்படும். பதிவுகள் கணக்குகளில் அறிவிக்கும் முறை மற்றும் தொகுக்கும் உதவுகின்றன.

கணினி உள்ளிடம் பெரிய அளவிலும் விவரம் சேமிப்பதற்கு "கேச்" (வாசகம் என்று படிக்கப்படுகின்றது) உச்ச வேக நினைவுகளுடன் ஒருவர் அனைத்து பதிவுகளையும் அளிக்கின்றன. கேச் அநேக முக்கிய தரவு அணுவை அணுகின்றது. கிடைக்கும் அதிக முக்கிய தரவு "ரேம்" இல் சேமிக்கப்படும். ரேம் என்றால் சீரற்ற அணுவை செயலாக்குகின்ற ஒரு மனச்சிறு நினைவு ஆகும், அது உள்ளிடம் மற்றும் உட்டமைகளை கோப்பு சேமித்து விட்டுக்கொள்ளும் வரை அதிசேரும். பதிக்குகள் அதிசேரிக்கும் தரவை பதிவுகின்றன அதனால் கணினி நிரல்களின் விளைவிக்கு அதிசேர்ந்த மெதுவாக அணுக்கம் செய்யலாம். அக்கொரையில் அனைத்து தரவு கேச் இலக்கம் அடைந்துள்ளது. கேச் செயல்பாட்டின் போது அணுவை அணுகும் நிலைக்குக் கூட்டப்படுகின்றது. அதிசேர்ந்த அளவுக்கு அதிசேரமாக அதிசேரும் அளவு தரவு ரேமில் சேமிக்கப்படும். ரேம் என்பது விரட்டமாக விளைவிக்குகின்ற வகையில் நினைவு ஆகும், அது கணினி அதை விரும்பும் வரை விண்ணப்ப சேமித்து விட்டுக்கொள்ளும்.


### [காசே](/Registers%20Cache%20and%20RAM/readme.md#cache)
கேச் நினைவகம் ஒரு சிப் அடிக்கடி கணினி உள்ளடக்கம் ஆகும். இது கணினி நினைவுக்கு தரவு எளிதில் பெற முடியும் என்பதால் அது தானமைக்கல் இடம் ஆகும். இது கணினி உள்ளமைப்புக்கு உள்ளடக்கம் கொண்டு இருக்கும் அணுகுகின்றது, மெயின் மெம்மொரி வழியில் கணினி மேலதிக இருக்கும், பொருளாக DRAM படிவம் போன்றது.

கேச் நினைவகம் போன்றதை சிபியு (மற்றும் மைய செயல்பாட அமைப்பு) நினைவகம் என்று சொல்லப்படுகின்றது ஏற்கனவே, அது மூலம் சிபி சிபியில் உள்ளிடப்பட்டு அல்லது சிபி இடத்தில் தனி சிப் உட்கணித கொள்ளும் தனி சிப்புக்கு கூட்டிக் கொண்டிருக்கும். அதாவது, அது சிபிக்கு அணுகல் அதிகமான முக்கியத்தை வழங்குகின்றது மற்றும் சிபிக்கு அதிக செயல்பாடுச் செய்ய முடியும் அவசியம் அதான் சிபி பரிமைத்தில் உள்ளது.

சிபி அதிக அணுகல் அதிக அளவில் உள்ளது மாற்ற வேண்டும், அதனால் கேச் நினைவகம் முக்கிய நினைவகம் குறைவாக இருக்க வேண்டும். அதாவது, அதிக செயல்பாடு உள்ள அதிக கணினியாக்கப்பட்ட அது முக்கிய நினைவகத்திற்கு விலைவாய்படும் மேலும் முக்கிய நினைவகம் விலையில் அதிகமாக உள்ளது, அது அதிக செயல்பாடுகளை உருவாக்கும் அதிக கணினி ஆனது என்பதைக் குறிக்கின்றது.

அது அளவில்லாதது மற்றும் விலையில்லாததை விரிவாக அதிகமாக பெறுகின்றது. கேச் நினைவகம் முக்கிய நினைவகத்திற்கு 10 முதல் 100 மட்டுமே விலையில்லாது இருக்கும், சிபி கோரிக்கைக்கு பதில் பதில் பதில் செய்ய அருகிலுள்ள ஒளிவகைக் கணினி காலப் பணிகள் மட்டும் தேவை உள்ளன.

கேச் நினைவகத்திற்கு பயன்படுத்தப்படும் உண்மை ஹார்ட்வேர் பெயர் அதிசய வெக்கம் முக்கிய அணுகல் அணுகல் (SRAM) ஆகும். கணினி முக்கிய நினைவகத்திற்கு பயன்படுத்தப்படும் ஹார்ட்வேர் பெயர் டைனமிக் ராண்டம் அணுகல் அணுகல் அணுகல் (DRAM) ஆகும்.

கேச் நினைவகம் பாரம்பரிய வார்த்தை "கேச்" என்பது உடன் கலப்பும் அல்லது கருவியில் மற்றும் மென்பொருளில் இருக்கலாம் என்று கொள்ளக்கூடாது. கேச்சுகள் அஸ்஥ாயி தரவு சேமிப்பிக்கல் பெயர் ஆகும், அவை கருவியிலும் மென்பொருளிலும் உள்ளது. கேச் நினைவகம் கணினிகள் விதிகளின் வடிவங்களில் வகைவகையான கேச்சுகளை உருவாக்க அனுமதிக்கின்ற கணினியின் கருவி பெயர் ஆகும். ஒரு கேச் ஒளியை கம்ப்யூட்டிங் சூழ்நிலையில் அதிக செயல்பாடுகளை அனுமதிக்கும் ஒரு ஹார்ட்வேர் அல்லது சாப்ட்வேர் ஆகும், பொருளாக அடிப்படையில் அல்லது மென்பொருளில் சூழ்நிலையில் ஒன்றை சேமிக்க பயன்படுகின்றது.

### [உண்மை அணுவகம்(RAM)](/Registers%20Cache%20and%20RAM/readme.md#ram)
RAM (Random Access Memory) கணினி நினைவகம் ஒரு கணினி நினைவக வகையாகும் அதன் வரிசையில் வாசிக்க மற்றும் முடிக்க முடியும், பொதுவாக வேலை செய்ய பயன்படும் ஆகாது, செயலாக்க உத்தக மற்றும் கணினி குறியீட்டை சேமிக்க பயன்படும். ஒரு ராண்டம் அணுகுகல் நிலையான அணுகுகல் சாதனம், உள்ளடக்கத்தின் உள்ளமைப்புகளின் உள்ளத்தில் தரவு உத்தகமாக வாசிக்க அல்லது எழுதப்பட அனுமதிக்கும், வருகின்ற பிற நேர அணுகுகல் தரவு சேமிப்பு மீடியா (உடல் வருவாய், சி-ஆர்-டவுகள், டிவிடி-ஆர்-டவுகள் மற்றும் பழைய காங்கள் நினைவகம்) போன்ற பிற நேர அணுகுகல் சேமிப்பு மீடியாக்களுக்கு எதிராக போன்ற போதை படிகளை வாசித்து எழுதுகின்றன. இதன் போதை முக்கியமான பக்கவாசிக்கு அதிக போடும், அது ஒழிய செய்யும் நேரம் உண்டு என்பது இடம்பிடிப்பதுபோல் இதர நேர அணுகுகல் தரவு சேமிப்பு மீடியா (உடல் வருவாய், சி-ஆர்-டவுகள், டிவிடி-ஆர்-டவுகள் மற்றும் பழைய காங்கள் நினைவகம்) போன்ற நேர அணுகுகல் சேமிப்பு மீடியாக்களில் அவசியமாக மாறும் மற்றும் எழுதுதல் போன்ற மெக்கானிக்கல் விளக்கம் வேகம் மற்றும் முக்கிய மூலங்களை உள்ளடக்கின்றன, இதுவரை தரவுகளின் உள்ளமைப்பில் உள்ளன்போல உள்ளது.

## [உட்பொருள்கள் மற்றும் திட்டம்](Not-Added)
கணினியியல் விதிமுகம் வழங்கும் ஒரு பிராக்சசர் வகையாக உள்ளது ஒரு வழிமுறை. கணினி முடியும் என்பதை சொல்லும் வழிமுறையின் கொள்கைகள் அடையாளப்படும். ஒரு கணினி செய்ய வேண்டியவையெல்லாம் ஒரு கணினி பதிவு செய்யும் பிராக்சசரின் வழிமுறையை பயன்படுத்தி செய்யுகின்றன். கணினி செய்த எல்லாவற்றையும் ஒரு கணினி பதிவு செய்யும் பிராக்சசரின் வழிமுறையை பயன்படுத்தி செய்கின்றன். கணினியின் நினைவகத்தில் சேமிக்கப்பட்டுள்ள நிர்வாகனத்தில் சேமிப்படும் கணினி நினைவகங்கள் ("உள் பிரோகிராமிங்") கணினி ஒரு சிந்தனை பின்னில் ஒருவரைத் தரும், இடைவிடாத விருப்பங்களுடன்.

## [நிரலாக்க மொழிகள்](/Programming_Languages/readme.md)
பிரோகிராமிங் மொழி எந்த வகையான விதிகளை உருவாக்க, அல்லது வரைமலம் பிரோகிராம் உருப்படிகளை விவரிய பிரோகிராமிங் மொழிகளின் வகைகளையும், வரைமல பிரோகிராமிங் மொழிகளின் வகைகளையும் வேறுபடும் வகைகளுக்கு உள்ள இயக்க கொள்கைகள் அல்லது விசுவாசிக பிரோகிராமிங் மொழிகளின் வகைகளில் கொண்டுவருகின்றன. பிரோகிராமிங் மொழிகள் கணினி பிரோகிராமிங் செய்வதுக்கு உள்ள ஒரு வகையான கணினி மொழி பயன்படுத்தும் ஒன்று.

பிரோகிராமிங் மொழிகள் அடிப்படையில் இரண்டு பெருமையான வகைகளாக பிரிக்கப்படுகின்றன:

1. உயர் நிலை மொழி ஆங்கில மொழிக்கு அமைந்த ஒரு வடிவத்தைக் கொண்டுள்ளது. மூலகினி அல்லது விளக்கி பிரோகிராம் மொழியை கணினி-அடிப்படை கணினி மொழி விரும்பத் திக்குமிடுகின்றன. ஜாவா மற்றும் பைதன் உயர் நிலை பிரோகிராமிங் மொழிகளின் சில உதாரணங்கள். இவை போதும் உயர் நிலை மொழிகளுடன் விளக்கில் பலுவெறி ஆகும், ஆனால் அது எளிதாக உள்ளது.
2. குறைந்த நிலை பிரோகிராமிங் மொழிகள் உயர் நிலை மொழிகளுடன் அதிக அரசியாக வேலை செய்யுகின்றன. அவை உடைய மென்பொருள் மற்றும் மென்பொருளுடன் நேரடியாக படைத்து விளக்கில் பலுவெறி ஆகும். குறைந்த நிலை மொழிகளின் இரண்டு பொது உதாரணங்கள் கணினி மொழி மற்றும் அசம்ப்ளி மொழி என்று இருக்கும். இவை போதும் உயர் நிலை மொழிகளுடன் விளக்கில் பலுவெறி ஆகும், ஆனால் அது அதிக கோர்ப்பதை மற்றும் படித்தல் இல்லாமைக்கு விளக்கமற்ற விலக்கம் உள்ளது.

### [பிரோகிராமிங் பரிமாணங்கள்](/Programming_Languages/readme.md#Programming+Paradigms)
பிரோகிராமிங் பரிமாணங்கள் வளரும் பிரோகிராமிங் பரிமாணங்கள் அநேக வகையான பிரோகிராம் அல்லது பிரோகிராமிங் மொழிகளை அமைக்க முடியும் வழிகள் அல்ல. ஒவ்வொரு பரிமாணம் சில படிகள், அம்சங்கள், மற்றும் பொது பிரோகிராமிங் பிரச்சினைகள் எப்படி அல்லது அவை எப்படி அவற்றை நிரப்ப வேண்டும் என்று கூற்றாகும்.

பிரோகிராமிங் பரிமாணங்கள் மொழிகள் அல்ல அந்தப் பரிமாணத்தையும் அல்லது கருவிகளையும் "உருவாக்க" முடியாது. அவை அநேக மக்கள் ஒரு வகையான வசனங்கள் மற்றும் கொள்கைகளின் ஒரு தொகுப்பாக உள்ளன, அநேக மக்கள் அவைகளை ஒரு பொது வார்த்தைகளுக்கு அமைக்க, அடிப்படைகளை அந்தக் கருவிகளில் விளக்குகின்றன. பிரோகிராமிங் மொழிகள் அல்லது கருவிகள் ஒவ்வொரு பரிமாணத்துடன் சேர்ந்திருக்காது. உங்கள் கோடையை ஒரு குறிப்பில் அளிக்க முடியும் என்று கூறப்பட்டிருக்கும் (ஹாஸ்கல் மற்றும் செயல்படுத்தல் பிரோகிராமிங் உதாரணம்). ஆனால் குறைந்த பரிமாணத்துடன் உங்கள் கோடையை ஒரு குறிப்பில் அளிக்க முடியும் அல்லது பிரோகிராம் வகை அல்லது மற்றொரு குறிப்பில் உங்கள் கோடையை உருவாக்க முடியும் "பல-பரிமாண" மொழிகளும் உள்ளன (ஜாவாஸ்கிரிப்ட் மற்றும் பைதான் உதாரணங்கள்).

## [தரவு வகைகள்](Data%20Types/readme.md#data-types)
ஒரு தரவு வகை, பொருளின் ஏதாவது தரம் மற்றும் அதில் எத்தனை வகையான கணித, உத்தரவு, அல்லது தர்கோல் செயல்களை விளக்கும் பதிவு செய்ய முடியும் என்பதை அறிக்கைக்கு வருகின்றது, பிரோகிராமிங்கில் ஒரு வகைப்படுத்தல் ஆகும்.

### [ஆதிகார தரவு வகைகள்](Data%20Types/readme.md#primitive-data-types)
ஆதிகார தரவு வகைகள் பிரோகிராமிங்கில் அதிசய தரவு வகைகள் ஆகும். அவை அதிக செயல்முறை தரவு வகைகளின் கட்டாயமான அடுக்குகள் ஆகும். ஆதிகார தரவு வகைகள் பிரோகிராமிங்கில் முன்புத்தரிக்கின்ற சொற்சொல் பயன்படுத்தி முன்னிருக்கின்றன.

### [பொது ஆதிகார தரவு வகைகள்](Data%20Types/readme.md#common-primitive-data-types)
- [முழுத்துணை](Data%20Types/readme.md#integer)
- [புளம்](Data%20Types/readme.md#float)
- [பூலியன்](Data%20Types/readme.md#boolean)
- [எழுத்து](Data%20Types/readme.md#character)
- [செயலி](Data%20Types/readme.md#string)

### [ஆதிகார அதிசய தரவு வகைகள்](Data%20Types/readme.md#non-primitive-data-types)
ஆதிகார அதிசய தரவு வகைகள் முற்படியாக பரிவர்த்த தரவு வகைகளாகும். அவை பிரோகிராமர் உருவாக்கியுள்ளன மற்றும் பிரோகிராமிங்கில் வரையறுநிலையாக வரையறுநிலையாக வெளிப்படுத்தப்பட்டன. ஆதிகார அதிசய தரவு வகைகள் பரிவர்த்த தரவு வகைகள் என்றும் அழைக்கப்படுகின்றன அவை பிற வகைகளில் உருவாக்கப்பட்டுள்ளன.

### [பொது ஆதிகார அதிசய தரவு வகைகள்](Data%20Types/readme.md#common-non-primitive-data-types)
- [வரிசை](Data%20Types/readme.md#array)
- [படிமம்](Data%20Types/readme.md#struct)
- [ஐகான்](Data%20Types/readme.md#union)
- [குறி](Data%20Types/readme.md#pointer)
- [செயல்](Data%20Types/readme.md#function)
- [வகுப்பு](Data%20Types/readme.md#class)

## [அறிமுகங்கள் மற்றும் செயல்கள்](Statements%20and%20Functions/readme.md)
கணினி பிரோகிராமிங்கில், ஒரு அப்படிவ முறையான பிரோகிராமிங்க் மொழியில் செயல் செய்ய வேண்டும் என்று குறிப்பிடும் ஒரு சொல்லு அதாவது அறிமுகம் ஆகும். அந்த மொழியில் எழுதப்பட்ட ஒரு பிரோகிராம் ஒரு அல்லது அதற்கு மேல் அதிசய தரவுகளின் வரிசையாக உருவாக்கப்பட்டுள்ளது. ஒரு சொல்லில் உள்ள அதிசய அம்சங்களைக் கொண்டிருக்கலாம் (உதாரணம், விசைகள்).
எந்த பிரோகிராமிங்க மொழியிலும் அந்த பிரோகிராமிங்க மொழியின் கோடியின் லாகிகத்தை அமைக்க அவசியம் உள்ள இரண்டு முக்கிய வகைகள் உள்ளன.

1. [விதி செயல்கள்](Statements%20and%20Functions/readme.md#conditional-statements)

பிரதிகூல அறிகுறி அறிகுறிகள் இரு வகைகளைக் கொண்டுள்ளன:

- உடையில் (if)
- உடையில்-இல்லை (if-else)
- விரிவான பொருள் (switch case)


2. [வரி செயல்கள்](Statements%20and%20Functions/readme.md#loops)

வரி செயல்களின் முன்னாள் வகைகள் முக்கியமாக மூன்று வகையாக உள்ளன:

- அந்தர வரி (for loop)
- அந்தர வரி (while loop)
- அந்தர வரி (do-while loop) - while loop-ன் மாற்றம்
- அந்தர வரி (do-until loop)

------------

ஒரு செயல் ஒரு குறிப்பிட்ட பணி செய்யும் அல்லது திட்டும் கொள்ளும் அடிப்படையான அமைப்பு ஆகும். செயல்கள் தரவை ஏற்றுக்கொள்ளும், அதை செயல்முறைக்குப் பரிசீலிக்கின்றன அல்லது அதை செய்யும் அல்லது அதை வரும் அடிப்படைக்குப் பரிசீலிக்கின்றன. செயல்கள் மேலாண்மை கோண்டு எழும்புவதற்கு அமைக்கப்பட்டுள்ளன. ஒரு செயல் ஒருவர் அல்லது அதற்கு அதிக முறையில் அழைக்கப்பட்டுள்ளது என்று எழுதப்பட்டுள்ளது. விதமான செயல் மொழிகள் செயல்களை எழுதுவதற்கு விதிகளை விவகாரிப்பதில் விதிகளை அனுபவித்துக் கொள்ளுகின்றன

செயல் அதிசயங்கள் பற்றி மேலும் அறிய [இங்கே](Statements%20and%20Functions/readme.md#functions)


## [தரவு கட்டமைப்புகள்](Data%20Structures/readme.md)
கணினி அறிவியலில், தரவு அமைப்பு ஒரு தரவு அமைப்பாக்கல், மேலாண்மை அணுக்கம் மற்றும் சேமிப்பு வடிவம் அநேக வகைகளுக்கு சிறந்த அணுக்கத்தை அனுமதிக்கும் வடிவம் ஆகும். மேலும் குறிப்பிடப்படும் போது, தரவு அமைப்பு ஒரு தரவு மதிப்புகளின் ஒன்றியம், அவர்கள் உட்பட, மற்றும் தரவிற்கு விண்ணப்ப அல்லது செயல்கள் அல்லது செயல்கள் ஆகியவை ஆகும்.

### தரவு அமைப்புகளின் வகைகள்
- [வரிசை](Data%20Structures/readme.md#array)
- [இணைய பட்டியல்](Data%20Structures/readme.md#linkedlist)
- [ஸ்டேக்](Data%20Structures/readme.md#stack)
- [வர்த்தியம்](Data%20Structures/readme.md#queue)
- [ஹாஷ் டேபிள்](Data%20Structures/readme.md#hashtable)
- [ஹீப்](Data%20Structures/readme.md#heap)
- [மரம்](Data%20Structures/readme.md#tree)
- [கிராப்](Data%20Structures/readme.md#graph)

## [அல்கொரிதம்](Algorithms/readme.md)
அல்கொரிதங்கள் கணினி செயல்களை முடிக்க தேவைப்படும் படிகள். அவை எங்கள் சாதனங்கள் செய்யும் பயிற்சியின் அதிசயமாக உள்ளன, இது புதிய பரிபாசகம் அல்ல. கணிதம் உருவாக்கப்பட்ட பிறகும், திட்டங்களை எவ்வாறு அதிசயமாக செய்ய உதவ அல்லது விருது கட்ட அல்லது விருது செய்ய உதவ தேவைப்படும் என்று அல்கொரிதங்கள் தேவைப்படுகின்றன, ஆனால் இன்று நாங்கள் செய்யும் கெடுத்து பரிசீலிக்குத் தயாராக்கியுள்ளோம். உங்களுக்கு படிகள் அல்லது கட்டடங்களை கிடைக்கக்கூடியதாக சேர்ந்த மற்றும் கூடுதல் செயல்களை காண்பிக்க உதவுகின்றனவோ இல்லையோ, நாங்கள் இன்று பார்க்கலாம். அதிசயமாக விளக்கமளிக்க நாங்கள் சோடிங் மற்றும் கிராப் தேடல் போன்ற பரந்த கணினி சிக்கல்களைப் பார்க்கின்றோம், மற்றும் அவற்றை எங்கள் செய்தியை சிறந்தவர்களாக காண்கின்றனர், இதை செய்ய முடியும் அல்லது அறிந்திட முடியும்.

### [நேர சூழ்நிலை](Algorithms/Time%20Complexity/readme.md)
ஒரு அல்கொரிதத்தின் நேர சூழ்நிலை அதற்கு பல நுண்ணறிவு அளிக்குகின்றது. அதன் கொடையை உள்ளடக்கின்ற ஒரு தரவால் அதன் நுண்ணறிவை போல் கருத முடியும். நேர சூழ்நிலையை கணிக்கும்போது, அதன் நுண்ணறிவை நாம் அதிகரித்து, அதன் அதிசயமாக உள்ளதை நம்புவது முடியும் என்று அளிக்க முடியும் என்ற நேர சூழ்நிலையை நாம் கண்காணிக்கலாம் விரும்புகின்றது. அதனால், அத்தாவரத்தை அமைக்க விரும்பாமல் அதை நிறுத்தாது..

### [அவகாச சூழ்நிலை](Algorithms/Space%20Complexity/readme.md)
அவகாச சூழ்நிலை அதற்கு ஒரு அல்கொரிதத்தின்/நிரலத்தின் பயன்பாட்டிற்கு பயன்படுத்தும் மெம்மோரி அளவுகள் ஒன்று அல்லது பல்வேறு சாதனங்களின் அளவை சேர்க்கின்றன. அவகாச சூழ்நிலையை கணிக்க அல்கொரிதம்/நிரலம் உபயோகிக்கும் மற்றும் அதன் பட்டியலில் உள்ள மாறியின்றி அளிப்பது அது.

### [வரிசைப்படுத்தல்](Algorithms/Sorting/readme.md)
வரிசைப்படுத்துதல் ஒரு பட்டியத்தில் உள்ள உருப்படிகளை ஒரு குறிப்பிட்ட வரிசையில் வைக்கும் செய்தி. உதாரணமாக, உங்களுக்கு ஒரு பெயர்களின் பட்டியம் உள்ளதால், நீங்கள் அவற்றை அக்ஷரிகளின் வரிசையில் வரிசைப்படுத்த விரும்பலாம். அல்டர்னேடிவல், உங்களுக்கு எண்களின் பட்டியம் உள்ளதால், அவைகளை சிறியதேன் அல்லது பெரியதேன் வரை வரிசைப்படுத்த விரும்பலாம். வரிசைப்படுத்தல் ஒரு பொது பணி ஆகும், மற்றும் அது பல வேறுபடங்களில் நாங்கள் அதை செய்ய முடிக்க முடியும்.

### [தேடல்](Algorithms/Searching/readme.md)
தேடல் அல்கொரிதம் ஒரு குழுவில் குறிப்பிட்ட இலக்குக்கு கொண்டு போக ஒரு அல்கொரிதம் ஆகும். தேடும் அல்கொரிதங்கள் எந்த தரவு கூட்டத்தில் அல்லது அதன் சேமிப்பிடப்பட்ட இலக்குக்கு உள்ள இலக்கை சோதிக்க வடிகட்டலாக உள்ளன.


### [கிராப் தேடல்](Algorithms/Graph/readme.md)
கிராப் தேடல் ஒரு கிராப் மூலம் ஒரு குறிப்பிட்ட நோட்டை கண்டறித வழியில் போகும் செய்தி. ஒரு கிராப் ஒரு தரவு கூட்டத்தை அடங்கி உள்ளது அல்லது அதற்கு வேலை செய்யும் ஒரு வரிசை செயலாகிறது. இந்த வரிசைகள் ஒரு அமைதியாகும் அல்லது மாற்றக்கூடிய முடக்கங்கள் உள்ளன. ஒரு வரிசை கரண வரிசைகளுக்கு அல்லது ஒரு வரிசை வரிசைகளுக்கு அதாவது ஒரு வரிசை உருப்படிகளின் அளவில் உள்ள ஒரு அலகுக்கு ஒரு அலகுக்கு குழப்பிக்கொள்ளும் ஒரு தரவு அமைப்புக்கள் அடங்கி உள்ளன. வரிசைகள் இரண்டு வரிசைகளுக்கு அல்லது அதற்கு அநுப்பிக்கப்படுகின்றது ஒரு தரவு கூட்டத்தின் உட்படி அல்லது ஒரு வரிசை வரிசைகளுக்கு உள்ள வரிசை கூட்டத்தின் அளவின் ஒரு வரிசை உருப்படியானது. வரிசைகள் பல உயர்தர உள்ளனவோ உயர்ந்த மாறியான தரவு உருப்படிகளின் அமைப்புகளாக உள்ளன. உதாரணமாக, வான்வழியின் பற்றி பேசுவது நகர்கள் மாணவர்கள் ஆவணிகள் உருப்படிகள் மற்றும் உருப்படிகள் உருவாக்கும் கிராபாக்குகள் அந்த நகர்கள் வரிசைக்கு இந்திய பற்றி என்ன விரைவில் தேடல் செய்வதற்கு அனுமதிகள், வான்வழிக்கு விமான நேர்மாக்கம் உள்ள நகர்களை உள்ளடக்குகின்றது. கிராப்கள் கணிக்க ஒருவர் மற்றும் மற்றும் மற்றும் விருப்பத்திற்குள் பெயர் அல்லது நோட்கள் அல்லது புள்ளிகள் அல்லது ஒரு கைமுழு அல்லது ஒரு கைமுழு குற்றத்துக்கு உள்ள ஒரு குறிப்புக்கு உள்ள ஒரு தரவு உருப்படி ஆகும். வரிசைகள் வரிசை மாற்றும் பழைய விருப்பமான பழைய முகங்கள் அல்லது புள்ளிகள் போல பல வழியாக செய்ய முடியும்.



### [மாறுபாடு நியமனம்](Algorithms/Dynamic%20Programming/README.md)
மாறுபாடு ஒரு கணித மேம்பாடு முறை மற்றும் கணிப்பொறி மேம்பாடு முறையாகும். இதை ரிசர்ட் பெல்மன் 1950களில் வளர்ச்சியைச் செய்தார் மற்றும் விண்கலமின் போது அனைத்து புதிய படிகளிலும் விளக்கப்பட்டுள்ளது. இரு பிரச்சினைகளை எப்போதும் ஒன்று வெளிப்படுத்தி சுமார் பிரச்சினையிலிருந்து பிரதிபித்திக்க மூலம் அதை எளிதாக்கும் என்பது அடிப்படை அமைப்புகளுக்கு செல்லும். சில மாறுபாடு முறைகள் இப்படிதமாக பிரிப்பப்பட்டு மூலப்பிரச்சினைகள் மாறுபாடு பிரச்சினையாக்கும். அதை வரிசைகளில் சில பிரச்சினைகள் இதில் மூலப்பிரச்சினைகளை சில பொருள்களில் சோதிக்கும் முறையாகக் கூடாது அல்லது பல விளக்கமான பொருள்களில் மாறுபாடு முறையாகக் கூடாது. கணிப்பொறிக்கிலும், ஒரு பிரச்சினையை உருவாக்கப்பட்டு பிரதிபித்திக்க முடியும் அல்லது முதல் கடித கோணத்தில் மூலப்பிரச்சினைகளுக்கு உத்தமமான தீர்மானங்களை கண்டுபிடிக்க முடியும், அப்போது அதன் வீதத்தில் சில பிரதிபித்திக்கு உத்தமமான தீர்மானங்களை வரைந்து கண்டுபிடிக்க முடியும் அதை செய்து காட்டும் வழிமுறையாகும். ஒரு பிரச்சினையை குறிப்பிடமாட்டம் சிறப்பாக சினி மற்றும் சினம் அமைக்கும்போது, அநிவார்யமாக அதிகம் விளக்கம் செய்ய உத்தமமாக செய்கின்றது அல்லது அதை செய்யும் முறைக்கு அமைப்பு உள்ளடக்குகின்றது. சிறு கணிப்புகளில் சேமிப்பு அளவை அறிந்து கொள்ள முடியும் மேலும் நிரல் அமைப்புகளில் அதிகம் சேமிக்கப்படும். அதை அறிந்து கொள்ள முடியுமா அல்லது அதிகம் சேமிக்க முடியுமா, அதை அறிந்து கொள்ள முடியும்.



### [அதிசய அகரிதிகள்](Algorithms/Greedy%20Algorithm/readme.md)
"அதிசய அகரிதிகள்" என்பது அதிசயமான பிரிவுகள் ஆகும், சொல்லாக்கிகளின் ஒரு எளிமையான, உண்மையான வகை அகரிதிகள் ஆகும். அவை அதிசயமாக அழுத்தப்படும் அதாவது, ஒவ்வொரு படிகளிலும், அந்த நேரத்தில் மிகச் சிறந்ததை தேர்வு செய்யும். இதன் அர்த்தம் அதிசயமான அகரிதிகள் உலகம் முழுவதும் முழுமையான செய்திகளை கண்டுபிடிக்க பயன்படுத்த முடியும் என்று அர்த்திக்கொள்ளப்படுகின்றது. அதிசய அகரிதிகள் சொல்லாக்கிகளின் ஒரு வகையாக உள்ளன. ஒரு சொல்லாக்கியை அதிசய அகரிதிகளின் மூலம் பொருட்களின் ஒரு உட்புற செய்தியை தேர்வு செய்து அதிசயமாக சொன்னது. அதிசய அகரிதிகள் முறைமை சொல்லாக்கிகள் கொள்கின்றன். ஒரு சொல்லாக்கியை அதிசயமாக தீர்மானித்து அதை ஒரு செய்தியின் அந்த சொல்லின் உட்புற செய்தியாக பெறுவது அந்த முறைமையில் சொல்லாக்கியை பயன்படுத்தும் வார்த்தைகளில் சொன்னதாகக் கொள்கின்றன. அதிசய அகரிதிகள் வரிசையை கண்டுபிடிக்க முடியும். அவை அதிசய மட்டும் சொல்லாக்கிகள் கொள்கின்றன. அவை ஒரு பாலின்ப அகரிதிகள் ஆகும். அவை கட்டப்பட்டுள்ளன மற்றும் அதிசயமாக அழுத்தப்படுகின்றன. அதிசய அகரிதிகள் முன்பொருள் சொல்லாக்கிகளாகும். அவை மொத்தம் பெயரில் ரிசர்வ்ட் கீயார்டுக்களாக அழைக்கப்படுகின்றன.


### [பின்புடி செயல்பாடு](Algorithms/Backtracking/README.md)
பின்புடி செயல்பாடு ஒரு சிக்கலை தீர்க்கும் வழியாக, ஒரு பகுதியை ஒரு பகுதிக்குச் சேர்க்க முயற்சிக்கும் மூலம் பிரச்சினையை தீர்த்து அநேக படி மேம்படுத்த முயற்சி செய்வது ஒரு கணிப்போமியம் அல்லது முறைமையாகும். பின்புடி, அநேக படி தேர்வு செய்வதை தவிர்க்கும் அநேக படி மேம்படுத்த அதிசயமாக செய்வதை அகழும்.


### [கிளை மற்றும் பைண்ட்](Algorithms/Branch%20and%20Bound/README.md)
கிளை மற்றும் பைண்ட் ஒரு பொருள் மற்றும் விருதுகள் பெற முயற்சிக்கும் மூலம் வழங்குகின்ற ஒரு பொருள் அல்லது விதை ஆகும். அது அநேக கோடித்தொகை விளக்கம் செய்யும் மூலம் கோடித்தொகை விளக்கங்களை ஒழிய முடியாது பிரச்சினைகளை முடிக்கும் மூலம் ஒரு பொருளை ஒரு பொருளுக்கு சேர்த்து வைக்கும் முயற்சி ஆகும் (இங்கு நேரம், இங்கே போன்ற கோடித்தொகைகளின் சேர்ப்பட்ட வரை அநேக விளக்கங்கள் அமைந்துள்ளன).


### [வெவ்வேறு தேடல் மற்றும் வரிசையாக்க அல்காரிதம்களின் நேர சிக்கலானது மற்றும் விண்வெளி சிக்கலானது](Not-Added)
**நேர பரிசோதித்தல்**: இது ஒரு குறிப்பிட்ட உரையிடப்பட்ட கட்டளை தொகுதியை மெய்நிகரிக்கின்றது; முழு நேரம் அல்லது வழக்கம் எதிர்காலம் அமைந்திருக்கும் பதிவிடுதல் அல்ல. ஏற்கையாக, நேரம் ஒரு இடைவிடயப்படிக்கு அளிக்கப்படுகின்றது, நேர பரிசோதித்தல் வெளிப்படுகின்ற விளக்கத்திற்கு பிரகாரம் பிரகாரம் மாறுகின்றது; பிராகாசியத்தை அமைக்கும் சூழ்நிலைகள், பொருள் விளக்கத்தை போல, நேர பரிசோதித்தல் மாறுகின்றன.

**இடம் பொருள மாற்றம்**: அது அதன் செயல்படுத்தும் நிர்வாகத்திற்கு அளவிடப்படும் மொத்த நினைவக விசை.

இருவரும் உள்ளீடு அளவில் (n) புனிதப்படுகின்றன. ஒரு மொழிபெயர்ப்புக்கு அமைக்கப்படும் ஒரு மேலும் ஒ (Big O குறிப்பாக்கம்) மூலம் ஒரு மெய்நிகரிக்கப்படுகின்றது.

ஒரு கணிமையின் செயல்பாடு இந்த இரண்டு அளவுகளின் அனைத்து அமைப்புகளிலும் அழைக்கப்படுகின்றது.

நேர பரிசோதித்தலின் வகைகள்:

- சிறந்த நேர பரிசோதித்தல்: அல்கொரிதம் செய்தால் அது குறியிடுகின்ற நேரம் அல்லது குறைவான நேரம் எடுக்கும் உள்ளீடு. சிறந்த நேர சூழ்நிலையில், அல்கொரிதம் செய்யும் நேர பரிசோதித்தலை கணக்கிடுகின்றோம். உதாத்தமாக, ஒரு பெரிதினம் தரக்கோட்டில் ஒரு பெரிதினம் தரக்கோட்டில் உள்ள தரவு வரிசையில் தரவு இடையில் உள்ளதாக, சிறந்த நேர சூழ்நிலை ஏற்படுகின்றது.
- சராசரி நேர பரிசோதித்தல்: எல்லா சீரற்ற உள்ளீடுகளையும் எடுக்கின்றோம் மற்றும் அந்த உள்ளீடுகளின் கணக்கிடுகின்றோம். அப்படியே, அந்த உள்ளீடுகளின் மொத்த எடுக்கை எண்ணிக்கொள்கின்றோம்.
- மேலும் நேர பரிசோதித்தல்: அல்கொரிதம் செய்தபோது அது அதிக நேரம் எடுக்கும் அல்லது அதிக நேரம் எடுக்கும் உள்ளீடுகளுக்கு அநேக நியாயங்கள் வரிசையில் கணக்கிடுகின்றோம். உதாத்தமாக, ஒரு பெரிதினம் தரக்கோட்டில் ஒரு பெரிதினம் தரக்கோட்டில் உள்ள தரவு வரிசையில் தரவு இறுதியில் உள்ளதாக, சராசரி நேர சூழ்நிலை ஏற்படுகின்றது.

சில பொது நேர பரிசோதித்தல் அமைப்புகள்:

- **O(1)**: இது அநிலை நேரத்தை குறிக்கின்றது. O(1) பொருள் அத்தனை உள்ளீட்டுக்கு வரை ஒரு அநிலை நேரம் உள்ளது. ஹாஷ் மேப்கள் அநிலை நேர உதாரணங்கள்.

- **O(log n)**: இது லோகாரித்மிக நேரம் குறிக்கின்றது. O(log n) என்பது ஒரு செயல்களுக்கு ஒரு நூல் சேர்க்கும் என்பதை குறிக்கின்றது. பைனரி தேடல் மொழிகளில் உள்ள உள்ளீடுகளை தேடுவது ஒரு நன்கு உதாரணம்.

- **O(n)**: இது பராமிப்பு நேரம் குறிக்கின்றது. O(n) என்பது செயல்களின் பரிசோதித்தல் உள்ளீட்டின் அளவில் உள்ளீடு போது, நுரைபாக்கிய நுரைபாக்கிய உள்ளீடு போது நேரம் எடுக்கும். வளர்ந்திருந்து உள்ளீடுகளை தேடும் எளிய உதாரணம்.

- **O(n*n)**: இது பராமிப்பு நேர பரிசோதித்தல் குறிக்கின்றது. O(n^2) என்பது செயல்களின் பரிசோதித்தல் உள்ளீட்டின் அடுக்குக்கு அடுக்கு இருக்கும் என்பதை குறிக்கின்றது. முடிவு பெருக்கப்பட்ட வருகைகள் பராமிப்பு நேர பரிசோதித்தல் அமைப்புகளின் அநிலை உதாரணங்கள்.

- **O(n log n)**: இது போலிந்த நேர பரிசோதித்தல் பரிசோதித்தல் குறிக்கின்றது. O(n log n) என்பது செயல்களின் நேர பரிசோதித்தல் அதன் அதிசய நேர பரிசோதித்தல் (O(log n)) இன்னும் n மட்டுமே இருக்கும் என்பதை குறிக்கின்றது. அதிசய நேர பரிசோதித்தல் (O(log n)) நேரத்தை எடுக்கும் முதல் பிரிவாக இருந்து, அப்படியே, பங்கு செய்ய அநேகப் புதிய செயல்கள் பராமிப்பு நேர பரிசோதித்தல் (O(n)) நேரத்தை அந்த முதல் நேர பரிசோதித்தல் (O(log n)) நேரத்துக்கு மூலம் வரிசைப்படுத்தும்; அதனால், மெர்ஜ் சோர்ட் போன்ற பிரிப்பு மற்றும் சூழ்நிலை முடிவு பெருக்கத்தை குறிக்கின்றது."

| Algorithm	     |             |  Time Complexity|	       | Space Complexity |
|   :---:        |  :---:      |  :---: 	   |   :---: 	   |   :---:          |
|  	             | Best	       | Average	   |  Worst	     |  Worst           |
| Selection Sort | Ω(n^2)	     | θ(n^2)	     | O(n^2)	     | O(1)             |
| Bubble Sort	 | Ω(n)	         | θ(n^2)	     | O(n^2)	     | O(1)             |
| Insertion Sort | Ω(n)	       | θ(n^2)	     | O(n^2)	     | O(1)             |
| Heap Sort	     | Ω(n log(n)) | θ(n log(n)) | O(n log(n)) | O(1)             |
| Quick Sort	   | Ω(n log(n)) | θ(n log(n)) | O(n^2)	     | O(n)             |
| Merge Sort	   | Ω(n log(n)) | θ(n log(n)) | O(n log(n)) | O(n)             |
| Bucket Sort    | Ω(n +k)	   | θ(n +k)	   | O(n^2)	     | O(n)             |
| Radix Sort  	 | Ω(nk)	     | θ(nk)	     | O(nk)	     | O(n + k)         |
| Count Sort  	 | Ω(n +k)	   | θ(n +k)	   | O(n +k)	   | O(k)             |
| Shell Sort  	 | Ω(n log(n)) | θ(n log(n)) | O(n^2)	     | O(1)             |
| Tim Sort	     | Ω(n)	       | θ(n log(n)) | O(n log(n)) | O(n)             |
| Tree Sort   	 | Ω(n log(n)) | θ(n log(n)) | O(n^2)	     | O(n)             |
| Cube Sort	     | Ω(n)	       | θ(n log(n)) | O(n log(n)) | O(n)             |

| Algorithm	     |             |  Time Complexity|	     |
|   :---:        |  :---:      |  :---: 	 |   :---: 	   |  
|  	             | Best	       | Average	 |  Worst	     |
| Linear Search  | O(1)	       | O(N)	     | O(N)	       | O(1)  |
| Binary Search	 | O(1)	       | O(logN)   | O(logN)	   |

## [அலன் ட்யூரிங்](Not-Added)
அலன் ட்யூரிங் (பிறப்பு: 1912 ஜூன் 23, லண்டன், ஆங்கிலம்—இறுதி: 1954 ஜூன் 7, வில்ம்ஸ்லோ, செஷயர்) ஒரு ஆங்கில கணிதஜ்ஜான் மற்றும் அரசியலால் அறிந்தவர். அவர் கேம்ப்ரிஜ் பல்கலைக்கழகத்தில் மற்றும் பிரின்ஸ்டன் உயிரியல் ஆராய்ச்சி நிறைவில் படித்தார். அவரதன் முக்கிய 1936 ஆம் ஆண்டு பதிப்பித்த 'கணிக்கக்கூடிய எண்கள் பற்றி' என்ற படிதத்தில், அவர் கணிதத்தில் உண்மையை எப்போதும் அறிந்துகொள்ள முடியாது என்று ஒரு பொது அமைப்புக்கு எந்த உருவாக்கும் முறை இல்லை என்பதை பிரதிபாதித்தார், மற்றும் கணிதத்தில் அறியமுடியும் (அறியமுடியாது அல்ல) உருவாக்கல்கள் எப்போதும் உள்ளன என்று முழுநேர அந்தச் சொல்லில் காட்டின்றது. அந்த படிதம் இதே ட்யூரிங் இயந்திரம் அறியமுடியும் என்றும் அறிந்தவர். அவர் கணினிகள் கணிதமும் மானிடத்தும் இடையே அளவுகொண்டு சிந்தனை செய்ய முடியும் என்று நம்பினார் மற்றும் இதை மதிப்பிட ஒரு எளிதான சோதனை (காண்க Turing சோதனை) அமைத்தார். அவரதன் கணிதத்திற்கு மேலான இதே உடன் அரசாங்க போரில் குறிப்பிட்ட பகுப்பில் மதிப்பிடத் தக்க உழைப்பது போல், அவர் ம௃த்துவம் அடைந்தது. அவரும் மற்றும் ஜெர்மனியில் வானொலி பேச்சு தொலைபேசிகள் வழங்கும் மற்றும் தடைப்படுத்துகின்ற ஈஞ்சிமா குறியீடுவழியை முறிந்து போரில் முடித்தார். போர் பிறகு, அவர் மேன்சஸ்டர் பல்கலைக்கழகத்தில் படித்து, இப்போது அறிவியல் வினாத்தம் எனப்படுகிற கணினி அறிவியல் கொண்டுவந்தார். அதற்கு முன்பும், ட்யூரிங் மற்றும் ஒரு ஆனால் அதுவான (அந்த நேரம் ஒழியாத ஒரு செய்தியாக்கம்) மூலக்கு அடுத்த அரசியல் வன் பதிலாக 12 மாதங்கள் மூலக்குத்தையப்பட்டது

2009ல் ஒரு பொது பிரச்சாரம் பிரச்சாரித்த பிரிட்டிஷ் பிரதம மந்திரியாக கோர்டன் பிரவுன் அலன் டியூரிங்க் பற்றி பிரிட்டிஷ் அரசின் சார்பாக அதிசயக் குறித்த அதிசய முகாம் அளித்தார். 2013ல் குயின் எலிசபெத் II மரபில் பிரிட்டிஷ் அரசின் வரும் அளிக்கின்ற ஒருவர் அலன் டியூரிங்க் மார்கம் சோர்பானிற்கு அனுப்பின்றனர். "அலன் டியூரிங் சட்டம்" என்பது இப்போது பிரிட்டிஷ் ஐக்கிய அரசின் இதிஹாஸத் திணைக்கணித அலகில் அறியப்படுகிறது; இது வரலாற்றில் அலன் டியூரிங்கின் கைத்தண்டிகள் அல்லது பதித்தவர்கள் மீது விதிமுறைகளை விளக்கும் வகையில் செயல்படுத்தின்றது.

அலன் டியூரிங் பல வரலாற்றில் அவனை சுத்தி செய்யும் போது அவன் பெயரை அனுப்பும் வளரும் காணி கொள்கின்றன, அதுவும் கணினி அறிவியல் புரட்சி செயல்பாட்களுக்கு ஒரு வார்ஷிக விருது போன்றது. அவன் பிறந்த நாள் ஒருவரிடம் வெளியிடப்பட்ட வங்கி விலைப் பட்டியலில் கூட்டம் கிடைத்துள்ளது, அது 2021 ஜூன் 23 அன்று வெளியிடப்பட்டது. 2019ல் பிபிசி சீரிஸ், பொது மக்கள் மதிப்பும், அவனை 20ஆம் நூற்றாண்டின் அதிசய மனிதர் என்று பெரும்

## [மென்பொருள் பொறியியல்](Software%20Engineering/readme.md)
மென்பொருள் பொறியியல் என்பது மென்பொருள் பயனாளர்க்கு மென்பொருளை வடிவமைக்க, உருவாக்க, சோதனை செய்து பரப்புதல் மற்றும் பரப்புமென்பொருளை பரப்புவது முதல் வடிவமைப்புவரைக்கும் இணைப்பு பல்லகங்கள் செய்யும் கணினி அறிஞர்கள் கூறுகின்றனர்.

மென்பொருள் பொறியியலின் வைகாசிக வெளிப்படுத்தல்களை பார்க்கலாம்:

- IEEE, அதன் 610.12-1990 நிலையில், மென்பொருள் பொறியியலை மென்பொருளை வடிவமைக்க, உருவாக்க, செயல்படுத்த, பரப்ப முதல் அதன் பரப்புவதற்கு ஒரு அமைதியான, அணைத்தலமான ஒரு அணையாக்கப்படும் அமைப்பு முனையாக அமைக்கும் ஒரு கணினியியல் முறை ஆவதை விளக்குகின்றது.
- ஃப்ரிட்ஸ் பவர் அதனை 'அமைந்துகொள்ளப்பட்டுவரும் ஸ்டான்டர்ட் கணினி பொருள் நன்மையாக பணித்து உண்டாக்க உதவும் பொருள் பொழியத்தில் பயன்படுத்தின்றனது. அது விருப்பப்பட்டுவரும் பொருள் நன்மையாக பணிக்கான மற்றும் உண்டாக்க உதவும் ஸ்டான்டர்ட் கணினி பொருள் நன்மைகளை அமைக்கின்றது.
- போம் மென்பொருள் பொறியியலை 'கணினி நிரப்பங்கள் மற்றும் அத்தியாவசியமான வடிவமைப்புகளை உருவாக்க, கணினி நிர்மாணத்திற்கு மற்றும் அத்தியாவசியமான வடிவவிவரம் உதவும் வணிக அறிவியல் அறிஞர்களின் வாழ்க்கையில் அந்தச் சாதனை பொருட்கள் பயன்படுகின்றது' என்று விளக்குகின்றது.

### மென்பொருள் பொறியியல் பணிகளும் பொருள்களும்
வெற்றிகரமாக பொறியியல் பொறியாக்கல் என்பதற்கு, கணினி விளக்கம் கொண்டு கணினி விளக்கங்கள் முதல் பிளேட்போர்முகள் மற்றும் போர்டோக்கிகளை வளர்ந்து அடிக்கடி அமைக்க அறிந்திருக்கும். அவர்கள் பாடக்கணினிகள் கட்டி வைக்கும்போது அல்லது பிற பொறியியாக்கள் கட்டி வைத்த பொறியியாக்களை பரிசோதிக்க, மேம்படுத்த மற்றும் பரப்ப வேண்டும்.

இந்த பங்கியில், உங்கள் நாள்-முதல் நாள் பணிகள் பின்தொடர பின்தொடர பட்டியலில் அமைந்திருக்கலாம்:

- மென்பொருள் அமைக்கல் மற்றும் பரப்பல் மென்பொருள்களை பரப்ப வேண்டும்
- புதிய மென்பொருள் நிரப்புவது மற்றும் சோதிக்குவது
- வேகமும் அளவுக்கு மென்பொருள் உயர்வுக்கு மேம்படுத்துவது
- குறிப்பு மற்றும் சோதனை கோட்களை எழுதுவது
- வாடிக்கையாளர்களுடன், பொறியியாக்காளர்களுடன், பாதுகாப்பு விஶேஷஜ்ஞர்களுடன் மற்றும் பிற பங்கியாளர்களுடன் பரப்ப வேண்டும்
- புதிய அம்சங்களை பரப்புவது மற்றும் உள்நுழைவு வாடிக்கையாளர்களுக்கு பரிசோதிப்பு செய்வது

### மென்பொருள் பொறுப்பின்மை பெயர்ச்சி படைத்தல்
மென்பொருள் பொறுப்பின்மை செயல்பாடு பல படைகளை சேர்க்கின்றது, அதற்கு வெளிப்படும் கோரிக்கைகள், வடிவமைப்பு, செயல்பாடு, சோதனை மற்றும் பராமர்பனை உள்ளன. மென்பொருள் வளர்ப்புக்கு ஒரு கடினமான வழியை பின்பற்றி, மென்பொருள் பெயர்ச்சிக்கு பரிமாற்றம் செய்ய முடியும்.

- மென்பொருள் பெயர்ச்சிக்கு முதல் படை கோரிக்கை பெயர்ச்சியை அடைந்தது. இந்த படையில், மென்பொருள் பெயர்ச்சி போலி செயல்பாளர் வடிவமைப்புகள் குழு உட்படிக்கு மென்பொருளின் செயல்பாட்டின் செயல்பாட்டாக்கின்றன. செயல்பாட்டின் செயல்பாட்டு என்பது மென்பொருள் செயல்பாட்டின் முழு வளர்ச்சிக்கு அடிப்படம் செய்கின்றது.

- கோரிக்கைகள் பெயர்ச்சியாக அடைந்த பின், அடுத்த படை வடிவமைப்புத் தொகுதி ஆகும். இந்த படையில், மென்பொருள் பெயர்ச்சி செயல்பாளர் மென்பொருளின் மென்பொருளின் வடிவம், நடவடிக்கை, மற்றும் பிற கோப்புகளுடன் இணைந்து உள்ள விரிவான திட்டமைப்பை உருவாக்குகின்றன. மென்பொருள் வடிவமைப்புத் தானாகவும் மென்பொருளின் செயல்பாட்டின் செயல்பாட்டாகவும் இந்த படையாக்கும் விருப்பம் உள்ளது.

- செயல்பாடு அமைக்கப்படும் இடம் மென்பொருள் பெயர்ச்சியின் கோப்பை உருவாக்க இந்த படையில் உள்ளூர். இது வடிவமைப்பு வரைபடுத்தியும், அதை செயல்பாட்டு மென்பொருளாக அமைக்கின்றது. செயல்பாடு அமைப்பு, குழப்புகளை உள்ளிட விளக்குகின்றது மற்றும் வடிகட்டி பரிசோதித்துக்குப் போகின்றது, இது வடிவமைப்பு வரைபடுத்தியல் செய்யும் விருப்பத்தை உருவாக்குகின்றது.

- சோதனை மென்பொருள் பெயர்ச்சியில் அதிக முக்கியமாக இருக்கின்றது. இந்த படையில், மென்பொருள் பெயர்ச்சியாகப் பார்க்கிறது மென்பொருள் சரியாக செயல்படுத்துகின்றது, நம்பிக்கையாக இருக்கின்றது மற்றும் அதை பயன்படுத்த விளக்கின்றது. இது அலட்சிய வகைகள் சோதனை செய்யும், அநேக வகைகள் சோதனை செய்யும், மற்றும் அமைப்பு சோதனை செய்யும் போது அதை உறுதிப்படுத்துகின்றது. சோதனை உருவாக்குகின்றது மென்பொருள் வரைபடுத்தியல் செய்யும், அது அதாகத்தான செயல்பாட்டை செயல்படுத்த உதவுகின்றது.

- மென்பொருள் பெயர்ச்சியின் கடைசி படை பராமர்பனை ஆகும். இந்த படையில், மென்பொருள் பெயர்ச்சி செயல்பாளர் பிழைகளை திருத்த, புதிய அம்புகளை சேர்க்கவும், அல்லது அதன் செயல்பாட்டை மேம்படுத்த அனுமதிப்படும். பராமர்பனை ஒரு மென்பொருளின் உயிர்நிலையில் தொடரும் பயணம் ஆகும்.


### சாப்ட்வேர் பொறுப்பாக்கியது எப்படி?

- கணினி அறிவியல்: பிரம்பரிகள் பல்லாளி வினாத்தியில் உள்ள கணினி சாப்ட்வேரின் அறிவியல் அடிப்படையைக் கொண்டுள்ளது, முதல் பல்லாளி வினா முதுகுவியல் போன்ற இயக்க அறிவியல் படையின் படிகளில் அனுப்பப்படுகின்றது.
- மேலாண்மை அறிவியல்: சாப்ட்வேர் பொறுப்பின்மையாக உழைக்குகின்றது மற்றும் தொழில்நுட்ப மேலாண்மை அறிவியல் அதை காண்பிக்கின்றது. அதாவது, இது மேலாண்மை அறிவியல் உபயோகிக்கப்படும்.
- பொருளாதாரம்: இந்த ப sector தில், சாப்ட்வேர் பொறுப்பின்மை உங்களுக்கு வளர்ச்சி கொடுக்குகின்றது மற்றும் செலவுகளை கட்டுப்படுத்துகின்றது. ஒரு கணக்கிடைத்த அமைப்பை வளர்த்துவது மற்றும் ஒரு வரம்பை கொண்டுவந்து வர விரைந்திருக்க வேண்டும்.
- கணினி அமைப்பாளரியல்: அதிகவைத்த பொருள் பொருட்கள் மிக பெரும்பால் பொருள் அமைக்குகின்றன. உதாரணமாக, ஒரு தொழில்நுட்ப கண்ட்ரோள் சாப்ட்வேரில் அல்லது ஒரு விமானத்தில் உள்ள விமான சாப்ட்வேர். இந்த வகையான அமைப்புகளில் சாப்ட்வேர் பொறுப்பு முறைகள் பயன்படுத்தப்பட வேண்டும்.

## [ஒரேதர மொதிகள்](Integrated%20Circuits/readme.md)
ஒரு ஐசியம் அல்லது ஒரு ஒன்றிய ஐசியம் அல்லது ஐசி (IC, சிப் அல்லது மைக்ரோசிப் என்றும் அழைக்கப்படுகின்றது) என்பது ஒரு சிறிய சிலிகான் பொருட்கள் அல்லது 'சிப்' வடிவில் உள்ள ஒரு பிரயோக மெய்நிகரிக்கும் வித்தியாச மொழிபெயர் ஆகும். பல சிறிய மொஸ்பட் (மெட்டல்–ஆக்சைட்–மொசில்கேன்ட் ஃபில்ட்-எஃபெக்ட் ட்ரான்சிஸ்டர்) ஐசிக்கு ஒரு சிறிய சிப் அனுக்கின்றன. இதன் முடிவு, விதைப்படும் வித்தியாசமான பெரும்படிகள் கட்டமைக்கப்பட்டிருக்கும் பிரயோக மெய்நிகரிக்கின்றது. ஐசிகளின் பெரும்படிக்கப்பட்ட உதாரண ஐசிகளின் பெரும்படிக்கப்பட்ட வர்த்தக விளைவு, நிலைமை மற்றும் ஐசியம் வடிவமைப்பு பிரயோக அளவை உச்சமாக்கின்றது. இன்டிகிரேடட் ஐசிகளின் பெரும்படிக்கப்பட்ட உதாரண ஐசிகள் அடிப்படையாக தரம் தரக்கோட்டை, இடைவிடயப் பிரயோக மொழிபெயர் வடிவமைப்புக்கு மாற்றுகின்றது. ஐசிகள் இப்பொழுது அனைத்து வினிதிப் பொருள்களிலும் பயன்படுகின்றன மற்றும் இலக்ட்ரானிக்ஸ் உலகத்தின் படியே அபிவேஷப்படுத்தினது. கணினிகள், கைபேசிகள் மற்றும் மற்ற வீட்டு பொருட்கள் இப்பொழுது அதன் பிரயோக மொழிபெயர் மற்றும் குறைவான விலை ஆகிய ஐசிகளின் சிறிய அளவு மற்றும் குறைவான விலை மூலம் முடிவடைந்துள்ளது, போதும் குறிப்பிடப்பட்டிருக்கின்ற தரம் மூலம் முடிவடைந்துள்ளது.

மெடல்–ஆக்சைட்–சிலிகான் (MOS) செமிகணி சாதனைகளில் தொழில்நுட்ப முன்னேற்றங்கள் உடனே அதிசய பொருத்தப்பட்ட மிகப் பெரிய அளவுகளில் விசை அமைப்பு (VLSI) சாத்தியமாக்கப்பட்டது. 1960 களில் அவதூறும் கட்டுப்பட்ட முதல்வரை, விளக்க மற்றும் பருவமாற்ற அளவுகள், அதே அளவில் விசைகளில் அதிசய மொஸ் மூல்களை அடைய மூலம் மேலும் மேலும் அனுக்குகின்ற தொழில்நுட்ப முன்னேற்றங்கள் வளர்ந்து சென்றன - இன்னொரு நவீன விசை மனித கையின் அளவில் அதிசய பில்லியன்ஸ் மொஸ் மூல்களை கொண்டிருக்கலாம். இந்த முன்னேற்றங்கள், ஓர் பிரிவில் மூர் விதியின்படி அனுக்க மூலம் வருகின்ற, நவீன விசைகளில் இன்னும் மேலும் மேலும் மூலம் கணக்காக்குகின்றன - இன்னொரு கணினி விசை பில்லியன்ஸ் அளவுகள் மற்றும் கடந்த முதல் 1970 களில் உள்ள கணினி விசைகளின் அளவுகளின் மிகக் கண்டிப்பாக்குகளை உடைத்துவிட்டன.

IC-கள் தினிதேசிய பரிதாபங்களுக்கு மேல் இருக்கின்றன: செலவு மற்றும் செயல்பாடு. செலவு குறைந்துள்ளது காரணம், அனைத்து அமைப்புகளும் ஒரு பிரின்ட் பன்னாக பதிவிடப்படுகின்றன, அதற்கு ஒரு டிரான்ஸிஸ்டரை ஒரு செய்தனம் அமைத்திருக்கும் பதிவிடப்படும் மேல் அல்ல. கூடுதலாக, பொதுவாக தோல்வியுற்ற IC-கள் தினிதேசிய பரிதாபங்களுடன் பயன்படுத்துகின்றன. செயல்பாடு உயர் ஆகின்றது காரணம், IC-களின் அமைப்புகள் விரைவாக மாறுகின்றன மற்றும் அவைகள் சீரான அளவு மற்றும் அருப்பின்மை காரணமாக உற்பத்தியாக்குகின்றன. IC-களின் பிரமுக விளக்கத்தின் மேல் உச்சமான செலவை உருவாக்குகின்றது. இந்த உயரமான தொழில் முதல் செலவு IC-கள் உயர் உத்தமமான உத்தமங்கள் எதிர்காலம் உள்ளதால் மட்டுமே வணிக உத்தமமாக உள்ளன.

### வகைகள்
நவீன மின்னூலித்துவ பொருட்பார்வையாளர்கள் பெருமையிட்ட உள்ளீட்டு மேலைப் பொருட்களை மேம்படுத்துகின்றனர்:

- இயக்க உள்ளீடுகள் அனைத்து பொருள் உள்ளீடுகள் (போன்ற மைக்ரோப்ரோசசர்ஸ் மற்றும் மைக்ரோகண்ட்ரோல்லர்களைக் கொண்டுவருகின்றன), நினைவக உள்ளீடுகள் (MOS நினைவக மற்றும் புகட்டு நினைவக), இணைப்பு உள்ளீடுகள் (அதிகம் அடியாக்கி, சீரப்பூட்டி / விரிப்பூட்டி போன்றவை), மிகம் மற்றும் கடைக்கும் உள்ளீடுகள்.
- அனாலாக் உள்ளீடுகள் நீரப்படிய உள்ளீடுகள் மற்றும் RF உள்ளீடுகள் (ரேடியோ அதிரடி உள்ளீடுகள்).
- மிக்சர்-சிக்னல் உள்ளீடுகள் தரவு அதிரடி உள்ளீடுகள் (A/D மாற்றுநிலைப்பலகர், D/A மாற்றுநிலைப்பலகர், மற்றும் எண்ணுப்பொறியாளர்கள்), கடிகை / நேரம் உள்ளீடுகள், மாற்றப்படுத்தப்படும் விளையுறு (SC) உள்ளீடுகள், மற்றும் RF CMOS உள்ளீடுகள்.
- மூன்று அளவிடாய்க்கப்பட்ட உள்ளீடுகள் (3D உள்ளீடுகள்) மூலம் அந்தச் சிலிகான் வழி (TSV) உள்ளீடுகள் மற்றும் சினம்-சினம் இணைப்பு உள்ளீடுகள் பகுப்படுத்தப்படுகின்றன.


## [பொருள் செயல்முறை நிரூபிகம்](Object%20Oriented%20Programming/readme.md)
பொருள் சார்ந்த நிரலாக்கம் என்பது பொருள்கள் மற்றும் தரவுகளின் கருத்துகளை அடிப்படையாகக் கொண்ட ஒரு அடிப்படை நிரலாக்க முன்னுதாரணமாகும்.

குறியீட்டின் சிறந்த வாசிப்புத்திறன் மற்றும் மறுபயன்பாட்டிற்காக ஒவ்வொரு புரோகிராமரும் கடைபிடிக்க வேண்டிய குறியீட்டின் நிலையான வழி இது. 

### * பொருள் சார்ந்த நிரலாக்கத்தின் நான்கு அடிப்படை கருத்துக்கள் உள்ளன:
- சுருக்கம் 
- இணைத்தல்
- பரம்பரைச் சொத்து
- பாலிமார்பிசம் 


OOP இன் இந்த கருத்தாக்கங்களைப் பற்றி மேலும் வாசிக்க [இங்கே](Object%20Oriented%20Programming/readme.md)

## [செயல்பாட்டு நிரலாக்கம்](Functional%20Programming/readme.md)

கணினி அறிவியலில், செயல்பாட்டு நிரலாக்கம் என்பது ஒரு நிரலாக்க முன்னுதாரணமாகும், அங்கு நிரல்கள் செயல்பாடுகளைப் பயன்படுத்துவதன் மூலமும் உருவாக்குவதன் மூலமும் உருவாக்கப்படுகின்றன. இது ஒரு அறிவிப்பு நிரலாக்க முன்னுதாரணமாகும், இதில் செயல்பாட்டு வரையறைகள் என்பது நிரலின் இயங்கும் நிலையை புதுப்பிக்கும் கட்டாய அறிக்கைகளின் வரிசையை விட, மற்ற மதிப்புகளுக்கு மதிப்புகளை வரைபடமாக்கும் வெளிப்பாடுகளின் மரங்கள் ஆகும்.

செயல்பாட்டு நிரலாக்கத்தில், செயல்பாடுகள் முதல் தர குடிமக்களாகக் கருதப்படுகின்றன, அதாவது அவை வேறு எந்த தரவு வகையையும் போலவே வாதங்களாக அனுப்பப்பட்ட பெயர்களுடன் (உள்ளூர் அடையாளங்காட்டிகள் உட்பட) பிணைக்கப்படலாம், மேலும் பிற செயல்பாடுகளிலிருந்து திரும்பப் பெறலாம். இது நிரல்களை ஒரு அறிவிக்கும் மற்றும் ஒருங்கிணைக்கக்கூடிய பாணியில் எழுத அனுமதிக்கிறது, அங்கு சிறிய செயல்பாடுகள் ஒரு மட்டு முறையில் இணைக்கப்படுகின்றன.

செயல்பாட்டு நிரலாக்கம் சில நேரங்களில் முற்றிலும் செயல்பாட்டு நிரலாக்கத்துடன் ஒத்ததாக கருதப்படுகிறது, இது செயல்பாட்டு நிரலாக்கத்தின் துணைக்குழுவாகும், இது அனைத்து செயல்பாடுகளையும் தீர்மானகரமான கணித செயல்பாடுகள் அல்லது தூய செயல்பாடுகளாகக் கருதுகிறது. கொடுக்கப்பட்ட சில வாதங்களுடன் ஒரு தூய செயல்பாடு அழைக்கப்படும்போது, அது எப்போதும் அதே முடிவைத் தரும், மேலும் எந்த மாற்றக்கூடிய நிலை அல்லது பிற பக்க விளைவுகளாலும் பாதிக்கப்பட முடியாது. இது தூய்மையற்ற நடைமுறைகளுக்கு மாறாக உள்ளது, இது கட்டாய நிரலாக்கத்தில் பொதுவானது, இது பக்க விளைவுகளை ஏற்படுத்தக்கூடும் (நிரலின் நிலையை மாற்றியமைப்பது அல்லது பயனரிடமிருந்து உள்ளீட்டை எடுத்துக்கொள்வது போன்றவை) முற்றிலும் செயல்பாட்டு நிரலாக்கத்தின் ஆதரவாளர்கள், பக்க விளைவுகளைக் கட்டுப்படுத்துவதன் மூலம், நிரல்கள் குறைவான பிழைகளைக் கொண்டிருக்கலாம், பிழைத்திருத்தம் மற்றும் சோதனை செய்ய எளிதாக இருக்கும், மேலும் முறையான சரிபார்ப்பு நடைமுறைகளுக்கு மிகவும் பொருத்தமானதாக இருக்கும் என்று கூறுகின்றனர்.

செயல்பாட்டு நிரலாக்கம் கல்வித்துறையில் அதன் வேர்களைக் கொண்டுள்ளது, இது செயல்பாடுகளை மட்டுமே அடிப்படையாகக் கொண்ட முறையான கணக்கீட்டு அமைப்பான லாம்ப்டா கால்குலஸிலிருந்து உருவாகிறது. செயல்பாட்டு நிரலாக்கம் வரலாற்று ரீதியாக கட்டாய நிரலாக்கத்தை விட குறைவாகவே பிரபலமாக உள்ளது, ஆனால் பல செயல்பாட்டு மொழிகள் இன்று தொழில் மற்றும் கல்வியில் பயன்படுத்தப்படுகின்றன. 

செயல்பாட்டு நிரலாக்க மொழிகளின் சில எடுத்துக்காட்டுகள்:
- <a href="https://lisp-lang.org/"> காமன் லிஸ்ப் </a>
- <a href="https://www.scheme.org/"> ஸ்கிம் </a>
- <a href="https://racket-lang.org/"> ராக்கெட் </a>
- <a href="https://www.erlang.org/"> ஏர்லாங் </a>
- <a href="https://www.haskell.org/"> ஹாஸ்கெல் </a>
- <a href="https://fsharp.org/"> F# </a>
- <a href="https://cs.lmu.edu/~ray/notes/introml/"> ML </a> 

செயல்பாட்டு நிரலாக்கம் வரலாற்று ரீதியாக * லாம்ப்டா கால்குலஸ் * இலிருந்து பெறப்பட்டது. லாம்ப்டா கால்குலஸ் என்பது செயல்பாடுகளுடன் கணக்கீடுகளைப் படிக்க அலோன்சோ சர்ச் உருவாக்கிய ஒரு கட்டமைப்பாகும். இது பெரும்பாலும் "உலகின் மிகச்சிறிய நிரலாக்க மொழி" என்று அழைக்கப்படுகிறது. இது என்ன கணக்கிடக்கூடியது, எது இல்லை என்பதற்கான வரையறையை வழங்குகிறது. இது ஒரு டூரிங் இயந்திரத்தின் கணக்கீட்டு திறனுக்கு சமமானது மற்றும் டூரிங் இயந்திரத்தால் கணக்கிடக்கூடிய எதையும் போலவே லாம்ப்டா கால்குலஸால் கணக்கிடக்கூடிய எதுவும் கணக்கிடக்கூடியது. இது செயல்பாடுகள் மற்றும் அவற்றின் மதிப்பீடுகளை விவரிப்பதற்கான ஒரு தத்துவார்த்த கட்டமைப்பை வழங்குகிறது.

செயல்பாட்டு நிரலாக்கத்தின் சில அத்தியாவசிய கருத்துக்கள்ஃ
- தூய செயல்பாடுகள் 
- மறுசுழற்சி
- குறிப்பு பரிமாற்றம்
- முதல் வகுப்பு மற்றும் உயர் வரிசை செயல்பாடுகளாக செயல்பாடுகள்
- மாறிகள் மாறாதவை.

**தூய செயல்பாடுகள்**: இந்த செயல்பாடுகள் இரண்டு முக்கிய பண்புகளைக் கொண்டுள்ளன. முதலாவதாக, அவை எப்போதும் வேறு எதையும் பொருட்படுத்தாமல் ஒரே வாதங்களுக்கு ஒரே வெளியீட்டை உருவாக்குகின்றன. இரண்டாவதாக, அவை எந்த பக்க விளைவுகளையும் ஏற்படுத்தாது. i.e. அவை எந்த வாதங்களையும் அல்லது உள்ளூர்/உலகளாவிய மாறி அல்லது உள்ளீடு/வெளியீட்டு ஸ்ட்ரீம்களையும் மாற்றாது. பிந்தைய பண்பு * மாறாத தன்மை * என்று அழைக்கப்படுகிறது. தூய செயல்பாட்டின் ஒரே முடிவு அது திரும்பும் மதிப்பாகும். அவை தீர்மானகரமானவை. செயல்பாட்டு நிரலாக்கத்தைப் பயன்படுத்தி செய்யப்படும் நிரல்கள் பக்க விளைவுகள் அல்லது மறைக்கப்பட்ட I/O இல்லாததால் அவற்றை பிழைத்திருத்தம் செய்வது எளிது. தூய செயல்பாடுகள் பார்ரேல்/கன்குரன்ட் பயன்பாடுகளை எழுதுவதை எளிதாக்குகின்றன. குறியீடு இந்த பாணியில் எழுதப்படும்போது, ஒரு ஸ்மார்ட் கம்பைலர் பல விஷயங்களைச் செய்ய முடியும்-இது அறிவுறுத்தல்களை இணையாக்கலாம், தேவைப்படும் வரை முடிவுகளை மதிப்பீடு செய்ய காத்திருக்கலாம் மற்றும் உள்ளீடு மாறாத வரை முடிவுகள் ஒருபோதும் மாறாது என்பதால் முடிவுகளை மனப்பாடம் செய்யலாம். பைத்தானில் தூய செயல்பாட்டின் எளிய எடுத்துக்காட்டு இங்கே:

```python
def sum(x ,y): # சம் என்பது x மற்றும் y ஐ வாதங்களாக எடுத்துக் கொள்ளும் ஒரு செயல்பாடு
    return x + y  # மதிப்பை மாற்றாமல் x + y தருகிறது
 ```

**மறுசுழற்சி**: தூய செயல்பாட்டு நிரலாக்க மொழிகளில் "for" அல்லது "while" சுழல்கள் இல்லை. மறுசுழற்சி மூலம் மறுசுழற்சி செயல்படுத்தப்படுகிறது. ஒரு அடிப்படை வழக்கை அடையும் வரை தொடர்ச்சியான செயல்பாடுகள் மீண்டும் மீண்டும் தங்களை அழைக்கிறது. C இல் ஒரு மறுநிகழ்வு செயல்பாட்டின் எளிய எடுத்துக்காட்டு இங்கே:

```c
int fib(n) {
  if(n <= 1)
    return 1;
   else
     return (fib(n-1) + fib(n-2));
}
 ```
**குறிப்பு வெளிப்படைத்தன்மை**: செயல்பாட்டு நிரல்களில், ஒரு முறை வரையறுக்கப்பட்ட மாறிகள் நிரல் முழுவதும் அவற்றின் மதிப்பை மாற்றாது.
செயல்பாட்டு நிரல்களுக்கு அசைன்மென்ட் அறிக்கைகள் இல்லை. நாம் சில மதிப்பை சேமிக்க வேண்டும் என்றால், அதற்கு பதிலாக ஒரு புதிய மாறியை வரையறுக்கிறோம். இது பக்க விளைவுகளின் எந்தவொரு வாய்ப்பையும் நீக்குகிறது, ஏனெனில் எந்தவொரு மாறியையும் செயல்படுத்தும் எந்த கட்டத்திலும் அதன் உண்மையான மதிப்புடன் மாற்ற முடியும். எந்தவொரு மாறுபாட்டின் நிலையும் எந்த நேரத்திலும் நிலையானது. உதாரணம்:
```bash
x = x + 1 # இது மாறக்கூடிய x க்கு ஒதுக்கப்பட்ட மதிப்பை மாற்றியது
         # எனவே, வெளிப்பாடு குறிப்பிடும் வகையில் வெளிப்படையானது அல்ல
```

**செயல்பாடுகள் முதல் தரமானவை மற்றும் உயர் வரிசையில் இருக்கலாம்**: முதல் வகுப்பு செயல்பாடுகள் முதல் வகுப்பு மாறிகளாக கருதப்படுகின்றன. முதல் வகுப்பு மாறிகள் செயல்பாடுகளுக்கு அளவுருக்களாக அனுப்பப்படலாம், செயல்பாடுகளிலிருந்து திருப்பித் தரப்படலாம் அல்லது தரவு கட்டமைப்புகளில் சேமிக்கப்படலாம்.
         
செயல்பாட்டு பயன்பாடுகளின் கலவையை **funcall** எனப்படும் LISP படிவத்தைப் பயன்படுத்தி வரையறுக்கலாம், இது வாதங்களை ஒரு செயல்பாடு மற்றும் தொடர்ச்சியான வாதங்களாக எடுத்து அந்த வாதங்களுக்கு அந்த செயல்பாட்டைப் பயன்படுத்துகிறது:

```Lisp
(defun filter (list-of-elements test)
    (cond ((null list-of-elements) nil)
          ((funcall test (car list-of-elements))
            (cons (car list-of-elements)
                (filter (cdr list-of-elements)
                      test)))
           (t (filter (cdr list-of-elements)
                       test))))
   ```
  செயல்பாடு **filter** பட்டியலின் முதல் உறுப்புக்கு சோதனையைப் பயன்படுத்துகிறது. சோதனை பூஜ்யம் அல்லாததை திருப்பினால், அது பட்டியலின் cdr இல் பயன்படுத்தப்படும் வடிப்பானின் ரெசூலில் உறுப்பை இணைக்கிறது; இல்லையெனில், அது வடிகட்டப்பட்ட cdr ஐத் திருப்பித் தருகிறது. பல்வேறு வடிகட்டுதல் பணிகளைச் செய்ய அளவுருக்களாக அனுப்பப்பட்ட வெவ்வேறு கணிப்புகளுடன் இந்த செயல்பாடு பயன்படுத்தப்படலாம்:

```Lisp
    > (filter '(1 3 -9 5 -2 -7 6) #'plusp)   ; filter out all negative numbers 
```    
    output: (1 3 5 6)

```Lisp
   > (filter '(1 2 3 4 5 6 7 8 9) #'evenp)   ; filter out all odd numbers
```   
   output: (2 4 6 8)

   and so on.

**மாறிகள் மாறாதவை**: செயல்பாட்டு நிரலாக்கத்தில், பீம் துவக்கப்பட்ட பிறகு ஒரு மாறியை நாம் மாற்ற முடியாது.
நாம் புதிய மாறிகளை உருவாக்க முடியும்-ஆனால் ஏற்கனவே உள்ள மாறியை நாம் மாற்ற முடியாது, மேலும் இது ஒரு நிரலின் இயக்க நேரம் முழுவதும் நிலையை பராமரிக்க உதவுகிறது. ஒரு மாறி மற்றும் அதன் மதிப்பை அமைத்தவுடன், அந்த மாறியின் மதிப்பு ஒருபோதும் மாறாது என்பதை அறிந்து முழு நம்பிக்கையுடன் இருக்க முடியும்.

## [இயக்க முறைமைகள்](Operating%20Systems/readme.md)
ஒரு இயக்க முறைமை (அல்லது சுருக்கமாக OS) ஒரு கணினி பயனர் மற்றும் கணினி வன்பொருள் இடையே ஒரு இடைத்தரகராக செயல்படுகிறது. ஒரு இயக்க முறைமையின் நோக்கம் ஒரு பயனர் நிரல்களை வசதியாகவும் திறமையாகவும் செயல்படுத்தக்கூடிய சூழலை வழங்குவதாகும்.
இயக்க முறைமை என்பது கணினி வன்பொருளை நிர்வகிக்கும் மென்பொருள் ஆகும். கணினி அமைப்பின் சரியான செயல்பாட்டை உறுதி செய்வதற்கும், கணினியின் சரியான செயல்பாட்டில் பயனர் நிரல்கள் தலையிடுவதைத் தடுப்பதற்கும் வன்பொருள் பொருத்தமான வழிமுறைகளை வழங்க வேண்டும்.
இன்னும் பொதுவான வரையறை என்னவென்றால், இயக்க முறைமை என்பது கணினியில் எல்லா நேரங்களிலும் இயங்கும் ஒரே நிரலாகும் (பொதுவாக கர்னல் என்று அழைக்கப்படுகிறது) மற்ற அனைத்தும் பயன்பாட்டு நிரல்களாக இருக்கும்.

இயக்க முறைமைகளை இரண்டு கண்ணோட்டங்களில் இருந்து பார்க்கலாம்ஃ வள மேலாளர்கள் மற்றும் நீட்டிக்கப்பட்ட இயந்திரங்கள். வள மேலாளர் பார்வையில், இயக்க முறைமையின் வேலை அமைப்பின் பல்வேறு பகுதிகளை திறம்பட நிர்வகிப்பதாகும். நீட்டிக்கப்பட்ட இயந்திர பார்வையில், கணினியின் வேலை பயனர்களுக்கு உண்மையான இயந்திரத்தை விட பயன்படுத்த மிகவும் வசதியான சுருக்கங்களை வழங்குவதாகும். இதில் செயல்முறைகள், முகவரி இடங்கள் மற்றும் கோப்புகள் அடங்கும்.
இயக்க முறைமைகள் ஒரு நீண்ட வரலாற்றைக் கொண்டுள்ளன, அவை ஆபரேட்டருக்கு பதிலாக நவீன பல நிரலாக்க அமைப்புகளுக்கு மாற்றப்பட்டன. 
ஆரம்பகால தொகுதி அமைப்புகள், பல நிரலாக்க அமைப்புகள் மற்றும் தனிப்பட்ட கணினி அமைப்புகள் ஆகியவை சிறப்பம்சங்களில் அடங்கும்.
இயக்க முறைமைகள் வன்பொருளுடன் நெருக்கமாக தொடர்பு கொள்வதால், கணினி வன்பொருள் பற்றிய சில அறிவு அவற்றைப் புரிந்துகொள்ள பயனுள்ளதாக இருக்கும். கணினிகள் செயலிகள், நினைவுகள் மற்றும் I/O சாதனங்களால் கட்டமைக்கப்பட்டுள்ளன. இந்தப் பகுதிகள் பேருந்துகள் மூலம் இணைக்கப்பட்டுள்ளன.
அனைத்து இயக்க முறைமைகளும் கட்டமைக்கப்பட்டுள்ள அடிப்படை கருத்துக்கள் செயல்முறைகள், நினைவக மேலாண்மை, I/O மேலாண்மை, கோப்பு முறைமை மற்றும் பாதுகாப்பு ஆகும். எந்தவொரு இயக்க முறைமையின் இதயம் அது கையாளக்கூடிய கணினி அழைப்புகளின் தொகுப்பாகும்.
இயக்க முறைமை என்ன செய்கிறது என்பதை இவை தெரிவிக்கின்றன.

### வள மேலாளராக இயக்க முறைமை
இயக்க முறைமை ஒரு சிக்கலான அமைப்பின் அனைத்து பகுதிகளையும் நிர்வகிக்கிறது. நவீன கணினிகள் செயலிகள், நினைவுகள், டைமர்கள், வட்டுகள், எலிகள், நெட்வொர்க் இடைமுகங்கள், அச்சுப்பொறிகள் மற்றும் பல்வேறு வகையான பிற சாதனங்களைக் கொண்டுள்ளன. 
பாட்டம்-அப் பார்வையில், இயக்க முறைமையின் வேலை, அவை விரும்பும் பல்வேறு நிரல்களுக்கு இடையில் செயலிகள், நினைவுகள் மற்றும் I/O சாதனங்களின் ஒழுங்கான மற்றும் கட்டுப்படுத்தப்பட்ட ஒதுக்கீட்டை வழங்குவதாகும்.
நவீன இயக்க முறைமைகள் பல நிரல்களை நினைவகத்தில் இருக்கவும் ஒரே நேரத்தில் இயக்கவும் அனுமதிக்கின்றன. சில கணினிகளில் இயங்கும் மூன்று நிரல்கள் அனைத்தும் ஒரே அச்சுப்பொறியில் ஒரே நேரத்தில் தங்கள் வெளியீட்டை அச்சிட முயற்சித்தால் என்ன நடக்கும் என்று கற்பனை செய்து பாருங்கள்.
இதன் விளைவாக முற்றிலும் குழப்பம் ஏற்படும். இயக்க முறைமை வட்டில் உள்ள அச்சுப்பொறிக்கு நிர்ணயிக்கப்பட்ட அனைத்து வெளியீட்டையும் இடையகப்படுத்துவதன் மூலம் சாத்தியமான குழப்பத்திற்கு ஒழுங்கை கொண்டு வர முடியும். 
ஒரு நிரல் முடிந்ததும், இயக்க முறைமை அதன் வெளியீட்டை அச்சுப்பொறிக்கு சேமித்து வைக்கப்பட்ட வட்டு கோப்பில் இருந்து நகலெடுக்க முடியும், அதே நேரத்தில், மற்ற நிரல் அதிக வெளியீட்டை தொடர்ந்து உருவாக்க முடியும், வெளியீடு இல்லை என்ற உண்மையை மறந்துவிடுகிறது அச்சுப்பொறிக்கு செல்லவில்லை (yet).
ஒரு கணினி (அல்லது நெட்வொர்க்) ஒன்றுக்கு மேற்பட்ட பயனர்களைக் கொண்டிருக்கும்போது, நினைவகம், ஐ/ஓ சாதனங்கள் மற்றும் பிற வளங்களை நிர்வகிக்கவும் பாதுகாக்கவும் தேவைப்படுகிறது, ஏனெனில் பயனர்கள் ஒருவருக்கொருவர் தலையிடக்கூடும். கூடுதலாக, பயனர்கள் பெரும்பாலும் வன்பொருள் மட்டுமல்ல, தகவல்களையும் பகிர்ந்து கொள்ள வேண்டும். (files, databases, etc.). சுருக்கமாக, இயக்க முறைமையின் இந்த பார்வை, எந்த நிரல்கள் எந்த வளத்தைப் பயன்படுத்துகின்றன என்பதைக் கண்காணிப்பது, வள கோரிக்கைகளை வழங்குவது, பயன்பாட்டிற்காக கணக்கிடுவது மற்றும் வெவ்வேறு நிரல்கள் மற்றும் பயனர்களிடமிருந்து முரண்பட்ட கோரிக்கைகளை மத்தியஸ்தம் செய்வது ஆகியவை அதன் முதன்மை பணியாகும்.

### நீட்டிக்கப்பட்ட இயந்திரமாக இயக்க முறைமை
இயந்திர மொழி மட்டத்தில் பெரும்பாலான கணினிகளின் கட்டமைப்பு பழமையானது மற்றும் நிரலுக்கு சங்கடமானது, குறிப்பாக உள்ளீடு/வெளியீட்டிற்கு. இந்த கருத்தை மேலும் உறுதியாக்க, பெரும்பாலான கணினிகளில் பயன்படுத்தப்படும் நவீன SATA (சீரியல் ATA) ஹார்ட் டிஸ்க்குகளைக் கவனியுங்கள். வட்டைப் பயன்படுத்த ஒரு புரோகிராமர் என்ன தெரிந்து கொள்ள வேண்டும். 
அப்போதிருந்து, இடைமுகம் பல முறை திருத்தப்பட்டுள்ளது மற்றும் 2007 இல் இருந்ததை விட மிகவும் சிக்கலானது. எந்தவொரு புத்திசாலித்தனமான புரோகிராமரும் வன்பொருள் மட்டத்தில் இந்த வட்டைக் கையாள விரும்ப மாட்டார்கள். 
அதற்கு பதிலாக, வட்டு இயக்கி என்று அழைக்கப்படும் ஒரு மென்பொருள் வன்பொருளைக் கையாள்கிறது மற்றும் விவரங்களுக்குள் செல்லாமல் வட்டு தொகுதிகளைப் படிக்கவும் எழுதவும் ஒரு இடைமுகத்தை வழங்குகிறது. 
இயக்க முறைமைகளில் I/O சாதனங்களைக் கட்டுப்படுத்த பல இயக்கிகள் உள்ளன.
ஆனால் இந்த நிலை கூட பெரும்பாலான பயன்பாடுகளுக்கு மிகவும் குறைவாக உள்ளது. இந்த காரணத்திற்காக, அனைத்து இயக்க முறைமைகளும் வட்டுகளைப் பயன்படுத்துவதற்கான சுருக்கத்தின் மற்றொரு அடுக்கை வழங்குகின்றனஃ கோப்புகள்.
இந்த சுருக்கத்தைப் பயன்படுத்தி, வன்பொருள் எவ்வாறு செயல்படுகிறது என்பதற்கான குழப்பமான விவரங்களைக் கையாளாமல் நிரல்கள் கோப்புகளை உருவாக்கலாம், எழுதலாம் மற்றும் படிக்கலாம்.
இந்த சிக்கலான அனைத்தையும் நிர்வகிப்பதற்கான திறவுகோலாக இந்த சுருக்கம் உள்ளது. நல்ல சுருக்கங்கள் கிட்டத்தட்ட சாத்தியமற்ற பணியை நிர்வகிக்கக்கூடிய இரண்டு பணிகளாக மாற்றுகின்றன. முதலாவது சுருக்கங்களை வரையறுத்து செயல்படுத்துவதாகும். இரண்டாவது, கையில் உள்ள சிக்கலைத் தீர்க்க இந்த சுருக்கங்களைப் பயன்படுத்துவது.

### இயக்க முறைமைகளின் வரலாறு
- **முதல் தலைமுறை (1945-55)**: இரண்டாம் உலகப் போர் சகாப்தம் வரை பாபேஜின் பேரழிவு முயற்சிகளுக்குப் பிறகு டிஜிட்டல் கணினிகளை உருவாக்குவதில் சிறிய முன்னேற்றம் அடையப்பட்டது. அயோவா மாநில பல்கலைக்கழகத்தில், பேராசிரியர் ஜான் அடனசாஃப் மற்றும் அவரது பட்டதாரி மாணவர் கிளிஃபோர்ட் பெர்ரி ஆகியோர் இன்று முதல் செயல்பாட்டு டிஜிட்டல் கணினியாக அங்கீகரிக்கப்பட்டதை உருவாக்கினர். பெர்லினில் உள்ள கொன்ராட் சூஸ் அதே நேரத்தில் எலக்ட்ரோ மெக்கானிக்கல் ரிலேக்களைப் பயன்படுத்தி Z3 கணினியை உருவாக்கினார். மார்க் I ஹார்வர்டில் ஹோவர்ட் ஐக்கனால் உருவாக்கப்பட்டது, இங்கிலாந்தில் உள்ள பிளெட்ச்லி பூங்காவில் உள்ள விஞ்ஞானிகள் குழுவால் கொலோசஸ் உருவாக்கப்பட்டது, மற்றும் 1944 இல் பென்சில்வேனியா பல்கலைக்கழகத்தில் வில்லியம் மோக்லி மற்றும் அவரது முனைவர் மாணவர் ஜே. பிரஸ்பர் எக்கர்ட் ஆகியோரால் ENIAC உருவாக்கப்பட்டது.

- **இரண்டாம் தலைமுறை (1955-65)**: 1950 களின் நடுப்பகுதியில் டிரான்சிஸ்டரின் கண்டுபிடிப்பு நிலைமையை கடுமையாக மாற்றியது. கணினிகள் நம்பகமானவையாக மாறின, அவை சில அர்த்தமுள்ள வேலைகளைச் செய்ய நீண்ட நேரம் வேலை செய்யும் என்ற அனுமானத்துடன் அவற்றை உற்பத்தி செய்து பணம் செலுத்தும் வாடிக்கையாளர்களுக்கு விற்க முடியும். மெயின்ஃப்ரேம்கள், இப்போது அறியப்பட்டபடி, பெரிய, குறிப்பாக குளிரூட்டப்பட்ட கணினி அறைகளில் பூட்டப்பட்டு, அவற்றை நிர்வகிக்க தகுதி வாய்ந்த ஆபரேட்டர்களின் குழுக்களுடன் வைக்கப்பட்டன. பெரிய வணிகங்கள், குறிப்பிடத்தக்க அரசு நிறுவனங்கள் அல்லது நிறுவனங்கள் மட்டுமே பல மில்லியன் டாலர்கள் என்ற விலைக் குறியீட்டை வாங்க முடியும்.

- **மூன்றாம் தலைமுறை (1965-80)**: தனிப்பட்ட டிரான்சிஸ்டர்களிலிருந்து கட்டப்பட்ட இரண்டாம் தலைமுறை கணினிகளுடன் ஒப்பிடுகையில், ஐபிஎம் 360 ஆனது (சிறிய அளவிலான) ஐ. சி. க்களைப் பயன்படுத்திய முதல் பெரிய கணினி வரிசையாகும். (Integrated Circuits). இதன் விளைவாக, இது குறிப்பிடத்தக்க விலை/செயல்திறன் நன்மையை வழங்கியது. இது ஒரு உடனடி வெற்றியாக இருந்தது, மற்ற அனைத்து பெரிய உற்பத்தியாளர்களும் விரைவாக இயங்கக்கூடிய கணினிகளின் குடும்பத்தின் கருத்தை ஏற்றுக்கொண்டனர். ஓஎஸ்/360 இயக்க முறைமை உட்பட அனைத்து மென்பொருள்களும் அசல் வடிவமைப்பில் உள்ள அனைத்து மாடல்களுடனும் இணக்கமாக இருக்க வேண்டும். இது பெரிய அமைப்புகளில் இயங்க வேண்டியிருந்தது, இது அடிக்கடி 7094 களுக்கு பதிலாக கனமான கணக்கீடு மற்றும் வானிலை முன்னறிவிப்புக்காக மாற்றப்பட்டது, மேலும் சிறிய அமைப்புகள், பெரும்பாலும் அட்டைகளை நாடாக்கு மாற்றுவதற்காக 1401 களுக்கு பதிலாக மாற்றப்பட்டன. சில பெரிஃபெரல்களைக் கொண்ட இரண்டு அமைப்புகளும், பல பெரிஃபெரல்களைக் கொண்ட அமைப்புகளும் அதனுடன் நன்றாக செயல்பட வேண்டும். இது தொழில்முறை மற்றும் கல்வி அமைப்புகளில் செயல்பட வேண்டியிருந்தது. எல்லாவற்றிற்கும் மேலாக, இந்த பல பயன்பாடுகள் ஒவ்வொன்றிற்கும் இது பயனுள்ளதாக இருக்க வேண்டும்.

- **நான்காம் தலைமுறை (1980-தற்போது வரை)**: தனிநபர் கணினி சகாப்தம் எல். எஸ். ஐ (பெரிய அளவிலான ஒருங்கிணைப்பு) சுற்றுகள், சிலிக்கானின் ஒரு சதுர சென்டிமீட்டரில் ஆயிரக்கணக்கான டிரான்சிஸ்டர்களைக் கொண்ட செயலிகள் உருவாக்கத்துடன் தொடங்கியது. முதலில் மைக்ரோகம்ப்யூட்டர்கள் என்று அழைக்கப்பட்ட தனிநபர் கணினிகள், பி. டி. பி-11 வகுப்பின் மினிகம்ப்யூட்டர்களிடமிருந்து கட்டமைப்பில் குறிப்பிடத்தக்க மாற்றத்தை ஏற்படுத்தவில்லை என்றாலும், அவை விலையில் கணிசமாக வேறுபட்டன.


- **ஐந்தாம் தலைமுறை (1990-தற்போது வரை)**: 1940 களின் காமிக் ஸ்ட்ரிப் துப்பறியும் டிக் ட்ரேசி தனது "இரு வழி வானொலி கைக்கடிகாரத்துடன்" உரையாடத் தொடங்கியதிலிருந்து மக்கள் ஒரு சிறிய தகவல்தொடர்பு சாதனத்திற்காக ஏங்கி வருகின்றனர். 1946 ஆம் ஆண்டில், ஒரு உண்மையான மொபைல் போன் அறிமுகமானது, அது சுமார் 40 கிலோகிராம் எடையைக் கொண்டிருந்தது. முதல் உண்மையான கையடக்க தொலைபேசி 1970 களில் அறிமுகமானது மற்றும் நம்பமுடியாத அளவிற்கு ஒரு கிலோகிராம் எடை கொண்டது. இது நகைச்சுவையாக "செங்கல்" என்று குறிப்பிடப்பட்டது. விரைவில், அனைவரும் ஒன்றுக்காக கூச்சலிட்டனர்.

### ஒரு OS இன் செயல்பாடுகள்
- **வசதி**: ஒரு ஓஎஸ் ஒரு கணினியைப் பயன்படுத்த மிகவும் வசதியாக இருக்கும்.
- **செயல்திறன்**: கணினி அமைப்பு வளங்களை திறம்பட பயன்படுத்த ஒரு OS அனுமதிக்கிறது.
- **உருவாகும் திறன்**: சேவையில் தலையிடாமல் ஒரே நேரத்தில் புதிய கணினி செயல்பாடுகளை திறம்பட மேம்படுத்துதல், சோதனை செய்தல் மற்றும் அறிமுகப்படுத்துவதை அனுமதிக்கும் வகையில் ஒரு OS கட்டமைக்கப்பட வேண்டும்.
- **செயல்திறன்**: அதிகபட்ச செயல்திறனை வழங்கக்கூடிய வகையில் ஒரு OS கட்டமைக்கப்பட வேண்டும்(Number of tasks per unit time).

### ஒரு OS இன் முக்கிய செயல்பாடுகள்
- **வள மேலாண்மை**: OS இல் இணையான அணுகல் நிகழும்போது, பல பயனர்கள் கணினியை அணுகும்போது, OS ஒரு வள மேலாளராக செயல்படுகிறது. பயனருக்கு வன்பொருளை வழங்குவதே அதன் பொறுப்பு. இது அமைப்பில் சுமையைக் குறைக்கிறது.
- **செயல்முறை மேலாண்மை**: இது திட்டமிடல் மற்றும் செயல்முறையை நிறுத்துதல் போன்ற பல்வேறு பணிகளை உள்ளடக்கியது. ஓஎஸ் ஒரே நேரத்தில் பல்வேறு பணிகளை நிர்வகிக்கிறது. இங்கே CPU திட்டமிடல் நிகழ்கிறது என்றால் அனைத்து பணிகளும் திட்டமிடலுக்குப் பயன்படுத்தும் பல வழிமுறைகளால் செய்யப்படும்.
- **சேமிப்பக மேலாண்மை**: சேமிப்பகத்தை நிர்வகிக்க பயன்படுத்தப்படும் கோப்பு முறைமை பொறிமுறை. என்ஐஎஃப்எஸ், சிஎஃப்எஸ், சிஐஎஃப்எஸ், என்எஃப்எஸ் போன்றவை. சில கோப்பு அமைப்புகள் உள்ளன. அனைத்து தரவுகளும் சேமிப்பக மேலாளரால் நிர்வகிக்கப்படும் ஹார்ட் டிஸ்க்குகளின் பல்வேறு தடங்களில் சேமிக்கப்படுகின்றன. இதில் ஹார்ட் டிஸ்க் அடங்கும்.
- **நினைவக மேலாண்மை**: முதன்மை நினைவகத்தை நிர்வகிப்பதைக் குறிக்கிறது. இயக்க முறைமை எவ்வளவு நினைவகம் பயன்படுத்தப்பட்டுள்ளது, யாரால் பயன்படுத்தப்பட்டது என்பதைக் கண்காணிக்க வேண்டும். எந்த செயல்முறைக்கு நினைவக இடம் தேவை, எவ்வளவு என்பதை அது தீர்மானிக்க வேண்டும். ஓஎஸ் நினைவக இடத்தை ஒதுக்கி நீக்க வேண்டும்
- **பாதுகாப்பு/தனியுரிமை மேலாண்மை**: கடவுச்சொற்களைப் பயன்படுத்தி இயக்க முறைமையால் தனியுரிமை வழங்கப்படுகிறது, இதனால் அங்கீகரிக்கப்படாத பயன்பாடுகள் நிரல்கள் அல்லது தரவை அணுக முடியாது. எடுத்துக்காட்டாக, தரவுகளுக்கான அங்கீகரிக்கப்படாத அணுகலைத் தடுக்க விண்டோஸ் **_ Kerberos _** அங்கீகாரத்தைப் பயன்படுத்துகிறது.

### இயக்க முறைமைகளின் வகைகள்
- **மெயின்ஃப்ரேம் OS**:
உயர்மட்டத்தில் மெயின்ஃப்ரேம்களுக்கான இயக்க முறைமைகள் உள்ளன, அந்த அறை அளவிலான கணினிகள் இன்னும் முக்கிய கார்ப்பரேட் தரவு மையங்களில் காணப்படுகின்றன. இந்த கணினிகள் அவற்றின் I/O திறனைப் பொறுத்தவரை தனிப்பட்ட கணினிகளிலிருந்து வேறுபடுகின்றன. 1000 வட்டுகள் மற்றும் மில்லியன் கணக்கான ஜிகாபைட் தரவு கொண்ட ஒரு மெயின்ஃப்ரேம் அசாதாரணமானது அல்ல; இந்த விவரக்குறிப்புகளைக் கொண்ட ஒரு தனிப்பட்ட கணினி அதன் நண்பர்களின் பொறாமையாக இருக்கும். மெயின்ஃப்ரேம்களும் சிலவற்றைச் செய்கின்றன-உயர்நிலை வலை சேவையகங்கள், பெரிய அளவிலான மின்னணு வர்த்தக தளங்களுக்கான சேவையகங்கள் மற்றும் வணிகத்திலிருந்து வணிக பரிவர்த்தனைகளுக்கான சேவையகங்கள்.
மெயின்ஃப்ரேம்களுக்கான இயக்க முறைமைகள் பல வேலைகளை ஒரே நேரத்தில் செயலாக்குவதை நோக்கமாகக் கொண்டுள்ளன, அவற்றில் பெரும்பாலானவை ஏராளமான ஐ/ஓ தேவைப்படுகின்றன. அவை பொதுவாக மூன்று வகையான சேவைகளை வழங்குகின்றனஃ தொகுதி, பரிவர்த்தனை செயலாக்கம் மற்றும் நேர பகிர்வு.

- **சர்வர் ஓஎஸ்**: ஒரு நிலை கீழே சர்வர் இயக்க முறைமைகள். அவை மிகப் பெரிய தனிநபர் கணினிகள், பணிநிலையங்கள் அல்லது மெயின்ஃப்ரேம்களாக இருக்கும் சேவையகங்களில் இயங்குகின்றன. அவை ஒரு நெட்வொர்க்கில் ஒரே நேரத்தில் பல பயனர்களுக்கு சேவை செய்கின்றன, மேலும் பயனர்கள் வன்பொருள் மற்றும் மென்பொருள் வளங்களைப் பகிர்ந்து கொள்ள அனுமதிக்கின்றன. சேவையகங்கள் அச்சு சேவை, கோப்பு சேவை அல்லது வலை சேவையை வழங்கலாம். 
இணைய வழங்குநர்கள் தங்கள் வாடிக்கையாளர்களுக்கு ஆதரவளிக்க பல சேவையக இயந்திரங்களை இயக்குகிறார்கள், மேலும் வலைத்தளங்கள் வலைப்பக்கங்களை சேமிக்கவும் உள்வரும் கோரிக்கைகளை கையாளவும் சேவையகங்களைப் பயன்படுத்துகின்றன.
வழக்கமான சேவையக இயக்க முறைமைகள் சோலாரிஸ், ஃப்ரீபிஎஸ்டி, லினக்ஸ் மற்றும் விண்டோஸ் சர்வர் 201 எக்ஸ் ஆகும்.


- **மல்டி பிராசஸர் ஓஎஸ்**: மேஜர்-லீக் கம்ப்யூட்டிங் சக்தியைப் பெறுவதற்கான ஒரு பொதுவான வழி பல சிபியுக்களை ஒரே அமைப்பில் இணைப்பதாகும். 
துல்லியமாக அவை எவ்வாறு இணைக்கப்பட்டுள்ளன மற்றும் பகிரப்படுகின்றன என்பதைப் பொறுத்து, இந்த அமைப்புகள் இணையான கணினிகள், பல கணினிகள் அல்லது பல செயலிகள் என்று அழைக்கப்படுகின்றன. 
அவர்களுக்கு சிறப்பு இயக்க முறைமைகள் தேவை, ஆனால் பெரும்பாலும் இவை சேவையக இயக்க முறைமைகளில் உள்ள மாறுபாடுகள், தகவல் தொடர்பு, இணைப்பு மற்றும் நிலைத்தன்மைக்கான சிறப்பு அம்சங்களுடன்.


- **தனிநபர் கணினி OS**: அடுத்த வகை தனிநபர் கணினி இயக்க முறைமை. நவீன திட்டங்கள் அனைத்தும் பல நிரலாக்கத்தை ஆதரிக்கின்றன, பெரும்பாலும் துவக்க நேரத்தில் டஜன் கணக்கான நிரல்கள் தொடங்கப்படுகின்றன.
ஒரு பயனருக்கு நல்ல ஆதரவை வழங்குவதே அவர்களின் வேலை. அவை சொல் செயலாக்கம், விரிதாள்கள், விளையாட்டுகள் மற்றும் இணைய அணுகலுக்கு பரவலாகப் பயன்படுத்தப்படுகின்றன. லினக்ஸ், ஃப்ரீபிஎஸ்டி, விண்டோஸ் 7, விண்டோஸ் 8 மற்றும் ஆப்பிளின் ஓஎஸ் எக்ஸ் ஆகியவை பொதுவான எடுத்துக்காட்டுகளாகும். தனிநபர் கணினி இயக்க முறைமைகள் மிகவும் பரவலாக அறியப்பட்டதால், ஒருவேளை சிறிய அறிமுகம் தேவைப்படுகிறது.
மற்ற வகைகள் உள்ளன என்பது கூட பலருக்குத் தெரியாது.


- **உட்பொதிக்கப்பட்ட OS**: உட்பொதிக்கப்பட்ட அமைப்புகள் பொதுவாக கணினிகளாக கருதப்படாத மற்றும் பயனர் நிறுவிய மென்பொருளை ஏற்காத சாதனங்களைக் கட்டுப்படுத்தும் கணினிகளில் இயங்குகின்றன.
மைக்ரோவேவ் அடுப்புகள், டிவி செட்டுகள், கார்கள், டிவிடி ரெக்கார்டர்கள், பாரம்பரிய தொலைபேசிகள் மற்றும் எம்பி 3 பிளேயர்கள் ஆகியவை பொதுவான எடுத்துக்காட்டுகளாகும். உட்பொதிக்கப்பட்ட அமைப்புகளை கையடக்க சாதனங்களிலிருந்து வேறுபடுத்தும் முக்கிய பண்பு, நம்பத்தகாத எந்த மென்பொருளும் அவற்றில் இயங்காது என்பது உறுதி.
உங்கள் மைக்ரோவேவ் அடுப்பில் புதிய பயன்பாடுகளை நீங்கள் பதிவிறக்கம் செய்ய முடியாது-அனைத்து மென்பொருள்களும் ROM இல் உள்ளன. இதன் பொருள் பயன்பாடுகளுக்கு இடையில் பாதுகாப்பு தேவையில்லை, வடிவமைப்பை எளிதாக்குகிறது. உட்பொதிக்கப்பட்ட லினக்ஸ், QNX மற்றும் VxWorks போன்ற அமைப்புகள் இந்த களத்தில் பிரபலமாக உள்ளன.


- **ஸ்மார்ட் கார்டு ஓஎஸ்**: சிறிய இயக்க முறைமைகள் கிரெடிட் கார்டு அளவிலான ஸ்மார்ட் கார்டு சாதனங்களில் CPU சில்லுகளுடன் இயங்குகின்றன. அவை மிகவும் கடுமையான செயலாக்க சக்தி மற்றும் நினைவக கட்டுப்பாடுகளைக் கொண்டுள்ளன. 
சில ரீடரில் உள்ள தொடர்புகளால் இயக்கப்படுகின்றன, அவற்றில் அவை செருகப்படுகின்றன, ஆனால் தொடர்பு இல்லாத ஸ்மார்ட் கார்டுகள் தூண்டுதலாக இயக்கப்படுகின்றன, அவை என்ன செய்ய முடியும் என்பதை பெரிதும் கட்டுப்படுத்துகின்றன. சிலரால் மின்னணு கொடுப்பனவுகள் போன்ற ஒரே ஒரு செயல்பாட்டை மட்டுமே கையாள முடியும், ஆனால் மற்றவர்கள் பல செயல்பாடுகளை கையாள முடியும். 
பெரும்பாலும் இவை தனியுரிமை அமைப்புகளாகும்.
சில ஸ்மார்ட் கார்டுகள் ஜாவா சார்ந்தவை. இதன் பொருள் ஸ்மார்ட் கார்டில் உள்ள ரோம் ஜாவா மெய்நிகர் இயந்திரத்திற்கான மொழிபெயர்ப்பாளரைக் கொண்டுள்ளது. (JVM). ஜாவா ஆப்பிள்கள் (சிறிய நிரல்கள்) அட்டையில் பதிவிறக்கம் செய்யப்பட்டு ஜே. வி. எம் மொழிபெயர்ப்பாளரால் விளக்கப்படுகின்றன.
இந்த அட்டைகளில் சில ஒரே நேரத்தில் பல ஜாவா ஆப்பிள்களை கையாள முடியும், இது பல நிரலாக்கத்திற்கு வழிவகுக்கிறது மற்றும் அவற்றை திட்டமிட வேண்டிய அவசியம் உள்ளது. இரண்டு அல்லது அதற்கு மேற்பட்ட ஆப்பிள்டுகள் ஒரே நேரத்தில் இருக்கும்போது வள மேலாண்மை மற்றும் பாதுகாப்பு ஒரு பிரச்சினையாக மாறும். 
இந்த சிக்கல்களை அட்டையில் இருக்கும் (பொதுவாக மிகவும் பழமையான) இயக்க முறைமையால் கையாளப்பட வேண்டும்.

## [நினைவு மற்றும் சேமிப்பு](Memory%20and%20Storage/readme.md)

### நினைவகம்
_ மெமரி _ என்ற சொல் உங்கள் கணினியில் குறுகிய கால தரவு அணுகலை அனுமதிக்கும் கூறுகளைக் குறிக்கிறது. இந்த கூறுகளை நீங்கள் DRAM அல்லது மாறும் சீரற்ற அணுகல் நினைவகமாக அடையாளம் காணலாம். உங்கள் கணினி அதன் குறுகிய கால நினைவகத்தில் சேமிக்கப்பட்ட தரவை அணுகுவதன் மூலம் பல செயல்பாடுகளைச் செய்கிறது. அத்தகைய செயல்பாடுகளின் சில எடுத்துக்காட்டுகளில் ஆவணத்தைத் திருத்துதல், பயன்பாடுகளை ஏற்றுதல் மற்றும் இணையத்தில் உலாவுதல் ஆகியவை அடங்கும். உங்கள் கணினியின் வேகம் மற்றும் செயல்திறன் உங்கள் கணினியில் நிறுவப்பட்ட நினைவகத்தின் அளவைப் பொறுத்தது.

உங்களிடம் ஒரு மேசை மற்றும் ஒரு ஃபைலிங் அமைச்சரவை இருந்தால், மேசை உங்கள் கணினியின் நினைவகத்தைக் குறிக்கிறது. நீங்கள் உடனடியாகப் பயன்படுத்த வேண்டிய பொருட்கள் எளிதாக அணுகுவதற்காக உங்கள் மேசையில் வைக்கப்படுகின்றன. இருப்பினும், அதன் அளவு வரம்புகள் காரணமாக ஒரு மேசையில் அதிகம் சேமிக்க முடியாது.

### சேமிப்பு
நினைவகம் என்பது குறுகிய கால தரவின் இருப்பிடத்தைக் குறிக்கும் அதே வேளையில், _ ஸ்டோரேஜ் _ என்பது உங்கள் கணினியில் உள்ள கூறு ஆகும், இது தரவை நீண்ட காலத்திற்கு சேமிக்கவும் அணுகவும் உங்களை அனுமதிக்கிறது. வழக்கமாக, சேமிப்பகம் திட-நிலை இயக்கி அல்லது ஹார்ட் டிரைவ் வடிவில் வருகிறது. சேமிப்பகத்தில் உங்கள் பயன்பாடுகள், இயக்க முறைமை மற்றும் கோப்புகள் காலவரையின்றி உள்ளன. கணினிகள் சேமிப்பக அமைப்பிலிருந்து தகவல்களைப் படிக்கவும் எழுதவும் வேண்டும், எனவே சேமிப்பக வேகம் உங்கள் கணினி எவ்வளவு வேகமாக துவக்க முடியும், ஏற்ற முடியும் மற்றும் நீங்கள் சேமித்ததை அணுக முடியும் என்பதை தீர்மானிக்கிறது.

மேசை கணினியின் நினைவகத்தைக் குறிக்கும் அதே வேளையில், தாக்கல் செய்யும் அமைச்சரவை உங்கள் கணினியின் சேமிப்பைக் குறிக்கிறது. இது சேமிக்கப்பட வேண்டிய மற்றும் சேமிக்கப்பட வேண்டிய பொருட்களை வைத்திருக்கிறது, ஆனால் உடனடி அணுகலுக்கு அவசியமில்லை. தாக்கல் செய்யும் கேபினெட்டின் அளவு என்பது பல விஷயங்களை வைத்திருக்க முடியும் என்பதாகும்.

நினைவகத்திற்கும் சேமிப்பகத்திற்கும் உள்ள ஒரு முக்கியமான வேறுபாடு என்னவென்றால், கணினி அணைக்கப்படும்போது நினைவகம் அழிக்கப்படுகிறது. மறுபுறம், உங்கள் கணினியை நீங்கள் எவ்வளவு அடிக்கடி மூடினாலும் சேமிப்பகம் அப்படியே இருக்கும். எனவே, மேசை மற்றும் தாக்கல் அமைச்சரவை ஒப்புமையில், நீங்கள் அலுவலகத்தை விட்டு வெளியேறும்போது உங்கள் மேசையில் எஞ்சியிருக்கும் எந்த கோப்புகளும் தூக்கி எறியப்படும். உங்கள் தாக்கல் செய்யும் அமைச்சரவையில் உள்ள அனைத்தும் அப்படியே இருக்கும்.

### மெய்நிகர் நினைவகம்
கணினி அமைப்புகளின் மையத்தில் நினைவகம் உள்ளது, நிரல்கள் இயங்கும் இடம் மற்றும் தரவு சேமிக்கப்படுகிறது. ஆனால் நீங்கள் இயக்கும் நிரல்கள் மற்றும் நீங்கள் பணிபுரியும் தரவு உங்கள் கணினியின் நினைவகத்தின் இயற்பியல் திறனை விட அதிகமாக இருக்கும்போது என்ன நடக்கும்? இங்குதான் மெய்நிகர் நினைவகம் நுழைகிறது, இது உங்கள் கணினியின் நினைவகத்திற்கு ஒரு ஸ்மார்ட் நீட்டிப்பாக செயல்படுகிறது மற்றும் அதன் திறன்களை மேம்படுத்துகிறது.

**மெய்நிகர் நினைவகத்தின் வரையறை மற்றும் நோக்கம்:**

மெய்நிகர் நினைவகம் என்பது இயற்பியல் நினைவகத்தின் வரம்புகளை சமாளிக்க இயக்க முறைமைகளால் பயன்படுத்தப்படும் நினைவக மேலாண்மை நுட்பமாகும். (RAM). மென்பொருள் பயன்பாடுகளுக்கு கணினியில் இயற்பியல் ரீதியாக நிறுவப்பட்டதை விட அதிக அளவு நினைவகத்திற்கான அணுகல் உள்ளது என்ற மாயையை இது உருவாக்குகிறது. சாராம்சத்தில், இது கணினியின் இயற்பியல் ரேமின் வரம்புகளுக்கு அப்பால் நினைவக இடத்தைப் பயன்படுத்த நிரல்களை செயல்படுத்துகிறது.

மெய்நிகர் நினைவகத்தின் முதன்மை நோக்கம் திறமையான பல பணிகளை செயல்படுத்துவதும், பெரிய நிரல்களை செயல்படுத்துவதும் ஆகும், இவை அனைத்தும் அமைப்பின் பதிலளிப்பை பராமரிப்பதாகும். இயற்பியல் ரேம் மற்றும் ஹார்ட் டிரைவ் அல்லது எஸ்எஸ்டி போன்ற இரண்டாம் நிலை சேமிப்பக சாதனங்களுக்கு இடையில் தடையற்ற தொடர்புகளை உருவாக்குவதன் மூலம் இது இதை அடைகிறது.

**மெய்நிகர் நினைவகம் கிடைக்கக்கூடிய இயற்பியல் நினைவகத்தை எவ்வாறு நீட்டிக்கிறது:**

மெய்நிகர் நினைவகத்தை உங்கள் கணினியின் ரேம் மற்றும் அதன் இரண்டாம் நிலை சேமிப்பகத்தை இணைக்கும் ஒரு பாலமாக நினைத்துப் பாருங்கள். (disk drives). நீங்கள் ஒரு நிரலை இயக்கும்போது, அதன் பகுதிகள் வேகமான இயற்பியல் நினைவகத்தில் ஏற்றப்படுகின்றன. (RAM). இருப்பினும், திட்டத்தின் அனைத்து பகுதிகளும் உடனடியாக பயன்படுத்தப்படாது.

மெய்நிகர் நினைவகம் இந்த சூழ்நிலையை RAM இலிருந்து இரண்டாம் நிலை சேமிப்பகத்திற்கு தீவிரமாக பயன்படுத்தப்படாத நிரலின் பிரிவுகளை நகர்த்துவதன் மூலம் பயன்படுத்துகிறது, இது தீவிரமாக பயன்படுத்தப்படும் பகுதிகளுக்கு RAM இல் அதிக இடத்தை உருவாக்குகிறது. இந்த செயல்முறை பயனர் மற்றும் இயங்கும் நிரல்களுக்கு வெளிப்படையானது. நகர்த்தப்பட்ட பாகங்கள் மீண்டும் தேவைப்படும்போது, அவை மீண்டும் ரேமுக்கு மாற்றப்படுகின்றன, அதே நேரத்தில் மற்ற குறைவான செயலில் உள்ள பாகங்கள் இரண்டாம் நிலை சேமிப்பகத்திற்கு நகர்த்தப்படலாம்.

இயற்பியல் நினைவகத்திற்கு உள்ளேயும் வெளியேயும் தரவின் இந்த மாறும் பரிமாற்றம் இயக்க முறைமையால் நிர்வகிக்கப்படுகிறது. நிரல்கள் கிடைக்கக்கூடிய ரேமை விட பெரியதாக இருந்தாலும் அவற்றை இயக்க இது அனுமதிக்கிறது, ஏனெனில் உகந்த செயல்திறனுக்காக ரேம்-இல் என்ன தரவு இருக்க வேண்டும் என்பதை இயக்க முறைமை புத்திசாலித்தனமாக தீர்மானிக்கிறது.

சுருக்கமாக, மெய்நிகர் நினைவகம் ஒரு மெய்நிகராக்க அடுக்காக செயல்படுகிறது, இது ரேம் மற்றும் இரண்டாம் நிலை சேமிப்பகத்திற்கு இடையில் நிரல்கள் மற்றும் தரவுகளின் பகுதிகளை தற்காலிகமாக மாற்றுவதன் மூலம் கிடைக்கக்கூடிய இயற்பியல் நினைவகத்தை விரிவுபடுத்துகிறது. இந்த செயல்முறை கணினி பெரிய பணிகளையும் ஏராளமான நிரல்களையும் ஒரே நேரத்தில் கையாள முடியும் என்பதை உறுதி செய்கிறது, இவை அனைத்தும் திறமையான செயல்திறன் மற்றும் பதிலளிப்பை பராமரிக்கின்றன.

## [கோப்பு முறைமை](File%20System/readme.md)
கணினியில், கோப்பு முறைமை அல்லது கோப்பு முறைமை (பெரும்பாலும் fs என சுருக்கமாக அழைக்கப்படுகிறது) என்பது தரவு எவ்வாறு சேமிக்கப்படுகிறது மற்றும் மீட்டெடுக்கப்படுகிறது என்பதைக் கட்டுப்படுத்த இயக்க முறைமை பயன்படுத்தும் ஒரு முறை மற்றும் தரவு அமைப்பு ஆகும். ஒரு கோப்பு முறைமை இல்லாமல், ஒரு சேமிப்பு ஊடகத்தில் வைக்கப்படும் தரவு ஒரு பெரிய தரவு அமைப்பாக இருக்கும், அங்கு ஒரு தரவு நிறுத்தப்பட்டது, அடுத்தது தொடங்கியது அல்லது அதை மீட்டெடுக்கும் நேரம் வரும்போது எந்த தரவு பகுதியும் எங்கு அமைந்துள்ளது என்பதைச் சொல்ல வழி இல்லை. தரவை துண்டுகளாகப் பிரிப்பதன் மூலமும், ஒவ்வொரு பகுதிக்கும் ஒரு பெயரைக் கொடுப்பதன் மூலமும், தரவு எளிதில் தனிமைப்படுத்தப்பட்டு அடையாளம் காணப்படுகிறது. காகித அடிப்படையிலான தரவு மேலாண்மை அமைப்பு எவ்வாறு பெயரிடப்பட்டது என்பதிலிருந்து அதன் பெயரை எடுத்து, ஒவ்வொரு தரவுக் குழுவும் "கோப்பு" என்று அழைக்கப்படுகிறது. தரவுகளின் குழுக்கள் மற்றும் அவற்றின் பெயர்களை நிர்வகிக்கப் பயன்படுத்தப்படும் கட்டமைப்பு மற்றும் தர்க்க விதிகள் "கோப்பு முறைமை" என்று அழைக்கப்படுகின்றன.

பல வகையான கோப்பு அமைப்புகள் உள்ளன, ஒவ்வொன்றும் தனித்துவமான அமைப்பு மற்றும் தர்க்கம், வேகம், நெகிழ்வுத்தன்மை, பாதுகாப்பு, அளவு மற்றும் பலவற்றின் பண்புகளைக் கொண்டுள்ளன. சில கோப்பு அமைப்புகள் குறிப்பிட்ட பயன்பாடுகளுக்கு பயன்படுத்த வடிவமைக்கப்பட்டுள்ளன. எடுத்துக்காட்டாக, ஐஎஸ்ஓ 9660 கோப்பு முறைமை குறிப்பாக ஒளியியல் வட்டுகளுக்காக வடிவமைக்கப்பட்டுள்ளது.

கோப்பு அமைப்புகளை பல்வேறு ஊடகங்களைப் பயன்படுத்தி பல வகையான சேமிப்பு சாதனங்களில் பயன்படுத்தலாம். 2019 ஆம் ஆண்டு நிலவரப்படி, ஹார்ட் டிஸ்க் டிரைவ்கள் முக்கிய சேமிப்பு சாதனங்களாக இருந்து வருகின்றன, மேலும் அவை எதிர்காலத்தில் அப்படியே இருக்கும் என்று எதிர்பார்க்கப்படுகிறது. பயன்படுத்தப்படும் பிற வகையான ஊடகங்களில் எஸ். எஸ். டி. க்கள், காந்த நாடாக்கள் மற்றும் ஒளியியல் வட்டுகள் அடங்கும். சில சந்தர்ப்பங்களில், டி. எம். பி. எஃப். கள் போன்ற, கணினியின் முக்கிய நினைவகம் (சீரற்ற அணுகல் நினைவகம், ரேம்) குறுகிய கால பயன்பாட்டிற்காக ஒரு தற்காலிக கோப்பு அமைப்பை உருவாக்குகிறது.

சில கோப்பு அமைப்புகள் உள்ளூர் தரவு சேமிப்பு சாதனங்களில் பயன்படுத்தப்படுகின்றன; மற்றவை நெட்வொர்க் நெறிமுறை வழியாக கோப்பு அணுகலை வழங்குகின்றன. (for example, NFS, SMB, or 9P clients). சில கோப்பு அமைப்புகள் "மெய்நிகர்" ஆகும், அதாவது வழங்கப்பட்ட "கோப்புகள்" (மெய்நிகர் கோப்புகள் என்று அழைக்கப்படுகின்றன) கோரிக்கையின் பேரில் கணக்கிடப்படுகின்றன (procfs மற்றும் sysfs போன்றவை) அல்லது வெறுமனே வேறு கோப்பு முறைமையில் ஒரு மேப்பிங் ஆகும். கோப்பு முறைமை கோப்புகளின் உள்ளடக்கம் மற்றும் அந்த கோப்புகளைப் பற்றிய மெட்டாடேட்டா ஆகிய இரண்டிற்கும் அணுகலை நிர்வகிக்கிறது. சேமிப்பு இடத்தை ஏற்பாடு செய்வதற்கு இது பொறுப்பாகும்; இயற்பியல் சேமிப்பு ஊடகத்தைப் பொறுத்தவரை நம்பகத்தன்மை, செயல்திறன் மற்றும் ட்யூனிங் ஆகியவை முக்கியமான வடிவமைப்புக் கருத்துகளாகும்.

### கோப்பு அமைப்புகள் எவ்வாறு செயல்படுகின்றன
ஒரு கோப்பு முறைமை தரவை சேமித்து ஒழுங்கமைக்கிறது மற்றும் சேமிப்பக சாதனத்தில் உள்ள அனைத்து தரவுகளுக்கும் ஒரு வகை குறியீடாக கருதப்படலாம். இந்த சாதனங்களில் ஹார்ட் டிரைவ்கள், ஆப்டிகல் டிரைவ்கள் மற்றும் ஃபிளாஷ் டிரைவ்கள் ஆகியவை அடங்கும்.

கோப்பு அமைப்புகள் கோப்புகளை பெயரிடுவதற்கான மரபுகளைக் குறிப்பிடுகின்றன, இதில் ஒரு பெயரில் அதிகபட்ச எழுத்துக்களின் எண்ணிக்கை, எந்த எழுத்துக்களைப் பயன்படுத்தலாம், மற்றும் சில அமைப்புகளில், கோப்பு பெயர் பின்னொட்டு எவ்வளவு நீளமாக இருக்கும். பல கோப்பு அமைப்புகளில், கோப்பு பெயர்கள் வழக்கு-உணர்திறன் கொண்டவை அல்ல.

கோப்புடன் சேர்ந்து, கோப்பு அமைப்புகள் மெட்டாடேட்டாவில் உள்ள கோப்பகத்தின் அளவு மற்றும் அதன் பண்புக்கூறுகள், இருப்பிடம் மற்றும் படிநிலை போன்ற தகவல்களைக் கொண்டுள்ளன. இயக்ககத்தில் கிடைக்கக்கூடிய சேமிப்பகத்தின் இலவச தொகுதிகளையும், எவ்வளவு இடம் கிடைக்கிறது என்பதையும் மெட்டாடேட்டா அடையாளம் காணலாம்.

ஒரு கோப்பு முறைமை அடைவுகளின் கட்டமைப்பின் மூலம் ஒரு கோப்பின் பாதையை குறிப்பிட ஒரு வடிவமைப்பையும் உள்ளடக்கியது. ஒரு கோப்பு ஒரு கோப்பகத்தில் வைக்கப்படுகிறது-அல்லது விண்டோஸ் ஓஎஸ் இல் ஒரு கோப்புறையில்-அல்லது மர கட்டமைப்பில் விரும்பிய இடத்தில் துணை அடைவு. பிசி மற்றும் மொபைல் ஓஎஸ் கோப்பு அமைப்புகளைக் கொண்டுள்ளன, இதில் கோப்புகள் ஒரு படிநிலை மர கட்டமைப்பில் வைக்கப்படுகின்றன.

சேமிப்பு ஊடகத்தில் கோப்புகள் மற்றும் அடைவுகள் உருவாக்கப்படுவதற்கு முன்பு, பகிர்வுகள் வைக்கப்பட வேண்டும். ஒரு பகிர்வு என்பது OS தனித்தனியாக நிர்வகிக்கும் வட்டு அல்லது பிற சேமிப்பகத்தின் ஒரு பகுதியாகும். ஒரு கோப்பு முறைமை முதன்மை பகிர்வில் உள்ளது, மேலும் சில இயக்க முறைமைகள் ஒரு வட்டில் பல பகிர்வுகளை அனுமதிக்கின்றன. இந்த சூழ்நிலையில், ஒரு கோப்பு முறைமை சிதைந்தால், வேறு பகிர்வில் உள்ள தரவு பாதுகாப்பாக இருக்கும்.

### கோப்பு முறைமைகளின் வகைகள்
வேகம் மற்றும் அளவு போன்ற வெவ்வேறு தர்க்கரீதியான கட்டமைப்புகள் மற்றும் பண்புகளைக் கொண்ட பல வகையான கோப்பு அமைப்புகள் உள்ளன. கோப்பு முறைமையின் வகை OS மற்றும் அந்த OS இன் தேவைகளைப் பொறுத்து வேறுபடலாம். மைக்ரோசாப்ட் விண்டோஸ், மேக் ஓஎஸ் எக்ஸ் மற்றும் லினக்ஸ் ஆகியவை மிகவும் பொதுவான மூன்று பிசி இயக்க முறைமைகளாகும். மொபைல் ஓஎஸ்ஸில் ஆப்பிள் ஐஓஎஸ் மற்றும் கூகுள் ஆண்ட்ராய்டு ஆகியவை அடங்கும்.

முக்கிய கோப்பு அமைப்புகள் பின்வருவனவற்றை உள்ளடக்குகின்றனஃ

- கோப்பு ஒதுக்கீடு அட்டவணை (FAT) மைக்ரோசாப்ட் விண்டோஸ் ஓஎஸ் மூலம் ஆதரிக்கப்படுகிறது. FAT எளிய மற்றும் நம்பகமானதாகக் கருதப்படுகிறது மற்றும் மரபு கோப்பு அமைப்புகளுக்கு ஏற்ப வடிவமைக்கப்பட்டுள்ளது. FAT 1977 ஆம் ஆண்டில் ஃப்ளாப்பி டிஸ்க்குகளுக்காக வடிவமைக்கப்பட்டது, ஆனால் பின்னர் ஹார்ட் டிஸ்க்குகளுக்கு மாற்றியமைக்கப்பட்டது. பெரும்பாலான தற்போதைய OS களுடன் திறமையான மற்றும் இணக்கமானதாக இருக்கும்போது, FAT நவீன கோப்பு அமைப்புகளின் செயல்திறன் மற்றும் அளவிடுதலுடன் பொருந்தாது.

- குளோபல் கோப்பு முறைமை (GFS) என்பது லினக்ஸ் இயக்க முறைமைக்கான கோப்பு முறைமையாகும், மேலும் இது பகிரப்பட்ட வட்டு கோப்பு முறைமையாகும். GFS பகிரப்பட்ட தொகுதி சேமிப்பகத்திற்கான நேரடி அணுகலை வழங்குகிறது மற்றும் உள்ளூர் கோப்பு அமைப்பாக பயன்படுத்தப்படலாம்.

- GFS2 என்பது புதுப்பிக்கப்பட்ட மெட்டாடேட்டா அமைப்பு போன்ற அசல் GFS இல் சேர்க்கப்படாத அம்சங்களைக் கொண்ட புதுப்பிக்கப்பட்ட பதிப்பாகும். குனு பொது உரிம விதிமுறைகளின் கீழ், ஜி. எஃப். எஸ் மற்றும் ஜி. எஃப். எஸ் 2 கோப்பு அமைப்புகள் இரண்டும் இலவச மென்பொருளாக கிடைக்கின்றன.

- படிநிலை கோப்பு முறைமை (HFS) மேக் இயக்க முறைமைகளுடன் பயன்படுத்த உருவாக்கப்பட்டது. எச். எஃப். எஸ். ஐ மேக் ஓஎஸ் ஸ்டாண்டர்ட் என்றும் அழைக்கலாம், அதற்குப் பிறகு மேக் ஓஎஸ் எக்ஸ்டெண்டட் வருகிறது. முதலில் 1985 ஆம் ஆண்டில் ஃப்ளாப்பி மற்றும் ஹார்ட் டிஸ்க்குகளுக்காக அறிமுகப்படுத்தப்பட்டது, எச். எஃப். எஸ் அசல் மேகிண்டோஷ் கோப்பு முறைமையை மாற்றியது. இதை சிடி-ரோம்களிலும் பயன்படுத்தலாம்.

- புதிய தொழில்நுட்ப கோப்பு முறைமை (NTFS) என்றும் அழைக்கப்படும் NT கோப்பு முறைமை விண்டோஸ் NT 3.1 OS இலிருந்து விண்டோஸ் தயாரிப்புகளுக்கான இயல்புநிலை கோப்பு முறைமையாகும். முந்தைய FAT கோப்பு முறைமையின் மேம்பாடுகளில் சிறந்த மெட்டாடேட்டா ஆதரவு, செயல்திறன் மற்றும் வட்டு இடத்தின் பயன்பாடு ஆகியவை அடங்கும். லினக்ஸ் இயங்குதளத்தில் இலவச, திறந்த மூல NTFS இயக்கி மூலமாகவும் NTFS ஆதரிக்கப்படுகிறது. மேக் ஓஎஸ் என். டி. எஃப். எஸ்-க்கான வாசிப்பு-மட்டும் ஆதரவைக் கொண்டுள்ளது.

- யுனிவர்சல் டிஸ்க் ஃபார்மேட் (யுடிஎஃப்) என்பது ஆப்டிகல் மீடியா மற்றும் டிவிடிக்களுக்கான விற்பனையாளர்-நடுநிலை கோப்பு முறைமையாகும். யுடிஎஃப் ஐஎஸ்ஓ 9660 கோப்பு முறைமையை மாற்றுகிறது மற்றும் டிவிடி மன்றத்தால் தேர்ந்தெடுக்கப்பட்ட டிவிடி வீடியோ மற்றும் ஆடியோவுக்கான அதிகாரப்பூர்வ கோப்பு முறைமையாகும்.

## [மேகக் கணக்கீடு](Cloud%20Computing/Readme.md)
கிளவுட் கம்ப்யூட்டிங் என்பது இணையத்தில் தகவல் மற்றும் பயன்பாடுகளை அணுகும் திறன் ஆகும். கிளவுட் கம்ப்யூட்டிங் இணைய இணைப்புடன் எந்த இடத்திலிருந்தும் பயன்பாடுகள் மற்றும் தரவை அணுக பயனர்களை அனுமதிக்கிறது.

கிளவுட் கம்ப்யூட்டிங் என்பது இணைய அடிப்படையிலான கணினி வகையாகும், இது பகிரப்பட்ட கணினி செயலாக்க வளங்கள் மற்றும் தரவை கணினிகள் மற்றும் பிற சாதனங்களுக்கு தேவைக்கேற்ப வழங்குகிறது.

இது கட்டமைக்கக்கூடிய கணினி வளங்களின் (e.g., நெட்வொர்க்குகள், சேவையகங்கள், சேமிப்பு, பயன்பாடுகள் மற்றும் சேவைகள்) பகிரப்பட்ட குளத்திற்கு எங்கும் நிறைந்த, வசதியான, தேவைக்கேற்ப நெட்வொர்க் அணுகலை செயல்படுத்துவதற்கான ஒரு மாதிரியாகும், இது குறைந்தபட்ச மேலாண்மை முயற்சி அல்லது சேவை வழங்குநர் தொடர்புடன் விரைவாக வழங்கப்பட்டு வெளியிடப்படலாம்.
 
## கிளவுட் கம்ப்யூட்டிங்கின் சிறந்த நன்மைகள்

தகவல் தொழில்நுட்ப வளங்களைப் பற்றி வணிகங்கள் நினைக்கும் விதத்திலிருந்து கிளவுட் கம்ப்யூட்டிங் ஒரு பெரிய மாற்றமாகும். நிறுவனங்கள் கிளவுட் கம்ப்யூட்டிங் சேவைகளுக்கு திரும்புவதற்கான ஏழு பொதுவான காரணங்கள் இங்கேஃ

செலவு.
வன்பொருள் மற்றும் மென்பொருளை வாங்குவதற்கும், தளத்தில் தரவு மையங்களை அமைப்பதற்கும் இயக்குவதற்கும் மூலதன செலவை கிளவுட் கம்ப்யூட்டிங் நீக்குகிறது-சேவையகங்களின் அடுக்குகள், மின்சாரம் மற்றும் குளிரூட்டலுக்கான 24 மணி நேர மின்சாரம் மற்றும் உள்கட்டமைப்பை நிர்வகிப்பதற்கான தகவல் தொழில்நுட்ப வல்லுநர்கள். இது வேகமாக சேர்க்கிறது.

வேகம்.
பெரும்பாலான கிளவுட் கம்ப்யூட்டிங் சேவைகள் சுய சேவை மற்றும் தேவைக்கேற்ப வழங்கப்படுகின்றன, எனவே ஏராளமான கம்ப்யூட்டிங் வளங்களை கூட நிமிடங்களில் வழங்க முடியும், பொதுவாக ஒரு சில மவுஸ் கிளிக்குகள் மூலம், வணிகங்களுக்கு நிறைய நெகிழ்வுத்தன்மையை அளிக்கிறது மற்றும் திறன் திட்டமிடலின் அழுத்தத்தை நீக்குகிறது.

உலக அளவுகோல்
கிளவுட் கம்ப்யூட்டிங் சேவைகளின் நன்மைகள் நெகிழ்ச்சியுடன் அளவிடுவதற்கான திறனை உள்ளடக்கியது. கிளவுட் பேச்சில், அதாவது சரியான அளவு தகவல் தொழில்நுட்ப வளங்களை வழங்குவது-எடுத்துக்காட்டாக, அதிகமாகவோ அல்லது குறைவாகவோ கணினி சக்தி, சேமிப்பு மற்றும் அலைவரிசை-தேவைப்படும்போது மற்றும் சரியான புவியியல் இருப்பிடத்திலிருந்து.

உற்பத்தித்திறன்
ஆன்-சைட் தரவு மையங்களுக்கு பொதுவாக நிறைய "ரேக்கிங் மற்றும் ஸ்டேக்கிங்" தேவைப்படுகிறது-வன்பொருள் அமைப்பு, மென்பொருள் ஒட்டுதல் மற்றும் பிற நேரத்தை எடுத்துக்கொள்ளும் தகவல் தொழில்நுட்ப மேலாண்மை வேலைகள். கிளவுட் கம்ப்யூட்டிங் இந்த பணிகளில் பலவற்றின் தேவையை நீக்குகிறது, எனவே ஐடி குழுக்கள் மிக முக்கியமான வணிக இலக்குகளை அடைய நேரத்தை செலவிடலாம்.

செயல்திறன்
மிகப்பெரிய கிளவுட் கம்ப்யூட்டிங் சேவைகள் உலகளாவிய பாதுகாப்பான தரவு மையங்களின் நெட்வொர்க்கில் இயங்குகின்றன, அவை வேகமான மற்றும் திறமையான கம்ப்யூட்டிங் வன்பொருளின் சமீபத்திய தலைமுறைக்கு தொடர்ந்து மேம்படுத்தப்படுகின்றன. இது ஒரு கார்ப்பரேட் தரவு மையத்தின் மீது பல நன்மைகளை வழங்குகிறது, இதில் பயன்பாடுகளுக்கான குறைந்த நெட்வொர்க் தாமதம் மற்றும் அதிக அளவிலான பொருளாதாரங்கள் அடங்கும்.

நம்பகத்தன்மை
கிளவுட் கம்ப்யூட்டிங் தரவு காப்புப்பிரதி, பேரழிவு மீட்பு மற்றும் வணிக தொடர்ச்சியை எளிதாகவும் மலிவானதாகவும் ஆக்குகிறது, ஏனெனில் கிளவுட் வழங்குநரின் நெட்வொர்க்கில் பல தேவையற்ற தளங்களில் தரவை பிரதிபலிக்க முடியும்.

பாதுகாப்பு
பல கிளவுட் வழங்குநர்கள் பரந்த அளவிலான கொள்கைகள், தொழில்நுட்பங்கள் மற்றும் கட்டுப்பாடுகளை வழங்குகிறார்கள், அவை ஒட்டுமொத்தமாக உங்கள் பாதுகாப்பு தோரணையை வலுப்படுத்துகின்றன, இது உங்கள் தரவு, பயன்பாடுகள் மற்றும் உள்கட்டமைப்பை சாத்தியமான அச்சுறுத்தல்களிலிருந்து பாதுகாக்க உதவுகிறது.

### கிளவுட் கம்ப்யூட்டிங் சேவைகளின் வகைகள்
- [ஒரு சேவையாக உள்கட்டமைப்பு (IaaS)](Cloud%20Computing/Readme.md#infrastructure-as-a-service-iaas)
- [ஒரு சேவையாக மேடை (PaaS)](Cloud%20Computing/Readme.md#platform-as-a-service-paas)
- [ஒரு சேவையாக மென்பொருள் (SaaS)](Cloud%20Computing/Readme.md#software-as-a-service-saas)


## [இயந்திர கற்றல்]()
இயந்திர கற்றல் என்பது ஒரு கணினிக்கு கற்றுக்கொடுக்கும் நடைமுறையாகும். உள்வரும் தரவுகளில் தீர்ப்புகளை வழங்க இந்த கருத்து முறை அங்கீகாரத்தையும், முன்கணிப்பு வழிமுறைகளின் பிற வடிவங்களையும் பயன்படுத்துகிறது. இந்தத் துறை செயற்கை நுண்ணறிவு மற்றும் கணக்கீட்டு புள்ளிவிவரங்களுடன் நெருக்கமாக தொடர்புடையது.

### இயந்திர கற்றலில் மூன்று துணைப்பிரிவுகள் உள்ளனஃ

### மேற்பார்வையிடப்பட்ட இயந்திர கற்றல் 
இதில், இயந்திர கற்றல் மாதிரிகள் பெயரிடப்பட்ட தரவுத் தொகுப்புகளுடன் பயிற்றுவிக்கப்படுகின்றன, இது மாதிரிகள் காலப்போக்கில் மிகவும் துல்லியமாக கற்றுக்கொள்ளவும் வளரவும் அனுமதிக்கிறது. எடுத்துக்காட்டாக, நாய்கள் மற்றும் பிற பொருட்களின் படங்களுடன் ஒரு வழிமுறை பயிற்சி அளிக்கப்படும், இவை அனைத்தும் மனிதர்களால் பெயரிடப்பட்டவை, மேலும் நாய்களின் படங்களை தானாக அடையாளம் காணும் வழிகளை இயந்திரம் கற்றுக் கொள்ளும். மேற்பார்வையிடப்பட்ட இயந்திர கற்றல் இன்று பயன்படுத்தப்படும் மிகவும் பொதுவான வகையாகும்.


மேற்பார்வையிடப்பட்ட கற்றலின் நடைமுறை பயன்பாடுகள்-
1. **உயிர் தகவலியல்:** உயிர் தகவலியல் என்பது கைரேகைகள், கண் அமைப்பு, காதணிகள் போன்ற உயிரியல் அறிவை தனிநபர்கள் எவ்வாறு தக்கவைத்துக்கொள்கிறார்கள் என்பதைப் பற்றிய ஆய்வு ஆகும். மொபைல் போன்கள் இப்போது நமது உயிரியல் தரவைப் புரிந்துகொள்ளும் அளவுக்கு புத்திசாலித்தனமாக உள்ளன, பின்னர் கணினி பாதுகாப்பை அதிகரிக்க சரிபார்க்கின்றன.
2. **பேச்சு அங்கீகாரம்:** இது உங்கள் குரலை நிரலுக்கு தெரிவிக்கக்கூடிய நிரலின் வகை, அது உங்களை அடையாளம் காணும். கூகிள் அசிஸ்டென்ட் அல்லது சிரி போன்ற டிஜிட்டல் உதவியாளர்கள் மிகவும் பிரபலமான நிஜ உலக கேஜெட்களாகும், அவை உங்கள் குரலால் மட்டுமே பதிலளிக்கின்றன.
3. **ஸ்பேம் கண்டறிதல்:** கற்பனையான அல்லது இயந்திர அடிப்படையிலான தகவல்தொடர்புகள் அனுப்பப்படுவதைத் தடுக்க இந்த கருவி பயன்படுத்தப்படுகிறது. ஜிமெயில் பல தவறான சொற்களைக் கற்றுக் கொள்ளும் ஒரு வழிமுறையை உள்ளடக்கியது. ஒன்பிளஸ் மெசேஜஸ் ஆப் பயனரிடம் எந்த விதிமுறைகள் தடை செய்யப்பட வேண்டும் என்பதைக் குறிப்பிடுமாறு கேட்கிறது, மேலும் முக்கிய சொல் அத்தகைய உரைகளை பயன்பாட்டிலிருந்து தடுக்கும்.
4. **பார்வைக்கு பொருள் அங்கீகாரம்:** நீங்கள் எதையும் வரையறுக்க வேண்டியிருக்கும் போது இந்த வகை மென்பொருள் பயன்படுத்தப்படுகிறது. வழிமுறையைப் பயிற்றுவிக்க நீங்கள் பயன்படுத்தும் ஒரு பெரிய தரவுத்தொகுப்பு உங்களிடம் உள்ளது, மேலும் இதைப் பயன்படுத்தி ஒரு புதிய பொருளை அடையாளம் காணலாம்.


### மேற்பார்வை செய்யப்படாத இயந்திர கற்றல்
மேற்பார்வை செய்யப்படாத இயந்திர கற்றலில், ஒரு நிரல் பெயரிடப்படாத தரவுகளில் வடிவங்களைத் தேடுகிறது. மேற்பார்வை செய்யப்படாத இயந்திர கற்றல் மக்கள் வெளிப்படையாகத் தேடாத வடிவங்கள் அல்லது போக்குகளைக் கண்டறிய முடியும். எடுத்துக்காட்டாக, மேற்பார்வை செய்யப்படாத இயந்திர கற்றல் திட்டம் ஆன்லைன் விற்பனைத் தரவைப் பார்த்து, கொள்முதல் செய்யும் பல்வேறு வகையான வாடிக்கையாளர்களை அடையாளம் காணலாம்.


மேற்பார்வை செய்யப்படாத கற்றலின் நடைமுறை பயன்பாடுகள்
1. **கிளஸ்டரிங்:** கிளஸ்டரிங் என்பது தரவை தனித்தனி குழுக்களாக வகைப்படுத்தும் செயல்முறையாகும். கிளஸ்டர்களைப் பற்றிய அனைத்து விவரங்களும் நமக்குத் தெரியாதபோது, அவற்றைக் கிளஸ்டர் செய்ய மேற்பார்வை செய்யப்படாத கற்றலைப் பயன்படுத்தலாம். முன் பெயரிடப்பட்ட வகுப்புகள் அல்லது வகுப்பு பண்புகள் இல்லாத தரவை பகுப்பாய்வு செய்யவும் ஒழுங்கமைக்கவும் மேற்பார்வை செய்யப்படாத கற்றல் பயன்படுத்தப்படுகிறது. நிறுவனங்கள் தங்கள் தரவை மிகவும் திறம்பட கையாள கிளஸ்டரிங் உதவும்.
உங்களிடம் ஒரு யூடியூப் சேனல் இருப்பதாக வைத்துக்கொள்வோம். உங்கள் சந்தாதாரர்களைப் பற்றி உங்களிடம் நிறைய தகவல்கள் இருக்கலாம். நீங்கள் இதே போன்ற சந்தாதாரர்களைக் கண்டுபிடிக்க விரும்பினால், நீங்கள் ஒரு கிளஸ்டரிங் நுட்பத்தைப் பயன்படுத்த வேண்டும்.
2. **காட்சிப்படுத்தல்:** தகவல்களை வழங்குவதற்காக வரைபடங்கள், புகைப்படங்கள், வரைபடங்கள், வரைபடங்கள் மற்றும் பலவற்றை உருவாக்கும் செயல்முறை காட்சிப்படுத்தல் என்று அழைக்கப்படுகிறது. இந்த மூலோபாயத்தை செயல்படுத்த மேற்பார்வை செய்யப்படாத இயந்திர கற்றலைப் பயன்படுத்தலாம்.
ஒரு போட்டியில் உங்கள் அணியின் செயல்திறன் குறித்த தகவல்களைக் கொண்ட கிரிக்கெட் பயிற்சியாளராக நீங்கள் இருக்கிறீர்கள் என்று வைத்துக்கொள்வோம். போட்டியின் அனைத்து புள்ளிவிவரங்களையும் நீங்கள் விரைவாகக் கண்டுபிடிக்க விரும்பலாம். பெயரிடப்படாத மற்றும் சிக்கலான தரவை நீங்கள் ஒரு காட்சிப்படுத்தல் வழிமுறையில் அனுப்பலாம்.
3. **முரண்பாடு கண்டறிதல்:** ஒழுங்கின்மை கண்டறிதல் என்பது வழக்கமான தரவுகளிலிருந்து பெரிதும் விலகிச் செல்வதன் மூலம் சந்தேகங்களை எழுப்பும் அசாதாரண விஷயங்கள், நிகழ்வுகள் அல்லது அவதானிப்புகளின் கண்டுபிடிப்பாகும். இந்த சூழ்நிலையில், இந்த அமைப்பு ஏராளமான வழக்கமான நிகழ்வுகளுடன் திட்டமிடப்பட்டுள்ளது. இதன் விளைவாக, அது ஒரு எதிர்பாராத நிகழ்வைக் கண்டறியும்போது, அது ஒரு ஒழுங்கின்மையா இல்லையா என்பதை தீர்மானிக்க முடியும்.
கிரெடிட் கார்டு மோசடி கண்டறிதல் இதற்கு ஒரு நல்ல எடுத்துக்காட்டு. இந்த சிக்கல் இப்போது மேற்பார்வை செய்யப்படாத இயந்திர கற்றல் ஒழுங்கின்மை கண்டறிதல் அணுகுமுறைகளைப் பயன்படுத்தி தீர்க்கப்படுகிறது. மோசடிகளைத் தவிர்ப்பதற்காக, எதிர்பாராத கிரெடிட் கார்டு பரிவர்த்தனைகளை இந்த அமைப்பு அடையாளம் காட்டுகிறது.

### அரை மேற்பார்வையிடப்பட்ட இயந்திர கற்றல்
மேற்பார்வையிடப்பட்ட கற்றலின் குறைபாடு என்னவென்றால், இதற்கு எம். எல் நிபுணர்கள் அல்லது தரவு விஞ்ஞானிகளால் கையால் பெயரிடுதல் தேவைப்படுகிறது மற்றும் செயலாக்கத்திற்கு அதிக செலவு தேவைப்படுகிறது. மேற்பார்வை செய்யப்படாத கற்றல் அதன் பயன்பாடுகளுக்கு ஒரு வரையறுக்கப்பட்ட நிறமாலையையும் கொண்டுள்ளது. மேற்பார்வையிடப்பட்ட கற்றல் மற்றும் மேற்பார்வையிடப்படாத கற்றல் வழிமுறைகளின் இந்த குறைபாடுகளை சமாளிக்க, அரை மேற்பார்வையிடப்பட்ட கற்றல் என்ற கருத்து அறிமுகப்படுத்தப்பட்டுள்ளது. பொதுவாக, இந்த கலவையில் மிகக் குறைந்த அளவு பெயரிடப்பட்ட தரவு மற்றும் அதிக அளவு பெயரிடப்படாத தரவு உள்ளது. சம்பந்தப்பட்ட அடிப்படை செயல்முறை என்னவென்றால், முதலில், புரோகிராமர் மேற்பார்வை செய்யப்படாத கற்றல் வழிமுறையைப் பயன்படுத்தி ஒத்த தரவைக் குவித்து, பின்னர் பெயரிடப்படாத மீதமுள்ள தரவை பெயரிட ஏற்கனவே உள்ள பெயரிடப்பட்ட தரவைப் பயன்படுத்துவார்.

அரை மேற்பார்வையிடப்பட்ட கற்றலின் நடைமுறை பயன்பாடுகள் - 
1. **பேச்சு பகுப்பாய்வு:** ஆடியோ கோப்புகளை பெயரிடுவது மிகவும் தீவிரமான பணியாக இருப்பதால், அரை மேற்பார்வையிடப்பட்ட கற்றல் இந்த சிக்கலைத் தீர்ப்பதற்கான மிகவும் இயற்கையான அணுகுமுறையாகும்.
2. **இணைய உள்ளடக்கம்:** வகைப்படுத்தல்ஃ ஒவ்வொரு வலைப்பக்கத்தையும் பெயரிடுவது ஒரு நடைமுறைக்கு மாறான மற்றும் சாத்தியமற்ற செயல்முறையாகும், இதனால் அரை மேற்பார்வையிடப்பட்ட கற்றல் வழிமுறைகளைப் பயன்படுத்துகிறது. கூகிள் தேடல் வழிமுறை கூட கொடுக்கப்பட்ட வினவலுக்கு ஒரு வலைப்பக்கத்தின் பொருத்தத்தை தரவரிசைப்படுத்த அரை-மேற்பார்வையிடப்பட்ட கற்றலின் மாறுபாட்டைப் பயன்படுத்துகிறது.
3. **புரத வரிசை வகைப்பாடு:** டிஎன்ஏ இழைகள் பொதுவாக மிகப் பெரியவை என்பதால், இந்தத் துறையில் அரை மேற்பார்வையிடப்பட்ட கற்றலின் எழுச்சி உடனடி.

### வலுவூட்டல் இயந்திர கற்றல்
இது ஒரு வெகுமதி முறையை நிறுவுவதன் மூலம் சிறந்த நடவடிக்கை எடுக்க சோதனை மற்றும் பிழை மூலம் இயந்திரங்களுக்கு பயிற்சி அளிக்கிறது. வலுவூட்டல் கற்றல் மாதிரிகளுக்கு விளையாட்டுகளை விளையாட பயிற்சி அளிக்கலாம் அல்லது இயந்திரம் சரியான முடிவுகளை எடுக்கும்போது சொல்வதன் மூலம் தன்னாட்சி வாகனங்களை ஓட்டுவதற்கு பயிற்சி அளிக்கலாம், இது காலப்போக்கில் என்ன நடவடிக்கைகள் எடுக்க வேண்டும் என்பதை அறிய உதவுகிறது.


வலுவூட்டல் கற்றலின் நடைமுறை பயன்பாடுகள் - 
1. **உற்பத்தி அமைப்புகள்** 
e.g. கூகுள் கிளவுட் ஆட்டோஎம்எல், ஃபேஸ்புக் ஹொரைசன், பரிந்துரை, விளம்பரம், தேடல் 
2. **தன்னிச்சையாக வாகனம் ஓட்டுதல்**
3. **வணிக மேலாண்மை** 
e.g. வாகன ரூட்டிங் சிக்கலைத் தீர்ப்பது, ஈ-காமர்ஸில் மோசடி நடத்தை, வாடிக்கையாளர் தொடர்புகளிலிருந்து ஒரே நேரத்தில் வலுவூட்டல் கற்றல்
4. **பரிந்துரை அமைப்புகள்** 
e.g. தேடல், பரிந்துரை மற்றும் ஆன்லைன் விளம்பரம்
   
### இயந்திர கற்றல் பல செயற்கை நுண்ணறிவு துணைத் துறைகளுடன் தொடர்புடையதுஃ

### இயற்கை மொழி செயலாக்கம்

இயற்கையான மொழி செயலாக்கம் என்பது இயந்திர கற்றல் துறையாகும், இதில் இயந்திரங்கள் கணினிகளை நிரல் செய்ய பொதுவாகப் பயன்படுத்தப்படும் தரவு மற்றும் எண்களுக்கு பதிலாக மனிதர்களால் பேசப்பட்ட மற்றும் எழுதப்பட்ட இயற்கையான மொழியைப் புரிந்துகொள்ள கற்றுக்கொள்கின்றன. இது இயந்திரங்களை மொழியை அடையாளம் காணவும், அதைப் புரிந்துகொள்ளவும், அதற்கு பதிலளிக்கவும், புதிய உரையை உருவாக்கவும், மொழிகளுக்கு இடையில் மொழிபெயர்க்கவும் அனுமதிக்கிறது. இயற்கையான மொழி செயலாக்கம் சாட்போட்கள் மற்றும் சிரி அல்லது அலெக்சா போன்ற டிஜிட்டல் உதவியாளர்கள் போன்ற பழக்கமான தொழில்நுட்பத்தை செயல்படுத்துகிறது.


NLP இன் நடைமுறை பயன்பாடுகள்:
1. **கேள்வி பதில்:** கேள்வி பதில் என்பது மனிதர்கள் கேட்கும் கேள்விகளுக்கு இயற்கையான மொழியில் தானாகவே பதிலளிக்கும் அமைப்புகளை உருவாக்குவதில் கவனம் செலுத்துகிறது. 
2. **ஸ்பேம் கண்டறிதல்:** பயனரின் இன்பாக்ஸுக்கு தேவையற்ற மின்னஞ்சல்கள் வருவதைக் கண்டறிய ஸ்பேம் கண்டறிதல் பயன்படுத்தப்படுகிறது.
3. **உணர்வு பகுப்பாய்வு:** உணர்வு பகுப்பாய்வு கருத்துச் சுரங்கம் என்றும் அழைக்கப்படுகிறது. அனுப்புநரின் அணுகுமுறை, நடத்தை மற்றும் உணர்ச்சி நிலையை பகுப்பாய்வு செய்ய இது வலையில் பயன்படுத்தப்படுகிறது. இந்த பயன்பாடு NLP (இயற்கை மொழி செயலாக்கம்) மற்றும் புள்ளிவிவரங்களின் கலவையின் மூலம் உரைக்கு மதிப்புகளை ஒதுக்குவதன் மூலம் (நேர்மறை, எதிர்மறை அல்லது இயற்கையானது) மற்றும் சூழலின் மனநிலையை அடையாளம் காண்பதன் மூலம் செயல்படுத்தப்படுகிறது. (happy, sad, angry, etc.)
4. **இயந்திர மொழிபெயர்ப்பு:** உரை அல்லது உரையை ஒரு இயற்கையான மொழியிலிருந்து மற்றொரு இயற்கையான மொழிக்கு மொழிபெயர்க்க இயந்திர மொழிபெயர்ப்பு பயன்படுத்தப்படுகிறது. e.g. கூகிள் மொழிபெயர்ப்பு
5. **எழுத்து திருத்தம்:** மைக்ரோசாப்ட் கார்ப்பரேஷன் எழுத்து திருத்தத்திற்காக எம். எஸ்-வேர்ட் மற்றும் பவர்பாயிண்ட் போன்ற சொல் செயலி மென்பொருளை வழங்குகிறது.

### நரம்பியல் நெட்வொர்க்குகள்

நரம்பியல் நெட்வொர்க்குகள் பொதுவாக பயன்படுத்தப்படும், குறிப்பிட்ட வகை இயந்திர கற்றல் வழிமுறைகள் ஆகும். செயற்கை நரம்பியல் நெட்வொர்க்குகள் மனித மூளையில் வடிவமைக்கப்பட்டுள்ளன, இதில் ஆயிரக்கணக்கான அல்லது மில்லியன் கணக்கான செயலாக்க முனைகள் ஒன்றோடொன்று இணைக்கப்பட்டு அடுக்குகளாக ஒழுங்கமைக்கப்பட்டுள்ளன.

ஒரு செயற்கை நரம்பியல் வலையமைப்பில், செல்கள் அல்லது முனைகள், ஒவ்வொரு செல் செயலாக்க உள்ளீடுகளுடன் இணைக்கப்பட்டு, மற்ற நரம்பணுக்களுக்கு அனுப்பப்படும் ஒரு வெளியீட்டை உற்பத்தி செய்கின்றன. பெயரிடப்பட்ட தரவு முனைகள் அல்லது செல்கள் வழியாக நகர்கிறது, ஒவ்வொரு கலமும் வெவ்வேறு செயல்பாட்டைச் செய்கிறது. ஒரு படத்தில் பூனை இருக்கிறதா இல்லையா என்பதை அடையாளம் காண பயிற்சி பெற்ற ஒரு நரம்பியல் வலையமைப்பில், வெவ்வேறு முனைகள் தகவலை மதிப்பீடு செய்து, ஒரு படத்தில் பூனை இருக்கிறதா என்பதைக் குறிக்கும் வெளியீட்டை அடையும்.

நரம்பியல் நெட்வொர்க்குகளின் நடைமுறை பயன்பாடுகள்:
1. **பங்குச் சந்தை கணிப்பு:** நிகழ்நேரத்தில் ஒரு வெற்றிகரமான பங்கு கணிப்பைச் செய்ய, ஒரு மல்டிலேயர் பெர்செப்ட்ரான் எம். எல். பி (ஃபீட்ஃபார்வர்டு செயற்கை நுண்ணறிவு வழிமுறையின் வகுப்பு) பயன்படுத்தப்படுகிறது. எம்எல்பி பல அடுக்குகளின் முனைகளைக் கொண்டுள்ளது, மேலும் இந்த அடுக்குகள் ஒவ்வொன்றும் அடுத்தடுத்த முனைகளுடன் முழுமையாக இணைக்கப்பட்டுள்ளன. பங்குகளின் கடந்தகால செயல்திறன், வருடாந்திர வருமானம் மற்றும் இலாப நோக்கற்ற விகிதங்கள் எம்எல்பி மாதிரியை உருவாக்குவதற்கு பரிசீலிக்கப்படுகின்றன.
2. **சமூக ஊடகங்கள்:** பல அடுக்கு பெர்செப்ட்ரான்கள் சமூக ஊடக போக்குகளை முன்னறிவிக்கின்றன. இது சராசரி முழுமையான பிழை (MAE) ரூட் மீன் ஸ்கொயர் பிழை (RMSE) மற்றும் சராசரி ஸ்கொயர் பிழை போன்ற பல்வேறு பயிற்சி முறைகளைப் பயன்படுத்துகிறது. (MSE). பயனருக்கு பிடித்த இன்ஸ்டாகிராம் பக்கங்கள், புக்மார்க் செய்யப்பட்ட தேர்வுகள் போன்ற பல காரணிகளை எம். எல். பி கருத்தில் கொள்கிறது. சமூக ஊடக நெட்வொர்க்குகள் வழியாக தனிநபர்களின் நடத்தைகளை பகுப்பாய்வு செய்த பிறகு, தரவை மக்களின் செலவு பழக்கத்துடன் இணைக்க முடியும். எம்எல்பி ஏஎன்என் சமூக ஊடக பயன்பாடுகளிலிருந்து தரவைச் சுரண்டப் பயன்படுகிறது.  
3. **விண்வெளி:** ஏரோஸ்பேஸ் இன்ஜினியரிங் என்பது விண்கலம் மற்றும் விமானங்களின் முன்னேற்றங்களை உள்ளடக்கிய ஒரு விரிவான சொல். தவறு கண்டறிதல், உயர் செயல்திறன் கொண்ட தானியங்கி விமானி, விமானக் கட்டுப்பாட்டு அமைப்புகளைப் பாதுகாப்பது மற்றும் முக்கிய மாறும் உருவகப்படுத்துதல்களை மாதிரியாக்குவது ஆகியவை நரம்பியல் நெட்வொர்க்குகள் கையகப்படுத்திய சில முக்கிய பகுதிகளாகும். கால தாமதம் நேரியல் அல்லாத நேர மாறும் அமைப்புகளை மாதிரியாக்குவதற்கு நரம்பியல் நெட்வொர்க்குகள் பயன்படுத்தப்படலாம்.

### ஆழமான கற்றல்

ஆழமான கற்றல் நெட்வொர்க்குகள் பல அடுக்குகளைக் கொண்ட நரம்பியல் நெட்வொர்க்குகள் ஆகும். அடுக்கு நெட்வொர்க் விரிவான அளவிலான தரவை செயலாக்க முடியும் மற்றும் நெட்வொர்க்கில் உள்ள ஒவ்வொரு இணைப்பின் "எடையை" தீர்மானிக்க முடியும்-எடுத்துக்காட்டாக, ஒரு பட அங்கீகார அமைப்பில், நரம்பியல் நெட்வொர்க்கின் சில அடுக்குகள் கண்கள், மூக்கு அல்லது வாய் போன்ற ஒரு முகத்தின் தனிப்பட்ட அம்சங்களைக் கண்டறியலாம், அதே நேரத்தில் மற்றொரு அடுக்கு அந்த அம்சங்கள் ஒரு முகத்தைக் குறிக்கும் வகையில் தோன்றுகிறதா என்பதைக் கூற முடியும்.  

ஆழமான கற்றலின் நடைமுறை பயன்பாடுகள்:
1. **தானியங்கி உரை உருவாக்கம்-** உரையின் தொகுப்பு கற்றுக்கொள்ளப்படுகிறது, மேலும் இந்த மாதிரியிலிருந்து, புதிய உரை உருவாக்கப்படுகிறது, சொல்-மூலம்-சொல் அல்லது எழுத்து-மூலம்-எழுத்து. பின்னர் இந்த மாதிரி எழுத்துப்பிழை, நிறுத்தற்குறி மற்றும் வாக்கியங்களை எவ்வாறு உருவாக்குவது என்பதைக் கற்றுக்கொள்ளும் திறன் கொண்டது, அல்லது அது பாணியைக் கூட பிடிக்கலாம்.
2. **சுகாதாரம்-** பல்வேறு நோய்களைக் கண்டறிந்து அவற்றுக்கு சிகிச்சையளிக்க உதவுகிறது.
3. **தானியங்கி இயந்திர மொழிபெயர்ப்பு-**ஒரு மொழியில் உள்ள சில சொற்கள், வாக்கியங்கள் அல்லது சொற்றொடர்கள் மற்றொரு மொழியாக மாற்றப்படுகின்றன (Deep Learning is achieving top results in the areas of text and images).
4. **பட அங்கீகாரம்-** படங்களில் உள்ள மக்கள் மற்றும் பொருள்களை அடையாளம் கண்டு அடையாளம் காணும் அதே போல் உள்ளடக்கம் மற்றும் சூழலைப் புரிந்துகொள்கிறது. இந்த பகுதி ஏற்கனவே கேமிங், சில்லறை விற்பனை, சுற்றுலா போன்றவற்றில் பயன்படுத்தப்படுகிறது.
5. **பூகம்பங்களை கணிப்பது-** பூகம்பங்களை கணிப்பதில் பயன்படுத்தப்படும் விஸ்கோலாஸ்டிக் கணக்கீடுகளைச் செய்ய கணினிக்கு கற்றுக்கொடுக்கிறது.

## [வலை தொழில்நுட்ப வல்லுநர்](Web%20Technology/WebTechnology.md#web-tecnology)
வலை தொழில்நுட்பம் என்பது இணையத்தில் பல்வேறு வகையான சாதனங்களுக்கிடையேயான தகவல்தொடர்பு செயல்பாட்டில் பயன்படுத்தப்படும் பல்வேறு கருவிகள் மற்றும் நுட்பங்களைக் குறிக்கிறது. வலைப்பக்கங்களை அணுக ஒரு வலை உலாவி பயன்படுத்தப்படுகிறது. வலை உலாவிகளை இணையத்தில் உரை, தரவு, படங்கள், அனிமேஷன் மற்றும் வீடியோவைக் காண்பிக்கும் நிரல்கள் என்று வரையறுக்கலாம். உலகளாவிய வலையில் ஹைப்பர்லிங்க் செய்யப்பட்ட வளங்களை வலை உலாவிகளால் வழங்கப்பட்ட மென்பொருள் இடைமுகங்களைப் பயன்படுத்தி அணுகலாம்.
### வலைத் தொழில்நுட்பத்தை பின்வரும் பிரிவுகளாக வகைப்படுத்தலாம்ஃ
- உலகளாவிய வலை (WWW)
உலகளாவிய வலை பல்வேறு தொழில்நுட்பங்களை அடிப்படையாகக் கொண்டதுஃ வலை உலாவிகள், ஹைபர்டெக்ஸ்ட் மார்க்அப் மொழி (HTML) மற்றும் ஹைபர்டெக்ஸ்ட் டிரான்ஸ்பர் புரோட்டோகால். (HTTP).
- வலை உலாவி
வலை உலாவி என்பது www ஐ ஆராய்வதற்கான ஒரு பயன்பாட்டு மென்பொருளாகும். (World Wide Web). இது சேவையகத்திற்கும் வாடிக்கையாளருக்கும் இடையே ஒரு இடைமுகத்தை வழங்குகிறது மற்றும் வலை ஆவணங்கள் மற்றும் சேவைகளுக்கான சேவையகத்திற்கான கோரிக்கைகளை வழங்குகிறது.
- வலை சேவையகம்
ஒரு வலை சேவையகம் என்பது பயனர்களின் நெட்வொர்க் கோரிக்கைகளை செயலாக்கும் ஒரு நிரலாகும், மேலும் வலைப்பக்கங்களை உருவாக்கும் கோப்புகளுடன் அவர்களுக்கு சேவை செய்கிறது. இந்த பரிமாற்றம் ஹைபர்டெக்ஸ்ட் பரிமாற்ற நெறிமுறையைப் பயன்படுத்தி நடைபெறுகிறது. (HTTP).
- வலைப்பக்கங்கள்
வலைப்பக்கம் என்பது உலகளாவிய வலையுடன் இணைக்கப்பட்ட ஒரு டிஜிட்டல் ஆவணம் மற்றும் வலை உலாவியைக் கொண்ட இணையத்துடன் இணைக்கப்பட்ட எவரும் பார்க்க முடியும்.
- இணைய மேம்பாடு
வலை மேம்பாடு என்பது வலைத்தளங்களை உருவாக்குவது, உருவாக்குவது மற்றும் பராமரிப்பதைக் குறிக்கிறது. வலை வடிவமைப்பு, வலை வெளியீடு, வலை நிரலாக்கம் மற்றும் தரவுத்தள மேலாண்மை போன்ற அம்சங்கள் இதில் அடங்கும். இது இணையம், i.e., வலைத்தளங்களில் செயல்படும் ஒரு பயன்பாட்டின் உருவாக்கம் ஆகும்.
### வலை மேம்பாட்டை இரண்டு வழிகளில் வகைப்படுத்தலாம்:
### வளர்ச்சியை முன்னிறுத்துதல்
பயனர் நேரடியாக தொடர்பு கொள்ளும் வலைத்தளத்தின் பகுதி முன் முனை என்று அழைக்கப்படுகிறது. இது பயன்பாட்டின் 'கிளையன்ட் சைட்' என்றும் குறிப்பிடப்படுகிறது.
### பின்புல மேம்பாடு
பின்தளம் என்பது ஒரு வலைத்தளத்தின் சேவையக பக்கமாகும். இது பயனர்கள் பார்க்கவோ தொடர்பு கொள்ளவோ முடியாத வலைத்தளத்தின் ஒரு பகுதியாகும். மென்பொருளின் ஒரு பகுதியே பயனர்களுடன் நேரடி தொடர்பில் வராது. இது தரவைச் சேமிக்கவும் ஒழுங்கமைக்கவும் பயன்படுத்தப்படுகிறது.


# [நெட்வொர்க்](Networking/readme.md#networking)
கணினி வலையமைப்பு என்பது நெட்வொர்க் முனைகளில் அமைந்துள்ள அல்லது வழங்கப்பட்ட வளங்களைப் பகிர்ந்து கொள்ளும் கணினிகளின் தொகுப்பாகும். கணினிகள் ஒருவருக்கொருவர் தொடர்பு கொள்ள டிஜிட்டல் இணைப்புகள் மூலம் பொதுவான தகவல்தொடர்பு நெறிமுறைகளைப் பயன்படுத்துகின்றன. இந்த ஒன்றோடொன்று இணைப்புகள் பல்வேறு நெட்வொர்க் இடவமைப்புகளில் ஏற்பாடு செய்யப்படக்கூடிய இயற்பியல் கம்பி, ஒளியியல் மற்றும் வயர்லெஸ் ரேடியோ-அதிர்வெண் முறைகளை அடிப்படையாகக் கொண்ட தொலைத்தொடர்பு நெட்வொர்க் தொழில்நுட்பங்களால் ஆனவை.

ஒரு கணினி வலையமைப்பின் முனைகளில் தனிப்பட்ட கணினிகள், சேவையகங்கள், நெட்வொர்க்கிங் வன்பொருள் அல்லது பிற சிறப்பு அல்லது பொது நோக்க ஹோஸ்ட்கள் இருக்கலாம். அவை நெட்வொர்க் முகவரிகளால் அடையாளம் காணப்படுகின்றன மற்றும் புரவலன் பெயர்களைக் கொண்டிருக்கலாம். புரவலன் பெயர்கள் முனைகளுக்கு மறக்கமுடியாத லேபிள்களாக செயல்படுகின்றன, ஆரம்ப பணிக்குப் பிறகு அரிதாகவே மாற்றப்படுகின்றன. நெட்வொர்க் முகவரிகள் இணைய நெறிமுறை போன்ற தகவல்தொடர்பு நெறிமுறைகள் மூலம் முனைகளைக் கண்டறிந்து அடையாளம் காண உதவுகின்றன.

கணினி நெட்வொர்க்குகள் பல அளவுகோல்களால் வகைப்படுத்தப்படலாம், இதில் சமிக்ஞைகளை எடுத்துச் செல்ல பயன்படுத்தப்படும் பரிமாற்ற ஊடகம், அலைவரிசை, நெட்வொர்க் போக்குவரத்தை ஒழுங்கமைப்பதற்கான தகவல்தொடர்பு நெறிமுறைகள், நெட்வொர்க் அளவு, இடவியல், போக்குவரத்து கட்டுப்பாட்டு பொறிமுறை மற்றும் நிறுவன நோக்கம் ஆகியவை அடங்கும்.

## நெட்வொர்க்கிங் வகைகள்

கணினி வலையமைப்பில் இரண்டு முக்கிய வகைகள் உள்ளன:
- கம்பி நெட்வொர்க்கிங்: கம்பி நெட்வொர்க்கிங் முனைகளுக்கு இடையில் போக்குவரத்துக்கு ஒரு இயற்பியல் ஊடகத்தைப் பயன்படுத்த வேண்டும். குறைந்த செலவு மற்றும் ஆயுள் காரணமாக பிரபலமான செப்பு அடிப்படையிலான ஈதர்நெட் கேபிளிங், பொதுவாக வணிகங்கள் மற்றும் வீடுகளில் டிஜிட்டல் தகவல்தொடர்புகளுக்கு பயன்படுத்தப்படுகிறது. மாற்றாக, ஆப்டிகல் ஃபைபர் அதிக தூரம் மற்றும் வேகமான வேகத்தில் தரவை கொண்டு செல்ல பயன்படுத்தப்படுகிறது, ஆனால் இது அதிக செலவுகள் மற்றும் மிகவும் பலவீனமான கூறுகள் உட்பட பல பரிமாற்றங்களைக் கொண்டுள்ளது.
- வயர்லெஸ் நெட்வொர்க்கிங்: வயர்லெஸ் நெட்வொர்க்கிங் வானொலி அலைகளைப் பயன்படுத்தி தரவை காற்றில் கொண்டு செல்கிறது, இது சாதனங்களை எந்த கேபிளிங்கும் இல்லாமல் ஒரு நெட்வொர்க்குடன் இணைக்க உதவுகிறது. வயர்லெஸ் லேன்கள் மிகவும் நன்கு அறியப்பட்ட மற்றும் பரவலாக பயன்படுத்தப்படும் வயர்லெஸ் நெட்வொர்க்கிங் வடிவமாகும். மைக்ரோவேவ், செயற்கைக்கோள், செல்லுலார் மற்றும் புளூடூத் ஆகியவை மாற்று வழிகளில் அடங்கும்.
## OSI மாதிரி
OSI என்பது **Open Systems Interconnection** ஐ குறிக்கிறது. இது 1984 ஆம் ஆண்டில் ஐ. எஸ். ஓ-'**தரப்படுத்தலுக்கான சர்வதேச அமைப்பு**' ஆல் உருவாக்கப்பட்டது. இது 7 அடுக்கு கட்டமைப்பாகும், ஒவ்வொரு அடுக்கும் செயல்பட குறிப்பிட்ட செயல்பாட்டைக் கொண்டுள்ளது. இந்த ஏழு அடுக்குகளும் உலகெங்கிலும் ஒரு நபரிடமிருந்து மற்றொரு நபருக்கு தரவை அனுப்ப ஒத்துழைப்புடன் செயல்படுகின்றன. 

### **1\. இயற்பியல் அடுக்கு (அடுக்கு 1)**

OSI குறிப்பு மாதிரியின் மிகக் குறைந்த அடுக்கு இயற்பியல் அடுக்கு ஆகும். சாதனங்களுக்கிடையேயான உண்மையான உடல் இணைப்புக்கு இது பொறுப்பாகும். இயற்பியல் அடுக்கு **பிட்கள்** வடிவில் தகவல்களைக் கொண்டுள்ளது. தனிப்பட்ட பிட்களை ஒரு முனையிலிருந்து அடுத்த முனைக்கு அனுப்புவதற்கு இது பொறுப்பாகும். தரவைப் பெறும்போது, இந்த அடுக்கு சமிக்ஞையைப் பெற்று, அதை 0 கள் மற்றும் 1 களாக மாற்றி, தரவு இணைப்பு அடுக்குக்கு அனுப்பும், இது சட்டகத்தை மீண்டும் ஒன்றாக இணைக்கும்.  

![](Networking/OSI%20Model/img/computer-network-osi-model-layers-bits.png)

இயற்பியல் அடுக்கின் செயல்பாடுகள் பின்வருமாறு:

1. **பிட் ஒத்திசைவு:** இயற்பியல் அடுக்கு ஒரு கடிகாரத்தை வழங்குவதன் மூலம் பிட்களின் ஒத்திசைவை வழங்குகிறது. இந்த கடிகாரம் அனுப்புநர் மற்றும் பெறுநர் ஆகிய இருவரையும் கட்டுப்படுத்துகிறது, இதனால் பிட் மட்டத்தில் ஒத்திசைவை வழங்குகிறது.
2. **பிட் வீத கட்டுப்பாடு:** இயற்பியல் அடுக்கு பரிமாற்ற வீதத்தை வரையறுக்கிறது, i.e., வினாடிக்கு அனுப்பப்பட்ட பிட்களின் எண்ணிக்கை.
3. **இயற்பியல் இடவியல்:** இயற்பியல் அடுக்கு ஒரு நெட்வொர்க்கில் வெவ்வேறு சாதனங்கள்/முனைகள் எவ்வாறு ஏற்பாடு செய்யப்படுகின்றன என்பதைக் குறிப்பிடுகிறது, i.e., பஸ், ஸ்டார் அல்லது மெஷ் இடவியல்.
4. **பரிமாற்ற முறை:** இணைக்கப்பட்ட இரண்டு சாதனங்களுக்கு இடையில் தரவு எவ்வாறு பாய்கிறது என்பதையும் இயற்பியல் அடுக்கு வரையறுக்கிறது. சிம்ப்ளக்ஸ், அரை-இரட்டை மற்றும் முழு-இரட்டை ஆகியவை சாத்தியமான பல்வேறு பரிமாற்ற முறைகள் ஆகும்.

### **2\. தரவு இணைப்பு அடுக்கு (DLL) (அடுக்கு 2)**

செய்தியின் முனை-க்கு-முனை விநியோகத்திற்கு தரவு இணைப்பு அடுக்கு பொறுப்பாகும். இந்த அடுக்கின் முக்கிய செயல்பாடு, இயற்பியல் அடுக்கின் மீது ஒரு முனையிலிருந்து இன்னொரு முனைக்கு தரவு பரிமாற்றம் பிழை இல்லாதது என்பதை உறுதி செய்வதாகும். ஒரு பாக்கெட் ஒரு நெட்வொர்க்கில் வரும்போது, அதன் MAC முகவரியைப் பயன்படுத்தி அதை ஹோஸ்டுக்கு அனுப்புவது DLL இன் பொறுப்பாகும்.   
தரவு இணைப்பு அடுக்கு இரண்டு துணை அடுக்குகளாக பிரிக்கப்பட்டுள்ளதுஃ  

1. தர்க்கரீதியான இணைப்பு கட்டுப்பாடு (LLC)
2. ஊடக அணுகல் கட்டுப்பாடு (MAC)

நெட்வொர்க் அடுக்கிலிருந்து பெறப்பட்ட பாக்கெட் என். ஐ. சி. யின் பிரேம் அளவைப் பொறுத்து பிரேம்களாகப் பிரிக்கப்படுகிறது.(Network Interface Card). DLL அனுப்புநர் மற்றும் பெறுநரின் MAC முகவரியையும் தலைப்பில் இணைக்கிறது. 

பெறுநரின் MAC முகவரி ஒரு ARP (முகவரி தீர்மான நெறிமுறை) கோரிக்கையை கம்பியில் வைப்பதன் மூலம் பெறப்படுகிறது, "அந்த IP முகவரி யாரிடம் உள்ளது?" மற்றும் இலக்கு ஹோஸ்ட் அதன் MAC முகவரியுடன் பதிலளிக்கும்.  

![](Networking/OSI%20Model/img/computer-network-osi-model-layers-framing.png)

தரவு இணைப்பு அடுக்கின் செயல்பாடுகள் பின்வருமாறு:  

1. **ஃப்ரேமிங்:** ஃப்ரேமிங் என்பது தரவு இணைப்பு அடுக்கின் செயல்பாடாகும். இது அனுப்புநருக்கு பெறுநருக்கு அர்த்தமுள்ள பிட்களின் தொகுப்பை அனுப்ப ஒரு வழியை வழங்குகிறது. சட்டகத்தின் தொடக்கத்திலும் முடிவிலும் சிறப்பு பிட் வடிவங்களை இணைப்பதன் மூலம் இதை அடைய முடியும்.
2. **இயற்பியல் முகவரி:** பிரேம்களை உருவாக்கிய பிறகு, தரவு இணைப்பு அடுக்கு ஒவ்வொரு பிரேமின் தலைப்பிலும் அனுப்புநர் மற்றும்/அல்லது பெறுநரின் இயற்பியல் முகவரிகளை (MAC முகவரிகள்) சேர்க்கிறது.
3. **பிழை கட்டுப்பாடு:** தரவு இணைப்பு அடுக்கு பிழை கட்டுப்பாட்டு பொறிமுறையை வழங்குகிறது, இதில் அது சேதமடைந்த அல்லது இழந்த பிரேம்களைக் கண்டறிந்து மீண்டும் அனுப்புகிறது.
4. **ஓட்ட கட்டுப்பாடு:** தரவு விகிதம் இருபுறமும் நிலையானதாக இருக்க வேண்டும், இல்லையெனில் தரவு சிதைக்கப்படலாம்; இதனால், ஓட்டக் கட்டுப்பாடு ஒப்புதலைப் பெறுவதற்கு முன்பு அனுப்பக்கூடிய தரவின் அளவை ஒருங்கிணைக்கிறது.
5. **அணுகல் கட்டுப்பாடு:** ஒரு தகவல்தொடர்பு சேனல் பல சாதனங்களால் பகிரப்படும்போது, தரவு இணைப்பு அடுக்கின் MAC துணை அடுக்கு ஒரு குறிப்பிட்ட நேரத்தில் எந்த சாதனம் சேனலின் மீது கட்டுப்பாட்டைக் கொண்டுள்ளது என்பதை தீர்மானிக்க உதவுகிறது.

### **3\. பிணைய அடுக்கு (அடுக்கு 3)**

நெட்வொர்க் அடுக்கு வெவ்வேறு நெட்வொர்க்குகளில் அமைந்துள்ள ஒரு ஹோஸ்டிலிருந்து மற்றொன்றுக்கு தரவை அனுப்புவதற்கு வேலை செய்கிறது. இது பாக்கெட் ரூட்டிங்கையும் கவனித்துக்கொள்கிறது, i.e., கிடைக்கக்கூடிய வழிகளின் எண்ணிக்கையிலிருந்து பாக்கெட்டை அனுப்புவதற்கான குறுகிய பாதையின் தேர்வு. அனுப்புநர் மற்றும் பெறுநரின் ஐபி முகவரிகள் நெட்வொர்க் அடுக்கால் தலைப்பில் வைக்கப்படுகின்றன. 

பிணைய அடுக்கின் செயல்பாடுகள் பின்வருமாறுஃ  

1. **ரூட்டிங்:** நெட்வொர்க் அடுக்கு நெறிமுறைகள் மூலத்திலிருந்து இலக்குக்கு எந்த பாதை பொருத்தமானது என்பதை தீர்மானிக்கின்றன. நெட்வொர்க் அடுக்கின் இந்த செயல்பாடு ரூட்டிங் என்று அழைக்கப்படுகிறது.
2. **தர்க்க முகவரி:** இணையத்தில் உள்ள ஒவ்வொரு சாதனத்தையும் தனித்துவமாக அடையாளம் காண, நெட்வொர்க் அடுக்கு ஒரு முகவரி திட்டத்தை வரையறுக்கிறது. அனுப்புநர் மற்றும் பெறுநரின் ஐபி முகவரிகள் நெட்வொர்க் அடுக்கால் தலைப்பில் வைக்கப்படுகின்றன. அத்தகைய முகவரி ஒவ்வொரு சாதனத்தையும் தனித்துவமாகவும் உலகளாவிய ரீதியாகவும் வேறுபடுத்துகிறது.

# [இணையம்](Internet/readme.md#internet)
இணையம் என்பது ஒன்றோடொன்று இணைக்கப்பட்ட கணினி நெட்வொர்க்குகளின் உலகளாவிய அமைப்பாகும், இது உலகளவில் பில்லியன் கணக்கான பயனர்களுக்கு சேவை செய்ய நிலையான இணைய நெறிமுறை தொகுப்பை (TCP/IP (Networking/readme. md#tcpttransmission-control-protocol)) பயன்படுத்துகிறது. இது மில்லியன் கணக்கான தனியார், பொது, கல்வி, வணிகம் மற்றும் உள்ளூர் முதல் உலகளாவிய அளவிலான அரசாங்க நெட்வொர்க்குகளைக் கொண்ட நெட்வொர்க்குகளின் வலையமைப்பாகும், இது பரந்த அளவிலான மின்னணு, வயர்லெஸ் மற்றும் ஆப்டிகல் நெட்வொர்க்கிங் தொழில்நுட்பங்களால் இணைக்கப்பட்டுள்ளது. ஒன்றோடொன்று இணைக்கப்பட்ட ஹைபர்டெக்ஸ்ட் ஆவணங்கள் மற்றும் உலகளாவிய வலையின் பயன்பாடுகள் ([WWW] (Internet/readme. md#world-wide-web-www)) மற்றும் மின்னஞ்சலை ஆதரிப்பதற்கான உள்கட்டமைப்பு போன்ற விரிவான தகவல் வளங்கள் மற்றும் சேவைகளை இணையம் கொண்டு செல்கிறது.

## [உலகளாவிய வலை (WWW)](Internet/readme.md#world-wide-web-www)
உலகளாவிய வலை (WWW) என்பது ஆவணங்கள் மற்றும் பிற வலை வளங்களை சீரான வள இருப்பிடங்கள் (URL கள்) ஹைபர்டெக்ஸ்ட் இணைப்புகளால் ஒன்றோடொன்று இணைக்கப்பட்டு, இணையம் வழியாக அணுகக்கூடிய ஒரு தகவல் இடமாகும். ஆங்கில விஞ்ஞானி டிம் பெர்னர்ஸ்-லீ 1989 இல் உலகளாவிய வலையை கண்டுபிடித்தார். 1990 ஆம் ஆண்டில் சுவிட்சர்லாந்தில் உள்ள CERN இல் பணிபுரிந்தபோது முதல் வலை உலாவியை எழுதினார். உலாவி 1991 இல் CERN க்கு வெளியே வெளியிடப்பட்டது, முதலில் ஜனவரி 1991 இல் தொடங்கி பிற ஆராய்ச்சி நிறுவனங்களுக்கும், ஆகஸ்ட் 1991 இல் இணையத்தில் பொது மக்களுக்கும் வெளியிடப்பட்டது.

## [இணைய நெறிமுறை (IP)](Internet/readme.md#internet-protocol-ip)
இன்டர்நெட் புரோட்டோகால் (ஐபி) என்பது ஒரு நெறிமுறை அல்லது விதிகளின் தொகுப்பாகும், இது தரவுகளின் பாக்கெட்டுகளை வழிநடத்துவதற்கும் உரையாற்றுவதற்கும் ஆகும், இதனால் அவை நெட்வொர்க்குகள் முழுவதும் பயணிக்கவும் சரியான இலக்கை அடையவும் முடியும். இணையத்தில் பயணிக்கும் தரவுகள் பாக்கெட்டுகள் எனப்படும் சிறிய துண்டுகளாகப் பிரிக்கப்படுகின்றன.

## [டிபிஎம்எஸ்]()

தரவுத்தளம் என்றால் என்ன?
-----------------
ஒரு தரவுத்தளம் என்பது நிஜ உலகின் சில அம்சங்களைக் குறிக்கும் தொடர்புடைய தரவுகளின் தொகுப்பாகும். ஒரு தரவுத்தள அமைப்பு ஒரு குறிப்பிட்ட பணிக்கான தரவுகளுடன் கட்டமைக்கப்பட்டு நிரம்பும் வகையில் வடிவமைக்கப்பட்டுள்ளது.

DBMS என்றால் என்ன?
------------
தரவுத்தள மேலாண்மை அமைப்பு (DBMS) என்பது பொருத்தமான பாதுகாப்பு நடவடிக்கைகளை கருத்தில் கொண்டு பயனர்களின் தரவை சேமித்து மீட்டெடுப்பதற்கான மென்பொருளாகும். இது தரவுத்தளத்தை கையாளும் நிரல்களின் குழுவைக் கொண்டுள்ளது. DBMS ஒரு பயன்பாட்டிலிருந்து தரவுக்கான கோரிக்கையை ஏற்றுக்கொள்கிறது மற்றும் குறிப்பிட்ட தரவை வழங்க இயக்க முறைமைக்கு அறிவுறுத்துகிறது. பெரிய அமைப்புகளில், ஒரு டிபிஎம்எஸ் பயனர்கள் மற்றும் பிற மூன்றாம் தரப்பு மென்பொருள்களை சேமித்து வைக்கவும் தரவை மீட்டெடுக்கவும் உதவுகிறது.

டிபிஎம்எஸ் பயனர்கள் தங்கள் தேவைகளுக்கு ஏற்ப தங்கள் தரவுத்தளங்களை உருவாக்க அனுமதிக்கிறது. "டிபிஎம்எஸ்" என்ற சொல் ஒரு தரவுத்தளம் மற்றும் பிற பயன்பாட்டு நிரல்களின் பயன்பாட்டை உள்ளடக்கியது. இது தரவுக்கும் மென்பொருள் பயன்பாட்டிற்கும் இடையே ஒரு இடைமுகத்தை வழங்குகிறது.

DBMS இன் எடுத்துக்காட்டு
----------------
பல்கலைக்கழக தரவுத்தளத்தின் எளிய உதாரணத்தைப் பார்ப்போம். இந்த தரவுத்தளம் பல்கலைக்கழக சூழலில் மாணவர்கள், படிப்புகள் மற்றும் தரங்கள் தொடர்பான தகவல்களை பராமரிக்கிறது. தரவுத்தளம் ஐந்து கோப்புகளாக ஒழுங்கமைக்கப்பட்டுள்ளதுஃ

* மாணவர் கோப்பு ஒவ்வொரு மாணவரின் தரவையும் சேமிக்கிறது
* பாடநெறி கோப்பு கடைகளில் ஒவ்வொரு பாடத்தின் தரவும் உள்ளது.
* பிரிவு ஒரு குறிப்பிட்ட பாடத்திட்டத்தில் பிரிவுகள் பற்றிய தகவல்களை சேமிக்கிறது.
* GRADE கோப்பு மாணவர்கள் பெறும் தரங்களை பல்வேறு பிரிவுகளில் சேமிக்கிறது.
* TUTOR கோப்பில் ஒவ்வொரு பேராசிரியரைப் பற்றிய தகவல்களும் உள்ளன.

DBMS ஐ வரையறுக்க:

* ஒவ்வொரு பதிவிலும் சேமிக்க வேண்டிய பல்வேறு வகையான தரவு கூறுகளை வரையறுப்பதன் மூலம் ஒவ்வொரு கோப்பின் பதிவுகளின் கட்டமைப்பையும் நாம் குறிப்பிட வேண்டும்.
* ஒரு தரவு உருப்படியின் மதிப்புகளைக் குறிக்க ஒரு குறியீட்டு திட்டத்தையும் நாம் பயன்படுத்தலாம். 
* அடிப்படையில், உங்கள் தரவுத்தளத்தில் பல்வேறு அட்டவணைகளுக்கு இடையில் வரையறுக்கப்பட்ட வெளிநாட்டு விசையுடன் ஐந்து அட்டவணைகள் இருக்கும்.

டிபிஎம்எஸ் வரலாறு
--------------
வரலாற்றிலிருந்து முக்கியமான அடையாளங்கள் இங்கே:


* 1960-சார்ல்ஸ் பச்மேன் முதல் டிபிஎம்எஸ் அமைப்பை வடிவமைத்தார்
* 1970-கோட் ஐபிஎம் இன் தகவல் மேலாண்மை அமைப்பு (ஐஎம்எஸ்)
* 1976-பீட்டர் சென் நிறுவனம்-உறவு மாதிரியை உருவாக்கி வரையறுத்தார், இது ஈஆர் மாடல்
* 1980 என்றும் அழைக்கப்படுகிறது-உறவு மாதிரி பரவலாக ஏற்றுக்கொள்ளப்பட்ட தரவுத்தள கூறு
* 1985-பொருள் சார்ந்த டிபிஎம்எஸ் உருவாகிறது. 1990 கள்-தொடர்புடைய டிபிஎம்எஸ் இல் பொருள் நோக்குநிலையை இணைத்தல்.
* 1991-மைக்ரோசாப்ட் எம். எஸ். அணுகலை அனுப்பியது, இது மற்ற அனைத்து தனிப்பட்ட டிபிஎம்எஸ் தயாரிப்புகளையும் இடமாற்றம் செய்யும் ஒரு தனிப்பட்ட டிபிஎம்எஸ் ஆகும்.
* 1995: முதல் இணைய தரவுத்தள பயன்பாடுகள்
* 1997: தரவுத்தள செயலாக்கத்திற்கு எக்ஸ்எம்எல் பயன்படுத்தப்பட்டது. பல விற்பனையாளர்கள் எக்ஸ்எம்எல்-ஐ டிபிஎம்எஸ் தயாரிப்புகளுடன் ஒருங்கிணைக்கத் தொடங்குகிறார்கள்.

DBMS இன் சிறப்பியல்புகள்
-------------------

ஒரு தரவுத்தள மேலாண்மை அமைப்பின் பண்புகள் மற்றும் பண்புகள் இங்கேஃ

* பாதுகாப்பை வழங்குகிறது மற்றும் பணிநீக்கத்தை நீக்குகிறது
* ஒரு தரவுத்தள அமைப்பின் தன்மையை சுயமாக விவரிப்பது
* நிரல்களுக்கும் தரவு சுருக்கத்திற்கும் இடையிலான காப்பு
* தரவின் பல பார்வைகளின் ஆதரவு
* தரவைப் பகிர்வது மற்றும் பல பயனர் பரிவர்த்தனை செயலாக்கம்
* தரவுத்தள மேலாண்மை மென்பொருள் நிறுவனங்களையும் அவற்றுக்கிடையேயான உறவுகளையும் அட்டவணைகளை உருவாக்க அனுமதிக்கிறது.
* இது ஏ. சி. ஐ. டி கருத்தை (அணுசக்தி, நிலைத்தன்மை, தனிமைப்படுத்தல் மற்றும் ஆயுள்) பின்பற்றுகிறது.
* DBMS பல பயனர் சூழலை ஆதரிக்கிறது, இது பயனர்கள் தரவை இணையாக அணுகவும் கையாளவும் அனுமதிக்கிறது.

பிரபலமான டிபிஎம்எஸ் மென்பொருள்
------------------

சில பிரபலமான டிபிஎம்எஸ் அமைப்புகளின் பட்டியல் இங்கேஃ

* MySQL
* Microsoft Access
* Oracle
* PostgreSQL 
* dBASE
* FoxPro
* SQLite
* IBM DB2
* LibreOffice base
* MariaDB
* Microsoft SQL Server போன்றவை.

## [கிரிப்டோகிராஃபி](Cryptography/readme.md#cryptography)
கிரிப்டோகிராஃபி என்பது தரவு மற்றும் தகவல்தொடர்புகளைப் பாதுகாப்பதற்கான ஒரு நுட்பமாகும். இது குறியீடுகளைப் பயன்படுத்துவதன் மூலம் தகவல் மற்றும் தகவல்தொடர்புகளைப் பாதுகாக்கும் ஒரு முறையாகும், இதனால் தகவல் நோக்கம் கொண்டவர்கள் மட்டுமே அதைப் படிக்கவும் செயலாக்கவும் முடியும். போக்குவரத்து, ஓய்வு மற்றும் பயன்பாட்டில் உள்ள தரவைப் பாதுகாக்க கிரிப்டோகிராஃபி பயன்படுத்தப்படுகிறது. முன்னொட்டு _ கிரிப்ட் _ என்றால் "மறைக்கப்பட்ட" அல்லது "ரகசியம்" என்றும், பின்னொட்டு _ கிராஃபி _ என்றால் "எழுதுதல்" என்றும் பொருள்.

### கிரிப்டோகிராஃபியின் வகைகள்
கிரிப்டோகிராஃபியில் இரண்டு வகைகள் உள்ளன:
1. [சமச்சீர் கிரிப்டோகிராஃபி](Cryptography/readme.md#symmetric-cryptography)
2. [சமச்சீரற்ற கிரிப்டோகிராஃபி](Cryptography/readme.md#asymmetric-cryptography)

### [கிரிப்டோ நாணயம்](Cryptography/CryptoCurrency/readme.md#crypto-currency)
கிரிப்டோகரன்சி என்பது ஒரு டிஜிட்டல் நாணயமாகும், இதில் குறியாக்க நுட்பங்கள் நாணய அலகுகளின் உற்பத்தியை ஒழுங்குபடுத்துவதற்கும் நிதி பரிமாற்றத்தை சரிபார்க்கவும் பயன்படுத்தப்படுகின்றன, இது ஒரு மத்திய வங்கியிலிருந்து சுயாதீனமாக செயல்படுகிறது. கிரிப்டோகரன்ஸிகள் மையப்படுத்தப்பட்ட டிஜிட்டல் நாணயம் மற்றும் மத்திய வங்கி அமைப்புகளுக்கு மாறாக பரவலாக்கப்பட்ட கட்டுப்பாட்டைப் பயன்படுத்துகின்றன. ஒவ்வொரு கிரிப்டோகரன்சியின் பரவலாக்கப்பட்ட கட்டுப்பாடு விநியோகிக்கப்பட்ட லெட்ஜர் தொழில்நுட்பத்தின் மூலம் செயல்படுகிறது, பொதுவாக ஒரு பிளாக்செயின், இது ஒரு பொது நிதி பரிவர்த்தனை தரவுத்தளமாக செயல்படுகிறது. ஒரு கிரிப்டோகரன்சியின் வரையறுக்கும் அம்சம், மற்றும் விவாதிக்கக்கூடிய வகையில் அதன் மிகவும் அன்பான கவர்ச்சி, அதன் கரிம இயல்பு; இது எந்த மத்திய அதிகாரத்தாலும் வழங்கப்படவில்லை, இது கோட்பாட்டளவில் அரசாங்க தலையீடு அல்லது கையாளுதலுக்கு எதிரானது.

## கிரிப்டோ நாணயத்தின் வகைகள் பின்வருமாறு:
1. [பணியின் சான்று](Cryptography/CryptoCurrency/ProofOfWork/readme.md#proof-of-work)
2. [பங்கின் சான்று](Cryptography/CryptoCurrency/ProofOfStake/readme.md#proof-of-stake)



### _மிகவும் பிரபலமான கிரிப்டோ நாணயங்கள் பின்வருமாறு:_
1. [பிட்காயின்](Cryptography/CryptoCurrency/ProofOfWork/Bitcoin/readme.md#bitcoin)
2. [எத்தேரியம்](Cryptography/CryptoCurrency/ProofOfStake/Ethereum/readme.md#ethereum)
3. [லிட்காயின்](Cryptography/CryptoCurrency/ProofOfWork/Litecoin/readme.md#litecoin)
4. [கார்டேனோ](Cryptography/CryptoCurrency/ProofOfStake/Cardano/readme.md#cardano)
5. [டோஜெகோயின்](Cryptography/CryptoCurrency/ProofOfWork/Dogecoin/readme.md#dogecoin)



## கணக்கீட்டு கோட்பாடு
கோட்பாட்டு கணினி அறிவியல் மற்றும் கணிதத்தில், கணக்கீட்டு கோட்பாடு என்பது ஒரு வழிமுறையைப் பயன்படுத்தி கணக்கீட்டு மாதிரியில் என்ன சிக்கல்களைத் தீர்க்க முடியும், அவற்றை எவ்வளவு திறமையாக தீர்க்க முடியும் அல்லது எந்த அளவிற்கு தீர்க்க முடியும் என்பதைக் கையாளும் கிளை ஆகும். (e.g., approximate solutions versus precise ones). இந்தத் துறை மூன்று முக்கிய கிளைகளாக பிரிக்கப்பட்டுள்ளதுஃ தானியங்கி கோட்பாடு மற்றும் முறையான மொழிகள், கணக்கீட்டு கோட்பாடு மற்றும் கணக்கீட்டு சிக்கலான கோட்பாடு, இவை கேள்வியால் இணைக்கப்பட்டுள்ளனஃ "கணினிகளின் அடிப்படை திறன்கள் மற்றும் வரம்புகள் என்ன? "என்றார்.

### ஆட்டோமேட்டா கோட்பாடு
ஆட்டோமேட்டா கோட்பாடு என்பது சுருக்க இயந்திரங்கள் மற்றும் ஆட்டோமேட்டா மற்றும் அவற்றைப் பயன்படுத்தி தீர்க்கக்கூடிய கணக்கீட்டு சிக்கல்களைப் பற்றிய ஆய்வு ஆகும். இது கோட்பாட்டு கணினி அறிவியலில் ஒரு கோட்பாடு ஆகும். ஆட்டோமேட்டா என்ற சொல் கிரேக்க வார்த்தையான ατοδματoς என்பதிலிருந்து வந்தது, இதன் பொருள் "சுயமாக செயல்படுவது, சுய விருப்பத்துடன் செயல்படுவது, சுயமாக நகர்வது" என்பதாகும். ஒரு ஆட்டோமேட்டன் (பன்மையில் ஆட்டோமேட்டா) என்பது ஒரு சுருக்க சுய-உந்துவிசை கணினி சாதனமாகும், இது முன்னரே தீர்மானிக்கப்பட்ட செயல்பாடுகளின் வரிசையை தானாகவே பின்பற்றுகிறது. வரையறுக்கப்பட்ட எண்ணிக்கையிலான நிலைகளைக் கொண்ட ஒரு தானியங்கி இயந்திரம் ஃபைனைட் ஆட்டோமேட்டன் (எஃப்ஏ) அல்லது ஃபைனைட்-ஸ்டேட் மெஷின் என்று அழைக்கப்படுகிறது. (FSM). வலதுபுறத்தில் உள்ள படம் ஒரு வரையறுக்கப்பட்ட-நிலை இயந்திரத்தை விளக்குகிறது, இது நன்கு அறியப்பட்ட வகை ஆட்டோமேட்டன் ஆகும். இந்த ஆட்டோமேட்டன் நிலைகள் (வட்டங்களால் படத்தில் குறிப்பிடப்படுகிறது) மற்றும் மாற்றங்களைக் கொண்டுள்ளது. (represented by arrows). ஆட்டோமேட்டன் உள்ளீட்டின் சின்னத்தைப் பார்க்கும்போது, அதன் மாற்றம் செயல்பாட்டின் படி, அது மற்றொரு நிலைக்கு மாறுகிறது (அல்லது குதிக்கிறது), இது முந்தைய நிலை மற்றும் தற்போதைய உள்ளீட்டு சின்னத்தை அதன் வாதங்களாக எடுத்துக்கொள்கிறது. 

### முறையான மொழிகள்
தர்க்கம், கணிதம், கணினி அறிவியல் மற்றும் மொழியியல் ஆகியவற்றில், ஒரு முறையான மொழி என்பது ஒரு எழுத்துக்களிலிருந்து எடுக்கப்பட்ட சொற்களைக் கொண்டுள்ளது மற்றும் ஒரு குறிப்பிட்ட விதிகளின் தொகுப்பின் படி நன்கு வடிவமைக்கப்பட்டுள்ளது.

ஒரு முறையான மொழியின் எழுத்துக்கள் குறியீடுகள், எழுத்துக்கள் அல்லது டோக்கன்களைக் கொண்டுள்ளன, அவை மொழியின் சரங்களாக இணைக்கப்படுகின்றன.[1] இந்த எழுத்துக்களின் சின்னங்களிலிருந்து இணைக்கப்பட்ட ஒவ்வொரு சரமும் ஒரு சொல் என்றும், ஒரு குறிப்பிட்ட முறையான மொழியைச் சேர்ந்த சொற்கள் சில நேரங்களில் நன்கு உருவாக்கப்பட்ட சொற்கள் அல்லது நன்கு உருவாக்கப்பட்ட சூத்திரங்கள் என்றும் அழைக்கப்படுகின்றன. ஒரு முறையான மொழி பெரும்பாலும் வழக்கமான இலக்கணம் அல்லது சூழல் இல்லாத இலக்கணம் போன்ற முறையான இலக்கணத்தைப் பயன்படுத்தி வரையறுக்கப்படுகிறது, இது அதன் உருவாக்கம் விதிகளைக் கொண்டுள்ளது.

கணினி அறிவியலில், முறையான மொழிகள் மற்றவற்றுடன், நிரலாக்க மொழிகளின் இலக்கணத்தை வரையறுப்பதற்கான அடிப்படையாகவும், இயற்கையான மொழிகளின் துணைக்குழுக்களின் முறைப்படுத்தப்பட்ட பதிப்புகளாகவும் பயன்படுத்தப்படுகின்றன, இதில் மொழியின் சொற்கள் குறிப்பிட்ட அர்த்தங்கள் அல்லது சொற்பொருள்களுடன் தொடர்புடைய கருத்துக்களைக் குறிக்கின்றன. கணக்கீட்டு சிக்கலான கோட்பாட்டில், முடிவு சிக்கல்கள் பொதுவாக முறையான மொழிகளாக வரையறுக்கப்படுகின்றன மற்றும் சிக்கலான வகுப்புகள் வரையறுக்கப்பட்ட கணக்கீட்டு சக்தியைக் கொண்ட இயந்திரங்களால் பகுப்பாய்வு செய்யக்கூடிய முறையான மொழிகளின் தொகுப்புகளாக வரையறுக்கப்படுகின்றன. தர்க்கம் மற்றும் கணிதத்தின் அடித்தளங்களில், முறையான மொழிகள் தன்னியக்க அமைப்புகளின் தொடரமைப்பைக் குறிக்கப் பயன்படுத்தப்படுகின்றன, மேலும் கணித சம்பிரதாயம் என்பது அனைத்து கணிதங்களையும் முறையான மொழிகளின் சொற்பொருள் கையாளுதலுக்கு இந்த வழியில் குறைக்க முடியும் என்ற தத்துவமாகும். 

### கணக்கீட்டு கோட்பாடு
கணக்கீட்டு கோட்பாடு, மறுநிகழ்வு கோட்பாடு என்றும் அழைக்கப்படுகிறது, இது கணித தர்க்கம், கணினி அறிவியல் மற்றும் கணக்கீட்டு கோட்பாடு ஆகியவற்றின் ஒரு கிளை ஆகும், இது 1930 களில் கணக்கிடக்கூடிய செயல்பாடுகள் மற்றும் டூரிங் டிகிரிகள் பற்றிய ஆய்வுடன் உருவானது. பொதுப்படுத்தப்பட்ட கணக்கீட்டு மற்றும் வரையறை பற்றிய ஆய்வை உள்ளடக்கும் வகையில் இந்தத் துறை விரிவடைந்துள்ளது. இந்த பகுதிகளில், கணக்கீட்டு கோட்பாடு ஆதாரக் கோட்பாடு மற்றும் பயனுள்ள விளக்க தொகுப்புக் கோட்பாட்டுடன் ஒன்றுடன் ஒன்று இணைகிறது. 

### கணக்கீட்டு சிக்கலான கோட்பாடு
கோட்பாட்டு கணினி அறிவியல் மற்றும் கணிதத்தில், கணக்கீட்டு சிக்கலான கோட்பாடு கணக்கீட்டு சிக்கல்களை அவற்றின் வள பயன்பாட்டிற்கு ஏற்ப வகைப்படுத்துவதிலும், இந்த வகுப்புகளை ஒருவருக்கொருவர் தொடர்புபடுத்துவதிலும் கவனம் செலுத்துகிறது. கணக்கீட்டு சிக்கல் என்பது கணினி மூலம் தீர்க்கப்படும் ஒரு பணியாகும். ஒரு கணக்கீட்டு சிக்கலை ஒரு வழிமுறை போன்ற கணித நடவடிக்கைகளின் இயந்திர பயன்பாட்டின் மூலம் தீர்க்க முடியும்.

அல்காரிதம் எதுவாக இருந்தாலும், அதன் தீர்வுக்கு குறிப்பிடத்தக்க வளங்கள் தேவைப்பட்டால் ஒரு சிக்கல் இயல்பாகவே கடினமாக கருதப்படுகிறது. இந்தக் கோட்பாடு இந்த சிக்கல்களை ஆய்வு செய்வதற்கும், அவற்றின் கணக்கீட்டு சிக்கலை அளவிடுவதற்கும் கணக்கீட்டு மாதிரிகளை அறிமுகப்படுத்துவதன் மூலம் இந்த உள்ளுணர்வை முறைப்படுத்துகிறது, i.e., நேரம் மற்றும் சேமிப்பு போன்ற அவற்றைத் தீர்க்க தேவையான வளங்களின் எண்ணிக்கை. தகவல்தொடர்பு அளவு (தகவல்தொடர்பு சிக்கலில் பயன்படுத்தப்படுகிறது) ஒரு சுற்றில் உள்ள வாயில்களின் எண்ணிக்கை (சுற்று சிக்கலில் பயன்படுத்தப்படுகிறது) மற்றும் செயலிகளின் எண்ணிக்கை போன்ற சிக்கலான பிற அளவீடுகளும் பயன்படுத்தப்படுகின்றன. (used in parallel computing). கணக்கீட்டு சிக்கலான கோட்பாட்டின் பாத்திரங்களில் ஒன்று, கணினிகளால் என்ன செய்ய முடியும் மற்றும் செய்ய முடியாது என்பதற்கான நடைமுறை வரம்புகளை தீர்மானிப்பதாகும். ஏழு மில்லினியம் பரிசு சிக்கல்களில் ஒன்றான P vs NP சிக்கல், கணக்கீட்டு சிக்கலான துறைக்கு அர்ப்பணிக்கப்பட்டுள்ளது.[1]

கோட்பாட்டு கணினி அறிவியலில் நெருங்கிய தொடர்புடைய துறைகள் வழிமுறைகள் மற்றும் கணக்கீட்டு கோட்பாட்டின் பகுப்பாய்வு ஆகும். வழிமுறைகளின் பகுப்பாய்விற்கும் கணக்கீட்டு சிக்கலான கோட்பாட்டிற்கும் இடையிலான ஒரு முக்கிய வேறுபாடு என்னவென்றால், முந்தையது ஒரு சிக்கலைத் தீர்க்க ஒரு குறிப்பிட்ட வழிமுறையால் தேவைப்படும் வளங்களின் எண்ணிக்கையை பகுப்பாய்வு செய்வதில் அர்ப்பணிக்கப்பட்டுள்ளது, அதேசமயம் பிந்தையது ஒரே சிக்கலைத் தீர்க்க பயன்படுத்தக்கூடிய அனைத்து வழிமுறைகளையும் பற்றி மிகவும் பொதுவான கேள்வியைக் கேட்கிறது. மேலும் துல்லியமாக, கணக்கீட்டு சிக்கலான கோட்பாடு பொருத்தமான கட்டுப்படுத்தப்பட்ட வளங்களுடன் தீர்க்கக்கூடிய அல்லது தீர்க்க முடியாத சிக்கல்களை வகைப்படுத்த முயற்சிக்கிறது. இதையொட்டி, கிடைக்கக்கூடிய வளங்களுக்கு கட்டுப்பாடுகளை விதிப்பதே கணக்கீட்டு சிக்கலை கணக்கீட்டு கோட்பாட்டிலிருந்து வேறுபடுத்துகிறதுஃ பிந்தைய கோட்பாடு, கொள்கையளவில், எந்த வகையான சிக்கல்களை வழிமுறையாக தீர்க்க முடியும் என்று கேட்கிறது.
