<h1 align="center">Diretrizes de Contribuição</h1>
<h4 align="center">
    <p>
        <a href="https://github.com/shhossain/computer_science/blob/main/README.md">English</a> |
        <a href="https://github.com/shhossain/computer_science/blob/main/README_es.md">Español</a> |
        <a href="https://github.com/shhossain/computer_science/blob/main/README_fr.md">Français</a> |
        <a href="https://github.com/shhossain/computer_science/blob/main/README_bn.md">বাংলা</a> |
        <a href="https://github.com/shhossain/computer_science/blob/main/README_ta.md">தமிழ்</a> |
        <a href="https://github.com/shhossain/computer_science/blob/main/README_guj.md">ગુજરાતી</a> |
        <b>Portuguese</b> |
        <a href="https://github.com/shhossain/computer_science/blob/main/README_ro.md">Română</a>
    </p>
</h4>

Se você está interessado em contribuir para este projeto, por favor, reserve um momento para revisar [CONTRIBUTING.md](https://github.com/shhossain/computer_science/blob/main/CONTRIBUTING.md) para obter instruções detalhadas sobre como começar. Suas contribuições são muito apreciadas!



## Tabela de Conteúdo

- [Introdução](#introdução)
- [Computador Eletrônico](#computador-eletrônico)
- [Lógica Booleana](#lógica-booleana)
- [Sistemas Numéricos](#Sistemas-Numéricos)
- [Unidade Central de Processamento (CPU)](#Unidade-Central-de-Processamento-CPU)
- [Registradores, Cache e RAM](#Registradores-Cache-e-RAM)
- [Instruções e Programas](#Instruções-e-Programas)
- [Linguagens de Programação](#Linguagens-de-Programação)
- [Tipos de Dados](#Tipos-de-Dadoss)
- [Declarações e Funções](#Declarações-e-Funções)
- [Estruturas de Dados](#Estruturas-de-Dados)
- [Algoritmos](#Algoritmos)
- [Alan Turing](#alan-turing)
- [Engenharia de Software](#Engenharia-de-Software)
- [Circuitos Integrados](#Circuitos-Integrados)
- [Programação Orientada a Objetos](#Programação-Orientada-a-Objetos)
- [Programação Funcional](#Programação-Funcional)
- [Sistemas Operacionais](#Sistemas-Operacionais)
- [Memória e Armazenamento](#Memória-e-Armazenamento)
- [Sistema de Arquivos](#Sistema-de-Arquivos)
- [Computação em Nuvem](#Computação-em-Nuvem)
- [Aprendizado de Máquina](#Aprendizado-de-Máquina)
- [Tecnologia da Web](#Tecnologia-da-Web)
- [Redes](#Redes)
- [Internet](#internet)
- [SGBD (Sistema de Gerenciamento de Banco de Dados)](#SGBD-Sistema-de-Gerenciamento-de-Banco-de-Dados)
- [Criptografia](#Criptografia)
- [Teoria da Computação](#Teoria-da-Computação)


## Introdução

A ciência da computação é o estudo de computadores e computação, bem como suas aplicações teóricas e práticas. A ciência da computação aplica os princípios da matemática, engenharia e lógica a uma infinidade de problemas. Isso inclui a formulação de algoritmos, o desenvolvimento de software/hardware e a inteligência artificial.
## [Computador Eletrônico](Electronic%20Computer/readme.md)

Um dispositivo que calcula, especialmente uma máquina eletrônica programável que realiza operações matemáticas ou lógicas em alta velocidade ou reúne, armazena, correlaciona ou de outra forma processa informações.

## [Lógica Booleana](Boolean%20Logic/readme.md)

A lógica booleana é um ramo da matemática que lida com os valores de verdade e falsidade. É um sistema lógico que utiliza apenas dois valores, 0 e 1, para representar falso e verdadeiro, respectivamente. Também é conhecida como álgebra booleana, nomeada em homenagem a George Boole, que a descreveu pela primeira vez em 1854.
### Operadores Booleanos Comuns
| Operador | Nome | Descrição |
| :------: | :--: | :-------------------------------------: |
|    !     | NÃO  | Nega o valor do operando. |
|    &&    | E    | Retorna **verdadeiro** se ambos os operandos forem verdadeiros. |
|   \|\|   | OU   | Retorna **verdadeiro** se um ou todos os operandos forem verdadeiros. |

### Operadores Booleanos Úteis
| Operador | Nome | Descrição |
| :------: | :--: | :-------------------------------------: |
|    ()    | Parênteses     | Permite agrupar palavras-chave e controlar a ordem na qual os termos serão pesquisados. |
|    “”    | Aspas | Fornece resultados com a frase exata. |
|   *      | Asterisco | Fornece resultados que contenham uma variação da palavra-chave. |
|   ⊕     | XOR  | Retorna **verdadeiro** se os operandos forem diferentes. |
|   ⊽      | NOR  | Retorna **verdadeiro** se todos os operandos forem falsos. |
|   ⊼      | NAND | Retorna **falso** somente se ambos os valores de suas duas entradas forem verdadeiros.
## [Sistemas Numéricos](Number%20System/readme.md#number-systems)

Os sistemas numéricos são sistemas matemáticos para expressar números. Um sistema numérico consiste em um conjunto de símbolos que são usados para representar números e um conjunto de regras para manipular esses símbolos. Os símbolos usados em um sistema numérico são chamados de numerais.

### [Tipos de Sistemas Numéricos](Number%20System/readme.md#types-of-number-systems)
- [Sistema Numérico Posicional](Number%20System/readme.md#positional-numeral-system)
- [Sistema de Notação de Valor de Sinal](Number%20System/readme.md#sign-value-notation-system)

### [Sistemas Numéricos Posicionais Comuns](Number%20System/readme.md#common-positional-number-systems)
- [Binário](Sistema%20Num%C3%A9rico/readme.md#bin%C3%A1rio)
- [Octal](Sistema%20Num%C3%A9rico/readme.md#octal)
- [Decimal](Sistema%20Num%C3%A9rico/readme.md#decimal)
- [Hexadecimal](Sistema%20Num%C3%A9rico/readme.md#hexadecimal)
### Importância do Sistema Binário

O sistema binário é um sistema numérico de base 2 inventado por Gottfried Leibniz, composto apenas por dois números ou dígitos: 0 (zero) e 1 (um). Este sistema numérico é a base para todo o código binário, que é usado para escrever dados digitais, como as instruções do processador de computador usadas diariamente. Os 0s e 1s no sistema binário representam DESLIGADO ou LIGADO, respectivamente. Em um transistor, um "0" representa a ausência de fluxo de eletricidade, e um "1" representa que a eletricidade está autorizada a fluir. Dessa forma, os números são representados fisicamente dentro do dispositivo de computação, permitindo cálculos.

O binário ainda é a linguagem principal dos computadores e é usado em eletrônica e hardware de computadores pelos seguintes motivos:

- É um design simples e elegante.
- O método 0 e 1 do binário é rápido para detectar o estado desligado (falso) ou ligado (verdadeiro) de um sinal elétrico.
- Ter apenas dois estados espaçados longe em um sinal elétrico torna-o menos suscetível a interferências elétricas.
- Os polos positivos e negativos de mídia magnética são rapidamente traduzidos para binário.
- O binário é a maneira mais eficiente de controlar circuitos lógicos.
## [Unidade Central de Processamento (CPU)](CPU/readme.md#central-processing-unitcpu)

A Unidade Central de Processamento (CPU) é a parte mais importante de qualquer computador. A CPU envia sinais para controlar as outras partes do computador, quase como o cérebro controla o corpo. A CPU é uma máquina eletrônica que opera com uma lista de tarefas de computador, chamada de instruções. Ela lê a lista de instruções e as executa em ordem. Uma lista de instruções que uma CPU pode executar é chamada de programa de computador. Uma CPU pode processar mais de uma instrução por vez em seções chamadas "núcleos". Uma CPU com quatro núcleos pode processar quatro programas ao mesmo tempo. A CPU em si é composta por três componentes principais. Eles são:
1. [Unidade de Memória ou Armazenamento](CPU/readme.md#memory-or-storage-unit)
2. [Unidade de Controle](CPU/readme.md#control-unit)
3. [Unidade Aritmética e Lógica (ALU)](CPU/readme.md#arithmetic-and-logic-unit-alu)


## [Registros, Cache e RAM](/Registros%20Cache%20e%20RAM)

### [Registro](/Registros%20Cache%20e%20RAM/readme.md#register)
Registros são pequenas quantidades de memória de alta velocidade contidas dentro da CPU. Registros são uma coleção de "flip-flops" (um circuito usado para armazenar 1 bit de memória). Eles são usados pelo processador para armazenar pequenas quantidades de dados necessários durante o processamento. Uma CPU pode ter vários conjuntos de registros chamados "núcleos". Os registros também auxiliam nas operações aritméticas e lógicas.

As operações aritméticas são cálculos matemáticos realizados pela CPU em dados numéricos armazenados nos registros. Essas operações incluem adição, subtração, multiplicação e divisão. Operações lógicas são cálculos booleanos realizados pela CPU em dados binários armazenados nos registros. Essas operações incluem comparações (por exemplo, testar se dois valores são iguais) e operações lógicas (por exemplo, E, OU, NÃO).

Os registros são essenciais para realizar essas operações, pois permitem que a CPU acesse e manipule rapidamente pequenas quantidades de dados. Ao armazenar dados frequentemente acessados nos registros, a CPU pode evitar o processo mais lento de recuperação de dados da memória.

Quantidades maiores de dados podem ser armazenadas em Cache (pronunciado como "cache"), uma memória muito rápida localizada no mesmo circuito integrado que os registros. O Cache é usado para dados frequentemente acessados enquanto o programa é executado. Quantidades ainda maiores de dados podem ser armazenadas na RAM. RAM significa memória de acesso aleatório, que é um tipo de memória que armazena dados e instruções que foram movidos do armazenamento em disco até que o processador precise deles.


### [Cache](/Registros%20Cache%20e%20RAM/readme.md#cache)
A memória Cache é um componente de computador baseado em chips que torna a recuperação de dados da memória do computador mais eficiente. Ela age como uma área de armazenamento temporário para que o processador do computador possa recuperar dados facilmente. Essa área de armazenamento temporário, conhecida como cache, está mais prontamente disponível para o processador do que a fonte de memória principal do computador, normalmente algum tipo de DRAM.

A memória Cache é às vezes chamada de memória da CPU (unidade central de processamento) porque geralmente é integrada diretamente ao chip da CPU ou colocada em um chip separado que possui uma interconexão de barramento separada com a CPU. Portanto, é mais acessível ao processador e pode aumentar a eficiência porque está fisicamente próxima do processador.

Para ficar próxima do processador, a memória Cache precisa ser muito menor do que a memória principal. Consequentemente, ela possui menos espaço de armazenamento. Também é mais cara do que a memória principal, pois é um chip mais complexo que oferece maior desempenho.

O que ela sacrifica em tamanho e preço, compensa em velocidade. A memória Cache opera de 10 a 100 vezes mais rápido do que a RAM, exigindo apenas alguns nanossegundos para responder a uma solicitação da CPU.

O nome do hardware real usado para a memória Cache é memória de acesso aleatório estática de alta velocidade (SRAM). O nome do hardware usado na memória principal do computador é memória de acesso aleatório dinâmico (DRAM).

A memória Cache não deve ser confundida com o termo mais amplo "cache". Caches são armazenamentos temporários de dados que podem existir em hardware e software. A memória Cache se refere ao componente de hardware específico que permite aos computadores criar caches em vários níveis da rede. Um cache é um hardware ou software usado para armazenar algo, normalmente dados, temporariamente em um ambiente de computação.


### [RAM](/Registros%20Cache%20e%20RAM/readme.md#ram)
A RAM (Memória de Acesso Aleatório) é um tipo de memória de computador que pode ser lida e alterada em qualquer ordem, geralmente usada para armazenar dados de trabalho e código de máquina. Um dispositivo de memória de acesso aleatório permite que os itens de dados
sejam lidos ou gravados em quase a mesma quantidade de tempo, independentemente da localização física dos dados dentro da memória, ao contrário de outros meios de armazenamento de dados de acesso direto (como discos rígidos, CD-RWs,
DVD-RWs e as antigas fitas magnéticas e memória de tambor), onde o tempo necessário para ler e gravar itens de dados varia significativamente dependendo de suas localizações físicas no meio de gravação, devido a limitações mecânicas, como velocidades de rotação do meio e movimento do braço.


## [Instruções e Programas](Não-Adicionado)
Na ciência da computação, uma instrução é uma única operação de um processador definida pelo conjunto de instruções do processador. Um programa de computador é uma lista de instruções que diz a um computador o que fazer. Tudo o que um computador faz é realizado usando um programa de computador. Programas armazenados na memória de um computador ("programação interna") permitem que o computador faça uma coisa após a outra, mesmo com intervalos entre elas.

## [Linguagens de Programação](/Linguagens%20de%20Programação/readme.md)
Uma linguagem de programação é um conjunto de regras que converte strings ou elementos gráficos de programas no caso de linguagens de programação visuais, em vários tipos de saídas de código de máquina. Linguagens de programação são um tipo de linguagem de computador usada na programação de computadores para implementar algoritmos.

As linguagens de programação são frequentemente divididas em duas categorias amplas:
1. Linguagem de alto nível usa uma sintaxe semelhante à língua inglesa. O código-fonte é convertido em código de máquina compreensível por máquina usando um compilador ou um interpretador. Java e Python são alguns exemplos de linguagens de programação de alto nível. Elas costumam ser mais lentas do que as de baixo nível, mas são mais fáceis de usar.
2. Linguagens de programação de baixo nível trabalham mais diretamente com o hardware e têm mais controle sobre ele. Elas interagem diretamente com o hardware. Dois exemplos comuns de linguagens de baixo nível são a linguagem de máquina e a linguagem assembly. Elas costumam ser mais rápidas do que as de alto nível, mas isso vem com a dificuldade e a falta de legibilidade.

### [Paradigmas de Programação](/Linguagens%20de%20Programação/readme.md#paradigmas-de-programação)
Existem também vários *paradigmas de programação* diferentes. Paradigmas de programação são diferentes maneiras ou estilos nos quais um programa ou linguagem de programação pode ser organizado. Cada paradigma consiste em certas estruturas, características e opiniões sobre como os problemas comuns de programação devem ser tratados.

Paradigmas de programação não são *linguagens* ou *ferramentas*. Você não pode "construir" nada com um paradigma. Eles são mais como um conjunto de ideais e diretrizes com os quais muitas pessoas concordaram, seguiram e expandiram. As linguagens de programação nem sempre estão vinculadas a um determinado paradigma. *Existem* linguagens que foram construídas com um certo paradigma em mente e têm recursos que facilitam esse tipo de programação mais do que outras (Haskell e programação funcional são um bom exemplo). Mas também existem linguagens "multiparadigma" nas quais você pode adaptar seu código para se adequar a um certo paradigma ou outro (JavaScript e Python são bons exemplos).


## [Tipos de Dados](Tipos%20de%20Dados/readme.md#tipos-de-dados)
Um tipo de dado, na programação, é uma classificação que especifica que tipo de valor uma variável tem e que tipo de operações matemáticas, relacionais ou lógicas podem ser aplicadas a ela sem causar um erro.

### [Tipos de Dados Primitivos](Tipos%20de%20Dados/readme.md#tipos-de-dados-primitivos)
Tipos de dados primitivos são os tipos de dados mais básicos em uma linguagem de programação. Eles são os blocos de construção de tipos de dados mais complexos. Tipos de dados primitivos são predefinidos pela linguagem de programação e são nomeados por uma palavra-chave reservada.

### [Tipos de Dados Primitivos Comuns](Tipos%20de%20Dados/readme.md#tipos-de-dados-primitivos-comuns)
- [Inteiro](Tipos%20de%20Dados/readme.md#integer)
- [Ponto Flutuante](Tipos%20de%20Dados/readme.md#float)
- [Booleano](Tipos%20de%20Dados/readme.md#boolean)
- [Caractere](Tipos%20de%20Dados/readme.md#character)
- [String](Tipos%20de%20Dados/readme.md#string)

### [Tipos de Dados Não Primitivos](Tipos%20de%20Dados/readme.md#tipos-de-dados-não-primitivos)
Tipos de dados não primitivos também são conhecidos como tipos de dados de referência. Eles são criados pelo programador e não são definidos pela linguagem de programação. Tipos de dados não primitivos também são chamados de tipos de dados compostos, pois são compostos por outros tipos.

### [Tipos de Dados Não Primitivos Comuns](Tipos%20de%20Dados/readme.md#tipos-de-dados-não-primitivos-comuns)
- [Array](Tipos%20de%20Dados/readme.md#array)
- [Estrutura](Tipos%20de%20Dados/readme.md#struct)
- [União](Tipos%20de%20Dados/readme.md#union)
- [Ponteiro](Tipos%20de%20Dados/readme.md#pointer)
- [Função](Tipos%20de%20Dados/readme.md#function)
- [Classe](Tipos%20de%20Dados/readme.md#class)
## [Instruções e Funções](Instruções%20e%20Funções/readme.md)

Na programação de computadores, uma instrução é uma unidade sintática de uma linguagem de programação imperativa que expressa alguma ação a ser realizada. Um programa escrito em tal linguagem é formado por uma sequência de uma ou mais instruções. Uma instrução pode ter componentes internos (por exemplo, expressões).
Existem dois tipos principais de instruções em qualquer linguagem de programação que são necessários para construir a lógica de um código.

1. [Instruções Condicionais](Instruções%20e%20Funções/readme.md#instruções-condicionais)

Existem dois tipos principais de instruções condicionais:
- if
- if-else
- switch case
2. [Laços de Repetição](Instruções%20e%20Funções/readme.md#loops)

Existem três tipos principais de declarações de repetição:
- for loop
- while loop
- do - while loop (uma variação de while loop)
- do - Until loop

------------

Uma função é um bloco de declarações que realiza uma tarefa específica. As funções aceitam dados, processam-nos e retornam um resultado ou executam-no. As funções são escritas principalmente para suportar o conceito de reutilização. Uma vez que uma função é escrita, pode ser chamada facilmente sem ter que repetir o mesmo código.

Linguagens funcionais diferentes usam sintaxes diferentes para escrever funções.

Saiba mais sobre funções [aqui](Instruções%20e%20Funções/readme.md#funções)
## [Estruturas de Dados](Estruturas%20de%20Dados/readme.md)

Na ciência da computação, uma estrutura de dados é uma organização de dados, um formato de gerenciamento e armazenamento que permite o acesso e a modificação eficientes. Mais precisamente, uma estrutura de dados é uma coleção de valores de dados, as relações entre eles e as funções ou operações que podem ser aplicadas aos dados.

### Tipos de Estruturas de Dados
- [Array](Estruturas%20de%20Dados/readme.md#array)
- [Lista Encadeada](Estruturas%20de%20Dados/readme.md#listaligada)
- [Pilha](Estruturas%20de%20Dados/readme.md#pilha)
- [Fila](Estruturas%20de%20Dados/readme.md#fila)
- [Tabela de Hash](Estruturas%20de%20Dados/readme.md#tabeladehash)
- [Heap](Estruturas%20de%20Dados/readme.md#heap)
- [Árvore](Estruturas%20de%20Dados/readme.md#árvore)
- [Grafo](Estruturas%20de%20Dados/readme.md#grafo)

## [Algoritmos](Algoritmos/readme.md)

Os algoritmos são conjuntos de etapas necessárias para concluir uma computação. Eles estão no cerne do que nossos dispositivos fazem, e este não é um conceito novo. Desde o desenvolvimento da matemática em si, algoritmos têm sido necessários para nos ajudar a realizar tarefas de forma mais eficiente, mas hoje vamos dar uma olhada em alguns problemas de computação modernos, como ordenação e busca em gráficos, e mostrar como os tornamos mais eficientes, para que você possa encontrar passagens aéreas baratas ou traçar rotas para Winterfell ou um restaurante ou algo assim.

### [Complexidade de Tempo](Algoritmos/Complexidade%20de%20Tempo/readme.md)
A complexidade de tempo de um algoritmo estima quanto tempo o algoritmo usará para alguma entrada. A ideia é representar a eficiência como uma função cujo parâmetro é o tamanho da entrada. Ao calcular a complexidade de tempo, podemos determinar se o algoritmo é rápido o suficiente sem implementá-lo.

### [Complexidade de Espaço](Algoritmos/Complexidade%20de%20Espaço/readme.md)
A complexidade de espaço refere-se à quantidade total de espaço de memória que um algoritmo/programa utiliza, incluindo os
### [Ordenação](Algoritmos/Ordenação/readme.md)

Ordenação é o processo de organizar uma lista de itens em uma ordem específica. Por exemplo, se você tiver uma lista de nomes, pode desejar ordená-los em ordem alfabética. Alternativamente, se você tiver uma lista de números, pode desejar organizá-los do menor para o maior. A ordenação é uma tarefa comum e pode ser realizada de várias maneiras diferentes.

### [Busca](Algoritmos/Busca/readme.md)

Busca é um algoritmo para encontrar um determinado elemento-alvo dentro de um contêiner. Algoritmos de busca são projetados para verificar a existência de um elemento ou recuperar um elemento de qualquer estrutura de dados onde ele está armazenado.

### [Busca em Gráficos](Algoritmos/Gráfico/readme.md)

A busca em gráficos é o processo de procurar em um gráfico para encontrar um nó específico. Um gráfico é uma estrutura de dados que consiste em um conjunto finito (e possivelmente mutável) de vértices ou nós ou pontos, juntamente com um conjunto de pares não ordenados desses vértices para um gráfico não direcionado ou um conjunto de pares ordenados para um gráfico direcionado. Esses pares são conhecidos como arestas, arcos ou linhas para um gráfico não direcionado e como setas, arestas direcionadas, arcos direcionados ou linhas direcionadas para um gráfico direcionado. Os vértices podem fazer parte da estrutura do gráfico ou podem ser entidades externas representadas por índices inteiros ou referências. Os gráficos são uma das estruturas de dados mais úteis para muitas aplicações do mundo real. Os gráficos são usados para modelar relações de par entre objetos. Por exemplo, a rede de rotas aéreas é um gráfico em que as cidades são os vértices e as rotas de voo são as arestas. Os gráficos também são usados para representar redes. A Internet pode ser modelada como um gráfico em que os computadores são os vértices e as conexões entre computadores são as arestas. Os gráficos também são usados em redes sociais como LinkedIn e Facebook. Os gráficos são usados para representar muitas aplicações do mundo real: redes de computadores, design de circuitos e agendamento aeronáutico, para citar apenas algumas.

### [Programação Dinâmica](Algoritmos/Programação%20Dinâmica/README.md)

Programação dinâmica é tanto um método de otimização matemática quanto um método de programação de computador. Richard Bellman desenvolveu o método na década de 1950 e ele encontrou aplicações em diversas áreas, desde engenharia aeroespacial até economia. Em ambos os contextos, ele se refere à simplificação de um problema complicado, dividindo-o em subproblemas mais simples de maneira recursiva. Embora alguns problemas de decisão não possam ser divididos dessa maneira, decisões que abrangem vários pontos no tempo geralmente se dividem recursivamente. Da mesma forma, na ciência da computação, se um problema pode ser resolvido de maneira otimizada dividindo-o em subproblemas e, em seguida, encontrando recursivamente as soluções ótimas para os subproblemas, ele é dito ter uma subestrutura ótima. A programação dinâmica é uma maneira de resolver problemas com essas propriedades. O processo de dividir um problema complicado em subproblemas mais simples é chamado "dividir e conquistar".

### [Algoritmos Gananciosos](Algoritmos/Algoritmo%20Ganancioso/readme.md)

Algoritmos gananciosos são uma classe simples e intuitiva de algoritmos que podem ser usados para encontrar a solução ótima para alguns problemas de otimização. Eles são chamados gananciosos porque, em cada etapa, eles fazem a escolha que parece melhor naquele momento. Isso significa que algoritmos gananciosos não garantem retornar a solução globalmente ótima, mas, em vez disso, fazem escolhas localmente ótimas na esperança de encontrar um ótimo global. Algoritmos gananciosos são usados para problemas de otimização. Um problema de otimização pode ser resolvido usando algoritmos gananciosos se o problema tiver a seguinte propriedade: a cada etapa, podemos fazer uma escolha que parece melhor naquele momento e obtemos a solução ótima para o problema completo.

### [Backtracking](Algoritmos/Backtracking/README.md)

Backtracking é uma técnica algorítmica para resolver problemas de forma recursiva, tentando construir uma solução incrementalmente, peça por peça, removendo aquelas soluções que não satisfazem as restrições do problema a qualquer momento (por tempo, aqui, se refere ao tempo decorrido até alcançar qualquer nível da árvore de busca).

### [Branch and Bound](Algoritmos/Branch%20and%20Bound/README.md)

Branch and bound é uma técnica geral para resolver problemas de otimização combinatória. É uma técnica de enumeração sistemática que reduz o número de soluções candidatas usando a estrutura do problema para eliminar soluções candidatas que não podem ser ótimas.

### [Complexidade de Tempo e Complexidade de Espaço de Diferentes Algoritmos de Busca e Ordenação](Não-Adicionado)
**Complexidade de Tempo**: É definida como o número de vezes que um conjunto específico de instruções é esperado para ser executado, em vez do tempo total gasto. Como o tempo é um fenômeno dependente, a complexidade de tempo pode variar devido a alguns fatores externos, como a velocidade do processador, o compilador usado, etc.

**Complexidade de Espaço**: É o espaço de memória total consumido pelo programa durante sua execução.

Ambos são calculados como função do tamanho da entrada (n). A complexidade de tempo de um algoritmo é expressa na notação big O.

A eficiência de um algoritmo depende desses dois parâmetros.

Tipos de Complexidade de Tempo:

- *Melhor Complexidade de Tempo*: A entrada para a qual o algoritmo leva menos tempo ou o tempo mínimo. No melhor caso, calculamos a complexidade de tempo de limite inferior de um algoritmo. Por exemplo: se os dados a serem pesquisados estão presentes na primeira localização de uma grande matriz de dados em um algoritmo de pesquisa linear, o melhor caso ocorre.
- *Complexidade de Tempo Médio*: Levamos todas as entradas aleatórias e calculamos o tempo de computação para todas as entradas. E, então, dividimos pelo número total de entradas.
- *Pior Complexidade de Tempo*: Defina a entrada para a qual o algoritmo leva muito tempo ou o tempo máximo. No pior caso, calculamos o limite superior da complexidade de tempo de um algoritmo. Exemplo: se os dados a serem pesquisados estão presentes na última localização de uma grande matriz de dados em um algoritmo de pesquisa linear, o pior caso ocorre.

Algumas complexidades de tempo comuns são:

- **O(1)**: Isso denota tempo constante. O(1) geralmente significa que um algoritmo terá um tempo constante, independentemente do tamanho da entrada. Mapas de hash são exemplos perfeitos de tempo constante.
- **O(log n)**: Isso denota tempo logarítmico. O(log n) significa diminuir com cada instância para as operações. Procurar elementos em Árvores de Busca Binária (BSTs) é um bom exemplo de tempo logarítmico.
- **O(n)**: Isso denota tempo linear. O(n) significa que o desempenho é diretamente proporcional ao tamanho da entrada. Em termos simples, o número de entradas e o tempo necessário para executar essas entradas serão proporcionais. A pesquisa linear em matrizes é um ótimo exemplo de complexidade de tempo linear.
- **O(n^2)**: Isso denota tempo quadrático. O(n^2) significa que o desempenho é diretamente proporcional ao quadrado do tamanho da entrada. Loops aninhados são exemplos perfeitos de complexidade de tempo quadrático.
- **O(n log n)**: Isso denota complexidade de tempo polinomial. O(n log n) significa que o desempenho é n vezes o de O(log n) (que é a complexidade do pior caso). Um bom exemplo seria algoritmos de divisão e conquista, como merge sort. Este algoritmo primeiro divide o conjunto, o que leva O(log n) tempo, depois conquista e classifica o conjunto, o que leva O(n) tempo. Portanto, o merge sort leva O(n log n) tempo.
- **O(n*n)**: Isso denota complexidade de tempo quadrático. O(n^2) significa que o desempenho é diretamente proporcional ao quadrado do tamanho da entrada. Loops aninhados são exemplos perfeitos de complexidade de tempo quadrático.

| Algoritmo         |           | Complexidade de Tempo|         | Complexidade de Espaço |
|   :---:           |  :---:    |  :---:                |   :---:  |   :---:                |
|                   | Melhor    | Média                 |  Pior    | Pior                   |
| Selection Sort    | Ω(n^2)    | θ(n^2)                | O(n^2)  | O(1)                   |
| Bubble Sort	      | Ω(n)      | θ(n^2)                | O(n^2)  | O(1)                   |
| Insertion Sort    | Ω(n)      | θ(n^2)                | O(n^2)  | O(1)                   |
| Heap Sort	      | Ω(n log(n)) | θ(n log(n))         | O(n log(n)) | O(1)              |
| Quick Sort	      | Ω(n log(n)) | θ(n log(n))         | O(n^2)  | O(n)                  |
| Merge Sort	      | Ω(n log(n)) | θ(n log(n))         | O(n log(n)) | O(n)              |
| Bucket Sort       | Ω(n +k)   | θ(n +k)               | O(n^2)  | O(n)                  |
| Radix Sort	      | Ω(nk)     | θ(nk)                 | O(nk)   | O(n + k)              |
| Count Sort	      | Ω(n +k)   | θ(n +k)               | O(n +k) | O(k)                  |
| Shell Sort	      | Ω(n log(n)) | θ(n log(n))         | O(n^2)  | O(1)                  |
| Tim Sort	      | Ω(n)      | θ(n log(n))           | O(n log(n)) | O(n)              |
| Tree Sort         | Ω(n log(n)) | θ(n log(n))         | O(n^2)  | O(n)                  |
| Cube Sort         | Ω(n)      | θ(n log(n))           | O(n log(n)) | O(n)              |

| Algoritmo         |           | Complexidade de Tempo|         |
|   :---:           |  :---:    |  :---:                |   :---:  |
|                   | Melhor    | Média                 |  Pior    |
| Busca Linear      | O(1)      | O(N)                  | O(N)    | O(1)      |
| Busca Binária     | O(1)      | O(logN)               | O(logN) | O(1)      |

## [Alan Turing](Não-Adicionado)
Alan Turing (nascido em 23 de junho de 1912, em Londres, Inglaterra - falecido em 7 de junho de 1954, em Wilmslow, Cheshire) foi um matemático e lógico inglês. Ele estudou na Universidade de Cambridge e no Instituto de Estudos Avançados de Princeton. Em seu seminal artigo de 1936 "Sobre Números Computáveis", ele provou que não poderia existir nenhum método algorítmico universal para determinar a verdade na matemática e que a matemática sempre conteria proposições indecidíveis (em oposição a desconhecidas). Esse artigo também introduziu a máquina de Turing. Ele acreditava que os computadores eventualmente seriam capazes de pensar de forma indistinguível da de um ser humano e propôs um teste simples (veja o teste de Turing) para avaliar essa capacidade. Seus trabalhos sobre o assunto são amplamente reconhecidos como a base da pesquisa em inteligência artificial. Ele realizou trabalho valioso em criptografia durante a Segunda Guerra Mundial, desempenhando um papel importante na quebra do código Enigma usado pela Alemanha para comunicações de rádio. Após a guerra, ele lecionou na Universidade de Manchester e começou a trabalhar no que hoje é conhecido como inteligência artificial. Em meio a esse trabalho inovador, Turing foi encontrado morto em sua cama, envenenado por cianeto. Sua morte seguiu sua prisão por um ato homossexual (então um crime) e uma sentença de 12 meses de terapia hormonal.

Após uma campanha pública em 2009, o primeiro-ministro britânico Gordon Brown fez um pedido público oficial em nome do governo britânico pelo terrível tratamento a que Turing foi submetido. A Rainha Elizabeth II concedeu um perdão póstumo em 2013. O termo "lei de Alan Turing" agora é usado informalmente para se referir a uma lei de 2017 no Reino Unido que concedeu anistia retroativa a homens advertidos ou condenados sob legislação histórica que proibia atos homossexuais.

Turing tem um extenso legado, com estátuas dele e muitas coisas nomeadas em sua homenagem, incluindo um prêmio anual para inovações em ciência da computação. Sua imagem está na nota de 50 libras do Banco da Inglaterra, que foi lançada em 23 de junho de 2021, coincidindo com seu aniversário. Em uma série da BBC em 2019, votada pelo público, ele foi nomeado a maior personalidade do século XX.

## [Engenharia de Software](Engenharia%20de%20Software/readme.md)
Engenharia de software é o ramo da ciência da computação que lida com o design, desenvolvimento, teste e manutenção de aplicativos de software. Engenheiros de software aplicam princípios de engenharia e conhecimento de linguagens de programação para criar soluções de software para usuários finais.

Vamos examinar várias definições de engenharia de software:

- O IEEE, em seu padrão 610.12-1990, define a engenharia de software como a aplicação de uma abordagem sistemática e disciplinada, que é uma abordagem computável para o desenvolvimento, operação e manutenção de software.
- Fritz Bauer definiu como "o estabelecimento e o uso de princípios de engenharia padrão. Isso ajuda você a obter um software econômico que é confiável e funciona eficientemente em máquinas reais".
- Boehm define a engenharia de software como envolvendo "a aplicação prática do conhecimento científico para o projeto criativo e a construção de programas de computador. Também inclui a documentação associada necessária para desenvolvê-los, operá-los e mantê-los".

### Tarefas e Responsabilidades de Engenheiros de Software
Engenheiros de sucesso sabem como usar as linguagens de programação, plataformas e arquiteturas certas para desenvolver desde jogos de computador até sistemas de controle de rede. Além de construir seus próprios sistemas, os engenheiros de software também testam, melhoram e mantêm o software criado por outros engenheiros.

Nesse papel, suas tarefas diárias podem incluir o seguinte:

- Projetar e manter sistemas de software
- Avaliar e testar novos programas de software
- Otimizar o software para velocidade e escalabilidade
- Escrever e testar código
- Consultar-se com clientes, engenheiros, especialistas em segurança e outras partes interessadas
- Apresentar novos recursos para partes interessadas internas e externas
### Fases da Engenharia de Software

O processo de engenharia de software envolve várias fases, incluindo a coleta de requisitos, design, implementação, teste e manutenção. Ao seguir uma abordagem disciplinada no desenvolvimento de software, os engenheiros de software podem criar software de alta qualidade que atende às necessidades de seus usuários.

- A primeira fase da engenharia de software é a **coleta de requisitos**. Nesta fase, o engenheiro de software trabalha com o cliente para determinar os requisitos funcionais e não funcionais do software. Os requisitos funcionais descrevem o que o software deve fazer, enquanto os requisitos não funcionais descrevem o quão bem ele deve fazê-lo. A coleta de requisitos é uma fase crítica, pois estabelece a base para todo o processo de desenvolvimento de software.

- Após a coleta de requisitos, a próxima fase é o **design**. Nesta fase, o engenheiro de software cria um plano detalhado para a arquitetura e funcionalidade do software. Esse plano inclui um **documento de design de software** que especifica a estrutura, o comportamento e as interações do software com outros sistemas. O documento de design de software é essencial, pois serve como um plano para a fase de implementação.

- A **fase de implementação** é onde o engenheiro de software cria o código real do software. É aqui que o documento de design é transformado em software funcional. A fase de implementação envolve escrever código, compilá-lo e testá-lo para garantir que atenda aos requisitos especificados no documento de design.

- O **teste** é uma fase crítica na engenharia de software. Nesta fase, o engenheiro de software verifica se o software funciona corretamente, é confiável e fácil de usar. Isso envolve vários tipos de teste, incluindo teste de unidade, teste de integração e teste de sistema. O teste garante que o software atenda aos requisitos e funcione conforme o esperado.

- A fase final da engenharia de software é a **manutenção**. Nesta fase, o engenheiro de software faz alterações no software para corrigir erros, adicionar novos recursos ou melhorar o desempenho. A manutenção é um processo contínuo que continua ao longo da vida do software.

### Por que a Engenharia de Software é Popular?

- Ciência da Computação: Fornece a base científica para o software, enquanto a engenharia elétrica depende principalmente da física.
- Ciência da Administração: A engenharia de software é intensiva em mão de obra e exige controle técnico e gerencial. Portanto, é amplamente utilizada na ciência da administração.
- Economia: Neste setor, a engenharia de software ajuda a estimar recursos e controlar custos. Um sistema de computação deve ser desenvolvido e os dados devem ser mantidos regularmente dentro de um orçamento estabelecido.
- Engenharia de Sistemas: A maioria do software é um componente de um sistema muito maior. Por exemplo, o software em um sistema de monitoramento industrial ou o software de voo em uma aeronave. Métodos de engenharia de software devem ser aplicados ao estudo desse tipo de sistema.
## [Circuitos Integrados](Integrated%20Circuits/readme.md)
Um circuito integrado ou circuito integrado monolítico (também referido como CI, um chip ou um microchip) é um conjunto de circuitos eletrônicos em uma pequena peça plana (ou "chip") de material semicondutor, geralmente silício. Muitos pequenos MOSFETs (transistores de efeito de campo metal-óxido-semicondutor) são integrados em um pequeno chip. Isso resulta em circuitos que são ordens de magnitude menores, mais rápidos e mais baratos do que aqueles construídos com componentes eletrônicos discretos. A capacidade de produção em massa dos CIs, sua confiabilidade e a abordagem de projeto em blocos integrados garantiram a rápida adoção de CIs padronizados em lugar de transistores discretos. Os CIs são agora usados em praticamente todos os equipamentos eletrônicos e revolucionaram o mundo da eletrônica. Computadores, telefones celulares e outros eletrodomésticos fazem agora parte inextricável da estrutura das sociedades modernas, tornados possíveis pelo tamanho reduzido e baixo custo dos CIs, como os processadores de computador modernos e microcontroladores.

A integração em grande escala tornou-se prática devido aos avanços tecnológicos na fabricação de dispositivos semicondutores de metal-óxido-semicondutor (MOS). Desde seus primórdios na década de 1960, o tamanho, a velocidade e a capacidade dos chips progrediram enormemente, impulsionados por avanços técnicos que acomodam cada vez mais transistores MOS em chips do mesmo tamanho - um chip moderno pode ter bilhões de transistores MOS em uma área do tamanho de uma unha humana. Esses avanços, que seguem aproximadamente a Lei de Moore, fazem com que os chips de computador de hoje tenham capacidade de armazenamento milhões de vezes maior e velocidade milhares de vezes maior do que os chips de computador da década de 1970.

Os CIs têm duas principais vantagens sobre circuitos discretos: custo e desempenho. O custo é baixo porque os chips, com todos os seus componentes, são impressos como uma unidade por meio de fotolitografia, em vez de serem construídos um transistor de cada vez. Além disso, os CIs embalados usam muito menos material do que circuitos discretos. O desempenho é alto porque os componentes dos CIs comutam rapidamente e consomem comparativamente pouca energia devido ao seu tamanho pequeno e proximidade. A principal desvantagem dos CIs é o alto custo de projetá-los e fabricar as fotomáscaras necessárias. Esse alto custo inicial significa que os CIs são economicamente viáveis apenas quando são previstos volumes de produção elevados.

### Tipos
Distribuidores modernos de componentes eletrônicos muitas vezes subdividem ainda mais os circuitos integrados:

- CIs Digitais são categorizados como CIs lógicos (como microprocessadores e microcontroladores), chips de memória (como memória MOS e memória de célula flutuante), CIs de interface (niveladores de tensão, serializador/desserializador, etc.), CIs de gerenciamento de energia e dispositivos programáveis.
- CIs Analógicos são categorizados como circuitos integrados lineares e circuitos de RF (radiofrequência).
- CIs de Sinais Mistas são categorizados como CIs de aquisição de dados (conversores A/D, conversores D/A e potenciômetros digitais), CIs de clock/tempo, circuitos de capacitores comutados (SC) e circuitos CMOS de RF.
- Circuitos Integrados Tridimensionais (CIs 3D) são categorizados em CIs com via através de silício (TSV) e CIs de conexão Cu-Cu.
## [Programação Orientada a Objetos](Object%20Oriented%20Programming/readme.md)
A Programação Orientada a Objetos é um paradigma fundamental de programação que se baseia nos conceitos de objetos e dados.

É a forma padrão de código que todo programador deve seguir para melhor legibilidade e reutilização do código.

### * Existem quatro conceitos básicos da Programação Orientada a Objetos:
- Abstração
- Encapsulamento
- Herança
- Polimorfismo 

Leia mais sobre esses conceitos de POO [aqui](Object%20Oriented%20Programming/readme.md)

## [Programação Funcional](Functional%20Programming/readme.md)

Na ciência da computação, a programação funcional é um paradigma de programação no qual os programas são construídos aplicando e compondo funções. É um paradigma de programação declarativa no qual as definições de função são árvores de expressões que mapeiam valores para outros valores, em vez de uma sequência de declarações imperativas que atualizam o estado em execução do programa.

Na programação funcional, as funções são tratadas como cidadãs de primeira classe, o que significa que podem ser atribuídas a nomes (incluindo identificadores locais), passadas como argumentos e retornadas de outras funções, assim como qualquer outro tipo de dados. Isso permite que os programas sejam escritos em um estilo declarativo e componível, onde pequenas funções são combinadas de maneira modular.

A programação funcional é às vezes tratada como sinônimo de programação puramente funcional, um subconjunto da programação funcional que trata todas as funções como funções matemáticas determinísticas, ou funções puras. Quando uma função pura é chamada com argumentos dados, ela sempre retornará o mesmo resultado e não pode ser afetada por nenhum estado mutável ou outros efeitos colaterais. Isso contrasta com procedimentos impuros, comuns na programação imperativa, que podem ter efeitos colaterais (como modificar o estado do programa ou receber entrada do usuário). Defensores da programação puramente funcional afirmam que, ao restringir os efeitos colaterais, os programas podem ter menos bugs, ser mais fáceis de depurar e testar, e ser mais adequados para procedimentos de verificação formal.

A programação funcional tem suas raízes na academia, evoluindo a partir do cálculo lambda, um sistema formal de computação baseado apenas em funções. A programação funcional historicamente foi menos popular do que a programação imperativa, mas muitas linguagens funcionais estão sendo usadas hoje na indústria e na educação.

Alguns exemplos de linguagens de programação funcional são:
- <a href="https://lisp-lang.org/"> Common Lisp </a>
- <a href="https://www.scheme.org/"> Scheme </a>
- <a href="https://racket-lang.org/"> Racket </a>
- <a href="https://www.erlang.org/"> Erlang </a>
- <a href="https://www.haskell.org/"> Haskell </a>
- <a href="https://fsharp.org/"> F# </a>
- <a href="https://cs.lmu.edu/~ray/notes/introml/"> ML </a> 

A programação funcional é historicamente derivada do *cálculo lambda*. O cálculo lambda é uma estrutura desenvolvida por Alonzo Church para estudar computações com funções. É frequentemente chamado de "a menor linguagem de programação do mundo". Ele fornece uma definição do que é computável e do que não é. É equivalente a uma máquina de Turing em sua capacidade de computação e tudo o que é computável pelo cálculo lambda, assim como tudo o que é computável por uma máquina de Turing, é computável. Ele fornece um arcabouço teórico para descrever funções e suas avaliações.

Alguns conceitos essenciais da programação funcional são:
- Funções puras
- Recursão
- Transparência referencial
- Funções como cidadãs de primeira classe e funções de alta ordem
- Variáveis são imutáveis.

**Funções puras**: Essas funções têm duas propriedades principais. Primeiro, elas sempre produzem a mesma saída para os mesmos argumentos, independentemente de qualquer outra coisa. Em segundo lugar, elas não têm efeitos colaterais. Ou seja, elas não modificam nenhum argumento ou variável local/global ou fluxos de entrada/saída. A última propriedade é chamada de *imutabilidade*. O único resultado das funções puras é o valor que elas retornam. Elas são determinísticas. Programas feitos usando programação funcional são fáceis de depurar porque não têm efeitos colaterais ou E/S oculta. Funções puras também facilitam a escrita de aplicativos paralelos/concorrentes. Quando o código é escrito nesse estilo, um compilador inteligente pode fazer muitas coisas - ele pode paralelizar as instruções, esperar para avaliar resultados até que sejam necessários e memorizar os resultados, já que os resultados nunca mudam, desde que a entrada não mude. Aqui está um exemplo simples de uma função pura em Python:

```python
def soma(x, y): # soma é uma função que recebe x e y como argumentos
    return x + y # retorna x + y sem alterar o valor
int fib(n) {
  if(n <= 1)
    return 1;
   else
     return (fib(n-1) + fib(n-2));
}
x = x + 1 # isso altera o valor atribuído à variável x
**As funções são de primeira classe e podem ser de ordem superior**: Funções de primeira classe são tratadas como variáveis de primeira classe. As variáveis de primeira classe podem ser passadas como parâmetros para funções, podem ser retornadas por funções ou armazenadas em estruturas de dados.

Uma combinação de aplicações de função pode ser definida usando uma forma de LISP chamada **funcall**, que recebe como argumentos uma função e uma série de argumentos e aplica essa função a esses argumentos:

```Lisp
(defun filter (lista-de-elementos teste)
    (cond ((null lista-de-elementos) nil)
          ((funcall teste (car lista-de-elementos))
            (cons (car lista-de-elementos)
                (filter (cdr lista-de-elementos)
                      teste)))
           (t (filter (cdr lista-de-elementos)
                       teste))))
   ```
A função **filter** aplica o teste ao primeiro elemento da lista. Se o teste retornar um valor diferente de nil, ele anexa o elemento ao resultado de filter aplicado ao cdr da lista; caso contrário, ele simplesmente retorna o cdr filtrado. Esta função pode ser usada com diferentes predicados passados como parâmetros para realizar uma variedade de tarefas de filtragem:

```Lisp
> (filter '(1 3 -9 5 -2 -7 6) #'plusp)   ; filtra todos os números negativos 
```    
saída: (1 3 5 6)

```Lisp
> (filter '(1 2 3 4 5 6 7 8 9) #'evenp)   ; filtra todos os números ímpares
```   
saída: (2 4 6 8)

e assim por diante.

**As variáveis são imutáveis**: Na programação funcional, não podemos modificar uma variável depois que ela foi inicializada. Podemos criar novas variáveis, mas não podemos modificar variáveis existentes, e isso realmente ajuda a manter o estado ao longo da execução de um programa. Uma vez que criamos uma variável e definimos seu valor, podemos ter plena confiança de que o valor dessa variável nunca mudará.

## [Sistemas Operacionais](Sistemas%20Operacionais/readme.md)
Um sistema operacional (ou SO, para abreviar) age como um intermediário entre um usuário de computador e o hardware do computador. O propósito de um sistema operacional é fornecer um ambiente no qual um usuário pode executar programas de forma conveniente e eficiente. Um sistema operacional é um software que gerencia o hardware do computador. O hardware deve fornecer mecanismos apropriados para garantir o funcionamento correto do sistema de computador e para evitar que programas de usuário interfiram no funcionamento adequado do sistema. Uma definição ainda mais comum é que o sistema operacional é o único programa em execução o tempo todo no computador (geralmente chamado de kernel), com tudo o mais sendo programas de aplicação.

Os sistemas operacionais podem ser vistos de duas perspectivas: gerenciadores de recursos e máquinas estendidas. Na visão de gerenciador de recursos, o trabalho do sistema operacional é gerenciar eficientemente as diferentes partes do sistema. Na visão de máquina estendida, o trabalho do sistema é fornecer abstrações aos usuários que são mais convenientes de usar do que a máquina real. Isso inclui processos, espaços de endereço e arquivos.

Os sistemas operacionais têm uma longa história, desde que substituíram o operador em sistemas multiprogramados modernos. Os destaques incluem sistemas de lotes iniciais, sistemas multiprogramados e sistemas de computadores pessoais. Como os sistemas operacionais interagem intimamente com o hardware, algum conhecimento de hardware de computador é útil para entendê-los. Os computadores são compostos de processadores, memórias e dispositivos de E/S. Essas partes estão conectadas por barramentos.

Os conceitos básicos nos quais todos os sistemas operacionais são construídos são processos, gerenciamento de memória, gerenciamento de E/S, sistema de arquivos e segurança. O coração de qualquer sistema operacional são as chamadas de sistema que ele pode manipular. Elas definem o que o sistema operacional faz.

### Sistema operacional como gerenciador de recursos
O sistema operacional gerencia todas as partes de um sistema complexo. Os computadores modernos consistem em processadores, memórias, temporizadores, discos, mouses, interfaces de rede, impressoras e uma ampla variedade de outros dispositivos. Na visão de baixo para c alto, o trabalho do sistema operacional é fornecer uma alocação ordenada e controlada dos processadores, memórias e dispositivos de E/S entre os diversos programas que os desejam. Sistemas operacionais modernos permitem que vários programas estejam na memória e sejam executados simultaneamente. Imagine o que aconteceria se três programas em execução em algum computador tentassem imprimir sua saída simultaneamente na mesma impressora. O resultado seria um caos total. O sistema operacional pode trazer ordem ao caos potencial, armazenando todos os resultados destinados à impressora no disco. Quando um programa é concluído, o sistema operacional pode copiar sua saída do arquivo em disco onde foi armazenada para a impressora, enquanto ao mesmo tempo, o outro programa pode continuar gerando mais saída, sem saber que a saída não está indo para a impressora (ainda). Quando um computador (ou rede) tem mais de um usuário, a necessidade de gerenciar e proteger a memória, dispositivos de E/S e outros recursos se torna ainda mais importante, uma vez que os usuários podem interferir uns com os outros. Além disso, os usuários frequentemente precisam compartilhar não apenas hardware, mas também informações (arquivos, bancos de dados etc.). Em resumo, essa visão do sistema operacional sustenta que sua principal tarefa é acompanhar quais programas estão usando quais recursos, conceder solicitações de recursos, contabilizar o uso e mediar solicitações conflitantes de diferentes programas e usuários.
### Sistema operacional como uma máquina estendida
A arquitetura da maioria dos computadores, no nível de linguagem de máquina, é primitiva e desajeitada para programar, especialmente no que diz respeito à entrada/saída. Para tornar esse ponto mais concreto, considere os discos rígidos SATA (Serial ATA) modernos usados na maioria dos computadores. Um programador precisaria saber para usar o disco. Desde então, a interface foi revisada várias vezes e é mais complicada do que era em 2007. Nenhum programador sensato gostaria de lidar com este disco no nível de hardware. Em vez disso, um software chamado driver de disco lida com o hardware e fornece uma interface para ler e gravar blocos de disco, sem entrar em detalhes. Sistemas operacionais contêm muitos drivers para controlar dispositivos de E/S.

Mas mesmo este nível é muito baixo para a maioria das aplicações. Por esse motivo, todos os sistemas operacionais fornecem mais uma camada de abstração para usar discos: arquivos. Usando essa abstração, os programas podem criar, gravar e ler arquivos sem lidar com os detalhes confusos de como o hardware funciona. Essa abstração é a chave para gerenciar toda essa complexidade. Boas abstrações transformam uma tarefa quase impossível em duas gerenciáveis. A primeira é definir e implementar as abstrações. A segunda é usar essas abstrações para resolver o problema em questão.
### História dos Sistemas Operacionais
- **Primeira Geração (1945-55)**: Pouco progresso foi alcançado na construção de computadores digitais após os esforços desastrosos de Babbage até a era da Segunda Guerra Mundial. Na Universidade Estadual de Iowa, o professor John Atanasoff e seu aluno de pós-graduação Clifford Berry criaram o que hoje é reconhecido como o primeiro computador digital operacional. Konrad Zuse em Berlim construiu o computador Z3 usando relés eletromecânicos na mesma época. O Mark I foi criado por Howard Aiken em Harvard, o Colossus por uma equipe de cientistas em Bletchley Park, na Inglaterra, e o ENIAC por William Mauchley e seu aluno de doutorado J. Presper Eckert na Universidade da Pensilvânia em 1944.

- **Segunda Geração (1955-65)**: A invenção do transistor no meio da década de 1950 alterou drasticamente a situação. Os computadores se tornaram confiáveis o suficiente para que pudessem ser fabricados e vendidos a clientes pagantes com a suposição de que continuariam funcionando tempo suficiente para realizar algum trabalho significativo. Mainframes, como essas máquinas são conhecidas atualmente, eram mantidos trancados em salas de computadores enormes e especialmente climatizadas, com equipes de operadores qualificados para gerenciá-los. Apenas grandes empresas, entidades governamentais significativas ou instituições poderiam arcar com o preço de vários milhões de dólares.

- **Terceira Geração (1965-80)**: Em comparação com os computadores de segunda geração, que eram construídos a partir de transistores individuais, o IBM 360 foi a primeira grande linha de computadores a usar Circuitos Integrados (CIs de pequena escala). Como resultado, ele ofereceu uma vantagem significativa em termos de preço/desempenho. Foi um sucesso imediato, e todos os outros grandes fabricantes adotaram rapidamente o conceito de uma família de computadores interoperáveis. Todo o software, incluindo o sistema operacional OS/360, deveria ser compatível com todos os modelos no design original. Ele tinha que funcionar em sistemas massivos, que frequentemente substituíam 7094s para cálculos pesados e previsão do tempo, e em sistemas pequenos, que frequentemente apenas substituíam 1401s para transferir cartões para fita. Tanto sistemas com poucos periféricos quanto sistemas com muitos periféricos precisavam funcionar bem com ele. Tinha que funcionar tanto em ambientes profissionais quanto acadêmicos. Acima de tudo, tinha que ser eficaz para cada uma dessas muitas aplicações.

- **Quarta Geração (1980-Presente)**: A era dos computadores pessoais começou com a criação de Circuitos de Integração em Grande Escala (CIs), processadores com milhares de transistores em um centímetro quadrado de silício. Embora os computadores pessoais, originalmente conhecidos como microcomputadores, não tenham mudado significativamente em termos de arquitetura em relação aos minicomputadores da classe PDP-11, eles diferiram significativamente em preço.

- **Quinta Geração (1990-Presente)**: As pessoas anseiam por um dispositivo de comunicação portátil desde que o detetive Dick Tracy na história em quadrinhos dos anos 1940 começou a conversar com seu "rádio de pulso bidirecional". Em 1946, um verdadeiro telefone celular fez sua estreia, e pesava cerca de 40 quilogramas. O primeiro telefone celular verdadeiramente portátil estreou na década de 1970 e era incrivelmente leve, pesando cerca de um quilograma. Era brincadeira chamá-lo de "o tijolo". Em breve, todos estavam clamando por um.

### Funções de um SO
- **Conveniência**: Um SO torna o computador mais conveniente de usar.
- **Eficiência**: Um SO permite que os recursos do sistema de computador sejam usados de forma eficiente.
- **Capacidade de Evolução**: Um SO deve ser construído de tal forma que permita o desenvolvimento, teste e introdução eficazes de novas funções do sistema ao mesmo tempo, sem interferir no serviço.
- **Taxa de Transferência**: Um SO deve ser construído de forma a fornecer a taxa de transferência máxima (número de tarefas por unidade de tempo).

### Principais funcionalidades de um SO
- **Gerenciamento de Recursos**: Quando o acesso paralelo ocorre no SO, significa que quando vários usuários estão acessando o sistema, o SO funciona como um Gerenciador de Recursos. Sua responsabilidade é fornecer hardware ao usuário. Isso diminui a carga no sistema.
- **Gerenciamento de Processos**: Inclui várias tarefas, como agendamento e término de processos. O SO gerencia várias tarefas ao mesmo tempo. Aqui ocorre o agendamento da CPU, o que significa que todas as tarefas serão feitas por muitos algoritmos usados para o agendamento.
- **Gerenciamento de Armazenamento**: O mecanismo do sistema de arquivos é usado para o gerenciamento do armazenamento. NIFS, CFS, CIFS, NFS, etc. são alguns sistemas de arquivos. Todos os dados são armazenados em várias trilhas de discos rígidos, que são gerenciadas pelo gerenciador de armazenamento. Isso inclui disco rígido.
- **Gerenciamento de Memória**: Refere-se ao gerenciamento da memória principal. O sistema operacional precisa controlar quanto da memória foi usada e por quem. Ele tem que decidir qual processo precisa de espaço de memória e quanto. O SO também precisa alocar e desalocar o espaço de memória.
- **Gerenciamento de Segurança/Privacidade**: A privacidade também é fornecida pelo sistema operacional utilizando senhas para que aplicativos não autorizados não possam acessar programas ou dados. Por exemplo, o Windows utiliza a autenticação **_Kerberos_** para evitar o acesso não autorizado aos dados.
### Tipos de Sistemas Operacionais
- **Sistema Operacional de Mainframe**:
Na ponta superior estão os sistemas operacionais para mainframes, esses computadores do tamanho de uma sala ainda encontrados nos principais centros de dados corporativos. Esses computadores diferem dos computadores pessoais em termos de capacidade de E/S. Um mainframe com 1000 discos e milhões de gigabytes de dados não é incomum; um computador pessoal com essas especificações seria a inveja de seus amigos. Os mainframes também estão fazendo um certo retorno como servidores Web de alto nível, servidores para sites de comércio eletrônico em grande escala e servidores para transações de empresa para empresa. Os sistemas operacionais para mainframes são altamente orientados para processar muitos trabalhos ao mesmo tempo, a maioria dos quais precisa de quantidades prodigiosas de E/S. Normalmente, eles oferecem três tipos de serviços: em lote, processamento de transações e timesharing.

- **Sistema Operacional de Servidor**:
Um nível abaixo estão os sistemas operacionais de servidor. Eles são executados em servidores, que podem ser computadores pessoais muito grandes, estações de trabalho ou até mainframes. Eles atendem a vários usuários de uma só vez por meio de uma rede e permitem que os usuários compartilhem recursos de hardware e software. Servidores podem fornecer serviços de impressão, serviços de arquivos ou serviços da Web. Provedores de Internet executam muitas máquinas de servidor para dar suporte aos seus clientes, e sites usam servidores para armazenar páginas da Web e lidar com solicitações de entrada. Sistemas operacionais típicos de servidor incluem Solaris, FreeBSD, Linux e Windows Server 20xx.

- **Sistema Operacional Multiprocessador**:
Uma maneira cada vez mais comum de obter grande poder computacional de alto nível é conectar várias CPUs em um único sistema. Dependendo de como exatamente elas estão conectadas e o que é compartilhado, esses sistemas são chamados de computadores paralelos, multicompiladores ou multiprocessadores. Eles precisam de sistemas operacionais especiais, mas muitas vezes são variações dos sistemas operacionais de servidor, com recursos especiais para comunicação, conectividade e consistência.

- **Sistema Operacional de Computador Pessoal**:
A próxima categoria é o sistema operacional de computador pessoal. Os modernos suportam todos a multiprogramação, muitas vezes com dezenas de programas iniciados na inicialização. Seu trabalho é fornecer um bom suporte a um único usuário. Eles são amplamente usados para processamento de texto, planilhas, jogos e acesso à Internet. Exemplos comuns incluem Linux, FreeBSD, Windows 7, Windows 8 e o OS X da Apple. Sistemas operacionais de computadores pessoais são tão amplamente conhecidos que provavelmente há pouca necessidade de introdução. Muitas pessoas nem sequer estão cientes de que existem outros tipos.

- **Sistema Operacional Embarcado**:
Sistemas embarcados são executados em computadores que controlam dispositivos que não são geralmente considerados computadores e não aceitam software instalado pelo usuário. Exemplos típicos são micro-ondas, TVs, carros, gravadores de DVD, telefones tradicionais e players de MP3. A principal característica que distingue sistemas embarcados de dispositivos portáteis é a certeza de que nenhum software não confiável será executado neles. Você não pode baixar novos aplicativos para o seu micro-ondas — todo o software está na ROM. Isso significa que não há necessidade de proteção entre aplicativos, simplificando o design. Sistemas como Embedded Linux, QNX e VxWorks são populares neste domínio.

- **Sistema Operacional de Cartão Inteligente**:
Os sistemas operacionais mais pequenos são executados em dispositivos de cartões inteligentes do tamanho de um cartão de crédito com chips de CPU. Eles têm limitações muito severas de potência de processamento e memória. Alguns são alimentados por contatos no leitor em que são inseridos, mas os cartões inteligentes sem contato são alimentados indutivamente, limitando bastante o que podem fazer. Alguns podem lidar apenas com uma única função, como pagamentos eletrônicos, mas outros podem lidar com várias funções. Frequentemente, esses sistemas são proprietários. Alguns cartões inteligentes são orientados para o Java. Isso significa que a ROM no cartão inteligente possui um interpretador para a Máquina Virtual Java (JVM). Applets Java (pequenos programas) são baixados no cartão e interpretados pelo interpretador JVM. Alguns desses cartões podem lidar com vários applets Java ao mesmo tempo, levando à multiprogramação e à necessidade de programá-los. O gerenciamento de recursos e proteção também se tornam um problema quando dois ou mais applets estão presentes simultaneamente. Essas questões devem ser tratadas pelo sistema operacional (geralmente extremamente primitivo) presente no cartão.

## [Memória e Armazenamento](Memória%20e%20Armazenamento/readme.md)
Here is the provided text translated into Portuguese:

### Memória
O termo _memória_ refere-se ao componente dentro do seu computador que permite o acesso a dados a curto prazo. Você pode reconhecer esse componente como DRAM ou memória de acesso aleatório dinâmico. Seu computador realiza muitas operações acessando dados armazenados em sua memória de curto prazo. Alguns exemplos de tais operações incluem a edição de um documento, o carregamento de aplicativos e a navegação na Internet. A velocidade e o desempenho do seu sistema dependem da quantidade de memória instalada no seu computador.

Se você tem uma mesa e um arquivo, a mesa representa a memória do seu computador. Itens que você precisa usar imediatamente são mantidos na sua mesa para facilitar o acesso. No entanto, não é possível armazenar muitas coisas em uma mesa devido às suas limitações de tamanho.

### Armazenamento
Enquanto a memória se refere ao local de armazenamento de dados a curto prazo, o _armazenamento_ é o componente dentro do seu computador que permite armazenar e acessar dados a longo prazo. Normalmente, o armazenamento vem na forma de uma unidade de estado sólido (SSD) ou um disco rígido. O armazenamento abriga suas aplicações, sistema operacional e arquivos indefinidamente. Os computadores precisam ler e gravar informações no sistema de armazenamento, portanto, a velocidade de armazenamento determina quão rápido seu sistema pode ser inicializado, carregado e acessar o que você salvou.

Enquanto a mesa representa a memória do computador, o arquivo representa o armazenamento do seu computador. Ele contém itens que precisam ser salvos e armazenados, mas não são necessariamente necessários para acesso imediato. O tamanho do arquivo significa que ele pode armazenar muitas coisas.

**Uma distinção importante** entre memória e armazenamento é que a memória é apagada quando o computador é desligado. Por outro lado, o armazenamento permanece intacto, não importa com que frequência você desligue seu computador. Portanto, na analogia da mesa e do arquivo, qualquer arquivo deixado na sua mesa será descartado quando você sair do escritório. Tudo no seu arquivo permanecerá.

### Memória Virtual
No coração dos sistemas de computadores está a memória, o espaço onde os programas são executados e os dados são armazenados. Mas o que acontece quando os programas que você está executando e os dados com os quais está trabalhando excedem a capacidade física da memória do seu computador? É aí que a memória virtual entra em ação, atuando como uma extensão inteligente da memória do seu computador e aprimorando suas capacidades.

**Definição e Propósito da Memória Virtual:**

A memória virtual é uma técnica de gerenciamento de memória empregada pelos sistemas operacionais para superar as limitações da memória física (RAM). Ela cria uma ilusão para aplicativos de software de que eles têm acesso a uma quantidade maior de memória do que a que está fisicamente instalada no computador. Em essência, ela permite que programas utilizem espaço de memória além dos limites da RAM física do computador.

O principal propósito da memória virtual é permitir a multitarefa eficiente e a execução de programas maiores, mantendo a responsividade do sistema. Isso é alcançado criando uma interação contínua entre a RAM física e dispositivos de armazenamento secundários, como disco rígido ou SSD.

**Como a Memória Virtual Amplia a Memória Física Disponível:**

Pense na memória virtual como uma ponte que conecta a RAM do seu computador e o armazenamento secundário (unidades de disco). Quando você executa um programa, partes dele são carregadas na RAM física mais rápida. No entanto, nem todas as partes do programa podem ser usadas imediatamente.

A memória virtual explora essa situação movendo seções do programa que não estão sendo usadas ativamente da RAM para o armazenamento secundário, criando mais espaço na RAM para as partes que estão sendo usadas ativamente. Esse processo é transparente para o usuário e para os programas em execução. Quando as partes movidas são necessárias novamente, elas são transferidas de volta para a RAM, enquanto outras partes menos ativas podem ser movidas para o armazenamento secundário.

A troca dinâmica de dados dentro e fora da memória física é gerenciada pelo sistema operacional. Isso permite que os programas funcionem mesmo se forem maiores do que a RAM disponível, já que o sistema operacional decide de maneira inteligente quais dados precisam estar na RAM para obter o desempenho ideal.

Em resumo, a memória virtual atua como uma camada de virtualização que amplia a memória física disponível temporariamente transferindo partes de programas e dados entre a RAM e o armazenamento secundário. Esse processo garante que o computador possa lidar com tarefas maiores e diversos programas simultaneamente, mantendo um desempenho eficiente e responsivo.

## [Sistema de Arquivos](File%20System/readme.md)
Em computação, um sistema de arquivos (frequentemente abreviado como fs) é um método e estrutura de dados que o sistema operacional utiliza para controlar como os dados são armazenados e recuperados. Sem um sistema de arquivos, os dados colocados em um meio de armazenamento seriam um único corpo de dados, sem uma maneira de dizer onde um pedaço de dados termina e o próximo começa ou onde um pedaço de dados estava localizado quando era hora de recuperá-lo. Ao separar os dados em pedaços e dar a cada pedaço um nome, os dados são facilmente isolados e identificados. Tendo seu nome como uma sistema de gerenciamento de dados baseado em papel, cada grupo de dados é chamado de "arquivo". A estrutura e regras lógicas usadas para gerenciar os grupos de dados e seus nomes são chamadas de "sistema de arquivos".

Existem muitos tipos de sistemas de arquivos, cada um com estruturas lógicas e propriedades exclusivas, como velocidade, flexibilidade, segurança, tamanho e outros. Alguns sistemas de arquivos foram projetados para serem usados em aplicativos específicos. Por exemplo, o sistema de arquivos ISO 9660 foi projetado especificamente para discos ópticos.

Sistemas de arquivos podem ser usados em muitos tipos de dispositivos de arm

azenamento usando vários meios. A partir de 2019, os discos rígidos têm sido dispositivos de armazenamento-chave e devem permanecer assim no futuro previsível. Outros tipos de mídia usados incluem SSDs, fitas magnéticas e discos ópticos. Em alguns casos, como com o tmpfs, a memória principal do computador (memória de acesso aleatório, RAM) cria um sistema de arquivos temporário para uso a curto prazo.

Alguns sistemas de arquivos são usados em dispositivos de armazenamento de dados locais; outros fornecem acesso a arquivos por meio de um protocolo de rede (por exemplo, NFS, SMB ou clientes 9P). Alguns sistemas de arquivos são "virtuais", o que significa que os "arquivos" fornecidos (chamados de arquivos virtuais) são calculados sob demanda (como procfs e sysfs) ou são simplesmente uma mapeamento em um sistema de arquivos diferente usado como armazenamento de suporte. O sistema de arquivos gerencia o acesso tanto ao conteúdo dos arquivos quanto aos metadados sobre esses arquivos. Ele é responsável por organizar o espaço de armazenamento; confiabilidade, eficiência e ajuste em relação ao meio de armazenamento físico são considerações importantes no projeto.

### Como os sistemas de arquivos funcionam
Um sistema de arquivos armazena e organiza dados e pode ser considerado como um tipo de índice para todos os dados contidos em um dispositivo de armazenamento. Esses dispositivos podem incluir discos rígidos, discos ópticos e pen drives.

Os sistemas de arquivos especificam convenções para nomear arquivos, incluindo o número máximo de caracteres em um nome, quais caracteres podem ser usados e, em alguns sistemas, quão longo pode ser o sufixo do nome do arquivo. Em muitos sistemas de arquivos, os nomes de arquivo não diferenciam maiúsculas de minúsculas.

Além do arquivo em si, os sistemas de arquivos contêm informações, como o tamanho do arquivo e seus atributos, localização e hierarquia no diretório nos metadados. Os metadados também podem identificar blocos livres de armazenamento disponíveis no disco e quanto espaço está disponível.

Um sistema de arquivos também inclui um formato para especificar o caminho para um arquivo na estrutura de diretórios. Um arquivo é colocado em um diretório - ou uma pasta no sistema operacional Windows - ou subdiretório no local desejado na estrutura de árvore. Sistemas operacionais de PC e móveis têm sistemas de arquivos em que os arquivos são colocados em uma estrutura de árvore hierárquica.

Antes que arquivos e diretórios sejam criados no meio de armazenamento, partições devem ser criadas. Uma partição é uma região do disco rígido ou outro armazenamento que o sistema operacional gerencia separadamente. Um sistema de arquivos está contido na partição primária, e alguns sistemas operacionais permitem múltiplas partições em um disco. Nessa situação, se um sistema de arquivos for corrompido, os dados em uma partição diferente estarão seguros.

### Tipos de Sistemas de Arquivos
Existem vários tipos de sistemas de arquivos, todos com estruturas lógicas e propriedades diferentes, como velocidade e tamanho. O tipo de sistema de arquivos pode variar de acordo com o sistema operacional e as necessidades desse sistema operacional. Microsoft Windows, Mac OS X e Linux são os três sistemas operacionais mais comuns para PCs. Sistemas operacionais móveis incluem Apple iOS e Google Android.

Os principais sistemas de arquivos incluem os seguintes:

- Tabela de alocação de arquivos (FAT) é suportada pelo sistema operacional Microsoft Windows. O FAT é considerado simples e confiável e foi projetado em 1977 para disquetes, mas depois foi adaptado para discos rígidos. Embora eficiente e compatível com a maioria dos sistemas operacionais atuais, o FAT não pode se igualar ao desempenho e escalabilidade de sistemas de arquivos mais modernos.

- Sistema de arquivos global (GFS) é um sistema de arquivos para o sistema operacional Linux e é um sistema de arquivos de disco compartilhado. O GFS oferece acesso direto ao armazenamento de bloco compartilhado e pode ser usado como um sistema de arquivos local.

- GFS2 é uma versão atualizada com recursos não incluídos no GFS original, como um sistema de metadados atualizado. Nos termos da Licença Pública Geral GNU, tanto o GFS quanto os sistemas de arquivos GFS2 estão disponíveis como software livre.

- Sistema de arquivos hierárquico (HFS) foi desenvolvido para uso em sistemas operacionais Mac. O HFS também pode ser chamado de Mac OS Standard e foi sucedido pelo Mac OS Extended. Originalmente introduzido em 1985 para disquetes e discos rígidos, o HFS substituiu o sistema de arquivos original do Macintosh. Ele também pode ser usado em CD-ROMs.

- O sistema de arquivos NT - também conhecido como Sistema de Arquivos de Nova Tecnologia (NTFS) - é o sistema de arquivos padrão para produtos Windows a partir do Windows NT 3.1. As melhorias em relação ao sistema de arquivos FAT anterior incluem um melhor suporte a metadados, desempenho e uso de espaço em disco. O NTFS também é suportado no sistema operacional Linux por meio de um driver NTFS gratuito e de código aberto. Os sistemas operacionais Mac têm suporte apenas para leitura do NTFS.

- Formato de Disco Universal (UDF) é um sistema de arquivos neutro em relação a fornecedores para mídia óptica e DVDs. O UDF substitui o sistema de arquivos ISO 9660 e é o sistema de arquivos oficial para vídeo e áudio em DVD, conforme escolhido pelo Fórum de DVDs.

## [Computação em Nuvem](Cloud%20Computing/Readme.md)
A computação em nuvem é a capacidade de acessar informações e aplicativos pela Internet. A computação em nuvem permite aos usuários acessar aplicativos e dados de qualquer local com uma conexão à Internet.

A computação em nuvem é um tipo de computação baseada na Internet que fornece recursos de processamento de computadores compartilhados e dados para computadores e outros dispositivos sob demanda.

É um modelo para possibilitar acesso à rede ubíquo, conveniente, sob demanda a um conjunto compartilhado de recursos de computação configuráveis (por exemplo, redes, servidores, armazenamento

, aplicativos e serviços) que podem ser rapidamente provisionados e liberados com um esforço mínimo de gerenciamento ou interação com o provedor de serviços.

## Principais benefícios da computação em nuvem

A computação em nuvem representa uma grande mudança na forma como as empresas pensam sobre os recursos de TI. Aqui estão sete razões comuns pelas quais as organizações estão recorrendo aos serviços de computação em nuvem:

Custo
A computação em nuvem elimina o gasto de capital na compra de hardware e software e na configuração e operação de data centers locais - os racks de servidores, a eletricidade 24 horas por dia para alimentação e refrigeração, e os especialistas em TI para gerenciar a infraestrutura. Isso se acumula rapidamente.

Velocidade
A maioria dos serviços de computação em nuvem é fornecida de forma autoatendida e sob demanda, portanto, mesmo grandes quantidades de recursos de computação podem ser provisionadas em minutos, geralmente com apenas alguns cliques do mouse, oferecendo às empresas muita flexibilidade e aliviando a pressão do planejamento de capacidade.

Escala global
Os benefícios dos serviços de computação em nuvem incluem a capacidade de escalar elasticamente. Na linguagem da computação em nuvem, isso significa fornecer a quantidade certa de recursos de TI - por exemplo, mais ou menos poder de computação, armazenamento e largura de banda - no momento em que é necessário e na localização geográfica certa.

Produtividade
Os data centers locais normalmente exigem muito "empilhamento e instalação" - configuração de hardware, aplicação de patches de software e outras tarefas demoradas de gerenciamento de TI. A computação em nuvem elimina a necessidade de muitas dessas tarefas, para que as equipes de TI possam se concentrar em metas de negócios mais importantes.

Desempenho
Os maiores serviços de computação em nuvem são executados em uma rede mundial de data centers seguros, que são regularmente atualizados para a geração mais recente de hardware de computação rápida e eficiente. Isso oferece várias vantagens em relação a um único data center corporativo, incluindo latência de rede reduzida para aplicativos e economias de escala significativas.

Confiabilidade
A computação em nuvem facilita o backup de dados, a recuperação de desastres e a continuidade dos negócios a um custo menor, porque os dados podem ser espelhados em vários locais na rede do provedor de nuvem.

Segurança
Muitos provedores de nuvem oferecem um conjunto amplo de políticas, tecnologias e controles que fortalecem a postura de segurança geral, ajudando a proteger dados, aplicativos e infraestrutura contra ameaças em potencial.

### Tipos de Serviços de Computação em Nuvem
- [Infraestrutura como Serviço (IaaS)](Cloud%20Computing/Readme.md#infraestrutura-como-serviço-iaas)
- [Plataforma como Serviço (PaaS)](Cloud%20Computing/Readme.md#plataforma-como-serviço-paas)
- [Software como Serviço (SaaS)](Cloud%20Computing/Readme.md#software-como-serviço-saas)

## [Aprendizado de Máquina]()
A aprendizado de máquina é a prática de ensinar um computador a aprender. O conceito utiliza o reconhecimento de padrões, bem como outras formas de algoritmos preditivos, para fazer julgamentos sobre dados de entrada. Esse campo está intimamente relacionado à inteligência artificial e à estatística computacional.

### Existem três subcategorias de aprendizado de máquina:

### Aprendizado de Máquina Supervisionado
Nesse caso, modelos de aprendizado de máquina são treinados com conjuntos de dados rotulados, o que permite que os modelos aprendam e melhorem com precisão ao longo do tempo. Por exemplo, um algoritmo seria treinado com imagens de cães e outros objetos, todos rotulados por seres humanos, e a máquina aprenderia a identificar imagens de cães por conta própria. O aprendizado de máquina supervisionado é o tipo mais comum usado hoje.

Aplicações práticas do Aprendizado de Máquina Supervisionado - 
1. **Bioinformática:** A bioinformática é o estudo de como os indivíduos retêm conhecimento biológico, como impressões digitais, textura ocular, lóbulos da orelha, entre outros. Hoje, os telefones celulares são inteligentes o suficiente para entender nossos dados biológicos e, em seguida, nos verificar para aumentar a segurança do sistema.
2. **Reconhecimento de fala:** Este é o tipo de programa onde você pode transmitir sua voz para o programa, e ele o identificará. Os dispositivos do mundo real mais conhecidos são os assistentes digitais, como o Google Assistant ou o Siri, que respondem apenas com sua voz.
3. **Detecção de spam:** Esta ferramenta é usada para impedir que mensagens fictícias ou geradas por máquinas sejam enviadas. O Gmail inclui um algoritmo que aprende muitas palavras erradas. O aplicativo Oneplus Messages pede ao usuário que especifique quais palavras devem ser proibidas e, em seguida, impedirá que esses textos sejam enviados pelo aplicativo.
4. **Reconhecimento de objetos para visão:** Este tipo de software é usado quando você precisa identificar algo. Você tem um grande conjunto de dados que você usa para treinar o algoritmo, e ele pode identificar um novo objeto usando isso.

### Aprendizado de Máquina Não Supervisionado
No aprendizado de máquina não supervisionado, um programa procura padrões em dados não rotulados. O aprendizado de máquina não supervisionado pode encontrar padrões ou tendências que as pessoas não estão explicitamente procurando. Por exemplo, um programa de aprendizado de máquina não supervisionado poderia analisar dados de vendas online e identificar diferentes tipos de clientes fazendo compras.

Aplicações práticas do Aprendizado de Máquina Não Supervisionado:
1. **Agrupamento:** O agrupamento é o

 processo de segmentação de um conjunto de dados em subconjuntos com base em características ou semelhanças comuns. Ele é usado em marketing para segmentar clientes com base em comportamentos e preferências de compra.
2. **Redução de dimensionalidade:** Redução de dimensionalidade é o processo de reduzir o número de variáveis em um conjunto de dados. Isso pode ajudar a simplificar a análise e tornar os modelos mais eficientes.

### Aprendizado de Máquina por Reforço
Neste caso, o algoritmo aprende com base em recompensas ou punições. O aprendizado de máquina por reforço é mais semelhante ao treinamento de animais do que à educação de humanos. O programa é dado um objetivo a ser alcançado, mas não é informado de como chegar lá.

Aplicações práticas do Aprendizado de Máquina por Reforço:
1. **Jogos:** O aprendizado de máquina por reforço é frequentemente usado para treinar agentes em jogos. Os agentes aprendem a tomar decisões que maximizam uma recompensa específica, como ganhar o jogo.
2. **Robótica:** Agentes de aprendizado de máquina por reforço são usados para treinar robôs a realizar tarefas específicas em ambientes complexos.

### Ferramentas Comuns de Aprendizado de Máquina
- **Python:** A linguagem de programação Python é amplamente utilizada em aprendizado de máquina devido à sua vasta biblioteca de código aberto, incluindo o NumPy, pandas e scikit-learn.
- **R:** A linguagem de programação R é popular entre os estatísticos e analistas de dados, e possui muitos pacotes dedicados ao aprendizado de máquina.
- **TensorFlow:** Uma biblioteca de código aberto desenvolvida pelo Google para treinamento de modelos de aprendizado de máquina em redes neurais.
- **Keras:** Uma API de alto nível construída sobre o TensorFlow que facilita a criação, treinamento e avaliação de modelos de aprendizado de máquina, especialmente redes neurais.
- **PyTorch:** Uma biblioteca de aprendizado de máquina de código aberto mantida pelo Facebook's AI Research lab.
- **scikit-learn:** Uma biblioteca de código aberto que fornece ferramentas simples e eficientes para análise de dados e modelagem estatística, incluindo várias técnicas de aprendizado de máquina.

## [Desenvolvimento de Software](Software%20Development/readme.md)
Desenvolvimento de software refere-se ao processo de criação, design e implantação de software para uma variedade de finalidades. Isso envolve escrever código, testar, documentar e manter o software. O desenvolvimento de software é uma disciplina ampla que abrange várias áreas, incluindo desenvolvimento web, desenvolvimento de aplicativos móveis, desenvolvimento de sistemas embarcados e muito mais. É uma parte fundamental da tecnologia da informação e é essencial para uma ampla gama de setores, desde empresas de tecnologia até assistência médica e manufatura.

### Ciclo de Desenvolvimento de Software
O desenvolvimento de software segue um ciclo de vida que é projetado para garantir que o software atenda aos requisitos do usuário, seja de alta qualidade e seja entregue a tempo e dentro do orçamento. Embora existam várias metodologias para o desenvolvimento de software, muitas delas incluem fases semelhantes, incluindo:

1. **Requisitos:** A fase de requisitos envolve entender as necessidades do usuário e do sistema. Isso inclui coletar informações sobre o que o software deve fazer, quais recursos ele deve ter e quais problemas deve resolver.

2. **Design:** Nesta fase, os desenvolvedores projetam a arquitetura do software, incluindo a estrutura do banco de dados, a interface do usuário e outros componentes.

3. **Implementação:** Durante a fase de implementação, o código real do software é escrito. Isso pode envolver várias linguagens de programação, dependendo dos requisitos do sistema.

4. **Teste:** O software é testado para garantir que ele funcione conforme o esperado e atenda aos requisitos do usuário. Isso pode envolver testes de unidade, testes de integração e testes de aceitação do usuário.

5. **Implantação:** Após a conclusão dos testes, o software é implantado para uso em produção. Isso pode envolver a instalação em servidores, lojas de aplicativos ou outros locais, dependendo do tipo de software.

6. **Manutenção:** Após a implantação, o software requer manutenção contínua para corrigir bugs, adicionar novos recursos e garantir que ele continue a funcionar conforme o esperado.

### Linguagens de Programação Comuns
Existem muitas linguagens de programação usadas no desenvolvimento de software, cada uma com suas próprias características e casos de uso. Algumas das linguagens de programação mais comuns incluem:

- **JavaScript:** Amplamente utilizado para o desenvolvimento web e é executado nos navegadores dos usuários.
- **Python:** Uma linguagem versátil usada em várias aplicações, incluindo desenvolvimento web, ciência de dados e automação.
- **Java:** Comumente usado para desenvolvimento Android e aplicativos empresariais.
- **C++:** Usado para desenvolvimento de software de sistemas, jogos e aplicativos de alto desempenho.
- **C#:** Popular para o desenvolvimento de aplicativos Windows e jogos com o Unity.
- **Ruby:** Conhecido por sua simplicidade e usado principalmente com o framework Ruby on Rails para desenvolvimento web.
- **Swift:** Usado para desenvolvimento de aplicativos iOS e macOS.
- **PHP:** Amplamente usado para desenvolvimento de sites e aplicativos web.

### Metodologias de Desenvolvimento de Software
Várias metodologias são usadas no desenvolvimento de software para gerenciar projetos, equipes e processos. Alguns dos métodos mais conhecidos incluem:

- **Cascata:** Um modelo sequencial que divide o desenvolvimento em fases distintas, como requisitos, design, implementação, teste e manutenção.
- **Desenvolvimento Ágil:** Um conjunto de abordagens iterativas e flexíveis que enfatiza a colaboração do cliente, entregas frequentes e respostas rápidas às mudanças.
- **Scrum:** Um framework ágil que organiza o desenvolvimento em sprints curtas, geralmente de 2 a 4 semanas, com foco na entrega de incrementos de software.
- **Kanban:** Um método ágil que se concentra no fluxo contínuo de trabalho, permitindo

 que as equipes visualizem e otimizem o processo.
- **DevOps:** Uma abordagem que combina desenvolvimento e operações para melhorar a colaboração e a entrega de software.

## [Cibersegurança](Cybersecurity/Readme.md)
A cibersegurança é o campo dedicado a proteger sistemas de computador, redes, dispositivos e dados contra ameaças, roubo ou danos, garantindo a confidencialidade, integridade e disponibilidade das informações. Com a crescente dependência da tecnologia e da internet, a cibersegurança tornou-se uma preocupação crítica em todo o mundo.

### Conceitos Importantes de Cibersegurança
1. **Confidencialidade:** Garantir que os dados estejam acessíveis apenas a pessoas autorizadas.
2. **Integridade:** Manter a precisão e a confiabilidade dos dados, garantindo que eles não sejam alterados de forma não autorizada.
3. **Disponibilidade:** Garantir que sistemas e dados estejam disponíveis quando necessário, evitando interrupções ou tempo de inatividade.
4. **Autenticidade:** Verificar a identidade de usuários, sistemas e dados.
5. **Autorização:** Determinar quem tem permissão para acessar recursos ou executar ações específicas.
6. **Auditoria:** Registrar atividades de sistema e usuário para monitorar o uso e detectar atividades suspeitas.
7. **Criptografia:** Proteger dados por meio de técnicas de criptografia para que só possam ser lidos por pessoas autorizadas.
8. **Firewalls e Segurança em Rede:** Implementar medidas para proteger redes e sistemas contra ameaças externas.
9. **Proteção contra Malware:** Usar software antivírus e anti-malware para detectar e remover software malicioso.
10. **Gestão de Vulnerabilidades:** Identificar e corrigir vulnerabilidades em sistemas e software para evitar explorações.

### Ameaças Comuns de Cibersegurança
1. **Malware:** Software malicioso, como vírus, worms, trojans e ransomware, que danifica sistemas ou rouba informações.
2. **Phishing:** Técnica de engenharia social que utiliza mensagens enganosas para enganar as pessoas a revelar informações confidenciais.
3. **Ataques de Força Bruta:** Tentativas repetidas de adivinhar senhas ou chaves de criptografia até obter acesso não autorizado.
4. **Ataques de Negação de Serviço (DDoS):** Sobrecarregam sistemas, servidores ou redes com tráfego falso para torná-los inacessíveis.
5. **Hacking:** Exploração de vulnerabilidades de segurança para ganhar acesso não autorizado a sistemas ou dados.
6. **Engenharia Social:** Manipulação psicológica para obter informações confidenciais ou acesso não autorizado.
7. **Insiders Maliciosos:** Funcionários ou usuários internos que usam seu acesso privilegiado para prejudicar a organização.
8. **Vazamentos de Dados:** Exposição não autorizada de informações confidenciais.

### Melhores Práticas de Cibersegurança
1. **Manter Software Atualizado:** Instalar atualizações e patches de segurança regularmente.
2. **Usar Senhas Fortes:** Criar senhas complexas e únicas para contas online e alterá-las periodicamente.
3. **Autenticação em Duas Etapas:** Usar autenticação em duas etapas sempre que possível para adicionar uma camada extra de segurança.
4. **Conscientização do Usuário:** Educar funcionários e usuários sobre práticas seguras de cibersegurança.
5. **Backup de Dados:** Realizar backups regulares de dados críticos e mantê-los fora do ambiente de produção.
6. **Monitoramento de Rede:** Implementar ferramentas de monitoramento de rede para detectar atividades suspeitas.
7. **Restrição de Acesso:** Conceder privilégios de acesso mínimos necessários para cada usuário ou sistema.
8. **Políticas de Segurança:** Desenvolver políticas de segurança e procedimentos de resposta a incidentes.

## [Blockchain](Blockchain/Readme.md)
Blockchain é uma tecnologia de registro distribuído que visa a descentralização como medida de segurança. A principal característica do blockchain é que os dados são armazenados em blocos encadeados, criando um registro permanente de todas as transações. Cada bloco contém um conjunto de transações e é ligado ao bloco anterior por meio de uma função de hash, formando uma cadeia. Essa tecnologia ficou famosa por ser a base das criptomoedas, como o Bitcoin.

### Principais Características do Blockchain
1. **Descentralização:** Diferentemente dos sistemas centralizados, como bancos, o blockchain é mantido por uma rede de computadores em todo o mundo, sem uma autoridade central.
2. **Imutabilidade:** Uma vez que os dados são registrados em um bloco, eles não podem ser alterados ou excluídos, garantindo a integridade do registro.
3. **Segurança:** Os registros são criptografados e protegidos por uma rede de nós (computadores), tornando difícil a modificação maliciosa dos dados.
4. **Transparência:** Todos os dados do blockchain são visíveis para os participantes da rede, garantindo transparência e confiança.
5. **Consenso:** Alterações no blockchain são feitas somente após consenso da maioria dos nós da rede, evitando fraudes.
6. **Contratos Inteligentes:** Recursos programáveis permitem a criação de contratos inteligentes, que se autoexecutam quando as condições são atendidas.

### Uso do Blockchain
Além de seu uso em criptomoedas, o blockchain tem uma ampla variedade de aplicações, incluindo:

1. **Fornecimento e Logística:** Rastreamento transparente de produtos ao longo da cadeia de suprimentos.
2. **Setor Financeiro:** Transferências e liquidações mais rápidas e econômicas, com redução da necessidade de intermediários.
3. **Ativos Digitais:** Tokenização de ativos, como imóveis e obras de arte, facilitando a negociação e a propriedade compartilhada.
4. **Votação Eletrônica:** Registro seguro e transparente de votos, aumentando a confiança nas eleições.
5. **Assistência Médica:** Registro de históricos médicos e compartilhamento seguro de informações de pacientes.
6. **Gestão de Identidade:** Controle sobre dados de identificação pessoal e acesso seletivo

 a serviços.
7. **Jogos Online:** Itens e personagens de jogos representados como ativos digitais únicos no blockchain.
8. **Setor Imobiliário:** Facilita a compra, venda e troca de propriedades com facilidade de transações.

## [Internet das Coisas (IoT)](IoT/Readme.md)
A Internet das Coisas (IoT) refere-se à interconexão de dispositivos físicos, veículos, eletrodomésticos e outros itens incorporados com eletrônicos, software, sensores e conectividade de rede. Isso permite que esses objetos coletem e troquem dados. A IoT tem um impacto significativo em uma variedade de setores, incluindo automação residencial, saúde, indústria e cidades inteligentes.

### Componentes da IoT
1. **Dispositivos IoT:** São os objetos físicos equipados com sensores, processadores e tecnologia de comunicação que coletam e transmitem dados.
2. **Sensores:** Dispositivos que coletam informações do ambiente, como temperatura, umidade, luz, movimento, etc.
3. **Conectividade:** A comunicação entre dispositivos e servidores ocorre por meio de redes, como Wi-Fi, Bluetooth, 4G/5G e LPWAN.
4. **Plataformas IoT:** São sistemas que facilitam a configuração, gerenciamento e análise de dispositivos e dados IoT.
5. **Cloud:** É onde os dados coletados são armazenados, processados e disponibilizados para análise.
6. **Aplicativos:** As interfaces que os usuários finais utilizam para interagir com os dados e dispositivos IoT.

### Aplicações da IoT
A IoT tem várias aplicações em diversos setores, incluindo:

1. **Cidades Inteligentes:** Monitoramento de tráfego, gerenciamento de resíduos, iluminação pública eficiente.
2. **Indústria:** Manutenção preditiva, monitoramento de ativos, automação de fábricas.
3. **Saúde:** Dispositivos de monitoramento médico, assistência ao paciente.
4. **Agricultura:** Agricultura de precisão, monitoramento de gado.
5. **Automotivo:** Veículos autônomos, seguros baseados em telemática.
6. **Casa Inteligente:** Termostatos inteligentes, sistemas de segurança.
7. **Varejo:** Contagem de estoque automatizada, experiências de compra personalizadas.
8. **Energia:** Medidores inteligentes, gerenciamento de consumo de energia.
9. **Ambiente:** Monitoramento de qualidade do ar, conservação de recursos naturais.
10. **Logística:** Rastreamento de ativos, otimização de rotas de entrega.

### Desafios da IoT
A IoT apresenta desafios, incluindo:

1. **Segurança:** Proteger dispositivos IoT contra ataques cibernéticos.
2. **Privacidade:** Gerenciar a coleta e o uso de dados pessoais.
3. **Padrões: **Falta de padrizações consistentes na indústria.
4. **Gerenciamento de Dados:** Lidar com grandes volumes de dados gerados por dispositivos.
5. **Consumo de Energia:** Garantir que dispositivos tenham consumo eficiente de energia.

## [Robótica](Robotics/Readme.md)
A robótica é um campo interdisciplinar que envolve o projeto, construção, operação e uso de robôs para realizar tarefas autônomas em ambientes variados. Os robôs são máquinas programáveis que podem ser usadas em uma variedade de aplicações, desde manufatura industrial até cirurgia médica e exploração espacial.

### Componentes de um Robô
Os robôs consistem em vários componentes-chave, incluindo:

1. **Sensores:** Dispositivos que permitem que o robô perceba e colete informações sobre seu ambiente, como câmeras, microfones, acelerômetros e sensores de proximidade.
2. **Atuadores:** Mecanismos que permitem que o robô realize ações físicas, como motores, pistões hidráulicos ou articulações mecânicas.
3. **Controladores:** O "cérebro" do robô, que processa informações dos sensores e decide como os atuadores devem responder.
4. **Estrutura Mecânica:** O corpo físico do robô que abriga os sensores, atuadores e controladores.

### Tipos de Robôs
Há muitos tipos diferentes de robôs, incluindo:

1. **Robôs Industriais:** Usados na fabricação para automatizar tarefas repetitivas, como montagem e soldagem.
2. **Robôs Médicos:** Auxiliam cirurgiões em procedimentos precisos, realizam diagnósticos médicos e auxiliam na reabilitação.
3. **Robôs de Serviço:** Projetados para interagir com pessoas e realizar tarefas de serviços, como limpeza doméstica e assistência ao cliente.
4. **Veículos Autônomos:** Incluem carros autônomos, drones e robôs de entrega.
5. **Robôs de Exploração:** Usados em missões de exploração espacial, subaquáticas ou em ambientes hostis.
6. **Robôs de Entretenimento:** Brinquedos e dispositivos de entretenimento equipados com recursos de IA.

### Inteligência Artificial na Robótica
A inteligência artificial (IA) desempenha um papel fundamental na robótica moderna. Os robôs são frequentemente equipados com algoritmos de IA que lhes permitem tomar decisões com base em dados de sensores. A aprendizado de máquina é frequentemente usada para melhorar a capacidade dos robôs de realizar tarefas complexas e se adaptar a ambientes variados.

### Ética na Robótica
O avanço da robótica levanta questões éticas, incluindo aquelas relacionadas à automação de empregos, segurança, privacidade e o uso de robôs em aplicações militares. A sociedade está cada vez mais confrontada com o desafio de desenvolver políticas e regulamentos para garantir o uso ético e responsável da robótica.

## [Realidade Virtual (VR) e Realidade Aumentada (AR)](Virtual%20Reality%20and%20Augmented%20Reality/Readme.md)
Realidade Virtual (VR) e Realidade Aumentada (AR) são tecnologias que alteram nossa percepção
### Aprendizado de Máquina por Reforço
Isso treina máquinas por tentativa e erro para tomar a melhor ação, estabelecendo um sistema de recompensa. A aprendizagem por reforço pode treinar modelos para jogar jogos ou treinar veículos autônomos a dirigir, dizendo à máquina quando ela tomou as decisões certas, o que ajuda a aprender ao longo do tempo quais ações deve tomar.

Aplicações Práticas da Aprendizagem por Reforço -
1. **Sistemas de Produção**
   por exemplo, Google Cloud AutoML, Facebook Horizon, Recomendação, publicidade, pesquisa
2. **Condução Autônoma**
3. **Gestão Empresarial**
   por exemplo, resolvendo o problema de roteamento de veículos, comportamento fraudulento no comércio eletrônico, Aprendizado por reforço simultâneo a partir das interações com o cliente
4. **Sistemas de Recomendação**
   por exemplo, para pesquisa, recomendação e publicidade online

### Aprendizado de Máquina também está associado a vários outros subcampos da inteligência artificial:

### Processamento de Linguagem Natural

O processamento de linguagem natural é um campo de aprendizado de máquina no qual as máquinas aprendem a entender a linguagem natural, falada e escrita por humanos, em vez dos dados e números normalmente usados para programar computadores. Isso permite que as máquinas reconheçam a linguagem, a compreendam e respondam a ela, além de criar novo texto e traduzir entre idiomas. O processamento de linguagem natural permite tecnologias familiares, como chatbots e assistentes digitais como Siri ou Alexa.

Aplicações Práticas do Processamento de Linguagem Natural:
1. **Resposta a Perguntas:** A resposta a perguntas se concentra na construção de sistemas que respondem automaticamente às perguntas feitas por humanos em linguagem natural.
2. **Detecção de Spam:** A detecção de spam é usada para detectar e-mails indesejados que chegam à caixa de entrada do usuário.
3. **Análise de Sentimento:** A análise de sentimento, também conhecida como mineração de opinião, é usada na web para analisar a atitude, comportamento e estado emocional do remetente. Essa aplicação é implementada por meio de uma combinação de PNL (Processamento de Linguagem Natural) e estatísticas, atribuindo valores ao texto (positivo, negativo ou neutro) e identificando o humor do contexto (feliz, triste, com raiva, etc.).
4. **Tradução Automática:** A tradução automática é usada para traduzir texto ou fala de um idioma natural para outro. por exemplo, o Google Tradutor
5. **Correção Ortográfica:** A Microsoft Corporation fornece software de processamento de texto como o MS-Word e o PowerPoint para correção ortográfica.

### Redes Neurais

As redes neurais são um tipo comum de algoritmo de aprendizado de máquina. As redes neurais artificiais são modeladas com base no cérebro humano, em que milhares ou milhões de nós de processamento estão interconectados e organizados em camadas.

Em uma rede neural artificial, células ou nós estão conectados, com cada célula processando entradas e produzindo uma saída que é enviada para outros neurônios. Os dados rotulados passam pelos nós ou células, com cada célula desempenhando uma função diferente. Em uma rede neural treinada para identificar se uma imagem contém um gato ou não, os diferentes nós avaliariam as informações e chegariam a uma saída que indica se a imagem possui um gato.

Aplicações Práticas de Redes Neurais:
1. **Previsão do Mercado de Ações:** Para fazer uma previsão de ações bem-sucedida em tempo real, é empregado um Multilayer Perceptron MLP (classe de algoritmo de inteligência artificial feedforward). MLP compreende várias camadas de nós, e cada uma dessas camadas está totalmente conectada aos nós sucessores. O desempenho passado das ações, retornos anuais e índices sem fins lucrativos são considerados para a construção do modelo MLP.
2. **Mídias Sociais:** Perceptrons de múltiplas camadas preveem tendências de mídias sociais. Ele usa diferentes métodos de treinamento, como Erro Médio Absoluto (MAE), Erro Quadrático Médio (RMSE) e Erro Quadrático Médio (MSE). O MLP leva em consideração vários fatores, como as páginas favoritas dos usuários do Instagram, escolhas favoritas, etc. Após a análise do comportamento das pessoas por meio de redes sociais, os dados podem ser vinculados aos hábitos de gastos das pessoas. O MLP ANN é usado para minerar dados de aplicativos de mídia social.
3. **Aeroespacial:** A engenharia aeroespacial é um termo amplo que abrange desenvolvimentos em espaçonaves e aeronaves. Diagnóstico de falhas, piloto automático de alto desempenho, segurança de sistemas de controle de aeronaves e modelagem de simulações dinâmicas-chave são algumas das áreas-chave em que as redes neurais assumiram o controle. Redes neurais de atraso de tempo podem ser usadas para modelar sistemas dinâmicos não lineares no tempo.

### Aprendizado Profundo

As redes de aprendizado profundo são redes neurais com muitas camadas. A rede em camadas pode processar grandes quantidades de dados e determinar o "peso" de cada ligação na rede, como em um sistema de reconhecimento de imagem, onde algumas camadas da rede neural podem detectar características individuais de um rosto, como os olhos, o nariz ou a boca, enquanto outra camada pode determinar se essas características aparecem de uma maneira que indica um rosto.

Aplicações Práticas de Aprendizado Profundo:
1. **Geração Automática de Texto -** Um corpus de texto é aprendido, e a partir desse modelo, um novo texto é gerado, palavra por palavra ou caractere por caractere. Este modelo é capaz de aprender a ortografia, pontuação e formação de frases, ou até mesmo capturar o estilo.
2. **Saúde -** Ajuda no diagnóstico de várias doenças e no tratamento delas.
3. **Tradução Automática -** Certas palavras, frases ou expressões em um idioma são transformadas em outro idioma (o Aprendizado Profundo está obtendo os melhores resultados nas áreas de texto e imagens).
4. **Reconhecimento de Imagens -** Reconhece e identifica pessoas e objetos em imagens, além de entender o conteúdo e o contexto. Esta área já está sendo usada em jogos, varejo, turismo, etc.
5. **Previsão de Terremotos -** Ensina um computador a realizar cálculos viscoelásticos, usados na previsão de terremotos.

## [Tecnologia da Web](Tecnologia%20da%20Web/WebTechnology.md#tecnologia-da-web)
A tecnologia da web refere-se às diversas ferramentas e técnicas usadas no processo de comunicação entre diferentes tipos de dispositivos pela Internet. Um navegador da web é usado para acessar páginas da web. Navegadores da web podem ser definidos como programas que exibem texto, dados, imagens, animação e vídeo na Internet. Recursos hiperlinkados na World Wide Web podem ser acessados usando interfaces de software fornecidas pelos navegadores da web.

### A tecnologia da web pode ser classificada nas seguintes seções:
- World Wide Web (WWW)
A World Wide Web é baseada em várias tecnologias diferentes: navegadores da web, Linguagem de Marcação de Hipertexto (HTML) e Protocolo de Transferência de Hipertexto (HTTP).
- Navegador da web
O navegador da web é um software de aplicativo para explorar a World Wide Web (WWW). Ele fornece uma interface entre o servidor e o cliente e solicita ao servidor documentos e serviços da web.
- Servidor web
Um servidor da web é um programa que processa as solicitações de rede dos usuários e fornece a eles arquivos que criam páginas da web. Essa troca ocorre usando o Protocolo de Transferência de Hipertexto (HTTP).
- Páginas da web
Uma página da web é um documento digital vinculado à World Wide Web e acessível por qualquer pessoa conectada à Internet que tenha um navegador da web.
- Desenvolvimento web
O desenvolvimento web refere-se à construção, criação e manutenção de sites. Inclui aspectos como design da web, publicação da web, programação da web e gerenciamento de banco de dados. É a criação de um aplicativo que funciona pela Internet, ou seja, sites.
### O desenvolvimento web pode ser classificado de duas maneiras:
### Desenvolvimento Frontend
A parte de um site em que o usuário interage diretamente é chamada de frontend. Também é conhecida como o "lado do cliente" do aplicativo.
### Desenvolvimento Backend
O backend é o lado do servidor de um site. É a parte do software que não entra em contato direto com os usuários. É usado para armazenar e organizar dados.

# [Redes de Computadores](Redes/readme.md#redes-de-computadores)
Uma rede de computadores é um conjunto de computadores que compartilham recursos localizados em ou fornecidos por meio de uma rede de telecomunicações. As redes de computadores usam protocolos de comunicação para compartilhar recursos e informações entre dispositivos na rede. Estas redes podem ser tão pequenas quanto duas máquinas ou tão grandes quanto bilhões de dispositivos interconectados.

## Tipos de redes
Existem dois tipos principais de redes de computadores:
- Redes com fio: As redes com fio requerem o uso de um meio físico para o transporte entre os nós. Cabos Ethernet de cobre, populares devido ao seu baixo custo e durabilidade, são comumente usados para comunicações digitais em empresas e residências. Alternativamente, a fibra óptica é usada para transportar dados a distâncias maiores e a velocidades mais rápidas, mas apresenta algumas desvantagens, incluindo custos mais altos e componentes mais frágeis.
- Redes sem fio: As redes sem fio usam ondas de rádio para transportar dados pelo ar, permitindo que os dispositivos se conectem a uma rede sem a necessidade de cabos físicos. Redes LAN sem fio são o tipo mais conhecido e amplamente implantado de rede sem fio. As alternativas incluem micro-ondas, satélite, celular e Bluetooth, entre outras.

## Modelo OSI
OSI significa **Open Systems Interconnection** (Interconexão de Sistemas Abertos). Foi desenvolvido pela ISO - 'Organização Internacional de Normalização' no ano de 1984. É uma arquitetura de 7 camadas, em que cada camada possui funcionalidade específica para realizar. Todas essas sete camadas trabalham em colaboração para transmitir os dados de uma pessoa para outra em todo o mundo.

### **1\. Camada Física (Camada 1):**

A camada mais baixa do modelo de referência OSI é a camada física. Ela é responsável pela conexão física real entre os dispositivos. A camada física contém informações na forma de **bits**. É responsável por transmitir bits individuais de um nó para outro. Ao receber dados, esta camada obtém o sinal recebido e o converte em 0s e 1s e os envia para a camada de link de dados, que recomporá o quadro.

![](Redes/OSI%20Model/img/computer-network-osi-model-layers-bits.png)

As funções da camada física são as seguintes:

1. **Sincronização de bits:** A camada física fornece a sincronização dos bits fornecendo um relógio. Este relógio controla tanto o remetente quanto o receptor, fornecendo sincronização no nível do bit.
2. **Controle de taxa de bits:** A camada física também define a taxa de transmissão, ou seja, o número de bits enviados por segundo.
3. **Topologias físicas:** A camada física especifica como os diferentes dispositivos/nós estão dispostos em uma rede, ou seja, a topologia de barramento, estrela ou malha.
4. **Modo de transmissão:** A camada física também define como os dados fluem entre os dois dispositivos conectados. Os diversos modos de transmissão possíveis são simples, half-duplex e full-duplex.

### **2\. Camada de Enlace de Dados (DLL) (Camada 2):**

A camada de enlace de dados é responsável pela entrega de nó a nó da mensagem. A principal função desta camada é garantir a transferência de dados sem erros de um nó para outro em uma camada na camada física. Quando um pacote chega a uma rede, é responsabilidade da DLL transmiti-lo ao host usando seu endereço MAC. A Camada de Enlace de Dados é dividida em duas subcamadas:

1. Controle Lógico de Enlace (LLC)
2. Controle de Acesso à Mídia (MAC)

O pacote recebido da camada de rede é dividido em quadros, dependendo do tamanho do quadro da NIC (Cartão de Interface de Rede). A DLL também encapsula o endereço MAC do remetente e/ou receptor no cabeçalho. 

O endereço MAC do receptor é obtido colocando uma solicitação ARP (Protocolo de Resolução de Endereços) na rede, perguntando: "Quem possui esse endereço IP?" e o host de destino responderá com seu endereço MAC.

![](Redes/OSI%20Model/img/computer-network-osi-model-layers-framing.png)

As funções da camada de Enlace de Dados são as seguintes:

1. **Moldagem:** A moldagem é uma função da camada de enlace de dados. Ela fornece uma maneira para um remetente transmitir um conjunto de bits que são significativos para o receptor. Isso pode ser alcançado anexando padrões de bits especiais no início e no final do quadro.
2. **Endereçamento físico:** Após a criação dos quadros, a camada de Enlace de Dados adiciona os endereços físicos (endereços MAC) do remetente e/ou receptor no cabeçalho de cada quadro.
3. **Controle de erros:** A camada de Enlace de Dados fornece o mecanismo de controle de erros no qual ele detecta e retransmite quadros danificados ou perdidos.
4. **Controle de fluxo:** A taxa de dados deve ser constante em ambos os lados, caso contrário, os dados podem ser corrompidos. Portanto, o controle de fluxo coordena a quantidade de dados que pode ser enviada antes de receber um reconhecimento.
5. **Controle de acesso:** Quando um único canal de comunicação é compartilhado por vários dispositivos, a subcamada MAC da camada de enlace de dados ajuda a determinar qual dispositivo tem controle sobre o canal em um determinado momento.

### **3\. Camada de Rede (Camada 3):**

A camada de rede funciona para a transmissão de dados de um host para outro localizado em redes diferentes. Ela também cuida do roteamento de pacotes, ou seja, da seleção do caminho mais curto para transmitir o pacote do número de rotas disponíveis. Os endereços IP do remetente e receptor são colocados no cabeçalho pela camada de rede. 

As funções da camada de rede são:

1. **Roteamento:** Os protocolos da camada de rede determinam a rota mais adequada do remetente para o destino. Essa função da camada de rede é conhecida como roteamento.
2. **Endereçamento lógico:** Para identificar cada dispositivo em uma internetwork exclusivamente, a camada de rede define um esquema de endereçamento. Os endereços IP do remetente e receptor são colocados no cabeçalho pela camada de rede.
  
## [Internet](Internet/readme.md#internet)
A Internet é um sistema global de redes de computadores interconectadas que usam o conjunto de protocolos da Internet (TCP/IP) para atender a bilhões de usuários em todo o mundo. É uma rede de redes que consiste em milhões de redes privadas, públicas, acadêmicas, empresariais e governamentais de escopo local a global, interligadas por várias tecnologias de rede eletrônica, sem fio e óptica. A Internet transporta uma ampla gama de recursos de informação e serviços, como documentos interligados por hipertexto e aplicativos da World Wide Web (WWW) e a infraestrutura para suportar e-mail.

## [World Wide Web (WWW)](Internet/readme.md#world-wide-web-www)
A World Wide Web (WWW) é um espaço de informação onde documentos e outros recursos da web são identificados por URLs, interligados por links de hipertexto e acessíveis via Internet. O cientista inglês Tim Berners-Lee inventou a World Wide Web em 1989. Ele escreveu o primeiro navegador da web em 1990, enquanto estava empregado no CERN na Suíça. O navegador foi lançado fora do CERN em 1991, primeiro para outras instituições de pesquisa a partir de janeiro de 1991 e para o público em geral na Internet em agosto de 1991.

## [Protocolo de Internet (IP)](Internet/readme.md#internet-protocol-ip)
O Protocolo de Internet (IP) é um protocolo ou conjunto de regras para rotear e endereçar pacotes de dados, de modo que eles possam viajar por redes e chegar ao destino correto. Os dados que atravessam a Internet são divididos em pedaços menores chamados pacotes. O IP é responsável por rotear esses pacotes de um lugar para outro na Internet e garantir que eles cheguem ao destino correto. O IP é a base da comunicação na Internet e é uma parte fundamental do funcionamento da rede global.

## [Navegadores da Web](Internet/WebBrowsers.md#navegadores-da-web)
Um navegador da web é um software que permite aos usuários acessar, visualizar e interagir com documentos e outros recursos na World Wide Web. Os navegadores da web são aplicativos essenciais para a experiência de navegação na web e são usados para acessar sites, ler conteúdo, assistir a vídeos, fazer compras online, interagir com aplicativos da web e muito mais.

Os navegadores da web funcionam como intermediários entre os usuários e os servidores da web. Quando um usuário insere um URL (Localizador Uniforme de Recursos) ou clica em um link, o navegador solicita a página da web correspondente do servidor e a exibe ao usuário. Eles também fornecem ferramentas para navegação, como botões de voltar e avançar, favoritos, guias e barras de pesquisa.

Alguns dos navegadores da web mais populares incluem:

1. **Google Chrome**
2. **Mozilla Firefox**
3. **Apple Safari**
4. **Microsoft Edge**
5. **Opera**
6. **Brave**
7. **Vivaldi**

# [Segurança de Rede](Security/NetworkSecurity.md#seguran%C3%A7a-de-rede)
A segurança de rede envolve práticas, políticas e tecnologias para proteger a integridade, confidencialidade e disponibilidade dos dados de rede. É essencial para proteger a infraestrutura de rede contra ameaças, ataques cibernéticos e acesso não autorizado.

## Tópicos de Segurança de Rede
1. **Firewalls:** Os firewalls são dispositivos ou programas que controlam o tráfego de rede, permitindo ou bloqueando o tráfego com base em regras de segurança.

2. **Criptografia:** A criptografia é o processo de codificar dados para que apenas pessoas autorizadas possam acessá-los. É usado para proteger a confidencialidade dos dados.

3. **Autenticação:** A autenticação envolve a verificação da identidade de usuários ou dispositivos que tentam acessar a rede. Isso ajuda a garantir que apenas pessoas autorizadas tenham acesso.

4. **Vírus e Malware:** Proteger contra vírus, malware e outras ameaças cibernéticas é essencial para manter a segurança da rede.

5. **Segurança sem fio:** Redes sem fio estão sujeitas a ameaças especiais e precisam de medidas de segurança específicas.

6. **Políticas de Segurança:** A criação e implementação de políticas de segurança ajuda a definir práticas seguras para funcionários e usuários.

7. **Monitoramento de Rede:** O monitoramento contínuo da rede ajuda a identificar e responder a possíveis ameaças em tempo real.

8. **Gestão de Identidade e Acesso:** Gerenciar as identidades dos usuários e seu acesso à rede é fundamental para a segurança.

## **Firewalls**
Os firewalls são um componente crítico da segurança de rede. Eles atuam como barreiras entre redes confiáveis e não confiáveis, filtrando o tráfego com base em regras de segurança predefinidas. Os firewalls podem ser implementados em hardware, software ou uma combinação de ambos.

**Tipos de Firewalls:**
1. **Firewall de Pacotes:** Este tipo de firewall examina pacotes individuais de dados e decide permitir ou bloquear com base em regras como endereços IP e portas.
2. **Firewall de Estado:** Este firewall monitora o estado da conexão e permite ou bloqueia o tráfego com base no estado da conexão.
3. **Firewall de Próxima Geração (NGFW):** Este firewall combina funcionalidades de firewall de pacotes com recursos de inspeção de aplicativos e controle de conteúdo.

**Funções principais dos firewalls:**
1. **Filtragem de Pacotes:** Decide permitir ou bloquear pacotes com base em endereços IP, portas e protocolos.
2. **Tradução de Endereço de Rede (NAT):** Altera os endereços IP e portas de origem e destino dos pacotes.
3. **Proxy de Aplicativo:** Age como intermediário entre clientes e servidores, controlando o tráfego entre eles.
4. **Detecção e Prevenção de Intrusões (IDS/IPS):** Monitora o tráfego em busca de atividades suspeitas e bloqueia ou relata essas atividades.

## [Criptografia](Security/Encryption.md#criptografia)
A criptografia é uma técnica usada para proteger informações sensíveis, tornando-as ilegíveis para qualquer pessoa que não tenha a chave de descriptografia apropriada. É uma parte fundamental da segurança da informação e é usada em várias aplicações, como comunicações seguras, armazenamento de dados protegidos e transações financeiras.

## **Princípios de Criptografia:**
1. **Confidencialidade:** A criptografia protege as informações, garantindo que apenas as pessoas autorizadas possam acessá-las.

2. **Integridade:** A criptografia ajuda a detectar qualquer alteração não autorizada nos dados. Se os dados forem alterados, a descriptografia produzirá informações diferentes.

3. **Autenticidade:** A criptografia pode ser usada para verificar a identidade das partes envolvidas em uma comunicação.

4. **Não Repúdio:** A criptografia pode ser usada para garantir que uma parte não possa negar sua participação em uma transação.

## [Autenticação](Security/Authentication.md#autentica%C3%A7%C3%A3o)
A autenticação é o processo de verificar a identidade de um usuário, dispositivo ou sistema que tenta acessar uma rede ou recurso. É uma parte fundamental da segurança de rede e é usada para garantir que apenas pessoas autorizadas tenham acesso a informações confidenciais.

## **Métodos de Autenticação:**
1. **Nome de usuário e senha:** Os usuários fornecem um nome de usuário e uma senha que correspondem a uma conta autorizada.

2. **Autenticação de dois fatores (2FA):** Os usuários fornecem um segundo fator de autenticação além da senha, como um código enviado por SMS ou gerado por um aplicativo.

3. **Biometria:** A autenticação biométrica usa características físicas ou comportamentais únicas, como impressão digital, reconhecimento facial ou íris, para verificar a identidade.

4. **Token de segurança:** Os tokens de segurança são dispositivos físicos que geram códigos temporários para autenticação.

## [Vírus e Malware](Security/VirusMalware.md#v%C3%ADrus-e-malware)
Vírus e malware são tipos de software malicioso que podem infectar computadores e redes, causando danos e comprometendo a segurança. Eles são uma ameaça significativa à segurança de rede e devem ser tratados com ferramentas antivírus e boas práticas de segurança.

## **Tipos de Ameaças:**
1. **Vírus de Computador:** Programas de software que se anexam a arquivos legítimos e se espalham quando esses arquivos são executados.

2. **Worms:** Programas de malware autônomos que se espalham rapidamente pela rede, explorando vulnerabilidades de segurança.

3. **Cavalos de Troia (Trojans):** Programas que se disfarçam como software legítimo, mas têm funcionalidades maliciosas ocultas.

4. **Spyware:** Software que rastreia a atividade do usuário sem o seu conhecimento ou consentimento.

5. **Ransomware:** Malware que criptografa os dados do usuário e exige um resgate para desbloqueá-los.

6. **Adware:** Software que exibe anúncios indesejados aos usuários.

## **Medidas de Proteção:**
1. **Software Antivírus:** Use software antivírus atualizado para detectar e remover malware.

2. **Firewalls:** Configure firewalls para bloquear tráfego malicioso.

3. **Atualizações de Software:** Mantenha o sistema operacional e o software atualizados para corrigir vulnerabilidades de segurança.

4. **Conscientização do Usuário:** Eduque os usuários sobre práticas seguras de navegação e uso de e-mail.

5. **Cópias de Segurança (Backups):** Faça backups regulares dos dados importantes.

## [Segurança sem Fio](Security/WirelessSecurity.md#seguran%C3%A7a-sem-fio)
A segurança das redes sem fio (Wi-Fi) é essencial para proteger os dados e a privacidade dos usuários. As redes Wi-Fi estão sujeitas a ameaças específicas, como acesso não autorizado e interceptação de dados.

## **Medidas de Segurança Wi-Fi:**
1. **Criptografia:** Use criptografia WPA3 ou WPA2 para proteger o tráfego Wi-Fi.

2. **Senhas Fortes:** Use senhas seguras para a rede Wi-Fi e o roteador.

3. **Filtragem de Endereços MAC:** Liste os dispositivos autorizados que podem se conectar à rede com base em seus endereços MAC.

4. **Ocultar o Nome da Rede (SSID):** Oculte o nome da rede Wi-Fi para que não seja visível para dispositivos não autorizados.

5. **Atualizações de Firmware:** Mantenha o firmware do roteador atualizado para corrigir vulnerabilidades.

6. **Redes de Convidados:** Crie redes separadas para convidados com acesso limitado à rede principal.

## [Políticas de Segurança](Security/SecurityPolicies.md#pol%C3%ADticas-de-seguran%C3%A7a)
As políticas de segurança são diretrizes e procedimentos que definem as práticas de segurança em uma organização. Elas desempenham um papel fundamental na proteção de ativos e na redução de riscos.

## **Componentes de Políticas de Segurança:**
1. **Acesso e Autenticação:** Define quem tem acesso aos sistemas e como a autenticação é realizada.

2. **Controle de Acesso:** Define quem tem acesso a recursos específicos e sob quais condições.

3. **Gerenciamento de Senhas:** Estabelece requisitos e práticas para senhas seguras.

4. **Monitoramento e Auditoria:** Define como as atividades de rede são monitoradas e auditadas.

5. **Treinamento de Usuário:** Educa os funcionários sobre práticas seguras e procedimentos.

6. **Plano de Recuperação de Desastres:** Define procedimentos para lidar com falhas de segurança e desastres.

## [Monitoramento de Rede](Security/NetworkMonitoring.md#monitoramento-de-rede)
O monitoramento de rede é a prática de acompanhar o tráfego de rede e o desempenho dos dispositivos para garantir que a rede esteja operando corretamente e para identificar possíveis problemas ou ameaças de segurança.

## **Objetivos do Monitoramento de Rede:**
1. **Identificar Problemas de Desempenho:** Identificar gargalos, alta utilização de largura de banda e outros problemas que afetam o desempenho da rede.

2. **Detecção de Ameaças de Segurança:** Monitorar o tráfego em busca de atividades suspeitas que possam indicar ameaças de segurança.

3. **Planejamento de Capacidade:** Acompanhar o crescimento da rede e planejar a capacidade para atender às necessidades futuras.

4. **Conformidade e Relatórios:** Garantir que a rede esteja em conformidade com políticas e regulamentos e gerar relatórios para documentar o desempenho e a segurança da rede.

## [Gestão de Identidade e Acesso](Security/IdentityAccessManagement.md#gest%C3%A3o-de-identidade-e-acesso)
A gestão de identidade e acesso (IAM) envolve a administração de identidades de usuários e seu acesso a sistemas e recursos na rede. É fundamental para garantir que apenas pessoas autorizadas tenham acesso aos recursos apropriados.

## **Componentes da IAM:**
1. **Provisionamento de Usuário:** Criar, modificar e excluir contas de usuário conforme necessário.

2. **Autenticação:** Verificar a identidade do usuário por meio de métodos como senhas, autenticação de dois fatores (2FA) e biometria.

3. **Autorização:** Definir permissões e privilégios de acesso para usuários com base em suas funções e necessidades.

4. **Gerenciamento de Senhas:** Estabelecer políticas para senhas seguras e fornecer ferramentas para redefinição de senhas.

5. **Gerenciamento de Grupos:** Agrupar usuários com base em funções ou departamentos para facilitar o gerenciamento.

6. **Auditoria e Relatórios:** Monitorar e documentar o acesso do usuário para conformidade e segurança.

7. **Desativação de Usuário:** Desativar contas de usuário quando não forem mais necessárias ou quando um usuário sai da organização.

## [Fundamentos da Segurança de Rede](Security/NetworkSecurityFundamentals.md#fundamentos-da-seguran%C3%A7a-de-rede)
Os fundamentos da segurança de rede incluem princípios e práticas essenciais para proteger uma rede contra ameaças e vulnerabilidades. Estes princípios são relevantes para qualquer organização que utilize redes para comunicação e compartilhamento de recursos.

## **Princípios Fundamentais:**
1. **Segurança em Profundidade:** A segurança de rede deve ser abordada em várias camadas e em todos os pontos de acesso.

2. **Princípio do Menor Privilégio:** Os usuários e sistemas devem ter apenas o acesso necessário para realizar suas funções.

3. **Defesa em Camadas:** Use várias camadas de segurança, como firewalls, detecção de intrusões e criptografia, para proteger a rede.

4. **Atualizações e Patches:** Mantenha sistemas e software atualizados com as últimas correções de segurança.

5. **Conscientização do Usuário:** Eduque os usuários sobre práticas seguras, como senhas fortes e detecção de e-mails de phishing.

## **Melhores Práticas de Segurança:**
1. **Senhas Fortes:** Exija senhas seguras que incluam letras maiúsculas e minúsculas, números e caracteres especiais.

2. **Monitoramento Contínuo:** Monitore a rede em busca de atividades suspeitas ou intrusões.

3. **Auditorias de Segurança:** Realize auditorias regulares para identificar vulnerabilidades e avaliar a conformidade.

4. **Políticas de Segurança:** Estabeleça políticas de segurança claras e comunique-as a todos os funcionários.

5. **Planos de Resposta a Incidentes:** Tenha planos em vigor para responder a incidentes de segurança de rede.

6. **Testes de Penetração:** Realize testes de penetração para identificar vulnerabilidades na rede.

7. **Backup de Dados:** Faça backups regulares dos dados para recuperação em caso de perda de dados.
