<h1 align="center">कम्प्युटर विज्ञान</h1>
<h4 align="center">
    <p>
        <a href="https://github.com/shhossain/computer_science/blob/main/README.md">English</a> |
        <a href="https://github.com/shhossain/computer_science/blob/main/README_it.md">Italiano</a> |
        <a href="https://github.com/shhossain/computer_science/blob/main/README_es.md">Español</a> |
        <a href="https://github.com/shhossain/computer_science/blob/main/README_fr.md">Français</a> |
        <a href="https://github.com/shhossain/computer_science/blob/main/README_bn.md">বাংলা</a> |
        <a href="https://github.com/shhossain/computer_science/blob/main/README_ta.md">தமிழ்</a> |
        <a href="https://github.com/shhossain/computer_science/blob/main/README_guj.md">ગુજરાતી</a> |
        <a href="https://github.com/shhossain/computer_science/blob/main/README_pt.md">Portuguese</a> |
        <a href="https://github.com/shhossain/computer_science/blob/main/README_hi.md">हिंदी</a> |
        <a href="https://github.com/shhossain/computer_science/blob/main/README_te.md">తెలుగు</a> |
        <a href="https://github.com/shhossain/computer_science/blob/main/README_ro.md">Română</a> |
        <a href="https://github.com/shhossain/computer_science/blob/main/README_ar.md">العربية</a> |
        <b>Nepali</b>
    </p>
</h4>

## योगदान दिशानिर्देशहरू
यदि तपाईं यस परियोजनामा योगदान गर्न इच्छुक हुनुहुन्छ भने, कसरी प्राप्त गर्ने भन्ने बारे विस्तृत निर्देशनहरूको लागि कृपया तल दिइएको लिङ्कमा हेर्नुहोस् [CONTRIBUTING.md](https://github.com/shhossain/computer_science/blob/main/CONTRIBUTING.md) तपाईंको योगदानहरू धेरै सराहनीय छन्!

## विषयवस्तुको तालिका

- [परिचय](#परिचय)
- [इलेक्ट्रोनिक-कम्प्युटर](#इलेक्ट्रोनिक-कम्प्यूटर)
- [बुलियन तर्क](#बूलियन-लजिक)
- [नम्बर प्रणालीहरू](#नम्बर-प्रणालीहरू)
- [Central Processing Unit(CPU)](#central-processing-unit-cpu)
- [रेजिस्टरहरू, क्यास, र RAM](#रेजिस्टरहरू-क्यास-र-RAM)
- [निर्देशन र कार्यक्रम](#निर्देशन-र-कार्यक्रम)
- [प्रोग्रामिङ भाषाहरू](#प्रोग्रामिङ-भाषाहरू)
- [डेटा प्रकारहरू](#डेटा-प्रकारहरू)
- [कथन र कार्यहरू](#कथन-र-कार्यहरू)
- [डेटा संरचनाहरू](#डेटा-संरचनाहरू)
- [एल्गोरिदम](#एल्गोरिदम)
- [एलन ट्युरिङ](#एलन-ट्युरिङ)
- [सफ्टवेयर इन्जिनियरिङ्](#सफ्टवेयर-इन्जिनियरिङ्)
- [एकीकृत सर्किट](#एकीकृत-सर्किट)
- [वस्तु उन्मुख प्रोग्रामिङ](#वस्तु-उन्मुख-प्रोग्रामिङ)
- [कार्यात्मक प्रोग्रामिङ](#कार्यात्मक-प्रोग्रामिङ)
- [अपरेटिङ सिस्टम्स](#अपरेटिङ-सिस्टम्स)
- [मेमोरी र भण्डारण](#मेमोरी-र-भण्डारण)
- [फाइल प्रणाली](#फाइल-प्रणाली)
- [क्लाउड कम्प्युटिङ](#क्लाउड-कम्प्युटिङ)
- [मेसिन लर्निङ](#मेसिन-लर्निङ)
- [वेब टेक्नोलोजी](#वेब-टेक्नोलोजी)
- [नेटवर्किङ](#नेटवर्किङ)
- [इन्टरनेट](#इन्टरनेट)
- [DBMS(डाटाबेस व्यवस्थापन प्रणाली)](#डाटाबेस-व्यवस्थापन-प्रणाली)
- [क्रिप्टोग्राफी](#क्रिप्टोग्राफी)
- [गणनाको सिद्धान्त](#गणनाको-सिद्धान्त)

## [परिचय]

कम्प्युटर विज्ञान भनेको कम्प्युटर र कम्प्युटिङ र तिनीहरूको सैद्धान्तिक र व्यावहारिक अनुप्रयोगहरूको अध्ययन हो। कम्प्युटर विज्ञानले गणित, ईन्जिनियरिङ् र तर्कका सिद्धान्तहरूलाई धेरै समस्याहरूमा लागू गर्दछ। यसमा एल्गोरिथ्म सूत्रीकरण, सफ्टवेयर/हार्डवेयर विकास, र कृत्रिम बुद्धिमत्ता समावेश छ।

## [#इलेक्ट्रोनिक कम्प्यूटर](Electronic%20Computer/readme.md)
एउटा यन्त्र जसले कम्प्युट गर्छ, विशेष गरी एउटा प्रोग्रामेबल इलेक्ट्रोनिक मेसिन जसले उच्च-गतिको गणितीय वा तार्किक अपरेसनहरू गर्छ वा जानकारीलाई भेला, भण्डारण, सहसंबद्ध वा अन्यथा प्रक्रिया गर्छ।

## [बूलियन लजिक](Boolean%20Logic/readme.md)
बुलियन तर्क गणितको एक शाखा हो जुन सत्य र असत्यको मूल्यहरूसँग सम्बन्धित छ। यो तर्कको एक प्रणाली हो जसले क्रमशः गलत र सत्यलाई प्रतिनिधित्व गर्न दुईवटा मानहरू, 0 र १ प्रयोग गर्दछ। यसलाई बूलियन बीजगणितको रूपमा पनि चिनिन्छ, जर्ज बुलको नामबाट नाम दिइएको छ, जसले यसलाई पहिलो पटक १८५४ मा वर्णन गरेको थियो।

### साधारण बुलियन अपरेटरहरू

| बुलियन अपरेटरहरू | नाम | विवरण |
| --- | --- | --- |

| अपरेटर | नाम |               विवरण               |
| :------: | :--: | :-------------------------------------: |
|    !     | NOT  |    अपरेन्डको मूल्यलाई अस्वीकार गर्दछ।    |
|    &&    | AND  | दुबै अपरेन्डहरू सही भएमा **true** फर्काउँछ। |
|   \|\|   |  OR  | एक वा सबै अपरेन्डहरू सत्य भएमा **true** फर्काउँछ। |

### जान्न राम्रो बुलियन अपरेटरहरू

| बुलियन अपरेटरहरू | नाम |               विवरण               |
| :------: | :--: | :-------------------------------------: |
|    ()    | Parentheses     |   तपाईंलाई किवर्डहरू समूहबद्ध गर्न र सर्तहरू खोजिने क्रममा नियन्त्रण गर्न अनुमति दिन्छ।    |
|    “”    | Quotation marks | सटीक वाक्यांशको साथ परिणामहरू प्रदान गर्दछ। |
|   *      |  Asterisk       | खोजशब्द भिन्नता समावेश परिणामहरू प्रदान गर्दछ। |
|   ⊕     |  XOR            | अपरेन्डहरू फरक भएमा **true** फर्काउँछ। |
|   ⊽      |  NOR            | सबै अपरेन्डहरू गलत भएमा **true** फर्काउँछ। |
|   ⊼      |  NAND           | यसका दुई इनपुटका दुवै मानहरू सत्य भएमा मात्र **false** फर्काउँछ। |


## [नम्बर प्रणालीहरू](Number%20System/readme.md#number-systems)
संख्या प्रणालीहरू संख्याहरू व्यक्त गर्नका लागि गणितीय प्रणालीहरू हुन्। संख्या प्रणालीमा सङ्ख्याहरू प्रतिनिधित्व गर्न प्रयोग गरिने प्रतीकहरूको सेट र ती प्रतीकहरूलाई हेरफेर गर्नका लागि नियमहरूको सेट समावेश हुन्छ। संख्या प्रणालीमा प्रयोग हुने प्रतीकहरूलाई अंक भनिन्छ।

### [नम्बर प्रणालीका प्रकारहरू](Number%20System/readme.md#types-of-number-systems)
- [Positional Numeral System](Number%20System/readme.md#positional-numeral-system)
- [Sign-value Notation System](Number%20System/readme.md#sign-value-notation-system)

### [Common Positional Number Systems](Number%20System/readme.md#common-positional-number-systems)
- [बाइनरी](Number%20System/readme.md#binary)
- [अक्टल](Number%20System/readme.md#octal)
- [दशमलव](Number%20System/readme.md#decimal)
- [हेक्साडेसिमल](Number%20System/readme.md#hexadecimal)


### बाइनरी को महत्व
बाइनरी एक आधार-2 नम्बर प्रणाली हो जुन Gottfried Leibniz द्वारा आविष्कार गरिएको छ जुन केवल दुई संख्या वा अंकहरू मिलेर बनेको छ: 0 (शून्य) र 1 (एक)। यो नम्बरिङ प्रणाली सबै बाइनरी कोडहरूको लागि आधार हो, जुन डिजिटल डाटा लेख्न प्रयोग गरिन्छ जस्तै कम्प्युटर प्रोसेसर निर्देशनहरू हरेक दिन प्रयोग गरिन्छ। बाइनरीमा 0s र 1s ले क्रमशः OFF वा ON लाई प्रतिनिधित्व गर्दछ। ट्रान्जिस्टरमा, "0" ले बिजुलीको प्रवाहलाई प्रतिनिधित्व गर्दछ, र "1" ले बिजुली प्रवाह गर्न अनुमति दिन्छ। यस तरिकाले, संख्याहरूलाई कम्प्युटिङ उपकरण भित्र भौतिक रूपमा प्रतिनिधित्व गरिन्छ, गणना गर्न अनुमति दिन्छ।

 
बाइनरी अझै पनि कम्प्युटरहरूको लागि प्राथमिक भाषा हो र निम्न कारणहरूको लागि इलेक्ट्रोनिक्स र कम्प्युटर हार्डवेयरसँग प्रयोग गरिन्छ:

- यो एक सरल र सुरुचिपूर्ण डिजाइन छ।
- बाइनरीको 0 र 1 विधिले विद्युतीय सिग्नल अफ (झूटो) वा अन (सत्य) अवस्था पत्ता लगाउन द्रुत छ।
- विद्युतीय संकेतमा दुईवटा मात्रै राज्यहरू टाढा राख्दा यसले विद्युतीय हस्तक्षेपको लागि कम संवेदनशील बनाउँछ।
- चुम्बकीय मिडियाको सकारात्मक र नकारात्मक ध्रुवहरू चाँडै बाइनरीमा अनुवाद गरिन्छ।
- बाइनरी तर्क सर्किट नियन्त्रण गर्न सबैभन्दा कुशल तरिका हो।

## [Central Processing Unit (CPU)](CPU/readme.md#central-processing-unitcpu)
केन्द्रीय प्रशोधन इकाई (CPU) कुनै पनि कम्प्युटरको सबैभन्दा महत्त्वपूर्ण भाग हो। CPU ले कम्प्यूटरका अन्य भागहरू नियन्त्रण गर्न सिग्नलहरू पठाउँछ, लगभग जस्तै मस्तिष्कले शरीरलाई कसरी नियन्त्रण गर्छ। CPU एउटा इलेक्ट्रोनिक मेसिन हो जसले कम्प्युटरमा गर्नुपर्ने कामहरूको सूचीमा काम गर्छ, जसलाई निर्देशन भनिन्छ। यसले निर्देशनहरूको सूची पढ्छ र प्रत्येकलाई क्रमबद्ध रूपमा चलाउँछ (कार्यान्वयन गर्दछ)। CPU ले चलाउन सक्ने निर्देशनहरूको सूची कम्प्युटर प्रोग्राम हो। CPU ले "कोर" भनिने खण्डहरूमा एक पटकमा एकभन्दा बढी निर्देशनहरू प्रशोधन गर्न सक्छ। चार कोर भएको CPU ले एकै पटक चारवटा प्रोग्रामहरू प्रशोधन गर्न सक्छ। CPU आफैंमा तीन मुख्य कम्पोनेन्टहरू बनेको छ। उनीहरु:
1. [मेमोरी वा भण्डारण इकाई](CPU/readme.md#memory-or-storage-unit)
2. [नियन्त्रण इकाई](CPU/readme.md#control-unit)
3. [अंकगणित र तर्क एकाइ (ALU)](CPU/readme.md#arithmetic-and-logic-unit-alu)


## [रेजिस्टरहरू, क्यास, र RAM](/Registers%20Cache%20and%20RAM)

### [रेजिस्टर](/Registers%20Cache%20and%20RAM/readme.md#register)
रेजिस्टरहरू CPU भित्र निहित उच्च-गति मेमोरीको सानो मात्रा हो। रेजिस्टरहरू "फ्लिप-फ्लपहरू" (१ बिट मेमोरी भण्डारण गर्न प्रयोग गरिने सर्किट) को संग्रह हो। तिनीहरू प्रोसेसर द्वारा प्रशोधन को समयमा आवश्यक डाटा को सानो मात्रा भण्डारण गर्न को लागी प्रयोग गरिन्छ। CPU मा "कोर" भनिने दर्ताका धेरै सेटहरू हुन सक्छन्। दर्ताले अंकगणित र तर्क सञ्चालनमा पनि मद्दत गर्दछ।

अंकगणितीय कार्यहरू CPU द्वारा दर्ताहरूमा भण्डारण गरिएको संख्यात्मक डेटामा गरिएको गणितीय गणनाहरू हुन्। यी कार्यहरूमा जोड, घटाउ, गुणन र भाग समावेश छन्। Logic अपरेसनहरू रेजिस्टरहरूमा भण्डारण गरिएका बाइनरी डेटामा CPU द्वारा प्रदर्शन गरिएका बुलियन गणनाहरू हुन्। यी अपरेसनहरूमा तुलनाहरू समावेश छन् (जस्तै दुई मान बराबर भएमा परीक्षण) र तार्किक अपरेशनहरू (जस्तै AND, OR, NOT)।

यी कार्यहरू गर्नका लागि दर्ताहरू आवश्यक हुन्छन् किनभने तिनीहरूले CPU लाई छिटो पहुँच गर्न र थोरै मात्रामा डेटा हेरफेर गर्न अनुमति दिन्छ। बारम्बार पहुँच गरिएका डाटालाई रेजिस्टरहरूमा भण्डारण गरेर, CPU ले मेमोरीबाट डाटा पुन: प्राप्त गर्ने ढिलो प्रक्रियाबाट बच्न सक्छ।

क्यासमा ठूलो मात्रामा डाटा भण्डारण गर्न सकिन्छ ("नगद" को रूपमा उच्चारण गरिन्छ), एक धेरै छिटो मेमोरी जुन दर्ताहरू जस्तै एकीकृत सर्किटमा अवस्थित हुन्छ। कार्यक्रम चल्दा बारम्बार पहुँच हुने डाटाका लागि क्यास प्रयोग गरिन्छ। RAM मा डाटा को ठूलो मात्रा पनि भण्डारण गर्न सकिन्छ। RAM भनेको अनियमित-पहुँच मेमोरी हो, जुन मेमोरीको एक प्रकार हो जसले डाटा र निर्देशनहरू राख्छ जुन प्रोसेसरलाई आवश्यक नभएसम्म डिस्क भण्डारणबाट सारिएको हुन्छ।


### [क्यास](/Registers%20Cache%20and%20RAM/readme.md#cache)
क्यास मेमोरी एक चिप-आधारित कम्प्युटर कम्पोनेन्ट हो जसले कम्प्युटरको मेमोरीबाट डेटा पुन: प्राप्तिलाई अझ प्रभावकारी बनाउँछ। यसले अस्थायी भण्डारण क्षेत्रको रूपमा कार्य गर्दछ त्यसैले कम्प्युटरको प्रोसेसरले सजिलैसँग डाटा पुन: प्राप्त गर्न सक्छ। यो अस्थायी भण्डारण क्षेत्र, क्यासको रूपमा चिनिन्छ, कम्प्युटरको मुख्य मेमोरी स्रोत, सामान्यतया DRAM को केही रूपहरू भन्दा प्रोसेसरमा अधिक सजिलैसँग उपलब्ध छ।

क्यास मेमोरीलाई कहिलेकाहीँ CPU (केन्द्रीय प्रशोधन इकाई) मेमोरी भनिन्छ किनभने यो सामान्यतया सीपीयू चिपमा सिधै एकीकृत हुन्छ वा CPU सँग छुट्टै बस इन्टरकनेक्ट भएको छुट्टै चिपमा राखिएको हुन्छ। त्यसकारण, यो प्रोसेसरको लागि अधिक पहुँचयोग्य छ र दक्षता बढाउन सक्षम छ किनभने यो भौतिक रूपमा प्रोसेसरको नजिक छ।

प्रोसेसरको नजिक हुनको लागि, क्यास मेमोरी मुख्य मेमोरी भन्दा धेरै सानो हुनुपर्छ। फलस्वरूप, यसमा कम भण्डारण ठाउँ छ। यो मुख्य मेमोरी भन्दा महँगो पनि छ, किनकि यो एक जटिल चिप हो जसले उच्च प्रदर्शन दिन्छ।

यसले आकार र मूल्यमा के बलिदान दिन्छ, यसले गतिको लागि बनाउँछ। क्यास मेमोरीले RAM भन्दा 10 देखि 100 गुणा छिटो काम गर्छ, CPU अनुरोधमा प्रतिक्रिया दिन केही नानोसेकेन्ड मात्र चाहिन्छ।

क्यास मेमोरीको लागि प्रयोग गरिने वास्तविक हार्डवेयरको नाम हाई-स्पीड स्ट्याटिक रेन्डम एक्सेस मेमोरी (SRAM) हो। कम्प्युटरको मुख्य मेमोरीमा प्रयोग हुने हार्डवेयरको नाम डायनामिक र्यान्डम-एक्सेस मेमोरी (DRAM) हो।

क्यास मेमोरी फराकिलो शब्द क्याससँग भ्रमित हुनु हुँदैन। क्यासहरू अस्थायी डेटा भण्डारहरू हुन् जुन हार्डवेयर र सफ्टवेयर दुवैमा अवस्थित हुन सक्छ। क्यास मेमोरीले विशेष हार्डवेयर कम्पोनेन्टलाई जनाउँछ जसले कम्प्युटरहरूलाई नेटवर्कको विभिन्न स्तरहरूमा क्यासहरू सिर्जना गर्न अनुमति दिन्छ। क्यास एक हार्डवेयर वा सफ्टवेयर हो जुन केहि भण्डारण गर्न प्रयोग गरिन्छ, सामान्यतया डाटा, अस्थायी रूपमा कम्प्युटिङ वातावरणमा।


### [RAM](/Registers%20Cache%20and%20RAM/readme.md#ram)
RAM (Random Access Memory) कम्प्युटर मेमोरीको एक रूप हो जुन कुनै पनि क्रममा पढ्न र परिवर्तन गर्न सकिन्छ, सामान्यतया काम गर्ने डाटा र मेसिन कोड भण्डारण गर्न प्रयोग गरिन्छ। अनियमित पहुँच मेमोरी उपकरणले डेटा वस्तुहरूलाई अनुमति दिन्छ
मेमोरी भित्रको डेटाको भौतिक स्थानको ख्याल नगरी लगभग एकै मात्रामा पढ्न वा लेख्न सकिन्छ, अन्य प्रत्यक्ष-पहुँच डाटा भण्डारण मिडिया (जस्तै हार्ड डिस्क, CD-RWS,
DVD-RWs र पुरानो चुम्बकीय टेपहरू र ड्रम मेमोरी), जहाँ डाटा वस्तुहरू पढ्न र लेख्न आवश्यक समय रेकर्डिङ माध्यममा तिनीहरूको भौतिक स्थानहरूमा निर्भर गर्दछ, मिडिया रोटेशन गति र हात चाल जस्ता मेकानिकल सीमितताहरूको कारण।


## [निर्देशन र कार्यक्रम](Not-Added)
कम्प्युटर विज्ञानमा, एक निर्देशन प्रोसेसरको एकल अपरेशन हो जुन प्रोसेसर निर्देशन सेट द्वारा परिभाषित हुन्छ। कम्प्युटर प्रोग्राम निर्देशनहरूको सूची हो जसले कम्प्युटरलाई के गर्ने भनेर बताउँछ। कम्प्युटरले गर्ने सबै काम कम्प्युटर प्रोग्राम प्रयोग गरेर पूरा हुन्छ। कम्प्युटरको मेमोरीमा भण्डारण गरिएका प्रोग्रामहरूले ("आन्तरिक प्रोग्रामिङ") कम्प्युटरलाई एकपछि अर्को काम गर्न दिन्छ, बीचमा ब्रेक भए पनि।

## [प्रोग्रामिङ भाषाहरू](/Programming_Languages/readme.md)
प्रोग्रामिङ भाषा भनेको कुनै पनि नियमहरूको सेट हो जसले स्ट्रिङहरू, वा भिजुअल प्रोग्रामिङ भाषाहरूको सन्दर्भमा ग्राफिकल प्रोग्राम तत्वहरूलाई विभिन्न प्रकारका मेसिन कोड आउटपुटमा रूपान्तरण गर्छ। प्रोग्रामिङ भाषाहरू एल्गोरिदमहरू लागू गर्न कम्प्युटर प्रोग्रामिङमा प्रयोग गरिने एक प्रकारको कम्प्युटर भाषा हो।

प्रोग्रामिङ भाषाहरू प्रायः दुई ठूला वर्गहरूमा विभाजित हुन्छन्:
1. उच्च-स्तरको भाषाले अंग्रेजी भाषा जस्तै वाक्य रचना प्रयोग गर्दछ। स्रोत कोडलाई कम्पाइलर वा दोभाषे प्रयोग गरेर मेसिनले बुझ्न सकिने मेसिन कोडमा रूपान्तरण गरिन्छ। जाभा र पाइथन उच्च-स्तरीय प्रोग्रामिङ भाषाहरूको केही उदाहरणहरू हुन्। यी सामान्यतया निम्न-स्तर भन्दा ढिलो हुन्छन्, तर यो सजिलो भएको साथ आउँछ।
2. कम-स्तर प्रोग्रामिङ भाषाहरूले हार्डवेयरसँग अझ नजिकबाट काम गर्छ र यसमा थप नियन्त्रण हुन्छ। तिनीहरू सीधा हार्डवेयरसँग अन्तरक्रिया गर्छन्। निम्न-स्तर भाषाहरूको दुई सामान्य उदाहरणहरू मेसिन भाषा र विधानसभा भाषा हुन्। यी सामान्यतया उच्च-स्तर भन्दा छिटो हुन्छन्, तर यो धेरै ठूलो कठिनाई र पढ्न योग्यताको कमीको लागतमा आउँछ।

### [Programming Paradigms](/Programming_Languages/readme.md#Programming+Paradigms)
त्यहाँ धेरै फरक * प्रोग्रामिंग प्रतिमानहरू * पनि छन्। प्रोग्रामिङ प्रतिमानहरू विभिन्न तरिकाहरू वा शैलीहरू हुन् जसमा दिइएको कार्यक्रम वा प्रोग्रामिङ भाषा व्यवस्थित गर्न सकिन्छ। प्रत्येक प्रतिमानमा निश्चित संरचनाहरू, सुविधाहरू, र सामान्य प्रोग्रामिङ समस्याहरू कसरी सम्बोधन गर्नुपर्छ भन्ने बारे रायहरू समावेश हुन्छन्।

प्रोग्रामिङ प्रतिमानहरू भाषाहरू वा उपकरणहरू होइन। तपाईं प्रतिमान संग केहि "निर्माण" गर्न सक्नुहुन्न। तिनीहरू धेरै आदर्शहरू र दिशानिर्देशहरूको सेट जस्तै छन् जुन धेरै मानिसहरू सहमत छन्, पछ्याउँछन्, र विस्तारित छन्। प्रोग्रामिङ भाषाहरू सधैं एक विशेष प्रतिमानमा बाँधिएका छैनन्। त्यहाँ *भाषाहरू* छन् जुन एक निश्चित प्रतिमानलाई ध्यानमा राखेर निर्माण गरिएका छन् र त्यस्ता प्रकारका प्रोग्रामिङलाई अरूभन्दा बढी सुविधा दिने सुविधाहरू छन् (हस्केल र कार्यात्मक प्रोग्रामिङ एउटा राम्रो उदाहरण हो)। तर त्यहाँ "बहु-प्याराडाइम" भाषाहरू पनि छन् जसमा तपाइँ तपाइँको कोडलाई निश्चित प्रतिमान वा अन्य (जाभास्क्रिप्ट र पाइथन राम्रो उदाहरणहरू हुन्) फिट गर्न अनुकूलन गर्न सक्नुहुन्छ।


## [डेटा प्रकारहरू](Data%20Types/readme.md#data-types)
डाटा प्रकार, प्रोग्रामिङमा, एक वर्गीकरण हो जसले निर्दिष्ट गर्दछ कि कुन प्रकारको मान चरमा छ र कुन प्रकारको गणितीय, सापेक्षिक, वा तार्किक अपरेसनहरू यसमा त्रुटि उत्पन्न नगरी लागू गर्न सकिन्छ।

### [Primitive Data Types](Data%20Types/readme.md#primitive-data-types)
Primitive डेटा प्रकारहरू प्रोग्रामिङ भाषामा सबैभन्दा आधारभूत डेटा प्रकारहरू हुन्। तिनीहरू अधिक जटिल डेटा प्रकारहरूको निर्माण ब्लकहरू हुन्। Primitive डेटा प्रकारहरू प्रोग्रामिङ भाषा द्वारा पूर्वनिर्धारित छन् र एक आरक्षित किवर्ड द्वारा नाम दिइएको छ।

### [सामान्य Primitive डाटा प्रकार](Data%20Types/readme.md#common-primitive-data-types)
- [पूर्णांक](Data%20Types/readme.md#integer)
- [फ्लोट](Data%20Types/readme.md#float)
- [बुलियन](Data%20Types/readme.md#boolean)
- [क्यारेक्टर](Data%20Types/readme.md#character)
- [स्ट्रिङ](Data%20Types/readme.md#string)

### [Non-Primitive डाटा प्रकार](Data%20Types/readme.md#non-primitive-data-types)
Non-Primitive डेटा प्रकारहरूलाई reference डेटा प्रकारहरू पनि भनिन्छ। तिनीहरू प्रोग्रामरद्वारा सिर्जना गरिएका हुन् र प्रोग्रामिङ भाषाद्वारा परिभाषित छैनन्। Non-Primitive डेटा प्रकारहरूलाई समग्र डेटा प्रकारहरू पनि भनिन्छ किनभने तिनीहरू अन्य प्रकारका हुन्छन्।

### [सामान्य Non-Primitive डाटा प्रकार](Data%20Types/readme.md#common-non-primitive-data-types)
- [Array](Data%20Types/readme.md#array)
- [Struct](Data%20Types/readme.md#struct)
- [Union](Data%20Types/readme.md#union)
- [Pointer](Data%20Types/readme.md#pointer)
- [Function](Data%20Types/readme.md#function)
- [Class](Data%20Types/readme.md#class)

## [कथन र कार्यहरू](Statements%20and%20Functions/readme.md)
कम्प्यूटर प्रोग्रामिङमा, कथन अनिवार्य प्रोग्रामिङ भाषाको सिन्ट्याक्टिक एकाइ हो जसले केही कार्यहरू गर्न व्यक्त गर्दछ। यस्तो भाषामा लेखिएको प्रोग्राम एक वा धेरै कथनहरूको अनुक्रमबाट बनाइन्छ। कथनमा आन्तरिक कम्पोनेन्टहरू हुन सक्छन् (जस्तै, अभिव्यक्ति)।
कुनै पनि प्रोग्रामिङ भाषामा दुई मुख्य प्रकारका कथनहरू हुन्छन् जुन कोडको तर्क निर्माण गर्न आवश्यक हुन्छ।

1. [सशर्त-कथनहरू (Conditional Statements)](Statements%20and%20Functions/readme.md#conditional-statements)

मुख्यतया दुई प्रकारका सशर्त कथनहरू छन्:
- यदि (if)
- यदि-अन्य (if-else)
- स्विच केस (switch case)


2. [लूप्स](Statements%20and%20Functions/readme.md#loops)

त्यहाँ मुख्य रूपमा तीन प्रकारका लूप्स छन्:
- for लूप
- while लूप
- do - while loop ( while loop को भिन्नता)
- do - Until लूप

------------

फंक्शन भनेको कथनहरूको ब्लक हो जसले विशेष कार्य गर्दछ। प्रकार्यहरूले डेटा स्वीकार गर्दछ, यसलाई प्रशोधन गर्दछ, र परिणाम फर्काउँछ वा कार्यान्वयन गर्दछ। प्रकार्यहरू मुख्य रूपमा पुन: प्रयोज्यताको अवधारणालाई समर्थन गर्न लेखिएका छन्। एकपटक फंक्शन लेखिसकेपछि, एउटै कोड दोहोर्याउन बिना सजिलै कल गर्न सकिन्छ।

विभिन्न कार्यात्मक भाषाहरूले प्रकार्यहरू लेख्नको लागि विभिन्न वाक्यविन्यासहरू प्रयोग गर्छन्।

फंक्शनहरूको बारेमा थप पढ्नुहोस् [यहाँ](Statements%20and%20Functions/readme.md#functions)

## [डेटा संरचनाहरू](Data%20Structures/readme.md)
कम्प्युटर विज्ञानमा, डाटा संरचना भनेको डाटा संगठन, व्यवस्थापन, र भण्डारण ढाँचा हो जसले कुशल पहुँच र परिमार्जन सक्षम गर्दछ। थप स्पष्ट रूपमा, डेटा संरचना डेटा मानहरूको संग्रह हो, तिनीहरू बीचको सम्बन्धहरू, र डेटामा लागू गर्न सकिने कार्यहरू वा अपरेशनहरू।

### डाटा संरचनाका प्रकारहरू
- [Array](Data%20Structures/readme.md#array)
- [Linked List](Data%20Structures/readme.md#linkedlist)
- [Stack](Data%20Structures/readme.md#stack)
- [Queue](Data%20Structures/readme.md#queue)
- [Hash Table](Data%20Structures/readme.md#hashtable)
- [Heap](Data%20Structures/readme.md#heap)
- [Tree](Data%20Structures/readme.md#tree)
- [Graph](Data%20Structures/readme.md#graph)

## [एल्गोरिदम](Algorithms/readme.md)
एल्गोरिदम गणना पूरा गर्न आवश्यक चरणहरूको सेट हो। तिनीहरू हाम्रा यन्त्रहरूले गर्ने कामको केन्द्रमा छन्, र यो कुनै नयाँ अवधारणा होइन। गणितको विकास भएदेखि, हामीलाई कार्यहरू अझ प्रभावकारी रूपमा पूरा गर्न मद्दत गर्न एल्गोरिदमहरू आवश्यक भएको छ, तर आज हामी क्रमबद्ध र ग्राफ खोज जस्ता केही आधुनिक कम्प्युटिङ समस्याहरू हेर्न जाँदैछौं र हामीले तिनीहरूलाई कसरी थप बनायौं भनेर देखाउने छौं। कुशल ताकि तपाईं सस्तो हवाई भाडा वा Winterfell वा एक रेस्टुरेन्ट वा केहि नक्सा दिशा निर्देशनहरू सजिलै पाउन सक्नुहुन्छ।

### [समय जटिलता](Algorithms/Time%20Complexity/readme.md)
एल्गोरिदमको समय जटिलताले (Time Complexity) अनुमान गर्दछ कि एल्गोरिदमले कति समय इनपुटको लागि प्रयोग गर्नेछ। विचार एक प्रकार्य को रूप मा दक्षता को प्रतिनिधित्व गर्नु हो जसको प्यारामिटर इनपुट आकार हो। समय जटिलता गणना गरेर, हामी एल्गोरिथ्म कार्यान्वयन बिना पर्याप्त छिटो छ कि भनेर निर्धारण गर्न सक्छौं।

### [स्पेस जटिलता](Algorithms/Space%20Complexity/readme.md)
स्पेस जटिलताले एल्गोरिथ्म/प्रोग्रामले प्रयोग गर्ने मेमोरी स्पेसको कुल मात्रालाई बुझाउँछ, कार्यान्वयनको लागि इनपुट मानहरूको स्पेस सहित। अन्तरिक्ष जटिलता निर्धारण गर्न एल्गोरिथ्म/कार्यक्रममा चरहरूले ओगटेको ठाउँको गणना गर्नुहोस्।

### [क्रमबद्ध](Algorithms/Sorting/readme.md)
क्रमबद्ध(Sorting) एक विशेष क्रममा वस्तुहरूको सूची व्यवस्थित गर्ने प्रक्रिया हो। उदाहरणका लागि, यदि तपाइँसँग नामहरूको सूची छ भने, तपाइँ तिनीहरूलाई वर्णमाला क्रमबद्ध गर्न चाहानुहुन्छ। वैकल्पिक रूपमा, यदि तपाइँसँग संख्याहरूको सूची छ भने, तपाइँ तिनीहरूलाई सानो देखि ठूलो सम्म क्रमबद्ध गर्न चाहानुहुन्छ। क्रमबद्ध गर्ने एउटा साझा कार्य हो, र यो हामीले विभिन्न तरिकामा गर्न सक्छौं।

### [खोज गर्दै (Searching)](Algorithms/Searching/readme.md)
खोज एक कन्टेनर भित्र एक निश्चित लक्ष्य तत्व फेला पार्न को लागी एक एल्गोरिथ्म हो। खोजी एल्गोरिदमहरू एक तत्वको लागि जाँच गर्न वा भण्डार गरिएको कुनै पनि डाटा संरचनाबाट एक तत्व पुन: प्राप्त गर्न डिजाइन गरिएको हो।

### [स्ट्रिङ आधारित एल्गोरिदम](Algorithms/String%20Based%20Algorithms/readme.md)
स्ट्रिङहरू प्रोग्रामिङमा सबैभन्दा धेरै प्रयोग गरिएको र सबैभन्दा महत्त्वपूर्ण डेटा संरचनाहरू मध्ये एक हो, यो भण्डारमा धेरै प्रयोग गरिएका एल्गोरिदमहरू समावेश छन् जसले हाम्रो कोड सुधार गर्न छिटो खोजी गर्न मद्दत गर्दछ।

### [ग्राफ खोज](Algorithms/Graph/readme.md)
ग्राफ खोज एक विशेष नोड फेला पार्न ग्राफ मार्फत खोजी गर्ने प्रक्रिया हो। ग्राफ भनेको डेटा संरचना हो जसमा परिमित (र सम्भवतः परिवर्तनीय) ठाडो वा नोडहरू वा बिन्दुहरूको सेट समावेश हुन्छ, सँगै अनिर्देशित ग्राफका लागि यी शीर्षहरूका अक्रमित जोडीहरूको सेट वा निर्देशित ग्राफको लागि अर्डर गरिएको जोडीहरूको सेट। यी जोडीहरूलाई अनिर्देशित ग्राफका लागि किनाराहरू, चापहरू, वा रेखाहरू, र तीरहरू, निर्देशित किनारहरू, निर्देशित आर्कहरू, वा निर्देशित ग्राफका लागि निर्देशित रेखाहरू भनेर चिनिन्छ। शीर्षहरू ग्राफ संरचनाको अंश हुन सक्छन् वा पूर्णांक सूचकांक वा सन्दर्भहरूद्वारा प्रतिनिधित्व गरिएका बाह्य निकायहरू हुन सक्छन्। ग्राफहरू धेरै वास्तविक-विश्व अनुप्रयोगहरूको लागि सबैभन्दा उपयोगी डेटा संरचनाहरू मध्ये एक हो। ग्राफहरू वस्तुहरू बीचको जोडी सम्बन्धलाई मोडेल गर्न प्रयोग गरिन्छ। उदाहरणका लागि, एयरलाइन रुट नेटवर्क एउटा ग्राफ हो जसमा सहरहरू ठाडो छन्, र उडान मार्गहरू किनारहरू हुन्। ग्राफहरू पनि नेटवर्कहरू प्रतिनिधित्व गर्न प्रयोग गरिन्छ। इन्टरनेटलाई ग्राफको रूपमा मोडेल गर्न सकिन्छ जसमा कम्प्यूटरहरू ठाडो हुन्छन्, र कम्प्युटरहरू बीचको लिङ्कहरू किनाराहरू हुन्। LinkedIn र Facebook जस्ता सामाजिक सञ्जालहरूमा पनि ग्राफहरू प्रयोग गरिन्छ। ग्राफहरू धेरै वास्तविक-विश्व अनुप्रयोगहरू प्रतिनिधित्व गर्न प्रयोग गरिन्छ: कम्प्युटर नेटवर्कहरू, सर्किट डिजाइन, र एयरोनटिकल समयतालिका केही नामहरू मात्र।



### [डायनामिक प्रोग्रामिङ](Algorithms/Dynamic%20Programming/README.md)
डायनामिक प्रोग्रामिङ दुवै गणितीय अनुकूलन विधि र कम्प्युटर प्रोग्रामिङ विधि हो। रिचर्ड बेलम्यानले सन् १९५० को दशकमा यस विधिको विकास गरेका थिए र एयरोस्पेस इन्जिनियरिङदेखि अर्थशास्त्रसम्मका धेरै क्षेत्रमा आवेदन फेला पारेका छन्। दुबै सन्दर्भहरूमा, यसले जटिल समस्यालाई पुनरावर्ती तरिकामा सरल उप-समस्याहरूमा विभाजन गरेर सरलीकरण गर्न बुझाउँछ। यद्यपि केही निर्णय समस्याहरू यस तरिकाबाट अलग गर्न सकिँदैन, निर्णयहरू जुन समयमा धेरै बिन्दुहरू फैलिन्छन् प्रायः पुनरावर्ती रूपमा अलग हुन्छन्। त्यसैगरी, कम्प्युटर विज्ञानमा, यदि कुनै समस्यालाई उप-समस्याहरूमा विभाजन गरेर राम्रोसँग समाधान गर्न सकिन्छ र त्यसपछि पुनरावर्ती रूपमा उप-समस्याहरूको इष्टतम समाधानहरू खोज्न सकिन्छ भने, यसलाई इष्टतम सबस्ट्रक्चर भनिन्छ। डायनामिक प्रोग्रामिंग यी गुणहरूसँग समस्याहरू समाधान गर्ने एक तरिका हो। जटिल समस्यालाई सरल उप-समस्याहरूमा विभाजन गर्ने प्रक्रियालाई "विभाजन र विजय" भनिन्छ।



### [लोभी एल्गोरिदम](Algorithms/Greedy%20Algorithm/readme.md)
लोभी (Greedy) एल्गोरिदमहरू एल्गोरिदमहरूको एक सरल, सहज वर्ग हो जुन केही अनुकूलन समस्याहरूको इष्टतम समाधान खोज्न प्रयोग गर्न सकिन्छ। तिनीहरूलाई लोभी भनिन्छ किनभने, प्रत्येक पाइलामा, तिनीहरूले त्यो क्षणमा सबैभन्दा राम्रो लाग्ने छनौट गर्छन्। यसको मतलब यो हो कि लोभी एल्गोरिदमहरूले विश्वव्यापी रूपमा इष्टतम समाधान फिर्ता गर्ने ग्यारेन्टी गर्दैन तर यसको सट्टा विश्वव्यापी इष्टतम फेला पार्ने आशामा स्थानीय रूपमा इष्टतम विकल्पहरू बनाउँदछ। लोभी एल्गोरिदमहरू अनुकूलन समस्याहरूको लागि प्रयोग गरिन्छ। यदि समस्यामा निम्न गुणहरू छन् भने ग्रीडी प्रयोग गरेर अनुकूलन समस्या समाधान गर्न सकिन्छ: प्रत्येक चरणमा, हामी यस क्षणमा राम्रो देखिने छनौट गर्न सक्छौं, र हामीले पूर्ण समस्याको इष्टतम समाधान पाउँछौं।


### [ब्याकट्र्याकिंग](Algorithms/Backtracking/README.md)
ब्याकट्र्याकिङ समस्याको समाधानलाई क्रमशः, एक पटकमा एक टुक्रा, कुनै पनि समयमा समस्याको अवरोधहरू पूरा गर्न असफल भएका समाधानहरू हटाउने प्रयास गरेर पुनरावर्ती रूपमा समस्याहरू समाधान गर्ने एल्गोरिदमिक प्रविधि हो (समयद्वारा, यहाँ, सन्दर्भ गरिएको छ। खोज रूख को कुनै पनि स्तर सम्म पुग्न समय बितेको छ)।


### [शाखा र बाउन्ड](Algorithms/Branch%20and%20Bound/README.md)
शाखा र बाउन्ड (Branch and Bound) संयोजन अनुकूलन समस्याहरू समाधान गर्नको लागि एक सामान्य प्रविधि हो। यो एक व्यवस्थित गणना प्रविधि हो जसले समस्याको संरचना प्रयोग गरेर उम्मेद्वार समाधानहरूको संख्या घटाउँछ जुन उम्मेद्वार समाधानहरू सम्भवतः इष्टतम हुन सक्दैन।


### [विभिन्न खोजी र क्रमबद्ध एल्गोरिदमहरूको समय जटिलता र ठाउँ जटिलता](Not-Added)
**समय जटिलता**: यो कुल समय भन्दा सट्टा कुनै विशेष निर्देशन सेट कार्यान्वयन हुने अपेक्षा गरिएको संख्याको रूपमा परिभाषित गरिएको छ। समय एक निर्भर घटना भएकोले, समय जटिलता केहि बाह्य कारकहरु जस्तै प्रोसेसर गति, प्रयोग गरिएको कम्पाइलर, आदि मा भिन्न हुन सक्छ।

**स्पेस जटिलता**: यो यसको कार्यान्वयनको लागि कार्यक्रमले खपत गरेको कुल मेमोरी स्पेस हो।

दुबै इनपुट साइज(n) को प्रकार्यको रूपमा गणना गरिन्छ। एल्गोरिदमको समय जटिलता ठूलो ओ नोटेशनमा व्यक्त गरिएको छ।

एल्गोरिथ्मको दक्षता यी दुई प्यारामिटरहरूमा निर्भर गर्दछ।

समय जटिलता को प्रकार:

- *उत्तम समय जटिलता*: इनपुट जसको लागि एल्गोरिदमले कम समय वा न्यूनतम समय लिन्छ। उत्तम अवस्थामा, हामी एल्गोरिथ्मको तल्लो सीमा समय जटिलता गणना गर्छौं। उदाहरण को लागी: यदि खोजी गर्न को लागी डाटा एक रैखिक खोज मा एक ठूलो डाटा एरे को पहिलो स्थान मा उपस्थित छ, तब सबै भन्दा राम्रो मामला हुन्छ।
- *औसत समय जटिलता*: हामी सबै अनियमित इनपुटहरू लिन्छौं र सबै इनपुटहरूको लागि गणना समय गणना गर्छौं। र त्यसपछि, हामी यसलाई कुल इनपुट संख्या द्वारा विभाजित गर्छौं।
- *सबैभन्दा खराब समय जटिलता*: इनपुट परिभाषित गर्नुहोस् जसको लागि एल्गोरिदमले लामो समय वा अधिकतम समय लिन्छ। सबैभन्दा खराब अवस्थामा, हामी एल्गोरिथ्मको माथिल्लो सीमा गणना गर्छौं। उदाहरण: यदि खोज्नुपर्ने डाटा रैखिक खोज एल्गोरिथ्ममा ठूलो डाटा एरेको अन्तिम स्थानमा अवस्थित छ भने, त्यसपछि सबैभन्दा खराब अवस्था हुन्छ।

केहि सामान्य समय जटिलताहरू हुन्:

- **O(1)**: यसले स्थिर समयलाई जनाउँछ। O(1) को सामान्यतया मतलब हो कि एल्गोरिदममा इनपुट साइजको पर्वाह नगरी स्थिर समय हुनेछ। ह्यास नक्सा स्थिर समय को सही उदाहरण हो।

- **O(log n)**: यसले लॉगरिदमिक समयलाई जनाउँछ। O(log n) को अर्थ सञ्चालनका लागि प्रत्येक उदाहरणको साथ घटाउनु हो। Binary Search Trees (BSTs) मा तत्वहरूको खोजी गर्नु लॉगरिदमिक समयको राम्रो उदाहरण हो।

- **O(n)**: यसले रेखीय समयलाई जनाउँछ। O(n) को अर्थ हो कि प्रदर्शन इनपुटको साइजसँग प्रत्यक्ष समानुपातिक छ। सरल शब्दहरूमा, इनपुटहरूको संख्या र ती इनपुटहरू कार्यान्वयन गर्न लाग्ने समय समानुपातिक हुनेछ। एरेहरूमा रैखिक खोज रैखिक समय जटिलताको उत्कृष्ट उदाहरण हो।

- **O(n*n)**: यसले द्विघात समयलाई जनाउँछ। O(n ^ 2) को अर्थ हो कि प्रदर्शन लिइएको इनपुटको वर्गसँग प्रत्यक्ष समानुपातिक छ। सरल रूपमा, कार्यान्वयनको लागि लाग्ने समयले इनपुट साइजको वर्ग गुणा लिनेछ। नेस्टेड लूपहरू द्विघातीय समय जटिलताका उत्तम उदाहरण हुन्।

- **O(n log n)**: यसले बहुपद समय जटिलतालाई जनाउँछ। O(n log n) को अर्थ O(log n) को भन्दा n पटक हो, (जुन सबैभन्दा खराब केस जटिलता हो)। एक राम्रो उदाहरण विभाजित हुनेछ र एल्गोरिदमहरू जित्नुहोस् जस्तै मर्ज क्रम। यो एल्गोरिथ्मले पहिले सेटलाई विभाजन गर्छ, जसले O(लग एन) समय लिन्छ, त्यसपछि सेटलाई जित्छ र क्रमबद्ध गर्दछ, जसले O(n) समय लिन्छ- त्यसैले, मर्ज क्रमले O(n लग n) समय लिन्छ।

| Algorithm	     |             |  Time Complexity|	       | Space Complexity |
|   :---:        |  :---:      |  :---: 	   |   :---: 	   |   :---:          |
|  	             | Best	       | Average	   |  Worst	     |  Worst           |
| Selection Sort | Ω(n^2)	     | θ(n^2)	     | O(n^2)	     | O(1)             |
| Bubble Sort	 | Ω(n)	         | θ(n^2)	     | O(n^2)	     | O(1)             |
| Insertion Sort | Ω(n)	       | θ(n^2)	     | O(n^2)	     | O(1)             |
| Heap Sort	     | Ω(n log(n)) | θ(n log(n)) | O(n log(n)) | O(1)             |
| Quick Sort	   | Ω(n log(n)) | θ(n log(n)) | O(n^2)	     | O(n)             |
| Merge Sort	   | Ω(n log(n)) | θ(n log(n)) | O(n log(n)) | O(n)             |
| Bucket Sort    | Ω(n +k)	   | θ(n +k)	   | O(n^2)	     | O(n)             |
| Radix Sort  	 | Ω(nk)	     | θ(nk)	     | O(nk)	     | O(n + k)         |
| Count Sort  	 | Ω(n +k)	   | θ(n +k)	   | O(n +k)	   | O(k)             |
| Shell Sort  	 | Ω(n log(n)) | θ(n log(n)) | O(n^2)	     | O(1)             |
| Tim Sort	     | Ω(n)	       | θ(n log(n)) | O(n log(n)) | O(n)             |
| Tree Sort   	 | Ω(n log(n)) | θ(n log(n)) | O(n^2)	     | O(n)             |
| Cube Sort	     | Ω(n)	       | θ(n log(n)) | O(n log(n)) | O(n)             |

| Algorithm	     |             |  Time Complexity|	     |
|   :---:        |  :---:      |  :---: 	 |   :---: 	   |  
|  	             | Best	       | Average	 |  Worst	     |
| Linear Search  | O(1)	       | O(N)	     | O(N)	       | O(1)  |
| Binary Search	 | O(1)	       | O(logN)   | O(logN)	   |



## [एलन ट्युरिङ](Not-Added)
एलन ट्युरिङ (जन्म जुन २३, १९१२, लन्डन, इन्जिनियर — मृत्यु ७ जुन १९५४, विल्मस्लो, चेशायर) एक अंग्रेजी गणितज्ञ र तर्कशास्त्री थिए। उनले क्याम्ब्रिज विश्वविद्यालय र प्रिन्सटन इन्स्टिच्युट फर एडभान्स्ड स्टडीमा अध्ययन गरे। आफ्नो सेमिनल 1936 पेपर "कम्प्युटेबल नम्बरहरूमा," उनले प्रमाणित गरे कि गणितमा सत्य निर्धारण गर्ने कुनै पनि विश्वव्यापी एल्गोरिदमिक विधि अवस्थित हुन सक्दैन र गणितले सधैं अनिर्णय (अज्ञातको विपरीत) प्रस्तावहरू समावेश गर्दछ। त्यो कागजले ट्युरिङ मेसिन पनि ल्यायो। उसले विश्वास गर्यो कि कम्प्यूटरहरू अन्ततः मानवको भन्दा अभेद्य सोच्न सक्षम हुनेछन् र यो क्षमताको मूल्याङ्कन गर्न एक साधारण परीक्षण (ट्युरिङ परीक्षण हेर्नुहोस्) प्रस्तावित गरे। यस विषयमा उनका लेखहरू आर्टिफिसियल इन्टेलिजेन्समा अनुसन्धानको जगको रूपमा व्यापक रूपमा स्वीकार गरिन्छ। उनले द्वितीय विश्वयुद्धको समयमा क्रिप्टोग्राफीमा बहुमूल्य काम गरे, रेडियो संचारको लागि जर्मनीले प्रयोग गरेको एनिग्मा कोड तोड्न महत्त्वपूर्ण भूमिका खेल्दै। युद्ध पछि, उनले म्यानचेस्टर विश्वविद्यालयमा पढाए र अहिले आर्टिफिसियल इन्टेलिजेन्स भनेर चिनिने काम गर्न थाले। यस ग्राउन्डब्रेकिङ कामको बीचमा, ट्युरिङ आफ्नो ओछ्यानमा मरेको अवस्थामा फेला पर्यो, सायनाइडले विषाक्त। उनको मृत्यु समलिङ्गी कार्य (तब अपराध) र 12 महिनाको हार्मोन थेरापीको सजायको लागि उनको गिरफ्तारी पछि भयो।


2009 मा सार्वजनिक अभियान पछि, बेलायती प्रधानमन्त्री गोर्डन ब्राउनले ट्युरिङसँग गरिएको डरलाग्दो व्यवहारको लागि ब्रिटिश सरकारको तर्फबाट आधिकारिक सार्वजनिक माफी मागे। रानी एलिजाबेथ द्वितीयले 2013 मा मरणोपरान्त क्षमा प्रदान गर्नुभयो। "एलन ट्युरिङ कानून" शब्द अब अनौपचारिक रूपमा युनाइटेड किंगडममा 2017 कानूनलाई जनाउन प्रयोग गरिन्छ जसले समलिङ्गी कार्यहरूलाई गैरकानूनी बनाउने ऐतिहासिक कानून अन्तर्गत सावधान वा दोषी ठहरिएका पुरुषहरूलाई पूर्वव्यापी रूपमा क्षमा दिन्छ।

ट्युरिङसँग उहाँका मूर्तिहरू र कम्प्युटर विज्ञान आविष्कारहरूका लागि वार्षिक पुरस्कार सहित उहाँको नाममा राखिएका धेरै चीजहरूको व्यापक विरासत छ। उहाँ हालको बैंक अफ इङ्गल्याण्ड £ 50 नोटमा देखा पर्नुहुन्छ, जुन जुन 23, 2021 मा जारी गरिएको थियो, उहाँको जन्मदिनको साथमा। २०१९ को बीबीसी शृङ्खला, दर्शकहरूले मतदान गरेअनुसार, उहाँलाई २०औँ शताब्दीको महान् व्यक्ति घोषित गरियो।


## [सफ्टवेयर इन्जिनियरिङ्](Software%20Engineering/readme.md)
सफ्टवेयर इन्जिनियरिङ् कम्प्युटर विज्ञानको शाखा हो जसले सफ्टवेयर अनुप्रयोगहरूको डिजाइन, विकास, परीक्षण, र मर्मत सम्भार गर्दछ। सफ्टवेयर इन्जिनियरहरूले अन्त प्रयोगकर्ताहरूको लागि सफ्टवेयर समाधानहरू निर्माण गर्न इन्जिनियरिङ सिद्धान्तहरू र प्रोग्रामिङ भाषाहरूको ज्ञान लागू गर्छन्।

सफ्टवेयर इन्जिनियरिङका विभिन्न परिभाषाहरू हेरौं:

- IEEE, यसको मानक 610.12-1990 मा, सफ्टवेयर इन्जिनियरिङ्लाई व्यवस्थित, अनुशासित, सफ्टवेयरको विकास, सञ्चालन, र मर्मतसम्भारको लागि गणनायोग्य दृष्टिकोणको रूपमा परिभाषित गर्दछ।
- फ्रिट्ज बाउरले यसलाई 'स्थापना र मानक इन्जिनियरिङ सिद्धान्तहरू प्रयोग गरेको रूपमा परिभाषित गरे। यसले तपाईंलाई आर्थिक सफ्टवेयर प्राप्त गर्न मद्दत गर्दछ जुन भरपर्दो छ र वास्तविक मेसिनहरूमा कुशलतापूर्वक काम गर्दछ।
- बोहेमले सफ्टवेयर इन्जिनियरिङलाई 'कम्प्यूटर प्रोग्रामहरूको रचनात्मक डिजाइन र निर्माणमा वैज्ञानिक ज्ञानको व्यावहारिक प्रयोग' समावेशको रूपमा परिभाषित गर्दछ। यसमा विकास, सञ्चालन र मर्मतसम्भारका लागि आवश्यक सम्बन्धित कागजातहरू पनि समावेश छन्।'

### सफ्टवेयर इन्जिनियरका कार्य र जिम्मेवारीहरू
सफल इन्जिनियरहरूले कम्प्युटर गेमहरूदेखि नेटवर्क नियन्त्रण प्रणालीहरूमा सबै कुरा विकास गर्न सही प्रोग्रामिङ भाषाहरू, प्लेटफर्महरू, र वास्तुकलाहरू कसरी प्रयोग गर्ने भनेर जान्दछन्। तिनीहरूको प्रणालीहरू निर्माण गर्नुको अतिरिक्त, सफ्टवेयर इन्जिनियरहरूले अन्य इन्जिनियरहरूले बनाएको सफ्टवेयरको परीक्षण, सुधार र मर्मत पनि गर्छन्।

यस भूमिकामा, तपाईंको दैनिक कार्यहरूमा निम्न समावेश हुन सक्छ:

- डिजाइन र सफ्टवेयर प्रणाली को रखरखाव
- नयाँ सफ्टवेयर प्रोग्रामहरूको मूल्याङ्कन र परीक्षण
- गति र स्केलेबिलिटीको लागि सफ्टवेयर अप्टिमाइज गर्दै
- लेखन र परीक्षण कोड
- ग्राहकहरु, इन्जिनियरहरु, सुरक्षा विशेषज्ञहरु, र अन्य सरोकारवालाहरु संग परामर्श
- सरोकारवालाहरू र आन्तरिक ग्राहकहरूलाई नयाँ सुविधाहरू प्रस्तुत गर्दै

### सफ्टवेयर इन्जिनियरिङका चरणहरू
सफ्टवेयर इन्जिनियरिङ् प्रक्रियामा आवश्यकताहरू जम्मा गर्ने, डिजाइन, कार्यान्वयन, परीक्षण, र मर्मतसम्भारलगायत धेरै चरणहरू समावेश हुन्छन्। सफ्टवेयर विकासको लागि अनुशासित दृष्टिकोण पछ्याएर, सफ्टवेयर इन्जिनियरहरूले उच्च-गुणस्तरको सफ्टवेयर सिर्जना गर्न सक्छन् जसले प्रयोगकर्ताहरूको आवश्यकताहरू पूरा गर्दछ।

- सफ्टवेयर ईन्जिनियरिङ् को पहिलो चरण आवश्यकताहरु को भेला छ। यस चरणमा, सफ्टवेयर इन्जिनियरले सफ्टवेयरको कार्यात्मक र गैर-कार्यात्मक आवश्यकताहरू निर्धारण गर्न ग्राहकसँग काम गर्दछ। कार्यात्मक आवश्यकताहरूले सफ्टवेयरले के गर्नुपर्छ भनेर वर्णन गर्दछ, जबकि गैर-कार्यात्मक आवश्यकताहरूले यसलाई कत्तिको राम्रोसँग गर्नुपर्छ भनेर वर्णन गर्दछ। आवश्यकताहरू जम्मा गर्नु एक महत्वपूर्ण चरण हो, किनकि यसले सम्पूर्ण सफ्टवेयर विकास प्रक्रियाको लागि जग राख्छ।

- आवश्यकताहरू जम्मा भएपछि, अर्को चरण डिजाइन हो। यस चरणमा, सफ्टवेयर इन्जिनियरले सफ्टवेयरको वास्तुकला र कार्यक्षमताको लागि विस्तृत योजना बनाउँछ। यो योजनामा सफ्टवेयर डिजाइन कागजात समावेश छ जसले सफ्टवेयरको संरचना, व्यवहार, र अन्य प्रणालीहरूसँग अन्तरक्रियाहरू निर्दिष्ट गर्दछ। सफ्टवेयर डिजाइन कागजात आवश्यक छ किनकि यसले कार्यान्वयन चरणको लागि खाकाको रूपमा काम गर्दछ।

- कार्यान्वयन चरण हो जहाँ सफ्टवेयर इन्जिनियरले सफ्टवेयरको लागि वास्तविक कोड सिर्जना गर्दछ। यो जहाँ डिजाइन कागजात काम सफ्टवेयर मा रूपान्तरण हुन्छ। कार्यान्वयन चरणमा कोड लेख्ने, यसलाई कम्पाइल गर्ने, र डिजाइन कागजातमा निर्दिष्ट आवश्यकताहरू पूरा गरेको सुनिश्चित गर्नको लागि परीक्षण समावेश गर्दछ।

- परीक्षण सफ्टवेयर इन्जिनियरिङ् मा एक महत्वपूर्ण चरण हो। यस चरणमा, सफ्टवेयर इन्जिनियरले सफ्टवेयरले सही रूपमा काम गर्छ, भरपर्दो छ र प्रयोग गर्न सजिलो छ भनी सुनिश्चित गर्न जाँच गर्दछ। यसमा एकाइ परीक्षण, एकीकरण परीक्षण, र प्रणाली परीक्षण सहित धेरै प्रकारका परीक्षणहरू समावेश छन्। परीक्षणले यो सुनिश्चित गर्दछ कि सफ्टवेयरले अपेक्षित आवश्यकताहरू र कार्यहरू पूरा गर्दछ।

- सफ्टवेयर इन्जिनियरिङको अन्तिम चरण मर्मतसम्भार हो। यस चरणमा, सफ्टवेयर इन्जिनियरले त्रुटिहरू सच्याउन, नयाँ सुविधाहरू थप्न, वा यसको कार्यसम्पादन सुधार गर्न सफ्टवेयरमा परिवर्तनहरू गर्दछ। मर्मतसम्भार एक निरन्तर प्रक्रिया हो जुन सफ्टवेयरको जीवनकालभर जारी रहन्छ।


### सफ्टवेयर इन्जिनियरिङ किन लोकप्रिय छ?

- कम्प्यूटर विज्ञान: सफ्टवेयरको लागि वैज्ञानिक आधार दिन्छ किनकि इलेक्ट्रिकल इन्जिनियरिङ मुख्यतया भौतिक विज्ञानमा निर्भर हुन्छ।
- व्यवस्थापन विज्ञान: सफ्टवेयर इन्जिनियरिङ् श्रम-गहन हो र प्राविधिक र व्यवस्थापकीय नियन्त्रणको माग गर्दछ। तसर्थ, यो व्यापक रूपमा व्यवस्थापन विज्ञान मा प्रयोग गरिन्छ।
- अर्थशास्त्र: यस क्षेत्रमा, सफ्टवेयर इन्जिनियरिङले तपाईंलाई स्रोतहरू अनुमान गर्न र लागतहरू नियन्त्रण गर्न मद्दत गर्दछ। एक कम्प्युटिङ प्रणाली विकास गर्नुपर्छ, र डाटा दिइएको बजेट भित्र नियमित रूपमा राखिएको हुनुपर्छ।
- प्रणाली ईन्जिनियरिङ्: धेरै सफ्टवेयर धेरै ठूलो प्रणाली को एक घटक हो। उदाहरण को लागी, एक उद्योग निगरानी प्रणाली मा सफ्टवेयर वा एक हवाई जहाज मा उडान सफ्टवेयर। यस प्रकारको प्रणालीको अध्ययनमा सफ्टवेयर इन्जिनियरिङ विधिहरू लागू गरिनुपर्छ।


## [एकीकृत सर्किट](Integrated%20Circuits/readme.md)
एक एकीकृत सर्किट वा मोनोलिथिक एकीकृत सर्किट (जसलाई आईसी, चिप, वा माइक्रोचिप पनि भनिन्छ) अर्धचालक सामग्रीको एउटा सानो समतल टुक्रा (वा "चिप") मा इलेक्ट्रोनिक सर्किटहरूको सेट हो, सामान्यतया सिलिकन। धेरै साना MOSFETs (मेटल-अक्साइड-सेमिकन्डक्टर फिल्ड-इफेक्ट ट्रान्जिस्टरहरू) सानो चिपमा एकीकृत हुन्छन्। यसले सर्किटहरूमा परिणाम दिन्छ जुन परिमाणको अर्डरहरू सानो, छिटो र कम महँगो अलग इलेक्ट्रोनिक कम्पोनेन्टहरूबाट निर्मित हुन्छन्। आईसीको ठूलो उत्पादन क्षमता, विश्वसनीयता, र एकीकृत सर्किट डिजाइनको लागि निर्माण-ब्लक दृष्टिकोणले अलग ट्रान्जिस्टरहरूको स्थानमा मानकीकृत आईसीहरूको द्रुत अवलम्बन सुनिश्चित गरेको छ। आईसीहरू अब लगभग सबै इलेक्ट्रोनिक उपकरणहरूमा प्रयोग गरिन्छ र इलेक्ट्रोनिक्सको संसारमा क्रान्ति ल्याएको छ। कम्प्युटर, मोबाइल फोन र अन्य घरेलु उपकरणहरू अब आधुनिक समाजको संरचनाको अविभाज्य भागहरू हुन्, जुन आधुनिक कम्प्युटर प्रोसेसरहरू र माइक्रोकन्ट्रोलरहरू जस्ता IC को सानो आकार र कम लागतले सम्भव भएको हो।

मेटल–अक्साइड–सिलिकन (MOS) अर्धचालक उपकरण निर्माणमा प्राविधिक प्रगतिहरूद्वारा धेरै-ठूलो-स्तरीय एकीकरणलाई व्यावहारिक बनाइएको थियो। 1960 को दशकमा तिनीहरूको उत्पत्ति भएदेखि, चिपहरूको आकार, गति, र क्षमतामा धेरै प्रगति भएको छ, प्राविधिक प्रगतिहरू द्वारा संचालित जुन उही साइजको चिपहरूमा अधिक र अधिक MOS ट्रान्जिस्टरहरू फिट हुन्छ - एक आधुनिक चिपमा धेरै अरबौं MOS ट्रान्जिस्टरहरू हुन सक्छन्। मानव नङ को आकार क्षेत्र। यी प्रगतिहरू, लगभग मूरको कानूनलाई पछ्याउँदै, आजका कम्प्युटर चिपहरू 1970 को दशकको शुरुवातको कम्प्युटर चिप्सको लाखौं गुणा क्षमता र हजारौं गुणाको गतिमा छन्।

ICs का अलग सर्किटहरूमा दुई मुख्य फाइदाहरू छन्: लागत र प्रदर्शन। लागत कम छ किनभने चिपहरू, तिनीहरूका सबै कम्पोनेन्टहरू सहित, फोटोलिथोग्राफीद्वारा एक पटकमा एउटै ट्रान्जिस्टर निर्माण गर्नुको सट्टा एकाइको रूपमा प्रिन्ट गरिन्छ। यसबाहेक, प्याकेज गरिएका आईसीहरूले अलग सर्किटहरू भन्दा धेरै कम सामग्री प्रयोग गर्छन्। प्रदर्शन उच्च छ किनभने IC का कम्पोनेन्टहरू चाँडै स्विच गर्छन् र तिनीहरूको सानो आकार र निकटताको कारण तुलनात्मक रूपमा थोरै शक्ति खपत गर्दछ। ICs को मुख्य बेफाइदा तिनीहरूलाई डिजाइन गर्न र आवश्यक photomasks निर्माण को उच्च लागत हो। यो उच्च प्रारम्भिक लागतको अर्थ IC हरू मात्र व्यावसायिक रूपमा व्यवहार्य हुन्छन् जब उच्च उत्पादन मात्राहरू प्रत्याशित हुन्छन्।

### प्रकारहरू
आधुनिक इलेक्ट्रोनिक कम्पोनेन्ट वितरकहरूले प्राय: थप उप-वर्गीकृत एकीकृत सर्किटहरू:

- डिजिटल आईसीहरूलाई तर्क ICs (जस्तै माइक्रोप्रोसेसरहरू र माइक्रोकन्ट्रोलरहरू), मेमोरी चिपहरू (जस्तै MOS मेमोरी र फ्लोटिंग-गेट मेमोरी), इन्टरफेस ICs (लेभल शिफ्टरहरू, सिरियलाइजर/डिसेरियलाइजर, इत्यादि), पावर व्यवस्थापन आईसीहरू, र प्रोग्रामयोग्य रूपमा वर्गीकृत गरिन्छ। उपकरणहरू।
- एनालग IC लाई रैखिक एकीकृत सर्किट र RF सर्किट (रेडियो फ्रिक्वेन्सी सर्किट) को रूपमा वर्गीकृत गरिएको छ।
- मिश्रित-सिग्नल एकीकृत सर्किटहरूलाई डेटा अधिग्रहण ICs (A/D कन्भर्टरहरू, D/A कन्भर्टरहरू, र डिजिटल पोटेन्टियोमिटरहरू), घडी/समय ICs, स्विच गरिएको क्यापेसिटर (SC) सर्किटहरू, र RF CMOS सर्किटहरूका रूपमा वर्गीकृत गरिएको छ।
- त्रि-आयामी एकीकृत सर्किटहरू (3D ICs) लाई सिलिकन मार्फत (TSV) ICs र Cu-Cu जडान ICs मा वर्गीकृत गरिएको छ।


## [वस्तु उन्मुख प्रोग्रामिङ](Object%20Oriented%20Programming/readme.md)
वस्तु उन्मुख प्रोग्रामिङ (Object Oriented Programming) एक आधारभूत प्रोग्रामिंग प्रतिमान हो जुन वस्तु र डेटा को अवधारणा मा आधारित छ।

यो कोडको मानक तरीका हो जुन प्रत्येक प्रोग्रामरले कोडको राम्रो पठनीयता र पुन: प्रयोज्यताको लागि पालन गर्नुपर्छ।

### * वस्तु उन्मुख प्रोग्रामिङका चार आधारभूत अवधारणाहरू छन्:
- Abstraction
- Encapsulation
- Inheritance
- Polymorphism 

OOP को यी अवधारणाहरू बारे थप पढ्नुहोस् [यहाँ](Object%20Oriented%20Programming/readme.md)

## [कार्यात्मक प्रोग्रामिङ](Functional%20Programming/readme.md)

कम्प्युटर विज्ञानमा, कार्यात्मक प्रोग्रामिङ एक प्रोग्रामिङ प्रतिमान हो जहाँ कार्यक्रमहरू कार्यहरू लागू र रचना गरेर निर्माण गरिन्छ। यो एक घोषणात्मक प्रोग्रामिंग प्रतिमान हो जसमा प्रकार्य परिभाषाहरू अभिव्यक्तिको रूखहरू हुन् जसले अन्य मानहरूमा मानहरू नक्सा गर्दछ, आवश्यक बयानहरूको अनुक्रमको सट्टा जसले कार्यक्रमको चलिरहेको अवस्था अपडेट गर्दछ।

कार्यात्मक प्रोग्रामिङमा, प्रकार्यहरूलाई प्रथम श्रेणीको नागरिकको रूपमा व्यवहार गरिन्छ, जसको अर्थ तिनीहरू नामहरूमा बाँध्न सकिन्छ (स्थानीय पहिचानकर्ताहरू सहित), तर्कको रूपमा पास गर्न सकिन्छ, र अन्य प्रकार्यहरूबाट फर्काइन्छ, जस्तै कुनै अन्य डेटा प्रकारले गर्न सक्छ। यसले प्रोग्रामहरूलाई घोषणात्मक र कम्पोजेबल शैलीमा लेख्न अनुमति दिन्छ, जहाँ साना प्रकार्यहरू मोड्युलर तरिकामा जोडिन्छन्।

फंक्शनल प्रोग्रामिङलाई कहिलेकाहीं विशुद्ध कार्यात्मक प्रोग्रामिङको पर्यायवाचीको रूपमा व्यवहार गरिन्छ, कार्यात्मक प्रोग्रामिङको एक उपसमूह जसले सबै प्रकार्यहरूलाई निर्धारणात्मक गणितीय प्रकार्यहरू, वा शुद्ध प्रकार्यहरूको रूपमा व्यवहार गर्दछ। जब एक शुद्ध प्रकार्य केहि दिइएको तर्क संग बोलाइन्छ, यो सधैं उही परिणाम फर्काउँछ, र कुनै पनि परिवर्तनीय अवस्था वा अन्य साइड इफेक्ट द्वारा प्रभावित हुन सक्दैन। यो अशुद्ध प्रक्रियाहरूसँग विपरित छ, अनिवार्य प्रोग्रामिङमा सामान्य, जसको साइड इफेक्ट हुन सक्छ (जस्तै कार्यक्रमको अवस्था परिमार्जन गर्ने वा प्रयोगकर्ताबाट इनपुट लिने)। विशुद्ध रूपमा कार्यात्मक प्रोग्रामिङका समर्थकहरूले दाबी गर्छन् कि साइड इफेक्टहरू प्रतिबन्ध गरेर, कार्यक्रमहरूमा कम बगहरू हुन सक्छन्, डिबग गर्न र परीक्षण गर्न सजिलो हुन सक्छ, र औपचारिक प्रमाणीकरण प्रक्रियाहरूमा बढी उपयुक्त हुन सक्छ।

कार्यात्मक प्रोग्रामिङको जरा एकेडेमियामा छ, ल्याम्ब्डा क्याल्कुलसबाट विकसित हुँदै, कार्यहरूमा आधारित गणनाको औपचारिक प्रणाली। कार्यात्मक प्रोग्रामिङ ऐतिहासिक रूपमा अनिवार्य प्रोग्रामिङ भन्दा कम लोकप्रिय भएको छ, तर धेरै कार्यात्मक भाषाहरू आज उद्योग र शिक्षामा प्रयोग भइरहेको छ।

कार्यात्मक प्रोग्रामिङ भाषाहरूको केही उदाहरणहरू :
- <a href="https://lisp-lang.org/"> Common Lisp </a>
- <a href="https://www.scheme.org/"> Scheme </a>
- <a href="https://racket-lang.org/"> Racket </a>
- <a href="https://www.erlang.org/"> Erlang </a>
- <a href="https://www.haskell.org/"> Haskell </a>
- <a href="https://fsharp.org/"> F# </a>
- <a href="https://cs.lmu.edu/~ray/notes/introml/"> ML </a>

कार्यात्मक प्रोग्रामिङ ऐतिहासिक रूपमा *lambda calculus* बाट लिइएको हो। Lambda क्याल्कुलस एक रूपरेखा हो जुन Alonzo चर्च द्वारा कार्य संग गणना अध्ययन गर्न को लागी विकसित गरिएको छ। यसलाई प्रायः "संसारको सबैभन्दा सानो प्रोग्रामिङ भाषा" भनिन्छ। यसले कम्प्युटेबल के हो र के होइन भन्ने परिभाषा दिन्छ। यो यसको कम्प्युटेसनल क्षमतामा ट्युरिङ मेसिनको बराबर छ र ल्याम्बडा क्याल्कुलसद्वारा कम्प्युट गर्न सकिने कुनै पनि कुरा, जसरी ट्युरिङ मेसिनले कम्प्युट गर्न मिल्ने कुनै पनि कुरा कम्प्युटेबल हुन्छ। यसले कार्यहरू र तिनीहरूको मूल्याङ्कनहरू वर्णन गर्नको लागि सैद्धान्तिक रूपरेखा प्रदान गर्दछ।

कार्यात्मक प्रोग्रामिङका केही आवश्यक अवधारणाहरू हुन्:
- शुद्ध कार्यहरू (Pure Functions)
- पुनरावृत्ति (Recursion)
- सन्दर्भ पारदर्शिता (Referential transparency)
- प्रथम श्रेणी र उच्च अर्डर कार्यहरूको रूपमा कार्यहरू (Functions as first class and higher order functions)
- चरहरू अपरिवर्तनीय छन्। V(ariables are immutable)

**शुद्ध कार्यहरू**: यी प्रकार्यहरूमा दुई मुख्य गुणहरू छन्। पहिलो, तिनीहरूले सधैं एउटै तर्कको लागि उही आउटपुट उत्पादन गर्दछ चाहे अरू केहि पनि। दोस्रो, तिनीहरूको कुनै साइड इफेक्ट छैन। अर्थात् तिनीहरूले कुनै पनि तर्क वा स्थानीय/ग्लोबल चर परिमार्जन गर्दैनन्
वा इनपुट/आउटपुट स्ट्रिमहरू। पछिल्लो गुणलाई *अपरिवर्तनीयता* भनिन्छ। शुद्ध प्रकार्यको मात्र परिणाम भनेको यसले फर्काउने मान हो। तिनीहरू निश्चयवादी छन्। कार्यात्मक प्रोग्रामिङ प्रयोग गरी गरिएका कार्यक्रमहरू डिबग गर्न सजिलो छ किनभने तिनीहरूसँग कुनै साइड इफेक्ट वा लुकेको I/O छैन। शुद्ध प्रकार्यहरूले समानान्तर/समवर्ती अनुप्रयोगहरू लेख्न सजिलो बनाउँदछ। जब कोड यस शैलीमा लेखिन्छ, एक स्मार्ट कम्पाइलरले धेरै चीजहरू गर्न सक्छ- यसले निर्देशनहरूलाई समानान्तर गर्न सक्छ, आवश्यक नभएसम्म परिणामहरूको मूल्याङ्कन गर्न पर्खन सक्छ र नतिजाहरू याद गर्नुहोस् किनभने परिणामहरू कहिल्यै परिवर्तन हुँदैन जबसम्म इनपुट परिवर्तन हुँदैन। यहाँ पाइथन मा शुद्ध प्रकार्य को एक सरल उदाहरण छ:

```python
def sum(x ,y): # sum is a function taking x and y as arguments
    return x + y  # returns x + y without changing the value
 ```

 **पुनरावृत्ति**: शुद्ध कार्यात्मक प्रोग्रामिङ भाषाहरूमा "for" वा "while" लूपहरू छैनन्। पुनरावृत्ति पुनरावृत्ति मार्फत लागू गरिएको छ। पुनरावर्ती प्रकार्यहरूले आधार केस नपुगेसम्म बारम्बार आफैलाई कल गर्दछ। यहाँ पुनरावृत्ति को एक सरल उदाहरण हो
C मा कार्य:

```c
int fib(n) {
  if(n <= 1)
    return 1;
   else
     return (fib(n-1) + fib(n-2));
}
 ```
 **सन्दर्भात्मक पारदर्शिता**: कार्यात्मक कार्यक्रमहरूमा, एक पटक परिभाषित भ्यारीएबलहरूले कार्यक्रम भरि तिनीहरूको मान परिवर्तन गर्दैन।
कार्यात्मक कार्यक्रमहरूमा असाइनमेन्ट कथनहरू छैनन्। यदि हामीले केहि मान भण्डार गर्नुपर्दछ भने, हामी यसको सट्टामा नयाँ चर परिभाषित गर्दछौं। यसले साइड इफेक्टको कुनै पनि सम्भावनालाई हटाउँछ किनभने कुनै पनि चर कार्यान्वयनको कुनै पनि बिन्दुमा यसको वास्तविक मानसँग प्रतिस्थापन गर्न सकिन्छ। कुनै पनि चरको अवस्था कुनै पनि क्षणमा स्थिर हुन्छ। उदाहरण:
 
```bash
x = x + 1 # this changed the value assigned to the variable x
         # Therefore, the expression is NOT referentially transparent
```

** प्रथम श्रेणी र उच्च अर्डर कार्यहरूको रूपमा कार्यहरू **: प्रथम श्रेणीका प्रकार्यहरूलाई प्रथम श्रेणी चरको रूपमा व्यवहार गरिन्छ। प्रथम श्रेणी चरहरूलाई प्यारामिटरहरूको रूपमा प्रकार्यहरूमा पास गर्न सकिन्छ, प्रकार्यहरूबाट फर्काउन सकिन्छ वा डेटा संरचनाहरूमा भण्डारण गर्न सकिन्छ।
         
प्रकार्य अनुप्रयोगहरूको संयोजनलाई LISP फारम प्रयोग गरेर परिभाषित गर्न सकिन्छ जसलाई **funcall** भनिन्छ, जसले तर्कको रूपमा कार्य र तर्कहरूको श्रृंखला लिन्छ र ती कार्यहरूलाई ती तर्कहरूमा लागू गर्दछ:

```Lisp
(defun filter (list-of-elements test)
    (cond ((null list-of-elements) nil)
          ((funcall test (car list-of-elements))
            (cons (car list-of-elements)
                (filter (cdr list-of-elements)
                      test)))
           (t (filter (cdr list-of-elements)
                       test))))
   ```

   Function **फिल्टर** ले सूचीको पहिलो तत्वमा परीक्षण लागू गर्दछ। यदि परीक्षणले शून्यमा फर्काउँछ भने, यसले सूचीको सीडीआरमा लागू गरिएको फिल्टरको नतिजामा तत्वलाई समावेश गर्दछ; अन्यथा, यसले फिल्टर गरिएको cdr मात्र फर्काउँछ। यो प्रकार्य विभिन्न प्रकारका फिल्टरिङ कार्यहरू गर्न प्यारामिटरहरूको रूपमा पारित विभिन्न भविष्यवाणीहरूसँग प्रयोग गर्न सकिन्छ:

```Lisp
    > (filter '(1 3 -9 5 -2 -7 6) #'plusp)   ; filter out all negative numbers 
```    
    output: (1 3 5 6)

```Lisp
   > (filter '(1 2 3 4 5 6 7 8 9) #'evenp)   ; filter out all odd numbers
```   
   output: (2 4 6 8)

   and so on.

**चरहरू अपरिवर्तनीय छन्**: कार्यात्मक प्रोग्रामिङमा, हामी यसलाई प्रारम्भ गरिसकेपछि परिमार्जन गर्न सक्दैनौं।
हामी नयाँ चरहरू सिर्जना गर्न सक्छौं- तर हामी अवस्थित भ्यारीएबलहरू परिमार्जन गर्न सक्दैनौं, र यसले कार्यक्रमको रनटाइम भरि राज्यलाई कायम राख्न मद्दत गर्दछ। एकचोटि हामीले एउटा चर सिर्जना गरी यसको मान सेट गरेपछि, त्यो चरको मान कहिल्यै परिवर्तन हुँदैन भन्ने कुरामा हामी पूर्ण विश्वस्त हुन सक्छौं।    

### [अपरेटिङ सिस्टम्स](Operating%20Systems/readme.md)
अपरेटिङ सिस्टम (वा छोटकरीमा OS) ले कम्प्युटर प्रयोगकर्ता र कम्प्युटर हार्डवेयर बीच मध्यस्थको रूपमा काम गर्छ। एक अपरेटिङ सिस्टम को उद्देश्य एक वातावरण प्रदान गर्न को लागी एक प्रयोगकर्ता सुविधाजनक र कुशलतापूर्वक कार्यक्रम कार्यान्वयन गर्न सक्छ।
अपरेटिङ सिस्टम भनेको कम्प्युटर हार्डवेयर व्यवस्थापन गर्ने सफ्टवेयर हो। हार्डवेयरले कम्प्युटर प्रणालीको सही सञ्चालन सुनिश्चित गर्न र प्रयोगकर्ता कार्यक्रमहरूलाई प्रणालीको उचित सञ्चालनमा हस्तक्षेप गर्नबाट रोक्नको लागि उपयुक्त संयन्त्रहरू प्रदान गर्नुपर्छ।
अझ सामान्य परिभाषा यो हो कि अपरेटिङ सिस्टम भनेको कम्प्युटरमा सधैं चल्ने एउटा प्रोग्राम हो (सामान्यतया कर्नेल भनिन्छ), अन्य सबै एप्लिकेसन प्रोग्रामहरू सहित।

अपरेटिङ सिस्टमहरू दुई दृष्टिकोणबाट हेर्न सकिन्छ: स्रोत प्रबन्धकहरू र
विस्तारित मेसिनहरू। स्रोत-प्रबन्धक दृश्यमा, अपरेटिङ सिस्टमको काम हो
प्रणालीका विभिन्न भागहरूलाई कुशलतापूर्वक व्यवस्थापन गर्नुहोस्। विस्तारित मेसिन दृश्यमा,
प्रणालीको काम भनेको प्रयोगकर्ताहरूलाई अमूर्तताहरू प्रदान गर्नु हो जुन अधिक कन्-
वास्तविक मेसिन भन्दा प्रयोग गर्न सुविधाजनक। यसमा प्रक्रियाहरू, ठेगाना स्पेसहरू,
र फाइलहरू।
अपरेटिङ सिस्टमहरूको लामो इतिहास छ, जबदेखि तिनीहरूले अपरेटरलाई आधुनिक मल्टिप्रोग्रामिङ प्रणालीहरूमा बदले।
हाइलाइटहरूमा प्रारम्भिक ब्याच प्रणालीहरू, बहुप्रोग्रामिङ प्रणालीहरू, र व्यक्तिगत कम्प्युटर प्रणालीहरू समावेश छन्।
अपरेटिङ सिस्टमहरूले हार्डवेयरसँग नजिकबाट अन्तरक्रिया गरेको हुनाले, केही ज्ञान
कम्प्युटर हार्डवेयर तिनीहरूलाई बुझ्न उपयोगी छ। कम्प्युटरहरू बनाइएका छन्
प्रोसेसर, मेमोरी, र I/O यन्त्रहरू। यी भागहरू बसहरूद्वारा जोडिएका छन्।
आधारभूत अवधारणाहरू जसमा सबै अपरेटिङ सिस्टमहरू बनाइएका छन् प्रक्रियाहरू,
मेमोरी व्यवस्थापन, I/O व्यवस्थापन, फाइल प्रणाली, र सुरक्षा। कुनै पनि अपरेटिङ सिस्टमको मुटु भनेको सिस्टम कलहरूको सेट हो जुन यसले ह्यान्डल गर्न सक्छ।
यसले अपरेटिङ सिस्टमले के गर्छ भनेर बताउँछ।

### संसाधन प्रबन्धकको रूपमा अपरेटिङ सिस्टम
अपरेटिङ सिस्टमले जटिल प्रणालीका सबै टुक्राहरू व्यवस्थापन गर्छ। आधुनिक कम्प्युटरमा प्रोसेसर, मेमोरी, टाइमर, डिस्क, मुसा,
नेटवर्क इन्टरफेसहरू, प्रिन्टरहरू, र अन्य उपकरणहरूको एक विस्तृत विविधता।
तल्लो-माथिको दृश्यमा, अपरेटिङ सिस्टमको काम भनेको व्यवस्थित र नियन्त्रित विनियोजनको लागि प्रदान गर्नु हो।
प्रोसेसरहरू, मेमोरीहरू, र I/O यन्त्रहरू विभिन्न कार्यक्रमहरूमा उनीहरूलाई चाहिन्छ।
आधुनिक अपरेटिङ सिस्टमहरूले धेरै प्रोग्रामहरूलाई मेमोरीमा हुन र चलाउन अनुमति दिन्छ
एकै साथ। केहीमा तीनवटा कार्यक्रमहरू चल्दा के हुन्छ कल्पना गर्नुहोस्
कम्प्युटर सबैले एउटै प्रिन्टरमा एकै साथ आफ्नो आउटपुट प्रिन्ट गर्ने प्रयास गरे।
परिणाम पूर्ण अराजकता हुनेछ। अपरेटिङ सिस्टमले सम्भावित अराजकतामा क्रम ल्याउन सक्छ
डिस्कमा प्रिन्टरको लागि निर्धारित सबै आउटपुट बफर गरेर।
जब एक कार्यक्रम समाप्त हुन्छ, अपरेटिङ सिस्टम सक्छ
त्यसपछि डिस्क फाइलबाट यसको आउटपुट प्रतिलिपि गर्नुहोस् जहाँ यो प्रिन्टरको लागि भण्डारण गरिएको छ,
जबकि एकै समयमा, अन्य कार्यक्रमले थप आउटपुट उत्पन्न गर्न जारी राख्न सक्छ,
आउटपुट प्रिन्टरमा गइरहेको छैन भन्ने तथ्यबाट बेवास्ता (अझैसम्म)।
जब एक कम्प्युटर (वा नेटवर्क) एक भन्दा बढी प्रयोगकर्ता छ, व्यवस्थापन गर्न आवश्यक छ
र मेमोरी, I/O यन्त्रहरू, र अन्य स्रोतहरू अझ बढी सुरक्षित गर्नुहोस्
प्रयोगकर्ताहरूले अन्यथा एकअर्कासँग हस्तक्षेप गर्न सक्छन्। थप रूपमा, प्रयोगकर्ताहरूलाई प्राय: आवश्यक पर्दछ
हार्डवेयर मात्र होइन जानकारी (फाइल, डाटाबेस, आदि) पनि साझा गर्नुहोस्। छोटकरीमा,
अपरेटिङ सिस्टमको यो दृष्टिकोणले यसको प्राथमिक कार्य ट्र्याक राख्नु हो भन्ने मान्यता राख्छ
कुन कार्यक्रमले कुन स्रोत प्रयोग गरिरहेको छ, स्रोत अनुरोधहरू प्रदान गर्न, खातामा
प्रयोगका लागि र विभिन्न कार्यक्रमहरू र प्रयोगकर्ताहरूबाट विवादित अनुरोधहरू मध्यस्थता गर्न।

### विस्तारित मेसिनको रूपमा अपरेटिङ सिस्टम
मेसिन-भाषा स्तरमा अधिकांश कम्प्युटरहरूको वास्तुकला आदिम र अप्ठ्यारो छ।
कार्यक्रम, विशेष गरी इनपुट/आउटपुटको लागि। यो बिन्दु थप ठोस बनाउन, विचार गर्नुहोस्
आधुनिक SATA (Serial ATA) हार्ड डिस्क धेरै जसो कम्प्युटरहरूमा प्रयोग गरिन्छ। एक प्रोग्रामरले डिस्क प्रयोग गर्न के थाहा पाउनुपर्छ।
त्यसबेलादेखि, इन्टरफेस धेरै पटक परिमार्जन गरिएको छ र यो भन्दा बढी जटिल छ
2007. कुनै पनि समझदार प्रोग्रामरले हार्डवेयर स्तरमा यो डिस्कसँग सम्झौता गर्न चाहँदैन।
यसको सट्टा, डिस्क ड्राइभर भनिने सफ्टवेयरको टुक्राले हार्डवेयरसँग सम्झौता गर्दछ र डिस्क ब्लकहरू पढ्न र लेख्नको लागि इन्टरफेस प्रदान गर्दछ,
विवरणमा प्रवेश नगरी।
अपरेटिङ सिस्टमहरूले I/O यन्त्रहरू नियन्त्रण गर्न धेरै ड्राइभरहरू समावेश गर्दछ।
तर पनि यो स्तर धेरै अनुप्रयोगहरूको लागि धेरै कम छ। यस कारणले, सबै
अपरेटिङ सिस्टमहरूले डिस्कहरू: फाइलहरू प्रयोग गर्नका लागि अमूर्तताको अर्को तह प्रदान गर्दछ।
यो अमूर्तता प्रयोग गरेर, प्रोग्रामहरूले हार्डवेयरले कसरी काम गर्छ भन्ने गडबड विवरणहरूसँग व्यवहार नगरी फाइलहरू सिर्जना गर्न, लेख्न र पढ्न सक्छ।
यो अमूर्तता यो सबै जटिलता व्यवस्थापन गर्न कुञ्जी हो। राम्रो abstractions
लगभग असम्भव कार्यलाई दुई प्रबन्धनीय कार्यहरूमा परिणत गर्नुहोस्। पहिलो परिभाषित र
अमूर्तहरू लागू गर्दै। दोस्रो problem समाधान गर्न यी abstractions प्रयोग गर्दैछ।

### अपरेटिङ सिस्टम को इतिहास
- **पहिलो पुस्ता (१९४५-५५)**: दोस्रो विश्वयुद्धको युगसम्म ब्याबेजको विनाशकारी प्रयासपछि डिजिटल कम्प्युटर निर्माणमा थोरै प्रगति हासिल भएको थियो। आयोवा स्टेट युनिभर्सिटीमा, प्रोफेसर जोन एटानासोफ र उनको स्नातक विद्यार्थी क्लिफर्ड बेरीले आज पहिलो परिचालन डिजिटल कम्प्युटरको रूपमा चिनिएको सिर्जना गरे। बर्लिनमा कोनराड जुसले एकै समयमा इलेक्ट्रोमेकानिकल रिले प्रयोग गरेर Z3 कम्प्युटर निर्माण गरे। मार्क I हार्वर्डमा हावर्ड एकेनले, इङ्गल्याण्डको ब्लेचले पार्कका वैज्ञानिकहरूको टोलीद्वारा कोलोसस र विलियम माउचले र उनका डक्टरल विद्यार्थी जे. प्रेसर एकर्टले 1944 मा पेन्सिलभेनिया विश्वविद्यालयमा ENIAC द्वारा सिर्जना गरेका थिए।

- **सेकेन्ड जेनेरेसन (१९५५-६५)**: सन् १९५० को मध्यमा ट्रान्जिस्टरको आविष्कारले स्थितिमा ठूलो परिवर्तन ल्यायो। कम्प्यूटरहरू पर्याप्त भरोसेमंद भए कि तिनीहरू निर्माण गर्न र भुक्तानी गर्ने ग्राहकहरूलाई केही अर्थपूर्ण काम सञ्चालन गर्न लामो समयसम्म काम गरिरहने धारणाको साथ बेच्न सकिन्छ। मेनफ्रेमहरू, जसरी यी मेसिनहरू अहिले चिनिन्छन्, तिनीहरूलाई व्यवस्थित गर्न योग्य अपरेटरहरूको टोलीसहित विशाल, विशेष गरी वातानुकूलित कम्प्युटर कोठाहरूमा बन्द गरिएको थियो। केवल ठूला व्यवसायहरू, महत्त्वपूर्ण सरकारी संस्थाहरू, वा संस्थाहरूले धेरै मिलियन डलरको मूल्य ट्याग वहन गर्न सक्छन्।

- **तेस्रो पुस्ता (१९६५-८०)**: व्यक्तिगत ट्रान्जिस्टरबाट बनाइएका दोस्रो पुस्ताका कम्प्युटरहरूको तुलनामा, IBM 360 पहिलो प्रमुख कम्प्युटर लाइन (सानो स्केल) ICs (Integrated Circuits) प्रयोग गर्ने थियो। नतिजाको रूपमा, यसले महत्त्वपूर्ण मूल्य/प्रदर्शन लाभ प्रदान गर्‍यो। यो तत्काल हिट थियो, र अन्य सबै ठूला निर्माताहरूले तुरुन्तै अन्तरक्रियायोग्य कम्प्युटरहरूको परिवारको अवधारणालाई अँगाले। OS/360 अपरेटिङ सिस्टम सहित सबै सफ्टवेयरहरू, मूल डिजाइनमा सबै मोडेलहरूसँग मिल्दो हुनुपर्छ। यसले ठूला प्रणालीहरूमा चल्नुपर्‍यो, जसले बारम्बार भारी गणना र मौसम पूर्वानुमानको लागि 7094s प्रतिस्थापन गर्‍यो, र स-साना प्रणालीहरू, जसले प्राय: टेपमा कार्डहरू स्थानान्तरण गर्नको लागि 1401s प्रतिस्थापन गर्यो। दुबै प्रणालीहरू थोरै परिधीयहरू र धेरै बाह्य उपकरणहरू भएका प्रणालीहरू यससँग राम्रोसँग काम गर्न आवश्यक छ। यसले व्यावसायिक र अकादमिक दुवै सेटिङहरूमा काम गर्नुपर्‍यो। सबै भन्दा माथि, यो यी धेरै अनुप्रयोगहरू मध्ये प्रत्येकको लागि प्रभावकारी हुनुपर्दछ।

- **चौथो पुस्ता (१९८०-वर्तमान)**: व्यक्तिगत कम्प्युटर युग LSI (ठूलो स्केल एकीकरण) सर्किटहरू, सिलिकनको वर्ग सेन्टिमिटरमा हजारौं ट्रान्जिस्टरहरू भएका प्रोसेसरहरूको सिर्जनाबाट सुरु भयो। यद्यपि व्यक्तिगत कम्प्युटरहरू, मूल रूपमा माइक्रो कम्प्युटरहरू भनेर चिनिने, PDP-11 वर्गका मिनी कम्प्युटरहरूबाट वास्तुकलामा उल्लेखनीय परिवर्तन भएन, तिनीहरूको मूल्यमा उल्लेखनीय भिन्नता थियो।

- **पाँचौं पुस्ता (१९९०-वर्तमान)**: १९४० को दशकको कमिक स्ट्रिपमा जासूस डिक ट्रेसीले आफ्नो "टू-वे रेडियो रिस्टवाच" सँग कुराकानी गर्न थालेदेखि नै मानिसहरू पोर्टेबल सञ्चार ग्याजेटको लागि उत्सुक छन्। 1946 मा, एक वास्तविक मोबाइल फोनले आफ्नो डेब्यू गर्यो, र यसको वजन लगभग 40 किलोग्राम थियो। पहिलो वास्तविक पोर्टेबल फोन 1970 मा डेब्यू भयो र लगभग एक किलोग्राम मा अविश्वसनीय रूपमा हल्का थियो। यसलाई मजाकमा "इँटा" भनिएको थियो। चाँडै, सबैले एक को लागी हल्लिरहेका थिए।

### OS को कार्यहरू
- **सुविधा**: OS ले कम्प्युटरलाई प्रयोग गर्न अझ सुविधाजनक बनाउँछ।
- **दक्षता**: एक OS ले कम्प्युटर प्रणाली स्रोतहरूलाई प्रभावकारी रूपमा प्रयोग गर्न अनुमति दिन्छ।
- **विकास गर्ने क्षमता**: सेवामा हस्तक्षेप नगरी एकै समयमा प्रभावकारी विकास, परीक्षण, र नयाँ प्रणाली प्रकार्यहरूको परिचयलाई अनुमति दिने गरी OS निर्माण गरिनु पर्छ।
- **थ्रुपुट**: एउटा OS निर्माण गरिनु पर्छ ताकि यसले अधिकतम थ्रुपुट दिन सक्छ (प्रति एकाइ समय कार्यहरूको संख्या)।

### एक OS को प्रमुख कार्यक्षमताहरू
- **संसाधन व्यवस्थापन**: जब समानान्तर पहुँच OS मा हुन्छ, यसको मतलब धेरै प्रयोगकर्ताहरूले प्रणाली पहुँच गरिरहेको बेला, OS ले संसाधन प्रबन्धकको रूपमा काम गर्दछ। यसको जिम्मेवारी प्रयोगकर्तालाई हार्डवेयर उपलब्ध गराउनु हो। यसले प्रणालीमा लोड घटाउँछ।
- **प्रक्रिया व्यवस्थापन**: यसले विभिन्न कार्यहरू समावेश गर्दछ जस्तै समयतालिका र प्रक्रियाको समाप्ति। OS ले एकै समयमा विभिन्न कार्यहरू व्यवस्थापन गर्दछ। यहाँ CPU शेड्युलिंग हुन्छ भनेको सबै कार्यहरू धेरै एल्गोरिदमहरू द्वारा गरिन्छ जुन समय तालिकाको लागि प्रयोग गरिन्छ।
- **भण्डारण व्यवस्थापन**: भण्डारण व्यवस्थापनको लागि प्रयोग गरिएको फाइल प्रणाली संयन्त्र। NIFS, CFS, CIFS, NFS, आदि केही फाइल प्रणालीहरू हुन्। सबै डाटा हार्ड डिस्कका विभिन्न ट्र्याकहरूमा भण्डारण गरिन्छ जुन सबै भण्डारण प्रबन्धकद्वारा व्यवस्थित गरिन्छ। यसमा हार्ड डिस्क समावेश थियो।
- **मेमोरी व्यवस्थापन**: प्राथमिक मेमोरीको व्यवस्थापनलाई बुझाउँछ। अपरेटिङ सिस्टमले कति मेमोरी र कसले प्रयोग गरेको छ भनेर ट्र्याक राख्नुपर्छ। कुन प्रक्रियालाई मेमोरी स्पेस चाहिन्छ र कति चाहिन्छ भनेर निर्णय गर्नुपर्दछ। OS ले मेमोरी स्पेस पनि आवंटित र डिलोकेट गर्नुपर्छ।
- **सुरक्षा/गोपनीयता व्यवस्थापन**: अपरेटिङ सिस्टमले पासवर्डहरू प्रयोग गरेर गोपनीयता पनि प्रदान गरेको छ ताकि अनाधिकृत अनुप्रयोगहरूले कार्यक्रमहरू वा डेटा पहुँच गर्न सक्दैनन्। उदाहरणका लागि, विन्डोजले डाटामा अनधिकृत पहुँच रोक्न **_Kerberos_** प्रमाणीकरण प्रयोग गर्दछ।

### अपरेटिङ सिस्टमका प्रकारहरू
- **मेनफ्रेम ओएस**:
उच्च छेउमा मेनफ्रेमहरूका लागि अपरेटिङ सिस्टमहरू छन्, ती कोठा-आकारका
कम्प्युटरहरू अझै पनि प्रमुख कर्पोरेट डाटा केन्द्रहरूमा फेला परेका छन्। यी कम्प्युटरहरू फरक छन्
व्यक्तिगत कम्प्युटरहरू तिनीहरूको I/O क्षमताको सन्दर्भमा। 1000 डिस्क संग एक मुख्य फ्रेम
र लाखौं गीगाबाइट डाटा असामान्य छैन; यी संग एक व्यक्तिगत कम्प्युटर
विशिष्टताहरू यसको साथीहरूको ईर्ष्या हुनेछ। मेनफ्रेमहरू पनि केही बनाउँदैछन्-
उच्च-अन्त वेब सर्भरहरू, ठूला-स्तरीय इलेक्ट्रोनिकका लागि सर्भरहरूको रूपमा पुनरागमनको कुरा
वाणिज्य साइटहरू, र व्यापार-देखि-व्यापार लेनदेनको लागि सर्भरहरू।
मेनफ्रेमहरूको लागि अपरेटिङ सिस्टमहरू प्रशोधन तिर धेरै उन्मुख छन्
एकै पटक धेरै कामहरू, जसमध्ये धेरैलाई I/O को प्रचुर मात्रा चाहिन्छ। तिनीहरू सामान्यतया
तीन प्रकारका सेवाहरू प्रस्ताव गर्दछ: ब्याच, लेनदेन प्रशोधन, र टाइमसेयरिङ

- **सर्भर ओएस**:
एक तह तल सर्भर अपरेटिङ सिस्टम हो। तिनीहरू सर्भरहरूमा चल्छन्, जुन
या त धेरै ठूला व्यक्तिगत कम्प्युटरहरू, कार्यस्थानहरू, वा मेनफ्रेमहरू पनि हुन्। तिनीहरूले
नेटवर्कमा एकै पटक धेरै प्रयोगकर्ताहरूलाई सेवा दिनुहोस् र प्रयोगकर्ताहरूलाई हार्डवेयर साझेदारी गर्न अनुमति दिनुहोस्
र सफ्टवेयर स्रोतहरू। सर्भरहरूले मुद्रण सेवा, फाइल सेवा, वा वेब सेवा प्रदान गर्न सक्छन्।
इन्टरनेट प्रदायकहरूले आफ्ना ग्राहकहरूलाई समर्थन गर्न धेरै सर्भर मेसिनहरू चलाउँछन्, र वेबसाइटहरूले वेब पृष्ठहरू भण्डारण गर्न र आगमन अनुरोधहरू ह्यान्डल गर्न सर्भरहरू प्रयोग गर्छन्।
विशिष्ट सर्भर अपरेटिङ सिस्टमहरू सोलारिस, फ्रीबीएसडी, लिनक्स, र विन्डोज सर्भर हुन्
201x।

- **मल्टीप्रोसेसर ओएस**:
प्रमुख-लीग कम्प्युटिङ पावर प्राप्त गर्ने बढ्दो सामान्य तरिका एकल प्रणालीमा धेरै CPU हरू जडान गर्नु हो।
तिनीहरू कसरी जडान भएका छन् र के साझा गरिएको छ भन्ने कुरामा निर्भर गर्दछ, यी प्रणालीहरूलाई समानान्तर कम्प्युटरहरू, बहु-कम्प्यूटरहरू, वा बहु-प्रोसेसरहरू भनिन्छ।
तिनीहरूलाई विशेष अपरेटिङ सिस्टम चाहिन्छ, तर प्रायः यी सर्भर अपरेटिङ सिस्टमहरूमा भिन्नताहरू हुन्,
संचार, जडान, र स्थिरता को लागी विशेष सुविधाहरू संग।

- **व्यक्तिगत कम्प्युटर ओएस**:
अर्को श्रेणी व्यक्तिगत कम्प्युटर अपरेटिङ सिस्टम हो। आधुनिक सबै
बहुप्रोग्रामिङलाई समर्थन गर्दछ, प्रायः दर्जनौं कार्यक्रमहरू बुटको समयमा सुरु हुन्छ।
तिनीहरूको काम एकल प्रयोगकर्तालाई राम्रो समर्थन प्रदान गर्नु हो। तिनीहरूको लागि व्यापक रूपमा प्रयोग गरिन्छ
शब्द प्रशोधन, स्प्रेडसिट, खेल, र इन्टरनेट पहुँच। सामान्य उदाहरणहरू छन्
Linux, FreeBSD, Windows 7, Windows 8, र Apple को OS X। व्यक्तिगत कम्प्युटर
अपरेटिङ सिस्टमहरू यति व्यापक रूपमा परिचित छन् कि सायद थोरै परिचय आवश्यक छ।
धेरै मानिसहरूलाई थाहा छैन कि अन्य प्रकारहरू अवस्थित छन्।

- **एम्बेडेड ओएस**:
इम्बेडेड प्रणालीहरू कम्प्युटरहरूमा चल्छन् जसले यन्त्रहरू नियन्त्रण गर्दछ जुन सामान्यतया कम्प्युटरहरू मानिँदैन र प्रयोगकर्ता-स्थापित सफ्टवेयर स्वीकार गर्दैन।
माइक्रोवेभ ओभन, टिभी सेट, कार, डीभिडी रेकर्डर, परम्परागत उदाहरणहरू हुन्
फोन, र MP3 प्लेयरहरू। ह्यान्डहेल्डहरूबाट एम्बेडेड प्रणालीहरू छुट्याउने मुख्य गुण भनेको कुनै पनि अविश्वसनीय सफ्टवेयर तिनीहरूमा चल्ने छैन भन्ने निश्चितता हो।
तपाइँ तपाइँको माइक्रोवेभ ओभनमा नयाँ अनुप्रयोगहरू डाउनलोड गर्न सक्नुहुन्न - सबै सफ्टवेयर
ROM मा हुनुहुन्छ। यसको मतलब अनुप्रयोगहरू बीच सुरक्षाको लागि कुनै आवश्यकता छैन,
सरलीकरण डिजाइन। प्रणालीहरू जस्तै इम्बेडेड लिनक्स, QNX र
VxWorks यस डोमेनमा लोकप्रिय छ।

- **स्मार्ट कार्ड ओएस**:
सबैभन्दा सानो अपरेटिङ सिस्टम क्रेडिट कार्ड आकारको स्मार्ट कार्डमा चल्छ
CPU चिप्स भएका यन्त्रहरू। तिनीहरूसँग धेरै गम्भीर प्रशोधन शक्ति र मेमोरी अवरोधहरू छन्।
केही पाठकमा सम्पर्कहरूद्वारा संचालित हुन्छन् जसमा तिनीहरू छन्
सम्मिलित, तर सम्पर्कविहीन स्मार्ट कार्डहरू प्रेरक रूपमा संचालित छन्, धेरै सीमित छन्
तिनीहरूले के गर्न सक्छन्। केहिले मात्र एकल प्रकार्य ह्यान्डल गर्न सक्छ, जस्तै इलेक्ट्रोनिक भुक्तानीहरू, तर अरूले धेरै प्रकार्यहरू ह्यान्डल गर्न सक्छन्।
प्रायः यी स्वामित्व प्रणालीहरू हुन्।
केही स्मार्ट कार्डहरू जाभा उन्मुख छन्। यसको मतलब यो हो कि रोममा स्मार्ट
कार्डले जाभा भर्चुअल मेसिन (JVM) को लागि दोभाषे राख्छ। जाभा एप्लेटहरू (सानो
प्रोग्रामहरू) कार्डमा डाउनलोड गरिन्छ र JVM दोभाषेद्वारा व्याख्या गरिन्छ।
यी मध्ये केही कार्डहरूले एकै समयमा धेरै जाभा एप्लेटहरू ह्यान्डल गर्न सक्छन्, जसले गर्दा
बहुप्रोग्रामिङ र तिनीहरूलाई अनुसूचित गर्न आवश्यकता। स्रोत व्यवस्थापन र सुरक्षा पनि एक मुद्दा बन्न सक्छ जब दुई वा बढी एप्लेटहरू एक साथ उपस्थित हुन्छन्।
यी समस्याहरू कार्डमा उपस्थित (सामान्यतया अत्यन्त आदिम) अपरेटिङ सिस्टम द्वारा ह्यान्डल गरिनु पर्छ।

## [मेमोरी र भण्डारण](Memory%20and%20Storage/readme.md)

### मेमोरी
शब्द _memory_ ले तपाइँको कम्प्यूटर भित्रको कम्पोनेन्टलाई बुझाउँछ जसले छोटो अवधिको डेटा पहुँच अनुमति दिन्छ। तपाईंले यो कम्पोनेन्टलाई DRAM वा गतिशील अनियमित पहुँच मेमोरीको रूपमा चिन्न सक्नुहुन्छ। तपाईको कम्प्युटरले यसको छोटो अवधिको मेमोरीमा भण्डारण गरिएको डाटा पहुँच गरेर धेरै कार्यहरू गर्दछ। त्यस्ता कार्यहरूका केही उदाहरणहरूमा कागजात सम्पादन गर्ने, एपहरू लोड गर्ने र इन्टरनेट ब्राउज गर्ने समावेश छ। तपाईको प्रणालीको गति र कार्यसम्पादन तपाईको कम्प्युटरमा स्थापना भएको मेमोरीको मात्रामा निर्भर गर्दछ।

यदि तपाइँसँग डेस्क र फाइलिङ क्याबिनेट छ भने, डेस्कले तपाइँको कम्प्युटरको मेमोरीलाई प्रतिनिधित्व गर्दछ। तपाईंले तुरुन्तै प्रयोग गर्न आवश्यक वस्तुहरू सजिलै पहुँचको लागि तपाईंको डेस्कमा राखिन्छन्। यद्यपि, यसको आकार सीमितताको कारण डेस्कमा धेरै भण्डारण गर्न सकिँदैन।

### भण्डारण
जहाँ मेमोरीले छोटो अवधिको डाटाको स्थानलाई जनाउँछ, _storage_ तपाइँको कम्प्युटर भित्रको कम्पोनेन्ट हो जसले तपाइँलाई लामो समयसम्म डाटा भण्डारण गर्न र पहुँच गर्न अनुमति दिन्छ। सामान्यतया, भण्डारण ठोस-राज्य ड्राइभ वा हार्ड ड्राइभको रूपमा आउँछ। भण्डारणले तपाईका अनुप्रयोगहरू, अपरेटिङ सिस्टम, र फाइलहरू अनिश्चितकालका लागि राख्छ। कम्प्यूटरहरूले भण्डारण प्रणालीबाट जानकारी पढ्न र लेख्न आवश्यक छ, त्यसैले भण्डारण गतिले तपाइँको प्रणालीले कति छिटो बुट गर्न, लोड गर्न र तपाइँले बचत गर्नुभएको कुरा पहुँच गर्न सक्छ भनेर निर्धारण गर्दछ।

जबकि डेस्कले कम्प्युटरको मेमोरी प्रतिनिधित्व गर्दछ, फाइलिङ क्याबिनेटले तपाइँको कम्प्युटरको भण्डारण प्रतिनिधित्व गर्दछ। यसले वस्तुहरू राख्छ जुन बचत गर्न र भण्डारण गर्न आवश्यक छ तर तत्काल पहुँचको लागि आवश्यक पर्दैन। फाइलिङ क्याबिनेटको आकार भनेको यसले धेरै चीजहरू समात्न सक्छ।

** मेमोरी र भण्डारण बीचको एउटा महत्त्वपूर्ण भिन्नता यो हो कि कम्प्युटर बन्द हुँदा मेमोरी खाली हुन्छ। अर्कोतर्फ, तपाईंले आफ्नो कम्प्युटर जतिसुकै बन्द गरे पनि भण्डारण यथावत रहन्छ। तसर्थ, डेस्क र फाइलिङ क्याबिनेट एनालोजीमा, तपाइँको डेस्कमा बाँकी रहेका कुनै पनि फाइलहरू तपाइँ अफिसबाट बाहिर निस्कँदा फ्याँकिनेछन्। तपाईंको फाइलिङ क्याबिनेटमा सबै कुरा रहनेछ।

### भर्चुअल मेमोरी
कम्प्युटर प्रणालीको मुटुमा मेमोरी हुन्छ, जहाँ प्रोग्रामहरू चल्छन् र डाटा भण्डारण गरिन्छ। तर के हुन्छ जब तपाईले चलाइरहनु भएको प्रोग्रामहरू र तपाईले काम गरिरहनुभएको डाटा तपाईको कम्प्युटरको मेमोरीको भौतिक क्षमता भन्दा बढि हुन्छ? यो जहाँ भर्चुअल मेमोरीले तपाइँको कम्प्यूटरको मेमोरीमा स्मार्ट एक्सटेन्सनको रूपमा काम गर्दछ र यसको क्षमताहरू बढाउँछ।

**भर्चुअल मेमोरीको परिभाषा र उद्देश्य:**

भर्चुअल मेमोरी भौतिक मेमोरी (RAM) को सीमितताहरू पार गर्न अपरेटिङ सिस्टमहरू द्वारा नियोजित मेमोरी व्यवस्थापन प्रविधि हो। यसले सफ्टवेयर अनुप्रयोगहरूको लागि भ्रम सिर्जना गर्दछ कि तिनीहरूसँग कम्प्युटरमा भौतिक रूपमा स्थापना गरिएको भन्दा ठूलो मात्रामा मेमोरीमा पहुँच छ। संक्षेपमा, यसले कम्प्युटरको भौतिक र्यामको सीमाभन्दा बाहिर मेमोरी स्पेस प्रयोग गर्न प्रोग्रामहरूलाई सक्षम बनाउँछ।

भर्चुअल मेमोरीको प्राथमिक उद्देश्य कुशल मल्टिटास्किङ र ठूला कार्यक्रमहरूको कार्यान्वयनलाई सक्षम पार्नु हो, प्रणालीको प्रतिक्रियाशीलता कायम राख्दै। यसले भौतिक RAM र माध्यमिक भण्डारण उपकरणहरू, जस्तै हार्ड ड्राइभ वा SSD बीच एक सहज अन्तरक्रिया सिर्जना गरेर यो प्राप्त गर्दछ।

**भर्चुअल मेमोरीले उपलब्ध भौतिक मेमोरी कसरी विस्तार गर्छ:**

भर्चुअल मेमोरीलाई ब्रिजको रूपमा सोच्नुहोस् जसले तपाइँको कम्प्युटरको RAM र यसको माध्यमिक भण्डारण (डिस्क ड्राइभहरू) जडान गर्दछ। जब तपाइँ एक कार्यक्रम चलाउनुहुन्छ, यसको भागहरू छिटो भौतिक मेमोरी (RAM) मा लोड हुन्छन्। यद्यपि, कार्यक्रमका सबै भागहरू तुरुन्तै प्रयोग गर्न सकिँदैन।

भर्चुअल मेमोरीले सक्रिय रूपमा प्रयोगमा रहेका पार्टहरूका लागि RAM मा थप ठाउँहरू सिर्जना गर्दै, सक्रिय रूपमा RAM बाट माध्यमिक भण्डारणमा प्रयोग भइरहेका कार्यक्रमहरूको खण्डहरू सारेर यो अवस्थाको शोषण गर्दछ। यो प्रक्रिया प्रयोगकर्ता र चलिरहेको कार्यक्रमहरूको लागि पारदर्शी छ। जब सारियो भागहरू पुन: आवश्यक हुन्छ, तिनीहरूलाई RAM मा फर्काइन्छ, जबकि अन्य कम सक्रिय भागहरू माध्यमिक भण्डारणमा सार्न सकिन्छ।

भौतिक मेमोरी भित्र र बाहिर डाटाको यो गतिशील स्वैपिङ अपरेटिङ सिस्टम द्वारा व्यवस्थित गरिन्छ। यसले उपलब्ध RAM भन्दा ठूला भए तापनि प्रोग्रामहरू चलाउन अनुमति दिन्छ, किनकि अपरेटिङ सिस्टमले इष्टतम कार्यसम्पादनको लागि RAM मा कुन डाटा हुनु आवश्यक छ भनी बुद्धिमानी निर्णय गर्छ।

संक्षेपमा, भर्चुअल मेमोरीले भर्चुअलाइजेशन तहको रूपमा कार्य गर्दछ जसले RAM र माध्यमिक भण्डारण बीचका कार्यक्रमहरू र डाटाका अंशहरू अस्थायी रूपमा स्थानान्तरण गरेर उपलब्ध भौतिक मेमोरी विस्तार गर्दछ। यो प्रक्रियाले सुनिश्चित गर्दछ कि कम्प्यूटरले ठूला कार्यहरू र धेरै कार्यक्रमहरू एकै साथ ह्यान्डल गर्न सक्छ, सबै कुशल प्रदर्शन र उत्तरदायित्व कायम राख्दै।

## [फाइल प्रणाली](File%20System/readme.md)
कम्प्युटिङमा, फाइल प्रणाली वा फाइल प्रणाली (प्रायः fs को संक्षिप्त रूपमा) एक विधि र डाटा संरचना हो जुन अपरेटिङ सिस्टमले डाटा कसरी भण्डारण र पुन: प्राप्त गर्ने नियन्त्रण गर्न प्रयोग गर्दछ। फाइल प्रणाली बिना, भण्डारण माध्यममा राखिएको डाटा डाटाको एक ठूलो भाग हुनेछ जहाँ डाटाको एक टुक्रा कहाँ रोकियो र अर्को सुरु भयो वा डाटाको कुनै टुक्रा कहाँ अवस्थित थियो जब यसलाई पुन: प्राप्त गर्ने समय थियो भनेर बताउन कुनै तरिका छैन। डाटालाई टुक्रामा विभाजन गरेर र प्रत्येक टुक्रालाई नाम दिएर, डाटा सजिलै पृथक र पहिचान हुन्छ। कागजमा आधारित डाटा व्यवस्थापन प्रणालीको नामबाट यसको नाम लिएर, प्रत्येक डेटा समूहलाई "फाइल" भनिन्छ। डेटा समूह र तिनीहरूको नामहरू व्यवस्थापन गर्न प्रयोग गरिने संरचना र तर्क नियमहरूलाई "फाइल प्रणाली" भनिन्छ।

त्यहाँ धेरै प्रकारका फाइल प्रणालीहरू छन्, प्रत्येकमा अद्वितीय संरचना र तर्क, गतिको गुण, लचिलोपन, सुरक्षा, आकार, र थप। केही फाइल प्रणालीहरू विशेष अनुप्रयोगहरूको लागि प्रयोग गर्न डिजाइन गरिएको छ। उदाहरण को लागी, ISO 9660 फाइल प्रणाली विशेष गरी अप्टिकल डिस्क को लागी डिजाइन गरिएको छ।

फाइल प्रणालीहरू विभिन्न मिडिया प्रयोग गरेर धेरै प्रकारका भण्डारण उपकरणहरूमा प्रयोग गर्न सकिन्छ। 2019 को रूपमा, हार्ड डिस्क ड्राइभहरू मुख्य भण्डारण यन्त्रहरू भएका छन् र निकट भविष्यको लागि यस्तै रहने अनुमान गरिएको छ। अन्य प्रकारका मिडियाहरू जुन प्रयोग गरिन्छ SSDs, चुम्बकीय टेपहरू, र अप्टिकल डिस्कहरू समावेश छन्। केहि अवस्थामा, जस्तै tmpfs संग, कम्प्यूटरको मुख्य मेमोरी (यादृच्छिक-पहुँच मेमोरी, RAM) ले छोटो अवधिको प्रयोगको लागि अस्थायी फाइल प्रणाली सिर्जना गर्दछ।

केही फाइल प्रणालीहरू स्थानीय डाटा भण्डारण उपकरणहरूमा प्रयोग गरिन्छ; अरूले नेटवर्क प्रोटोकल मार्फत फाइल पहुँच प्रदान गर्दछ (उदाहरणका लागि, NFS, SMB, वा 9P ग्राहकहरू)। केही फाइल प्रणालीहरू "भर्चुअल" हुन्छन्, यसको अर्थ आपूर्ति गरिएका "फाइलहरू" (भर्चुअल फाइलहरू भनिन्छ) अनुरोधमा गणना गरिन्छ (जस्तै procfs र sysfs) वा ब्याकिङ स्टोरको रूपमा प्रयोग गरिने फरक फाइल प्रणालीमा म्यापिङ मात्र हुन्छ। फाइल प्रणालीले फाइलहरूको सामग्री र ती फाइलहरूको बारेमा मेटाडाटा दुवैमा पहुँच व्यवस्थापन गर्दछ। यो भण्डारण ठाउँ व्यवस्था गर्न जिम्मेवार छ; भौतिक भण्डारण माध्यमको सन्दर्भमा विश्वसनीयता, दक्षता, र ट्युनिङ महत्त्वपूर्ण डिजाइन विचारहरू हुन्।

### फाइल प्रणाली कसरी काम गर्छ
फाइल प्रणालीले डाटा भण्डारण र व्यवस्थित गर्दछ र भण्डारण उपकरणमा समावेश सबै डाटाको लागि अनुक्रमणिकाको प्रकारको रूपमा सोच्न सकिन्छ। यी यन्त्रहरूमा हार्ड ड्राइभहरू, अप्टिकल ड्राइभहरू, र फ्ल्यास ड्राइभहरू समावेश हुन सक्छन्।

फाइल प्रणालीहरूले नाममा क्यारेक्टरहरूको अधिकतम संख्या, कुन क्यारेक्टरहरू प्रयोग गर्न सकिन्छ, र केही प्रणालीहरूमा, फाइल नाम प्रत्यय कति लामो हुन सक्छ भन्ने सहित फाइलहरू नामकरणका लागि कन्भेन्सनहरू निर्दिष्ट गर्दछ। धेरै फाइल प्रणालीहरूमा, फाइल नाम केस-संवेदनशील हुँदैनन्।

फाइलको साथमा, फाइल प्रणालीहरूले फाइलको साइज र यसको विशेषताहरू, स्थान, र मेटाडेटामा डाइरेक्टरीमा पदानुक्रम जस्ता जानकारी समावेश गर्दछ। मेटाडाटाले ड्राइभमा उपलब्ध भण्डारणको नि:शुल्क ब्लकहरू र कति ठाउँ उपलब्ध छ भनेर पनि पहिचान गर्न सक्छ।

फाइल प्रणालीले डाइरेक्टरीहरूको संरचना मार्फत फाइलको मार्ग निर्दिष्ट गर्न ढाँचा पनि समावेश गर्दछ। एउटा फाइल डाइरेक्टरीमा राखिएको छ - वा Windows OS मा फोल्डर - वा रूख संरचनामा वांछित ठाउँमा उपनिर्देशिका। पीसी र मोबाइल ओएसहरूसँग फाइल प्रणालीहरू छन् जसमा फाइलहरू क्रमबद्ध रूख संरचनामा राखिन्छन्।

भण्डारण माध्यममा फाइलहरू र डाइरेक्टरीहरू सिर्जना गर्नु अघि, विभाजनहरू राख्नुपर्छ। विभाजन हार्ड डिस्क वा अन्य भण्डारणको क्षेत्र हो जुन OS ले छुट्टै व्यवस्थापन गर्दछ। प्राथमिक विभाजनमा एउटा फाइल प्रणाली समावेश हुन्छ, र केही ओएसहरूले एउटा डिस्कमा धेरै विभाजनहरूका लागि अनुमति दिन्छ। यस अवस्थामा, यदि एउटा फाइल प्रणाली दूषित हुन्छ भने, फरक विभाजनमा डाटा सुरक्षित हुनेछ।

### फाइल प्रणालीका प्रकारहरू
त्यहाँ धेरै प्रकारका फाइल प्रणालीहरू छन्, सबै फरक तार्किक संरचना र गुणहरू, जस्तै गति र आकार। फाइल प्रणालीको प्रकार OS र त्यो OS को आवश्यकता अनुसार फरक हुन सक्छ। माइक्रोसफ्ट विन्डोज, म्याक ओएस एक्स, र लिनक्स तीन सबैभन्दा सामान्य पीसी अपरेटिङ सिस्टमहरू हुन्। मोबाइल ओएसहरूमा एप्पल आईओएस र गुगल एन्ड्रोइड समावेश छ।

प्रमुख फाइल प्रणालीहरू निम्न समावेश छन्:

- फाइल आवंटन तालिका (FAT) Microsoft Windows OS द्वारा समर्थित छ। FAT लाई सरल र भरपर्दो मानिन्छ र लिगेसी फाइल प्रणाली पछि मोडेल गरिएको छ। FAT लाई 1977 मा फ्लपी डिस्कको लागि डिजाइन गरिएको थियो तर पछि हार्ड डिस्कको लागि अनुकूलित गरियो। धेरै हालको ओएसहरूसँग कुशल र उपयुक्त हुँदा, FAT ले थप आधुनिक फाइल प्रणालीहरूको प्रदर्शन र स्केलेबिलिटीसँग मेल खाँदैन।

- ग्लोबल फाइल प्रणाली (GFS) Linux OS को लागि फाइल प्रणाली हो, र यो साझा डिस्क फाइल प्रणाली हो। GFS ले साझा ब्लक भण्डारणमा प्रत्यक्ष पहुँच प्रदान गर्दछ र स्थानीय फाइल प्रणालीको रूपमा प्रयोग गर्न सकिन्छ।

- GFS2 मूल GFS मा समावेश नगरिएका सुविधाहरू सहितको अद्यावधिक संस्करण हो, जस्तै अद्यावधिक गरिएको मेटाडेटा प्रणाली। GNU जनरल पब्लिक लाइसेन्स सर्तहरू अन्तर्गत, GFS र GFS2 फाइल प्रणालीहरू नि: शुल्क सफ्टवेयरको रूपमा उपलब्ध छन्।

- पदानुक्रमिक फाइल प्रणाली (HFS) म्याक अपरेटिङ सिस्टमहरूसँग प्रयोगको लागि विकसित गरिएको थियो। HFS लाई Mac OS मानक पनि भन्न सकिन्छ, Mac OS विस्तारित द्वारा सफल। मूल रूपमा फ्लपी र हार्ड डिस्कका लागि 1985 मा पेश गरिएको, HFS ले मूल Macintosh फाइल प्रणालीलाई प्रतिस्थापन गर्यो। यो CD-ROM मा पनि प्रयोग गर्न सकिन्छ।

- NT फाइल प्रणाली - जसलाई नयाँ टेक्नोलोजी फाइल प्रणाली (NTFS) पनि भनिन्छ - Windows NT 3.1 OS बाट विन्डोज उत्पादनहरूको लागि पूर्वनिर्धारित फाइल प्रणाली हो। अघिल्लो FAT फाइल प्रणालीबाट सुधारहरूमा राम्रो मेटाडेटा समर्थन, प्रदर्शन, र डिस्क ठाउँको प्रयोग समावेश छ। NTFS लाई Linux OS मा नि:शुल्क, खुला स्रोत NTFS ड्राइभर मार्फत पनि समर्थन गरिन्छ। Mac OSes सँग NTFS को लागि पढ्ने मात्र समर्थन छ।

- युनिभर्सल डिस्क ढाँचा (UDF) अप्टिकल मिडिया र DVD को लागि विक्रेता-तटस्थ फाइल प्रणाली हो। UDF ले ISO 9660 फाइल प्रणालीलाई प्रतिस्थापन गर्छ र DVD भिडियो र अडियोको लागि आधिकारिक फाइल प्रणाली हो, जुन DVD फोरमले रोजेको छ।

## [क्लाउड कम्प्युटिङ](Cloud%20Computing/Readme.md)
क्लाउड कम्प्युटिङ इन्टरनेट मार्फत जानकारी र अनुप्रयोगहरू पहुँच गर्ने क्षमता हो। क्लाउड कम्प्युटिङले प्रयोगकर्ताहरूलाई इन्टरनेट जडानको साथ कुनै पनि स्थानबाट अनुप्रयोगहरू र डेटा पहुँच गर्न अनुमति दिन्छ।

क्लाउड कम्प्युटिङ इन्टरनेट-आधारित कम्प्युटिङको एक प्रकार हो जसले साझा कम्प्युटर प्रशोधन स्रोतहरू र डाटा कम्प्युटर र अन्य उपकरणहरूलाई मागमा उपलब्ध गराउँछ।

यो कन्फिगर योग्य कम्प्युटिङ स्रोतहरू (जस्तै, नेटवर्कहरू, सर्भरहरू, भण्डारण, अनुप्रयोगहरू, र सेवाहरू) को साझा पूलमा सर्वव्यापी, सुविधाजनक, अन-डिमांड नेटवर्क पहुँच सक्षम गर्ने मोडेल हो जुन न्यूनतम व्यवस्थापन प्रयास वा सेवाको साथ द्रुत रूपमा प्रावधान र जारी गर्न सकिन्छ। प्रदायक अन्तरक्रिया।
 
  ### क्लाउड कम्प्युटिङका शीर्ष फाइदाहरू
 
क्लाउड कम्प्युटिङ IT स्रोतहरूको बारेमा व्यवसायहरूले सोच्ने तरिकाबाट ठूलो परिवर्तन हो। संस्थाहरू क्लाउड कम्प्युटिङ सेवाहरूमा फर्किने सातवटा सामान्य कारणहरू यहाँ छन्:


लागत
क्लाउड कम्प्युटिङले हार्डवेयर र सफ्टवेयर किन्न र साइटमा डाटा सेन्टरहरू सेटअप र चलाउनको पूँजीगत खर्च हटाउँछ — सर्भरहरूको र्याक, पावर र कूलिङका लागि चौबीसै घण्टा बिजुली, र पूर्वाधार व्यवस्थापनका लागि IT विशेषज्ञहरू। यो छिटो जोड्छ।


गति
धेरैजसो क्लाउड कम्प्युटिङ सेवाहरू स्व-सेवा र मागमा उपलब्ध गराइन्छ, त्यसैले धेरै मात्रामा कम्प्युटिङ स्रोतहरू पनि मिनेटमा प्रदान गर्न सकिन्छ, सामान्यतया केही माउस क्लिकहरूद्वारा, व्यवसायहरूलाई धेरै लचिलोपन प्रदान गर्दै र क्षमता योजनाको दबाब हटाउन।


ग्लोबल स्केल
क्लाउड कम्प्युटिङ सेवाहरूको फाइदाहरूमा लोचदार रूपमा मापन गर्ने क्षमता समावेश छ। क्लाउड स्पिकमा, यसको मतलब सही मात्रामा IT स्रोतहरू डेलिभर गर्नु हो - उदाहरणका लागि, कम वा कम कम्प्युटिङ पावर, भण्डारण, र ब्यान्डविथ — आवश्यक परेको बेला र सही भौगोलिक स्थानबाट।


उत्पादकता
अन-साइट डेटा केन्द्रहरूलाई सामान्यतया धेरै "र्याकिङ र स्ट्याकिङ" चाहिन्छ — हार्डवेयर सेटअप, सफ्टवेयर प्याचिङ, र अन्य समय-उपभोग गर्ने IT व्यवस्थापन कामहरू। क्लाउड कम्प्युटिङले यी धेरै कार्यहरूको आवश्यकतालाई हटाउँछ, त्यसैले IT टोलीहरूले थप महत्त्वपूर्ण व्यावसायिक लक्ष्यहरू प्राप्त गर्न समय खर्च गर्न सक्छन्।


प्रदर्शन
सबैभन्दा ठूलो क्लाउड कम्प्युटिङ सेवाहरू सुरक्षित डाटा केन्द्रहरूको विश्वव्यापी नेटवर्कमा चल्छ, जुन नियमित रूपमा छिटो र कुशल कम्प्युटिङ हार्डवेयरको नवीनतम पुस्तामा अपग्रेड गरिन्छ। यसले एकल कर्पोरेट डाटा सेन्टरमा धेरै फाइदाहरू प्रदान गर्दछ, जसमा अनुप्रयोगहरूको लागि कम नेटवर्क विलम्बता र स्केलको ठूलो अर्थव्यवस्थाहरू समावेश छन्।


विश्वसनीयता
क्लाउड कम्प्युटिङले डाटा ब्याकअप, विपद् रिकभरी, र व्यापार निरन्तरतालाई सजिलो र कम खर्चिलो बनाउँछ किनभने डाटा क्लाउड प्रदायकको नेटवर्कमा धेरै अनावश्यक साइटहरूमा मिरर गर्न सकिन्छ।


सुरक्षा
धेरै क्लाउड प्रदायकहरूले तपाईंको डेटा, एपहरू र पूर्वाधारलाई सम्भावित खतराहरूबाट जोगाउन मद्दत गर्दै समग्रमा तपाईंको सुरक्षा स्थितिलाई बलियो बनाउने नीतिहरू, प्रविधिहरू र नियन्त्रणहरूको फराकिलो सेट प्रस्ताव गर्छन्।

### क्लाउड कम्प्युटिङ सेवाका प्रकारहरू
- [सेवाको रूपमा पूर्वाधार (IaaS)](Cloud%20Computing/Readme.md#infrastructure-as-a-service-iaas)
- [सेवाको रूपमा प्लेटफर्म (PaaS)](Cloud%20Computing/Readme.md#platform-as-a-service-paas)
- [सेवाको रूपमा सफ्टवेयर (SaaS)](Cloud%20Computing/Readme.md#software-as-a-service-saas)

## [मेसिन लर्निङ]()
मेसिन लर्निङ भनेको कम्प्युटरलाई सिक्न सिकाउने अभ्यास हो। अवधारणाले ढाँचा पहिचान प्रयोग गर्दछ, साथै भविष्यवाणी गर्ने एल्गोरिदमका अन्य रूपहरू, आगमन डेटामा निर्णय गर्न। यो क्षेत्र कृत्रिम बुद्धिमत्ता र कम्प्युटेसनल तथ्याङ्कसँग नजिकको सम्बन्ध छ।

### मेसिन लर्निङका तीन उपश्रेणीहरू छन्:

### पर्यवेक्षित (Supervised) मेसिन लर्निङ 
यसमा, मेसिन लर्निङ मोडेलहरूलाई लेबल गरिएका डाटा सेटहरूद्वारा प्रशिक्षित गरिन्छ, जसले मोडेलहरूलाई समयसँगै अझ सटीक रूपमा सिक्न र बढ्न अनुमति दिन्छ। उदाहरणका लागि, एल्गोरिदमलाई कुकुरहरू र अन्य चीजहरूका तस्बिरहरूद्वारा प्रशिक्षित गरिनेछ, सबै मानिसहरूद्वारा लेबल गरिएको छ, र मेसिनले आफैंमा कुकुरहरूको चित्रहरू पहिचान गर्ने तरिकाहरू सिक्नेछ। पर्यवेक्षित मेसिन लर्निङ आज प्रयोग हुने सबैभन्दा सामान्य प्रकार हो।

पर्यवेक्षित शिक्षाको व्यावहारिक अनुप्रयोगहरू -
1. **जैव सूचना विज्ञान:** बायोइन्फर्मेटिक्स भनेको व्यक्तिहरूले कसरी औँठाछाप, आँखाको बनावट, कानको लोब आदि जस्ता जैविक ज्ञानहरू राख्ने अध्ययन हो। मोबाइल फोनहरू अब हाम्रो जैविक डेटा बुझ्न र त्यसपछि प्रणाली सुरक्षा बढाउन हामीलाई प्रमाणित गर्न पर्याप्त चलाख छन्।
2. **स्पिच रिकग्निसन:** यो कार्यक्रमको प्रकार हो जहाँ तपाइँ कार्यक्रममा तपाइँको आवाज सुनाउन सक्नुहुन्छ, र यसले तपाइँलाई पहिचान गर्नेछ। सबैभन्दा प्रसिद्ध वास्तविक-विश्व ग्याजेटहरू डिजिटल सहायकहरू जस्तै गुगल सहायक वा सिरी हुन्, जसले शब्दलाई तपाईंको आवाजले मात्र जवाफ दिन्छ।
3. **स्प्याम पत्ता लगाउने:** यो उपकरण काल्पनिक वा मेसिनमा आधारित सञ्चारहरू पठाउनबाट रोक्न प्रयोग गरिन्छ। जीमेलले धेरै गलत शब्दहरू सिक्ने एल्गोरिदम समावेश गर्दछ। Oneplus Messages एपले प्रयोगकर्तालाई कुन सर्तहरू प्रतिबन्धित गर्नुपर्छ भनेर निर्दिष्ट गर्न सोध्छ, र किवर्डले एपबाट त्यस्ता पाठहरूलाई रोक्नेछ।
4. **दृष्टिको लागि वस्तु पहिचान:** यस प्रकारको सफ्टवेयर प्रयोग गरिन्छ जब तपाईले कुनै पनि कुरा परिभाषित गर्नु पर्छ। तपाईंसँग एउटा ठूलो डेटासेट छ जुन तपाईंले एल्गोरिदमलाई तालिम दिन प्रयोग गर्नुहुन्छ, र यसले यसलाई प्रयोग गरेर नयाँ वस्तु पहिचान गर्न सक्छ।

### Unsupervised मेसिन लर्निङ
Unsupervised मेसिन लर्निङमा, एउटा कार्यक्रमले लेबल नगरिएको डाटामा ढाँचाहरू खोज्छ। असुरक्षित मेसिन लर्निङले मानिसहरूले स्पष्ट रूपमा नखोजिरहेका ढाँचा वा प्रवृत्तिहरू फेला पार्न सक्छ। उदाहरणका लागि, एक असुरक्षित मेसिन लर्निङ प्रोग्रामले अनलाइन बिक्री डेटा मार्फत हेर्न र खरिद गर्ने ग्राहकहरूको विभिन्न प्रकारहरू पहिचान गर्न सक्छ।

Unsupervised शिक्षाको व्यावहारिक अनुप्रयोगहरू
१. **क्लस्टरिङ:** क्लस्टरिङ भनेको डाटालाई छुट्टाछुट्टै समूहमा वर्गीकरण गर्ने प्रक्रिया हो। जब हामीलाई क्लस्टरहरूको बारेमा सबै विवरणहरू थाहा हुँदैन, हामी तिनीहरूलाई क्लस्टर गर्न असुरक्षित सिकाइ प्रयोग गर्न सक्छौं। पूर्व-लेबल गरिएका कक्षाहरू वा वर्ग गुणहरू नभएको डेटाको विश्लेषण र व्यवस्थित गर्नको लागि असुरक्षित शिक्षा प्रयोग गरिन्छ। क्लस्टरिङले फर्महरूलाई आफ्नो डाटालाई अझ प्रभावकारी रूपमा ह्यान्डल गर्न मद्दत गर्न सक्छ।
मानौं तपाईसँग युट्युब च्यानल छ। तपाईंसँग आफ्ना सदस्यहरूमा धेरै जानकारी हुन सक्छ। यदि तपाइँ समान ग्राहकहरू फेला पार्न चाहनुहुन्छ भने, तपाइँले क्लस्टरिङ प्रविधि प्रयोग गर्न आवश्यक छ।
२. **भिजुअलाइजेशन:** जानकारी प्रस्तुत गर्नका लागि रेखाचित्र, फोटो, ग्राफ, चार्ट आदि बनाउने प्रक्रियालाई दृश्यावलोकन भनिन्छ। यो रणनीति कार्यान्वयन गर्न असुरक्षित मेसिन लर्निङ प्रयोग गर्न सकिन्छ।
मान्नुहोस् कि तपाईं एक क्रिकेट प्रशिक्षक हुनुहुन्छ जसमा टूर्नामेन्टमा तपाईंको टोलीको प्रदर्शनको बारेमा जानकारी छ। तपाइँ चाँडै सबै मिलान तथ्याङ्कहरू पत्ता लगाउन चाहनुहुन्छ। तपाईले लेबल नगरिएको र जटिल डेटालाई भिजुअलाइजेशन एल्गोरिदममा पास गर्न सक्नुहुन्छ।
3. **विसंगति पत्ता लगाउने:** विसंगति (Anomaly) पत्ता लगाउने असामान्य चीजहरू, घटनाहरू, वा अवलोकनहरूको खोज हो जसले नियमित डेटाबाट धेरै विचलित भएर शंका उत्पन्न गर्दछ। यस अवस्थामा, प्रणाली विशिष्ट केसहरूको ठूलो संख्यामा प्रोग्राम गरिएको छ। नतिजाको रूपमा, जब यसले एक अप्रत्याशित घटना पत्ता लगाउँछ, यसले यो विसंगति हो वा होइन भनेर निर्धारण गर्न सक्छ।
क्रेडिट कार्ड धोखाधडी पत्ता लगाउने यो एक राम्रो दृष्टान्त हो। यो मुद्दा अब असुरक्षित मेसिन लर्निङ विसंगति पत्ता लगाउने दृष्टिकोणहरू प्रयोग गरेर सम्बोधन गरिएको छ। धोखाधडीबाट बच्नको लागि, प्रणालीले अप्रत्याशित क्रेडिट कार्ड लेनदेनहरू पहिचान गर्दछ।

### सेमी-पर्यवेक्षित (Semi-supervised) मेसिन लर्निङ
पर्यवेक्षित(Supervised) शिक्षाको बेफाइदा यो हो कि यसलाई ML विशेषज्ञहरू वा डेटा वैज्ञानिकहरूद्वारा ह्यान्ड-लेबलिङ आवश्यक पर्दछ र प्रशोधन गर्न उच्च लागत चाहिन्छ। पर्यवेक्षण नगरिएको सिकाइमा पनि यसको अनुप्रयोगहरूको लागि सीमित स्पेक्ट्रम छ। पर्यवेक्षित सिकाइ र असुरक्षित सिकाइ एल्गोरिदमका यी कमजोरीहरूलाई हटाउन, अर्ध-पर्यवेक्षित शिक्षाको अवधारणा प्रस्तुत गरिएको छ। सामान्यतया, यो संयोजनले लेबल गरिएको डेटाको धेरै सानो मात्रा र लेबल नगरिएको डेटाको ठूलो मात्रा समावेश गर्दछ। समावेश गरिएको आधारभूत प्रक्रिया यो हो कि पहिले, प्रोग्रामरले असुरक्षित सिकाइ एल्गोरिदम प्रयोग गरी समान डेटा क्लस्टर गर्नेछ र त्यसपछि लेबल नगरिएको बाँकी डाटालाई लेबल गर्न अवस्थित लेबल गरिएको डाटा प्रयोग गर्दछ।

अर्ध-पर्यवेक्षित शिक्षाको व्यावहारिक अनुप्रयोगहरू -
1. **स्पिच एनालिसिस:** अडियो फाइलहरूलाई लेबल लगाउने एकदमै गहन कार्य भएकोले, सेमी-पर्यवेक्षित सिकाइ यस समस्याको समाधान गर्नको लागि एकदमै स्वाभाविक दृष्टिकोण हो।
2. **इन्टरनेट सामग्री:** वर्गीकरण: प्रत्येक वेबपेज लेबल गर्नु एक अव्यावहारिक र असम्भव प्रक्रिया हो र यसैले अर्ध-पर्यवेक्षित शिक्षा एल्गोरिदमहरू प्रयोग गर्दछ। गुगल खोज एल्गोरिथ्मले पनि दिइएको क्वेरीको लागि वेबपेजको सान्दर्भिकता स्तर निर्धारण गर्न अर्ध-पर्यवेक्षित शिक्षाको भिन्नता प्रयोग गर्दछ।
3. **प्रोटिन अनुक्रम वर्गीकरण:** DNA स्ट्र्यान्डहरू सामान्यतया धेरै ठूला हुने भएकाले, यस क्षेत्रमा सेमी-पर्यवेक्षित सिकाइको उदय आसन्न छ।

### सुदृढीकरण(Reinforcement) मेसिन लर्निंग
यसले इनाम प्रणाली स्थापना गरेर उत्कृष्ट कार्य गर्न परीक्षण र त्रुटि मार्फत मेसिनहरूलाई तालिम दिन्छ। सुदृढीकरण सिकाइले मोडेलहरूलाई गेमहरू खेल्न वा स्वायत्त सवारी साधनहरूलाई ड्राइभ गर्न तालिम दिन सक्छ जब मेसिनले सही निर्णयहरू लिन्छ भनेर बताइदिन्छ, जसले यसलाई समयसँगै के-के कार्यहरू गर्नुपर्छ भनेर सिक्न मद्दत गर्छ।

सुदृढीकरण शिक्षाको व्यावहारिक अनुप्रयोगहरू -
१. **उत्पादन प्रणाली**
    जस्तै Google Cloud AutoML, Facebook Horizon, सिफारिस, विज्ञापन, खोज
2. **स्वायत्त ड्राइभिङ**
3. **व्यवसाय व्यवस्थापन**
    जस्तै वाहन मार्ग समस्या समाधान गर्दै, ई-वाणिज्य मा धोखाधडी व्यवहार, ग्राहक अन्तरक्रियाहरु बाट समवर्ती सुदृढीकरण शिक्षा
४. **सिफारिस प्रणाली**
    जस्तै खोज, सिफारिस र अनलाइन विज्ञापनको लागि

### मेसिन लर्निङ धेरै अन्य आर्टिफिसियल इन्टेलिजेन्स सबफिल्डहरूसँग पनि सम्बन्धित छ:

### प्राकृतिक भाषा प्रशोधन

प्राकृतिक भाषा प्रशोधन भनेको मेसिन लर्निङको एउटा क्षेत्र हो जसमा मेसिनहरूले सामान्यतया कम्प्युटर प्रोग्राम गर्न प्रयोग गरिने डेटा र संख्याहरूको सट्टा मानिसले बोल्ने र लेखिएको प्राकृतिक भाषा बुझ्न सिक्छन्। यसले मेशिनहरूलाई भाषा पहिचान गर्न, बुझ्न र प्रतिक्रिया दिन, साथै नयाँ पाठ सिर्जना गर्न र भाषाहरू बीच अनुवाद गर्न अनुमति दिन्छ। प्राकृतिक भाषा प्रशोधनले च्याटबटहरू र सिरी वा एलेक्सा जस्ता डिजिटल सहायकहरू जस्ता परिचित प्रविधिहरूलाई सक्षम बनाउँछ।

NLP को व्यावहारिक अनुप्रयोगहरू:
1. **प्रश्न उत्तर:** प्रश्न उत्तरले मानिसले प्राकृतिक भाषामा सोधेका प्रश्नहरूको स्वचालित रूपमा जवाफ दिने प्रणाली निर्माणमा केन्द्रित हुन्छ।
2. **स्प्याम पत्ता लगाउने:** स्प्याम पत्ता लगाउने प्रयोगकर्ताको इनबक्समा आउने अनावश्यक इ-मेलहरू पत्ता लगाउन प्रयोग गरिन्छ।
3. **भावना विश्लेषण:** भावना विश्लेषणलाई राय माइनिङ पनि भनिन्छ। यो वेबमा प्रेषकको मनोवृत्ति, व्यवहार, र भावनात्मक अवस्थाको विश्लेषण गर्न प्रयोग गरिन्छ। यो अनुप्रयोग NLP (प्राकृतिक भाषा प्रशोधन) र तथ्याङ्कको संयोजन मार्फत लागू गरिएको छ पाठमा मानहरू (सकारात्मक, नकारात्मक, वा प्राकृतिक) र सन्दर्भको मुड (खुसी, दुखी, रिस, इत्यादि) पहिचान गरेर।
4. **मेसिन अनुवाद:** मेशिन अनुवाद एक प्राकृतिक भाषाबाट अर्को प्राकृतिक भाषामा पाठ वा भाषण अनुवाद गर्न प्रयोग गरिन्छ। जस्तै गुगल अनुवाद्
5. **हिज्जे सुधार:** माइक्रोसफ्ट कर्पोरेशनले हिज्जे सुधारको लागि MS-word र PowerPoint जस्ता वर्ड प्रोसेसर सफ्टवेयर उपलब्ध गराउँछ।

### न्यूरल नेटवर्कहरू

तंत्रिका सञ्जालहरू सामान्यतया प्रयोग हुने मेसिन लर्निङ एल्गोरिदमहरूको विशिष्ट वर्ग हुन्। कृत्रिम तंत्रिका सञ्जालहरू मानव मस्तिष्कमा मोडेल गरिएका छन्, जसमा हजारौं वा लाखौं प्रशोधन नोडहरू आपसमा जोडिएका छन् र तहहरूमा व्यवस्थित छन्।

एक कृत्रिम तंत्रिका नेटवर्कमा, कोशिकाहरू, वा नोडहरू, प्रत्येक सेल प्रशोधन इनपुटहरू र अन्य न्यूरोन्सहरूमा पठाइने आउटपुट उत्पादनको साथ जडान हुन्छन्। लेबल गरिएको डाटा नोड वा कक्षहरू मार्फत सर्छ, प्रत्येक कक्षले फरक प्रकार्य प्रदर्शन गर्दछ। तस्विरमा बिरालो छ वा छैन भनेर पहिचान गर्न प्रशिक्षित न्यूरल नेटवर्कमा, बिभिन्न नोडहरूले जानकारीको मूल्याङ्कन गर्नेछन् र आउटपुटमा आइपुग्छन् जसले चित्रमा बिरालो छ कि छैन भनेर संकेत गर्दछ।

तंत्रिका नेटवर्क को व्यावहारिक अनुप्रयोगहरू:
१. **स्टक मार्केट प्रिडिक्शन:** वास्तविक समयमा सफल स्टक भविष्यवाणी गर्नको लागि, मल्टिलेयर पर्सेप्ट्रोन MLP (फिडफर्वार्ड आर्टिफिसियल इन्टेलिजेन्स एल्गोरिदमको क्लास) प्रयोग गरिन्छ। MLP मा नोडहरूको धेरै तहहरू समावेश हुन्छन्, र यी प्रत्येक तहहरू सफल नोडहरूमा पूर्ण रूपमा जडान हुन्छन्। स्टकको विगतको प्रदर्शन, वार्षिक प्रतिफल, र गैर-नाफा अनुपातलाई MLP मोडेल निर्माण गर्न विचार गरिन्छ।
2. **सामाजिक मिडिया:** बहु-स्तरित पर्सेप्ट्रन्सले सामाजिक सञ्जाल प्रचलनहरू भविष्यवाणी गर्दछ। यसले विभिन्न प्रशिक्षण विधिहरू जस्तै मीन निरपेक्ष त्रुटि (MAE), रूट मीन स्क्वायर त्रुटि (RMSE), र मीन स्क्वायर त्रुटि (MSE) प्रयोग गर्दछ। MLP ले प्रयोगकर्ताको मनपर्ने इन्स्टाग्राम पृष्ठहरू, बुकमार्क गरिएका छनोटहरू, आदि जस्ता धेरै कारकहरूलाई ध्यानमा राख्छ। सामाजिक सञ्जालहरू मार्फत व्यक्तिहरूको व्यवहारको विश्लेषण पोस्ट गर्नुहोस्, डेटालाई मानिसहरूको खर्च गर्ने बानीसँग जोड्न सकिन्छ। MLP ANN सामाजिक मिडिया अनुप्रयोगहरूबाट डाटा माइन गर्न प्रयोग गरिन्छ।
3. **एरोस्पेस:** एरोस्पेस इन्जिनियरिङ् एउटा विस्तृत शब्द हो जसले अन्तरिक्ष यान र विमानमा भएका विकासहरूलाई समेट्छ। त्रुटि निदान, उच्च-प्रदर्शन स्वत-पाइलटिंग, विमान नियन्त्रण प्रणाली सुरक्षित, र मोडेलिङ कुञ्जी गतिशील सिमुलेशनहरू तंत्रिका सञ्जालहरूले कब्जा गरेका केही प्रमुख क्षेत्रहरू हुन्। समय ढिलाइ न्यूरल नेटवर्कहरू गैर-रैखिक समय गतिशील प्रणालीहरूको मोडेलिङको लागि नियोजित गर्न सकिन्छ।

### गहिरो शिक्षा (Deep Learning)

गहिरो शिक्षा नेटवर्कहरू धेरै तहहरू भएका तंत्रिका नेटवर्कहरू हुन्। स्तरित नेटवर्कले डेटाको व्यापक मात्रामा प्रशोधन गर्न सक्छ र नेटवर्कमा प्रत्येक लिङ्कको "वजन" निर्धारण गर्न सक्छ - उदाहरणका लागि, छवि पहिचान प्रणालीमा, तंत्रिका नेटवर्कका केही तहहरूले अनुहारको व्यक्तिगत विशेषताहरू पत्ता लगाउन सक्छन्, जस्तै आँखा, नाक, वा मुख, जबकि अर्को तहले ती सुविधाहरू अनुहारलाई संकेत गर्ने तरिकामा देखा पर्छन् कि भनेर बताउन सक्षम हुनेछ।

गहिरो शिक्षाको व्यावहारिक अनुप्रयोगहरू:
1. **स्वचालित पाठ जेनेरेसन -** पाठको कोर्पस सिकिन्छ, र यस मोडेलबाट, नयाँ पाठ उत्पन्न हुन्छ, शब्द-द्वारा-शब्द वा वर्ण-द्वारा-क्यारेक्टर। त्यसपछि यो मोडेल हिज्जे, विराम चिन्ह, र वाक्य बनाउन सिक्न सक्षम छ, वा यो शैली पनि कब्जा गर्न सक्छ।
2. **स्वास्थ्य सेवा -** विभिन्न रोगहरूको निदान र उपचार गर्न मद्दत गर्दछ।
3. **स्वचालित मेसिन अनुवाद -** एक भाषाका निश्चित शब्दहरू, वाक्यहरू, वा वाक्यांशहरूलाई अर्को भाषामा रूपान्तरण गरिन्छ (डीप लर्निङले पाठ र छविहरूको क्षेत्रमा शीर्ष परिणामहरू प्राप्त गर्दैछ)।
4. **छवि पहिचान -** छविहरूमा मानिसहरू र वस्तुहरूलाई पहिचान र पहिचान गर्नका साथै सामग्री र सन्दर्भ बुझ्दछ। यो क्षेत्र पहिले नै गेमिङ, रिटेल, पर्यटन, आदिमा प्रयोग भइरहेको छ।
५. **भूकम्पको भविष्यवाणी गर्ने -** कम्प्युटरलाई भिस्कोइलेस्टिक गणना गर्न सिकाउँछ, जुन भूकम्पको भविष्यवाणी गर्न प्रयोग गरिन्छ।

## [वेब टेक्नोलोजी](Web%20Technology/WebTechnology.md#web-tecnology)
वेब टेक्नोलोजीले इन्टरनेटमा विभिन्न प्रकारका उपकरणहरू बीच सञ्चारको प्रक्रियामा प्रयोग हुने विभिन्न उपकरण र प्रविधिहरूलाई बुझाउँछ। वेब ब्राउजर वेब पृष्ठहरू पहुँच गर्न प्रयोग गरिन्छ। वेब ब्राउजरहरूलाई इन्टरनेटमा पाठ, डेटा, चित्र, एनिमेसन र भिडियोहरू प्रदर्शन गर्ने कार्यक्रमहरूको रूपमा परिभाषित गर्न सकिन्छ। वर्ल्ड वाइड वेबमा हाइपरलिंक गरिएका स्रोतहरू वेब ब्राउजरहरूद्वारा प्रदान गरिएको सफ्टवेयर इन्टरफेसहरू प्रयोग गरेर पहुँच गर्न सकिन्छ।
### वेब प्रविधिलाई निम्न खण्डहरूमा वर्गीकृत गर्न सकिन्छ:
- वर्ल्ड वाइड वेब (WWW)
वर्ल्ड वाइड वेब धेरै फरक प्रविधिहरूमा आधारित छ: वेब ब्राउजरहरू, हाइपरटेक्स्ट मार्कअप भाषा (HTML), र हाइपरटेक्स्ट ट्रान्सफर प्रोटोकल (HTTP)।
- वेब ब्राउजर
वेब ब्राउजर www (वर्ल्ड वाइड वेब) को अन्वेषण गर्न को लागी एक अनुप्रयोग सफ्टवेयर हो। यसले सर्भर र क्लाइन्ट बीचको इन्टरफेस प्रदान गर्दछ र वेब कागजात र सेवाहरूको लागि सर्भरलाई अनुरोध गर्दछ।
- वेब सर्भर
वेब सर्भर एक प्रोग्राम हो जसले प्रयोगकर्ताहरूको नेटवर्क अनुरोधहरू प्रशोधन गर्दछ र तिनीहरूलाई वेब पृष्ठहरू सिर्जना गर्ने फाइलहरूसँग सेवा गर्दछ। यो एक्सचेन्ज हाइपरटेक्स्ट ट्रान्सफर प्रोटोकल (HTTP) को प्रयोग गरेर हुन्छ।
- वेब पृष्ठहरू
वेबपेज एक डिजिटल कागजात हो जुन वर्ल्ड वाइड वेबमा लिङ्क गरिएको छ र वेब ब्राउजर भएको इन्टरनेटमा जडान भएका जो कोहीले हेर्न मिल्छ।
- वेब विकास
वेब विकासले वेबसाइटहरूको निर्माण, सिर्जना र रखरखावलाई बुझाउँछ। यसले वेब डिजाइन, वेब प्रकाशन, वेब प्रोग्रामिङ, र डाटाबेस व्यवस्थापन जस्ता पक्षहरू समावेश गर्दछ। यो इन्टरनेटमा काम गर्ने एप्लिकेसनको सिर्जना हो, अर्थात् वेबसाइटहरू।
### वेब विकासलाई दुई तरिकामा वर्गीकृत गर्न सकिन्छ:
### Frontend विकास
वेबसाइटको भाग जहाँ प्रयोगकर्ताले प्रत्यक्ष अन्तरक्रिया गर्दछ अगाडिको अन्त्य भनिन्छ। यसलाई अनुप्रयोगको 'ग्राहक पक्ष' पनि भनिन्छ।
### ब्याकएन्ड विकास
ब्याकइन्ड वेबसाइटको सर्भर साइड हो। यो वेबसाइटको अंश हो जुन प्रयोगकर्ताहरूले हेर्न र अन्तरक्रिया गर्न सक्दैनन्। यो सफ्टवेयरको अंश हो जुन प्रयोगकर्ताहरूसँग प्रत्यक्ष सम्पर्कमा आउँदैन। यो डाटा भण्डारण र व्यवस्थित गर्न प्रयोग गरिन्छ।


## [नेटवर्किङ](Networking/readme.md#networking)
कम्प्युटर नेटवर्क भनेको नेटवर्क नोडहरूमा अवस्थित वा उपलब्ध गराइएका कम्प्युटरहरू साझेदारी गर्ने स्रोतहरूको सेट हो। कम्प्युटरहरूले एकअर्कासँग सञ्चार गर्न डिजिटल इन्टरकनेक्सनहरूमा साझा संचार प्रोटोकलहरू प्रयोग गर्छन्। यी अन्तरसम्बन्धहरू भौतिक रूपमा तार, अप्टिकल, र वायरलेस रेडियो-फ्रिक्वेन्सी विधिहरूमा आधारित दूरसञ्चार नेटवर्क प्रविधिहरू मिलेर बनेका छन् जुन विभिन्न नेटवर्क टोपोलोजीहरूमा व्यवस्थित गर्न सकिन्छ।

कम्प्युटर नेटवर्कको नोडहरूमा व्यक्तिगत कम्प्युटरहरू, सर्भरहरू, नेटवर्किङ हार्डवेयरहरू, वा अन्य विशेष वा सामान्य-उद्देश्य होस्टहरू समावेश हुन सक्छन्। तिनीहरू नेटवर्क ठेगानाहरूद्वारा पहिचान गरिएका छन् र होस्टनामहरू हुन सक्छन्। होस्टनामहरू नोडहरूका लागि यादगार लेबलको रूपमा काम गर्छन्, प्रारम्भिक असाइनमेन्ट पछि विरलै परिवर्तन हुन्छ। नेटवर्क ठेगानाहरू इन्टरनेट प्रोटोकल जस्ता सञ्चार प्रोटोकलहरूद्वारा नोडहरू पत्ता लगाउन र पहिचान गर्नका लागि सेवा गर्दछ।

कम्प्यूटर सञ्जालहरूलाई धेरै मापदण्डहरूद्वारा वर्गीकृत गर्न सकिन्छ, जसमा सङ्केतहरू बोक्न प्रयोग गरिने प्रसारण माध्यम, ब्यान्डविथ, सञ्जाल ट्राफिक व्यवस्थित गर्न सञ्चार प्रोटोकलहरू, सञ्जालको आकार, टोपोलोजी, ट्राफिक नियन्त्रण संयन्त्र, र संगठनात्मक अभिप्राय।

### नेटवर्किङका प्रकारहरू
कम्प्युटर नेटवर्किङका दुई प्राथमिक प्रकारहरू छन्:
- वायर्ड नेटवर्किङ: तारयुक्त नेटवर्किङले नोडहरू बीचको यातायातको लागि भौतिक माध्यमको प्रयोग गर्न आवश्यक छ। कपर-आधारित इथरनेट केबलिङ, यसको कम लागत र स्थायित्वको कारण लोकप्रिय, सामान्यतया व्यवसाय र घरहरूमा डिजिटल संचारको लागि प्रयोग गरिन्छ। वैकल्पिक रूपमा, अप्टिकल फाइबर धेरै टाढा र छिटो गतिमा डाटा ढुवानी गर्न प्रयोग गरिन्छ, तर यसमा धेरै ट्रेडअफहरू छन्, उच्च लागत र अधिक कमजोर घटकहरू सहित।
- ताररहित सञ्जाल: ताररहित सञ्जालले रेडियो तरंगहरू हावामा डाटा ढुवानी गर्न प्रयोग गर्दछ, यन्त्रहरूलाई कुनै पनि केबल बिना नेटवर्कमा जडान गर्न सक्षम बनाउँछ। ताररहित ल्यानहरू वायरलेस नेटवर्किङको सबैभन्दा प्रसिद्ध र व्यापक रूपमा प्रयोग गरिएको रूप हो। विकल्पहरूमा माइक्रोवेभ, स्याटेलाइट, सेलुलर र ब्लुटुथ समावेश छन्।
## OSI मोडेल
OSI भनेको **Open Systems Interconnection** हो। यसलाई ISO - **मानकीकरणका लागि अन्तर्राष्ट्रिय संगठन**' वर्ष 1984 मा विकसित गरिएको थियो। यो एक 7-तह वास्तुकला हो जसमा प्रत्येक तहमा प्रदर्शन गर्नको लागि विशिष्ट कार्यक्षमता हुन्छ। यी सबै सात तहहरूले विश्वभरि एक व्यक्तिबाट अर्कोमा डाटा हस्तान्तरण गर्न सहयोगी रूपमा काम गर्छन्।

#### **१\। भौतिक  तह (तह १ Physical Layer):**

OSI सन्दर्भ मोडेलको सबैभन्दा तल्लो तह भौतिक तह हो। यो यन्त्रहरू बीचको वास्तविक भौतिक जडानको लागि जिम्मेवार छ। भौतिक तहले **बिट्सको रूपमा जानकारी समावेश गर्दछ।** यो एक नोडबाट अर्को नोडमा व्यक्तिगत बिटहरू प्रसारण गर्न जिम्मेवार छ। डाटा प्राप्त गर्दा, यो तहले प्राप्त सिग्नल प्राप्त गर्नेछ र यसलाई 0s र 1s मा रूपान्तरण गर्नेछ र तिनीहरूलाई डेटा लिङ्क तहमा पठाउनेछ, जसले फ्रेमलाई एकसाथ फिर्ता राख्नेछ।

![](Networking/OSI%20Model/img/computer-network-osi-model-layers-bits.png)

भौतिक तहका कार्यहरू निम्नानुसार छन्:

1. **बिट सिंक्रोनाइजेसन:** भौतिक तहले घडी प्रदान गरेर बिट्सको सिङ्क्रोनाइजेसन प्रदान गर्दछ। यो घडीले प्रेषक र प्रापक दुवैलाई नियन्त्रण गर्छ यसरी बिट स्तरमा सिङ्क्रोनाइजेसन प्रदान गर्दछ।
2. **बिट दर नियन्त्रण:** भौतिक तहले प्रसारण दर पनि परिभाषित गर्दछ, अर्थात्, प्रति सेकेन्ड पठाइएका बिटहरूको संख्या।
3. **भौतिक टोपोलोजीहरू:** भौतिक तहले नेटवर्कमा कसरी विभिन्न यन्त्रहरू/नोडहरू व्यवस्थित हुन्छन्, जस्तै, बस, तारा, वा जाल टोपोलोजी निर्दिष्ट गर्दछ।
4. **ट्रान्समिशन मोड:** भौतिक तहले दुई जडान गरिएका यन्त्रहरू बीच डाटा कसरी प्रवाह हुन्छ भनेर पनि परिभाषित गर्दछ। सम्भावित विभिन्न प्रसारण मोडहरू सिम्प्लेक्स, हाफ डुप्लेक्स र फुल डुप्लेक्स हुन्।

#### **२\। डाटा लिङ्क तह (DLL) (लेयर २):**

डाटा लिङ्क तह सन्देशको नोड-टू-नोड डेलिभरीको लागि जिम्मेवार छ। यस तहको मुख्य कार्य भनेको भौतिक तहमा एक नोडबाट अर्को नोडमा डेटा स्थानान्तरण त्रुटिरहित छ भनी सुनिश्चित गर्नु हो। जब एक प्याकेट नेटवर्कमा आइपुग्छ, यसको MAC ठेगाना प्रयोग गरेर होस्टमा प्रसारण गर्ने जिम्मेवारी DLL को हो।
डाटा लिङ्क तह दुई उप-तहहरूमा विभाजित छ:

1. तार्किक लिङ्क नियन्त्रण (Logical Link Control- LLC)
2. मिडिया पहुँच नियन्त्रण (Media Access Control - MAC)

नेटवर्क तहबाट प्राप्त प्याकेटलाई NIC (नेटवर्क इन्टरफेस कार्ड) को फ्रेम साइजको आधारमा थप फ्रेमहरूमा विभाजन गरिएको छ। DLL ले हेडरमा प्रेषक र प्रापकको MAC ठेगाना पनि समावेश गर्दछ।

रिसिभरको MAC ठेगाना तारमा ARP (ठेगाना रिजोल्युसन प्रोटोकल) अनुरोध राखेर प्राप्त गरिन्छ, "त्यो IP ठेगाना कसको छ?" र गन्तव्य होस्टले यसको MAC ठेगानाको साथ जवाफ दिनेछ।

![](Networking/OSI%20Model/img/computer-network-osi-model-layers-framing.png)

डाटा लिङ्क तहका कार्यहरू हुन्:

1. **फ्रेमिङ:** फ्रेमिङ डाटा लिङ्क तहको कार्य हो। यसले प्रेषकलाई प्राप्तकर्ताको लागि अर्थपूर्ण बिट्सको सेट प्रसारण गर्ने तरिका प्रदान गर्दछ। यो फ्रेमको सुरु र अन्त्यमा विशेष बिट ढाँचाहरू संलग्न गरेर पूरा गर्न सकिन्छ।
2. **भौतिक ठेगाना:** फ्रेमहरू सिर्जना गरेपछि, डेटा लिङ्क तहले प्रत्येक फ्रेमको हेडरमा प्रेषक र/वा प्राप्तकर्ताको भौतिक ठेगानाहरू (MAC ठेगानाहरू) थप्छ।
3. **त्रुटि नियन्त्रण:** डाटा लिङ्क तहले त्रुटि नियन्त्रणको संयन्त्र प्रदान गर्दछ जसमा यसले क्षतिग्रस्त वा हराएको फ्रेमहरू पत्ता लगाउँछ र पुन: प्रसारण गर्दछ।
4. **प्रवाह नियन्त्रण:** डाटा दर दुवै पक्षमा स्थिर हुनुपर्छ अन्यथा डाटा भ्रष्ट हुन सक्छ; यसरी, प्रवाह नियन्त्रणले स्वीकृति प्राप्त गर्नु अघि पठाउन सकिने डाटाको मात्रालाई समन्वय गर्दछ।
5. **पहुँच नियन्त्रण:** जब एकल सञ्चार च्यानल धेरै यन्त्रहरूद्वारा साझा गरिन्छ, डेटा लिङ्क तहको MAC उप-तहले कुन यन्त्रले तोकिएको समयमा च्यानलमा नियन्त्रण गर्छ भनेर निर्धारण गर्न मद्दत गर्छ।

#### **३\। नेटवर्क तह (तह 3):**

नेटवर्क तहले विभिन्न नेटवर्कहरूमा अवस्थित एक होस्टबाट अर्कोमा डाटा प्रसारणको लागि काम गर्दछ। यसले प्याकेट राउटिङको पनि ख्याल राख्छ, अर्थात् उपलब्ध मार्गहरूको सङ्ख्याबाट प्याकेट पठाउनको लागि सबैभन्दा छोटो मार्गको चयन। प्रेषक र प्रापकको आईपी ठेगानाहरू नेटवर्क तहद्वारा हेडरमा राखिन्छन्।

नेटवर्क तहका कार्यहरू निम्न हुन्:

1. **रुटिङ्:** नेटवर्क तह प्रोटोकलहरूले स्रोतबाट गन्तव्यसम्म कुन रुट उपयुक्त छ भनी निर्धारण गर्छ। नेटवर्क तहको यो प्रकार्यलाई राउटिङ भनिन्छ।
2. **तार्किक ठेगाना:** इन्टरनेटवर्कमा प्रत्येक उपकरणलाई विशिष्ट रूपमा पहिचान गर्न, नेटवर्क तहले ठेगाना योजना परिभाषित गर्दछ। प्रेषक र प्रापकको आईपी ठेगानाहरू नेटवर्क तहद्वारा हेडरमा राखिन्छन्। यस्तो ठेगानाले प्रत्येक उपकरणलाई अद्वितीय र विश्वव्यापी रूपमा फरक पार्छ।

## [इन्टरनेट](Internet/readme.md#internet)
इन्टरनेट अन्तरसम्बन्धित कम्प्युटर सञ्जालहरूको विश्वव्यापी प्रणाली हो जसले विश्वभरका अरबौं प्रयोगकर्ताहरूलाई सेवा दिन मानक इन्टरनेट प्रोटोकल सुइट ([TCP/IP](Networking/readme.md#tcptransmission-control-protocol)) प्रयोग गर्दछ। यो नेटवर्कको सञ्जाल हो जसमा लाखौं निजी, सार्वजनिक, शैक्षिक, व्यापार, र स्थानीयदेखि विश्वव्यापी दायराका सरकारी सञ्जालहरू छन् जुन इलेक्ट्रोनिक, वायरलेस, र अप्टिकल नेटवर्किङ टेक्नोलोजीहरूको फराकिलो एरेद्वारा जोडिएको छ। इन्टरनेटले सूचना स्रोत र सेवाहरूको विस्तृत दायरा बोक्छ, जस्तै अन्तरलिङ्क गरिएका हाइपरटेक्स्ट कागजातहरू र वर्ल्ड वाइड वेबका अनुप्रयोगहरू ([WWW](Internet/readme.md#world-wide-web-www)) र इमेल समर्थन गर्ने पूर्वाधार।

### [वर्ल्ड वाइड वेब (WWW)](Internet/readme.md#world-wide-web-www)
वर्ल्ड वाइड वेब (WWW) एक सूचना स्थान हो जहाँ कागजातहरू र अन्य वेब स्रोतहरू युनिफर्म रिसोर्स लोकेटरहरू (URL हरू) द्वारा पहिचान गरिन्छ, हाइपरटेक्स्ट लिङ्कहरूद्वारा जोडिएको, र इन्टरनेट मार्फत पहुँचयोग्य हुन्छ। अङ्ग्रेजी वैज्ञानिक टिम बर्नर्स-लीले सन् १९८९ मा वर्ल्ड वाइड वेबको आविष्कार गरेका थिए। उनले स्विट्जरल्याण्डको CERN मा कार्यरत हुँदा सन् १९९० मा पहिलो वेब ब्राउजर लेखेका थिए। ब्राउजर 1991 मा CERN बाहिर जारी गरिएको थियो, पहिले जनवरी 1991 मा सुरु हुने अन्य अनुसन्धान संस्थाहरूमा र अगस्त 1991 मा इन्टरनेटमा सामान्य जनताको लागि।

### [इन्टरनेट प्रोटोकल (IP)](Internet/readme.md#internet-protocol-ip)
इन्टरनेट प्रोटोकल (आईपी) एक प्रोटोकल हो, वा नियमहरूको सेट, डेटाको प्याकेटहरू राउटिंग र ठेगानाको लागि ताकि तिनीहरू नेटवर्कहरूमा यात्रा गर्न र सही गन्तव्यमा पुग्न सकून्। इन्टरनेट पार गर्ने डाटालाई साना टुक्राहरूमा विभाजन गरिन्छ जसलाई प्याकेट भनिन्छ।

## [डाटाबेस व्यवस्थापन प्रणाली]()
डाटाबेस भनेको के हो?
-------------------

एक डाटाबेस सम्बन्धित डाटा को एक संग्रह हो जुन वास्तविक दुनिया को केहि पक्ष को प्रतिनिधित्व गर्दछ। डाटाबेस प्रणाली निश्चित कार्यको लागि डाटाको साथ निर्माण र आबादीको लागि डिजाइन गरिएको हो।

DBMS भनेको के हो?
--------------

**डाटाबेस व्यवस्थापन प्रणाली (DBMS)** उपयुक्त सुरक्षा उपायहरू विचार गर्दा प्रयोगकर्ताहरूको डाटा भण्डारण र पुन: प्राप्त गर्न सफ्टवेयर हो। यसले डाटाबेसलाई हेरफेर गर्ने कार्यक्रमहरूको समूह समावेश गर्दछ। DBMS ले एप्लिकेसनबाट डाटाको अनुरोध स्वीकार गर्छ र अपरेटिङ सिस्टमलाई निर्दिष्ट डाटा उपलब्ध गराउन निर्देशन दिन्छ। ठूला प्रणालीहरूमा, DBMS ले प्रयोगकर्ताहरू र अन्य तेस्रो-पक्ष सफ्टवेयर भण्डारण र डेटा पुन: प्राप्त गर्न मद्दत गर्दछ।

DBMS ले प्रयोगकर्ताहरूलाई उनीहरूको आवश्यकता अनुसार डाटाबेसहरू सिर्जना गर्न अनुमति दिन्छ। "DBMS" शब्दले डाटाबेस र अन्य अनुप्रयोग कार्यक्रमहरूको प्रयोग समावेश गर्दछ। यसले डाटा र सफ्टवेयर अनुप्रयोग बीचको इन्टरफेस प्रदान गर्दछ।

DBMS को उदाहरण
------------------

युनिभर्सिटी डाटाबेसको एउटा साधारण उदाहरण हेरौं। यो डाटाबेसले विश्वविद्यालयको वातावरणमा विद्यार्थी, पाठ्यक्रम र ग्रेडहरू बारे जानकारी राख्छ। डाटाबेस पाँच फाइलहरूमा व्यवस्थित गरिएको छ:

* विद्यार्थी फाइलले प्रत्येक विद्यार्थीको डाटा भण्डारण गर्दछ
* COURSE फाइल स्टोरहरूले प्रत्येक पाठ्यक्रममा डाटा समावेश गर्दछ।
* SECTION ले विशेष पाठ्यक्रममा खण्डहरूको बारेमा जानकारी भण्डारण गर्दछ।
* GRADE फाइलले विद्यार्थीहरूले विभिन्न खण्डहरूमा प्राप्त गरेका ग्रेडहरू भण्डारण गर्छ
* TUTOR फाइलले प्रत्येक प्रोफेसरको बारेमा जानकारी समावेश गर्दछ।

DBMS परिभाषित गर्न:

* हामीले प्रत्येक रेकर्डमा भण्डारण गरिने विभिन्न प्रकारका डाटा तत्वहरूलाई परिभाषित गरेर प्रत्येक फाइलको रेकर्डको संरचना निर्दिष्ट गर्न आवश्यक छ।
* हामी डेटा वस्तुको मानहरू प्रतिनिधित्व गर्न कोडिङ योजना पनि प्रयोग गर्न सक्छौं।
* मूलतया, तपाईको डाटाबेसमा विभिन्न तालिकाहरू बीच परिभाषित विदेशी कुञ्जीसहित पाँचवटा तालिकाहरू हुनेछन्।

DBMS को इतिहास
---------------

यहाँ इतिहासबाट महत्त्वपूर्ण स्थलचिन्हहरू छन्:

* 1960 - चार्ल्स बाचम्यानले पहिलो DBMS प्रणाली डिजाइन गरे
* 1970 - Codd ले IBM को सूचना व्यवस्थापन प्रणाली (IMS) पेश गर्यो।
* 1976- पिटर चेनले एकाइ-सम्बन्ध मोडेलको रचना र परिभाषित गरे, जसलाई ER मोडेल पनि भनिन्छ।
* 1980 - रिलेशनल मोडेल एक व्यापक रूपमा स्वीकार गरिएको डाटाबेस घटक हुन्छ
* 1985- वस्तु-उन्मुख DBMS विकास।
* 1990s- सम्बन्धगत DBMS मा वस्तु अभिमुखीकरण को समावेश।
* 1991- Microsoft ले MS पहुँच पठाउँछ, एक व्यक्तिगत DBMS जसले अन्य सबै व्यक्तिगत DBMS उत्पादनहरूलाई विस्थापित गर्दछ।
* 1995: पहिलो इन्टरनेट डाटाबेस अनुप्रयोगहरू
* 1997: XML डाटाबेस प्रशोधनमा लागू गरियो। धेरै विक्रेताहरूले XML लाई DBMS उत्पादनहरूमा एकीकृत गर्न थाल्छन्।

DBMS को विशेषताहरू
--------------------------------------------------

यहाँ डाटाबेस व्यवस्थापन प्रणालीका विशेषताहरू र गुणहरू छन्:

* सुरक्षा प्रदान गर्दछ र अनावश्यकता हटाउँछ
* डाटाबेस प्रणालीको प्रकृति आत्म-वर्णन
* कार्यक्रम र डाटा अमूर्त बीच इन्सुलेशन
* डाटाको बहु दृश्यहरूको समर्थन
* डाटा साझेदारी र बहु-प्रयोगकर्ता लेनदेन प्रशोधन
* डाटाबेस प्रबन्धन सफ्टवेयरले संस्थाहरू र तिनीहरू बीचको सम्बन्धहरूलाई तालिकाहरू बनाउन अनुमति दिन्छ।
* यसले ACID अवधारणा (Atomicity, Consistency, Isolation, and Durability) लाई पछ्याउँछ।
* DBMS ले बहु-प्रयोगकर्ता वातावरणलाई समर्थन गर्दछ जसले प्रयोगकर्ताहरूलाई समानान्तरमा डेटा पहुँच र हेरफेर गर्न अनुमति दिन्छ।

लोकप्रिय DBMS सफ्टवेयर
----------------------------------

यहाँ केहि लोकप्रिय DBMS प्रणालीहरूको सूची छ:

* MySQL
* माइक्रोसफ्ट पहुँच
* ओरेकल
* PostgreSQL
* dBASE
* FoxPro
* SQLite
* IBM DB2
* LibreOffice Base
* मारियाडीबी
* माइक्रोसफ्ट SQL सर्भर आदि।

## [क्रिप्टोग्राफी](Cryptography/readme.md#cryptography)
क्रिप्टोग्राफी डाटा र संचार सुरक्षित गर्ने एक प्रविधि हो। यो कोडहरूको प्रयोग मार्फत सूचना र सञ्चारको सुरक्षा गर्ने एक विधि हो ताकि जानकारीको उद्देश्यले मात्र यसलाई पढ्न र प्रशोधन गर्न सकून्। क्रिप्टोग्राफी ट्रान्जिटमा, आराममा, र प्रयोगमा डाटा सुरक्षित गर्न प्रयोग गरिन्छ। उपसर्ग _crypt_ को अर्थ "लुकेको" वा "गोप्य", र प्रत्यय _graphy_ को अर्थ "लेखन" हो।

### क्रिप्टोग्राफीका प्रकारहरू
त्यहाँ दुई प्रकारका क्रिप्टोग्राफी छन्:
1. [सिमेट्रिक क्रिप्टोग्राफी](Cryptography/readme.md#symmetric-cryptography)
2. [एसिमेट्रिक क्रिप्टोग्राफी](Cryptography/readme.md#asymmetric-cryptography)

### [क्रिप्टो मुद्रा](Cryptography/CryptoCurrency/readme.md#crypto-currency)
क्रिप्टोकरेन्सी एक डिजिटल मुद्रा हो जसमा मुद्राको एकाइहरूको उत्पादनलाई विनियमित गर्न र केन्द्रीय बैंकबाट स्वतन्त्र रूपमा सञ्चालन, कोषको स्थानान्तरण प्रमाणित गर्न इन्क्रिप्शन प्रविधिहरू प्रयोग गरिन्छ। क्रिप्टोकरेन्सीहरूले केन्द्रीकृत डिजिटल मुद्रा र केन्द्रीय बैंकिङ प्रणालीको विपरीत विकेन्द्रीकृत नियन्त्रण प्रयोग गर्दछ। प्रत्येक क्रिप्टोकरन्सीको विकेन्द्रीकृत नियन्त्रणले वितरण गरिएको लेजर टेक्नोलोजी, सामान्यतया ब्लकचेन, जसले सार्वजनिक वित्तीय लेनदेन डाटाबेसको रूपमा काम गर्दछ। क्रिप्टोकरन्सीको परिभाषित विशेषता, र यसको सबैभन्दा मनमोहक आकर्षण, यसको जैविक प्रकृति हो; यो कुनै पनि केन्द्रीय प्राधिकरण द्वारा जारी गरिएको छैन, यसलाई सैद्धान्तिक रूपमा सरकारी हस्तक्षेप वा हेरफेरबाट प्रतिरक्षा प्रदान गर्दछ।

## क्रिप्टो मुद्राका प्रकारहरू निम्नानुसार छन्:
1. [कार्यको प्रमाण](Cryptography/CryptoCurrency/ProofOfWork/readme.md#proof-of-work)
२. [प्रुफ अफ स्टेक](Cryptography/CryptoCurrency/ProofOfStake/readme.md#proof-of-stake)



### _सबैभन्दा लोकप्रिय क्रिप्टो मुद्राहरू निम्नानुसार छन्:_
1. [Bitcoin](Cryptography/CryptoCurrency/ProofOfWork/Bitcoin/readme.md#bitcoin)
2. [एथरियम](Cryptography/CryptoCurrency/ProofOfStake/Ethereum/readme.md#ethereum)
3. [Litecoin](Cryptography/CryptoCurrency/ProofOfWork/Litecoin/readme.md#litecoin)
4. [Cardano](Cryptography/CryptoCurrency/ProofOfStake/Cardano/readme.md#cardano)
५. [डोगेकोइन](Cryptography/CryptoCurrency/ProofOfWork/Dogecoin/readme.md#dogecoin)



## गणनाको सिद्धान्त
सैद्धान्तिक कम्प्युटर विज्ञान र गणितमा, गणनाको सिद्धान्त एउटा शाखा हो जसले एल्गोरिदम प्रयोग गरेर गणनाको मोडेलमा कस्ता समस्याहरू समाधान गर्न सकिन्छ, तिनीहरूलाई कसरी कुशलतापूर्वक समाधान गर्न सकिन्छ, वा कुन डिग्रीमा (जस्तै, सटीक समाधानहरू बनाम अनुमानित समाधानहरू) )। क्षेत्रलाई तीन प्रमुख शाखाहरूमा विभाजन गरिएको छ: स्वचालित सिद्धान्त र औपचारिक भाषाहरू, कम्प्यूटेबिलिटी सिद्धान्त, र कम्प्युटेसनल जटिलता सिद्धान्त, जुन प्रश्नद्वारा जोडिएको छ: "कम्प्यूटरका आधारभूत क्षमताहरू र सीमाहरू के हुन्?"।

### अटोमेटा थ्योरी
अटोमेटा सिद्धान्त अमूर्त मेसिन र अटोमेटाको अध्ययन हो, साथै तिनीहरूको प्रयोग गरेर समाधान गर्न सकिने कम्प्युटेसनल समस्याहरू। यो सैद्धान्तिक कम्प्युटर विज्ञान मा एक सिद्धान्त हो। automata शब्द ग्रीक शब्द αὐτόματος बाट आएको हो, जसको अर्थ "आत्म-अभिनय, स्व-इच्छा, स्व-चलिरहेको" हो। एक automaton (बहुवचन मा automata) एक अमूर्त स्व-चालित कम्प्युटिङ उपकरण हो जसले स्वचालित रूपमा सञ्चालनको पूर्वनिर्धारित अनुक्रम पछ्याउँछ। राज्यहरूको एक सीमित संख्या भएको अटोमेटनलाई Finite Automaton (FA) वा Finite-State Machine (FSM) भनिन्छ। दायाँको चित्रले सीमित-राज्य मेसिनलाई चित्रण गर्दछ, जुन एक प्रसिद्ध प्रकारको अटोमेटन हो। यो अटोमेटनमा राज्यहरू (वृत्तहरूद्वारा चित्रमा प्रतिनिधित्व गरिएको) र ट्रान्जिसनहरू (तीरहरूद्वारा प्रतिनिधित्व) हुन्छन्। अटोमेटनले इनपुटको प्रतीक देखेपछि, यसले आफ्नो ट्रान्जिसन प्रकार्य अनुसार अर्को राज्यमा ट्रान्जिसन (वा जम्प) गर्छ, जसले अघिल्लो अवस्था र हालको इनपुट प्रतीकलाई यसको तर्कको रूपमा लिन्छ।


### औपचारिक भाषाहरू
तर्कशास्त्र, गणित, कम्प्युटर विज्ञान र भाषाविज्ञानमा, औपचारिक भाषामा शब्दहरू समावेश हुन्छन् जसको अक्षरहरू वर्णमालाबाट लिइन्छ र नियमहरूको निश्चित सेट अनुसार राम्रोसँग बनाइएको हुन्छ।

औपचारिक भाषाको वर्णमालामा प्रतीक, अक्षर वा टोकनहरू हुन्छन् जुन भाषाको स्ट्रिङमा जोडिन्छन्। यस वर्णमालाका प्रतीकहरूबाट जोडिएका प्रत्येक स्ट्रिङलाई शब्द भनिन्छ, र कुनै विशेष औपचारिक भाषासँग सम्बन्धित शब्दहरूलाई कहिलेकाहीँ राम्रोसँग बनेका शब्दहरू वा राम्रोसँग बनाइएको सूत्रहरू भनिन्छ। एक औपचारिक भाषा प्रायः औपचारिक व्याकरण प्रयोग गरी परिभाषित गरिन्छ, जस्तै नियमित व्याकरण वा सन्दर्भ-रहित व्याकरण, जसमा यसको गठन नियमहरू हुन्छन्।

कम्प्युटर विज्ञानमा, औपचारिक भाषाहरू प्रयोग गरिन्छ, प्रोग्रामिङ भाषाहरूको व्याकरण र प्राकृतिक भाषाहरूको उपसमूहहरूको औपचारिक संस्करणहरू परिभाषित गर्नको लागि आधारको रूपमा, जसमा भाषाका शब्दहरूले विशेष अर्थ वा अर्थशास्त्रसँग सम्बन्धित अवधारणाहरू प्रतिनिधित्व गर्दछ। कम्प्युटेशनल जटिलता सिद्धान्तमा, निर्णय समस्याहरू सामान्यतया औपचारिक भाषाहरूको रूपमा परिभाषित गरिन्छ र जटिलता वर्गहरूलाई औपचारिक भाषाहरूको सेटको रूपमा परिभाषित गरिन्छ जुन सीमित कम्प्यूटेशनल शक्ति भएका मेसिनहरूद्वारा पार्स गर्न सकिन्छ। तर्क र गणितको जगमा, औपचारिक भाषाहरू स्वयंसिद्ध प्रणालीहरूको वाक्यविन्यास प्रतिनिधित्व गर्न प्रयोग गरिन्छ, र गणितीय औपचारिकता भनेको दर्शन हो कि सबै गणितलाई यस तरिकाले औपचारिक भाषाहरूको सिन्ट्याक्टिक हेरफेरमा कम गर्न सकिन्छ।

### कम्प्युटिबिलिटी थ्योरी
कम्प्युटेबिलिटी थ्योरी, जसलाई पुनरावृत्ति सिद्धान्त पनि भनिन्छ, गणितीय तर्क, कम्प्यूटर विज्ञान, र गणनाको सिद्धान्तको एक शाखा हो जुन 1930 मा कम्प्युटेबल प्रकार्यहरू र ट्युरिङ डिग्रीहरूको अध्ययनबाट उत्पन्न भएको थियो। सामान्यीकृत कम्प्युटेबिलिटी र डेफिनिबिलिटीको अध्ययन समावेश गर्न यस क्षेत्रलाई विस्तार गरिएको छ। यी क्षेत्रहरूमा, कम्प्युटिबिलिटी सिद्धान्त प्रमाण सिद्धान्त र प्रभावकारी वर्णनात्मक सेट सिद्धान्तसँग ओभरल्याप हुन्छ।

### कम्प्यूटेशनल जटिलता सिद्धान्त
सैद्धान्तिक कम्प्युटर विज्ञान र गणितमा, कम्प्युटेशनल जटिलता सिद्धान्तले कम्प्युटेशनल समस्याहरूलाई तिनीहरूको स्रोत उपयोगको आधारमा वर्गीकरण गर्न र यी कक्षाहरूलाई एकअर्कासँग सम्बन्धित गर्नमा केन्द्रित हुन्छ। कम्प्युटेसनल समस्या कम्प्युटरद्वारा समाधान गर्ने कार्य हो। एल्गोरिदम जस्ता गणितीय चरणहरूको मेकानिकल अनुप्रयोगद्वारा गणना समस्या समाधान गर्न सकिन्छ।

समस्यालाई स्वाभाविक रूपमा गाह्रो मानिन्छ यदि यसको समाधानलाई महत्त्वपूर्ण स्रोतहरू चाहिन्छ, जुनसुकै एल्गोरिदम प्रयोग गरियो। सिद्धान्तले यी समस्याहरू अध्ययन गर्न गणनाको गणितीय मोडेलहरू प्रस्तुत गरेर र तिनीहरूको कम्प्युटेसनल जटिलता, अर्थात्, समय र भण्डारण जस्ता तिनीहरूलाई समाधान गर्न आवश्यक स्रोतहरूको संख्याको परिमाण निर्धारण गरेर यो अन्तर्ज्ञानलाई औपचारिक बनाउँछ। जटिलताका अन्य उपायहरू पनि प्रयोग गरिन्छ, जस्तै सञ्चारको मात्रा (संचार जटिलतामा प्रयोग गरिन्छ), सर्किटमा गेटहरूको संख्या (सर्किट जटिलतामा प्रयोग गरिन्छ), र प्रोसेसरहरूको संख्या (समानान्तर कम्प्युटिङमा प्रयोग गरिन्छ)। कम्प्युटेशनल जटिलता सिद्धान्तको एक भूमिका भनेको कम्प्युटरले के गर्न सक्छ र के गर्न सक्दैन भन्नेमा व्यावहारिक सीमाहरू निर्धारण गर्नु हो। P बनाम NP समस्या, सात सहस्राब्दी पुरस्कार समस्याहरू मध्ये एक, कम्प्युटेसनल जटिलताको क्षेत्रमा समर्पित छ।

सैद्धान्तिक कम्प्यूटर विज्ञानमा नजिकको सम्बन्धित क्षेत्रहरू एल्गोरिदम र कम्प्युटिबिलिटी सिद्धान्तको विश्लेषण हुन्। एल्गोरिदम र कम्प्युटेसनल जटिलता सिद्धान्तको विश्लेषण बीचको मुख्य भिन्नता भनेको समस्या समाधान गर्नको लागि एक विशेष एल्गोरिदम द्वारा आवश्यक स्रोतहरूको संख्याको विश्लेषण गर्न समर्पित छ, जबकि पछिल्लोले प्रयोग गर्न सकिने सबै सम्भावित एल्गोरिदमहरूको बारेमा थप सामान्य प्रश्न सोध्छ। एउटै समस्या समाधान गर्न। अझ स्पष्ट रूपमा, कम्प्युटेसनल जटिलता सिद्धान्तले समस्याहरूलाई वर्गीकृत गर्ने प्रयास गर्दछ जुन उचित रूपमा प्रतिबन्धित स्रोतहरूसँग हल गर्न सकिन्छ वा सकिँदैन। बदलामा, उपलब्ध स्रोतहरूमा प्रतिबन्ध लगाउनु भनेको कम्प्यूटेशनल जटिलतालाई कम्प्युटेबिलिटी सिद्धान्तबाट छुट्याउँछ: पछिल्लो सिद्धान्तले प्रश्न गर्छ कि कस्ता प्रकारका समस्याहरू, सिद्धान्तमा, एल्गोरिदमिक रूपमा समाधान गर्न सकिन्छ।



## Contributors

<!-- ALL-CONTRIBUTORS-LIST:START - Do not remove or modify this section -->
<!-- prettier-ignore-start -->
<!-- markdownlint-disable -->
<table>
  <tbody>
    <tr>
      <td align="center" valign="top" width="16.66%"><a href="http://safayat.me"><img src="https://avatars.githubusercontent.com/u/80335059?v=4?s=50" width="50px;" alt="Sifat"/><br /><sub><b>Sifat</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=shhossain" title="Code">💻</a> <a href="#content-shhossain" title="Content">🖋</a> <a href="https://github.com/shhossain/computer_science/commits?author=shhossain" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/Sabine91"><img src="https://avatars.githubusercontent.com/u/96158726?v=4?s=50" width="50px;" alt="Yuvraj Chauhan"/><br /><sub><b>Yuvraj Chauhan</b></sub></a><br /><a href="#content-Sabine91" title="Content">🖋</a> <a href="https://github.com/shhossain/computer_science/commits?author=Sabine91" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/Rajesh144142"><img src="https://avatars.githubusercontent.com/u/82487522?v=4?s=50" width="50px;" alt="Rajesh kumar halder"/><br /><sub><b>Rajesh kumar halder</b></sub></a><br /><a href="#content-Rajesh144142" title="Content">🖋</a> <a href="https://github.com/shhossain/computer_science/commits?author=Rajesh144142" title="Code">💻</a> <a href="https://github.com/shhossain/computer_science/commits?author=Rajesh144142" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="http://ishanmondal.me"><img src="https://avatars.githubusercontent.com/u/76674591?v=4?s=50" width="50px;" alt="Ishan Mondal"/><br /><sub><b>Ishan Mondal</b></sub></a><br /><a href="#content-ishan-im" title="Content">🖋</a> <a href="https://github.com/shhossain/computer_science/commits?author=ishan-im" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/Apoorva08102000"><img src="https://avatars.githubusercontent.com/u/91753868?v=4?s=50" width="50px;" alt="Apoorva08102000"/><br /><sub><b>Apoorva08102000</b></sub></a><br /><a href="#content-Apoorva08102000" title="Content">🖋</a> <a href="https://github.com/shhossain/computer_science/commits?author=Apoorva08102000" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/apoorva1823000"><img src="https://avatars.githubusercontent.com/u/71769587?v=4?s=50" width="50px;" alt="Apoorva .S. Mehta"/><br /><sub><b>Apoorva .S. Mehta</b></sub></a><br /><a href="#content-apoorva1823000" title="Content">🖋</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/utopian-coder"><img src="https://avatars.githubusercontent.com/u/66299782?v=4?s=50" width="50px;" alt="Imran Biswas"/><br /><sub><b>Imran Biswas</b></sub></a><br /><a href="#content-utopian-coder" title="Content">🖋</a> <a href="https://github.com/shhossain/computer_science/commits?author=utopian-coder" title="Code">💻</a> <a href="https://github.com/shhossain/computer_science/commits?author=utopian-coder" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/subrata-9999"><img src="https://avatars.githubusercontent.com/u/109057053?v=4?s=50" width="50px;" alt="Subrata Pramanik"/><br /><sub><b>Subrata Pramanik</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=subrata-9999" title="Code">💻</a> <a href="https://github.com/shhossain/computer_science/commits?author=subrata-9999" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://br.linkedin.com/in/samuelbratifavarin"><img src="https://avatars.githubusercontent.com/u/17628602?v=4?s=50" width="50px;" alt="Samuel Favarin"/><br /><sub><b>Samuel Favarin</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=SamuelBFavarin" title="Documentation">📖</a> <a href="https://github.com/shhossain/computer_science/commits?author=SamuelBFavarin" title="Code">💻</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/sahooabhipsa10"><img src="https://avatars.githubusercontent.com/u/99355886?v=4?s=50" width="50px;" alt="sahooabhipsa10"/><br /><sub><b>sahooabhipsa10</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=sahooabhipsa10" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/Sahilrao09"><img src="https://avatars.githubusercontent.com/u/88286056?v=4?s=50" width="50px;" alt="Sahil Rao"/><br /><sub><b>Sahil Rao</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=Sahilrao09" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/Code-N-Bug"><img src="https://avatars.githubusercontent.com/u/103832013?v=4?s=50" width="50px;" alt="K K Chowdhury"/><br /><sub><b>K K Chowdhury</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=Code-N-Bug" title="Code">💻</a> <a href="https://github.com/shhossain/computer_science/commits?author=Code-N-Bug" title="Documentation">📖</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="16.66%"><a href="https://manas6699.github.io/portfolio-website3.0/"><img src="https://avatars.githubusercontent.com/u/78929050?v=4?s=50" width="50px;" alt="Manas Baroi"/><br /><sub><b>Manas Baroi</b></sub></a><br /><a href="#example-manas6699" title="Examples">💡</a> <a href="https://github.com/shhossain/computer_science/commits?author=manas6699" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/kanaujiyaaditi"><img src="https://avatars.githubusercontent.com/u/94130073?v=4?s=50" width="50px;" alt="Aditi"/><br /><sub><b>Aditi</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=kanaujiyaaditi" title="Documentation">📖</a> <a href="#content-kanaujiyaaditi" title="Content">🖋</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/Talib-Hossain"><img src="https://avatars.githubusercontent.com/u/83373885?v=4?s=50" width="50px;" alt="Syed Talib Hossain"/><br /><sub><b>Syed Talib Hossain</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=Talib-Hossain" title="Code">💻</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/JaiMehrotra02"><img src="https://avatars.githubusercontent.com/u/94130223?v=4?s=50" width="50px;" alt="Jai Mehrotra"/><br /><sub><b>Jai Mehrotra</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=JaiMehrotra02" title="Documentation">📖</a> <a href="https://github.com/shhossain/computer_science/commits?author=JaiMehrotra02" title="Code">💻</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/ShuvamBag"><img src="https://avatars.githubusercontent.com/u/82321197?v=4?s=50" width="50px;" alt="Shuvam Bag"/><br /><sub><b>Shuvam Bag</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=ShuvamBag" title="Code">💻</a> <a href="https://github.com/shhossain/computer_science/commits?author=ShuvamBag" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/AbhijitTurate"><img src="https://avatars.githubusercontent.com/u/46615905?v=4?s=50" width="50px;" alt="Abhijit Turate"/><br /><sub><b>Abhijit Turate</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=AbhijitTurate" title="Code">💻</a> <a href="https://github.com/shhossain/computer_science/commits?author=AbhijitTurate" title="Documentation">📖</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/Jayesh2812"><img src="https://avatars.githubusercontent.com/u/52153715?v=4?s=50" width="50px;" alt="Jayesh Deorukhkar"/><br /><sub><b>Jayesh Deorukhkar</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=Jayesh2812" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/SohamDey80"><img src="https://avatars.githubusercontent.com/u/93932583?v=4?s=50" width="50px;" alt="JC Shankar"/><br /><sub><b>JC Shankar</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=SohamDey80" title="Code">💻</a> <a href="https://github.com/shhossain/computer_science/commits?author=SohamDey80" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/Subrata-Pramanik"><img src="https://avatars.githubusercontent.com/u/86642230?v=4?s=50" width="50px;" alt="Subrata Pramanik"/><br /><sub><b>Subrata Pramanik</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=Subrata-Pramanik" title="Code">💻</a> <a href="https://github.com/shhossain/computer_science/commits?author=Subrata-Pramanik" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/imams12"><img src="https://avatars.githubusercontent.com/u/59444865?v=4?s=50" width="50px;" alt="Imam Suyuti"/><br /><sub><b>Imam Suyuti</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=imams12" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/rahulmangla28"><img src="https://avatars.githubusercontent.com/u/93324315?v=4?s=50" width="50px;" alt="genius_koder"/><br /><sub><b>genius_koder</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=rahulmangla28" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://www.altafshaikh.ml"><img src="https://avatars.githubusercontent.com/u/26015187?v=4?s=50" width="50px;" alt="Altaf Shaikh"/><br /><sub><b>Altaf Shaikh</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=altafshaikh" title="Documentation">📖</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/rajdeepdas2000"><img src="https://avatars.githubusercontent.com/u/53941109?v=4?s=50" width="50px;" alt="Rajdeep Das"/><br /><sub><b>Rajdeep Das</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=rajdeepdas2000" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/its-red-eagle"><img src="https://avatars.githubusercontent.com/u/77643994?v=4?s=50" width="50px;" alt="Vikash Patel"/><br /><sub><b>Vikash Patel</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=its-red-eagle" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/alwenpy"><img src="https://avatars.githubusercontent.com/u/94129388?v=4?s=50" width="50px;" alt="Arvind Srivastav"/><br /><sub><b>Arvind Srivastav</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=alwenpy" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/Naprila"><img src="https://avatars.githubusercontent.com/u/85901005?v=4?s=50" width="50px;" alt="Manish Kr Prasad"/><br /><sub><b>Manish Kr Prasad</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=Naprila" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://linktr.ee/mohit_kushwaha"><img src="https://avatars.githubusercontent.com/u/73400792?v=4?s=50" width="50px;" alt="MOHIT KUMAR KUSHWAHA"/><br /><sub><b>MOHIT KUMAR KUSHWAHA</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=KimtVak8143" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/DryHitman"><img src="https://avatars.githubusercontent.com/u/116108787?v=4?s=50" width="50px;" alt="DryHitman"/><br /><sub><b>DryHitman</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=DryHitman" title="Documentation">📖</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/harshkulkarni17"><img src="https://avatars.githubusercontent.com/u/72391096?v=4?s=50" width="50px;" alt="Harsh Kulkarni"/><br /><sub><b>Harsh Kulkarni</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=harshkulkarni17" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/ATREAY"><img src="https://avatars.githubusercontent.com/u/66585295?v=4?s=50" width="50px;" alt="Atreay  Kukanur"/><br /><sub><b>Atreay  Kukanur</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=ATREAY" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://sreeharan.github.io"><img src="https://avatars.githubusercontent.com/u/62993067?v=4?s=50" width="50px;" alt="Sree Haran"/><br /><sub><b>Sree Haran</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=SreeHaran" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://www.linkedin.com/in/auro-saswat-raj-d05m07y2003/"><img src="https://avatars.githubusercontent.com/u/83534307?v=4?s=50" width="50px;" alt="Auro Saswat Raj"/><br /><sub><b>Auro Saswat Raj</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=geeky-auro" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/Aiyan-Faras"><img src="https://avatars.githubusercontent.com/u/55203889?v=4?s=50" width="50px;" alt="Aiyan Faras"/><br /><sub><b>Aiyan Faras</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=Aiyan-Faras" title="Documentation">📖</a> <a href="https://github.com/shhossain/computer_science/commits?author=Aiyan-Faras" title="Code">💻</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/PriyanshiDavid"><img src="https://avatars.githubusercontent.com/u/71930453?v=4?s=50" width="50px;" alt="Priyanshi David"/><br /><sub><b>Priyanshi David</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=PriyanshiDavid" title="Documentation">📖</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/ishancode-dev"><img src="https://avatars.githubusercontent.com/u/115942220?v=4?s=50" width="50px;" alt="Ishan Mondal"/><br /><sub><b>Ishan Mondal</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=ishancode-dev" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="http://expy.bio/NikhilShrivastava"><img src="https://avatars.githubusercontent.com/u/20610444?v=4?s=50" width="50px;" alt="Nikhil Shrivastava"/><br /><sub><b>Nikhil Shrivastava</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=NikhilShrivastava" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/deepshikha2708"><img src="https://avatars.githubusercontent.com/u/80972038?v=4?s=50" width="50px;" alt="deepshikha2708"/><br /><sub><b>deepshikha2708</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=deepshikha2708" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/rishiwardhan"><img src="https://avatars.githubusercontent.com/u/88772100?v=4?s=50" width="50px;" alt="L.RISHIWARDHAN"/><br /><sub><b>L.RISHIWARDHAN</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=rishiwardhan" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/DevTMK"><img src="https://avatars.githubusercontent.com/u/47377566?v=4?s=50" width="50px;" alt="Rahul RK"/><br /><sub><b>Rahul RK</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=DevTMK" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://www.linkedin.com/company/nscc-ggv/"><img src="https://avatars.githubusercontent.com/u/82573863?v=4?s=50" width="50px;" alt="Nishant Wankhade"/><br /><sub><b>Nishant Wankhade</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=NishantWankhade" title="Documentation">📖</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/pritika163"><img src="https://avatars.githubusercontent.com/u/102177744?v=4?s=50" width="50px;" alt="pritika163"/><br /><sub><b>pritika163</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=pritika163" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/AnjumanHasan"><img src="https://avatars.githubusercontent.com/u/82674743?v=4?s=50" width="50px;" alt="Anjuman Hasan"/><br /><sub><b>Anjuman Hasan</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=AnjumanHasan" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://linktr.ee/asthavarshney"><img src="https://avatars.githubusercontent.com/u/97240696?v=4?s=50" width="50px;" alt="Astha Varshney "/><br /><sub><b>Astha Varshney </b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=Asthavarshneyy" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/Gcettbdeveloper"><img src="https://avatars.githubusercontent.com/u/114204175?v=4?s=50" width="50px;" alt="Gcettbdeveloper"/><br /><sub><b>Gcettbdeveloper</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=Gcettbdeveloper" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://elston-website.web.app"><img src="https://avatars.githubusercontent.com/u/66341506?v=4?s=50" width="50px;" alt="Elston Tan"/><br /><sub><b>Elston Tan</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=Elstuhn" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/ShivanshDengla"><img src="https://avatars.githubusercontent.com/u/66008449?v=4?s=50" width="50px;" alt="Shivansh Dengla"/><br /><sub><b>Shivansh Dengla</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=ShivanshDengla" title="Documentation">📖</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="16.66%"><a href="https://www.tetricz.com"><img src="https://avatars.githubusercontent.com/u/49681400?v=4?s=50" width="50px;" alt="David Daniels"/><br /><sub><b>David Daniels</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=Tetricz" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/ayushverma14"><img src="https://avatars.githubusercontent.com/u/65187507?v=4?s=50" width="50px;" alt="ayushverma14"/><br /><sub><b>ayushverma14</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=ayushverma14" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://kontentkreator.tech"><img src="https://avatars.githubusercontent.com/u/70800059?v=4?s=50" width="50px;" alt="Pratik Rai"/><br /><sub><b>Pratik Rai</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=pratikkumar399" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/yash-ch"><img src="https://avatars.githubusercontent.com/u/66888087?v=4?s=50" width="50px;" alt="Yash"/><br /><sub><b>Yash</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=yash-ch" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/pranavyatnalkar"><img src="https://avatars.githubusercontent.com/u/84735288?v=4?s=50" width="50px;" alt="pranavyatnalkar"/><br /><sub><b>pranavyatnalkar</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=pranavyatnalkar" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/jeremiaaxel"><img src="https://avatars.githubusercontent.com/u/57858415?v=4?s=50" width="50px;" alt="Jeremia Axel"/><br /><sub><b>Jeremia Axel</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=jeremiaaxel" title="Documentation">📖</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="16.66%"><a href="https://in.linkedin.com/in/akhil-soni-9827181a1"><img src="https://avatars.githubusercontent.com/u/58397226?v=4?s=50" width="50px;" alt="Akhil Soni"/><br /><sub><b>Akhil Soni</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=akhil-maker" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/DevZahraShahid"><img src="https://avatars.githubusercontent.com/u/111266434?v=4?s=50" width="50px;" alt="Zahra Shahid"/><br /><sub><b>Zahra Shahid</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=DevZahraShahid" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/Mihir20K"><img src="https://avatars.githubusercontent.com/u/112269999?v=4?s=50" width="50px;" alt="Mihir20K"/><br /><sub><b>Mihir20K</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=Mihir20K" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/computerwala"><img src="https://avatars.githubusercontent.com/u/30777038?v=4?s=50" width="50px;" alt="Aman"/><br /><sub><b>Aman</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=computerwala" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/mauriallegrettiswnat"><img src="https://avatars.githubusercontent.com/u/71467262?v=4?s=50" width="50px;" alt="Mauricio Allegretti"/><br /><sub><b>Mauricio Allegretti</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=mauriallegrettiswnat" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/Bruno-Vasconcellos-Betella"><img src="https://avatars.githubusercontent.com/u/57138664?v=4?s=50" width="50px;" alt="Bruno-Vasconcellos-Betella"/><br /><sub><b>Bruno-Vasconcellos-Betella</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=Bruno-Vasconcellos-Betella" title="Documentation">📖</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="16.66%"><a href="https://itdadakan.site"><img src="https://avatars.githubusercontent.com/u/62456215?v=4?s=50" width="50px;" alt="Febi Arifin"/><br /><sub><b>Febi Arifin</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=febiarifin" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/dinesh9-ai"><img src="https://avatars.githubusercontent.com/u/63300423?v=4?s=50" width="50px;" alt="Dineshwar Doddapaneni"/><br /><sub><b>Dineshwar Doddapaneni</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=dinesh9-ai" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/Dheerajsoni93"><img src="https://avatars.githubusercontent.com/u/82114565?v=4?s=50" width="50px;" alt="Dheeraj_Soni"/><br /><sub><b>Dheeraj_Soni</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=Dheerajsoni93" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://www.linkedin.com/in/ojash-kushwaha-791770185"><img src="https://avatars.githubusercontent.com/u/96474959?v=4?s=50" width="50px;" alt="Ojash Kushwaha"/><br /><sub><b>Ojash Kushwaha</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=OjashKush" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/Sleep-lover"><img src="https://avatars.githubusercontent.com/u/82304155?v=4?s=50" width="50px;" alt="Laleet Borse"/><br /><sub><b>Laleet Borse</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=Sleep-lover" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/Wahaj-Raza"><img src="https://avatars.githubusercontent.com/u/103155321?v=4?s=50" width="50px;" alt="Wahaj Raza"/><br /><sub><b>Wahaj Raza</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=Wahaj-Raza" title="Documentation">📖</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/WahajRaza1"><img src="https://avatars.githubusercontent.com/u/90937190?v=4?s=50" width="50px;" alt="WahajRaza1"/><br /><sub><b>WahajRaza1</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=WahajRaza1" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://ravencolevol.github.io"><img src="https://avatars.githubusercontent.com/u/44892121?v=4?s=50" width="50px;" alt="Ravi Lamkoti"/><br /><sub><b>Ravi Lamkoti</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=RavenColEvol" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/UperscuzziSchoolAcc"><img src="https://avatars.githubusercontent.com/u/111448336?v=4?s=50" width="50px;" alt="The One and Only Uper"/><br /><sub><b>The One and Only Uper</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=UperscuzziSchoolAcc" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/AdarshBajpai67"><img src="https://avatars.githubusercontent.com/u/95476086?v=4?s=50" width="50px;" alt="AdarshBajpai67"/><br /><sub><b>AdarshBajpai67</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=AdarshBajpai67" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="http://deepakkharah.me"><img src="https://avatars.githubusercontent.com/u/42672761?v=4?s=50" width="50px;" alt="Deepak Kharah"/><br /><sub><b>Deepak Kharah</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=Deepak-Kharah" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/sairohit360"><img src="https://avatars.githubusercontent.com/u/55144209?v=4?s=50" width="50px;" alt="sairohit360"/><br /><sub><b>sairohit360</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=sairohit360" title="Documentation">📖</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/sairohitzl"><img src="https://avatars.githubusercontent.com/u/86225259?v=4?s=50" width="50px;" alt="sairohitzl"/><br /><sub><b>sairohitzl</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=sairohitzl" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/RavalJinit"><img src="https://avatars.githubusercontent.com/u/72157334?v=4?s=50" width="50px;" alt="Raval Jinit"/><br /><sub><b>Raval Jinit</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=RavalJinit" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/Vovka1759"><img src="https://avatars.githubusercontent.com/u/75867274?v=4?s=50" width="50px;" alt="Vovka1759"/><br /><sub><b>Vovka1759</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=Vovka1759" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/Nijin-P-S"><img src="https://avatars.githubusercontent.com/u/101330853?v=4?s=50" width="50px;" alt="Nijin"/><br /><sub><b>Nijin</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=Nijin-P-S" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/avinilcode"><img src="https://avatars.githubusercontent.com/u/111761529?v=4?s=50" width="50px;" alt="Avinil Bedarkar"/><br /><sub><b>Avinil Bedarkar</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=avinilcode" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/FercueNat"><img src="https://avatars.githubusercontent.com/u/113535859?v=4?s=50" width="50px;" alt="FercueNat"/><br /><sub><b>FercueNat</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=FercueNat" title="Documentation">📖</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="16.66%"><a href="https://khareyash05.github.io/home/"><img src="https://avatars.githubusercontent.com/u/60147732?v=4?s=50" width="50px;" alt="Yash Khare"/><br /><sub><b>Yash Khare</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=khareyash05" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/ayushanand16"><img src="https://avatars.githubusercontent.com/u/96689639?v=4?s=50" width="50px;" alt="Ayush Anand"/><br /><sub><b>Ayush Anand</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=ayushanand16" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/DharmaWarrior"><img src="https://avatars.githubusercontent.com/u/97218268?v=4?s=50" width="50px;" alt="DharmaWarrior"/><br /><sub><b>DharmaWarrior</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=DharmaWarrior" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://linktr.ee/hitarthraval"><img src="https://avatars.githubusercontent.com/u/62943532?v=4?s=50" width="50px;" alt="Hitarth Raval"/><br /><sub><b>Hitarth Raval</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=hitarthraval" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/WiemBorchani"><img src="https://avatars.githubusercontent.com/u/52404192?v=4?s=50" width="50px;" alt="Wiem Borchani "/><br /><sub><b>Wiem Borchani </b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=WiemBorchani" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/Kambo2320"><img src="https://avatars.githubusercontent.com/u/98479408?v=4?s=50" width="50px;" alt="Kamden Burke"/><br /><sub><b>Kamden Burke</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=Kambo2320" title="Documentation">📖</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/denschiro"><img src="https://avatars.githubusercontent.com/u/6161324?v=4?s=50" width="50px;" alt="denschiro"/><br /><sub><b>denschiro</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=denschiro" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/nishat48"><img src="https://avatars.githubusercontent.com/u/109063023?v=4?s=50" width="50px;" alt="Nishat"/><br /><sub><b>Nishat</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=nishat48" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/mdfaizanahmed786"><img src="https://avatars.githubusercontent.com/u/85175130?v=4?s=50" width="50px;" alt="Mohammed Faizan Ahmed"/><br /><sub><b>Mohammed Faizan Ahmed</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=mdfaizanahmed786" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/manish831"><img src="https://avatars.githubusercontent.com/u/74316266?v=4?s=50" width="50px;" alt="Manish Agrahari"/><br /><sub><b>Manish Agrahari</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=manish831" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/lokesh-katari"><img src="https://avatars.githubusercontent.com/u/111894942?v=4?s=50" width="50px;" alt="Katari Lokeswara rao"/><br /><sub><b>Katari Lokeswara rao</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=lokesh-katari" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://g.dev/ZahraShahid"><img src="https://avatars.githubusercontent.com/u/65255043?v=4?s=50" width="50px;" alt="Zahra Shahid"/><br /><sub><b>Zahra Shahid</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=ZahraShahid" title="Documentation">📖</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/glenntu15"><img src="https://avatars.githubusercontent.com/u/10324492?v=4?s=50" width="50px;" alt="Glenn Turner"/><br /><sub><b>Glenn Turner</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=glenntu15" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/vinayak9303"><img src="https://avatars.githubusercontent.com/u/55548976?v=4?s=50" width="50px;" alt="Vinayak godse"/><br /><sub><b>Vinayak godse</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=vinayak9303" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/Satyajeetbh"><img src="https://avatars.githubusercontent.com/u/88246318?v=4?s=50" width="50px;" alt="Satyajeetbh"/><br /><sub><b>Satyajeetbh</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=Satyajeetbh" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/P-Dhruva-Teja"><img src="https://avatars.githubusercontent.com/u/81409709?v=4?s=50" width="50px;" alt="Paidipelly Dhruvateja"/><br /><sub><b>Paidipelly Dhruvateja</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=P-Dhruva-Teja" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/helloausrine"><img src="https://avatars.githubusercontent.com/u/30316810?v=4?s=50" width="50px;" alt="helloausrine"/><br /><sub><b>helloausrine</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=helloausrine" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/SourabhJoshi209"><img src="https://avatars.githubusercontent.com/u/69594540?v=4?s=50" width="50px;" alt="SourabhJoshi209"/><br /><sub><b>SourabhJoshi209</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=SourabhJoshi209" title="Documentation">📖</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="16.66%"><a href="https://bio.link/stefantaitano"><img src="https://avatars.githubusercontent.com/u/85418632?v=4?s=50" width="50px;" alt="Stefan Taitano"/><br /><sub><b>Stefan Taitano</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=codewithfan" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="http://linkedin.com/in/anmspro"><img src="https://avatars.githubusercontent.com/u/33668152?v=4?s=50" width="50px;" alt="Abu Noman Md. Sakib"/><br /><sub><b>Abu Noman Md. Sakib</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=anmspro" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="http://skyrunner360.pythonanywhere.com"><img src="https://avatars.githubusercontent.com/u/44318840?v=4?s=50" width="50px;" alt="Rishi Mathur"/><br /><sub><b>Rishi Mathur</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=skyrunner360" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/Atharv-Nalwade"><img src="https://avatars.githubusercontent.com/u/98139553?v=4?s=50" width="50px;" alt="Darky001"/><br /><sub><b>Darky001</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=Atharv-Nalwade" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/Retr0Sushi"><img src="https://avatars.githubusercontent.com/u/110653014?v=4?s=50" width="50px;" alt="himanshu"/><br /><sub><b>himanshu</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=Retr0Sushi" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/kusumita29"><img src="https://avatars.githubusercontent.com/u/99873488?v=4?s=50" width="50px;" alt="Kusumita Ghose"/><br /><sub><b>Kusumita Ghose</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=kusumita29" title="Documentation">📖</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/Yash1107"><img src="https://avatars.githubusercontent.com/u/76468153?v=4?s=50" width="50px;" alt="Yashvi Patel"/><br /><sub><b>Yashvi Patel</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=Yash1107" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/ArshadAriff"><img src="https://avatars.githubusercontent.com/u/113685884?v=4?s=50" width="50px;" alt="ArshadAriff"/><br /><sub><b>ArshadAriff</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=ArshadAriff" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/ishashukla183"><img src="https://avatars.githubusercontent.com/u/93022787?v=4?s=50" width="50px;" alt="ishashukla183"/><br /><sub><b>ishashukla183</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=ishashukla183" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/jhuynh06"><img src="https://avatars.githubusercontent.com/u/111946833?v=4?s=50" width="50px;" alt="jhuynh06"/><br /><sub><b>jhuynh06</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/issues?q=author%3Ajhuynh06" title="Bug reports">🐛</a> <a href="https://github.com/shhossain/computer_science/commits?author=jhuynh06" title="Tests">⚠️</a></td>
      <td align="center" valign="top" width="16.66%"><a href="http://asche.tech"><img src="https://avatars.githubusercontent.com/u/2975712?v=4?s=50" width="50px;" alt="Andrew Asche"/><br /><sub><b>Andrew Asche</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=andrewasche" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="http://nateonmission.github.io"><img src="https://avatars.githubusercontent.com/u/37854313?v=4?s=50" width="50px;" alt="J. Nathan Allen"/><br /><sub><b>J. Nathan Allen</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/issues?q=author%3Anateonmission" title="Bug reports">🐛</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/Sayed-Afnan-Khazi"><img src="https://avatars.githubusercontent.com/u/83779299?v=4?s=50" width="50px;" alt="Sayed Afnan Khazi"/><br /><sub><b>Sayed Afnan Khazi</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=Sayed-Afnan-Khazi" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/Technic143"><img src="https://avatars.githubusercontent.com/u/117275755?v=4?s=50" width="50px;" alt="Technic143"/><br /><sub><b>Technic143</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=Technic143" title="Documentation">📖</a> <a href="https://github.com/shhossain/computer_science/issues?q=author%3ATechnic143" title="Bug reports">🐛</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/snowflake1201"><img src="https://avatars.githubusercontent.com/u/56119216?v=4?s=50" width="50px;" alt="Pin Yuan Wang"/><br /><sub><b>Pin Yuan Wang</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=snowflake1201" title="Code">💻</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/BogdanOtava"><img src="https://avatars.githubusercontent.com/u/103674688?v=4?s=50" width="50px;" alt="Bogdan Otava"/><br /><sub><b>Bogdan Otava</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=BogdanOtava" title="Code">💻</a> <a href="https://github.com/shhossain/computer_science/commits?author=BogdanOtava" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/Vedeesh6"><img src="https://avatars.githubusercontent.com/u/88491153?v=4?s=50" width="50px;" alt="Vedeesh Dwivedi"/><br /><sub><b>Vedeesh Dwivedi</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/issues?q=author%3AVedeesh6" title="Bug reports">🐛</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/TsiG-404"><img src="https://avatars.githubusercontent.com/u/74056836?v=4?s=50" width="50px;" alt="Tsig"/><br /><sub><b>Tsig</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=TsiG-404" title="Code">💻</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="16.66%"><a href="https://brandonawan.github.io/Resume/"><img src="https://avatars.githubusercontent.com/u/74030681?v=4?s=50" width="50px;" alt="Brandon Awan"/><br /><sub><b>Brandon Awan</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=Brandonawan" title="Documentation">📖</a> <a href="https://github.com/shhossain/computer_science/issues?q=author%3ABrandonawan" title="Bug reports">🐛</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/Evy04"><img src="https://avatars.githubusercontent.com/u/84919650?v=4?s=50" width="50px;" alt="Sanya Madre"/><br /><sub><b>Sanya Madre</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=Evy04" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/steventohme"><img src="https://avatars.githubusercontent.com/u/56594084?v=4?s=50" width="50px;" alt="Steven"/><br /><sub><b>Steven</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=steventohme" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://www.linkedin.com/in/garrett-crowley-a0b931126/"><img src="https://avatars.githubusercontent.com/u/86014840?v=4?s=50" width="50px;" alt="Garrett Crowley"/><br /><sub><b>Garrett Crowley</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=crowleyg" title="Code">💻</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/Francesco601"><img src="https://avatars.githubusercontent.com/u/130352141?v=4?s=50" width="50px;" alt="Francesco Franco"/><br /><sub><b>Francesco Franco</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/issues?q=author%3AFrancesco601" title="Bug reports">🐛</a> <a href="https://github.com/shhossain/computer_science/commits?author=Francesco601" title="Code">💻</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/aclittle096"><img src="https://avatars.githubusercontent.com/u/43685369?v=4?s=50" width="50px;" alt="Alexander Little"/><br /><sub><b>Alexander Little</b></sub></a><br /><a href="#content-aclittle096" title="Content">🖋</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/Wandererr01"><img src="https://avatars.githubusercontent.com/u/129178279?v=4?s=50" width="50px;" alt="Subham Maji"/><br /><sub><b>Subham Maji</b></sub></a><br /><a href="#content-Wandererr01" title="Content">🖋</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/ZRX-SIGMA"><img src="https://avatars.githubusercontent.com/u/100613008?v=4?s=50" width="50px;" alt="SK Jiyad"/><br /><sub><b>SK Jiyad</b></sub></a><br /><a href="#content-ZRX-SIGMA" title="Content">🖋</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/exrol"><img src="https://avatars.githubusercontent.com/u/86170495?v=4?s=50" width="50px;" alt="exrol"/><br /><sub><b>exrol</b></sub></a><br /><a href="#content-exrol" title="Content">🖋</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/manavmittal05"><img src="https://avatars.githubusercontent.com/u/65654441?v=4?s=50" width="50px;" alt="Manav Mittal"/><br /><sub><b>Manav Mittal</b></sub></a><br /><a href="#content-manavmittal05" title="Content">🖋</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/Rathish-Rajendran"><img src="https://avatars.githubusercontent.com/u/61904970?v=4?s=50" width="50px;" alt="Rathish R"/><br /><sub><b>Rathish R</b></sub></a><br /><a href="#content-Rathish-Rajendran" title="Content">🖋</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/anubhav1450"><img src="https://avatars.githubusercontent.com/u/124580419?v=4?s=50" width="50px;" alt="Anubhav Kulshreshtha"/><br /><sub><b>Anubhav Kulshreshtha</b></sub></a><br /><a href="#content-anubhav1450" title="Content">🖋</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="16.66%"><a href="http://sarthak950.netlify.app"><img src="https://avatars.githubusercontent.com/u/93645760?v=4?s=50" width="50px;" alt="Sarthak "/><br /><sub><b>Sarthak </b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=Sarthak950" title="Code">💻</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/architO21"><img src="https://avatars.githubusercontent.com/u/97817943?v=4?s=50" width="50px;" alt="architO21"/><br /><sub><b>architO21</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=architO21" title="Code">💻</a> <a href="#content-architO21" title="Content">🖋</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/nik-6174"><img src="https://avatars.githubusercontent.com/u/78644716?v=4?s=50" width="50px;" alt="Nikhil Kumar Jha"/><br /><sub><b>Nikhil Kumar Jha</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=nik-6174" title="Code">💻</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/Kundai10"><img src="https://avatars.githubusercontent.com/u/76932641?v=4?s=50" width="50px;" alt="Kundai Chasinda"/><br /><sub><b>Kundai Chasinda</b></sub></a><br /><a href="#content-Kundai10" title="Content">🖋</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/rohankaushal123"><img src="https://avatars.githubusercontent.com/u/76746752?v=4?s=50" width="50px;" alt="Rohan kaushal"/><br /><sub><b>Rohan kaushal</b></sub></a><br /><a href="#content-rohankaushal123" title="Content">🖋</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/AayushKumar176"><img src="https://avatars.githubusercontent.com/u/110240629?v=4?s=50" width="50px;" alt="Aayush Kumar"/><br /><sub><b>Aayush Kumar</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=AayushKumar176" title="Code">💻</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/vladimir-cucu"><img src="https://avatars.githubusercontent.com/u/108150922?v=4?s=50" width="50px;" alt="Vladimir Cucu"/><br /><sub><b>Vladimir Cucu</b></sub></a><br /><a href="#content-vladimir-cucu" title="Content">🖋</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://www.linkedin.com/in/mohammed-ali-alsakkaf-899b44224/"><img src="https://avatars.githubusercontent.com/u/87440507?v=4?s=50" width="50px;" alt="Mohammed Ali Alsakkaf (Binbasri)"/><br /><sub><b>Mohammed Ali Alsakkaf (Binbasri)</b></sub></a><br /><a href="#content-Binbasri-in" title="Content">🖋</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/serv-er"><img src="https://avatars.githubusercontent.com/u/120189782?v=4?s=50" width="50px;" alt="serv-er"/><br /><sub><b>serv-er</b></sub></a><br /><a href="#content-serv-er" title="Content">🖋</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/ABarpanda"><img src="https://avatars.githubusercontent.com/u/145291762?v=4?s=50" width="50px;" alt="Amritanshu Barpanda"/><br /><sub><b>Amritanshu Barpanda</b></sub></a><br /><a href="#content-ABarpanda" title="Content">🖋</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/aheaton22"><img src="https://avatars.githubusercontent.com/u/117932053?v=4?s=50" width="50px;" alt="aheaton22"/><br /><sub><b>aheaton22</b></sub></a><br /><a href="#content-aheaton22" title="Content">🖋</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/geeknees"><img src="https://avatars.githubusercontent.com/u/701242?v=4?s=50" width="50px;" alt="Masumi Kawasaki"/><br /><sub><b>Masumi Kawasaki</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/issues?q=author%3Ageeknees" title="Bug reports">🐛</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/aslezar"><img src="https://avatars.githubusercontent.com/u/97354675?v=4?s=50" width="50px;" alt="aslezar"/><br /><sub><b>aslezar</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=aslezar" title="Code">💻</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://yashsajwan.netlify.app/"><img src="https://avatars.githubusercontent.com/u/52412969?v=4?s=50" width="50px;" alt="Yash Sajwan"/><br /><sub><b>Yash Sajwan</b></sub></a><br /><a href="#content-Yash-Sajwan24" title="Content">🖋</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/AbhishekKumar993"><img src="https://avatars.githubusercontent.com/u/121042725?v=4?s=50" width="50px;" alt="Abhishek Kumar"/><br /><sub><b>Abhishek Kumar</b></sub></a><br /><a href="#content-AbhishekKumar993" title="Content">🖋</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/jakenybo"><img src="https://avatars.githubusercontent.com/u/57851055?v=4?s=50" width="50px;" alt="jakenybo"/><br /><sub><b>jakenybo</b></sub></a><br /><a href="#content-jakenybo" title="Content">🖋</a> <a href="https://github.com/shhossain/computer_science/commits?author=jakenybo" title="Code">💻</a></td>
    </tr>
  </tbody>
</table>

<!-- markdownlint-restore -->
<!-- prettier-ignore-end -->

<!-- ALL-CONTRIBUTORS-LIST:END -->
<!-- prettier-ignore-start -->
<!-- markdownlint-disable -->

<!-- markdownlint-restore -->
<!-- prettier-ignore-end -->

<!-- ALL-CONTRIBUTORS-LIST:END -->
<!-- ALL-CONTRIBUTORS-BADGE:START - Do not remove or modify this section -->

[![All Contributors](https://img.shields.io/badge/all_contributors-104-orange.svg?style=flat-square)](#contributors)
<!-- ALL-CONTRIBUTORS-BADGE:END -->
