

<h1 align="center">Informatica</h1>
<h4 align="center">
    <p>
        <a href="https://github.com/shhossain/computer_science/blob/main/README.md">English</a> |
        <b>Italiano</b> |
        <a href="https://github.com/shhossain/computer_science/blob/main/README_es.md">Español</a> |
        <a href="https://github.com/shhossain/computer_science/blob/main/README_fr.md">Français</a> |
        <a href="https://github.com/shhossain/computer_science/blob/main/README_bn.md">বাংলা</a> |
        <a href="https://github.com/shhossain/computer_science/blob/main/README_ta.md">தமிழ்</a> |
        <a href="https://github.com/shhossain/computer_science/blob/main/README_guj.md">ગુજરાતી</a> |
        <a href="https://github.com/shhossain/computer_science/blob/main/README_pt.md">Portuguese</a> |
        <a href="https://github.com/shhossain/computer_science/blob/main/README_hi.md">हिंदी</a> |
        <a href="https://github.com/shhossain/computer_science/blob/main/README_te.md">తెలుగు</a> |
        <a href="https://github.com/shhossain/computer_science/blob/main/README_ro.md">Română</a> |
        <a href="https://github.com/shhossain/computer_science/blob/main/README_ar.md">العربية</a> |
        <a href="https://github.com/shhossain/computer_science/blob/main/README_np.md">Nepali</a> |
        <a href="https://github.com/shhossain/computer_science/blob/main/README_cn.md">简体中文</a>
    </p>
</h4>

## Linee guida per i contributi
Se sei interessato a contribuire a questo progetto, prenditi un momento per leggere [CONTRIBUTING.md](https://github.com/shhossain/computer_science/blob/main/CONTRIBUTING.md) per istruzioni dettagliate su come iniziare. I tuoi contributi sono molto apprezzati!

<!-- ALL-CONTRIBUTORS-BADGE:START - Do not remove or modify this section -->
[![All Contributors](https://img.shields.io/badge/all_contributors-153-orange.svg?style=flat-square)](#contributors-)
<!-- ALL-CONTRIBUTORS-BADGE:END -->

## Indice dei Contenuti

- [Introduzione](#introduzione)
- [Computer Elettronico](#computer-elettronico)
- [Logica Booleana](#logica-booleana)
- [Circuiti Digitali](#circuiti-digitali)
- [Sistemi Numerici](#sistemi-numerici)
- [Unità di Elaborazione Centrale (CPU)](#unità-di-elaborazione-centrale-cpu)
- [Registri, Cache e RAM](#registri-cache-e-ram)
- [Istruzioni e Programma](#istruzioni-e-programma)
- [Linguaggi di Programmazione](#linguaggi-di-programmazione)
- [Tipi di Dati](#tipi-di-dati)
- [Istruzioni e Funzioni](#istruzioni-e-funzioni)
- [Strutture Dati](#strutture-dati)
- [Algoritmi](#algoritmi)
- [Alan Turing](#alan-turing)
- [Ingegneria del Software](#ingegneria-del-software)
- [Data Science](#data-science)
- [Circuiti Integrati](#circuiti-integrati)
- [Programmazione Orientata agli Oggetti](#programmazione-orientata-agli-oggetti)
- [Programmazione Funzionale](#programmazione-funzionale)
- [Sistemi Operativi](#sistemi-operativi)
- [Memoria e Archiviazione](#memoria-e-archiviazione)
- [File System](#file-system)
- [Cloud Computing](#cloud-computing)
- [Machine Learning](#machine-learning)
- [Tecnologia Web](#tecnologia-web)
- [Reti](#reti)
- [Internet](#internet)
- [DBMS (Sistema di Gestione di Database)](#dbms)
- [Crittografia](#crittografia)
- [Teoria della Computazione](#teoria-della-computazione)


## Introduzione

L'informatica è lo studio dei computer e del calcolo e delle loro applicazioni teoriche e pratiche. L'informatica applica i principi della matematica, dell'ingegneria e della logica a una moltitudine di problemi, tra cui la formulazione di algoritmi, lo sviluppo di software/hardware e l'intelligenza artificiale.


## [Computer Elettronico](Electronic%20Computer/readme.md)
Un dispositivo che esegue calcoli, in particolare una macchina elettronica programmabile che esegue operazioni matematiche o logiche ad alta velocità, o che assembla, memorizza, correla o elabora in altro modo informazioni.

## [Logica Booleana](Boolean%20Logic/readme.md)
La logica booleana è un ramo della matematica che si occupa dei valori di verità e falsità. È un sistema di logica che utilizza solo due valori, 0 e 1, per rappresentare rispettivamente falso e vero. È anche conosciuta come algebra booleana, dal nome di George Boole, che l'ha descritta per la prima volta nel 1854.

### Operatori Booleani Comuni
| Operatore | Nome |               Descrizione               |
| :------: | :--: | :-------------------------------------: |
|    !     | NOT  |    Nega il valore dell'operando.    |
|    &&    | AND  | Restituisce **vero** se entrambi gli operandi sono veri. |
|   \|\|   |  OR  | Restituisce **vero** se uno o entrambi gli operandi sono veri. |

### Operatori Booleani Interessanti
| Operatore | Nome |               Descrizione               |
| :------: | :--: | :-------------------------------------: |
|    ()    | Parentesi     |   Permette di raggruppare parole chiave e controllare l'ordine in cui i termini verranno cercati.    |
|    “”    | Virgolette | Fornisce risultati con la frase esatta. |
|   *      |  Asterisco       | Fornisce risultati contenenti una variazione della parola chiave. |
|   ⊕     |  XOR            | Restituisce **vero** se gli operandi sono diversi |
|   ⊽      |  NOR            | Restituisce **vero** se tutti gli operandi sono falsi. |
|   ⊼      |  NAND           | Restituisce **falso** solo se entrambi i valori dei suoi due input sono veri. |

## [Circuiti Digitali](Digital%20Circuits/readme.md)

I circuiti digitali si occupano di segnali booleani (1 e 0). Sono i blocchi fondamentali di un computer. Sono i componenti e i circuiti utilizzati per creare unità di processore e unità di memoria essenziali per un sistema informatico.

### Tavole di Verità

Le tavole di verità sono tabelle matematiche utilizzate nella progettazione logica e dei circuiti digitali. Aiutano a mappare la funzionalità di un circuito. Possiamo utilizzarle per aiutare a progettare circuiti digitali complessi.

Le tavole di verità hanno 1 colonna per ogni variabile di input e 1 colonna finale che mostra tutti i possibili risultati dell'operazione logica che la tavola rappresenta.

### Tipi di Circuiti Digitali

Ci sono 2 tipi di circuiti digitali: Combinatori e Sequenziali

- **Circuiti Combinatori**: In questo tipo di circuito digitale, l'output dipende dall'input che riceve in un istante. Questo tipo di circuito rimarrà costante rispetto al suo input.
- **Circuiti Sequenziali**: In questo tipo di circuito digitale, l'output dipende non solo dall'input che riceve in un istante ma anche dal precedente input che ha ricevuto. L'output generato dal precedente input viene trasferito nell'output dell'input corrente.

### Metodologia di Progettazione

Quando si progetta un circuito digitale, soprattutto complesso, è importante utilizzare strumenti dell'algebra booleana per aiutare nel processo di progettazione (esempio: mappa di Karnaugh). È anche importante suddividere tutto in circuiti più piccoli ed esaminare la tavola di verità necessaria per quel circuito più piccolo. Non cercare di affrontare tutto il circuito in una volta, suddividilo e metti gradualmente insieme i pezzi.

## [Sistemi Numerici](Number%20System/readme.md#number-systems)
I sistemi numerici sono sistemi matematici per esprimere numeri. Un sistema numerico consiste in un insieme di simboli utilizzati per rappresentare numeri e un insieme di regole per manipolare

 quei simboli. I simboli utilizzati in un sistema numerico sono chiamati numerali.

### [Tipi di Sistemi Numerici](Number%20System/readme.md#types-of-number-systems)
- [Sistema Numerico Posizionale](Number%20System/readme.md#positional-numeral-system)
- [Sistema Notazionale a Segno e Valore](Number%20System/readme.md#sign-value-notation-system)

### [Sistemi Numerici Posizionali Comuni](Number%20System/readme.md#common-positional-number-systems)
- [Binario](Number%20System/readme.md#binary)
- [Ottale](Number%20System/readme.md#octal)
- [Decimale](Number%20System/readme.md#decimal)
- [Esadecimale](Number%20System/readme.md#hexadecimal)


### Importanza del Binario
Il binario è un sistema numerico a base 2 inventato da Gottfried Leibniz composto solo da due numeri o cifre: 0 (zero) e 1 (uno). Questo sistema numerico è alla base di tutto il codice binario, utilizzato per scrivere dati digitali come le istruzioni del processore del computer utilizzate ogni giorno. Gli 0 e i 1 nel binario rappresentano rispettivamente SPENTO o ACCESO. In un transistor, uno "0" rappresenta l'assenza di flusso di elettricità, e uno "1" rappresenta che l'elettricità è permessa di fluire. In questo modo, i numeri vengono rappresentati fisicamente all'interno del dispositivo di calcolo, permettendo i calcoli.

 
Il binario è ancora il linguaggio principale per i computer ed è utilizzato con l'elettronica e l'hardware del computer per le seguenti ragioni:

- È un design semplice ed elegante.
- Il metodo 0 e 1 del binario è rapido per rilevare lo stato spento (falso) o acceso (vero) di un segnale elettrico.
- Avere solo due stati posti a distanza in un segnale elettrico lo rende meno suscettibile alle interferenze elettriche.
- I poli positivi e negativi dei supporti magnetici sono rapidamente tradotti in binario.
- Il binario è il modo più efficiente per controllare i circuiti logici.


## [Unità di Elaborazione Centrale (CPU)](CPU/readme.md#central-processing-unitcpu)
L'Unità di Elaborazione Centrale (CPU) è la parte più importante di qualsiasi computer. La CPU invia segnali per controllare le altre parti del computer, quasi come un cervello controlla un corpo. La CPU è una macchina elettronica che esegue un elenco di cose da fare del computer, chiamate istruzioni. Legge l'elenco delle istruzioni ed esegue (esegue) ciascuna in ordine. Un elenco di istruzioni che una CPU può eseguire è un programma per computer. Una CPU può elaborare più di un'istruzione alla volta su sezioni chiamate "core". Una CPU con quattro core può elaborare quattro programmi contemporaneamente. La CPU stessa è composta da tre componenti principali. Sono:
1. [Unità di Memoria o di Archiviazione](CPU/readme.md#memory-or-storage-unit)
2. [Unità di Controllo](CPU/readme.md#control-unit)
3. [Unità Aritmetica e Logica (ALU)](CPU/readme.md#arithmetic-and-logic-unit-alu)



## [Registri, Cache e RAM](/Registers%20Cache%20and%20RAM)

### [Registro](/Registers%20Cache%20and%20RAM/readme.md#register)
I registri sono piccole quantità di memoria ad alta velocità contenute all'interno della CPU. I registri sono una raccolta di "flip-flop" (un circuito utilizzato per memorizzare 1 bit di memoria). Vengono utilizzati dal processore per memorizzare piccole quantità di dati necessari durante l'elaborazione. Una CPU può avere diversi set di registri che vengono chiamati "core". I registri aiutano anche nelle operazioni aritmetiche e logiche.

Le operazioni aritmetiche sono calcoli matematici eseguiti dalla CPU su dati numerici memorizzati nei registri. Queste operazioni includono addizione, sottrazione, moltiplicazione e divisione. Le operazioni logiche sono calcoli booleani eseguiti dalla CPU su dati binari memorizzati nei registri. Queste operazioni includono confronti (ad esempio, verificare se due valori sono uguali) e operazioni logiche (ad esempio, AND, OR, NOT).

I registri sono essenziali per eseguire queste operazioni perché consentono alla CPU di accedere rapidamente e manipolare piccole quantità di dati. Memorizzando i dati frequentemente utilizzati nei registri, la CPU può evitare il processo più lento di recupero dei dati dalla memoria.

Quantità maggiori di dati possono essere memorizzate nella Cache, una memoria molto veloce situata sullo stesso circuito integrato dei registri. La cache viene utilizzata per i dati accessibili frequentemente mentre il programma è in esecuzione. Quantità ancora maggiori di dati possono essere memorizzate nella RAM. La RAM è l'acronimo di "random-access memory", un tipo di memoria che contiene dati e istruzioni che sono stati spostati dall'archiviazione su disco fino a quando il processore ne avrà bisogno.


### [Cache](/Registers%20Cache%20and%20RAM/readme.md#cache)
La memoria cache è un componente del computer basato su chip che rende più efficiente il recupero dei dati dalla memoria del computer. Funziona come un'area di archiviazione temporanea in modo che il processore del computer possa recuperare facilmente i dati. Questa area di archiviazione temporanea, nota come cache, è più facilmente disponibile per il processore rispetto alla fonte di memoria principale del computer, che è tipicamente una forma di DRAM.

La memoria cache viene talvolta chiamata memoria della CPU (unità di elaborazione centrale) perché è tipicamente integrata direttamente nel chip della CPU o posizionata su un chip separato che ha un bus di interconnessione separato con la CPU. Pertanto, è più accessibile al processore e in grado di aumentare l'efficienza perché è fisicamente vicina al processore.

Per essere vicina al processore, la memoria cache deve essere molto più piccola rispetto alla memoria principale. Di conseguenza, ha meno spazio di archiviazione. È anche più costosa della memoria principale, poiché è un chip più complesso che offre prestazioni superiori.

Ciò che sacrifica in termini di dimensioni e prezzo, lo compensa in termini di velocità. La memoria cache funziona da 10 a 100 volte più velocemente della RAM, richiedendo solo pochi nanosecondi per rispondere a una richiesta della CPU.

Il nome dell'hardware effettivo utilizzato per la memoria cache è memoria statica ad accesso casuale ad alta velocità (SRAM). Il nome dell'hardware utilizzato nella memoria principale di un computer è memoria dinamica ad accesso casuale (DRAM).

La memoria cache non deve essere confusa con il termine più ampio cache. Le cache sono archivi di dati temporanei che possono esistere sia nell'hardware che nel software. La memoria cache si riferisce al componente hardware specifico che consente ai computer di creare cache a vari livelli della rete. Una cache è un componente hardware o software utilizzato per memorizzare temporaneamente qualcosa, tipicamente dati, in un ambiente informatico.


### [RAM](/Registers%20Cache%20and%20RAM/readme.md#ram)
La RAM (memoria ad accesso casuale) è una forma di memoria del computer che può essere letta e modificata in qualsiasi ordine, tipicamente utilizzata per memorizzare dati di lavoro e codice macchina. Un dispositivo di memoria ad accesso casuale consente agli elementi di dati di essere letti o scritti in quasi lo stesso tempo indipendentemente dalla posizione fisica dei dati all'interno della memoria, a differenza di altri media di archiviazione di dati ad accesso diretto (come dischi rigidi, CD-RW, DVD-RW e le vecchie memorie a nastro e a tamburo), dove il tempo richiesto per leggere e scrivere elementi di dati varia significativamente a seconda delle loro posizioni fisiche sul supporto di registrazione, a causa di limitazioni meccaniche come la velocità di rotazione dei supporti e il movimento del braccio.


## [Istruzioni e Programma](Not-Added)
Nell'informatica, un'istruzione è una singola operazione di un processore definita dal set di istruzioni del processore. Un programma per computer è un elenco di istruzioni che dicono al computer cosa fare. Tutto ciò che un computer fa viene realizzato utilizzando un programma per computer. I programmi memorizzati nella memoria di un computer ("programmazione interna") consentono al computer di fare una cosa dopo l'altra, anche con pause tra un'operazione e l'altra.

## [Linguaggi di Programmazione](/Programming_Languages/readme.md)
Un linguaggio di programmazione è un insieme di regole che converte stringhe, o elementi grafici di programma nel caso di linguaggi di programmazione visuale, in vari tipi di output in codice macchina. I linguaggi di programmazione sono un tipo di linguaggio informatico utilizzato nella programmazione per implementare algoritmi.

I linguaggi di programmazione sono spesso divisi in due ampie categorie:
1. Il linguaggio ad alto livello utilizza una sintassi simile alla lingua inglese. Il codice sorgente viene convertito in codice macchina comprensibile tramite un compilatore o un interprete. Java e Python sono alcuni esempi di linguaggi di programmazione ad alto livello. Questi sono generalmente più lenti dei linguaggi a basso livello, ma sono più facili da utilizzare.
2. I linguaggi di programmazione a basso livello lavorano più da vicino con l'hardware e hanno maggiore controllo su di esso. Interagiscono direttamente con l'hardware. Due esempi comuni di linguaggi a basso livello sono il linguaggio macchina e il linguaggio assembly. Questi sono generalmente più veloci dei linguaggi ad alto livello, ma a costo di una maggiore difficoltà e minore leggibilità.

### [Paradigmi di Programmazione](/Programming_Languages/readme.md#Programming+Paradigms)
Esistono anche diversi *paradigmi di programmazione*. I paradigmi di programmazione sono diversi modi o stili in cui un dato programma o linguaggio di programmazione può essere organizzato. Ogni paradigma consiste di certe strutture, caratteristiche e opinioni su come affrontare i problemi di programmazione comuni.

I paradigmi di programmazione *non* sono linguaggi o strumenti. Non puoi "costruire" nulla con un paradigma. Sono più simili a un insieme di ideali e linee guida che molte persone hanno accettato, seguito e ampliato. I linguaggi di programmazione non sono sempre legati a un particolare paradigma. Ci *sono* linguaggi che sono stati costruiti con un certo paradigma in mente e hanno caratteristiche che facilitano quel tipo di programmazione più di altri (Haskell e la programmazione funzionale sono un buon esempio). Ma ci sono anche linguaggi "multi-paradigma" in cui puoi adattare il tuo codice per adattarsi a un paradigma o all'altro (JavaScript e Python sono buoni esempi).


## [Tipi di Dati](Data%20Types/readme.md#data-types)
Un tipo di dati, nella programmazione, è una classificazione che specifica quale tipo di valore ha una variabile e quale tipo di operazioni matematiche, relazionali o logiche possono essere applicate ad essa senza causare errori.

### [Tipi di Dati Primitivi](Data%20Types/readme.md#primitive-data-types)
I tipi di dati primitivi sono i tipi di dati più basilari in un linguaggio di programmazione. Sono i mattoni di costruzione dei tipi di dati più complessi. I tipi di dati primitivi sono predefiniti dal linguaggio di programmazione e sono nominati da una parola chiave riservata.

### [Tipi di Dati Primitivi Comuni](Data%20Types/readme.md#common-primitive-data-types)
- [Intero](Data%20Types/readme.md#integer)
- [Virgola Mobile](Data%20Types/readme.md#float)
- [Booleano](Data%20Types/readme.md#boolean)
- [Carattere](Data%20Types/readme.md#character)
- [Stringa](Data%20Types/readme.md#string)

### [Tipi di Dati Non Primitivi](Data%20Types/read

me.md#non-primitive-data-types)
I tipi di dati non primitivi sono anche noti come tipi di dati di riferimento. Sono creati dal programmatore e non sono definiti dal linguaggio di programmazione. I tipi di dati non primitivi sono anche chiamati tipi di dati compositi perché sono composti da altri tipi.

### [Tipi di Dati Non Primitivi Comuni](Data%20Types/readme.md#common-non-primitive-data-types)
- [Array](Data%20Types/readme.md#array)
- [Struct](Data%20Types/readme.md#struct)
- [Unione](Data%20Types/readme.md#union)
- [Puntatore](Data%20Types/readme.md#pointer)
- [Funzione](Data%20Types/readme.md#function)
- [Classe](Data%20Types/readme.md#class)

## [Istruzioni e Funzioni](Statements%20and%20Functions/readme.md)
Nella programmazione, un'istruzione è un'unità sintattica di un linguaggio di programmazione imperativo che esprime un'azione da eseguire. Un programma scritto in tale linguaggio è formato da una sequenza di una o più istruzioni. Un'istruzione può avere componenti interni (ad esempio, espressioni).
Ci sono due tipi principali di istruzioni in qualsiasi linguaggio di programmazione necessari per costruire la logica di un codice.

1. [Istruzioni Condizionali](Statements%20and%20Functions/readme.md#conditional-statements)

Esistono principalmente due tipi di istruzioni condizionali:
- if
- if-else
- switch case

2. [Cicli](Statements%20and%20Functions/readme.md#loops)

Esistono principalmente tre tipi di cicli:
- for loop
- while loop
- do-while loop (una variazione del while loop)
- do-until loop

------------

Una funzione è un blocco di istruzioni che svolge un compito specifico. Le funzioni accettano dati, li elaborano e restituiscono un risultato o eseguono un'azione. Le funzioni sono scritte principalmente per supportare il concetto di riutilizzabilità. Una volta scritta una funzione, può essere chiamata facilmente senza dover ripetere lo stesso codice.

Diversi linguaggi funzionali utilizzano sintassi diverse per scrivere le funzioni.

Leggi di più sulle funzioni [qui](Statements%20and%20Functions/readme.md#functions).


## [Strutture Dati](Data%20Structures/readme.md)
In informatica, una struttura dati è un formato per l'organizzazione, la gestione e l'archiviazione dei dati che consente un accesso e una modifica efficienti. Più precisamente, una struttura dati è una raccolta di valori di dati, le relazioni tra di essi e le funzioni o operazioni che possono essere applicate ai dati.

### Tipi di Strutture Dati
- [Array](Data%20Structures/readme.md#array)
- [Lista Collegata](Data%20Structures/readme.md#linkedlist)
- [Stack](Data%20Structures/readme.md#stack)
- [Coda](Data%20Structures/readme.md#queue)
- [Tabella Hash](Data%20Structures/readme.md#hashtable)
- [Heap](Data%20Structures/readme.md#heap)
- [Albero](Data%20Structures/readme.md#tree)
- [Grafo](Data%20Structures/readme.md#graph)

## [Algoritmi](Algorithms/readme.md)
Gli algoritmi sono insiemi di passi necessari per completare un calcolo. Sono al cuore di ciò che fanno i nostri dispositivi, e non è un concetto nuovo. Dallo sviluppo della matematica stessa, sono stati necessari algoritmi per aiutarci a completare i compiti in modo più efficiente. Oggi daremo uno sguardo a un paio di problemi di calcolo moderni, come l'ordinamento e la ricerca sui grafi, e mostreremo come li abbiamo resi più efficienti affinché tu possa trovare più facilmente voli economici o indicazioni stradali verso Winterfell o un ristorante o altro.

### [Complessità Temporale](Algorithms/Time%20Complexity/readme.md)
La complessità temporale di un algoritmo stima quanto tempo l'algoritmo impiegherà per un certo input. L'idea è di rappresentare l'efficienza come una funzione il cui parametro è la dimensione dell'input. Calcolando la complessità temporale, possiamo determinare se l'algoritmo è abbastanza veloce senza implementarlo.

### [Complessità Spaziale](Algorithms/Space%20Complexity/readme.md)
La complessità spaziale si riferisce alla quantità totale di memoria che un algoritmo/program utilizza, inclusa la memoria degli input necessari per l'esecuzione. Calcolare lo spazio occupato dalle variabili in un algoritmo/program permette di determinare la complessità spaziale.

### [Ordinamento](Algorithms/Sorting/readme.md)
L'ordinamento è il processo di disposizione di un elenco di elementi in un ordine particolare. Ad esempio, se avessi un elenco di nomi, potresti volerli ordinare in ordine alfabetico. In alternativa, se avessi un elenco di numeri, potresti volerli mettere in ordine dal più piccolo al più grande. L'ordinamento è un compito comune, e possiamo farlo in molti modi diversi.

### [Ricerca](Algorithms/Searching/readme.md)
La ricerca è un algoritmo per trovare un certo elemento target all'interno di un contenitore. Gli algoritmi di ricerca sono progettati per verificare la presenza di un elemento o recuperare un elemento da qualsiasi struttura dati in cui è archiviato.

### [Algoritmi Basati su Stringhe](Algorithms/String%20Based%20Algorithms/readme.md)
Le stringhe sono una delle strutture dati più utilizzate e importanti nella programmazione. Questo repository contiene alcuni degli algoritmi più utilizzati che aiutano a migliorare il tempo di ricerca, ottimizzando il nostro codice.

### [Ricerca sui Grafi](Algorithms/Graph/readme.md)
La ricerca sui grafi è il processo di ricerca attraverso un grafo per trovare un particolare nodo. Un grafo è una struttura dati che consiste in un insieme finito (e possibilmente mutabile) di vertici o nodi o punti, insieme a un insieme di coppie non ordinate di questi vertici per un grafo non orientato o un insieme di coppie ordinate per un grafo orientato. Queste coppie sono conosciute come archi, archi orientati o linee per un grafo non orientato e come frecce, archi diretti, archi diretti o linee dirette per un grafo orientato. I vertici possono far parte della struttura del grafo o possono essere entità esterne rappresentate da indici interi o riferimenti. I grafi sono una delle strutture dati più utili per molte applicazioni nel mondo reale. I grafi sono utilizzati per modellare relazioni a coppie tra oggetti. Ad esempio, la rete delle rotte aeree è un grafo in cui le città sono i vertici e le rotte dei voli sono gli archi. I grafi sono anche usati per rappresentare reti. Internet può essere modellato come un grafo in cui i computer sono i vertici e i collegamenti tra i computer sono gli archi. I grafi sono anche utilizzati nei social network come LinkedIn e Facebook. I grafi sono utilizzati per rappresentare molte applicazioni del mondo reale: reti informatiche, progettazione di circuiti, e programmazione aeronautica, solo per citarne alcune.

### [Programmazione Dinamica](Algorithms/Dynamic%20Programming/README.md)
La programmazione dinamica è sia un metodo di ottimizzazione matematica che un metodo di programmazione informatica. Richard Bellman sviluppò il metodo negli anni '50 e ha trovato applicazioni in numerosi campi, dall'ingegneria aerospaziale all'economia. In entrambi i contesti, si riferisce a semplificare un problema complicato suddividendolo in sottoproblemi più semplici in modo ricorsivo. Anche se alcuni problemi decisionali non possono essere scomposti in questo modo, le decisioni che si estendono su più punti nel tempo spesso si scompongono ricorsivamente. Allo stesso modo, in informatica, se un problema può essere risolto in modo ottimale suddividendolo in sottoproblemi e poi trovando ricorsivamente le soluzioni ottimali ai sottoproblemi, allora si dice che ha una struttura ottimale. La programmazione dinamica è uno dei modi per risolvere problemi con queste proprietà. Il processo di suddivisione di un problema complicato in sottoproblemi più semplici è chiamato "divide et impera".

### [Algoritmi Greedy](Algorithms/Greedy%20Algorithm/readme.md)
Gli algoritmi greedy sono una classe di algoritmi semplice e intuitiva che può essere utilizzata per trovare la soluzione ottimale a problemi di ottimizzazione. Sono chiamati greedy perché, a ogni passo, fanno la scelta che sembra migliore in quel momento. Questo significa che gli algoritmi greedy non garantiscono di restituire la soluzione ottimale globale, ma invece fanno scelte localmente ottimali nella speranza di trovare un ottimo globale. Gli algoritmi greedy sono utilizzati per problemi di ottimizzazione. Un problema di ottimizzazione può essere risolto utilizzando Greedy se il problema ha la seguente proprietà: a ogni passo, possiamo fare una scelta che sembra migliore al momento e ottenere la soluzione ottimale al problema completo.

### [Backtracking](Algorithms/Backtracking/README.md)
Il backtracking è una tecnica algoritmica per risolvere problemi in modo ricorsivo cercando di costruire una soluzione incrementale, un pezzo alla volta, rimuovendo quelle soluzioni che non soddisfano i vincoli del problema in qualsiasi punto del tempo (il tempo qui si riferisce al tempo trascorso fino a raggiungere qualsiasi livello dell'albero di ricerca).

### [Branch and Bound](Algorithms/Branch%20and%20Bound/README.md)
Branch and Bound è una tecnica generale per risolvere problemi di ottimizzazione combinatoria. È una tecnica di enumerazione sistematica che riduce il numero di soluzioni candidate utilizzando la struttura del problema per eliminare soluzioni candidate che non possono essere ottimali.

### [Complessità Temporale e Complessità Spaziale di Diversi Algoritmi di Ricerca e Ordinamento](Not-Added)
**Complessità Temporale**: È definita come il numero di volte che un particolare set di istruzioni si prevede venga eseguito piuttosto che il tempo totale impiegato. Poiché il tempo è un fenomeno dipendente, la complessità temporale può variare in base ad alcuni fattori esterni come la velocità del processore, il compilatore utilizzato, ecc.

**Complessità Spaziale**: È lo spazio totale di memoria consumato dal programma per la sua esecuzione.

Entrambi sono calcolati come funzione della dimensione dell'input (n). La complessità temporale di un algoritmo è espressa in notazione big O.

L'efficienza di un algoritmo dipende da questi due parametri.

### Tipi di Complessità Temporale:

- **Complessità Temporale nel Migliore dei Casi**: L'input per cui l'algoritmo impiega meno tempo o il tempo minimo. Nel migliore dei casi, calcoliamo la complessità temporale del limite inferiore di un algoritmo. Ad esempio: se i dati da cercare sono presenti nella prima posizione di un grande array di dati in una ricerca lineare, allora si verifica il migliore dei casi.

- **Complessità Temporale Media**: Prendiamo tutti gli input casuali e calcoliamo il tempo di elaborazione per tutti gli input. Poi, lo dividiamo per il numero totale di input.

- **Complessità Temporale nel Peggiore dei Casi**: Definisce l'input per cui l'algoritmo impiega più tempo o il tempo massimo. Nel peggiore dei casi, calcoliamo il limite superiore di un algoritmo. Esempio: Se i dati da cercare sono presenti nell'ultima posizione di un grande array di dati in un algoritmo di ricerca lineare, allora si verifica il peggiore dei casi.

Alcune complessità temporali comuni sono:

- **O(1)**: Questo denota il tempo costante. O(1) di solito significa che un algoritmo avrà un tempo costante indipendentemente dalla dimensione dell'input. Gli Hash Map sono perfetti esempi di tempo costante.

- **O(log n)**: Questo denota il tempo logaritmico. O(log n) significa che diminuisce a ogni iterazione per le operazioni. Cercare elementi negli Alberi di Ricerca Binari (BST) è un buon esempio di tempo logaritmico.

- **O(n)**: Questo denota il tempo lineare. O(n) significa che le prestazioni sono direttamente proporzionali alla dimensione dell'input. In termini semplici, il numero di input e il tempo impiegato per eseguire quegli input saranno proporzionali. La ricerca lineare negli array è un ottimo esempio di complessità temporale lineare.

- **O(n\*n)**: Questo denota il tempo quadratico. O(n^2) significa che le prestazioni sono direttamente proporzionali al quadrato dell'input preso. In modo semplice, il tempo impiegato per l'esecuzione richiederà grosso modo il quadrato della dimensione dell'input. I cicli annidati sono perfetti esempi di complessità temporale quadratica.

- **O(n log n)**: Questo denota la complessità temporale polinomiale. O(n log n) significa che le prestazioni sono n volte quelle di O(log n), (che è la complessità nel peggiore dei casi). Un buon esempio sarebbe un algoritmo di divide et impera come il merge sort. Questo algoritmo prima divide l'insieme, che richiede O(log n) tempo, poi affronta e ordina l'insieme, che richiede O(n) tempo; quindi, il merge sort richiede O(n log n) tempo.

| Algoritmo	     |             |  Complessità Temporale |	       | Complessità Spaziale |
|   :---:        |  :---:      |  :---: 	   |   :---: 	   |   :---:          |
|  	             | Migliore	   | Media	         |  Peggiore	     |  Peggiore         |
| Selection Sort | Ω(n^2)	     | θ(n^2)	     | O(n^2)	       | O(1)             |
| Bubble Sort	 | Ω(n)	       | θ(n^2)	     | O(n^2)	       | O(1)             |
| Insertion Sort | Ω(n)	       | θ(n^2)	     | O(n^2)	       | O(1)             |
| Heap Sort	     | Ω(n log(n)) | θ(n log(n)) | O(n log(n)) | O(1)             |
| Quick Sort	   | Ω(n log(n)) | θ(n log(n)) | O(n^2)	     | O(n)             |
| Merge Sort	   | Ω(n log(n)) | θ(n log(n)) | O(n log(n)) | O(n)             |
| Bucket Sort    | Ω(n +k)	   | θ(n +k)	   | O(n^2)	     | O(n)             |
| Radix Sort  	 | Ω(nk)	     | θ(nk)	     | O(nk)	       | O(n + k)         |
| Count Sort  	 | Ω(n +k)	   | θ(n +k)	   | O(n +k)	     | O(k)             |
| Shell Sort  	 | Ω(n log(n)) | θ(n log(n)) | O(n^2)	     | O(1)             |
| Tim Sort	     | Ω(n)	       | θ(n log(n)) | O(n log(n)) | O(n)             |
| Tree Sort   	 | Ω(n log(n)) | θ(n log(n)) | O(n^2)	     | O(n)             |
| Cube Sort	     | Ω(n)	       | θ(n log(n)) | O(n log(n)) | O(n)             |

| Algoritmo	     |             |  Complessità Temporale |	     |
|   :---:        |  :---:      |  :---: 	 |   :---: 	   |  
|  	             | Migliore	   | Media	   |  Peggiore	     |
| Linear Search  | O(1)	       | O(N)	     | O(N)	         | O(1)  |
| Binary Search	 | O(1)	       | O(logN)   | O(logN)	     |


## [Alan Turing](Not-Added)
Alan Turing (nato il 23 giugno 1912, Londra, Inghilterra – morto il 7 giugno 1954, Wilmslow, Cheshire) è stato un matematico e logico inglese. Ha studiato presso l'Università di Cambridge e l'Istituto per gli Studi Avanzati di Princeton. Nel suo influente articolo del 1936 "On Computable Numbers", dimostrò che non poteva esistere alcun metodo algoritmico universale per determinare la verità in matematica e che la matematica conterrà sempre proposizioni indecidibili (a differenza delle proposizioni sconosciute). Quel documento introdusse anche la macchina di Turing. Credeva che i computer sarebbero stati capaci di pensiero indistinguibile da quello umano e propose un semplice test (vedi Turing test) per valutare questa capacità. I suoi articoli sull'argomento sono ampiamente riconosciuti come le fondamenta della ricerca sull'intelligenza artificiale. Fece un lavoro prezioso nella crittografia durante la Seconda Guerra Mondiale, svolgendo un ruolo importante nella decodifica del codice Enigma utilizzato dalla Germania per le comunicazioni radio. Dopo la guerra, insegnò presso l'Università di Manchester e iniziò a lavorare su quello che oggi è conosciuto come intelligenza artificiale. In mezzo a questo lavoro rivoluzionario, Turing fu trovato morto nel suo letto, avvelenato dal cianuro. La sua morte seguì il suo arresto per un atto omosessuale (all'epoca un reato) e la condanna a 12 mesi di terapia ormonale.

A seguito di una campagna pubblica nel 2009, il Primo Ministro britannico Gordon Brown fece una scusa pubblica ufficiale a nome del governo britannico per il trattamento orribile riservato a Turing. La Regina Elisabetta II concesse un perdono postumo nel 2013. Il termine "Alan Turing law" è ora usato informalmente per riferirsi a una legge del 2017 nel Regno Unito che ha concesso il perdono retroattivo agli uomini ammoniti o condannati sotto la legislazione storica che vietava gli atti omosessuali.

Turing ha un'estesa eredità con statue di lui e molte cose a lui intitolate, tra cui un premio annuale per le innovazioni in informatica. Appare sulla banconota da £50 della Bank of England, rilasciata il 23 giugno 2021, in coincidenza con il suo compleanno. Una serie della BBC del 2019, votata dal pubblico, lo ha nominato la più grande persona del 20° secolo.


## [Ingegneria del Software](Software%20Engineering/readme.md)
L'ingegneria del software è il ramo dell'informatica che si occupa della progettazione, dello sviluppo, del collaudo e della manutenzione delle applicazioni software. Gli ingegneri del software applicano i principi dell'ingegneria e la conoscenza dei linguaggi di programmazione per creare soluzioni software per gli utenti finali.

Vediamo le varie definizioni di ingegneria del software:

- IEEE, nel suo standard 610.12-1990, definisce l'ingegneria del software come l'applicazione di un approccio sistematico, disciplinato e calcolabile per lo sviluppo, l'operazione e la manutenzione del software.
- Fritz Bauer la definisce come "l'istituzione e l'uso di principi ingegneristici standard. Aiuta a ottenere software economico, affidabile e che funziona

 in modo efficiente su macchine reali."
- Boehm definisce l'ingegneria del software come "l'applicazione pratica della conoscenza scientifica alla progettazione creativa e alla costruzione di programmi per computer. Include anche la documentazione associata necessaria per svilupparli, gestirli e mantenerli."

### Compiti e responsabilità dell'ingegnere del software
Gli ingegneri di successo sanno come utilizzare i giusti linguaggi di programmazione, piattaforme e architetture per sviluppare tutto, dai giochi per computer ai sistemi di controllo della rete. Oltre a costruire i propri sistemi, gli ingegneri del software testano, migliorano e mantengono anche il software sviluppato da altri ingegneri.

In questo ruolo, le tue attività quotidiane potrebbero includere:

- Progettare e mantenere sistemi software
- Valutare e testare nuovi programmi software
- Ottimizzare il software per velocità e scalabilità
- Scrivere e testare codice
- Consultarsi con clienti, ingegneri, specialisti della sicurezza e altre parti interessate
- Presentare nuove funzionalità alle parti interessate e ai clienti interni

### Fasi dell'Ingegneria del Software
Il processo di ingegneria del software comprende diverse fasi, tra cui la raccolta dei requisiti, la progettazione, l'implementazione, il collaudo e la manutenzione. Seguendo un approccio disciplinato allo sviluppo del software, gli ingegneri del software possono creare software di alta qualità che soddisfa le esigenze degli utenti.

- La prima fase dell'ingegneria del software è la raccolta dei requisiti. In questa fase, l'ingegnere del software lavora con il cliente per determinare i requisiti funzionali e non funzionali del software. I requisiti funzionali descrivono cosa dovrebbe fare il software, mentre i requisiti non funzionali descrivono come dovrebbe farlo. La raccolta dei requisiti è una fase critica, poiché pone le basi per l'intero processo di sviluppo del software.

- Dopo la raccolta dei requisiti, la fase successiva è la progettazione. In questa fase, l'ingegnere del software crea un piano dettagliato per l'architettura e la funzionalità del software. Questo piano include un documento di progettazione del software che specifica la struttura, il comportamento e le interazioni del software con altri sistemi. Il documento di progettazione del software è essenziale poiché funge da guida per la fase di implementazione.

- La fase di implementazione è dove l'ingegnere del software crea il codice effettivo per il software. Questo è il momento in cui il documento di progettazione viene trasformato in software funzionante. La fase di implementazione comprende la scrittura del codice, la compilazione e il collaudo per garantire che soddisfi i requisiti specificati nel documento di progettazione.

- Il collaudo è una fase critica nell'ingegneria del software. In questa fase, l'ingegnere del software verifica che il software funzioni correttamente, sia affidabile e facile da usare. Questo coinvolge diversi tipi di collaudo, tra cui collaudo unitario, collaudo di integrazione e collaudo del sistema. Il collaudo assicura che il software soddisfi i requisiti e funzioni come previsto.

- L'ultima fase dell'ingegneria del software è la manutenzione. In questa fase, l'ingegnere del software apporta modifiche al software per correggere errori, aggiungere nuove funzionalità o migliorare le prestazioni. La manutenzione è un processo continuo che continua per tutta la durata del software.

### Perché l'Ingegneria del Software è Popolare?

- **Informatica**: Fornisce le basi scientifiche per il software così come l'ingegneria elettrica dipende principalmente dalla fisica.
- **Scienze Gestionali**: L'ingegneria del software è intensiva dal punto di vista del lavoro e richiede controllo tecnico e manageriale. Pertanto, è ampiamente utilizzata nelle scienze gestionali.
- **Economia**: In questo settore, l'ingegneria del software aiuta a stimare le risorse e controllare i costi. Un sistema informatico deve essere sviluppato e i dati devono essere mantenuti regolarmente all'interno di un budget definito.
- **Ingegneria dei Sistemi**: La maggior parte del software è un componente di un sistema molto più grande. Ad esempio, il software in un sistema di monitoraggio industriale o il software di volo su un aereo. I metodi di ingegneria del software dovrebbero essere applicati allo studio di questo tipo di sistema.


## [Data Science](Data%20Science/readme.md)

La Data Science estrae informazioni preziose dai dati spesso disordinati applicando informatica, statistica e conoscenza del dominio in considerazione. Esempi di utilizzo della data science includono la derivazione del sentimento dei clienti dai record delle chiamate o i sistemi di raccomandazione basati sui dati di vendita.

## [Circuiti Integrati](Integrated%20Circuits/readme.md)

Un circuito integrato o circuito integrato monolitico (indicato anche come IC, chip o microchip) è un insieme di circuiti elettronici su un piccolo pezzo piatto (o "chip") di materiale semiconduttore, di solito silicio. Moltissimi piccoli MOSFET (transistor a effetto di campo metallo-ossido-semiconduttore) vengono integrati in un piccolo chip. Ciò si traduce in circuiti che sono ordini di grandezza più piccoli, più veloci e meno costosi di quelli costruiti con componenti elettronici discreti. La capacità di produzione di massa degli IC, la loro affidabilità e l'approccio modulare alla progettazione di circuiti integrati hanno assicurato la rapida adozione degli IC standardizzati al posto dei transistor discreti. Gli IC sono ora utilizzati in quasi tutte le apparecchiature elettroniche e hanno rivoluzionato il mondo dell'elettronica. Computer, telefoni cellulari e altri elettrodomestici sono ormai parti inseparabili della struttura delle società moderne, resi possibili dalle piccole dimensioni e dal basso costo degli IC come i moderni processori per computer e microcontrollori.

L'integrazione su larga scala è diventata pratica grazie ai progressi tecnologici nella fabbricazione di dispositivi semiconduttori MOS. Dai loro esordi negli anni '60, la dimensione, la velocità e la capacità dei chip sono progredite enormemente, grazie agli avanzamenti tecnici che consentono di inserire sempre più transistor MOS su chip della stessa dimensione: un chip moderno può avere molti miliardi di transistor MOS in un'area delle dimensioni di un'unghia umana. Questi progressi, seguendo approssimativamente la legge di Moore, fanno sì che i chip di oggi abbiano milioni di volte la capacità e migliaia di volte la velocità dei chip dei primi anni '70.

Gli IC hanno due principali vantaggi rispetto ai circuiti discreti: costo e prestazioni. Il costo è basso perché i chip, con tutti i loro componenti, sono stampati come un'unità tramite fotolitografia anziché essere costruiti un transistor alla volta. Inoltre, i circuiti integrati confezionati utilizzano molto meno materiale rispetto ai circuiti discreti. Le prestazioni sono elevate perché i componenti dell'IC commutano rapidamente e consumano relativamente poca energia grazie alle loro piccole dimensioni e alla loro vicinanza. Lo svantaggio principale degli IC è l'elevato costo di progettazione e fabbricazione delle maschere fotolitografiche richieste. Questo alto costo iniziale rende gli IC commercialmente viabili solo quando si prevede una produzione di grandi volumi.

### Tipi

I distributori di componenti elettronici moderni spesso suddividono ulteriormente i circuiti integrati:

- I circuiti integrati digitali sono categorizzati come IC logici (come microprocessori e microcontrollori), chip di memoria (come memoria MOS e memoria a gate flottante), IC di interfaccia (shifter di livello, serializer/deserializer, ecc.), IC di gestione dell'alimentazione e dispositivi programmabili.
- I circuiti integrati analogici sono categorizzati come circuiti integrati lineari e circuiti a radiofrequenza (circuiti RF).
- I circuiti integrati a segnali misti sono categorizzati come IC di acquisizione dati (convertitori A/D, convertitori D/A e potenziometri digitali), IC di temporizzazione/clock, circuiti a capacità commutata (SC) e circuiti CMOS RF.
- I circuiti integrati tridimensionali (IC 3D) sono categorizzati in IC con via attraverso il silicio (TSV) e IC con connessione Cu-Cu.


## [Programmazione Orientata agli Oggetti](Object%20Oriented%20Programming/readme.md)

La programmazione orientata agli oggetti è un paradigma di programmazione fondamentale basato sui concetti di oggetti e dati.

È il modo standard di scrivere codice che ogni programmatore deve seguire per garantire una migliore leggibilità e riutilizzabilità del codice.

###  Ci sono quattro concetti base della programmazione orientata agli oggetti:
- Astrazione
- Incapsulamento
- Ereditarietà
- Polimorfismo

Leggi di più su questi concetti della programmazione orientata agli oggetti [qui](Object%20Oriented%20Programming/readme.md)



## [Programmazione Funzionale](Functional%20Programming/readme.md)

In informatica, la programmazione funzionale è un paradigma di programmazione in cui i programmi sono costruiti applicando e componendo funzioni. È un paradigma di programmazione dichiarativa in cui le definizioni delle funzioni sono alberi di espressioni che mappano valori su altri valori, piuttosto che una sequenza di istruzioni imperative che aggiornano lo stato del programma in esecuzione.

Nella programmazione funzionale, le funzioni sono trattate come cittadini di prima classe, il che significa che possono essere legate a nomi (compresi identificatori locali), passate come argomenti e restituite da altre funzioni, proprio come qualsiasi altro tipo di dato. Questo consente di scrivere programmi in uno stile dichiarativo e composabile, dove piccole funzioni sono combinate in modo modulare.

La programmazione funzionale è talvolta trattata come sinonimo di programmazione puramente funzionale, un sottoinsieme della programmazione funzionale che tratta tutte le funzioni come funzioni matematiche deterministiche, o funzioni pure. Quando una funzione pura è chiamata con determinati argomenti, restituirà sempre lo stesso risultato e non può essere influenzata da alcuno stato mutabile o altri effetti collaterali. Questo contrasta con le procedure impure, comuni nella programmazione imperativa, che possono avere effetti collaterali (come modificare lo stato del programma o prendere input da un utente). I sostenitori della programmazione puramente funzionale affermano che, limitando gli effetti collaterali, i programmi possono avere meno bug, essere più facili da eseguire il debug e testare, e essere più adatti alle procedure di verifica formale.

La programmazione funzionale ha le sue radici nell'accademia, evolvendosi dal calcolo lambda, un sistema formale di calcolo basato solo su funzioni. La programmazione funzionale è storicamente stata meno popolare rispetto alla programmazione imperativa, ma molti linguaggi funzionali sono oggi utilizzati nell'industria e nell'istruzione.

Alcuni esempi di linguaggi di programmazione funzionale sono:
- <a href="https://lisp-lang.org/"> Common Lisp </a>
- <a href="https://www.scheme.org/"> Scheme </a>
- <a href="https://racket-lang.org/"> Racket </a>
- <a href="https://www.erlang.org/"> Erlang </a>
- <a href="https://www.haskell.org/"> Haskell </a>
- <a href="https://fsharp.org/"> F# </a>
- <a href="https://cs.lmu.edu/~ray/notes/introml/"> ML </a>

La programmazione funzionale è derivata storicamente dal *calcolo lambda*. Il calcolo lambda è un framework sviluppato da Alonzo Church per studiare i calcoli con le funzioni. È spesso chiamato "il linguaggio di programmazione più piccolo del mondo." Fornisce una definizione di ciò che è computabile e ciò che non lo è. È equivalente a una macchina di Turing nella sua capacità computazionale e qualsiasi cosa computabile dal calcolo lambda, proprio come qualsiasi cosa computabile da una macchina di Turing, è computabile. Fornisce un framework teorico per descrivere le funzioni e le loro valutazioni.

Alcuni concetti essenziali della programmazione funzionale sono:
- Funzioni pure
- Ricorsione
- Trasparenza referenziale
- Funzioni come prime classi e funzioni di ordine superiore
- Le variabili sono immutabili.

**Funzioni pure**: Queste funzioni hanno due proprietà principali. Prima, producono sempre lo stesso output per gli stessi argomenti indipendentemente da qualsiasi altra cosa. In secondo luogo, non hanno effetti collaterali, ovvero non modificano argomenti o variabili locali/globali o flussi di input/output. Questa ultima proprietà è chiamata *immutabilità*. L'unico risultato di una funzione pura è il valore che restituisce. Sono deterministiche. I programmi scritti usando la programmazione funzionale sono facili da eseguire il debug perché non hanno effetti collaterali o I/O nascosto. Le funzioni pure rendono anche più facile scrivere applicazioni parallele/concurrenti. Quando il codice è scritto in questo stile, un compilatore intelligente può fare molte cose: può parallelizzare le istruzioni, attendere di valutare i risultati fino a quando sono necessari e memorizzare i risultati poiché i risultati non cambiano finché l'input non cambia. Ecco un semplice esempio di una funzione pura in Python:

```python
def sum(x ,y): # sum è una funzione che prende x e y come argomenti
    return x + y  # restituisce x + y senza cambiare il valore
```

**Ricorsione**: Non ci sono loop "for" o "while" nei linguaggi di programmazione funzionale pura. L'iterazione è implementata attraverso la ricorsione. Le funzioni ricorsive chiamano ripetutamente se stesse fino a quando viene raggiunto un caso base. Ecco un semplice esempio di una funzione ricorsiva in C:

```c
int fib(n) {
  if(n <= 1)
    return 1;
   else
     return (fib(n-1) + fib(n-2));
}
```

**Trasparenza referenziale**: Nei programmi funzionali, le variabili una volta definite non cambiano il loro valore durante l'esecuzione del programma. I programmi funzionali non hanno istruzioni di assegnamento. Se dobbiamo memorizzare un valore, definiamo una nuova variabile. Questo elimina qualsiasi possibilità di effetti collaterali perché qualsiasi variabile può essere sostituita con il suo valore effettivo in qualsiasi punto dell'esecuzione. Lo stato di qualsiasi variabile è costante in ogni istante. Esempio:

```bash
x = x + 1 # questo ha cambiato il valore assegnato alla variabile x
         # Pertanto, l'espressione NON è referenzialmente trasparente
```

**Le funzioni sono di prima classe e possono essere di ordine superiore**: Le funzioni di prima classe sono trattate come variabili di prima classe. Le variabili di prima classe possono essere passate alle funzioni come parametri, possono essere restituite dalle funzioni o memorizzate in strutture dati.

Una combinazione di applicazioni di funzioni può essere definita usando una forma LISP chiamata **funcall**, che prende come argomenti una funzione e una serie di argomenti e applica quella funzione a quegli argomenti:

```Lisp
(defun filter (list-of-elements test)
    (cond ((null list-of-elements) nil)
          ((funcall test (car list-of-elements))
            (cons (car list-of-elements)
                (filter (cdr list-of-elements)
                      test)))
           (t (filter (cdr list-of-elements)
                       test))))
```

La funzione **filter** applica il test al primo elemento della lista. Se il test restituisce non-nil, consente l'elemento al risultato di filter applicato al cdr della lista; altrimenti, restituisce semplicemente il cdr filtrato. Questa funzione può essere utilizzata con diversi predicati passati come parametri per eseguire una varietà di compiti di filtraggio:

```Lisp
    > (filter '(1 3 -9 5 -2 -7 6) #'plusp)   ; filtra tutti i numeri negativi
```    
    output: (1 3 5 6)

```Lisp
   > (filter '(1 2 3 4 5 6 7 8 9) #'evenp)   ; filtra tutti i numeri dispari
```   
   output: (2 4 6 8)

   e così via.

**Le variabili sono immutabili**: Nella programmazione funzionale, non possiamo modificare una variabile dopo che è stata inizializzata. Possiamo creare nuove variabili, ma non possiamo modificare quelle esistenti, e questo aiuta a mantenere lo stato durante l'esecuzione di un programma. Una volta creata una variabile e impostato il suo valore, possiamo avere piena fiducia sapendo che il valore di quella variabile non cambierà mai.


## [Sistemi Operativi](Operating%20Systems/readme.md)

Un sistema operativo (o OS in breve) funge da intermediario tra un utente del computer e l'hardware del computer. Lo scopo di un sistema operativo è fornire un ambiente in cui un utente possa eseguire programmi in modo conveniente ed efficiente.

Un sistema operativo è un software che gestisce l'hardware del computer. L'hardware deve fornire meccanismi appropriati per garantire il corretto funzionamento del sistema informatico e per prevenire che i programmi degli utenti interferiscano con il funzionamento corretto del sistema.

Una definizione ancora più comune è che il sistema operativo è l'unico programma che è sempre in esecuzione sul computer (di solito chiamato kernel), mentre tutto il resto sono programmi applicativi.

I sistemi operativi possono essere visti da due punti di vista: come gestori delle risorse e come macchine estese. Dal punto di vista del gestore delle risorse, il compito del sistema operativo è gestire le diverse parti del sistema in modo efficiente. Dal punto di vista della macchina estesa, il compito del sistema è fornire agli utenti astrazioni che sono più comode da usare rispetto alla macchina reale. Queste includono processi, spazi di indirizzamento e file.

I sistemi operativi hanno una lunga storia, dall'epoca in cui hanno sostituito l'operatore ai moderni sistemi di multiprogrammazione. I momenti salienti includono i primi sistemi batch, i sistemi di multiprogrammazione e i sistemi per computer personali.

Poiché i sistemi operativi interagiscono strettamente con l'hardware, una certa conoscenza dell'hardware del computer è utile per comprenderli. I computer sono costituiti da processori, memorie e dispositivi di I/O. Queste parti sono collegate tramite bus.

I concetti di base su cui sono costruiti tutti i sistemi operativi sono processi, gestione della memoria, gestione degli I/O, sistema dei file e sicurezza. Il cuore di qualsiasi sistema operativo è il set di chiamate di sistema che può gestire. Queste indicano cosa fa il sistema operativo.

### Sistema operativo come gestore delle risorse

Il sistema operativo gestisce tutti i pezzi di un sistema complesso. I computer moderni sono costituiti da processori, memorie, timer, dischi, mouse, interfacce di rete, stampanti e una vasta gamma di altri dispositivi. 

Dal punto di vista dal basso verso l'alto, il compito del sistema operativo è fornire una allocazione ordinata e controllata dei processori, delle memorie e dei dispositivi di I/O tra i vari programmi che ne hanno bisogno.

I moderni sistemi operativi permettono a più programmi di essere in memoria ed eseguiti simultaneamente. Immagina cosa succederebbe se tre programmi in esecuzione su un computer tentassero di stampare il loro output simultaneamente sulla stessa stampante. Il risultato sarebbe un completo caos. Il sistema operativo può portare ordine al potenziale caos memorizzando tutto l'output destinato alla stampante sul disco. Quando un programma è terminato, il sistema operativo può quindi copiare il suo output dal file sul disco per la stampante, mentre allo stesso tempo, l'altro programma può continuare a generare altro output, ignaro del fatto che l'output non sta andando ancora alla stampante.

Quando un computer (o una rete) ha più di un utente, è necessario gestire e proteggere la memoria, i dispositivi di I/O e altre risorse ancora di più, poiché gli utenti potrebbero altrimenti interferire tra loro. Inoltre, gli utenti spesso devono condividere non solo l'hardware ma anche informazioni (file, database, ecc.). In breve, questo punto di vista del sistema operativo sostiene che il suo compito principale è tenere traccia di quali programmi stanno usando quale risorsa, concedere le richieste di risorse, contabilizzare l'uso e mediare le richieste conflittuali tra diversi programmi e utenti.

### Sistema operativo come macchina estesa

L'architettura della maggior parte dei computer a livello di linguaggio macchina è primitiva e scomoda da programmare, specialmente per l'input/output. Per rendere questo punto più concreto, considera i moderni dischi rigidi SATA (Serial ATA) utilizzati nella maggior parte dei computer. Cosa dovrebbe sapere un programmatore per utilizzare il disco. Da allora, l'interfaccia è stata rivista più volte ed è più complicata rispetto al 2007. Nessun programmatore sano di mente vorrebbe trattare con questo disco a livello hardware. Invece, un pezzo di software chiamato driver del disco si occupa dell'hardware e fornisce un'interfaccia per leggere e scrivere blocchi del disco, senza entrare nei dettagli.

I sistemi operativi contengono molti driver per il controllo dei dispositivi di I/O. Ma anche questo livello è molto troppo basso per la maggior parte delle applicazioni. Per questo motivo, tutti i sistemi operativi forniscono un ulteriore livello di astrazione per l'utilizzo dei dischi: i file. Utilizzando questa astrazione, i programmi possono creare, scrivere e leggere file senza dover affrontare i dettagli disordinati di come funziona l'hardware. Questa astrazione è la chiave per gestire tutta questa complessità. Buone astrazioni trasformano un compito quasi impossibile in due compiti gestibili. Il primo è definire e implementare le astrazioni. Il secondo è utilizzare queste astrazioni per risolvere il problema in questione.

### Storia dei Sistemi Operativi

- **Prima Generazione (1945-55)**: Poco progresso è stato raggiunto nella costruzione di computer digitali dopo i disastrosi tentativi di Babbage fino all'era della Seconda Guerra Mondiale. Alla Iowa State University, il professor John Atanasoff e il suo studente Clifford Berry crearono quello che oggi è riconosciuto come il primo computer digitale operativo. Konrad Zuse a Berlino costruì il computer Z3 utilizzando relè elettromeccanici quasi nello stesso periodo. Il Mark I fu creato da Howard Aiken ad Harvard, il Colossus da un team di scienziati a Bletchley Park in Inghilterra, e l'ENIAC da William Mauchley e il suo dottorando J. Presper Eckert all'Università della Pennsylvania nel 1944.

- **Seconda Generazione (1955-65)**: L'invenzione del transistor a metà degli anni '50 cambiò drasticamente la situazione. I computer divennero abbastanza affidabili da poter essere fabbricati e venduti ai clienti paganti con l'assunzione che avrebbero continuato a funzionare abbastanza a lungo per eseguire un lavoro significativo. I mainframe, come sono ora conosciuti, erano tenuti chiusi in enormi sale computer particolarmente climatizzate, con squadre di operatori qualificati per gestirli. Solo grandi aziende, importanti enti governativi o istituzioni potevano permettersi il prezzo di diversi milioni di dollari.

- **Terza Generazione (1965-80)**: Rispetto ai computer di seconda generazione, costruiti con transistor singoli, l'IBM 360 fu la prima grande linea di computer a utilizzare circuiti integrati (IC) (in piccola scala). Di conseguenza, offrì un notevole vantaggio in termini di prezzo/performance. Fu un successo immediato e tutti gli altri grandi produttori abbracciarono rapidamente il concetto di una famiglia di computer interoperabili. Tutto il software, incluso il sistema operativo OS/360, doveva essere compatibile con tutti i modelli nel design originale. Doveva funzionare su sistemi enormi, che spesso sostituivano i 7094 per calcoli pesanti e previsioni meteorologiche, e su sistemi piccoli, che spesso sostituivano solo i 1401 per trasferimenti di schede a nastro. Entrambi i sistemi con pochi periferici e i sistemi con molti periferici dovevano funzionare bene con esso. Doveva funzionare sia in ambienti professionali che accademici. Soprattutto, doveva essere efficace per ciascuna di queste numerose applicazioni.

- **Quarta Generazione (1980-Presente)**: L'era dei computer personali iniziò con la creazione di circuiti LSI (Large Scale Integration), processori con migliaia di transistor su un centimetro quadrato di silicio. Anche se i computer personali, originariamente conosciuti come microcomputer, non cambiarono significativamente in architettura rispetto ai minicomputer della classe PDP-11, differivano significativamente nel prezzo.

- **Quinta Generazione (1990-Presente)**: Le persone hanno desiderato un dispositivo di comunicazione portatile sin da quando il detective Dick Tracy nella striscia comica degli anni '40 iniziò a conversare con il suo "orologio radio a due vie". Nel 1946, un vero telefono mobile fece il suo debutto e pesava circa 40 chilogrammi. Il primo vero telefono portatile fece il suo debutto negli anni '70 ed era incredibilmente leggero, circa un chilogrammo. Era scherzosamente chiamato "il mattone". Presto, tutti stavano cercando uno.

### Funzioni di un OS

- **Convenienza**: Un OS rende un computer più conveniente da usare

.
- **Efficienza**: Un OS permette di utilizzare le risorse del sistema informatico in modo efficiente.
- **Capacità di Evolversi**: Un OS dovrebbe essere costruito in modo tale da permettere lo sviluppo, il test e l'introduzione di nuove funzioni di sistema in modo efficace allo stesso tempo senza interferire con il servizio.
- **Throughput**: Un OS dovrebbe essere costruito in modo da fornire il massimo throughput (Numero di compiti per unità di tempo).

### Funzionalità principali di un OS

- **Gestione delle Risorse**: Quando avviene l'accesso parallelo nel sistema operativo, significa che quando più utenti stanno accedendo al sistema, l'OS funge da Gestore delle Risorse. La sua responsabilità è fornire hardware all'utente. Riduce il carico nel sistema.
- **Gestione dei Processi**: Include vari compiti come la pianificazione e la terminazione dei processi. L'OS gestisce vari compiti contemporaneamente. Qui avviene la Pianificazione della CPU, cioè tutti i compiti verrebbero eseguiti da molti algoritmi utilizzati per la pianificazione.
- **Gestione dello Storage**: Il meccanismo del file system utilizzato per la gestione dello storage. NIFS, CFS, CIFS, NFS, ecc. sono alcuni file system. Tutti i dati sono memorizzati in vari tracce dei dischi rigidi che sono tutti gestiti dal gestore dello storage. Include un Disco Rigido.
- **Gestione della Memoria**: Si riferisce alla gestione della memoria primaria. Il sistema operativo deve tenere traccia di quanto memoria è stata utilizzata e da chi. Deve decidere quale processo ha bisogno di spazio in memoria e quanto. L'OS deve anche allocare e deallocare lo spazio in memoria.
- **Gestione della Sicurezza/Privacy**: La privacy è fornita anche dal sistema operativo utilizzando password in modo che applicazioni non autorizzate non possano accedere a programmi o dati. Ad esempio, Windows utilizza l'autenticazione **_Kerberos_** per prevenire accessi non autorizzati ai dati.

### Tipi di Sistemi Operativi

- **OS per Mainframe**:
Alla fascia alta ci sono i sistemi operativi per mainframe, quei computer di dimensioni da sala ancora trovati nei principali centri dati aziendali. Questi computer differiscono dai computer personali in termini di capacità di I/O. Un mainframe con 1000 dischi e milioni di gigabyte di dati non è insolito; un computer personale con queste specifiche sarebbe l'invidia dei suoi amici. I mainframe stanno anche facendo una sorta di ritorno come server di alta gamma, server per siti di commercio elettronico su larga scala e server per transazioni business-to-business. 

I sistemi operativi per mainframe sono fortemente orientati al trattamento di molti lavori contemporaneamente, la maggior parte dei quali richiede enormi quantità di I/O. Offrono tipicamente tre tipi di servizi: batch, elaborazione delle transazioni e time-sharing.

- **OS per Server**:
Un livello sotto ci sono i sistemi operativi per server. Essi girano su server, che sono computer personali molto grandi, workstation o anche mainframe. Servono più utenti contemporaneamente attraverso una rete e permettono agli utenti di condividere risorse hardware e software. I server possono fornire servizi di stampa, servizi di file o servizi Web. I provider di Internet eseguono molti server per supportare i loro clienti e i siti Web utilizzano server per memorizzare pagine Web e gestire le richieste in entrata. Tipici sistemi operativi per server sono Solaris, FreeBSD, Linux e Windows Server 201x.

- **OS per Multiprocessori**:
Un modo sempre più comune per ottenere una potenza di calcolo di alto livello è connettere più CPU in un unico sistema. A seconda di come sono collegati e cosa è condiviso, questi sistemi sono chiamati computer paralleli, multi-computer o multiprocessori. Hanno bisogno di sistemi operativi speciali, ma spesso questi sono variazioni dei sistemi operativi per server, con caratteristiche speciali per la comunicazione, la connettività e la coerenza.

- **OS per Computer Personali**:
La categoria successiva è il sistema operativo per computer personali. Quelli moderni supportano tutti la multiprogrammazione, spesso con decine di programmi avviati all'avvio. Il loro compito è fornire un buon supporto a un singolo utente. Sono ampiamente utilizzati per l'elaborazione di testi, fogli di calcolo, giochi e accesso a Internet. Esempi comuni sono Linux, FreeBSD, Windows 7, Windows 8 e OS X di Apple. I sistemi operativi per computer personali sono così ampiamente conosciuti che probabilmente non è necessaria molta introduzione. Molte persone non sono nemmeno consapevoli che esistono altri tipi.

- **OS per Sistemi Embedded**:
I sistemi embedded girano su computer che controllano dispositivi che non sono generalmente considerati computer e non accettano software installato dall'utente. Esempi tipici sono i forni a microonde, i televisori, le auto, i lettori DVD, i telefoni tradizionali e i lettori MP3. La principale proprietà che distingue i sistemi embedded dai dispositivi portatili è la certezza che nessun software non autorizzato verrà mai eseguito su di essi. Non puoi scaricare nuove applicazioni nel tuo forno a microonde—tutto il software è in ROM. Questo significa che non c'è bisogno di protezione tra le applicazioni, semplificando il design. Sistemi come Embedded Linux, QNX e VxWorks sono popolari in questo dominio.

- **OS per Smart Card**:
I sistemi operativi più piccoli girano su dispositivi smart card delle dimensioni di una carta di credito con chip CPU. Hanno vincoli molto severi di potenza di elaborazione e memoria. Alcuni sono alimentati tramite contatti nel lettore in cui sono inseriti, ma le smart card senza contatto sono alimentate per induzione, limitando notevolmente cosa possono fare. Alcuni possono gestire solo una singola funzione, come i pagamenti elettronici, ma altri possono gestire più funzioni. Spesso questi sono sistemi proprietari. Alcune smart card sono orientate a Java. Questo significa che la ROM sulla smart card contiene un interprete per la Java Virtual Machine (JVM). Gli applet Java (piccoli programmi) vengono scaricati sulla scheda e sono interpretati dall'interprete JVM. Alcune di queste schede possono gestire più applet Java contemporaneamente, portando alla multiprogrammazione e alla necessità di pianificarli. La gestione delle risorse e la protezione diventano anche un problema quando sono presenti due o più applet contemporaneamente. Questi problemi devono essere gestiti dal sistema operativo (di solito estremamente primitivo) presente sulla scheda.


## [Memoria e Archiviazione](Memory%20and%20Storage/readme.md)

### Memoria
Il termine _memoria_ si riferisce al componente all'interno del computer che consente l'accesso ai dati a breve termine. Potresti riconoscere questo componente come DRAM o memoria ad accesso casuale dinamico. Il computer esegue molte operazioni accedendo ai dati memorizzati nella sua memoria a breve termine. Alcuni esempi di tali operazioni includono la modifica di un documento, il caricamento delle applicazioni e la navigazione su Internet. La velocità e le prestazioni del tuo sistema dipendono dalla quantità di memoria installata sul computer.

Se hai una scrivania e un armadietto, la scrivania rappresenta la memoria del computer. Gli oggetti che devi utilizzare immediatamente sono tenuti sulla scrivania per un facile accesso. Tuttavia, non si può memorizzare molto su una scrivania a causa delle sue limitazioni di spazio.

### Archiviazione
Mentre la memoria si riferisce alla posizione dei dati a breve termine, _archiviazione_ è il componente all'interno del computer che ti consente di memorizzare e accedere ai dati a lungo termine. Di solito, l'archiviazione si presenta sotto forma di un'unità a stato solido o di un disco rigido. L'archiviazione contiene le tue applicazioni, il sistema operativo e i file in modo indefinito. I computer devono leggere e scrivere informazioni dal sistema di archiviazione, quindi la velocità dell'archiviazione determina quanto velocemente il sistema può avviarsi, caricare e accedere a ciò che hai salvato.

Mentre la scrivania rappresenta la memoria del computer, l'armadietto rappresenta l'archiviazione del computer. Esso conserva gli oggetti che devono essere salvati e memorizzati, ma non sono necessariamente necessari per un accesso immediato. La dimensione dell'armadietto significa che può contenere molte cose.

**Una distinzione importante** tra memoria e archiviazione è che la memoria si cancella quando il computer viene spento. D'altra parte, l'archiviazione rimane intatta indipendentemente da quante volte spegni il computer. Pertanto, nell'analogia tra scrivania e armadietto, qualsiasi file lasciato sulla tua scrivania verrà gettato via quando lasci l'ufficio. Tutto ciò che è nel tuo armadietto rimarrà.

### Memoria Virtuale
Al centro dei sistemi informatici c'è la memoria, lo spazio in cui i programmi vengono eseguiti e i dati sono memorizzati. Ma cosa succede quando i programmi che stai eseguendo e i dati con cui stai lavorando superano la capacità fisica della memoria del computer? Qui entra in gioco la memoria virtuale, che funge da estensione intelligente alla memoria del computer e ne migliora le capacità.

**Definizione e Scopo della Memoria Virtuale:**

La memoria virtuale è una tecnica di gestione della memoria impiegata dai sistemi operativi per superare le limitazioni della memoria fisica (RAM). Crea un'illusione per le applicazioni software di avere accesso a una quantità di memoria maggiore rispetto a quella fisicamente installata sul computer. In sostanza, consente ai programmi di utilizzare spazio di memoria al di là dei confini della RAM fisica del computer.

Lo scopo principale della memoria virtuale è consentire un multitasking efficiente e l'esecuzione di programmi più grandi, mantenendo al contempo la reattività del sistema. Questo viene ottenuto creando un'interazione fluida tra la RAM fisica e i dispositivi di archiviazione secondari, come il disco rigido o l'SSD.

**Come la Memoria Virtuale Estende la Memoria Fisica Disponibile:**

Considera la memoria virtuale come un ponte che collega la RAM del computer e l'archiviazione secondaria (unità disco). Quando esegui un programma, parti di esso vengono caricate nella memoria fisica più veloce (RAM). Tuttavia, non tutte le parti del programma potrebbero essere utilizzate immediatamente.

La memoria virtuale sfrutta questa situazione spostando le sezioni del programma che non sono attivamente utilizzate dalla RAM all'archiviazione secondaria, creando più spazio nella RAM per le parti che sono attivamente in uso. Questo processo è trasparente per l'utente e per i programmi in esecuzione. Quando le parti spostate sono nuovamente necessarie, vengono trasferite di nuovo nella RAM, mentre altre parti meno attive possono essere spostate nell'archiviazione secondaria.

Questo scambio dinamico di dati dentro e fuori dalla memoria fisica è gestito dal sistema operativo. Consente ai programmi di funzionare anche se sono più grandi della RAM disponibile, poiché il sistema operativo decide intelligentemente quali dati devono essere nella RAM per un'ottimale performance.

In sintesi, la memoria virtuale funge da strato di virtualizzazione che estende la memoria fisica disponibile trasferendo temporaneamente parti di programmi e dati tra la RAM e l'archiviazione secondaria. Questo processo garantisce che il computer possa gestire compiti più grandi e numerosi programmi simultaneamente, mantenendo al contempo prestazioni e reattività efficienti.


## [File System](File%20System/readme.md)

In informatica, un sistema di file o filesystem (spesso abbreviato in fs) è un metodo e una struttura dati che il sistema operativo utilizza per controllare come i dati sono memorizzati e recuperati. Senza un sistema di file, i dati immagazzinati in un supporto di memorizzazione sarebbero un grande corpo di dati senza modo di sapere dove finisce un pezzo di dati e dove inizia il successivo o dove si trova un dato quando è il momento di recuperarlo. Separando i dati in pezzi e dando a ciascun pezzo un nome, i dati sono facilmente isolati e identificati. Prendendo il nome da come è denominato un sistema di gestione dei dati cartaceo, ogni gruppo di dati è chiamato "file". La struttura e le regole logiche utilizzate per gestire i gruppi di dati e i loro nomi sono chiamate "sistema di file".

Esistono molti tipi di sistemi di file, ciascuno con una struttura e una logica uniche, proprietà di velocità, flessibilità, sicurezza, dimensioni e altro ancora. Alcuni sistemi di file sono stati progettati per applicazioni specifiche. Ad esempio, il sistema di file ISO 9660 è progettato specificamente per i dischi ottici.

I sistemi di file possono essere utilizzati su molti tipi di dispositivi di archiviazione utilizzando vari media. A partire dal 2019, i dischi rigidi sono stati dispositivi di archiviazione chiave e si prevede che rimarranno tali nel prossimo futuro. Altri tipi di media utilizzati includono SSD, nastri magnetici e dischi ottici. In alcuni casi, come con tmpfs, la memoria principale del computer (memoria ad accesso casuale, RAM) crea un sistema di file temporaneo per un uso a breve termine.

Alcuni sistemi di file sono utilizzati su dispositivi di archiviazione locale; altri forniscono accesso ai file tramite un protocollo di rete (ad esempio, NFS, SMB o client 9P). Alcuni sistemi di file sono "virtuali", il che significa che i "file" forniti (chiamati file virtuali) vengono calcolati su richiesta (come procfs e sysfs) o sono semplicemente una mappatura in un altro sistema di file utilizzato come archivio di supporto. Il sistema di file gestisce l'accesso sia al contenuto dei file sia ai metadati su tali file. È responsabile dell'organizzazione dello spazio di archiviazione; l'affidabilità, l'efficienza e la regolazione rispetto al supporto di memorizzazione fisico sono considerazioni progettuali importanti.

### Come funzionano i sistemi di file
Un sistema di file memorizza e organizza i dati e può essere considerato come un tipo di indice per tutti i dati contenuti in un dispositivo di archiviazione. Questi dispositivi possono includere dischi rigidi, dischi ottici e unità flash.

I sistemi di file specificano convenzioni per la denominazione dei file, inclusi il numero massimo di caratteri in un nome, quali caratteri possono essere utilizzati e, in alcuni sistemi, quanto può essere lunga l'estensione del nome del file. In molti sistemi di file, i nomi dei file non sono sensibili al caso.

Oltre al file stesso, i sistemi di file contengono informazioni come le dimensioni del file e i suoi attributi, la posizione e la gerarchia nella directory nei metadati. I metadati possono anche identificare blocchi liberi di spazio disponibile sull'unità e quanto spazio è disponibile.

Un sistema di file include anche un formato per specificare il percorso a un file attraverso la struttura delle directory. Un file è collocato in una directory - o in una cartella in Windows OS - o in una sottodirectory nel punto desiderato della struttura ad albero. I sistemi operativi PC e mobili hanno sistemi di file in cui i file sono collocati in una struttura ad albero gerarchica.

Prima che i file e le directory vengano creati sul supporto di memorizzazione, le partizioni devono essere messe in atto. Una partizione è una regione del disco rigido o di un altro supporto che il sistema operativo gestisce separatamente. Un sistema di file è contenuto nella partizione principale e alcuni sistemi operativi consentono più partizioni su un disco. In questo caso, se un sistema di file si corrompe, i dati in una partizione diversa saranno al sicuro.

### Tipi di sistemi di file
Esistono diversi tipi di sistemi di file, tutti con diverse strutture logiche e proprietà, come velocità e dimensioni. Il tipo di sistema di file può variare a seconda del sistema operativo e delle esigenze di quel sistema operativo. Microsoft Windows, Mac OS X e Linux sono i tre sistemi operativi PC più comuni. I sistemi operativi mobili includono Apple iOS e Google Android.

I principali sistemi di file includono i seguenti:

- La tabella di allocazione dei file (FAT) è supportata dal sistema operativo Microsoft Windows. FAT è considerato semplice e affidabile e modellato sui sistemi di file legacy. FAT è stato progettato nel 1977 per i dischetti, ma è stato successivamente adattato per i dischi rigidi. Sebbene sia efficiente e compatibile con la maggior parte dei sistemi operativi attuali, FAT non può eguagliare le prestazioni e la scalabilità dei sistemi di file più moderni.

- Il Global File System (GFS) è un sistema di file per il sistema operativo Linux ed è un sistema di file su disco condiviso. GFS offre accesso diretto all'archiviazione a blocchi condivisi e può essere utilizzato come sistema di file locale.

- GFS2 è una versione aggiornata con funzionalità non incluse nel GFS originale, come un sistema di metadati aggiornato. Sotto i termini della GNU General Public License, sia i sistemi di file GFS che GFS2 sono disponibili come software gratuito.

- Il Hierarchical File System (HFS) è stato sviluppato per essere utilizzato con i sistemi operativi Mac. L'HFS può essere anche chiamato Mac OS Standard, succeduto da Mac OS Extended. Introdotto originariamente nel 1985 per dischetti e dischi rigidi, l'HFS ha sostituito il sistema di file Macintosh originale. Può essere utilizzato anche su CD-ROM.

- Il New Technology File System (NTFS) è il sistema di file predefinito per i prodotti Windows a partire dal sistema operativo Windows NT 3.1. I miglioramenti rispetto al precedente sistema di file FAT includono un migliore supporto ai metadati, prestazioni e utilizzo dello spazio su disco. NTFS è anche supportato nel sistema operativo Linux attraverso un driver NTFS gratuito e open source. I sistemi operativi Mac hanno supporto in sola lettura per NTFS.

- Il Universal Disk Format (UDF) è un sistema di file neutro dal fornitore per i media ottici e i DVD. UDF sostituisce il sistema di file ISO 9660 ed è il sistema di file ufficiale per video e audio DVD, come scelto dal DVD Forum.

## [Cloud Computing](Cloud%20Computing/Readme.md)
Il cloud computing è la capacità di accedere a informazioni e applicazioni tramite Internet. Il cloud computing consente agli utenti di accedere a applicazioni e dati da qualsiasi posizione con una connessione a Internet.

Il cloud computing è un tipo di elaborazione basata su Internet che fornisce risorse di elaborazione e dati condivisi a computer e altri dispositivi su richiesta.

È un modello per abilitare l'accesso universale, conveniente e su richiesta a un pool condiviso di risorse informatiche configurabili (ad esempio, reti, server, archiviazione, applicazioni e servizi) che possono essere rapidamente fornite e rilasciate con un minimo sforzo di gestione o interazione con il fornitore di servizi.

### Principali vantaggi del cloud computing

Il cloud computing rappresenta un grande cambiamento nel modo in cui le aziende pensano alle risorse IT. Ecco sette motivi comuni per cui le organizzazioni si stanno rivolgendo ai servizi di cloud computing:

**Costo**
Il cloud computing elimina la spesa di capitale per l'acquisto di hardware e software e per l'allestimento e la gestione dei data center sul posto: gli scaffali di server, l'elettricità continua per l'alimentazione e il raffreddamento e gli esperti IT per gestire l'infrastruttura. I costi si accumulano rapidamente.

**Velocità**
La maggior parte dei servizi di cloud computing sono forniti in modalità self-service e su richiesta, quindi anche grandi quantità di risorse informatiche possono essere fornite in pochi minuti, tipicamente con solo pochi clic del mouse, offrendo alle aziende molta flessibilità e togliendo la pressione dalla pianificazione della capacità.

**Scala globale**
I benefici dei servizi di cloud computing includono la capacità di scalare elasticamente. Nel linguaggio del cloud, questo significa fornire la giusta quantità di risorse IT—ad esempio, maggiore o minore potenza di calcolo, archiviazione e banda—esattamente quando è necessario e dalla giusta posizione geografica.

**Produttività**
I data center sul posto richiedono tipicamente molta "installazione e configurazione"—impost

azione hardware, aggiornamento software e altre mansioni di gestione IT che richiedono tempo. Il cloud computing elimina la necessità di molte di queste attività, così i team IT possono dedicare tempo al raggiungimento di obiettivi aziendali più importanti.

**Prestazioni**
I maggiori servizi di cloud computing operano su una rete mondiale di data center sicuri, che vengono regolarmente aggiornati con l'ultima generazione di hardware di calcolo veloce ed efficiente. Questo offre diversi vantaggi rispetto a un singolo data center aziendale, inclusa una riduzione della latenza di rete per le applicazioni e maggiori economie di scala.

**Affidabilità**
Il cloud computing rende più facile e meno costoso il backup dei dati, il recupero da disastri e la continuità aziendale poiché i dati possono essere replicati in più siti ridondanti sulla rete del fornitore di servizi cloud.

**Sicurezza**
Molti fornitori di cloud offrono un ampio insieme di politiche, tecnologie e controlli che rafforzano la tua postura di sicurezza complessiva, aiutando a proteggere i tuoi dati, applicazioni e infrastrutture da potenziali minacce.

### Tipi di Servizi di Cloud Computing
- [Infrastruttura come Servizio (IaaS)](Cloud%20Computing/Readme.md#infrastructure-as-a-service-iaas)
- [Piattaforma come Servizio (PaaS)](Cloud%20Computing/Readme.md#platform-as-a-service-paas)
- [Software come Servizio (SaaS)](Cloud%20Computing/Readme.md#software-as-a-service-saas)


## [Machine Learning](Machine%20Learning/)

Il machine learning è la pratica di insegnare a un computer ad apprendere. Il concetto utilizza il riconoscimento dei modelli, così come altre forme di algoritmi predittivi, per formulare giudizi sui dati in arrivo. Questo campo è strettamente correlato all'intelligenza artificiale e alla statistica computazionale.

### Esistono tre sottocategorie del machine learning:

### Machine learning supervisionato
In questo tipo, i modelli di machine learning vengono addestrati con set di dati etichettati, che permettono ai modelli di apprendere e migliorare con maggiore precisione nel tempo. Ad esempio, un algoritmo verrebbe addestrato con immagini di cani e altri oggetti, tutti etichettati da umani, e la macchina imparerebbe a identificare le immagini di cani autonomamente. Il machine learning supervisionato è il tipo più comune utilizzato oggi.

Applicazioni pratiche del Machine Learning Supervisionato – 
1. **Bioinformatica:** La bioinformatica è lo studio di come gli individui conservano conoscenze biologiche come impronte digitali, texture degli occhi, lobi delle orecchie e così via. I telefoni cellulari sono ora abbastanza intelligenti da comprendere i nostri dati biologici e poi verificarci per aumentare la sicurezza del sistema.
2. **Riconoscimento vocale:** È il tipo di programma in cui puoi trasmettere la tua voce al programma, e esso ti riconoscerà. I dispositivi reali più noti sono assistenti digitali come Google Assistant o Siri, che rispondono al termine solo con la tua voce.
3. **Rilevamento dello spam:** Questo strumento viene utilizzato per prevenire l'invio di comunicazioni false o generate da macchina. Gmail include un algoritmo che apprende numerosi termini sbagliati. L'app Messaggi di Oneplus chiede all'utente di specificare quali termini dovrebbero essere bloccati, e la parola chiave impedirà tali testi dall'app.
4. **Riconoscimento oggetti per la visione:** Questo tipo di software è utilizzato quando devi definire qualcosa. Hai un grande dataset che utilizzi per addestrare l'algoritmo, e può riconoscere un nuovo oggetto utilizzando questo.

### Machine learning non supervisionato
Nel machine learning non supervisionato, un programma cerca schemi nei dati non etichettati. Il machine learning non supervisionato può scoprire schemi o tendenze che le persone non stanno cercando esplicitamente. Ad esempio, un programma di machine learning non supervisionato potrebbe esaminare i dati delle vendite online e identificare diversi tipi di clienti che effettuano acquisti.

Applicazioni pratiche del Machine Learning Non Supervisionato
1. **Clustering:** Il clustering è il processo di categorizzazione dei dati in gruppi separati. Quando non conosciamo tutti i dettagli sui cluster, possiamo utilizzare il machine learning non supervisionato per clusterizzarli. Il machine learning non supervisionato viene utilizzato per analizzare e organizzare dati che non hanno classi o proprietà di classe pre-etichettate. Il clustering può aiutare le aziende a gestire i loro dati in modo più efficace.
   Supponiamo che tu abbia un canale YouTube. Potresti avere molte informazioni sui tuoi abbonati. Se vuoi trovare abbonati simili, dovresti utilizzare una tecnica di clustering.
2. **Visualizzazione:** Il processo di creazione di diagrammi, foto, grafici, tabelle e così via per presentare informazioni è noto come visualizzazione. Il machine learning non supervisionato può essere utilizzato per implementare questa strategia.
   Supponiamo che tu sia un allenatore di cricket con informazioni riguardanti le prestazioni della tua squadra in un torneo. Potresti voler trovare rapidamente tutte le statistiche delle partite. Puoi passare i dati non etichettati e complessi a un algoritmo di visualizzazione.
3. **Rilevamento delle anomalie:** Il rilevamento delle anomalie è la scoperta di cose, eventi o osservazioni insoliti che sollevano sospetti deviando notevolmente dai dati normali. In questo caso, il sistema è programmato con un gran numero di casi tipici. Pertanto, quando rileva un evento inatteso, può determinare se si tratta di un'anomalia o meno.
   Il rilevamento delle frodi con carta di credito è un buon esempio di questo. Questo problema viene ora affrontato utilizzando approcci di rilevamento delle anomalie nel machine learning non supervisionato. Per evitare frodi, il sistema identifica transazioni con carta di credito inaspettate.

### Machine learning semi-supervisionato
Lo svantaggio del machine learning supervisionato è che richiede etichettatura manuale da parte di specialisti di ML o scienziati dei dati e comporta un alto costo di elaborazione. Il machine learning non supervisionato ha anche uno spettro limitato per le sue applicazioni. Per superare questi svantaggi degli algoritmi di machine learning supervisionato e non supervisionato, è stato introdotto il concetto di machine learning semi-supervisionato. Tipicamente, questa combinazione contiene una quantità molto piccola di dati etichettati e una grande quantità di dati non etichettati. La procedura di base consiste nel fatto che prima il programmatore clasterizza i dati simili utilizzando un algoritmo di machine learning non supervisionato e poi utilizza i dati etichettati esistenti per etichettare il resto dei dati non etichettati.

Applicazioni pratiche del Machine Learning Semi-Supervisionato – 
1. **Analisi del parlato:** Poiché l'etichettatura dei file audio è un compito molto intensivo, il machine learning semi-supervisionato è un approccio molto naturale per risolvere questo problema.
2. **Classificazione dei contenuti su Internet:** L'etichettatura di ogni pagina web è un processo poco praticabile e fattibile e quindi utilizza algoritmi di machine learning semi-supervisionato. Anche l'algoritmo di ricerca di Google utilizza una variante del machine learning semi-supervisionato per classificare la rilevanza di una pagina web per una determinata query.
3. **Classificazione delle sequenze proteiche:** Poiché i filamenti di DNA sono tipicamente molto grandi, l'ascesa del machine learning semi-supervisionato è stata imminente in questo campo.

### Machine learning per rinforzo
Questo addestra le macchine attraverso tentativi ed errori a prendere la migliore azione stabilendo un sistema di ricompensa. Il machine learning per rinforzo può addestrare modelli a giocare ai giochi o ad addestrare veicoli autonomi a guidare dicendo alla macchina quando ha preso le decisioni giuste, il che aiuta a imparare nel tempo quali azioni dovrebbe intraprendere.

Applicazioni pratiche del Machine Learning per Rinforzo - 
1. **Sistemi di produzione** 
   e.g. Google Cloud AutoML, Facebook Horizon, raccomandazioni, pubblicità, ricerca 
2. **Guida autonoma**
3. **Gestione aziendale** 
   e.g. risoluzione del problema del routing dei veicoli, comportamento fraudolento nell'e-commerce, apprendimento per rinforzo concorrente dalle interazioni con i clienti
4. **Sistemi di raccomandazione**
   e.g. per ricerca, raccomandazioni e pubblicità online

### Il machine learning è anche associato a diversi altri sottocampi dell'intelligenza artificiale:

### Elaborazione del linguaggio naturale

L'elaborazione del linguaggio naturale è un campo del machine learning in cui le macchine apprendono a comprendere il linguaggio naturale parlato e scritto dagli esseri umani anziché i dati e i numeri normalmente usati per programmare i computer. Questo consente alle macchine di riconoscere il linguaggio, comprenderlo e rispondere, così come creare nuovo testo e tradurre tra lingue. L'elaborazione del linguaggio naturale abilita tecnologie familiari come i chatbot e assistenti digitali come Siri o Alexa.

Applicazioni pratiche della NLP:
1. **Risposta alle domande:** La Risposta alle domande si concentra sulla costruzione di sistemi che rispondono automaticamente alle domande poste dagli esseri umani in un linguaggio naturale. 
2. **Rilevamento dello spam:** Il rilevamento dello spam viene utilizzato per rilevare e-mail indesiderate che arrivano alla casella di posta di un utente.
3. **Analisi del sentiment:** L'Analisi del sentiment è anche nota come mining dell'opinione. Viene utilizzata sul web per analizzare l'atteggiamento, il comportamento e lo stato emotivo del mittente. Questa applicazione viene implementata attraverso una combinazione di NLP (Elaborazione del Linguaggio Naturale) e statistica assegnando valori al testo (positivo, negativo o neutro) e identificando l'umore del contesto (felice, triste, arrabbiato, ecc.)
4. **Traduzione automatica:** La traduzione automatica viene utilizzata per tradurre testo o discorsi da una lingua naturale a un'altra lingua naturale. e.g. Google Translate
5. **Correzione ortografica:** Microsoft Corporation fornisce software di elaborazione testi come MS Word e PowerPoint per la correzione ortografica.

### Reti neurali

Le reti neurali sono una classe specifica di algoritmi di machine learning comunemente utilizzati. Le reti neurali artificiali sono modellate sul cervello umano, in cui migliaia o milioni di nodi di elaborazione sono interconnessi e organizzati in strati.

In una rete neurale artificiale, le cellule o i nodi sono collegati, con ciascuna cellula che elabora gli input e produce un output che viene inviato ad altri neuroni. I dati etichettati si muovono attraverso i nodi o le cellule, con ciascuna cellula che svolge una funzione diversa. In una rete neurale addestrata per identificare se una foto contiene un gatto o meno, i diversi nodi valuterebbero le informazioni e arriverebbero a un output che indica se la foto presenta un gatto.

Applicazioni pratiche delle Reti Neurali:
1. **Previsione del mercato azionario:** Per fare una previsione di successo in tempo reale, viene impiegato un Multilayer Perceptron MLP (classe di algoritmo di intelligenza artificiale feedforward). L'MLP comprende più strati di nodi, e ciascuno di questi strati è completamente connesso ai nodi successivi. Le prestazioni passate delle azioni, i ritorni annuali e i rapporti senza profitto vengono considerati per costruire il modello MLP.
2. **Social Media:** I Perceptron Multistrato prevedono le tendenze dei social media. Utilizza diversi metodi di addestramento come Mean Absolute Error (MAE), Root Mean Squared Error (RMSE) e Mean Squared Error (MSE). L'MLP considera diversi fattori come le pagine Instagram preferite dall'utente, le scelte salvate, ecc. Dopo l'analisi dei comportamenti degli individui tramite i social media, i dati possono essere collegati alle abitudini di spesa delle persone. L'MLP ANN viene utilizzato per estrarre dati dalle applicazioni dei social media.  
3. **Aerospace:** L'Ingegneria Aerospaziale è un termine ampio che comprende i progressi nei veicoli spaziali e negli aerei. Diagnosi dei guasti, pilotaggio automatico ad alte prestazioni, sicurezza dei sistemi di controllo degli aerei e modellizzazione di simulazioni dinamiche chiave sono alcune delle aree chiave che le reti neurali hanno assunto. Le reti neurali a ritardo di tempo possono essere impiegate per modellare sistemi dinamici non lineari nel tempo.

### Deep learning

Le reti di deep learning sono reti neurali con molti strati. La rete stratificata può elaborare enormi quantità di dati e determinare il “peso” di ciascun collegamento nella rete — ad esempio, in un sistema di riconoscimento delle immagini, alcuni strati della rete neurale potrebbero rilevare caratteristiche individuali di un volto, come occhi, naso o bocca, mentre un altro strato potrebbe essere in grado di dire se queste caratteristiche appaiono in modo tale da indicare un volto.

Applicazioni pratiche del Deep Learning:
1. **Generazione automatica di testo –** Un corpus di testo viene appreso, e da questo modello viene generato nuovo testo, parola per parola o carattere per carattere. Poi questo modello è in grado di apprendere come scrivere, punteggiare e formare frasi, o può anche catturare lo stile.
2. **Salute –** Aiuta nella diagnosi di varie malattie e nel loro trattamento.
3. **Traduzione automatica –** Alcune parole, frasi o espressioni in una lingua vengono trasformate in un'altra lingua (Il Deep Learning sta ottenendo risultati migliori nelle aree di testo e immagini).
4. **Riconoscimento delle immagini –** Riconosce e identifica persone e oggetti nelle immagini e comprende contenuti e contesti. Quest'area è già utilizzata nei settori dei giochi, del retail, del turismo, ecc.
5. **Previsione dei terremoti –** Insegna a un computer a eseguire calcoli viscoelastici, utilizzati nella previsione dei terremoti.


## [Tecnologia Web](Web%20Technology/WebTechnology.md#web-tecnology)
La Tecnologia Web si riferisce ai vari strumenti e tecniche utilizzati nel processo di comunicazione tra diversi tipi di dispositivi su Internet. Un browser web viene utilizzato per accedere alle pagine web. I browser web possono essere definiti come programmi che visualizzano testo, dati, immagini, animazioni e video su Internet. Le risorse ipertestuali sul World Wide Web possono essere accessibili utilizzando le interfacce software fornite dai browser web.

### La Tecnologia Web può essere classificata nelle seguenti sezioni:
- World Wide Web (WWW)
Il World Wide Web si basa su diverse tecnologie: browser web, Linguaggio di Marcatura Ipertestuale (HTML) e Protocollo di Trasferimento Ipertestuale (HTTP).

- Browser Web
Il browser web è un software applicativo per esplorare il www (World Wide Web). Fornisce un'interfaccia tra il server e il client e richiede al server documenti e servizi web.

- Server Web
Un server web è un programma che elabora le richieste di rete degli utenti e le serve con file che creano pagine web. Questo scambio avviene utilizzando il Protocollo di Trasferimento Ipertestuale (HTTP).

- Pagine Web
Una pagina web è un documento digitale che è collegato al World Wide Web e visualizzabile da chiunque sia connesso a Internet e abbia un browser web.

- Sviluppo Web
Lo sviluppo web si riferisce alla costruzione, creazione e manutenzione di siti web. Include aspetti come design web, pubblicazione web, programmazione web e gestione di database. È la creazione di un'applicazione che funziona su Internet, cioè, siti web.

### Lo Sviluppo Web può essere classificato in due modi:
### Sviluppo Frontend
La parte di un sito web con cui l'utente interagisce direttamente è chiamata front end. Viene anche definita come il ‘lato client’ dell'applicazione.

### Sviluppo Backend
Il backend è il lato server di un sito web. È la parte del sito web che gli utenti non possono vedere e con cui non interagiscono. È la porzione di software che non entra in contatto diretto con gli utenti. Viene utilizzato per memorizzare e organizzare i dati.


## [Reti](Networking/readme.md#networking)
Una rete di computer è un insieme di computer che condividono risorse situate su o fornite dai nodi della rete. I computer utilizzano protocolli di comunicazione comuni attraverso connessioni digitali per comunicare tra loro. Queste connessioni sono costituite da tecnologie di rete basate su metodi fisicamente cablati, ottici e wireless a radiofrequenza, che possono essere disposti in una varietà di topologie di rete.

I nodi di una rete di computer possono includere computer personali, server, hardware di rete o altri host specializzati o generali. Essi sono identificati da indirizzi di rete e possono avere nomi host. I nomi host servono come etichette memorabili per i nodi, raramente cambiate dopo l'assegnazione iniziale. Gli indirizzi di rete servono per localizzare e identificare i nodi tramite protocolli di comunicazione come il Protocollo Internet.

Le reti di computer possono essere classificate secondo diversi criteri, tra cui il mezzo di trasmissione utilizzato per trasportare i segnali, la larghezza di banda, i protocolli di comunicazione per organizzare il traffico di rete, le dimensioni della rete, la topologia, il meccanismo di controllo del traffico e l'intento organizzativo.

### Tipi di rete
Esistono due tipi principali di networking:
- Networking cablato: Il networking cablato richiede l'uso di un mezzo fisico per il trasporto tra i nodi. I cavi Ethernet a base di rame, popolari per il loro basso costo e durabilità, sono comunemente utilizzati per le comunicazioni digitali in aziende e case. In alternativa, la fibra ottica viene utilizzata per trasportare dati su distanze maggiori e a velocità superiori, ma presenta diversi compromessi, inclusi costi più elevati e componenti più fragili.
- Networking wireless: Il networking wireless utilizza onde radio per trasportare dati nell'aria, consentendo ai dispositivi di essere collegati a una rete senza alcun cablaggio. Le LAN wireless sono la forma più conosciuta e ampiamente implementata di networking wireless. Altre opzioni includono microonde, satelliti, cellulari e Bluetooth, tra gli altri.

## MODELLO OSI
OSI sta per **Open Systems Interconnection**. È stato sviluppato da ISO – ‘**International Organization for Standardization**’ nel 1984. È un'architettura a 7 strati, con ciascuno strato che ha una funzionalità specifica da eseguire. Tutti questi sette strati lavorano collaborativamente per trasmettere i dati da una persona all'altra in tutto il mondo.

#### **1. Strato Fisico (Layer 1):**

Il livello più basso del modello di riferimento OSI è lo strato fisico. È responsabile della connessione fisica effettiva tra i dispositivi. Lo strato fisico contiene informazioni sotto forma di **bit**. È responsabile della trasmissione di bit individuali da un nodo all'altro. Quando si riceve un dato, questo strato riceve il segnale e lo converte in 0 e 1 e li invia allo strato Data Link, che rimonta il frame.

![](Networking/OSI%20Model/img/computer-network-osi-model-layers-bits.png)

Le funzioni dello strato fisico sono le seguenti:

1.  **Sincronizzazione dei bit:** Lo strato fisico fornisce la sincronizzazione dei bit mediante un orologio. Questo orologio controlla sia il mittente che il destinatario, fornendo così sincronizzazione a livello di bit.
2.  **Controllo della velocità dei bit:** Lo strato fisico definisce anche la velocità di trasmissione, cioè il numero di bit inviati al secondo.
3.  **Topologie fisiche:** Lo strato fisico specifica come i diversi dispositivi/nodi sono disposti in una rete, cioè topologia a bus, stella o maglia.
4.  **Modalità di trasmissione:** Lo strato fisico definisce anche come i dati fluiscono tra i due dispositivi connessi. Le varie modalità di trasmissione possibili sono Simplex, half-duplex e full-duplex.

#### **2. Data Link Layer (DLL) (Layer 2):**

Lo strato di collegamento dati è responsabile della consegna del messaggio da nodo a nodo. La funzione principale di questo strato è assicurare che il trasferimento dei dati sia privo di errori da un nodo all'altro attraverso lo strato fisico. Quando un pacchetto arriva in una rete, è responsabilità del DLL trasmetterlo all'host utilizzando il suo indirizzo MAC.   
Lo strato di collegamento dati è diviso in due sottostrati:

1. Controllo del collegamento logico (LLC)
2. Controllo di accesso ai mezzi (MAC)

Il pacchetto ricevuto dallo strato di rete viene ulteriormente suddiviso in frame a seconda delle dimensioni del frame della NIC (Network Interface Card). Il DLL incapsula anche l'indirizzo MAC del mittente e del destinatario nell'intestazione. 

L'indirizzo MAC del destinatario viene ottenuto inserendo una richiesta ARP (Address Resolution Protocol) sulla rete chiedendo: “Chi ha quell'indirizzo IP?” e l'host di destinazione risponderà con il proprio indirizzo MAC.

![](Networking/OSI%20Model/img/computer-network-osi-model-layers-framing.png)

Le funzioni dello strato di collegamento dati sono:

1.  **Incapsulamento:** L'incapsulamento è una funzione dello strato di collegamento dati. Fornisce un modo per un mittente di trasmettere un insieme di bit che siano significativi per il destinatario. Questo può essere realizzato aggiungendo modelli di bit speciali all'inizio e alla fine del frame.
2.  **Indirizzamento fisico:** Dopo aver creato i frame, lo strato di collegamento dati aggiunge indirizzi fisici (indirizzi MAC) del mittente e/o destinatario nell'intestazione di ciascun frame.
3.  **Controllo degli errori:** Lo strato di collegamento dati fornisce il meccanismo di controllo degli errori in cui rileva e ritrasmette frame danneggiati o persi.
4.  **Controllo del flusso:** La velocità dei dati deve essere costante su entrambi i lati altrimenti i dati potrebbero essere corrotti; pertanto, il controllo del flusso coordina la quantità di dati che può essere inviata prima di ricevere una conferma.
5.  **Controllo dell'accesso:** Quando un singolo canale di comunicazione è condiviso da più dispositivi, il sottostrato MAC dello strato di collegamento dati aiuta a determinare quale dispositivo ha il controllo sul canale in un dato momento.

#### **3. Network Layer (Layer 3):**

Lo strato di rete lavora per la trasmissione dei dati da un host all'altro situati in reti diverse. Si occupa anche dell'instradamento dei pacchetti, cioè della selezione del percorso più breve per trasmettere il pacchetto tra i vari percorsi disponibili. Gli indirizzi IP del mittente e del destinatario sono inseriti nell'intestazione dallo strato di rete.

Le funzioni dello strato di rete sono:

1.  **Instradamento:** I protocolli dello strato di rete determinano quale percorso è adatto dal sorgente alla destinazione. Questa funzione dello strato di rete è conosciuta come instradamento.
2.  **Indirizzamento logico:** Per identificare in modo univoco ogni dispositivo su una rete, lo strato di rete definisce uno schema di indirizzamento. Gli indirizzi IP del mittente e del destinatario sono inseriti nell'intestazione dallo strato di rete. Tale indirizzo distingue in modo univoco e universale ogni dispositivo.

## [Internet](Internet/readme.md#internet)
Internet è un sistema globale di reti di computer interconnesse che utilizzano il suite di protocolli standard Internet ([TCP/IP](Networking/readme.md#tcptransmission-control-protocol)) per servire miliardi di utenti in tutto il mondo. È una rete di reti che consiste in milioni di reti private, pubbliche, accademiche, aziendali e governative di portata locale e globale, collegate da una vasta gamma di tecnologie di rete elettroniche, wireless e ottiche. Internet trasporta una vasta gamma di risorse e servizi informativi, come i documenti ipertestuali e le applicazioni del World Wide Web ([WWW](Internet/readme.md#world-wide-web-www)) e l'infrastruttura per supportare la posta elettronica.

### [World Wide Web (WWW)](Internet/readme.md#world-wide-web-www)
Il World Wide Web (WWW) è uno spazio informativo dove i documenti e altre risorse web sono identificati da Localizzatori Uniformi di Risorse (URL), intercollegati da link ipertestuali e accessibili tramite Internet. Il ricercatore inglese Tim Berners-Lee inventò il World Wide Web nel 1989. Scrisse il primo

 browser web nel 1990 mentre lavorava al CERN in Svizzera. Il browser fu rilasciato al di fuori del CERN nel 1991, prima ad altre istituzioni di ricerca a partire da gennaio 1991 e al pubblico generale su Internet nell'agosto 1991.

### [Internet Protocol (IP)](Internet/readme.md#internet-protocol-ip)
Il Protocollo Internet (IP) è un protocollo, o un insieme di regole, per instradare e indirizzare i pacchetti di dati in modo che possano viaggiare attraverso le reti e arrivare alla destinazione corretta. I dati che attraversano Internet sono suddivisi in pezzi più piccoli chiamati pacchetti.


## [DBMS]()

### Cos'è un Database?
Un database è una raccolta di dati correlati che rappresentano un aspetto del mondo reale. Un sistema di database è progettato per essere costruito e popolato con dati per un certo compito.

### Cos'è un DBMS?
**Database Management System (DBMS)** è un software per memorizzare e recuperare i dati degli utenti, tenendo conto delle misure di sicurezza appropriate. Esso consiste in un insieme di programmi che manipolano il database. Il DBMS accetta la richiesta di dati da un'applicazione e istruisce il sistema operativo per fornire i dati specifici. Nei grandi sistemi, un DBMS aiuta gli utenti e altri software di terze parti a memorizzare e recuperare i dati.

Il DBMS consente agli utenti di creare i propri database in base alle loro esigenze. Il termine "DBMS" include l'uso di un database e di altri programmi applicativi. Fornisce un'interfaccia tra i dati e l'applicazione software.

### Esempio di un DBMS
Vediamo un semplice esempio di un database universitario. Questo database mantiene informazioni riguardanti studenti, corsi e voti in un ambiente universitario. Il database è organizzato in cinque file:

*   Il file STUDENT memorizza i dati di ogni studente.
*   Il file COURSE memorizza i dati su ciascun corso.
*   Il file SECTION memorizza le informazioni sui vari settori di un determinato corso.
*   Il file GRADE memorizza i voti che gli studenti ricevono nelle varie sezioni.
*   Il file TUTOR contiene informazioni su ciascun professore.

Per definire un DBMS:

*   Dobbiamo specificare la struttura dei record di ciascun file definendo i diversi tipi di elementi di dati da memorizzare in ciascun record.
*   Possiamo anche utilizzare uno schema di codifica per rappresentare i valori di un elemento di dati.
*   Fondamentalmente, il tuo database avrà cinque tabelle con una chiave esterna definita tra le varie tabelle.

### Storia del DBMS
Ecco i traguardi importanti della storia:

*   1960 – Charles Bachman progettò il primo sistema DBMS.
*   1970 – Codd introdusse il Sistema di Gestione delle Informazioni di IBM (IMS).
*   1976 – Peter Chen coniò e definì il modello Entità-Relazione, noto anche come modello ER.
*   1980 – Il Modello Relazionale diventa un componente ampiamente accettato dei database.
*   1985 – Sviluppo del DBMS orientato agli oggetti.
*   Anni '90 – Incorporazione dell'orientamento agli oggetti nei DBMS relazionali.
*   1991 – Microsoft lancia MS Access, un DBMS personale che soppianta tutti gli altri prodotti DBMS personali.
*   1995 – Prime applicazioni di database su Internet.
*   1997 – XML applicato all'elaborazione dei database. Molti fornitori iniziano a integrare XML nei prodotti DBMS.

### Caratteristiche del DBMS
Ecco le caratteristiche e le proprietà di un Sistema di Gestione di Database:

*   Fornisce sicurezza e rimuove la ridondanza.
*   Descrive autonomamente la natura di un sistema di database.
*   Isolamento tra programmi e astrazione dei dati.
*   Supporto di più viste dei dati.
*   Condivisione dei dati e elaborazione delle transazioni multi-utente.
*   Il Software di Gestione dei Database consente a entità e relazioni tra esse di formare tabelle.
*   Segue il concetto ACID (Atomicità, Coerenza, Isolamento e Durabilità).
*   Il DBMS supporta un ambiente multi-utente che consente agli utenti di accedere e manipolare i dati in parallelo.

### Software DBMS Popolari
Ecco un elenco di alcuni sistemi DBMS popolari:

*   MySQL
*   Microsoft Access
*   Oracle
*   PostgreSQL
*   dBASE
*   FoxPro
*   SQLite
*   IBM DB2
*   LibreOffice Base
*   MariaDB
*   Microsoft SQL Server, ecc.

## [Crittografia](Cryptography/readme.md#cryptography)
La crittografia è una tecnica per proteggere i dati e le comunicazioni. È un metodo di protezione delle informazioni e delle comunicazioni attraverso l'uso di codici in modo che solo coloro per cui le informazioni sono destinate possano leggerle e processarle. La crittografia è usata per proteggere i dati in transito, a riposo e in uso. Il prefisso _crypt_ significa "nascosto" o "segreto", e il suffisso _graphy_ significa "scrittura".

### Tipi di Critttografia
Ci sono due tipi di crittografia:
1. [Crittografia Simmetrica](Cryptography/readme.md#symmetric-cryptography)
2. [Crittografia Asimmetrica](Cryptography/readme.md#asymmetric-cryptography)

### [Crypto Currency](Cryptography/CryptoCurrency/readme.md#crypto-currency)
La criptovaluta è una valuta digitale in cui le tecniche di crittografia sono utilizzate per regolare la generazione di unità di valuta e verificare il trasferimento di fondi, operando indipendentemente da una banca centrale. Le criptovalute usano il controllo decentralizzato rispetto ai sistemi di valuta digitale centralizzati e alle banche centrali. Il controllo decentralizzato di ciascuna criptovaluta funziona attraverso la tecnologia del libro mastro distribuito, tipicamente una blockchain, che funge da database pubblico delle transazioni finanziarie. Una caratteristica distintiva di una criptovaluta, e probabilmente il suo fascino più duraturo, è la sua natura organica; non è emessa da alcuna autorità centrale, rendendola teoricamente immune a interferenze o manipolazioni governative.

## Tipi di Criptovaluta sono i seguenti:
1. [Proof of Work](Cryptography/CryptoCurrency/ProofOfWork/readme.md#proof-of-work)
2. [Proof of Stake](Cryptography/CryptoCurrency/ProofOfStake/readme.md#proof-of-stake)

### _Le Criptovalute più Popolari sono le seguenti:_
1. [Bitcoin](Cryptography/CryptoCurrency/ProofOfWork/Bitcoin/readme.md#bitcoin)
2. [Ethereum](Cryptography/CryptoCurrency/ProofOfStake/Ethereum/readme.md#ethereum)
3. [Litecoin](Cryptography/CryptoCurrency/ProofOfWork/Litecoin/readme.md#litecoin)
4. [Cardano](Cryptography/CryptoCurrency/ProofOfStake/Cardano/readme.md#cardano)
5. [Dogecoin](Cryptography/CryptoCurrency/ProofOfWork/Dogecoin/readme.md#dogecoin)

## Teoria della Computazione
Nella scienza dei computer teorica e nella matematica, la teoria della computazione è il ramo che si occupa di quali problemi possono essere risolti su un modello di computazione usando un algoritmo, quanto efficientemente possono essere risolti, o a quale grado (ad esempio, soluzioni approssimate rispetto a soluzioni precise). Il campo è diviso in tre rami principali: la teoria degli automi e dei linguaggi formali, la teoria della calcolabilità e la teoria della complessità computazionale, che sono collegate dalla domanda: "Quali sono le capacità e le limitazioni fondamentali dei computer?".

### Teoria degli Automati
La teoria degli automi è lo studio di macchine astratte e automi, così come dei problemi computazionali che possono essere risolti usando questi. È una teoria nella scienza dei computer teorica. La parola automa deriva dalla parola greca αὐτόματος, che significa "auto-agente, auto-voluto, auto-movente". Un automa (automata al plurale) è un dispositivo di calcolo astratto auto-propulsato che segue una sequenza predeterminata di operazioni automaticamente. Un automa con un numero finito di stati è chiamato Automa Finito (FA) o Macchina a Stati Finiti (FSM). La figura a destra illustra una macchina a stati finiti, che è un tipo ben noto di automa. Questo automa è composto da stati (rappresentati nella figura da cerchi) e transizioni (rappresentate da frecce). Quando l'automa vede un simbolo di input, effettua una transizione (o salto) a un altro stato, in base alla sua funzione di transizione, che prende come argomenti lo stato precedente e il simbolo di input corrente.

### Linguaggi Formali
In logica, matematica, scienza dei computer e linguistica, un linguaggio formale consiste di parole i cui caratteri sono presi da un alfabeto e sono ben formati secondo un insieme specifico di regole.

L'alfabeto di un linguaggio formale consiste di simboli, lettere o token che si concatenano in stringhe del linguaggio. Ogni stringa concatenata da simboli di questo alfabeto è chiamata parola, e le parole che appartengono a un particolare linguaggio formale sono talvolta chiamate parole ben formate o formule ben formate. Un linguaggio formale è spesso definito usando una grammatica formale, come la grammatica regolare o la grammatica senza contesto, che consiste nelle sue regole di formazione.

Nella scienza dei computer, i linguaggi formali sono usati, tra l'altro, come base per definire la grammatica dei linguaggi di programmazione e versioni formalizzate di sottoinsiemi di linguaggi naturali in cui le parole del linguaggio rappresentano concetti associati a significati particolari o semantica. Nella teoria della complessità computazionale, i problemi decisionali sono tipicamente definiti come linguaggi formali e le classi di complessità sono definite come gli insiemi di linguaggi formali che possono essere analizzati da macchine con potere computazionale limitato. In logica e nelle fondamenta della matematica, i linguaggi formali sono usati per rappresentare la sintassi dei sistemi assiomatici, e il formalismo matematico è la filosofia secondo cui tutta la matematica può essere ridotta alla manipolazione sintattica di linguaggi formali in questo modo.

Teoria della Calcolabilità
La teoria della calcolabilità, nota anche come teoria della ricorsione, è un ramo della logica matematica, della scienza dei computer e della teoria della computazione che ha avuto origine negli anni '30 con lo studio delle funzioni calcolabili e dei gradi di Turing. Il campo si è successivamente espanso per includere lo studio della calcolabilità e della definibilità generalizzate. In questi ambiti, la teoria della calcolabilità si sovrappone alla teoria della dimostrazione e alla teoria degli insiemi descrittivi efficaci.

Teoria della Complessità Computazionale
Nella scienza dei computer teorica e nella matematica, la teoria della complessità computazionale si concentra sulla classificazione dei problemi computazionali in base al loro uso delle risorse e sul collegamento di queste classi tra loro. Un problema computazionale è un compito risolto da un computer. Un problema di calcolo è risolvibile mediante l'applicazione meccanica di passaggi matematici, come un algoritmo.

Un problema è considerato intrinsecamente difficile se la sua soluzione richiede risorse significative, qualunque sia l'algoritmo utilizzato. La teoria formalizza questa intuizione introducendo modelli matematici di calcolo per studiare questi problemi e quantificare la loro complessità computazionale, cioè il numero di risorse necessarie per risolverli, come tempo e spazio di memorizzazione. Altre misure di complessità sono utilizzate, come la quantità di comunicazione (utilizzata nella complessità della comunicazione), il numero di porte in un circuito (utilizzato nella complessità dei circuiti) e il numero di processori (utilizzato nel calcolo parallelo). Uno dei ruoli della teoria della complessità computazionale è determinare i limiti pratici su ciò che i computer possono e non possono fare. Il problema P versus NP, uno dei sette problemi del Millennium Prize, è dedicato al campo della complessità computazionale.

Campi strettamente correlati nella scienza dei computer teorica sono l'analisi degli algoritmi e la teoria della calcolabilità. Una distinzione chiave tra l'analisi degli algoritmi e la teoria della complessità computazionale è che la prima si dedica all'analisi del numero di risorse necessarie da un algoritmo particolare per risolvere un problema, mentre la seconda pone una domanda più generale su tutti gli algoritmi possibili che potrebbero essere utilizzati per risolvere lo stesso problema. Più precisamente, la teoria della complessità computazionale cerca di classificare i problemi che possono o non possono essere risolti con risorse appropriatamente limitate. A sua volta, l'imposizione di restrizioni sulle risorse disponibili è ciò che distingue la complessità computazionale dalla teoria della calcolabilità: quest'ultima teoria chiede quali tipi di problemi possono, in linea di principio, essere risolti algoritmicamente.








## Contributors

<!-- ALL-CONTRIBUTORS-LIST:START - Do not remove or modify this section -->
<!-- prettier-ignore-start -->
<!-- markdownlint-disable -->
<table>
  <tbody>
    <tr>
      <td align="center" valign="top" width="16.66%"><a href="http://safayat.me"><img src="https://avatars.githubusercontent.com/u/80335059?v=4?s=50" width="50px;" alt="Sifat"/><br /><sub><b>Sifat</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=shhossain" title="Code">💻</a> <a href="#content-shhossain" title="Content">🖋</a> <a href="https://github.com/shhossain/computer_science/commits?author=shhossain" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/Sabine91"><img src="https://avatars.githubusercontent.com/u/96158726?v=4?s=50" width="50px;" alt="Yuvraj Chauhan"/><br /><sub><b>Yuvraj Chauhan</b></sub></a><br /><a href="#content-Sabine91" title="Content">🖋</a> <a href="https://github.com/shhossain/computer_science/commits?author=Sabine91" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/Rajesh144142"><img src="https://avatars.githubusercontent.com/u/82487522?v=4?s=50" width="50px;" alt="Rajesh kumar halder"/><br /><sub><b>Rajesh kumar halder</b></sub></a><br /><a href="#content-Rajesh144142" title="Content">🖋</a> <a href="https://github.com/shhossain/computer_science/commits?author=Rajesh144142" title="Code">💻</a> <a href="https://github.com/shhossain/computer_science/commits?author=Rajesh144142" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="http://ishanmondal.me"><img src="https://avatars.githubusercontent.com/u/76674591?v=4?s=50" width="50px;" alt="Ishan Mondal"/><br /><sub><b>Ishan Mondal</b></sub></a><br /><a href="#content-ishan-im" title="Content">🖋</a> <a href="https://github.com/shhossain/computer_science/commits?author=ishan-im" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/Apoorva08102000"><img src="https://avatars.githubusercontent.com/u/91753868?v=4?s=50" width="50px;" alt="Apoorva08102000"/><br /><sub><b>Apoorva08102000</b></sub></a><br /><a href="#content-Apoorva08102000" title="Content">🖋</a> <a href="https://github.com/shhossain/computer_science/commits?author=Apoorva08102000" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/apoorva1823000"><img src="https://avatars.githubusercontent.com/u/71769587?v=4?s=50" width="50px;" alt="Apoorva .S. Mehta"/><br /><sub><b>Apoorva .S. Mehta</b></sub></a><br /><a href="#content-apoorva1823000" title="Content">🖋</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/utopian-coder"><img src="https://avatars.githubusercontent.com/u/66299782?v=4?s=50" width="50px;" alt="Imran Biswas"/><br /><sub><b>Imran Biswas</b></sub></a><br /><a href="#content-utopian-coder" title="Content">🖋</a> <a href="https://github.com/shhossain/computer_science/commits?author=utopian-coder" title="Code">💻</a> <a href="https://github.com/shhossain/computer_science/commits?author=utopian-coder" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/subrata-9999"><img src="https://avatars.githubusercontent.com/u/109057053?v=4?s=50" width="50px;" alt="Subrata Pramanik"/><br /><sub><b>Subrata Pramanik</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=subrata-9999" title="Code">💻</a> <a href="https://github.com/shhossain/computer_science/commits?author=subrata-9999" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://br.linkedin.com/in/samuelbratifavarin"><img src="https://avatars.githubusercontent.com/u/17628602?v=4?s=50" width="50px;" alt="Samuel Favarin"/><br /><sub><b>Samuel Favarin</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=SamuelBFavarin" title="Documentation">📖</a> <a href="https://github.com/shhossain/computer_science/commits?author=SamuelBFavarin" title="Code">💻</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/sahooabhipsa10"><img src="https://avatars.githubusercontent.com/u/99355886?v=4?s=50" width="50px;" alt="sahooabhipsa10"/><br /><sub><b>sahooabhipsa10</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=sahooabhipsa10" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/Sahilrao09"><img src="https://avatars.githubusercontent.com/u/88286056?v=4?s=50" width="50px;" alt="Sahil Rao"/><br /><sub><b>Sahil Rao</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=Sahilrao09" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/Code-N-Bug"><img src="https://avatars.githubusercontent.com/u/103832013?v=4?s=50" width="50px;" alt="K K Chowdhury"/><br /><sub><b>K K Chowdhury</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=Code-N-Bug" title="Code">💻</a> <a href="https://github.com/shhossain/computer_science/commits?author=Code-N-Bug" title="Documentation">📖</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="16.66%"><a href="https://manas6699.github.io/portfolio-website3.0/"><img src="https://avatars.githubusercontent.com/u/78929050?v=4?s=50" width="50px;" alt="Manas Baroi"/><br /><sub><b>Manas Baroi</b></sub></a><br /><a href="#example-manas6699" title="Examples">💡</a> <a href="https://github.com/shhossain/computer_science/commits?author=manas6699" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/kanaujiyaaditi"><img src="https://avatars.githubusercontent.com/u/94130073?v=4?s=50" width="50px;" alt="Aditi"/><br /><sub><b>Aditi</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=kanaujiyaaditi" title="Documentation">📖</a> <a href="#content-kanaujiyaaditi" title="Content">🖋</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/Talib-Hossain"><img src="https://avatars.githubusercontent.com/u/83373885?v=4?s=50" width="50px;" alt="Syed Talib Hossain"/><br /><sub><b>Syed Talib Hossain</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=Talib-Hossain" title="Code">💻</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/JaiMehrotra02"><img src="https://avatars.githubusercontent.com/u/94130223?v=4?s=50" width="50px;" alt="Jai Mehrotra"/><br /><sub><b>Jai Mehrotra</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=JaiMehrotra02" title="Documentation">📖</a> <a href="https://github.com/shhossain/computer_science/commits?author=JaiMehrotra02" title="Code">💻</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/ShuvamBag"><img src="https://avatars.githubusercontent.com/u/82321197?v=4?s=50" width="50px;" alt="Shuvam Bag"/><br /><sub><b>Shuvam Bag</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=ShuvamBag" title="Code">💻</a> <a href="https://github.com/shhossain/computer_science/commits?author=ShuvamBag" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/AbhijitTurate"><img src="https://avatars.githubusercontent.com/u/46615905?v=4?s=50" width="50px;" alt="Abhijit Turate"/><br /><sub><b>Abhijit Turate</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=AbhijitTurate" title="Code">💻</a> <a href="https://github.com/shhossain/computer_science/commits?author=AbhijitTurate" title="Documentation">📖</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/Jayesh2812"><img src="https://avatars.githubusercontent.com/u/52153715?v=4?s=50" width="50px;" alt="Jayesh Deorukhkar"/><br /><sub><b>Jayesh Deorukhkar</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=Jayesh2812" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/SohamDey80"><img src="https://avatars.githubusercontent.com/u/93932583?v=4?s=50" width="50px;" alt="JC Shankar"/><br /><sub><b>JC Shankar</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=SohamDey80" title="Code">💻</a> <a href="https://github.com/shhossain/computer_science/commits?author=SohamDey80" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/Subrata-Pramanik"><img src="https://avatars.githubusercontent.com/u/86642230?v=4?s=50" width="50px;" alt="Subrata Pramanik"/><br /><sub><b>Subrata Pramanik</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=Subrata-Pramanik" title="Code">💻</a> <a href="https://github.com/shhossain/computer_science/commits?author=Subrata-Pramanik" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/imams12"><img src="https://avatars.githubusercontent.com/u/59444865?v=4?s=50" width="50px;" alt="Imam Suyuti"/><br /><sub><b>Imam Suyuti</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=imams12" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/rahulmangla28"><img src="https://avatars.githubusercontent.com/u/93324315?v=4?s=50" width="50px;" alt="genius_koder"/><br /><sub><b>genius_koder</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=rahulmangla28" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://www.altafshaikh.ml"><img src="https://avatars.githubusercontent.com/u/26015187?v=4?s=50" width="50px;" alt="Altaf Shaikh"/><br /><sub><b>Altaf Shaikh</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=altafshaikh" title="Documentation">📖</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/rajdeepdas2000"><img src="https://avatars.githubusercontent.com/u/53941109?v=4?s=50" width="50px;" alt="Rajdeep Das"/><br /><sub><b>Rajdeep Das</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=rajdeepdas2000" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/its-red-eagle"><img src="https://avatars.githubusercontent.com/u/77643994?v=4?s=50" width="50px;" alt="Vikash Patel"/><br /><sub><b>Vikash Patel</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=its-red-eagle" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/alwenpy"><img src="https://avatars.githubusercontent.com/u/94129388?v=4?s=50" width="50px;" alt="Arvind Srivastav"/><br /><sub><b>Arvind Srivastav</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=alwenpy" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/Naprila"><img src="https://avatars.githubusercontent.com/u/85901005?v=4?s=50" width="50px;" alt="Manish Kr Prasad"/><br /><sub><b>Manish Kr Prasad</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=Naprila" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://linktr.ee/mohit_kushwaha"><img src="https://avatars.githubusercontent.com/u/73400792?v=4?s=50" width="50px;" alt="MOHIT KUMAR KUSHWAHA"/><br /><sub><b>MOHIT KUMAR KUSHWAHA</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=KimtVak8143" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/DryHitman"><img src="https://avatars.githubusercontent.com/u/116108787?v=4?s=50" width="50px;" alt="DryHitman"/><br /><sub><b>DryHitman</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=DryHitman" title="Documentation">📖</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/harshkulkarni17"><img src="https://avatars.githubusercontent.com/u/72391096?v=4?s=50" width="50px;" alt="Harsh Kulkarni"/><br /><sub><b>Harsh Kulkarni</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=harshkulkarni17" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/ATREAY"><img src="https://avatars.githubusercontent.com/u/66585295?v=4?s=50" width="50px;" alt="Atreay  Kukanur"/><br /><sub><b>Atreay  Kukanur</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=ATREAY" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://sreeharan.github.io"><img src="https://avatars.githubusercontent.com/u/62993067?v=4?s=50" width="50px;" alt="Sree Haran"/><br /><sub><b>Sree Haran</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=SreeHaran" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://www.linkedin.com/in/auro-saswat-raj-d05m07y2003/"><img src="https://avatars.githubusercontent.com/u/83534307?v=4?s=50" width="50px;" alt="Auro Saswat Raj"/><br /><sub><b>Auro Saswat Raj</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=geeky-auro" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/Aiyan-Faras"><img src="https://avatars.githubusercontent.com/u/55203889?v=4?s=50" width="50px;" alt="Aiyan Faras"/><br /><sub><b>Aiyan Faras</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=Aiyan-Faras" title="Documentation">📖</a> <a href="https://github.com/shhossain/computer_science/commits?author=Aiyan-Faras" title="Code">💻</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/PriyanshiDavid"><img src="https://avatars.githubusercontent.com/u/71930453?v=4?s=50" width="50px;" alt="Priyanshi David"/><br /><sub><b>Priyanshi David</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=PriyanshiDavid" title="Documentation">📖</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/ishancode-dev"><img src="https://avatars.githubusercontent.com/u/115942220?v=4?s=50" width="50px;" alt="Ishan Mondal"/><br /><sub><b>Ishan Mondal</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=ishancode-dev" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="http://expy.bio/NikhilShrivastava"><img src="https://avatars.githubusercontent.com/u/20610444?v=4?s=50" width="50px;" alt="Nikhil Shrivastava"/><br /><sub><b>Nikhil Shrivastava</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=NikhilShrivastava" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/deepshikha2708"><img src="https://avatars.githubusercontent.com/u/80972038?v=4?s=50" width="50px;" alt="deepshikha2708"/><br /><sub><b>deepshikha2708</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=deepshikha2708" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/rishiwardhan"><img src="https://avatars.githubusercontent.com/u/88772100?v=4?s=50" width="50px;" alt="L.RISHIWARDHAN"/><br /><sub><b>L.RISHIWARDHAN</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=rishiwardhan" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/DevTMK"><img src="https://avatars.githubusercontent.com/u/47377566?v=4?s=50" width="50px;" alt="Rahul RK"/><br /><sub><b>Rahul RK</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=DevTMK" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://www.linkedin.com/company/nscc-ggv/"><img src="https://avatars.githubusercontent.com/u/82573863?v=4?s=50" width="50px;" alt="Nishant Wankhade"/><br /><sub><b>Nishant Wankhade</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=NishantWankhade" title="Documentation">📖</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/pritika163"><img src="https://avatars.githubusercontent.com/u/102177744?v=4?s=50" width="50px;" alt="pritika163"/><br /><sub><b>pritika163</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=pritika163" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/AnjumanHasan"><img src="https://avatars.githubusercontent.com/u/82674743?v=4?s=50" width="50px;" alt="Anjuman Hasan"/><br /><sub><b>Anjuman Hasan</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=AnjumanHasan" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://linktr.ee/asthavarshney"><img src="https://avatars.githubusercontent.com/u/97240696?v=4?s=50" width="50px;" alt="Astha Varshney "/><br /><sub><b>Astha Varshney </b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=Asthavarshneyy" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/Gcettbdeveloper"><img src="https://avatars.githubusercontent.com/u/114204175?v=4?s=50" width="50px;" alt="Gcettbdeveloper"/><br /><sub><b>Gcettbdeveloper</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=Gcettbdeveloper" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://elston-website.web.app"><img src="https://avatars.githubusercontent.com/u/66341506?v=4?s=50" width="50px;" alt="Elston Tan"/><br /><sub><b>Elston Tan</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=Elstuhn" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/ShivanshDengla"><img src="https://avatars.githubusercontent.com/u/66008449?v=4?s=50" width="50px;" alt="Shivansh Dengla"/><br /><sub><b>Shivansh Dengla</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=ShivanshDengla" title="Documentation">📖</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="16.66%"><a href="https://www.tetricz.com"><img src="https://avatars.githubusercontent.com/u/49681400?v=4?s=50" width="50px;" alt="David Daniels"/><br /><sub><b>David Daniels</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=Tetricz" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/ayushverma14"><img src="https://avatars.githubusercontent.com/u/65187507?v=4?s=50" width="50px;" alt="ayushverma14"/><br /><sub><b>ayushverma14</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=ayushverma14" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://kontentkreator.tech"><img src="https://avatars.githubusercontent.com/u/70800059?v=4?s=50" width="50px;" alt="Pratik Rai"/><br /><sub><b>Pratik Rai</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=pratikkumar399" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/yash-ch"><img src="https://avatars.githubusercontent.com/u/66888087?v=4?s=50" width="50px;" alt="Yash"/><br /><sub><b>Yash</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=yash-ch" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/pranavyatnalkar"><img src="https://avatars.githubusercontent.com/u/84735288?v=4?s=50" width="50px;" alt="pranavyatnalkar"/><br /><sub><b>pranavyatnalkar</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=pranavyatnalkar" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/jeremiaaxel"><img src="https://avatars.githubusercontent.com/u/57858415?v=4?s=50" width="50px;" alt="Jeremia Axel"/><br /><sub><b>Jeremia Axel</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=jeremiaaxel" title="Documentation">📖</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="16.66%"><a href="https://in.linkedin.com/in/akhil-soni-9827181a1"><img src="https://avatars.githubusercontent.com/u/58397226?v=4?s=50" width="50px;" alt="Akhil Soni"/><br /><sub><b>Akhil Soni</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=akhil-maker" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/DevZahraShahid"><img src="https://avatars.githubusercontent.com/u/111266434?v=4?s=50" width="50px;" alt="Zahra Shahid"/><br /><sub><b>Zahra Shahid</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=DevZahraShahid" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/Mihir20K"><img src="https://avatars.githubusercontent.com/u/112269999?v=4?s=50" width="50px;" alt="Mihir20K"/><br /><sub><b>Mihir20K</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=Mihir20K" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/computerwala"><img src="https://avatars.githubusercontent.com/u/30777038?v=4?s=50" width="50px;" alt="Aman"/><br /><sub><b>Aman</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=computerwala" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/mauriallegrettiswnat"><img src="https://avatars.githubusercontent.com/u/71467262?v=4?s=50" width="50px;" alt="Mauricio Allegretti"/><br /><sub><b>Mauricio Allegretti</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=mauriallegrettiswnat" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/Bruno-Vasconcellos-Betella"><img src="https://avatars.githubusercontent.com/u/57138664?v=4?s=50" width="50px;" alt="Bruno-Vasconcellos-Betella"/><br /><sub><b>Bruno-Vasconcellos-Betella</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=Bruno-Vasconcellos-Betella" title="Documentation">📖</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="16.66%"><a href="https://itdadakan.site"><img src="https://avatars.githubusercontent.com/u/62456215?v=4?s=50" width="50px;" alt="Febi Arifin"/><br /><sub><b>Febi Arifin</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=febiarifin" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/dinesh9-ai"><img src="https://avatars.githubusercontent.com/u/63300423?v=4?s=50" width="50px;" alt="Dineshwar Doddapaneni"/><br /><sub><b>Dineshwar Doddapaneni</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=dinesh9-ai" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/Dheerajsoni93"><img src="https://avatars.githubusercontent.com/u/82114565?v=4?s=50" width="50px;" alt="Dheeraj_Soni"/><br /><sub><b>Dheeraj_Soni</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=Dheerajsoni93" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://www.linkedin.com/in/ojash-kushwaha-791770185"><img src="https://avatars.githubusercontent.com/u/96474959?v=4?s=50" width="50px;" alt="Ojash Kushwaha"/><br /><sub><b>Ojash Kushwaha</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=OjashKush" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/Sleep-lover"><img src="https://avatars.githubusercontent.com/u/82304155?v=4?s=50" width="50px;" alt="Laleet Borse"/><br /><sub><b>Laleet Borse</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=Sleep-lover" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/Wahaj-Raza"><img src="https://avatars.githubusercontent.com/u/103155321?v=4?s=50" width="50px;" alt="Wahaj Raza"/><br /><sub><b>Wahaj Raza</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=Wahaj-Raza" title="Documentation">📖</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/WahajRaza1"><img src="https://avatars.githubusercontent.com/u/90937190?v=4?s=50" width="50px;" alt="WahajRaza1"/><br /><sub><b>WahajRaza1</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=WahajRaza1" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://ravencolevol.github.io"><img src="https://avatars.githubusercontent.com/u/44892121?v=4?s=50" width="50px;" alt="Ravi Lamkoti"/><br /><sub><b>Ravi Lamkoti</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=RavenColEvol" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/UperscuzziSchoolAcc"><img src="https://avatars.githubusercontent.com/u/111448336?v=4?s=50" width="50px;" alt="The One and Only Uper"/><br /><sub><b>The One and Only Uper</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=UperscuzziSchoolAcc" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/AdarshBajpai67"><img src="https://avatars.githubusercontent.com/u/95476086?v=4?s=50" width="50px;" alt="AdarshBajpai67"/><br /><sub><b>AdarshBajpai67</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=AdarshBajpai67" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="http://deepakkharah.me"><img src="https://avatars.githubusercontent.com/u/42672761?v=4?s=50" width="50px;" alt="Deepak Kharah"/><br /><sub><b>Deepak Kharah</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=Deepak-Kharah" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/sairohit360"><img src="https://avatars.githubusercontent.com/u/55144209?v=4?s=50" width="50px;" alt="sairohit360"/><br /><sub><b>sairohit360</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=sairohit360" title="Documentation">📖</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/sairohitzl"><img src="https://avatars.githubusercontent.com/u/86225259?v=4?s=50" width="50px;" alt="sairohitzl"/><br /><sub><b>sairohitzl</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=sairohitzl" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/RavalJinit"><img src="https://avatars.githubusercontent.com/u/72157334?v=4?s=50" width="50px;" alt="Raval Jinit"/><br /><sub><b>Raval Jinit</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=RavalJinit" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/Vovka1759"><img src="https://avatars.githubusercontent.com/u/75867274?v=4?s=50" width="50px;" alt="Vovka1759"/><br /><sub><b>Vovka1759</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=Vovka1759" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/Nijin-P-S"><img src="https://avatars.githubusercontent.com/u/101330853?v=4?s=50" width="50px;" alt="Nijin"/><br /><sub><b>Nijin</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=Nijin-P-S" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/avinilcode"><img src="https://avatars.githubusercontent.com/u/111761529?v=4?s=50" width="50px;" alt="Avinil Bedarkar"/><br /><sub><b>Avinil Bedarkar</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=avinilcode" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/FercueNat"><img src="https://avatars.githubusercontent.com/u/113535859?v=4?s=50" width="50px;" alt="FercueNat"/><br /><sub><b>FercueNat</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=FercueNat" title="Documentation">📖</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="16.66%"><a href="https://khareyash05.github.io/home/"><img src="https://avatars.githubusercontent.com/u/60147732?v=4?s=50" width="50px;" alt="Yash Khare"/><br /><sub><b>Yash Khare</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=khareyash05" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/ayushanand16"><img src="https://avatars.githubusercontent.com/u/96689639?v=4?s=50" width="50px;" alt="Ayush Anand"/><br /><sub><b>Ayush Anand</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=ayushanand16" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/DharmaWarrior"><img src="https://avatars.githubusercontent.com/u/97218268?v=4?s=50" width="50px;" alt="DharmaWarrior"/><br /><sub><b>DharmaWarrior</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=DharmaWarrior" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://linktr.ee/hitarthraval"><img src="https://avatars.githubusercontent.com/u/62943532?v=4?s=50" width="50px;" alt="Hitarth Raval"/><br /><sub><b>Hitarth Raval</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=hitarthraval" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/WiemBorchani"><img src="https://avatars.githubusercontent.com/u/52404192?v=4?s=50" width="50px;" alt="Wiem Borchani "/><br /><sub><b>Wiem Borchani </b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=WiemBorchani" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/Kambo2320"><img src="https://avatars.githubusercontent.com/u/98479408?v=4?s=50" width="50px;" alt="Kamden Burke"/><br /><sub><b>Kamden Burke</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=Kambo2320" title="Documentation">📖</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/denschiro"><img src="https://avatars.githubusercontent.com/u/6161324?v=4?s=50" width="50px;" alt="denschiro"/><br /><sub><b>denschiro</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=denschiro" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/nishat48"><img src="https://avatars.githubusercontent.com/u/109063023?v=4?s=50" width="50px;" alt="Nishat"/><br /><sub><b>Nishat</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=nishat48" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/mdfaizanahmed786"><img src="https://avatars.githubusercontent.com/u/85175130?v=4?s=50" width="50px;" alt="Mohammed Faizan Ahmed"/><br /><sub><b>Mohammed Faizan Ahmed</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=mdfaizanahmed786" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/manish831"><img src="https://avatars.githubusercontent.com/u/74316266?v=4?s=50" width="50px;" alt="Manish Agrahari"/><br /><sub><b>Manish Agrahari</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=manish831" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/lokesh-katari"><img src="https://avatars.githubusercontent.com/u/111894942?v=4?s=50" width="50px;" alt="Katari Lokeswara rao"/><br /><sub><b>Katari Lokeswara rao</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=lokesh-katari" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://g.dev/ZahraShahid"><img src="https://avatars.githubusercontent.com/u/65255043?v=4?s=50" width="50px;" alt="Zahra Shahid"/><br /><sub><b>Zahra Shahid</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=ZahraShahid" title="Documentation">📖</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/glenntu15"><img src="https://avatars.githubusercontent.com/u/10324492?v=4?s=50" width="50px;" alt="Glenn Turner"/><br /><sub><b>Glenn Turner</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=glenntu15" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/vinayak9303"><img src="https://avatars.githubusercontent.com/u/55548976?v=4?s=50" width="50px;" alt="Vinayak godse"/><br /><sub><b>Vinayak godse</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=vinayak9303" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/Satyajeetbh"><img src="https://avatars.githubusercontent.com/u/88246318?v=4?s=50" width="50px;" alt="Satyajeetbh"/><br /><sub><b>Satyajeetbh</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=Satyajeetbh" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/P-Dhruva-Teja"><img src="https://avatars.githubusercontent.com/u/81409709?v=4?s=50" width="50px;" alt="Paidipelly Dhruvateja"/><br /><sub><b>Paidipelly Dhruvateja</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=P-Dhruva-Teja" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/helloausrine"><img src="https://avatars.githubusercontent.com/u/30316810?v=4?s=50" width="50px;" alt="helloausrine"/><br /><sub><b>helloausrine</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=helloausrine" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/SourabhJoshi209"><img src="https://avatars.githubusercontent.com/u/69594540?v=4?s=50" width="50px;" alt="SourabhJoshi209"/><br /><sub><b>SourabhJoshi209</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=SourabhJoshi209" title="Documentation">📖</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="16.66%"><a href="https://bio.link/stefantaitano"><img src="https://avatars.githubusercontent.com/u/85418632?v=4?s=50" width="50px;" alt="Stefan Taitano"/><br /><sub><b>Stefan Taitano</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=codewithfan" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="http://linkedin.com/in/anmspro"><img src="https://avatars.githubusercontent.com/u/33668152?v=4?s=50" width="50px;" alt="Abu Noman Md. Sakib"/><br /><sub><b>Abu Noman Md. Sakib</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=anmspro" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="http://skyrunner360.pythonanywhere.com"><img src="https://avatars.githubusercontent.com/u/44318840?v=4?s=50" width="50px;" alt="Rishi Mathur"/><br /><sub><b>Rishi Mathur</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=skyrunner360" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/Atharv-Nalwade"><img src="https://avatars.githubusercontent.com/u/98139553?v=4?s=50" width="50px;" alt="Darky001"/><br /><sub><b>Darky001</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=Atharv-Nalwade" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/Retr0Sushi"><img src="https://avatars.githubusercontent.com/u/110653014?v=4?s=50" width="50px;" alt="himanshu"/><br /><sub><b>himanshu</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=Retr0Sushi" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/kusumita29"><img src="https://avatars.githubusercontent.com/u/99873488?v=4?s=50" width="50px;" alt="Kusumita Ghose"/><br /><sub><b>Kusumita Ghose</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=kusumita29" title="Documentation">📖</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/Yash1107"><img src="https://avatars.githubusercontent.com/u/76468153?v=4?s=50" width="50px;" alt="Yashvi Patel"/><br /><sub><b>Yashvi Patel</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=Yash1107" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/ArshadAriff"><img src="https://avatars.githubusercontent.com/u/113685884?v=4?s=50" width="50px;" alt="ArshadAriff"/><br /><sub><b>ArshadAriff</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=ArshadAriff" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/ishashukla183"><img src="https://avatars.githubusercontent.com/u/93022787?v=4?s=50" width="50px;" alt="ishashukla183"/><br /><sub><b>ishashukla183</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=ishashukla183" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/jhuynh06"><img src="https://avatars.githubusercontent.com/u/111946833?v=4?s=50" width="50px;" alt="jhuynh06"/><br /><sub><b>jhuynh06</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/issues?q=author%3Ajhuynh06" title="Bug reports">🐛</a> <a href="https://github.com/shhossain/computer_science/commits?author=jhuynh06" title="Tests">⚠️</a></td>
      <td align="center" valign="top" width="16.66%"><a href="http://asche.tech"><img src="https://avatars.githubusercontent.com/u/2975712?v=4?s=50" width="50px;" alt="Andrew Asche"/><br /><sub><b>Andrew Asche</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=andrewasche" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="http://nateonmission.github.io"><img src="https://avatars.githubusercontent.com/u/37854313?v=4?s=50" width="50px;" alt="J. Nathan Allen"/><br /><sub><b>J. Nathan Allen</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/issues?q=author%3Anateonmission" title="Bug reports">🐛</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/Sayed-Afnan-Khazi"><img src="https://avatars.githubusercontent.com/u/83779299?v=4?s=50" width="50px;" alt="Sayed Afnan Khazi"/><br /><sub><b>Sayed Afnan Khazi</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=Sayed-Afnan-Khazi" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/Technic143"><img src="https://avatars.githubusercontent.com/u/117275755?v=4?s=50" width="50px;" alt="Technic143"/><br /><sub><b>Technic143</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=Technic143" title="Documentation">📖</a> <a href="https://github.com/shhossain/computer_science/issues?q=author%3ATechnic143" title="Bug reports">🐛</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/snowflake1201"><img src="https://avatars.githubusercontent.com/u/56119216?v=4?s=50" width="50px;" alt="Pin Yuan Wang"/><br /><sub><b>Pin Yuan Wang</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=snowflake1201" title="Code">💻</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/BogdanOtava"><img src="https://avatars.githubusercontent.com/u/103674688?v=4?s=50" width="50px;" alt="Bogdan Otava"/><br /><sub><b>Bogdan Otava</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=BogdanOtava" title="Code">💻</a> <a href="https://github.com/shhossain/computer_science/commits?author=BogdanOtava" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/Vedeesh6"><img src="https://avatars.githubusercontent.com/u/88491153?v=4?s=50" width="50px;" alt="Vedeesh Dwivedi"/><br /><sub><b>Vedeesh Dwivedi</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/issues?q=author%3AVedeesh6" title="Bug reports">🐛</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/TsiG-404"><img src="https://avatars.githubusercontent.com/u/74056836?v=4?s=50" width="50px;" alt="Tsig"/><br /><sub><b>Tsig</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=TsiG-404" title="Code">💻</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="16.66%"><a href="https://brandonawan.github.io/Resume/"><img src="https://avatars.githubusercontent.com/u/74030681?v=4?s=50" width="50px;" alt="Brandon Awan"/><br /><sub><b>Brandon Awan</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=Brandonawan" title="Documentation">📖</a> <a href="https://github.com/shhossain/computer_science/issues?q=author%3ABrandonawan" title="Bug reports">🐛</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/Evy04"><img src="https://avatars.githubusercontent.com/u/84919650?v=4?s=50" width="50px;" alt="Sanya Madre"/><br /><sub><b>Sanya Madre</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=Evy04" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/steventohme"><img src="https://avatars.githubusercontent.com/u/56594084?v=4?s=50" width="50px;" alt="Steven"/><br /><sub><b>Steven</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=steventohme" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://www.linkedin.com/in/garrett-crowley-a0b931126/"><img src="https://avatars.githubusercontent.com/u/86014840?v=4?s=50" width="50px;" alt="Garrett Crowley"/><br /><sub><b>Garrett Crowley</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=crowleyg" title="Code">💻</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/Francesco601"><img src="https://avatars.githubusercontent.com/u/130352141?v=4?s=50" width="50px;" alt="Francesco Franco"/><br /><sub><b>Francesco Franco</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/issues?q=author%3AFrancesco601" title="Bug reports">🐛</a> <a href="https://github.com/shhossain/computer_science/commits?author=Francesco601" title="Code">💻</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/aclittle096"><img src="https://avatars.githubusercontent.com/u/43685369?v=4?s=50" width="50px;" alt="Alexander Little"/><br /><sub><b>Alexander Little</b></sub></a><br /><a href="#content-aclittle096" title="Content">🖋</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/Wandererr01"><img src="https://avatars.githubusercontent.com/u/129178279?v=4?s=50" width="50px;" alt="Subham Maji"/><br /><sub><b>Subham Maji</b></sub></a><br /><a href="#content-Wandererr01" title="Content">🖋</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/ZRX-SIGMA"><img src="https://avatars.githubusercontent.com/u/100613008?v=4?s=50" width="50px;" alt="SK Jiyad"/><br /><sub><b>SK Jiyad</b></sub></a><br /><a href="#content-ZRX-SIGMA" title="Content">🖋</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/exrol"><img src="https://avatars.githubusercontent.com/u/86170495?v=4?s=50" width="50px;" alt="exrol"/><br /><sub><b>exrol</b></sub></a><br /><a href="#content-exrol" title="Content">🖋</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/manavmittal05"><img src="https://avatars.githubusercontent.com/u/65654441?v=4?s=50" width="50px;" alt="Manav Mittal"/><br /><sub><b>Manav Mittal</b></sub></a><br /><a href="#content-manavmittal05" title="Content">🖋</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/Rathish-Rajendran"><img src="https://avatars.githubusercontent.com/u/61904970?v=4?s=50" width="50px;" alt="Rathish R"/><br /><sub><b>Rathish R</b></sub></a><br /><a href="#content-Rathish-Rajendran" title="Content">🖋</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/anubhav1450"><img src="https://avatars.githubusercontent.com/u/124580419?v=4?s=50" width="50px;" alt="Anubhav Kulshreshtha"/><br /><sub><b>Anubhav Kulshreshtha</b></sub></a><br /><a href="#content-anubhav1450" title="Content">🖋</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="16.66%"><a href="http://sarthak950.netlify.app"><img src="https://avatars.githubusercontent.com/u/93645760?v=4?s=50" width="50px;" alt="Sarthak "/><br /><sub><b>Sarthak </b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=Sarthak950" title="Code">💻</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/architO21"><img src="https://avatars.githubusercontent.com/u/97817943?v=4?s=50" width="50px;" alt="architO21"/><br /><sub><b>architO21</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=architO21" title="Code">💻</a> <a href="#content-architO21" title="Content">🖋</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/nik-6174"><img src="https://avatars.githubusercontent.com/u/78644716?v=4?s=50" width="50px;" alt="Nikhil Kumar Jha"/><br /><sub><b>Nikhil Kumar Jha</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=nik-6174" title="Code">💻</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/Kundai10"><img src="https://avatars.githubusercontent.com/u/76932641?v=4?s=50" width="50px;" alt="Kundai Chasinda"/><br /><sub><b>Kundai Chasinda</b></sub></a><br /><a href="#content-Kundai10" title="Content">🖋</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/rohankaushal123"><img src="https://avatars.githubusercontent.com/u/76746752?v=4?s=50" width="50px;" alt="Rohan kaushal"/><br /><sub><b>Rohan kaushal</b></sub></a><br /><a href="#content-rohankaushal123" title="Content">🖋</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/AayushKumar176"><img src="https://avatars.githubusercontent.com/u/110240629?v=4?s=50" width="50px;" alt="Aayush Kumar"/><br /><sub><b>Aayush Kumar</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=AayushKumar176" title="Code">💻</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/vladimir-cucu"><img src="https://avatars.githubusercontent.com/u/108150922?v=4?s=50" width="50px;" alt="Vladimir Cucu"/><br /><sub><b>Vladimir Cucu</b></sub></a><br /><a href="#content-vladimir-cucu" title="Content">🖋</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://www.linkedin.com/in/mohammed-ali-alsakkaf-899b44224/"><img src="https://avatars.githubusercontent.com/u/87440507?v=4?s=50" width="50px;" alt="Mohammed Ali Alsakkaf (Binbasri)"/><br /><sub><b>Mohammed Ali Alsakkaf (Binbasri)</b></sub></a><br /><a href="#content-Binbasri-in" title="Content">🖋</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/serv-er"><img src="https://avatars.githubusercontent.com/u/120189782?v=4?s=50" width="50px;" alt="serv-er"/><br /><sub><b>serv-er</b></sub></a><br /><a href="#content-serv-er" title="Content">🖋</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/ABarpanda"><img src="https://avatars.githubusercontent.com/u/145291762?v=4?s=50" width="50px;" alt="Amritanshu Barpanda"/><br /><sub><b>Amritanshu Barpanda</b></sub></a><br /><a href="#content-ABarpanda" title="Content">🖋</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/aheaton22"><img src="https://avatars.githubusercontent.com/u/117932053?v=4?s=50" width="50px;" alt="aheaton22"/><br /><sub><b>aheaton22</b></sub></a><br /><a href="#content-aheaton22" title="Content">🖋</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/geeknees"><img src="https://avatars.githubusercontent.com/u/701242?v=4?s=50" width="50px;" alt="Masumi Kawasaki"/><br /><sub><b>Masumi Kawasaki</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/issues?q=author%3Ageeknees" title="Bug reports">🐛</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/aslezar"><img src="https://avatars.githubusercontent.com/u/97354675?v=4?s=50" width="50px;" alt="aslezar"/><br /><sub><b>aslezar</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=aslezar" title="Code">💻</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://yashsajwan.netlify.app/"><img src="https://avatars.githubusercontent.com/u/52412969?v=4?s=50" width="50px;" alt="Yash Sajwan"/><br /><sub><b>Yash Sajwan</b></sub></a><br /><a href="#content-Yash-Sajwan24" title="Content">🖋</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/AbhishekKumar993"><img src="https://avatars.githubusercontent.com/u/121042725?v=4?s=50" width="50px;" alt="Abhishek Kumar"/><br /><sub><b>Abhishek Kumar</b></sub></a><br /><a href="#content-AbhishekKumar993" title="Content">🖋</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/jakenybo"><img src="https://avatars.githubusercontent.com/u/57851055?v=4?s=50" width="50px;" alt="jakenybo"/><br /><sub><b>jakenybo</b></sub></a><br /><a href="#content-jakenybo" title="Content">🖋</a> <a href="https://github.com/shhossain/computer_science/commits?author=jakenybo" title="Code">💻</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/jiangfz1997"><img src="https://avatars.githubusercontent.com/u/63608649?v=4?s=50" width="50px;" alt="Fangzhou_Jiang"/><br /><sub><b>Fangzhou_Jiang</b></sub></a><br /><a href="#content-jiangfz1997" title="Content">🖋</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://nelsonuprety.netlify.app/"><img src="https://avatars.githubusercontent.com/u/25173636?v=4?s=50" width="50px;" alt="Nelson Uprety"/><br /><sub><b>Nelson Uprety</b></sub></a><br /><a href="#content-nelsonuprety1" title="Content">🖋</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/Ettubrute05"><img src="https://avatars.githubusercontent.com/u/89800208?v=4?s=50" width="50px;" alt="Kevin Garfield"/><br /><sub><b>Kevin Garfield</b></sub></a><br /><a href="#content-Ettubrute05" title="Content">🖋</a> <a href="https://github.com/shhossain/computer_science/commits?author=Ettubrute05" title="Code">💻</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/xaviermonb"><img src="https://avatars.githubusercontent.com/u/144323061?v=4?s=50" width="50px;" alt="xaviermonb"/><br /><sub><b>xaviermonb</b></sub></a><br /><a href="#content-xaviermonb" title="Content">🖋</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/AryasCodeTreks"><img src="https://avatars.githubusercontent.com/u/159680137?v=4?s=50" width="50px;" alt="AryasCodeTreks"/><br /><sub><b>AryasCodeTreks</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=AryasCodeTreks" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/khouloudhaddad"><img src="https://avatars.githubusercontent.com/u/22796050?v=4?s=50" width="50px;" alt="khouloud HADDAD AMAMOU"/><br /><sub><b>khouloud HADDAD AMAMOU</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=khouloudhaddad" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/WalterMarch"><img src="https://avatars.githubusercontent.com/u/38635451?v=4?s=50" width="50px;" alt="Walter March"/><br /><sub><b>Walter March</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/issues?q=author%3AWalterMarch" title="Bug reports">🐛</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/niv-png"><img src="https://avatars.githubusercontent.com/u/66550479?v=4?s=50" width="50px;" alt="Nivea Hanley"/><br /><sub><b>Nivea Hanley</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=niv-png" title="Documentation">📖</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="16.66%"><a href="http://namberino.github.io"><img src="https://avatars.githubusercontent.com/u/70761157?v=4?s=50" width="50px;" alt="nam"/><br /><sub><b>nam</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=namberino" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/shaanrxx"><img src="https://avatars.githubusercontent.com/u/62669918?v=4?s=50" width="50px;" alt="Shaan Rehsi"/><br /><sub><b>Shaan Rehsi</b></sub></a><br /><a href="#content-shaanrxx" title="Content">🖋</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/mjung1"><img src="https://avatars.githubusercontent.com/u/86390269?v=4?s=50" width="50px;" alt="mjung1"/><br /><sub><b>mjung1</b></sub></a><br /><a href="https://github.com/shhossain/computer_science/commits?author=mjung1" title="Documentation">📖</a></td>
    </tr>
  </tbody>
</table>

<!-- markdownlint-restore -->
<!-- prettier-ignore-end -->

<!-- ALL-CONTRIBUTORS-LIST:END -->
<!-- prettier-ignore-start -->
<!-- markdownlint-disable -->

<!-- markdownlint-restore -->
<!-- prettier-ignore-end -->

<!-- ALL-CONTRIBUTORS-LIST:END -->
<!-- ALL-CONTRIBUTORS-BADGE:START - Do not remove or modify this section -->

[![All Contributors](https://img.shields.io/badge/all_contributors-104-orange.svg?style=flat-square)](#contributors)
<!-- ALL-CONTRIBUTORS-BADGE:END -->
