<h1 align="center">कंप्यूटर विज्ञान</h1>
<h4 align="center">
    <p>
        <a href="https://github.com/shhossain/computer_science/blob/main/README.md">English</a> |
        <a href="https://github.com/shhossain/computer_science/blob/main/README_it.md">Italiano</a> |
        <a href="https://github.com/shhossain/computer_science/blob/main/README_es.md">Español</a> |
        <a href="https://github.com/shhossain/computer_science/blob/main/README_fr.md">Français</a> |
        <a href="https://github.com/shhossain/computer_science/blob/main/README_bn.md">বাংলা</a> |
        <a href="https://github.com/shhossain/computer_science/blob/main/README_ta.md">தமிழ்</a> |
        <a href="https://github.com/shhossain/computer_science/blob/main/README_guj.md">ગુજરાતી</a> |
        <a href="https://github.com/shhossain/computer_science/blob/main/README_pt.md">Portuguese</a> |
        <b>हिंदी</b> |
        <a href="https://github.com/shhossain/computer_science/blob/main/README_te.md">తెలుగు</a> |
        <a href="https://github.com/shhossain/computer_science/blob/main/README_ro.md">Română</a> |
        <a href="https://github.com/shhossain/computer_science/blob/main/README_ar.md">العربية</a> 
    </p>
</h4>

## विषय तालिका

- [प्रस्तावना](#प्रस्तावना)
- [इलेक्ट्रॉनिक कंप्यूटर](#इलेक्ट्रॉनिक-कंप्यूटर)
- [बूलियन तर्क](#बूलियन-तर्क)
- [संख्या प्रणालियां](#संख्या-प्रणालियां)
- [सेन्ट्रल प्रॉसेसिंग यूनिट (सीपीयू)](#सेन्ट्रल-प्रॉसेसिंग-यूनिट-सीपीयू)
- [रजिस्टर, कैच और रैम](#रजिस्टर-कैच-और-रैम)
- [निर्देश एवं प्रोग्राम](#निर्देश-एवं-कार्यक्रम)
- [प्रोग्रामिंग भाषाऐ](#प्रोग्रामिंग-भाषाऐ)
- [आंकड़ा प्रकार](#आंकड़ा-प्रकार)
- [स्टेटमेंट और फ़ंकशन](#स्टेटमेंट-और-फ़ंकशन)
- [डेटा संरचनाएं](#डेटा-संरचनाएं)
- [एल्गोरिदम](#एल्गोरिदम)
- [ऐलैन ट्युरिंग](#एलन-ट्यूरिंग)
- [सॉफ्टवेयर इंजीनियरिंग](#सॉफ्टवेयर-इंजीनियरिंग)
- [एकीकृत सर्किट](#एकीकृत-सर्किट)
- [ऑब्जेक्ट ओरिएंटेड प्रोग्रामिंग](#ऑब्जेक्ट-ओरिएंटेड-प्रोग्रामिंग)
- [फ़ंकशनाल प्रोग्रामिंग](#फ़ंकशनाल-प्रोग्रामिंग)
- [ऑपरेटिंग सिस्टम](#ऑपरेटिंग-सिस्टम)
- [मेमोरी और स्टोरेज](#मेमोरी-और-स्टोरेज)
- [फाइल सिस्टम](#फाइल-सिस्टम)
- [क्लाउड कम्प्यूटिंग](#क्लाउड-कम्प्यूटिंग)
- [यंत्र अधिगम (मशीन लर्निंग)](#यंत्र-अधिगम-मशीन-लर्निंग)
- [वेब प्रौद्योगिकी](#वेब-प्रौद्योगिकी)
- [नेटवर्किंग](#नेटवर्किंग)
- [इंटरनेट](#इंटरनेट)
- [डीबीएमएस (डेटाबेस प्रबंधन प्रणाली)](#डीबीएमएस-डेटाबेस-प्रबंधन-प्रणाली)
- [क्रिप्टोग्राफी](#क्रिप्टोग्राफी)
- [संगणना का सिद्धांत](#संगणना-का-सिद्धांत)

## प्रस्तावना

कंप्यूटर विज्ञान कंप्यूटर और कंप्यूटिंग और उनके सैद्धांतिक और व्यावहारिक अनुप्रयोगों का अध्ययन है। कंप्यूटर विज्ञान अनेक समस्याओं पर गणित, इंजीनियरिंग और तर्क के सिद्धांतों को लागू करता है। इनमें एल्गोरिदम निर्माण, सॉफ्टवेयर/हार्डवेयर विकास और कृत्रिम बुद्धिमत्ता शामिल हैं।

## [इलेक्ट्रॉनिक कंप्यूटर](Electronic%20Computer/readme.md)
एक उपकरण जो गणना करता है, विशेष रूप से एक प्रोग्राम करने योग्य इलेक्ट्रॉनिक मशीन जो उच्च गति गणितीय या तार्किक संचालन करती है या जानकारी को इकट्ठा करती है, संग्रहीत करती है, सहसंबंधित करती है, या अन्यथा संसाधित करती है।

## [बूलियन तर्क](Boolean%20Logic/readme.md)
बूलियन तर्कशास्त्र गणित की एक शाखा है जो सत्य और असत्य के मूल्यों से संबंधित है। यह तर्क की एक प्रणाली है जो क्रमशः असत्य और सत्य का प्रतिनिधित्व करने के लिए केवल दो मानों, 0 और 1 का उपयोग करती है। इसे बूलियन बीजगणित के रूप में भी जाना जाता है, जिसका नाम जॉर्ज बूले के नाम पर रखा गया है, जिन्होंने पहली बार 1854 में इसका वर्णन किया था।
### आम बूलियन ऑपरेटर्स
| Operator | Name |               Description               |
| :------: | :--: | :-------------------------------------: |
|    !     | NOT  |    ऑपरेंड के मूल्य को नकारता है    |
|    &&    | AND  | यदि दोनों ऑपरेंड सत्य हैं, तो **true** लौटाता है |
|   \|\|   |  OR  | यदि एक या सभी ऑपरेंड सत्य हैं तो **true** लौटाता है। |

### कुछ और बूलियन ऑपरेटर्स
| Operator | Name |               Description               |
| :------: | :--: | :-------------------------------------: |
|    ()    | Parentheses     |   आपको कीवर्ड समूहित करने और उस क्रम को नियंत्रित करने की अनुमति देता है जिसमें शब्द खोजे जाएंगे।    |
|    “”    | Quotation marks | सटीक वाक्यांश के साथ परिणाम प्रदान करता है। |
|   *      |  Asterisk       | कीवर्ड भिन्नता वाले परिणाम प्रदान करता है। |
|   ⊕     |  XOR            | यदि ऑपरेंड भिन्न हैं तो **true** लौटाता है |
|   ⊽      |  NOR            | यदि सभी ऑपरेंड गलत हैं तो **true** लौटाता है। |
|   ⊼      |  NAND           | केवल तभी **false** लौटाता है जब इसके दो इनपुट के दोनों मान सत्य हों। |

## [संख्या प्रणालियां](Number%20System/readme.md#number-systems)
संख्या प्रणालियाँ संख्याओं को व्यक्त करने की गणितीय प्रणालियाँ हैं। एक संख्या प्रणाली में प्रतीकों का एक सेट होता है जिनका उपयोग संख्याओं को दर्शाने के लिए किया जाता है और उन प्रतीकों में हेरफेर करने के लिए नियमों का एक सेट होता है। किसी संख्या प्रणाली में प्रयुक्त प्रतीकों को अंक कहा जाता है।

## [सेन्ट्रल प्रॉसेसिंग यूनिट (सीपीयू)](CPU/readme.md#central-processing-unitcpu)
सेंट्रल प्रोसेसिंग यूनिट (सीपीयू) किसी भी कंप्यूटर का सबसे महत्वपूर्ण हिस्सा है। सीपीयू कंप्यूटर के अन्य हिस्सों को नियंत्रित करने के लिए सिग्नल भेजता है, लगभग उसी तरह जैसे मस्तिष्क किसी शरीर को नियंत्रित करता है। सीपीयू एक इलेक्ट्रॉनिक मशीन है जो कंप्यूटर द्वारा किए जाने वाले कार्यों की सूची पर काम करती है, जिन्हें निर्देश कहा जाता है। यह निर्देशों की सूची को पढ़ता है और प्रत्येक को क्रम से चलाता (निष्पादित) करता है। निर्देशों की एक सूची जिसे सीपीयू चला सकता है वह एक कंप्यूटर प्रोग्राम है। एक सीपीयू "कोर" नामक अनुभागों पर एक समय में एक से अधिक निर्देशों को संसाधित कर सकता है। चार कोर वाला एक सीपीयू एक साथ चार प्रोग्राम प्रोसेस कर सकता है। CPU स्वयं तीन मुख्य घटकों से बना होता है। वे हैं:
1. [मेमोरी या स्टोरेज यूनिट](CPU/readme.md#memory-or-storage-unit)
2. [नियंत्रण यूनिट](CPU/readme.md#control-unit)
3. [अंकगणित और तर्क यूनिट (ALU)](CPU/readme.md#arithmetic-and-logic-unit-alu)

## [रजिस्टर, कैच और रैम](/Registers%20Cache%20and%20RAM)

## [निर्देश एवं कार्यक्रम](Not-Added)
कंप्यूटर विज्ञान में, एक निर्देश प्रोसेसर अनुदेश सेट द्वारा परिभाषित प्रोसेसर का एक एकल ऑपरेशन है। कंप्यूटर प्रोग्राम निर्देशों की एक सूची है जो कंप्यूटर को बताती है कि उसे क्या करना है। कंप्यूटर जो कुछ भी करता है वह कंप्यूटर प्रोग्राम का उपयोग करके पूरा किया जाता है। प्रोग्राम जो कंप्यूटर की मेमोरी ("आंतरिक प्रोग्रामिंग") में संग्रहीत होते हैं, कंप्यूटर को एक के बाद एक काम करने देते हैं, यहां तक ​​कि बीच में ब्रेक के साथ भी।

## [प्रोग्रामिंग भाषाऐ](/Programming_Languages/readme.md)
एक प्रोग्रामिंग भाषा नियमों का कोई भी सेट है जो विज़ुअल प्रोग्रामिंग भाषाओं के मामले में स्ट्रिंग्स, या ग्राफ़िकल प्रोग्राम तत्वों को विभिन्न प्रकार के मशीन कोड आउटपुट में परिवर्तित करती है। प्रोग्रामिंग भाषाएँ एक प्रकार की कंप्यूटर भाषा है जिसका उपयोग कंप्यूटर प्रोग्रामिंग में एल्गोरिदम को लागू करने के लिए किया जाता है।

प्रोग्रामिंग भाषाओं को अक्सर दो व्यापक श्रेणियों में विभाजित किया जाता है:
1. उच्च स्तरीय भाषा आम बोलचाल भाषा के समान वाक्यविन्यास का उपयोग करती है। कंपाइलर या दुभाषिया का उपयोग करके स्रोत कोड को मशीन-समझने योग्य मशीन कोड में परिवर्तित किया जाता है। जावा और पायथन उच्च स्तरीय प्रोग्रामिंग भाषाओं के कुछ उदाहरण हैं। ये आमतौर पर निम्न-स्तर वाले की तुलना में धीमे होते हैं, लेकिन इसके साथ आसान भी होते हैं।
2. निम्न-स्तरीय प्रोग्रामिंग भाषाएँ हार्डवेयर के साथ अधिक निकटता से काम करती हैं और उस पर अधिक नियंत्रण रखती हैं। वे सीधे हार्डवेयर के साथ इंटरैक्ट करते हैं। निम्न-स्तरीय भाषाओं के दो सामान्य उदाहरण मशीन भाषा और असेंबली भाषा हैं। ये आमतौर पर उच्च-स्तरीय से तेज़ होते हैं, लेकिन इन भाषाओं को पढना व समझना बहुत कठिन होता है।


## [आंकड़ा प्रकार](Data%20Types/readme.md#data-types)
प्रोग्रामिंग में डेटा प्रकार, एक वर्गीकरण है जो निर्दिष्ट करता है कि एक चर का किस प्रकार का मान है और बिना किसी त्रुटि के किस प्रकार के गणितीय, संबंधपरक या तार्किक संचालन को उस पर लागू किया जा सकता है।

## [स्टेटमेंट और फ़ंकशन](Statements%20and%20Functions/readme.md)
कंप्यूटर प्रोग्रामिंग में, एक स्टेटमेंट एक अनिवार्य प्रोग्रामिंग भाषा की एक वाक्यात्मक इकाई है जो किए जाने वाले कुछ कार्यों को व्यक्त करती है। ऐसी भाषा में लिखा गया प्रोग्राम एक या अधिक कथनों के अनुक्रम से बनता है। किसी कथन में आंतरिक घटक (जैसे, अभिव्यक्ति) हो सकते हैं।
किसी भी प्रोग्रामिंग भाषा में दो मुख्य प्रकार के कथन होते हैं जो किसी कोड का तर्क बनाने के लिए आवश्यक होते हैं:-
1. [प्रतिबंधात्मक-स्टेटमेंट](Statements%20and%20Functions/readme.md#conditional-statements)

प्रतिबंधात्मक-स्टेटमेंट मुख्यतः दो प्रकार के होते हैं:
- if
- if-else
- switch case

2. [लूप](Statements%20and%20Functions/readme.md#loops)

लूप मुख्यतः तीन प्रकार के होते हैं:
- for loop
- while loop
- do - while loop (while लूप का हि एक प्रकार)
- do - Until loop

फ़ंक्शन कथनों का एक ब्लॉक है जो एक विशिष्ट कार्य करता है। फ़ंक्शंस डेटा स्वीकार करते हैं, इसे संसाधित करते हैं, और परिणाम लौटाते हैं या इसे निष्पादित करते हैं। फ़ंक्शंस मुख्य रूप से पुन: प्रयोज्य की अवधारणा का समर्थन करने के लिए लिखे गए हैं। एक बार जब कोई फ़ंक्शन लिखा जाता है, तो उसे उसी कोड को दोहराए बिना आसानी से कॉल किया जा सकता है।

विभिन्न प्रोग्रामिंग भाषाएँ फ़ंक्शन लिखने के लिए विभिन्न वाक्यविन्यास का उपयोग करती हैं।

फ़ंक्शन के बारे मैं और जानें [यहां](Statements%20and%20Functions/readme.md#functions)

## [डेटा संरचनाएं](Data%20Structures/readme.md)

कंप्यूटर विज्ञान में, डेटा संरचना एक डेटा संगठन, प्रबंधन और भंडारण प्रारूप है जो कुशल पहुंच और संशोधन को सक्षम बनाता है। अधिक सटीक रूप से, एक डेटा संरचना डेटा मानों, उनके बीच संबंधों और उन कार्यों या संचालन का एक संग्रह है जिन्हें डेटा पर लागू किया जा सकता है।

### डेटा संरचना के विभिन्न प्रकार:
- [ऐरे](Data%20Structures/readme.md#array)
- [लिंक्ड लिस्ट](Data%20Structures/readme.md#linkedlist)
- [स्टैक](Data%20Structures/readme.md#stack)
- [क्यु](Data%20Structures/readme.md#queue)
- [हैश तालिका](Data%20Structures/readme.md#hashtable)
- [हीप](Data%20Structures/readme.md#heap)
- [ट्री](Data%20Structures/readme.md#tree)
- [ग्राफ](Data%20Structures/readme.md#graph)

## [एल्गोरिदम](Algorithms/readme.md)


## [एलन ट्यूरिंग](Not-Added)
एलन ट्यूरिंग (जन्म 23 जून, 1912, लंदन, इंग्लैंड -मृत्यु 7 जून, 1954, विल्म्सलो, चेशायर) एक अंग्रेजी गणितज्ञ और तर्कशास्त्री थे। उन्होंने कैम्ब्रिज विश्वविद्यालय और प्रिंसटन के इंस्टीट्यूट फॉर एडवांस्ड स्टडी में अध्ययन किया। 1936 के अपने मौलिक पेपर "ऑन कंप्यूटेबल नंबर्स" में उन्होंने साबित किया कि गणित में सत्य का निर्धारण करने के लिए कोई सार्वभौमिक एल्गोरिथम विधि मौजूद नहीं हो सकती है और गणित में हमेशा अनिर्णीत (अज्ञात के विपरीत) प्रस्ताव शामिल होंगे। उस पेपर में ट्यूरिंग मशीन का भी परिचय दिया गया। उनका मानना ​​था कि कंप्यूटर अंततः मानव से अप्रभेद्य विचार करने में सक्षम होंगे और उन्होंने इस क्षमता का आकलन करने के लिए एक सरल परीक्षण (ट्यूरिंग टेस्ट देखें) का प्रस्ताव रखा। इस विषय पर उनके शोधपत्रों को कृत्रिम बुद्धिमत्ता में अनुसंधान की नींव के रूप में व्यापक रूप से स्वीकार किया जाता है। उन्होंने द्वितीय विश्व युद्ध के दौरान क्रिप्टोग्राफी में बहुमूल्य काम किया और रेडियो संचार के लिए जर्मनी द्वारा उपयोग किए जाने वाले एनिग्मा कोड को तोड़ने में महत्वपूर्ण भूमिका निभाई। युद्ध के बाद, उन्होंने मैनचेस्टर विश्वविद्यालय में पढ़ाया और उस पर काम शुरू किया जिसे अब कृत्रिम बुद्धिमत्ता के रूप में जाना जाता है। इस अभूतपूर्व कार्य के दौरान, ट्यूरिंग अपने बिस्तर पर साइनाइड जहर के कारण मृत पाए गए। उनकी मृत्यु समलैंगिक कृत्य (तब एक अपराध) के लिए उनकी गिरफ्तारी और 12 महीने की हार्मोन थेरेपी की सजा के बाद हुई।

2009 में एक सार्वजनिक अभियान के बाद, ब्रिटिश प्रधान मंत्री गॉर्डन ब्राउन ने ट्यूरिंग के साथ किए गए भयावह व्यवहार के लिए ब्रिटिश सरकार की ओर से आधिकारिक सार्वजनिक माफी मांगी। महारानी एलिजाबेथ द्वितीय ने 2013 में मरणोपरांत क्षमादान दिया। "एलन ट्यूरिंग कानून" शब्द का उपयोग अब अनौपचारिक रूप से यूनाइटेड किंगडम में 2017 के कानून को संदर्भित करने के लिए किया जाता है, जो समलैंगिक कृत्यों को गैरकानूनी घोषित करने वाले ऐतिहासिक कानून के तहत चेतावनी दिए गए या दोषी ठहराए गए पुरुषों को पूर्वव्यापी रूप से माफ कर देता है।

ट्यूरिंग के पास उनकी मूर्तियों और उनके नाम पर रखी गई कई चीज़ों की एक व्यापक विरासत है, जिसमें कंप्यूटर विज्ञान नवाचारों के लिए एक वार्षिक पुरस्कार भी शामिल है। वह बैंक ऑफ इंग्लैंड के मौजूदा £50 नोट पर दिखाई देते हैं, जो उनके जन्मदिन के अवसर पर 23 जून, 2021 को जारी किया गया था। दर्शकों द्वारा वोट किए गए 2019 बीबीसी सीरीज़ में उन्हें 20वीं सदी का सबसे महान व्यक्ति बताया गया।

## [सॉफ्टवेयर इंजीनियरिंग](Software%20Engineering/readme.md)
सॉफ्टवेयर इंजीनियरिंग कंप्यूटर विज्ञान की वह शाखा है जो सॉफ्टवेयर अनुप्रयोगों के डिजाइन, विकास, परीक्षण और रखरखाव से संबंधित है। सॉफ्टवेयर इंजीनियर अंतिम उपयोगकर्ताओं के लिए सॉफ्टवेयर समाधान बनाने के लिए इंजीनियरिंग सिद्धांतों और प्रोग्रामिंग भाषाओं के ज्ञान को लागू करते हैं।

आइए सॉफ्टवेयर इंजीनियरिंग की विभिन्न परिभाषाओं पर नजर डालें:
- आई ई ई ई, अपने मानक 610.12-1990 में, सॉफ्टवेयर इंजीनियरिंग को एक व्यवस्थित, अनुशासित अनुप्रयोग के रूप में परिभाषित करता है, जो सॉफ्टवेयर के विकास, संचालन और रखरखाव के लिए एक गणना योग्य दृष्टिकोण है।
- फ्रिट्ज़ बाउर ने इसे 'प्रतिष्ठान' के रूप में परिभाषित किया और मानक इंजीनियरिंग सिद्धांतों का इस्तेमाल किया। यह आपको किफायती सॉफ़्टवेयर प्राप्त करने में मदद करता है जो विश्वसनीय है और वास्तविक मशीनों पर कुशलतापूर्वक काम करता है।
- बोहेम सॉफ्टवेयर इंजीनियरिंग को 'कंप्यूटर प्रोग्रामों के रचनात्मक डिजाइन और निर्माण के लिए वैज्ञानिक ज्ञान के व्यावहारिक अनुप्रयोग' के रूप में परिभाषित करता है। इसमें उनके विकास, संचालन और रखरखाव के लिए आवश्यक संबंधित दस्तावेज भी शामिल हैं।'

## [एकीकृत सर्किट](Integrated%20Circuits/readme.md)
एक एकीकृत सर्किट या मोनोलिथिक इंटीग्रेटेड सर्किट (जिसे IC, चिप या माइक्रोचिप भी कहा जाता है) अर्धचालक सामग्री, आमतौर पर सिलिकॉन के एक छोटे फ्लैट टुकड़े (या "चिप") पर इलेक्ट्रॉनिक सर्किट का एक सेट है। कई छोटे MOSFETs (धातु-ऑक्साइड-अर्धचालक क्षेत्र-प्रभाव ट्रांजिस्टर) एक छोटी चिप में एकीकृत होते हैं। इसके परिणामस्वरूप ऐसे सर्किट बनते हैं जो अलग-अलग इलेक्ट्रॉनिक घटकों से निर्मित सर्किट की तुलना में छोटे, तेज़ और कम महंगे होते हैं। IC की बड़े पैमाने पर उत्पादन क्षमता, विश्वसनीयता और एकीकृत सर्किट डिजाइन के लिए बिल्डिंग-ब्लॉक दृष्टिकोण ने असतत ट्रांजिस्टर के स्थान पर मानकीकृत IC को तेजी से अपनाना सुनिश्चित किया है। IC का उपयोग अब लगभग सभी इलेक्ट्रॉनिक उपकरणों में किया जाता है और इसने इलेक्ट्रॉनिक्स की दुनिया में क्रांति ला दी है। कंप्यूटर, मोबाइल फोन और अन्य घरेलू उपकरण अब आधुनिक समाज की संरचना का अभिन्न अंग हैं, जो आधुनिक कंप्यूटर प्रोसेसर और माइक्रोकंट्रोलर जैसे IC के छोटे आकार और कम लागत के कारण संभव हुआ है।

धातु-ऑक्साइड-सिलिकॉन (एमओएस) सेमीकंडक्टर डिवाइस निर्माण में तकनीकी प्रगति द्वारा बहुत बड़े पैमाने पर एकीकरण को व्यावहारिक बनाया गया था। 1960 के दशक में अपनी उत्पत्ति के बाद से, चिप्स के आकार, गति और क्षमता में काफी प्रगति हुई है, जो तकनीकी प्रगति से प्रेरित है जो एक ही आकार के चिप्स पर अधिक से अधिक एमओएस ट्रांजिस्टर फिट करते हैं - एक आधुनिक चिप में कई अरब एमओएस ट्रांजिस्टर हो सकते हैं क्षेत्रफल मनुष्य के नाखून के बराबर है। ये प्रगति, मोटे तौर पर मूर के नियम का पालन करते हुए, आज के कंप्यूटर चिप्स को 1970 के दशक की शुरुआत के कंप्यूटर चिप्स की तुलना में लाखों गुना अधिक क्षमता और हजारों गुना अधिक गति प्रदान करती है।

अलग-अलग सर्किट की तुलना में IC के दो मुख्य फायदे हैं: लागत और प्रदर्शन। लागत कम है क्योंकि चिप्स, उनके सभी घटकों के साथ, एक समय में एक ट्रांजिस्टर के बजाय फोटोलिथोग्राफी द्वारा एक इकाई के रूप में मुद्रित होते हैं। इसके अलावा, पैकेज्ड IC अलग-अलग सर्किट की तुलना में बहुत कम सामग्री का उपयोग करते हैं। प्रदर्शन उच्च है क्योंकि IC के घटक तेजी से स्विच करते हैं और अपने छोटे आकार और निकटता के कारण तुलनात्मक रूप से कम बिजली की खपत करते हैं। IC का मुख्य नुकसान उन्हें डिजाइन करने और आवश्यक फोटोमास्क बनाने की उच्च लागत है। इस उच्च प्रारंभिक लागत का मतलब है कि IC केवल तभी व्यावसायिक रूप से व्यवहार्य हैं जब उच्च उत्पादन मात्रा का अनुमान हो।

## [ऑब्जेक्ट ओरिएंटेड प्रोग्रामिंग](Object%20Oriented%20Programming/readme.md)
ऑब्जेक्ट ओरिएंटेड प्रोग्रामिंग एक मौलिक प्रोग्रामिंग प्रतिमान है जो ऑब्जेक्ट और डेटा की अवधारणाओं पर आधारित है।

यह कोड का मानक तरीका है जिसका पालन प्रत्येक प्रोग्रामर को कोड की बेहतर पठनीयता और पुन: प्रयोज्य के लिए करना होता है।
### ऑब्जेक्ट ओरिएंटेड प्रोग्रामिंग की चार बुनियादी अवधारणाएँ हैं:
- मतिहीनता
- कैप्सूलीकरण
- विरासत
- बहुरूपता

OOP की इन अवधारणाओं के बारे में और पढ़ें [यहां](Object%20Oriented%20Programming/readme.md)

## [फ़ंकशनाल प्रोग्रामिंग](Functional%20Programming/readme.md)

## [ऑपरेटिंग सिस्टम](Operating%20Systems/readme.md)

## [मेमोरी और स्टोरेज](Memory%20and%20Storage/readme.md)

## [फाइल सिस्टम](File%20System/readme.md)

## [क्लाउड कम्प्यूटिंग](Cloud%20Computing/Readme.md)
क्लाउड कंप्यूटिंग इंटरनेट पर सूचना और एप्लिकेशन तक पहुंचने की क्षमता है। क्लाउड कंप्यूटिंग उपयोगकर्ताओं को इंटरनेट कनेक्शन के साथ किसी भी स्थान से एप्लिकेशन और डेटा तक पहुंचने की अनुमति देता है।

क्लाउड कंप्यूटिंग एक प्रकार की इंटरनेट-आधारित कंप्यूटिंग है जो मांग पर कंप्यूटर और अन्य उपकरणों को साझा कंप्यूटर प्रोसेसिंग संसाधन और डेटा प्रदान करती है।

यह कॉन्फ़िगर करने योग्य कंप्यूटिंग संसाधनों (जैसे, नेटवर्क, सर्वर, स्टोरेज, एप्लिकेशन और सेवाओं) के साझा पूल तक सर्वव्यापी, सुविधाजनक, ऑन-डिमांड नेटवर्क पहुंच को सक्षम करने के लिए एक मॉडल है जिसे न्यूनतम प्रबंधन प्रयास या सेवा के साथ तेजी से प्रावधानित और जारी किया जा सकता है। 

### क्लाउड कंप्यूटिंग के लाभ
व्यवसायों द्वारा IT संसाधनों के बारे में सोचने के तरीके में क्लाउड कंप्यूटिंग एक बड़ा बदलाव है। यहां सात सामान्य कारण बताए गए हैं कि संगठन क्लाउड कंप्यूटिंग सेवाओं की ओर रुख कर रहे हैं:

लागत:
क्लाउड कंप्यूटिंग हार्डवेयर और सॉफ्टवेयर खरीदने और ऑन-साइट डेटा सेंटर स्थापित करने और चलाने की पूंजीगत व्यय को समाप्त कर देता है - सर्वर के रैक, बिजली और शीतलन के लिए चौबीसों घंटे बिजली, और बुनियादी ढांचे के प्रबंधन के लिए आईटी विशेषज्ञ। यह तेजी से जुड़ता है।

त्वरित:
अधिकांश क्लाउड कंप्यूटिंग सेवाएं स्वयं-सेवा और मांग पर प्रदान की जाती हैं, इसलिए बड़ी मात्रा में कंप्यूटिंग संसाधनों को मिनटों में प्रावधानित किया जा सकता है, आमतौर पर केवल कुछ माउस क्लिक के साथ, व्यवसायों को बहुत अधिक लचीलापन मिलता है और क्षमता योजना पर दबाव कम होता है।

वैश्विक स्तर:
क्लाउड कंप्यूटिंग सेवाओं के लाभों में लचीले ढंग से स्केल करने की क्षमता शामिल है। क्लाउड स्पीक में, इसका मतलब है कि आईटी संसाधनों की सही मात्रा - उदाहरण के लिए, अधिक या कम कंप्यूटिंग शक्ति, भंडारण और बैंडविड्थ - सही समय पर और सही भौगोलिक स्थान से वितरित करना।

उत्पादकता:
ऑन-साइट डेटा केंद्रों को आमतौर पर बहुत सारी "रैकिंग और स्टैकिंग" की आवश्यकता होती है - हार्डवेयर सेटअप, सॉफ़्टवेयर पैचिंग, और अन्य समय लेने वाली आईटी प्रबंधन कार्य। क्लाउड कंप्यूटिंग इनमें से कई कार्यों की आवश्यकता को समाप्त कर देती है, इसलिए आईटी टीमें अधिक महत्वपूर्ण व्यावसायिक लक्ष्यों को प्राप्त करने में समय व्यतीत कर सकती हैं।

प्रदर्शन:
सबसे बड़ी क्लाउड कंप्यूटिंग सेवाएँ सुरक्षित डेटा केंद्रों के विश्वव्यापी नेटवर्क पर चलती हैं, जिन्हें नियमित रूप से नवीनतम पीढ़ी के तेज़ और कुशल कंप्यूटिंग हार्डवेयर में अपग्रेड किया जाता है। यह एकल कॉर्पोरेट डेटा सेंटर पर कई लाभ प्रदान करता है, जिसमें अनुप्रयोगों के लिए कम नेटवर्क विलंबता और पैमाने की अधिक अर्थव्यवस्थाएं शामिल हैं।

विश्वसनीयता:
क्लाउड कंप्यूटिंग डेटा बैकअप, डिजास्टर रिकवरी और व्यापार निरंतरता को आसान और कम खर्चीला बनाता है क्योंकि डेटा को क्लाउड प्रदाता के नेटवर्क पर कई अनावश्यक साइटों पर मिरर किया जा सकता है।

सुरक्षा:
कई क्लाउड प्रदाता नीतियों, प्रौद्योगिकियों और नियंत्रणों का एक व्यापक सेट पेश करते हैं जो आपके डेटा, ऐप्स और बुनियादी ढांचे को संभावित खतरों से बचाने में मदद करते हुए आपकी सुरक्षा स्थिति को समग्र रूप से मजबूत करते हैं।

### क्लाउड कंप्यूटिंग सेवाओं के प्रकार
- [इंफ्रास्ट्रक्चर एक सर्विस कि तरह (IaaS)](Cloud%20Computing/Readme.md#infrastructure-as-a-service-iaas)
- [प्लैटफरम एक सर्विस कि तरह (PaaS)](Cloud%20Computing/Readme.md#platform-as-a-service-paas)
- [सॉफ्टवैर एक सर्विस कि तरह (SaaS)](Cloud%20Computing/Readme.md#software-as-a-service-saas)


## [यंत्र अधिगम (मशीन लर्निंग)]()

## [वेब प्रौद्योगिकी](Web%20Technology/WebTechnology.md#web-tecnology)

## [नेटवर्किंग](Networking/readme.md#networking)

## [इंटरनेट](Internet/readme.md#internet)
इंटरनेट इंटरकनेक्टेड कंप्यूटर नेटवर्क की एक वैश्विक प्रणाली है जो दुनिया भर के अरबों उपयोगकर्ताओं को सेवा प्रदान करने के लिए मानक इंटरनेट प्रोटोकॉल सूट ([टीसीपी/आईपी](Networking/readme.md#tcptransmission-control-protocol)) का उपयोग करती है। यह नेटवर्कों का एक नेटवर्क है जिसमें स्थानीय से वैश्विक दायरे के लाखों निजी, सार्वजनिक, शैक्षणिक, व्यावसायिक और सरकारी नेटवर्क शामिल हैं जो इलेक्ट्रॉनिक, वायरलेस और ऑप्टिकल नेटवर्किंग प्रौद्योगिकियों की एक विस्तृत श्रृंखला से जुड़े हुए हैं। इंटरनेट सूचना संसाधनों और सेवाओं की एक विस्तृत श्रृंखला प्रदान करता है, जैसे इंटरलिंक्ड हाइपरटेक्स्ट दस्तावेज़ और वर्ल्ड वाइड वेब के एप्लिकेशन ([WWW](Internet/readme.md#world-wide-web-www)) और समर्थन करने के लिए बुनियादी ढांचा ईमेल।

### [वर्ल्ड वाइड वेब (WWW)](Internet/readme.md#world-wide-web-www)
वर्ल्ड वाइड वेब (डब्ल्यूडब्ल्यूडब्ल्यू) एक सूचना स्थान है जहां दस्तावेजों और अन्य वेब संसाधनों को यूनिफ़ॉर्म रिसोर्स लोकेटर (यूआरएल) द्वारा पहचाना जाता है, हाइपरटेक्स्ट लिंक द्वारा इंटरलिंक किया जाता है और इंटरनेट के माध्यम से पहुंच योग्य होता है। अंग्रेजी वैज्ञानिक टिम बर्नर्स-ली ने 1989 में वर्ल्ड वाइड वेब का आविष्कार किया था। उन्होंने स्विट्जरलैंड में CERN में कार्यरत रहते हुए 1990 में पहला वेब ब्राउज़र लिखा था। ब्राउज़र को 1991 में CERN के बाहर, पहले जनवरी 1991 में अन्य अनुसंधान संस्थानों के लिए और अगस्त 1991 में इंटरनेट पर आम जनता के लिए जारी किया गया था।

### [इंटरनेट प्रोटोकॉल (IP)](Internet/readme.md#internet-protocol-ip)
इंटरनेट प्रोटोकॉल (आईपी) डेटा के पैकेटों को रूट करने और संबोधित करने के लिए एक प्रोटोकॉल या नियमों का सेट है, ताकि वे पूरे नेटवर्क में यात्रा कर सकें और सही गंतव्य पर पहुंच सकें। इंटरनेट पर मौजूद डेटा को छोटे-छोटे टुकड़ों में विभाजित किया जाता है जिन्हें पैकेट कहा जाता है।


## [डीबीएमएस (डेटाबेस प्रबंधन प्रणाली)]()

## [क्रिप्टोग्राफी](Cryptography/readme.md#cryptography)
क्रिप्टोग्राफी डेटा और संचार को सुरक्षित करने की एक तकनीक है। यह कोड के उपयोग के माध्यम से सूचना और संचार को सुरक्षित रखने की एक विधि है ताकि केवल वे लोग ही इसे पढ़ और संसाधित कर सकें जिनके लिए जानकारी का इरादा है। क्रिप्टोग्राफी का उपयोग पारगमन, आराम और उपयोग में डेटा की सुरक्षा के लिए किया जाता है। उपसर्ग _क्रिप्ट_ का अर्थ है "छिपा हुआ" या "गुप्त", और प्रत्यय _ग्राफी_ का अर्थ है "लिखना"।

### क्रिप्टोग्राफी के प्रकार
क्रिप्टोग्राफी के दो प्रकार हैं:
1. [सममित क्रिप्टोग्राफी](Cryptography/readme.md#symmetric-cryptography)
2. [असममित क्रिप्टोग्राफी](Cryptography/readme.md#asymmetric-cryptography)

### [क्रिप्टो करेंसी](Cryptography/CryptoCurrency/readme.md#crypto-currency)
क्रिप्टोकरेंसी एक डिजिटल मुद्रा है जिसमें एन्क्रिप्शन तकनीकों का उपयोग मुद्रा की इकाइयों की पीढ़ी को विनियमित करने और केंद्रीय बैंक से स्वतंत्र रूप से संचालित होने वाले धन के हस्तांतरण को सत्यापित करने के लिए किया जाता है। केंद्रीकृत डिजिटल मुद्रा और केंद्रीय बैंकिंग प्रणालियों के विपरीत क्रिप्टोकरेंसी विकेंद्रीकृत नियंत्रण का उपयोग करती है। प्रत्येक क्रिप्टोकरेंसी का विकेंद्रीकृत नियंत्रण वितरित बहीखाता तकनीक के माध्यम से काम करता है, आमतौर पर एक ब्लॉकचेन, जो सार्वजनिक वित्तीय लेनदेन डेटाबेस के रूप में कार्य करता है। क्रिप्टोकरेंसी की एक परिभाषित विशेषता, और यकीनन इसका सबसे आकर्षक आकर्षण, इसकी जैविक प्रकृति है; यह किसी केंद्रीय प्राधिकरण द्वारा जारी नहीं किया जाता है, जो इसे सैद्धांतिक रूप से सरकारी हस्तक्षेप या हेरफेर से प्रतिरक्षित करता है।

### क्रिप्टो करेंसी के दो प्रकार हैं:
1. [कार्य का प्रमाण](Cryptography/CryptoCurrency/ProofOfWork/readme.md#proof-of-work)
2. [हिस्सेदारी का प्रमाण](Cryptography/CryptoCurrency/ProofOfStake/readme.md#proof-of-stake)

### _सर्वाधिक लोकप्रिय क्रिप्टो मुद्राएँ इस प्रकार हैं:_
1. [Bitcoin](Cryptography/CryptoCurrency/ProofOfWork/Bitcoin/readme.md#bitcoin)
2. [Ethereum](Cryptography/CryptoCurrency/ProofOfStake/Ethereum/readme.md#ethereum)
3. [Litecoin](Cryptography/CryptoCurrency/ProofOfWork/Litecoin/readme.md#litecoin)
4. [Cardano](Cryptography/CryptoCurrency/ProofOfStake/Cardano/readme.md#cardano)
5. [Dogecoin](Cryptography/CryptoCurrency/ProofOfWork/Dogecoin/readme.md#dogecoin)

## संगणना का सिद्धांत
सैद्धांतिक कंप्यूटर विज्ञान और गणित में, गणना का सिद्धांत वह शाखा है जो इस बात से संबंधित है कि एल्गोरिदम का उपयोग करके गणना के मॉडल पर किन समस्याओं को हल किया जा सकता है, उन्हें कितनी कुशलता से हल किया जा सकता है, या किस हद तक (उदाहरण के लिए, अनुमानित समाधान बनाम सटीक समाधान). क्षेत्र को तीन प्रमुख शाखाओं में विभाजित किया गया है: ऑटोमेटा सिद्धांत और औपचारिक भाषाएं, कम्प्यूटेबिलिटी सिद्धांत, और कम्प्यूटेशनल जटिलता सिद्धांत, जो इस प्रश्न से जुड़े हुए हैं: "कंप्यूटर की मूलभूत क्षमताएं और सीमाएं क्या हैं?"

### ऑटोमेटा सिद्धांत
ऑटोमेटा सिद्धांत अमूर्त मशीनों और ऑटोमेटा के साथ-साथ कम्प्यूटेशनल समस्याओं का अध्ययन है जिन्हें उनका उपयोग करके हल किया जा सकता है। यह सैद्धांतिक कंप्यूटर विज्ञान में एक सिद्धांत है। ऑटोमेटा शब्द ग्रीक शब्द αὐτόματος से आया है, जिसका अर्थ है "स्व-अभिनय, स्व-इच्छाधारी, स्व-चालित"। एक ऑटोमेटन (बहुवचन में ऑटोमेटा) एक अमूर्त स्व-चालित कंप्यूटिंग डिवाइस है जो स्वचालित रूप से संचालन के पूर्व निर्धारित अनुक्रम का पालन करता है। राज्यों की एक सीमित संख्या वाले एक ऑटोमेटन को परिमित ऑटोमेटन (एफए) या परिमित-राज्य मशीन (एफएसएम) कहा जाता है। दाईं ओर का चित्र एक परिमित-राज्य मशीन को दर्शाता है, जो एक प्रसिद्ध प्रकार का ऑटोमेटन है। इस ऑटोमेटन में स्थितियाँ (वृत्तों द्वारा चित्र में दर्शाई गई) और संक्रमण (तीरों द्वारा दर्शाई गई) शामिल हैं। जैसे ही ऑटोमेटन इनपुट का एक प्रतीक देखता है, यह अपने संक्रमण फ़ंक्शन के अनुसार, किसी अन्य राज्य में संक्रमण (या छलांग) करता है, जो पिछले राज्य और वर्तमान इनपुट प्रतीक को अपने तर्क के रूप में लेता है।

### औपचारिक भाषाएँ
तर्क, गणित, कंप्यूटर विज्ञान और भाषा विज्ञान में, एक औपचारिक भाषा में ऐसे शब्द होते हैं जिनके अक्षर वर्णमाला से लिए जाते हैं और नियमों के एक विशिष्ट सेट के अनुसार अच्छी तरह से बनाए जाते हैं।

औपचारिक भाषा की वर्णमाला में प्रतीक, अक्षर या चिह्न होते हैं जो भाषा के तारों में जुड़ते हैं। इस वर्णमाला के प्रतीकों से जुड़ी प्रत्येक स्ट्रिंग को एक शब्द कहा जाता है, और जो शब्द किसी विशेष औपचारिक भाषा से संबंधित होते हैं उन्हें कभी-कभी सुगठित शब्द या सुगठित सूत्र कहा जाता है। एक औपचारिक भाषा को अक्सर औपचारिक व्याकरण का उपयोग करके परिभाषित किया जाता है, जैसे कि नियमित व्याकरण या संदर्भ-मुक्त व्याकरण, जिसमें इसके गठन के नियम शामिल होते हैं।

कंप्यूटर विज्ञान में, औपचारिक भाषाओं का उपयोग, अन्य बातों के अलावा, प्रोग्रामिंग भाषाओं के व्याकरण और प्राकृतिक भाषाओं के सबसेट के औपचारिक संस्करणों को परिभाषित करने के आधार के रूप में किया जाता है, जिसमें भाषा के शब्द उन अवधारणाओं का प्रतिनिधित्व करते हैं जो विशेष अर्थ या शब्दार्थ से जुड़े होते हैं। कम्प्यूटेशनल जटिलता सिद्धांत में, निर्णय समस्याओं को आम तौर पर औपचारिक भाषाओं के रूप में परिभाषित किया जाता है और जटिलता वर्गों को औपचारिक भाषाओं के सेट के रूप में परिभाषित किया जाता है जिन्हें सीमित कम्प्यूटेशनल शक्ति वाली मशीनों द्वारा पार्स किया जा सकता है। तर्क और गणित की नींव में, औपचारिक भाषाओं का उपयोग स्वयंसिद्ध प्रणालियों के वाक्यविन्यास का प्रतिनिधित्व करने के लिए किया जाता है, और गणितीय औपचारिकतावाद वह दर्शन है कि सभी गणित को इस तरह से औपचारिक भाषाओं के वाक्यविन्यास हेरफेर में कम किया जा सकता है।

### संगणना सिद्धांत
कम्प्यूटेबिलिटी सिद्धांत, जिसे रिकर्सन सिद्धांत के रूप में भी जाना जाता है, गणितीय तर्क, कंप्यूटर विज्ञान और गणना के सिद्धांत की एक शाखा है जिसकी उत्पत्ति 1930 के दशक में गणना योग्य कार्यों और ट्यूरिंग डिग्री के अध्ययन के साथ हुई थी। तब से इस क्षेत्र का विस्तार सामान्यीकृत कम्प्यूटेबिलिटी और निश्चितता के अध्ययन को शामिल करने के लिए किया गया है। इन क्षेत्रों में, संगणनीयता सिद्धांत प्रमाण सिद्धांत और प्रभावी वर्णनात्मक सेट सिद्धांत के साथ ओवरलैप होता है।

### कम्प्यूटेशनल जटिलता सिद्धांत
सैद्धांतिक कंप्यूटर विज्ञान और गणित में, कम्प्यूटेशनल जटिलता सिद्धांत उनके संसाधन उपयोग के अनुसार कम्प्यूटेशनल समस्याओं को वर्गीकृत करने और इन वर्गों को एक दूसरे से संबंधित करने पर केंद्रित है। कम्प्यूटेशनल समस्या कंप्यूटर द्वारा हल किया जाने वाला कार्य है। एक गणना समस्या को एल्गोरिदम जैसे गणितीय चरणों के यांत्रिक अनुप्रयोग द्वारा हल किया जा सकता है।

किसी समस्या को स्वाभाविक रूप से कठिन माना जाता है यदि उसके समाधान के लिए महत्वपूर्ण संसाधनों की आवश्यकता होती है, भले ही एल्गोरिदम का उपयोग कुछ भी हो। सिद्धांत इन समस्याओं का अध्ययन करने और उनकी कम्प्यूटेशनल जटिलता की मात्रा निर्धारित करने के लिए गणना के गणितीय मॉडल पेश करके इस अंतर्ज्ञान को औपचारिक बनाता है, यानी, उन्हें हल करने के लिए आवश्यक संसाधनों की संख्या, जैसे समय और भंडारण। जटिलता के अन्य उपायों का भी उपयोग किया जाता है, जैसे संचार की मात्रा (संचार जटिलता में प्रयुक्त), सर्किट में गेटों की संख्या (सर्किट जटिलता में प्रयुक्त), और प्रोसेसर की संख्या (समानांतर कंप्यूटिंग में प्रयुक्त)। कम्प्यूटेशनल जटिलता सिद्धांत की भूमिकाओं में से एक कंप्यूटर क्या कर सकता है और क्या नहीं, इसकी व्यावहारिक सीमाएं निर्धारित करना है। पी बनाम एनपी समस्या, सात सहस्राब्दी पुरस्कार समस्याओं में से एक, कम्प्यूटेशनल जटिलता के क्षेत्र के लिए समर्पित है।

सैद्धांतिक कंप्यूटर विज्ञान में निकटतम संबंधित क्षेत्र एल्गोरिदम और कम्प्यूटेबिलिटी सिद्धांत का विश्लेषण हैं। एल्गोरिदम के विश्लेषण और कम्प्यूटेशनल जटिलता सिद्धांत के बीच एक महत्वपूर्ण अंतर यह है कि पूर्व किसी समस्या को हल करने के लिए किसी विशेष एल्गोरिदम द्वारा आवश्यक संसाधनों की संख्या का विश्लेषण करने के लिए समर्पित है, जबकि बाद वाला उन सभी संभावित एल्गोरिदम के बारे में अधिक सामान्य प्रश्न पूछता है जिनका उपयोग किया जा सकता है। उसी समस्या को हल करने के लिए. अधिक सटीक रूप से, कम्प्यूटेशनल जटिलता सिद्धांत उन समस्याओं को वर्गीकृत करने का प्रयास करता है जिन्हें उचित रूप से प्रतिबंधित संसाधनों के साथ हल किया जा सकता है या नहीं। बदले में, उपलब्ध संसाधनों पर प्रतिबंध लगाना कम्प्यूटेशनल जटिलता को कम्प्यूटेबिलिटी सिद्धांत से अलग करता है: बाद वाला सिद्धांत पूछता है कि सिद्धांत रूप में किस प्रकार की समस्याओं को एल्गोरिदमिक रूप से हल किया जा सकता है।
