<h1 align="center">Computer Science</h1>
<h4 align="center">
    <p>
        <a href="https://github.com/shhossain/computer_science/blob/main/readme_fr.md">English</a> |
        <a href="https://github.com/shhossain/computer_science/blob/main/README_it.md">Italiano</a> |
        <a href="https://github.com/shhossain/computer_science/blob/main/README_es.md">Español</a> |
        <b>Français</b> |
        <a href="https://github.com/shhossain/computer_science/blob/main/README_bn.md">বাংলা</a> |
        <a href="https://github.com/shhossain/computer_science/blob/main/README_ta.md">தமிழ்</a> |
        <a href="https://github.com/shhossain/computer_science/blob/main/README_guj.md">ગુજરાતી</a> |
        <a href="https://github.com/shhossain/computer_science/blob/main/README_pt.md">Portuguese</a> |
        <a href="https://github.com/shhossain/computer_science/blob/main/README_ro.md">Română</a>
    </p>
</h4>

## Guide de contribution

Si vous souhaitez participer à ce projet, prenez le temps de jeter un œil au guide de contribution [CONTRIBUTING.md](https://github.com/shhossain/computer_science/blob/main/CONTRIBUTING.md) pour obtenir plus de détails sur comment participer et comment commencer. Votre aide est grandement appréciée.

## Table des matières

- [Introduction](#introduction)
- [Ordinateur électronique](#ordinateur-electronique)
- [Logique booléenne](#logique-booleenne)
- [Langages de programmation](#langages-de-programmation)

## Introduction

L'informatique est l'étude des ordinateurs mais également de l'application théorique et pratique de ceux-ci. L'informatique utilise les principes des mathématiques, de l'ingénierie et de la logique afin de répondre à une multitude de problèmes. Ceci comprend la formulation d'algorithmes, le développement de logiciels et de matériel ainsi que d'intelligence artificielle.

## [Ordinateur électronique](/Electronic%20Computer/readme_fr.md)
Un ordinateur électronique est un appareil qui calcule et plus particulièrement une machine électronique programmable qui effectue des calculs ou des opérations logiques à grande vitesse. Elle peut également assembler, stocker, mettre en corrélation ou traiter l'information.

## [Logique booléenne (ou opérateurs logiques)](Boolean%20Logic/readme_fr.md)
La logique booléenne est une branche des mathématiques qui traite des valeurs dites vraies ou fausses (true ou false). C'est un système logique qui utilise 2 valeurs, 0 et 1, pour différencier respectivement le vrai et le faux. Elle est également appelée algèbre de Boole par son créateur George Boole en 1854.

### Opérateurs booléens récurrents
| Opérateur | Nom |               Description               |
| :------: | :--: | :-------------------------------------: |
|    !     | NON  | Inverse l'état d'une variable booléenne. (0 -> 1 ; 1 -> 0) |
|    &&    |  ET  | Retourne **vrai** si TOUTES les conditions sont respectées. |
|   \|\|   |  OU  | Retourne **vrai** si au moins UNE des conditions est respectée. |

### Opérateurs booléens utiles
| Opérateur | Nom |               Description               |
| :------: | :--: | :-------------------------------------: |
|    ()    | Parenthèses |   Permet de regrouper des mots-clés et/ou contrôler l'ordre de recherche. (priorité) |
|    “”    | Guillemets | Renvoie le résultat comprenant la phrase exacte. |
|   *      |  Astérisque | Renvoie le résultat comprenant un mot-clé. |
|   ⊕     |  XOR  - OU exclusif | Retourne **vrai** si les entrées sont différentes. |
|   ⊽      |  NOR - OU inversé | Retourne **vrai** si toutes les entrées sont fausses. |
|   ⊼      |  NAND - ET inversé | Retourne **faux** si les deux valeurs d'entrée sont vraies. |

## [Langages de programmation](/Programming_Languages/readme_fr.md)
Un langage de programmation est un ensemble de règles qui convertit des chaînes de caractères, ou des éléments graphiques de programme dans le cas des langages de programmation visuels, en différents types de code machine. Les langages de programmation sont un type de langage informatique utilisé dans la programmation pour implémenter des algorithmes. 

Les langages de programmation sont souvent divisés en deux grandes catégories :
1. Les langages dits de "haut niveau" qui utilisent une syntaxe proche du langage humain. Le code source y est plus intelligible et il est compilé en code exécutable via un compilateur ou un interpréteur. Java et Python sont deux exemples de langages de "haut niveau". Ils sont plus simples d'utilisation et plus génériques. En contrepartie, ils peuvent apparaître moins optimisés.
2. Les langages de programmation de bas niveau fonctionnent plus étroitement avec le matériel et offrent un plus grand contrôle sur celui-ci. Ils interagissent directement avec le matériel. Deux exemples courants de langages de bas niveau sont le langage machine et le langage assembleur. Ces langages sont généralement plus rapides que ceux de haut niveau, mais cela se fait au prix d'une grande complexité et d'un manque de lisibilité.

### [Paradigmes de programmation](/Programming_Languages/readme_fr.md#paradigmes-de-programmation)
Il existe également plusieurs *paradigmes de programmation* différents. Les paradigmes de programmation sont des façons ou styles différents selon lesquels un programme ou un langage de programmation peut être organisé. Chaque paradigme comporte certaines structures, fonctionnalités et opinions sur la manière dont les problèmes courants de programmation doivent être abordés.

Les paradigmes de programmation *ne sont pas* des langages ou des outils. Vous ne pouvez pas "construire" quoi que ce soit avec un paradigme. Ce *sont* plutôt un ensemble d'idéaux et de lignes directrices sur lesquels de nombreuses personnes se sont mises d'accord, qu'elles ont suivis et sur lesquels elles ont développé. Les langages de programmation ne sont pas toujours liés à un paradigme particulier. Il existe des langages qui ont été conçus en tenant compte d'un certain paradigme et qui ont des fonctionnalités facilitant ce type de programmation plus que d'autres (Haskell et la programmation fonctionnelle en sont un bon exemple). Mais il existe également des langages "multi-paradigmes" dans lesquels vous pouvez adapter votre code pour correspondre à un certain paradigme ou à un autre (JavaScript et Python sont de bons exemples).

## [Types de données](Data%20Types/readme_fr.md#types-de-données)
Un type de données, en programmation, est une classification qui spécifie quel type de valeur une variable peut avoir et quel type d'opérations mathématiques, relationnelles ou logiques peuvent lui être appliquées sans provoquer d'erreur.

### [Types de données primitifs](Data%20Types/readme_fr.md#types-de-données-primitifs)
Les types de données primitifs sont les types de données les plus basiques dans un langage de programmation. Ils sont les blocs de construction de types de données plus complexes. Les types de données primitifs sont prédéfinis par le langage de programmation et sont nommés par un mot-clé réservé.

### [Types de données primitifs courants](Data%20Types/readme_fr.md#types-de-données-primitifs-courants)
- [Entier](Data%20Types/readme_fr.md#entier)
- [Flottant](Data%20Types/readme_fr.md#flottant)
- [Booléen](Data%20Types/readme_fr.md#booléen)
- [Caractère](Data%20Types/readme_fr.md#caratère)
- [Chaîne de caractères](Data%20Types/readme_fr.md#chaîne-de-caractères)

### [Types de données non primitifs](Data%20Types/readme_fr.md#types-de-données-non-primitifs)
Les types de données non primitifs sont également connus sous le nom de types de données de référence. Ils sont créés par le programmeur et ne sont pas définis par le langage de programmation. Les types de données non primitifs sont également appelés types de données composites car ils sont composés d'autres types.

### [Types de données non primitifs courants](Data%20Types/readme_fr.md#types-de-données-non-primitifs)
- [Tableau](Data%20Types/readme_fr.md#tableau)
- [Structure](Data%20Types/readme_fr.md#structure)
- [Union](Data%20Types/readme_fr.md#union)
- [Pointeur](Data%20Types/readme_fr.md#pointeur)
- [Fonction](Data%20Types/readme_fr.md#fonction)
- [Classe](Data%20Types/readme_fr.md#classe)

## [Instructions et fonctions](Statements%20and%20Functions/readme_fr.md)
En programmation informatique, une instruction est une unité syntaxique d'un langage de programmation impératif qui exprime une action à effectuer. Un programme écrit dans un tel langage est formé par une séquence d'une ou plusieurs instructions. Une instruction peut avoir des composants internes (par exemple, des expressions).
Il existe deux principaux types d'instructions dans tout langage de programmation nécessaires pour construire la logique d'un code.

1. [Instructions conditionnelles](Statements%20and%20Functions/readme_fr.md#instructions-conditionnelles)

Il existe principalement deux types d'instructions conditionnelles :
- if
- if-else
- switch case

2. [Boucles](Statements%20and%20Functions/readme_fr.md#boucles)

Il existe principalement trois types de boucles :
- boucle for
- boucle while
- boucle do-while (une variation de la boucle while)
- boucle do-until

------------
Une fonction est un bloc d'instructions qui effectue une tâche spécifique. Les fonctions acceptent des données, les traitent et renvoient un résultat ou les exécutent. Les fonctions sont principalement écrites pour soutenir le concept de réutilisabilité. Une fois qu'une fonction est écrite, elle peut être appelée facilement sans avoir à répéter le même code.

Différents langages fonctionnels utilisent des syntaxes différentes pour écrire des fonctions.

Lisez plus sur les fonctions [ici](Statements%20and%20Functions/readme.md#functions)


## [Structures de données](Data%20Structures/readme_fr.md)
En informatique, une structure de données est un format d'organisation, de gestion et de stockage des données qui permet un accès et une modification efficaces. Plus précisément, une structure de données est une collection de valeurs de données, les relations entre elles et les fonctions ou opérations qui peuvent être appliquées aux données.
<!-- 
### Types de structures de données
- [Tableau](Data%20Structures/readme.md#array)
- [Liste chaînée](Data%20Structures/readme.md#linkedlist)
- [Pile](Data%20Structures/readme.md#stack)
- [File](Data%20Structures/readme.md#queue)
- [Table de hachage](Data%20Structures/readme.md#hashtable)
- [Tas](Data%20Structures/readme.md#heap)
- [Arbre](Data%20Structures/readme.md#tree)
- [Graphe](Data%20Structures/readme.md#graph)

## [Algorithmes](Algorithms/readme.md)
Les algorithmes sont les ensembles d'étapes nécessaires pour effectuer des calculs. Ils sont au cœur de ce que font nos appareils, et ce n'est pas un concept nouveau. Depuis le développement des mathématiques elles-mêmes, les algorithmes ont été nécessaires pour nous aider à accomplir des tâches plus efficacement, mais aujourd'hui nous allons examiner quelques problèmes informatiques modernes comme le tri et la recherche de graphes et montrer comment nous les avons rendus plus efficaces afin que vous puissiez plus facilement trouver des billets d'avion bon marché ou des itinéraires vers Winterfell ou un restaurant ou autre chose.

### [Complexité temporelle](Algorithms/Time%20Complexity/readme.md)
La complexité temporelle d'un algorithme estime le temps que l'algorithme utilisera pour une certaine entrée. L'idée est de représenter l'efficacité comme une fonction dont le paramètre est la taille de l'entrée. En calculant la complexité temporelle, nous pouvons déterminer si l'algorithme est suffisamment rapide sans l'implémenter.

### [Complexité spatiale](Algorithms/Space%20Complexity/readme.md)
La complexité spatiale fait référence à la quantité totale d'espace mémoire qu'un algorithme/programme utilise, y compris l'espace des valeurs d'entrée pour l'exécution. Calculez l'espace occupé par les variables dans un algorithme/programme pour déterminer la complexité spatiale.

### [Tri](Algorithms/Sorting/readme.md)
Le tri est le processus consistant à organiser une liste d'éléments dans un ordre particulier. Par exemple, si vous aviez une liste de noms, vous pourriez vouloir les trier par ordre alphabétique. De même, si vous aviez une liste de nombres, vous pourriez vouloir les classer du plus petit au plus grand. Le tri est une tâche courante, et il existe de nombreuses façons de le réaliser.

### [Recherche](Algorithms/Searching/readme.md)
La recherche est un algorithme permettant de trouver un certain élément cible à l'intérieur d'un conteneur. Les algorithmes de recherche sont conçus pour vérifier la présence d'un élément ou récupérer un élément à partir de toute structure de données où il est stocké.

### [Algorithmes basés sur les chaînes de caractères](Algorithms/String%20Based%20Algorithms/readme.md)
Les chaînes de caractères sont l'une des structures de données les plus utilisées et les plus importantes en programmation. Ce dépôt contient quelques-uns des algorithmes les plus utilisés qui aident à améliorer le temps de recherche, rendant notre code plus efficace.

### [Recherche de graphes](Algorithms/Graph/readme.md)
La recherche de graphes est le processus de recherche à travers un graphe pour trouver un nœud particulier. Un graphe est une structure de données qui consiste en un ensemble fini (et éventuellement mutable) de sommets ou de nœuds ou de points, ainsi qu'un ensemble de paires non ordonnées de ces sommets pour un graphe non orienté ou un ensemble de paires ordonnées pour un graphe orienté. Ces paires sont connues sous le nom d'arêtes, arcs ou lignes pour un graphe non orienté, et sous le nom de flèches, arêtes dirigées, arcs dirigés ou lignes dirigées pour un graphe orienté. Les sommets peuvent faire partie de la structure du graphe ou être des entités externes représentées par des indices entiers ou des références. Les graphes sont l'une des structures de données les plus utiles pour de nombreuses applications du monde réel. Les graphes sont utilisés pour modéliser les relations par paires entre les objets. Par exemple, le réseau de routes aériennes est un graphe dans lequel les villes sont les sommets, et les routes aériennes sont les arêtes. Les graphes sont également utilisés pour représenter des réseaux. Internet peut être modélisé comme un graphe dans lequel les ordinateurs sont les sommets, et les liens entre les ordinateurs sont les arêtes. Les graphes sont également utilisés sur les réseaux sociaux comme LinkedIn et Facebook. Les graphes sont utilisés pour représenter de nombreuses applications du monde réel : réseaux informatiques, conception de circuits et planification aéronautique pour n'en nommer que quelques-unes. -->