<h1 align="center">Computer Science</h1>
<h4 align="center">
    <p>
        <a href="https://github.com/shhossain/computer_science/blob/main/README.md">English</a> |
        <a href="https://github.com/shhossain/computer_science/blob/main/README_it.md">Italiano</a> |
        <a href="https://github.com/shhossain/computer_science/blob/main/README_es.md">Español</a> |
        <a href="https://github.com/shhossain/computer_science/blob/main/README_fr.md">Français</a> |
        <a href="https://github.com/shhossain/computer_science/blob/main/README_bn.md">বাংলা</a> |
        <a href="https://github.com/shhossain/computer_science/blob/main/README_ta.md">தமிழ்</a> |
        <a href="https://github.com/shhossain/computer_science/blob/main/README_guj.md">ગુજરાતી</a> |
        <a href="https://github.com/shhossain/computer_science/blob/main/README_pt.md">Portuguese</a> |
        <a href="https://github.com/shhossain/computer_science/blob/main/README_hi.md">हिंदी</a> |
        <a href="https://github.com/shhossain/computer_science/blob/main/README_te.md">తెలుగు</a> |
        <a href="https://github.com/shhossain/computer_science/blob/main/README_ro.md">Română</a> |
        <a href="https://github.com/shhossain/computer_science/blob/main/README_ar.md">العربية</a> |
        <b>简体中文</b>
    </p>
</h4>

## 贡献指南
如果你对于贡献这个项目感兴趣，请查看 [CONTRIBUTING.md](https://github.com/shhossain/computer_science/blob/main/CONTRIBUTING.md) 以了解如何对项目做出贡献。非常感谢你的贡献！

## 目录

- [介绍](#介绍)
- [电子计算机](#电子计算机)
- [布尔逻辑](#布尔逻辑)
- [数字系统](#数字系统)
- [中央处理器](#中央处理器)
- [寄存器和高速缓存](#寄存器和高速缓存)
- [指令和程序](#指令和程序)
- [编程语言](#编程语言)
- [数据类型](#数据类型)
- [声明和函数](#声明和函数)
- [数据结构](#数据结构)
- [算法](#算法)
- [艾伦·图灵](#艾伦图灵)
- [软件工程](#软件工程)
- [集成电路](#集成电路)
- [面向对象编程](#面向对象编程)
- [函数式编程](#函数式编程)
- [操作系统](#操作系统)
- [内存和存储](#内存和存储)
- [文件系统](#文件系统)
- [云计算](#云计算)
- [机器学习](#机器学习)
- [网络技术](#网络技术)
- [计算机网络](#计算机网络)
- [互联网](#互联网)
- [数据库管理系统](#数据库管理系统)
- [密码学](#密码学)
- [计算理论](#计算理论)


## 介绍

计算机科学是研究计算机和计算及其理论和实践应用的学科。计算机科学将数学、工程和逻辑的原理应用于众多问题。这些问题包括算法设计、软件/硬件开发以及人工智能。


## [电子计算机](Electronic%20Computer/readme.md)
电子计算机是一种计算设备，特别是一种执行高速数学或逻辑运算或组装、存储、相关或其他方式处理信息的可编程电子机器。

## [布尔逻辑](Boolean%20Logic/readme.md)
布尔逻辑是数学的一个分支，它处理真和假的值。它是一个逻辑系统，只使用两个值，0和1，分别代表假和真。它也被称为布尔代数，以1854年首次描述它的乔治布尔命名。

### 常见的布尔运算符
| 运算符 | 名称 |               描述               |
| :------: | :--: | :-------------------------------------: |
|    !     | 非  |    取操作数的非。    |
|    &&    | 与  | 如果两个操作数都为真则返回 **true**。 |
|   \|\|   |  或  | 如果一个或所有操作数为真则返回 **true**。 |

### 应该了解的布尔运算符
| 运算符 | 名称 |               描述               |
| :------: | :--: | :-------------------------------------: |
|    ()    | 括号     |   允许你分组关键词并控制搜索的顺序。    |
|    “”    | 引号 | 提供精确短语的结果。 |
|   *      |  星号       | 提供包含关键词变体的结果。 |
|   ⊕     |  异或            | 如果操作数不同则返回 **true** |
|   ⊽      |  或非            | 如果所有操作数为假则返回 **true**。 |
|   ⊼      |  与非           | 只有当其两个输入的值都为真时才返回 **false**。 |

## [数字系统](Number%20System/readme.md#number-systems)
数字系统是表达数字的数学系统。数字系统由一组用来表示数字的符号和一组用来处理这些符号的规则组成。数字系统中使用的符号被称为数字符号。

### [数字系统的类型](Number%20System/readme.md#types-of-number-systems)
- [位置数字符号系统](Number%20System/readme.md#positional-numeral-system)
- [符号-值记数系统](Number%20System/readme.md#sign-value-notation-system)

### [常见的位置数字系统](Number%20System/readme.md#common-positional-number-systems)
- [二进制](Number%20System/readme.md#binary)
- [八进制](Number%20System/readme.md#octal)
- [十进制](Number%20System/readme.md#decimal)
- [十六进制](Number%20System/readme.md#hexadecimal)


### 二进制的重要性
二进制是由莱布尼茨发明的一个由0和1两个数字或字符组成的系统。这个数字系统是所有二进制代码的基础，这些代码被用来编写数码数据，例如每天使用的计算机处理器指令。在二进制中，0和1分别代表OFF或ON。在一个晶体管中， "0"代表没有电流流动， "1"代表电流被允许流动。以这种方式，数字被物理地表示在计算设备内部，允许进行计算。

二进制仍然是计算机的主要语言，以下是其在电子和计算机硬件中的应用原因：

- 它是一个简单而优雅的设计。
- 二进制的0和1方法快速检测电信号的关闭（false）或打开（true）状态。
- 只有两个状态的电信号使其更不易受到电磁干扰。
- 磁介质的正负极快速转换为二进制。
- 二进制是控制逻辑电路的最有效方式。

## [中央处理器](CPU/readme.md#central-processing-unitcpu)
中央处理器（CPU）是所有计算机中最重要的部分。CPU通过发送信号来控制计算机的其他部分，就像大脑控制身体一样。CPU会根据一份要做的计算机工作列表，也就是指令，进行工作。它读取指令列表并按顺序运行（执行）每一条指令。CPU可以运行的指令列表就是一个计算机程序。CPU可以在称为"核心"的部分同时处理多条指令。一个有四个核心的CPU可以一次处理四个程序。CPU本身主要由三个主要组件组成，它们是：
1. [内存或存储单位](CPU/readme.md#memory-or-storage-unit)
2. [控制单元](CPU/readme.md#control-unit)
3. [算术和逻辑单元 (ALU)](CPU/readme.md#arithmetic-and-logic-unit-alu)

## [寄存器和高速缓存](/Registers%20Cache%20and%20RAM)
### [寄存器](/Registers%20Cache%20and%20RAM/readme.md#register)
寄存器是CPU内部包含的少量高速存储器。寄存器是一个由"触发器"（用于存储1位内存的电路）组成的集合。它们被处理器用来存储在处理过程中需要的少量数据。一个CPU可能有几套称为"核心"的寄存器。寄存器还有助于进行算术和逻辑操作。

算术操作是CPU对存储在寄存器中的数值数据进行的数学计算。这些操作包括加法、减法、乘法和除法。逻辑操作是CPU对存储在寄存器中的二进制数据进行的布尔计算。这些操作包括比较（例如，测试两个值是否相等）和逻辑操作（例如，AND，OR，NOT）。

寄存器对于执行这些操作至关重要，因为它们允许CPU快速访问和处理少量数据。通过在寄存器中存储频繁访问的数据，CPU可以避免从内存中检索数据的慢速过程。

更大量的数据可能存储在高速缓存中，这是一种处理速度非常快的存储器，位于与寄存器相同的集成电路上。高速缓存用于存储程序运行时频繁访问的数据。更大量的数据可能存储在RAM中。RAM是随机访问存储器的简称，这种存储器用于保存从磁盘存储中移动的数据和指令，直到处理器需要这些数据和指令时才会使用。


### [高速缓存](/Registers%20Cache%20and%20RAM/readme.md#cache)
高速缓存内存是一种基于芯片的计算机组件，可以使从计算机内存中检索数据更加高效。它充当一个临时存储区，使计算机的处理器可以轻松检索数据。这个被称为高速缓存的临时存储区对处理器来说比计算机的主内存源（通常是某种形式的DRAM）更容易获得。

高速缓存内存有时被称为CPU（中央处理单元）内存，因为它通常直接集成在CPU芯片中，或者放在一个有与CPU单独总线互连的独立芯片上。因此，它对处理器更容易获得，能够提高效率，因为它物理上离处理器更近。

为了靠近处理器，高速缓存内存需要比主内存小得多。因此，它的存储空间更小。它也比主内存更贵，因为它是一个更复杂且性能更强大的芯片

在大小和价格上的牺牲，它在速度上得到了补偿。高速缓存内存的运行速度比RAM快10到100倍，只需要几纳秒就能响应CPU的请求。

用于高速缓存内存的实际硬件的名字是高速静态随机访问存储器(SRAM)。用于计算机主存储器的硬件的名字是动态随机访问存储器(DRAM)。

高速缓存内存不应与更广义的术语高速缓存混淆。高速缓存是临时数据存储，可以在硬件和软件中存在。高速缓存内存指的是允许计算机在网络的各个层次创建高速缓存的特定硬件组件。高速缓存是用于在计算环境中临时存储某物（通常是数据）的硬件或软件。

### [RAM](/Registers%20Cache%20and%20RAM/readme.md#ram)
RAM（随机存取存储器）是一种计算机存储器，可以按任意顺序读取和更改，通常用于存储工作数据和机器代码。随机存取存储器设备允许数据项在几乎相同的时间内被读取或写入，无论数据在内存内的物理位置如何，这与其他直接访问数据存储媒体（如硬盘、CD-RW、DVD-RW和旧式的磁带和磁鼓存储器）形成了鲜明的对比，后者读取和写入数据项所需的时间根据其在记录介质上的物理位置的不同而显著不同，这是由于机械限制（如媒体旋转速度和悬臂移动）。

## [指令和程序](Not-Added)
在计算机科学中，指令是由处理器指令集定义的处理器的单个操作。计算机程序是一系列指令，告诉计算机要做什么。计算机做的每一件事都是通过使用计算机程序来完成的。存储在计算机内存中的程序（"内部编程"）让计算机可以一个接一个地完成任务，虽然中间可能有停顿。

## [编程语言](/Programming_Languages/readme.md)
编程语言是一种规则集，可以将字符串，或者在可视化编程语言中的图形程序元素转换为各种类型的机器代码输出。编程语言是用于计算机编程以实现算法的一种计算机语言。

编程语言通常分为两大类：
1. 高级语言使用与英语类似的语法。源代码使用编译器或解释器转换为机器可理解的机器代码。Java和Python是一些高级编程语言的例子。这些语言的执行速度通常比低级语言慢，但更容易使用。
2. 低级编程语言与硬件更紧密地协作，并对其有更多的控制。它们直接与硬件交互。机器语言和汇编语言是两个常见的低级语言的例子。这些语言通常比高级语言快，但是它们的可读性差，使用起来非常困难。

### [编程范式](/Programming_Languages/readme.md#Programming+Paradigms)
还有几种不同的*编程范式*。编程范式是给定程序或编程语言可以组织的不同方式或风格。每一种范式都包含了一些结构、特性和对如何解决常见编程问题的观点。

编程范式并*不是*语言或工具。你不能用范式来"构建"任何东西。它们更像是一套许多人已经达成一致、遵循并扩展的理想和指导方针。编程语言并不总是与特定的范式相关联。*确实有*一些语言是以某种特定的范式为思路构建的，并且具有比其他语言更能促进那种编程的特性（Haskell和函数式编程就是一个很好的例子）。但也有"多范式"的语言，你可以在其中调整你的代码以适应某种范式或者其他范式（JavaScript和Python就是很好的例子）。

## [数据类型](Data%20Types/readme.md#data-types)
在编程中，数据类型是一种分类，它指定了一个变量具有哪种类型的值，以及可以对它应用哪种类型的数学、关系或逻辑操作，而不会引起错误。

### [基本数据类型](Data%20Types/readme.md#primitive-data-types)
基本数据类型是编程语言中最基本的数据类型。它们是更复杂数据类型的构建块。基本数据类型是由编程语言预定义的，并由保留关键词命名。

### [常见的基本数据类型](Data%20Types/readme.md#common-primitive-data-types)
- [整数](Data%20Types/readme.md#integer)
- [浮点数](Data%20Types/readme.md#float)
- [布尔值](Data%20Types/readme.md#boolean)
- [字符](Data%20Types/readme.md#character)
- [字符串](Data%20Types/readme.md#string)

### [非基本数据类型](Data%20Types/readme.md#non-primitive-data-types)
非基本数据类型也被称为引用数据类型。它们是由程序员创建的，并没有被编程语言定义。非基本数据类型也被称为复合数据类型，因为它们是由其他类型组成的。

### [常见的非基本数据类型](Data%20Types/readme.md#common-non-primitive-data-types)
- [数组](Data%20Types/readme.md#array)
- [结构体](Data%20Types/readme.md#struct)
- [集合](Data%20Types/readme.md#union)
- [指针](Data%20Types/readme.md#pointer)
- [函数](Data%20Types/readme.md#function)
- [类](Data%20Types/readme.md#class)

## [声明和函数](Statements%20and%20Functions/readme.md)
在计算机编程中，语句是命令式编程语言的一个语法单位，表示要执行的某个动作。用这种语言编写的程序由一个或多个语句的序列组成。语句可能有内部组件（例如，表达式）。
在任何编程语言中，有两种主要的语句类型，这些语句对构建代码的逻辑是必要的。

1. [条件语句](Statements%20and%20Functions/readme.md#conditional-statements)

    主要有两种类型的条件语句：
    - if
    - if-else
    - switch case


2. [循环](Statements%20and%20Functions/readme.md#loops)

    主要有三种类型的条件语句：
    - for循环
    - while循环
    - do - while循环 (while循环的一种变形)
    - do - until循环

------------

函数是执行特定任务的语句块。函数接收数据，处理数据，并返回结果或执行之。函数主要是为了支持可重用性的概念。一旦写好一个函数，就可以轻松地调用它，而无需重复相同的代码。

不同的函数式语言使用不同的语法来编写函数。

在[这里](Statements%20and%20Functions/readme.md#functions)阅读更多关于函数的信息。

## [数据结构](Data%20Structures/readme.md)
在计算机科学中，数据结构是一种便于对数据进行增删改查等操作的存储格式。更准确地说，数据结构是一个数据的集合，数据之间的关系和可以应用于数据的函数或操作。

### 数据结构的类型
- [数组](Data%20Structures/readme.md#array)
- [链表](Data%20Structures/readme.md#linkedlist)
- [栈](Data%20Structures/readme.md#stack)
- [队列](Data%20Structures/readme.md#queue)
- [哈希表](Data%20Structures/readme.md#hashtable)
- [堆](Data%20Structures/readme.md#heap)
- [树](Data%20Structures/readme.md#tree)
- [图](Data%20Structures/readme.md#graph)

## [算法](Algorithms/readme.md)
算法是完成计算所必需的一系列步骤。它们是我们设备所做的事情的核心，这并不是一个新名词。自从数学本身的发展以来，我们就需要算法来帮助我们更高效地完成任务，但是今天我们将看一看一些现代计算问题，如排序和图搜索，展示我们如何使它们更高效，以便你可以更容易地找到廉价的机票，或者找到去冬堡或某个餐馆的路线图。

### [时间复杂度](Algorithms/Time%20Complexity/readme.md)
算法的时间复杂度估计了算法对于某个输入将使用多少时间。这个概念是将效率表示为一个函数，其参数是输入的大小。通过计算时间复杂度，我们可以在不实现算法的情况下确定算法是否足够快。

### [空间复杂度](Algorithms/Space%20Complexity/readme.md)
空间复杂度指的是算法/程序使用的总内存空间，包括执行输入值所占用的空间。确定空间复杂度，需要计算算法/程序中变量所占用的空间。

### [排序](Algorithms/Sorting/readme.md)
排序是将一系列项目按照特定顺序排列的过程。例如，如果你有一份名字的列表，你可能希望按字母顺序进行排序。或者，如果你有一份数字的列表，你可能希望按从小到大的顺序进行排序。排序是一个常见的任务，我们有许多不同的方式来完成它。

### [搜索](Algorithms/Searching/readme.md)
搜索是在一个数据集合内查找某个目标元素的算法。搜索算法被设计用来检查一个元素或从它所存储的任何数据结构中检索一个元素。

## [基于字符串的算法](Algorithms/String%20Based%20Algorithms/readme.md)
字符串是编程中最常用和最重要的数据结构之一，本仓库包含了一些最常用的算法，这些算法可以帮助我们提高搜索速度，提升我们的代码。

### [图搜索](Algorithms/Graph/readme.md)
图搜索是通过图来寻找特定节点的过程。图是一种数据结构，由有限的（可能可变的）顶点或节点或点，以及这些顶点的无序对（对于无向图）或有序对（对于有向图）组成。这些对被称为边、弧或线（对于无向图），或箭头、有向边、有向弧或有向线（对于有向图）。顶点可能是图结构的一部分，也可能是由整数索引或引用表示的外部实体。图是许多现实世界应用的最有用的数据结构之一。图用于模拟对象之间的成对关系。例如，航线网络是一个图，城市是顶点，航班路线是边。图也被用来表示网络。互联网可以被视为一个图，计算机是顶点，计算机之间的链接是边。图也被用在LinkedIn和Facebook等社交网络上。图被用来表示许多现实世界的应用：计算机网络、电路设计和航空调度等。

### [动态规划](Algorithms/Dynamic%20Programming/README.md)
动态规划既是一种数学优化方法，也是一种计算机编程方法。理查德·贝尔曼在20世纪50年代开发了这种方法，已在航空航天工程、经济学等众多领域中找到应用。在两个语境中，它都是指通过递归的方式将一个复杂问题简化为更简单的子问题。尽管有些决策问题无法用这种方式拆解，但跨越多个时间点的决策往往可以递归地拆解。同样，在计算机科学中，如果一个问题可以通过将其拆解为子问题，然后递归地找到子问题的最优解来解决，那么它就被认为具有最优子结构。动态规划是一种解决这些性质问题的方式。将一个复杂问题拆解为更简单的子问题的过程被称为"分治"。

### [贪心算法](Algorithms/Greedy%20Algorithm/readme.md)
贪心算法是一种简单、直观的算法类，可以用来找到一些优化问题的最优解。它们被称为贪心算法，因为在每一步，它们都做出了当时看起来最好的选择。这意味着贪心算法不能保证返回全局最优解，而是在希望找到全局最优解的过程中做出局部最优的选择。贪心算法被用于优化问题。一个优化问题可以使用贪心算法来解决，如果这个问题具有以下性质：在每一步，我们都可以做出当前看起来最好的选择，然后我们就能得到完整问题的最优解。

### [回溯](Algorithms/Backtracking/README.md)
回溯是一种算法技术，通过尝试逐步建立解决方案，一次一个部分，移除那些在任何时间点（这里的时间指的是到达搜索树的任何级别所经过的时间）无法满足问题约

### [不同搜索和排序算法的时间复杂度和空间复杂度](Not-Added)
**时间复杂度**：它被定义为预期执行特定指令集的次数，而不是总共花费的时间。由于时间是一个依赖现象，时间复杂度可能会因一些外部因素（如处理器速度，使用的编译器等）而变化。

**空间复杂度**：它是程序执行所消耗的总内存空间。

两者都被计算为输入大小(n)的函数。算法的时间复杂度以大O表示法表示。

算法的效率依赖于这两个参数。

时间复杂度的类型：

- *最佳时间复杂度*：算法花费的时间最少或最少的输入。在最佳情况下，我们计算算法的下界时间复杂度。例如：如果要搜索的数据位于线性搜索中的大型数据数组的第一个位置，那么最佳情况就发生了。
- *平均时间复杂度*：我们取所有随机输入并计算所有输入的计算时间。然后，我们将其除以输入的总数。
- *最坏时间复杂度*：定义算法花费的时间最长或最大的输入。在最坏的情况下，我们计算算法的上界。例如：如果要搜索的数据位于线性搜索算法中的大型数据数组的最后位置，那么最坏情况就会发生。

一些常见的时间复杂度是：

- **O(1)**：这表示常数时间。 O(1)通常意味着算法将具有常数时间，无论输入大小如何。哈希图是常数时间的完美例子。

- **O(log n)**：表示对数时间。 O(log n)表示对于每个操作实例，性能都会降低。在二叉搜索树(BSTs)中搜索元素是对数时间的一个很好的例子。

- **O(n)**：表示线性时间。 O(n)意味着性能与输入大小直接成正比。简单地说，输入的数量和执行这些输入所需的时间将成正比。数组中的线性搜索是线性时间复杂度的一个很好的例子。

- **O(n*n)**：表示二次方时间。 O(n^2)意味着性能直接与输入的平方成正比。简单来说，执行所需的时间大致是输入大小的平方倍。嵌套循环是二次方时间复杂度的绝佳例子。

- **O(n log n)**：表示多项式时间复杂度。 O(n log n)意味着性能是O(log n)的n倍，（这是最坏情况下的复杂度）。一个好的例子是分而治之的算法，比如归并排序。这种算法首先分割集合，这需要O(log n)的时间，然后征服并通过集合进行排序，这需要O(n)的时间-因此，归并排序需要O(n log n)的时间。

| 算法	        |             |  时间复杂度    |	       | 空间复杂度  |
|   :---:        |  :---:      |  :---: 	       |   :---: 	   |   :---:      |
|  	             | 最佳	       | 平均	       |  最坏	     |  最坏        |
| 选择排序       | Ω(n^2)	     | θ(n^2)	       | O(n^2)	     | O(1)         |
| 冒泡排序	     | Ω(n)	       | θ(n^2)	       | O(n^2)	     | O(1)         |
| 插入排序       | Ω(n)	       | θ(n^2)	       | O(n^2)	     | O(1)         |
| 堆排序	     | Ω(n log(n)) | θ(n log(n))   | O(n log(n)) | O(1)         |
| 快速排序	     | Ω(n log(n)) | θ(n log(n))   | O(n^2)	     | O(n)         |
| 归并排序	     | Ω(n log(n)) | θ(n log(n))   | O(n log(n)) | O(n)         |
| 桶排序         | Ω(n +k)	   | θ(n +k)	   | O(n^2)	     | O(n)         |
| 基数排序  	 | Ω(nk)	     | θ(nk)	       | O(nk)	     | O(n + k)     |
| 计数排序  	 | Ω(n +k)	   | θ(n +k)	   | O(n +k)	   | O(k)         |
| 希尔排序  	 | Ω(n log(n)) | θ(n log(n))   | O(n^2)	     | O(1)         |
| Tim 排序	     | Ω(n)	       | θ(n log(n))   | O(n log(n)) | O(n)         |
| 树排序       	 | Ω(n log(n)) | θ(n log(n))   | O(n^2)	     | O(n)         |
| 立方排序	     | Ω(n)	       | θ(n log(n))   | O(n log(n)) | O(n)         |


| 算法	     |             |  时间复杂度    |
|   :---:    |  :---:      |  :---: 	  |   
|  	         | 最佳	       | 平均	         |  最坏	     |
| 线性搜索   | O(1)	       | O(N)	         | O(N)	     |
| 二分搜索	 | O(1)	       | O(logN)       | O(logN)	   |


## [艾伦图灵](Not-Added)
艾伦·图灵（1912年6月23日伦敦出生，1954年6月7日在威尔姆斯洛，柴郡逝世）是一位英国数学家和逻辑学家。他在剑桥大学和普林斯顿高级研究所学习。在他具有里程碑意义的1936年的论文《关于可计算数》中，他证明了不能存在任何通用的算法方法来确定数学中的真理，并且数学将总是包含不可决定的（相对于未知的）命题。那篇论文也引入了图灵机。他相信计算机最终将能够进行与人类无法区分的思考，并提出了一个简单的测试（见图灵测试）来评估这种能力。他关于这个主题的论文被广泛承认为人工智能研究的基础。他在二战期间在密码学方面做出了宝贵的工作，对破解德国用于无线电通信的谜机密码起到了重要作用。战后，他在曼彻斯特大学任教，并开始研究现在称为人工智能的东西。在这个开创性的工作中，图灵被发现在床上死亡，死因是氰化物中毒。他的死亡是在被捕进行同性恋行为（当时是犯罪）并被判处12个月的荷尔蒙疗法之后。

2009年的一场公众运动之后，英国首相戈登·布朗代表英国政府正式公开道歉，为他们对图灵的惨酷待遇表示歉意。英女王伊丽莎白二世在2013年赦免了他的罪。"艾伦·图灵法"现在被非正式地用来指2017年在英国的一项法律，该法律追溯地赦免了在历史上将同性恋行为定为非法的男性。

图灵的影响深远，有许多雕像和许多以他的名字命名的事物，包括一个针对计算机科学创新的年度奖项。他出现在现行的英格兰银行50英镑纸币上，该纸币于2021年6月23日（与他的生日相吻合）发布。在2019年BBC系列节目中，经过观众投票，他被誉为20世纪最伟大的人。

## [软件工程](Software%20Engineering/readme.md)
软件工程是计算机科学的一个分支，它处理软件应用的设计、开发、测试和维护。软件工程师应用工程原理和编程语言知识来构建面向最终用户的软件解决方案。

让我们来看看软件工程的各种定义：

- IEEE在其610.12-1990标准中，将软件工程定义为一个系统化、有纪律、可计算的方法，用于软件的开发、操作和维护。
- Fritz Bauer将其定义为'建立和使用标准工程原则。它帮助你获得经济、可靠并在实际机器上高效工作的软件。
- Boehm将软件工程定义为涉及'将科学知识实际应用到计算机程序的创造性设计和构建。它还包括开发、操作和维护它们所需的相关文档。'

### 软件工程师的任务和职责
成功的工程师知道如何使用正确的编程语言、平台和架构来开发从电脑游戏到网络控制系统的所有东西。除了建立他们自己的系统，软件工程师还测试、改进和维护其他工程师构建的软件。

在这个角色中，你的日常任务可能包括以下内容：

- 设计和维护软件系统
- 评估和测试新的软件程序
- 优化软件以提高速度和可扩展性
- 编写和测试代码
- 与客户、工程师、安全专家以及其他相关人员进行咨询
- 向利益相关者和内部客户展示新功能

### 软件工程的阶段
软件工程过程涉及到几个阶段，包括需求收集、设计、实现、测试和维护。通过遵循规范的软件开发方法，软件工程师可以创建出高质量的软件，满足用户的需求。

- 软件工程的第一阶段是需求收集。在这个阶段，软件工程师与客户合作确定软件的功能需求和非功能需求。功能需求描述了软件应该做什么，而非功能需求描述了它应该如何做。需求收集是一个关键的阶段，因为它为整个软件开发过程奠定了基础。

- 在需求收集之后，下一个阶段是设计。在这个阶段，软件工程师为软件的架构和功能创建一个详细的计划。这个计划包括一个软件设计文档，指定了软件的结构、行为和与其他系统的交互。软件设计文档是非常重要的，因为它作为实现阶段的蓝图。

- 实现阶段是软件工程师为软件创建实际代码的地方。这是将设计文档转化为工作软件的地方。实现阶段涉及到编写代码、编译代码，并测试它以确保它满足设计文档中指定的需求。

- 在软件工程中，测试是一个关键的阶段。在这个阶段，软件工程师检查以确保软件运行正确、可靠并且易于使用。这涉及到几种类型的测试，包括单元测试、集成测试和系统测试。测试确保软件满足需求并按预期运行。

- 软件工程的最后阶段是维护。在这个阶段，软件工程师对软件进行更改，以纠正错误、添加新功能或改善其性能。维护是一个持续的过程，贯穿于软件的整个生命周期。

### 为什么软件工程如此流行？

- 计算机科学：为软件提供科学基础，就像电气工程主要依赖物理学一样。
- 管理科学：软件工程是劳动密集型的，需要技术和管理控制。因此，它在管理科学中被广泛使用。
- 经济学：在这个领域，软件工程帮助你估计资源和控制成本。必须开发计算系统，并且数据应在给定的预算内定期维护。
- 系统工程：大多数软件都是一个更大系统的组成部分。例如，工业监控系统中的软件或飞机上的飞行软件。应该将软件工程方法应用于这种类型的系统的研究。

## [集成电路](Integrated%20Circuits/readme.md)
集成电路或者硅片集成电路（也被称为IC，芯片，或者微芯片）是一套电子电路集成在一小块扁平的半导体材料（或"芯片"）上，通常是硅。许多微小的MOSFETs（金属-氧化物-半导体场效应晶体管）集成在一个小芯片上。这导致电路比由离散电子元件构成的电路小了几个数量级，更快，也更便宜。IC的大规模生产能力，可靠性，和集成电路设计的积木式方法，确保了标准化ICs代替离散晶体管的快速采用。ICs现在被用于几乎所有的电子设备，并且已经革新了电子世界。电脑，手机，和其他家用电器现在已经成为现代社会结构不可或缺的部分，这得益于ICs的小尺寸和低成本，比如现代计算机处理器和微控制器。

超大规模集成电路被金属-氧化物-硅（MOS）半导体器件制造的技术进步变得实际可行。自从它们在1960年代起源以来，芯片的大小，速度，和容量已经取得了巨大的进步，受到技术进步的驱动，可以在相同大小的芯片上装更多的MOS晶体管 – 现代的芯片可能在人指甲大小的区域里有多达几十亿的MOS晶体管。这些进步遵循着摩尔定律，使得今天的计算机芯片相比于1970年代初期的芯片具有几百万倍的容量和几千倍的速度。

ICs相比离散电路有两个主要的优势：成本和性能。成本低是因为芯片，和它们所有的组件，作为一个单位通过光刻技术打印，而不是一个一个晶体管地构造。此外，封装的ICs比离散电路使用的材料少得多。性能很高，因为IC的组件切换速度快、体积和间距都相对较小，因此消耗的电力相对较少。ICs的主要缺点是设计它们和制作所需的光罩的高成本。这种高初始成本意味着只有当预期有高产量时，ICs才在商业上具有可行性。

### 类型
现代电子元件分销商通常会进一步对集成电路进行子分类：

- 数字IC被分类为逻辑IC（如微处理器和微控制器）、存储芯片（如MOS存储器和浮动栅存储器）、接口IC（电平转换器，串行器/解串行器等）、电源管理IC和可编程设备。
- 模拟IC被分类为线性集成电路和射频电路（无线电频率电路）。
- 混合信号集成电路被分类为数据采集IC（A/D转换器，D/A转换器和数字电位计），时钟/计时IC，开关电容（SC）电路和RF CMOS电路。
- 三维集成电路（3D ICs）被分类为硅通孔IC（TSV）和铜-铜连接IC。

## [面向对象编程](Object%20Oriented%20Programming/readme.md)
面向对象编程是一种基于对象和数据概念的基本编程范式。

它是每个程序员都必须遵守的编码标准方式，以便更好地阅读和重用代码。

### * 面向对象编程有四个基本概念:
- 抽象
- 封装
- 继承
- 多态

了解更多关于OOP的概念[在这里](Object%20Oriented%20Programming/readme.md)

## [函数式编程](Functional%20Programming/readme.md)

在计算机科学中，函数式编程是一种编程范式，程序是通过应用和组合函数构建的。它是一种声明式的编程范式，其中函数定义是表达式的树，将值映射到其他值，而不是一系列改变程序运行状态的命令式语句。

在函数式编程中，函数被视为一等公民，这意味着它们可以被绑定到名称（包括局部标识符），作为参数传递，从其他函数返回，就像任何其他数据类型一样。这允许程序以声明式和组合式的风格编写，其中小函数以模块化的方式组合在一起。

函数式编程有时被视为纯函数式编程的同义词，纯函数式编程是函数式编程的一个子集，它将所有函数视为确定性的数学函数，或纯函数。当用一些给定的参数调用纯函数时，它总是返回相同的结果，并且不能受到任何可变状态或其他副作用的影响。这与非纯过程形成鲜明对比，非纯过程在命令式编程中很常见，它可以有副作用（例如修改程序的状态或从用户获取输入）。纯函数式编程的支持者声称，通过限制副作用，程序可以有更少的错误，更容易调试和测试，并且更适合于正式的验证程序。

函数式编程起源于学术界，从λ演算演变而来，λ演算是一种只基于函数的计算的形式系统。从历史角度来看，函数式编程没有命令式编程流行，但是现在函数式编程开始应用于在工业和教育中。

函数式编程语言的一些例子包括：
- <a href="https://lisp-lang.org/"> Common Lisp </a>
- <a href="https://www.scheme.org/"> Scheme </a>
- <a href="https://racket-lang.org/"> Racket </a>
- <a href="https://www.erlang.org/"> Erlang </a>
- <a href="https://www.haskell.org/"> Haskell </a>
- <a href="https://fsharp.org/"> F# </a>
- <a href="https://cs.lmu.edu/~ray/notes/introml/"> ML </a> 

函数式编程历史上源自*λ演算*。λ演算是由阿隆佐·丘奇开发的一个框架，用于研究函数的计算。它常被称为"世界上最小的编程语言"。它提供了可计算和不可计算的定义。它在计算能力上等价于图灵机，λ演算可以计算的任何东西，就像图灵机可以计算的任何东西一样，是可计算的。它为描述函数及其求值提供了一个理论框架。

函数式编程的一些基本概念包括：
- 纯函数 
- 递归
- 引用透明性
- 函数作为一等公民和高阶函数
- 变量是不可变的。

**纯函数**：这些函数有两个主要属性。首先，它们总是为相同的参数产生相同的输出，而不考虑任何其他因素。其次，它们没有副作用。即它们不修改任何参数或局部/全局变量或输入/输出流。后者的属性被称为*不可变性*。纯函数唯一的结果就是它返回的值。它们是决定性的。使用函数式编程完成的程序易于调试，因为它们没有副作用或隐藏的I/O。纯函数也使编写并行/并发应用程序变得更容易。当代码以这种风格编写时，智能编译器可以做很多事情-它可以并行化指令，等待评估结果直到需要，以及记住结果，因为只要输入不变，结果就永远不会变。下面是Python中的一个简单的纯函数示例：

```python
def sum(x ,y): # sum是一个以x和y为参数的函数
    return x + y  # 返回x + y而不改变值
 ```

**递归**：在纯函数式编程语言中没有"for"或"while"循环。迭代是通过递归实现的。递归函数反复调用自己，直到达到基本情况。下面是一个简单的C语言递归函数示例：

```c
int fib(n) {
  if(n <= 1)
    return 1;
   else
     return (fib(n-1) + fib(n-2));
}
 ```

 **引用透明**：在函数式程序中，一旦定义的变量在整个程序中不会改变其值。函数式程序没有赋值语句。如果我们需要存储某个值，我们会定义一个新的变量，而不是改变已有的变量。这消除了任何副作用的可能性，因为任何变量都可以在执行的任何时刻被其实际值替换。任何变量在任何时刻的状态都是恒定的。例如：

```bash
x = x + 1 # 这改变了变量x赋值的值
         # 因此，这个表达式不是引用透明的
```

**函数是一等公民并且可以是高阶的**：一等函数被视为一等变量。一等变量可以作为参数传递给函数，可以从函数返回或存储在数据结构中。

可以使用一个叫做**funcall**的LISP形式来定义函数应用的组合，它将一个函数和一系列的参数作为参数，并将该函数应用于这些参数：

```Lisp
(defun filter (list-of-elements test)
    (cond ((null list-of-elements) nil)
          ((funcall test (car list-of-elements))
            (cons (car list-of-elements)
                (filter (cdr list-of-elements)
                      test)))
           (t (filter (cdr list-of-elements)
                       test))))
   ```
**filter**函数将测试应用于列表的第一个元素。如果测试返回非空，它将元素连到filter应用于列表cdr的结果上；否则，它只返回过滤后的cdr。这个函数可以与作为参数传入的不同谓词一起使用，执行各种过滤任务，下面是两个示例：

```Lisp
    > (filter '(1 3 -9 5 -2 -7 6) #'plusp)   ; 过滤掉所有的负数 
```    
    输出：(1 3 5 6)

```Lisp
   > (filter '(1 2 3 4 5 6 7 8 9) #'evenp)   ; 过滤掉所有的奇数
```   
   输出：(2 4 6 8)

**变量是不可变的**：在函数式编程中，我们不能修改一个已初始化的变量。我们可以创建新的变量-但我们不能修改现有的变量，这对于在程序运行过程中维护状态非常有帮助。一旦我们创建一个变量并设置其值，我们可以充分确信该变量的值永远不会改变。

## [操作系统](Operating%20Systems/readme.md)
操作系统（或简称为OS）充当计算机用户和计算机硬件之间的中介。操作系统的目的是提供一个环境，用户可以在其中方便、高效地执行程序。
操作系统是管理计算机硬件的软件。硬件必须提供适当的机制来确保计算机系统的正确操作，并防止用户程序干扰系统的正常运行。
更常见的定义是，操作系统是计算机上始终运行的一个程序（通常称为内核），所有其他的都是应用程序。

操作系统可以从两个观点来看：资源管理器和扩展机。在资源管理器视图中，操作系统的任务是有效地管理系统的不同部分。在扩展机视图中，系统的工作是为用户提供比实际机器更方便使用的抽象。这些抽象包括进程、地址空间和文件。操作系统有着悠久的历史，从它们取代操作员到现代的多程序系统。重要的里程碑包括早期的批处理系统、多程序系统和个人计算机系统。由于操作系统与硬件紧密交互，一些计算机硬件的知识对于理解操作系统是有用的。计算机是由处理器、内存和I/O设备组成的。这些部分通过总线连接。所有操作系统都是基于进程、内存管理、I/O管理、文件系统和安全性的基本概念构建的。任何操作系统的核心是它可以处理的系统调用集。这些告诉我们操作系统做什么。

操作系统有着悠久的历史，从它们取代操作员到现代的多程序系统。重要的里程碑包括早期的批处理系统、多程序系统和个人计算机系统。由于操作系统与硬件紧密交互，一些计算机硬件的知识对于理解操作系统是有用的。计算机是由处理器、内存和I/O设备组成的。这些部分通过总线连接。所有操作系统都是基于进程、内存管理、I/O管理、文件系统和安全性的基本概念构建的。任何操作系统的核心是它可以处理的系统调用集。这些告诉我们操作系统做什么。

### 操作系统作为资源管理器
操作系统管理着复杂系统的所有部分。现代计算机由处理器、内存、计时器、硬盘、鼠标、网络接口、打印机以及各种其他设备组成。
从底层视角来看，操作系统的任务是为处理器、内存和I/O设备在各种程序间的有序和控制分配提供支持。
现代操作系统允许多个程序在内存中同时运行。想象一下，如果某台计算机上运行的三个程序都试图同时在同一台打印机上打印他们的输出，结果将是一片混乱。操作系统可以通过在硬盘上缓冲所有目标为打印机的输出来引导潜在的混乱。
当一个程序完成时，操作系统可以从它被存储的硬盘文件中复制其输出到打印机，同时，其他程序可以继续生成更多的输出，而不知道输出还没有到打印机（尚未）。
当一台计算机（或网络）有多个用户时，需要更多地管理和保护内存、I/O设备和其他资源，否则用户可能会相互干扰。此外，用户经常需要共享硬件以及信息（文件、数据库等）。简而言之，这种对操作系统的视角认为，它的主要任务是跟踪哪些程序正在使用哪些资源，批准资源请求，记录使用情况，并调解来自不同程序和用户的冲突请求。

### 操作系统作为扩展机器
在机器语言级别，大多数计算机的架构是原始且难以编程的，特别是对于输入/输出。为了更具体地说明这一点，考虑一下在大多数计算机上使用的现代SATA（Serial ATA）硬盘。程序员需要了解什么才能使用这个硬盘。
从那时起，接口已经多次修订，比2007年时更为复杂。只有疯子程序员才会想在硬件级别处理这个硬盘。
相反，一个名为硬盘驱动器的软件处理硬件，并提供一个接口来读写硬盘块，而无需深入了解具体细节。
操作系统包含许多用于控制I/O设备的驱动程序。
但是，即使这个级别对于大多数应用程序来说也太低了。因此，所有操作系统都提供了另一层用于使用硬盘的抽象：文件。
使用这种抽象，程序可以创建、写入和读取文件，而无需处理硬件工作的混乱细节。
这种抽象是管理所有这些复杂性的关键。好的抽象将一个几乎不可能的任务变成两个可管理的任务。第一个是定义和实现抽象。第二个是使用这些抽象来解决手头的问题。

### 操作系统的历史
- **第一代（1945-55）**：在巴贝奇的灾难性努力之后，构建数字计算机的进展甚微，直到二战时期。在爱荷华州立大学，约翰·阿塔纳索夫教授和他的研究生克利福德·贝瑞创建了今天被认为是第一个运行的数字计算机。在同一时间，康拉德·祖斯在柏林使用电机继电器构建了Z3计算机。霍华德·艾肯在哈佛创建了Mark I，英格兰布莱切利公园的一个科学家团队创建了Colossus，威廉·莫奇和他的博士生J.普雷斯珀·埃克特在宾夕法尼亚大学于1944年创建了ENIAC。

- **第二代（1955-65）**：在1950年代中期发明晶体管极大地改变了情况。计算机的可靠性足以将其作为商品制造并销售给付费客户，他们会假设这些计算机将继续工作足够长的时间来进行一些有意义的工作。这些机器现在被称为大型机，它们被锁在巨大的、特别是空调调节的计算机房间里，有专业的操作团队来管理它们。只有大型企业、重要的政府实体或机构才能承担得起几百万美元的价格标签。

- **第三代（1965-80）**：与使用单个晶体管构建的第二代计算机相比，IBM 360是第一款使用（小规模）集成电路（ICs）的主要计算机系列。因此，它提供了显著的价格/性能优势。它立即走红，其他所有大型制造商很快就接受了一系列互操作计算机的概念。所有的软件，包括OS/360操作系统，原始设计中都应该与所有模型兼容。它必须在大型系统上运行，这些系统经常用于重型计算和天气预报，取代了7094，以及微小的系统，这些系统通常仅用于将卡传输到磁带，替代了1401。它必须能够很好地处理少量外设和大量外设的系统。它必须在专业和学术环境中都能运行。最重要的是，它必须对这些多种应用都有效。

- **第四代（1980-至今）**：随着LSI（大规模集成）电路的创建，个人计算机时代开始了，这些处理器在硅的平方厘米上拥有数千个晶体管。尽管个人计算机，最初被称为微型计算机，在架构上与PDP-11类的小型计算机没有显著变化，但他们在价格上确实有很大的不同。

- **第五代（1990-至今）**：自1940年代的侦探Dick Tracy在连环画中开始使用他的"双向无线电手表"进行通话以来，人们一直渴望拥有一个便携式通讯设备。1946年，真正的移动电话首次亮相，重量约为40公斤。1970年代，第一个真正的便携式电话登场，重量仅约一公斤，非常轻便。它被戏称为“砖头”，并在很短的时间内风靡全球。

### 操作系统的功能
- **便利性**：操作系统使得计算机的使用更为便利。
- **高效性**：操作系统可以使计算机系统的资源得到高效利用。
- **演进能力**：操作系统应该被设计成可以在不影响服务的同时，有效地开发、测试和引入新的系统功能。
- **吞吐率**：操作系统应被设计为可以提供最大的吞吐率（即单位时间内完成的任务数量）。

### 操作系统的主要功能
- **资源管理**：当操作系统中发生并行访问时，也就是多个用户同时访问系统时，操作系统作为资源管理器，其职责是为用户提供硬件。这降低了系统的负载。
- **进程管理**：它包括诸如进程调度和终止等各种任务。操作系统可以同时管理各种任务。这里发生的CPU调度指的是由许多用于调度的算法完成的所有任务。
- **存储管理**：文件系统机制用于存储管理。NIFS、CFS、CIFS、NFS等是一些文件系统。所有数据都存储在硬盘的各个轨道上，所有这些都由存储管理器管理。它包括硬盘。
- **内存管理**：指的是对主内存的管理。操作系统必须跟踪已使用了多少内存以及由谁使用。它必须决定哪个进程需要内存空间以及需要多少。操作系统还必须分配和释放内存空间。
- **安全/隐私管理**：操作系统也通过使用密码提供隐私，以防止未经授权的应用程序访问程序或数据。例如，Windows使用**_Kerberos_**身份验证来防止对数据的未经授权的访问。

### 操作系统的类型
- **大型机操作系统**：
在高端是为主机（那些仍然存在于主要公司数据中心的房间大小的计算机）设计的操作系统。这些计算机与个人计算机在I/O容量上有所不同。拥有1000个硬盘和数百万吉字节数据的主机并不少见；具有这些规格的个人计算机会令其同伴羡慕。主机也作为高端Web服务器、大型电子商务网站的服务器以及业务到业务交易的服务器正在进行一些复兴。
大型机的操作系统主要侧重于同时处理许多作业，其中大部分需要大量的I/O。它们通常提供三种服务：批处理、事务处理和分时处理。

- **服务器操作系统**：
下一级是服务器操作系统。它们运行在服务器上，这些服务器可以是非常大的个人计算机、工作站，甚至是大型机。它们可以通过网络同时为多个用户服务，并允许用户共享硬件和软件资源。服务器可以提供打印服务、文件服务或Web服务。
互联网服务提供商运行许多服务器机器来支持其客户，网站使用服务器存储网页并处理传入请求。
典型的服务器操作系统有Solaris、FreeBSD、Linux和Windows Server 201x。

- **多处理器操作系统**：
获取大型计算能力的一种越来越常见的方式是将多个CPU连接到一个系统中。
根据它们的连接方式和共享内容的具体情况，这些系统被称为并行计算机、多计算机或多处理器。
它们需要特殊的操作系统，但这些操作系统通常是对服务器操作系统的变体，具有特殊的通信、连接和一致性功能。

- **个人计算机操作系统**：
下一个类别是个人计算机操作系统。现代的个人计算机操作系统都支持多程序设计，通常在启动时启动数十个程序。
它们的任务是为单个用户提供良好的支持。它们被广泛用于文字处理、电子表格、游戏和互联网访问。常见的例子包括Linux、FreeBSD、Windows 7、Windows 8和Apple的OS X。个人计算机操作系统广为人知，可能几乎不需要介绍。
许多人甚至不知道还存在其他类型的操作系统。

- **嵌入式操作系统**：
嵌入式系统运行在控制不通常被认为是计算机的设备的计算机上，并且不接受用户安装的软件。
典型的例子包括微波炉、电视机、汽车、DVD录制机、传统电话和MP3播放器。区分嵌入式系统和手持设备的主要特性是嵌入式系统上永远不会运行不受信任的软件。
你不能向你的微波炉下载新的应用程序——所有的软件都在ROM中。这意味着不需要在应用程序之间进行保护，简化了设计。像嵌入式Linux、QNX和VxWorks这样的系统在这个领域很受欢迎。

- **智能卡操作系统**：
最小的操作系统运行在信用卡大小的智能卡设备的CPU芯片上。它们在处理能力和内存约束方面具有非常严重的限制。
一些设备通过插入读卡器中的接触点供电，但是无接触智能卡是感应供电的，极大地限制了它们可以做什么。有些只能处理单一功能，如电子支付，但其他一些可以处理多种功能。
这些通常是专有系统。
一些智能卡是Java导向的。这意味着智能卡上的ROM保存了Java虚拟机（JVM）的解释器。Java小程序（小程序）被下载到卡上，并由JVM解释器解释。
其中一些卡可以同时处理多个Java小程序，从而导致多程序设计和需要对它们进行调度。当同时存在两个或更多小程序时，资源管理和保护也成为一个问题。
这些问题必须由卡上存在的（通常极其原始的）操作系统来处理。

## [内存和存储](Memory%20and%20Storage/readme.md)

### 内存
内存是指计算机中允许短期数据访问的组件。你可以将此组件认为是DRAM或动态随机访问存储器。您的计算机通过访问存储在其短期存储器中的数据来执行许多操作。这样的操作包括编辑文档、加载应用程序和浏览互联网。您的系统的速度和性能取决于安装在计算机上的内存大小。

如果你有一个桌子和一个文件柜，那么桌子代表你的计算机的内存。您需要立即使用的物品被放在桌子上，以便轻松访问。然而，由于桌子的大小限制，不能在桌子上放太多东西。

### 存储
相对于内存来说，存储是计算机中允许您长期存储和访问数据的组件。通常，存储以固态硬盘或硬盘驱动器的形式出现。存储永久地保存您的应用程序、操作系统和文件。计算机需要从存储系统中读取和写入信息，因此存储速度决定了您的系统启动、加载和访问已保存内容的速度。

虽然桌子代表计算机的内存，但文件柜代表你的计算机的存储。它保存需要保存和存储的物品，但不一定需要立即访问。文件柜的大小意味着它可以保存许多东西。

**内存和存储之间的一个重要区别**是，当计算机关闭时，内存会清空。另一方面，无论你关闭电脑多少次，存储都会保持不变。因此，在桌子和文件柜的比喻中，当你离开办公室时，桌子上留下的任何文件都会被扔掉。文件柜里的所有东西都会留下。

### 虚拟内存
在计算机系统的核心是内存，这是运行程序和存储数据的空间。但是，当你运行的程序和你正在处理的数据超过计算机物理内存的容量时该怎么办呢？这就是虚拟内存的作用，它作为计算机内存的智能扩展，增强了其功能。

**虚拟内存的定义和目的：**

虚拟内存是操作系统采用的一种内存管理技术，用来克服物理内存（RAM）的限制。它为软件应用程序创建了一种假象，让它们认为可以访问的内存量大于计算机上实际安装的内存量。本质上，它使程序能够使用超出计算机物理RAM限制的内存空间。

虚拟内存的主要目的是实现有效的多任务处理和执行更大的程序，同时保持系统的响应性。它通过在物理RAM和二级存储设备（如硬盘驱动器或SSD）之间创建无缝的交互来实现这一点。

**虚拟内存如何扩展可用的物理内存：**

虚拟内存可以看作是连接计算机的RAM和二级存储（硬盘驱动器）的桥梁。当你运行一个程序时，它的部分内容会被加载到更快的物理内存（RAM）中。然而，并非程序的所有部分都会立即使用。

虚拟内存利用这种情况，将程序中没有被经常访问的部分从RAM移动到二级存储，为RAM中经常访问的部分创造出更多的空间。这个过程对用户和正在运行的程序是透明的。当再次需要移动的部分时，它们会被换回到RAM，而其他不太活跃的部分可能会被移动到二级存储。

这种动态地将数据交换进出物理内存的过程由操作系统管理。它允许程序运行，即使它们大于可用的RAM，因为操作系统聪明地决定了什么数据需要在RAM中以获得最佳性能。

总的来说，虚拟内存充当一个虚拟化层，通过临时在RAM和二级存储之间传输程序和数据的部分，扩展了可用的物理内存。这个过程确保了计算机可以同时处理更大的任务和众多的程序，同时保持高效的性能和响应能力。

## [文件系统](File%20System/readme.md)
在计算中，文件系统（通常缩写为fs）是操作系统用来控制数据如何存储和检索的方法和数据结构。没有文件系统，存储在存储介质中的数据将是一个大的数据体，无法知道一个数据结束和下一个数据开始的地方，或者在检索数据时无法知道任何数据的位置。通过将数据分成各个部分并给每个部分一个名字，数据可以很容易地被隔离和识别。从纸质数据管理系统的命名方式中取名，每一组数据都被称为一个“文件”。用来管理数据组及其名称的结构和逻辑规则被称为“文件系统”。

有许多种类型的文件系统，每种都有独特的结构和逻辑，有速度、灵活性、安全性、大小等属性。有些文件系统被设计用于特定的应用。例如，ISO 9660文件系统专门为光盘设计。

文件系统可以在使用各种媒体的许多类型的存储设备上使用。截至2019年，硬盘驱动器一直是关键的存储设备，预计在可预见的将来仍将如此。其他使用的媒体包括SSD、磁带和光盘。在某些情况下，如tmpfs，计算机的主内存（随机存取存储器，RAM）会创建一个临时文件系统供短期使用。

有些文件系统用于本地数据存储设备；其他提供通过网络协议（例如，NFS、SMB或9P客户端）进行文件访问。有些文件系统是“虚拟”的，这意味着提供的“文件”（称为虚拟文件）是根据请求计算的（如procfs和sysfs）或仅仅是映射到用作后备存储的不同文件系统。文件系统管理对文件内容和关于这些文件的元数据的访问。它负责安排存储空间；关于物理存储介质的可靠性、效率和调整是重要的设计考虑因素。

### 文件系统如何工作
文件系统存储和组织数据，可以被认为是存储设备中所有数据的一种索引。这些设备可以包括硬盘驱动器、光驱和闪存驱动器。

文件系统规定了命名文件的约定，包括名称中的最大字符数、可以使用的字符，以及在某些系统中，文件名后缀的长度。在许多文件系统中，文件名不区分大小写。

除了文件本身，文件系统还包含元数据中的信息，如文件的大小、属性、位置和在目录中的层次结构。元数据还可以标识驱动器上可用存储的空闲块以及可用的空间有多少。

文件系统还包括一种格式，用于通过目录结构指定到文件的路径。文件放在目录中——或者在Windows操作系统中的文件夹中——或者在树结构中所需位置的子目录中。PC和移动操作系统有文件系统，其中文件被放在分层的树结构中。

在存储介质上创建文件和目录之前，应当放置分区。分区是硬盘或其他存储的一个区域，操作系统单独管理。一个文件系统包含在主分区中，一些操作系统允许在一个磁盘上有多个分区。在这种情况下，即使其中一个分区被破坏，其他分区的数据将是安全的。

### 文件系统的类型
有几种类型的文件系统，它们都有不同的逻辑结构和属性，如速度和大小。文件系统的类型可以由操作系统和该操作系统的需求来决定。微软Windows，Mac OS X和Linux是最常见的PC操作系统。移动操作系统包括Apple iOS和Google Android。

主要的文件系统包括以下几种：

- 文件分配表（FAT）由微软Windows操作系统支持。FAT被认为简单可靠，是模仿传统文件系统的。FAT是在1977年为软盘设计的，但后来被改造用于硬盘。尽管FAT的效率高，且与大多数当前的操作系统兼容，但它无法匹配更现代的文件系统的性能和可扩展性。

- 全局文件系统（GFS）是Linux操作系统的文件系统，它是一个共享磁盘文件系统。GFS提供对共享块存储的直接访问，可以作为本地文件系统使用。

- GFS2是一个更新版本，包含了原始GFS中没有的功能，如更新的元数据系统。在GNU通用公共许可证的条款下，GFS和GFS2文件系统都可以作为免费软件获得。

- 分层文件系统（HFS）是为Mac操作系统开发的。HFS也可以被称为Mac OS Standard，由Mac OS Extended接替。HFS最初在1985年为软盘和硬盘推出，取代了原始的Macintosh文件系统。它也可以用在CD-ROM上。

- NT文件系统——也被称为新技术文件系统（NTFS）——是从Windows NT 3.1操作系统开始的Windows产品的默认文件系统。与以前的FAT文件系统相比，NTFS在元数据支持、性能和磁盘空间使用方面有所改进。NTFS也在Linux操作系统中通过一个免费的、开源的NTFS驱动程序得到支持。Mac操作系统对NTFS有只读支持。

- 通用磁盘格式（UDF）是一个面向光盘和DVD的中立厂商的文件系统。UDF取代了ISO 9660文件系统，是DVD论坛选择的DVD视频和音频的官方文件系统。

## [云计算](Cloud%20Computing/Readme.md)
云计算是通过互联网访问信息和应用程序的能力。云计算允许用户从任何有互联网连接的地方访问应用程序和数据。

云计算是一种基于互联网的计算类型，可提供共享的计算机处理资源和数据，以满足计算机和其他设备的需求。

它是一种模型，可以使用户在任何地方，任何时候，方便地通过网络访问一组可配置的计算资源（如网络、服务器、存储、应用程序和服务），这些资源可以快速地被配置和释放，而无需大量的管理工作或服务提供商的交互。
 
 ### 云计算的主要优势

云计算是企业思考IT资源的一种重大转变。以下是机构转向云计算服务的七个常见原因：

成本
云计算消除了购买硬件和软件，设置和运行现场数据中心的资本支出--服务器机架，全天候的电力供应和冷却，以及管理基础设施的IT专家。这一切都会快速积累。

速度
大多数云计算服务是自助服务，并按需提供，所以即使是大量的计算资源也可以在几分钟内提供，通常只需要几次鼠标点击，这给企业带来了很大的灵活性，减轻了容量规划的压力。

全球范围
云计算服务的好处包括弹性扩展的能力。在云语言中，这意味着提供适当数量的IT资源--例如，增加或减少计算能力、存储和带宽--在需要的时候和正确的地理位置。

生产力
现场数据中心通常需要大量的“装架和堆叠”--硬件设置、软件补丁和其他耗时的IT管理任务。云计算消除了这些任务的需要，所以IT团队可以花时间实现更重要的商业目标。


性能
最大的云计算服务在全球范围内的安全数据中心网络上运行，这些数据中心定期升级为最新一代的快速高效的计算硬件。这相比于单个企业数据中心有几个优点，包括降低应用程序的网络延迟和更大的规模经济效益。

可靠性
云计算使数据备份、灾难恢复和业务连续性变得更容易，也更便宜，因为数据可以在云服务提供商网络上的多个冗余站点进行镜像。

安全性
许多云提供商提供一整套广泛的政策、技术和控制措施，这些措施加强了您的整体安全姿态，有助于保护您的数据、应用程序和基础设施免受潜在威胁。

### 云计算服务的类型
- [基础设施即服务（IaaS）](Cloud%20Computing/Readme.md#infrastructure-as-a-service-iaas)
- [平台即服务（PaaS）](Cloud%20Computing/Readme.md#platform-as-a-service-paas)
- [软件即服务（SaaS）](Cloud%20Computing/Readme.md#software-as-a-service-saas)


## [机器学习]()
机器学习是教计算机学习的实践。这个概念使用模式识别以及其他形式的预测算法，对输入的数据进行判断。这个领域与人工智能和计算统计密切相关。

### 机器学习有三个子类别：

### 监督机器学习
在这种情况下，机器学习模型是用标注的数据集训练的，这允许模型随着时间的推移更准确地学习和成长。例如，一个算法会用人类标记的狗的照片和其他东西进行训练，机器会学习自己识别狗的照片的方法。监督机器学习是现在最常用的类型。

监督学习的实际应用 -
1. **生物信息学：** 生物信息学是研究个体如何保留生物知识的学问，如指纹、眼睛的纹理、耳垂等。现在的手机已经足够聪明，可以理解我们的生物数据，然后验证我们以提高系统的安全性。
2. **语音识别：** 你只需要向程序传达你的声音，它就能识别你。最知名的实际设备是数字助手，如Google助手或Siri，它们只会通过你的声音来响应。
3. **垃圾邮件检测：** 这个工具用来阻止发送虚假的或基于机器的消息。Gmail包含了一个学习了多种错误词汇的算法。Oneplus的消息应用程序会要求用户指定哪些词应该被禁止，关键词会在应用程序中阻止这样的消息。
4. **视觉对象识别：** 这类算法一般用于定义某个对象。你用一个很大的训练接来来训练算法，该算法可以用这个数据集来识别新的对象。

### 无监督机器学习
在无监督机器学习中，程序在未标记的数据中寻找模式。无监督机器学习可以找到人们没有明确寻找的模式或趋势。例如，一个无监督的机器学习程序可以查看在线销售数据，并识别出进行购买的不同类型的客户。

无监督学习的实际应用
1. **聚类：** 聚类是将数据分组的过程。当我们不知道所有的簇的详细信息时，我们可以使用无监督学习来聚类。无监督学习被用于分析和组织没有预标记类或类属性的数据。聚类可以帮助公司更有效地处理他们的数据。
假设你有一个YouTube频道。你可能有很多关于你订阅者的信息。如果你想找到相似的订阅者，你需要使用聚类技术。
2. **可视化：** 制作图表、图片、图形、图表等来展示信息的过程被称为可视化。无监督机器学习可以用来实现这个策略。
假设你是一个板球教练，有关于你的团队在比赛中的表现的信息。你可能希望快速找到所有的比赛统计数据。你可以将未标记和复杂的数据传给一个可视化算法。
3. **异常检测：** 异常检测是发现异常的事物、事件或观察，这些异常通过大大偏离正常数据引发怀疑。在这种情况下，系统被编程为有大量的典型案例。因此，当它检测到一个意外的事件时，它可以判断这是不是一个异常。
信用卡欺诈检测就是一个很好的例子。这个问题现在正在使用无监督机器学习的异常检测方法来解决。为了防止欺诈，系统会识别出异常的信用卡交易。

### 半监督机器学习
监督式学习的缺点在于，它需要机器学习专家或数据科学家手动标记，处理成本高。无监督学习的应用范围也有限。为了克服监督式学习和无监督学习算法的这些缺点，引入了半监督学习的概念。典型的半监督学习组合包含很少量的标记过的数据和大量的未标记数据。基本的程序是，首先，编程员会使用无监督学习算法将相似的数据进行聚类，然后利用现有的已标记数据对其余未标记的数据进行标记。

半监督学习的实际应用 – 
1. **语音分析：**由于标签化音频文件是一项极其繁重的任务，半监督学习是解决这个问题的理想选择。
2. **互联网内容分类：**对每个网页进行标签化是一项不切实际和不可行的过程，因此采用了半监督学习算法。甚至谷歌的搜索算法也使用了半监督学习的变种，以评估某个网页对于给定查询的相关性排名。
3. **蛋白质序列分类：**由于DNA链通常非常长，因此在这个领域，半监督学习的应用已经成为了必然趋势。

### 强化机器学习
通过建立奖励系统，训练机器通过反复试错来采取最佳行动。强化学习可以通过告诉机器何时做出了正确的决策，训练模型玩游戏或训练自动驾驶车辆驾驶，这有助于机器随着时间的推移学习应该采取的行动。

强化学习的实际应用 - 
1. **生产系统**
   例如：Google Cloud AutoML，Facebook Horizon，推荐系统，广告，搜索 
2. **自动驾驶**
3. **商业管理**
   例如：解决车辆路线问题，电子商务中的欺诈行为，从客户互动中进行并行强化学习
4. **推荐系统**
   例如：用于搜索，推荐和在线广告
   
### 机器学习也与其他几个人工智能子领域有关：

### 自然语言处理

自然语言处理是机器学习的一个领域，其中机器学习理解人类口头和书面的自然语言，而不是通常用于编程的数据和数字。这使得机器能够识别语言，理解它，并对其进行响应，以及创建新的文本和在语言之间进行翻译。自然语言处理使像聊天机器人和数字助手（如Siri或Alexa）等熟悉的技术成为可能。

自然语言处理的实际应用：
1. **问答系统：**问答系统专注于建立自动回答人类以自然语言提出的问题的系统。
2. **垃圾邮件检测：**垃圾邮件检测用于检测用户收件箱中的不必要的邮件。
3. **情感分析：**情感分析也被称为意见挖掘。它被用于网络上，分析发送者的态度、行为和情绪状态。这个应用通过结合自然语言处理（NLP）和统计，为文本分配值（正面、负面或自然），并识别上下文的情绪（快乐，悲伤，愤怒等）来实现。
4. **机器翻译：**机器翻译用于将文本或语音从一种自然语言翻译到另一种自然语言。例如：Google翻译
5. **拼写纠正：**微软公司提供了像MS-word和PowerPoint这样的文字处理器软件，用于拼写纠正。

### 神经网络

神经网络是一类常用的特定机器学习算法。人工神经网络基于人脑模型，其中成千上万的处理节点相互连接，并组织成层。

在人工神经网络中，细胞或节点是相互连接的，每个细胞处理输入并产生输出，然后将输出发送给其他神经元。标签数据通过节点或细胞移动，每个细胞执行不同的功能。在一个训练出来的能够识别图片中是否含有猫的神经网络中，不同的节点会评估信息，然后得出一个输出，表明图片中是否有猫。

神经网络的实际应用：
1. **股市预测：**为了实时成功地预测股票行情，我们会使用一种称为多层感知机MLP（一种前馈人工智能算法）的工具。MLP由多层节点组成，每一层都与后续的节点完全连接。在构建MLP模型时，会考虑股票的过去表现、年度回报和非盈利比率等因素。
2. **社交媒体：**多层感知机可以预测社交媒体的趋势。它使用不同的训练方法，如平均绝对误差（MAE）、均方根误差（RMSE）和均方误差（MSE）。MLP会考虑多个因素，如用户最喜欢的Instagram页面，书签选择等。在通过社交媒体网络分析个人行为后，可以将数据和人们的消费习惯关联起来。MLP人工神经网络用于从社交媒体应用中挖掘数据。
3. **航天领域：**航天工程是一个包含了航天器和飞机开发的广泛领域。故障诊断、高性能自动驾驶、保护飞机控制系统和建模关键动态模拟是神经网络接管的一些重要领域。时延神经网络可以用于模拟非线性时间动态系统。
### 深度学习

深度学习网络是具有多层的神经网络。分层网络可以处理大量的数据并确定网络中每个链接的“权重” —— 例如，在图像识别系统中，神经网络的某些层可能会检测面部的各个独立特征，如眼睛、鼻子或嘴巴，而另一层则能判断这些特征是否以某种方式出现以表明是一张脸。

深度学习的实际应用：
1. **自动生成文本 -** 学习文本语料库，然后从这个模型中生成新的文本，逐字或逐字符地生成。然后这个模型能学习如何拼写、标点和形成句子，甚至可能捕获到风格。
2. **医疗保健 -** 在诊断各种疾病和治疗他们方面有所帮助。
3. **自动机器翻译 -** 将一种语言中的某些词、句子或短语转换成另一种语言（深度学习在文本和图像领域取得了顶级的结果）。
4. **图像识别 -** 识别并识别图像中的人和物体，同时理解内容和上下文。这个领域已经在游戏、零售、旅游等领域得到应用。
5. **预测地震 -** 教计算机执行粘弹性计算，用于预测地震等。

## [网络技术](Web%20Technology/WebTechnology.md#web-tecnology)
网络技术指的是在互联网上进行不同类型设备之间通信过程中使用的各种工具和技术。网络浏览器用于访问网页。网络浏览器可以定义为在互联网上显示文本、数据、图片、动画和视频的程序。可以使用网络浏览器提供的软件接口来访问万维网上的超链接资源。
### 网络技术可以分为以下几部分：
- 万维网（WWW）
万维网基于几种不同的技术：网络浏览器、超文本标记语言（HTML）、和超文本传输协议（HTTP）。
- 网络浏览器
网络浏览器是一种应用软件，用于浏览万维网（WWW）。它提供了服务器和客户端之间的接口，并向服务器请求网页文档和服务。
- 网络服务器
网络服务器是一个处理用户的网络请求并为他们提供创建网页的文件的程序。这种交换使用超文本传输协议（HTTP）进行。
- 网页
网页是一个链接到万维网并可通过网络浏览器被任何连接到互联网的人查看的数字文档。
- 网络开发
网络开发指的是建造、创建和维护网站。它包括诸如网页设计、网络发布、网络编程和数据库管理等方面。它是创建在互联网上运行的应用，即网站。
### 网络开发可以分类为两种方式：
### 前端开发
用户直接交互的网站部分称为前端。它也被称为应用的“客户端”。
### 后端开发
后端是网站的服务器端。这是网站的一部分，用户无法看到和交互。它是软件的部分，不直接接触用户。它用于存储和整理数据。


## [计算机网络](Networking/readme.md#networking)
计算机网络是一组共享网络节点上的资源或由网络节点提供的资源的计算机集合。计算机使用通用的通信协议通过数字互连进行通信。这些互连由基于物理有线、光学和无线射频的电信网络技术组成，可以按照各种网络拓扑进行布局。

计算机网络的节点可以包括个人电脑、服务器、网络硬件或其他专用或通用主机。它们由网络地址识别，并可能有主机名。主机名作为节点的易记标签，在初始分配后很少更改。网络地址用于通过通信协议（如Internet协议）定位和识别节点。

计算机网络可以根据许多标准进行分类，包括用于传输信号的传输介质、带宽、组织网络流量的通信协议、网络规模、拓扑、流量控制机制和组织目标。

### 网络类型
计算机网络主要有两种类型：
- 有线网络：有线网络需要使用物理介质在节点之间进行传输。由于其低成本和耐用性，铜基Ethernet布线常用于企业和家庭的数字通信。或者，光纤用于传输数据，距离更远，速度更快，但它有几个权衡，包括更高的成本和更脆弱的组件。
- 无线网络：无线网络使用无线电波通过空气传输数据，使设备能够在没有任何电缆的情况下连接到网络。无线局域网是最知名和最广泛部署的无线网络形式。其他选项包括微波、卫星、蜂窝和蓝牙等。
## OSI模型
OSI代表**开放系统互连**。它是由ISO - '**国际标准化组织'在1984年开发的。它是一个7层架构，每层都有特定的功能要执行。所有这些七层协同工作，将数据从世界上的一个人传输到另一个人。

#### **1\. 物理层 (第1层):**

OSI参考模型的最底层是物理层。它负责设备之间的实际物理连接。物理层包含以**比特**形式的信息。它负责将单个比特从一个节点传输到下一个节点。在接收数据时，该层会获取接收到的信号并将其转换为0和1，然后将它们发送到数据链路层，数据链路层将重新组合数据帧。

![](Networking/OSI%20Model/img/computer-network-osi-model-layers-bits.png)

物理层的功能如下:

1.  **比特同步:** 通过提供时钟，物理层提供比特的同步。这个时钟控制发送者和接收者，从而在比特级别提供同步。
2.  **比特率控制:** 物理层还定义了传输率，即每秒发送的比特数。
3.  **物理拓扑:** 物理层指定网络中不同设备/节点的排列方式，即总线、星型或网状拓扑。
4.  **传输模式:** 物理层也定义了数据如何在两个连接的设备之间流动。可能的传输模式有单工、半双工和全双工。

#### **2\. 数据链路层 (第2层):**

数据链路层负责消息从节点到节点的传送。该层的主要功能是确保数据在物理层从一个节点无误地传输到另一个节点。当一个包到达网络时，将其传输到主机是数据链路层的责任，这通过使用其MAC地址来实现。   
数据链路层分为两个子层:  

1. 逻辑链路控制 (LLC)
2. 媒介访问控制 (MAC)

从网络层接收到的数据包根据NIC(网络接口卡)的帧大小进一步划分为帧。数据链路层还在头部封装了发送者和接收者的MAC地址。 

接收者的MAC地址是通过在网络上发送一个ARP(地址解析协议)请求获得的，询问“谁拥有这个IP地址？”，然后目标主机将回复其MAC地址。
![](Networking/OSI%20Model/img/computer-network-osi-model-layers-framing.png)

数据链路层的功能有 :  

1.  **帧设定:** 帧设定是数据链路层的一个功能。它为发送者提供了一种方式来传输接收者可以理解的一组比特。这可以通过在帧的开始和结束处附加特殊的比特模式来实现。
2.  **物理寻址:** 在创建帧后，数据链路层在每个帧的头部添加发送者和/或接收者的物理地址（MAC地址）。
3.  **错误控制:** 数据链路层提供了错误控制机制，它可以检测并重新传输损坏或丢失的帧。
4.  **流量控制:** 两边的数据率必须保持恒定，否则数据可能会被损坏；因此，流量控制协调在接收到确认之前可以发送的数据量。
5.  **访问控制:** 当单个通信通道被多个设备共享时，数据链路层的MAC子层帮助确定在给定时间哪个设备控制着通道。

#### **3\. 网络层 (第3层):**

网络层为在不同网络中的两个主机之间传输数据工作。它还负责数据包的路由，即选择从众多可用路径中传输数据包的最短路径。网络层将发送者和接收者的IP地址放在头部。 

网络层的功能有 :  

1.  **路由:** 网络层协议确定从源到目的地的哪条路线适合。这个网络层的功能被称为路由。
2.  **逻辑寻址:** 为了唯一地识别互联网上的每个设备，网络层定义了一种寻址方案。网络层将发送者和接收者的IP地址放在头部。这样的地址可以区分不同的设备。

## [互联网](Internet/readme.md#internet)
互联网是一个全球性的计算机网络互连系统，它使用标准的互联网协议套件（[TCP/IP](Networking/readme.md#tcptransmission-control-protocol)）为全球数十亿用户提供服务。互联网是由数百万个私人、公共、学术、商业和政府的本地到全局范围的网络组成的网络，这些网络通过广泛的电子、无线和光网络技术连接在一起。互联网携带了大量的信息资源和服务，如相互链接的超文本文档和世界范围网（[WWW](Internet/readme.md#world-wide-web-www)）的应用程序以及支持电子邮件的基础设施。

### [世界范围网 (WWW)](Internet/readme.md#world-wide-web-www)
世界范围网（WWW）是一个信息空间，其中的文档和其他网络资源由统一资源定位符（URLs）标识，通过超文本链接相互连接，并通过互联网可访问。英国科学家蒂姆·伯纳斯-李在1989年发明了世界范围网。他在1990年就职于瑞士的欧洲核子研究中心（CERN）时编写了第一个网络浏览器。该浏览器于1991年在CERN外部发布，首先于1991年1月发布给其他研究机构，然后在1991年8月发布给互联网的公众。

### [互联网协议 (IP)](Internet/readme.md#internet-protocol-ip)
互联网协议（IP）是一种协议或规则集，用于路由和寻址数据包，使它们可以穿越网络并到达正确的目的地。穿越互联网的数据被划分为称为数据包的较小片段。

## [数据库管理系统]()

什么是数据库？
-------------------

数据库是一个数据的集合，这些数据来源于现实世界中的某个部分。数据库系统被设计为构建和填充某个任务的数据。

什么是DBMS？
-------------

**数据库管理系统(DBMS)** 是一种在考虑适当的安全措施的同时存储和检索用户数据的软件。它由一组操作数据库的程序组成。DBMS接受应用程序对数据的请求，并指示操作系统提供特定的数据。在大型系统中，DBMS帮助用户和其他第三方软件存储和检索数据。

DBMS允许用户根据他们的需求创建自己的数据库。"DBMS"一词包括了数据库和其他应用程序的使用。它提供了数据和软件应用之间的接口。

DBMS的例子
-----------------

让我们看一个大学数据库的简单例子。这个数据库维护了大学环境中关于学生、课程和成绩的信息。数据库被组织成五个文件：

*   学生文件存储每个学生的数据
*   课程文件存储每门课程的数据。
*   部分存储关于特定课程中部分的信息。
*   成绩文件存储学生在各个部分获得的成绩
*   指导文件包含每位教授的信息。

定义DBMS：

*   我们需要通过定义每个记录中要存储的不同类型的数据元素来指定每个文件的记录结构。
*   我们还可以使用编码方案来表示数据项的值。
*   基本上，你的数据库将有五个表，各个表之间定义了一个外键。

DBMS的历史
---------------

这里是一些重要的历史里程碑：

*   1960年 – 查尔斯·巴赫曼设计了第一个DBMS系统
*   1970年 – 科德引入了IBM的信息管理系统（IMS）
*   1976年- 彼得·陈提出并定义了实体-关系模型，也被称为ER模型
*   1980年 – 关系模型成为广泛接受的数据库组件
*   1985年- 对象导向的DBMS得到发展。
*   1990年代- 在关系型DBMS中加入了面向对象的思想。
*   1991年- 微软发布了MS Access，这是一款个人DBMS，取代了所有其他的个人DBMS产品。
*   1995年: 第一批互联网数据库应用
*   1997年: XML被应用于数据库处理。许多供应商开始将XML集成到DBMS产品中。

DBMS的特性
-----------------------

以下是数据库管理系统的特性和属性：

*   提供安全性并消除冗余
*   自我描述数据库系统的性质
*   程序和数据抽象之间的隔离
*   支持数据的多视图
*   数据共享和多用户事务处理
*   数据库管理软件允许实体和它们之间的关系形成表。
*   它遵循ACID概念（原子性，一致性，隔离性和持久性）。
*   DBMS支持多用户环境，允许用户并行访问和操作数据。

常见的DBMS软件
---------------------

以下是一些常见的DBMS系统的列表:

*   MySQL
*   Microsoft Access
*   Oracle
*   PostgreSQL
*   dBASE
*   FoxPro
*   SQLite
*   IBM DB2
*   LibreOffice Base
*   MariaDB
*   Microsoft SQL Server etc.

## [密码学](Cryptography/readme.md#cryptography)
密码学是一种保护数据和通信的技术。它是一种通过使用编码来保护信息和通信的方法，这样只有那些信息的预期接收者才能阅读和处理这些信息。密码学被用来保护在传输中、静止状态和使用中的数据。前缀_crypt_的意思是"隐藏"或"秘密"，后缀_graphy_的意思是"写作"。

### 密码学的类型
密码学有两种类型:
1. [对称密码学](Cryptography/readme.md#symmetric-cryptography)
2. [非对称密码学](Cryptography/readme.md#asymmetric-cryptography)

### [加密货币](Cryptography/CryptoCurrency/readme.md#crypto-currency)
加密货币是一种数字货币，其中使用加密技术来规定货币的产生单位，并验证资金的转移，独立于中央银行运作。加密货币使用分散的控制，而不是集中的数字货币和中央银行系统。每种加密货币的分散控制通过分布式账本技术，通常是一种区块链，作为公共的金融交易数据库。加密货币的一个定义特性，也可以说是其最吸引人的特点，就是其有机的性质；它不是由任何中央权威发行的，理论上它对政府的干预或操纵是免疫的。

## 加密货币的类型如下：
1. [工作证明](Cryptography/CryptoCurrency/ProofOfWork/readme.md#proof-of-work)
2. [权益证明](Cryptography/CryptoCurrency/ProofOfStake/readme.md#proof-of-stake)


### _以下是最受欢迎的加密货币：_
1. [Bitcoin](Cryptography/CryptoCurrency/ProofOfWork/Bitcoin/readme.md#bitcoin)
2. [Ethereum](Cryptography/CryptoCurrency/ProofOfStake/Ethereum/readme.md#ethereum)
3. [Litecoin](Cryptography/CryptoCurrency/ProofOfWork/Litecoin/readme.md#litecoin)
4. [Cardano](Cryptography/CryptoCurrency/ProofOfStake/Cardano/readme.md#cardano)
5. [Dogecoin](Cryptography/CryptoCurrency/ProofOfWork/Dogecoin/readme.md#dogecoin)



## 计算理论
在理论计算机科学和数学中，计算理论是一门研究算法在一种计算模型上可以解决哪些问题，解决的效率如何，或者解决的程度（例如，近似解与精确解）的学科。这个领域主要分为三大分支：自动机理论和形式语言、可计算性理论、计算复杂性理论，这三个问题围绕着一个问题展开：“计算机的基本能力和限制是什么？”。

### 自动机理论
自动机理论是对抽象机器和自动机以及使用它们可以解决的计算问题的研究。它是理论计算机科学中的一个理论。单词automata来源于希腊语的αὐτόματος，意味着“自行行动，自愿，自我移动”。自动机（复数形式为automata）是一个遵循预设操作顺序自动执行的抽象自推进计算设备。有限状态的自动机被称为有限自动机(FA)或有限状态机(FSM)。右图展示了一个著名的自动机类型 - 有限状态机。这个自动机由状态（图中以圆形表示）和转换（以箭头表示）组成。当自动机看到一个输入符号时，它根据转移函数（该函数以前一个状态和当前输入符号作为参数）转移到另一个状态。

### 形式语言
在逻辑学、数学、计算机科学和语言学中，形式语言由字母组成的单词，这些字母取自一个字母表，并根据一套特定的规则形成。

形式语言的字母表由符号、字母或标记组成，这些符号、字母或标记串联成语言的字符串。每个由此字母表的符号串联成的字符串称为单词，属于特定形式语言的单词有时被称为良构单词或良构公式。形式语言通常通过形式语法（如正则语法或无上下文语法）定义，这包括了其形成规则。

在计算机科学中，形式语言用于定义编程语言的语法和自然语言的正式化版本的基础，其中语言的单词代表与特定含义或语义相关的概念。在计算复杂性理论中，决策问题通常被定义为形式语言，复杂性类被定义为可以由具有有限计算能力的机器解析的形式语言集合。在逻辑和数学基础中，形式语言用于表示公理系统的语法，数学形式主义是一种所有数学都可以被归约为以这种方式对形式语言进行句法操控的哲学。

### 可计算性理论
可计算性理论，也称为递归理论，是数学逻辑、计算机科学和计算理论的一个分支，起源于20世纪30年代对可计算函数和图灵度的研究。该领域已扩展到包括对广义可计算性和可定义性的研究。在这些领域，可计算性理论与证明理论和有效描述集理论有所重叠。
### 计算复杂性理论
在理论计算机科学和数学中，计算复杂性理论主要关注的是根据其资源使用情况对计算问题进行分类，并将这些类别相互关联。计算问题是由计算机解决的任务。计算问题可以通过数学步骤（例如算法）的机械应用进行解决。

如果一个问题的解决需要大量的资源，无论使用何种算法，都被认为是固有的困难。这种理论通过引入计算的数学模型来形式化这种直觉，研究这些问题，并量化它们的计算复杂性，即，解决它们所需要的资源数量，如时间和存储。也会使用其他复杂性度量，如通信量（用于通信复杂性）、电路中的门数（用于电路复杂性）和处理器数量（用于并行计算）。计算复杂性理论的一个角色是确定计算机能做什么和不能做什么的实际限制。P/NP问题，作为七个千禧年奖问题之一，是专门用于计算复杂性领域的。

理论计算机科学中与计算复杂性理论密切相关的领域是算法分析和可计算性理论。算法分析与计算复杂性理论之间的一个关键区别是，前者致力于分析特定算法解决问题所需的资源数量，而后者则提出了关于所有可能用于解决同一问题的算法的更一般性问题。更准确地说，计算复杂性理论试图分类可以或不能用适当的限制资源解决的问题。反过来，对可用资源进行限制是计算复杂性与可计算性理论的区别所在：后者的理论询问的是原则上可以用算法解决哪些问题。
