<h1 align="center">Computer Science (علوم الحاسوب)</h1>
<h4 align="center">
    <p>
        <a href="https://github.com/shhossain/computer_science/blob/main/README.md">English</a> |
        <a href="https://github.com/shhossain/computer_science/blob/main/README_it.md">Italiano</a> |
        <a href="https://github.com/shhossain/computer_science/blob/main/README_es.md">Español</a> |
        <a href="https://github.com/shhossain/computer_science/blob/main/README_fr.md">Français</a> |
        <a href="https://github.com/shhossain/computer_science/blob/main/README_bn.md">বাংলা</a> |
        <a href="https://github.com/shhossain/computer_science/blob/main/README_ta.md">தமிழ்</a> |
        <a href="https://github.com/shhossain/computer_science/blob/main/README_guj.md">ગુજરાતી</a> |
        <a href="https://github.com/shhossain/computer_science/blob/main/README_pt.md">Portuguese</a> |
        <a href="https://github.com/shhossain/computer_science/blob/main/README_ro.md">Română</a> |
        <b>العربية</b>
    </p>
</h4>

## إرشادات المساهمة
إذا كنت مهتمًا بالمساهمة في هذا المشروع، يُرجى قضاء لحظة لمراجعة [CONTRIBUTING.md](https://github.com/shhossain/computer_science/blob/main/CONTRIBUTING.md) للحصول على تعليمات مفصلة حول كيفية البدء. نحن نقدر مساهماتك كثيرًا!



## جدول المحتويات

- [المقدمة](#المقدمة)
- [الحاسوب الإلكتروني](#الحاسوب-الإلكتروني)
- [المنطق البولياني](#المنطق-البولياني)
- [أنظمة الأعداد](#أنظمة-الأعداد)
- [وحدة المعالجة المركزية (CPU)](#وحدة-المعالجة-المركزية-cpu)
- [السجلات، الذاكرة المؤقتة والذاكرة الرئيسية (Registers, Cache, and RAM)](#السجلات-الذاكرة-المؤقتة-والذاكرة-الرئيسية-registers-cache-and-ram)
- [التعليمات والبرنامج](#التعليمات-والبرنامج)
- [لغات البرمجة](#لغات-البرمجة)
- [أنواع البيانات](#أنواع-البيانات)
- [البيانات والدوال](#البيانات-والدوال)
- [هياكل البيانات](#هياكل-البيانات)
- [الخوارزميات](#الخوارزميات)
- [آلان تورينج](#آلان-تورينج)
- [هندسة البرمجيات](#هندسة-البرمجيات)
- [الدوائر المتكاملة](#الدوائر-المتكاملة)
- [البرمجة الشيئية الموجهة](#البرمجة-الشيئية-الموجهة)
- [البرمجة الوظيفية](#البرمجة-الوظيفية)
- [أنظمة التشغيل](#أنظمة-التشغيل)
- [الذاكرة والتخزين](#الذاكرة-والتخزين)
- [نظام الملفات](#نظام-الملفات)
- [حوسبة السحابة](#حوسبة-السحابة)
- [تعلم الآلة](#تعلم-الآلة)
- [تقنية الويب](#تقنية-الويب)
- [الشبكات](#الشبكات)
- [الإنترنت](#الإنترنت)
- [أنظمة إدارة قواعد البيانات (DBMS)](#أنظمة-إدارة-قواعد-البيانات-dbms)

## المقدمة

علم الحاسوب هو دراسة الأجهزة الحاسوبية وعمليات الحوسبة وتطبيقاتها النظرية والعملية. يُطبق علم الحاسوب مبادئ الرياضيات والهندسة والمنطق على مجموعة من المشكلات، بما في ذلك صياغة الخوارزميات وتطوير البرمجيات/الأجهزة والذكاء الاصطناعي.

## [الحاسوب الإلكتروني](Electronic%20Computer/readme.md)

جهاز يقوم بالحسابات، خاصة الجهاز الإلكتروني القابل للبرمجة الذي يقوم بإجراء العمليات الرياضية أو المنطقية بسرعة عالية أو يجمع أو يخزن أو يقوم بتقارن أو يعالج المعلومات بأي وسيلة أخرى.

## [المنطق البولياني](Boolean%20Logic/readme.md)

المنطق البولياني هو فرع من الرياضيات يتناول قيم الصدق والكذب. إنه نظام منطقي يستخدم قيمتين فقط، 0 و 1، لتمثيل الكذب والحقيقة على التوالي. وهو معروف أيضا باسم الجبر البولياني، نسبة إلى جورج بول الذي وصفه لأول مرة في عام 1854.

### العمليات البوليانية الشائعة

| العامل | الاسم | الوصف |
| :------: | :--: | :-------------------------------------: |
|    !     | NOT  |    يعكس قيمة العامل.    |
|    &&    | AND  | يعود **صحيح** إذا كانت كل العوامل صحيحة. |
|   \|\|   |  OR  | يعود **صحيح** إذا كانت واحدة أو جميع العوامل صحيحة. |

### العمليات البوليانية الجيدة للمعرفة

| العامل | الاسم | الوصف |
| :------: | :--: | :-------------------------------------: |
|    ()    | القوسين     |   يسمح لك بتجميع الكلمات الرئيسية والتحكم في ترتيب البحث عندما يتم البحث.    |
|    “”    | علامات التنصيص | يوفر نتائج بالعبارة الدقيقة. |
|   *      |  النجمة       | يوفر نتائج تحتوي على تغيير في الكلمة الرئيسية. |
|   ⊕     |  XOR            | يعود **صحيح** إذا كانت العوامل مختلفة |
|   ⊽      |  NOR            | يعود **صحيح** إذا كانت كل العوامل خاطئة. |
|   ⊼      |  NAND           | يعود **خاطئ** فقط إذا كانت قيمتي مدخليه صحيحتين.

## [أنظمة الأعداد](Number%20System/readme.md#أنظمة-الأعداد)

الأنظمة العددية هي نظم رياضية لتعبير الأعداد. يتكون نظام الأعداد من مجموعة من الرموز التي تستخدم لتمثيل الأعداد ومجموعة من القواعد لتلاعب بهذه الرموز. يطلق على الرموز المستخدمة في نظام الأعداد اسم "العلامات العددية".

### [أنواع أنظمة الأعداد](Number%20System/readme.md#أنواع-أنظمة-الأعداد)

- [نظام العد الثنائي](Number%20System/readme.md#نظام-العد-الثنائي)
- [نظام التعبير بالقيمة والعلامة](Number%20System/readme.md#نظام-التعبير-بالقيمة-والعلامة)

### [أنظمة العد الثنائي الشائعة](Number%20System/readme.md#أنظمة-العد-الثنائي-الشائعة)

- [نظام العد الثنائي](Number%20System/readme.md#نظام-العد-الثنائي)
- [نظام العد الثماني](Number%20System/readme.md#نظام-العد-الثماني)
- [نظام العد العشري](Number%20System/readme.md#نظام-العد-العشري)
- [نظام العد السداسي عشري](Number%20System/readme.md#نظام-العد-السداسي-عشري)

### أهمية العد الثنائي

النظام الثنائي هو نظام عددي قائم على القاعدة 2 اخترعه غوتفريد لايبنتز ويتكون فقط من رقمين أو أرقام: 0 (صفر) و 1 (واحد). يعتبر هذا النظام الأساس لجميع رموز النظام الثنائي التي تُستخدم لكتابة البيانات الرقمية مثل تعليمات معالج الحاسوب التي تستخدم يومياً. الأصفار والواحدات في النظام الثنائي تمثل إيقاف التشغيل أو التشغيل على التوالي. في المفتاحية الكهروضوئية، يمثل "0" عدم تدفق الكهرباء، ويمثل "1" السماح بتدفق الكهرباء. بهذه الطريقة، تُمثل الأرقام بشكل فيزيائي داخل الجهاز الحاسوبي، مما يسمح بإجراء الحسابات.

النظام الثنائي لا يزال اللغة الأساسية للحواسيب ويستخدم مع الإلكترونيات وأجهزة الحاسوب للأسباب التالية:

- إنه تصميم بسيط وأنيق.
- طريقة النظام الثنائي (0 و 1) سريعة في اكتشاف حالة الإشارة الكهربائية إيقاف (خاطئة) أو تشغيل

 (صحيح).
- وجود حالتين فقط بعيدين جدا عن بعضهما في الإشارة الكهربائية يجعله أقل عرضة للتداخل الكهربائي.
- يتم ترجمة أقطاب وقطبين سالبين لوسائط المغناطيسية بسرعة إلى النظام الثنائي.
- النظام الثنائي هو الطريقة الأكثر كفاءة للتحكم في الدوائر المنطقية.

## وحدة المعالجة المركزية (CPU)

وحدة المعالجة المركزية (CPU) هي الجزء الأهم في أي حاسوب. ترسل وحدة المعالجة المركزية إشارات للتحكم في باقي أجزاء الحاسوب، تمامًا كيف يتحكم المخ في الجسم. إن وحدة المعالجة المركزية هي جهاز إلكتروني يعمل على قائمة من الأمور الحاسوبية التي يجب القيام بها، تسمى التعليمات. تقوم بقراءة قائمة التعليمات وتنفيذ كل واحدة منها بالتسلسل. قائمة التعليمات التي يمكن لوحدة المعالجة المركزية تشغيلها هي برنامج حاسوب. يمكن لوحدة المعالجة المركزية معالجة أكثر من تعليمة في نفس الوقت في أقسام تسمى "النوى". قد تعالج وحدة المعالجة المركزية ذات الأربعة نوى أربعة برامج في وقت واحد. تتكون وحدة المعالجة المركزية ذاتها من ثلاثة مكونات رئيسية. وهي:

1. [وحدة الذاكرة أو وحدة التخزين](CPU/readme.md#memory-or-storage-unit)
2. [وحدة التحكم](CPU/readme.md#control-unit)
3. [وحدة الحساب والمنطق (ALU)](CPU/readme.md#arithmetic-and-logic-unit-alu)

## السجلات، الذاكرة المؤقتة والذاكرة الرئيسية (Registers, Cache, and RAM)

### السجل (Register)

السجلات هي كميات صغيرة من الذاكرة عالية السرعة الموجودة داخل وحدة المعالجة المركزية. السجلات هي مجموعة من "القلابات" (دائرة تستخدم لتخزين 1 بت من الذاكرة). تُستخدم من قبل المعالج لتخزين كميات صغيرة من البيانات التي تحتاج أثناء المعالجة. قد تحتوي وحدة المعالجة المركزية على عدة مجموعات من السجلات تسمى "النوى". تساعد السجلات أيضًا في العمليات الحسابية والمنطقية.

العمليات الحسابية هي الحسابات الرياضية التي يقوم بها وحدة المعالجة المركزية على البيانات الرقمية المخزنة في السجلات. تتضمن هذه العمليات الجمع والطرح والضرب والقسمة. العمليات المنطقية هي الحسابات البولية التي يقوم بها وحدة المعالجة المركزية على البيانات الثنائية المخزنة في السجلات. تتضمن هذه العمليات المقارنات (على سبيل المثال اختبار ما إذا كانت قيمتان متسا

ويتان) والعمليات المنطقية (مثل AND، OR، NOT).

السجلات ضرورية لأداء هذه العمليات لأنها تسمح لوحدة المعالجة المركزية بالوصول السريع والتلاعب بكميات صغيرة من البيانات. من خلال تخزين البيانات التي يتم الوصول إليها بشكل متكرر في السجلات، يمكن لوحدة المعالجة المركزية تجنب عملية استرجاع البيانات من الذاكرة التي تستغرق وقتًا أطول.

يمكن تخزين كميات أكبر من البيانات في الذاكرة المؤقتة (تلفظ كـ "كاش")، وهي ذاكرة سريعة جدًا تقع على نفس الدائرة المتكاملة مع السجلات. يتم استخدام الذاكرة المؤقتة للبيانات التي يتم الوصول إليها بشكل متكرر أثناء تشغيل البرنامج. ويمكن تخزين كميات أكبر من البيانات في الذاكرة العشوائية (RAM). RAM تعني الذاكرة ذات الوصول العشوائي، وهي نوع من الذاكرة تحتفظ بالبيانات والتعليمات التي تم نقلها من تخزين القرص حتى يحتاج المعالج إليها.

### الذاكرة المؤقتة (Cache)

ذاكرة الذاكرة المؤقتة هي عنصر حاسوب يعتمد على الشرائح ويجعل استرجاع البيانات من ذاكرة الحاسوب أكثر كفاءة. إنها تعمل كمنطقة تخزين مؤقتة بحيث يمكن لمعالج الحاسوب استرجاع البيانات بسهولة. هذه المنطقة التخزينية المؤقتة، المعروفة باسم الكاش، أكثر توفراً للمعالج من مصدر الذاكرة الرئيسي للحاسوب، والذي يكون عادةً بعض نوع من DRAM.

ذاكرة الذاكرة المؤقتة تسمى أحياناً بذاكرة وحدة المعالجة المركزية (CPU) لأنها عادة ما تكون متكاملة مباشرة في شريحة وحدة المعالجة المركزية أو موجودة على شريحة منفصلة تحتوي على اتصال بوصلة منفصلة مع وحدة المعالجة المركزية. لذلك، فهي أكثر إمكانية للمعالج وقادرة على زيادة الكفاءة لأنها قريبة جسديًا من وحدة المعالجة المركزية.

لكي تكون قريبة من وحدة المعالجة المركزية، يجب أن تكون ذاكرة الذاكرة المؤقتة أصغر بكثير من الذاكرة الرئيسية. وبالتالي، لديها مساحة تخزين أقل. إنها أيضا أغلى من الذاكرة الرئيسية، لأنها شريحة أكثر تعقيدًا توفر أداءًا أعلى.

ما تضحي به من حجم وسعر، تعوض عنه بالسرعة. تعمل ذاكرة الذاكرة المؤقتة بسرعة 10 إلى 100 مرة أسرع من الذاكرة، حيث يتطلب الأمر ثوانٍ قليلة فقط للاستجابة لطلب من وحدة المعالجة المركزية.

اسم الأجهزة الفعلي التي تستخدم لذاكرة الذاكرة المؤقتة هو ذاكرة الوصول العشوائي الساكنة عالية السرعة (SRAM). واسم الأجهزة التي تستخدم في الذاكرة الرئيسية للحاسوب هو ذاكرة الوصول العشوائي الديناميكية (DRAM).

لا يجب أن يتم الخلط بين ذاكرة الذاكرة المؤقتة ومصطلح الذاكرة بشكل أوسع. الذاكرات هي مخازن بيانات مؤقتة يمكن أن تكون موجودة في كل من الأجهزة والبرمجيات. تشير ذاك

رة الذاكرة المؤقتة إلى المكون الأجهزة الخاص الذي يسمح للحواسيب بإنشاء ذواكر في مستويات مختلفة من الشبكة. ذاكرة الذاكرة المؤقتة هي عبارة عن عتاد أو برنامج يستخدم لتخزين شيء ما، وعادةً بيانات، مؤقتًا في بيئة الحوسبة.

### الذاكرة العشوائية (RAM)

الذاكرة العشوائية (RAM) هي نوع من ذاكرة الحاسوب التي يمكن قراءتها وتغييرها بأي ترتيب، وعادةً ما تستخدم لتخزين البيانات العاملة ورمز الآلة. يتيح جهاز ذاكرة الوصول العشوائي للعناصر البيانات أن تكون قابلة للقراءة أو الكتابة في نفس الوقت تقريبًا بنفس الوقت بغض النظر عن الموقع الفعلي للبيانات داخل الذاكرة، على عكس وسائط تخزين البيانات بالوصول المباشر الأخرى (مثل الأقراص الصلبة، وأقراص الـ CD-RW، وأقراص الـ DVD-RW وأشرطة الـ Magnetic القديمة والذاكرة الدوارة)، حيث يختلف الوقت اللازم لقراءة وكتابة عناصر البيانات بشكل كبير اعتمادًا على المواقع الفعلية للبيانات على وسيط التسجيل، نتيجة للقيود الميكانيكية مثل سرعات دوران وسائط التسجيل وحركة الذراع.

## التعليمات والبرنامج (Instructions and Program)

في علم الحاسوب، تعتبر التعليمة هي عملية واحدة من مجموعة عمليات معالج محددة من قبل مجموعة التعليمات للمعالج. البرنامج الحاسوبي هو قائمة من التعليمات تخبر الحاسوب بما يجب فعله. كل ما يفعله الحاسوب يتم بواسطة استخدام برنامج حاسوب. البرامج التي يتم تخزينها في ذاكرة الحاسوب ("البرمجة الداخلية") تتيح للحاسوب القيام بشيء بعد شيء، حتى مع فواصل بينها.

## لغات البرمجة (Programming Languages)

لغة البرمجة هي أي مجموعة من القواعد التي تحول السلاسل، أو العناصر البرمجية الرسومية في حالة لغات البرمجة البصرية، إلى أنواع مختلفة من الإخراجات الرمزية. اللغات البرمجية هي نوع واحد من لغة الحاسوب المستخدمة في برمجة الحاسوب لتنفيذ الخوارزميات.

غالبًا ما تنقسم لغات البرمجة إلى فئتين رئيسيتين:

1. تستخدم لغة عالية المستوى بنية تركيبية مماثلة للغة الإنجليزية. يتم تحويل الشيفرة المصدرية إلى شيفرة آلية قابلة للقراءة بواسطة مترجم أو مفسر. جافا وبايثون هما بعض الأمثلة على لغات البرمجة عالية المستوى. هذه اللغات عادةً ما تكون أبطأ من المستوى المنخفض، ولكن يترافق ذلك مع سهولة الاستخدام.

2. تعمل لغات البرمجة منخفضة المستوى بشكل أكثر تقارباً مع الأجهزة ولديها مزيد من التحكم فيها. إنها تتفاعل مباشرة مع الأجهزة. مثالان شائعان على لغات البرمجة منخفضة المستوى هما لغة الآلة ولغة التجميع. هذه اللغات عادةً ما تكون أسرع من المستوى المنخفض، ولكن هذا يأتي على حساب الصعوبة الكبيرة ونقص القراءة.

## البيانات وأنواعها (Data Types)

نوع البيانات، في البرم

جة، هو تصنيف يحدد أي نوع من القيمة يحمل المتغير وأي نوع من العمليات الرياضية أو العلاقية أو المنطقية يمكن تطبيقها عليه دون تسبب في خطأ.

### أنواع البيانات الأساسية (Primitive Data Types)

أنواع البيانات الأساسية هي أنواع البيانات الأكثر أساسية في لغة البرمجة. إنها تشكل البنية الأساسية لأنواع البيانات الأكثر تعقيدًا. أنواع البيانات الأساسية محددة مسبقًا من قبل لغة البرمجة وتسمى بكلمة مفتاحية محجوزة.

### أنواع البيانات الأساسية الشائعة (Common Primitive Data Types)

- [العدد الصحيح (Integer)](Data%20Types/readme.md#integer)
- [العدد العشري (Float)](Data%20Types/readme.md#float)
- [القيمة البولية (Boolean)](Data%20Types/readme.md#boolean)
- [الحرف (Character)](Data%20Types/readme.md#character)
- [السلسلة (String)](Data%20Types/readme.md#string)

### أنواع البيانات غير الأساسية (Non-Primitive Data Types)

أنواع البيانات غير الأساسية تعرف أيضًا باسم أنواع البيانات المرجعية. إنها تم إنشاؤها من قبل المبرمج وليست محددة من قبل لغة البرمجة. أنواع البيانات غير الأساسية تسمى أيضًا أنواع البيانات المركبة لأنها تتكون من أنواع أخرى.

### أنواع البيانات غير الأساسية الشائعة (Common Non-Primitive Data Types)

- [المصفوفة (Array)](Data%20Types/readme.md#array)
- [الهيكل (Struct)](Data%20Types/readme.md#struct)
- [الاتحاد (Union)](Data%20Types/readme.md#union)
- [المؤشر (Pointer)](Data%20Types/readme.md#pointer)
- [الوظيفة (Function)](Data%20Types/readme.md#function)
- [الفصل (Class)](Data%20Types/readme.md#class)

## البيانات والدوال (Statements and Functions)

في برمجة الحاسوب، البيان هو وحدة صياغية من لغة البرمجة التي تعبر عن بعض الإجراءات التي يجب تنفيذها. يتكون برنامج كتب بلغة مثل هذه من متسلسلة من بيانات واحدة أو أكثر. قد تحتوي بيانات على مكونات داخلية (على سبيل المثال، التعبيرات).

هناك نوعان رئيسيان من البيانات في أي لغة برمجة ضروري لبناء منطق الشيفرة.

1. [البيانات الشرطية (Conditional-Statements)](Statements%20and%20Functions/readme.md#conditional-statements)

هناك نوعان رئيسيان من البيانات الشرطية:
- إذا
- إذا كان غير ذلك
- تبديل الحالة

2. [الحلقات (Loops)](Statements%20and%20Functions/readme.md#loops)

هناك ثلاثة أنواع رئيسية من البيانات الشرطية:
- حلقة للتكرار
- حلقة مع شرط محدد
- حلقة "فعل - حتى" (اختلاف من الحلقة مع شرط)

### الدالة(function)

الدالة هي مجموعة من البيانات التي تقوم بأداء مهمة معينة. تقوم الدوال بقبول البيانات، معالجتها، وإرجاع نتيجة أو تنفيذها. تكتب الدوال أساساً لدعم مفهوم إعادة الاستخدام. بمجرد كتابة دالة، يمكن استدعاؤها بسهولة دون الحاجة إلى تكرار نفس الشيفرة.

تستخدم لغات البرمجة الوظيفية المختلفة تراكيب مختلفة لكتابة الدوال.

اقرأ المزيد حول الدوال [هنا](Statements%20and%20Functions/readme.md#functions)



## [هياكل البيانات](Data%20Structures/readme.md)
في علم الحاسوب، هيكل البيانات هو تنظيم البيانات وإدارتها وتنسيق تخزينها الذي يتيح الوصول الفعال والتعديل. بدقة أكبر، هيكل البيانات هو مجموعة من قيم البيانات، والعلاقات بينها، والوظائف أو العمليات التي يمكن تطبيقها على البيانات.

### أنواع هياكل البيانات
- [المصفوفة](Data%20Structures/readme.md#array)
- [القائمة المتسلسلة](Data%20Structures/readme.md#linkedlist)
- [المكدس](Data%20Structures/readme.md#stack)
- [الصف](Data%20Structures/readme.md#queue)
- [جدول التجزئة](Data%20Structures/readme.md#hashtable)
- [الكومة](Data%20Structures/readme.md#heap)
- [الشجرة](Data%20Structures/readme.md#tree)
- [الرسم البياني](Data%20Structures/readme.md#graph)

## [الخوارزميات](Algorithms/readme.md)
الخوارزميات هي مجموعات الخطوات اللازمة لإكمال عملية الحساب. إنها في قلب ما تفعله أجهزتنا، وهذه ليست مفهومة جديدة. منذ تطور الرياضيات نفسها، كانت هناك حاجة إلى الخوارزميات لمساعدتنا في إكمال المهام بشكل أكثر كفاءة، ولكن اليوم سنلقي نظرة على بعض مشاكل الحوسبة الحديثة مثل الفرز والبحث في الرسوم البيانية ونظهر كيف قد جعلناها أكثر كفاءة حتى يمكنك العثور بسهولة أكبر على تذكرة طيران رخيصة أو توجيهات الخريف أو مطعم أو شيء من هذا القبيل.

### [تعقيد الوقت](Algorithms/Time%20Complexity/readme.md)
تقدير تعقيد الوقت للخوارزمية يقدر كم من الوقت ستستخدم الخوارزمية لإدخال معين. الفكرة هي تمثيل الكفاءة كوظيفة يكون معلمها حجم الإدخال. من خلال حساب تعقيد الوقت، يمكننا تحديد ما إذا كانت الخوارزمية سريعة بما فيه الكفاية دون تنفيذها.

### [تعقيد المساحة](Algorithms/Space%20Complexity/readme.md)
تشير تعقيد المساحة إلى الكمية الإجمالية من الذاكرة التي يستخدمها الخوارزمية/البرنامج، بما في ذلك مساحة القيم الإدخال للتنفيذ. حساب المساحة التي تشغلها المتغيرات في الخوارزمية/البرنامج لتحديد تعقيد المساحة.

### [الفرز](Algorithms/Sorting/readme.md)
الفرز هو عملية ترتيب قائمة من العناصر بترتيب معين. على سبيل المثال، إذا كانت لديك قائمة بأسماء، قد ترغب في فرزها ترتيباً أبجدياً. بالمثل، إذا كانت لديك قائمة من الأرقام، قد ترغب في وضعها في ترتيب من الأصغر إلى الأكبر. الفرز هو مهمة شائعة، وهي واحدة يمكننا أن نفعلها بطرق عديدة مختلفة.

### [البحث](Algorithms/Searching/readme.md)
البحث هو خوارزمية للعثور على عنصر معين داخل حاوية. تم تصميم خوارزميات البحث لفحص العنصر أو استرجاع العنصر من أي هيكل بيانات يتم تخزينه فيه.

### [الخوارزميات القائمة على السلاسل](Algorithms/String%20Based%20Algorithms/readme.md)
السلاسل هي واحدة من أهم وأكثر الهياكل البيانية استخداماً وأهمية في البرمجة، يحتوي هذا المستودع على بعض الخوارزميات الأكثر استخداماً التي تساعد في تحسين وقت البحث بسرعة في الشفرة الخاصة بنا.

### [بحث الرسم البياني](Algorithms/Graph/readme.md)
بحث الرسم البياني هو عملية البحث من خلال الرسم البياني للعثور على عقدة معينة. الرسم البياني هو هيكل بيانات يتكون من مجموعة محدودة (وقابلة للتغيير ربما) من الرؤوس أو العقد أو النقاط، جنبًا إلى جنب مع مجموعة من الأزواج غير المرتبة من هذه الرؤوس للرسم البياني غير الموجه أو مجموعة من الأزواج المرتبة للرسم البياني الموجه. وتُعرف هذه الأزواج أيضًا باسم الحواف أو الأقواس أو الخطوط للرسم البياني غير الموجه، وكأسهم أو الحواف الموجهة أو الأقواس الموجهة أو الخطوط الموجهة للرسم البياني الموجه. قد تكون الرؤوس جزءًا من هيكل الرسم البياني أو قد تكون كيانات خارجية يتم تمثيلها بمؤشرات أو مراجع عددية. الرسوم البيانية هي واحدة من أكثر هياكل البيانات فائدة للعديد من التطبيقات الحقيقية. يتم استخدام الرسوم البيانية لنمذجة العلاقات الزوجية بين الكائنات. على سبيل المثال، شبكة طرق الطيران هي رسم بياني حيث تكون المدن هي الرؤوس، ومسارات الرحلات هي الحواف. كما يتم استخدام الرسوم البيانية لتمثيل الشبكات. يمكن تصور الإنترنت كرسم بياني حيث تكون الحواسيب هي الرؤوس، والروابط بين الحواسيب هي الحواف. يتم استخدام الرسوم البيانية أيضًا على الشبكات الاجتماعية مثل LinkedIn و Facebook. تُستخدم الرسوم البيانية لتمثيل العديد من التطبيقات الحقيقية: شبكات الكمبيوتر، تصميم الدوائر، وجداول الجدول الزمني للطيران لذكر بعض الأمثلة فقط.

### [البرمجة الديناميكية](Algorithms/Dynamic%20Programming/README.md)
البرمجة الديناميكية هي طريقة تحسين رياضية وطريقة برمجية لحل المشكلات. طور ريتشارد بيلمان هذه الطريقة في الخمسينات ووجدت تطبيقات في مجالات عديدة، من هندسة الفضاء إلى الاقتصاد. في كلتا السياقين، يشير إلى تبسيط مشكلة معقدة عن طريق تقسيمها إلى مشاكل فرعية أبسط بطريقة تكرارية. بينما لا يمكن تقسيم بعض مشاكل القرار بهذه الطريقة، فإن القرارات التي تمتد عبر عدة نقاط في الوقت غالباً ما تنقسم تلقائياً. وبالمثل، في علم الحاسوب، إذا كان بإمكان حل مشكلة عن طريق تقسيمها إلى مشاكل فرعية ومن ثم العثور على الحلول الأمثل للمشاكل الفرعية بطريقة تكرارية، فإنه يعتبر أن يكون لديها بنية فرعية مثلى. البرمجة الديناميكية هي وسيلة واحدة لحل المشكلات ذات هذه الخصائص. يُطلق عملية تقسيم مشكلة معقدة إلى مشاكل فرعية أبسط اسم "التقسيم والفتح".

### [الخوارزميات الجشعة](Algorithms/Greedy%20Algorithm/readme.md)
الخوارزميات الجشعة هي فئة بسيطة وبديهية من الخوارزميات يمكن استخدامها للعثور على الحلاول الأمثل لبعض مشاكل الأمثلة. يتم تسميتها جشعة لأنها في كل خطوة تقوم بالاختيار الذي يبدو أفضل في ذلك اللحظة. وهذا يعني أن الخوارزميات الجشعة لا تضمن إرجاع الحلاول الأمثل على مستوى عالمي ولكنها تجعل اختيارات محلياً أفضل في الأمل في العثور على الحد الأقصى العالمي. تستخدم الخوارزميات الجشعة لمشاكل الأمثلة. يمكن حل مشكلة الأمثلة إذا كان بإمكاننا في كل خطوة أن نجعل اختيار يبدو الأفضل في ذلك الوقت، ونحصل على الحل الأمثل للمشكلة بأكملها.

### [التراجع](Algorithms/Backtracking/README.md)
التراجع هو تقنية خوارزمية لحل المشاكل بشكل متكرر عن طريق محاولة بناء الحلاول تدريجياً، قطعة واحدة في كل مرة، وإزالة تلك الحلول التي تفشل في تحقيق شروط المشكلة في أي نقطة في الوقت (وبحدود الزمن هنا، يتم الإشارة إلى الوقت المنقضي حتى الوصول إلى أي مستوى من شجرة البحث).


### [فرع وربط](Algorithms/Branch%20and%20Bound/README.md)
الفرع والربط هو تقنية عامة لحل مشاكل الأمثلة التنظيمية المحسابية. إنها تقنية تعدادية منهجية تقلل من عدد الحلاول المرشحة باستخدام هيكل المشكلة للقضاء على الحلاول المرشحة التي لا يمكن أن تكون بالضرورة الأمثل.

### [وقت التعقيد ومساحة التعقيد لخوارزميات البحث والترتيب المختلفة](Not-Added)

**وقت التعقيد**: يُعرف باعتباره عدد مرات تنفيذ مجموعة معينة من التعليمات من المتوقع أن يتم تنفيذها بدلاً من الوقت الإجمالي المستغرق. نظرًا لأن الوقت هو ظاهرة تعتمد على عوامل خارجية، قد يختلف وقت التعقيد بناءً على بعض العوامل الخارجية مثل سرعة المعالج، والمترجم المستخدم، وما إلى ذلك.

**مساحة التعقيد**: هي المساحة الكلية في الذاكرة التي تستهلكها البرنامج لتنفيذه.

كلاهما يتم حسابه كدالة لحجم الإدخال (n). يتم التعبير عن وقت التعقيد للخوارزمية بوسائل الـ "O الكبيرة".

كفاءة الخوارزمية تعتمد على هذين المعلمتين.

أنواع وقت التعقيد:

- *أفضل وقت تعقيد*: الإدخال الذي تستغرق فيه الخوارزمية وقتًا أقل أو الحد الأدنى من الوقت. في أفضل الحالات، نحسب التعقيد الحد السفلي للخوارزمية. على سبيل المثال: إذا كانت البيانات التي يتعين البحث عنها موجودة في الموقع الأول من مصفوفة بيانات كبيرة في البحث الخطي، فإن أفضل الحالات تحدث.
- *وقت تعقيد متوسط*: نأخذ جميع الإدخالات العشوائية ونحسب وقت الحساب لجميع الإدخالات. ثم نقوم بقسمته على العدد الإجمالي للإدخالات.
- *أسوأ وقت تعقيد*: تعريف الإدخال الذي يستغرق فيه الخوارزمية وقتًا طويلاً أو الحد الأقصى من الوقت. في أسوأ الحالات، نحسب الحد الأعلى للخوارزمية. مثال: إذا كانت البيانات التي يتعين البحث عنها موجودة في الموقع الأخير من مصفوفة بيانات كبيرة في خوارزمية البحث الخطي، فإن الحالة الأسوأ تحدث.

بعض الخوارزميات الشائعة لوقت التعقيد هي:

- **O(1)**: يعني هذا الوقت الثابت. O(1) يعني عادة أن لدى الخوارزمية وقتًا ثابتًا بغض النظر عن حجم الإدخال. خرائط الهاش هي أمثلة مثالية على الوقت الثابت.

- **O(log n)**: يعني هذا الوقت اللوغاريتمي. O(log n) يعني الانخفاض مع كل حالة للعمليات. البحث عن العناصر في أشجار البحث الثنائي (BSTs) هو مثال جيد على الوقت اللوغاريتمي.

- **O(n)**: يعني هذا الوقت الخطي. O(n) يعني أن الأداء يتناسب بشكل مباشر مع حجم الإدخال. ببساطة، عدد الإدخالات والوقت الذي يستغرقه تنفيذ تلك الإدخالات سيكون متناسبًا. البحث الخطي في المصفوفات هو مثال رائع على تعقيد الوقت الخطي.

- **O(n*n)**: يعني هذا الوقت التربيعي. O(n^2) يعني أن الأداء يتناسب بشكل مباشر مع مربع الإدخال المأخوذ. ببساطة، سيستغرق الوقت الذي يستغرقه التنفيذ حوالي مربع مرات حجم الإدخال. الحلقات المتداخلة هي أمثلة مثالية على تعقيد الوقت التربيعي.

- **O(n log n)**: يعني هذا تعقيد الوقت السياسي. O(n log n) يعني أن الأداء يضاعف n مرات من O(log n)، (والذي هو أسوأ حالة تعقي

د). مثال جيد سيكون لخوارزميات القسمة والفتح مثل فرز الدمج. تقوم هذه الخوارزمية أولاً بتقسيم المجموعة، مما يستغرق وقتًا O(log n)، ثم تغزو وترتب من خلال المجموعة، مما يستغرق وقتًا O(n) - لذا يستغرق فرز الدمج وقتًا O(n log n).

| الخوارزمية     |             |  وقت التعقيد   |           | مساحة التعقيد |
|   :---:         |  :---:      |  :---: 	    |   :---: 	   |   :---:          |
|  	              | الأفضل     | المتوسط    |  الأسوأ	   | الأسوأ          |
| فرز الاختيار   | Ω(n^2)	     | θ(n^2)	     | O(n^2)	     | O(1)             |
| فرز الفقاعة	   | Ω(n)	     | θ(n^2)	     | O(n^2)	     | O(1)             |
| فرز الإدراج    | Ω(n)	     | θ(n^2)	     | O(n^2)	     | O(1)             |
| فرز الهرم	     | Ω(n log(n)) | θ(n log(n)) | O(n log(n)) | O(1)             |
| فرز السريع	   | Ω(n log(n)) | θ(n log(n)) | O(n^2)	     | O(n)             |
| فرز الدمج	   | Ω(n log(n)) | θ(n log(n)) | O(n log(n)) | O(n)             |
| فرز الدلو	     | Ω(n +k)	   | θ(n +k)	   | O(n^2)	     | O(n)             |
| فرز الأساس	   | Ω(nk)	     | θ(nk)	     | O(nk)	     | O(n + k)         |
| فرز العداد	   | Ω(n +k)	   | θ(n +k)	   | O(n +k)	   | O(k)             |
| فرز الصدفة	   | Ω(n log(n)) | θ(n log(n)) | O(n^2)	     | O(1)             |
| فرز تيم	     | Ω(n)	       | θ(n log(n)) | O(n log(n)) | O(n)             |
| فرز الشجرة	   | Ω(n log(n)) | θ(n log(n)) | O(n^2)	     | O(n)             |
| فرز المكعب	   | Ω(n)	       | θ(n log(n)) | O(n log(n)) | O(n)             |

| الخوارزمية     |             |  وقت التعقيد   |	     |
|   :---:         |  :---:      |  :---: 	    |   :---: 	   |  
|  	              | الأفضل     | المتوسط    |  الأسوأ	   |
| البحث الخطي    | O(1)	       | O(N)	     | O(N)	       | O(1)  |
| البحث الثنائي	 | O(1)	       | O(logN)   | O(logN)	   |


## [آلان تورنج](Not-Added)

آلان تورنج (وُلد في 23 يونيو 1912، لندن، إنجلترا - توفي في 7 يونيو 1954، ويلمسلو، تشيشير) كان عالم رياضيات ومنطقي إنجليزي. درس في جامعة كامبريدج ومعهد برنستون للدراسات المتقدمة. في ورقته الرائدة لعام 1936 "على الأعداد الحسابية القابلة للحساب"، أثبت أنه لا يمكن وجود أي طريقة حسابية عالمية لتحديد الحقيقة في الرياضيات وأن الرياضيات ستحتوي دائمًا على عبارات غير قابلة للحسم (بدلاً من غير معروفة). قدمت هذه الورقة أيضًا الآلة تورنج. وكان يعتقد أن الحواسب في نهاية المطاف ستكون قادرة على التفكير لا يميزها عن تفكير الإنسان واقترح اختبارًا بسيطًا (انظر اختبار تورنج) لتقييم هذه القدرة. تعتبر ورقاته في هذا الموضوع معترف بها على نطاق واسع كأسس للبحث في الذكاء الاصطناعي. قام بعمل قيم في علم الكريبتولوجيا خلال الحرب العالمية الثانية، ولعب دورًا مهمًا في كسر رمز إنيجما الذي استخدمته ألمانيا لاتصالات الراديو. بعد الحرب، عمل في جامعة مانشستر وبدأ العمل في ما يعرف الآن بالذكاء الاصطناعي. وفي وسط هذا العمل ال

رائد، عُثر على تورنج ميتًا في سريره، مسمومًا بالسيانيد. تلت على وفاته اعتقاله بتهمة عمل مثلي الجنس (وقتها جريمة) وحكم عليه بـ 12 شهرًا من العلاج بالهرمون.

بعد حملة عامة في عام 2009، قدم رئيس الوزراء البريطاني غوردون براون اعتذارًا رسميًا نيابة عن الحكومة البريطانية عن الطريقة المروعة التي تم فيها معاملة تورنج. منحت الملكة إليزابيث الثانية عفوًا ما بعد الوفاة في عام 2013. يُستخدم مصطلح "قانون آلان تورنج" الآن بشكل غير رسمي للإشارة إلى قانون صدر في عام 2017 في المملكة المتحدة يعفي تحته الرجال الذين تم تحذيرهم أو محكوم عليهم بموجب التشريعات التاريخية التي جرمت الأفعال المثلية.

لدى تورنج إرث واسع يتمثل في تماثيل له والعديد من الأشياء التي أطلقت عليه اسمه، بما في ذلك جائزة سنوية للابتكارات في علوم الحاسوب. يظهر في العنصر الحالي لبنك إنجلترا بقيمة 50 جنيهًا إسترلينيًا، الذي تم إصداره في 23 يونيو 2021، للتزامن مع عيد ميلاده. في سلسلة عام 2019 على قناة بي بي سي، اختاره الجمهور كأعظم شخصية في القرن العشرين. 


## [هندسة البرمجيات](Software%20Engineering/readme.md)

هندسة البرمجيات هي فرع من علوم الحاسوب يتعامل مع تصميم وتطوير واختبار وصيانة تطبيقات البرمجيات. يقوم مهندسو البرمجيات بتطبيق مبادئ الهندسة والمعرفة بلغات البرمجة لبناء حلاً برمجياً للمستخدمين النهائيين.

دعونا نلقي نظرة على التعاريف المختلفة لهندسة البرمجيات:

- في المعيار رقم 610.12-1990 من IEEE، تعرف هندسة البرمجيات بأنها تطبيق لأسلوب منهجي ومنضبط والذي هو أسلوب قابل للحساب لتطوير وتشغيل وصيانة البرمجيات.
- وصف فريتز باور أنها "إنشاء واستخدام مبادئ الهندسة القياسية. إنه يساعدك على الحصول على برمجيات اقتصادية تعمل بشكل موثوق وبكفاءة على الأجهزة الحقيقية.
- يعرف بوهم الهندسة البرمجية على أنها تشمل "التطبيق العملي للمعرف

ة العلمية في تصميم وبناء البرامج الحاسوبية. تشمل أيضًا الوثائق المرتبطة اللازمة لتطويرها وتشغيلها وصيانتها".

### مهام ومسؤوليات مهندس البرمجيات

يعرف المهندسون الناجحون كيفية استخدام لغات البرمجة والمنصات والهندسات الصحيحة لتطوير كل شيء بدءًا من ألعاب الكمبيوتر حتى أنظمة التحكم في الشبكات. بالإضافة إلى بناء نظمهم الخاصة، يقوم مهندسو البرمجيات أيضًا باختبار وتحسين وصيانة البرمجيات التي تم بناؤها من قبل مهندسين آخرين.

في هذا الدور، قد تتضمن مهامك اليومية ما يلي:

- تصميم وصيانة أنظمة البرمجيات
- تقييم واختبار برامج الكمبيوتر الجديدة
- تحسين البرمجيات من أجل السرعة وقابلية التوسع
- كتابة واختبار الشفرة
- الاستشارة مع العملاء والمهندسين وأخصائيي الأمان وأصحاب المصلحة الآخرين
- تقديم ميزات جديدة لأصحاب المصلحة والعملاء الداخليين

### مراحل هندسة البرمجيات

يتضمن عملية هندسة البرمجيات عدة مراحل، بما في ذلك جمع المتطلبات، والتصميم، والتنفيذ، والاختبار، والصيانة. من خلال اتباع نهج منهجي لتطوير البرمجيات، يمكن لمهندسي البرمجيات إنشاء برمجيات عالية الجودة تلبي احتياجات مستخدميها.

- تشمل المرحلة الأولى من هندسة البرمجيات جمع المتطلبات. في هذه المرحلة، يعمل مهندس البرمجيات مع العميل لتحديد الاحتياجات الوظيفية وغير الوظيفية للبرمجيات. تصف الاحتياجات الوظيفية ما يجب أن تفعله البرمجيات، بينما تصف الاحتياجات غير الوظيفية مدى جودتها في القيام بذلك. إن جمع المتطلبات مرحلة حرجة، حيث تمثل أساس عملية تطوير البرمجيات بأكملها.

- بعد جمع المتطلبات، تأتي المرحلة التالية وهي التصميم. في هذه المرحلة، يقوم مهندس البرمجيات بإنشاء خطة مفصلة لهندسة البرمجيات بما في ذلك البنية والوظائف. تتضمن هذه الخطة وثيقة تصميم البرمجيات التي تحدد الهيكل والسلوك والتفاعلات مع الأنظمة الأخرى. إن وثيقة تصميم البرمجيات أمر أساسي حيث تعتبر مخططًا لمرحلة التنفيذ.

- مرحلة التنفيذ هي المرحلة التي يقوم فيها مهندس البرمجيات بإنشاء الشيفرة الفعلية للبرمجيات. هذه هي المرحلة التي يتم فيها تحويل وثيقة التصميم إلى برمجيات قابلة للتشغيل. تشمل مرحلة التنفيذ كتابة الشيفرة، وتجميعها، واختبارها للتأكد من أنها ت

لبي الاحتياجات المحددة في وثيقة التصميم.

- الاختبار هو مرحلة حاسمة في هندسة البرمجيات. في هذه المرحلة، يقوم مهندس البرمجيات بالتحقق من أن البرمجيات تعمل بشكل صحيح، وأنها موثوقة وسهلة الاستخدام. يتضمن ذلك عدة أنواع من الاختبارات، بما في ذلك اختبار الوحدة، واختبار الدمج، واختبار النظام. يضمن الاختبار أن تلبي البرمجيات الاحتياجات وتعمل كما هو متوقع.

- المرحلة النهائية من هندسة البرمجيات هي المرحلة الصيانة. في هذه المرحلة، يقوم مهندس البرمجيات بإجراء تغييرات على البرمجيات لتصحيح الأخطاء، أو إضافة ميزات جديدة، أو تحسين أدائها. إن الصيانة هي عملية مستمرة تستمر طوال عمر البرمجيات.

### لماذا أصبحت هندسة البرمجيات شائعة؟

- علوم الحاسوب: تعطي الأسس العلمية للبرمجيات كما أن الهندسة الكهربائية تعتمد بشكل رئيسي على الفيزياء.
- علم الإدارة: هندسة البرمجيات تعتمد بشكل كبير على العمالة وتتطلب السيطرة التقنية والإدارية. لذلك يتم استخدامها على نطاق واسع في علم الإدارة.
- الاقتصاد: في هذا القطاع، تساعدك هندسة البرمجيات في تقدير الموارد ومراقبة التكاليف. يجب تطوير نظام حوسبة، ويجب الحفاظ على البيانات بانتظام داخل ميزانية معينة.
- هندسة النظم: معظم البرمجيات هي جزء من نظام أكبر بكثير. على سبيل المثال، البرمجيات في نظام مراقبة الصناعة أو برمجيات الطيران على الطائرة. يجب تطبيق أساليب هندسة البرمجيات على دراسة هذا النوع من النظام.

# الدوائر المتكاملة

الدائرة المتكاملة أو الدائرة المتكاملة الوحيدة (المعروفة أيضًا باسم IC، شريحة، أو رقاقة دقيقة) هي مجموعة من الدوائر الإلكترونية على قطعة صغيرة مسطحة واحدة (أو "شريحة") من مادة نصف موصلية، عادةً السيليكون. تتكامل العديد من الترانزستورات MOSFET الصغيرة (الترانزستورات ذات الحقل المعدني - أكسيد - نصف موصلي) في شريحة صغيرة. ويؤدي ذلك إلى دوائر أصغر بأمراض من مرات وأسرع وأقل تكلفة من تلك التي تم بناؤها من مكونات إلكترونية منفصلة. إمكانية إنتاج الدوائر المتكاملة بكميات كبيرة وموثوقية الدائرة المتكاملة ونهج تصميم الدائرة المتكاملة على شكل كتلة بناءً على وحدات تأكيد اعتماد الدوائر المتكاملة القياسية بسرعة بدلاً من الترانزستورات المنفصلة. تستخدم الدوائر المتكاملة الآن في جميع أجهزة الإلكترونيات تقريبًا وقد ثورت على عالم الإلكترونيات. الحواسيب والهواتف المحمولة والأجهزة المنزلية الأخرى هي الآن أجزاء لا يمكن الفصل عنها من بنية المجتمعات الحديثة، وذلك بفضل الحجم الصغير والتكلفة المنخفضة للدوائر المتكاملة مثل معالجات الحاسوب الحديثة والمتحكمات الدقيقة.

تم تمكين تكامل الحجم الكبير جداً بفضل التقدم التكنولوجي في تصنيع الأجهزة الشبه موصلة ذات الأكسيد المعدني (MOS). منذ نشأتها في الستينيات، تقدمت حجم الشرائح وسرعتها وسعتها بشكل هائل، بفضل التطورات التقنية التي تمكن من وضع المزيد والمزيد من ترانزستورات MOS على شرائح نفس الحجم - يمكن أن تحتوي شريحة حديثة على مليارات من ترانزستورات MOS في منطقة حجمها مثل أظفار الإنسان. هذه التقدمات، التي تتبع تقريباً قانون مور، تجعل شرائح الحاسوب الحديثة تمتلك قدرات تزيد عن ملايين مرات من قدرات شرائح الحاسوب في بدايات السبعينيات.

الدوائر المتكاملة لديها مزايا رئيسيتين

 على الدوائر المنفصلة: التكلفة والأداء. التكلفة منخفضة لأن الشرائح، مع جميع مكوناتها، تُطبع كوحدة باستخدام تقنية تصوير الضوء بدلاً من بناء الترانزستور واحد تلو الآخر. علاوة على ذلك، تستخدم الدوائر المتكاملة المعبأة الكثير أقل من المواد مقارنة بالدوائر المنفصلة. الأداء عالي لأن مكونات الدائرة المتكاملة تتحول بسرعة وتستهلك قدراً قليلاً من الطاقة بسبب حجمها الصغير وقربها. العيب الرئيسي للدوائر المتكاملة هو التكلفة العالية لتصميمها وتصنيع الأقنعة الضوئية اللازمة. هذه التكلفة الابتدائية العالية تعني أن الدوائر المتكاملة تكون تجارياً قابلة للتحقق فقط عندما يتوقع حجم إنتاج عال.

### أنواع الدوائر المتكاملة

يصنف موزعوا المكونات الإلكترونية الحديثة الدوائر المتكاملة بشكل أدق عادةً:

- الدوائر المتكاملة الرقمية تصنف كدوائر منطقية (مثل المعالجات الدقيقة ووحدات التحكم الدقيقة)، وذاكرة الشرائح (مثل الذاكرة MOS والذاكرة ذات البوابة العائمة)، ووحدات الواجهة (محولات مستوى الجهد، محول/فك تسلسلي، إلخ)، ووحدات إدارة الطاقة، والأجهزة القابلة للبرمجة.
- الدوائر المتكاملة التماثلية تصنف كدوائر متكاملة خطية ودوائر RF (دوائر التردد الراديوي).
- الدوائر المتكاملة مزيج الإشارات تصنف كدوائر اكتساب البيانات (محولات A/D، محولات D/A، والمقاومات البوتنشيومترية الرقمية)، ودوائر الساعة/التوقيت، ودوائر تيار متغير (SC)، ودوائر RF CMOS.
- الدوائر المتكاملة ثلاثية الأبعاد (3D ICs) تصنف إلى دوائر عبر الفيا السيليكون (TSV) ودوائر الاتصال Cu-Cu.

## البرمجة الشيئية الموجهة

البرمجة الشيئية الموجهة هي نمط أساسي للبرمجة يعتمد على مفاهيم الكائنات والبيانات.

إنها الطريقة القياسية للكود التي يجب على كل مبرمج أن يلتزم بها لتحسين قابلية القراءة وإعادة استخدام الكود.

### * هناك أربعة مفاهيم أساسية للبرمجة الشيئية الموجهة:

- التجريد
- التجميع
- الوراثة
- البوليمورفيزم

اقرأ المزيد حول هذه المفاهيم في [هذا الرابط](Object%20Oriented%20Programming/readme.md)

## البرمجة الوظيفية

في علم الحاسوب، البرمجة الوظيفية هي نمط للبرمجة حيث يتم بناء البرامج عن طريق تطبيق وتركيب الوظائف. إنها نمط للبرمجة الوظيفية حيث تعتبر تعريفات الوظائف شجرة من التعبيرات التي تعيد تعيين القيم إلى قيم أخرى، بدلاً من تسلسل البيانات الأمرية التي تحدث تحديث حالة التشغيل للبرنامج.

في البرمجة الوظيفية، تُعامل الوظائف كمواطنين من الدرجة الأولى، وهذا يعني أنه يمكن ربطها بالأسماء (بما في ذلك المعرفات المحلية)، وتمريرها كوسائط، وإرجاعها من وظائف أخرى، تمامًا مثل أي نوع آخر

 من البيانات. وهذا يسمح بكتابة البرامج بأسلوب تصريحي ومركب، حيث تجمع الوظائف الصغيرة بطريقة وحداتية.

تعتبر البرمجة الوظيفية في بعض الأحيان مترادفة مع البرمجة الوظيفية النقية، وهي مجموعة فرعية من البرمجة الوظيفية التي تعتبر جميع الوظائف كوظائف رياضية حاسمة غير متغيرة، أو وظائف نقية. عند استدعاء وظيفة نقية مع بعض الوسائط المعطاة، ستعيد دائمًا نفس النتيجة، ولا يمكن أن يتأثر أي منها بأي حالة قابلة للتغيير أو آثار جانبية أخرى. يدعي أنصار البرمجة الوظيفية النقية أنه من خلال تقييد الآثار الجانبية، يمكن أن تكون البرامج أقل توقفاً، وأسهل لتصحيح الأخطاء واختبارها، وأنها تكون أكثر ملاءمة لإجراءات التحقق الشكلي.

تتمتع البرمجة الوظيفية بجذورها في الأوساط الأكاديمية، حيث تطورت من حسابات لامبدا، وهو نظام رسمي للحسابات يعتمد فقط على الوظائف. وكثيرًا ما يُطلق عليه "أصغر لغة برمجية في العالم". إنه يوفر تعريفًا لما يمكن حسابه وما لا يمكن. إنه مكافئ لآلة تورينغ في قدراتها الحسابية وأي شيء قابل للحساب بواسطة الحسابات لامبدا، تمامًا مثل أي شيء قابل للحساب بواسطة آلة تورينغ، هو قابل للحساب. إنه يوفر الإطار النظري لوصف الوظائف وتقييماتها.

بعض المفاهيم الأساسية للبرمجة الوظيفية هي:

- الوظائف النقية
- الاستدعاء المتكرر
- الشفافية الإشارية
- الوظائف كمواطنين من الدرجة الأولى والوظائف عالية الرتبة
- المتغيرات غير قابلة للتغيير.

**الوظائف النقية**: هذه الوظائف لديها خاصيتان رئيسيتان. أولاً، إنها تنتج دائمًا نفس الناتج لنفس الوسائط بغض النظر عن أي شيء آخر. ثانياً، ليس لديها آثار جانبية. أي أنها لا تعديل أي وسيطات أو متغيرات محلية/عالمية أو تيارات إدخال/إخراج. الخاصية الثانية تسمى *عدم التغيير*. النتيجة الوحيدة للوظيفة النقية هي القيمة التي تعيدها. إنها تكون حاسمة. البرامج التي تم إجراؤها باستخدام البرمجة الوظيفية سهلة التصحيح لأنها ليست لديها آثار جانبية أو إدخال/إخراج مخفي. تجعل الوظائف النقية أيضًا من السهل كتابة التطبيقات المتوازية/المتزامنة. عندما يتم كتابة الكود بهذا النمط، يمكن للمترجم الذكي أن يفعل الكثير من الأشياء - يمكنه توازيع التعليمات، والانتظار لتقييم النتائج حتى تحتاج إليها، وتذكير النتائج لأن النتائج لا تتغير طالما لا تتغير الإدخال. فيما يلي مثال بسيط على وظيفة نقية في Python:

```python
def sum(x, y): # الجمع هو وظيفة تأخذ x و y كوسائط
    return x + y  # تعيد x + y دون تغيير القيمة
 ```

**الاستدعاء المتكرر**: لا توجد حلقات "for" أو "while" في لغات البرمجة الوظيفية النقية. يتم تنفيذ الت

كرار من خلال الاستدعاء المتكرر للوظائف. تقوم الوظائف المتكررة بدعوة أنفسها مرارًا وتكرارًا حتى يتم الوصول إلى حالة أساسية. فيما يلي مثال بسيط على وظيفة متكررة في لغة C:

```c
int fib(n) {
  if(n <= 1)
    return 1;
   else
     return (fib(n-1) + fib(n-2));
}
 ```

**الشفافية الإشارية**: في البرمجة الوظيفية، لا تتغير قيم المتغيرات بمجرد تعريفها. البرامج الوظيفية لا تحتوي على تعليمات التعيين. إذا كان لدينا لتخزين قيمة ما، نقوم بتعريف متغير جديد بدلاً من ذلك. يلغي ذلك أي فرصة لحدوث آثار جانبية لأن أي متغير يمكن استبداله بقيمته الفعلية في أي نقطة من تنفيذ البرنامج. حالة أي متغير ثابتة في أي لحظة. مثال:

```bash
x = x + 1 # هذا يغير القيمة المخصصة للمتغير x
         # لذلك فإن التعبير ليس شفافيًا إشاريًا
```

**الوظائف كمواطنين من الدرجة الأولى والوظائف عالية الرتبة**: تعامل الوظائف كمتغيرات من الدرجة الأولى. يمكن تمرير المتغيرات من الدرجة الأولى إلى الوظائف كمعاملات، ويمكن إرجاعها من الوظائف الأخرى أو تخزينها في هياكل البيانات.

يمكن تعريف توصيلة من تطبيقات الوظائف باستخدام نموذج LISP يسمى **funcall**، والذي يأخذ كوسائط وظيفة وسلسلة من الوسائط ويطبق تلك الوظيفة على تلك الوسائط:

```Lisp
(defun filter (list-of-elements test)
    (cond ((null list-of-elements) nil)
          ((funcall test (car list-of-elements))
            (cons (car list-of-elements)
                (filter (cdr list-of-elements)
                      test)))
           (t (filter (cdr list-of-elements)
                       test))))
   ```
   تطبق وظيفة **filter** الاختبار على العنصر الأول من القائمة. إذا كان الاختبار يعيد قيمة غير صفرية، فإنها تضيف العنصر إلى ناتج filter الذي يتم تطبيقه على cdr من القائمة. في حالة عدم تحقق الشرط، يتم إعادة القائمة المفلترة cdr. يمكن استخدام هذه الوظيفة مع تحققات مختلفة تمرر كمعلمات لأداء مجموعة متنوعة من مهام التصفية:

```Lisp
    > (filter '(1 3 -9 5 -2 -7 6) #'plusp)   ; تصفية جميع الأرقام السالبة 
```    
    الناتج: (1 3 5 6)

```Lisp
   > (filter '(1 2 3 4 5 6 7 8 9) #'evenp)   ; تصفية جميع الأرقام الفردية
```   
   الناتج: (2 4 6 8)

   وهكذا.

**المتغيرات غير القابلة للتغيير**: في البرمجة الوظيفية، لا يمكننا تعديل متغير بعد تهيئته. يمكننا إنشاء متغيرات جديدة - ولكن لا يمكننا تعديل المتغيرات الحالية، وهذا يساعد حقًا في الحفاظ على الحالة طوال وقت التشغيل للبرنامج. بمجرد إنشاء متغير وتحديد قيمته، يمكننا أن نكون واثقين تمامًا من أن قيمة هذا المتغير لن تتغير أبدًا.

أنظمة التشغيل

يعمل نظام التشغيل (أو OS بشكل مختصر) كوسيط بين مستخدم الكمبيوتر وأجهزة الكمبيوتر. الهدف من نظام التشغيل هو توفير بيئة يمكن للمستخدم فيها تنفيذ البرامج بسهولة وكفاءة. نظام التشغيل هو برنامج يدير أجهزة الكمبيوتر. يجب على الأجهزة توفير آليات مناسبة لضمان عمل النظام بشكل صحيح ولمنع البرامج الخاصة بالمستخدم من التداخل مع عملية تشغيل النظام بشكل صحيح. تعرف تعريفًا أكثر شيوعًا أن نظام التشغيل هو البرنامج الوحيد الذي يعمل في جميع الأوقات على الكمبيوتر (يسمى عادة النواة)، مع كل شيء آخر هو برامج تطبيق.

يمكن رؤية أنظمة التشغيل من وجهتي نظر: مديري الموارد والأجهزة الموسعة. في وجهة نظر مدير الموارد، مهمة نظام التشغيل هي إدارة أجزاء مختلفة من النظام بكفاءة. في وجهة نظر الجهاز الموسع، فإن مهمة النظام هي توفير تجريدات للمستخدمين تكون أكثر سهولة في الاستخدام من الجهاز الفعلي. تشمل هذه العمليات العمليات، ومساحات العناوين، والملفات.

تاريخ أنظمة التشغيل

- **الجيل الأول (1945-55)**: لم يتم تحقيق تقدم يذكر في بناء الحواسيب الرقمية بعد جهود باباج حتى عصر الحرب العالمية الثانية. في جامعة ولاية آيوا، قام الأستاذ جون أتاناسوف وطالبه الخريج كليفورد بيري بإنشاء ما يعترف به اليوم كأول حاسوب رقمي تشغيلي. في برلين، قام كونراد زوز بإنشاء حاسوب Z3 باستخدام الريلايات الكهروميكانيكية في نفس الوقت. تم إنشاء العلامة الأولى من قبل هوارد آيكن في جامعة هارفارد، والكولوسس من قبل فريق من العلماء في بليتشلي بارك في إنجلترا، والإينياك من قبل وليام ماكولي وطالبه الدكتور ج. بريسبر إيكرت في جامعة بنسلفانيا في عام 1944.

- **الجيل الثاني (1955-65)**: غيّر اختراع الترانزستور في منتصف الخمسينيات تمامًا الوضع. أصبحت الحواسيب موثوقة بما فيه الكفاية حتى يمكن تصنيعها وبيعها للعملاء الدافعين على افتراض أنها ستستمر في العمل لفترة كافية لإجراء بعض الأعمال ذات الدلالة. تم إبقاء الحواسيب الكبيرة، وهي تلك الحواسيب التي توجد في قاعات الكمبيوتر المكيفة بشكل خاص، مغلقة في الغالب، مع وجود فرق من المشغلين المؤهلين لإدارتها. فقط الشركات الكبيرة والكيانات الحكومية الكبيرة أو المؤسسات يمكنها تحمل السعر البالغ عدة ملايين دولار.

- **الجيل الثالث (1965-80)**: بالمقارنة مع الحواسيب من الجيل الثاني التي تم بناؤها من الترانزستورات الفردية، كان IBM 360 هو الخط الرئيسي الأول الذي استخدم الدوائر المتكاملة الصغيرة (ICs). نتيجة لذلك، قدمت فوائد كبيرة من حيث السعر/الأداء. كانت ضربة ناجحة على الفور، وسارعت كل الشركات المصنعة الكبيرة لاعتماد فكرة عائلة من الحواسيب المتوافقة. من المفترض أن يكون جمي

ع البرمجيات، بما في ذلك نظام التشغيل OS/360، متوافقة مع جميع النماذج في التصميم الأصلي. كان يتعين عليها أن تعمل على الأنظمة الضخمة، التي غالباً ما كانت تحل محل 7094 للحسابات الثقيلة وتوقعات الطقس، والأنظمة الصغيرة، التي كانت في الغالب تحل محل 1401 لنقل البطاقات إلى الشريط. كانت هناك حاجة لأنظمة لتعمل جيدًا مع النظم الضخمة والنظم الصغيرة التي تحتوي على العديد من الأجهزة الفرعية والنظم التي تحتوي على عدد كبير من الأجهزة الفرعية.

- **الجيل الرابع (1980-اليوم)**: بدأت عصر الحواسيب الشخصية مع إنشاء دوائر التكامل الكبير (LSI) ، وهي معالجات تحتوي على الآلاف من الترانزستورات على سنتيمتر مربع من السيليكون. على الرغم من أن الحواسيب الشخصية، التي كانت تعرف في الأصل بالحواسيب الصغيرة، لم تتغير بشكل كبير في البنية عن الحواسيب الصغيرة من فئة PDP-11، إلا أنها اختلفت بشكل كبير من حيث السعر.

- **الجيل الخامس (1990-اليوم)**: منذ الأزمنة القديمة، كان الناس يتوقون لجهاز اتصال محمول، وذلك منذ أن بدأ المحقق ديك تريسي في الشريط الكوميدي في الأربعينات في التحدث عبر "ساعة اليد اللاسلكية ذات الاتجاهين". في عام 1946، ظهرت أول هاتف محمول حقيقي، وكان يزن حوالي 40 كيلوجرامًا. وكان أول هاتف محمول حقيقي ظهر في السبعينيات وكان خفيف الوزن بحوالي كيلوغرام واحد. كان يعرف على سبيل الدعابة بـ "الطوبة". سرعان ما بدأ الجميع في الصراخ من أجل واحد.

وظائف نظام التشغيل

- **الراحة**: يجعل نظام التشغيل الكمبيوتر أكثر راحة للاستخدام.
- **الكفاءة**: يسمح نظام التشغيل باستخدام موارد نظام الكمبيوتر بكفاءة.
- **القدرة على التطور**: يجب أن يتم بناء نظام التشغيل بحيث يسمح بتطوير واختبار وتقديم وظائف نظام جديدة بفعالية في نفس الوقت دون التداخل مع الخدمة.
- **الإنتاجية**: يجب بناء نظام التشغيل بحيث يمكنه تحقيق أقصى إنتاجية (عدد المهام في الوحدة الزمنية).

وظائف رئيسية لنظام التشغيل

- **إدارة الموارد**: عندما يحدث الوصول المتوازي في نظام التشغيل، ويعني عندما يقوم العديد من المستخدمين بالوصول إلى النظام، يعمل نظام التشغيل كمدير موارد. مسؤوليته هو توفير الأجهزة للمستخدم. يقلل من العبء في النظام.
- **إدارة العمليات**: يتضمن ذلك مهام مختلفة مثل جدولة وإنهاء العملية. يدير نظام التشغيل مهامًا متعددة في وقت واحد. هنا يحدث جدولة وحدة المعالجة المركزية وتعني أن جميع المهام ستتم باستخدام الخوارزميات التي تستخدم لجدولة.
- **إدارة التخزين**: آلية نظام الملفات المستخدمة لإدارة التخزين. نيفس، سيفس، كيفس، إن إف إس، وما إلى ذلك هي بعض نظم الملفات. يتم تخزين جميع البيانات في المسارات المختلفة لأقراص الصلب التي يتم إدارتها جميعها بواسطة مدير الت

خزين. يتضمن ذلك القرص الصلب.
- **إدارة الذاكرة**: تشير إلى إدارة الذاكرة الأساسية. يجب على نظام التشغيل تتبع كم من الذاكرة تم استخدامها ومن قبل من. يجب عليه أن يقرر أي عملية تحتاج إلى مساحة ذاكرة وكم. كما يتعين على نظام التشغيل أن يخصص ويحرر مساحة الذاكرة.
- **إدارة الأمان/الخصوصية**: يتم توفير الخصوصية أيضًا من قبل نظام التشغيل باستخدام كلمات مرور بحيث لا يمكن للتطبيقات غير المعتمدة الوصول إلى البرامج أو البيانات. على سبيل المثال، يستخدم Windows المصادقة Kerberos لمنع الوصول غير المصرح به إلى البيانات.

أنواع أنظمة التشغيل

- **أنظمة التشغيل للحواسيب الكبيرة**:
في الطرف العلوي من هذه الأنظمة تكمن أنظمة التشغيل للحواسيب الكبيرة، وهي تلك الحواسيب التي يتم العثور عليها لا تزال في مراكز بيانات الشركات الكبيرة. تختلف هذه الحواسيب عن الحواسيب الشخصية من حيث سعة الإدخال/الإخراج. ليس من غير المألوف أن يكون لدى الحاسوب الكبير مع 1000 قرص وملايين من غيغابايت البيانات؛ حاسوب شخصي بهذه المواصفات سيكون حسدًا لأصدقائه. تزداد أنظمة التشغيل للحواسيب الكبيرة توجهًا نحو معالجة العديد من المهام في وقت واحد، معظمها يحتاج إلى كميات هائلة من الإدخال/الإخراج. عادةً ما تقدم هذه الأنظمة ثلاثة أنواع من الخدمات: التجميع، معالجة المعاملات، ومشاركة الوقت.

- **أنظمة التشغيل للخوادم**:
على مستوى أدنى هي أنظمة التشغيل للخوادم. تعمل على الخوادم، والتي تكون إما حواسيب شخصية كبيرة جدًا، أو محطات عمل، أو حتى الحواسيب الكبيرة. إنها تخدم مستخدمين متعددين في وقت واحد عبر شبكة وتسمح للمستخدمين بمشاركة الموارد الأجهزة والبرمجيات. يمكن أن تقدم الخوادم خدمة الطباعة، أو خدمة الملفات، أو خدمة الويب. تدير مزودو الإنترنت العديد من آلات الخوادم لدعم عملائهم، وتستخدم مواقع الويب الخوادم لتخزين صفحات الويب ومعالجة الطلبات الواردة. الأنظمة التشغيل النموذجية للخوادم هي Solaris، FreeBSD، Linux، و Windows Server 201x.

- **أنظمة التشغيل للمعالجات المتعددة**:
أصبحت الطريقة المتزايدة شيوعًا للحصول على قوة حوسبة من الدوريات الكبرى هي ربط عدة وحدات معالجة مركزية في نظام واحد. اعتمادًا على الطريقة التي يتم بها الاتصال وما يتم مشاركته، يتم تسمية هذه الأنظمة بالحواسيب المتوازية، أو الحواسيب متعددة الحواسيب، أو المعالجات المتعددة. إنها تحتاج إلى أنظمة تشغيل خاصة، ولكن غالباً ما تكون هذه تعتمد على الأنظمة التشغيل للخوادم، مع ميزات خاصة للاتصال والتواصل والاتساق.

- **أنظمة التشغيل للحواسيب الشخصية**:
الفئة التالية هي نظام التشغيل للحواسيب الشخصية. تدعم كل الأنظمة الحديثة متعدد البرمجيات، غال

باً ما يشمل هذا نظام التشغيل. وهناك طبقات من البرمجيات توفر واجهة مستخدم. تقوم هذه الواجهات بإظهار النوافذ والأزرار والقوائم والمراجعات والرموز الصورية والأنماط والألوان والنصوص وغير ذلك الكثير. يمكن للمستخدمين العاديين استخدام هذه البرمجيات بسهولة، بينما يمكن للمستخدمين المحترفين القيام بالمزيد.

- **أنظمة التشغيل المدمجة**:
في ذروة هرم تعلم الحوسبة، تبدو الحواسيب أمرًا مربكًا في التصميم. في بعض الحالات، يمكن أن تكون الحواسيب الصغيرة جدًا والبسيطة جدًا لدرجة أنك تريد أن تعمل في جهاز واحد فقط لتجنب إضاعة الموارد. يتم برمجة هذه الأنظمة بحيث تكون قادرة على أداء وظائف معينة فقط.

من المهم أن نلاحظ أن هذه الأنظمة ليست متناغمة تمامًا. لا يمكن تشغيل برنامج مصمم للعمل على الحاسوب الشخصي على نظام التشغيل المضمن (والعكس صحيح). وهذا ببساطة لأنه يتوجب على كل نظام تشغيل أن يكون مخصصًا للقيام بأمور معينة. لا يمكن للحواسيب الكبيرة أن تستخدم الكثير من الوقت في تحميل الصفحات من شبكة الإنترنت بسبب الكم الهائل من البيانات اللازمة، ولا يمكن لأنظمة التشغيل المضمنة تحمل العديد من الصفحات والتطبيقات بسبب القيود المفروضة عليها من ناحية الذاكرة والمعالجة.


## الذاكرة والتخزين

### الذاكرة
مصطلح "الذاكرة" يشير إلى الجزء داخل حاسوبك الذي يسمح بالوصول الى البيانات على المدى القصير. قد تعرف هذا الجزء باسم DRAM أو الذاكرة العشوائية ذات الوصول الديناميكي. يقوم حاسوبك بتنفيذ العديد من العمليات من خلال الوصول إلى البيانات المخزنة في ذاكرته على المدى القصير. بعض أمثلة هذه العمليات تشمل تحرير وثيقة، تحميل التطبيقات وتصفح الإنترنت. تعتمد سرعة وأداء نظامك على كمية الذاكرة المثبتة في حاسوبك.

إذا كان لديك مكتب وخزانة ملفات، فيجسد المكتب الذاكرة في حاسوبك. يتم الاحتفاظ بالعناصر التي تحتاج إلى استخدامها على الفور على المكتب لسهولة الوصول. ومع ذلك، لا يمكن تخزين الكثير على المكتب بسبب حجمه المحدود.

### التخزين
بينما تشير الذاكرة إلى موقع البيانات على المدى القصير، فإن "التخزين" هو الجزء داخل حاسوبك الذي يسمح لك بتخزين البيانات على المدى الطويل والوصول إليها. عادةً ما يأتي التخزين على شكل وحدة تخزين ثابتة الحالة أو قرص صلب. يحتوي التخزين على تطبيقاتك، ونظام التشغيل، والملفات بشكل دائم. يحتاج الحواسيب إلى قراءة وكتابة المعلومات من نظام التخزين، لذا تحدد سرعة التخزين مدى سرعة بدء تشغيل النظام، وتحميل البيانات، والوصول إلى ما قمت بحفظه.

بينما يُجسد المكتب الذاكرة في الحاسوب، تُجسد الخزانة ملفات حاسوبك. إنها تحتوي على العناصر التي يتعين حفظها وتخزينها ولكنها ليست بالضرورة مطلوبة للوصول الفوري. حجم الخزانة يعني أنها يمكنها أن تحتوي على الكثير من الأشياء.

**الفرق الهام** بين الذاكرة والتخزين هو أن الذاكرة تمحى عند إيقاف تشغيل الحاسوب. من ناحية أخرى، يبقى التخزين سليماً بغض النظر عن مدى تكرار إيقاف تشغيل الحاسوب. لذا، في مقارنة المكتب والخزانة، سيتم رمي الملفات المتبقية على مكتبك عند مغادرتك للمكتب. كل ما هو في خزانتك سيظل.

### الذاكرة الظاهرية
في قلب أنظمة الحواسيب يكمن الذاكرة، المساحة التي تعمل فيها البرامج ويتم تخزين البيانات. ولكن ماذا يحدث عندما تتجاوز البرامج التي تقوم بتشغيلها والبيانات التي تعمل بها القدرة الفعلية لذاكرة الحاسوب؟ هنا يأتي دور

 الذاكرة الظاهرية، حيث تعمل كامتداد ذكي لذاكرة حاسوبك وتعزز قدراته.

**تعريف وغرض الذاكرة الظاهرية:**

الذاكرة الظاهرية هي تقنية إدارة الذاكرة توظفها أنظمة التشغيل لتجاوز قيود الذاكرة الفعلية (RAM). إنها تخلق وهماً لتطبيقات البرمجيات بأن لديها وصولاً إلى كمية أكبر من الذاكرة مما هو مثبت بدنياً على الحاسوب. في جوهرها، تمكّن البرامج من استخدام مساحة الذاكرة وراء حدود RAM الفعلية للحاسوب.

الغرض الرئيسي للذاكرة الظاهرية هو تمكين التعددية الفعالة وتنفيذ برامج أكبر، وذلك بينما يتم الحفاظ على استجابة النظام. يتحقق ذلك من خلال إنشاء تفاعل سلس بين RAM الفعلية وأجهزة التخزين الثانوية، مثل القرص الصلب أو SSD.

**كيف توسع الذاكرة الظاهرية الذاكرة الفعلية المتاحة:**

فكر في الذاكرة الظاهرية كجسر يربط بين RAM الفعلية في حاسوبك وتخزينه الثانوي (أقراص القرص). عند تشغيل برنامج، يتم تحميل أجزاء منه إلى الذاكرة الفعلية الأسرع (RAM). ومع ذلك، قد لا تُستخدم جميع أجزاء البرنامج على الفور.

تستغل الذاكرة الظاهرية هذا الوضع عن طريق نقل أقسام من البرنامج التي لا تستخدم بنشاط من RAM إلى التخزين الثانوي، مما يخلق مزيدًا من المساحة في RAM للأجزاء التي تستخدم بنشاط. هذه العملية شفافة للمستخدم والبرامج الجارية. عند الحاجة للأجزاء التي تم نقلها مرة أخرى، يتم استبدالها في RAM، في حين قد يتم نقل أجزاء أقل نشاطًا إلى التخزين الثانوي.

يدير نظام التشغيل عملية تبديل البيانات داخل وخارج الذاكرة الفعلية. يسمح للبرامج بالتشغيل حتى لو كانت أكبر من RAM المتاحة، حيث يقرر النظام بذكاء أي البيانات يجب أن تكون في RAM لتحقيق أداء مثالي.

في الختام، تعمل الذاكرة الظاهرية كطبقة افتراضية توسع الذاكرة الفعلية المتاحة عن طريق نقل أجزاء مؤقتة من البرامج والبيانات بين RAM والتخزين الثانوي. تضمن هذه العملية أن يمكن للحاسوب التعامل مع المهام الكبيرة والبرامج العديدة في نفس الوقت، وذلك بينما يحافظ على أداء فعال واستجابة فورية.

## [نظام الملفات](File%20System/readme.md)

في مجال الحوسبة، نظام الملفات هو الطريقة والهيكلية التي يستخدمها نظام التشغيل للتحكم في كيفية تخزين البيانات واسترجاعها. بدون نظام ملفات، سيكون لدى البيانات الموجودة في وسط تخزين ما حجم واحد كبير دون وجود وسيلة لمعرفة متى انتهت قطعة واحدة من البيانات أو أين كان موقع أي قطعة من البيانات عندما يكون من الوقت لاسترجاعها. من خلال فصل البيانات إلى قطع ومنح كل قطعة اسماً، يمكن عزل البيانات بسهولة وتحديدها. اسم كل مجموعة بيانات يُسمى "ملف". يُسمى الهيكل وقواعد الفهرسة المستخدمة لإدارة مجموعات البيانات وأسمائها "نظام ملفات".

هناك العديد

 من أنواع نظم الملفات، كل منها يأتي مع هيكل وقواعد مختلفة، وخصائص مثل السرعة، والمرونة، والأمان، والحجم، وغيرها. تم تصميم بعض نظم الملفات لاستخدامها في تطبيقات محددة. على سبيل المثال، نظام الملفات ISO 9660 مصمم خصيصاً للأقراص البصرية.

يمكن استخدام نظم الملفات على أنواع مختلفة من أجهزة التخزين باستخدام وسائط متنوعة. حتى عام 2019، كانت محركات الأقراص الصلبة هي الأجهزة الرئيسية للتخزين ومن المتوقع أن تظل كذلك في المستقبل المنظور. تشمل الوسائط الأخرى التي يتم استخدامها محركات الأقراص الصلبة ذات الحالة الصلبة، وأشرطة المغناطيسية، والأقراص البصرية. في بعض الحالات، مثل tmpfs، يقوم الذاكرة الرئيسية للحاسوب (RAM) بإنشاء نظام ملفات مؤقت للاستخدام على المدى القصير.

يُستخدم بعض نظم الملفات على أجهزة تخزين البيانات المحلية، بينما يوفر البعض الآخر وصولاً إلى الملفات عبر بروتوكول الشبكة (مثل NFS، SMB، أو عملاء 9P). بعض نظم الملفات هي "افتراضية"، مما يعني أن "الملفات" الواردة (تسمى الملفات الافتراضية) يتم حسابها حسب الطلب (مثل procfs وsysfs) أو تكون مجرد تعيين في نظام ملفات مختلف يستخدم كمخزن دعم. يدير نظام الملفات الوصول إلى محتوى الملفات والبيانات الوصفية حول تلك الملفات. إنه مسؤول عن ترتيب مساحة التخزين. يعتبر الأمان والكفاءة وضبط الأداء فيما يتعلق بوسائط التخزين الفعلية اعتبارات تصميم مهمة.

### كيفية عمل نظم الملفات
يخزن نظام ملفات وينظم البيانات ويمكن اعتباره نوعًا من الفهرس لكل البيانات الواردة في جهاز تخزين ما. يمكن أن تشمل هذه الأجهزة محركات الأقراص الصلبة ومحركات الأقراص البصرية ومحركات الفلاش.

تحدد نظم الملفات معايير لتسمية الملفات، بما في ذلك الحد الأقصى لعدد الأحرف في الاسم، والأحرف التي يمكن استخدامها، وفي بعض الأنظمة، مدى يمكن أن يكون لاحقة اسم الملف. في العديد من نظم الملفات، لا تكون أسماء الملفات حساسة لحالة الأحرف.

إلى جانب الملف نفسه، يحتوي نظام الملفات على معلومات مثل حجم الملف وسماته، وموقعه، وتسلسله في الدليل في البيانات الوصفية. يمكن أن تحدد البيانات الوصفية أيضًا الكتل الحرة من التخزين المتاحة على القرص وكم من المساحة متاحة.

يتضمن نظام ملفات أيضًا تنسيقًا لتحديد المسار إلى ملف من خلال هيكلية الدلائل. يتم وضع ملف في دليل - أو مجلد في نظام التشغيل Windows - أو دليل فرعي في المكان المطلوب في هيكل الشجرة. نظم تشغيل الحواسيب والهواتف المحمولة لديها نظم ملفات يتم وضع الملفات فيها في هيكل شجري تسلسلي.

قبل إنشاء الملفات والدلائل على وسيط التخزين، يجب وضع الأقسام في مكانها. القسم هو منطقة في القرص الصلب أو غيره من وسائط التخزين التي يديرها نظام الت

شغيل بشكل منفصل. يتم تضمين نظام ملفات واحد في القسم الرئيسي، وتسمح بعض أنظمة التشغيل بوجود عدة أقسام على قرص واحد. في هذا الوضع، إذا تعرض نظام ملفات واحد للتلف، فإن البيانات في قسم مختلف ستكون آمنة.

### أنواع نظم الملفات
هناك العديد من أنواع نظم الملفات، كل منها يأتي مع هياكل منطقية وخصائص مختلفة، مثل السرعة والحجم. يمكن أن يختلف نوع نظام الملفات حسب نظام التشغيل واحتياجات هذا النظام. نظام التشغيل Microsoft Windows وMac OS X وLinux هم ثلاثة من أنظمة التشغيل الشائعة على الحواسيب الشخصية. تشمل أنظمة التشغيل المحمولة Apple iOS وGoogle Android.

تشمل النظم الرئيسية لنظم الملفات ما يلي:

- نظام تخصيص الملفات (FAT) مدعوم من نظام التشغيل Microsoft Windows. يُعتبر FAT بسيطًا وموثوقًا ومستمدًا من نظم الملفات التقليدية. تم تصميم FAT في عام 1977 لأقراص المرنة ولكن تم تكييفه لاحقًا لأقراص الصلب. على الرغم من أنه فعال ومتوافق مع معظم أنظمة التشغيل الحالية، إلا أنه لا يمكن مقارنته بالأداء والقابلية للتوسيع لنظم الملفات الحديثة.

- نظام الملفات العالمي (GFS) هو نظام ملفات لنظام التشغيل Linux، وهو نظام ملفات مشترك للأقراص الثابتة. يوفر GFS وصولاً مباشراً إلى التخزين المشترك بينما يمكن استخدامه كنظام ملفات محلي.

- GFS2 هو الإصدار المحدث بميزات غير مدرجة في النسخة الأصلية من GFS، مثل نظام الميتاداتا المحدث. بموجب شروط الرخصة العامة للجمهور GNU، يتوفر نظامي ملفات GFS وGFS2 كبرمجيات حرة.

- نظام ملفات هرمي (HFS) تم تطويره لاستخدامه مع أنظمة تشغيل Mac. يمكن أن يطلق عليه HFS أيضًا اسم Mac OS Standard، ونجحته Mac OS Extended. تم تقديمه في الأصل في عام 1985 لأقراص المرنة والأقراص الصلبة، حيث استبدل نظام ملفات Macintosh الأصلي. يمكن أيضًا استخدامه على أقراص السيدي.

- نظام الملفات NT - المعروف أيضًا باسم نظام الملفات التكنولوجي الجديد (NTFS) - هو نظام الملفات الافتراضي لمنتجات Windows من نظام التشغيل Windows NT 3.1 وما بعده. تضمن التحسينات على نظام الملفات FAT السابق دعمًا أفضل للبيانات الوصفية والأداء واستخدام مساحة القرص. يدعم NTFS أيضًا في نظام التشغيل Linux من خلال مشغل NTFS مفتوح المصدر ومجاني. نظم التشغيل لنظام Mac لديها دعم للقراءة فقط لـ NTFS.

- تنسيق القرص العالمي (UDF) هو نظام ملفات محايد للبائعين لوسائط البصرية وأقراص الدي في دي. يحل UDF محل نظام الملفات ISO 9660 وهو النظام الرسمي لأقراص الفيديو والصوت على DVD، كما تم اختياره من قبل منتدى DVD.

إذا كنت ترغب في تحويل هذا النص إلى صيغة تتوافق مع كاشف المحتوى الذكي للذكاء الاصطناعي، يمكنني تعديله بناءً على الأسلوب الذي تفضله. يمكنك مشاركة التعديلات التي تريدها.

## [الحوسبة السحابية](Cloud%20Computing/Readme.md)
الحوسبة السحابية هي القدرة على الوصول إلى المعلومات والتطبيقات عبر الإنترنت. تسمح الحوسبة السحابية للمستخدمين بالوصول إلى التطبيقات والبيانات من أي موقع يتوفر به اتصال بالإنترنت.

الحوسبة السحابية هي نوع من أنواع الحوسبة القائمة على الإنترنت التي توفر موارد مشتركة لمعالجة الحاسوب والبيانات للحواسيب والأجهزة الأخرى عند الطلب.

إنها نموذج يمكن من خلاله الوصول إلى مجموعة مشتركة من موارد الحوسبة التي يمكن تكوينها (مثل الشبكات والخوادم والتخزين والتطبيقات والخدمات) بشكل عام وملائم وحسب الطلب من خلال شبكة توزيعية، مع إمكانية توفيرها وإطلاقها بسهولة وبجهد إداري أو تفاعل مع موفر الخدمة بحد أدنى.

 ## أهم فوائد الحوسبة السحابية
 
الحوسبة السحابية تمثل تحولًا كبيرًا في كيفية تفكير الشركات حول موارد تكنولوجيا المعلومات. إليك سبعة أسباب شائعة تجعل المؤسسات تتجه نحو خدمات الحوسبة السحابية:

تكلفة
تقوم الحوسبة السحابية بالتخلص من التكلفة الرأسمالية لشراء الأجهزة والبرمجيات وإعداد وتشغيل مراكز البيانات في الموقع—رفوف الخوادم، الكهرباء على مدار الساعة لتبريد وتشغيلها، وخبراء تكنولوجيا المعلومات لإدارة البنية التحتية. إنها تضيف سريعًا.

السرعة
تُقدم معظم خدمات الحوسبة السحابية بنفسها وعند الطلب، لذا يمكن توفير كميات هائلة من موارد الحوسبة في دقائق، عادةً مع بضع نقرات فقط بالماوس، مما يمنح الشركات الكثير من المرونة ويخفف من ضغط التخطيط للقدرات.

المقياس العالمي
تشمل فوائد خدمات الحوسبة السحابية القدرة على توسيع القدرة بمرونة. بلغة الحوسبة السحابية، يعني ذلك تقديم الكمية الصحيحة من موارد تكنولوجيا المعلومات—على سبيل المثال، طاقة حاسوبية أكثر أو أقل، تخزين، وعرض نطاق ترددي—في الوقت الذي يحتاج فيه ومن الموقع الجغرافي الصحيح.

الإنتاجية
تتطلب مراكز البيانات في الموقع عادةً الكثير من "الرفوف والتكديس"—إعداد الأجهزة، وتحديث البرمجيات، ومهام إدارة تكنولوجيا المعلومات الأخرى التي تستغرق وقتًا طويلاً. تزيل الحوسبة السحابية الحاجة إلى العديد من هذه المهام، بحيث يمكن لفرق تكنولوجيا المعلومات قضاء الوقت في تحقيق أهداف العمل الأكثر أهمية.

الأداء
تعمل خدمات الحوسبة السحابية الكبيرة على شبكة عالمية من مراكز البيانات الآمنة، والتي يتم ترقيتها بانتظام إلى الجيل الأحدث من أجهزة الحوسبة السريعة والفعالة. وهذا يقدم العديد من الفوائد على مركز بيانات شركة واحدة، بما في ذلك تقليل التأخير في الشبكة للتطبيقات وتحقيق اقتصاديات أكبر.

الموثوقية
تجعل الحوسبة السحابية عمليات نسخ البيانات واستعادتها واستمرارية الأعمال أسهل وأقل تكلفة لأنه يمكن نسخ البيانات في مواقع متعددة ومتكررة على شبكة موفر الحوسبة السحابية.

الأمان
يقدم العديد من مزودي الحوسبة السحابية مجموعة واسعة من السياسات والتقنيات والضوابط التي تعزز موقف الأمان الخاص بك بشكل عام، مما يساعد في حماية بياناتك وتطبيقاتك وبنية البنية التحتية من التهديدات المحتملة.

### أنواع خدمات الحوسبة السحابية
- [البنية التحتية كخدمة (IaaS)](Cloud%20Computing/Readme.md#infrastructure-as-a-service-iaas)
- [منصة كخدمة (PaaS)](Cloud%20Computing/Readme.md#platform-as-a-service-paas)
- [برمجيات كخدمة (SaaS)](Cloud%20Computing/Readme.md#software-as-a-service-saas)


## [التعلم الآلي]()
التعلم الآلي هو ممارسة تعليم الحاسوب على التعلم. يستخدم هذا المفهوم التعرف على الأنماط، بالإضافة إلى أشكال أخرى من الخوارزميات التنبؤية، لاتخاذ قرارات حول البيانات الواردة. هذا الميدان مرتبط توثيقياً بالذكاء الاصطناعي والإحصاءات الحسابية.

### هناك ثلاثة فئات فرعية من التعلم الآلي:

### التعلم الآلي الإشرافي 
في هذا النوع، يتم تدريب نماذج التعلم الآلي باستخدام مجموعات بيانات موسومة، مما يسمح للنماذج بالتعلم والنمو بدقة أكبر مع مرور الوقت. على سبيل المثال، يتم تدريب خوارزمية مع صور للكلاب وأشياء أخرى، جميعها موسومة من قبل البشر، وسيتعلم الحاسوب كيفية تحديد الصور للكلاب بمفرده.

التطبيقات العملية للتعلم الآلي الإشرافي – 
1. **الحوسبة الحيوية:** الحوسبة الحيوية هي دراسة كيفية الاحتفاظ بالمعرفة البيولوجية مثل البصمات ونسيج العين والأذن، وما إلى ذلك. أصبحت الهواتف المحمولة الذكية الآن ذكية بما فيه الكفاية لفهم بياناتنا البيولوجية ثم التحقق منها لزيادة أمان النظام.
2. **تعرف على الكلام:** إنه نوع من البرنامج يمكنك من خلاله نقل صوتك إلى البرنامج، وسيتعرف عليك. أشهر الأجهزة في العالم الحقيقي هي المساعدين الرقميين مثل مساعد Google أو Siri، الذين يستجيبون للمصطلح فقط بصوتك.
3. **كشف الرسائل الغير مرغوب فيها:** يتم استخدام هذه الأداة لمنع إرسال الرسائل الخيالية أو القائمة على الآلات. يتضمن Gmail خوارزمية تتعلم العديد من المصطلحات الخاطئة. تطبيق Oneplus Messages يطلب من المستخدم تحديد المصطلحات التي يجب حظرها، وستمنع هذه الكلمة الرسائل النصية من التطبيق.
4. **اعتراف بالكائن للرؤية:** يتم استخدام هذا النوع من البرمجيات عندما يتعين عليك تحديد شيء ما. لديك مجموعة كبيرة من البيانات التي تستخدمها لتدريب الخوارزمية، ويمكنها التعرف على كائن جديد باستخدام ذلك.

### التعلم الآلي غير الإشرافي
في التعلم الآلي غير الإشرافي، يبحث البرنامج عن الأنماط في البيانات غير الموسومة. يمكن للتعلم الآلي غير الإشرافي أن يجد أنماطًا أو اتجاهات لا يبحث فيها الأشخاص بوضوح. على سبيل المثال، يمكن لبرنامج التعلم الآلي غير الإشرافي أن يبحث في بيانات المبيعات عبر الإنترنت ويحدد أنواعًا مختلفة من العملاء الذين يقومون بالشراء.

التطبيقات العملية للتعلم الآلي غير الإشرافي
1. **تجميع المعلومات:** تجميع المعلومات هو عملية تصنيف البيانات إلى مجموعات منفصلة. عندما لا نعرف كل التفاصيل حول هذه التجمعات، يمكننا استخدام التعلم الآلي غير الإشرافي لتجميعها. يتم استخدام التعلم الآلي غير الإشرافي لتحليل وتنظيم البيانات التي لا تحتوي على فئات مسبقة التصنيف أو خصائص الفئة. يمكن أن يساعد التجميع الشركات في التعامل مع بياناتها بشكل أكثر فعالية.
لنفترض أن لديك قناة على يوتيوب. قد تمتلك الكثير من المعلومات حول المشتركين الخاصين بك. إذا كنت ترغب في العثور بسرعة على المشتركين المماثلين، فيجب عليك استخدام تقنية التجميع.

2. **التصور:** عملية إنشاء الرسومات والصور والمخططات وما إلى ذلك لتقديم المعلومات تعرف باسم التصور. يمكن استخدام التعلم الآلي غير الإشرافي لتنفيذ هذه الاستراتيجية.
لنفترض أنك مدرب كريكيت تمتلك معلومات حول أداء فريقك في بطولة. قد ترغب في العثور بسرعة على جميع إحصائيات المباراة. يمكنك تمرير البيانات غير الموسومة والمعقدة إلى خوارزمية التصور.

3. **كشف الشذوذ:** كشف الشذوذ هو اكتشاف الأمور، أو الحوادث، أو الملاحظات غير العادية التي تثير الشك من خلال الانحراف بشكل كبير عن البيانات العادية. في هذه الحالة، يتم برمجة النظام بعدد كبير من الحالات النموذجية الطبيعية. نتيجة لذلك، عندما يكتشف حدوثًا غير متوقع، يمكنه تحديد ما إذا كان ذلك استثناءً أم لا.
تعتبر كشف الاحتيال ببطاقات الائتمان مثالاً جيداً على ذلك. يتم التعامل مع هذه المسألة الآن باستخدام تقنيات كشف الشذوذ في التعلم الآلي غير الإشرافي. لتجنب الاحتيال، يتعرف النظام على معاملات بطاقات الائتمان غير المتوقعة.

### التعلم الآلي شبه الإشرافي
عيب التعلم الآلي الإشرافي هو أنه يتطلب وضع العلامات بواسطة خبراء في التعلم الآلي أو علماء البيانات ويتطلب تكلفة عالية لمعالجته. التعلم الآلي غير الإشرافي لديه نطاق محدود أيضًا لتطبيقاته. للتغلب على هذه العيوب في خوارزميات التعلم الآلي الإشرافي وغير الإشرافي، تم تقديم مفهوم التعلم الآلي شبه الإشرافي. عادةً ما يتضمن هذا الجمع بين كمية صغيرة جدًا من البيانات الموسومة وكمية كبيرة من البيانات غير الموسومة. الإجراء الأساسي الذي يشمله هو أن البرنامج سيجمع البيانات المماثلة باستخدام خوارزمية التعلم الآلي غير الإشرافي ثم سيستخدم البيانات الموجودة الموسومة لوسم بقية البيانات غير الموسومة.

التطبيقات العملية للتعلم الآلي شبه الإشرافي
1. **ترجمة اللغة:** في ترجمة اللغات، يمكن استخدام البيانات الموسومة لإقامة الاتصال بين الكلمات والجمل باللغتين المصدر والمستهدفة. بعد ذلك، يمكن استخدام هذه الاتصالات لترجمة النصوص.

2. **تسمية الصور:** يمكن استخدام البيانات الموسومة لربط الكائنات في الصور بالتسميات الصحيحة. ثم يمكن استخدام هذه المعرفة لتدريب الخوارزميات على تحديد الكائنات في الصور غير الموسومة.

3. **استعراض المنتجات:** يمكن استخدام البيانات الموسومة لربط السمات الدقيقة للمنتجات بالتقييمات العامة للمستخدمين. بعد ذلك، يمكن استخدام هذه المعرفة لتوجيه المستخدمين نحو المنتجات التي قد تعجبهم.

4. **تصنيف الموسيقى:** يمكن استخدام البيانات الموسومة لتوضيح العلاقات بين الأغاني والفنانين والأنواع الموسيقية. ثم يمكن استخدام هذه المعرفة لتوصية المستخدمين بالموسيقى التي قد تناسب أذواقهم.

### الاستنتاج
التعلم الآلي هو مجال مثير للغاية يشهد تقدماً مستمراً. باستخدام البيانات والخوارزميات الصحيحة، يمكن للتعلم الآلي أن يحقق تقدماً كبيراً في مجالات متعددة بما في ذلك الرعاية الصحية، والتجارة الإلكترونية، والتسويق، والسيارات الذاتية القيادة، والمزيد. بفضل تقدم التكنولوجيا والتزايد السريع في كميات البيانات، من المتوقع أن يستمر التعلم الآلي في تحسين حياتنا ومجتمعاتنا في المستقبل.

# تكنولوجيا الويب

تشير تكنولوجيا الويب إلى مجموعة متنوعة من الأدوات والتقنيات التي يتم استخدامها في عملية التواصل بين أنواع مختلفة من الأجهزة عبر الإنترنت. يتم استخدام متصفح الويب للوصول إلى صفحات الويب. يمكن تعريف متصفحات الويب على أنها برامج تعرض النصوص والبيانات والصور والرسوم المتحركة ومقاطع الفيديو على الإنترنت. يمكن الوصول إلى الموارد المرتبطة على الشبكة العنكبوتية العالمية باستخدام واجهات البرمجة الخاصة بمتصفحات الويب.

### يمكن تصنيف تكنولوجيا الويب إلى الأقسام التالية:

- **الشبكة العنكبوتية العالمية (WWW)**
  الشبكة العنكبوتية العالمية تعتمد على تقنيات مختلفة: متصفحات الويب ولغة وسم نصي متشعب (HTML) وبروتوكول نقل وسم نصي متشعب (HTTP).

- **متصفح الويب**
  متصفح الويب هو برنامج تطبيقي لاستكشاف الشبكة العنكبوتية العالمية. يوفر واجهة بين الخادم والعميل ويطلب من الخادم مستندات وخدمات الويب.

- **خادم الويب**
  خادم الويب هو برنامج يعالج طلبات الشبكة من المستخدمين ويقدم لهم ملفات تُنشئ صفحات ويب. يتم هذا التبادل باستخدام بروتوكول نقل وسم نصي متشعب (HTTP).

- **صفحات الويب**
  صفحة الويب هي وثيقة رقمية ترتبط بالشبكة العنكبوتية العالمية ويمكن رؤيتها من قبل أي شخص متصل بالإنترنت ولديه متصفح ويب.

- **تطوير الويب**
  يشير تطوير الويب إلى بناء وإنشاء وصيانة المواقع الإلكترونية. يشمل جوانبًا مثل تصميم الويب ونشر الويب وبرمجة الويب وإدارة قواعد البيانات. إنه إنشاء تطبيق يعمل عبر الإنترنت، أي المواقع الإلكترونية.

### يمكن تصنيف تطوير الويب إلى طريقتين:

#### تطوير الواجهة الأمامية

الجزء من موقع الويب حيث يتفاعل المستخدم مباشرة يسمى الواجهة الأمامية. يُشار أيضًا إليها باسم "الجهة العميل" للتطبيق.

#### تطوير الواجهة الخلفية

الجزء الخلفي هو الجانب الخادم لموقع الويب. إنه الجزء من الموقع الذي لا يستطيع المستخدمون رؤيته والتفاعل معه. إنه الجزء من البرنامج الذي لا يتصل مباشرة بالمستخدمين. يتم استخدامه لتخزين وتر

تيب البيانات.

# الشبكات

الشبكة الحاسوبية هي مجموعة من الأجهزة تشترك في موارد تقع على العقد الشبكية أو المقدمة من عقد الشبكة. تستخدم الحواسيب بروتوكولات الاتصال الشائعة عبر الاتصالات الرقمية للتواصل مع بعضها البعض. تتكون هذه الاتصالات الرقمية من تقنيات شبكة الاتصالات السلكية والبصرية واللاسلكية التي يمكن ترتيبها بأشكال متنوعة من توبولوجيات الشبكة.

قد تشمل عقد شبكة الحاسوب العقد الشبكي أو مضيفات متخصصة أو عامة الغرض. يتم التعرف عليها من خلال عناوين الشبكة وقد تحتوي على أسماء مضيف. تعتبر أسماء المضيف تصنيفًا لهذه العقد ونادراً ما تتغير بعد الاسناد الأولي. تستخدم عناوين الشبكة لتحديد مواقع وتحديد العقد عن طريق بروتوكولات الاتصال مثل بروتوكول الإنترنت.

قد يتم تصنيف شبكات الحواسيب بواسطة العديد من المعايير، بما في ذلك وسيلة النقل المستخدمة لنقل الإشارات، وعرض النطاق الترددي، وبروتوكولات الاتصال لتنظيم حركة الشبكة، وحجم الشبكة، والتوبولوجيا، وآلية مراقبة حركة المرور، والنية التنظيمية.

## أنواع الشبكات

هناك نوعان رئيسيان من الشبكات الحواسوب:

- **الشبكات السلكية:**
  تتطلب الشبكات السلكية استخدام وسيط مادي لنقل الإشارات بين العقد. تُستخدم كابلات إيثرنت على أساس النحاس، والتي تعتبر شائعة بسبب تكلفتها المنخفضة ومتانتها، عادةً للاتصالات الرقمية في الشركات والمنازل. بالمقابل، يتم استخدام الألياف البصرية لنقل البيانات على مسافات أطول وبسرعات أسرع، ولكن لديها عدة مقاييس، بما في ذلك تكاليف أعلى ومكونات أكثر هشاشة.

- **الشبكات اللاسلكية:**
  تستخدم الشبكات اللاسلكية موجات الراديو لنقل البيانات عبر الهواء، مما يتيح للأجهزة الاتصال بشبكة دون وجود أي كابلات. شبكات الشبكة المحلية اللاسلكية هي الأكثر شهرة وانتشاراً من بين أشكال الشبكات اللاسلكية. تتضمن البدائل ميكروويف، والأقمار الصناعية، والخلوية، وتقنية البلوتوث، بين أمور أخرى.

## نموذج OSI

تعني OSI "التواصل بين الأنظمة المفتوحة". تم تطويرها بواسطة ISO - "المنظمة الدولية للتوحيد القياسي" في عام 1984. إنها تعتمد على معمارية من 7 طبقات، حيث يوجد لكل طبقة وظيفة محددة لأدائها. تعمل جميع هذه الطبقات السبعة بتعاون لنقل البيانات من شخص إلى آخر عبر العالم.

### **1. الطبقة الفعلية (الطبقة 1):**

الطبقة الأدنى من نموذج OSI هي الطبقة الفعلية. إنها مسؤولة عن الاتصال الفعلي بين الأجهزة. تحتوي الطبقة الفعلية على معلومات في شكل **بتات.** إنها مسؤولة عن نقل البتات الفردية من جهاز إلى الآخر. عند استلام البيانات، ستأخذ هذه الطبقة الإشارة المستلمة وتحولها إلى 0 و 1 وترسلها إلى طبقة ال

ربط بيانات، التي ستجمع الإطار مرة أخرى.

![](Networking/OSI%20Model/img/computer-network-osi-model-layers-bits.png)

وظائف الطبقة الفعلية هي كالتالي:

1. **مزامنة البتات:** توفير الطبقة الفعلية للمزامنة بين البتات عن طريق توفير ساعة. تتحكم هذه الساعة في الإرسال والاستقبال وبالتالي توفير المزامنة على مستوى البت.

2. **مراقبة معدل البت:** الطبقة الفعلية تعرف أيضا معدل النقل، أي عدد البتات التي يتم إرسالها في الثانية الواحدة.

3. **التوبولوجيات الفعلية:** تحدد الطبقة الفعلية الطريقة التي تم ترتيب الأجهزة / العقد المختلفة في الشبكة، سواء كانت شبكة الحافلة أو النجم أو الشبكة.

4. **وضع النقل:** تعرف الطبقة الفعلية أيضًا كيفية تدفق البيانات بين الجهازين المتصلين. وضعيات النقل المختلفة الممكنة هي نصف الثنائي والكامل الثنائي والبسيط.

### **2. طبقة الربط بيانات (DLL) (الطبقة 2):**

طبقة الربط بيانات مسؤولة عن تسليم الرسالة من العقدة إلى العقدة. وظيفتها الرئيسية هي التأكد من أن نقل البيانات خالٍ من الأخطاء من عقدة واحدة إلى أخرى عبر الطبقة الفعلية. عندما يصل حزمة إلى شبكة، يتوجب على طبقة الربط بيانات نقلها إلى المضيف باستخدام عنوان MAC الخاص به. يتم تقسيم طبقة الربط بيانات إلى طبقتين فرعيتين:

1. التحكم في الوصل اللوجي (LLC)
2. التحكم في وصل الوسائط (MAC)

تُقسم الحزمة التي تم استلامها من الطبقة الشبكية إلى إطارات اعتمادًا على حجم الإطار في بطاقة الشبكة (NIC). كما تكتسب طبقة الربط بيانات عناوين MAC للمرسل و / أو المستقبل في الرأس.

![](Networking/OSI%20Model/img/computer-network-osi-model-layers-framing.png)

وظائف طبقة الربط بيانات هي:

1. **تأطير:** التأطير هو وظيفة من وظائف طبقة الربط بيانات. يوفر وسيلة للمرسل لنقل مجموعة من البتات التي تكون ذات مغزى للمستقبل. يمكن تحقيق ذلك من خلال إرفاق نمط خاص من البتات في بداية ونهاية الإطار.

2. **عنوان الشبكة الفعلي:** بعد إنشاء الإطارات، تضيف طبقة الربط بيانات عناوين فعلية (عناوين MAC) للمرسل و / أو المستقبل في رأس كل إطار.

3. **مراقبة الأخطاء:** توفر طبقة الربط بيانات آلية التحكم في الأخطاء التي تكتشف وتعيد نقل الإطارات التالفة أو المفقودة.

4. **مراقبة التدفق:** يجب أن يكون معدل البيانات ثابتًا على كلا الجانبين، وإلا فإن البيانات قد تتلف. وبالتالي، تنسق مراقبة التدفق كمية البيانات التي يمكن إرسالها قبل تلقي تأكيد.

5. **مراقبة الوصول:** عندما يتم مشاركة قناة اتصال واحدة بواسطة عدة أجهزة، يساعد الطبقة الفرعية MAC من طبقة الربط بيانات في تحديد أي جهاز لديه السيطرة على القناة في وقت معين.

### **3. طبقة الشبكة (الطبقة 3):**

تعمل طبقة الشبكة على نقل البيانات من مضيف واحد إلى آخر المتواجدين في شبكات

 مختلفة. كما تعتني أيضًا بتوجيه الحزمة، أي اختيار المسار الأقصر لنقل الحزمة من بين العديد من المسارات المتاحة. يتم وضع عناوين IP للمرسل والمستقبل في الرأس من طبقة الشبكة.

وظائف طبقة الشبكة هي:

1. **التوجيه:** بروتوكولات طبقة الشبكة تحدد أي مسار مناسب من المصدر إلى الوجهة. يعرف هذا الوظيفة من طبقة الشبكة باسم التوجيه.

2. **العناوين المنطقية:** لتحديد كل جهاز على الشبكة الداخلية بشكل فريد، تعرف طبقة الشبكة مخطط عناوين. يتم وضع عناوين IP للمرسل و / أو المستقبل في الرأس من طبقة الشبكة. تميز مثل هذه العناوين كل جهاز بشكل فريد وعالمي.

# الإنترنت

الإنترنت هو نظام عالمي من الشبكات الحاسوبية المتصلة تستخدم مجموعة البروتوكولات القياسية للإنترنت ([TCP/IP](Networking/readme.md#tcptransmission-control-protocol)) لخدمة مليارات المستخدمين في جميع أنحاء العالم. إنها شبكة من الشبكات تتكون من ملايين الشبكات الخاصة والعامة والأكاديمية والتجارية والحكومية من النطاق المحلي إلى النطاق العالمي تمر بها مجموعة واسعة من تقنيات الشبكات الإلكترونية واللاسلكية والضوئية. يحمل الإنترنت مجموعة واسعة من موارد المعلومات والخدمات، مثل الوثائق النصية المترابطة وتطبيقات الشبكة العنكبوتية العالمية ([WWW](Internet/readme.md#world-wide-web-www)) والبنية التحتية لدعم البريد الإلكتروني.

## [الشبكة العنكبوتية العالمية (WWW)](Internet/readme.md#world-wide-web-www)

الشبكة العنكبوتية العالمية (WWW) هي مساحة معلومات حيث يتم تحديد المستندات والموارد الويب الأخرى بواسطة معرفات موحدة للموارد (URLs)، ويتم ربطها بواسطة روابط النصوص المتشعبة، ويمكن الوصول إليها عبر الإنترنت. اخترع العالِم الإنجليزي تيم بيرنرز-لي الشبكة العنكبوتية العالمية في عام 1989. كتب أول متصفح ويب في عام 1990 أثناء عمله في منظمة CERN في سويسرا. تم إصدار المتصفح للجمهور العام على الإنترنت في أغسطس 1991.

## [بروتوكول الإنترنت (IP)](Internet/readme.md#internet-protocol-ip)

بروتوكول الإنترنت (IP) هو بروتوكول أو مجموعة من القواعد لتوجيه وتوجيه حزم البيانات بحيث يمكن أن تسافر عبر الشبكات وتصل إلى الوجهة الصحيحة. يتم تقسيم البيانات التي تعبر عبر الإنترنت إلى قطع صغيرة تسمى حزم.

# نظام إدارة قواعد البيانات (DBMS)

## ما هي قاعدة البيانات؟
-----------------------------------

قاعدة البيانات هي مجموعة من البيانات ذات الصلة التي تمثل جانبًا من العالم الحقيقي. يتم تصميم نظام قاعدة البيانات ليتم بناؤها وملؤها بالبيانات لمهمة معينة.

## ما هو نظام إدارة قواعد البيانات (DBMS)?
-------------

**نظام إدارة قواعد البيانات (DBMS)** هو برنامج يستخدم لتخزين واسترجاع بيانات المستخدمين مع مراعاة التدابير الأمنية المناسبة. يتكون من مجموعة من البرامج التي تعامل مع قاعدة البيانات. يقبل نظام إدارة قواعد البيانات الطلبات للبيانات من التطبيق ويوجه نظام التشغيل لتوفير البيانات النوعية. في الأنظمة الكبيرة، يساعد نظام إدارة قواعد البيانات المستخدمين والبرمجيات الطرف الثالث الأخرى في تخزين واسترجاع البيانات.

يسمح نظام إدارة قواعد البيانات للمستخدمين بإنشاء قواعد بياناتهم وفقًا لاحتياجاتهم. يتضمن مصطلح "نظام إدارة قواعد البيانات" استخدام قاعدة بيانات وبرامج تطبيق أخرى. يوفر واجهة بين البيانات وتطبيق البرمجيات.

## مثال على نظام إدارة قواعد البيانات
-----------------

دعونا نرى مثالًا بسيطًا على قاعدة بيانات جامعية. تحتوي هذه القاعدة على معلومات تتعلق بالطلاب والدورات والدرجات في بيئة جامعية. تنظم قاعدة البيانات إلى خمسة ملفات:

* يخزن ملف الطالب بيانات كل طالب
* ملف الدورة يحتوي على بيانات حول كل دورة.
* تخزن القسم معلومات حول الأقسام في دورة معينة.
* ملف الدرجات يخزن الدرجات التي يتلقاها الطلاب في الأقسام المختلفة.
* ملف المعلم يحتوي على معلومات حول كل أستاذ.

لتعريف نظام إدارة قواعد البيانات:

* نحتاج إلى تحديد هيكل السجلات في كل ملف عن طريق تحديد أنواع مختلفة من عناصر البيانات التي يجب تخزينها في كل سجل.
* يمكننا أيضًا استخدام مخطط ترميز لتمثيل قيم عنصر البيانات.
* في الأساس، ستحتوي قاعدة البيانات لديك على خمسة جداول مع مفتاح خارجي يتم تعريفه بين الجداول المختلفة.

## تاريخ نظام إدارة قواعد البيانات
---------------

فيما يلي الأحداث الهامة من التاريخ:

* 1960 – قام تشارلز باخمان بتصميم أول نظام DBMS
* 1970 – قدم كود نظام إدارة المعلومات لشركة IBM (IMS)
* 1976 - صاغ بيتر تشين ووضع تعريف نموذج العلاقة-الكيان، والمعروف أيضا باسم نموذج ER
* 1980 – أصبح النموذج العلاقي عنصرًا مقبولًا على نطاق واسع في قاعدة البيانات
* 1985 - تطور نظام DBMS الموجه نحو الكائنات.
* 1990s - دمج التوجه نحو الكائنات في DBMS العلاقي.
* 1991 - شحنت مايكروسوفت MS Access، وهو نظام DBMS شخصي يحل محل جميع منتجات DBMS الشخصية الأخرى.
* 1995: تطبيقات قاعدة بيانات الإنترنت الأولى
* 1997: تطبيق XML في معالجة قواعد البيانات. بدأ العديد من البائعين في دمج XML في منت

جات نظام إدارة قواعد البيانات.

## خصائص نظام إدارة قواعد البيانات
-----------------------

فيما يلي خصائص وخصائص نظام إدارة قواعد البيانات:

* يوفر الأمان ويزيل التكرار
* يصف طبيعة نفسه لنظام قاعدة البيانات
* عزل بين البرامج والتجريد من البيانات
* دعم عرضات متعددة للبيانات
* مشاركة البيانات ومعالجة المعاملات متعددة المستخدمين
* يسمح برنامج إدارة قاعدة البيانات للكيانات والعلاقات بينها بتشكيل الجداول.
* يتبع مفهوم ACID (الذرية والاتساق والعزل والدوام).
* نظام إدارة قاعدة البيانات يدعم بيئة متعددة المستخدمين تتيح للمستخدمين الوصول إلى البيانات وتلاعبها بشكل متزامن.

## برامج نظام إدارة قواعد البيانات الشهيرة
---------------------

فيما يلي قائمة ببعض أنظمة نظام إدارة قواعد البيانات الشهيرة:

* MySQL
* Microsoft Access
* Oracle
* PostgreSQL
* dBASE
* FoxPro
* SQLite
* IBM DB2
* LibreOffice Base
* MariaDB
* Microsoft SQL Server إلخ.

## [التشفير](Cryptography/readme.md#cryptography)
التشفير هو تقنية لتأمين البيانات والاتصالات. إنها طريقة لحماية المعلومات والاتصالات من خلال استخدام الرموز بحيث يمكن قراءتها ومعالجتها فقط من قبل أولئك الذين يتعين عليهم قراءة المعلومات. يتم استخدام التشفير لحماية البيانات أثناء الانتقال، وفي الراحة، وعند الاستخدام. البادئة _crypt_ تعني "مخفي" أو "سري"، واللاحقة _graphy_ تعني "كتابة".

### أنواع التشفير
هناك نوعان من التشفير:
1. [التشفير التماثلي](Cryptography/readme.md#symmetric-cryptography)
2. [التشفير غير التماثلي](Cryptography/readme.md#asymmetric-cryptography)

### [العملة الرقمية](Cryptography/CryptoCurrency/readme.md#crypto-currency)
العملة الرقمية هي عملة رقمية يتم استخدام تقنيات التشفير فيها لتنظيم إنشاء وتحقق تحويل الأموال، وذلك بشكل مستقل عن البنك المركزي. تستخدم العملات الرقمية التحكم غير المركزي بدلاً من العملات الرقمية المركزية وأنظمة البنوك المركزية. يعمل التحكم اللامركزي في كل عملة رقمية من خلال تكنولوجيا الدفتر الأستاذ الموزعة، وعادةً ما يكون سلسلة كتلية، التي تعمل كقاعدة بيانات مالية عامة للمعاملات. ميزة محددة للعملة الرقمية، وربما أكثر إثارة للاهتمام، هي طبيعتها العضوية. فهي لا تصدر من قبل أي سلطة مركزية، مما يجعلها نظرياً مقاومة للتدخل أو التلاعب من قبل الحكومات.

## أنواع العملات الرقمية كما يلي:
1. [دليل العمل](Cryptography/CryptoCurrency/ProofOfWork/readme.md#proof-of-work)
2. [دليل حصة](Cryptography/CryptoCurrency/ProofOfStake/readme.md#proof-of-stake)

### _أشهر العملات الرقمية هي كما يلي:_
1. [بيتكوين](Cryptography/CryptoCurrency/ProofOfWork/Bitcoin/readme.md#bitcoin)
2. [إيثريوم](Cryptography/CryptoCurrency/ProofOfStake/Ethereum/readme.md#ethereum)
3. [لايتكوين](Cryptography/CryptoCurrency/ProofOfWork/Litecoin/readme.md#litecoin)
4. [كاردانو](Cryptography/CryptoCurrency/ProofOfStake/Cardano/readme.md#cardano)
5. [دوجيكوين](Cryptography/CryptoCurrency/ProofOfWork/Dogecoin/readme.md#dogecoin)

# نظرية الحوسبة

في علم الحوسبة النظري والرياضيات، تعد نظرية الحوسبة الفرع الذي يتناول ما إذا كان يمكن حلاً للمشاكل على نموذج من الحوسبة باستخدام خوارزمية، وكيفية فعالية حلاها، أو إلى أي حد (على سبيل المثال، الحلاول التقريبية مقابل الحلاول الدقيقة). وينقسم هذا المجال إلى ثلاثة فروع رئيسية: نظرية الأتمتة واللغات الشكلية، نظرية القابلية للحوسبة، ونظرية تعقيد الحوسبة، والتي يربطها السؤال: "ما هي القدرات الأساسية والقيود للحواسيب؟".

### نظرية الأتمتة

نظرية الأتمتة هي دراسة الآلات والأتمتة النظرية، وكذلك المشاكل الحوسبية التي يمكن حلاها باستخدامها. إنها نظرية في علم الحوسبة النظري. يأتي كلمة "الأتمتة" من الكلمة اليونانية "أوتوماتوس"، والتي تعني "ذاتي العمل، ذاتي الإرادة، ذاتي الحركة". الأتمتة (أوتوماتا في الجمع) هي جهاز حوسبي تجريبي تلقائي يتبع تسلسلًا محددًا من العمليات بشكل تلقائي. الأتمتة ذات عدد محدود من الحالات تسمى الأتمتة المحدودة أو الآلة ذات الحالات المحدودة. الشكل على اليمين يوضح آلة ذات حالات محدودة، والتي هي نوع معروف من الأتمتة. تتكون هذه الأتمتة من حالات (تمثل في الشكل بالدوائر) وانتقالات (تمثل بالسهام). عندما ترى الأتمتة رمزًا من المدخلات، يتم إجراء انتقال (أو قفزة) إلى حالة أخرى، وفقًا لدالتها للانتقال، التي تأخذ الحالة السابقة والرمز الحالي كمدخلات لها.

### اللغات الشكلية

في المنطق، الرياضيات، علم الحاسوب، وعلم اللغات، تتكون اللغة الشكلية من كلمات تتألف حروفها من أحرف من ألفبيت وتكون متشكلة وفقًا لمجموعة معينة من القواعد.

يتكون ألفبت اللغة الشكلية من رموز أو أحرف أو رموز يتسلسلون في سلاسل من اللغة.[1] تسمى كل سلسلة متسلسلة من الرموز من هذا الألفبت بكلمة، وتسمى الكلمات التي تنتمي إلى لغة شكلية معينة في بعض الأحيان بكلمات جيدة التشكيل أو الصيغ الجيدة. غالبًا ما يتم تحديد اللغة الشكلية باستخدام قواعد لغوية شكلية، مثل قواعد اللغة النظامية أو قواعد اللغة الحرة السياقية، التي تتكون من قواعد تشكيلها.

في علم الحاسوب، تُستخدم اللغات الشكلية، بين أمور أخرى، كأساس لتحديد قواعد اللغات البرمجية والنسخ الشكلي لمجموعات من لغات طبيعية حيث تمثل كلمات اللغة مفاهيم مرتبطة بمعان أو دلالات محددة. في نظرية تعقيد الحوسبة، يتم تحديد مشكلات القرار عادة كلغات شكلية وتعريف فئات التعقيد الحسابي كمجموعات من اللغات الشكلية التي يمكن معالجتها بواسطة آلات ذات قدرات حوسبة محددة. في المنطق وأسس الرياضيات، تستخدم اللغات الشكلية لتمثيل بنية الأنظمة المحددة، والصيغ الرياضية هي الفلسف

ة التي يمكن تقليل كل الرياضيات إلى التلاعب الصياغي للغات الشكل بهذه الطريقة.

### نظرية القابلية للحوسبة

نظرية القابلية للحوسبة، المعروفة أيضا بنظرية التكرار، هي فرع من المنطق الرياضي وعلم الحاسوب، ونظرية الحوسبة نشأت في الثلاثينات مع دراسة الوظائف القابلة للحوسبة ودرجات تورينغ. منذ ذلك الحين توسع هذا المجال ليشمل دراسة القابلية العامة والقابلية للتعريف. في هذه المجالات، تتداخل نظرية القابلية للحوسبة مع نظرية البرهان ونظرية مجموعات الوصف الفعال.

### نظرية تعقيد الحوسبة

في علم الحوسبة النظري والرياضيات، تركز نظرية تعقيد الحوسبة على تصنيف المشاكل الحوسبية وفقاً لاستخدام مواردها وربط هذه الفئات ببعضها. المشكلة الحوسبية هي مهمة يتم حلها بواسطة الكمبيوتر. مشكلة الحوسبة قابلة للحل عن طريق التطبيق الميكانيكي لخطوات رياضية، مثل خوارزمية.

يعتبر الأمر مشكلة صعبة بشكل أساسي إذا كان حلاها يتطلب موارد كبيرة، بغض النظر عن الخوارزمية المستخدمة. تشكل النظرية توثيقًا رياضيًا لهذا الحدس عن طريق تقديم النماذج الرياضية للحوسبة لدراسة هذه المشاكل وقياس تعقيد الحوسبة الخاص بها، أي عدد الموارد اللازمة لحلها، مثل الوقت والتخزين. يتم استخدام تدابير أخرى للتعقيد أيضًا، مثل كمية الاتصال (المستخدمة في تعقيد الاتصال)، وعدد البوابات في دائرة كهربائية (المستخدمة في تعقيد الدائرة)، وعدد المعالجات (المستخدمة في الحوسبة المتوازية). أحد أدوار نظرية تعقيد الحوسبة هو تحديد الحدود العملية لما يمكن وما لا يمكن فعله بواسطة الكمبيوتر. مشكلة P مقابل مشكلة NP، واحدة من مشاكل الجوائز السبع للألفية، مكرسة لميدان تعقيد الحوسبة.

المجالات ذات الصلة بعلم الحوسبة النظري هي تحليل الخوارزميات ونظرية القابلية للحوسبة. الفرق الرئيسي بين تحليل الخوارزميات ونظرية تعقيد الحوسبة هو أن الأول مكرس لتحليل عدد الموارد التي يحتاجها خوارزمية معينة لحل مشكلة، في حين أن الثاني يطرح سؤالًا أكثر عمومية حول جميع الخوارزميات الممكنة التي يمكن استخدامها لحل نفس المشكلة. وبدقة أكبر، تحاول نظرية تعقيد الحوسبة تصنيف المشاكل التي يمكن أو لا يمكن حلاها باستخدام موارد مقيدة بشكل مناسب. وبالمقابل، فإن فرض قيود على الموارد المتاحة هو ما يميز نظرية تعقيد الحوسبة عن نظرية القابلية للحوسبة: النظرية الأخيرة تسأل ما هي أنواع المشاكل التي يمكن، في المبدأ، حلاها بشكل خوارزمي. 
