# Internet
The Internet is a global network of billions of computers and other electronic devices. With the Internet, it's possible to access almost any information, communicate with anyone else in the world, and do much more.

You can do all of this by connecting a computer to the Internet, which is also called going online. When someone says a computer is online, it's just another way of saying it's connected to the Internet.

## How the Internet Works
The Internet is a network of networks. It's made up of millions of smaller networks, called local area networks ([LANs](../Networking/readme.md#local-area-network-lan)), that are connected to each other. These smaller networks are owned by companies, schools, governments, and other organizations. The Internet is also made up of billions of computers and other electronic devices that are connected to these smaller networks.

The Internet is a global network, which means it's not limited to any one country. It's a worldwide network of networks. The Internet is also a public network, which means anyone can use it. You don't need to be a member of any organization to use the Internet.

## World Wide Web (WWW)
The World Wide Web (WWW) is an information space where documents and other web resources are identified by Uniform Resource Locators ([URLs](#url-uniform-resource-locator)), interlinked by hypertext links, and accessible via the Internet. English scientist Tim Berners-Lee invented the World Wide Web in 1989. He wrote the first [web browser](#web-browsers) in 1990 while employed at CERN in Switzerland. The browser was released outside CERN in 1991, first to other research institutions starting in January 1991 and to the general public on the Internet in August 1991.

It's a service that allows you to find information on the Internet. The World Wide Web is a collection of web pages that are linked together. You can find web pages by using a web browser, such a Google Chrome, or Mozilla Firefox.

## URL (Uniform Resource Locator)
A Uniform Resource Locator (URL), colloquially termed a web address, is a reference to a web resource that specifies its location on a computer network and a mechanism for retrieving it. A URL is a specific type of Uniform Resource Identifier (URI), although many people use the two terms interchangeably. A URL implies the means to access an indicated resource, which is not true of most URIs. URLs occur most commonly to reference web pages (http), but are also used for file transfer (ftp), email (mailto), database access (JDBC), and many other applications.

### Examples of URLs
* http://www.example.com
* https://www.example.com
* ftp://ftp.example.com
* mailto:
* telnet://example.com
* jdbc:mysql://example.com:3306/test


## Search Engines
A search engine is a software system that is designed to search for information on the World Wide Web. The search results are generally presented in a line of results often referred to as search engine results pages (SERPs). The information may be a mix of web pages, images, and other types of files. Search engines are accessed by entering a word or group of words into a search box. The word or words are called keywords or search terms. Most search engines use an internal algorithm to generate the search results. The algorithm is a complex mathematical formula that is used to rank the relevance of web pages in response to a search query. The algorithm is kept a secret, so no one knows exactly how it works. However, there are some things that search engines look for when ranking web pages. These include the number of times a keyword appears on a web page, the number of links to a web page, and the quality of the web page.

### Major Search Engines
* [Google](https://www.google.com/)
* [Bing](https://www.bing.com/)
* [Yahoo](https://www.yahoo.com/)
* [DuckDuckGo](https://duckduckgo.com/)
* [Baidu](https://www.baidu.com/)
* [Yandex](https://yandex.com/)

## Web Browsers
A web browser is a software application for accessing information on the World Wide Web. When a user enters a URL into the browser, the browser retrieves the web page and displays it on the user's computer screen. The browser also provides a user interface for navigating between web pages. The browser is the most common way to access the World Wide Web. There are many different web browsers available, including Google Chrome, Mozilla Firefox, Microsoft Edge, and Apple Safari.


## Internet Protocol (IP)
The Internet Protocol (IP) is a protocol, or set of rules, for routing and addressing packets of data so that they can travel across networks and arrive at the correct destination. Data traversing the Internet is divided into smaller pieces, called packets.


## Topics on Internet
- [Cyber Security](Cyber%20Security/readme.md)
- [Internet of Things (IoT)](IOT/readme.md)
- [Cyber Crime](Cyber%20Crimes/readme.md)

## Error Codes
While browsing the internet, you may have encountered some error codes.
Like:
* 404 Not Found
* 403 Forbidden
* 500 Internal Server Error
* 502 Bad Gateway
* 503 Service Unavailable
* 504 Gateway Timeout
* 408 Request Timeout

These errors might be confusing for you. But they make the life of the developer a lot easier 
as they contain a lot of useful information about the problem.

In genral the error codes means:
* 1xx:  informational response - it means the request was received and the process is continuing 
* 2xx:  success - the request was successfully received, understood, and accepted
* 3xx:  redirection - further action needs to be taken in order to complete the request
* 4xx:  client error - the request contains bad syntax or cannot be fulfilled
* 5xx:  server error - the server failed to fulfil an apparently valid request


### 404 Not Found
This error means that the requested resource could not be found. This is the most common error you will encounter while browsing the internet. This error is returned when the server is unable to find the requested resource. This error can be caused by a number of things, including a broken link, a mistyped URL, or a deleted file.

