# Internet of Things (IoT). What is IoT?

If we go into the definition of the Internet of Things, we find out that it is the concept of inter-networking of physical devices, connected devices, smart devices, and other devices embedded with electronics, software, sensors, actuators, and network connectivity that enable these objects to collect and exchange data.

What it means, is that an object can be sensed or controlled remotely across the existing network infrastructure that enables direct integration of the physical world into computer-based systems, which, in turn, improves their efficiency and accuracy and reduces human intervention.


If augmented with sensors and actuators, the technology becomes an instance of a more general class of cyber-physical systems, which also encompasses technologies such as smart grids, virtual power plants, smart homes, intelligent transportation and smart cities.

# Key Concepts of IoT

### 1. Hardware 
 The heart of IoT is billions of interconnected devices with attached sensors and actuators that sense and control the physical world. In addition to network connectivity to transmit the data they collect, these devices require some basic processing and storage capabilities, provided by a micro-controller or by an integrated circuit, such as a System-on-a-Chip (SoC) or a field-programmable gate array (FPGA) .

### 2. Embedded programming
 IoT devices are embedded devices, and may be prototyped using commoditized micro-controller platforms, such as Arduino, with custom printed circuit boards (PCBs) developed at a later stage. Prototyping with these platforms requires circuit design skills, micro-controller programming, and a deep understanding of hardware communication protocols like serial, I2C, or SPI used to establish communication between the micro-controller and the connected sensors and actuators. The embedded programs are often developed using C++ or C, however Python and JavaScript are becoming more popular for prototyping IoT devices.

### 3. Security
 Security is one of the most critical concerns in IoT, closely related to data ethics, privacy and liability. It must be built-in at every step of the design of the system. With millions of new devices connected every day, the number of potential points of attack grows daily. With so much at stake, security engineering skills, including threat assessment, ethical hacking, encryption to ensure data integrity, securing network architectures and applications, as well as event monitoring, activity logging, and threat intelligence, move to the foreground of the IoT development projects.

### 4. Networking and cloud integration
 Network design and management are essential within IoT, due to the sheer volume of connected devices and due to the impact that network design decisions can have at scale. Connectivity enables devices to communicate with other devices as well as with applications and services that are running in the cloud. Though cloud computing and the IoT are two very different technologies, real-time data streaming and cloud integration are crucial for the proper functioning of the Internet of Things. Cloud infrastructure is used for data storage, processing and analysis, as well as for implementation of the business logic of IoT applications.

### 5. Data analytics and prediction 
 The number of IoT devices transmitting data increases on the daily basis, which turns big data into huge data. Developers will need securely and reliably ingest, store, and query the vast quantities of heterogeneous data originating from these devices. Besides, as many IoT devices generate latency or time-sensitive data, it is also necessary to filter or discard irrelevant data.

### 6. Machine Learning and AI 
 To deliver value and make sense of the huge volumes of data that is generated by IoT devices, machine learning and AI skills are the ultimate must-have skill for IoT developers. To be truly intelligent, big data analytics needs to apply cognitive computing techniques drawn from data mining, modeling, statistics, machine learning, and AI. These techniques can be applied in real-time both to sensor data streams for predictive analysis and to autonomously make decisions in response to incoming data. Besides, machine learning can be applied to historical data to identify patterns or anomalies in the data.

### 7. IoT and Industry
 The impact of IoT on industrial ecosystems has resulted in emergence of robust physical-cyber connectivity, often called the fourth industrial revolution aka Industry 4.0 , also known as the Industrial Internet of Things (IIoT). The connected ecosystem encompasses physical connected assets: including those on the manufacturing shop floor as well as the manufactured connected devices such as connected cars or appliances.

 The IoT/IIoT digital transformation in Manufacturing is providing robust communication, understanding and opportunities for innovation involving orchestration of Things, People, and Systems in end-to-end automated value streams.

### 8. IoT Protcols
 There are various protocols for IOT, one protocol that comes from the industry has established itself in the smarthome field. MQTT is a client-broker system that uses narrow bandwidth and has many features in it, such as last will and 3 levels for message transmission.

 AQMP is the next level and is also an OASIS standard and an ISO recommendation (ISO/IEC 19464:2014). This is currently more commonly found in professional Internet applications. 

 In the smarthome area, Google Matter was recently introduced. This standard is intended to be able to address all devices regardless of manufacturer and thus soften manufacturer boundaries.  So far there are partly own standards and other protocols like ZigBee, Bluetooth other 433Mhz radio protocols as well as Wlan. Which then exchange the data via TCP/UDP, MQTT and REST.

# Why IoT Is Important
All things connected to the internet can be divided into three categories:

1. Things that collect information and then send it
2. Things the receive information and act on it
3. Things that do both

To make this more clear, we could use some real-life examples.


### Collecting Information
These devices use sensors (usually) to collect information. For example, a thermostat in your smart home, can measure the temperature in your house and show you the degree on an app on your smartphone.

The sensors along with an internet connection allow us to automatically collect information and make smarter decisions based on complex computer algorithms, while not having to interact at all with anything but an internet-connected device.

### Receiving Information and Sending it
Most of the devices we know operate like this — getting information and acting upon it. A printer receives a document to print and prints it. A car unlocks if it receives a signal to unlock.

These operations can be as simple as turning on a device from farther away. The real power of the Internet of Things is when these two behaviors can work simultaneously from the same device!

### Things That Can Do Both
Let’s take the example with the thermostat from before; what if it could operate completely on its own? The thermostat measures the temperature, and once the house becomes too hot it automatically lowers the temperature.

This way the device is collecting information but also receiving its own information and acting upon it. This is the true power of IoT.

### IoT In Your Life
Automated Farming might seem less impactful in your personal world, so let’s think of how things can change in your day. Using our “typical day” story from before, we could think of different ways to improve the use of devices, especially by making them interact with each other (making them “smart’).

What if your morning alarm could automatically turn on the coffee machine for it to be ready once you need to leave? What if your smart fridge could take care of your groceries? It could track every food item, and use an app on your smartphone to automatically order more. If these sound a little useless (or lazy for some people), we could think of more significant uses.

What if your wearable devices can sense when you’re in danger, and automatically let someone know? What if you have some kind of device that tracks your house’s energy consumption, and automatically turns different things on or off depending on your usage, saving you thousands of dollars a year?

The possibilities are endless.

### Security
As I’m sure you’ve heard, everything connected to the internet can be hacked (yes, everything), and IoT products are no exception to this rule. With everything being connected to the internet, anything could be hacked and messed with. Following the previous example, one cyberattack could ruin an entire crop in a day.

One other issue is the amount of data being stored. If every device is constantly storing all the data it’s collecting, there is a possibility of someone reaching all this data and using it for other purposes.

Also, what about your personal privacy? If everything in your house is connected to the internet, everything could be hacked and information about you and your habits come out. With a smart fridge, everything you eat and when you eat will come out. With your smartwatch, every heartbeat and step could be accessible. With almost all devices around you having some kind of sensor (some with cameras), hackers would have access to every aspect of your life.

These issues are very serious, and the truth is there isn’t any real solution yet. Different security methods have been released, and these issues are constantly being thought upon:

In September 2015, the Federal Bureau of Investigation released a public service announcement, FBI Alert Number I-091015-PSA, which warned about the potential vulnerabilities of IoT devices and offered consumer protection and defense recommendations.
In August 2017, Congress introduced the IoT Cybersecurity Improvement Act, which would require any IoT device sold to the U.S. government to not use default passwords, not have known vulnerabilities and offer a mechanism to patch the devices.

### Reliable Standards
If the whole point of all devices being connected is for them to communicate, we need to find a way to allow that to happen. If all devices run on different standards, they’re going to struggle to communicate and transfer data to each other.

Currently, the Institute of Electrical and Electronics Standards Association lists a large number of standards that exist and are being worked on for different devices.

Also, Microsoft has started to think about this issue and came up with their own system — IoT Central. The system gives businesses a central platform for setting up their IoT devices.

### Conclusion
To sum things up, revolutionizing the planet with IoT is often thought of as “The 4th Industrial Revolution”, because of how impactful it can be. We should all be aware of the changes happening and the issues they bring, but also appreciate we live in a world where these kinds of changes are possible and are actually happening.





