# Deep Tutorials for [PyTorch](https://pytorch.org)

This is a series of in-depth tutorials I'm writing for implementing cool deep learning models on your own with the amazing PyTorch library. 

Basic knowledge of PyTorch and neural networks is assumed.

If you're new to PyTorch, first read [Deep Learning with PyTorch: A 60 Minute Blitz](https://pytorch.org/tutorials/beginner/deep_learning_60min_blitz.html) and [Learning PyTorch with Examples](https://pytorch.org/tutorials/beginner/pytorch_with_examples.html).

---

**24 Apr 2023**: I've just completed the [Super-Resolution](https://github.com/sgrvinod/a-PyTorch-Tutorial-to-Super-Resolution) and [Transformers](https://github.com/sgrvinod/a-PyTorch-Tutorial-to-Transformers) tutorials.

**09 Dec 2023**: Interested in chess or transformers? Check out [Chess Transformers](https://github.com/sgrvinod/chess-transformers).

---

In each tutorial, we will focus on a specific application or area of interest by implementing a model from a research paper. 

Application | Paper | Tutorial | Also Learn About | Status
:---: | :---: | :---: | :---: | :---:
Image Captioning | [_Show, Attend, and Tell_](https://arxiv.org/abs/1502.03044) | [a PyTorch Tutorial to Image Captioning](https://github.com/sgrvinod/a-PyTorch-Tutorial-to-Image-Captioning) | &bull; encoder-decoder architecture<br/><br/>&bull; attention <br/><br/>&bull; transfer learning <br/><br/>&bull; beam search | 🟢<br/>*complete*
Sequence Labeling | [_Empower Sequence Labeling with Task-Aware Neural Language Model_](https://arxiv.org/abs/1709.04109) | [a PyTorch Tutorial to Sequence Labeling](https://github.com/sgrvinod/a-PyTorch-Tutorial-to-Sequence-Labeling) | &bull; language models<br/><br/>&bull; character RNNs <br/><br/>&bull; multi-task learning <br/><br/>&bull; conditional random fields <br/><br/>&bull; Viterbi decoding <br/><br/>&bull; highway networks | 🟢<br/>*complete*
Object Detection | [_SSD: Single Shot MultiBox Detector_](https://arxiv.org/abs/1512.02325) | [a PyTorch Tutorial to Object Detection](https://github.com/sgrvinod/a-PyTorch-Tutorial-to-Object-Detection) | &bull; single-shot detection<br/><br/>&bull; multiscale feature maps <br/><br/>&bull; priors <br/><br/>&bull; multibox <br/><br/>&bull; hard negative mining <br/><br/>&bull; non-maximum suppression | 🟢<br/>*complete*
Text Classification | [_Hierarchical Attention Networks for Document Classification_](https://www.semanticscholar.org/paper/Hierarchical-Attention-Networks-for-Document-Yang-Yang/1967ad3ac8a598adc6929e9e6b9682734f789427) | [a PyTorch Tutorial to Text Classification](https://github.com/sgrvinod/a-PyTorch-Tutorial-to-Text-Classification) | &bull; hierarchical attention | 🟡<br/>*code complete*
Super-Resolution | [_Photo-Realistic Single Image Super-Resolution Using a Generative Adversarial Network_](https://arxiv.org/abs/1609.04802) | [a PyTorch Tutorial to Super-Resolution](https://github.com/sgrvinod/a-PyTorch-Tutorial-to-Super-Resolution) | &bull; **GANs** — this is also a GAN tutorial <br/><br/>&bull; residual connections <br/><br/>&bull; sub-pixel convolution <br/><br/>&bull; perceptual loss | 🟢<br/>*complete*
Machine Translation | [_Attention Is All You Need_](https://arxiv.org/abs/1706.03762) | [a PyTorch Tutorial to Transformers](https://github.com/sgrvinod/a-PyTorch-Tutorial-to-Transformers) | &bull; **transformers** <br/><br/>&bull; multi-head attention <br/><br/>&bull; positional embeddings <br/><br/>&bull; encoder-decoder architecture <br/><br/>&bull; byte pair encoding <br/><br/>&bull; beam search | 🟢<br/>*complete*
Semantic Segmentation | [_SegFormer: Simple and Efficient Design for Semantic Segmentation with Transformers_](https://arxiv.org/abs/2105.15203) | a PyTorch Tutorial to Semantic Segmentation | N/A | 🔴<br/>*planned*

