package party;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

/**
 * ab226.03, Aufgabe 2
 * Klasse PartyConsoleUI implementiert eine konsolenbasierte Benutzerschnittstelle
 * fr die Party-Applikation. Sie verwendet die Klasse PartyCore.
 * @author Andres Scheidegger
 */
public class PartyConsoleUI {

  /**
   * Hauptmethode fr den Start der Party-Applikation. Fordert den Benutzer auf 
   * die Anzahl Gste einzugeben und stellt dann die Anzahl der erklingenden
   * Glserpaare beim Anstossen dar.
   * 
   * @param args nicht verwendet
   * @throws NumberFormatException, wenn die Benutzereingabe keine gltige Zahl ist.
   * @throws IOException, wenn die Konsole nicht geffnet oder gelesen werden kann.
   */
  public static void main(String[] args) throws NumberFormatException, IOException {
    // Konsole zum Lesen ffnen
    BufferedReader input = new BufferedReader(new InputStreamReader(System.in));

    // Prompt ausgeben und Anzahl Teilnehmer von Konsole lesen
    System.out.println("Geben Sie die Anzahl der Teilnehmer ein:");
    int teilnehmer = Integer.parseInt(input.readLine());
    PartyCore.setNbOfGuests(teilnehmer);

    // anstossen
    System.out.println(
        "Wenn " + teilnehmer + " Teilnehmer anstossen, erklingen " + 
        PartyCore.cheers() + " Glserpaare."
    );

  }
}
