import { config } from 'dotenv'
config()

import { TextLoader } from 'langchain/document_loaders/fs/text'
import { CharacterTextSplitter } from 'langchain/text_splitter'
import { OpenAIEmbeddings } from 'langchain/embeddings/openai'
import { FaissStore } from 'langchain/vectorstores/faiss'

const loader = new TextLoader('./restaurant.txt')

const docs = await loader.load()

const splitter = new CharacterTextSplitter({
    chunkSize: 200,
    chunkOverlap: 50
})

const documents = await splitter.splitDocuments(docs)
console.log(documents)

const embeddings = new OpenAIEmbeddings()

const vectorstore = await FaissStore.fromDocuments(documents, embeddings)
await vectorstore.save('./')
