# Contributing

The Sempare Template Library for Delphi is a templating engine for creating dynamic text. Please discuss any major new feature 
changes or enhancements to this project with the project's maintainers first.

We may not be able to accommodate certain changes. Please feel free to contact the maintainers if you have questions.
Bug fixes and performance improvements are always welcome.

To contribute,

1. Fork this repository.
1. Search for any open issues on the [Sempare Template Engine Github Issues](https://github.com/sempare/sempare-delphi-template-engine/issues) site related
to the improvement you are interested in making. Team up with other developers if you see a related issues.
1. Create a new issue to track progress, commits and general discussions on a proprosed change (limit discussion in PRs
to code related topics).
1. Work on your changes within a topic branch on your fork of the Sempare Template Engine.
1. Create a pull request from your topic branch to the Sempare Template Engine DEV branch with reference to the issue you created.
1. The maintainers may choose to merge your changes directly, or may create a test build with your changes for internal testing.

Pull requests are accepted under the discretion of the Sempare Limited maintainer(s). Improve the chances your PR will be
merged by following the requirements and guidelines below. For any questions, please e-mail info@sempare.ltd.

**REQUIREMENTS**
- By creating a pull request, you are agreeing to [Sempare Limited's Contributor terms and conditions](./docs/CONTRIBUTION.pdf).

**GUIDELINES**
- Make sure your pull contains quality code. We will certainly provide constructive feedback on works in progress but
we will not merge incomplete pull requests.
- Check your code with code quality tools of your choosing.
- Attempt to follow existing code conventions found in the library.
- Make sure your pull is fully documented.
- Reference related Github Issues within commit comments and pull request comment where appropriate.
- Squash out minor or "typo" commits in your pull using `git commit -a` or `git rebase -i`.

**BUGS**

File bugs or feature requests using Github Issue Tracker.

https://github.com/sempare/sempare-delphi-template-engine/issues