//
//  OpenHaystack – Tracking personal Bluetooth devices via Apple's Find My network
//
//  Copyright © 2021 Secure Mobile Networking Lab (SEEMOO)
//  Copyright © 2021 The Open Wireless Link Project
//
//  SPDX-License-Identifier: AGPL-3.0-only
//

import Combine
import CryptoKit
import Foundation

struct FindMyDevice: Codable {
  let deviceId: String
  var keys = [FindMyKey]()
}

struct FindMyKey: Codable {
  /// The advertising key
  let advertisedKey: Data
  /// Hashed advertisement key using SHA256
  let hashedKey: Data
  /// The private key from which the advertisement keys can be derived
  let privateKey: Data
  /// When this key was used to send out BLE advertisements
  let startTime: Date?
  /// Duration from start time how long the key has been used to send out BLE advertisements
  let duration: Double?

  // swiftlint:disable identifier_name
  /// ?
  let pu: Data?

  /// As exported from Big Sur
  let yCoordinate: Data?
  /// As exported from BigSur
  let fullKey: Data?
}

enum FindMyError: Error {
  case noFoldersFound
  case parsingFailed
}
