//
//  OpenHaystack – Tracking personal Bluetooth devices via Apple's Find My network
//
//  Copyright © 2021 Secure Mobile Networking Lab (SEEMOO)
//  Copyright © 2021 The Open Wireless Link Project
//
//  SPDX-License-Identifier: AGPL-3.0-only
//

import Cocoa
import MapKit
import SwiftUI

struct MapView: NSViewControllerRepresentable {
  @Environment(\.findMyController) var findMyController

  func makeNSViewController(context: Context) -> MapViewController {
    return MapViewController(nibName: NSNib.Name("MapViewController"), bundle: nil)
  }

  func updateNSViewController(_ nsViewController: MapViewController, context: Context) {
    nsViewController.addLocationsReports(from: findMyController.devices)
  }

}
