package pe

import (
	"crypto/x509"
	_ "embed"
	"encoding/binary"
	"fmt"
	"go.mozilla.org/pkcs7"
	"io"
)

// La sezione "security" contiene una firma chiamata authenticode che è un formato di firma
// utilizzato per verificare l'integrità e l'origine del software.
func readSecuritySection(virtualAddress uint32) {
	// WinRootCertificate
	rootCertificateMicrosoft := []byte{48, 130, 2, 89, 48, 130, 1, 223, 160, 3, 2, 1, 2, 2, 16, 102, 242, 61, 175, 135, 222, 139, 177, 74, 234, 12, 87, 49, 1, 194, 236, 48, 10, 6, 8, 42, 134, 72, 206, 61, 4, 3, 3, 48, 101, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 30, 48, 28, 6, 3, 85, 4, 10, 19, 21, 77, 105, 99, 114, 111, 115, 111, 102, 116, 32, 67, 111, 114, 112, 111, 114, 97, 116, 105, 111, 110, 49, 54, 48, 52, 6, 3, 85, 4, 3, 19, 45, 77, 105, 99, 114, 111, 115, 111, 102, 116, 32, 69, 67, 67, 32, 82, 111, 111, 116, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 101, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 32, 50, 48, 49, 55, 48, 30, 23, 13, 49, 57, 49, 50, 49, 56, 50, 51, 48, 54, 52, 53, 90, 23, 13, 52, 50, 48, 55, 49, 56, 50, 51, 49, 54, 48, 52, 90, 48, 101, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 30, 48, 28, 6, 3, 85, 4, 10, 19, 21, 77, 105, 99, 114, 111, 115, 111, 102, 116, 32, 67, 111, 114, 112, 111, 114, 97, 116, 105, 111, 110, 49, 54, 48, 52, 6, 3, 85, 4, 3, 19, 45, 77, 105, 99, 114, 111, 115, 111, 102, 116, 32, 69, 67, 67, 32, 82, 111, 111, 116, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 101, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 32, 50, 48, 49, 55, 48, 118, 48, 16, 6, 7, 42, 134, 72, 206, 61, 2, 1, 6, 5, 43, 129, 4, 0, 34, 3, 98, 0, 4, 212, 188, 61, 2, 66, 117, 65, 19, 35, 205, 128, 4, 134, 2, 81, 47, 106, 168, 129, 98, 11, 101, 204, 246, 202, 157, 30, 111, 74, 102, 81, 162, 3, 217, 157, 145, 250, 182, 22, 177, 140, 110, 222, 124, 205, 219, 121, 166, 47, 206, 187, 206, 113, 47, 229, 165, 171, 40, 236, 99, 4, 102, 153, 248, 250, 242, 147, 16, 5, 225, 129, 40, 66, 227, 198, 104, 244, 230, 27, 132, 96, 74, 137, 175, 237, 121, 15, 59, 206, 241, 246, 68, 245, 1, 120, 192, 163, 84, 48, 82, 48, 14, 6, 3, 85, 29, 15, 1, 1, 255, 4, 4, 3, 2, 1, 134, 48, 15, 6, 3, 85, 29, 19, 1, 1, 255, 4, 5, 48, 3, 1, 1, 255, 48, 29, 6, 3, 85, 29, 14, 4, 22, 4, 20, 200, 203, 153, 114, 112, 82, 12, 248, 230, 190, 178, 4, 87, 41, 42, 207, 66, 16, 237, 53, 48, 16, 6, 9, 43, 6, 1, 4, 1, 130, 55, 21, 1, 4, 3, 2, 1, 0, 48, 10, 6, 8, 42, 134, 72, 206, 61, 4, 3, 3, 3, 104, 0, 48, 101, 2, 48, 88, 242, 77, 234, 12, 249, 95, 94, 238, 96, 41, 203, 58, 242, 219, 214, 50, 132, 25, 63, 124, 213, 47, 194, 177, 204, 147, 174, 80, 187, 9, 50, 198, 198, 237, 126, 201, 54, 148, 18, 228, 104, 133, 6, 162, 27, 208, 47, 2, 49, 0, 153, 233, 22, 180, 14, 250, 86, 72, 212, 164, 48, 22, 145, 120, 219, 84, 140, 101, 1, 138, 231, 80, 102, 194, 49, 183, 57, 186, 184, 26, 34, 7, 78, 252, 107, 84, 22, 32, 255, 43, 181, 231, 76, 12, 77, 166, 79, 115}
	rootCertificateMicrosoft2010 := []byte{48, 130, 5, 237, 48, 130, 3, 213, 160, 3, 2, 1, 2, 2, 16, 40, 204, 58, 37, 191, 186, 68, 172, 68, 154, 155, 88, 107, 67, 57, 170, 48, 13, 6, 9, 42, 134, 72, 134, 247, 13, 1, 1, 11, 5, 0, 48, 129, 136, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 19, 48, 17, 6, 3, 85, 4, 8, 19, 10, 87, 97, 115, 104, 105, 110, 103, 116, 111, 110, 49, 16, 48, 14, 6, 3, 85, 4, 7, 19, 7, 82, 101, 100, 109, 111, 110, 100, 49, 30, 48, 28, 6, 3, 85, 4, 10, 19, 21, 77, 105, 99, 114, 111, 115, 111, 102, 116, 32, 67, 111, 114, 112, 111, 114, 97, 116, 105, 111, 110, 49, 50, 48, 48, 6, 3, 85, 4, 3, 19, 41, 77, 105, 99, 114, 111, 115, 111, 102, 116, 32, 82, 111, 111, 116, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 101, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 32, 50, 48, 49, 48, 48, 30, 23, 13, 49, 48, 48, 54, 50, 51, 50, 49, 53, 55, 50, 52, 90, 23, 13, 51, 53, 48, 54, 50, 51, 50, 50, 48, 52, 48, 49, 90, 48, 129, 136, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 19, 48, 17, 6, 3, 85, 4, 8, 19, 10, 87, 97, 115, 104, 105, 110, 103, 116, 111, 110, 49, 16, 48, 14, 6, 3, 85, 4, 7, 19, 7, 82, 101, 100, 109, 111, 110, 100, 49, 30, 48, 28, 6, 3, 85, 4, 10, 19, 21, 77, 105, 99, 114, 111, 115, 111, 102, 116, 32, 67, 111, 114, 112, 111, 114, 97, 116, 105, 111, 110, 49, 50, 48, 48, 6, 3, 85, 4, 3, 19, 41, 77, 105, 99, 114, 111, 115, 111, 102, 116, 32, 82, 111, 111, 116, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 101, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 32, 50, 48, 49, 48, 48, 130, 2, 34, 48, 13, 6, 9, 42, 134, 72, 134, 247, 13, 1, 1, 1, 5, 0, 3, 130, 2, 15, 0, 48, 130, 2, 10, 2, 130, 2, 1, 0, 185, 8, 158, 40, 228, 228, 236, 6, 78, 80, 104, 179, 65, 197, 123, 235, 174, 182, 142, 175, 129, 186, 34, 68, 31, 101, 52, 105, 76, 190, 112, 64, 23, 242, 22, 123, 226, 121, 253, 134, 237, 13, 57, 244, 27, 168, 173, 146, 144, 30, 203, 61, 118, 143, 90, 217, 181, 145, 16, 46, 60, 5, 141, 138, 109, 36, 84, 231, 31, 237, 86, 173, 131, 180, 80, 156, 21, 165, 23, 116, 136, 89, 32, 252, 8, 197, 132, 118, 211, 104, 212, 111, 40, 120, 206, 92, 184, 243, 80, 144, 68, 255, 227, 99, 95, 190, 161, 154, 44, 150, 21, 4, 214, 7, 254, 30, 132, 33, 224, 66, 49, 17, 196, 40, 54, 148, 207, 80, 164, 98, 158, 201, 214, 171, 113, 0, 178, 91, 12, 230, 150, 212, 10, 36, 150, 245, 255, 198, 213, 183, 27, 215, 203, 183, 33, 98, 175, 18, 220, 161, 93, 55, 227, 26, 251, 26, 70, 152, 192, 155, 192, 231, 99, 31, 42, 8, 147, 2, 126, 30, 106, 142, 242, 159, 24, 137, 228, 34, 133, 162, 177, 132, 87, 64, 255, 245, 14, 216, 111, 156, 237, 226, 69, 49, 1, 205, 23, 233, 127, 176, 129, 69, 227, 170, 33, 64, 38, 161, 114, 170, 167, 79, 60, 1, 5, 126, 238, 131, 88, 177, 94, 6, 99, 153, 98, 145, 120, 130, 183, 13, 147, 12, 36, 106, 180, 27, 219, 39, 236, 95, 149, 4, 63, 147, 74, 48, 245, 151, 24, 179, 167, 249, 25, 167, 147, 51, 29, 1, 200, 219, 34, 82, 92, 215, 37, 201, 70, 249, 162, 251, 135, 89, 67, 190, 155, 98, 177, 141, 45, 134, 68, 26, 70, 172, 120, 97, 126, 48, 9, 250, 174, 137, 196, 65, 42, 34, 102, 3, 145, 57, 69, 156, 199, 139, 12, 168, 202, 13, 47, 251, 82, 234, 12, 247, 99, 51, 35, 157, 254, 176, 31, 173, 103, 214, 167, 80, 3, 198, 4, 112, 99, 181, 44, 177, 134, 90, 67, 183, 251, 174, 249, 110, 41, 110, 33, 33, 65, 38, 6, 140, 201, 195, 238, 176, 194, 133, 147, 161, 185, 133, 217, 230, 50, 108, 75, 76, 63, 214, 93, 163, 229, 181, 157, 119, 195, 156, 192, 85, 183, 116, 0, 227, 184, 56, 171, 131, 151, 80, 225, 154, 66, 36, 29, 198, 192, 163, 48, 209, 26, 90, 200, 82, 52, 247, 115, 241, 199, 24, 31, 51, 173, 122, 236, 203, 65, 96, 243, 35, 148, 32, 194, 72, 69, 172, 92, 81, 198, 46, 128, 194, 226, 119, 21, 189, 133, 135, 237, 54, 157, 150, 145, 238, 0, 181, 163, 112, 236, 159, 227, 141, 128, 104, 131, 118, 186, 175, 93, 112, 82, 34, 22, 226, 102, 251, 186, 179, 197, 194, 247, 62, 47, 119, 166, 202, 222, 193, 166, 198, 72, 76, 195, 55, 81, 35, 211, 39, 215, 184, 78, 112, 150, 240, 161, 68, 118, 175, 120, 207, 154, 225, 102, 19, 2, 3, 1, 0, 1, 163, 81, 48, 79, 48, 11, 6, 3, 85, 29, 15, 4, 4, 3, 2, 1, 134, 48, 15, 6, 3, 85, 29, 19, 1, 1, 255, 4, 5, 48, 3, 1, 1, 255, 48, 29, 6, 3, 85, 29, 14, 4, 22, 4, 20, 213, 246, 86, 203, 143, 232, 162, 92, 98, 104, 209, 61, 148, 144, 91, 215, 206, 154, 24, 196, 48, 16, 6, 9, 43, 6, 1, 4, 1, 130, 55, 21, 1, 4, 3, 2, 1, 0, 48, 13, 6, 9, 42, 134, 72, 134, 247, 13, 1, 1, 11, 5, 0, 3, 130, 2, 1, 0, 172, 165, 150, 140, 191, 187, 174, 166, 246, 215, 113, 135, 67, 49, 86, 136, 253, 28, 50, 113, 91, 53, 183, 212, 240, 145, 242, 175, 55, 226, 20, 241, 243, 2, 38, 5, 62, 22, 20, 127, 20, 186, 184, 79, 251, 137, 178, 178, 231, 212, 9, 204, 109, 185, 91, 59, 100, 101, 112, 102, 183, 242, 177, 90, 223, 26, 2, 243, 245, 81, 184, 103, 109, 121, 243, 191, 86, 123, 228, 132, 185, 43, 30, 155, 64, 156, 38, 52, 249, 71, 24, 152, 105, 216, 28, 215, 182, 209, 191, 143, 97, 194, 103, 196, 181, 239, 96, 67, 142, 16, 27, 54, 73, 228, 32, 202, 173, 167, 193, 177, 39, 101, 9, 248, 205, 245, 91, 42, 208, 132, 51, 243, 239, 31, 242, 245, 156, 11, 88, 147, 55, 160, 117, 160, 222, 114, 222, 108, 117, 42, 102, 34, 245, 140, 6, 48, 86, 159, 64, 185, 48, 170, 64, 119, 21, 130, 215, 139, 236, 192, 211, 178, 189, 131, 197, 119, 12, 30, 174, 175, 25, 83, 160, 77, 121, 113, 159, 15, 175, 48, 206, 103, 249, 214, 44, 204, 34, 65, 122, 7, 242, 151, 66, 24, 206, 89, 121, 16, 85, 222, 111, 16, 228, 184, 218, 131, 102, 64, 22, 9, 104, 35, 91, 151, 46, 38, 154, 2, 187, 87, 140, 197, 184, 186, 105, 98, 50, 128, 137, 158, 161, 253, 192, 146, 124, 123, 43, 51, 25, 132, 42, 99, 197, 0, 104, 98, 250, 159, 71, 141, 153, 122, 69, 58, 167, 233, 237, 238, 105, 66, 181, 243, 129, 155, 71, 86, 16, 123, 252, 112, 54, 132, 24, 115, 234, 239, 249, 151, 77, 158, 51, 35, 221, 38, 11, 186, 42, 183, 63, 68, 220, 131, 39, 255, 189, 97, 89, 43, 17, 183, 202, 79, 219, 197, 139, 12, 28, 49, 174, 50, 248, 248, 185, 66, 247, 127, 220, 97, 154, 118, 177, 90, 4, 225, 17, 61, 102, 69, 183, 24, 113, 190, 201, 36, 133, 214, 243, 212, 186, 65, 52, 93, 18, 45, 37, 185, 141, 166, 19, 72, 109, 75, 176, 7, 125, 153, 147, 9, 97, 129, 116, 87, 38, 138, 171, 105, 227, 228, 217, 199, 136, 204, 36, 216, 236, 82, 36, 92, 30, 188, 145, 20, 226, 150, 222, 235, 10, 218, 158, 221, 95, 179, 91, 219, 212, 130, 236, 198, 32, 80, 135, 37, 64, 58, 251, 199, 238, 205, 254, 51, 229, 110, 195, 132, 9, 85, 3, 37, 57, 192, 233, 53, 93, 101, 49, 168, 246, 191, 160, 9, 205, 41, 199, 179, 54, 50, 46, 220, 149, 243, 131, 193, 90, 207, 139, 141, 246, 234, 179, 33, 248, 164, 237, 30, 49, 14, 182, 76, 17, 171, 96, 11, 164, 18, 35, 34, 23, 163, 54, 100, 130, 145, 4, 18, 224, 171, 111, 30, 203, 80, 5, 97, 180, 64, 255, 89, 134, 113, 209, 213, 51, 105, 124, 169, 115, 138, 56, 215, 100, 12, 241, 105}
	section := getSectionFromVirtualAddress(uint64(virtualAddress))

	if section == nil {
		fmt.Println("Non esiste la sezione \"Security\" per questo binario")
		return
	}

	//offset := virtualAddress - section.VirtualAddress
	offset := virtualAddress
	if offset < 0 {
		fmt.Println("L'offset non può essere minore di 0.")
		return
	}

	for {
		_, err := reader.Seek(int64(offset), io.SeekStart)
		var reasonString string
		if err != nil {
			fmt.Println("Impossibile effettuare il seek per il seguente motivo: " + err.Error())
			return
		}

		// Parsa ogni certificato
		var Certificate WinCertificate

		err = binary.Read(reader, binary.LittleEndian, &Certificate)
		if err != nil {
			fmt.Println("Impossibile leggere la struttura WinCertificate per il seguente motivo: " + err.Error())
			return
		}

		if Certificate.Length == 0 {
			fmt.Println("Errore: certificato invalido")
			return
		}

		fmt.Printf("%+v\n", Certificate)

		certificateContent := make([]byte, Certificate.Length-uint32(binary.Size(WinCertificate{})))
		err = binary.Read(reader, binary.LittleEndian, certificateContent)
		if err != nil {
			fmt.Println("Impossibile leggere il contenuto del certificato " + err.Error())
			return
		}

		pkcs, err := pkcs7.Parse(certificateContent)
		if err != nil {
			reasonString = err.Error()
			fmt.Println("Errore: il certificato non è valido: " + reasonString)
			fileAnalyzed.SecuritySection = append(fileAnalyzed.SecuritySection, SecurityHeader{Header: Certificate, Content: pkcs, IsSigned: false, ReasonFail: reasonString})
			return
		}

		/*
			for _, cert := range pkcs.Certificates {
				fmt.Printf("%+v\n", cert)
			}*/

		// Verifica la signature
		certPool, err := x509.SystemCertPool()
		if err != nil {
			fmt.Println("Impossibile ottenere la pool dei certificati di sistema")
			return
		}

		// Aggiungiamo alcuni certificati
		crt, err := x509.ParseCertificate(rootCertificateMicrosoft2010)
		if err != nil {
			fmt.Println("Errore nel parsing del primo certificato: " + err.Error())
		}
		certPool.AddCert(crt)

		crt, err = x509.ParseCertificate(rootCertificateMicrosoft)
		if err != nil {
			fmt.Println("Errore nel parsing del secondo certificato: " + err.Error())
		}
		certPool.AddCert(crt)

		isValid := true
		err = pkcs.VerifyWithChain(certPool)
		if err != nil {
			reasonString = err.Error()
			fmt.Println("Il certificato non è valido: " + err.Error())
			isValid = false
		}

		offset = Certificate.Length + offset
		offset = offset + 8 - 1
		fileAnalyzed.SecuritySection = append(fileAnalyzed.SecuritySection, SecurityHeader{Header: Certificate, Content: pkcs, IsSigned: isValid, ReasonFail: reasonString})
	}

}
