### PHP Security Check List [ EN ]

<img src="https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg"> <img src="https://img.shields.io/github/stars/security-checklist/php-security-check-list?style=social"> <img src="https://img.shields.io/github/forks/security-checklist/php-security-check-list?style=social"> <img src="https://img.shields.io/github/repo-size/security-checklist/php-security-check-list"> <img src="https://img.shields.io/github/license/anti-ddos/Anti-DDOS"> <img src="https://img.shields.io/github/issues/detail/author/security-checklist/php-security-check-list/2">

![PHP-Security-Check-List](/image/php-image.png)

PHP: Hypertext Preprocessor is a web-based, server-side, multi-use, general-purpose, scripting and programming language that can be embedded in HTML. The PHP development, which was first created by Rasmus Lerdorf in 1995, is now being run by the PHP community.

The PHP programming language is still used by a large developer. It is the most known backend programming language. In PHP web applications, I prepared a list called "php security check list" which security researchers should know.

* [Full Path Disclosure](https://www.owasp.org/index.php/Full_Path_Disclosure)
* [Arbitrary File Upload](https://www.owasp.org/index.php/Unrestricted_File_Upload)
* [Arbitrary File Delete](https://www.acunetix.com/vulnerabilities/web/arbitrary-file-deletion/)
* [Arbitrary File Download](https://resources.infosecinstitute.com/arbitrary-file-download-breaking-into-the-system/#gref)
* [Local File Inclusion](https://www.offensive-security.com/metasploit-unleashed/file-inclusion-vulnerabilities/)
* [Remote File Inclusion](https://www.owasp.org/index.php/Testing_for_Remote_File_Inclusion)
* [Cookie Injection](https://www.owasp.org/index.php/Testing_for_cookies_attributes_(OTG-SESS-002))
* [Session hijacking](https://www.owasp.org/index.php/Session_hijacking_attack)
* [Header Injection](https://www.owasp.org/index.php/Testing_for_HTTP_Parameter_pollution_(OTG-INPVAL-004))
* [SQL Injection](https://www.owasp.org/index.php/SQL_Injection)
* [XML Injection](https://www.owasp.org/index.php/Testing_for_XML_Injection_(OTG-INPVAL-008))
* [XXE Injection](https://www.owasp.org/index.php/XML_External_Entity_(XXE)_Processing)
* [Email Injection](https://www.owasp.org/index.php/Testing_for_IMAP/SMTP_Injection_(OTG-INPVAL-011))
* [HTML Injection](https://www.owasp.org/index.php/Testing_for_HTML_Injection_(OTG-CLIENT-003))
* [xPath Injection](https://www.owasp.org/index.php/XPATH_Injection)
* [Code Injection](https://www.owasp.org/index.php/Code_Injection)
* [Command Injection](https://www.owasp.org/index.php/Command_Injection)
* [Object Injection](https://www.owasp.org/index.php/PHP_Object_Injection)
* [Cross Site Scripting](https://www.owasp.org/index.php/Cross-site_Scripting_(XSS))
* [Cross Site Request Forgery](https://www.owasp.org/index.php/Cross-Site_Request_Forgery_(CSRF))
* [Broken Authentication and Session Management](https://www.owasp.org/index.php/Broken_Authentication_and_Session_Management)
* [Session Hijacking Attack](https://www.owasp.org/index.php/Session_hijacking_attack)
