from tensorflow.python.framework import ops as ops
from tensorflow.python.util import tf_decorator as tf_decorator, tf_inspect as tf_inspect, traceback_utils as traceback_utils, type_annotations as type_annotations
from tensorflow.python.util.lazy_loader import LazyLoader as LazyLoader
from tensorflow.python.util.tf_export import tf_export as tf_export
from typing import Any

extension_type: Any
FALLBACK_DISPATCH_ATTR: str
TYPE_BASED_DISPATCH_ATTR: str

class OpDispatcher:
    NOT_SUPPORTED: Any
    def handle(self, args, kwargs): ...
    def register(self, op) -> None: ...

class GlobalOpDispatcher:
    NOT_SUPPORTED: Any
    def handle(self, op, args, kwargs) -> None: ...
    def register(self) -> None: ...

def dispatch(op, args, kwargs): ...

class _TypeBasedDispatcher(OpDispatcher):
    def __init__(self, override_func, types) -> None: ...
    def handle(self, args, kwargs): ...

def dispatch_for_types(op, *types): ...
def add_fallback_dispatch_list(target): ...
add_dispatch_list = add_fallback_dispatch_list

def dispatch_for_api(api, *signatures): ...
def apis_with_type_based_dispatch(): ...
def type_based_dispatch_signatures_for(cls): ...
def unregister_dispatch_for(dispatch_target) -> None: ...
def register_dispatchable_type(cls): ...
def add_type_based_api_dispatcher(target): ...
def make_type_checker(annotation): ...
def dispatch_for_unary_elementwise_apis(x_type): ...
def dispatch_for_binary_elementwise_apis(x_type, y_type): ...
def register_unary_elementwise_api(func): ...
def register_binary_elementwise_api(func): ...
def unary_elementwise_apis(): ...
def binary_elementwise_apis(): ...
def update_docstrings_with_api_lists() -> None: ...
def add_dispatch_support(target: Any | None = ..., iterable_parameters: Any | None = ...): ...
def replace_iterable_params(args, kwargs, iterable_params): ...
