import abc
from tensorflow.core.protobuf import trackable_object_graph_pb2 as trackable_object_graph_pb2
from tensorflow.python.client import session as session_lib
from tensorflow.python.eager import context as context, def_function as def_function
from tensorflow.python.framework import constant_op as constant_op, dtypes as dtypes, errors_impl as errors_impl, ops as ops, tensor_shape as tensor_shape, tensor_util as tensor_util
from tensorflow.python.lib.io import file_io as file_io
from tensorflow.python.ops import array_ops as array_ops, init_ops as init_ops, variable_scope as variable_scope, variables as variables
from tensorflow.python.platform import gfile as gfile
from tensorflow.python.saved_model import utils_impl as utils_impl
from tensorflow.python.saved_model.pywrap_saved_model import metrics as metrics
from tensorflow.python.training import checkpoint_management as checkpoint_management, py_checkpoint_reader as py_checkpoint_reader
from tensorflow.python.training.saving import checkpoint_options as checkpoint_options, functional_saver as functional_saver, saveable_object_util as saveable_object_util
from tensorflow.python.training.tracking import base as base, data_structures as data_structures, tracking as tracking
from tensorflow.python.util import compat as compat, deprecation as deprecation, object_identity as object_identity, tf_contextlib as tf_contextlib, tf_inspect as tf_inspect
from tensorflow.python.util.tf_export import tf_export as tf_export
from typing import Any

def register_session_provider(session_provider) -> None: ...
def get_session(): ...

class _ObjectGraphProtoPrettyPrinter:
    def __init__(self, object_graph_proto) -> None: ...
    @property
    def node_names(self): ...

class _CheckpointRestoreCoordinatorDeleter:
    expect_partial: Any
    object_graph_proto: Any
    matched_proto_ids: Any
    unused_attributes: Any
    def __init__(self, expect_partial, object_graph_proto, matched_proto_ids, unused_attributes) -> None: ...
    def set_expect_partial(self, expect_partial) -> None: ...
    def __del__(self) -> None: ...

class _CheckpointRestoreCoordinator:
    options: Any
    object_graph_proto: Any
    restore_uid: Any
    unused_attributes: Any
    object_by_proto_id: Any
    matched_proto_ids: Any
    all_python_objects: Any
    save_path_tensor: Any
    save_path_string: Any
    dtype_map: Any
    shape_map: Any
    restore_ops: Any
    restore_ops_by_name: Any
    graph_view: Any
    new_restore_ops_callback: Any
    deferred_slot_restorations: Any
    slot_restorations: Any
    expect_partial_attr: bool
    def __init__(self, object_graph_proto, save_path, save_path_tensor, restore_op_cache, graph_view, options) -> None: ...
    @property
    def expect_partial(self): ...
    @expect_partial.setter
    def expect_partial(self, expect_partial) -> None: ...
    def new_restore_ops(self, new_ops) -> None: ...
    def restore_saveables(self, tensor_saveables, python_saveables): ...

class _NameBasedRestoreCoordinator:
    save_path: Any
    dtype_map: Any
    unused_attributes: Any
    restore_uid: Any
    def __init__(self, save_path, dtype_map: Any | None = ...) -> None: ...
    def globally_named_object_attributes(self, trackable) -> None: ...
    def eager_restore(self, trackable) -> None: ...

def add_variable(trackable, name, shape: Any | None = ..., dtype=..., initializer: Any | None = ..., trainable: bool = ...): ...
def object_metadata(save_path): ...
def list_objects(root_trackable): ...
def gather_initializers(root_trackable): ...
def capture_dependencies(template): ...

class _LoadStatus(metaclass=abc.ABCMeta):
    @abc.abstractmethod
    def assert_consumed(self): ...
    @abc.abstractmethod
    def assert_existing_objects_matched(self): ...
    @abc.abstractmethod
    def assert_nontrivial_match(self): ...
    @abc.abstractmethod
    def run_restore_ops(self, session: Any | None = ...): ...
    @abc.abstractmethod
    def initialize_or_restore(self, session: Any | None = ...): ...
    def expect_partial(self): ...

def streaming_restore(status, session: Any | None = ...): ...

class CheckpointLoadStatus(_LoadStatus):
    def __init__(self, checkpoint, feed_dict, graph_view) -> None: ...
    def assert_consumed(self): ...
    def assert_existing_objects_matched(self): ...
    def assert_nontrivial_match(self): ...
    def run_restore_ops(self, session: Any | None = ...) -> None: ...
    def initialize_or_restore(self, session: Any | None = ...) -> None: ...
    def expect_partial(self): ...

class InitializationOnlyStatus(_LoadStatus):
    def __init__(self, graph_view, restore_uid) -> None: ...
    def assert_consumed(self) -> None: ...
    def assert_existing_objects_matched(self) -> None: ...
    def assert_nontrivial_match(self) -> None: ...
    def run_restore_ops(self, session: Any | None = ...) -> None: ...
    def initialize_or_restore(self, session: Any | None = ...) -> None: ...

class NameBasedSaverStatus(_LoadStatus):
    def __init__(self, checkpoint, graph_view) -> None: ...
    def add_to_optionally_restored(self, var) -> None: ...
    def assert_consumed(self): ...
    def assert_existing_objects_matched(self): ...
    def assert_nontrivial_match(self): ...
    def run_restore_ops(self, session: Any | None = ...) -> None: ...
    def initialize_or_restore(self, session: Any | None = ...) -> None: ...

class _SessionWithFeedDictAdditions(session_lib.SessionInterface):
    def __init__(self, session, feed_additions) -> None: ...
    def run(self, fetches, feed_dict: Any | None = ..., **kwargs): ...

class TrackableSaver:
    def __init__(self, graph_view) -> None: ...
    def save(self, file_prefix, checkpoint_number: Any | None = ..., session: Any | None = ..., options: Any | None = ...): ...
    def restore(self, save_path, options: Any | None = ...): ...

def frozen_saver(root_trackable): ...
def saver_with_op_caching(obj, attached_dependencies: Any | None = ...): ...

class CheckpointV1(tracking.AutoTrackable):
    def __init__(self, **kwargs): ...
    def write(self, file_prefix, session: Any | None = ...): ...
    @property
    def save_counter(self): ...
    def save(self, file_prefix, session: Any | None = ...): ...
    def restore(self, save_path): ...

class Checkpoint(tracking.AutoTrackable):
    def __init__(self, root: Any | None = ..., **kwargs): ...
    def write(self, file_prefix, options: Any | None = ...): ...
    @property
    def save_counter(self): ...
    def save(self, file_prefix, options: Any | None = ...): ...
    def read(self, save_path, options: Any | None = ...): ...
    def restore(self, save_path, options: Any | None = ...): ...
