from .....third_party import wrapt
from tensorflow.python.eager import def_function as def_function
from tensorflow.python.ops import variables as variables
from tensorflow.python.saved_model import revived_types as revived_types
from tensorflow.python.training.tracking import base as base, layer_utils as layer_utils
from tensorflow.python.util import lazy_loader as lazy_loader
from tensorflow.python.util.compat import collections_abc as collections_abc
from tensorflow.python.util.tf_export import tf_export as tf_export
from typing import Any

module: Any

class NoDependency:
    value: Any
    def __init__(self, value) -> None: ...

def wrap_or_unwrap(value): ...
def sticky_attribute_assignment(trackable, name, value): ...

class _UntrackableError(ValueError):
    def __init__(self, value) -> None: ...

class TrackableDataStructure(base.Trackable):
    def __init__(self) -> None: ...
    @property
    def trainable(self): ...
    @trainable.setter
    def trainable(self, value) -> None: ...
    @property
    def layers(self): ...
    @property
    def trainable_weights(self): ...
    @property
    def non_trainable_weights(self): ...
    @property
    def weights(self): ...
    @property
    def trainable_variables(self): ...
    @property
    def non_trainable_variables(self): ...
    @property
    def variables(self): ...
    @property
    def updates(self): ...
    @property
    def losses(self): ...
    def __hash__(self): ...
    def __eq__(self, other): ...

class List(TrackableDataStructure, collections_abc.Sequence):
    def __init__(self, *args, **kwargs) -> None: ...
    def copy(self): ...
    def __copy__(self): ...
    def __deepcopy__(self, memo): ...
    def append(self, value) -> None: ...
    def extend(self, values) -> None: ...
    def __iadd__(self, values): ...
    def __add__(self, other): ...
    def __imul__(self, y): ...
    def __mul__(self, n): ...
    def __rmul__(self, n): ...
    def __radd__(self, other): ...
    def __getitem__(self, key): ...
    def __getslice__(self, i, j): ...
    def __len__(self): ...
    def __sizeof__(self): ...

class ListWrapper(List, collections_abc.MutableSequence, list):
    def __init__(self, wrapped_list) -> None: ...
    def __copy__(self): ...
    def __deepcopy__(self, memo): ...
    def __reduce_ex__(self, protocol): ...
    def __delitem__(self, key) -> None: ...
    def __setitem__(self, key, value) -> None: ...
    def append(self, value) -> None: ...
    def extend(self, values) -> None: ...
    def __imul__(self, y): ...
    def __eq__(self, other): ...
    def __ne__(self, other): ...
    def __lt__(self, other): ...
    def __le__(self, other): ...
    def __gt__(self, other): ...
    def __ge__(self, other): ...
    def __hash__(self): ...
    def insert(self, index, obj) -> None: ...
    def sort(self) -> None: ...
    def __setslice__(self, i, j, y) -> None: ...
    def __delslice__(self, i, j) -> None: ...

class Mapping(TrackableDataStructure, collections_abc.Mapping):
    def __init__(self, *args, **kwargs) -> None: ...
    def __copy__(self): ...
    def __deepcopy__(self, memo): ...
    def __setitem__(self, key, value) -> None: ...
    def update(self, *args, **kwargs) -> None: ...
    def __getitem__(self, key): ...
    def __len__(self): ...
    def __iter__(self): ...

class _DictWrapper(TrackableDataStructure, wrapt.ObjectProxy):
    def __init__(self, wrapped_dict: Any | None = ...) -> None: ...
    def __reduce_ex__(self, protocol): ...
    def __getattribute__(self, name): ...
    def copy(self): ...
    def __copy__(self): ...
    def __deepcopy__(self, memo): ...
    def __setitem__(self, key, value) -> None: ...
    def __delitem__(self, key) -> None: ...
    def __hash__(self): ...
    def __eq__(self, other): ...
    def update(self, *args, **kwargs) -> None: ...

class _TupleWrapper(TrackableDataStructure, wrapt.ObjectProxy):
    def __init__(self, original_wrapped_tuple=...) -> None: ...
    def __hash__(self): ...
    def __eq__(self, other): ...
    def __copy__(self): ...
    def __deepcopy__(self, memo): ...
    def __reduce_ex__(self, protocol): ...
    def __imul__(self, y): ...
    def __iadd__(self, y): ...
    def __getattribute__(self, name): ...
