from tensorflow.core.framework.summary_pb2 import Summary as Summary
from tensorflow.core.util.event_pb2 import SessionLog as SessionLog
from tensorflow.python.eager import context as context
from tensorflow.python.framework import dtypes as dtypes, meta_graph as meta_graph, ops as ops
from tensorflow.python.ops import control_flow_ops as control_flow_ops, lookup_ops as lookup_ops, variables as variables
from tensorflow.python.training import coordinator as coordinator, training_util as training_util
from tensorflow.python.util import deprecation as deprecation
from tensorflow.python.util.tf_export import tf_export as tf_export
from typing import Any

class Supervisor:
    USE_DEFAULT: int
    def __init__(self, graph: Any | None = ..., ready_op=..., ready_for_local_init_op=..., is_chief: bool = ..., init_op=..., init_feed_dict: Any | None = ..., local_init_op=..., logdir: Any | None = ..., summary_op=..., saver=..., global_step=..., save_summaries_secs: int = ..., save_model_secs: int = ..., recovery_wait_secs: int = ..., stop_grace_secs: int = ..., checkpoint_basename: str = ..., session_manager: Any | None = ..., summary_writer=..., init_fn: Any | None = ..., local_init_run_options: Any | None = ...) -> None: ...
    @property
    def is_chief(self): ...
    @property
    def session_manager(self): ...
    @property
    def coord(self): ...
    @property
    def init_op(self): ...
    @property
    def init_feed_dict(self): ...
    @property
    def ready_op(self): ...
    @property
    def ready_for_local_init_op(self): ...
    @property
    def summary_writer(self): ...
    @property
    def summary_op(self): ...
    @property
    def save_summaries_secs(self): ...
    @property
    def global_step(self): ...
    @property
    def saver(self): ...
    @property
    def save_model_secs(self): ...
    @property
    def save_path(self): ...
    def start_standard_services(self, sess): ...
    def prepare_or_wait_for_session(self, master: str = ..., config: Any | None = ..., wait_for_checkpoint: bool = ..., max_wait_secs: int = ..., start_standard_services: bool = ...): ...
    def start_queue_runners(self, sess, queue_runners: Any | None = ...): ...
    def loop(self, timer_interval_secs, target, args: Any | None = ..., kwargs: Any | None = ...): ...
    def stop(self, threads: Any | None = ..., close_summary_writer: bool = ..., ignore_live_threads: bool = ...) -> None: ...
    def request_stop(self, ex: Any | None = ...) -> None: ...
    def should_stop(self): ...
    def stop_on_exception(self): ...
    def wait_for_stop(self) -> None: ...
    def summary_computed(self, sess, summary, global_step: Any | None = ...) -> None: ...
    def managed_session(self, master: str = ..., config: Any | None = ..., start_standard_services: bool = ..., close_summary_writer: bool = ...) -> None: ...

class SVSummaryThread(coordinator.LooperThread):
    def __init__(self, sv, sess) -> None: ...
    def run_loop(self) -> None: ...

class SVStepCounterThread(coordinator.LooperThread):
    def __init__(self, sv, sess, step_counter: Any | None = ...) -> None: ...
    def start_loop(self) -> None: ...
    def run_loop(self) -> None: ...

class SVTimerCheckpointThread(coordinator.LooperThread):
    def __init__(self, sv, sess) -> None: ...
    def run_loop(self) -> None: ...
