from tensorflow.core.protobuf import meta_graph_pb2 as meta_graph_pb2, saver_pb2 as saver_pb2, trackable_object_graph_pb2 as trackable_object_graph_pb2
from tensorflow.python.client import session as session
from tensorflow.python.eager import context as context
from tensorflow.python.framework import constant_op as constant_op, errors as errors, meta_graph as meta_graph, ops as ops
from tensorflow.python.ops import array_ops as array_ops, control_flow_ops as control_flow_ops, gen_io_ops as gen_io_ops, io_ops as io_ops, string_ops as string_ops, variables as variables
from tensorflow.python.platform import gfile as gfile
from tensorflow.python.saved_model.pywrap_saved_model import metrics as metrics
from tensorflow.python.training import checkpoint_management as checkpoint_management, py_checkpoint_reader as py_checkpoint_reader, training_util as training_util
from tensorflow.python.training.saving import saveable_object as saveable_object, saveable_object_util as saveable_object_util
from tensorflow.python.util import compat as compat
from tensorflow.python.util.tf_export import tf_export as tf_export
from typing import Any

get_checkpoint_state: Any
update_checkpoint_state: Any
generate_checkpoint_state_proto: Any
latest_checkpoint: Any
checkpoint_exists: Any
get_checkpoint_mtimes: Any
remove_checkpoint: Any

class BaseSaverBuilder:
    SaveSpec: Any
    SaveableObject: Any
    VariableSaveable: Any
    ResourceVariableSaveable: Any
    def __init__(self, write_version=...) -> None: ...
    def save_op(self, filename_tensor, saveables): ...
    def bulk_restore(self, filename_tensor, saveables, preferred_shard, restore_sequentially): ...
    def restore_op(self, filename_tensor, saveable, preferred_shard): ...
    def sharded_filename(self, filename_tensor, shard, num_shards): ...
    def build(self, names_to_saveables, reshape: bool = ..., sharded: bool = ..., max_to_keep: int = ..., keep_checkpoint_every_n_hours: float = ..., name: Any | None = ..., restore_sequentially: bool = ..., filename: str = ...): ...

class BulkSaverBuilder(BaseSaverBuilder):
    def bulk_restore(self, filename_tensor, saveables, preferred_shard, restore_sequentially): ...

class Saver:
    saver_def: Any
    def __init__(self, var_list: Any | None = ..., reshape: bool = ..., sharded: bool = ..., max_to_keep: int = ..., keep_checkpoint_every_n_hours: float = ..., name: Any | None = ..., restore_sequentially: bool = ..., saver_def: Any | None = ..., builder: Any | None = ..., defer_build: bool = ..., allow_empty: bool = ..., write_version=..., pad_step_number: bool = ..., save_relative_paths: bool = ..., filename: Any | None = ...) -> None: ...
    def build(self) -> None: ...
    def as_saver_def(self): ...
    def to_proto(self, export_scope: Any | None = ...): ...
    @staticmethod
    def from_proto(saver_def, import_scope: Any | None = ...): ...
    @property
    def last_checkpoints(self): ...
    def set_last_checkpoints(self, last_checkpoints) -> None: ...
    def set_last_checkpoints_with_time(self, last_checkpoints_with_time) -> None: ...
    def recover_last_checkpoints(self, checkpoint_paths) -> None: ...
    def save(self, sess, save_path, global_step: Any | None = ..., latest_filename: Any | None = ..., meta_graph_suffix: str = ..., write_meta_graph: bool = ..., write_state: bool = ..., strip_default_attrs: bool = ..., save_debug_info: bool = ...): ...
    def export_meta_graph(self, filename: Any | None = ..., collection_list: Any | None = ..., as_text: bool = ..., export_scope: Any | None = ..., clear_devices: bool = ..., clear_extraneous_savers: bool = ..., strip_default_attrs: bool = ..., save_debug_info: bool = ...): ...
    def restore(self, sess, save_path) -> None: ...

def import_meta_graph(meta_graph_or_file, clear_devices: bool = ..., import_scope: Any | None = ..., **kwargs): ...
def export_meta_graph(filename: Any | None = ..., meta_info_def: Any | None = ..., graph_def: Any | None = ..., saver_def: Any | None = ..., collection_list: Any | None = ..., as_text: bool = ..., graph: Any | None = ..., export_scope: Any | None = ..., clear_devices: bool = ..., clear_extraneous_savers: bool = ..., strip_default_attrs: bool = ..., save_debug_info: bool = ..., **kwargs): ...
def object_graph_key_mapping(checkpoint_path): ...
def saver_from_object_based_checkpoint(checkpoint_path, var_list: Any | None = ..., builder: Any | None = ..., names_to_keys: Any | None = ..., cached_saver: Any | None = ...): ...
