import abc
from tensorflow.core.protobuf import config_pb2 as config_pb2
from tensorflow.python.distribute import distribute_coordinator_context as distribute_coordinator_context
from tensorflow.python.framework import errors as errors, ops as ops
from tensorflow.python.ops import array_ops as array_ops, control_flow_ops as control_flow_ops, lookup_ops as lookup_ops, resources as resources, variables as variables
from tensorflow.python.summary import summary as summary
from tensorflow.python.training import basic_session_run_hooks as basic_session_run_hooks, coordinator as coordinator, queue_runner as queue_runner, session_run_hook as session_run_hook
from tensorflow.python.training.tracking import graph_view as graph_view
from tensorflow.python.util import function_utils as function_utils
from tensorflow.python.util.tf_export import tf_export as tf_export
from typing import Any

USE_DEFAULT: Any

class Scaffold:
    def __init__(self, init_op: Any | None = ..., init_feed_dict: Any | None = ..., init_fn: Any | None = ..., ready_op: Any | None = ..., ready_for_local_init_op: Any | None = ..., local_init_op: Any | None = ..., summary_op: Any | None = ..., saver: Any | None = ..., copy_from_scaffold: Any | None = ..., local_init_feed_dict: Any | None = ...): ...
    def finalize(self): ...
    @property
    def init_fn(self): ...
    @property
    def init_op(self): ...
    @property
    def ready_op(self): ...
    @property
    def ready_for_local_init_op(self): ...
    @property
    def local_init_op(self): ...
    @property
    def local_init_feed_dict(self): ...
    @property
    def summary_op(self): ...
    @property
    def saver(self): ...
    @property
    def init_feed_dict(self): ...
    @staticmethod
    def get_or_default(arg_name, collection_key, default_constructor): ...
    @staticmethod
    def default_local_init_op(): ...

def MonitoredTrainingSession(master: str = ..., is_chief: bool = ..., checkpoint_dir: Any | None = ..., scaffold: Any | None = ..., hooks: Any | None = ..., chief_only_hooks: Any | None = ..., save_checkpoint_secs=..., save_summaries_steps=..., save_summaries_secs=..., config: Any | None = ..., stop_grace_period_secs: int = ..., log_step_count_steps: int = ..., max_wait_secs: int = ..., save_checkpoint_steps=..., summary_dir: Any | None = ..., save_graph_def: bool = ...): ...

class SessionCreator(metaclass=abc.ABCMeta):
    @abc.abstractmethod
    def create_session(self): ...

class ChiefSessionCreator(SessionCreator):
    def __init__(self, scaffold: Any | None = ..., master: str = ..., config: Any | None = ..., checkpoint_dir: Any | None = ..., checkpoint_filename_with_path: Any | None = ...) -> None: ...
    def create_session(self): ...

class WorkerSessionCreator(SessionCreator):
    def __init__(self, scaffold: Any | None = ..., master: str = ..., config: Any | None = ..., max_wait_secs=...) -> None: ...
    def create_session(self): ...

class _MonitoredSession:
    def __init__(self, session_creator, hooks, should_recover, stop_grace_period_secs: int = ...) -> None: ...
    @property
    def graph(self): ...
    def run(self, fetches, feed_dict: Any | None = ..., options: Any | None = ..., run_metadata: Any | None = ...): ...
    def run_step_fn(self, step_fn): ...
    class StepContext:
        def __init__(self, session, run_with_hooks_fn) -> None: ...
        @property
        def session(self): ...
        def run_with_hooks(self, *args, **kwargs): ...
        def request_stop(self) -> None: ...
    def should_stop(self): ...
    def close(self) -> None: ...
    def __enter__(self): ...
    def __exit__(self, exception_type, exception_value, traceback): ...
    class _CoordinatedSessionCreator(SessionCreator):
        coord: Any
        tf_sess: Any
        def __init__(self, session_creator, hooks, stop_grace_period_secs) -> None: ...
        def create_session(self): ...

class MonitoredSession(_MonitoredSession):
    def __init__(self, session_creator: Any | None = ..., hooks: Any | None = ..., stop_grace_period_secs: int = ...) -> None: ...

class SingularMonitoredSession(_MonitoredSession):
    def __init__(self, hooks: Any | None = ..., scaffold: Any | None = ..., master: str = ..., config: Any | None = ..., checkpoint_dir: Any | None = ..., stop_grace_period_secs: int = ..., checkpoint_filename_with_path: Any | None = ...) -> None: ...
    def raw_session(self): ...

class _WrappedSession:
    def __init__(self, sess) -> None: ...
    @property
    def graph(self): ...
    @property
    def sess_str(self): ...
    def should_stop(self): ...
    def close(self) -> None: ...
    def run(self, *args, **kwargs): ...
    def run_step_fn(self, step_fn, raw_session, run_with_hooks): ...

class _RecoverableSession(_WrappedSession):
    def __init__(self, sess_creator) -> None: ...
    def run(self, fetches, feed_dict: Any | None = ..., options: Any | None = ..., run_metadata: Any | None = ...): ...
    def run_step_fn(self, step_fn, raw_session, run_with_hooks): ...

class _CoordinatedSession(_WrappedSession):
    def __init__(self, sess, coord, stop_grace_period_secs: int = ...) -> None: ...
    def close(self) -> None: ...
    def run(self, *args, **kwargs): ...

class _HookedSession(_WrappedSession):
    def __init__(self, sess, hooks) -> None: ...
    def run(self, fetches, feed_dict: Any | None = ..., options: Any | None = ..., run_metadata: Any | None = ...): ...
