import abc
from tensorflow.python.distribute import distribution_strategy_context as distribution_strategy_context, reduce_util as reduce_util
from tensorflow.python.eager import context as context
from tensorflow.python.framework import dtypes as dtypes, ops as ops
from tensorflow.python.ops import control_flow_ops as control_flow_ops, math_ops as math_ops, variable_scope as variable_scope, variables as variables
from tensorflow.python.training.tracking import base as trackable
from tensorflow.python.util import deprecation as deprecation, nest as nest
from tensorflow.python.util.tf_export import tf_export as tf_export

class LossScale(trackable.Trackable, metaclass=abc.ABCMeta):
    def __init__(self) -> None: ...
    @abc.abstractmethod
    def __call__(self): ...
    @abc.abstractmethod
    def update(self, grads): ...
    @abc.abstractmethod
    def get_config(self): ...
    @classmethod
    def from_config(cls, config): ...

class FixedLossScale(LossScale):
    def __init__(self, loss_scale_value) -> None: ...
    def __call__(self): ...
    def update(self, grads): ...
    def get_config(self): ...

class DynamicLossScale(LossScale):
    def __init__(self, initial_loss_scale=..., increment_period: int = ..., multiplier: float = ...) -> None: ...
    @property
    def initial_loss_scale(self): ...
    @property
    def increment_period(self): ...
    @property
    def multiplier(self): ...
    def __call__(self): ...
    def update(self, grads): ...
    def get_config(self): ...

def get(identifier): ...
