from tensorflow.core.protobuf import saver_pb2 as saver_pb2
from tensorflow.python.eager import context as context
from tensorflow.python.framework import errors as errors, ops as ops
from tensorflow.python.lib.io import file_io as file_io
from tensorflow.python.ops import variable_scope as variable_scope
from tensorflow.python.training import training_util as training_util
from tensorflow.python.training.checkpoint_state_pb2 import CheckpointState as CheckpointState
from tensorflow.python.util import compat as compat, deprecation as deprecation
from tensorflow.python.util.tf_export import tf_export as tf_export
from typing import Any

def generate_checkpoint_state_proto(save_dir, model_checkpoint_path, all_model_checkpoint_paths: Any | None = ..., all_model_checkpoint_timestamps: Any | None = ..., last_preserved_timestamp: Any | None = ...): ...
def update_checkpoint_state(save_dir, model_checkpoint_path, all_model_checkpoint_paths: Any | None = ..., latest_filename: Any | None = ..., all_model_checkpoint_timestamps: Any | None = ..., last_preserved_timestamp: Any | None = ...) -> None: ...
def update_checkpoint_state_internal(save_dir, model_checkpoint_path, all_model_checkpoint_paths: Any | None = ..., latest_filename: Any | None = ..., save_relative_paths: bool = ..., all_model_checkpoint_timestamps: Any | None = ..., last_preserved_timestamp: Any | None = ...) -> None: ...
def get_checkpoint_state(checkpoint_dir, latest_filename: Any | None = ...): ...
def latest_checkpoint(checkpoint_dir, latest_filename: Any | None = ...): ...
def checkpoint_exists_internal(checkpoint_prefix): ...
def checkpoint_exists(checkpoint_prefix): ...
def get_checkpoint_mtimes(checkpoint_prefixes): ...
def remove_checkpoint(checkpoint_prefix, checkpoint_format_version=..., meta_graph_suffix: str = ...) -> None: ...
def meta_graph_filename(checkpoint_filename, meta_graph_suffix: str = ...): ...

class CheckpointManager:
    def __init__(self, checkpoint, directory, max_to_keep, keep_checkpoint_every_n_hours: Any | None = ..., checkpoint_name: str = ..., step_counter: Any | None = ..., checkpoint_interval: Any | None = ..., init_fn: Any | None = ...) -> None: ...
    @property
    def directory(self): ...
    @property
    def checkpoint_interval(self): ...
    @property
    def latest_checkpoint(self): ...
    @property
    def checkpoints(self): ...
    @property
    def checkpoint(self): ...
    def save(self, checkpoint_number: Any | None = ..., check_interval: bool = ..., options: Any | None = ...): ...
    def restore_or_initialize(self): ...
