import enum
from tensorflow.core.framework import attr_value_pb2 as attr_value_pb2
from tensorflow.core.protobuf.tpu import tpu_embedding_configuration_pb2 as embedding_pb2
from tensorflow.python import tf2 as tf2
from tensorflow.python.compiler.xla import xla as xla
from tensorflow.python.distribute import device_util as device_util, distribution_strategy_context as distribution_strategy_context
from tensorflow.python.framework import auto_control_deps as auto_control_deps, c_api_util as c_api_util, composite_tensor as composite_tensor, config as config, constant_op as constant_op, dtypes as dtypes, errors as errors, func_graph as func_graph, function as function, ops as ops, tensor_shape as tensor_shape
from tensorflow.python.ops import array_ops as array_ops, control_flow_ops as control_flow_ops, math_ops as math_ops, variable_scope as variable_scope, variables as variables
from tensorflow.python.tpu import device_assignment as device_assignment_lib, tpu_feed as tpu_feed, tpu_function as tpu_function, tpu_name_util as tpu_name_util
from tensorflow.python.tpu.ops import tpu_ops as tpu_ops
from tensorflow.python.types import core as core_types
from tensorflow.python.util import compat as compat, nest as nest, object_identity as object_identity
from tensorflow.python.util.tf_export import tf_export as tf_export
from typing import Any, Callable, List, Optional, Text, Tuple, Union

core: Any

def initialize_system(embedding_config: Optional[embedding_pb2.TPUEmbeddingConfiguration] = ..., job: Optional[Text] = ..., compilation_failure_closes_chips: bool = ..., tpu_cancellation_closes_chips: Optional[bool] = ...) -> core_types.Tensor: ...
def initialize_system_for_tpu_embedding(embedding_config: embedding_pb2.TPUEmbeddingConfiguration, job: Optional[Text] = ...) -> ops.Operation: ...
def shutdown_system(job: Optional[Text] = ...) -> ops.Operation: ...
def is_tpu_strategy(strategy: Any) -> bool: ...
def tpu_replicated_input_resolver(op: ops.Operation, resource_reads: object_identity.ObjectIdentitySet, resource_writes: object_identity.ObjectIdentitySet) -> bool: ...

class TPUReplicateContext(control_flow_ops.XLAControlFlowContext):
    def __init__(self, name: Text, num_replicas: int, pivot: ops.Operation) -> None: ...
    def get_replicated_var_handle(self, name: Text, vars_: Union[List[core_types.Tensor], List[variables.Variable]], is_mirrored: bool = ..., is_packed: bool = ...) -> core_types.Tensor: ...
    def report_unsupported_operations(self) -> None: ...
    def EnterGradientColocation(self, op: ops.Operation, gradient_uid: Text): ...
    def ExitGradientColocation(self, op: ops.Operation, gradient_uid: Text): ...
    def Enter(self) -> None: ...
    def HostComputeCore(self) -> List[Text]: ...
    def AddOp(self, op: ops.Operation) -> None: ...
    def AddValue(self, val: core_types.Tensor) -> core_types.Tensor: ...
    def AddInnerOp(self, op: ops.Operation): ...
    @property
    def grad_state(self) -> None: ...
    @property
    def back_prop(self): ...
    def GetControlPivot(self) -> ops.Operation: ...
    def RequiresUniqueFunctionRetracing(self): ...

class OutsideCompilationV2Context(control_flow_ops.ControlFlowContext):
    def __init__(self, name: Text) -> None: ...
    def AddOp(self, op: ops.Operation) -> None: ...
    def AddInnerOp(self, op: ops.Operation) -> None: ...
    def to_control_flow_context_def(self, context_def, export_scope: Any | None = ...) -> None: ...

def outside_compilation(computation: Callable[..., Any], *args, **kwargs) -> Any: ...

class PaddingSpec(enum.IntEnum):
    AUTO: int
    POWER_OF_TWO: int

class XLAOptions:
    def __new__(cls, use_spmd_for_xla_partitioning: bool = ..., enable_xla_dynamic_padder: bool = ...): ...

def replicate(computation: Callable[..., Any], inputs: Optional[List[List[core_types.Tensor]]] = ..., infeed_queue: Optional[tpu_feed.InfeedQueue] = ..., device_assignment: Optional[device_assignment_lib.DeviceAssignment] = ..., name: Optional[Text] = ..., maximum_shapes: Optional[Any] = ..., padding_spec: Optional[PaddingSpec] = ..., xla_options: Optional[XLAOptions] = ...) -> List[Any]: ...
def split_compile_and_replicate(computation: Callable[..., Any], inputs: Optional[List[List[core_types.Tensor]]] = ..., infeed_queue: Optional[tpu_feed.InfeedQueue] = ..., device_assignment: Optional[device_assignment_lib.DeviceAssignment] = ..., name: Optional[Text] = ..., use_tpu: bool = ..., maximum_shapes: Optional[Any] = ..., padding_spec: Optional[PaddingSpec] = ..., xla_options: Optional[XLAOptions] = ...) -> List[List[core_types.Tensor]]: ...
def split_compile_and_shard(computation: Callable[..., Any], inputs: Optional[List[List[Optional[core_types.Tensor]]]] = ..., num_shards: int = ..., input_shard_axes: Optional[List[int]] = ..., outputs_from_all_shards: Union[bool, List[bool]] = ..., output_shard_axes: Optional[List[int]] = ..., infeed_queue: Optional[tpu_feed.InfeedQueue] = ..., device_assignment: Optional[device_assignment_lib.DeviceAssignment] = ..., name: Optional[Text] = ..., xla_options: Optional[XLAOptions] = ...) -> Tuple[ops.Operation, List[core_types.Tensor]]: ...
def shard(computation: Callable[..., Any], inputs: Optional[List[core_types.Tensor]] = ..., num_shards: int = ..., input_shard_axes: Optional[List[int]] = ..., outputs_from_all_shards: Union[bool, List[bool]] = ..., output_shard_axes: Optional[List[int]] = ..., infeed_queue: Optional[tpu_feed.InfeedQueue] = ..., device_assignment: Optional[device_assignment_lib.DeviceAssignment] = ..., name: Optional[Text] = ..., xla_options: Optional[XLAOptions] = ...) -> List[core_types.Tensor]: ...
def batch_parallel(computation: Callable[..., Any], inputs: Optional[List[List[Optional[core_types.Tensor]]]] = ..., num_shards: int = ..., infeed_queue: Optional[tpu_feed.InfeedQueue] = ..., device_assignment: Optional[device_assignment_lib.DeviceAssignment] = ..., name: Optional[Text] = ..., xla_options: Optional[XLAOptions] = ...): ...
def rewrite(computation: Callable[..., Any], inputs: Optional[List[List[Optional[core_types.Tensor]]]] = ..., infeed_queue: Optional[tpu_feed.InfeedQueue] = ..., device_assignment: Optional[device_assignment_lib.DeviceAssignment] = ..., name: Optional[Text] = ..., xla_options: Optional[XLAOptions] = ...) -> Any: ...
def under_tpu_inference_context() -> bool: ...

class _TPUInferenceContext(control_flow_ops.XLAControlFlowContext):
    def __init__(self, name: Text, check_ops: bool = ...) -> None: ...
    def AddOp(self, op) -> None: ...
    def AddValue(self, val): ...
    def AddInnerOp(self, op) -> None: ...
    @property
    def grad_state(self) -> None: ...

def validate_inference_rewrite_for_variables(graph: ops.Graph): ...
def rewrite_for_inference(computation: Callable[..., Any], inputs: Optional[List[core_types.Tensor]] = ..., infeed_queue: Optional[tpu_feed.InfeedQueue] = ..., device_assignment: Optional[device_assignment_lib.DeviceAssignment] = ..., name: Optional[Text] = ...) -> List[core_types.Tensor]: ...
def prune_unconnected_ops_from_xla(prune_graph: ops.Graph): ...
