import threading
from tensorflow.core.protobuf import config_pb2 as config_pb2
from tensorflow.core.util import event_pb2 as event_pb2
from tensorflow.python.framework import dtypes as dtypes, errors as errors, ops as ops
from tensorflow.python.ops import array_ops as array_ops
from tensorflow.python.tpu.ops import tpu_ops as tpu_ops
from tensorflow.python.training import session_run_hook as session_run_hook, training_util as training_util
from typing import Any

class CoordinatorResetError(errors.AbortedError):
    def __init__(self) -> None: ...

class WorkerHeartbeatManager:
    def __init__(self, session, devices, heartbeat_ops, request_placeholder) -> None: ...
    @staticmethod
    def from_devices(session, devices): ...
    def num_workers(self): ...
    def configure(self, message) -> None: ...
    def ping(self, request: Any | None = ..., timeout_in_ms: int = ...): ...
    def lame_workers(self): ...
    def shutdown(self, wait_time_in_ms: int = ..., exit_code: int = ...) -> None: ...

def all_worker_devices(session): ...

class WatchdogManager(threading.Thread):
    ping_interval: Any
    shutdown_timeout: Any
    daemon: bool
    def __init__(self, session, devices: Any | None = ..., ping_interval: int = ..., shutdown_timeout=...) -> None: ...
    def configure_and_run(self) -> None: ...
    def stop(self) -> None: ...
    def __enter__(self) -> None: ...
    def __exit__(self, exc_type, exc_val, exc_tb) -> None: ...
    def run(self) -> None: ...

def start_worker_watchdog(session, devices: Any | None = ..., ping_interval: int = ..., shutdown_timeout: int = ...) -> None: ...
def stop_worker_watchdog() -> None: ...

class GracefulShutdownHook(session_run_hook.SessionRunHook):
    def __init__(self, checkpoint_prefix, saver: Any | None = ..., on_shutdown_hooks: Any | None = ...) -> None: ...
    def after_create_session(self, training_session, coord) -> None: ...
    def saver(self): ...
    def after_run(self, run_context, run_values) -> None: ...

class ResetComputation:
    def __init__(self) -> None: ...
    def __call__(self, run_context, all_workers, lame_workers) -> None: ...

class ShutdownLameWorkers:
    def __init__(self) -> None: ...
    def __call__(self, run_context, all_workers, lame_workers) -> None: ...

class ShutdownAllWorkers:
    def __init__(self) -> None: ...
    def __call__(self, run_context, all_workers, lame_workers) -> None: ...
