import enum
from tensorflow.python.feature_column import feature_column_lib as fc_lib
from tensorflow.python.framework import dtypes as dtypes, ops as ops
from tensorflow.python.ops import array_ops as array_ops, embedding_ops as embedding_ops, init_ops as init_ops, math_ops as math_ops, sparse_ops as sparse_ops, variable_scope as variable_scope
from tensorflow.python.tpu import tpu as tpu
from tensorflow.python.tpu.feature_column import _TPUBaseEmbeddingColumn
from tensorflow.python.util.tf_export import tf_export as tf_export
from typing import Any

class EmbeddingDevice(enum.Enum):
    CPU: int
    TPU_TENSOR_CORE: int
    TPU_EMBEDDING_CORE: int

def embedding_column_v2(categorical_column, dimension, combiner: str = ..., initializer: Any | None = ..., max_sequence_length: int = ..., learning_rate_fn: Any | None = ..., embedding_lookup_device: Any | None = ..., tensor_core_shape: Any | None = ..., use_safe_embedding_lookup: bool = ...): ...
def shared_embedding_columns_v2(categorical_columns, dimension, combiner: str = ..., initializer: Any | None = ..., shared_embedding_collection_name: Any | None = ..., max_sequence_lengths: Any | None = ..., learning_rate_fn: Any | None = ..., embedding_lookup_device: Any | None = ..., tensor_core_shape: Any | None = ..., use_safe_embedding_lookup: bool = ...): ...

class _TPUEmbeddingColumnV2(_TPUBaseEmbeddingColumn, fc_lib.EmbeddingColumn):
    def __new__(cls, categorical_column, dimension, combiner: str = ..., initializer: Any | None = ..., max_sequence_length: int = ..., learning_rate_fn: Any | None = ..., use_safe_embedding_lookup: bool = ..., bypass_scope_validation: bool = ...): ...
    def __getnewargs__(self): ...
    def __deepcopy__(self, memo): ...
    def __init__(self, categorical_column, dimension, combiner: str = ..., initializer: Any | None = ..., max_sequence_length: int = ..., learning_rate_fn: Any | None = ..., use_safe_embedding_lookup: bool = ..., bypass_scope_validation: bool = ...) -> None: ...
    def get_combiner(self): ...
    def get_embedding_table_size(self): ...
    def get_feature_key_name(self): ...
    def get_weight_key_name(self): ...
    def get_embedding_var_name(self): ...
    def get_initializer(self): ...
    def is_categorical_column_weighted(self): ...
    def create_state(self, state_manager): ...
    def get_dense_tensor(self, transformation_cache, state_manager): ...
    def get_sequence_dense_tensor(self, transformation_cache, state_manager): ...

class _TPUSharedEmbeddingColumnV2(_TPUBaseEmbeddingColumn, fc_lib.SharedEmbeddingColumn):
    def __new__(cls, categorical_column, shared_embedding_column_creator, combiner: str = ..., initializer: Any | None = ..., shared_embedding_collection_name: Any | None = ..., max_sequence_length: int = ..., learning_rate_fn: Any | None = ..., use_safe_embedding_lookup: bool = ...): ...
    def __getnewargs__(self): ...
    def __deepcopy__(self, memo): ...
    def __init__(self, categorical_column, shared_embedding_column_creator, combiner: str = ..., initializer: Any | None = ..., shared_embedding_collection_name: Any | None = ..., max_sequence_length: int = ..., learning_rate_fn: Any | None = ..., use_safe_embedding_lookup: bool = ...) -> None: ...
    def get_combiner(self): ...
    def get_embedding_table_size(self): ...
    def get_feature_key_name(self): ...
    def get_weight_key_name(self): ...
    def get_embedding_var_name(self): ...
    def get_initializer(self): ...
    def is_categorical_column_weighted(self): ...
    def get_sequence_dense_tensor(self, transformation_cache, state_manager): ...

def split_sequence_columns_v2(feature_columns): ...
def sparse_embedding_aggregate_slice(params, values_and_values_mask, combiner: str = ..., name: str = ...): ...
def pad_sparse_embedding_lookup_indices(sparse_indices, padded_size): ...

class _TPUDeviceSpecificEmbeddingColumnV2(_TPUEmbeddingColumnV2):
    def __new__(cls, *args, **kwargs): ...
    def __init__(self, *args, **kwargs) -> None: ...
    def __deepcopy__(self, memo): ...
    def create_state(self, state_manager): ...
    def get_dense_tensor(self, transformation_cache, state_manager): ...

class _TPUSharedDeviceSpecificEmbeddingColumnV2(_TPUSharedEmbeddingColumnV2):
    def __new__(cls, *args, **kwargs): ...
    def __init__(self, *args, **kwargs) -> None: ...
    def __deepcopy__(self, memo): ...
