from tensorflow.python.feature_column import feature_column as fc
from tensorflow.python.framework import ops as ops
from tensorflow.python.ops import array_ops as array_ops, init_ops as init_ops, variable_scope as variable_scope
from tensorflow.python.tpu import tpu as tpu, tpu_function as tpu_function
from typing import Any

def embedding_column(categorical_column, dimension, combiner: str = ..., initializer: Any | None = ..., max_sequence_length: int = ..., learning_rate_fn: Any | None = ..., use_safe_embedding_lookup: bool = ...): ...
def shared_embedding_columns(categorical_columns, dimension, combiner: str = ..., initializer: Any | None = ..., shared_embedding_collection_name: Any | None = ..., max_sequence_lengths: Any | None = ..., learning_rate_fn: Any | None = ..., use_safe_embedding_lookup: bool = ...): ...

class _TPUBaseEmbeddingColumn:
    def __init__(self, categorical_column, max_sequence_length: int = ..., learning_rate_fn: Any | None = ...) -> None: ...
    def get_combiner(self) -> None: ...
    def get_embedding_table_size(self) -> None: ...
    def get_feature_key_name(self) -> None: ...
    def get_weight_key_name(self) -> None: ...
    def get_embedding_var_name(self) -> None: ...
    def get_initializer(self) -> None: ...
    def is_categorical_column_weighted(self) -> None: ...
    def is_sequence_column(self): ...
    def get_max_sequence_length(self): ...
    def get_learning_rate_fn(self): ...
    def get_sequence_length_feature_key_name(self): ...

class _TPUEmbeddingColumn(_TPUBaseEmbeddingColumn, fc._EmbeddingColumn):
    def __new__(cls, categorical_column, dimension, combiner: str = ..., layer_creator: Any | None = ..., ckpt_to_load_from: Any | None = ..., tensor_name_in_ckpt: Any | None = ..., max_norm: Any | None = ..., trainable: bool = ..., max_sequence_length: int = ..., learning_rate_fn: Any | None = ..., use_safe_embedding_lookup: bool = ..., bypass_scope_validation: bool = ...): ...
    def __init__(self, categorical_column, dimension, combiner: str = ..., layer_creator: Any | None = ..., ckpt_to_load_from: Any | None = ..., tensor_name_in_ckpt: Any | None = ..., max_norm: Any | None = ..., trainable: bool = ..., max_sequence_length: int = ..., learning_rate_fn: Any | None = ..., use_safe_embedding_lookup: bool = ..., bypass_scope_validation: bool = ...) -> None: ...
    def get_combiner(self): ...
    def get_embedding_table_size(self): ...
    def get_feature_key_name(self): ...
    def get_weight_key_name(self): ...
    def get_embedding_var_name(self): ...
    def get_initializer(self): ...
    def is_categorical_column_weighted(self): ...

class _TPUSharedEmbeddingColumn(_TPUBaseEmbeddingColumn, fc._SharedEmbeddingColumn):
    def __new__(cls, categorical_column, dimension, combiner: str = ..., initializer: Any | None = ..., shared_embedding_collection_name: Any | None = ..., ckpt_to_load_from: Any | None = ..., tensor_name_in_ckpt: Any | None = ..., max_norm: Any | None = ..., trainable: bool = ..., max_sequence_length: int = ..., learning_rate_fn: Any | None = ..., use_safe_embedding_lookup: bool = ...): ...
    def __init__(self, categorical_column, dimension, combiner: str = ..., initializer: Any | None = ..., shared_embedding_collection_name: Any | None = ..., ckpt_to_load_from: Any | None = ..., tensor_name_in_ckpt: Any | None = ..., max_norm: Any | None = ..., trainable: bool = ..., max_sequence_length: int = ..., learning_rate_fn: Any | None = ..., use_safe_embedding_lookup: bool = ...) -> None: ...
    def get_combiner(self): ...
    def get_embedding_table_size(self): ...
    def get_feature_key_name(self): ...
    def get_weight_key_name(self): ...
    def get_embedding_var_name(self): ...
    def get_initializer(self): ...
    def is_categorical_column_weighted(self): ...

def get_sequence_length_feature_key_name_from_feature_key_name(feature_name): ...
def split_sequence_columns(feature_columns): ...
