from tensorflow.core.protobuf import struct_pb2 as struct_pb2
from tensorflow.python.data.ops import dataset_ops as dataset_ops, iterator_ops as iterator_ops, optional_ops as optional_ops
from tensorflow.python.distribute import values as values
from tensorflow.python.framework import dtypes as dtypes, extension_type as extension_type, indexed_slices as indexed_slices, sparse_tensor as sparse_tensor, tensor_shape as tensor_shape, tensor_spec as tensor_spec, tensor_util as tensor_util, type_spec as type_spec
from tensorflow.python.ops import resource_variable_ops as resource_variable_ops, tensor_array_ops as tensor_array_ops
from tensorflow.python.ops.ragged import ragged_tensor as ragged_tensor, row_partition as row_partition
from tensorflow.python.util import compat as compat, nest as nest
from tensorflow.python.util.compat import collections_abc as collections_abc
from tensorflow.python.util.tf_export import tf_export as tf_export
from typing import Any

class NotEncodableError(Exception): ...

class StructureCoder:
    @classmethod
    def register_codec(cls, x) -> None: ...
    def encode_structure(self, nested_structure): ...
    def can_encode(self, nested_structure): ...
    def decode_proto(self, proto): ...

class _ListCodec:
    def can_encode(self, pyobj): ...
    def do_encode(self, list_value, encode_fn): ...
    def can_decode(self, value): ...
    def do_decode(self, value, decode_fn): ...

class _TupleCodec:
    def can_encode(self, pyobj): ...
    def do_encode(self, tuple_value, encode_fn): ...
    def can_decode(self, value): ...
    def do_decode(self, value, decode_fn): ...

class _DictCodec:
    def can_encode(self, pyobj): ...
    def do_encode(self, dict_value, encode_fn): ...
    def can_decode(self, value): ...
    def do_decode(self, value, decode_fn): ...

class _NamedTupleCodec:
    def can_encode(self, pyobj): ...
    def do_encode(self, named_tuple_value, encode_fn): ...
    def can_decode(self, value): ...
    def do_decode(self, value, decode_fn): ...

class _Float64Codec:
    def can_encode(self, pyobj): ...
    def do_encode(self, float64_value, encode_fn): ...
    def can_decode(self, value): ...
    def do_decode(self, value, decode_fn): ...

class _Int64Codec:
    def can_encode(self, pyobj): ...
    def do_encode(self, int_value, encode_fn): ...
    def can_decode(self, value): ...
    def do_decode(self, value, decode_fn): ...

class _StringCodec:
    def can_encode(self, pyobj): ...
    def do_encode(self, string_value, encode_fn): ...
    def can_decode(self, value): ...
    def do_decode(self, value, decode_fn): ...

class _NoneCodec:
    def can_encode(self, pyobj): ...
    def do_encode(self, none_value, encode_fn): ...
    def can_decode(self, value): ...
    def do_decode(self, value, decode_fn) -> None: ...

class _BoolCodec:
    def can_encode(self, pyobj): ...
    def do_encode(self, bool_value, encode_fn): ...
    def can_decode(self, value): ...
    def do_decode(self, value, decode_fn): ...

class _TensorShapeCodec:
    def can_encode(self, pyobj): ...
    def do_encode(self, tensor_shape_value, encode_fn): ...
    def can_decode(self, value): ...
    def do_decode(self, value, decode_fn): ...

class _TensorTypeCodec:
    def can_encode(self, pyobj): ...
    def do_encode(self, tensor_dtype_value, encode_fn): ...
    def can_decode(self, value): ...
    def do_decode(self, value, decode_fn): ...

class _TensorSpecCodec:
    def can_encode(self, pyobj): ...
    def do_encode(self, tensor_spec_value, encode_fn): ...
    def can_decode(self, value): ...
    def do_decode(self, value, decode_fn): ...

class _BoundedTensorSpecCodec:
    def can_encode(self, pyobj): ...
    def do_encode(self, bounded_tensor_spec_value, encode_fn): ...
    def can_decode(self, value): ...
    def do_decode(self, value, decode_fn): ...

class _TypeSpecCodec:
    TYPE_SPEC_CLASS_FROM_PROTO: Any
    TYPE_SPEC_CLASS_TO_PROTO: Any
    def can_encode(self, pyobj): ...
    def do_encode(self, type_spec_value, encode_fn): ...
    def can_decode(self, value): ...
    def do_decode(self, value, decode_fn): ...
