import enum
from tensorflow.core.framework import attr_value_pb2 as attr_value_pb2, variable_pb2 as variable_pb2
from tensorflow.python import pywrap_tensorflow as pywrap_tensorflow
from tensorflow.python.eager import context as context
from tensorflow.python.framework import dtypes as dtypes, ops as ops, tensor_shape as tensor_shape
from tensorflow.python.ops import array_ops as array_ops, control_flow_ops as control_flow_ops, gen_array_ops as gen_array_ops, gen_math_ops as gen_math_ops, gen_state_ops as gen_state_ops, math_ops as math_ops, state_ops as state_ops
from tensorflow.python.types import core as core
from tensorflow.python.util import compat as compat, object_identity as object_identity, tf_should_use as tf_should_use, traceback_utils as traceback_utils
from tensorflow.python.util.deprecation import deprecated as deprecated, deprecated_args as deprecated_args
from tensorflow.python.util.tf_export import tf_export as tf_export
from typing import Any

def default_variable_creator(_, **kwds) -> None: ...
def default_variable_creator_v2(_, **kwds) -> None: ...

class VariableSynchronization(enum.Enum):
    AUTO: int
    NONE: int
    ON_WRITE: int
    ON_READ: int

class VariableAggregationV2(enum.Enum):
    NONE: int
    SUM: int
    MEAN: int
    ONLY_FIRST_REPLICA: int
    def __hash__(self): ...
    def __eq__(self, other): ...

class VariableAggregation(enum.Enum):
    NONE: int
    SUM: int
    MEAN: int
    ONLY_FIRST_REPLICA: int
    ONLY_FIRST_TOWER: int
    def __hash__(self): ...

def validate_synchronization_aggregation_trainable(synchronization, aggregation, trainable, name): ...

class VariableMetaclass(type):
    def __call__(cls, *args, **kwargs): ...

class Variable:
    def __init__(self, initial_value: Any | None = ..., trainable: Any | None = ..., validate_shape: bool = ..., caching_device: Any | None = ..., name: Any | None = ..., variable_def: Any | None = ..., dtype: Any | None = ..., import_scope: Any | None = ..., constraint: Any | None = ..., synchronization=..., aggregation=..., shape: Any | None = ...) -> None: ...
    def value(self) -> None: ...
    def read_value(self) -> None: ...
    def set_shape(self, shape) -> None: ...
    @property
    def trainable(self) -> None: ...
    @property
    def synchronization(self) -> None: ...
    @property
    def aggregation(self) -> None: ...
    def eval(self, session: Any | None = ...) -> None: ...
    def initialized_value(self): ...
    @property
    def initial_value(self) -> None: ...
    @property
    def constraint(self) -> None: ...
    def assign(self, value, use_locking: bool = ..., name: Any | None = ..., read_value: bool = ...) -> None: ...
    def assign_add(self, delta, use_locking: bool = ..., name: Any | None = ..., read_value: bool = ...) -> None: ...
    def assign_sub(self, delta, use_locking: bool = ..., name: Any | None = ..., read_value: bool = ...) -> None: ...
    def scatter_sub(self, sparse_delta, use_locking: bool = ..., name: Any | None = ...) -> None: ...
    def scatter_add(self, sparse_delta, use_locking: bool = ..., name: Any | None = ...) -> None: ...
    def scatter_max(self, sparse_delta, use_locking: bool = ..., name: Any | None = ...) -> None: ...
    def scatter_min(self, sparse_delta, use_locking: bool = ..., name: Any | None = ...) -> None: ...
    def scatter_mul(self, sparse_delta, use_locking: bool = ..., name: Any | None = ...) -> None: ...
    def scatter_div(self, sparse_delta, use_locking: bool = ..., name: Any | None = ...) -> None: ...
    def scatter_update(self, sparse_delta, use_locking: bool = ..., name: Any | None = ...) -> None: ...
    def batch_scatter_update(self, sparse_delta, use_locking: bool = ..., name: Any | None = ...) -> None: ...
    def scatter_nd_sub(self, indices, updates, name: Any | None = ...) -> None: ...
    def scatter_nd_add(self, indices, updates, name: Any | None = ...) -> None: ...
    def scatter_nd_update(self, indices, updates, name: Any | None = ...) -> None: ...
    def sparse_read(self, indices, name: Any | None = ...) -> None: ...
    def gather_nd(self, indices, name: Any | None = ...) -> None: ...
    def count_up_to(self, limit) -> None: ...
    def load(self, value, session: Any | None = ...) -> None: ...
    def __hash__(self): ...
    def __eq__(self, other): ...
    def __ne__(self, other): ...
    def __iter__(self): ...
    __array_priority__: int
    @property
    def name(self) -> None: ...
    @property
    def initializer(self) -> None: ...
    @property
    def device(self) -> None: ...
    @property
    def dtype(self) -> None: ...
    @property
    def op(self) -> None: ...
    @property
    def graph(self) -> None: ...
    @property
    def shape(self) -> None: ...
    def get_shape(self): ...
    def to_proto(self, export_scope: Any | None = ...) -> None: ...
    @staticmethod
    def from_proto(variable_def, import_scope: Any | None = ...): ...
    def experimental_ref(self): ...
    def ref(self): ...
    class SaveSliceInfo:
        full_name: Any
        full_shape: Any
        var_offset: Any
        var_shape: Any
        def __init__(self, full_name: Any | None = ..., full_shape: Any | None = ..., var_offset: Any | None = ..., var_shape: Any | None = ..., save_slice_info_def: Any | None = ..., import_scope: Any | None = ...) -> None: ...
        @property
        def spec(self): ...
        def to_proto(self, export_scope: Any | None = ...): ...

class VariableV1(Variable):
    def __init__(self, initial_value: Any | None = ..., trainable: Any | None = ..., collections: Any | None = ..., validate_shape: bool = ..., caching_device: Any | None = ..., name: Any | None = ..., variable_def: Any | None = ..., dtype: Any | None = ..., expected_shape: Any | None = ..., import_scope: Any | None = ..., constraint: Any | None = ..., use_resource: Any | None = ..., synchronization=..., aggregation=..., shape: Any | None = ...) -> None: ...
    SaveSliceInfo: Any

class RefVariable(VariableV1, core.Tensor):
    def __init__(self, initial_value: Any | None = ..., trainable: Any | None = ..., collections: Any | None = ..., validate_shape: bool = ..., caching_device: Any | None = ..., name: Any | None = ..., variable_def: Any | None = ..., dtype: Any | None = ..., expected_shape: Any | None = ..., import_scope: Any | None = ..., constraint: Any | None = ..., synchronization: Any | None = ..., aggregation: Any | None = ..., shape: Any | None = ...) -> None: ...
    def value(self): ...
    def read_value(self): ...
    def set_shape(self, shape) -> None: ...
    @property
    def trainable(self): ...
    @property
    def synchronization(self): ...
    @property
    def aggregation(self): ...
    def eval(self, session: Any | None = ...): ...
    @property
    def initial_value(self): ...
    @property
    def constraint(self): ...
    def assign(self, value, use_locking: bool = ..., name: Any | None = ..., read_value: bool = ...): ...
    def assign_add(self, delta, use_locking: bool = ..., name: Any | None = ..., read_value: bool = ...): ...
    def assign_sub(self, delta, use_locking: bool = ..., name: Any | None = ..., read_value: bool = ...): ...
    def scatter_sub(self, sparse_delta, use_locking: bool = ..., name: Any | None = ...): ...
    def scatter_add(self, sparse_delta, use_locking: bool = ..., name: Any | None = ...): ...
    def scatter_max(self, sparse_delta, use_locking: bool = ..., name: Any | None = ...): ...
    def scatter_min(self, sparse_delta, use_locking: bool = ..., name: Any | None = ...): ...
    def scatter_mul(self, sparse_delta, use_locking: bool = ..., name: Any | None = ...): ...
    def scatter_div(self, sparse_delta, use_locking: bool = ..., name: Any | None = ...): ...
    def scatter_update(self, sparse_delta, use_locking: bool = ..., name: Any | None = ...): ...
    def batch_scatter_update(self, sparse_delta, use_locking: bool = ..., name: Any | None = ...): ...
    def scatter_nd_sub(self, indices, updates, name: Any | None = ...): ...
    def scatter_nd_add(self, indices, updates, name: Any | None = ...): ...
    def scatter_nd_update(self, indices, updates, name: Any | None = ...): ...
    def scatter_nd_max(self, indices, updates, name: Any | None = ...): ...
    def scatter_nd_min(self, indices, updates, name: Any | None = ...): ...
    def count_up_to(self, limit): ...
    __array_priority__: int
    @property
    def name(self): ...
    @property
    def initializer(self): ...
    @property
    def device(self): ...
    @property
    def dtype(self): ...
    @property
    def op(self): ...
    @property
    def graph(self): ...
    @property
    def shape(self): ...
    def to_proto(self, export_scope: Any | None = ...): ...
    def __iadd__(self, other): ...
    def __isub__(self, other): ...
    def __imul__(self, other): ...
    def __idiv__(self, other): ...
    def __itruediv__(self, other): ...
    def __irealdiv__(self, other): ...
    def __ipow__(self, other): ...

class PartitionedVariable:
    def __init__(self, name, shape, dtype, variable_list, partitions): ...
    def __iter__(self): ...
    def __len__(self): ...
    def as_tensor(self): ...
    @property
    def name(self): ...
    @property
    def dtype(self): ...
    @property
    def shape(self): ...
    def get_shape(self): ...
    def assign(self, value, use_locking: bool = ..., name: Any | None = ..., read_value: bool = ...): ...
    def assign_add(self, value, use_locking: bool = ..., name: Any | None = ..., read_value: bool = ...): ...
    def assign_sub(self, value, use_locking: bool = ..., name: Any | None = ..., read_value: bool = ...): ...

def global_variables(scope: Any | None = ...): ...
def all_variables(): ...
def local_variables(scope: Any | None = ...): ...
def model_variables(scope: Any | None = ...): ...
def trainable_variables(scope: Any | None = ...): ...
def moving_average_variables(scope: Any | None = ...): ...
def variables_initializer(var_list, name: str = ...): ...
def initialize_variables(var_list, name: str = ...): ...
def global_variables_initializer(): ...
def initialize_all_variables(): ...
def local_variables_initializer(): ...
def initialize_local_variables(): ...
def is_variable_initialized(variable): ...
def assert_variables_initialized(var_list: Any | None = ...): ...
def report_uninitialized_variables(var_list: Any | None = ..., name: str = ...): ...
