import enum
import threading
from tensorflow.python.types import core
from typing import Any

class _PartitionInfo:
    def __init__(self, full_shape, var_offset) -> None: ...
    @property
    def full_shape(self): ...
    @property
    def var_offset(self): ...
    def single_offset(self, shape): ...
    def single_slice_dim(self, shape): ...

class _ReuseMode(enum.Enum):
    AUTO_REUSE: int

VariableSynchronization: Any
VariableAggregation: Any
AUTO_REUSE: Any

class _VariableStore:
    def __init__(self) -> None: ...
    def get_variable(self, name, shape: Any | None = ..., dtype=..., initializer: Any | None = ..., regularizer: Any | None = ..., reuse: Any | None = ..., trainable: Any | None = ..., collections: Any | None = ..., caching_device: Any | None = ..., partitioner: Any | None = ..., validate_shape: bool = ..., use_resource: Any | None = ..., custom_getter: Any | None = ..., constraint: Any | None = ..., synchronization=..., aggregation=...): ...

class _LazyEvalTensor(core.Tensor):
    def __init__(self, thunk) -> None: ...

def no_regularizer(_) -> None: ...

class VariableScope:
    def __init__(self, reuse, name: str = ..., initializer: Any | None = ..., regularizer: Any | None = ..., caching_device: Any | None = ..., partitioner: Any | None = ..., custom_getter: Any | None = ..., name_scope: str = ..., dtype=..., use_resource: Any | None = ..., constraint: Any | None = ...) -> None: ...
    @property
    def name(self): ...
    @property
    def original_name_scope(self): ...
    @property
    def reuse(self): ...
    @property
    def initializer(self): ...
    @property
    def dtype(self): ...
    @property
    def use_resource(self): ...
    @property
    def regularizer(self): ...
    @property
    def caching_device(self): ...
    @property
    def partitioner(self): ...
    @property
    def custom_getter(self): ...
    @property
    def constraint(self): ...
    def reuse_variables(self) -> None: ...
    def set_initializer(self, initializer) -> None: ...
    def set_dtype(self, dtype) -> None: ...
    def set_use_resource(self, use_resource) -> None: ...
    def set_regularizer(self, regularizer) -> None: ...
    def set_caching_device(self, caching_device) -> None: ...
    def set_partitioner(self, partitioner) -> None: ...
    def set_custom_getter(self, custom_getter) -> None: ...
    def get_collection(self, name): ...
    def trainable_variables(self): ...
    def global_variables(self): ...
    def local_variables(self): ...
    def get_variable(self, var_store, name, shape: Any | None = ..., dtype: Any | None = ..., initializer: Any | None = ..., regularizer: Any | None = ..., reuse: Any | None = ..., trainable: Any | None = ..., collections: Any | None = ..., caching_device: Any | None = ..., partitioner: Any | None = ..., validate_shape: bool = ..., use_resource: Any | None = ..., custom_getter: Any | None = ..., constraint: Any | None = ..., synchronization=..., aggregation=...): ...

class _VariableScopeStore(threading.local):
    current_scope: Any
    variable_scopes_count: Any
    def __init__(self) -> None: ...
    def open_variable_scope(self, scope_name) -> None: ...
    def close_variable_subscopes(self, scope_name) -> None: ...
    def variable_scope_count(self, scope_name): ...

def get_variable_scope(): ...

class EagerVariableStore:
    def __init__(self, store: Any | None = ...) -> None: ...
    def as_default(self): ...
    def variables(self): ...
    def trainable_variables(self): ...
    def non_trainable_variables(self): ...
    def copy(self): ...

def get_variable(name, shape: Any | None = ..., dtype: Any | None = ..., initializer: Any | None = ..., regularizer: Any | None = ..., trainable: Any | None = ..., collections: Any | None = ..., caching_device: Any | None = ..., partitioner: Any | None = ..., validate_shape: bool = ..., use_resource: Any | None = ..., custom_getter: Any | None = ..., constraint: Any | None = ..., synchronization=..., aggregation=...): ...
def get_local_variable(name, shape: Any | None = ..., dtype: Any | None = ..., initializer: Any | None = ..., regularizer: Any | None = ..., trainable: bool = ..., collections: Any | None = ..., caching_device: Any | None = ..., partitioner: Any | None = ..., validate_shape: bool = ..., use_resource: Any | None = ..., custom_getter: Any | None = ..., constraint: Any | None = ..., synchronization=..., aggregation=...): ...

class _pure_variable_scope:
    def __init__(self, name_or_scope, reuse: Any | None = ..., initializer: Any | None = ..., regularizer: Any | None = ..., caching_device: Any | None = ..., partitioner: Any | None = ..., custom_getter: Any | None = ..., old_name_scope: Any | None = ..., dtype=..., use_resource: Any | None = ..., constraint: Any | None = ...) -> None: ...
    def __enter__(self): ...
    def __exit__(self, type_arg, value_arg, traceback_arg) -> None: ...

class variable_scope:
    def __init__(self, name_or_scope, default_name: Any | None = ..., values: Any | None = ..., initializer: Any | None = ..., regularizer: Any | None = ..., caching_device: Any | None = ..., partitioner: Any | None = ..., custom_getter: Any | None = ..., reuse: Any | None = ..., dtype: Any | None = ..., use_resource: Any | None = ..., constraint: Any | None = ..., auxiliary_name_scope: bool = ...) -> None: ...
    def __enter__(self): ...
    def __exit__(self, type_arg, value_arg, traceback_arg) -> None: ...

def variable_op_scope(values, name_or_scope, default_name: Any | None = ..., initializer: Any | None = ..., regularizer: Any | None = ..., caching_device: Any | None = ..., partitioner: Any | None = ..., custom_getter: Any | None = ..., reuse: Any | None = ..., dtype: Any | None = ..., use_resource: Any | None = ..., constraint: Any | None = ...) -> None: ...
