from tensorflow.python.eager import context as context
from tensorflow.python.framework import constant_op as constant_op, dtypes as dtypes, errors_impl as errors_impl, ops as ops, tensor_shape as tensor_shape, tensor_spec as tensor_spec, tensor_util as tensor_util, type_spec as type_spec
from tensorflow.python.ops import array_ops as array_ops, control_flow_util as control_flow_util, gen_control_flow_ops as gen_control_flow_ops, gen_data_flow_ops as gen_data_flow_ops, list_ops as list_ops, math_ops as math_ops
from tensorflow.python.util import tf_should_use as tf_should_use
from tensorflow.python.util.tf_export import tf_export as tf_export
from typing import Any

class _GraphTensorArray:
    def __init__(self, dtype, size: Any | None = ..., dynamic_size: Any | None = ..., clear_after_read: Any | None = ..., tensor_array_name: Any | None = ..., handle: Any | None = ..., flow: Any | None = ..., infer_shape: bool = ..., element_shape: Any | None = ..., colocate_with_first_write_call: bool = ..., name: Any | None = ...): ...
    @property
    def flow(self): ...
    @property
    def dtype(self): ...
    @property
    def handle(self): ...
    @property
    def element_shape(self): ...
    def identity(self): ...
    def grad(self, source, flow: Any | None = ..., name: Any | None = ...): ...
    def read(self, index, name: Any | None = ...): ...
    def write(self, index, value, name: Any | None = ...): ...
    def stack(self, name: Any | None = ...): ...
    def gather(self, indices, name: Any | None = ...): ...
    def concat(self, name: Any | None = ...): ...
    def unstack(self, value, name: Any | None = ...): ...
    def scatter(self, indices, value, name: Any | None = ...): ...
    def split(self, value, lengths, name: Any | None = ...): ...
    def size(self, name: Any | None = ...): ...
    def close(self, name: Any | None = ...): ...

class _GraphTensorArrayV2:
    def __init__(self, dtype, size: Any | None = ..., dynamic_size: Any | None = ..., clear_after_read: Any | None = ..., tensor_array_name: Any | None = ..., handle: Any | None = ..., flow: Any | None = ..., infer_shape: bool = ..., element_shape: Any | None = ..., colocate_with_first_write_call: bool = ..., name: Any | None = ...) -> None: ...
    @property
    def flow(self): ...
    @property
    def dtype(self): ...
    @property
    def element_shape(self): ...
    @property
    def handle(self) -> None: ...
    def identity(self): ...
    def grad(self, source, flow: Any | None = ..., name: Any | None = ...) -> None: ...
    def read(self, index, name: Any | None = ...): ...
    def write(self, index, value, name: Any | None = ...): ...
    def stack(self, name: Any | None = ...): ...
    def gather(self, indices, name: Any | None = ...): ...
    def concat(self, name: Any | None = ...): ...
    def unstack(self, value, name: Any | None = ...): ...
    def scatter(self, indices, value, name: Any | None = ...): ...
    def split(self, value, lengths, name: Any | None = ...): ...
    def size(self, name: Any | None = ...): ...
    def close(self, name: Any | None = ...): ...

class _EagerTensorArray:
    def __init__(self, dtype, size: Any | None = ..., dynamic_size: Any | None = ..., clear_after_read: Any | None = ..., tensor_array_name: Any | None = ..., handle: Any | None = ..., flow: Any | None = ..., infer_shape: bool = ..., element_shape: Any | None = ..., colocate_with_first_write_call: bool = ..., name: Any | None = ...) -> None: ...
    @property
    def flow(self): ...
    @property
    def dtype(self): ...
    @property
    def handle(self): ...
    @property
    def element_shape(self): ...
    def identity(self): ...
    def grad(self, source, flow: Any | None = ..., name: Any | None = ...) -> None: ...
    def read(self, index, name: Any | None = ...): ...
    def write(self, index, value, name: Any | None = ...): ...
    def stack(self, name: Any | None = ...): ...
    def gather(self, indices, name: Any | None = ...): ...
    def concat(self, name: Any | None = ...): ...
    def unstack(self, value, name: Any | None = ...): ...
    def scatter(self, indices, value, name: Any | None = ...): ...
    def split(self, value, lengths, name: Any | None = ...): ...
    def size(self, name: Any | None = ...): ...
    def close(self, name: Any | None = ...) -> None: ...

class TensorArray:
    def __init__(self, dtype, size: Any | None = ..., dynamic_size: Any | None = ..., clear_after_read: Any | None = ..., tensor_array_name: Any | None = ..., handle: Any | None = ..., flow: Any | None = ..., infer_shape: bool = ..., element_shape: Any | None = ..., colocate_with_first_write_call: bool = ..., name: Any | None = ...) -> None: ...
    @property
    def flow(self): ...
    @property
    def dtype(self): ...
    @property
    def handle(self): ...
    @property
    def element_shape(self): ...
    @property
    def dynamic_size(self): ...
    def identity(self): ...
    def grad(self, source, flow: Any | None = ..., name: Any | None = ...): ...
    def read(self, index, name: Any | None = ...): ...
    def write(self, index, value, name: Any | None = ...): ...
    def stack(self, name: Any | None = ...): ...
    def gather(self, indices, name: Any | None = ...): ...
    def concat(self, name: Any | None = ...): ...
    def unstack(self, value, name: Any | None = ...): ...
    def scatter(self, indices, value, name: Any | None = ...): ...
    def split(self, value, lengths, name: Any | None = ...): ...
    def size(self, name: Any | None = ...): ...
    def close(self, name: Any | None = ...): ...

def build_ta_with_new_flow(old_ta, flow): ...

class TensorArraySpec(type_spec.TypeSpec):
    value_type: Any
    def __init__(self, element_shape: Any | None = ..., dtype=..., dynamic_size: bool = ..., infer_shape: bool = ...) -> None: ...
    def is_compatible_with(self, other): ...
    def most_specific_compatible_type(self, other): ...
    @staticmethod
    def from_value(value): ...
