from tensorflow.python.framework import composite_tensor as composite_tensor, constant_op as constant_op, dtypes as dtypes, ops as ops, tensor_shape as tensor_shape, tensor_spec as tensor_spec, tensor_util as tensor_util, type_spec as type_spec
from tensorflow.python.ops import array_ops as array_ops, check_ops as check_ops, control_flow_ops as control_flow_ops, gen_ragged_math_ops as gen_ragged_math_ops, math_ops as math_ops
from tensorflow.python.ops.ragged import segment_id_ops as segment_id_ops
from typing import Any

class RowPartition(composite_tensor.CompositeTensor):
    def __init__(self, row_splits, row_lengths: Any | None = ..., value_rowids: Any | None = ..., nrows: Any | None = ..., uniform_row_length: Any | None = ..., internal: bool = ...) -> None: ...
    @classmethod
    def from_value_rowids(cls, value_rowids, nrows: Any | None = ..., validate: bool = ..., preferred_dtype: Any | None = ...): ...
    @classmethod
    def from_row_splits(cls, row_splits, validate: bool = ..., preferred_dtype: Any | None = ...): ...
    @classmethod
    def from_row_lengths(cls, row_lengths, validate: bool = ..., preferred_dtype: Any | None = ...): ...
    @classmethod
    def from_row_starts(cls, row_starts, nvals, validate: bool = ..., preferred_dtype: Any | None = ...): ...
    @classmethod
    def from_row_limits(cls, row_limits, validate: bool = ..., preferred_dtype: Any | None = ...): ...
    @classmethod
    def from_uniform_row_length(cls, uniform_row_length, nvals, nrows: Any | None = ..., validate: bool = ..., preferred_dtype: Any | None = ...): ...
    def with_dependencies(self, dependencies): ...
    @property
    def dtype(self): ...
    def row_splits(self): ...
    def value_rowids(self): ...
    def nvals(self, out_type: Any | None = ...): ...
    def nrows(self, out_type: Any | None = ...): ...
    def uniform_row_length(self): ...
    def row_starts(self): ...
    def row_limits(self): ...
    def row_lengths(self): ...
    @property
    def static_nrows(self): ...
    @property
    def static_nvals(self): ...
    @property
    def static_uniform_row_length(self): ...
    def offsets_in_rows(self): ...
    def is_uniform(self): ...
    def with_row_splits_dtype(self, dtype): ...
    def has_precomputed_row_splits(self): ...
    def has_precomputed_row_lengths(self): ...
    def has_precomputed_value_rowids(self): ...
    def has_precomputed_nrows(self): ...
    def with_precomputed_row_splits(self): ...
    def with_precomputed_row_lengths(self): ...
    def with_precomputed_value_rowids(self): ...
    def with_precomputed_nrows(self): ...
    def merge_precomputed_encodings(self, other, validate: bool = ...): ...

class RowPartitionSpec(type_spec.TypeSpec):
    value_type: Any
    def __init__(self, nrows: Any | None = ..., nvals: Any | None = ..., uniform_row_length: Any | None = ..., dtype=...) -> None: ...
    def is_compatible_with(self, other): ...
    @property
    def nrows(self): ...
    @property
    def nvals(self): ...
    @property
    def uniform_row_length(self): ...
    @property
    def dtype(self): ...
    @classmethod
    def from_value(cls, value): ...
