import abc
from tensorflow.python.eager import backprop as backprop, context as context, def_function as def_function
from tensorflow.python.framework import composite_tensor as composite_tensor, dtypes as dtypes, ops as ops, random_seed as random_seed, tensor_shape as tensor_shape, tensor_util as tensor_util, test_util as test_util
from tensorflow.python.module import module as module
from tensorflow.python.ops import array_ops as array_ops, linalg_ops as linalg_ops, math_ops as math_ops, random_ops as random_ops, sort_ops as sort_ops, variables as variables, while_v2 as while_v2
from tensorflow.python.ops.linalg import linear_operator_util as linear_operator_util
from tensorflow.python.platform import test as test
from tensorflow.python.saved_model import nested_structure_coder as nested_structure_coder
from tensorflow.python.util import nest as nest
from typing import Any

class OperatorShapesInfo:
    shape: Any
    def __init__(self, shape, **kwargs) -> None: ...

class CheckTapeSafeSkipOptions:
    DETERMINANT: str
    DIAG_PART: str
    LOG_ABS_DETERMINANT: str
    TRACE: str

class LinearOperatorDerivedClassTest(test.TestCase, metaclass=abc.ABCMeta):
    def assertAC(self, x, y, check_dtype: bool = ...) -> None: ...
    @staticmethod
    def adjoint_options(): ...
    @staticmethod
    def adjoint_arg_options(): ...
    @staticmethod
    def dtypes_to_test(): ...
    @staticmethod
    def use_placeholder_options(): ...
    @staticmethod
    def use_blockwise_arg(): ...
    @staticmethod
    def operator_shapes_infos() -> None: ...
    @abc.abstractmethod
    def operator_and_matrix(self, shapes_info, dtype, use_placeholder, ensure_self_adjoint_and_pd: bool = ...): ...
    @abc.abstractmethod
    def make_rhs(self, operator, adjoint, with_batch: bool = ...): ...
    @abc.abstractmethod
    def make_x(self, operator, adjoint, with_batch: bool = ...): ...
    @staticmethod
    def skip_these_tests(): ...
    def assertRaisesError(self, msg): ...
    def check_tape_safe(self, operator, skip_options: Any | None = ...) -> None: ...

def add_tests(test_cls) -> None: ...

class SquareLinearOperatorDerivedClassTest(LinearOperatorDerivedClassTest, metaclass=abc.ABCMeta):
    @staticmethod
    def operator_shapes_infos(): ...
    def make_rhs(self, operator, adjoint, with_batch: bool = ...): ...
    def make_x(self, operator, adjoint, with_batch: bool = ...): ...

class NonSquareLinearOperatorDerivedClassTest(LinearOperatorDerivedClassTest, metaclass=abc.ABCMeta):
    @staticmethod
    def skip_these_tests(): ...
    @staticmethod
    def operator_shapes_infos(): ...
    def make_rhs(self, operator, adjoint, with_batch: bool = ...) -> None: ...
    def make_x(self, operator, adjoint, with_batch: bool = ...): ...

def random_positive_definite_matrix(shape, dtype, oversampling_ratio: int = ..., force_well_conditioned: bool = ...): ...
def random_tril_matrix(shape, dtype, force_well_conditioned: bool = ..., remove_upper: bool = ...): ...
def random_normal(shape, mean: float = ..., stddev: float = ..., dtype=..., seed: Any | None = ...): ...
def random_uniform(shape, minval: Any | None = ..., maxval: Any | None = ..., dtype=..., seed: Any | None = ...): ...
def random_sign_uniform(shape, minval: Any | None = ..., maxval: Any | None = ..., dtype=..., seed: Any | None = ...): ...
def random_normal_correlated_columns(shape, mean: float = ..., stddev: float = ..., dtype=..., eps: float = ..., seed: Any | None = ...): ...
