from tensorflow.python.ops.linalg import linear_operator
from typing import Any

class BaseLinearOperatorIdentity(linear_operator.LinearOperator): ...

class LinearOperatorIdentity(BaseLinearOperatorIdentity):
    def __init__(self, num_rows, batch_shape: Any | None = ..., dtype: Any | None = ..., is_non_singular: bool = ..., is_self_adjoint: bool = ..., is_positive_definite: bool = ..., is_square: bool = ..., assert_proper_shapes: bool = ..., name: str = ...) -> None: ...
    def add_to_tensor(self, mat, name: str = ...): ...

class LinearOperatorScaledIdentity(BaseLinearOperatorIdentity):
    def __init__(self, num_rows, multiplier, is_non_singular: Any | None = ..., is_self_adjoint: Any | None = ..., is_positive_definite: Any | None = ..., is_square: bool = ..., assert_proper_shapes: bool = ..., name: str = ...) -> None: ...
    def add_to_tensor(self, mat, name: str = ...): ...
    @property
    def multiplier(self): ...
